/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.invoker;

import com.android.ddmlib.Log;
import com.android.tradefed.build.BuildRetrievalError;
import com.android.tradefed.build.ExistingBuildProvider;
import com.android.tradefed.build.IBuildInfo;
import com.android.tradefed.build.IBuildProvider;
import com.android.tradefed.config.IConfiguration;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.invoker.IRescheduler;
import com.android.tradefed.invoker.ITestInvocation;
import com.android.tradefed.invoker.ShardListener;
import com.android.tradefed.invoker.ShardMasterResultForwarder;
import com.android.tradefed.log.ILeveledLogOutput;
import com.android.tradefed.log.LogRegistry;
import com.android.tradefed.result.ITestInvocationListener;
import com.android.tradefed.result.InputStreamSource;
import com.android.tradefed.result.InvocationSummaryHelper;
import com.android.tradefed.result.LogDataType;
import com.android.tradefed.result.ResultForwarder;
import com.android.tradefed.targetprep.BuildError;
import com.android.tradefed.targetprep.ITargetPreparer;
import com.android.tradefed.targetprep.TargetSetupError;
import com.android.tradefed.testtype.IBuildReceiver;
import com.android.tradefed.testtype.IDeviceTest;
import com.android.tradefed.testtype.IRemoteTest;
import com.android.tradefed.testtype.IResumableTest;
import com.android.tradefed.testtype.IShardableTest;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestInvocation
implements ITestInvocation {
    private static final String LOG_TAG = "TestInvocation";
    static final String TRADEFED_LOG_NAME = "host_log";
    static final String DEVICE_LOG_NAME = "device_logcat";
    private ITestDevice mDevice = null;
    private String mStatus = "(not invoked)";

    public String toString() {
        String string = "(none)";
        if (this.mDevice != null) {
            string = this.mDevice.getSerialNumber();
        }
        return String.format("Device %s: %s", string, this.mStatus);
    }

    @Override
    public void invoke(ITestDevice iTestDevice, IConfiguration iConfiguration, IRescheduler iRescheduler) throws DeviceNotAvailableException {
        try {
            this.mDevice = iTestDevice;
            this.mStatus = "fetching build";
            IBuildInfo iBuildInfo = iConfiguration.getBuildProvider().getBuild();
            if (iBuildInfo != null) {
                this.injectBuild(iBuildInfo, iConfiguration.getTests());
                if (this.shardConfig(iConfiguration, iBuildInfo, iRescheduler)) {
                    Log.i((String)LOG_TAG, (String)String.format("Invocation for %s has been sharded, rescheduling", iTestDevice.getSerialNumber()));
                } else {
                    iTestDevice.setRecovery(iConfiguration.getDeviceRecovery());
                    this.performInvocation(iConfiguration, iTestDevice, iBuildInfo, iRescheduler);
                }
            } else {
                this.mStatus = "(no build to test)";
                Log.i((String)LOG_TAG, (String)"No build to test");
            }
        }
        catch (BuildRetrievalError buildRetrievalError) {
            Log.e((String)LOG_TAG, (Throwable)buildRetrievalError);
        }
        catch (IOException iOException) {
            Log.e((String)LOG_TAG, (Throwable)iOException);
        }
    }

    private void injectBuild(IBuildInfo iBuildInfo, List<IRemoteTest> list) {
        for (IRemoteTest iRemoteTest : list) {
            if (!(iRemoteTest instanceof IBuildReceiver)) continue;
            ((IBuildReceiver)((Object)iRemoteTest)).setBuild(iBuildInfo);
        }
    }

    private boolean shardConfig(IConfiguration iConfiguration, IBuildInfo iBuildInfo, IRescheduler iRescheduler) {
        this.mStatus = "sharding";
        ArrayList<IRemoteTest> arrayList = new ArrayList<IRemoteTest>();
        boolean bl = false;
        for (IRemoteTest object : iConfiguration.getTests()) {
            bl |= this.shardTest(arrayList, object);
        }
        if (bl) {
            ShardMasterResultForwarder shardMasterResultForwarder = new ShardMasterResultForwarder(iConfiguration.getTestInvocationListeners(), arrayList.size());
            ShardListener shardListener = new ShardListener(shardMasterResultForwarder);
            iConfiguration.setTestInvocationListener(shardListener);
            shardMasterResultForwarder.invocationStarted(iBuildInfo);
            for (IRemoteTest iRemoteTest : arrayList) {
                Log.i((String)LOG_TAG, (String)String.format("Rescheduling sharded config...", new Object[0]));
                IConfiguration iConfiguration2 = iConfiguration.clone();
                iConfiguration2.setTest(iRemoteTest);
                iConfiguration2.setBuildProvider(new ExistingBuildProvider(iBuildInfo.clone(), iConfiguration.getBuildProvider()));
                iConfiguration2.setTestInvocationListener(new ShardListener(shardMasterResultForwarder));
                iConfiguration2.setLogOutput(iConfiguration.getLogOutput().clone());
                iRescheduler.scheduleConfig(iConfiguration2);
            }
            iConfiguration.getBuildProvider().cleanUp(iBuildInfo);
            return true;
        }
        return false;
    }

    private boolean shardTest(List<IRemoteTest> list, IRemoteTest iRemoteTest) {
        IShardableTest iShardableTest;
        Collection<IRemoteTest> collection;
        boolean bl = false;
        if (iRemoteTest instanceof IShardableTest && (collection = (iShardableTest = (IShardableTest)iRemoteTest).split()) != null) {
            list.addAll(collection);
            bl = true;
        }
        if (!bl) {
            list.add(iRemoteTest);
        }
        return bl;
    }

    private void logStartInvocation(IBuildInfo iBuildInfo, ITestDevice iTestDevice) {
        StringBuilder stringBuilder = new StringBuilder("Starting invocation for target ");
        stringBuilder.append(iBuildInfo.getTestTarget());
        stringBuilder.append(" on build ");
        stringBuilder.append(iBuildInfo.getBuildId());
        for (String string : iBuildInfo.getBuildAttributes().values()) {
            stringBuilder.append(" ");
            stringBuilder.append(string);
        }
        stringBuilder.append(" on device ");
        stringBuilder.append(iTestDevice.getSerialNumber());
        Log.logAndDisplay((Log.LogLevel)Log.LogLevel.INFO, (String)LOG_TAG, (String)stringBuilder.toString());
        this.mStatus = String.format("running %s on build %d", iBuildInfo.getTestTarget(), iBuildInfo.getBuildId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void performInvocation(IConfiguration iConfiguration, ITestDevice iTestDevice, IBuildInfo iBuildInfo, IRescheduler iRescheduler) throws DeviceNotAvailableException, IOException {
        block21: {
            Object v0;
            boolean bl = false;
            long l = System.currentTimeMillis();
            long l2 = -1L;
            this.startInvocation(iConfiguration, iTestDevice, iBuildInfo);
            if (iTestDevice != null) {
                iBuildInfo.addBuildAttribute("device_serial", iTestDevice.getSerialNumber());
            }
            for (ITargetPreparer iTargetPreparer : iConfiguration.getTargetPreparers()) {
                iTargetPreparer.setUp(iTestDevice, iBuildInfo);
            }
            this.runTests(iTestDevice, iBuildInfo, iConfiguration, iRescheduler);
            Object var13_14 = null;
            this.mStatus = "done running tests";
            try {
                this.reportLogs(iTestDevice, iConfiguration.getTestInvocationListeners(), iConfiguration.getLogOutput());
                l2 = System.currentTimeMillis() - l;
                if (!bl) {
                    InvocationSummaryHelper.reportInvocationEnded(iConfiguration.getTestInvocationListeners(), l2);
                }
                v0 = null;
            }
            catch (Throwable throwable) {
                v0 = null;
            }
            Object var15_22 = v0;
            iConfiguration.getBuildProvider().cleanUp(iBuildInfo);
            {
                break block21;
                catch (BuildError buildError) {
                    Object v1;
                    Log.w((String)LOG_TAG, (String)String.format("Build %d failed on device %s", iBuildInfo.getBuildId(), iTestDevice.getSerialNumber()));
                    this.reportFailure(buildError, iConfiguration.getTestInvocationListeners(), iConfiguration.getBuildProvider(), iBuildInfo);
                    Object var13_15 = null;
                    this.mStatus = "done running tests";
                    try {
                        this.reportLogs(iTestDevice, iConfiguration.getTestInvocationListeners(), iConfiguration.getLogOutput());
                        l2 = System.currentTimeMillis() - l;
                        if (!bl) {
                            InvocationSummaryHelper.reportInvocationEnded(iConfiguration.getTestInvocationListeners(), l2);
                        }
                        v1 = null;
                    }
                    catch (Throwable throwable) {
                        v1 = null;
                    }
                    Object var15_23 = v1;
                    iConfiguration.getBuildProvider().cleanUp(iBuildInfo);
                    break block21;
                }
                catch (TargetSetupError targetSetupError) {
                    Object v2;
                    Log.e((String)LOG_TAG, (Throwable)targetSetupError);
                    this.reportFailure(targetSetupError, iConfiguration.getTestInvocationListeners(), iConfiguration.getBuildProvider(), iBuildInfo);
                    Object var13_16 = null;
                    this.mStatus = "done running tests";
                    try {
                        this.reportLogs(iTestDevice, iConfiguration.getTestInvocationListeners(), iConfiguration.getLogOutput());
                        l2 = System.currentTimeMillis() - l;
                        if (!bl) {
                            InvocationSummaryHelper.reportInvocationEnded(iConfiguration.getTestInvocationListeners(), l2);
                        }
                        v2 = null;
                    }
                    catch (Throwable throwable) {
                        v2 = null;
                    }
                    Object var15_24 = v2;
                    iConfiguration.getBuildProvider().cleanUp(iBuildInfo);
                    break block21;
                }
                catch (DeviceNotAvailableException deviceNotAvailableException) {
                    Log.e((String)LOG_TAG, (Throwable)deviceNotAvailableException);
                    bl = this.resume(iConfiguration, iBuildInfo, iRescheduler, System.currentTimeMillis() - l);
                    if (!bl) {
                        this.reportFailure(deviceNotAvailableException, iConfiguration.getTestInvocationListeners(), iConfiguration.getBuildProvider(), iBuildInfo);
                    } else {
                        Log.i((String)LOG_TAG, (String)"Rescheduled failed invocation for resume");
                    }
                    throw deviceNotAvailableException;
                }
                catch (RuntimeException runtimeException) {
                    Log.e((String)LOG_TAG, (String)"Unexpected runtime exception!");
                    Log.e((String)LOG_TAG, (Throwable)runtimeException);
                    this.reportFailure(runtimeException, iConfiguration.getTestInvocationListeners(), iConfiguration.getBuildProvider(), iBuildInfo);
                    throw runtimeException;
                }
            }
            catch (Throwable throwable) {
                Object v3;
                Object var13_17 = null;
                this.mStatus = "done running tests";
                try {
                    this.reportLogs(iTestDevice, iConfiguration.getTestInvocationListeners(), iConfiguration.getLogOutput());
                    l2 = System.currentTimeMillis() - l;
                    if (!bl) {
                        InvocationSummaryHelper.reportInvocationEnded(iConfiguration.getTestInvocationListeners(), l2);
                    }
                    v3 = null;
                }
                catch (Throwable throwable2) {
                    v3 = null;
                }
                Object var15_25 = v3;
                iConfiguration.getBuildProvider().cleanUp(iBuildInfo);
                throw throwable;
            }
        }
    }

    private void startInvocation(IConfiguration iConfiguration, ITestDevice iTestDevice, IBuildInfo iBuildInfo) throws IOException {
        iConfiguration.getLogOutput().init();
        this.getLogRegistry().registerLogger(iConfiguration.getLogOutput());
        this.logStartInvocation(iBuildInfo, iTestDevice);
        for (ITestInvocationListener iTestInvocationListener : iConfiguration.getTestInvocationListeners()) {
            try {
                iTestInvocationListener.invocationStarted(iBuildInfo);
            }
            catch (RuntimeException runtimeException) {
                Log.e((String)LOG_TAG, (Throwable)runtimeException);
            }
        }
    }

    private boolean resume(IConfiguration iConfiguration, IBuildInfo iBuildInfo, IRescheduler iRescheduler, long l) {
        for (IRemoteTest iRemoteTest : iConfiguration.getTests()) {
            IResumableTest iResumableTest;
            if (!(iRemoteTest instanceof IResumableTest) || !(iResumableTest = (IResumableTest)iRemoteTest).isResumable()) continue;
            IConfiguration iConfiguration2 = iConfiguration.clone();
            IBuildInfo iBuildInfo2 = iBuildInfo.clone();
            iConfiguration2.setBuildProvider(new ExistingBuildProvider(iBuildInfo2, iConfiguration.getBuildProvider()));
            iConfiguration2.setTestInvocationListener(new ResumeResultForwarder(iConfiguration.getTestInvocationListeners(), l));
            iConfiguration2.setLogOutput(iConfiguration.getLogOutput().clone());
            boolean bl = iRescheduler.scheduleConfig(iConfiguration2);
            if (!bl) {
                Log.i((String)LOG_TAG, (String)String.format("Cannot reschedule resumed config for %d build. Cleaning up build.", iBuildInfo.getBuildId()));
                iConfiguration2.getBuildProvider().cleanUp(iBuildInfo2);
            }
            return bl;
        }
        return false;
    }

    private void reportFailure(Throwable throwable, List<ITestInvocationListener> list, IBuildProvider iBuildProvider, IBuildInfo iBuildInfo) {
        for (ITestInvocationListener iTestInvocationListener : list) {
            iTestInvocationListener.invocationFailed(throwable);
        }
        if (!(throwable instanceof BuildError)) {
            iBuildProvider.buildNotTested(iBuildInfo);
        }
    }

    private void reportLogs(ITestDevice iTestDevice, List<ITestInvocationListener> list, ILeveledLogOutput iLeveledLogOutput) {
        InputStreamSource inputStreamSource = null;
        InputStreamSource inputStreamSource2 = iLeveledLogOutput.getLog();
        if (iTestDevice != null) {
            inputStreamSource = iTestDevice.getLogcat();
        }
        for (ITestInvocationListener iTestInvocationListener : list) {
            if (inputStreamSource != null) {
                iTestInvocationListener.testLog(DEVICE_LOG_NAME, LogDataType.TEXT, inputStreamSource);
            }
            iTestInvocationListener.testLog(TRADEFED_LOG_NAME, LogDataType.TEXT, inputStreamSource2);
        }
        if (inputStreamSource != null) {
            inputStreamSource.cancel();
        }
        inputStreamSource2.cancel();
        this.getLogRegistry().unregisterLogger();
        iLeveledLogOutput.closeLog();
    }

    LogRegistry getLogRegistry() {
        return LogRegistry.getLogRegistry();
    }

    private void runTests(ITestDevice iTestDevice, IBuildInfo iBuildInfo, IConfiguration iConfiguration, IRescheduler iRescheduler) throws DeviceNotAvailableException {
        List<ITestInvocationListener> list = iConfiguration.getTestInvocationListeners();
        for (IRemoteTest iRemoteTest : iConfiguration.getTests()) {
            if (iRemoteTest instanceof IDeviceTest) {
                ((IDeviceTest)((Object)iRemoteTest)).setDevice(iTestDevice);
            }
            iRemoteTest.run(new ResultForwarder(list));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ResumeResultForwarder
    extends ResultForwarder {
        long mCurrentElapsedTime;

        public ResumeResultForwarder(List<ITestInvocationListener> list, long l) {
            super(list);
            this.mCurrentElapsedTime = l;
        }

        @Override
        public void invocationStarted(IBuildInfo iBuildInfo) {
        }

        @Override
        public void invocationEnded(long l) {
            super.invocationEnded(this.mCurrentElapsedTime + l);
        }
    }
}

