/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.invoker;

import com.android.ddmlib.testrunner.ITestRunListener;
import com.android.ddmlib.testrunner.TestIdentifier;
import com.android.tradefed.build.IBuildInfo;
import com.android.tradefed.result.CollectingTestListener;
import com.android.tradefed.result.ITestInvocationListener;
import com.android.tradefed.result.InputStreamSource;
import com.android.tradefed.result.LogDataType;
import com.android.tradefed.result.TestResult;
import com.android.tradefed.result.TestRunResult;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ShardListener
extends CollectingTestListener {
    private ITestInvocationListener mMasterListener;

    ShardListener(ITestInvocationListener iTestInvocationListener) {
        this.mMasterListener = iTestInvocationListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invocationStarted(IBuildInfo iBuildInfo) {
        super.invocationStarted(iBuildInfo);
        ITestInvocationListener iTestInvocationListener = this.mMasterListener;
        synchronized (iTestInvocationListener) {
            this.mMasterListener.invocationStarted(iBuildInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invocationFailed(Throwable throwable) {
        super.invocationFailed(throwable);
        ITestInvocationListener iTestInvocationListener = this.mMasterListener;
        synchronized (iTestInvocationListener) {
            this.mMasterListener.invocationFailed(throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void testLog(String string, LogDataType logDataType, InputStreamSource inputStreamSource) {
        ITestInvocationListener iTestInvocationListener = this.mMasterListener;
        synchronized (iTestInvocationListener) {
            this.mMasterListener.testLog(string, logDataType, inputStreamSource);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invocationEnded(long l) {
        ITestInvocationListener iTestInvocationListener = this.mMasterListener;
        synchronized (iTestInvocationListener) {
            for (TestRunResult testRunResult : this.getRunResults()) {
                this.mMasterListener.testRunStarted(testRunResult.getName(), testRunResult.getNumTests());
                this.forwardTestResults(testRunResult.getTestResults());
                if (testRunResult.isRunFailure()) {
                    this.mMasterListener.testRunFailed(testRunResult.getRunFailureMessage());
                }
                this.mMasterListener.testRunEnded(testRunResult.getElapsedTime(), testRunResult.getRunMetrics());
            }
            this.mMasterListener.invocationEnded(l);
        }
    }

    private void forwardTestResults(Map<TestIdentifier, TestResult> map) {
        for (Map.Entry<TestIdentifier, TestResult> entry : map.entrySet()) {
            this.mMasterListener.testStarted(entry.getKey());
            if (entry.getValue().getStatus().equals((Object)TestResult.TestStatus.ERROR)) {
                this.mMasterListener.testFailed(ITestRunListener.TestFailure.ERROR, entry.getKey(), entry.getValue().getStackTrace());
            } else if (entry.getValue().getStatus().equals((Object)TestResult.TestStatus.FAILURE)) {
                this.mMasterListener.testFailed(ITestRunListener.TestFailure.FAILURE, entry.getKey(), entry.getValue().getStackTrace());
            }
            this.mMasterListener.testEnded(entry.getKey(), entry.getValue().getMetrics());
        }
    }
}

