/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.device;

import com.android.ddmlib.IShellOutputReceiver;
import com.android.ddmlib.MultiLineReceiver;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.util.IRunUtil;
import com.android.tradefed.util.RunUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class WifiHelper {
    private static final String INTERFACE_KEY = "interface";
    static final String SUCCESS_MARKER = "tHiS-iS-sUcCeSs-MaRkEr";
    private static final String WPA_STATE = "wpa_state";
    private static final long DEFAULT_WIFI_STATE_TIMEOUT = 30000L;
    private final ITestDevice mDevice;

    WifiHelper(ITestDevice iTestDevice) {
        this.mDevice = iTestDevice;
    }

    IRunUtil getRunUtil() {
        return RunUtil.getInstance();
    }

    void enableWifi() throws DeviceNotAvailableException {
        this.mDevice.executeShellCommand("svc wifi enable");
    }

    void disableWifi() throws DeviceNotAvailableException {
        this.mDevice.executeShellCommand("svc wifi disable");
    }

    void disconnectFromNetwork(int n) throws DeviceNotAvailableException {
        this.callWpaCli(String.format("disable_network %d", n));
    }

    boolean waitForWifiState(WifiState ... wifiStateArray) throws DeviceNotAvailableException {
        return this.waitForWifiState(30000L, wifiStateArray);
    }

    boolean waitForWifiState(long l, WifiState ... wifiStateArray) throws DeviceNotAvailableException {
        long l2 = System.currentTimeMillis();
        while (System.currentTimeMillis() < l2 + l) {
            Map<String, String> map = this.getWifiStatus();
            if (map != null) {
                String string = map.get(WPA_STATE);
                for (WifiState wifiState : wifiStateArray) {
                    if (!wifiState.name().equals(string)) continue;
                    return true;
                }
            }
            this.getRunUtil().sleep(this.getPollTime());
        }
        return false;
    }

    long getPollTime() {
        return 1000L;
    }

    Map<String, String> getWifiStatus() throws DeviceNotAvailableException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        WpaCliOutput wpaCliOutput = this.callWpaCli("status");
        if (!wpaCliOutput.isSuccess()) {
            return null;
        }
        for (String string : wpaCliOutput.mOutputLines) {
            String[] stringArray = string.split("=", 2);
            if (stringArray.length != 2) continue;
            hashMap.put(stringArray[0], stringArray[1]);
        }
        if (!hashMap.containsKey(WPA_STATE)) {
            return null;
        }
        hashMap.put(INTERFACE_KEY, wpaCliOutput.mWpaInterface);
        return hashMap;
    }

    void removeNetwork(int n) throws DeviceNotAvailableException {
        this.callWpaCli(String.format("remove_network %d", n));
    }

    Integer addOpenNetwork(String string) throws DeviceNotAvailableException {
        WpaCliOutput wpaCliOutput = this.callWpaCli("add_network");
        if (!wpaCliOutput.isSuccess()) {
            return null;
        }
        Pattern pattern = Pattern.compile("^\\d+$");
        Integer n = null;
        for (String string2 : wpaCliOutput.mOutputLines) {
            Matcher matcher = pattern.matcher(string2);
            if (!matcher.matches()) continue;
            n = Integer.parseInt(string2);
            break;
        }
        if (n == null) {
            return null;
        }
        String string3 = String.format("set_network %d ssid '\"%s\"'", n, string);
        if (!this.callWpaCliChecked(string3)) {
            this.removeNetwork(n);
            return null;
        }
        if (!this.callWpaCliChecked(String.format("set_network %d key_mgmt NONE", n))) {
            this.removeNetwork(n);
            return null;
        }
        return n;
    }

    Integer addWpaPskNetwork(String string, String string2) throws DeviceNotAvailableException {
        Integer n = this.addOpenNetwork(string);
        if (n == null) {
            return null;
        }
        if (!this.callWpaCliChecked(String.format("set_network %d key_mgmt WPA-PSK", n))) {
            this.removeNetwork(n);
            return null;
        }
        String string3 = String.format("set_network %d psk '\"%s\"'", n, string2);
        if (!this.callWpaCliChecked(string3)) {
            this.removeNetwork(n);
            return null;
        }
        return n;
    }

    boolean associateNetwork(int n) throws DeviceNotAvailableException {
        if (!this.callWpaCliChecked("disconnect")) {
            return false;
        }
        if (!this.callWpaCliChecked(String.format("enable_network %d", n))) {
            return false;
        }
        if (!this.callWpaCliChecked(String.format("select_network %d", n))) {
            return false;
        }
        if (!this.callWpaCliChecked("reconnect")) {
            return false;
        }
        return this.callWpaCliChecked("save_config");
    }

    boolean waitForIp(long l) throws DeviceNotAvailableException {
        Map<String, String> map = this.getWifiStatus();
        if (map == null) {
            return false;
        }
        String string = map.get(INTERFACE_KEY);
        if (string == null) {
            return false;
        }
        long l2 = System.currentTimeMillis();
        while (System.currentTimeMillis() < l2 + l) {
            if (this.getIpAddress(string) != null) {
                return true;
            }
            this.getRunUtil().sleep(this.getPollTime());
        }
        return false;
    }

    public String getIpAddress(String string) throws DeviceNotAvailableException {
        NetCfgOutputParser netCfgOutputParser = new NetCfgOutputParser(string);
        this.mDevice.executeShellCommand("netcfg", (IShellOutputReceiver)netCfgOutputParser);
        return netCfgOutputParser.mIpAddress;
    }

    void removeAllNetworks() throws DeviceNotAvailableException {
        WpaCliOutput wpaCliOutput = this.callWpaCli("list_networks");
        if (!wpaCliOutput.isSuccess()) {
            return;
        }
        Pattern pattern = Pattern.compile("^(\\d+)\\s+\\w+");
        for (String string : wpaCliOutput.mOutputLines) {
            Matcher matcher = pattern.matcher(string);
            if (!matcher.find()) continue;
            Integer n = Integer.parseInt(matcher.group(1));
            this.removeNetwork(n);
        }
    }

    private WpaCliOutput callWpaCli(String string) throws DeviceNotAvailableException {
        String string2 = String.format("wpa_cli %s && echo && echo %s", string, SUCCESS_MARKER);
        WpaCliOutput wpaCliOutput = new WpaCliOutput();
        this.mDevice.executeShellCommand(string2, (IShellOutputReceiver)wpaCliOutput);
        return wpaCliOutput;
    }

    private boolean callWpaCliChecked(String string) throws DeviceNotAvailableException {
        WpaCliOutput wpaCliOutput = this.callWpaCli(string);
        if (!wpaCliOutput.isSuccess()) {
            return false;
        }
        for (String string2 : wpaCliOutput.mOutputLines) {
            if (!string2.equals("OK")) continue;
            return true;
        }
        return false;
    }

    private static class NetCfgOutputParser
    extends MultiLineReceiver {
        String mIpAddress = null;
        final String mInterfaceName;

        NetCfgOutputParser(String string) {
            this.mInterfaceName = string;
        }

        public void processNewLines(String[] stringArray) {
            for (String string : stringArray) {
                String[] stringArray2 = string.split("\\s+");
                if (stringArray2.length < 2 || stringArray2[0].equals("lo") || this.mInterfaceName != null && !stringArray2[0].equals(this.mInterfaceName) || !stringArray2[1].equals("UP") || stringArray2[2].equals("0.0.0.0")) continue;
                this.mIpAddress = stringArray2[2];
                break;
            }
        }

        public boolean isCancelled() {
            return false;
        }
    }

    private static class WpaCliOutput
    extends MultiLineReceiver {
        private boolean mDidCommandComplete = false;
        private boolean mIsCommandSuccess = true;
        String mWpaInterface = null;
        List<String> mOutputLines = new ArrayList<String>();

        WpaCliOutput() {
        }

        public void processNewLines(String[] stringArray) {
            if (!this.mDidCommandComplete) {
                this.mDidCommandComplete = stringArray[stringArray.length - 1].equals(WifiHelper.SUCCESS_MARKER);
            }
            Pattern pattern = Pattern.compile("Using interface '(.*)'");
            for (String string : stringArray) {
                Matcher matcher;
                this.mOutputLines.add(string);
                if (string.contains("Failed to connect to wpa_supplicant")) {
                    this.mIsCommandSuccess = false;
                }
                if (!(matcher = pattern.matcher(string)).find()) continue;
                this.mWpaInterface = matcher.group(1);
            }
        }

        public boolean isSuccess() {
            return this.mDidCommandComplete && this.mIsCommandSuccess;
        }

        public boolean isCancelled() {
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum WifiState {
        COMPLETED,
        SCANNING,
        DISCONNECTED;

    }
}

