/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.device;

import com.android.ddmlib.AdbCommandRejectedException;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.Log;
import com.android.ddmlib.TimeoutException;
import com.android.tradefed.config.Option;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.DeviceUnresponsiveException;
import com.android.tradefed.device.IDeviceRecovery;
import com.android.tradefed.device.IDeviceStateMonitor;
import com.android.tradefed.device.TestDeviceState;
import com.android.tradefed.util.IRunUtil;
import com.android.tradefed.util.RunUtil;
import java.io.IOException;

public class WaitDeviceRecovery
implements IDeviceRecovery {
    private static final String LOG_TAG = "WaitDeviceRecovery";
    protected static final long INITIAL_PAUSE_TIME = 5000L;
    @Option(name="device-wait-time", description="maximum time in ms to wait for a single device recovery command")
    protected long mWaitTime = 240000L;

    protected IRunUtil getRunUtil() {
        return RunUtil.getInstance();
    }

    void setWaitTime(long l) {
        this.mWaitTime = l;
    }

    public void recoverDevice(IDeviceStateMonitor iDeviceStateMonitor) throws DeviceNotAvailableException {
        IDevice iDevice;
        Log.i((String)LOG_TAG, (String)String.format("Pausing for %d for %s to recover", 5000L, iDeviceStateMonitor.getSerialNumber()));
        this.getRunUtil().sleep(5000L);
        iDeviceStateMonitor.waitForDeviceBootloaderStateUpdate();
        if (iDeviceStateMonitor.getDeviceState() == TestDeviceState.FASTBOOT) {
            Log.i((String)LOG_TAG, (String)String.format("Found device %s in fastboot but expected online. Rebooting...", iDeviceStateMonitor.getSerialNumber()));
            this.getRunUtil().runTimedCmd(20000L, "fastboot", "-s", iDeviceStateMonitor.getSerialNumber(), "reboot");
        }
        if ((iDevice = iDeviceStateMonitor.waitForDeviceOnline()) == null) {
            this.handleDeviceNotAvailable(iDeviceStateMonitor);
            return;
        }
        if (iDeviceStateMonitor.waitForDeviceAvailable(this.mWaitTime) == null) {
            this.handleDeviceUnresponsive(iDevice, iDeviceStateMonitor);
        }
    }

    protected void handleDeviceUnresponsive(IDevice iDevice, IDeviceStateMonitor iDeviceStateMonitor) throws DeviceNotAvailableException {
        this.rebootDevice(iDevice);
        IDevice iDevice2 = iDeviceStateMonitor.waitForDeviceOnline();
        if (iDevice2 == null) {
            this.handleDeviceNotAvailable(iDeviceStateMonitor);
            return;
        }
        if (iDeviceStateMonitor.waitForDeviceAvailable(this.mWaitTime) == null) {
            throw new DeviceUnresponsiveException(String.format("Device %s is online but unresponsive", iDeviceStateMonitor.getSerialNumber()));
        }
    }

    protected void handleDeviceNotAvailable(IDeviceStateMonitor iDeviceStateMonitor) throws DeviceNotAvailableException {
        throw new DeviceNotAvailableException(String.format("Could not find device %s", iDeviceStateMonitor.getSerialNumber()));
    }

    public void recoverDeviceBootloader(IDeviceStateMonitor iDeviceStateMonitor) throws DeviceNotAvailableException {
        Log.i((String)LOG_TAG, (String)String.format("Pausing for %d for %s to recover", 5000L, iDeviceStateMonitor.getSerialNumber()));
        this.getRunUtil().sleep(5000L);
        iDeviceStateMonitor.waitForDeviceBootloaderStateUpdate();
        if (iDeviceStateMonitor.getDeviceState() == TestDeviceState.FASTBOOT) {
            Log.i((String)LOG_TAG, (String)String.format("Found device %s in fastboot but unresponsive.", iDeviceStateMonitor.getSerialNumber()));
            this.handleDeviceBootloaderUnresponsive(iDeviceStateMonitor);
        } else {
            if (iDeviceStateMonitor.getDeviceState() == TestDeviceState.ONLINE) {
                Log.i((String)LOG_TAG, (String)String.format("Found device %s online but expected fastboot.", iDeviceStateMonitor.getSerialNumber()));
                IDevice iDevice = iDeviceStateMonitor.waitForDeviceOnline();
                if (iDevice == null) {
                    this.handleDeviceBootloaderNotAvailable(iDeviceStateMonitor);
                    return;
                }
                this.rebootDeviceIntoBootloader(iDevice);
            }
            if (!iDeviceStateMonitor.waitForDeviceBootloader(this.mWaitTime)) {
                this.handleDeviceBootloaderNotAvailable(iDeviceStateMonitor);
            }
        }
    }

    protected void handleDeviceBootloaderUnresponsive(IDeviceStateMonitor iDeviceStateMonitor) throws DeviceNotAvailableException {
        this.getRunUtil().runTimedCmd(20000L, "fastboot", "-s", iDeviceStateMonitor.getSerialNumber(), "reboot-bootloader");
        iDeviceStateMonitor.waitForDeviceNotAvailable(20000L);
        if (!iDeviceStateMonitor.waitForDeviceBootloader(this.mWaitTime)) {
            throw new DeviceNotAvailableException(String.format("Device %s not in bootloader after reboot", iDeviceStateMonitor.getSerialNumber()));
        }
    }

    protected void rebootDeviceIntoBootloader(IDevice iDevice) {
        try {
            iDevice.reboot("bootloader");
        }
        catch (IOException iOException) {
            Log.w((String)LOG_TAG, (String)String.format("failed to reboot %s: %s", iDevice.getSerialNumber(), iOException.getMessage()));
        }
        catch (TimeoutException timeoutException) {
            Log.w((String)LOG_TAG, (String)String.format("failed to reboot %s: timeout", iDevice.getSerialNumber()));
        }
        catch (AdbCommandRejectedException adbCommandRejectedException) {
            Log.w((String)LOG_TAG, (String)String.format("failed to reboot %s: %s", iDevice.getSerialNumber(), adbCommandRejectedException.getMessage()));
        }
    }

    protected void rebootDevice(IDevice iDevice) {
        try {
            iDevice.reboot(null);
        }
        catch (IOException iOException) {
            Log.w((String)LOG_TAG, (String)String.format("failed to reboot %s: %s", iDevice.getSerialNumber(), iOException.getMessage()));
        }
        catch (TimeoutException timeoutException) {
            Log.w((String)LOG_TAG, (String)String.format("failed to reboot %s: timeout", iDevice.getSerialNumber()));
        }
        catch (AdbCommandRejectedException adbCommandRejectedException) {
            Log.w((String)LOG_TAG, (String)String.format("failed to reboot %s: %s", iDevice.getSerialNumber(), adbCommandRejectedException.getMessage()));
        }
    }

    protected void handleDeviceBootloaderNotAvailable(IDeviceStateMonitor iDeviceStateMonitor) throws DeviceNotAvailableException {
        throw new DeviceNotAvailableException(String.format("Could not find device %s in bootloader", iDeviceStateMonitor.getSerialNumber()));
    }
}

