/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.device;

import com.android.ddmlib.AdbCommandRejectedException;
import com.android.ddmlib.FileListingService;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.ddmlib.InstallException;
import com.android.ddmlib.Log;
import com.android.ddmlib.ShellCommandUnresponsiveException;
import com.android.ddmlib.SyncException;
import com.android.ddmlib.SyncService;
import com.android.ddmlib.TimeoutException;
import com.android.ddmlib.testrunner.IRemoteAndroidTestRunner;
import com.android.ddmlib.testrunner.ITestRunListener;
import com.android.tradefed.config.Option;
import com.android.tradefed.device.CollectingByteOutputReceiver;
import com.android.tradefed.device.CollectingOutputReceiver;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.DeviceUnresponsiveException;
import com.android.tradefed.device.FileEntryWrapper;
import com.android.tradefed.device.IDeviceRecovery;
import com.android.tradefed.device.IDeviceStateMonitor;
import com.android.tradefed.device.IFileEntry;
import com.android.tradefed.device.IManagedTestDevice;
import com.android.tradefed.device.TestDeviceState;
import com.android.tradefed.device.WifiHelper;
import com.android.tradefed.result.ByteArrayInputStreamSource;
import com.android.tradefed.result.InputStreamSource;
import com.android.tradefed.result.SnapshotInputStreamSource;
import com.android.tradefed.result.StubTestListener;
import com.android.tradefed.util.CommandResult;
import com.android.tradefed.util.CommandStatus;
import com.android.tradefed.util.FileUtil;
import com.android.tradefed.util.IRunUtil;
import com.android.tradefed.util.RunUtil;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.SequenceInputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.concurrent.Semaphore;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TestDevice
implements IManagedTestDevice {
    private static final String LOG_TAG = "TestDevice";
    static final int MAX_RETRY_ATTEMPTS = 2;
    private static final int LOGCAT_BUFF_SIZE = 32768;
    private static final String LOGCAT_CMD = "logcat -v threadtime";
    private static final String BUGREPORT_CMD = "bugreport";
    private static final int BUGREPORT_TIMEOUT = 120000;
    private int mLogStartDelay = 5000;
    private static final int FASTBOOT_TIMEOUT = 60000;
    private static final int ADB_RECOVERY_TIMEOUT = 60000;
    private static final int NUM_CLEAR_ATTEMPTS = 5;
    static final String DISMISS_DIALOG_CMD = "input keyevent 23";
    private static final String BUILD_ID_PROP = "ro.build.version.incremental";
    private int mCmdTimeout = 120000;
    private long mLongCmdTimeout = 720000L;
    private IDevice mIDevice;
    private IDeviceRecovery mRecovery;
    private final IDeviceStateMonitor mMonitor;
    private TestDeviceState mState = TestDeviceState.ONLINE;
    private Semaphore mFastbootLock = new Semaphore(1);
    private LogCatReceiver mLogcatReceiver;
    private IFileEntry mRootFile = null;
    private boolean mFastbootEnabled = true;
    @Option(name="enable-root", description="enable adb root on boot")
    private boolean mEnableAdbRoot = true;
    @Option(name="disable-keyguard", description="attempt to disable keyguard once complete")
    private boolean mDisableKeyguard = true;
    @Option(name="disable-keyguard-cmd", description="shell command to disable keyguard")
    private String mDisableKeyguardCmd = "input keyevent 82";
    @Option(name="max-tmp-logcat-file", description="The maximum size of a tmp logcat file, in bytes")
    private long mMaxLogcatFileSize = 0xA00000L;

    TestDevice(IDevice iDevice, IDeviceStateMonitor iDeviceStateMonitor) {
        this.mIDevice = iDevice;
        this.mMonitor = iDeviceStateMonitor;
    }

    IRunUtil getRunUtil() {
        return RunUtil.getInstance();
    }

    void setTmpLogcatSize(long l) {
        this.mMaxLogcatFileSize = l;
    }

    void setLogStartDelay(int n) {
        this.mLogStartDelay = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IDevice getIDevice() {
        IDevice iDevice = this.mIDevice;
        synchronized (iDevice) {
            return this.mIDevice;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setIDevice(IDevice iDevice) {
        IDevice iDevice2 = this.mIDevice;
        if (!this.getIDevice().equals(iDevice)) {
            IDevice iDevice3 = iDevice2;
            synchronized (iDevice3) {
                this.mIDevice = iDevice;
            }
            this.mMonitor.setIDevice(this.mIDevice);
        }
    }

    @Override
    public String getSerialNumber() {
        return this.getIDevice().getSerialNumber();
    }

    @Override
    public String getProductType() throws DeviceNotAvailableException {
        return this.internalGetProductType(2);
    }

    @Override
    public int getBuildId() {
        String string = this.getIDevice().getProperty(BUILD_ID_PROP);
        try {
            int n = Integer.parseInt(string);
            return n;
        }
        catch (NumberFormatException numberFormatException) {
            Log.w((String)LOG_TAG, (String)String.format("Could not get device %s build id. Received %s", this.getSerialNumber(), string));
            return -1;
        }
    }

    private String internalGetProductType(int n) throws DeviceNotAvailableException {
        String string = this.getIDevice().getProperty("ro.product.board");
        if (string == null || string.isEmpty()) {
            if (this.getDeviceState() == TestDeviceState.FASTBOOT) {
                Log.i((String)LOG_TAG, (String)String.format("Product type for device %s is null, re-querying in fastboot", this.getSerialNumber()));
                string = this.getFastbootProduct();
            } else {
                Log.w((String)LOG_TAG, (String)String.format("Product type for device %s is null, re-querying", this.getSerialNumber()));
                string = this.executeShellCommand("getprop ro.product.board").trim();
                if (string.isEmpty()) {
                    string = this.executeShellCommand("getprop ro.product.device").trim();
                    Log.i((String)LOG_TAG, (String)String.format("Fell back to ro.product.device because ro.product.board is unset. product type is %s.", string));
                }
            }
        }
        if (string == null || string.isEmpty()) {
            if (n > 0) {
                this.recoverDevice();
                string = this.internalGetProductType(n - 1);
            }
            if (string == null || string.isEmpty()) {
                throw new DeviceNotAvailableException(String.format("Could not determine product type for device %s.", this.getSerialNumber()));
            }
        }
        return string;
    }

    private String getFastbootProduct() throws DeviceNotAvailableException, UnsupportedOperationException {
        CommandResult commandResult = this.executeFastbootCommand("getvar", "product");
        if (commandResult.getStatus() == CommandStatus.SUCCESS) {
            Matcher matcher;
            Pattern pattern = Pattern.compile("product:\\s(.*)\\s");
            String string = commandResult.getStdout();
            if (string == null || string.length() < 1) {
                string = commandResult.getStderr();
            }
            if ((matcher = pattern.matcher(string)).find()) {
                return matcher.group(1);
            }
        }
        return null;
    }

    @Override
    public void executeShellCommand(final String string, final IShellOutputReceiver iShellOutputReceiver) throws DeviceNotAvailableException {
        DeviceAction deviceAction = new DeviceAction(){

            public boolean run() throws TimeoutException, IOException, AdbCommandRejectedException, ShellCommandUnresponsiveException {
                TestDevice.this.getIDevice().executeShellCommand(string, iShellOutputReceiver, TestDevice.this.mCmdTimeout);
                return true;
            }
        };
        this.performDeviceAction(String.format("shell %s", string), deviceAction, 2);
    }

    @Override
    public void executeShellCommand(final String string, final IShellOutputReceiver iShellOutputReceiver, final int n, int n2) throws DeviceNotAvailableException {
        DeviceAction deviceAction = new DeviceAction(){

            public boolean run() throws TimeoutException, IOException, AdbCommandRejectedException, ShellCommandUnresponsiveException {
                TestDevice.this.getIDevice().executeShellCommand(string, iShellOutputReceiver, n);
                return true;
            }
        };
        this.performDeviceAction(String.format("shell %s", string), deviceAction, n2);
    }

    @Override
    public String executeShellCommand(String string) throws DeviceNotAvailableException {
        CollectingOutputReceiver collectingOutputReceiver = new CollectingOutputReceiver();
        this.executeShellCommand(string, collectingOutputReceiver);
        String string2 = collectingOutputReceiver.getOutput();
        Log.v((String)LOG_TAG, (String)String.format("%s on %s returned %s", string, this.getSerialNumber(), string2));
        return string2;
    }

    @Override
    public boolean runInstrumentationTests(final IRemoteAndroidTestRunner iRemoteAndroidTestRunner, final Collection<ITestRunListener> collection) throws DeviceNotAvailableException {
        RunFailureListener runFailureListener = new RunFailureListener();
        collection.add(runFailureListener);
        DeviceAction deviceAction = new DeviceAction(){

            public boolean run() throws IOException, TimeoutException, AdbCommandRejectedException, ShellCommandUnresponsiveException, InstallException, SyncException {
                iRemoteAndroidTestRunner.run(collection);
                return true;
            }
        };
        boolean bl = this.performDeviceAction(String.format("run %s instrumentation tests", iRemoteAndroidTestRunner.getPackageName()), deviceAction, 0);
        if (runFailureListener.mIsRunFailure && this.mMonitor.waitForDeviceAvailable(5000L) == null) {
            this.recoverDevice();
        }
        return bl;
    }

    @Override
    public boolean runInstrumentationTests(IRemoteAndroidTestRunner iRemoteAndroidTestRunner, ITestRunListener ... iTestRunListenerArray) throws DeviceNotAvailableException {
        ArrayList<ITestRunListener> arrayList = new ArrayList<ITestRunListener>();
        arrayList.addAll(Arrays.asList(iTestRunListenerArray));
        return this.runInstrumentationTests(iRemoteAndroidTestRunner, arrayList);
    }

    @Override
    public String installPackage(final File file, final boolean bl) throws DeviceNotAvailableException {
        final String[] stringArray = new String[1];
        DeviceAction deviceAction = new DeviceAction(){

            public boolean run() throws InstallException {
                String string;
                stringArray[0] = string = TestDevice.this.getIDevice().installPackage(file.getAbsolutePath(), bl);
                return string == null;
            }
        };
        this.performDeviceAction(String.format("install %s", file.getAbsolutePath()), deviceAction, 2);
        return stringArray[0];
    }

    @Override
    public String uninstallPackage(final String string) throws DeviceNotAvailableException {
        final String[] stringArray = new String[1];
        DeviceAction deviceAction = new DeviceAction(){

            public boolean run() throws InstallException {
                String string2;
                stringArray[0] = string2 = TestDevice.this.getIDevice().uninstallPackage(string);
                return string2 == null;
            }
        };
        this.performDeviceAction(String.format("uninstall %s", string), deviceAction, 2);
        return stringArray[0];
    }

    @Override
    public boolean pullFile(final String string, final File file) throws DeviceNotAvailableException {
        DeviceAction deviceAction = new DeviceAction(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean run() throws TimeoutException, IOException, AdbCommandRejectedException, SyncException {
                SyncService syncService = null;
                boolean bl = false;
                try {
                    try {
                        syncService = TestDevice.this.getIDevice().getSyncService();
                        syncService.pullFile(string, file.getAbsolutePath(), SyncService.getNullProgressMonitor());
                        bl = true;
                    }
                    catch (SyncException syncException) {
                        Log.w((String)TestDevice.LOG_TAG, (String)String.format("Failed to pull %s from %s. Message %s", string, TestDevice.this.getSerialNumber(), syncException.getMessage()));
                        throw syncException;
                    }
                    Object var5_3 = null;
                    if (syncService == null) return bl;
                }
                catch (Throwable throwable) {
                    Object var5_4 = null;
                    if (syncService == null) throw throwable;
                    syncService.close();
                    throw throwable;
                }
                syncService.close();
                return bl;
            }
        };
        return this.performDeviceAction(String.format("pull %s", string), deviceAction, 2);
    }

    @Override
    public File pullFile(String string) throws DeviceNotAvailableException {
        try {
            File file = FileUtil.createTempFileForRemote(string, null);
            if (this.pullFile(string, file)) {
                return file;
            }
        }
        catch (IOException iOException) {
            Log.w((String)LOG_TAG, (String)String.format("Encountered IOException while trying to pull '%s': %s", string, iOException));
        }
        return null;
    }

    @Override
    public File pullFileFromExternal(String string) throws DeviceNotAvailableException {
        String string2 = this.getMountPoint("EXTERNAL_STORAGE");
        String string3 = new File(string2, string).getPath();
        return this.pullFile(string3);
    }

    @Override
    public boolean pushFile(final File file, final String string) throws DeviceNotAvailableException {
        DeviceAction deviceAction = new DeviceAction(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean run() throws TimeoutException, IOException, AdbCommandRejectedException, SyncException {
                SyncService syncService = null;
                boolean bl = false;
                try {
                    try {
                        syncService = TestDevice.this.getIDevice().getSyncService();
                        syncService.pushFile(file.getAbsolutePath(), string, SyncService.getNullProgressMonitor());
                        bl = true;
                    }
                    catch (SyncException syncException) {
                        Log.w((String)TestDevice.LOG_TAG, (String)String.format("Failed to push to %s on device %s. Message %s", string, TestDevice.this.getSerialNumber(), syncException.getMessage()));
                        throw syncException;
                    }
                    Object var5_3 = null;
                    if (syncService == null) return bl;
                }
                catch (Throwable throwable) {
                    Object var5_4 = null;
                    if (syncService == null) throw throwable;
                    syncService.close();
                    throw throwable;
                }
                syncService.close();
                return bl;
            }
        };
        return this.performDeviceAction(String.format("push %s", string), deviceAction, 2);
    }

    @Override
    public boolean doesFileExist(String string) throws DeviceNotAvailableException {
        String string2 = this.executeShellCommand(String.format("ls \"%s\"", string));
        return !string2.contains("No such file or directory");
    }

    @Override
    public long getExternalStoreFreeSpace() throws DeviceNotAvailableException {
        Log.i((String)LOG_TAG, (String)String.format("Checking free space for %s", this.getSerialNumber()));
        String string = this.getMountPoint("EXTERNAL_STORAGE");
        String string2 = this.executeShellCommand(String.format("df %s", string));
        Long l = this.parseFreeSpaceFromAvailable(string2);
        if (l != null) {
            return l;
        }
        l = this.parseFreeSpaceFromFree(string, string2);
        if (l != null) {
            return l;
        }
        Log.e((String)LOG_TAG, (String)String.format("free space command output \"%s\" did not match expected patterns", string2));
        return 0L;
    }

    private Long parseFreeSpaceFromAvailable(String string) {
        Pattern pattern = Pattern.compile("(\\d+)K available");
        Matcher matcher = pattern.matcher(string);
        if (matcher.find()) {
            String string2 = matcher.group(1);
            try {
                return Long.parseLong(string2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    private Long parseFreeSpaceFromFree(String string, String string2) {
        Long l = null;
        Pattern pattern = Pattern.compile(String.format("%s\\s+[\\w\\d]+\\s+[\\w\\d]+\\s+(\\d+)(\\w)", string));
        Matcher matcher = pattern.matcher(string2);
        if (matcher.find()) {
            String string3 = matcher.group(1);
            String string4 = matcher.group(2);
            try {
                l = Long.parseLong(string3);
                if (string4.equals("M")) {
                    l = l * 1024L;
                } else if (string4.equals("G")) {
                    l = l * 1024L * 1024L;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return l;
    }

    @Override
    public String getMountPoint(String string) {
        return this.mMonitor.getMountPoint(string);
    }

    @Override
    public IFileEntry getFileEntry(String string) throws DeviceNotAvailableException {
        String[] stringArray = string.split("/");
        if (this.mRootFile == null) {
            FileListingService fileListingService = this.getIDevice().getFileListingService();
            this.mRootFile = new FileEntryWrapper(this, fileListingService.getRoot());
        }
        return FileEntryWrapper.getDescendant(this.mRootFile, Arrays.asList(stringArray));
    }

    @Override
    public boolean syncFiles(File file, String string) throws DeviceNotAvailableException {
        IFileEntry iFileEntry;
        Log.i((String)LOG_TAG, (String)String.format("Syncing %s to %s on device %s", file.getAbsolutePath(), string, this.getSerialNumber()));
        if (!file.isDirectory()) {
            Log.e((String)LOG_TAG, (String)String.format("file %s is not a directory", file.getAbsolutePath()));
            return false;
        }
        if (!this.doesFileExist(string = String.format("%s/%s", string, file.getName()))) {
            this.executeShellCommand(String.format("mkdir %s", string));
        }
        if ((iFileEntry = this.getFileEntry(string)) == null) {
            Log.e((String)LOG_TAG, (String)String.format("Could not find remote file entry %s ", string));
            return false;
        }
        return this.syncFiles(file, iFileEntry);
    }

    private boolean syncFiles(File file, IFileEntry iFileEntry) throws DeviceNotAvailableException {
        Log.d((String)LOG_TAG, (String)String.format("Syncing %s to %s on %s", file.getAbsolutePath(), iFileEntry.getFullPath(), this.getSerialNumber()));
        File[] fileArray = file.listFiles(new NoHiddenFilesFilter());
        ArrayList<String> arrayList = new ArrayList<String>();
        for (File file2 : fileArray) {
            IFileEntry iFileEntry2 = iFileEntry.findChild(file2.getName());
            if (iFileEntry2 == null) {
                Log.d((String)LOG_TAG, (String)String.format("Detected missing file path %s", file2.getAbsolutePath()));
                arrayList.add(file2.getAbsolutePath());
                continue;
            }
            if (file2.isDirectory()) {
                if (this.syncFiles(file2, iFileEntry2)) continue;
                return false;
            }
            if (!this.isNewer(file2, iFileEntry2)) continue;
            Log.d((String)LOG_TAG, (String)String.format("Detected newer file %s", file2.getAbsolutePath()));
            arrayList.add(file2.getAbsolutePath());
        }
        if (arrayList.size() == 0) {
            Log.d((String)LOG_TAG, (String)"No files to sync");
            return true;
        }
        Object[] objectArray = arrayList.toArray(new String[arrayList.size()]);
        DeviceAction deviceAction = new DeviceAction((String[])objectArray, iFileEntry){
            final /* synthetic */ String[] val$files;
            final /* synthetic */ IFileEntry val$remoteFileEntry;
            {
                this.val$files = stringArray;
                this.val$remoteFileEntry = iFileEntry;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean run() throws TimeoutException, IOException, AdbCommandRejectedException, SyncException {
                SyncService syncService = null;
                boolean bl = false;
                try {
                    try {
                        syncService = TestDevice.this.getIDevice().getSyncService();
                        syncService.push(this.val$files, this.val$remoteFileEntry.getFileEntry(), SyncService.getNullProgressMonitor());
                        bl = true;
                    }
                    catch (SyncException syncException) {
                        Log.w((String)TestDevice.LOG_TAG, (String)String.format("Failed to sync files to %s on device %s. Message %s", this.val$remoteFileEntry.getFullPath(), TestDevice.this.getSerialNumber(), syncException.getMessage()));
                        throw syncException;
                    }
                    Object var5_3 = null;
                    if (syncService == null) return bl;
                }
                catch (Throwable throwable) {
                    Object var5_4 = null;
                    if (syncService == null) throw throwable;
                    syncService.close();
                    throw throwable;
                }
                syncService.close();
                return bl;
            }
        };
        return this.performDeviceAction(String.format("sync files %s", iFileEntry.getFullPath()), deviceAction, 2);
    }

    FileListingService.FileEntry[] getFileChildren(FileListingService.FileEntry fileEntry) throws DeviceNotAvailableException {
        FileQueryAction fileQueryAction = new FileQueryAction(fileEntry, this.getIDevice().getFileListingService());
        this.performDeviceAction("buildFileCache", fileQueryAction, 2);
        return fileQueryAction.mFileContents;
    }

    private boolean isNewer(File file, IFileEntry iFileEntry) {
        String string = String.format("%s %s GMT", iFileEntry.getDate(), iFileEntry.getTime());
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm zzz");
            Date date = simpleDateFormat.parse(string);
            return file.lastModified() > date.getTime() - 60000L;
        }
        catch (ParseException parseException) {
            Log.e((String)LOG_TAG, (String)String.format("Error converting remote time stamp %s for %s on device %s", string, iFileEntry.getFullPath(), this.getSerialNumber()));
            return true;
        }
    }

    @Override
    public String executeAdbCommand(String ... stringArray) throws DeviceNotAvailableException {
        final String[] stringArray2 = this.buildAdbCommand(stringArray);
        final String[] stringArray3 = new String[1];
        DeviceAction deviceAction = new DeviceAction(){

            public boolean run() throws TimeoutException, IOException {
                CommandResult commandResult = TestDevice.this.getRunUtil().runTimedCmd(TestDevice.this.getCommandTimeout(), stringArray2);
                if (commandResult.getStatus() != CommandStatus.SUCCESS) {
                    throw new IOException();
                }
                if (commandResult.getStatus() == CommandStatus.EXCEPTION) {
                    throw new IOException();
                }
                if (commandResult.getStatus() == CommandStatus.TIMED_OUT) {
                    throw new TimeoutException();
                }
                stringArray3[0] = commandResult.getStdout();
                return true;
            }
        };
        this.performDeviceAction(String.format("adb %s", stringArray[0]), deviceAction, 2);
        return stringArray3[0];
    }

    @Override
    public CommandResult executeFastbootCommand(String ... stringArray) throws DeviceNotAvailableException, UnsupportedOperationException {
        return this.doFastbootCommand(this.getCommandTimeout(), stringArray);
    }

    @Override
    public CommandResult executeLongFastbootCommand(String ... stringArray) throws DeviceNotAvailableException, UnsupportedOperationException {
        return this.doFastbootCommand(this.getLongCommandTimeout(), stringArray);
    }

    private CommandResult doFastbootCommand(long l, String ... stringArray) throws DeviceNotAvailableException, UnsupportedOperationException {
        if (!this.mFastbootEnabled) {
            throw new UnsupportedOperationException(String.format("Attempted to fastboot on device %s , but fastboot is not available. Aborting.", this.getSerialNumber()));
        }
        String[] stringArray2 = this.buildFastbootCommand(stringArray);
        for (int i = 0; i < 2; ++i) {
            try {
                this.mFastbootLock.acquire();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            CommandResult commandResult = this.getRunUtil().runTimedCmd(l, stringArray2);
            this.mFastbootLock.release();
            if (!this.isRecoveryNeeded(commandResult)) {
                return commandResult;
            }
            this.recoverDeviceFromBootloader();
        }
        throw new DeviceUnresponsiveException(String.format("Attempted fastboot %s multiple times on device %s without communication success. Aborting.", stringArray[0], this.getSerialNumber()));
    }

    private boolean isRecoveryNeeded(CommandResult commandResult) {
        if (commandResult.getStatus().equals((Object)CommandStatus.TIMED_OUT)) {
            return true;
        }
        if (commandResult.getStderr().contains("data transfer failure (Protocol error)") || commandResult.getStderr().contains("status read failed (No such device)")) {
            Log.w((String)LOG_TAG, (String)String.format("Bad fastboot response from device %s. stderr: %s. Entering recovery", this.getSerialNumber(), commandResult.getStderr()));
            return true;
        }
        return false;
    }

    int getCommandTimeout() {
        return this.mCmdTimeout;
    }

    void setLongCommandTimeout(long l) {
        this.mLongCmdTimeout = l;
    }

    long getLongCommandTimeout() {
        return this.mLongCmdTimeout;
    }

    void setCommandTimeout(int n) {
        this.mCmdTimeout = n;
    }

    private String[] buildAdbCommand(String ... stringArray) {
        String[] stringArray2 = new String[stringArray.length + 3];
        stringArray2[0] = "adb";
        stringArray2[1] = "-s";
        stringArray2[2] = this.getSerialNumber();
        System.arraycopy(stringArray, 0, stringArray2, 3, stringArray.length);
        return stringArray2;
    }

    private String[] buildFastbootCommand(String ... stringArray) {
        String[] stringArray2 = new String[stringArray.length + 3];
        stringArray2[0] = "fastboot";
        stringArray2[1] = "-s";
        stringArray2[2] = this.getSerialNumber();
        System.arraycopy(stringArray, 0, stringArray2, 3, stringArray.length);
        return stringArray2;
    }

    private boolean performDeviceAction(String string, DeviceAction deviceAction, int n) throws DeviceNotAvailableException {
        for (int i = 0; i < n + 1; ++i) {
            try {
                return deviceAction.run();
            }
            catch (TimeoutException timeoutException) {
                Log.w((String)LOG_TAG, (String)String.format("'%s' timed out on device %s", string, this.getSerialNumber()));
            }
            catch (IOException iOException) {
                Log.w((String)LOG_TAG, (String)String.format("Exception when attempting %s on device %s", string, this.getSerialNumber()));
            }
            catch (InstallException installException) {
                Log.w((String)LOG_TAG, (String)String.format("InstallException when attempting %s on device %s", string, this.getSerialNumber()));
            }
            catch (SyncException syncException) {
                Log.w((String)LOG_TAG, (String)String.format("SyncException when attempting %s on device %s", string, this.getSerialNumber()));
                if (!syncException.getErrorCode().equals((Object)SyncException.SyncError.BUFFER_OVERRUN) && !syncException.getErrorCode().equals((Object)SyncException.SyncError.TRANSFER_PROTOCOL_ERROR)) {
                    return false;
                }
            }
            catch (AdbCommandRejectedException adbCommandRejectedException) {
                Log.w((String)LOG_TAG, (String)String.format("AdbCommandRejectedException when attempting %s on device %s", string, this.getSerialNumber()));
            }
            catch (ShellCommandUnresponsiveException shellCommandUnresponsiveException) {
                Log.w((String)LOG_TAG, (String)String.format("Device %s stopped responding when attempting %s", this.getSerialNumber(), string));
            }
            this.recoverDevice();
        }
        if (n > 0) {
            throw new DeviceUnresponsiveException(String.format("Attempted %s multiple times on device %s without communication success. Aborting.", string, this.getSerialNumber()));
        }
        return false;
    }

    void recoverDevice() throws DeviceNotAvailableException {
        Log.i((String)LOG_TAG, (String)String.format("Attempting recovery on %s", this.getSerialNumber()));
        this.mRecovery.recoverDevice(this.mMonitor);
        Log.i((String)LOG_TAG, (String)String.format("Recovery successful for %s", this.getSerialNumber()));
        this.postBootSetup();
    }

    private void recoverDeviceFromBootloader() throws DeviceNotAvailableException {
        Log.i((String)LOG_TAG, (String)String.format("Attempting recovery on %s in bootloader", this.getSerialNumber()));
        this.mRecovery.recoverDeviceBootloader(this.mMonitor);
        Log.i((String)LOG_TAG, (String)String.format("Bootloader recovery successful for %s", this.getSerialNumber()));
    }

    @Override
    public void startLogcat() {
        if (this.mLogcatReceiver != null) {
            Log.d((String)LOG_TAG, (String)String.format("Already capturing logcat for %s, ignoring", this.getSerialNumber()));
            return;
        }
        this.mLogcatReceiver = new LogCatReceiver();
        this.mLogcatReceiver.start();
    }

    @Override
    public InputStreamSource getLogcat() {
        if (this.mLogcatReceiver == null) {
            Log.w((String)LOG_TAG, (String)String.format("Not capturing logcat for %s in background, returning a logcat dump", this.getSerialNumber()));
            return this.getLogcatDump();
        }
        return this.mLogcatReceiver.getLogcatData();
    }

    private InputStreamSource getLogcatDump() {
        byte[] byArray = new byte[]{};
        try {
            CollectingByteOutputReceiver collectingByteOutputReceiver = new CollectingByteOutputReceiver();
            this.getIDevice().executeShellCommand("logcat -v threadtime -d", (IShellOutputReceiver)collectingByteOutputReceiver);
            byArray = collectingByteOutputReceiver.getOutput();
        }
        catch (IOException iOException) {
            Log.w((String)LOG_TAG, (String)String.format("Failed to get logcat dump from %s: ", this.getSerialNumber(), iOException.getMessage()));
        }
        catch (TimeoutException timeoutException) {
            Log.w((String)LOG_TAG, (String)String.format("Failed to get logcat dump from %s: timeout", this.getSerialNumber()));
        }
        catch (AdbCommandRejectedException adbCommandRejectedException) {
            Log.w((String)LOG_TAG, (String)String.format("Failed to get logcat dump from %s: ", this.getSerialNumber(), adbCommandRejectedException.getMessage()));
        }
        catch (ShellCommandUnresponsiveException shellCommandUnresponsiveException) {
            Log.w((String)LOG_TAG, (String)String.format("Failed to get logcat dump from %s: ", this.getSerialNumber(), shellCommandUnresponsiveException.getMessage()));
        }
        return new ByteArrayInputStreamSource(byArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopLogcat() {
        if (this.mLogcatReceiver != null) {
            LogCatReceiver logCatReceiver = this.mLogcatReceiver;
            synchronized (logCatReceiver) {
                this.mLogcatReceiver.cancel();
                this.mLogcatReceiver = null;
            }
        } else {
            Log.w((String)LOG_TAG, (String)String.format("Attempting to stop logcat when not capturing for %s", this.getSerialNumber()));
        }
    }

    LogCatReceiver createLogcatReceiver() {
        return new LogCatReceiver();
    }

    @Override
    public InputStreamSource getBugreport() {
        CollectingByteOutputReceiver collectingByteOutputReceiver = new CollectingByteOutputReceiver();
        try {
            this.executeShellCommand(BUGREPORT_CMD, collectingByteOutputReceiver, 120000, 0);
        }
        catch (DeviceNotAvailableException deviceNotAvailableException) {
            Log.e((String)LOG_TAG, (String)String.format("Device %s became unresponsive while retrieving bugreport", this.getSerialNumber()));
        }
        return new ByteArrayInputStreamSource(collectingByteOutputReceiver.getOutput());
    }

    @Override
    public boolean connectToWifiNetwork(String string, String string2) throws DeviceNotAvailableException {
        Log.i((String)LOG_TAG, (String)String.format("Connecting to wifi network %s on %s", string, this.getSerialNumber()));
        WifiHelper wifiHelper = new WifiHelper(this);
        wifiHelper.enableWifi();
        wifiHelper.waitForWifiState(WifiHelper.WifiState.SCANNING, WifiHelper.WifiState.COMPLETED);
        Integer n = null;
        n = string2 != null ? wifiHelper.addWpaPskNetwork(string, string2) : wifiHelper.addOpenNetwork(string);
        if (n == null) {
            Log.e((String)LOG_TAG, (String)String.format("Failed to add wifi network %s on %s", string, this.getSerialNumber()));
            return false;
        }
        if (!wifiHelper.associateNetwork(n)) {
            Log.e((String)LOG_TAG, (String)String.format("Failed to enable wifi network %s on %s", string, this.getSerialNumber()));
            return false;
        }
        if (!wifiHelper.waitForWifiState(WifiHelper.WifiState.COMPLETED)) {
            Log.e((String)LOG_TAG, (String)String.format("wifi network %s failed to associate on %s", string, this.getSerialNumber()));
            return false;
        }
        if (!wifiHelper.waitForIp(30000L)) {
            Log.e((String)LOG_TAG, (String)String.format("dhcp timeout when connecting to wifi network %s on %s", string, this.getSerialNumber()));
            return false;
        }
        for (int i = 0; i < 10; ++i) {
            String string3 = this.executeShellCommand("ping -c 1 -w 5 www.google.com");
            if (string3.contains("1 packets transmitted, 1 received")) {
                return true;
            }
            this.getRunUtil().sleep(1000L);
        }
        Log.e((String)LOG_TAG, (String)String.format("ping unsuccessful after connecting to wifi network %s on %s", string, this.getSerialNumber()));
        return false;
    }

    @Override
    public boolean disconnectFromWifi() throws DeviceNotAvailableException {
        WifiHelper wifiHelper = new WifiHelper(this);
        wifiHelper.removeAllNetworks();
        wifiHelper.disableWifi();
        return true;
    }

    @Override
    public String getIpAddress() throws DeviceNotAvailableException {
        WifiHelper wifiHelper = new WifiHelper(this);
        return wifiHelper.getIpAddress(null);
    }

    @Override
    public boolean clearErrorDialogs() throws DeviceNotAvailableException {
        for (int i = 0; i < 5; ++i) {
            int n = this.getErrorDialogCount();
            if (n == 0) {
                return true;
            }
            this.doClearDialogs(n);
        }
        if (this.getErrorDialogCount() > 0) {
            Log.e((String)LOG_TAG, (String)String.format("error dialogs still exist on %s.", this.getSerialNumber()));
            return false;
        }
        return true;
    }

    private int getErrorDialogCount() throws DeviceNotAvailableException {
        int n = 0;
        Pattern pattern = Pattern.compile(".*crashing=true.*AppErrorDialog.*");
        Pattern pattern2 = Pattern.compile(".*notResponding=true.*AppNotRespondingDialog.*");
        String string = this.executeShellCommand("dumpsys activity processes");
        Matcher matcher = pattern.matcher(string);
        while (matcher.find()) {
            ++n;
        }
        Matcher matcher2 = pattern2.matcher(string);
        while (matcher2.find()) {
            ++n;
        }
        return n;
    }

    private void doClearDialogs(int n) throws DeviceNotAvailableException {
        Log.i((String)LOG_TAG, (String)String.format("Attempted to clear %d dialogs on %s", n, this.getSerialNumber()));
        for (int i = 0; i < n; ++i) {
            this.executeShellCommand(DISMISS_DIALOG_CMD);
        }
    }

    IDeviceStateMonitor getDeviceStateMonitor() {
        return this.mMonitor;
    }

    @Override
    public void postBootSetup() throws DeviceNotAvailableException {
        if (this.mEnableAdbRoot) {
            this.enableAdbRoot();
        }
        if (this.mDisableKeyguard) {
            Log.i((String)LOG_TAG, (String)String.format("Attempting to disable keyguard on %s using %s", this.getSerialNumber(), this.mDisableKeyguardCmd));
            this.executeShellCommand(this.mDisableKeyguardCmd);
        }
    }

    String getDisableKeyguardCmd() {
        return this.mDisableKeyguardCmd;
    }

    @Override
    public void rebootIntoBootloader() throws DeviceNotAvailableException, UnsupportedOperationException {
        if (!this.mFastbootEnabled) {
            throw new UnsupportedOperationException("Fastboot is not available and cannot reboot into bootloader");
        }
        if (TestDeviceState.FASTBOOT == this.mMonitor.getDeviceState()) {
            Log.i((String)LOG_TAG, (String)String.format("device %s already in fastboot. Rebooting anyway", this.getSerialNumber()));
            this.executeFastbootCommand("reboot-bootloader");
        } else {
            Log.i((String)LOG_TAG, (String)String.format("Booting device %s into bootloader", this.getSerialNumber()));
            this.doAdbRebootBootloader();
        }
        if (!this.mMonitor.waitForDeviceBootloader(60000L)) {
            this.recoverDeviceFromBootloader();
        }
    }

    private void doAdbRebootBootloader() throws DeviceNotAvailableException {
        try {
            this.getIDevice().reboot("bootloader");
            return;
        }
        catch (IOException iOException) {
            Log.w((String)LOG_TAG, (String)String.format("IOException '%s' when rebooting %s into bootloader", iOException.getMessage(), this.getSerialNumber()));
            this.recoverDeviceFromBootloader();
        }
        catch (TimeoutException timeoutException) {
            Log.w((String)LOG_TAG, (String)String.format("TimeoutException when rebooting %s into bootloader", this.getSerialNumber()));
            this.recoverDeviceFromBootloader();
        }
        catch (AdbCommandRejectedException adbCommandRejectedException) {
            Log.w((String)LOG_TAG, (String)String.format("AdbCommandRejectedException '%s' when rebooting %s into bootloader", adbCommandRejectedException.getMessage(), this.getSerialNumber()));
            this.recoverDeviceFromBootloader();
        }
    }

    @Override
    public void reboot() throws DeviceNotAvailableException {
        this.doReboot();
        if (this.mMonitor.waitForDeviceAvailable() != null) {
            this.postBootSetup();
            return;
        }
        this.recoverDevice();
    }

    @Override
    public void rebootUntilOnline() throws DeviceNotAvailableException {
        this.doReboot();
        if (this.mMonitor.waitForDeviceOnline() != null) {
            if (this.mEnableAdbRoot) {
                this.enableAdbRoot();
            }
            return;
        }
        this.recoverDevice();
    }

    @Override
    public void rebootIntoRecovery() throws DeviceNotAvailableException {
        if (TestDeviceState.FASTBOOT == this.getDeviceState()) {
            Log.w((String)LOG_TAG, (String)String.format("device %s in fastboot when requesting boot to recovery. Rebooting to userspace first.", this.getSerialNumber()));
            this.rebootUntilOnline();
        }
        this.doAdbReboot("recovery");
        if (!this.waitForDeviceInRecovery(60000L)) {
            throw new DeviceNotAvailableException();
        }
    }

    private void doReboot() throws DeviceNotAvailableException, UnsupportedOperationException {
        if (TestDeviceState.FASTBOOT == this.getDeviceState()) {
            Log.i((String)LOG_TAG, (String)String.format("device %s in fastboot. Rebooting to userspace.", this.getSerialNumber()));
            this.executeFastbootCommand("reboot");
        } else {
            Log.i((String)LOG_TAG, (String)String.format("Rebooting device %s", this.getSerialNumber()));
            this.doAdbReboot(null);
            this.waitForDeviceNotAvailable("reboot", this.getCommandTimeout());
        }
    }

    private void doAdbReboot(final String string) throws DeviceNotAvailableException {
        DeviceAction deviceAction = new DeviceAction(){

            public boolean run() throws TimeoutException, IOException, AdbCommandRejectedException {
                TestDevice.this.getIDevice().reboot(string);
                return true;
            }
        };
        this.performDeviceAction("reboot", deviceAction, 2);
    }

    private void waitForDeviceNotAvailable(String string, long l) {
        if (!this.mMonitor.waitForDeviceNotAvailable(l)) {
            Log.w((String)LOG_TAG, (String)String.format("Did not detect device %s becoming unavailable after %s", this.getSerialNumber(), string));
        }
    }

    @Override
    public boolean enableAdbRoot() throws DeviceNotAvailableException {
        Log.i((String)LOG_TAG, (String)String.format("adb root on device %s", this.getSerialNumber()));
        String string = this.executeAdbCommand("root");
        if (string.contains("adbd is already running as root")) {
            return true;
        }
        if (string.contains("restarting adbd as root")) {
            this.waitForDeviceNotAvailable("root", 30000L);
            this.waitForDeviceOnline();
            return true;
        }
        Log.e((String)LOG_TAG, (String)String.format("Unrecognized output from adb root: %s", string));
        return false;
    }

    @Override
    public void waitForDeviceOnline(long l) throws DeviceNotAvailableException {
        if (this.mMonitor.waitForDeviceOnline(l) == null) {
            this.recoverDevice();
        }
    }

    @Override
    public void waitForDeviceOnline() throws DeviceNotAvailableException {
        if (this.mMonitor.waitForDeviceOnline() == null) {
            this.recoverDevice();
        }
    }

    @Override
    public void waitForDeviceAvailable(long l) throws DeviceNotAvailableException {
        if (this.mMonitor.waitForDeviceAvailable(l) == null) {
            this.recoverDevice();
        }
    }

    @Override
    public void waitForDeviceAvailable() throws DeviceNotAvailableException {
        if (this.mMonitor.waitForDeviceAvailable() == null) {
            this.recoverDevice();
        }
    }

    @Override
    public boolean waitForDeviceNotAvailable(long l) {
        return this.mMonitor.waitForDeviceNotAvailable(l);
    }

    @Override
    public boolean waitForDeviceInRecovery(long l) {
        return this.mMonitor.waitForDeviceInRecovery(l);
    }

    void setEnableAdbRoot(boolean bl) {
        this.mEnableAdbRoot = bl;
    }

    IDeviceRecovery getRecovery() {
        return this.mRecovery;
    }

    @Override
    public void setRecovery(IDeviceRecovery iDeviceRecovery) {
        this.mRecovery = iDeviceRecovery;
    }

    @Override
    public void setFastbootEnabled(boolean bl) {
        this.mFastbootEnabled = bl;
    }

    @Override
    public void setDeviceState(TestDeviceState testDeviceState) {
        if (!testDeviceState.equals((Object)this.getDeviceState())) {
            if (this.getDeviceState().equals((Object)TestDeviceState.FASTBOOT) && !this.mFastbootLock.tryAcquire()) {
                return;
            }
            Log.d((String)LOG_TAG, (String)String.format("Device %s state is now %s", new Object[]{this.getSerialNumber(), testDeviceState}));
            this.mState = testDeviceState;
            this.mFastbootLock.release();
            this.mMonitor.setState(testDeviceState);
        }
    }

    @Override
    public TestDeviceState getDeviceState() {
        return this.mState;
    }

    class LogCatReceiver
    extends Thread
    implements IShellOutputReceiver {
        private boolean mIsCancelled = false;
        private OutputStream mOutStream;
        private File mPreviousTmpFile = null;
        private File mTmpFile = null;
        private long mTmpBytesStored = 0L;

        LogCatReceiver() {
        }

        public synchronized void addOutput(byte[] byArray, int n, int n2) {
            if (this.mOutStream == null) {
                return;
            }
            try {
                this.mOutStream.write(byArray, n, n2);
                this.mTmpBytesStored += (long)n2;
                if (this.mTmpBytesStored > TestDevice.this.mMaxLogcatFileSize) {
                    Log.i((String)TestDevice.LOG_TAG, (String)String.format("Max tmp logcat file size reached for %s, swapping", TestDevice.this.getSerialNumber()));
                    this.createTmpFile();
                    this.mTmpBytesStored = 0L;
                }
            }
            catch (IOException iOException) {
                Log.w((String)TestDevice.LOG_TAG, (String)String.format("failed to write logcat data for %s.", TestDevice.this.getSerialNumber()));
            }
        }

        public synchronized InputStreamSource getLogcatData() {
            if (this.mTmpFile != null) {
                this.flush();
                try {
                    FileInputStream fileInputStream = new FileInputStream(this.mTmpFile);
                    if (this.mPreviousTmpFile != null) {
                        SequenceInputStream sequenceInputStream = new SequenceInputStream(new FileInputStream(this.mPreviousTmpFile), fileInputStream);
                        return new SnapshotInputStreamSource(sequenceInputStream);
                    }
                    return new SnapshotInputStreamSource(fileInputStream);
                }
                catch (IOException iOException) {
                    Log.e((String)TestDevice.LOG_TAG, (String)String.format("failed to get logcat data for %s.", TestDevice.this.getSerialNumber()));
                    Log.e((String)TestDevice.LOG_TAG, (Throwable)iOException);
                }
            }
            return new ByteArrayInputStreamSource(new byte[0]);
        }

        public synchronized void flush() {
            if (this.mOutStream == null) {
                return;
            }
            try {
                this.mOutStream.flush();
            }
            catch (IOException iOException) {
                Log.w((String)TestDevice.LOG_TAG, (String)String.format("failed to flush logcat data for %s.", TestDevice.this.getSerialNumber()));
            }
        }

        public synchronized void cancel() {
            this.mIsCancelled = true;
            this.interrupt();
            this.closeLogStream();
            if (this.mTmpFile != null) {
                this.mTmpFile.delete();
                this.mTmpFile = null;
            }
            if (this.mPreviousTmpFile != null) {
                this.mPreviousTmpFile.delete();
                this.mPreviousTmpFile = null;
            }
        }

        private void closeLogStream() {
            try {
                if (this.mOutStream != null) {
                    this.mOutStream.flush();
                    this.mOutStream.close();
                    this.mOutStream = null;
                }
            }
            catch (IOException iOException) {
                Log.w((String)TestDevice.LOG_TAG, (String)String.format("failed to close logcat stream for %s.", TestDevice.this.getSerialNumber()));
            }
        }

        public synchronized boolean isCancelled() {
            return this.mIsCancelled;
        }

        public void run() {
            try {
                this.createTmpFile();
            }
            catch (IOException iOException) {
                Log.e((String)TestDevice.LOG_TAG, (String)String.format("failed to create tmp logcat file for %s.", TestDevice.this.getSerialNumber()));
                Log.e((String)TestDevice.LOG_TAG, (Throwable)iOException);
                return;
            }
            while (!this.isCancelled()) {
                try {
                    if (TestDevice.this.mLogStartDelay > 0) {
                        Log.d((String)TestDevice.LOG_TAG, (String)String.format("Sleep for %d before starting logcat for %s.", TestDevice.this.mLogStartDelay, TestDevice.this.getSerialNumber()));
                        TestDevice.this.getRunUtil().sleep(TestDevice.this.mLogStartDelay);
                    }
                    Log.d((String)TestDevice.LOG_TAG, (String)String.format("Starting logcat for %s.", TestDevice.this.getSerialNumber()));
                    TestDevice.this.getIDevice().executeShellCommand(TestDevice.LOGCAT_CMD, (IShellOutputReceiver)this, 0);
                }
                catch (Exception exception) {
                    String string = String.format("logcat capture interrupted for %s. Waiting for device to be back online. May see duplicate content in log.", TestDevice.this.getSerialNumber());
                    Log.d((String)TestDevice.LOG_TAG, (String)string);
                    this.appendDeviceLogMsg(string);
                    TestDevice.this.getRunUtil().sleep(5000L);
                    TestDevice.this.mMonitor.waitForDeviceOnline(600000L);
                }
            }
        }

        private synchronized void createTmpFile() throws IOException, FileNotFoundException {
            this.closeLogStream();
            if (this.mPreviousTmpFile != null) {
                this.mPreviousTmpFile.delete();
            }
            this.mPreviousTmpFile = this.mTmpFile;
            this.mTmpFile = FileUtil.createTempFile(String.format("logcat_%s_", TestDevice.this.getSerialNumber()), ".txt");
            Log.i((String)TestDevice.LOG_TAG, (String)String.format("Created tmp logcat file %s", this.mTmpFile.getAbsolutePath()));
            this.mOutStream = new BufferedOutputStream(new FileOutputStream(this.mTmpFile), 32768);
            if (this.mPreviousTmpFile == null) {
                this.appendDeviceLogMsg(String.format("Logcat for device %s running system build %d", TestDevice.this.getSerialNumber(), TestDevice.this.getBuildId()));
            } else {
                this.appendDeviceLogMsg(String.format("Continuing logcat capture for device %s running system build %d. Previous content may have been truncated.", TestDevice.this.getSerialNumber(), TestDevice.this.getBuildId()));
            }
        }

        private synchronized void appendDeviceLogMsg(String string) {
            if (this.mOutStream == null) {
                return;
            }
            try {
                this.mOutStream.write("\n*******************\n".getBytes());
                this.mOutStream.write(string.getBytes());
                this.mOutStream.write("\n*******************\n".getBytes());
            }
            catch (IOException iOException) {
                Log.w((String)TestDevice.LOG_TAG, (String)String.format("failed to write logcat data for %s.", TestDevice.this.getSerialNumber()));
            }
        }
    }

    private static class NoHiddenFilesFilter
    implements FilenameFilter {
        private NoHiddenFilesFilter() {
        }

        public boolean accept(File file, String string) {
            return !string.startsWith(".");
        }
    }

    private class FileQueryAction
    implements DeviceAction {
        FileListingService.FileEntry[] mFileContents = null;
        private FileListingService.FileEntry mRemoteFileEntry;
        private FileListingService mService;

        FileQueryAction(FileListingService.FileEntry fileEntry, FileListingService fileListingService) {
            this.mRemoteFileEntry = fileEntry;
            this.mService = fileListingService;
        }

        public boolean run() throws TimeoutException, IOException {
            this.mFileContents = this.mService.getChildren(this.mRemoteFileEntry, false, null);
            return true;
        }
    }

    private static class RunFailureListener
    extends StubTestListener {
        private boolean mIsRunFailure = false;

        private RunFailureListener() {
        }

        public void testRunFailed(String string) {
            this.mIsRunFailure = true;
        }
    }

    private static interface DeviceAction {
        public boolean run() throws IOException, TimeoutException, AdbCommandRejectedException, ShellCommandUnresponsiveException, InstallException, SyncException;
    }
}

