/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.device;

import com.android.ddmlib.FileListingService;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.IFileEntry;
import com.android.tradefed.device.TestDevice;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FileEntryWrapper
implements IFileEntry {
    private final TestDevice mTestDevice;
    private final FileListingService.FileEntry mFileEntry;
    private Map<String, IFileEntry> mChildMap = null;

    FileEntryWrapper(TestDevice testDevice, FileListingService.FileEntry fileEntry) {
        this.mTestDevice = testDevice;
        this.mFileEntry = fileEntry;
    }

    @Override
    public String getFullEscapedPath() {
        return this.mFileEntry.getFullEscapedPath();
    }

    @Override
    public String getFullPath() {
        return this.mFileEntry.getFullPath();
    }

    @Override
    public IFileEntry findChild(String string) throws DeviceNotAvailableException {
        if (this.mChildMap == null || !this.mChildMap.containsKey(string)) {
            this.mChildMap = this.buildChildrenMap();
        }
        return this.mChildMap.get(string);
    }

    @Override
    public boolean isDirectory() {
        return this.mFileEntry.isDirectory();
    }

    @Override
    public boolean isAppFileName() {
        return this.mFileEntry.isAppFileName();
    }

    @Override
    public String getName() {
        return this.mFileEntry.getName();
    }

    @Override
    public Collection<IFileEntry> getChildren(boolean bl) throws DeviceNotAvailableException {
        if (bl || this.mChildMap == null) {
            this.mChildMap = this.buildChildrenMap();
        }
        return this.mChildMap.values();
    }

    private Map<String, IFileEntry> buildChildrenMap() throws DeviceNotAvailableException {
        FileListingService.FileEntry[] fileEntryArray = this.mTestDevice.getFileChildren(this.mFileEntry);
        HashMap<String, IFileEntry> hashMap = new HashMap<String, IFileEntry>(fileEntryArray.length);
        for (FileListingService.FileEntry fileEntry : fileEntryArray) {
            hashMap.put(fileEntry.getName(), new FileEntryWrapper(this.mTestDevice, fileEntry));
        }
        return hashMap;
    }

    static IFileEntry getDescendant(IFileEntry iFileEntry, List<String> list) throws DeviceNotAvailableException {
        IFileEntry iFileEntry2 = iFileEntry;
        for (String string : list) {
            if (string.length() <= 0 || (iFileEntry2 = iFileEntry2.findChild(string)) != null) continue;
            return null;
        }
        return iFileEntry2;
    }

    @Override
    public FileListingService.FileEntry getFileEntry() {
        return this.mFileEntry;
    }

    @Override
    public String getTime() {
        return this.mFileEntry.getTime();
    }

    @Override
    public String getDate() {
        return this.mFileEntry.getDate();
    }
}

