/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.device;

import com.android.ddmlib.AdbCommandRejectedException;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.ddmlib.Log;
import com.android.ddmlib.ShellCommandUnresponsiveException;
import com.android.ddmlib.TimeoutException;
import com.android.tradefed.device.CollectingOutputReceiver;
import com.android.tradefed.device.IDeviceManager;
import com.android.tradefed.device.IDeviceStateMonitor;
import com.android.tradefed.device.TestDeviceState;
import com.android.tradefed.util.IRunUtil;
import com.android.tradefed.util.RunUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

class DeviceStateMonitor
implements IDeviceStateMonitor {
    private static final String LOG_TAG = "DeviceStateMonitor";
    private IDevice mDevice;
    private TestDeviceState mDeviceState;
    private static final long CHECK_POLL_TIME = 5000L;
    private static final int MAX_OP_TIME = 30000;
    private static final long DEFAULT_ONLINE_TIMEOUT = 60000L;
    private static final long DEFAULT_AVAILABLE_TIMEOUT = 360000L;
    private List<DeviceStateListener> mStateListeners;
    private IDeviceManager mMgr;

    DeviceStateMonitor(IDeviceManager iDeviceManager, IDevice iDevice) {
        this.mMgr = iDeviceManager;
        this.mDevice = iDevice;
        this.mStateListeners = new ArrayList<DeviceStateListener>();
        this.mDeviceState = TestDeviceState.getStateByDdms(iDevice.getState());
    }

    IRunUtil getRunUtil() {
        return RunUtil.getInstance();
    }

    public IDevice waitForDeviceOnline(long l) {
        if (this.waitForDeviceState(TestDeviceState.ONLINE, l)) {
            return this.getIDevice();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IDevice getIDevice() {
        IDevice iDevice = this.mDevice;
        synchronized (iDevice) {
            return this.mDevice;
        }
    }

    public String getSerialNumber() {
        return this.getIDevice().getSerialNumber();
    }

    public IDevice waitForDeviceOnline() {
        return this.waitForDeviceOnline(60000L);
    }

    public boolean waitForDeviceNotAvailable(long l) {
        StubFastbootListener stubFastbootListener = new StubFastbootListener();
        this.mMgr.addFastbootListener(stubFastbootListener);
        boolean bl = this.waitForDeviceState(TestDeviceState.NOT_AVAILABLE, l);
        this.mMgr.removeFastbootListener(stubFastbootListener);
        return bl;
    }

    public boolean waitForDeviceInRecovery(long l) {
        return this.waitForDeviceState(TestDeviceState.RECOVERY, l);
    }

    public IDevice waitForDeviceAvailable(long l) {
        long l2 = System.currentTimeMillis();
        IDevice iDevice = this.waitForDeviceOnline(l);
        if (iDevice == null) {
            return null;
        }
        long l3 = System.currentTimeMillis() - l2;
        if (!this.waitForPmResponsive(l - l3)) {
            return null;
        }
        l3 = System.currentTimeMillis() - l2;
        if (!this.waitForStoreMount(l - l3)) {
            return null;
        }
        return iDevice;
    }

    public IDevice waitForDeviceAvailable() {
        return this.waitForDeviceAvailable(360000L);
    }

    private boolean waitForPmResponsive(long l) {
        Log.i((String)LOG_TAG, (String)String.format("Waiting %d ms for device %s package manager", l, this.getSerialNumber()));
        long l2 = System.currentTimeMillis();
        while (System.currentTimeMillis() - l2 < l) {
            CollectingOutputReceiver collectingOutputReceiver = new CollectingOutputReceiver();
            try {
                this.getIDevice().executeShellCommand("pm path android", (IShellOutputReceiver)collectingOutputReceiver, 30000);
                String string = collectingOutputReceiver.getOutput();
                Log.v((String)LOG_TAG, (String)String.format("%s returned %s", "pm path android", string));
                if (string.contains("package:")) {
                    return true;
                }
            }
            catch (IOException iOException) {
                Log.i((String)LOG_TAG, (String)String.format("%s failed: %s", "pm path android", iOException.getMessage()));
            }
            catch (TimeoutException timeoutException) {
                Log.i((String)LOG_TAG, (String)String.format("%s failed: timeout", "pm path android"));
            }
            catch (AdbCommandRejectedException adbCommandRejectedException) {
                Log.i((String)LOG_TAG, (String)String.format("%s failed: %s", "pm path android", adbCommandRejectedException.getMessage()));
            }
            catch (ShellCommandUnresponsiveException shellCommandUnresponsiveException) {
                Log.i((String)LOG_TAG, (String)String.format("%s failed: %s", "pm path android", shellCommandUnresponsiveException.getMessage()));
            }
            this.getRunUtil().sleep(5000L);
        }
        Log.w((String)LOG_TAG, (String)String.format("Device %s package manager is unresponsive", this.getSerialNumber()));
        return false;
    }

    private boolean waitForStoreMount(long l) {
        Log.i((String)LOG_TAG, (String)String.format("Waiting %d ms for device %s external store", l, this.getSerialNumber()));
        long l2 = System.currentTimeMillis();
        while (System.currentTimeMillis() - l2 < l) {
            CollectingOutputReceiver collectingOutputReceiver = new CollectingOutputReceiver();
            CollectingOutputReceiver collectingOutputReceiver2 = new CollectingOutputReceiver();
            long l3 = System.currentTimeMillis();
            String string = this.getMountPoint("EXTERNAL_STORAGE");
            String string2 = String.format("'%s/%d'", string, l3);
            String string3 = String.format("number %d one", l3);
            String string4 = String.format("echo '%s' > %s", string3, string2);
            String string5 = String.format("cat %s", string2);
            String string6 = String.format("rm %s", string2);
            String string7 = null;
            if (string != null) {
                try {
                    string7 = string4;
                    this.getIDevice().executeShellCommand(string4, (IShellOutputReceiver)collectingOutputReceiver2, 30000);
                    string7 = string5;
                    this.getIDevice().executeShellCommand(string5, (IShellOutputReceiver)collectingOutputReceiver, 30000);
                    string7 = string6;
                    this.getIDevice().executeShellCommand(string6, (IShellOutputReceiver)collectingOutputReceiver2, 30000);
                    String string8 = collectingOutputReceiver.getOutput();
                    Log.v((String)LOG_TAG, (String)String.format("%s returned %s", string5, string8));
                    if (string8.contains(string3)) {
                        return true;
                    }
                }
                catch (IOException iOException) {
                    Log.i((String)LOG_TAG, (String)String.format("%s failed: %s", string7, iOException.getMessage()));
                }
                catch (TimeoutException timeoutException) {
                    Log.i((String)LOG_TAG, (String)String.format("%s failed: timeout", string7));
                }
                catch (AdbCommandRejectedException adbCommandRejectedException) {
                    Log.i((String)LOG_TAG, (String)String.format("%s failed: %s", string7, adbCommandRejectedException.getMessage()));
                }
                catch (ShellCommandUnresponsiveException shellCommandUnresponsiveException) {
                    Log.i((String)LOG_TAG, (String)String.format("%s failed: %s", string7, shellCommandUnresponsiveException.getMessage()));
                }
            } else {
                Log.w((String)LOG_TAG, (String)String.format("Failed to get external store mount point for %s", this.getSerialNumber()));
            }
            this.getRunUtil().sleep(5000L);
        }
        Log.w((String)LOG_TAG, (String)String.format("Device %s external storage is not mounted after %d ms", this.getSerialNumber(), l));
        return false;
    }

    public String getMountPoint(String string) {
        String string2 = this.getIDevice().getMountPoint(string);
        if (string2 != null) {
            return string2;
        }
        CollectingOutputReceiver collectingOutputReceiver = new CollectingOutputReceiver();
        try {
            this.getIDevice().executeShellCommand("echo $" + string, (IShellOutputReceiver)collectingOutputReceiver);
            return collectingOutputReceiver.getOutput().trim();
        }
        catch (IOException iOException) {
            return null;
        }
        catch (TimeoutException timeoutException) {
            return null;
        }
        catch (AdbCommandRejectedException adbCommandRejectedException) {
            return null;
        }
        catch (ShellCommandUnresponsiveException shellCommandUnresponsiveException) {
            return null;
        }
    }

    public TestDeviceState getDeviceState() {
        return this.mDeviceState;
    }

    public boolean waitForDeviceBootloader(long l) {
        long l2 = System.currentTimeMillis();
        this.waitForDeviceBootloaderStateUpdate();
        long l3 = System.currentTimeMillis() - l2;
        StubFastbootListener stubFastbootListener = new StubFastbootListener();
        this.mMgr.addFastbootListener(stubFastbootListener);
        long l4 = l - l3;
        if (l4 < 0L) {
            l4 = 200L;
        }
        boolean bl = this.waitForDeviceState(TestDeviceState.FASTBOOT, l4);
        this.mMgr.removeFastbootListener(stubFastbootListener);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForDeviceBootloaderStateUpdate() {
        NotifyFastbootListener notifyFastbootListener;
        NotifyFastbootListener notifyFastbootListener2 = notifyFastbootListener = new NotifyFastbootListener();
        synchronized (notifyFastbootListener2) {
            this.mMgr.addFastbootListener(notifyFastbootListener);
            try {
                notifyFastbootListener.wait();
            }
            catch (InterruptedException interruptedException) {
                Log.w((String)LOG_TAG, (String)"wait for device bootloader state update interrupted");
            }
        }
        this.mMgr.removeFastbootListener(notifyFastbootListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean waitForDeviceState(TestDeviceState testDeviceState, long l) {
        String string = this.getSerialNumber();
        if (this.getDeviceState() == testDeviceState) {
            Log.i((String)LOG_TAG, (String)String.format("Device %s is already %s", new Object[]{string, testDeviceState}));
            return true;
        }
        Log.i((String)LOG_TAG, (String)String.format("Waiting for device %s to be %s; it is currently %s...", new Object[]{string, testDeviceState, this.getDeviceState()}));
        DeviceStateListener deviceStateListener = new DeviceStateListener(testDeviceState);
        this.addDeviceStateListener(deviceStateListener);
        DeviceStateListener deviceStateListener2 = deviceStateListener;
        synchronized (deviceStateListener2) {
            try {
                deviceStateListener.wait(l);
            }
            catch (InterruptedException interruptedException) {
                Log.w((String)LOG_TAG, (String)"wait for device state interrupted");
            }
        }
        this.removeDeviceStateListener(deviceStateListener);
        return this.getDeviceState().equals((Object)testDeviceState);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeDeviceStateListener(DeviceStateListener deviceStateListener) {
        List<DeviceStateListener> list = this.mStateListeners;
        synchronized (list) {
            this.mStateListeners.remove(deviceStateListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addDeviceStateListener(DeviceStateListener deviceStateListener) {
        List<DeviceStateListener> list = this.mStateListeners;
        synchronized (list) {
            this.mStateListeners.add(deviceStateListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setState(TestDeviceState testDeviceState) {
        this.mDeviceState = testDeviceState;
        ArrayList<DeviceStateListener> arrayList = new ArrayList<DeviceStateListener>(this.mStateListeners.size());
        List<DeviceStateListener> list = this.mStateListeners;
        synchronized (list) {
            arrayList.addAll(this.mStateListeners);
        }
        for (DeviceStateListener deviceStateListener : arrayList) {
            deviceStateListener.stateChanged(testDeviceState);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setIDevice(IDevice iDevice) {
        IDevice iDevice2 = this.mDevice;
        if (!this.getIDevice().equals(iDevice)) {
            IDevice iDevice3 = iDevice2;
            synchronized (iDevice3) {
                this.mDevice = iDevice;
            }
        }
    }

    private static class NotifyFastbootListener
    implements IDeviceManager.IFastbootListener {
        private NotifyFastbootListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stateUpdated() {
            NotifyFastbootListener notifyFastbootListener = this;
            synchronized (notifyFastbootListener) {
                this.notify();
            }
        }
    }

    private static class StubFastbootListener
    implements IDeviceManager.IFastbootListener {
        private StubFastbootListener() {
        }

        public void stateUpdated() {
        }
    }

    private static class DeviceStateListener {
        private final TestDeviceState mExpectedState;

        public DeviceStateListener(TestDeviceState testDeviceState) {
            this.mExpectedState = testDeviceState;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stateChanged(TestDeviceState testDeviceState) {
            if (this.mExpectedState.equals((Object)testDeviceState)) {
                DeviceStateListener deviceStateListener = this;
                synchronized (deviceStateListener) {
                    this.notify();
                }
            }
        }
    }
}

