/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.device;

import com.android.ddmlib.Log;
import com.android.tradefed.config.Option;
import com.android.tradefed.device.IDeviceSelectionOptions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeviceSelectionOptions
implements IDeviceSelectionOptions {
    private static final String LOG_TAG = "DeviceSelectionOptions";
    @Option(name="serial", shortName=115, description="run this test on a specific device with given serial number(s)")
    private Collection<String> mSerials = new ArrayList<String>();
    @Option(name="exclude-serial", description="run this test on any device except those with this serial number(s)")
    private Collection<String> mExcludeSerials = new ArrayList<String>();
    @Option(name="product-type", description="run this test on device with this product type(s)")
    private Collection<String> mProductTypes = new ArrayList<String>();
    @Option(name="property", description="run this test on device with this property value. Expected format <propertyname>=<propertyvalue>")
    private Collection<String> mPropertyStrings = new ArrayList<String>();
    private boolean mFetchedEnvVariable = false;

    public void addSerial(String string) {
        this.mSerials.add(string);
    }

    public void addExcludeSerial(String string) {
        this.mExcludeSerials.add(string);
    }

    public void addProductType(String string) {
        this.mProductTypes.add(string);
    }

    public void addProperty(String string) {
        this.mPropertyStrings.add(string);
    }

    @Override
    public Collection<String> getSerials() {
        if (this.mSerials.isEmpty() && !this.mFetchedEnvVariable) {
            String string = this.fetchEnvironmentVariable("ANDROID_SERIAL");
            if (string != null) {
                this.mSerials.add(string);
            }
            this.mFetchedEnvVariable = true;
        }
        return this.copyCollection(this.mSerials);
    }

    @Override
    public Collection<String> getExcludeSerials() {
        return this.copyCollection(this.mExcludeSerials);
    }

    @Override
    public Collection<String> getProductTypes() {
        return this.copyCollection(this.mProductTypes);
    }

    @Override
    public Map<String, String> getProperties() {
        HashMap<String, String> hashMap = new HashMap<String, String>(this.mPropertyStrings.size());
        for (String string : this.mPropertyStrings) {
            String[] stringArray = string.split("=");
            if (stringArray.length == 2) {
                hashMap.put(stringArray[0], stringArray[1]);
                continue;
            }
            Log.e((String)LOG_TAG, (String)String.format("Unrecognized property key value pair: '%s'", string));
        }
        return hashMap;
    }

    private Collection<String> copyCollection(Collection<String> collection) {
        ArrayList<String> arrayList = new ArrayList<String>(collection.size());
        arrayList.addAll(collection);
        return arrayList;
    }

    String fetchEnvironmentVariable(String string) {
        return System.getenv(string);
    }
}

