/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.device;

import com.android.ddmlib.IDevice;
import com.android.tradefed.device.IDeviceSelectionOptions;
import java.util.Collection;
import java.util.Map;

public class DeviceSelectionMatcher {
    public static boolean matches(IDevice iDevice, IDeviceSelectionOptions iDeviceSelectionOptions) {
        Collection<String> collection = iDeviceSelectionOptions.getSerials();
        Collection<String> collection2 = iDeviceSelectionOptions.getExcludeSerials();
        Collection<String> collection3 = iDeviceSelectionOptions.getProductTypes();
        Map<String, String> map = iDeviceSelectionOptions.getProperties();
        if (!collection.isEmpty() && !collection.contains(iDevice.getSerialNumber())) {
            return false;
        }
        if (collection2.contains(iDevice.getSerialNumber())) {
            return false;
        }
        if (!collection3.isEmpty() && !collection3.contains(DeviceSelectionMatcher.getDeviceProductType(iDevice))) {
            return false;
        }
        for (Map.Entry<String, String> entry : map.entrySet()) {
            if (entry.getValue().equals(iDevice.getProperty(entry.getKey()))) continue;
            return false;
        }
        return true;
    }

    private static String getDeviceProductType(IDevice iDevice) {
        String string = iDevice.getProperty("ro.product.board");
        if (string == null || string.isEmpty()) {
            string = iDevice.getProperty("ro.product.device");
        }
        return string;
    }
}

