/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.device;

import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.DdmPreferences;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.Log;
import com.android.tradefed.device.AndroidDebugBridgeWrapper;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.DeviceSelectionMatcher;
import com.android.tradefed.device.DeviceSelectionOptions;
import com.android.tradefed.device.DeviceStateMonitor;
import com.android.tradefed.device.IAndroidDebugBridge;
import com.android.tradefed.device.IDeviceManager;
import com.android.tradefed.device.IDeviceRecovery;
import com.android.tradefed.device.IDeviceSelectionOptions;
import com.android.tradefed.device.IDeviceStateMonitor;
import com.android.tradefed.device.IManagedTestDevice;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.device.TestDevice;
import com.android.tradefed.device.TestDeviceState;
import com.android.tradefed.util.CommandResult;
import com.android.tradefed.util.CommandStatus;
import com.android.tradefed.util.ConditionPriorityBlockingQueue;
import com.android.tradefed.util.IRunUtil;
import com.android.tradefed.util.RunUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeviceManager
implements IDeviceManager {
    private static final String LOG_TAG = "DeviceManager";
    private static final long FASTBOOT_CMD_TIMEOUT = 60000L;
    private static final long FASTBOOT_POLL_WAIT_TIME = 5000L;
    private static final int CHECK_WAIT_DEVICE_AVAIL_MS = 5000;
    private static final IDeviceSelectionOptions ANY_DEVICE_OPTIONS = new DeviceSelectionOptions();
    private static DeviceManager sInstance;
    private boolean mIsInitialized = false;
    private Map<String, IManagedTestDevice> mAllocatedDeviceMap;
    private ConditionPriorityBlockingQueue<IDevice> mAvailableDeviceQueue;
    private IAndroidDebugBridge mAdbBridge;
    private ManagedDeviceListener mManagedDeviceListener;
    private boolean mFastbootEnabled;
    private Set<IDeviceManager.IFastbootListener> mFastbootListeners;
    private FastbootMonitor mFastbootMonitor;
    private Map<String, IDeviceStateMonitor> mCheckDeviceMap;
    private boolean mEnableLogcat = true;
    private boolean mIsTerminated = false;
    private DeviceMatcher mGlobalDeviceFilter;

    DeviceManager() {
    }

    @Override
    public void init() {
        this.init(ANY_DEVICE_OPTIONS);
    }

    @Override
    public synchronized void init(IDeviceSelectionOptions iDeviceSelectionOptions) {
        if (this.mIsInitialized) {
            throw new IllegalStateException("already initialized");
        }
        this.mIsInitialized = true;
        this.mGlobalDeviceFilter = new DeviceMatcher(iDeviceSelectionOptions);
        this.mAllocatedDeviceMap = new Hashtable<String, IManagedTestDevice>();
        this.mAvailableDeviceQueue = new ConditionPriorityBlockingQueue();
        this.mCheckDeviceMap = new Hashtable<String, IDeviceStateMonitor>();
        DdmPreferences.setTimeOut((int)30000);
        this.mAdbBridge = this.createAdbBridge();
        this.mAdbBridge.init(false, "adb");
        if (this.isFastbootAvailable()) {
            this.mFastbootListeners = Collections.synchronizedSet(new HashSet());
            this.mFastbootMonitor = new FastbootMonitor();
            this.startFastbootMonitor();
            this.mFastbootEnabled = true;
        } else {
            Log.w((String)LOG_TAG, (String)"Fastboot is not available.");
            this.mFastbootListeners = null;
            this.mFastbootMonitor = null;
            this.mFastbootEnabled = false;
        }
        for (IDevice iDevice : this.mAdbBridge.getDevices()) {
            if (iDevice.getState() != IDevice.DeviceState.ONLINE) continue;
            this.checkAndAddAvailableDevice(iDevice);
        }
        this.mManagedDeviceListener = new ManagedDeviceListener();
        this.mAdbBridge.addDeviceChangeListener(this.mManagedDeviceListener);
    }

    private void checkInit() {
        if (!this.mIsInitialized) {
            throw new IllegalStateException("DeviceManager has not been initialized");
        }
    }

    private boolean isFastbootAvailable() {
        CommandResult commandResult = this.getRunUtil().runTimedCmd(5000L, "fastboot", "devices");
        return commandResult.getStatus() == CommandStatus.SUCCESS;
    }

    void startFastbootMonitor() {
        this.mFastbootMonitor.start();
    }

    IRunUtil getRunUtil() {
        return RunUtil.getInstance();
    }

    public void setEnableLogcat(boolean bl) {
        this.mEnableLogcat = bl;
    }

    private void checkAndAddAvailableDevice(final IDevice iDevice) {
        if (this.mCheckDeviceMap.containsKey(iDevice.getSerialNumber())) {
            Log.d((String)LOG_TAG, (String)String.format("Already checking new device %s, ignoring", iDevice.getSerialNumber()));
            return;
        }
        if (!this.mGlobalDeviceFilter.matches(iDevice)) {
            Log.v((String)LOG_TAG, (String)String.format("New device %s doesn't match global filter, ignoring", iDevice.getSerialNumber()));
            return;
        }
        final IDeviceStateMonitor iDeviceStateMonitor = this.createStateMonitor(iDevice);
        this.mCheckDeviceMap.put(iDevice.getSerialNumber(), iDeviceStateMonitor);
        String string = String.format("Check device %s", iDevice.getSerialNumber());
        Thread thread = new Thread(string){

            public void run() {
                Log.d((String)DeviceManager.LOG_TAG, (String)String.format("checking new device %s responsiveness", iDevice.getSerialNumber()));
                boolean bl = false;
                if (!iDeviceStateMonitor.waitForDeviceNotAvailable(5000L) && iDeviceStateMonitor.getDeviceState().equals((Object)TestDeviceState.ONLINE)) {
                    Log.logAndDisplay((Log.LogLevel)Log.LogLevel.INFO, (String)DeviceManager.LOG_TAG, (String)String.format("Detected new device %s", iDevice.getSerialNumber()));
                    DeviceManager.this.addAvailableDevice(iDevice);
                    bl = true;
                }
                if (!bl) {
                    Log.e((String)DeviceManager.LOG_TAG, (String)String.format("Device %s adb connection is not stable, skip adding to available pool", iDevice.getSerialNumber()));
                }
                DeviceManager.this.mCheckDeviceMap.remove(iDevice.getSerialNumber());
            }
        };
        thread.start();
    }

    IDeviceStateMonitor createStateMonitor(IDevice iDevice) {
        return new DeviceStateMonitor(this, iDevice);
    }

    private void addAvailableDevice(IDevice iDevice) {
        this.mAvailableDeviceQueue.add(iDevice);
    }

    public static synchronized IDeviceManager getInstance() {
        if (sInstance == null) {
            sInstance = new DeviceManager();
        }
        return sInstance;
    }

    @Override
    public ITestDevice allocateDevice() {
        this.checkInit();
        IDevice iDevice = this.takeAvailableDevice();
        if (iDevice == null) {
            return null;
        }
        return this.createAllocatedDevice(iDevice);
    }

    private IDevice takeAvailableDevice() {
        try {
            return this.mAvailableDeviceQueue.take();
        }
        catch (InterruptedException interruptedException) {
            Log.w((String)LOG_TAG, (String)"interrupted while taking device");
            return null;
        }
    }

    @Override
    public ITestDevice allocateDevice(long l) {
        this.checkInit();
        IDevice iDevice = this.pollAvailableDevice(l, ANY_DEVICE_OPTIONS);
        if (iDevice == null) {
            return null;
        }
        return this.createAllocatedDevice(iDevice);
    }

    @Override
    public ITestDevice allocateDevice(long l, IDeviceSelectionOptions iDeviceSelectionOptions) {
        this.checkInit();
        IDevice iDevice = this.pollAvailableDevice(l, iDeviceSelectionOptions);
        if (iDevice == null) {
            return null;
        }
        return this.createAllocatedDevice(iDevice);
    }

    private IDevice pollAvailableDevice(long l, IDeviceSelectionOptions iDeviceSelectionOptions) {
        try {
            return this.mAvailableDeviceQueue.poll(l, TimeUnit.MILLISECONDS, new DeviceMatcher(iDeviceSelectionOptions));
        }
        catch (InterruptedException interruptedException) {
            Log.w((String)LOG_TAG, (String)"interrupted while polling for device");
            return null;
        }
    }

    private ITestDevice createAllocatedDevice(IDevice iDevice) {
        IManagedTestDevice iManagedTestDevice = this.createTestDevice(iDevice, this.createStateMonitor(iDevice));
        if (this.mEnableLogcat) {
            iManagedTestDevice.startLogcat();
        }
        this.mAllocatedDeviceMap.put(iDevice.getSerialNumber(), iManagedTestDevice);
        Log.i((String)LOG_TAG, (String)String.format("Allocated device %s", iManagedTestDevice.getSerialNumber()));
        return iManagedTestDevice;
    }

    IManagedTestDevice createTestDevice(IDevice iDevice, IDeviceStateMonitor iDeviceStateMonitor) {
        TestDevice testDevice = new TestDevice(iDevice, iDeviceStateMonitor);
        testDevice.setFastbootEnabled(this.mFastbootEnabled);
        return testDevice;
    }

    synchronized IAndroidDebugBridge createAdbBridge() {
        return new AndroidDebugBridgeWrapper();
    }

    @Override
    public void freeDevice(ITestDevice iTestDevice, IDeviceManager.FreeDeviceState freeDeviceState) {
        this.checkInit();
        if (iTestDevice instanceof IManagedTestDevice) {
            IManagedTestDevice iManagedTestDevice = (IManagedTestDevice)iTestDevice;
            iManagedTestDevice.stopLogcat();
        }
        if (this.mAllocatedDeviceMap.remove(iTestDevice.getSerialNumber()) == null) {
            Log.e((String)LOG_TAG, (String)String.format("freeDevice called with unallocated device %s", iTestDevice.getSerialNumber()));
        } else if (freeDeviceState == IDeviceManager.FreeDeviceState.UNRESPONSIVE) {
            this.addAvailableDevice(iTestDevice.getIDevice());
        } else if (freeDeviceState == IDeviceManager.FreeDeviceState.AVAILABLE) {
            this.addAvailableDevice(iTestDevice.getIDevice());
        } else if (freeDeviceState == IDeviceManager.FreeDeviceState.UNAVAILABLE) {
            Log.logAndDisplay((Log.LogLevel)Log.LogLevel.WARN, (String)LOG_TAG, (String)String.format("Freed device %s is unavailable. Removing from use.", iTestDevice.getSerialNumber()));
        }
    }

    @Override
    public synchronized void terminate() {
        this.checkInit();
        if (!this.mIsTerminated) {
            this.mIsTerminated = true;
            this.mAdbBridge.removeDeviceChangeListener(this.mManagedDeviceListener);
            this.mAdbBridge.terminate();
            this.mFastbootMonitor.terminate();
        }
    }

    @Override
    public synchronized void terminateHard() {
        this.checkInit();
        if (!this.mIsTerminated) {
            for (IManagedTestDevice iManagedTestDevice : this.mAllocatedDeviceMap.values()) {
                iManagedTestDevice.setRecovery(new AbortRecovery());
            }
            this.mAdbBridge.disconnectBridge();
            this.terminate();
        }
    }

    @Override
    public synchronized Collection<String> getAllocatedDevices() {
        this.checkInit();
        ArrayList<String> arrayList = new ArrayList<String>(this.mAllocatedDeviceMap.size());
        arrayList.addAll(this.mAllocatedDeviceMap.keySet());
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Collection<String> getAvailableDevices() {
        this.checkInit();
        ArrayList<String> arrayList = new ArrayList<String>(this.mAvailableDeviceQueue.size());
        ConditionPriorityBlockingQueue<IDevice> conditionPriorityBlockingQueue = this.mAvailableDeviceQueue;
        synchronized (conditionPriorityBlockingQueue) {
            for (IDevice iDevice : this.mAvailableDeviceQueue) {
                arrayList.add(iDevice.getSerialNumber());
            }
        }
        return arrayList;
    }

    @Override
    public synchronized Collection<String> getUnavailableDevices() {
        this.checkInit();
        IDevice[] iDeviceArray = this.mAdbBridge.getDevices();
        ArrayList<String> arrayList = new ArrayList<String>(iDeviceArray.length);
        Collection<String> collection = this.getAvailableDevices();
        Collection<String> collection2 = this.getAllocatedDevices();
        for (IDevice iDevice : iDeviceArray) {
            if (collection.contains(iDevice.getSerialNumber()) || collection2.contains(iDevice.getSerialNumber())) continue;
            arrayList.add(iDevice.getSerialNumber());
        }
        return arrayList;
    }

    @Override
    public void addFastbootListener(IDeviceManager.IFastbootListener iFastbootListener) {
        this.checkInit();
        if (this.mFastbootEnabled) {
            this.mFastbootListeners.add(iFastbootListener);
        }
    }

    @Override
    public void removeFastbootListener(IDeviceManager.IFastbootListener iFastbootListener) {
        this.checkInit();
        if (this.mFastbootEnabled) {
            this.mFastbootListeners.remove(iFastbootListener);
        }
    }

    static Set<String> getDevicesOnFastboot(String string) {
        HashSet<String> hashSet = new HashSet<String>();
        Pattern pattern = Pattern.compile("([\\w\\d]+)\\s+fastboot\\s*");
        Matcher matcher = pattern.matcher(string);
        while (matcher.find()) {
            hashSet.add(matcher.group(1));
        }
        return hashSet;
    }

    private class FastbootMonitor
    extends Thread {
        private boolean mQuit;

        FastbootMonitor() {
            super("FastbootMonitor");
            this.mQuit = false;
        }

        public void terminate() {
            this.mQuit = true;
            this.interrupt();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (!this.mQuit) {
                if (!DeviceManager.this.mFastbootListeners.isEmpty()) {
                    Collection<Object> collection;
                    CommandResult commandResult = DeviceManager.this.getRunUtil().runTimedCmd(60000L, "fastboot", "devices");
                    if (commandResult.getStatus() == CommandStatus.SUCCESS) {
                        Log.v((String)DeviceManager.LOG_TAG, (String)String.format("fastboot devices returned %s", commandResult.getStdout()));
                        collection = DeviceManager.getDevicesOnFastboot(commandResult.getStdout());
                        for (String string : collection) {
                            IManagedTestDevice iManagedTestDevice = (IManagedTestDevice)DeviceManager.this.mAllocatedDeviceMap.get(string);
                            if (iManagedTestDevice == null || iManagedTestDevice.getDeviceState().equals((Object)TestDeviceState.FASTBOOT)) continue;
                            iManagedTestDevice.setDeviceState(TestDeviceState.FASTBOOT);
                        }
                        Map map = DeviceManager.this.mAllocatedDeviceMap;
                        synchronized (map) {
                            for (IManagedTestDevice iManagedTestDevice : DeviceManager.this.mAllocatedDeviceMap.values()) {
                                if (collection.contains(iManagedTestDevice.getSerialNumber()) || !iManagedTestDevice.getDeviceState().equals((Object)TestDeviceState.FASTBOOT)) continue;
                                iManagedTestDevice.setDeviceState(TestDeviceState.NOT_AVAILABLE);
                            }
                        }
                    }
                    collection = new ArrayList(DeviceManager.this.mFastbootListeners.size());
                    collection.addAll(DeviceManager.this.mFastbootListeners);
                    for (IDeviceManager.IFastbootListener iFastbootListener : collection) {
                        iFastbootListener.stateUpdated();
                    }
                }
                DeviceManager.this.getRunUtil().sleep(5000L);
            }
        }
    }

    private class ManagedDeviceListener
    implements AndroidDebugBridge.IDeviceChangeListener {
        private ManagedDeviceListener() {
        }

        public void deviceChanged(IDevice iDevice, int n) {
            IManagedTestDevice iManagedTestDevice = (IManagedTestDevice)DeviceManager.this.mAllocatedDeviceMap.get(iDevice.getSerialNumber());
            if ((n & 1) != 0) {
                if (iManagedTestDevice != null) {
                    TestDeviceState testDeviceState = TestDeviceState.getStateByDdms(iDevice.getState());
                    iManagedTestDevice.setDeviceState(testDeviceState);
                } else if (DeviceManager.this.mCheckDeviceMap.containsKey(iDevice.getSerialNumber())) {
                    IDeviceStateMonitor iDeviceStateMonitor = (IDeviceStateMonitor)DeviceManager.this.mCheckDeviceMap.get(iDevice.getSerialNumber());
                    iDeviceStateMonitor.setState(TestDeviceState.getStateByDdms(iDevice.getState()));
                } else if (!DeviceManager.this.mAvailableDeviceQueue.contains(iDevice) && iDevice.getState() == IDevice.DeviceState.ONLINE) {
                    DeviceManager.this.checkAndAddAvailableDevice(iDevice);
                }
            }
        }

        public void deviceConnected(IDevice iDevice) {
            Log.d((String)DeviceManager.LOG_TAG, (String)String.format("Detected device connect %s, id %d", iDevice.getSerialNumber(), iDevice.hashCode()));
            IManagedTestDevice iManagedTestDevice = (IManagedTestDevice)DeviceManager.this.mAllocatedDeviceMap.get(iDevice.getSerialNumber());
            if (iManagedTestDevice == null) {
                if (this.isValidDeviceSerial(iDevice.getSerialNumber()) && iDevice.getState() == IDevice.DeviceState.ONLINE) {
                    DeviceManager.this.checkAndAddAvailableDevice(iDevice);
                } else if (DeviceManager.this.mCheckDeviceMap.containsKey(iDevice.getSerialNumber())) {
                    IDeviceStateMonitor iDeviceStateMonitor = (IDeviceStateMonitor)DeviceManager.this.mCheckDeviceMap.get(iDevice.getSerialNumber());
                    iDeviceStateMonitor.setState(TestDeviceState.getStateByDdms(iDevice.getState()));
                }
            } else {
                Log.d((String)DeviceManager.LOG_TAG, (String)String.format("Updating IDevice for device %s", iDevice.getSerialNumber()));
                iManagedTestDevice.setIDevice(iDevice);
                TestDeviceState testDeviceState = TestDeviceState.getStateByDdms(iDevice.getState());
                iManagedTestDevice.setDeviceState(testDeviceState);
            }
        }

        private boolean isValidDeviceSerial(String string) {
            return string.length() > 1 && !string.contains("?");
        }

        public void deviceDisconnected(IDevice iDevice) {
            IManagedTestDevice iManagedTestDevice;
            if (DeviceManager.this.mAvailableDeviceQueue.remove(iDevice)) {
                Log.i((String)DeviceManager.LOG_TAG, (String)String.format("Removed disconnected device %s from available queue", iDevice.getSerialNumber()));
            }
            if ((iManagedTestDevice = (IManagedTestDevice)DeviceManager.this.mAllocatedDeviceMap.get(iDevice.getSerialNumber())) != null) {
                iManagedTestDevice.setDeviceState(TestDeviceState.NOT_AVAILABLE);
            } else if (DeviceManager.this.mCheckDeviceMap.containsKey(iDevice.getSerialNumber())) {
                IDeviceStateMonitor iDeviceStateMonitor = (IDeviceStateMonitor)DeviceManager.this.mCheckDeviceMap.get(iDevice.getSerialNumber());
                iDeviceStateMonitor.setState(TestDeviceState.NOT_AVAILABLE);
            }
        }
    }

    private static class AbortRecovery
    implements IDeviceRecovery {
        private AbortRecovery() {
        }

        public void recoverDevice(IDeviceStateMonitor iDeviceStateMonitor) throws DeviceNotAvailableException {
            throw new DeviceNotAvailableException("aborted test session");
        }

        public void recoverDeviceBootloader(IDeviceStateMonitor iDeviceStateMonitor) throws DeviceNotAvailableException {
            throw new DeviceNotAvailableException("aborted test session");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class DeviceMatcher
    implements ConditionPriorityBlockingQueue.IMatcher<IDevice> {
        private IDeviceSelectionOptions mOptions;

        DeviceMatcher(IDeviceSelectionOptions iDeviceSelectionOptions) {
            this.mOptions = iDeviceSelectionOptions;
        }

        @Override
        public boolean matches(IDevice iDevice) {
            return DeviceSelectionMatcher.matches(iDevice, this.mOptions);
        }
    }
}

