/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.device;

import com.android.ddmlib.Log;
import com.android.tradefed.device.DeviceManager;
import com.android.tradefed.util.RunUtil;
import java.util.Collection;
import junit.framework.TestCase;

public class DeviceDiagTest
extends TestCase {
    private static final String LOG_TAG = "DeviceDiagTest";

    public void testAllDevicesAvailable() {
        Collection<String> collection = DeviceManager.getInstance().getUnavailableDevices();
        for (int i = 0; i < 5 && collection.size() > 0; ++i) {
            Log.i((String)LOG_TAG, (String)"Unavailable devices detected, sleeping and polling");
            RunUtil.getInstance().sleep(1000L);
            collection = DeviceManager.getInstance().getUnavailableDevices();
        }
        for (String string : collection) {
            System.out.println(String.format("Device %s is not available for testing. Check that package manager is up and sdcard is mounted.", string));
        }
        DeviceDiagTest.assertEquals("Not all devices are available", 0, collection.size());
    }
}

