/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.config;

import com.android.tradefed.config.ConfigurationException;
import com.android.tradefed.config.Option;
import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class OptionSetter {
    static final String BOOL_FALSE_PREFIX = "no-";
    private static final HashMap<Class<?>, Handler> handlers = new HashMap();
    private final Collection<Object> mOptionSources;
    private final Map<String, OptionFieldsForName> mOptionMap;

    private static Handler getHandler(Type type) throws ConfigurationException {
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Class clazz = (Class)parameterizedType.getRawType();
            if (!Collection.class.isAssignableFrom(clazz)) {
                throw new ConfigurationException("cannot handle non-collection parameterized type " + type);
            }
            Type type2 = parameterizedType.getActualTypeArguments()[0];
            if (!(type2 instanceof Class)) {
                throw new ConfigurationException("cannot handle nested parameterized type " + type);
            }
            return OptionSetter.getHandler(type2);
        }
        if (type instanceof Class) {
            if (Collection.class.isAssignableFrom((Class)type)) {
                throw new ConfigurationException(String.format("Cannot handle non-parameterized collection %s. %s", type, "use a generic Collection to specify a desired element type"));
            }
            return handlers.get((Class)type);
        }
        throw new ConfigurationException(String.format("cannot handle unknown field type %s", type));
    }

    public OptionSetter(Object ... objectArray) throws ConfigurationException {
        this(Arrays.asList(objectArray));
    }

    public OptionSetter(Collection<Object> collection) throws ConfigurationException {
        this.mOptionSources = collection;
        this.mOptionMap = this.makeOptionMap();
    }

    private OptionFieldsForName fieldsForArg(String string) throws ConfigurationException {
        OptionFieldsForName optionFieldsForName = this.mOptionMap.get(string);
        if (optionFieldsForName == null || optionFieldsForName.size() == 0) {
            throw new ConfigurationException(String.format("Could not find option with name %s", string));
        }
        return optionFieldsForName;
    }

    public String getTypeForOption(String string) throws ConfigurationException {
        return this.fieldsForArg(string).getFirstField().getType().getSimpleName().toLowerCase();
    }

    public void setOptionValue(String string, String string2) throws ConfigurationException {
        OptionFieldsForName optionFieldsForName = this.fieldsForArg(string);
        for (Map.Entry<Object, Field> entry : optionFieldsForName) {
            Object object;
            Object object2 = entry.getKey();
            Field field = entry.getValue();
            Handler handler = OptionSetter.getHandler(field.getGenericType());
            Object object3 = handler.translate(string2);
            if (object3 == null) {
                object = field.getType().getSimpleName().toLowerCase();
                throw new ConfigurationException(String.format("Couldn't convert '%s' to a %s for option '%s'", string2, object, string));
            }
            try {
                field.setAccessible(true);
                if (Collection.class.isAssignableFrom(field.getType())) {
                    object = (Collection)field.get(object2);
                    if (object == null) {
                        throw new ConfigurationException(String.format("internal error: no storage allocated for field '%s' (used for option '%s') in class '%s'", field.getName(), string, object2.getClass().getName()));
                    }
                    object.add(object3);
                    continue;
                }
                field.set(object2, object3);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new ConfigurationException(String.format("internal error when setting option '%s'", string), illegalAccessException);
            }
        }
    }

    private Map<String, OptionFieldsForName> makeOptionMap() throws ConfigurationException {
        HashMap<String, OptionFieldsForName> hashMap = new HashMap<String, OptionFieldsForName>();
        for (Object object : this.mOptionSources) {
            this.addOptionsForObject(object, hashMap);
        }
        return hashMap;
    }

    private void addOptionsForObject(Object object, Map<String, OptionFieldsForName> map) throws ConfigurationException {
        Collection<Field> collection = OptionSetter.getOptionFieldsForClass(object.getClass());
        for (Field field : collection) {
            Option option = field.getAnnotation(Option.class);
            this.addNameToMap(map, object, option.name(), field);
            if (option.shortName() != '0') {
                this.addNameToMap(map, object, String.valueOf(option.shortName()), field);
            }
            if (!OptionSetter.isBooleanField(field)) continue;
            this.addNameToMap(map, object, BOOL_FALSE_PREFIX + option.name(), field);
        }
    }

    protected static Collection<Field> getOptionFieldsForClass(Class<?> clazz) {
        ArrayList<Field> arrayList = new ArrayList<Field>();
        OptionSetter.buildOptionFieldsForClass(clazz, arrayList);
        return arrayList;
    }

    private static void buildOptionFieldsForClass(Class<?> clazz, Collection<Field> collection) {
        for (Field field : clazz.getDeclaredFields()) {
            if (!field.isAnnotationPresent(Option.class)) continue;
            collection.add(field);
        }
        Class<?> clazz2 = clazz.getSuperclass();
        if (clazz2 != null) {
            OptionSetter.buildOptionFieldsForClass(clazz2, collection);
        }
    }

    public boolean isBooleanOption(String string) throws ConfigurationException {
        Field field = this.fieldsForArg(string).getFirstField();
        return OptionSetter.isBooleanField(field);
    }

    static boolean isBooleanField(Field field) throws ConfigurationException {
        return OptionSetter.getHandler(field.getGenericType()).isBoolean();
    }

    private void addNameToMap(Map<String, OptionFieldsForName> map, Object object, String string, Field field) throws ConfigurationException {
        OptionFieldsForName optionFieldsForName = map.get(string);
        if (optionFieldsForName == null) {
            optionFieldsForName = new OptionFieldsForName();
            map.put(string, optionFieldsForName);
        }
        optionFieldsForName.addField(string, object, field);
        if (OptionSetter.getHandler(field.getGenericType()) == null) {
            throw new ConfigurationException(String.format("unsupported @Option field type '%s'", field.getType()));
        }
    }

    static {
        handlers.put(Boolean.TYPE, new BooleanHandler());
        handlers.put(Boolean.class, new BooleanHandler());
        handlers.put(Byte.TYPE, new ByteHandler());
        handlers.put(Byte.class, new ByteHandler());
        handlers.put(Short.TYPE, new ShortHandler());
        handlers.put(Short.class, new ShortHandler());
        handlers.put(Integer.TYPE, new IntegerHandler());
        handlers.put(Integer.class, new IntegerHandler());
        handlers.put(Long.TYPE, new LongHandler());
        handlers.put(Long.class, new LongHandler());
        handlers.put(Float.TYPE, new FloatHandler());
        handlers.put(Float.class, new FloatHandler());
        handlers.put(Double.TYPE, new DoubleHandler());
        handlers.put(Double.class, new DoubleHandler());
        handlers.put(String.class, new StringHandler());
        handlers.put(File.class, new FileHandler());
    }

    private static class FileHandler
    extends Handler {
        private FileHandler() {
        }

        Object translate(String string) {
            return new File(string);
        }
    }

    private static class StringHandler
    extends Handler {
        private StringHandler() {
        }

        Object translate(String string) {
            return string;
        }
    }

    private static class DoubleHandler
    extends Handler {
        private DoubleHandler() {
        }

        Object translate(String string) {
            try {
                return Double.parseDouble(string);
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
        }
    }

    private static class FloatHandler
    extends Handler {
        private FloatHandler() {
        }

        Object translate(String string) {
            try {
                return Float.valueOf(Float.parseFloat(string));
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
        }
    }

    private static class LongHandler
    extends Handler {
        private LongHandler() {
        }

        Object translate(String string) {
            try {
                return Long.parseLong(string);
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
        }
    }

    private static class IntegerHandler
    extends Handler {
        private IntegerHandler() {
        }

        Object translate(String string) {
            try {
                return Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
        }
    }

    private static class ShortHandler
    extends Handler {
        private ShortHandler() {
        }

        Object translate(String string) {
            try {
                return Short.parseShort(string);
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
        }
    }

    private static class ByteHandler
    extends Handler {
        private ByteHandler() {
        }

        Object translate(String string) {
            try {
                return Byte.parseByte(string);
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
        }
    }

    private static class BooleanHandler
    extends Handler {
        private BooleanHandler() {
        }

        boolean isBoolean() {
            return true;
        }

        Object translate(String string) {
            if (string.equalsIgnoreCase("true") || string.equalsIgnoreCase("yes")) {
                return Boolean.TRUE;
            }
            if (string.equalsIgnoreCase("false") || string.equalsIgnoreCase("no")) {
                return Boolean.FALSE;
            }
            return null;
        }
    }

    private static abstract class Handler {
        private Handler() {
        }

        boolean isBoolean() {
            return false;
        }

        abstract Object translate(String var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class OptionFieldsForName
    implements Iterable<Map.Entry<Object, Field>> {
        private Map<Object, Field> mSourceFieldMap = new HashMap<Object, Field>();

        private OptionFieldsForName() {
        }

        void addField(String string, Object object, Field field) throws ConfigurationException {
            Handler handler;
            Handler handler2;
            if (this.size() > 0 && !(handler2 = OptionSetter.getHandler(this.getFirstField().getType())).equals(handler = OptionSetter.getHandler(field.getType()))) {
                throw new ConfigurationException(String.format("@Option field with name '%s' in class '%s' is defined with a different type than same option in class '%s'", string, object.getClass().getName(), this.getFirstObject().getClass().getName()));
            }
            if (this.mSourceFieldMap.put(object, field) != null) {
                throw new ConfigurationException(String.format("@Option field with name '%s' is defined more than once in class '%s'", string, object.getClass().getName()));
            }
        }

        public int size() {
            return this.mSourceFieldMap.size();
        }

        public Field getFirstField() throws ConfigurationException {
            if (this.size() <= 0) {
                throw new ConfigurationException("no option fields found");
            }
            return this.mSourceFieldMap.values().iterator().next();
        }

        public Object getFirstObject() throws ConfigurationException {
            if (this.size() <= 0) {
                throw new ConfigurationException("no option fields found");
            }
            return this.mSourceFieldMap.keySet().iterator().next();
        }

        @Override
        public Iterator<Map.Entry<Object, Field>> iterator() {
            return this.mSourceFieldMap.entrySet().iterator();
        }
    }
}

