/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.config;

import com.android.ddmlib.Log;
import com.android.tradefed.config.Configuration;
import com.android.tradefed.config.ConfigurationDef;
import com.android.tradefed.config.ConfigurationException;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

class ConfigurationXmlParser {
    private static final String LOG_TAG = "ConfigurationDef";

    ConfigurationXmlParser() {
    }

    ConfigurationDef parse(String string, InputStream inputStream) throws ConfigurationException {
        try {
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            sAXParserFactory.setNamespaceAware(true);
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            ConfigHandler configHandler = new ConfigHandler(string);
            sAXParser.parse(new InputSource(inputStream), (DefaultHandler)configHandler);
            return configHandler.getParsedDef();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            this.throwConfigException(string, parserConfigurationException);
        }
        catch (SAXException sAXException) {
            this.throwConfigException(string, sAXException);
        }
        catch (IOException iOException) {
            this.throwConfigException(string, iOException);
        }
        throw new ConfigurationException("should never reach here");
    }

    private void throwConfigException(String string, Throwable throwable) throws ConfigurationException {
        if (throwable.getCause() instanceof ConfigurationException) {
            throw (ConfigurationException)throwable.getCause();
        }
        throw new ConfigurationException(String.format("Failed to parse config xml '%s'", string), throwable);
    }

    private static class ConfigHandler
    extends DefaultHandler {
        private static final String OBJECT_TAG = "object";
        private static final String OPTION_TAG = "option";
        private static final Object CONFIG_TAG = "configuration";
        private ConfigurationDef mConfigDef;

        ConfigHandler(String string) {
            this.mConfigDef = new ConfigurationDef(string);
        }

        ConfigurationDef getParsedDef() {
            return this.mConfigDef;
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            if (OBJECT_TAG.equals(string2)) {
                String string4 = attributes.getValue("name");
                this.addObject(string4, attributes);
            } else if (Configuration.isBuiltInObjType(string2)) {
                this.addObject(string2, attributes);
            } else if (OPTION_TAG.equals(string2)) {
                String string5;
                String string6 = attributes.getValue("name");
                if (string6 == null) {
                    this.throwException("Missing 'name' attribute for option");
                }
                if ((string5 = attributes.getValue("value")) == null) {
                    this.throwException("Missing 'value' attribute for option");
                }
                this.mConfigDef.addOptionDef(string6, string5);
            } else if (CONFIG_TAG.equals(string2)) {
                String string7 = attributes.getValue("description");
                if (string7 != null) {
                    this.mConfigDef.setDescription(string7);
                }
            } else {
                Log.w((String)ConfigurationXmlParser.LOG_TAG, (String)String.format("Unrecognized tag '%s' in configuration", string2));
            }
        }

        void addObject(String string, Attributes attributes) throws SAXException {
            String string2 = attributes.getValue("class");
            if (string2 == null) {
                this.throwException(String.format("Missing class attribute for object %s", string));
            }
            this.mConfigDef.addConfigObjectDef(string, string2);
        }

        private void throwException(String string) throws SAXException {
            throw new SAXException(new ConfigurationException(String.format("Failed to parse config xml '%s'. Reason: %s", this.mConfigDef.getName(), string)));
        }
    }
}

