/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.config;

import com.android.ddmlib.Log;
import com.android.tradefed.config.ConfigurationDef;
import com.android.tradefed.config.ConfigurationException;
import com.android.tradefed.config.ConfigurationXmlParser;
import com.android.tradefed.config.IConfiguration;
import com.android.tradefed.config.IConfigurationFactory;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Map;

public class ConfigurationFactory
implements IConfigurationFactory {
    private static final String LOG_TAG = "ConfigurationFactory";
    private static IConfigurationFactory sInstance = null;
    static final String INSTRUMENT_CONFIG = "instrument";
    static final String HOST_TEST_CONFIG = "host";
    static final String TEST_DEF_CONFIG = "testdef";
    static final String[] sDefaultConfigs = new String[]{"instrument", "host", "testdef"};
    private Map<String, ConfigurationDef> mConfigDefMap = new Hashtable<String, ConfigurationDef>();

    private ConfigurationFactory() {
    }

    public static IConfigurationFactory getInstance() {
        if (sInstance == null) {
            sInstance = new ConfigurationFactory();
        }
        return sInstance;
    }

    private ConfigurationDef getConfigurationDef(String string) throws ConfigurationException {
        ConfigurationDef configurationDef = this.mConfigDefMap.get(string);
        if (configurationDef == null) {
            configurationDef = this.loadConfiguration(string);
            this.mConfigDefMap.put(string, configurationDef);
        }
        return configurationDef;
    }

    private ConfigurationDef loadConfiguration(String string) throws ConfigurationException {
        Log.i((String)LOG_TAG, (String)String.format("Loading configuration '%s'", string));
        InputStream inputStream = this.getClass().getResourceAsStream(String.format("/config/%s.xml", string));
        if (inputStream == null) {
            try {
                inputStream = new FileInputStream(string);
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new ConfigurationException(String.format("Could not find configuration '%s'", string));
            }
        }
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
        ConfigurationXmlParser configurationXmlParser = new ConfigurationXmlParser();
        return configurationXmlParser.parse(string, bufferedInputStream);
    }

    public IConfiguration createConfigurationFromArgs(String[] stringArray) throws ConfigurationException {
        if (stringArray.length == 0) {
            throw new ConfigurationException("Configuration to run was not specified");
        }
        ArrayList<String> arrayList = new ArrayList<String>(stringArray.length);
        arrayList.addAll(Arrays.asList(stringArray));
        String string = (String)arrayList.remove(arrayList.size() - 1);
        ConfigurationDef configurationDef = this.getConfigurationDef(string);
        IConfiguration iConfiguration = configurationDef.createConfiguration();
        iConfiguration.setOptionsFromCommandLineArgs(arrayList);
        return iConfiguration;
    }

    public void printHelp(PrintStream printStream) {
        printStream.println("Use --help <configuration_name> to get list of options for a configuration");
        printStream.println();
        printStream.println("See the res/config folder for available configurations.");
        printStream.println("Some available configurations include:");
        this.loadDefaultConfigs();
        for (ConfigurationDef configurationDef : this.mConfigDefMap.values()) {
            printStream.printf("  %s: %s", configurationDef.getName(), configurationDef.getDescription());
            printStream.println();
        }
    }

    private void loadDefaultConfigs() {
        for (String string : sDefaultConfigs) {
            try {
                this.getConfigurationDef(string);
            }
            catch (ConfigurationException configurationException) {
                Log.w((String)LOG_TAG, (String)String.format("Could not load default config with name '%s'", string));
            }
        }
    }
}

