/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.config;

import com.android.tradefed.config.Configuration;
import com.android.tradefed.config.ConfigurationException;
import com.android.tradefed.config.IConfiguration;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurationDef {
    private final Map<String, List<String>> mObjectClassMap;
    private final List<OptionDef> mOptionList;
    private final String mName;
    private String mDescription = "";

    public ConfigurationDef(String string) {
        this.mName = string;
        this.mObjectClassMap = new LinkedHashMap<String, List<String>>();
        this.mOptionList = new ArrayList<OptionDef>();
    }

    public String getDescription() {
        return this.mDescription;
    }

    void setDescription(String string) {
        this.mDescription = string;
    }

    void addConfigObjectDef(String string, String string2) {
        List<String> list = this.mObjectClassMap.get(string);
        if (list == null) {
            list = new ArrayList<String>();
            this.mObjectClassMap.put(string, list);
        }
        list.add(string2);
    }

    void addOptionDef(String string, String string2) {
        this.mOptionList.add(new OptionDef(string, string2));
    }

    Map<String, List<String>> getObjectClassMap() {
        return this.mObjectClassMap;
    }

    List<OptionDef> getOptionList() {
        return this.mOptionList;
    }

    IConfiguration createConfiguration() throws ConfigurationException {
        Configuration configuration = new Configuration(this.getName(), this.getDescription());
        for (Map.Entry<String, List<String>> object : this.mObjectClassMap.entrySet()) {
            ArrayList<Object> arrayList = new ArrayList<Object>(object.getValue().size());
            for (String string : object.getValue()) {
                Object object2 = this.createObject(object.getKey(), string);
                arrayList.add(object2);
            }
            configuration.setConfigurationObjectList(object.getKey(), arrayList);
        }
        for (OptionDef optionDef : this.mOptionList) {
            configuration.injectOptionValue(optionDef.name, optionDef.value);
        }
        return configuration;
    }

    public String getName() {
        return this.mName;
    }

    private Object createObject(String string, String string2) throws ConfigurationException {
        try {
            Class<?> clazz = this.getClassForObject(string, string2);
            Object obj = clazz.newInstance();
            return obj;
        }
        catch (InstantiationException instantiationException) {
            throw new ConfigurationException(String.format("Could not instantiate class %s for config object name %s", string2, string), instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new ConfigurationException(String.format("Could not access class %s for config object name %s", string2, string), illegalAccessException);
        }
    }

    private Class<?> getClassForObject(String string, String string2) throws ConfigurationException {
        try {
            return Class.forName(string2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ConfigurationException(String.format("Could not find class %s for config object name %s", string2, string), classNotFoundException);
        }
    }

    static class OptionDef {
        final String name;
        final String value;

        OptionDef(String string, String string2) {
            this.name = string;
            this.value = string2;
        }
    }
}

