/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.config;

import com.android.tradefed.build.IBuildProvider;
import com.android.tradefed.build.StubBuildProvider;
import com.android.tradefed.command.CommandOptions;
import com.android.tradefed.command.ICommandOptions;
import com.android.tradefed.config.ArgsOptionParser;
import com.android.tradefed.config.ConfigurationException;
import com.android.tradefed.config.IConfiguration;
import com.android.tradefed.config.IConfigurationReceiver;
import com.android.tradefed.config.OptionSetter;
import com.android.tradefed.device.DeviceSelectionOptions;
import com.android.tradefed.device.IDeviceRecovery;
import com.android.tradefed.device.IDeviceSelectionOptions;
import com.android.tradefed.device.WaitDeviceRecovery;
import com.android.tradefed.log.ILeveledLogOutput;
import com.android.tradefed.log.StdoutLogger;
import com.android.tradefed.result.ITestInvocationListener;
import com.android.tradefed.result.TextResultReporter;
import com.android.tradefed.targetprep.ITargetPreparer;
import com.android.tradefed.targetprep.StubTargetPreparer;
import com.android.tradefed.testtype.IRemoteTest;
import com.android.tradefed.testtype.StubTest;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Configuration
implements IConfiguration {
    public static final String BUILD_PROVIDER_NAME = "build_provider";
    public static final String TARGET_PREPARER_NAME = "target_preparer";
    public static final String TEST_NAME = "test";
    public static final String DEVICE_RECOVERY_NAME = "device_recovery";
    public static final String LOGGER_NAME = "logger";
    public static final String RESULT_REPORTER_NAME = "result_reporter";
    public static final String CMD_OPTIONS_NAME = "cmd_options";
    public static final String DEVICE_OPTIONS_NAME = "device_options";
    private static Map<String, ObjTypeInfo> sObjTypeMap = null;
    private Map<String, List<Object>> mConfigMap;
    private final String mName;
    private final String mDescription;

    static boolean isBuiltInObjType(String string) {
        return Configuration.getObjTypeMap().containsKey(string);
    }

    private static synchronized Map<String, ObjTypeInfo> getObjTypeMap() {
        if (sObjTypeMap == null) {
            sObjTypeMap = new HashMap<String, ObjTypeInfo>();
            sObjTypeMap.put(BUILD_PROVIDER_NAME, new ObjTypeInfo(IBuildProvider.class, false));
            sObjTypeMap.put(TARGET_PREPARER_NAME, new ObjTypeInfo(ITargetPreparer.class, true));
            sObjTypeMap.put(TEST_NAME, new ObjTypeInfo(IRemoteTest.class, true));
            sObjTypeMap.put(DEVICE_RECOVERY_NAME, new ObjTypeInfo(IDeviceRecovery.class, false));
            sObjTypeMap.put(LOGGER_NAME, new ObjTypeInfo(ILeveledLogOutput.class, false));
            sObjTypeMap.put(RESULT_REPORTER_NAME, new ObjTypeInfo(ITestInvocationListener.class, true));
            sObjTypeMap.put(CMD_OPTIONS_NAME, new ObjTypeInfo(ICommandOptions.class, false));
            sObjTypeMap.put(DEVICE_OPTIONS_NAME, new ObjTypeInfo(IDeviceSelectionOptions.class, false));
        }
        return sObjTypeMap;
    }

    public Configuration(String string, String string2) {
        this.mName = string;
        this.mDescription = string2;
        this.mConfigMap = new LinkedHashMap<String, List<Object>>();
        this.setCommandOptions(new CommandOptions());
        this.setDeviceSelectionOptions(new DeviceSelectionOptions());
        this.setBuildProvider(new StubBuildProvider());
        this.setTargetPreparer(new StubTargetPreparer());
        this.setTest(new StubTest());
        this.setDeviceRecovery(new WaitDeviceRecovery());
        this.setLogOutput(new StdoutLogger());
        this.setTestInvocationListener(new TextResultReporter());
    }

    public String getName() {
        return this.mName;
    }

    public String getDescription() {
        return this.mDescription;
    }

    @Override
    public IBuildProvider getBuildProvider() {
        return (IBuildProvider)this.getConfigurationObject(BUILD_PROVIDER_NAME);
    }

    @Override
    public List<ITargetPreparer> getTargetPreparers() {
        return this.getConfigurationObjectList(TARGET_PREPARER_NAME);
    }

    @Override
    public List<IRemoteTest> getTests() {
        return this.getConfigurationObjectList(TEST_NAME);
    }

    @Override
    public IDeviceRecovery getDeviceRecovery() {
        return (IDeviceRecovery)this.getConfigurationObject(DEVICE_RECOVERY_NAME);
    }

    @Override
    public ILeveledLogOutput getLogOutput() {
        return (ILeveledLogOutput)this.getConfigurationObject(LOGGER_NAME);
    }

    @Override
    public List<ITestInvocationListener> getTestInvocationListeners() {
        return this.getConfigurationObjectList(RESULT_REPORTER_NAME);
    }

    @Override
    public ICommandOptions getCommandOptions() {
        return (ICommandOptions)this.getConfigurationObject(CMD_OPTIONS_NAME);
    }

    @Override
    public IDeviceSelectionOptions getDeviceSelectionOptions() {
        return (IDeviceSelectionOptions)this.getConfigurationObject(DEVICE_OPTIONS_NAME);
    }

    @Override
    public List<?> getConfigurationObjectList(String string) {
        return this.mConfigMap.get(string);
    }

    @Override
    public Object getConfigurationObject(String string) {
        List<?> list = this.getConfigurationObjectList(string);
        if (list == null) {
            return null;
        }
        ObjTypeInfo objTypeInfo = Configuration.getObjTypeMap().get(string);
        if (objTypeInfo != null && objTypeInfo.mIsListSupported) {
            throw new IllegalStateException(String.format("Wrong method call. Used getConfigurationObject() for a config object that is stored as a list", string));
        }
        if (list.size() != 1) {
            throw new IllegalStateException(String.format("Attempted to retrieve single object for %s, but %d are present", string, list.size()));
        }
        return list.get(0);
    }

    private Collection<Object> getAllConfigurationObjects() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (List<Object> list : this.mConfigMap.values()) {
            arrayList.addAll(list);
        }
        return arrayList;
    }

    @Override
    public void injectOptionValue(String string, String string2) throws ConfigurationException {
        OptionSetter optionSetter = new OptionSetter(this.getAllConfigurationObjects());
        optionSetter.setOptionValue(string, string2);
    }

    @Override
    public Configuration clone() {
        Configuration configuration = new Configuration(this.getName(), this.getDescription());
        for (Map.Entry<String, List<Object>> entry : this.mConfigMap.entrySet()) {
            configuration.setConfigurationObjectListNoThrow(entry.getKey(), entry.getValue());
        }
        return configuration;
    }

    @Override
    public void setBuildProvider(IBuildProvider iBuildProvider) {
        this.setConfigurationObjectNoThrow(BUILD_PROVIDER_NAME, iBuildProvider);
    }

    @Override
    public void setTestInvocationListeners(List<ITestInvocationListener> list) {
        this.setConfigurationObjectListNoThrow(RESULT_REPORTER_NAME, list);
    }

    @Override
    public void setTestInvocationListener(ITestInvocationListener iTestInvocationListener) {
        this.setConfigurationObjectNoThrow(RESULT_REPORTER_NAME, iTestInvocationListener);
    }

    @Override
    public void setTest(IRemoteTest iRemoteTest) {
        this.setConfigurationObjectNoThrow(TEST_NAME, iRemoteTest);
    }

    @Override
    public void setTests(List<IRemoteTest> list) {
        this.setConfigurationObjectListNoThrow(TEST_NAME, list);
    }

    @Override
    public void setLogOutput(ILeveledLogOutput iLeveledLogOutput) {
        this.setConfigurationObjectNoThrow(LOGGER_NAME, iLeveledLogOutput);
    }

    @Override
    public void setDeviceRecovery(IDeviceRecovery iDeviceRecovery) {
        this.setConfigurationObjectNoThrow(DEVICE_RECOVERY_NAME, iDeviceRecovery);
    }

    @Override
    public void setTargetPreparer(ITargetPreparer iTargetPreparer) {
        this.setConfigurationObjectNoThrow(TARGET_PREPARER_NAME, iTargetPreparer);
    }

    @Override
    public void setCommandOptions(ICommandOptions iCommandOptions) {
        this.setConfigurationObjectNoThrow(CMD_OPTIONS_NAME, iCommandOptions);
    }

    @Override
    public void setDeviceSelectionOptions(IDeviceSelectionOptions iDeviceSelectionOptions) {
        this.setConfigurationObjectNoThrow(DEVICE_OPTIONS_NAME, iDeviceSelectionOptions);
    }

    @Override
    public void setConfigurationObject(String string, Object object) throws ConfigurationException {
        if (object == null) {
            throw new IllegalArgumentException("configObject cannot be null");
        }
        this.mConfigMap.remove(string);
        this.addObject(string, object);
    }

    @Override
    public void setConfigurationObjectList(String string, List<?> list) throws ConfigurationException {
        if (list == null) {
            throw new IllegalArgumentException("configList cannot be null");
        }
        this.mConfigMap.remove(string);
        for (Object obj : list) {
            this.addObject(string, obj);
        }
    }

    private void addObject(String string, Object object) throws ConfigurationException {
        ObjTypeInfo objTypeInfo;
        List<Object> list = this.mConfigMap.get(string);
        if (list == null) {
            list = new ArrayList<Object>(1);
            this.mConfigMap.put(string, list);
        }
        if ((objTypeInfo = Configuration.getObjTypeMap().get(string)) != null && !objTypeInfo.mExpectedType.isInstance(object)) {
            throw new ConfigurationException(String.format("The config object %s is not the correct type. Expected %s, received %s", string, objTypeInfo.mExpectedType.getCanonicalName(), object.getClass().getCanonicalName()));
        }
        if (objTypeInfo != null && !objTypeInfo.mIsListSupported && list.size() > 0) {
            throw new ConfigurationException(String.format("Only one config object allowed for %s, but multiple were specified.", string));
        }
        list.add(object);
        if (object instanceof IConfigurationReceiver) {
            ((IConfigurationReceiver)object).setConfiguration(this);
        }
    }

    private void setConfigurationObjectNoThrow(String string, Object object) {
        try {
            this.setConfigurationObject(string, object);
        }
        catch (ConfigurationException configurationException) {
            throw new IllegalArgumentException(configurationException);
        }
    }

    private void setConfigurationObjectListNoThrow(String string, List<?> list) {
        try {
            this.setConfigurationObjectList(string, list);
        }
        catch (ConfigurationException configurationException) {
            throw new IllegalArgumentException(configurationException);
        }
    }

    @Override
    public void setOptionsFromCommandLineArgs(List<String> list) throws ConfigurationException {
        ArgsOptionParser argsOptionParser = new ArgsOptionParser(this.getAllConfigurationObjects());
        List<String> list2 = argsOptionParser.parse(list);
        if (list2.size() > 0) {
            throw new ConfigurationException(String.format("Invalid arguments provided. Unprocessed arguments: %s", list2));
        }
    }

    @Override
    public void printCommandUsage(PrintStream printStream) throws ConfigurationException {
        printStream.println("Usage: [options] <configuration_name OR configuration xml file path>");
        printStream.println();
        printStream.println(String.format("'%s' configuration: %s", this.getName(), this.getDescription()));
        printStream.println();
        for (Map.Entry<String, List<Object>> entry : this.mConfigMap.entrySet()) {
            for (Object object : entry.getValue()) {
                String string = this.printOptionsForObject(entry.getKey(), object);
                if (string.length() <= 0) continue;
                printStream.printf("  %s options:", entry.getKey());
                printStream.println();
                printStream.print(string);
                printStream.println();
            }
        }
    }

    private String printOptionsForObject(String string, Object object) throws ConfigurationException {
        return ArgsOptionParser.getOptionHelp(object.getClass());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ObjTypeInfo {
        final Class<?> mExpectedType;
        final boolean mIsListSupported;

        ObjTypeInfo(Class<?> clazz, boolean bl) {
            this.mExpectedType = clazz;
            this.mIsListSupported = bl;
        }
    }
}

