/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.config;

import com.android.tradefed.config.ConfigurationException;
import com.android.tradefed.config.Option;
import com.android.tradefed.config.OptionSetter;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArgsOptionParser
extends OptionSetter {
    static final String SHORT_NAME_PREFIX = "-";
    static final String OPTION_NAME_PREFIX = "--";

    public ArgsOptionParser(Collection<Object> collection) throws ConfigurationException {
        super(collection);
    }

    public ArgsOptionParser(Object ... objectArray) throws ConfigurationException {
        super(objectArray);
    }

    public List<String> parse(String ... stringArray) throws ConfigurationException {
        return this.parse(Arrays.asList(stringArray));
    }

    public List<String> parse(List<String> list) throws ConfigurationException {
        return this.parseOptions(list.listIterator());
    }

    private List<String> parseOptions(ListIterator<String> listIterator) throws ConfigurationException {
        String string;
        ArrayList<String> arrayList = new ArrayList<String>();
        while (listIterator.hasNext() && !(string = listIterator.next()).equals(OPTION_NAME_PREFIX)) {
            if (string.startsWith(OPTION_NAME_PREFIX)) {
                this.parseLongOption(string, listIterator);
                continue;
            }
            if (string.startsWith(SHORT_NAME_PREFIX)) {
                this.parseGroupedShortOptions(string, listIterator);
                continue;
            }
            arrayList.add(string);
            break;
        }
        while (listIterator.hasNext()) {
            arrayList.add(listIterator.next());
        }
        return arrayList;
    }

    private void parseLongOption(String string, ListIterator<String> listIterator) throws ConfigurationException {
        String string2 = string.replaceFirst("^--", "");
        String string3 = null;
        int n = string2.indexOf(61);
        if (n != -1) {
            string3 = string2.substring(n + 1);
            string2 = string2.substring(0, n);
        }
        if (string3 == null) {
            string3 = this.isBooleanOption(string2) ? (string2.startsWith("no-") ? "false" : "true") : this.grabNextValue(listIterator, string2);
        }
        this.setOptionValue(string2, string3);
    }

    private void parseGroupedShortOptions(String string, ListIterator<String> listIterator) throws ConfigurationException {
        for (int i = 1; i < string.length(); ++i) {
            String string2;
            String string3 = String.valueOf(string.charAt(i));
            if (this.isBooleanOption(string3)) {
                string2 = "true";
            } else if (i + 1 < string.length()) {
                string2 = string.substring(i + 1);
                i = string.length() - 1;
            } else {
                string2 = this.grabNextValue(listIterator, string3);
            }
            this.setOptionValue(string3, string2);
        }
    }

    private String grabNextValue(ListIterator<String> listIterator, String string) throws ConfigurationException {
        if (!listIterator.hasNext()) {
            String string2 = this.getTypeForOption(string);
            throw new ConfigurationException(String.format("option '%s' requires a '%s' argument", string, string2));
        }
        return listIterator.next();
    }

    public static String getOptionHelp(Class<?> clazz) {
        StringBuilder stringBuilder = new StringBuilder();
        Collection<Field> collection = OptionSetter.getOptionFieldsForClass(clazz);
        String string = System.getProperty("line.separator");
        for (Field field : collection) {
            String string2 = "";
            try {
                if (OptionSetter.isBooleanField(field)) {
                    string2 = "[no-]";
                }
            }
            catch (ConfigurationException configurationException) {
                // empty catch block
            }
            Option option = field.getAnnotation(Option.class);
            stringBuilder.append(String.format("    %s%s%s: %s", OPTION_NAME_PREFIX, string2, option.name(), option.description()));
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }
}

