/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.command;

import com.android.ddmlib.DdmPreferences;
import com.android.ddmlib.Log;
import com.android.tradefed.command.CommandFileParser;
import com.android.tradefed.command.CommandScheduler;
import com.android.tradefed.command.ICommandScheduler;
import com.android.tradefed.config.ConfigurationException;
import com.android.tradefed.device.DeviceManager;
import com.android.tradefed.device.IDeviceManager;
import com.android.tradefed.invoker.ITestInvocation;
import com.android.tradefed.log.LogRegistry;
import com.android.tradefed.util.QuotationAwareTokenizer;
import com.android.tradefed.util.RegexTrie;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Console {
    private static final String LOG_TAG = "Console";
    private static final String CONSOLE_PROMPT = "tf >";
    protected static final String HELP_PATTERN = "\\?|h|help";
    protected static final String LIST_PATTERN = "l(?:ist)?";
    protected static final String DUMP_PATTERN = "d(?:ump)?";
    protected static final String RUN_PATTERN = "r(?:un)?";
    protected static final String EXIT_PATTERN = "(?:q|exit)";
    protected static final String SET_PATTERN = "s(?:et)?";
    protected static final String DEBUG_PATTERN = "debug";
    protected static final String LINE_SEPARATOR = System.getProperty("line.separator");
    protected ICommandScheduler mScheduler;
    protected java.io.Console mTerminal;
    private RegexTrie<Runnable> mCommandTrie = new RegexTrie();
    private boolean mShouldExit = false;

    protected Console() {
        this(new CommandScheduler());
    }

    Console(ICommandScheduler iCommandScheduler) {
        this.mScheduler = iCommandScheduler;
        this.mTerminal = System.console();
        LinkedList<String> linkedList = new LinkedList<String>();
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        this.addDefaultCommands(this.mCommandTrie, linkedList, linkedHashMap);
        this.setCustomCommands(this.mCommandTrie, linkedList, linkedHashMap);
        this.generateHelpListings(this.mCommandTrie, linkedList, linkedHashMap);
    }

    protected void setCustomCommands(RegexTrie<Runnable> regexTrie, List<String> list, Map<String, String> map) {
    }

    void generateHelpListings(RegexTrie<Runnable> regexTrie, List<String> list, Map<String, String> map) {
        final String string = Console.join(list);
        final ArgRunnable<CaptureList> argRunnable = new ArgRunnable<CaptureList>(){

            @Override
            public void run(CaptureList captureList) {
                Console.this.mTerminal.printf(string, new Object[0]);
            }
        };
        regexTrie.put((Runnable)argRunnable, HELP_PATTERN);
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String string2 = entry.getKey();
            final String string3 = entry.getValue();
            regexTrie.put(new Runnable(){

                public void run() {
                    Console.this.mTerminal.printf(string3, new Object[0]);
                }
            }, HELP_PATTERN, string2);
        }
        regexTrie.put((Runnable)new ArgRunnable<CaptureList>(){

            @Override
            public void run(CaptureList captureList) {
                Console.this.printLine(String.format("No help for '%s'; command is unknown or undocumented", ((List)captureList.get(1)).get(0)));
                argRunnable.run(captureList);
            }
        }, HELP_PATTERN, null);
        regexTrie.put((Runnable)new ArgRunnable<CaptureList>(){

            @Override
            public void run(CaptureList captureList) {
                if (captureList.isEmpty()) {
                    return;
                }
                Console.this.printLine(String.format("Unknown command: '%s'", ((List)captureList.get(0)).get(0)));
                argRunnable.run(captureList);
            }
        }, new Pattern[]{null});
    }

    void addDefaultCommands(RegexTrie<Runnable> regexTrie, List<String> list, Map<String, String> map) {
        list.add("Enter 'q' or 'exit' to exit");
        list.add("Enter 'kill' to attempt to forcibly exit, by shutting down adb");
        list.add("");
        list.add("Enter 'help list'  for help with 'list' commands");
        list.add("Enter 'help run'   for help with 'run' commands");
        list.add("Enter 'help dump'  for help with 'dump' commands");
        list.add("Enter 'help set'   for help with 'set' commands");
        list.add("Enter 'help debug' for help with 'debug' commands");
        map.put(LIST_PATTERN, String.format("%s help:" + LINE_SEPARATOR + "\ti[nvocations]  List all invocation threads" + LINE_SEPARATOR + "\td[evices]      List all detected or known devices" + LINE_SEPARATOR + "\tc[ommands]     List all commands currently waiting to be executed" + LINE_SEPARATOR, LIST_PATTERN));
        map.put(DUMP_PATTERN, String.format("%s help:" + LINE_SEPARATOR + "\ts[tack]  Dump the stack traces of all threads" + LINE_SEPARATOR + "\tl[ogs]   Dump the logs of all invocations to files" + LINE_SEPARATOR, DUMP_PATTERN));
        map.put(RUN_PATTERN, String.format("%s help:" + LINE_SEPARATOR + "\tcommand [options] <config>        Run the specified command" + LINE_SEPARATOR + "\tcmdfile <cmdfile.txt>             Run the specified commandfile" + LINE_SEPARATOR + "\tsingleCommand [options] <config>  Run the specified command, and run 'exit' " + "immediately afterward" + LINE_SEPARATOR, RUN_PATTERN));
        map.put(SET_PATTERN, String.format("%s help:" + LINE_SEPARATOR + "\tlog-level-display <level>     Sets the global display log level to <level>" + LINE_SEPARATOR, SET_PATTERN));
        map.put(DEBUG_PATTERN, String.format("%s help:" + LINE_SEPARATOR + "\tgc      Attempt to force a GC" + LINE_SEPARATOR, DEBUG_PATTERN));
        regexTrie.put((Runnable)new QuitRunnable(), EXIT_PATTERN);
        regexTrie.put((Runnable)new ForceQuitRunnable(), "kill");
        regexTrie.put(new Runnable(){

            public void run() {
                Collection<ITestInvocation> collection = Console.this.mScheduler.listInvocations();
                int n = 1;
                for (ITestInvocation iTestInvocation : collection) {
                    Console.this.printLine(String.format("Invocation %d: %s", n++, iTestInvocation));
                }
            }
        }, LIST_PATTERN, "i(?:nvocations)?");
        regexTrie.put(new Runnable(){

            public void run() {
                IDeviceManager iDeviceManager = DeviceManager.getInstance();
                Collection<String> collection = null;
                collection = iDeviceManager.getAvailableDevices();
                Console.this.printLine(String.format("Available devices:   %s", collection));
                collection = iDeviceManager.getUnavailableDevices();
                Console.this.printLine(String.format("Unavailable devices: %s", collection));
                collection = iDeviceManager.getAllocatedDevices();
                Console.this.printLine(String.format("Allocated devices:   %s", collection));
            }
        }, LIST_PATTERN, "d(?:evices)?");
        regexTrie.put(new Runnable(){

            public void run() {
                Collection<String> collection = Console.this.mScheduler.listCommands();
                int n = 1;
                for (String string : collection) {
                    Console.this.printLine(String.format("Command %d: %s", n++, string));
                }
            }
        }, LIST_PATTERN, "c(?:ommands)?");
        regexTrie.put(new Runnable(){

            public void run() {
                Console.this.dumpStacks();
            }
        }, DUMP_PATTERN, "s(?:tacks?)?");
        regexTrie.put(new Runnable(){

            public void run() {
                Console.this.dumpLogs();
            }
        }, DUMP_PATTERN, "l(?:ogs?)?");
        ArgRunnable<CaptureList> argRunnable = new ArgRunnable<CaptureList>(){

            @Override
            public void run(CaptureList captureList) {
                String[] stringArray = new String[captureList.size() - 2];
                for (int i = 2; i < captureList.size(); ++i) {
                    stringArray[i - 2] = (String)((List)captureList.get(i)).get(0);
                }
                Console.this.mScheduler.addCommand(stringArray);
            }
        };
        regexTrie.put((Runnable)argRunnable, RUN_PATTERN, "(?:singleC|c)ommand", null);
        ArgRunnable<CaptureList> argRunnable2 = new ArgRunnable<CaptureList>(){

            @Override
            public void run(CaptureList captureList) {
                String string = (String)((List)captureList.get(2)).get(0);
                Console.this.printLine(String.format("Attempting to run cmdfile %s", string));
                try {
                    Console.this.createCommandFileParser().parseFile(new File(string), Console.this.mScheduler);
                }
                catch (IOException iOException) {
                    Console.this.printLine(String.format("Failed to run %s: %s", string, iOException));
                }
                catch (ConfigurationException configurationException) {
                    Console.this.printLine(String.format("Failed to run %s: %s", string, configurationException));
                }
            }
        };
        regexTrie.put((Runnable)argRunnable2, RUN_PATTERN, "cmdfile", "(.*)");
        ArgRunnable<CaptureList> argRunnable3 = new ArgRunnable<CaptureList>(){

            @Override
            public void run(CaptureList captureList) {
                String string = (String)((List)captureList.get(2)).get(0);
                String string2 = LogRegistry.getLogRegistry().getGlobalLogDisplayLevel();
                if (Log.LogLevel.getByString((String)string) != null) {
                    LogRegistry.getLogRegistry().setGlobalLogDisplayLevel(string);
                    string2 = LogRegistry.getLogRegistry().getGlobalLogDisplayLevel();
                    if (string2 != null) {
                        Console.this.printLine(String.format("Current logging set to '%s'.", string2));
                    }
                } else if (string2 == null) {
                    Console.this.printLine(String.format("Invalid log level '%s'.", string));
                } else {
                    Console.this.printLine(String.format("Invalid log level '%s'; log level remains at '%s'.", string, string2));
                }
            }
        };
        regexTrie.put((Runnable)argRunnable3, SET_PATTERN, "log-level-display", "(.*)");
        regexTrie.put(new Runnable(){

            public void run() {
                System.gc();
            }
        }, DEBUG_PATTERN, "gc");
    }

    private static String join(List<String> list) {
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : list) {
            stringBuilder.append(string);
            stringBuilder.append(LINE_SEPARATOR);
        }
        return stringBuilder.toString();
    }

    void setTerminal(java.io.Console console) {
        this.mTerminal = console;
    }

    private String getConsoleInput() throws IOException {
        String string = this.mTerminal.readLine(CONSOLE_PROMPT, new Object[0]);
        return string;
    }

    protected void printLine(String string) {
        this.mTerminal.printf("%s%s", string, LINE_SEPARATOR);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run(String[] stringArray) {
        this.initLogging();
        LinkedList<String> linkedList = new LinkedList<String>(Arrays.asList(stringArray));
        try {
            try {
                this.mScheduler.start();
                if (this.mTerminal == null) {
                    Log.logAndDisplay((Log.LogLevel)Log.LogLevel.INFO, (String)LOG_TAG, (String)"Running indefinitely in non-interactive mode.");
                    this.mScheduler.join();
                    this.cleanUp();
                    Object var9_3 = null;
                    this.cleanUp();
                    return;
                }
                String string = "";
                CaptureList captureList = new CaptureList();
                while (!this.mShouldExit) {
                    Runnable runnable;
                    String[] stringArray2;
                    if (linkedList.isEmpty()) {
                        string = this.getConsoleInput();
                        if (string == null) {
                            this.printLine("");
                            this.printLine("Received EOF; quitting...");
                            this.mShouldExit = true;
                            break;
                        }
                        stringArray2 = null;
                        try {
                            stringArray2 = QuotationAwareTokenizer.tokenizeLine(string);
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            this.printLine(String.format("Invalid input: %s.", string));
                            continue;
                        }
                        if (stringArray2 == null || stringArray2.length == 0) {
                            continue;
                        }
                    } else {
                        this.printLine(String.format("Using commandline arguments as starting command: %s", linkedList));
                        stringArray2 = linkedList.toArray(new String[0]);
                        linkedList.clear();
                    }
                    if ((runnable = this.mCommandTrie.retrieve(captureList, stringArray2)) != null) {
                        if (runnable instanceof ArgRunnable) {
                            ((ArgRunnable)runnable).run(captureList);
                        } else {
                            runnable.run();
                        }
                    } else {
                        this.printLine(String.format("Unable to handle command '%s'.  Enter 'help' for help.", stringArray2[0]));
                    }
                    if (stringArray2.length >= 2 && "singleCommand".equals(stringArray2[1])) {
                        try {
                            Thread.sleep(5500L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        this.mShouldExit = true;
                    }
                    Thread.sleep(100L);
                }
                this.mScheduler.shutdown();
                this.mScheduler.join();
            }
            catch (InterruptedException interruptedException) {
                Object var9_5 = null;
                this.cleanUp();
                return;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                Object var9_6 = null;
                this.cleanUp();
                return;
            }
        }
        catch (Throwable throwable) {
            Object var9_7 = null;
            this.cleanUp();
            throw throwable;
        }
        Object var9_4 = null;
        this.cleanUp();
    }

    void initLogging() {
        DdmPreferences.setLogLevel((String)Log.LogLevel.VERBOSE.getStringValue());
        Log.setLogOutput((Log.ILogOutput)LogRegistry.getLogRegistry());
    }

    void cleanUp() {
        LogRegistry.getLogRegistry().closeAndRemoveAllLogs();
    }

    CommandFileParser createCommandFileParser() {
        return new CommandFileParser();
    }

    private void dumpStacks() {
        Map<Thread, StackTraceElement[]> map = Thread.getAllStackTraces();
        for (Map.Entry<Thread, StackTraceElement[]> entry : map.entrySet()) {
            this.dumpThreadStack(entry.getKey(), entry.getValue());
        }
    }

    private void dumpThreadStack(Thread thread, StackTraceElement[] stackTraceElementArray) {
        this.printLine(String.format("%s", thread));
        for (int i = 0; i < stackTraceElementArray.length; ++i) {
            this.printLine(String.format("\t%s", stackTraceElementArray[i]));
        }
        this.printLine("");
    }

    private void dumpLogs() {
        LogRegistry.getLogRegistry().dumpLogs();
    }

    public static void main(String[] stringArray) {
        Console console = new Console();
        console.run(stringArray);
    }

    private class ForceQuitRunnable
    extends QuitRunnable {
        private ForceQuitRunnable() {
        }

        public void run() {
            super.run();
            Console.this.mScheduler.shutdownHard();
        }
    }

    private class QuitRunnable
    implements Runnable {
        private QuitRunnable() {
        }

        public void run() {
            Console.this.mShouldExit = true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static abstract class ArgRunnable<T>
    implements Runnable {
        protected ArgRunnable() {
        }

        @Override
        public void run() {
            this.run(null);
        }

        public abstract void run(T var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class CaptureList
    extends LinkedList<List<String>> {
        CaptureList() {
        }

        CaptureList(Collection<? extends List<String>> collection) {
            super(collection);
        }
    }
}

