/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.command;

import com.android.ddmlib.Log;
import com.android.tradefed.command.FatalHostError;
import com.android.tradefed.command.ICommandOptions;
import com.android.tradefed.command.ICommandScheduler;
import com.android.tradefed.config.ConfigurationException;
import com.android.tradefed.config.ConfigurationFactory;
import com.android.tradefed.config.IConfiguration;
import com.android.tradefed.config.IConfigurationFactory;
import com.android.tradefed.device.DeviceManager;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.DeviceUnresponsiveException;
import com.android.tradefed.device.IDeviceManager;
import com.android.tradefed.device.IDeviceSelectionOptions;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.invoker.IRescheduler;
import com.android.tradefed.invoker.ITestInvocation;
import com.android.tradefed.invoker.TestInvocation;
import com.android.tradefed.util.ConditionPriorityBlockingQueue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandScheduler
extends Thread
implements ICommandScheduler {
    private static final String LOG_TAG = "CommandScheduler";
    private ConditionPriorityBlockingQueue<ConfigCommand> mCommandQueue = new ConditionPriorityBlockingQueue<ConfigCommand>(new ConfigComparator());
    private List<ConfigCommand> mAllCommands = Collections.synchronizedList(new LinkedList());
    private Set<InvocationThread> mInvocationThreads = new HashSet<InvocationThread>();
    private ScheduledThreadPoolExecutor mCommandTimer = new ScheduledThreadPoolExecutor(1);
    private static final int NO_DEVICE_DELAY_TIME = 20;

    CommandScheduler() {
        this.setDaemon(true);
    }

    ITestInvocation createRunInstance() {
        return new TestInvocation();
    }

    IDeviceManager getDeviceManager() {
        return DeviceManager.getInstance();
    }

    IConfigurationFactory getConfigFactory() {
        return ConfigurationFactory.getInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        InvocationThread invocationThread;
        Object object;
        Object object2;
        IDeviceManager iDeviceManager = this.getDeviceManager();
        iDeviceManager.init();
        while (!this.isShutdown()) {
            object2 = this.dequeueConfigCommand();
            if (object2 == null) continue;
            object = iDeviceManager.allocateDevice(0L, ((ConfigCommand)object2).getDeviceOptions());
            if (object != null) {
                invocationThread = this.startInvocation(iDeviceManager, (ITestDevice)object, (ConfigCommand)object2);
                this.addInvocationThread(invocationThread);
                if (!((ConfigCommand)object2).getCommandOptions().isLoopMode()) continue;
                try {
                    ((ConfigCommand)object2).resetConfiguration();
                    this.returnCommandToQueue((ConfigCommand)object2, ((ConfigCommand)object2).getCommandOptions().getMinLoopTime());
                }
                catch (ConfigurationException configurationException) {
                    Log.e((String)LOG_TAG, (Throwable)configurationException);
                }
                continue;
            }
            ((ConfigCommand)object2).incrementExecTime(1L);
            this.returnCommandToQueue((ConfigCommand)object2, 20L);
        }
        Log.i((String)LOG_TAG, (String)"Waiting for invocation threads to complete");
        object = this;
        synchronized (object) {
            object2 = new ArrayList(this.mInvocationThreads.size());
            object2.addAll(this.mInvocationThreads);
        }
        object = object2.iterator();
        while (object.hasNext()) {
            invocationThread = (InvocationThread)object.next();
            this.waitForThread(invocationThread);
        }
        Log.logAndDisplay((Log.LogLevel)Log.LogLevel.INFO, (String)LOG_TAG, (String)"All done");
        this.exit(iDeviceManager);
    }

    private void waitForThread(Thread thread) {
        try {
            thread.join();
        }
        catch (InterruptedException interruptedException) {
            this.waitForThread(thread);
        }
    }

    private void exit(IDeviceManager iDeviceManager) {
        if (iDeviceManager != null) {
            iDeviceManager.terminate();
        }
    }

    @Override
    public void addCommand(String[] stringArray) {
        try {
            ConfigCommand configCommand = new ConfigCommand(stringArray);
            if (configCommand.getCommandOptions().isHelpMode()) {
                configCommand.getConfiguration().printCommandUsage(System.out);
            } else {
                this.mCommandQueue.add(configCommand);
                this.mAllCommands.add(configCommand);
            }
        }
        catch (ConfigurationException configurationException) {
            System.out.println(String.format("Unrecognized arguments: %s", configurationException.getMessage()));
            this.getConfigFactory().printHelp(System.out);
        }
    }

    private ConfigCommand dequeueConfigCommand() {
        try {
            return this.mCommandQueue.poll(this.getCommandPollTimeMs(), TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException interruptedException) {
            Log.i((String)LOG_TAG, (String)"Waiting for command interrupted");
            return null;
        }
    }

    long getCommandPollTimeMs() {
        return 1000L;
    }

    private void returnCommandToQueue(final ConfigCommand configCommand, long l) {
        if (this.isShutdown()) {
            return;
        }
        try {
            if (l > 0L) {
                Runnable runnable = new Runnable(){

                    public void run() {
                        CommandScheduler.this.mCommandQueue.add(configCommand);
                    }
                };
                this.mCommandTimer.schedule(runnable, l, TimeUnit.MILLISECONDS);
            } else {
                this.mCommandQueue.add(configCommand);
            }
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            Log.e((String)LOG_TAG, (Throwable)rejectedExecutionException);
        }
    }

    private String getArgString(String[] stringArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : stringArray) {
            stringBuilder.append(string);
            stringBuilder.append(" ");
        }
        return stringBuilder.toString();
    }

    private InvocationThread startInvocation(IDeviceManager iDeviceManager, ITestDevice iTestDevice, ConfigCommand configCommand) {
        String string = String.format("Invocation-%s", iTestDevice.getSerialNumber());
        InvocationThread invocationThread = new InvocationThread(string, iDeviceManager, iTestDevice, configCommand);
        invocationThread.start();
        return invocationThread;
    }

    private synchronized void removeInvocationThread(InvocationThread invocationThread) {
        this.mInvocationThreads.remove(invocationThread);
    }

    private synchronized void addInvocationThread(InvocationThread invocationThread) {
        this.mInvocationThreads.add(invocationThread);
    }

    private synchronized boolean isShutdown() {
        return this.mCommandTimer.isTerminated();
    }

    @Override
    public synchronized void shutdown() {
        if (!this.isShutdown()) {
            this.mCommandQueue.clear();
            if (this.mCommandTimer != null) {
                this.mCommandTimer.shutdownNow();
            }
            this.mAllCommands.clear();
        }
    }

    @Override
    public synchronized void shutdownHard() {
        this.shutdown();
        Log.logAndDisplay((Log.LogLevel)Log.LogLevel.WARN, (String)LOG_TAG, (String)"Force killing adb connection");
        this.getDeviceManager().terminateHard();
    }

    @Override
    public Collection<ITestInvocation> listInvocations() throws UnsupportedOperationException {
        ArrayList<ITestInvocation> arrayList = new ArrayList<ITestInvocation>(this.mInvocationThreads.size());
        if (this.mInvocationThreads == null) {
            return null;
        }
        for (InvocationThread invocationThread : this.mInvocationThreads) {
            arrayList.add(invocationThread.getInvocation());
        }
        return arrayList;
    }

    @Override
    public boolean stopInvocation(ITestInvocation iTestInvocation) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<String> listCommands() throws UnsupportedOperationException {
        ArrayList<String> arrayList = new ArrayList<String>();
        List<ConfigCommand> list = this.mAllCommands;
        synchronized (list) {
            for (ConfigCommand configCommand : this.mAllCommands) {
                arrayList.add(this.getArgString(configCommand.getArgs()));
            }
        }
        return arrayList;
    }

    private class InvocationThread
    extends Thread {
        private final IDeviceManager mManager;
        private final ITestDevice mDevice;
        private final ConfigCommand mCmd;
        private ITestInvocation mInvocation;

        public InvocationThread(String string, IDeviceManager iDeviceManager, ITestDevice iTestDevice, ConfigCommand configCommand) {
            super(new ThreadGroup(string), string);
            this.mInvocation = null;
            this.mManager = iDeviceManager;
            this.mDevice = iTestDevice;
            this.mCmd = configCommand;
        }

        private synchronized ITestInvocation createInvocation() {
            this.mInvocation = CommandScheduler.this.createRunInstance();
            return this.mInvocation;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            IDeviceManager.FreeDeviceState freeDeviceState = IDeviceManager.FreeDeviceState.AVAILABLE;
            long l = System.currentTimeMillis();
            ITestInvocation iTestInvocation = this.createInvocation();
            try {
                try {
                    IConfiguration iConfiguration = this.mCmd.getConfiguration();
                    iTestInvocation.invoke(this.mDevice, iConfiguration, new Rescheduler(this.mCmd));
                }
                catch (DeviceUnresponsiveException deviceUnresponsiveException) {
                    Log.w((String)CommandScheduler.LOG_TAG, (String)String.format("Device %s is unresponsive", this.mDevice.getSerialNumber()));
                    freeDeviceState = IDeviceManager.FreeDeviceState.UNRESPONSIVE;
                    Object var7_10 = null;
                    long l4 = System.currentTimeMillis() - l;
                    Log.i((String)CommandScheduler.LOG_TAG, (String)String.format("Updating command '%s' with elapsed time %d ms", CommandScheduler.this.getArgString(this.mCmd.getArgs()), l4));
                    this.mCmd.incrementExecTime(l4);
                    CommandScheduler.this.mAllCommands.remove(this.mCmd);
                    this.mManager.freeDevice(this.mDevice, freeDeviceState);
                    CommandScheduler.this.removeInvocationThread(this);
                    return;
                }
                catch (DeviceNotAvailableException deviceNotAvailableException) {
                    Log.w((String)CommandScheduler.LOG_TAG, (String)String.format("Device %s is not available", this.mDevice.getSerialNumber()));
                    freeDeviceState = IDeviceManager.FreeDeviceState.UNAVAILABLE;
                    Object var7_11 = null;
                    long l5 = System.currentTimeMillis() - l;
                    Log.i((String)CommandScheduler.LOG_TAG, (String)String.format("Updating command '%s' with elapsed time %d ms", CommandScheduler.this.getArgString(this.mCmd.getArgs()), l5));
                    this.mCmd.incrementExecTime(l5);
                    CommandScheduler.this.mAllCommands.remove(this.mCmd);
                    this.mManager.freeDevice(this.mDevice, freeDeviceState);
                    CommandScheduler.this.removeInvocationThread(this);
                    return;
                }
                catch (FatalHostError fatalHostError) {
                    Log.logAndDisplay((Log.LogLevel)Log.LogLevel.ERROR, (String)CommandScheduler.LOG_TAG, (String)String.format("Fatal error occurred: %s, shutting down", fatalHostError.getMessage()));
                    if (fatalHostError.getCause() != null) {
                        Log.e((String)CommandScheduler.LOG_TAG, (Throwable)fatalHostError.getCause());
                    }
                    CommandScheduler.this.shutdown();
                    Object var7_12 = null;
                    long l6 = System.currentTimeMillis() - l;
                    Log.i((String)CommandScheduler.LOG_TAG, (String)String.format("Updating command '%s' with elapsed time %d ms", CommandScheduler.this.getArgString(this.mCmd.getArgs()), l6));
                    this.mCmd.incrementExecTime(l6);
                    CommandScheduler.this.mAllCommands.remove(this.mCmd);
                    this.mManager.freeDevice(this.mDevice, freeDeviceState);
                    CommandScheduler.this.removeInvocationThread(this);
                    return;
                }
                catch (Throwable throwable) {
                    Log.e((String)CommandScheduler.LOG_TAG, (Throwable)throwable);
                    Object var7_13 = null;
                    long l7 = System.currentTimeMillis() - l;
                    Log.i((String)CommandScheduler.LOG_TAG, (String)String.format("Updating command '%s' with elapsed time %d ms", CommandScheduler.this.getArgString(this.mCmd.getArgs()), l7));
                    this.mCmd.incrementExecTime(l7);
                    CommandScheduler.this.mAllCommands.remove(this.mCmd);
                    this.mManager.freeDevice(this.mDevice, freeDeviceState);
                    CommandScheduler.this.removeInvocationThread(this);
                    return;
                }
                Object var7_9 = null;
            }
            catch (Throwable throwable) {
                Object var7_14 = null;
                long l2 = System.currentTimeMillis() - l;
                Log.i((String)CommandScheduler.LOG_TAG, (String)String.format("Updating command '%s' with elapsed time %d ms", CommandScheduler.this.getArgString(this.mCmd.getArgs()), l2));
                this.mCmd.incrementExecTime(l2);
                CommandScheduler.this.mAllCommands.remove(this.mCmd);
                this.mManager.freeDevice(this.mDevice, freeDeviceState);
                CommandScheduler.this.removeInvocationThread(this);
                throw throwable;
            }
            long l3 = System.currentTimeMillis() - l;
            Log.i((String)CommandScheduler.LOG_TAG, (String)String.format("Updating command '%s' with elapsed time %d ms", CommandScheduler.this.getArgString(this.mCmd.getArgs()), l3));
            this.mCmd.incrementExecTime(l3);
            CommandScheduler.this.mAllCommands.remove(this.mCmd);
            this.mManager.freeDevice(this.mDevice, freeDeviceState);
            CommandScheduler.this.removeInvocationThread(this);
        }

        private synchronized ITestInvocation getInvocation() {
            return this.mInvocation;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ConfigComparator
    implements Comparator<ConfigCommand> {
        private ConfigComparator() {
        }

        @Override
        public int compare(ConfigCommand configCommand, ConfigCommand configCommand2) {
            if (configCommand.mTotalExecTime == configCommand2.mTotalExecTime) {
                return 0;
            }
            if (configCommand.mTotalExecTime < configCommand2.mTotalExecTime) {
                return -1;
            }
            return 1;
        }
    }

    private class Rescheduler
    implements IRescheduler {
        private ConfigCommand mOrigCmd;

        Rescheduler(ConfigCommand configCommand) {
            this.mOrigCmd = configCommand;
        }

        public boolean scheduleConfig(IConfiguration iConfiguration) {
            if (CommandScheduler.this.isShutdown()) {
                return false;
            }
            try {
                RescheduledConfigCommand rescheduledConfigCommand = new RescheduledConfigCommand(this.mOrigCmd, iConfiguration);
                CommandScheduler.this.mCommandQueue.add(rescheduledConfigCommand);
                return true;
            }
            catch (ConfigurationException configurationException) {
                Log.e((String)CommandScheduler.LOG_TAG, (Throwable)configurationException);
                return false;
            }
        }
    }

    private class RescheduledConfigCommand
    extends ConfigCommand {
        private final ConfigCommand mOriginalCmd;

        RescheduledConfigCommand(ConfigCommand configCommand, IConfiguration iConfiguration) throws ConfigurationException {
            super(configCommand.getArgs());
            this.mConfig = iConfiguration;
            this.mOriginalCmd = configCommand;
            this.mConfig.getCommandOptions().setLoopMode(false);
        }

        public IConfiguration resetConfiguration() throws ConfigurationException {
            return this.mConfig;
        }

        public IConfiguration getConfiguration() {
            return this.mConfig;
        }

        synchronized void incrementExecTime(long l) {
            this.mOriginalCmd.incrementExecTime(l);
        }
    }

    private class ConfigCommand {
        private final String[] mArgs;
        private long mTotalExecTime = 0L;
        protected IConfiguration mConfig;

        ConfigCommand(String[] stringArray) throws ConfigurationException {
            this.mArgs = stringArray;
            this.resetConfiguration();
        }

        synchronized void incrementExecTime(long l) {
            this.mTotalExecTime += l;
        }

        ICommandOptions getCommandOptions() {
            return this.getConfiguration().getCommandOptions();
        }

        IDeviceSelectionOptions getDeviceOptions() {
            return this.getConfiguration().getDeviceSelectionOptions();
        }

        String[] getArgs() {
            return this.mArgs;
        }

        public IConfiguration resetConfiguration() throws ConfigurationException {
            this.mConfig = CommandScheduler.this.getConfigFactory().createConfigurationFromArgs(this.getArgs());
            return this.mConfig;
        }

        public IConfiguration getConfiguration() {
            return this.mConfig;
        }
    }
}

