/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.command;

import com.android.ddmlib.Log;
import com.android.tradefed.command.ICommandScheduler;
import com.android.tradefed.config.ConfigurationException;
import com.android.tradefed.util.QuotationAwareTokenizer;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CommandFileParser {
    private static final String LOG_TAG = "CommandFileParser";
    private static final Pattern mMacroPattern = Pattern.compile("([a-z][a-z0-9_-]*)\\(\\)", 2);
    private Map<String, CommandLine> mMacros = new HashMap<String, CommandLine>();
    private Map<String, List<CommandLine>> mLongMacros = new HashMap<String, List<CommandLine>>();
    private List<CommandLine> mLines = new LinkedList<CommandLine>();
    private List<File> mIncludedFiles = new LinkedList<File>();

    CommandFileParser() {
    }

    private static boolean isLineMacro(CommandLine commandLine) {
        return commandLine.size() >= 4 && "MACRO".equals(commandLine.get(0)) && "=".equals(commandLine.get(2));
    }

    private static boolean isLineLongMacro(CommandLine commandLine) {
        return commandLine.size() == 3 && "LONG".equals(commandLine.get(0)) && "MACRO".equals(commandLine.get(1));
    }

    private static boolean isLineIncludeDirective(CommandLine commandLine) {
        return commandLine.size() == 2 && "INCLUDE".equals(commandLine.get(0));
    }

    private static boolean shouldParseLine(String string) {
        return !(string = string.trim()).isEmpty() && !string.startsWith("#");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scanFile(File file) throws IOException, ConfigurationException {
        if (this.mIncludedFiles.contains(file)) {
            Log.v((String)LOG_TAG, (String)String.format("Skipping repeated include of file %s.", file.toString()));
            return;
        }
        this.mIncludedFiles.add(file);
        BufferedReader bufferedReader = this.createCommandFileReader(file);
        String string = null;
        try {
            while ((string = bufferedReader.readLine()) != null) {
                CommandLine commandLine;
                Object object;
                if (!CommandFileParser.shouldParseLine(string = string.trim())) continue;
                CommandLine commandLine2 = null;
                try {
                    object = QuotationAwareTokenizer.tokenizeLine(string);
                    commandLine2 = new CommandLine(Arrays.asList(object));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new ConfigurationException(illegalArgumentException.getMessage());
                }
                if (CommandFileParser.isLineMacro(commandLine2)) {
                    object = (String)commandLine2.get(1);
                    commandLine = new CommandLine(commandLine2.subList(3, commandLine2.size()));
                    this.mMacros.put((String)object, commandLine);
                    continue;
                }
                if (CommandFileParser.isLineLongMacro(commandLine2)) {
                    object = (String)commandLine2.get(2);
                    commandLine = new LinkedList();
                    string = bufferedReader.readLine();
                    while (!"END MACRO".equals(string)) {
                        if (string == null) {
                            throw new ConfigurationException(String.format("Syntax error: Unexpected EOF while reading definition for LONG MACRO %s.", object));
                        }
                        if (CommandFileParser.shouldParseLine(string)) {
                            CommandLine commandLine3 = new CommandLine(Arrays.asList(QuotationAwareTokenizer.tokenizeLine(string)));
                            commandLine.add(commandLine3);
                        }
                        string = bufferedReader.readLine();
                    }
                    Log.d((String)LOG_TAG, (String)String.format("Parsed %d-line definition for long macro %s", commandLine.size(), object));
                    this.mLongMacros.put((String)object, commandLine);
                    continue;
                }
                if (CommandFileParser.isLineIncludeDirective(commandLine2)) {
                    Log.d((String)LOG_TAG, (String)String.format("Got an include directive for file %s", commandLine2.get(1)));
                    this.scanFile(new File((String)commandLine2.get(1)));
                    continue;
                }
                this.mLines.add(commandLine2);
            }
        }
        finally {
            bufferedReader.close();
        }
    }

    public void parseFile(File file, ICommandScheduler iCommandScheduler) throws IOException, ConfigurationException {
        Object object;
        int n;
        this.scanFile(file);
        LinkedList<Boolean> linkedList = new LinkedList<Boolean>();
        for (n = 0; n < this.mLines.size(); ++n) {
            linkedList.add(true);
        }
        n = this.mLines.size();
        for (int i = 0; i < 10 && n > 0; ++i) {
            Log.d((String)LOG_TAG, (String)("### Expansion iteration " + i));
            int n2 = 0;
            while (n2 < this.mLines.size()) {
                if (!((Boolean)linkedList.get(n2)).booleanValue()) {
                    ++n2;
                    continue;
                }
                boolean bl = this.expandMacro((CommandLine)(object = this.mLines.get(n2)));
                List<CommandLine> list = this.expandLongMacro((CommandLine)object, !bl);
                if (list == null) {
                    if (!bl) {
                        linkedList.set(n2, false);
                        --n;
                    }
                    ++n2;
                    continue;
                }
                this.mLines.remove(n2);
                this.mLines.addAll(n2, list);
                for (int j = 0; j < list.size(); ++j) {
                    linkedList.add(n2, true);
                }
                n2 += list.size();
            }
        }
        for (CommandLine commandLine : this.mLines) {
            Log.d((String)LOG_TAG, (String)String.format("Adding line: %s", commandLine.toString()));
            object = new String[commandLine.size()];
            iCommandScheduler.addCommand(commandLine.toArray((T[])object));
        }
    }

    private List<CommandLine> expandLongMacro(CommandLine commandLine, boolean bl) throws ConfigurationException {
        for (int i = 0; i < commandLine.size(); ++i) {
            String string = (String)commandLine.get(i);
            Matcher matcher = mMacroPattern.matcher(string);
            if (!matcher.matches()) continue;
            LinkedList<CommandLine> linkedList = new LinkedList<CommandLine>();
            String string2 = matcher.group(1);
            List<CommandLine> list = this.mLongMacros.get(string2);
            if (list == null) {
                if (bl) {
                    throw new ConfigurationException(String.format("Macro call '%s' does not match any macro definitions.", string2));
                }
                return null;
            }
            CommandLine commandLine2 = new CommandLine(commandLine.subList(0, i));
            CommandLine commandLine3 = new CommandLine(commandLine.subList(i, commandLine.size()));
            commandLine3.remove(0);
            for (CommandLine commandLine4 : list) {
                CommandLine commandLine5 = new CommandLine();
                commandLine5.addAll(commandLine2);
                commandLine5.addAll(commandLine4);
                commandLine5.addAll(commandLine3);
                linkedList.add(commandLine5);
            }
            return linkedList;
        }
        return null;
    }

    private boolean expandMacro(CommandLine commandLine) {
        boolean bl = false;
        int n = 0;
        while (n < commandLine.size()) {
            String string = (String)commandLine.get(n);
            Matcher matcher = mMacroPattern.matcher(string);
            if (matcher.matches() && this.mMacros.containsKey(matcher.group(1))) {
                String string2 = matcher.group(1);
                CommandLine commandLine2 = this.mMacros.get(string2);
                Log.d((String)LOG_TAG, (String)String.format("Gotcha!  Expanding macro '%s' to '%s'", string2, commandLine2));
                commandLine.remove(n);
                commandLine.addAll(n, commandLine2);
                n += commandLine2.size();
                bl = true;
                continue;
            }
            ++n;
        }
        return bl;
    }

    BufferedReader createCommandFileReader(File file) throws IOException {
        return new BufferedReader(new FileReader(file));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CommandLine
    extends LinkedList<String> {
        CommandLine() {
        }

        CommandLine(Collection<? extends String> collection) {
            super(collection);
        }
    }
}

