/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.build;

import com.android.tradefed.build.FileDownloadCache;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class FileDownloadCacheFactory {
    private Map<String, FileDownloadCache> mCacheObjectMap = Collections.synchronizedMap(new HashMap());

    public static FileDownloadCacheFactory getInstance() {
        return SingletonHolder.INSTANCE;
    }

    public synchronized FileDownloadCache getCache(File file) {
        FileDownloadCache fileDownloadCache = this.mCacheObjectMap.get(file.getAbsolutePath());
        if (fileDownloadCache == null) {
            fileDownloadCache = new FileDownloadCache(file);
            this.mCacheObjectMap.put(file.getAbsolutePath(), fileDownloadCache);
        }
        return fileDownloadCache;
    }

    private static class SingletonHolder {
        public static final FileDownloadCacheFactory INSTANCE = new FileDownloadCacheFactory();

        private SingletonHolder() {
        }
    }
}

