/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.build;

import com.android.ddmlib.Log;
import com.android.tradefed.build.BuildRetrievalError;
import com.android.tradefed.build.IFileDownloader;
import com.android.tradefed.command.FatalHostError;
import com.android.tradefed.util.FileUtil;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.concurrent.locks.ReentrantLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileDownloadCache {
    private static final String LOG_TAG = "FileDownloadCache";
    private static final char REL_PATH_SEPARATOR = '/';
    private final File mCacheRoot;
    private final Map<String, File> mCacheMap = new LinkedHashMap<String, File>();
    private final ReentrantLock mCacheMapLock = new ReentrantLock();
    private long mCurrentCacheSize = 0L;
    private long mMaxFileCacheSize = 0x80000000L;

    FileDownloadCache(File file) {
        this.mCacheRoot = file;
        if (!this.mCacheRoot.exists()) {
            Log.d((String)LOG_TAG, (String)String.format("Creating file cache at %s", this.mCacheRoot.getAbsolutePath()));
            if (!this.mCacheRoot.mkdirs()) {
                throw new FatalHostError(String.format("Could not create cache directory at %s", this.mCacheRoot.getAbsolutePath()));
            }
        } else {
            Log.d((String)LOG_TAG, (String)String.format("Building file cache from contents at %s", this.mCacheRoot.getAbsolutePath()));
            LinkedList<FilePair> linkedList = new LinkedList<FilePair>();
            this.addFiles(this.mCacheRoot, new Stack<String>(), linkedList);
            Collections.sort(linkedList, new FileTimeComparator());
            for (FilePair filePair : linkedList) {
                this.mCacheMap.put(filePair.mRelPath, filePair.mFile);
            }
        }
    }

    private void addFiles(File file, Stack<String> stack, List<FilePair> list) {
        for (File file2 : file.listFiles()) {
            if (file2.isDirectory()) {
                stack.push(file2.getName());
                this.addFiles(file2, stack, list);
                stack.pop();
                continue;
            }
            if (file2.isFile()) {
                StringBuffer stringBuffer = new StringBuffer();
                for (String string : stack) {
                    stringBuffer.append(string);
                    stringBuffer.append('/');
                }
                stringBuffer.append(file2.getName());
                list.add(new FilePair(stringBuffer.toString(), file2));
                continue;
            }
            Log.w((String)LOG_TAG, (String)String.format("Unrecognized file type %s in cache", file2.getAbsolutePath()));
        }
    }

    public void setMaxCacheSize(long l) {
        this.mCacheMapLock.lock();
        this.mMaxFileCacheSize = l;
        this.mCacheMapLock.unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File fetchRemoteFile(IFileDownloader iFileDownloader, String string) throws BuildRetrievalError {
        Object object;
        boolean bl = false;
        this.mCacheMapLock.lock();
        File file = this.mCacheMap.remove(string);
        if (file == null) {
            object = this.convertPath(string);
            file = new File(this.mCacheRoot, (String)object);
            file.getParentFile().mkdirs();
            bl = true;
        }
        object = null;
        try {
            File file2 = file;
            synchronized (file2) {
                this.mCacheMap.put(string, file);
                this.mCacheMapLock.unlock();
                if (bl) {
                    this.downloadFile(iFileDownloader, string, file);
                } else {
                    Log.d((String)LOG_TAG, (String)String.format("Retrieved remote file %s from cached file %s", string, file.getAbsolutePath()));
                }
                object = this.copyFile(string, file);
            }
        }
        catch (BuildRetrievalError buildRetrievalError) {
            this.mCacheMapLock.lock();
            this.mCacheMap.remove(string);
            this.mCacheMapLock.unlock();
            throw buildRetrievalError;
        }
        if (bl) {
            this.incrementAndAdjustCache(file.length());
        }
        return object;
    }

    private void downloadFile(IFileDownloader iFileDownloader, String string, File file) throws BuildRetrievalError {
        try {
            Log.d((String)LOG_TAG, (String)String.format("Downloading %s to cache", string));
            iFileDownloader.downloadFile(string, file);
        }
        catch (BuildRetrievalError buildRetrievalError) {
            file.delete();
            throw buildRetrievalError;
        }
    }

    private File copyFile(String string, File file) throws BuildRetrievalError {
        File file2 = null;
        try {
            file2 = FileUtil.createTempFileForRemote(string, null);
            FileUtil.copyFile(file, file2);
            return file2;
        }
        catch (IOException iOException) {
            if (file2 != null) {
                file2.delete();
            }
            file.delete();
            throw new BuildRetrievalError(String.format("Failed to copy cached file %s", file), iOException);
        }
    }

    private String convertPath(String string) {
        if ('/' != File.separatorChar) {
            return string.replace('/', File.separatorChar);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void incrementAndAdjustCache(long l) {
        this.mCacheMapLock.lock();
        try {
            this.mCurrentCacheSize += l;
            Iterator<Map.Entry<String, File>> iterator = this.mCacheMap.entrySet().iterator();
            LinkedList linkedList = new LinkedList();
            while (this.mCurrentCacheSize > this.mMaxFileCacheSize && iterator.hasNext()) {
                Map.Entry<String, File> entry = iterator.next();
                linkedList.add(entry.getKey());
                this.mCurrentCacheSize -= ((File)entry.getValue()).length();
            }
            for (String string : linkedList) {
                File file;
                File file2 = file = this.mCacheMap.remove(string);
                synchronized (file2) {
                    file.delete();
                }
            }
            if (this.mCurrentCacheSize < 0L) {
                Log.e((String)LOG_TAG, (String)"Cache size is less than 0!");
            }
        }
        finally {
            this.mCacheMapLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    File getCachedFile(String string) {
        this.mCacheMapLock.lock();
        try {
            File file = this.mCacheMap.get(string);
            return file;
        }
        finally {
            this.mCacheMapLock.unlock();
        }
    }

    void empty() {
        long l = this.mMaxFileCacheSize;
        this.setMaxCacheSize(0L);
        this.incrementAndAdjustCache(0L);
        this.setMaxCacheSize(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getOldestEntry() {
        this.mCacheMapLock.lock();
        try {
            if (!this.mCacheMap.isEmpty()) {
                String string = this.mCacheMap.keySet().iterator().next();
                return string;
            }
            String string = null;
            return string;
        }
        finally {
            this.mCacheMapLock.unlock();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FileTimeComparator
    implements Comparator<FilePair> {
        private FileTimeComparator() {
        }

        @Override
        public int compare(FilePair filePair, FilePair filePair2) {
            Long l = new Long(filePair.mFile.lastModified());
            Long l2 = filePair2.mFile.lastModified();
            return l.compareTo(l2);
        }
    }

    private static class FilePair {
        final String mRelPath;
        final File mFile;

        FilePair(String string, File file) {
            this.mRelPath = string;
            this.mFile = file;
        }
    }
}

