/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.build;

import com.android.ddmlib.Log;
import com.android.tradefed.build.BuildInfo;
import com.android.tradefed.build.IBuildInfo;
import com.android.tradefed.build.IDeviceBuildInfo;
import com.android.tradefed.util.FileUtil;
import java.io.File;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Map;

public class DeviceBuildInfo
extends BuildInfo
implements IDeviceBuildInfo {
    private static final String LOG_TAG = "DeviceBuildInfo";
    private Map<String, ImageFile> mImageFileMap = new Hashtable<String, ImageFile>();
    private static final String DEVICE_IMAGE_NAME = "device";
    private static final String USERDATA_IMAGE_NAME = "userdata";
    private static final String TESTZIP_IMAGE_NAME = "testszip";
    private static final String BASEBAND_IMAGE_NAME = "baseband";
    private static final String BOOTLOADER_IMAGE_NAME = "bootloader";

    public DeviceBuildInfo(int n, String string, String string2) {
        super(n, string, string2);
    }

    public File getImageFile(String string) {
        ImageFile imageFile = this.mImageFileMap.get(string);
        if (imageFile != null) {
            return imageFile.getImageFile();
        }
        return null;
    }

    public String getImageVersion(String string) {
        ImageFile imageFile = this.mImageFileMap.get(string);
        if (imageFile != null) {
            return imageFile.getVersion();
        }
        return null;
    }

    public void setImageFile(String string, File file, String string2) {
        this.mImageFileMap.put(string, new ImageFile(file, string2));
    }

    public File getDeviceImageFile() {
        return this.getImageFile(DEVICE_IMAGE_NAME);
    }

    public void setDeviceImageFile(File file) {
        this.setImageFile(DEVICE_IMAGE_NAME, file, Integer.toString(this.getBuildId()));
    }

    public File getUserDataImageFile() {
        return this.getImageFile(USERDATA_IMAGE_NAME);
    }

    public void setUserDataImageFile(File file) {
        this.setImageFile(USERDATA_IMAGE_NAME, file, Integer.toString(this.getBuildId()));
    }

    public File getTestsZipFile() {
        return this.getImageFile(TESTZIP_IMAGE_NAME);
    }

    public void setTestsZipFile(File file) {
        this.setImageFile(TESTZIP_IMAGE_NAME, file, Integer.toString(this.getBuildId()));
    }

    public File getBasebandImageFile() {
        return this.getImageFile(BASEBAND_IMAGE_NAME);
    }

    public String getBasebandVersion() {
        return this.getImageVersion(BASEBAND_IMAGE_NAME);
    }

    public void setBasebandImage(File file, String string) {
        this.setImageFile(BASEBAND_IMAGE_NAME, file, string);
    }

    public File getBootloaderImageFile() {
        return this.getImageFile(BOOTLOADER_IMAGE_NAME);
    }

    public String getBootloaderVersion() {
        return this.getImageVersion(BOOTLOADER_IMAGE_NAME);
    }

    public void setBootloaderImageFile(File file, String string) {
        this.setImageFile(BOOTLOADER_IMAGE_NAME, file, string);
    }

    public void cleanUp() {
        for (ImageFile imageFile : this.mImageFileMap.values()) {
            imageFile.getImageFile().delete();
        }
        this.mImageFileMap.clear();
    }

    public IBuildInfo clone() {
        try {
            DeviceBuildInfo deviceBuildInfo = new DeviceBuildInfo(this.getBuildId(), this.getTestTarget(), this.getBuildName());
            deviceBuildInfo.addAllBuildAttributes(this.getAttributesMultiMap());
            for (Map.Entry<String, ImageFile> entry : this.mImageFileMap.entrySet()) {
                File file = entry.getValue().getImageFile();
                File file2 = FileUtil.createTempFile(entry.getKey(), FileUtil.getExtension(file.getName()));
                FileUtil.copyFile(file, file2);
                deviceBuildInfo.mImageFileMap.put(entry.getKey(), new ImageFile(file2, entry.getValue().getVersion()));
            }
            return deviceBuildInfo;
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        String string = String.format("%s[%s]", LOG_TAG, Thread.currentThread().getName());
        Log.d((String)LOG_TAG, (String)String.format("%s in finalizer", string));
        if (!this.mImageFileMap.isEmpty()) {
            Log.e((String)LOG_TAG, (String)String.format("%s was not cleaned up: %s", string, this.mImageFileMap.toString()));
            this.cleanUp();
        }
    }

    private static class ImageFile {
        private final File mImageFile;
        private final String mVersion;

        ImageFile(File file, String string) {
            this.mImageFile = file;
            this.mVersion = string;
        }

        File getImageFile() {
            return this.mImageFile;
        }

        String getVersion() {
            return this.mVersion;
        }
    }
}

