/*
 * Decompiled with CFR 0.152.
 */
package com.android.performance.tests;

import com.android.ddmlib.Log;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.result.ITestInvocationListener;
import com.android.tradefed.testtype.IDeviceTest;
import com.android.tradefed.testtype.IRemoteTest;
import java.util.HashMap;
import java.util.Map;
import junit.framework.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StartupMetricsTest
implements IDeviceTest,
IRemoteTest {
    private static final String LOG_TAG = "StartupMetricsTest";
    ITestDevice mTestDevice = null;

    @Override
    public void run(ITestInvocationListener iTestInvocationListener) throws DeviceNotAvailableException {
        Assert.assertNotNull(this.mTestDevice);
        this.executeRebootTest(iTestInvocationListener);
    }

    void executeRebootTest(ITestInvocationListener iTestInvocationListener) throws DeviceNotAvailableException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        long l = System.currentTimeMillis();
        this.mTestDevice.rebootUntilOnline();
        long l2 = System.currentTimeMillis();
        this.mTestDevice.waitForDeviceAvailable();
        long l3 = System.currentTimeMillis();
        long l4 = l2 - l;
        long l5 = l3 - l;
        Log.d((String)LOG_TAG, (String)String.format("Reboot: %d millis until online, %d until available", l4, l5));
        hashMap.put("offline", Long.toString(l4));
        hashMap.put("unavail", Long.toString(l5));
        this.reportMetrics(iTestInvocationListener, "reboot", hashMap);
    }

    void reportMetrics(ITestInvocationListener iTestInvocationListener, String string, Map<String, String> map) {
        Log.d((String)LOG_TAG, (String)String.format("About to report metrics: %s", map));
        iTestInvocationListener.testRunStarted(string, 0);
        iTestInvocationListener.testRunEnded(0L, map);
    }

    @Override
    public void setDevice(ITestDevice iTestDevice) {
        this.mTestDevice = iTestDevice;
    }

    @Override
    public ITestDevice getDevice() {
        return this.mTestDevice;
    }
}

