/*
 * Decompiled with CFR 0.152.
 */
package com.android.media.tests;

import com.android.ddmlib.Log;
import com.android.ddmlib.testrunner.IRemoteAndroidTestRunner;
import com.android.ddmlib.testrunner.RemoteAndroidTestRunner;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.result.ITestInvocationListener;
import com.android.tradefed.result.InputStreamSource;
import com.android.tradefed.result.LogDataType;
import com.android.tradefed.result.SnapshotInputStreamSource;
import com.android.tradefed.testtype.IDeviceTest;
import com.android.tradefed.testtype.IRemoteTest;
import com.android.tradefed.util.StreamUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.ListIterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import junit.framework.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MediaStressTest
implements IDeviceTest,
IRemoteTest {
    private static final String LOG_TAG = "MediaStressTest";
    ITestDevice mTestDevice = null;
    private static final String METRICS_RUN_NAME = "media_stress";
    private static final String mTestClassName = "com.android.mediaframeworktest.stress.MediaRecorderStressTest";
    private static final String mTestPackageName = "com.android.mediaframeworktest";
    private static final String mTestRunnerName = ".MediaRecorderStressTestRunner";
    private static final String PREVIEW_STANZA = "Camera start preview stress:";
    private static final String SWITCH_STANZA = "Camera and video recorder preview switching";
    private static final String PLAYBACK_STANZA = "Video record and play back stress test:";
    private static final String RECORDING_STANZA = "H263 video record";
    private static final Pattern EXPECTED_LOOP_COUNT_PATTERN = Pattern.compile("Total number of loops:\\s*(\\d+)");
    private static final Pattern ACTUAL_LOOP_COUNT_PATTERN = Pattern.compile("No of loop:.*,\\s*(\\d+)\\s*");
    private final String mOutputPath = "mediaStressOutput.txt";

    @Override
    public void run(ITestInvocationListener iTestInvocationListener) throws DeviceNotAvailableException {
        Assert.assertNotNull(this.mTestDevice);
        RemoteAndroidTestRunner remoteAndroidTestRunner = new RemoteAndroidTestRunner(mTestPackageName, mTestRunnerName, this.mTestDevice.getIDevice());
        remoteAndroidTestRunner.setClassName(mTestClassName);
        this.cleanTmpFiles();
        this.mTestDevice.runInstrumentationTests((IRemoteAndroidTestRunner)remoteAndroidTestRunner, iTestInvocationListener);
        this.logOutputFile(iTestInvocationListener);
        this.cleanTmpFiles();
    }

    private void cleanTmpFiles() throws DeviceNotAvailableException {
        String string = this.mTestDevice.getMountPoint("EXTERNAL_STORAGE");
        this.mTestDevice.executeShellCommand(String.format("rm %s/temp*.3gp", string));
        this.mTestDevice.executeShellCommand(String.format("rm %s/%s", string, "mediaStressOutput.txt"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logOutputFile(ITestInvocationListener iTestInvocationListener) throws DeviceNotAvailableException {
        File file = null;
        InputStreamSource inputStreamSource = null;
        try {
            file = this.mTestDevice.pullFileFromExternal("mediaStressOutput.txt");
            Log.d((String)LOG_TAG, (String)String.format("Sending %d byte file %s into the logosphere!", file.length(), file));
            inputStreamSource = new SnapshotInputStreamSource(new FileInputStream(file));
            iTestInvocationListener.testLog("mediaStressOutput.txt", LogDataType.TEXT, inputStreamSource);
            this.parseOutputFile(file, iTestInvocationListener);
        }
        catch (IOException iOException) {
            Log.e((String)LOG_TAG, (String)String.format("IOException while reading or parsing output file: %s", iOException));
        }
        finally {
            if (file != null) {
                file.delete();
            }
            if (inputStreamSource != null) {
                inputStreamSource.cancel();
            }
        }
    }

    private void parseOutputFile(File file, ITestInvocationListener iTestInvocationListener) {
        String string;
        Object object;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        try {
            object = new FileInputStream(file);
            string = StreamUtil.getStringFromStream((InputStream)object);
        }
        catch (IOException iOException) {
            Log.e((String)LOG_TAG, (String)String.format("Got IOException: %s", iOException));
            return;
        }
        object = Arrays.asList(string.split("\n"));
        ListIterator<String> listIterator = object.listIterator();
        while (listIterator.hasNext()) {
            String string2 = (String)listIterator.next();
            String string3 = null;
            if (PREVIEW_STANZA.equals(string2)) {
                string3 = "preview";
            } else if (SWITCH_STANZA.equals(string2)) {
                string3 = "switch";
            } else if (PLAYBACK_STANZA.equals(string2)) {
                string3 = "playback";
            } else if (string2.startsWith(RECORDING_STANZA)) {
                string3 = "recording";
            } else {
                if (string2.isEmpty()) continue;
                Log.e((String)LOG_TAG, (String)String.format("Got unexpected line: %s", string2));
                continue;
            }
            Integer n = this.getIntFromOutput(listIterator, EXPECTED_LOOP_COUNT_PATTERN);
            Integer n2 = this.getIntFromOutput(listIterator, ACTUAL_LOOP_COUNT_PATTERN);
            int n3 = this.coalesceLoopCounts(n2, n);
            hashMap.put(string3, Integer.toString(n3));
        }
        this.reportMetrics(iTestInvocationListener, hashMap);
    }

    void reportMetrics(ITestInvocationListener iTestInvocationListener, Map<String, String> map) {
        Log.d((String)LOG_TAG, (String)String.format("About to report metrics: %s", map));
        iTestInvocationListener.testRunStarted(METRICS_RUN_NAME, 0);
        iTestInvocationListener.testRunEnded(0L, map);
    }

    private Integer getIntFromOutput(ListIterator<String> listIterator, Pattern pattern) {
        Integer n = null;
        String string = null;
        if (listIterator.hasNext()) {
            string = listIterator.next();
            Matcher matcher = pattern.matcher(string);
            if (matcher.matches()) {
                n = Integer.parseInt(matcher.group(1));
            } else {
                Log.e((String)LOG_TAG, (String)String.format("Couldn't match pattern %s against line '%s'", pattern, string));
            }
        } else {
            Log.e((String)LOG_TAG, (String)String.format("Encounted EOF while trying to match pattern %s", pattern));
        }
        return n;
    }

    private int coalesceLoopCounts(Integer n, Integer n2) {
        if (n2 == null || n2 <= 0) {
            return -1;
        }
        if (n == null) {
            return n2;
        }
        return n;
    }

    @Override
    public void setDevice(ITestDevice iTestDevice) {
        this.mTestDevice = iTestDevice;
    }

    @Override
    public ITestDevice getDevice() {
        return this.mTestDevice;
    }
}

