/*
 * Decompiled with CFR 0.152.
 */
package com.android.media.tests;

import com.android.ddmlib.Log;
import com.android.ddmlib.testrunner.IRemoteAndroidTestRunner;
import com.android.ddmlib.testrunner.RemoteAndroidTestRunner;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.result.CollectingTestListener;
import com.android.tradefed.result.ITestInvocationListener;
import com.android.tradefed.result.InputStreamSource;
import com.android.tradefed.result.LogDataType;
import com.android.tradefed.result.SnapshotInputStreamSource;
import com.android.tradefed.testtype.IDeviceTest;
import com.android.tradefed.testtype.IRemoteTest;
import com.android.tradefed.util.RegexTrie;
import com.android.tradefed.util.StreamUtil;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import junit.framework.Assert;
import junit.framework.TestCase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CameraStressTest
implements IDeviceTest,
IRemoteTest {
    private static final String LOG_TAG = "CameraStressTest";
    ITestDevice mTestDevice = null;
    private static final String TEST_PACKAGE_NAME = "com.google.android.camera.tests";
    private final String mOutputPath = "mediaStressOut.txt";
    private List<TestInfo> mTestCases = new ArrayList<TestInfo>();

    static RegexTrie<String> getPatternMap() {
        RegexTrie<String> regexTrie = new RegexTrie<String>();
        regexTrie.put("switch", "^Camera Switch Mode:");
        regexTrie.put("image", "^Camera Image Capture");
        regexTrie.put("video", "^Camera Video Capture");
        regexTrie.put("f_image", "^Front Camera Image Capture");
        regexTrie.put("b_image", "^Back Camera Image Capture");
        regexTrie.put("f_video", "^Front Camera Video Capture");
        regexTrie.put("b_video", "^Back Camera Video Capture");
        regexTrie.put("loopCount", "^No of loops :(\\d+)");
        regexTrie.put("iters", "^loop:.+,(\\d+)");
        return regexTrie;
    }

    public CameraStressTest() {
        RegexTrie<String> regexTrie = CameraStressTest.getPatternMap();
        TestInfo testInfo = new TestInfo();
        testInfo.mTestName = "imagecap";
        testInfo.mClassName = "com.android.camera.stress.ImageCapture";
        testInfo.mTestMetricsName = "camera_application_stress";
        testInfo.mPatternMap = regexTrie;
        this.mTestCases.add(testInfo);
        testInfo = new TestInfo();
        testInfo.mTestName = "videocap";
        testInfo.mClassName = "com.android.camera.stress.VideoCapture";
        testInfo.mTestMetricsName = "camera_application_stress";
        testInfo.mPatternMap = regexTrie;
        this.mTestCases.add(testInfo);
        testInfo = new TestInfo();
        testInfo.mTestName = "switch";
        testInfo.mClassName = "com.android.camera.stress.SwitchPreview";
        testInfo.mTestMetricsName = "camera_application_stress";
        testInfo.mPatternMap = regexTrie;
        this.mTestCases.add(testInfo);
    }

    @Override
    public void run(ITestInvocationListener iTestInvocationListener) throws DeviceNotAvailableException {
        Assert.assertNotNull(this.mTestDevice);
        for (TestInfo testInfo : this.mTestCases) {
            this.cleanTmpFiles();
            this.executeTest(testInfo, iTestInvocationListener);
            this.logOutputFiles(testInfo, iTestInvocationListener);
        }
        this.cleanTmpFiles();
    }

    private void executeTest(TestInfo testInfo, ITestInvocationListener iTestInvocationListener) throws DeviceNotAvailableException {
        RemoteAndroidTestRunner remoteAndroidTestRunner = new RemoteAndroidTestRunner(TEST_PACKAGE_NAME, this.mTestDevice.getIDevice());
        CollectingTestListener collectingTestListener = new CollectingTestListener();
        remoteAndroidTestRunner.setClassName(testInfo.mClassName);
        this.mTestDevice.runInstrumentationTests((IRemoteAndroidTestRunner)remoteAndroidTestRunner, iTestInvocationListener, collectingTestListener);
        if (collectingTestListener.hasFailedTests()) {
            Log.e((String)LOG_TAG, (String)String.format("Grabbing bugreport after test '%s' finished with %d failures and %d errors.", testInfo.mTestName, collectingTestListener.getNumFailedTests(), collectingTestListener.getNumErrorTests()));
            InputStreamSource inputStreamSource = this.mTestDevice.getBugreport();
            iTestInvocationListener.testLog(String.format("bugreport-%s.txt", testInfo.mTestName), LogDataType.TEXT, inputStreamSource);
            inputStreamSource.cancel();
        }
    }

    private void cleanTmpFiles() throws DeviceNotAvailableException {
        String string = this.mTestDevice.getMountPoint("EXTERNAL_STORAGE");
        this.mTestDevice.executeShellCommand(String.format("rm -r -f %s/DCIM", string));
        this.mTestDevice.executeShellCommand(String.format("rm %s/%s", string, "mediaStressOut.txt"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logOutputFiles(TestInfo testInfo, ITestInvocationListener iTestInvocationListener) throws DeviceNotAvailableException {
        File file = null;
        InputStreamSource inputStreamSource = null;
        try {
            file = this.mTestDevice.pullFileFromExternal("mediaStressOut.txt");
            if (file == null) {
                return;
            }
            Log.d((String)LOG_TAG, (String)String.format("Sending %d byte file %s into the logosphere!", file.length(), file));
            inputStreamSource = new SnapshotInputStreamSource(new FileInputStream(file));
            iTestInvocationListener.testLog(String.format("output-%s.txt", testInfo.mTestName), LogDataType.TEXT, inputStreamSource);
            this.parseOutputFile(testInfo, new FileInputStream(file), iTestInvocationListener);
        }
        catch (IOException iOException) {
            Log.e((String)LOG_TAG, (String)String.format("IOException while reading or parsing output file: %s", iOException));
        }
        finally {
            if (file != null) {
                file.delete();
            }
            if (inputStreamSource != null) {
                inputStreamSource.cancel();
            }
        }
    }

    private void parseOutputFile(TestInfo testInfo, InputStream inputStream, ITestInvocationListener iTestInvocationListener) {
        String string;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        try {
            string = StreamUtil.getStringFromStream(inputStream);
        }
        catch (IOException iOException) {
            Log.e((String)LOG_TAG, (String)String.format("Got IOException during %s test processing: %s", testInfo.mTestName, iOException));
            return;
        }
        String string2 = null;
        Integer n = null;
        Integer n2 = null;
        List<String> list = Arrays.asList(string.split("\n"));
        ListIterator<String> listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            int n3;
            String string3 = listIterator.next();
            ArrayList<List<String>> arrayList = new ArrayList<List<String>>(1);
            String string4 = testInfo.mPatternMap.retrieve(arrayList, string3);
            if (string4 != null) {
                if ("loopCount".equals(string4)) {
                    n = Integer.parseInt((String)((List)arrayList.get(0)).get(0));
                } else if ("iters".equals(string4)) {
                    n2 = Integer.parseInt((String)((List)arrayList.get(0)).get(0));
                    if (n2 != null) {
                        n2 = n2 + 1;
                    }
                } else {
                    if (string2 != null) {
                        n3 = this.coalesceLoopCounts(n2, n);
                        hashMap.put(string2, Integer.toString(n3));
                    }
                    string2 = string4;
                    n = null;
                    n2 = null;
                }
            } else {
                if (string3.isEmpty()) continue;
                Log.e((String)LOG_TAG, (String)String.format("Got unmatched line: %s", string3));
                continue;
            }
            Log.d((String)LOG_TAG, (String)String.format("Got %s key '%s' and captures '%s'", testInfo.mTestName, string2, ((Object)arrayList).toString()));
            if (string2 == null) continue;
            n3 = this.coalesceLoopCounts(n2, n);
            hashMap.put(string2, Integer.toString(n3));
        }
        this.reportMetrics(iTestInvocationListener, testInfo, hashMap);
    }

    private int coalesceLoopCounts(Integer n, Integer n2) {
        if (n2 == null || n2 <= 0) {
            return -1;
        }
        if (n == null) {
            return n2;
        }
        return n;
    }

    void reportMetrics(ITestInvocationListener iTestInvocationListener, TestInfo testInfo, Map<String, String> map) {
        Log.e((String)LOG_TAG, (String)String.format("About to report metrics for %s: %s", testInfo.mTestMetricsName, map));
        iTestInvocationListener.testRunStarted(testInfo.mTestMetricsName, 0);
        iTestInvocationListener.testRunEnded(0L, map);
    }

    @Override
    public void setDevice(ITestDevice iTestDevice) {
        this.mTestDevice = iTestDevice;
    }

    @Override
    public ITestDevice getDevice() {
        return this.mTestDevice;
    }

    public static class MetaTest
    extends TestCase {
        private CameraStressTest mTestInstance = null;
        private TestInfo mTestInfo = null;
        private TestInfo mReportedTestInfo = null;
        private Map<String, String> mReportedMetrics = null;

        private static String join(String ... stringArray) {
            StringBuilder stringBuilder = new StringBuilder();
            for (String string : stringArray) {
                stringBuilder.append(string);
                stringBuilder.append("\n");
            }
            return stringBuilder.toString();
        }

        public void setUp() throws Exception {
            this.mTestInstance = new CameraStressTest(){

                @Override
                void reportMetrics(ITestInvocationListener iTestInvocationListener, TestInfo testInfo, Map<String, String> map) {
                    MetaTest.this.mReportedTestInfo = testInfo;
                    MetaTest.this.mReportedMetrics = map;
                }
            };
            TestInfo testInfo = this.mTestInfo = new TestInfo();
            testInfo.mTestName = "capture";
            testInfo.mClassName = "com.android.camera.stress.ImageCapture";
            testInfo.mTestMetricsName = "camera_application_stress";
            testInfo.mPatternMap = CameraStressTest.getPatternMap();
        }

        public void testParse_old() throws Exception {
            String string = MetaTest.join("Camera Image Capture", "No of loops :100", "loop:  ,0 ,1 ,2 ,3 ,4 ,5 ,6 ,7 ,8 ,9 ,10 ,11 ,12 ,13 ,14 ,15 ,16 ,17 ,18 ,19 ,20 ,21 ,22 ,23 ,24 ,25 ,26 ,27 ,28 ,29 ,30 ,31 ,32 ,33 ,34 ,35 ,36 ,37 ,38 ,39 ,40 ,41 ,42", "Camera Video Capture", "No of loops :100", "loop:  ,0 ,1 ,2 ,3 ,4 ,5 ,6 ,7 ,8 ,9 ,10 ,11 ,12 ,13 ,14 ,15 ,16 ,17 ,18 ,19 ,20 ,21 ,22 ,23 ,24 ,25 ,26 ,27 ,28 ,29 ,30 ,31 ,32 ,33 ,34 ,35 ,36 ,37 ,38 ,39 ,40 ,41 ,42 ,43 ,44 ,45 ,46 ,47 ,48 ,49 ,50 ,51 ,52 ,53 ,54 ,55 ,56 ,57 ,58 ,59 ,60 ,61 ,62 ,63 ,64 ,65 ,66 ,67 ,68 ,69 ,70 ,71 ,72 ,73 ,74 ,75 ,76 ,77 ,78 ,79 ,80 ,81 ,82 ,83 ,84 ,85 ,86 ,87 ,88 ,89 ,90 ,91 ,92 ,93 ,94 ,95 ,96 ,97 ,98 ,99", "Camera Switch Mode:", "No of loops :200", "loop:  ,0 ,1 ,2 ,3 ,4 ,5 ,6 ,7 ,8 ,9 ,10 ,11 ,12 ,13");
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes());
            this.mTestInstance.parseOutputFile(this.mTestInfo, byteArrayInputStream, null);
            MetaTest.assertEquals(this.mTestInfo, this.mReportedTestInfo);
            MetaTest.assertNotNull(this.mReportedMetrics);
            Log.e((String)CameraStressTest.LOG_TAG, (String)String.format("Got reported metrics: %s", this.mReportedMetrics.toString()));
            MetaTest.assertEquals(3, this.mReportedMetrics.size());
            MetaTest.assertEquals("43", this.mReportedMetrics.get("image"));
            MetaTest.assertEquals("100", this.mReportedMetrics.get("video"));
            MetaTest.assertEquals("14", this.mReportedMetrics.get("switch"));
        }

        public void testParse_new() throws Exception {
            String string = MetaTest.join("Camera Stress Test result", "/auto/android-test/data/CameraStressTest_git_honeycomb-mr1-release_1700614441c02617_109535_CameraStressOut.txt", "Back Camera Image Capture", "No of loops :100", "loop:  ,0 ,1 ,2 ,3 ,4 ,5 ,6 ,7 ,8 ,9 ,10 ,11 ,12 ,13 ,14 ,15 ,16 ,17 ,18 ,19 ,20 ,21 ,22 ,23 ,24 ,25 ,26 ,27 ,28 ,29 ,30 ,31 ,32 ,33 ,34 ,35 ,36 ,37 ,38 ,39 ,40 ,41 ,42 ,43 ,44 ,45 ,46 ,47 ,48 ,49 ,50 ,51 ,52 ,53 ,54 ,55 ,56 ,57 ,58 ,59 ,60 ,61 ,62 ,63 ,64 ,65 ,66 ,67 ,68 ,69 ,70 ,71 ,72 ,73 ,74 ,75 ,76 ,77 ,78 ,79 ,80 ,81 ,82 ,83 ,84 ,85 ,86 ,87 ,88 ,89 ,90 ,91 ,92 ,93 ,94 ,95 ,96 ,97 ,98 ,99", "Front Camera Image Capture", "No of loops :100", "loop:  ,0 ,1 ,2 ,3 ,4 ,5 ,6 ,7 ,8 ,9 ,10 ,11 ,12 ,13 ,14 ,15 ,16 ,17 ,18 ,19 ,20 ,21 ,22 ,23 ,24 ,25 ,26 ,27 ,28 ,29 ,30 ,31 ,32 ,33 ,34 ,35 ,36 ,37 ,38 ,39 ,40 ,41 ,42 ,43 ,44 ,45 ,46 ,47 ,48 ,49 ,50 ,51 ,52 ,53 ,54 ,55 ,56 ,57 ,58 ,59 ,60 ,61 ,62 ,63 ,64 ,65 ,66 ,67 ,68 ,69 ,70 ,71 ,72 ,73 ,74 ,75 ,76 ,77 ,78 ,79 ,80 ,81 ,82 ,83 ,84 ,85 ,86 ,87 ,88 ,89 ,90 ,91 ,92 ,93 ,94 ,95 ,96 ,97 ,98", "Back Camera Video Capture", "No of loops :100", "loop:  ,0 ,1 ,2 ,3 ,4 ,5 ,6 ,7 ,8 ,9 ,10 ,11 ,12 ,13 ,14 ,15 ,16 ,17 ,18 ,19 ,20 ,21 ,22 ,23 ,24 ,25 ,26 ,27 ,28 ,29 ,30 ,31 ,32 ,33 ,34 ,35 ,36 ,37 ,38 ,39 ,40 ,41 ,42 ,43 ,44 ,45 ,46 ,47 ,48 ,49 ,50 ,51 ,52 ,53 ,54 ,55 ,56 ,57 ,58 ,59 ,60 ,61 ,62 ,63 ,64 ,65 ,66 ,67 ,68 ,69 ,70 ,71 ,72 ,73 ,74 ,75 ,76 ,77 ,78 ,79 ,80 ,81 ,82 ,83 ,84 ,85 ,86 ,87 ,88 ,89 ,90 ,91 ,92 ,93 ,94 ,95 ,96 ,97", "Front Camera Video Capture", "No of loops :100", "loop:  ,0 ,1 ,2 ,3 ,4 ,5 ,6 ,7 ,8 ,9 ,10 ,11 ,12 ,13 ,14 ,15 ,16 ,17 ,18 ,19 ,20 ,21 ,22 ,23 ,24 ,25 ,26 ,27 ,28 ,29 ,30 ,31 ,32 ,33 ,34 ,35 ,36 ,37 ,38 ,39 ,40 ,41 ,42 ,43 ,44 ,45 ,46 ,47 ,48 ,49 ,50 ,51 ,52 ,53 ,54 ,55 ,56 ,57 ,58 ,59 ,60 ,61 ,62 ,63 ,64 ,65 ,66 ,67 ,68 ,69 ,70 ,71 ,72 ,73 ,74 ,75 ,76 ,77 ,78 ,79 ,80 ,81 ,82 ,83 ,84 ,85 ,86 ,87 ,88 ,89 ,90 ,91 ,92 ,93 ,94 ,95 ,96 ,97 ,98 ,99", "Camera Switch Mode:", "No of loops :200", "loop:  ,0 ,1 ,2 ,3 ,4 ,5 ,6 ,7 ,8 ,9 ,10 ,11 ,12 ,13 ,14 ,15 ,16 ,17 ,18 ,19 ,20 ,21 ,22 ,23 ,24 ,25 ,26 ,27 ,28 ,29 ,30 ,31 ,32 ,33 ,34 ,35 ,36 ,37 ,38 ,39 ,40 ,41 ,42 ,43 ,44 ,45 ,46 ,47 ,48 ,49 ,50 ,51 ,52 ,53 ,54 ,55 ,56 ,57 ,58 ,59 ,60 ,61 ,62 ,63 ,64 ,65 ,66 ,67 ,68 ,69 ,70 ,71 ,72 ,73 ,74 ,75 ,76 ,77 ,78 ,79 ,80 ,81 ,82 ,83 ,84 ,85 ,86 ,87 ,88 ,89 ,90 ,91 ,92 ,93 ,94 ,95 ,96 ,97 ,98 ,99 ,100 ,101 ,102 ,103 ,104 ,105 ,106 ,107 ,108 ,109 ,110 ,111 ,112 ,113 ,114 ,115 ,116 ,117 ,118 ,119 ,120 ,121 ,122 ,123 ,124 ,125 ,126 ,127 ,128 ,129 ,130 ,131 ,132 ,133 ,134 ,135 ,136 ,137 ,138 ,139 ,140 ,141 ,142 ,143 ,144 ,145 ,146 ,147 ,148 ,149 ,150 ,151 ,152 ,153 ,154 ,155 ,156 ,157 ,158 ,159 ,160 ,161 ,162 ,163 ,164 ,165 ,166 ,167 ,168 ,169 ,170 ,171 ,172 ,173 ,174 ,175 ,176 ,177 ,178 ,179 ,180 ,181 ,182 ,183 ,184 ,185 ,186 ,187 ,188 ,189 ,190 ,191 ,192 ,193 ,194 ,195 ,196 ,197 ,198 ,199");
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes());
            this.mTestInstance.parseOutputFile(this.mTestInfo, byteArrayInputStream, null);
            MetaTest.assertEquals(this.mTestInfo, this.mReportedTestInfo);
            MetaTest.assertNotNull(this.mReportedMetrics);
            Log.e((String)CameraStressTest.LOG_TAG, (String)String.format("Got reported metrics: %s", this.mReportedMetrics.toString()));
            MetaTest.assertEquals(5, this.mReportedMetrics.size());
            MetaTest.assertEquals("100", this.mReportedMetrics.get("b_image"));
            MetaTest.assertEquals("99", this.mReportedMetrics.get("f_image"));
            MetaTest.assertEquals("98", this.mReportedMetrics.get("b_video"));
            MetaTest.assertEquals("100", this.mReportedMetrics.get("f_video"));
            MetaTest.assertEquals("200", this.mReportedMetrics.get("switch"));
        }
    }

    static class TestInfo {
        public String mTestName = null;
        public String mClassName = null;
        public String mTestMetricsName = null;
        public RegexTrie<String> mPatternMap = new RegexTrie();

        TestInfo() {
        }

        public String toString() {
            return String.format("TestInfo: name(%s) class(%s) metric(%s) patterns(%s)", this.mTestName, this.mClassName, this.mTestMetricsName, this.mPatternMap);
        }
    }
}

