/*
 * Decompiled with CFR 0.152.
 */
package com.android.media.tests;

import com.android.ddmlib.Log;
import com.android.ddmlib.testrunner.IRemoteAndroidTestRunner;
import com.android.ddmlib.testrunner.RemoteAndroidTestRunner;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.result.CollectingTestListener;
import com.android.tradefed.result.ITestInvocationListener;
import com.android.tradefed.result.InputStreamSource;
import com.android.tradefed.result.LogDataType;
import com.android.tradefed.result.SnapshotInputStreamSource;
import com.android.tradefed.testtype.IDeviceTest;
import com.android.tradefed.testtype.IRemoteTest;
import com.android.tradefed.util.RegexTrie;
import com.android.tradefed.util.StreamUtil;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import junit.framework.Assert;
import junit.framework.TestCase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CameraLatencyTest
implements IDeviceTest,
IRemoteTest {
    private static final String LOG_TAG = "CameraLatencyTest";
    ITestDevice mTestDevice = null;
    private static final String TEST_PACKAGE_NAME = "com.google.android.camera.tests";
    private final String mOutputPath = "mediaStressOut.txt";
    private List<TestInfo> mTestCases = new ArrayList<TestInfo>();

    public CameraLatencyTest() {
        TestInfo testInfo = new TestInfo();
        testInfo.mTestName = "latency";
        testInfo.mClassName = "com.android.camera.stress.CameraLatency";
        testInfo.mTestMetricsName = "camera_latency";
        RegexTrie<String> regexTrie = testInfo.mPatternMap;
        regexTrie.put("AutoFocus", "^Avg AutoFocus = (\\d+)");
        regexTrie.put("ShutterLag", "^Avg mShutterLag = (\\d+)");
        regexTrie.put("Preview", "^Avg mShutterToPictureDisplayedTime = (\\d+)");
        regexTrie.put("RawPictureGeneration", "^Avg mPictureDisplayedToJpegCallbackTime = (\\d+)");
        regexTrie.put("GenTimeDiffOverJPEGAndRaw", "^Avg mJpegCallbackFinishTime = (\\d+)");
        this.mTestCases.add(testInfo);
        testInfo = new TestInfo();
        testInfo.mTestName = "startup";
        testInfo.mClassName = "com.android.camera.stress.CameraStartUp";
        testInfo.mTestMetricsName = "camera_video_recorder_startup";
        regexTrie = testInfo.mPatternMap;
        regexTrie.put("FirstCameraStartup", "^First Camera Startup: (\\d+)");
        regexTrie.put("CameraStartup", "^Camera average startup time: (\\d+) ms");
        regexTrie.put("FirstVideoStartup", "^First Video Startup: (\\d+)");
        regexTrie.put("VideoStartup", "^Video average startup time: (\\d+) ms");
        this.mTestCases.add(testInfo);
    }

    @Override
    public void run(ITestInvocationListener iTestInvocationListener) throws DeviceNotAvailableException {
        Assert.assertNotNull(this.mTestDevice);
        for (TestInfo testInfo : this.mTestCases) {
            this.cleanTmpFiles();
            this.executeTest(testInfo, iTestInvocationListener);
            this.logOutputFile(testInfo, iTestInvocationListener);
        }
        this.cleanTmpFiles();
    }

    private void executeTest(TestInfo testInfo, ITestInvocationListener iTestInvocationListener) throws DeviceNotAvailableException {
        RemoteAndroidTestRunner remoteAndroidTestRunner = new RemoteAndroidTestRunner(TEST_PACKAGE_NAME, this.mTestDevice.getIDevice());
        CollectingTestListener collectingTestListener = new CollectingTestListener();
        remoteAndroidTestRunner.setClassName(testInfo.mClassName);
        this.mTestDevice.runInstrumentationTests((IRemoteAndroidTestRunner)remoteAndroidTestRunner, iTestInvocationListener, collectingTestListener);
        if (collectingTestListener.hasFailedTests()) {
            Log.e((String)LOG_TAG, (String)String.format("Grabbing bugreport after test '%s' finished with %d failures and %d errors.", testInfo.mTestName, collectingTestListener.getNumFailedTests(), collectingTestListener.getNumErrorTests()));
            InputStreamSource inputStreamSource = this.mTestDevice.getBugreport();
            iTestInvocationListener.testLog(String.format("bugreport-%s.txt", testInfo.mTestName), LogDataType.TEXT, inputStreamSource);
            inputStreamSource.cancel();
        }
    }

    private void cleanTmpFiles() throws DeviceNotAvailableException {
        String string = this.mTestDevice.getMountPoint("EXTERNAL_STORAGE");
        this.mTestDevice.executeShellCommand(String.format("rm -r -f %s/DCIM", string));
        this.mTestDevice.executeShellCommand(String.format("rm %s/%s", string, "mediaStressOut.txt"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logOutputFile(TestInfo testInfo, ITestInvocationListener iTestInvocationListener) throws DeviceNotAvailableException {
        File file = null;
        InputStreamSource inputStreamSource = null;
        try {
            file = this.mTestDevice.pullFileFromExternal("mediaStressOut.txt");
            Log.d((String)LOG_TAG, (String)String.format("Sending %d byte file %s into the logosphere!", file.length(), file));
            inputStreamSource = new SnapshotInputStreamSource(new FileInputStream(file));
            iTestInvocationListener.testLog(String.format("output-%s.txt", testInfo.mTestName), LogDataType.TEXT, inputStreamSource);
            this.parseOutputFile(testInfo, new FileInputStream(file), iTestInvocationListener);
        }
        catch (IOException iOException) {
            Log.e((String)LOG_TAG, (String)String.format("IOException while reading or parsing output file: %s", iOException));
        }
        finally {
            if (file != null) {
                file.delete();
            }
            if (inputStreamSource != null) {
                inputStreamSource.cancel();
            }
        }
    }

    private void parseOutputFile(TestInfo testInfo, InputStream inputStream, ITestInvocationListener iTestInvocationListener) {
        String string;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        try {
            string = StreamUtil.getStringFromStream(inputStream);
        }
        catch (IOException iOException) {
            Log.e((String)LOG_TAG, (String)String.format("Got IOException during %s test processing: %s", testInfo.mTestName, iOException));
            return;
        }
        List<String> list = Arrays.asList(string.split("\n"));
        ListIterator<String> listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            String string2 = listIterator.next();
            ArrayList<List<String>> arrayList = new ArrayList<List<String>>(1);
            String string3 = testInfo.mPatternMap.retrieve(arrayList, string2);
            if (string3 == null) {
                if (string2.isEmpty()) continue;
                Log.e((String)LOG_TAG, (String)String.format("Got unmatched line: %s", string2));
                continue;
            }
            Log.d((String)LOG_TAG, (String)String.format("Got %s key '%s' and captures '%s'", testInfo.mTestName, string3, ((Object)arrayList).toString()));
            hashMap.put(string3, (String)((List)arrayList.get(0)).get(0));
        }
        this.reportMetrics(iTestInvocationListener, testInfo, hashMap);
    }

    void reportMetrics(ITestInvocationListener iTestInvocationListener, TestInfo testInfo, Map<String, String> map) {
        Log.d((String)LOG_TAG, (String)String.format("About to report metrics for %s: %s", testInfo.mTestMetricsName, map));
        iTestInvocationListener.testRunStarted(testInfo.mTestMetricsName, 0);
        iTestInvocationListener.testRunEnded(0L, map);
    }

    @Override
    public void setDevice(ITestDevice iTestDevice) {
        this.mTestDevice = iTestDevice;
    }

    @Override
    public ITestDevice getDevice() {
        return this.mTestDevice;
    }

    public static class MetaTest
    extends TestCase {
        private CameraLatencyTest mTestInstance = null;
        private TestInfo mTestInfo = null;
        private TestInfo mReportedTestInfo = null;
        private Map<String, String> mReportedMetrics = null;

        private static String join(String ... stringArray) {
            StringBuilder stringBuilder = new StringBuilder();
            for (String string : stringArray) {
                stringBuilder.append(string);
                stringBuilder.append("\n");
            }
            return stringBuilder.toString();
        }

        public void setUp() throws Exception {
            this.mTestInstance = new CameraLatencyTest(){

                @Override
                void reportMetrics(ITestInvocationListener iTestInvocationListener, TestInfo testInfo, Map<String, String> map) {
                    MetaTest.this.mReportedTestInfo = testInfo;
                    MetaTest.this.mReportedMetrics = map;
                }
            };
            TestInfo testInfo = this.mTestInfo = new TestInfo();
            testInfo.mTestName = "startup";
            testInfo.mClassName = "com.android.camera.stress.CameraStartUp";
            testInfo.mTestMetricsName = "camera_video_recorder_startup";
            RegexTrie<String> regexTrie = testInfo.mPatternMap;
            regexTrie.put("FirstCameraStartup", "^First Camera Startup: (\\d+)");
            regexTrie.put("CameraStartup", "^Camera average startup time: (\\d+) ms");
            regexTrie.put("FirstVideoStartup", "^First Video Startup: (\\d+)");
            regexTrie.put("VideoStartup", "^Video average startup time: (\\d+) ms");
        }

        public void testParse() throws Exception {
            String string = MetaTest.join("First Camera Startup: 1421", "Camerastartup time: ", "Number of loop: 19", "Individual Camera Startup Time = 1920 ,1929 ,1924 ,1871 ,1840 ,1892 ,1813 ,1927 ,1856 ,1929 ,1911 ,1873 ,1381 ,1888 ,2405 ,1926 ,1840 ,2502 ,2357 ,", "", "Camera average startup time: 1946 ms", "", "First Video Startup: 2176", "Camera Latency : ", "Number of loop: 20", "Avg AutoFocus = 2304", "Avg mShutterLag = 403", "Avg mShutterToPictureDisplayedTime = 369", "Avg mPictureDisplayedToJpegCallbackTime = 50", "Avg mJpegCallbackFinishTime = 1679");
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes());
            this.mTestInstance.parseOutputFile(this.mTestInfo, byteArrayInputStream, null);
            MetaTest.assertEquals(this.mTestInfo, this.mReportedTestInfo);
            MetaTest.assertNotNull(this.mReportedMetrics);
            MetaTest.assertEquals(3, this.mReportedMetrics.size());
            MetaTest.assertEquals("1946", this.mReportedMetrics.get("CameraStartup"));
            MetaTest.assertEquals("2176", this.mReportedMetrics.get("FirstVideoStartup"));
            MetaTest.assertEquals("1421", this.mReportedMetrics.get("FirstCameraStartup"));
        }
    }

    static class TestInfo {
        public String mTestName = null;
        public String mClassName = null;
        public String mTestMetricsName = null;
        public RegexTrie<String> mPatternMap = new RegexTrie();

        TestInfo() {
        }

        public String toString() {
            return String.format("TestInfo: name(%s) class(%s) metric(%s) patterns(%s)", this.mTestName, this.mClassName, this.mTestMetricsName, this.mPatternMap);
        }
    }
}

