/*
 * Decompiled with CFR 0.152.
 */
package com.android.bluetooth.tests;

import com.android.ddmlib.Log;
import com.android.ddmlib.testrunner.IRemoteAndroidTestRunner;
import com.android.ddmlib.testrunner.RemoteAndroidTestRunner;
import com.android.tradefed.config.Option;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.result.CollectingTestListener;
import com.android.tradefed.result.ITestInvocationListener;
import com.android.tradefed.result.InputStreamSource;
import com.android.tradefed.result.LogDataType;
import com.android.tradefed.result.SnapshotInputStreamSource;
import com.android.tradefed.testtype.IDeviceTest;
import com.android.tradefed.testtype.IRemoteTest;
import com.android.tradefed.util.StreamUtil;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import junit.framework.Assert;
import junit.framework.TestCase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BluetoothStressTest
implements IDeviceTest,
IRemoteTest {
    private static final String LOG_TAG = "BluetoothStressTest";
    ITestDevice mTestDevice = null;
    private static final String TEST_CLASS_NAME = "android.bluetooth.BluetoothStressTest";
    private static final String TEST_PACKAGE_NAME = "com.android.frameworks.coretests";
    private static final String TEST_RUNNER_NAME = "android.bluetooth.BluetoothTestRunner";
    private static final String INSTRUCTIONS_INSTRUMENT_CMD = "adb -s %s shell am instrument -w -r -e device_address %s -e %s %d -e class android.bluetooth.BluetoothStressTest#%s com.android.frameworks.coretests/android.bluetooth.BluetoothTestRunner";
    private static final Pattern ITERATION_PATTERN = Pattern.compile("\\S+ iteration (\\d+) of (\\d+)");
    private static final String METHOD_COMPLETED_STR = "((?:\\w|-)+)\\((?:.*)\\) completed";
    private static final Pattern PERF_PATTERN = Pattern.compile("((?:\\w|-)+)\\((?:.*)\\) completed in (\\d+) ms");
    private static final Pattern METHOD_PATTERN = Pattern.compile("((?:\\w|-)+)\\((?:.*)\\) completed.*");
    private static final String OUTPUT_PATH = "BluetoothStressTestOutput.txt";
    private List<TestInfo> mTestCases = null;
    @Option(name="discoverable-iterations", description="Number of iterations to run for the 'discoverable' test")
    private Integer mDiscoverableIterations = null;
    @Option(name="enable-iterations", description="Number of iterations to run for the 'enable' test")
    private Integer mEnableIterations = null;
    @Option(name="scan-iterations", description="Number of iterations to run for the 'scan' test")
    private Integer mScanIterations = null;
    @Option(name="enable-pan-iterations", description="Number of iterations to run for the 'enable_pan' test")
    private Integer mEnablePanIterations = null;
    @Option(name="pair-iterations", description="Number of iterations to run for the 'pair' test")
    private Integer mPairIterations = 0;
    @Option(name="accept-pair-iterations", description="Number of iterations to run for the 'accept_pair' test")
    private Integer mAcceptPairIterations = 0;
    @Option(name="connect-headset-iterations", description="Number of iterations to run for the 'connect_headset' test")
    private Integer mConnectHeadsetIterations = 0;
    @Option(name="connect-a2dp-iterations", description="Number of iterations to run for the 'connect_a2dp' test")
    private Integer mConnectA2dpIterations = 0;
    @Option(name="connect-input-iterations", description="Number of iterations to run for the 'connect_input' test")
    private Integer mConnectInputIterations = 0;
    @Option(name="connect-pan-iterations", description="Number of iterations to run for the 'connect_pan' test")
    private Integer mConnectPanIterations = 0;
    @Option(name="incoming-pan-connection-iterations", description="Number of iterations to run for the 'incoming_pan_connection' test")
    private Integer mIncomingPanConnectionIterations = 0;
    @Option(name="start-stop-sco-iterations", description="Number of iterations to run for the 'start_stop_sco' test")
    private Integer mStartStopScoIterations = 0;
    @Option(name="local-address", description="Address for the local Android device")
    private String mLocalAddress = null;
    @Option(name="device-serial", description="Serial number for the remote Android device")
    private String mDeviceSerial = null;
    @Option(name="device-address", description="Address for the remote Android device")
    private String mDeviceAddress = null;
    @Option(name="device-pair-pin", description="Pair pin for the remote Android device")
    private String mDevicePairPin = null;
    @Option(name="device-pair-passkey", description="Pair passkey for the remote Android device")
    private String mDevicePairPasskey = null;
    @Option(name="headset-address", description="Address for the headset device")
    private String mHeadsetAddress = null;
    @Option(name="headset-pair-pin", description="Pair pin for the headset device")
    private String mHeadsetPairPin = null;
    @Option(name="headset-pair-passkey", description="Pair passkey for the headset device")
    private String mHeadsetPairPasskey = null;
    @Option(name="a2dp-address", description="Remote device address for the A2DP device")
    private String mA2dpAddress = null;
    @Option(name="a2dp-pair-pin", description="Pair pin for the A2DP device")
    private String mA2dpPairPin = null;
    @Option(name="a2dp-pair-passkey", description="Pair passkey for the A2DP device")
    private String mA2dpPairPasskey = null;
    @Option(name="input-address", description="Remote device address for the input device")
    private String mInputAddress = null;
    @Option(name="input-pair-pin", description="Pair pin for the input device")
    private String mInputPairPin = null;
    @Option(name="input-pair-passkey", description="Pair passkey for the input device")
    private String mInputPairPasskey = null;

    private void setupTests() {
        if (this.mTestCases != null) {
            return;
        }
        this.mTestCases = new ArrayList<TestInfo>(3);
        TestInfo testInfo = new TestInfo();
        testInfo.mTestName = "discoverable";
        testInfo.mTestMethod = "testDiscoverable";
        testInfo.mIterKey = "discoverable_iterations";
        testInfo.mIterCount = this.mDiscoverableIterations;
        testInfo.mPerfMetrics.add("discoverable");
        testInfo.mPerfMetrics.add("undiscoverable");
        this.mTestCases.add(testInfo);
        testInfo = new TestInfo();
        testInfo.mTestName = "enable";
        testInfo.mTestMethod = "testEnable";
        testInfo.mIterKey = "enable_iterations";
        testInfo.mIterCount = this.mEnableIterations;
        testInfo.mPerfMetrics.add("enable");
        testInfo.mPerfMetrics.add("disable");
        this.mTestCases.add(testInfo);
        testInfo = new TestInfo();
        testInfo.mTestName = "scan";
        testInfo.mTestMethod = "testScan";
        testInfo.mIterKey = "scan_iterations";
        testInfo.mIterCount = this.mScanIterations;
        testInfo.mPerfMetrics.add("startScan");
        testInfo.mPerfMetrics.add("stopScan");
        this.mTestCases.add(testInfo);
        testInfo = new TestInfo();
        testInfo.mTestName = "enable_pan";
        testInfo.mTestMethod = "testEnablePan";
        testInfo.mIterKey = "enable_pan_iterations";
        testInfo.mIterCount = this.mEnablePanIterations;
        testInfo.mPerfMetrics.add("enablePan");
        testInfo.mPerfMetrics.add("disablePan");
        this.mTestCases.add(testInfo);
        testInfo = new TestInfo();
        testInfo.mTestName = "pair";
        testInfo.mTestMethod = "testPair";
        testInfo.mIterKey = "pair_iterations";
        testInfo.mIterCount = this.mPairIterations;
        testInfo.mPerfMetrics.add("pair");
        testInfo.mPerfMetrics.add("unpair");
        testInfo.mRemoteAddress = this.mDeviceAddress;
        testInfo.mPairPin = this.mDevicePairPin;
        testInfo.mPairPasskey = this.mDevicePairPasskey;
        testInfo.mInstructions = String.format("Start the testAcceptPair instrumentation on the remote Android device with the following command:\n\n%s\n\nHit Enter when done.", String.format(INSTRUCTIONS_INSTRUMENT_CMD, this.mDeviceSerial, this.mLocalAddress, "pair_iterations", this.mPairIterations, "testAcceptPair"));
        this.mTestCases.add(testInfo);
        testInfo = new TestInfo();
        testInfo.mTestName = "accept_pair";
        testInfo.mTestMethod = "testAcceptPair";
        testInfo.mIterKey = "pair_iterations";
        testInfo.mIterCount = this.mAcceptPairIterations;
        testInfo.mPerfMetrics.add("acceptPair");
        testInfo.mPerfMetrics.add("unpair");
        testInfo.mRemoteAddress = this.mDeviceAddress;
        testInfo.mPairPin = this.mDevicePairPin;
        testInfo.mPairPasskey = this.mDevicePairPasskey;
        testInfo.mInstructions = String.format("Start the testPair instrumentation on the remote Android device with the following command:\n\n%s\n\nHit Enter when done.", String.format(INSTRUCTIONS_INSTRUMENT_CMD, this.mDeviceSerial, this.mLocalAddress, "pair_iterations", this.mAcceptPairIterations, "testPair"));
        this.mTestCases.add(testInfo);
        testInfo = new TestInfo();
        testInfo.mTestName = "connect_headset";
        testInfo.mTestMethod = "testConnectHeadset";
        testInfo.mIterKey = "connect_headset_iterations";
        testInfo.mIterCount = this.mConnectHeadsetIterations;
        testInfo.mPerfMetrics.add("connectHeadset");
        testInfo.mPerfMetrics.add("disconnectHeadset");
        testInfo.mRemoteAddress = this.mHeadsetAddress;
        testInfo.mPairPin = this.mHeadsetPairPin;
        testInfo.mPairPasskey = this.mHeadsetPairPasskey;
        testInfo.mInstructions = "Put the remote headset device in pairing mode. Hit Enter when done.";
        this.mTestCases.add(testInfo);
        testInfo = new TestInfo();
        testInfo.mTestName = "connect_a2dp";
        testInfo.mTestMethod = "testConnectA2dp";
        testInfo.mIterKey = "connect_a2dp_iterations";
        testInfo.mIterCount = this.mConnectA2dpIterations;
        testInfo.mPerfMetrics.add("connectA2dp");
        testInfo.mPerfMetrics.add("disconnectA2dp");
        testInfo.mRemoteAddress = this.mA2dpAddress;
        testInfo.mPairPin = this.mA2dpPairPin;
        testInfo.mPairPasskey = this.mA2dpPairPasskey;
        testInfo.mInstructions = "Put the remote A2DP device in pairing mode. Hit Enter when done.";
        this.mTestCases.add(testInfo);
        testInfo = new TestInfo();
        testInfo.mTestName = "connect_input";
        testInfo.mTestMethod = "testConnectInput";
        testInfo.mIterKey = "connect_input_iterations";
        testInfo.mIterCount = this.mConnectInputIterations;
        testInfo.mPerfMetrics.add("connectInput");
        testInfo.mPerfMetrics.add("disconnectInput");
        testInfo.mRemoteAddress = this.mInputAddress;
        testInfo.mPairPin = this.mInputPairPin;
        testInfo.mPairPasskey = this.mInputPairPasskey;
        testInfo.mInstructions = "Put the remote input device in pairing mode. Hit Enter when done.";
        this.mTestCases.add(testInfo);
        testInfo = new TestInfo();
        testInfo.mTestName = "connect_pan";
        testInfo.mTestMethod = "testConnectPan";
        testInfo.mIterKey = "connect_pan_iterations";
        testInfo.mIterCount = this.mConnectPanIterations;
        testInfo.mPerfMetrics.add("connectPan");
        testInfo.mPerfMetrics.add("disconnectPan");
        testInfo.mRemoteAddress = this.mDeviceAddress;
        testInfo.mPairPin = this.mDevicePairPin;
        testInfo.mPairPasskey = this.mDevicePairPasskey;
        testInfo.mInstructions = String.format("Start the testIncomingPanConnection instrumentation on the remote Android device with the following command:\n\n%s\n\nHit Enter when done.", String.format(INSTRUCTIONS_INSTRUMENT_CMD, this.mDeviceSerial, this.mLocalAddress, "connect_pan_iterations", this.mConnectPanIterations, "testIncomingPanConnection"));
        this.mTestCases.add(testInfo);
        testInfo = new TestInfo();
        testInfo.mTestName = "incoming_pan_connection";
        testInfo.mTestMethod = "testIncomingPanConnection";
        testInfo.mIterKey = "connect_pan_iterations";
        testInfo.mIterCount = this.mIncomingPanConnectionIterations;
        testInfo.mPerfMetrics.add("incomingPanConnection");
        testInfo.mPerfMetrics.add("incomingPanDisconnection");
        testInfo.mRemoteAddress = this.mDeviceAddress;
        testInfo.mPairPin = this.mDevicePairPin;
        testInfo.mPairPasskey = this.mDevicePairPasskey;
        testInfo.mInstructions = "Start the testConnectPan instrumentation on the remote Android device. Hit Enter when done.";
        testInfo.mInstructions = String.format("Start the testConnectPan instrumentation on the remote Android device with the following command:\n\n%s\n\nHit Enter when done.", String.format(INSTRUCTIONS_INSTRUMENT_CMD, this.mDeviceSerial, this.mLocalAddress, "connect_pan_iterations", this.mIncomingPanConnectionIterations, "testConnectPan"));
        this.mTestCases.add(testInfo);
        testInfo = new TestInfo();
        testInfo.mTestName = "start_stop_sco";
        testInfo.mTestMethod = "testStartStopSco";
        testInfo.mIterKey = "start_stop_sco_iterations";
        testInfo.mIterCount = this.mStartStopScoIterations;
        testInfo.mPerfMetrics.add("startSco");
        testInfo.mPerfMetrics.add("stopSco");
        testInfo.mRemoteAddress = this.mHeadsetAddress;
        testInfo.mPairPin = this.mHeadsetPairPin;
        testInfo.mPairPasskey = this.mHeadsetPairPasskey;
        testInfo.mInstructions = "Put the remote headset device in pairing mode. Hit Enter when done.";
        this.mTestCases.add(testInfo);
    }

    @Override
    public void run(ITestInvocationListener iTestInvocationListener) throws DeviceNotAvailableException {
        Assert.assertNotNull(this.mTestDevice);
        this.setupTests();
        RemoteAndroidTestRunner remoteAndroidTestRunner = new RemoteAndroidTestRunner(TEST_PACKAGE_NAME, TEST_RUNNER_NAME, this.mTestDevice.getIDevice());
        remoteAndroidTestRunner.setClassName(TEST_CLASS_NAME);
        for (TestInfo testInfo : this.mTestCases) {
            Object object;
            String string = testInfo.mTestName;
            TestInfo testInfo2 = testInfo;
            CollectingTestListener collectingTestListener = new CollectingTestListener();
            if (testInfo2.mIterCount != null && testInfo2.mIterCount <= 0) {
                Log.e((String)LOG_TAG, (String)String.format("Cancelled '%s' test case with iter count %s", string, testInfo2.mIterCount));
                continue;
            }
            if (testInfo2.mInstructions != null) {
                object = new BufferedReader(new InputStreamReader(System.in));
                System.out.println("========================================");
                System.out.println(testInfo2.mInstructions);
                System.out.println("========================================");
                try {
                    ((BufferedReader)object).readLine();
                }
                catch (IOException iOException) {
                    Log.e((String)LOG_TAG, (String)"IOException waiting for confirmation. Continuing.");
                }
            }
            this.cleanOutputFile();
            if (testInfo2.mIterKey != null && testInfo2.mIterCount != null) {
                remoteAndroidTestRunner.addInstrumentationArg(testInfo2.mIterKey, testInfo2.mIterCount.toString());
            }
            if (testInfo2.mRemoteAddress != null) {
                remoteAndroidTestRunner.addInstrumentationArg("device_address", testInfo2.mRemoteAddress);
                if (testInfo2.mPairPasskey != null) {
                    remoteAndroidTestRunner.addInstrumentationArg("device_pair_passkey", testInfo2.mPairPasskey);
                }
                if (testInfo2.mPairPin != null) {
                    remoteAndroidTestRunner.addInstrumentationArg("device_pair_pin", testInfo2.mPairPin);
                }
            }
            remoteAndroidTestRunner.setMethodName(TEST_CLASS_NAME, testInfo2.mTestMethod);
            this.mTestDevice.runInstrumentationTests((IRemoteAndroidTestRunner)remoteAndroidTestRunner, iTestInvocationListener, collectingTestListener);
            if (testInfo2.mIterKey != null && testInfo2.mIterCount != null) {
                remoteAndroidTestRunner.removeInstrumentationArg(testInfo2.mIterKey);
            }
            if (testInfo2.mRemoteAddress != null) {
                remoteAndroidTestRunner.removeInstrumentationArg("device_address");
                if (testInfo2.mPairPasskey != null) {
                    remoteAndroidTestRunner.removeInstrumentationArg("device_pair_passkey");
                }
                if (testInfo2.mPairPin != null) {
                    remoteAndroidTestRunner.removeInstrumentationArg("device_pair_pin");
                }
            }
            this.logOutputFile(testInfo2, iTestInvocationListener);
            this.cleanOutputFile();
            if (!collectingTestListener.hasFailedTests()) continue;
            Log.e((String)LOG_TAG, (String)String.format("Grabbing bugreport after test '%s' finished with %d failures and %d errors.", string, collectingTestListener.getNumFailedTests(), collectingTestListener.getNumErrorTests()));
            object = this.mTestDevice.getBugreport();
            iTestInvocationListener.testLog(String.format("bugreport-%s.txt", string), LogDataType.TEXT, (InputStreamSource)object);
            object.cancel();
        }
    }

    private void cleanOutputFile() throws DeviceNotAvailableException {
        String string = this.mTestDevice.getMountPoint("EXTERNAL_STORAGE");
        this.mTestDevice.executeShellCommand(String.format("rm %s/%s", string, OUTPUT_PATH));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logOutputFile(TestInfo testInfo, ITestInvocationListener iTestInvocationListener) throws DeviceNotAvailableException {
        File file = null;
        InputStreamSource inputStreamSource = null;
        try {
            file = this.mTestDevice.pullFileFromExternal(OUTPUT_PATH);
            if (file != null) {
                Log.d((String)LOG_TAG, (String)String.format("Sending %d byte file %s into the logosphere!", file.length(), file));
                inputStreamSource = new SnapshotInputStreamSource(new FileInputStream(file));
                iTestInvocationListener.testLog(String.format("output-%s.txt", testInfo.mTestName), LogDataType.TEXT, inputStreamSource);
                this.parseOutputFile(testInfo, new FileInputStream(file), iTestInvocationListener);
            }
        }
        catch (IOException iOException) {
            Log.e((String)LOG_TAG, (String)String.format("Got an IO Exception: %s", iOException));
        }
        finally {
            if (file != null) {
                file.delete();
            }
            if (inputStreamSource != null) {
                inputStreamSource.cancel();
            }
        }
    }

    private void parseOutputFile(TestInfo testInfo, InputStream inputStream, ITestInvocationListener iTestInvocationListener) {
        Object object;
        String string;
        try {
            inputStream = new BufferedInputStream(inputStream);
            string = StreamUtil.getStringFromStream(inputStream);
        }
        catch (IOException iOException) {
            Log.e((String)LOG_TAG, (String)String.format("Got IOException: %s", iOException));
            return;
        }
        List<String> list = Arrays.asList(string.split("\n"));
        ListIterator<String> listIterator = list.listIterator();
        Integer n = null;
        HashMap hashMap = new HashMap();
        HashMap<Object, Integer> hashMap2 = new HashMap<Object, Integer>();
        while (listIterator.hasNext()) {
            Object object2;
            String string2 = listIterator.next();
            object = ITERATION_PATTERN.matcher(string2);
            if (((Matcher)object).matches()) {
                n = Integer.parseInt(((Matcher)object).group(1));
                continue;
            }
            if (n == null) continue;
            object = PERF_PATTERN.matcher(string2);
            if (((Matcher)object).matches()) {
                object2 = ((Matcher)object).group(1);
                int n2 = Integer.parseInt(((Matcher)object).group(2));
                if (!hashMap.containsKey(object2)) {
                    hashMap.put(object2, new LinkedList());
                }
                ((List)hashMap.get(object2)).add(n2);
            }
            if (!((Matcher)(object = METHOD_PATTERN.matcher(string2))).matches()) continue;
            object2 = ((Matcher)object).group(1);
            if (!hashMap2.containsKey(object2)) {
                hashMap2.put(object2, 1);
                continue;
            }
            hashMap2.put(object2, (Integer)hashMap2.get(object2) + 1);
        }
        if (n == null) {
            n = 0;
        }
        object = new HashMap();
        for (String string3 : testInfo.mPerfMetrics) {
            Object object3;
            if (hashMap.containsKey(string3)) {
                object3 = (List)hashMap.get(string3);
                String string4 = String.format("performance_%s_mean", string3);
                object.put(string4, Float.toString(BluetoothStressTest.mean((List<Integer>)object3)));
            }
            if (hashMap2.containsKey(string3)) {
                object3 = (Integer)hashMap2.get(string3);
                n = BluetoothStressTest.min(n, (Integer)object3);
                continue;
            }
            n = 0;
        }
        object.put("iterations", n.toString());
        this.reportMetrics(iTestInvocationListener, testInfo, (Map<String, String>)object);
    }

    private static Integer min(Integer n, Integer n2) {
        if (n == null || n.compareTo(n2) > 0) {
            return n2;
        }
        return n;
    }

    private static float mean(List<Integer> list) {
        int n = 0;
        for (Integer n2 : list) {
            n += n2.intValue();
        }
        return (float)n / (float)list.size();
    }

    void reportMetrics(ITestInvocationListener iTestInvocationListener, TestInfo testInfo, Map<String, String> map) {
        Log.d((String)LOG_TAG, (String)String.format("About to report metrics to %s: %s", testInfo.getTestMetricsName(), map));
        iTestInvocationListener.testRunStarted(testInfo.getTestMetricsName(), 0);
        iTestInvocationListener.testRunEnded(0L, map);
    }

    @Override
    public void setDevice(ITestDevice iTestDevice) {
        this.mTestDevice = iTestDevice;
    }

    @Override
    public ITestDevice getDevice() {
        return this.mTestDevice;
    }

    public static class MetaTest
    extends TestCase {
        private BluetoothStressTest mTestInstance = null;
        private TestInfo mScanInfo = null;
        private TestInfo mReportedTestInfo = null;
        private Map<String, String> mReportedMetrics = null;

        private static String join(String ... stringArray) {
            StringBuilder stringBuilder = new StringBuilder();
            for (String string : stringArray) {
                stringBuilder.append(string);
                stringBuilder.append("\n");
            }
            return stringBuilder.toString();
        }

        public void setUp() throws Exception {
            this.mTestInstance = new BluetoothStressTest(){

                @Override
                void reportMetrics(ITestInvocationListener iTestInvocationListener, TestInfo testInfo, Map<String, String> map) {
                    MetaTest.this.mReportedTestInfo = testInfo;
                    MetaTest.this.mReportedMetrics = map;
                }
            };
            this.mScanInfo = new TestInfo();
            this.mScanInfo.mTestName = "scan";
            this.mScanInfo.mTestMethod = "testScan";
            this.mScanInfo.mIterCount = 1;
            this.mScanInfo.mPerfMetrics.add("startScan");
            this.mScanInfo.mPerfMetrics.add("stopScan");
        }

        public void testParse() throws Exception {
            String string = MetaTest.join("enable() completed in 5759 ms", "scan iteration 1 of 3", "startScan() completed in 102 ms", "stopScan() completed in 104 ms", "scan iteration 2 of 3", "startScan() completed in 103 ms", "stopScan() completed in 106 ms", "scan iteration 3 of 3", "startScan() completed in 107 ms", "stopScan() completed in 103 ms", "disable() completed in 3763 ms");
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes());
            this.mTestInstance.parseOutputFile(this.mScanInfo, byteArrayInputStream, null);
            MetaTest.assertEquals(this.mScanInfo, this.mReportedTestInfo);
            MetaTest.assertNotNull(this.mReportedMetrics);
            MetaTest.assertEquals(3, this.mReportedMetrics.size());
            MetaTest.assertEquals("3", this.mReportedMetrics.get("iterations"));
            MetaTest.assertEquals("104.333", this.mReportedMetrics.get("performance_stopScan_mean").substring(0, 7));
            MetaTest.assertEquals("104.0", this.mReportedMetrics.get("performance_startScan_mean"));
        }

        public void testParse_short() throws Exception {
            String string = MetaTest.join("enable() completed in 5759 ms", "scan iteration 3 of 3", "startScan() completed in 107 ms", "stopScan() completed in 103 ms", "disable() completed in 3763 ms");
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes());
            this.mTestInstance.parseOutputFile(this.mScanInfo, byteArrayInputStream, null);
            MetaTest.assertEquals(this.mScanInfo, this.mReportedTestInfo);
            MetaTest.assertNotNull(this.mReportedMetrics);
            MetaTest.assertEquals(3, this.mReportedMetrics.size());
            MetaTest.assertEquals("1", this.mReportedMetrics.get("iterations"));
            MetaTest.assertEquals("103.0", this.mReportedMetrics.get("performance_stopScan_mean"));
            MetaTest.assertEquals("107.0", this.mReportedMetrics.get("performance_startScan_mean"));
        }

        public void testParse_missingDatums() throws Exception {
            String string = MetaTest.join("enable() completed in 5759 ms", "scan iteration 1 of 3", "startScan() completed in 102 ms", "stopScan() completed", "scan iteration 2 of 3", "startScan() completed in 103 ms", "stopScan() completed", "scan iteration 3 of 3", "startScan() completed in 107 ms", "stopScan() completed", "disable() completed in 3763 ms");
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes());
            this.mTestInstance.parseOutputFile(this.mScanInfo, byteArrayInputStream, null);
            MetaTest.assertEquals(this.mScanInfo, this.mReportedTestInfo);
            MetaTest.assertNotNull(this.mReportedMetrics);
            MetaTest.assertEquals(2, this.mReportedMetrics.size());
            MetaTest.assertEquals("3", this.mReportedMetrics.get("iterations"));
            MetaTest.assertEquals("104.0", this.mReportedMetrics.get("performance_startScan_mean"));
        }

        public void testParse_missingMethods() throws Exception {
            String string = MetaTest.join("enable() completed in 5759 ms", "scan iteration 1 of 3", "startScan() completed in 102 ms", "scan iteration 2 of 3", "startScan() completed in 103 ms", "scan iteration 3 of 3", "startScan() completed in 107 ms", "disable() completed in 3763 ms");
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes());
            this.mTestInstance.parseOutputFile(this.mScanInfo, byteArrayInputStream, null);
            MetaTest.assertEquals(this.mScanInfo, this.mReportedTestInfo);
            MetaTest.assertNotNull(this.mReportedMetrics);
            MetaTest.assertEquals(2, this.mReportedMetrics.size());
            MetaTest.assertEquals("0", this.mReportedMetrics.get("iterations"));
            MetaTest.assertEquals("104.0", this.mReportedMetrics.get("performance_startScan_mean"));
        }

        public void testParse_extras() throws Exception {
            String string = MetaTest.join("enable() completed in 5759 ms", "scan iteration 1 of 3", "startScan(profile=1, device=12:34:45:78:9A:BC) completed in 102 ms", "stopScan(profile=1, device=12:34:45:78:9A:BC) completed in 104 ms", "scan iteration 2 of 3", "startScan(profile=1, device=12:34:45:78:9A:BC) completed in 103 ms", "stopScan(profile=1, device=12:34:45:78:9A:BC) completed in 106 ms", "scan iteration 3 of 3", "startScan(profile=1, device=12:34:45:78:9A:BC) completed in 107 ms", "stopScan(profile=1, device=12:34:45:78:9A:BC) completed in 103 ms", "disable() completed in 3763 ms");
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes());
            this.mTestInstance.parseOutputFile(this.mScanInfo, byteArrayInputStream, null);
            MetaTest.assertEquals(this.mScanInfo, this.mReportedTestInfo);
            MetaTest.assertNotNull(this.mReportedMetrics);
            MetaTest.assertEquals(3, this.mReportedMetrics.size());
            MetaTest.assertEquals("3", this.mReportedMetrics.get("iterations"));
            MetaTest.assertEquals("104.333", this.mReportedMetrics.get("performance_stopScan_mean").substring(0, 7));
            MetaTest.assertEquals("104.0", this.mReportedMetrics.get("performance_startScan_mean"));
        }

        public void testParse_ignoreSetup() throws Exception {
            String string = MetaTest.join("enable() completed in 5759 ms", "stopScan() completed in 10000 ms", "scan iteration 1 of 3", "startScan() completed in 102 ms", "stopScan() completed in 104 ms", "scan iteration 2 of 3", "startScan() completed in 103 ms", "stopScan() completed in 106 ms", "scan iteration 3 of 3", "startScan() completed in 107 ms", "stopScan() completed in 103 ms", "disable() completed in 3763 ms");
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes());
            this.mTestInstance.parseOutputFile(this.mScanInfo, byteArrayInputStream, null);
            MetaTest.assertEquals(this.mScanInfo, this.mReportedTestInfo);
            MetaTest.assertNotNull(this.mReportedMetrics);
            MetaTest.assertEquals(3, this.mReportedMetrics.size());
            MetaTest.assertEquals("3", this.mReportedMetrics.get("iterations"));
            MetaTest.assertEquals("104.333", this.mReportedMetrics.get("performance_stopScan_mean").substring(0, 7));
            MetaTest.assertEquals("104.0", this.mReportedMetrics.get("performance_startScan_mean"));
        }
    }

    static class TestInfo {
        public String mTestName = null;
        public String mTestMethod = null;
        public String mIterKey = null;
        public Integer mIterCount = null;
        public Set<String> mPerfMetrics = new HashSet<String>();
        public boolean mRemoteDeviceTest = false;
        public String mRemoteAddress = null;
        public String mPairPin = null;
        public String mPairPasskey = null;
        public String mInstructions = null;

        TestInfo() {
        }

        public String getTestMetricsName() {
            if (this.mTestName == null) {
                return null;
            }
            return String.format("bt_%s_stress", this.mTestName);
        }

        public String toString() {
            String string = null;
            if (this.mPerfMetrics != null) {
                string = this.mPerfMetrics.toString();
            }
            return String.format("TestInfo: method(%s) iters(%s) metrics(%s)", this.mTestMethod, this.mIterCount, string);
        }
    }
}

