/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.internal.cocoa.NSAffineTransform;
import org.eclipse.swt.internal.cocoa.NSAttributedString;
import org.eclipse.swt.internal.cocoa.NSCell;
import org.eclipse.swt.internal.cocoa.NSGraphicsContext;
import org.eclipse.swt.internal.cocoa.NSObject;
import org.eclipse.swt.internal.cocoa.NSOutlineView;
import org.eclipse.swt.internal.cocoa.NSRect;
import org.eclipse.swt.internal.cocoa.NSSize;
import org.eclipse.swt.internal.cocoa.NSString;
import org.eclipse.swt.internal.cocoa.NSTableColumn;
import org.eclipse.swt.internal.cocoa.NSTableHeaderCell;
import org.eclipse.swt.internal.cocoa.NSTableHeaderView;
import org.eclipse.swt.internal.cocoa.NSView;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TypedListener;

public class TreeColumn
extends Item {
    NSTableColumn nsColumn;
    Tree parent;
    String toolTipText;
    String displayText;
    boolean movable;
    static final int MARGIN = 2;

    public TreeColumn(Tree tree, int n) {
        super(tree, TreeColumn.checkStyle(n));
        this.parent = tree;
        tree.createItem(this, tree.columnCount);
    }

    public TreeColumn(Tree tree, int n, int n2) {
        super(tree, TreeColumn.checkStyle(n));
        this.parent = tree;
        tree.createItem(this, n2);
    }

    public void addControlListener(ControlListener controlListener) {
        this.checkWidget();
        if (controlListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(controlListener);
        this.addListener(11, typedListener);
        this.addListener(10, typedListener);
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    static int checkStyle(int n) {
        return TreeColumn.checkBits(n, 16384, 0x1000000, 131072, 0, 0, 0);
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    void deregister() {
        super.deregister();
        this.display.removeWidget(this.nsColumn.headerCell());
    }

    void destroyWidget() {
        this.parent.destroyItem(this);
        this.releaseHandle();
    }

    void drawInteriorWithFrame_inView(long l, long l2, NSRect nSRect, long l3) {
        NSRect nSRect2;
        int n = this.parent.indexOf(this.nsColumn);
        NSRect nSRect3 = this.parent.headerView.headerRectOfColumn(n);
        if (nSRect3.x != nSRect.x || nSRect3.width != nSRect.width) {
            return;
        }
        NSGraphicsContext nSGraphicsContext = NSGraphicsContext.currentContext();
        nSGraphicsContext.saveGraphicsState();
        int n2 = 0;
        NSSize nSSize = null;
        NSSize nSSize2 = null;
        NSAttributedString nSAttributedString = null;
        NSTableHeaderCell nSTableHeaderCell = this.nsColumn.headerCell();
        if (this.displayText != null) {
            Font font = Font.cocoa_new(this.display, nSTableHeaderCell.font());
            nSAttributedString = this.parent.createString(this.displayText, font, null, 16384, (this.parent.state & 8) == 0, false);
            nSSize = nSAttributedString.size();
            n2 = (int)((double)n2 + Math.ceil(nSSize.width));
            if (this.image != null) {
                n2 += 2;
            }
        }
        if (this.image != null) {
            nSSize2 = this.image.handle.size();
            n2 = (int)((double)n2 + Math.ceil(nSSize2.width));
        }
        if (this.parent.sortColumn == this && this.parent.sortDirection != 0) {
            boolean bl = this.parent.sortDirection == 128;
            nSTableHeaderCell.drawSortIndicatorWithFrame(nSRect, new NSView(l3), bl, 0L);
            nSRect2 = nSTableHeaderCell.sortIndicatorRectForBounds(nSRect);
            nSRect.width = Math.max(0.0, nSRect2.x - nSRect.x);
        }
        int n3 = 0;
        n3 = (this.style & 0x1000000) != 0 ? (int)(nSRect.x + Math.max(2.0, (nSRect.width - (double)n2) / 2.0)) : ((this.style & 0x20000) != 0 ? (int)(nSRect.x + Math.max(2.0, nSRect.width - (double)n2 - 2.0)) : (int)nSRect.x + 2);
        if (this.image != null) {
            Object object;
            nSRect2 = new NSRect();
            nSRect2.x = n3;
            nSRect2.y = nSRect.y;
            nSRect2.width = Math.min(nSSize2.width, nSRect.width - 4.0);
            nSRect2.height = Math.min(nSSize2.height, nSRect.height);
            boolean bl = new NSView(l3).isFlipped();
            if (bl) {
                nSGraphicsContext.saveGraphicsState();
                object = NSAffineTransform.transform();
                ((NSAffineTransform)object).scaleXBy(1.0, -1.0);
                ((NSAffineTransform)object).translateXBy(0.0, -(nSRect2.height + 2.0 * nSRect2.y));
                ((NSAffineTransform)object).concat();
            }
            object = new NSRect();
            ((NSRect)object).width = nSRect2.width;
            ((NSRect)object).height = nSRect2.height;
            this.image.handle.drawInRect(nSRect2, (NSRect)object, 2L, 1.0);
            if (bl) {
                nSGraphicsContext.restoreGraphicsState();
            }
            n3 = (int)((double)n3 + nSRect2.width);
        }
        if (this.displayText != null && this.displayText.length() > 0) {
            if (this.image != null) {
                n3 += 2;
            }
            nSRect2 = new NSRect();
            nSRect2.x = n3;
            nSRect2.y = nSRect.y;
            nSRect2.width = Math.min(nSSize.width, nSRect.x + nSRect.width - 2.0 - (double)n3);
            nSRect2.height = Math.min(nSSize.height, nSRect.height);
            nSAttributedString.drawInRect(nSRect2);
        }
        if (nSAttributedString != null) {
            nSAttributedString.release();
        }
        nSGraphicsContext.restoreGraphicsState();
    }

    public int getAlignment() {
        this.checkWidget();
        if ((this.style & 0x4000) != 0) {
            return 16384;
        }
        if ((this.style & 0x1000000) != 0) {
            return 0x1000000;
        }
        if ((this.style & 0x20000) != 0) {
            return 131072;
        }
        return 16384;
    }

    String getNameText() {
        return this.getText();
    }

    public Tree getParent() {
        this.checkWidget();
        return this.parent;
    }

    public boolean getMoveable() {
        this.checkWidget();
        return this.movable;
    }

    public boolean getResizable() {
        this.checkWidget();
        return this.nsColumn.resizingMask() != 0L;
    }

    public String getToolTipText() {
        this.checkWidget();
        return this.toolTipText;
    }

    public int getWidth() {
        this.checkWidget();
        int n = (int)this.nsColumn.width();
        if (n > 0) {
            ++n;
        }
        return n;
    }

    public void pack() {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        this.checkWidget();
        int n = 0;
        if (this.displayText != null) {
            object4 = this.nsColumn.headerCell();
            object3 = Font.cocoa_new(this.display, ((NSCell)object4).font());
            object2 = this.parent.createString(this.displayText, (Font)object3, null, 0, true, false);
            object = ((NSAttributedString)object2).size();
            ((NSObject)object2).release();
            n = (int)((double)n + Math.ceil(((NSSize)object).width));
            if (this.image != null) {
                n += 2;
            }
        }
        if (this.image != null) {
            object4 = this.image.handle.size();
            n = (int)((double)n + Math.ceil(((NSSize)object4).width));
        }
        if (this.parent.sortColumn == this && this.parent.sortDirection != 0) {
            object4 = this.nsColumn.headerCell();
            object3 = new NSRect();
            ((NSRect)object3).height = 3.4028234663852886E38;
            ((NSRect)object3).width = 3.4028234663852886E38;
            object2 = ((NSCell)object4).cellSizeForBounds((NSRect)object3);
            ((NSRect)object3).height = ((NSSize)object2).height;
            object = ((NSTableHeaderCell)object4).sortIndicatorRectForBounds((NSRect)object3);
            n = (int)((double)n + Math.ceil(((NSRect)object).width));
        }
        object4 = new GC(this.parent);
        n = Math.max(n, this.parent.calculateWidth(this.parent.items, this.parent.indexOf(this), (GC)object4, true));
        ((Resource)object4).dispose();
        this.setWidth(n);
    }

    void releaseHandle() {
        super.releaseHandle();
        if (this.nsColumn != null) {
            this.nsColumn.headerCell().release();
            this.nsColumn.release();
        }
        this.nsColumn = null;
        this.parent = null;
    }

    void releaseWidget() {
        super.releaseWidget();
        if (this.parent.sortColumn == this) {
            this.parent.sortColumn = null;
        }
    }

    public void removeControlListener(ControlListener controlListener) {
        this.checkWidget();
        if (controlListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(10, controlListener);
        this.eventTable.unhook(11, controlListener);
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, selectionListener);
        this.eventTable.unhook(14, selectionListener);
    }

    public void setAlignment(int n) {
        this.checkWidget();
        if ((n & 0x1024000) == 0) {
            return;
        }
        int n2 = this.parent.indexOf(this);
        if (n2 == -1 || n2 == 0) {
            return;
        }
        this.style &= 0xFEFDBFFF;
        this.style |= n & 0x1024000;
        NSOutlineView nSOutlineView = (NSOutlineView)this.parent.view;
        NSTableHeaderView nSTableHeaderView = nSOutlineView.headerView();
        if (nSTableHeaderView == null) {
            return;
        }
        n2 = this.parent.indexOf(this.nsColumn);
        NSRect nSRect = nSTableHeaderView.headerRectOfColumn(n2);
        nSTableHeaderView.setNeedsDisplayInRect(nSRect);
        nSRect = nSOutlineView.rectOfColumn(n2);
        this.parent.view.setNeedsDisplayInRect(nSRect);
    }

    public void setImage(Image image) {
        this.checkWidget();
        if (image != null && image.isDisposed()) {
            this.error(5);
        }
        super.setImage(image);
        NSTableHeaderView nSTableHeaderView = ((NSOutlineView)this.parent.view).headerView();
        if (nSTableHeaderView == null) {
            return;
        }
        int n = this.parent.indexOf(this.nsColumn);
        NSRect nSRect = nSTableHeaderView.headerRectOfColumn(n);
        nSTableHeaderView.setNeedsDisplayInRect(nSRect);
    }

    public void setMoveable(boolean bl) {
        this.checkWidget();
        this.movable = bl;
    }

    public void setResizable(boolean bl) {
        this.checkWidget();
        this.nsColumn.setResizingMask(bl ? 2 : 0);
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        super.setText(string);
        char[] cArray = new char[this.text.length()];
        this.text.getChars(0, cArray.length, cArray, 0);
        int n = this.fixMnemonic(cArray);
        this.displayText = new String(cArray, 0, n);
        NSString nSString = NSString.stringWith(this.displayText);
        this.nsColumn.headerCell().setTitle(nSString);
        NSTableHeaderView nSTableHeaderView = ((NSOutlineView)this.parent.view).headerView();
        if (nSTableHeaderView == null) {
            return;
        }
        int n2 = this.parent.indexOf(this.nsColumn);
        NSRect nSRect = nSTableHeaderView.headerRectOfColumn(n2);
        nSTableHeaderView.setNeedsDisplayInRect(nSRect);
    }

    public void setToolTipText(String string) {
        this.checkWidget();
        this.toolTipText = string;
        this.parent.checkToolTip(this);
    }

    public void setWidth(int n) {
        this.checkWidget();
        if (n < 0) {
            return;
        }
        n = Math.max(0, n - 1);
        this.nsColumn.setWidth(n);
    }

    String tooltipText() {
        return this.toolTipText;
    }
}

