/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.runtime;

import groovy.lang.Closure;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.codehaus.groovy.reflection.CachedClass;
import org.codehaus.groovy.reflection.CachedMethod;
import org.codehaus.groovy.reflection.ReflectionCache;
import org.codehaus.groovy.runtime.metaclass.NewInstanceMetaMethod;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroovyCategorySupport {
    private static AtomicInteger categoriesInUse = new AtomicInteger();
    private static final MyThreadLocal threadInfo = new MyThreadLocal();

    public static AtomicInteger getCategoryNameUsage(String name) {
        return threadInfo.getUsage(name);
    }

    public static Object use(Class categoryClass, Closure closure) {
        return GroovyCategorySupport.threadInfo.getInfo().use(categoryClass, closure);
    }

    public static Object use(List<Class> categoryClasses, Closure closure) {
        return threadInfo.getInfo().use(categoryClasses, closure);
    }

    public static boolean hasCategoryInCurrentThread() {
        return categoriesInUse.get() != 0 && GroovyCategorySupport.threadInfo.getInfo().level != 0;
    }

    public static boolean hasCategoryInAnyThread() {
        return categoriesInUse.get() != 0;
    }

    public static CategoryMethodList getCategoryMethods(String name) {
        return threadInfo.getInfo().getCategoryMethods(name);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MyThreadLocal
    extends ThreadLocal<SoftReference> {
        ConcurrentHashMap<String, AtomicInteger> usage = new ConcurrentHashMap();

        private MyThreadLocal() {
        }

        @Override
        protected SoftReference initialValue() {
            return new SoftReference<ThreadCategoryInfo>(new ThreadCategoryInfo());
        }

        public ThreadCategoryInfo getInfo() {
            ThreadCategoryInfo tcinfo = (ThreadCategoryInfo)((SoftReference)this.get()).get();
            if (tcinfo == null) {
                tcinfo = new ThreadCategoryInfo();
                this.set(new SoftReference<ThreadCategoryInfo>(tcinfo));
            }
            return tcinfo;
        }

        public AtomicInteger getUsage(String name) {
            AtomicInteger u = this.usage.get(name);
            if (u != null) {
                return u;
            }
            AtomicInteger ai = new AtomicInteger();
            AtomicInteger prev = this.usage.putIfAbsent(name, ai);
            return prev == null ? ai : prev;
        }
    }

    private static class CategoryMethod
    extends NewInstanceMetaMethod
    implements Comparable {
        private final Class metaClass;

        public CategoryMethod(CachedMethod metaMethod, Class metaClass) {
            super(metaMethod);
            this.metaClass = metaClass;
        }

        public boolean isCacheable() {
            return false;
        }

        public int compareTo(Object o) {
            CategoryMethod thatMethod = (CategoryMethod)o;
            Class thisClass = this.metaClass;
            Class thatClass = thatMethod.metaClass;
            if (thisClass == thatClass) {
                return 0;
            }
            if (this.isChildOfParent(thisClass, thatClass)) {
                return -1;
            }
            if (this.isChildOfParent(thatClass, thisClass)) {
                return 1;
            }
            return 0;
        }

        private boolean isChildOfParent(Class candidateChild, Class candidateParent) {
            Class loop = candidateChild;
            while (loop != null && loop != Object.class) {
                if ((loop = loop.getSuperclass()) != candidateParent) continue;
                return true;
            }
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ThreadCategoryInfo
    extends HashMap<String, CategoryMethodList> {
        int level;

        private void newScope() {
            categoriesInUse.incrementAndGet();
            ++this.level;
        }

        private void endScope() {
            Iterator it = this.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry e = it.next();
                CategoryMethodList list = (CategoryMethodList)e.getValue();
                if (list.level != this.level) continue;
                CategoryMethodList prev = list.previous;
                if (prev == null) {
                    it.remove();
                    list.usage.addAndGet(-list.size());
                    continue;
                }
                e.setValue(prev);
                list.usage.addAndGet(prev.size() - list.size());
            }
            --this.level;
            categoriesInUse.getAndDecrement();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Object use(Class categoryClass, Closure closure) {
            this.newScope();
            try {
                this.use(categoryClass);
                Object object = closure.call();
                return object;
            }
            finally {
                this.endScope();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object use(List<Class> categoryClasses, Closure closure) {
            this.newScope();
            try {
                for (Class categoryClass : categoryClasses) {
                    this.use(categoryClass);
                }
                Object object = closure.call();
                return object;
            }
            finally {
                this.endScope();
            }
        }

        private void applyUse(CachedClass cachedClass) {
            CachedMethod[] methods;
            for (CachedMethod cachedMethod : methods = cachedClass.getMethods()) {
                CachedClass[] paramTypes;
                if (!cachedMethod.isStatic() || !cachedMethod.isPublic() || (paramTypes = cachedMethod.getParameterTypes()).length <= 0) continue;
                CachedClass metaClass = paramTypes[0];
                CategoryMethod mmethod = new CategoryMethod(cachedMethod, metaClass.getTheClass());
                String name = cachedMethod.getName();
                CategoryMethodList list = (CategoryMethodList)this.get(name);
                if (list == null || list.level != this.level) {
                    list = new CategoryMethodList(name, this.level, list);
                    this.put(name, list);
                }
                list.add(mmethod);
                Collections.sort(list);
            }
        }

        private void use(Class categoryClass) {
            CachedClass cachedClass = ReflectionCache.getCachedClass(categoryClass);
            LinkedList<CachedClass> classStack = new LinkedList<CachedClass>();
            CachedClass superClass = cachedClass;
            while (superClass.getTheClass() != Object.class) {
                classStack.add(superClass);
                superClass = superClass.getCachedSuperClass();
            }
            while (!classStack.isEmpty()) {
                CachedClass klazz = (CachedClass)classStack.removeLast();
                this.applyUse(klazz);
            }
        }

        public CategoryMethodList getCategoryMethods(String name) {
            return this.level == 0 ? null : (CategoryMethodList)this.get(name);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CategoryMethodList
    extends ArrayList<CategoryMethod> {
        public final int level;
        final CategoryMethodList previous;
        final AtomicInteger usage;

        public CategoryMethodList(String name, int level, CategoryMethodList previous) {
            this.level = level;
            this.previous = previous;
            if (previous != null) {
                this.addAll(previous);
                this.usage = previous.usage;
            } else {
                this.usage = GroovyCategorySupport.getCategoryNameUsage(name);
            }
        }

        @Override
        public boolean add(CategoryMethod o) {
            this.usage.incrementAndGet();
            return super.add(o);
        }
    }
}

