/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.cocoa.NSArray;
import org.eclipse.swt.internal.cocoa.NSFont;
import org.eclipse.swt.internal.cocoa.NSGraphicsContext;
import org.eclipse.swt.internal.cocoa.NSMutableArray;
import org.eclipse.swt.internal.cocoa.NSNumber;
import org.eclipse.swt.internal.cocoa.NSPoint;
import org.eclipse.swt.internal.cocoa.NSRect;
import org.eclipse.swt.internal.cocoa.NSString;
import org.eclipse.swt.internal.cocoa.NSView;
import org.eclipse.swt.internal.cocoa.OS;
import org.eclipse.swt.internal.cocoa.SWTView;
import org.eclipse.swt.internal.cocoa.id;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;

public class ToolBar
extends Composite {
    int itemCount;
    ToolItem[] items;
    NSArray accessibilityAttributes = null;

    public ToolBar(Composite composite, int n) {
        super(composite, ToolBar.checkStyle(n));
        this.style = (n & 0x200) != 0 ? (this.style |= 0x200) : (this.style |= 0x100);
    }

    long accessibilityAttributeNames(long l, long l2) {
        if (this.accessibilityAttributes == null) {
            NSMutableArray nSMutableArray = NSMutableArray.arrayWithCapacity(10L);
            nSMutableArray.addObject(OS.NSAccessibilityRoleAttribute);
            nSMutableArray.addObject(OS.NSAccessibilityRoleDescriptionAttribute);
            nSMutableArray.addObject(OS.NSAccessibilityParentAttribute);
            nSMutableArray.addObject(OS.NSAccessibilityPositionAttribute);
            nSMutableArray.addObject(OS.NSAccessibilitySizeAttribute);
            nSMutableArray.addObject(OS.NSAccessibilityWindowAttribute);
            nSMutableArray.addObject(OS.NSAccessibilityTopLevelUIElementAttribute);
            nSMutableArray.addObject(OS.NSAccessibilityHelpAttribute);
            nSMutableArray.addObject(OS.NSAccessibilityEnabledAttribute);
            nSMutableArray.addObject(OS.NSAccessibilityFocusedAttribute);
            nSMutableArray.addObject(OS.NSAccessibilityChildrenAttribute);
            if (this.accessible != null) {
                NSMutableArray nSMutableArray2 = NSMutableArray.arrayWithCapacity(3L);
                nSMutableArray2.addObject(OS.NSAccessibilityHelpAttribute);
                nSMutableArray2.addObject(OS.NSAccessibilityDescriptionAttribute);
                nSMutableArray2.addObject(OS.NSAccessibilityTitleAttribute);
                int n = (int)nSMutableArray2.count() - 1;
                while (n >= 0) {
                    NSString nSString = new NSString(nSMutableArray2.objectAtIndex((long)((long)n)).id);
                    if (this.accessible.internal_accessibilityAttributeValue(nSString, -1) != null) {
                        nSMutableArray.addObject(nSMutableArray2.objectAtIndex(n));
                    }
                    --n;
                }
            }
            this.accessibilityAttributes = nSMutableArray;
            this.accessibilityAttributes.retain();
        }
        return this.accessibilityAttributes.id;
    }

    long accessibilityAttributeValue(long l, long l2, long l3) {
        id id2;
        NSString nSString = new NSString(l3);
        if (this.accessible != null && (id2 = this.accessible.internal_accessibilityAttributeValue(nSString, -1)) != null) {
            return id2.id;
        }
        if (nSString.isEqualToString(OS.NSAccessibilityRoleAttribute) || nSString.isEqualToString(OS.NSAccessibilityRoleDescriptionAttribute)) {
            id2 = OS.NSAccessibilityToolbarRole;
            if (nSString.isEqualToString(OS.NSAccessibilityRoleAttribute)) {
                return ((NSString)id2).id;
            }
            long l4 = OS.NSAccessibilityRoleDescription(((NSString)id2).id, 0L);
            return l4;
        }
        if (nSString.isEqualToString(OS.NSAccessibilityEnabledAttribute)) {
            return NSNumber.numberWithBool((boolean)this.isEnabled()).id;
        }
        if (nSString.isEqualToString(OS.NSAccessibilityFocusedAttribute)) {
            boolean bl = this.view.id == this.view.window().firstResponder().id;
            return NSNumber.numberWithBool((boolean)bl).id;
        }
        return super.accessibilityAttributeValue(l, l2, l3);
    }

    boolean accessibilityIsIgnored(long l, long l2) {
        return false;
    }

    static int checkStyle(int n) {
        return n & 0xFFFFFCFF;
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    public Point computeSize(int n, int n2, boolean bl) {
        this.checkWidget();
        int n3 = n;
        int n4 = n2;
        if (n == -1) {
            n3 = Integer.MAX_VALUE;
        }
        if (n2 == -1) {
            n4 = Integer.MAX_VALUE;
        }
        int[] nArray = this.layout(n3, n4, false);
        Point point = new Point(nArray[1], nArray[2]);
        if (n != -1) {
            point.x = n;
        }
        if (n2 != -1) {
            point.y = n2;
        }
        return point;
    }

    void createHandle() {
        this.state |= 0x800;
        NSView nSView = (NSView)new SWTView().alloc();
        nSView.init();
        this.view = nSView;
    }

    void createItem(ToolItem toolItem, int n) {
        if (n < 0 || n > this.itemCount) {
            this.error(6);
        }
        if (this.itemCount == this.items.length) {
            ToolItem[] toolItemArray = new ToolItem[this.itemCount + 4];
            System.arraycopy(this.items, 0, toolItemArray, 0, this.items.length);
            this.items = toolItemArray;
        }
        toolItem.createWidget();
        this.view.addSubview(toolItem.view);
        System.arraycopy(this.items, n, this.items, n + 1, this.itemCount++ - n);
        this.items[n] = toolItem;
        this.relayout();
    }

    void createWidget() {
        super.createWidget();
        this.items = new ToolItem[4];
        this.itemCount = 0;
    }

    void destroyItem(ToolItem toolItem) {
        int n = 0;
        while (n < this.itemCount) {
            if (this.items[n] == toolItem) break;
            ++n;
        }
        if (n == this.itemCount) {
            return;
        }
        System.arraycopy(this.items, n + 1, this.items, n, --this.itemCount - n);
        this.items[this.itemCount] = null;
        toolItem.view.removeFromSuperview();
        this.relayout();
    }

    void drawBackground(long l, NSGraphicsContext nSGraphicsContext, NSRect nSRect) {
        if (l != this.view.id) {
            return;
        }
        if (this.background != null) {
            this.fillBackground(this.view, nSGraphicsContext, nSRect, -1);
        }
    }

    void enableWidget(boolean bl) {
        super.enableWidget(bl);
        int n = 0;
        while (n < this.itemCount) {
            ToolItem toolItem = this.items[n];
            if (toolItem != null) {
                toolItem.enableWidget(bl);
            }
            ++n;
        }
    }

    Widget findTooltip(NSPoint nSPoint) {
        nSPoint = this.view.convertPoint_fromView_(nSPoint, null);
        int n = 0;
        while (n < this.itemCount) {
            ToolItem toolItem = this.items[n];
            if (OS.NSPointInRect(nSPoint, toolItem.view.frame())) {
                return toolItem;
            }
            ++n;
        }
        return super.findTooltip(nSPoint);
    }

    public ToolItem getItem(int n) {
        this.checkWidget();
        if (n >= 0 && n < this.itemCount) {
            return this.items[n];
        }
        this.error(6);
        return null;
    }

    public ToolItem getItem(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        int n = 0;
        while (n < this.itemCount) {
            Rectangle rectangle = this.items[n].getBounds();
            if (rectangle.contains(point)) {
                return this.items[n];
            }
            ++n;
        }
        return null;
    }

    public int getItemCount() {
        this.checkWidget();
        return this.itemCount;
    }

    public ToolItem[] getItems() {
        this.checkWidget();
        ToolItem[] toolItemArray = new ToolItem[this.itemCount];
        System.arraycopy(this.items, 0, toolItemArray, 0, this.itemCount);
        return toolItemArray;
    }

    public int getRowCount() {
        this.checkWidget();
        Rectangle rectangle = this.getClientArea();
        return this.layout(rectangle.width, rectangle.height, false)[0];
    }

    public int indexOf(ToolItem toolItem) {
        this.checkWidget();
        if (toolItem == null) {
            this.error(4);
        }
        if (toolItem.isDisposed()) {
            this.error(5);
        }
        int n = 0;
        while (n < this.itemCount) {
            if (this.items[n] == toolItem) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    int[] layoutHorizontal(int n, int n2, boolean bl) {
        Object object;
        int n3 = 0;
        int n4 = 2;
        int n5 = 0;
        int n6 = 0;
        int n7 = n5;
        int n8 = n6;
        int n9 = 0;
        int n10 = 1;
        boolean bl2 = (this.style & 0x40) != 0;
        int n11 = 0;
        Point[] pointArray = new Point[this.itemCount];
        int n12 = 0;
        while (n12 < this.itemCount) {
            pointArray[n12] = this.items[n12].computeSize();
            object = pointArray[n12];
            n11 = Math.max(n11, ((Point)object).y);
            ++n12;
        }
        n12 = 0;
        while (n12 < this.itemCount) {
            object = this.items[n12];
            Point point = pointArray[n12];
            if (bl2 && n12 != 0 && n7 + point.x > n) {
                ++n10;
                n7 = n5;
                n8 += n4 + n11;
            }
            if (bl) {
                ((ToolItem)object).setBounds(n7, n8, point.x, n11);
                boolean bl3 = n7 + point.x <= n && n8 + n11 <= n2;
                ((ToolItem)object).setVisible(bl3);
                Control control = ((ToolItem)object).control;
                if (control != null) {
                    int n13 = n8 + (n11 - point.y) / 2;
                    control.setBounds(n7, n13, point.x, n11 - (n13 - n8));
                }
            }
            n9 = Math.max(n9, n7 += n3 + point.x);
            ++n12;
        }
        return new int[]{n10, n9, n8 + n11};
    }

    int[] layoutVertical(int n, int n2, boolean bl) {
        Object object;
        int n3 = 2;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = n5;
        int n8 = n6;
        int n9 = 0;
        int n10 = 1;
        boolean bl2 = (this.style & 0x40) != 0;
        int n11 = 0;
        Point[] pointArray = new Point[this.itemCount];
        int n12 = 0;
        while (n12 < this.itemCount) {
            pointArray[n12] = this.items[n12].computeSize();
            object = pointArray[n12];
            n11 = Math.max(n11, ((Point)object).x);
            ++n12;
        }
        n12 = 0;
        while (n12 < this.itemCount) {
            object = this.items[n12];
            Point point = pointArray[n12];
            if (bl2 && n12 != 0 && n8 + point.y > n2) {
                ++n10;
                n7 += n3 + n11;
                n8 = n6;
            }
            if (bl) {
                ((ToolItem)object).setBounds(n7, n8, n11, point.y);
                boolean bl3 = n7 + n11 <= n && n8 + point.y <= n2;
                ((ToolItem)object).setVisible(bl3);
                Control control = ((ToolItem)object).control;
                if (control != null) {
                    int n13 = n7 + (n11 - point.x) / 2;
                    control.setBounds(n13, n8, n11 - (n13 - n7), point.y);
                }
            }
            n9 = Math.max(n9, n8 += n4 + point.y);
            ++n12;
        }
        return new int[]{n10, n7 + n11, n9};
    }

    int[] layout(int n, int n2, boolean bl) {
        if ((this.style & 0x200) != 0) {
            return this.layoutVertical(n, n2, bl);
        }
        return this.layoutHorizontal(n, n2, bl);
    }

    void relayout() {
        if (!this.getDrawing()) {
            return;
        }
        Rectangle rectangle = this.getClientArea();
        this.layout(rectangle.width, rectangle.height, true);
    }

    void releaseChildren(boolean bl) {
        if (this.items != null) {
            int n = 0;
            while (n < this.itemCount) {
                ToolItem toolItem = this.items[n];
                if (toolItem != null && !toolItem.isDisposed()) {
                    toolItem.release(false);
                }
                ++n;
            }
            this.itemCount = 0;
            this.items = null;
        }
        super.releaseChildren(bl);
    }

    void releaseHandle() {
        super.releaseHandle();
        if (this.accessibilityAttributes != null) {
            this.accessibilityAttributes.release();
        }
        this.accessibilityAttributes = null;
    }

    void removeControl(Control control) {
        super.removeControl(control);
        int n = 0;
        while (n < this.itemCount) {
            ToolItem toolItem = this.items[n];
            if (toolItem.control == control) {
                toolItem.setControl(null);
            }
            ++n;
        }
    }

    void resized() {
        super.resized();
        this.relayout();
    }

    void setFont(NSFont nSFont) {
        int n = 0;
        while (n < this.itemCount) {
            ToolItem toolItem = this.items[n];
            if (toolItem.button != null) {
                toolItem.button.setAttributedTitle(toolItem.createString());
            }
            ++n;
        }
    }

    public void setRedraw(boolean bl) {
        this.checkWidget();
        super.setRedraw(bl);
        if (bl && this.drawCount == 0) {
            this.relayout();
        }
    }
}

