/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.theme;

import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.carbon.HIThemeTrackDrawInfo;
import org.eclipse.swt.internal.carbon.OS;
import org.eclipse.swt.internal.carbon.ProgressTrackInfo;
import org.eclipse.swt.internal.theme.RangeDrawData;
import org.eclipse.swt.internal.theme.Theme;

public class ProgressBarDrawData
extends RangeDrawData {
    public ProgressBarDrawData() {
        this.state = new int[1];
    }

    HIThemeTrackDrawInfo getInfo() {
        int n = this.state[0];
        HIThemeTrackDrawInfo hIThemeTrackDrawInfo = new HIThemeTrackDrawInfo();
        hIThemeTrackDrawInfo.min = this.minimum;
        hIThemeTrackDrawInfo.max = this.maximum;
        hIThemeTrackDrawInfo.value = this.selection;
        hIThemeTrackDrawInfo.kind = (short)3;
        hIThemeTrackDrawInfo.attributes = (short)4;
        if ((this.style & 0x100) != 0) {
            hIThemeTrackDrawInfo.attributes = (short)(hIThemeTrackDrawInfo.attributes | 1);
        }
        hIThemeTrackDrawInfo.enableState = (byte)3;
        if ((n & 0x10) != 0) {
            hIThemeTrackDrawInfo.enableState = 0;
        }
        if ((n & 0x20) != 0) {
            hIThemeTrackDrawInfo.enableState = 1;
        }
        hIThemeTrackDrawInfo.progress = new ProgressTrackInfo();
        return hIThemeTrackDrawInfo;
    }

    void draw(Theme theme, GC gC, Rectangle rectangle) {
        HIThemeTrackDrawInfo hIThemeTrackDrawInfo = this.getInfo();
        hIThemeTrackDrawInfo.bounds_x = rectangle.x;
        hIThemeTrackDrawInfo.bounds_y = rectangle.y;
        hIThemeTrackDrawInfo.bounds_width = rectangle.width;
        hIThemeTrackDrawInfo.bounds_height = rectangle.height;
        hIThemeTrackDrawInfo.progress = new ProgressTrackInfo();
        OS.HIThemeDrawTrack(hIThemeTrackDrawInfo, null, gC.handle, 0);
    }

    int hit(Theme theme, Point point, Rectangle rectangle) {
        return rectangle.contains(point) ? 0 : -1;
    }
}

