/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visual.border;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import org.netbeans.api.visual.border.Border;

public final class ImageBorder
implements Border {
    private Insets borderInsets;
    private Insets imageInsets;
    private Image image;
    private int width;
    private int height;
    private int verStep;
    private int horStep;
    private int verEdge;
    private int horEdge;

    public ImageBorder(Insets insets, Insets insets2, Image image) {
        this.borderInsets = insets;
        this.imageInsets = insets2;
        this.image = image;
        this.width = image.getWidth(null);
        this.height = image.getHeight(null);
        this.horEdge = this.width - this.imageInsets.right;
        this.verEdge = this.height - this.imageInsets.bottom;
        this.horStep = this.horEdge - this.imageInsets.left;
        this.verStep = this.verEdge - this.imageInsets.top;
    }

    public Insets getInsets() {
        return this.borderInsets;
    }

    public void paint(Graphics2D graphics2D, Rectangle rectangle) {
        int n = rectangle.y + rectangle.height;
        int n2 = rectangle.x + rectangle.width;
        int n3 = n - this.imageInsets.bottom;
        int n4 = n2 - this.imageInsets.right;
        int n5 = rectangle.width - this.imageInsets.left - this.imageInsets.right;
        int n6 = n5 / this.horStep;
        int n7 = n5 % this.horStep;
        graphics2D.drawImage(this.image, rectangle.x, rectangle.y, rectangle.x + n7 + this.imageInsets.left, rectangle.y + this.imageInsets.top, 0, 0, n7 + this.imageInsets.left, this.imageInsets.top, null);
        graphics2D.drawImage(this.image, n4 - n7, n3, n2, n, this.horEdge - n7, this.verEdge, this.width, this.height, null);
        int n8 = 0;
        int n9 = rectangle.x + n7 + this.imageInsets.left;
        while (n8 < n6) {
            graphics2D.drawImage(this.image, n9, rectangle.y, n9 + this.horStep, rectangle.y + this.imageInsets.top, this.imageInsets.left, 0, this.horEdge, this.imageInsets.top, null);
            graphics2D.drawImage(this.image, n9 - n7, n3, n9 - n7 + this.horStep, n, this.imageInsets.left, this.verEdge, this.horEdge, this.height, null);
            ++n8;
            n9 += this.horStep;
        }
        n8 = rectangle.height - this.imageInsets.top - this.imageInsets.bottom;
        n9 = n8 / this.verStep;
        int n10 = n8 % this.verStep;
        graphics2D.drawImage(this.image, n4, rectangle.y, n2, rectangle.y + n10 + this.imageInsets.top, this.horEdge, 0, this.width, n10 + this.imageInsets.top, null);
        graphics2D.drawImage(this.image, rectangle.x, n3 - n10, rectangle.x + this.imageInsets.left, n, 0, this.verEdge - n10, this.imageInsets.left, this.height, null);
        int n11 = 0;
        int n12 = rectangle.y + n10 + this.imageInsets.top;
        while (n11 < n9) {
            graphics2D.drawImage(this.image, n4, n12, n2, n12 + this.verStep, this.horEdge, this.imageInsets.top, this.width, this.verEdge, null);
            graphics2D.drawImage(this.image, rectangle.x, n12 - n10, rectangle.x + this.imageInsets.left, n12 - n10 + this.verStep, 0, this.imageInsets.top, this.imageInsets.left, this.verEdge, null);
            ++n11;
            n12 += this.verStep;
        }
    }

    public boolean isOpaque() {
        return false;
    }
}

