/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.util.FileUtils;
import org.apache.tools.ant.util.StringUtils;

public class Replace
extends MatchingTask {
    private File src = null;
    private NestedString token = null;
    private NestedString value = new NestedString();
    private File propertyFile = null;
    private File replaceFilterFile = null;
    private Properties properties = null;
    private Vector replacefilters = new Vector();
    private File dir = null;
    private int fileCount;
    private int replaceCount;
    private boolean summary = false;
    private String encoding = null;
    private FileUtils fileUtils = FileUtils.newFileUtils();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws BuildException {
        Vector savedFilters = (Vector)this.replacefilters.clone();
        Properties savedProperties = this.properties == null ? null : (Properties)this.properties.clone();
        try {
            if (this.replaceFilterFile != null) {
                Properties props = this.getProperties(this.replaceFilterFile);
                Enumeration<Object> e = props.keys();
                while (e.hasMoreElements()) {
                    String token = e.nextElement().toString();
                    Replacefilter replaceFilter = this.createReplacefilter();
                    replaceFilter.setToken(token);
                    replaceFilter.setValue(props.getProperty(token));
                }
            }
            this.validateAttributes();
            if (this.propertyFile != null) {
                this.properties = this.getProperties(this.propertyFile);
            }
            this.validateReplacefilters();
            this.fileCount = 0;
            this.replaceCount = 0;
            if (this.src != null) {
                this.processFile(this.src);
            }
            if (this.dir != null) {
                DirectoryScanner ds = super.getDirectoryScanner(this.dir);
                String[] srcs = ds.getIncludedFiles();
                for (int i = 0; i < srcs.length; ++i) {
                    File file = new File(this.dir, srcs[i]);
                    this.processFile(file);
                }
            }
            if (this.summary) {
                this.log("Replaced " + this.replaceCount + " occurrences in " + this.fileCount + " files.", 2);
            }
        }
        finally {
            this.replacefilters = savedFilters;
            this.properties = savedProperties;
        }
    }

    public void validateAttributes() throws BuildException {
        if (this.src == null && this.dir == null) {
            String message = "Either the file or the dir attribute must be specified";
            throw new BuildException(message, this.getLocation());
        }
        if (this.propertyFile != null && !this.propertyFile.exists()) {
            String message = "Property file " + this.propertyFile.getPath() + " does not exist.";
            throw new BuildException(message, this.getLocation());
        }
        if (this.token == null && this.replacefilters.size() == 0) {
            String message = "Either token or a nested replacefilter must be specified";
            throw new BuildException(message, this.getLocation());
        }
        if (this.token != null && "".equals(this.token.getText())) {
            String message = "The token attribute must not be an empty string.";
            throw new BuildException(message, this.getLocation());
        }
    }

    public void validateReplacefilters() throws BuildException {
        for (int i = 0; i < this.replacefilters.size(); ++i) {
            Replacefilter element = (Replacefilter)this.replacefilters.elementAt(i);
            element.validate();
        }
    }

    public Properties getProperties(File propertyFile) throws BuildException {
        Properties properties = new Properties();
        FileInputStream in = null;
        try {
            in = new FileInputStream(propertyFile);
            properties.load(in);
        }
        catch (FileNotFoundException e) {
            String message = "Property file (" + propertyFile.getPath() + ") not found.";
            throw new BuildException(message);
        }
        catch (IOException e) {
            String message = "Property file (" + propertyFile.getPath() + ") cannot be loaded.";
            throw new BuildException(message);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {}
            }
        }
        return properties;
    }

    private void processFile(File src) throws BuildException {
        if (!src.exists()) {
            throw new BuildException("Replace: source file " + src.getPath() + " doesn't exist", this.getLocation());
        }
        File temp = this.fileUtils.createTempFile("rep", ".tmp", this.fileUtils.getParentFile(src));
        temp.deleteOnExit();
        Reader reader = null;
        Writer writer = null;
        try {
            boolean changes;
            reader = this.encoding == null ? new FileReader(src) : new InputStreamReader((InputStream)new FileInputStream(src), this.encoding);
            writer = this.encoding == null ? new FileWriter(temp) : new OutputStreamWriter((OutputStream)new FileOutputStream(temp), this.encoding);
            BufferedReader br = new BufferedReader(reader);
            BufferedWriter bw = new BufferedWriter(writer);
            String buf = FileUtils.readFully(br);
            if (buf == null) {
                buf = "";
            }
            String newString = new String(buf);
            if (this.token != null) {
                String val = this.stringReplace(this.value.getText(), "\r\n", "\n", false);
                val = this.stringReplace(val, "\n", StringUtils.LINE_SEP, false);
                String tok = this.stringReplace(this.token.getText(), "\r\n", "\n", false);
                tok = this.stringReplace(tok, "\n", StringUtils.LINE_SEP, false);
                this.log("Replacing in " + src.getPath() + ": " + this.token.getText() + " --> " + this.value.getText(), 3);
                newString = this.stringReplace(newString, tok, val, true);
            }
            if (this.replacefilters.size() > 0) {
                newString = this.processReplacefilters(newString, src.getPath());
            }
            boolean bl = changes = !newString.equals(buf);
            if (changes) {
                bw.write(newString, 0, newString.length());
                bw.flush();
            }
            bw.close();
            writer = null;
            br.close();
            reader = null;
            if (changes) {
                ++this.fileCount;
                this.fileUtils.rename(temp, src);
                temp = null;
            }
        }
        catch (IOException ioe) {
            throw new BuildException("IOException in " + src + " - " + ioe.getClass().getName() + ":" + ioe.getMessage(), ioe, this.getLocation());
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {}
            }
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException e) {}
            }
            if (temp != null) {
                temp.delete();
            }
        }
    }

    private String processReplacefilters(String buffer, String filename) {
        String newString = new String(buffer);
        for (int i = 0; i < this.replacefilters.size(); ++i) {
            Replacefilter filter = (Replacefilter)this.replacefilters.elementAt(i);
            this.log("Replacing in " + filename + ": " + filter.getToken() + " --> " + filter.getReplaceValue(), 3);
            newString = this.stringReplace(newString, filter.getToken(), filter.getReplaceValue(), true);
        }
        return newString;
    }

    public void setFile(File file) {
        this.src = file;
    }

    public void setSummary(boolean summary) {
        this.summary = summary;
    }

    public void setReplaceFilterFile(File filename) {
        this.replaceFilterFile = filename;
    }

    public void setDir(File dir) {
        this.dir = dir;
    }

    public void setToken(String token) {
        this.createReplaceToken().addText(token);
    }

    public void setValue(String value) {
        this.createReplaceValue().addText(value);
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public NestedString createReplaceToken() {
        if (this.token == null) {
            this.token = new NestedString();
        }
        return this.token;
    }

    public NestedString createReplaceValue() {
        return this.value;
    }

    public void setPropertyFile(File filename) {
        this.propertyFile = filename;
    }

    public Replacefilter createReplacefilter() {
        Replacefilter filter = new Replacefilter();
        this.replacefilters.addElement(filter);
        return filter;
    }

    private String stringReplace(String str, String str1, String str2, boolean countReplaces) {
        StringBuffer ret = new StringBuffer();
        int start = 0;
        int found = str.indexOf(str1);
        while (found >= 0) {
            if (found > start) {
                ret.append(str.substring(start, found));
            }
            if (str2 != null) {
                ret.append(str2);
            }
            start = found + str1.length();
            found = str.indexOf(str1, start);
            if (!countReplaces) continue;
            ++this.replaceCount;
        }
        if (str.length() > start) {
            ret.append(str.substring(start, str.length()));
        }
        return ret.toString();
    }

    public class Replacefilter {
        private String token;
        private String value;
        private String property;

        public void validate() throws BuildException {
            if (this.token == null) {
                String message = "token is a mandatory attribute of replacefilter.";
                throw new BuildException(message);
            }
            if ("".equals(this.token)) {
                String message = "The token attribute must not be an empty string.";
                throw new BuildException(message);
            }
            if (this.value != null && this.property != null) {
                String message = "Either value or property can be specified, but a replacefilter element cannot have both.";
                throw new BuildException(message);
            }
            if (this.property != null) {
                if (Replace.this.propertyFile == null) {
                    String message = "The replacefilter's property attribute can only be used with the replacetask's propertyFile attribute.";
                    throw new BuildException(message);
                }
                if (Replace.this.properties == null || Replace.this.properties.getProperty(this.property) == null) {
                    String message = "property \"" + this.property + "\" was not found in " + Replace.this.propertyFile.getPath();
                    throw new BuildException(message);
                }
            }
        }

        public String getReplaceValue() {
            if (this.property != null) {
                return Replace.this.properties.getProperty(this.property);
            }
            if (this.value != null) {
                return this.value;
            }
            if (Replace.this.value != null) {
                return Replace.this.value.getText();
            }
            return new String("");
        }

        public void setToken(String token) {
            this.token = token;
        }

        public String getToken() {
            return this.token;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public void setProperty(String property) {
            this.property = property;
        }

        public String getProperty() {
            return this.property;
        }
    }

    public class NestedString {
        private StringBuffer buf = new StringBuffer();

        public void addText(String val) {
            this.buf.append(val);
        }

        public String getText() {
            return this.buf.substring(0);
        }
    }
}

