/* Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package tests.api.java.nio.charset;

import dalvik.annotation.AndroidOnly;
import dalvik.annotation.TestTargetClass;

@AndroidOnly("icu different from RI")

public class Charset_MultiByte_GBK_Android extends Charset_AbstractTest {

    @Override
    protected void setUp() throws Exception {
        charsetName = "GBK";

        testChars = theseChars(new int[]{
0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15,
16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47,
48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63,
64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79,
80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95,
96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111,
112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127,
164, 167, 168, 176, 177, 183, 215, 224, 225, 232, 233, 234, 236, 237, 242, 243,
247, 249, 250, 252, 257, 275, 299, 324, 363, 462, 472, 593, 609, 711, 729, 913,
923, 933, 945, 955, 965, 1025, 1040, 1050, 1060, 1070, 1080, 1090, 1100, 8208, 8220, 8230,
8240, 8251, 8451, 8470, 8481, 8544, 8554, 8564, 8592, 8712, 8725, 8735, 8745, 8756, 8776, 8786,
8800, 8814, 8857, 8869, 8895, 8978, 9312, 9332, 9342, 9352, 9362, 9472, 9482, 9492, 9502, 9512,
9522, 9532, 9542, 9552, 9562, 9572, 9582, 9601, 9611, 9621, 9632, 9650, 9660, 9670, 9698, 9733,
9792, 12288, 12298, 12308, 12318, 12328, 12353, 12363, 12373, 12383, 12393, 12403, 12413, 12423, 12433, 12443,
12453, 12463, 12473, 12483, 12493, 12503, 12513, 12523, 12533, 12549, 12559, 12569, 12579, 12832, 12849, 12963,
13198, 13212, 13252, 13262, 19968, 19978, 19988, 19998, 20008, 20018, 20028, 20038, 20048, 20058, 20068, 20078,
20088, 20098, 20108, 20118, 20128, 20138, 20148, 20158, 20168, 20178, 20188, 20198, 20208, 20218, 20228, 20238,
20248, 20258, 20268, 20278, 20288, 20298, 20308, 20318, 20328, 20338, 20348, 20358, 20368, 20378, 20388, 20398,
20408, 20418, 20428, 20438, 20448, 20458, 20468, 20478, 20488, 20498, 20508, 20518, 20528, 20538, 20548, 20558,
20568, 20578, 20588, 20598, 20608, 20618, 20628, 20638, 20648, 20658, 20668, 20678, 20688, 20698, 20708, 20718,
20728, 20738, 20748, 20758, 20768, 20778, 20788, 20798, 20808, 20818, 20828, 20838, 20848, 20858, 20868, 20878,
20888, 20898, 20908, 20918, 20928, 20938, 20948, 20958, 20968, 20978, 20988, 20998, 21008, 21018, 21028, 21038,
21048, 21058, 21068, 21078, 21088, 21098, 21108, 21118, 21128, 21138, 21148, 21158, 21168, 21178, 21188, 21198,
21208, 21218, 21228, 21238, 21248, 21258, 21268, 21278, 21288, 21298, 21308, 21318, 21328, 21338, 21348, 21358,
21368, 21378, 21388, 21398, 21408, 21418, 21428, 21438, 21448, 21458, 21468, 21478, 21488, 21498, 21508, 21518,
21528, 21538, 21548, 21558, 21568, 21578, 21588, 21598, 21608, 21618, 21628, 21638, 21648, 21658, 21668, 21678,
21688, 21698, 21708, 21718, 21728, 21738, 21748, 21758, 21768, 21778, 21788, 21798, 21808, 21818, 21828, 21838,
21848, 21858, 21868, 21878, 21888, 21898, 21908, 21918, 21928, 21938, 21948, 21958, 21968, 21978, 21988, 21998,
22008, 22018, 22028, 22038, 22048, 22058, 22068, 22078, 22088, 22098, 22108, 22118, 22128, 22138, 22148, 22158,
22168, 22178, 22188, 22198, 22208, 22218, 22228, 22238, 22248, 22258, 22268, 22278, 22288, 22298, 22308, 22318,
22328, 22338, 22348, 22358, 22368, 22378, 22388, 22398, 22408, 22418, 22428, 22438, 22448, 22458, 22468, 22478,
22488, 22498, 22508, 22518, 22528, 22538, 22548, 22558, 22568, 22578, 22588, 22598, 22608, 22618, 22628, 22638,
22648, 22658, 22668, 22678, 22688, 22698, 22708, 22718, 22728, 22738, 22748, 22758, 22768, 22778, 22788, 22798,
22808, 22818, 22828, 22838, 22848, 22858, 22868, 22878, 22888, 22898, 22908, 22918, 22928, 22938, 22948, 22958,
22968, 22978, 22988, 22998, 23008, 23018, 23028, 23038, 23048, 23058, 23068, 23078, 23088, 23098, 23108, 23118,
23128, 23138, 23148, 23158, 23168, 23178, 23188, 23198, 23208, 23218, 23228, 23238, 23248, 23258, 23268, 23278,
23288, 23298, 23308, 23318, 23328, 23338, 23348, 23358, 23368, 23378, 23388, 23398, 23408, 23418, 23428, 23438,
23448, 23458, 23468, 23478, 23488, 23498, 23508, 23518, 23528, 23538, 23548, 23558, 23568, 23578, 23588, 23598,
23608, 23618, 23628, 23638, 23648, 23658, 23668, 23678, 23688, 23698, 23708, 23718, 23728, 23738, 23748, 23758,
23768, 23778, 23788, 23798, 23808, 23818, 23828, 23838, 23848, 23858, 23868, 23878, 23888, 23898, 23908, 23918,
23928, 23938, 23948, 23958, 23968, 23978, 23988, 23998, 24008, 24018, 24028, 24038, 24048, 24058, 24068, 24078,
24088, 24098, 24108, 24118, 24128, 24138, 24148, 24158, 24168, 24178, 24188, 24198, 24208, 24218, 24228, 24238,
24248, 24258, 24268, 24278, 24288, 24298, 24308, 24318, 24328, 24338, 24348, 24358, 24368, 24378, 24388, 24398,
24408, 24418, 24428, 24438, 24448, 24458, 24468, 24478, 24488, 24498, 24508, 24518, 24528, 24538, 24548, 24558,
24568, 24578, 24588, 24598, 24608, 24618, 24628, 24638, 24648, 24658, 24668, 24678, 24688, 24698, 24708, 24718,
24728, 24738, 24748, 24758, 24768, 24778, 24788, 24798, 24808, 24818, 24828, 24838, 24848, 24858, 24868, 24878,
24888, 24898, 24908, 24918, 24928, 24938, 24948, 24958, 24968, 24978, 24988, 24998, 25008, 25018, 25028, 25038,
25048, 25058, 25068, 25078, 25088, 25098, 25108, 25118, 25128, 25138, 25148, 25158, 25168, 25178, 25188, 25198,
25208, 25218, 25228, 25238, 25248, 25258, 25268, 25278, 25288, 25298, 25308, 25318, 25328, 25338, 25348, 25358,
25368, 25378, 25388, 25398, 25408, 25418, 25428, 25438, 25448, 25458, 25468, 25478, 25488, 25498, 25508, 25518,
25528, 25538, 25548, 25558, 25568, 25578, 25588, 25598, 25608, 25618, 25628, 25638, 25648, 25658, 25668, 25678,
25688, 25698, 25708, 25718, 25728, 25738, 25748, 25758, 25768, 25778, 25788, 25798, 25808, 25818, 25828, 25838,
25848, 25858, 25868, 25878, 25888, 25898, 25908, 25918, 25928, 25938, 25948, 25958, 25968, 25978, 25988, 25998,
26008, 26018, 26028, 26038, 26048, 26058, 26068, 26078, 26088, 26098, 26108, 26118, 26128, 26138, 26148, 26158,
26168, 26178, 26188, 26198, 26208, 26218, 26228, 26238, 26248, 26258, 26268, 26278, 26288, 26298, 26308, 26318,
26328, 26338, 26348, 26358, 26368, 26378, 26388, 26398, 26408, 26418, 26428, 26438, 26448, 26458, 26468, 26478,
26488, 26498, 26508, 26518, 26528, 26538, 26548, 26558, 26568, 26578, 26588, 26598, 26608, 26618, 26628, 26638,
26648, 26658, 26668, 26678, 26688, 26698, 26708, 26718, 26728, 26738, 26748, 26758, 26768, 26778, 26788, 26798,
26808, 26818, 26828, 26838, 26848, 26858, 26868, 26878, 26888, 26898, 26908, 26918, 26928, 26938, 26948, 26958,
26968, 26978, 26988, 26998, 27008, 27018, 27028, 27038, 27048, 27058, 27068, 27078, 27088, 27098, 27108, 27118,
27128, 27138, 27148, 27158, 27168, 27178, 27188, 27198, 27208, 27218, 27228, 27238, 27248, 27258, 27268, 27278,
27288, 27298, 27308, 27318, 27328, 27338, 27348, 27358, 27368, 27378, 27388, 27398, 27408, 27418, 27428, 27438,
27448, 27458, 27468, 27478, 27488, 27498, 27508, 27518, 27528, 27538, 27548, 27558, 27568, 27578, 27588, 27598,
27608, 27618, 27628, 27638, 27648, 27658, 27668, 27678, 27688, 27698, 27708, 27718, 27728, 27738, 27748, 27758,
27768, 27778, 27788, 27798, 27808, 27818, 27828, 27838, 27848, 27858, 27868, 27878, 27888, 27898, 27908, 27918,
27928, 27938, 27948, 27958, 27968, 27978, 27988, 27998, 28008, 28018, 28028, 28038, 28048, 28058, 28068, 28078,
28088, 28098, 28108, 28118, 28128, 28138, 28148, 28158, 28168, 28178, 28188, 28198, 28208, 28218, 28228, 28238,
28248, 28258, 28268, 28278, 28288, 28298, 28308, 28318, 28328, 28338, 28348, 28358, 28368, 28378, 28388, 28398,
28408, 28418, 28428, 28438, 28448, 28458, 28468, 28478, 28488, 28498, 28508, 28518, 28528, 28538, 28548, 28558,
28568, 28578, 28588, 28598, 28608, 28618, 28628, 28638, 28648, 28658, 28668, 28678, 28688, 28698, 28708, 28718,
28728, 28738, 28748, 28758, 28768, 28778, 28788, 28798, 28808, 28818, 28828, 28838, 28848, 28858, 28868, 28878,
28888, 28898, 28908, 28918, 28928, 28938, 28948, 28958, 28968, 28978, 28988, 28998, 29008, 29018, 29028, 29038,
29048, 29058, 29068, 29078, 29088, 29098, 29108, 29118, 29128, 29138, 29148, 29158, 29168, 29178, 29188, 29198,
29208, 29218, 29228, 29238, 29248, 29258, 29268, 29278, 29288, 29298, 29308, 29318, 29328, 29338, 29348, 29358,
29368, 29378, 29388, 29398, 29408, 29418, 29428, 29438, 29448, 29458, 29468, 29478, 29488, 29498, 29508, 29518,
29528, 29538, 29548, 29558, 29568, 29578, 29588, 29598, 29608, 29618, 29628, 29638, 29648, 29658, 29668, 29678,
29688, 29698, 29708, 29718, 29728, 29738, 29748, 29758, 29768, 29778, 29788, 29798, 29808, 29818, 29828, 29838,
29848, 29858, 29868, 29878, 29888, 29898, 29908, 29918, 29928, 29938, 29948, 29958, 29968, 29978, 29988, 29998,
30008, 30018, 30028, 30038, 30048, 30058, 30068, 30078, 30088, 30098, 30108, 30118, 30128, 30138, 30148, 30158,
30168, 30178, 30188, 30198, 30208, 30218, 30228, 30238, 30248, 30258, 30268, 30278, 30288, 30298, 30308, 30318,
30328, 30338, 30348, 30358, 30368, 30378, 30388, 30398, 30408, 30418, 30428, 30438, 30448, 30458, 30468, 30478,
30488, 30498, 30508, 30518, 30528, 30538, 30548, 30558, 30568, 30578, 30588, 30598, 30608, 30618, 30628, 30638,
30648, 30658, 30668, 30678, 30688, 30698, 30708, 30718, 30728, 30738, 30748, 30758, 30768, 30778, 30788, 30798,
30808, 30818, 30828, 30838, 30848, 30858, 30868, 30878, 30888, 30898, 30908, 30918, 30928, 30938, 30948, 30958,
30968, 30978, 30988, 30998, 31008, 31018, 31028, 31038, 31048, 31058, 31068, 31078, 31088, 31098, 31108, 31118,
31128, 31138, 31148, 31158, 31168, 31178, 31188, 31198, 31208, 31218, 31228, 31238, 31248, 31258, 31268, 31278,
31288, 31298, 31308, 31318, 31328, 31338, 31348, 31358, 31368, 31378, 31388, 31398, 31408, 31418, 31428, 31438,
31448, 31458, 31468, 31478, 31488, 31498, 31508, 31518, 31528, 31538, 31548, 31558, 31568, 31578, 31588, 31598,
31608, 31618, 31628, 31638, 31648, 31658, 31668, 31678, 31688, 31698, 31708, 31718, 31728, 31738, 31748, 31758,
31768, 31778, 31788, 31798, 31808, 31818, 31828, 31838, 31848, 31858, 31868, 31878, 31888, 31898, 31908, 31918,
31928, 31938, 31948, 31958, 31968, 31978, 31988, 31998, 32008, 32018, 32028, 32038, 32048, 32058, 32068, 32078,
32088, 32098, 32108, 32118, 32128, 32138, 32148, 32158, 32168, 32178, 32188, 32198, 32208, 32218, 32228, 32238,
32248, 32258, 32268, 32278, 32288, 32298, 32308, 32318, 32328, 32338, 32348, 32358, 32368, 32378, 32388, 32398,
32408, 32418, 32428, 32438, 32448, 32458, 32468, 32478, 32488, 32498, 32508, 32518, 32528, 32538, 32548, 32558,
32568, 32578, 32588, 32598, 32608, 32618, 32628, 32638, 32648, 32658, 32668, 32678, 32688, 32698, 32708, 32718,
32728, 32738, 32748, 32758, 32768, 32778, 32788, 32798, 32808, 32818, 32828, 32838, 32848, 32858, 32868, 32878,
32888, 32898, 32908, 32918, 32928, 32938, 32948, 32958, 32968, 32978, 32988, 32998, 33008, 33018, 33028, 33038,
33048, 33058, 33068, 33078, 33088, 33098, 33108, 33118, 33128, 33138, 33148, 33158, 33168, 33178, 33188, 33198,
33208, 33218, 33228, 33238, 33248, 33258, 33268, 33278, 33288, 33298, 33308, 33318, 33328, 33338, 33348, 33358,
33368, 33378, 33388, 33398, 33408, 33418, 33428, 33438, 33448, 33458, 33468, 33478, 33488, 33498, 33508, 33518,
33528, 33538, 33548, 33558, 33568, 33578, 33588, 33598, 33608, 33618, 33628, 33638, 33648, 33658, 33668, 33678,
33688, 33698, 33708, 33718, 33728, 33738, 33748, 33758, 33768, 33778, 33788, 33798, 33808, 33818, 33828, 33838,
33848, 33858, 33868, 33878, 33888, 33898, 33908, 33918, 33928, 33938, 33948, 33958, 33968, 33978, 33988, 33998,
34008, 34018, 34028, 34038, 34048, 34058, 34068, 34078, 34088, 34098, 34108, 34118, 34128, 34138, 34148, 34158,
34168, 34178, 34188, 34198, 34208, 34218, 34228, 34238, 34248, 34258, 34268, 34278, 34288, 34298, 34308, 34318,
34328, 34338, 34348, 34358, 34368, 34378, 34388, 34398, 34408, 34418, 34428, 34438, 34448, 34458, 34468, 34478,
34488, 34498, 34508, 34518, 34528, 34538, 34548, 34558, 34568, 34578, 34588, 34598, 34608, 34618, 34628, 34638,
34648, 34658, 34668, 34678, 34688, 34698, 34708, 34718, 34728, 34738, 34748, 34758, 34768, 34778, 34788, 34798,
34808, 34818, 34828, 34838, 34848, 34858, 34868, 34878, 34888, 34898, 34908, 34918, 34928, 34938, 34948, 34958,
34968, 34978, 34988, 34998, 35008, 35018, 35028, 35038, 35048, 35058, 35068, 35078, 35088, 35098, 35108, 35118,
35128, 35138, 35148, 35158, 35168, 35178, 35188, 35198, 35208, 35218, 35228, 35238, 35248, 35258, 35268, 35278,
35288, 35298, 35308, 35318, 35328, 35338, 35348, 35358, 35368, 35378, 35388, 35398, 35408, 35418, 35428, 35438,
35448, 35458, 35468, 35478, 35488, 35498, 35508, 35518, 35528, 35538, 35548, 35558, 35568, 35578, 35588, 35598,
35608, 35618, 35628, 35638, 35648, 35658, 35668, 35678, 35688, 35698, 35708, 35718, 35728, 35738, 35748, 35758,
35768, 35778, 35788, 35798, 35808, 35818, 35828, 35838, 35848, 35858, 35868, 35878, 35888, 35898, 35908, 35918,
35928, 35938, 35948, 35958, 35968, 35978, 35988, 35998, 36008, 36018, 36028, 36038, 36048, 36058, 36068, 36078,
36088, 36098, 36108, 36118, 36128, 36138, 36148, 36158, 36168, 36178, 36188, 36198, 36208, 36218, 36228, 36238,
36248, 36258, 36268, 36278, 36288, 36298, 36308, 36318, 36328, 36338, 36348, 36358, 36368, 36378, 36388, 36398,
36408, 36418, 36428, 36438, 36448, 36458, 36468, 36478, 36488, 36498, 36508, 36518, 36528, 36538, 36548, 36558,
36568, 36578, 36588, 36598, 36608, 36618, 36628, 36638, 36648, 36658, 36668, 36678, 36688, 36698, 36708, 36718,
36728, 36738, 36748, 36758, 36768, 36778, 36788, 36798, 36808, 36818, 36828, 36838, 36848, 36858, 36868, 36878,
36888, 36898, 36908, 36918, 36928, 36938, 36948, 36958, 36968, 36978, 36988, 36998, 37008, 37018, 37028, 37038,
37048, 37058, 37068, 37078, 37088, 37098, 37108, 37118, 37128, 37138, 37148, 37158, 37168, 37178, 37188, 37198,
37208, 37218, 37228, 37238, 37248, 37258, 37268, 37278, 37288, 37298, 37308, 37318, 37328, 37338, 37348, 37358,
37368, 37378, 37388, 37398, 37408, 37418, 37428, 37438, 37448, 37458, 37468, 37478, 37488, 37498, 37508, 37518,
37528, 37538, 37548, 37558, 37568, 37578, 37588, 37598, 37608, 37618, 37628, 37638, 37648, 37658, 37668, 37678,
37688, 37698, 37708, 37718, 37728, 37738, 37748, 37758, 37768, 37778, 37788, 37798, 37808, 37818, 37828, 37838,
37848, 37858, 37868, 37878, 37888, 37898, 37908, 37918, 37928, 37938, 37948, 37958, 37968, 37978, 37988, 37998,
38008, 38018, 38028, 38038, 38048, 38058, 38068, 38078, 38088, 38098, 38108, 38118, 38128, 38138, 38148, 38158,
38168, 38178, 38188, 38198, 38208, 38218, 38228, 38238, 38248, 38258, 38268, 38278, 38288, 38298, 38308, 38318,
38328, 38338, 38348, 38358, 38368, 38378, 38388, 38398, 38408, 38418, 38428, 38438, 38448, 38458, 38468, 38478,
38488, 38498, 38508, 38518, 38528, 38538, 38548, 38558, 38568, 38578, 38588, 38598, 38608, 38618, 38628, 38638,
38648, 38658, 38668, 38678, 38688, 38698, 38708, 38718, 38728, 38738, 38748, 38758, 38768, 38778, 38788, 38798,
38808, 38818, 38828, 38838, 38848, 38858, 38868, 38878, 38888, 38898, 38908, 38918, 38928, 38938, 38948, 38958,
38968, 38978, 38988, 38998, 39008, 39018, 39028, 39038, 39048, 39058, 39068, 39078, 39088, 39098, 39108, 39118,
39128, 39138, 39148, 39158, 39168, 39178, 39188, 39198, 39208, 39218, 39228, 39238, 39248, 39258, 39268, 39278,
39288, 39298, 39308, 39318, 39328, 39338, 39348, 39358, 39368, 39378, 39388, 39398, 39408, 39418, 39428, 39438,
39448, 39458, 39468, 39478, 39488, 39498, 39508, 39518, 39528, 39538, 39548, 39558, 39568, 39578, 39588, 39598,
39608, 39618, 39628, 39638, 39648, 39658, 39668, 39678, 39688, 39698, 39708, 39718, 39728, 39738, 39748, 39758,
39768, 39778, 39788, 39798, 39808, 39818, 39828, 39838, 39848, 39858, 39868, 39878, 39888, 39898, 39908, 39918,
39928, 39938, 39948, 39958, 39968, 39978, 39988, 39998, 40008, 40018, 40028, 40038, 40048, 40058, 40068, 40078,
40088, 40098, 40108, 40118, 40128, 40138, 40148, 40158, 40168, 40178, 40188, 40198, 40208, 40218, 40228, 40238,
40248, 40258, 40268, 40278, 40288, 40298, 40308, 40318, 40328, 40338, 40348, 40358, 40368, 40378, 40388, 40398,
40408, 40418, 40428, 40438, 40448, 40458, 40468, 40478, 40488, 40498, 40508, 40518, 40528, 40538, 40548, 40558,
40568, 40578, 40588, 40598, 40608, 40618, 40628, 40638, 40648, 40658, 40668, 40678, 40688, 40698, 40708, 40718,
40728, 40738, 40748, 40758, 40768, 40778, 40788, 40798, 40808, 40818, 40828, 40838, 40848, 40858, 40868, 57344,
57354, 57364, 57374, 57384, 57394, 57404, 57414, 57424, 57434, 57444, 57454, 57464, 57474, 57484, 57494, 57504,
57514, 57524, 57534, 57544, 57554, 57564, 57574, 57584, 57594, 57604, 57614, 57624, 57634, 57644, 57654, 57664,
57674, 57684, 57694, 57704, 57714, 57724, 57734, 57744, 57754, 57764, 57774, 57784, 57794, 57804, 57814, 57824,
57834, 57844, 57854, 57864, 57874, 57884, 57894, 57904, 57914, 57924, 57934, 57944, 57954, 57964, 57974, 57984,
57994, 58004, 58014, 58024, 58034, 58044, 58054, 58064, 58074, 58084, 58094, 58104, 58114, 58124, 58134, 58144,
58154, 58164, 58174, 58184, 58194, 58204, 58214, 58224, 58234, 58244, 58254, 58264, 58274, 58284, 58294, 58304,
58314, 58324, 58334, 58344, 58354, 58364, 58374, 58384, 58394, 58404, 58414, 58424, 58434, 58444, 58454, 58464,
58474, 58484, 58494, 58504, 58514, 58524, 58534, 58544, 58554, 58564, 58574, 58584, 58594, 58604, 58614, 58624,
58634, 58644, 58654, 58664, 58674, 58684, 58694, 58704, 58714, 58724, 58734, 58744, 58754, 58764, 58774, 58784,
58794, 58804, 58814, 58824, 58834, 58844, 58854, 58864, 58874, 58884, 58894, 58904, 58914, 58924, 58934, 58944,
58954, 58964, 58974, 58984, 58994, 59004, 59014, 59024, 59034, 59044, 59054, 59064, 59074, 59084, 59094, 59104,
59114, 59124, 59134, 59144, 59154, 59164, 59174, 59184, 59194, 59204, 59214, 59224, 59234, 59244, 59254, 59264,
59274, 59284, 59294, 59304, 59314, 59324, 59334, 59344, 59354, 59364, 59374, 59384, 59394, 59404, 59414, 59424,
59434, 59444, 59454, 59464, 59474, 59484, 63788, 63865, 63893, 63975, 63985, 64012, 64024, 64035, 65072, 65082,
65092, 65102, 65113, 65123, 65281, 65291, 65301, 65311, 65321, 65331, 65341, 65351, 65361, 65371, 65504, 65536
            });

        testBytes = theseBytes(new int[]{
0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15,
16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47,
48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63,
64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79,
80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95,
96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111,
112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127,
161, 232, 161, 236, 161, 167, 161, 227, 161, 192, 161, 164, 161, 193, 168, 164,
168, 162, 168, 168, 168, 166, 168, 186, 168, 172, 168, 170, 168, 176, 168, 174,
161, 194, 168, 180, 168, 178, 168, 185, 168, 161, 168, 165, 168, 169, 168, 189,
168, 177, 168, 163, 168, 182, 168, 187, 168, 192, 161, 166, 168, 66, 166, 161,
166, 171, 166, 180, 166, 193, 166, 203, 166, 212, 167, 167, 167, 161, 167, 172,
167, 182, 167, 192, 167, 218, 167, 228, 167, 238, 169, 92, 161, 176, 161, 173,
161, 235, 161, 249, 161, 230, 161, 237, 169, 89, 162, 241, 162, 251, 162, 165,
161, 251, 161, 202, 168, 77, 168, 78, 161, 201, 161, 224, 161, 214, 168, 80,
161, 217, 161, 218, 161, 209, 161, 205, 168, 83, 161, 208, 162, 217, 162, 197,
162, 207, 162, 177, 162, 187, 169, 164, 169, 174, 169, 184, 169, 194, 169, 204,
169, 214, 169, 224, 169, 234, 168, 84, 168, 94, 168, 104, 168, 114, 168, 120,
168, 131, 168, 138, 161, 246, 161, 248, 168, 139, 161, 244, 168, 141, 161, 239,
161, 226, 161, 161, 161, 182, 161, 178, 168, 149, 169, 71, 164, 161, 164, 171,
164, 181, 164, 191, 164, 201, 164, 211, 164, 221, 164, 231, 164, 241, 169, 97,
165, 165, 165, 175, 165, 185, 165, 195, 165, 205, 165, 215, 165, 225, 165, 235,
165, 245, 168, 197, 168, 207, 168, 217, 168, 227, 162, 229, 169, 90, 169, 73,
169, 74, 169, 76, 169, 80, 169, 81, 210, 187, 201, 207, 199, 210, 216, 169,
216, 173, 180, 174, 129, 83, 129, 88, 192, 214, 129, 93, 129, 97, 129, 105,
129, 112, 129, 121, 182, 254, 129, 129, 217, 239, 129, 136, 129, 140, 129, 147,
129, 148, 129, 152, 129, 155, 129, 158, 209, 246, 129, 168, 129, 174, 188, 191,
211, 197, 216, 243, 129, 192, 193, 230, 129, 203, 129, 211, 129, 215, 216, 250,
129, 220, 129, 226, 217, 174, 129, 237, 129, 242, 129, 249, 130, 64, 206, 234,
130, 74, 130, 83, 130, 89, 130, 95, 130, 98, 217, 179, 130, 107, 217, 194,
130, 124, 181, 185, 217, 195, 190, 235, 130, 146, 213, 174, 130, 162, 217, 203,
130, 176, 130, 184, 217, 204, 197, 188, 191, 254, 130, 214, 130, 223, 130, 233,
180, 162, 176, 193, 130, 254, 131, 73, 131, 82, 193, 197, 131, 100, 217, 215,
131, 113, 131, 122, 131, 130, 131, 139, 131, 149, 131, 158, 131, 168, 131, 178,
207, 200, 131, 186, 182, 181, 131, 199, 192, 188, 131, 205, 131, 209, 131, 214,
131, 220, 218, 163, 182, 172, 210, 177, 190, 187, 131, 245, 131, 251, 132, 68,
132, 75, 132, 81, 219, 202, 183, 214, 132, 91, 184, 213, 197, 208, 185, 206,
200, 175, 188, 193, 216, 221, 198, 202, 132, 133, 188, 244, 132, 146, 132, 155,
197, 252, 132, 170, 132, 178, 132, 181, 132, 185, 132, 192, 132, 199, 132, 206,
191, 177, 132, 221, 132, 230, 132, 239, 212, 200, 132, 251, 133, 67, 133, 71,
133, 77, 133, 85, 133, 92, 133, 97, 133, 101, 178, 169, 194, 177, 216, 180,
208, 182, 179, 167, 209, 225, 133, 133, 133, 139, 133, 143, 133, 152, 133, 160,
211, 214, 133, 170, 133, 174, 193, 237, 204, 168, 133, 181, 184, 247, 186, 243,
133, 190, 133, 194, 204, 253, 133, 200, 209, 189, 184, 230, 223, 190, 133, 218,
214, 220, 223, 218, 186, 244, 197, 216, 184, 192, 223, 203, 223, 229, 134, 66,
207, 204, 223, 211, 223, 223, 134, 80, 134, 83, 196, 196, 134, 93, 134, 100,
134, 106, 134, 112, 134, 120, 134, 126, 224, 167, 134, 138, 215, 196, 134, 149,
134, 156, 134, 164, 216, 196, 224, 164, 191, 166, 186, 176, 224, 184, 134, 192,
134, 200, 134, 209, 134, 214, 134, 220, 134, 227, 134, 232, 224, 205, 134, 240,
134, 245, 134, 251, 224, 209, 135, 75, 135, 81, 135, 88, 215, 236, 135, 100,
135, 109, 135, 116, 224, 224, 135, 130, 135, 135, 135, 143, 135, 151, 186, 191,
135, 166, 135, 176, 135, 185, 135, 194, 135, 202, 196, 210, 224, 236, 187, 216,
135, 230, 135, 236, 135, 242, 212, 178, 135, 253, 136, 72, 136, 79, 219, 220,
136, 90, 219, 224, 219, 208, 136, 106, 215, 185, 198, 186, 136, 118, 136, 124,
136, 130, 192, 221, 136, 145, 191, 209, 136, 154, 136, 161, 136, 169, 179, 199,
219, 245, 136, 187, 136, 196, 136, 203, 220, 165, 136, 215, 136, 222, 220, 166,
136, 236, 136, 244, 136, 253, 137, 71, 137, 79, 137, 86, 137, 95, 137, 102,
137, 112, 137, 119, 137, 126, 137, 135, 137, 141, 137, 149, 137, 159, 137, 168,
137, 176, 137, 185, 137, 194, 137, 203, 201, 249, 137, 216, 180, 166, 137, 232,
137, 238, 137, 244, 137, 248, 137, 253, 138, 67, 138, 71, 177, 188, 138, 81,
138, 88, 138, 98, 138, 103, 215, 177, 138, 113, 138, 118, 230, 165, 196, 221,
138, 138, 138, 145, 138, 152, 138, 157, 138, 162, 138, 169, 138, 178, 138, 186,
230, 174, 138, 195, 196, 200, 138, 208, 138, 217, 138, 223, 138, 231, 138, 238,
138, 247, 230, 190, 139, 72, 201, 244, 139, 86, 139, 96, 139, 105, 139, 113,
139, 123, 230, 199, 139, 139, 139, 146, 139, 154, 139, 160, 139, 166, 139, 173,
139, 182, 139, 192, 139, 201, 230, 212, 139, 219, 139, 229, 217, 248, 139, 246,
140, 64, 140, 72, 215, 206, 209, 167, 202, 235, 200, 230, 229, 179, 140, 97,
185, 217, 191, 205, 140, 107, 188, 210, 140, 117, 140, 122, 140, 129, 196, 175,
213, 175, 140, 150, 181, 188, 189, 171, 140, 168, 201, 208, 211, 200, 140, 185,
202, 172, 178, 227, 140, 197, 140, 202, 205, 192, 140, 215, 140, 222, 140, 230,
225, 172, 140, 242, 225, 177, 140, 252, 141, 67, 141, 72, 225, 187, 141, 87,
141, 96, 141, 104, 141, 109, 141, 117, 141, 126, 141, 133, 180, 222, 225, 198,
141, 155, 141, 162, 141, 171, 141, 179, 141, 185, 141, 194, 141, 202, 141, 209,
141, 217, 225, 214, 141, 236, 141, 246, 141, 254, 142, 73, 142, 83, 142, 92,
142, 101, 142, 110, 142, 119, 215, 243, 142, 128, 142, 133, 142, 138, 142, 144,
193, 177, 142, 152, 142, 160, 142, 167, 142, 172, 142, 179, 225, 163, 225, 165,
142, 202, 184, 201, 211, 215, 199, 236, 194, 174, 184, 253, 142, 232, 142, 238,
211, 185, 142, 251, 143, 68, 193, 206, 143, 83, 226, 222, 219, 200, 222, 195,
222, 196, 143, 115, 143, 120, 207, 210, 143, 132, 199, 191, 143, 147, 143, 157,
229, 233, 208, 206, 177, 242, 143, 178, 205, 249, 187, 178, 143, 191, 143, 196,
225, 229, 143, 211, 225, 232, 210, 228, 236, 254, 143, 232, 226, 232, 226, 229,
226, 238, 203, 203, 144, 67, 178, 192, 181, 161, 185, 214, 144, 86, 144, 93,
144, 99, 186, 227, 144, 112, 144, 118, 199, 161, 226, 253, 199, 196, 144, 136,
144, 143, 144, 148, 208, 252, 144, 158, 144, 165, 190, 170, 144, 180, 144, 185,
178, 210, 144, 193, 144, 198, 237, 169, 144, 210, 211, 222, 183, 223, 144, 231,
144, 241, 144, 250, 187, 197, 145, 73, 145, 82, 145, 89, 145, 98, 145, 106,
145, 116, 145, 124, 145, 134, 145, 143, 145, 149, 145, 158, 145, 166, 145, 173,
145, 180, 145, 190, 145, 199, 145, 208, 145, 217, 206, 236, 145, 226, 145, 230,
145, 235, 145, 242, 145, 249, 145, 253, 146, 65, 146, 70, 146, 78, 176, 231,
146, 86, 146, 91, 146, 98, 182, 182, 191, 217, 146, 112, 146, 119, 146, 124,
196, 233, 190, 220, 176, 221, 192, 185, 146, 140, 146, 145, 146, 149, 191, 230,
146, 163, 222, 216, 146, 169, 146, 177, 146, 184, 146, 189, 146, 193, 192, 204,
146, 206, 146, 212, 146, 218, 146, 226, 198, 254, 146, 235, 146, 242, 222, 231,
181, 167, 147, 65, 147, 72, 210, 190, 222, 235, 190, 190, 212, 174, 147, 104,
147, 109, 147, 115, 203, 209, 222, 249, 147, 135, 208, 175, 201, 227, 147, 154,
213, 170, 147, 170, 147, 178, 147, 187, 147, 194, 147, 200, 147, 208, 215, 178,
147, 223, 147, 228, 186, 179, 147, 240, 223, 167, 147, 254, 223, 169, 148, 79,
148, 89, 148, 98, 148, 107, 148, 116, 148, 125, 148, 135, 234, 183, 183, 197,
208, 167, 148, 158, 148, 164, 182, 216, 202, 253, 148, 183, 148, 193, 148, 200,
148, 206, 148, 211, 148, 216, 148, 223, 148, 230, 148, 235, 148, 240, 148, 248,
214, 188, 149, 64, 149, 71, 192, 165, 149, 83, 149, 89, 149, 96, 149, 102,
149, 107, 149, 114, 201, 206, 234, 205, 149, 133, 149, 139, 199, 231, 193, 192,
149, 158, 149, 166, 149, 174, 149, 183, 149, 190, 149, 198, 149, 207, 149, 217,
149, 227, 149, 233, 149, 241, 149, 247, 215, 238, 235, 195, 203, 183, 150, 79,
196, 190, 150, 90, 150, 97, 184, 203, 178, 196, 150, 113, 150, 118, 150, 123,
150, 128, 150, 134, 150, 140, 150, 148, 150, 152, 199, 185, 150, 161, 150, 167,
150, 174, 198, 226, 185, 241, 150, 189, 232, 205, 150, 202, 150, 209, 232, 221,
150, 216, 150, 224, 150, 232, 150, 240, 232, 238, 232, 240, 189, 219, 151, 66,
189, 176, 151, 75, 151, 82, 176, 240, 151, 97, 151, 105, 151, 114, 151, 120,
151, 126, 232, 249, 151, 143, 151, 150, 204, 196, 151, 166, 151, 173, 151, 179,
151, 187, 189, 183, 151, 202, 151, 209, 210, 172, 151, 225, 151, 232, 151, 242,
151, 250, 152, 65, 152, 72, 152, 80, 233, 175, 152, 89, 192, 198, 152, 103,
213, 165, 152, 118, 152, 125, 152, 135, 187, 177, 152, 150, 152, 157, 152, 166,
152, 175, 152, 183, 152, 192, 152, 202, 152, 209, 186, 225, 152, 224, 233, 208,
152, 239, 152, 248, 153, 64, 153, 72, 153, 82, 153, 90, 207, 173, 233, 213,
153, 113, 153, 122, 195, 202, 153, 140, 153, 150, 153, 160, 153, 170, 153, 180,
153, 190, 153, 200, 153, 210, 153, 220, 153, 230, 153, 240, 236, 163, 153, 254,
154, 71, 154, 78, 184, 232, 154, 93, 154, 102, 205, 225, 154, 115, 154, 122,
154, 126, 233, 230, 154, 138, 154, 147, 154, 156, 154, 162, 154, 169, 154, 176,
154, 179, 154, 186, 154, 194, 154, 201, 154, 209, 154, 216, 198, 248, 154, 224,
176, 177, 235, 181, 154, 238, 217, 224, 207, 171, 155, 65, 204, 192, 155, 74,
155, 80, 210, 202, 227, 231, 155, 95, 155, 102, 187, 166, 155, 108, 213, 180,
155, 119, 155, 125, 155, 130, 155, 134, 204, 169, 227, 248, 228, 167, 228, 169,
155, 159, 155, 165, 155, 171, 155, 176, 155, 181, 215, 199, 228, 177, 228, 183,
155, 199, 155, 205, 228, 188, 155, 219, 155, 225, 155, 231, 181, 211, 228, 204,
186, 212, 155, 250, 204, 202, 196, 215, 228, 196, 156, 83, 156, 88, 156, 94,
156, 103, 156, 107, 156, 113, 156, 117, 156, 123, 195, 236, 228, 216, 228, 207,
207, 230, 156, 160, 156, 169, 156, 178, 156, 186, 156, 192, 156, 200, 156, 208,
156, 214, 228, 209, 156, 225, 156, 232, 156, 239, 185, 246, 194, 203, 156, 253,
157, 71, 198, 175, 157, 87, 157, 93, 196, 174, 228, 244, 157, 114, 209, 250,
157, 131, 157, 139, 199, 177, 193, 202, 157, 162, 228, 253, 179, 206, 197, 236,
157, 191, 157, 199, 157, 208, 229, 164, 188, 164, 157, 232, 157, 240, 229, 168,
158, 66, 158, 74, 158, 84, 158, 94, 158, 104, 229, 171, 158, 120, 158, 131,
158, 140, 158, 149, 185, 224, 158, 167, 158, 176, 158, 186, 158, 191, 212, 214,
158, 203, 179, 180, 236, 191, 158, 223, 158, 228, 158, 233, 158, 236, 158, 244,
186, 230, 159, 69, 189, 253, 159, 80, 159, 87, 186, 184, 159, 103, 159, 108,
159, 117, 159, 124, 159, 134, 159, 143, 159, 150, 159, 160, 195, 186, 214, 243,
236, 212, 159, 188, 159, 196, 159, 204, 236, 218, 159, 219, 159, 227, 159, 235,
159, 244, 159, 253, 160, 70, 160, 78, 160, 86, 160, 95, 160, 105, 160, 114,
160, 124, 160, 134, 197, 192, 184, 184, 160, 151, 160, 159, 160, 166, 160, 172,
160, 177, 201, 252, 160, 190, 160, 195, 160, 201, 160, 210, 160, 219, 160, 227,
225, 239, 191, 241, 160, 245, 160, 251, 186, 221, 170, 73, 225, 249, 170, 79,
170, 87, 170, 95, 178, 194, 170, 104, 170, 109, 170, 114, 170, 122, 170, 132,
170, 139, 170, 148, 226, 179, 171, 68, 171, 77, 171, 84, 171, 91, 171, 99,
171, 107, 193, 225, 171, 117, 171, 125, 183, 169, 171, 138, 171, 146, 171, 152,
172, 64, 172, 74, 172, 79, 172, 87, 172, 95, 231, 247, 199, 217, 172, 112,
172, 121, 172, 132, 232, 164, 172, 144, 185, 229, 172, 160, 173, 69, 232, 172,
173, 85, 173, 93, 173, 100, 173, 110, 173, 119, 173, 130, 173, 139, 240, 172,
173, 152, 173, 160, 174, 70, 174, 78, 174, 86, 201, 245, 174, 99, 174, 103,
181, 233, 174, 111, 189, 231, 174, 124, 174, 131, 183, 172, 179, 235, 174, 154,
175, 64, 240, 218, 175, 75, 175, 78, 240, 230, 175, 86, 240, 228, 175, 94,
182, 187, 193, 161, 175, 109, 175, 116, 240, 246, 240, 250, 175, 137, 175, 142,
175, 146, 175, 151, 241, 162, 176, 65, 176, 73, 176, 81, 176, 88, 176, 97,
185, 239, 212, 237, 176, 116, 205, 238, 176, 132, 176, 141, 241, 229, 176, 157,
211, 175, 186, 208, 177, 73, 177, 81, 177, 89, 177, 94, 237, 237, 177, 105,
177, 115, 237, 243, 177, 128, 191, 244, 215, 197, 177, 146, 177, 154, 178, 65,
237, 254, 178, 77, 178, 86, 178, 90, 178, 97, 178, 105, 178, 112, 178, 117,
178, 124, 178, 132, 178, 142, 178, 151, 178, 158, 179, 66, 179, 71, 183, 175,
179, 83, 197, 248, 237, 191, 237, 206, 197, 233, 237, 194, 179, 113, 237, 202,
179, 124, 179, 134, 211, 178, 179, 149, 179, 157, 180, 68, 180, 73, 180, 78,
180, 83, 237, 218, 180, 97, 180, 104, 197, 205, 180, 117, 180, 128, 180, 136,
180, 143, 180, 151, 180, 160, 181, 72, 181, 81, 181, 90, 237, 231, 201, 231,
198, 237, 181, 120, 236, 239, 181, 129, 181, 135, 236, 247, 194, 187, 181, 157,
182, 69, 182, 78, 182, 87, 182, 96, 208, 227, 182, 106, 182, 112, 182, 120,
182, 125, 182, 131, 182, 139, 239, 249, 182, 151, 214, 201, 183, 68, 183, 78,
183, 86, 183, 91, 183, 100, 183, 109, 183, 118, 183, 129, 209, 168, 183, 142,
241, 186, 214, 207, 180, 220, 241, 188, 184, 72, 184, 81, 184, 90, 184, 99,
184, 108, 184, 114, 184, 121, 184, 130, 184, 136, 243, 201, 177, 202, 243, 215,
177, 191, 185, 66, 193, 253, 185, 80, 191, 240, 243, 217, 185, 94, 243, 223,
185, 109, 185, 115, 185, 124, 185, 131, 185, 138, 243, 236, 243, 240, 185, 155,
186, 65, 186, 73, 186, 80, 243, 247, 186, 94, 186, 102, 186, 110, 186, 117,
186, 125, 186, 135, 186, 142, 186, 152, 244, 166, 187, 71, 187, 80, 187, 90,
187, 100, 187, 110, 244, 204, 187, 125, 187, 135, 187, 140, 212, 193, 193, 184,
187, 158, 188, 66, 244, 216, 204, 199, 191, 183, 188, 92, 188, 101, 188, 109,
188, 119, 188, 129, 188, 139, 188, 147, 188, 154, 189, 67, 189, 77, 189, 87,
189, 97, 189, 107, 189, 117, 189, 126, 189, 136, 189, 146, 189, 156, 190, 69,
190, 78, 190, 87, 190, 97, 190, 107, 190, 117, 190, 128, 190, 138, 190, 148,
190, 158, 191, 71, 191, 81, 191, 91, 191, 101, 191, 111, 191, 121, 191, 131,
191, 139, 191, 149, 191, 159, 192, 72, 192, 82, 192, 92, 192, 101, 192, 111,
192, 121, 186, 236, 206, 179, 194, 218, 231, 164, 176, 237, 231, 171, 189, 202,
231, 176, 231, 181, 215, 219, 192, 194, 192, 137, 184, 191, 231, 205, 201, 201,
184, 215, 243, 191, 192, 155, 193, 64, 193, 70, 215, 239, 238, 188, 238, 192,
193, 98, 193, 105, 193, 113, 193, 118, 244, 202, 193, 133, 193, 139, 244, 225,
199, 204, 193, 159, 194, 69, 194, 75, 210, 171, 194, 87, 241, 232, 194, 95,
241, 241, 194, 106, 194, 110, 241, 246, 194, 121, 190, 219, 194, 138, 194, 146,
194, 155, 195, 66, 188, 161, 208, 164, 179, 166, 183, 190, 235, 200, 201, 246,
195, 95, 195, 102, 202, 164, 195, 111, 210, 200, 176, 183, 195, 122, 235, 219,
235, 228, 195, 138, 235, 227, 235, 225, 196, 64, 192, 176, 199, 187, 196, 82,
196, 89, 196, 94, 235, 239, 196, 104, 196, 111, 196, 119, 196, 125, 196, 133,
196, 142, 177, 219, 235, 251, 197, 66, 197, 76, 215, 212, 214, 194, 244, 167,
197, 100, 202, 230, 203, 180, 197, 118, 189, 162, 197, 123, 244, 185, 197, 138,
203, 210, 197, 154, 198, 66, 198, 70, 198, 75, 220, 183, 198, 85, 198, 90,
220, 184, 198, 95, 198, 100, 198, 106, 198, 108, 198, 111, 220, 214, 198, 120,
198, 126, 195, 175, 220, 221, 198, 140, 198, 146, 198, 154, 220, 238, 199, 64,
199, 70, 187, 196, 220, 234, 220, 253, 199, 84, 199, 92, 199, 99, 201, 175,
221, 183, 199, 118, 199, 124, 221, 178, 221, 210, 190, 213, 221, 202, 199, 151,
199, 157, 183, 198, 200, 73, 221, 201, 200, 83, 200, 91, 211, 169, 200, 104,
221, 199, 200, 120, 200, 130, 200, 139, 200, 144, 200, 151, 200, 156, 201, 65,
221, 220, 201, 78, 203, 226, 201, 94, 201, 103, 221, 240, 208, 238, 201, 121,
201, 128, 201, 135, 197, 238, 201, 150, 201, 158, 202, 71, 202, 78, 202, 86,
202, 94, 202, 102, 176, 170, 202, 114, 202, 121, 202, 130, 222, 168, 202, 147,
202, 155, 203, 64, 203, 71, 203, 80, 203, 88, 208, 189, 203, 102, 203, 110,
203, 119, 203, 126, 222, 188, 203, 143, 203, 152, 204, 65, 204, 73, 204, 82,
204, 90, 204, 100, 204, 108, 204, 118, 204, 126, 204, 137, 242, 175, 211, 221,
204, 158, 205, 67, 242, 180, 205, 77, 205, 83, 205, 91, 212, 233, 205, 102,
205, 106, 205, 114, 205, 118, 205, 123, 205, 129, 205, 137, 242, 211, 182, 234,
242, 218, 209, 209, 195, 219, 206, 70, 206, 78, 206, 85, 206, 92, 208, 171,
206, 105, 206, 113, 206, 120, 181, 251, 206, 133, 206, 139, 206, 146, 206, 155,
242, 253, 207, 72, 207, 79, 243, 161, 207, 94, 207, 101, 207, 109, 243, 181,
207, 126, 207, 135, 207, 143, 243, 182, 207, 159, 208, 70, 208, 79, 208, 87,
208, 94, 208, 102, 208, 109, 208, 114, 203, 165, 208, 126, 176, 192, 208, 137,
208, 145, 241, 200, 209, 64, 209, 72, 209, 80, 209, 85, 210, 225, 209, 99,
241, 212, 209, 111, 241, 211, 209, 124, 186, 214, 241, 210, 209, 147, 209, 154,
210, 64, 210, 73, 210, 82, 210, 92, 210, 100, 210, 109, 210, 119, 210, 129,
210, 135, 210, 145, 210, 155, 211, 68, 211, 78, 211, 88, 185, 230, 234, 236,
211, 101, 211, 108, 211, 114, 211, 122, 209, 212, 211, 141, 211, 151, 212, 64,
212, 74, 212, 84, 212, 94, 212, 103, 212, 112, 212, 122, 212, 133, 212, 143,
212, 153, 213, 65, 213, 73, 213, 82, 213, 92, 213, 102, 213, 112, 213, 122,
213, 133, 213, 143, 213, 153, 214, 66, 214, 76, 214, 86, 214, 96, 214, 105,
214, 115, 214, 125, 214, 135, 214, 145, 214, 155, 215, 68, 215, 78, 215, 88,
215, 97, 215, 106, 215, 116, 215, 126, 215, 137, 215, 147, 200, 207, 210, 233,
208, 237, 218, 172, 214, 223, 218, 180, 218, 185, 215, 158, 203, 181, 191, 206,
204, 184, 218, 203, 195, 213, 199, 171, 192, 190, 216, 66, 216, 75, 216, 81,
216, 90, 187, 191, 216, 105, 216, 114, 216, 121, 245, 246, 245, 249, 216, 145,
216, 155, 217, 68, 217, 78, 217, 88, 217, 98, 217, 108, 217, 118, 217, 129,
217, 139, 217, 149, 217, 159, 218, 72, 218, 79, 204, 176, 204, 249, 188, 214,
234, 226, 218, 81, 216, 211, 201, 226, 215, 223, 218, 95, 244, 242, 218, 110,
218, 118, 218, 128, 218, 137, 218, 143, 218, 148, 218, 155, 218, 160, 245, 200,
191, 231, 219, 79, 219, 82, 219, 90, 219, 96, 219, 105, 219, 110, 245, 218,
219, 123, 245, 229, 219, 132, 219, 140, 219, 149, 219, 157, 245, 237, 220, 72,
220, 78, 220, 86, 245, 242, 220, 103, 220, 110, 204, 201, 220, 129, 234, 166,
220, 148, 220, 158, 221, 71, 221, 81, 221, 91, 221, 101, 221, 111, 221, 121,
221, 132, 221, 142, 221, 152, 222, 65, 222, 75, 222, 85, 222, 95, 194, 214,
233, 244, 233, 251, 222, 99, 207, 189, 222, 102, 222, 109, 222, 116, 180, 239,
194, 245, 222, 134, 212, 182, 229, 200, 202, 246, 222, 149, 229, 204, 222, 157,
222, 160, 183, 234, 223, 74, 229, 212, 223, 85, 223, 91, 223, 95, 223, 102,
229, 219, 223, 116, 223, 124, 223, 130, 223, 138, 223, 143, 223, 148, 211, 202,
219, 161, 224, 64, 224, 70, 224, 75, 224, 81, 224, 86, 179, 187, 219, 177,
224, 107, 224, 117, 224, 126, 224, 134, 224, 143, 224, 151, 224, 160, 244, 252,
225, 72, 245, 161, 179, 234, 195, 184, 225, 87, 225, 94, 225, 98, 225, 106,
225, 114, 225, 120, 225, 128, 225, 138, 225, 141, 225, 150, 225, 159, 226, 72,
226, 82, 226, 92, 226, 102, 226, 112, 226, 122, 226, 133, 226, 143, 226, 153,
227, 66, 227, 76, 227, 86, 227, 96, 227, 106, 227, 115, 227, 125, 246, 198,
227, 145, 227, 155, 228, 68, 228, 77, 228, 87, 228, 96, 228, 106, 228, 116,
228, 126, 228, 137, 228, 147, 228, 157, 229, 70, 229, 80, 229, 90, 229, 100,
229, 110, 229, 119, 229, 130, 229, 140, 229, 150, 246, 202, 230, 72, 230, 82,
230, 92, 230, 101, 230, 111, 230, 121, 230, 132, 230, 142, 230, 152, 231, 64,
231, 73, 231, 83, 231, 93, 231, 103, 231, 113, 231, 123, 231, 134, 231, 144,
231, 154, 232, 67, 232, 77, 232, 86, 232, 96, 232, 106, 232, 116, 232, 125,
232, 136, 232, 146, 238, 201, 232, 150, 196, 198, 238, 214, 238, 220, 188, 216,
238, 230, 238, 239, 205, 173, 232, 157, 189, 194, 198, 204, 179, 250, 239, 180,
239, 187, 239, 192, 239, 196, 239, 200, 182, 198, 196, 247, 239, 217, 239, 223,
239, 232, 239, 239, 233, 81, 233, 90, 233, 100, 233, 110, 233, 120, 233, 131,
233, 141, 233, 151, 234, 64, 234, 74, 234, 84, 201, 193, 188, 228, 227, 204,
227, 208, 227, 214, 184, 183, 234, 103, 234, 111, 234, 115, 184, 189, 234, 120,
234, 128, 212, 186, 218, 238, 204, 213, 234, 153, 234, 160, 184, 244, 235, 74,
235, 83, 235, 92, 246, 192, 188, 175, 235, 105, 235, 113, 235, 122, 235, 130,
235, 136, 235, 142, 235, 147, 193, 216, 235, 160, 246, 175, 236, 79, 246, 178,
236, 96, 199, 224, 236, 111, 236, 116, 236, 125, 236, 133, 236, 142, 236, 149,
199, 202, 237, 67, 237, 75, 237, 81, 237, 91, 237, 101, 237, 111, 237, 121,
237, 130, 237, 135, 237, 142, 237, 152, 238, 65, 238, 75, 238, 85, 238, 95,
238, 105, 238, 115, 238, 125, 238, 136, 238, 146, 238, 156, 239, 69, 185, 203,
190, 177, 239, 72, 209, 213, 242, 173, 239, 84, 239, 94, 239, 104, 183, 231,
198, 174, 239, 124, 239, 133, 239, 143, 239, 153, 240, 66, 240, 74, 240, 84,
240, 94, 240, 103, 240, 113, 240, 123, 240, 134, 240, 142, 240, 151, 210, 251,
240, 154, 240, 158, 241, 64, 202, 215, 241, 72, 241, 80, 241, 90, 241, 100,
241, 110, 241, 120, 241, 131, 241, 141, 241, 151, 242, 64, 242, 74, 242, 84,
242, 94, 242, 104, 242, 114, 242, 124, 242, 135, 242, 145, 242, 155, 243, 68,
243, 78, 243, 82, 205, 213, 194, 230, 230, 235, 201, 167, 214, 232, 243, 96,
186, 161, 247, 196, 247, 198, 243, 121, 243, 130, 243, 138, 243, 145, 243, 153,
247, 220, 244, 73, 244, 82, 244, 90, 244, 99, 244, 108, 198, 199, 244, 117,
244, 124, 244, 135, 244, 145, 244, 155, 245, 68, 245, 78, 245, 88, 245, 98,
245, 108, 245, 118, 245, 129, 245, 139, 245, 149, 245, 159, 246, 72, 246, 82,
246, 92, 246, 102, 246, 112, 246, 122, 246, 133, 246, 143, 246, 153, 247, 66,
247, 76, 247, 86, 247, 96, 247, 106, 247, 116, 247, 126, 247, 133, 246, 215,
247, 141, 246, 227, 247, 145, 246, 243, 247, 150, 246, 253, 247, 167, 193, 219,
248, 69, 248, 79, 248, 89, 248, 99, 248, 109, 248, 119, 248, 130, 248, 140,
248, 150, 248, 160, 249, 73, 249, 83, 249, 93, 249, 103, 249, 113, 249, 123,
249, 134, 249, 144, 249, 154, 250, 67, 250, 77, 250, 87, 250, 97, 250, 107,
250, 117, 250, 128, 250, 138, 250, 148, 250, 158, 251, 71, 251, 81, 251, 91,
240, 177, 240, 182, 251, 98, 240, 193, 251, 101, 240, 203, 186, 215, 251, 113,
251, 120, 247, 228, 251, 135, 251, 143, 251, 151, 251, 160, 244, 240, 247, 226,
252, 87, 252, 92, 247, 237, 252, 103, 252, 109, 252, 118, 252, 125, 182, 166,
252, 140, 247, 247, 247, 248, 253, 68, 253, 73, 253, 82, 253, 90, 253, 100,
253, 110, 253, 120, 253, 131, 246, 182, 253, 139, 185, 168, 253, 154, 170, 161,
170, 171, 170, 181, 170, 191, 170, 201, 170, 211, 170, 221, 170, 231, 170, 241,
170, 251, 171, 167, 171, 177, 171, 187, 171, 197, 171, 207, 171, 217, 171, 227,
171, 237, 171, 247, 172, 163, 172, 173, 172, 183, 172, 193, 172, 203, 172, 213,
172, 223, 172, 233, 172, 243, 172, 253, 173, 169, 173, 179, 173, 189, 173, 199,
173, 209, 173, 219, 173, 229, 173, 239, 173, 249, 174, 165, 174, 175, 174, 185,
174, 195, 174, 205, 174, 215, 174, 225, 174, 235, 174, 245, 175, 161, 175, 171,
175, 181, 175, 191, 175, 201, 175, 211, 175, 221, 175, 231, 175, 241, 175, 251,
248, 167, 248, 177, 248, 187, 248, 197, 248, 207, 248, 217, 248, 227, 248, 237,
248, 247, 249, 163, 249, 173, 249, 183, 249, 193, 249, 203, 249, 213, 249, 223,
249, 233, 249, 243, 249, 253, 250, 169, 250, 179, 250, 189, 250, 199, 250, 209,
250, 219, 250, 229, 250, 239, 250, 249, 251, 165, 251, 175, 251, 185, 251, 195,
251, 205, 251, 215, 251, 225, 251, 235, 251, 245, 252, 161, 252, 171, 252, 181,
252, 191, 252, 201, 252, 211, 252, 221, 252, 231, 252, 241, 252, 251, 253, 167,
253, 177, 253, 187, 253, 197, 253, 207, 253, 217, 253, 227, 253, 237, 253, 247,
254, 163, 254, 173, 254, 183, 254, 193, 254, 203, 254, 213, 254, 223, 254, 233,
254, 243, 254, 253, 161, 72, 161, 82, 161, 92, 161, 102, 161, 112, 161, 122,
161, 133, 161, 143, 161, 153, 162, 66, 162, 76, 162, 86, 162, 96, 162, 106,
162, 116, 162, 126, 162, 137, 162, 147, 162, 157, 163, 70, 163, 80, 163, 90,
163, 100, 163, 110, 163, 120, 163, 131, 163, 141, 163, 151, 164, 64, 164, 74,
164, 84, 164, 94, 164, 104, 164, 114, 164, 124, 164, 135, 164, 145, 164, 155,
165, 68, 165, 78, 165, 88, 165, 98, 165, 108, 165, 118, 165, 129, 165, 139,
165, 149, 165, 159, 166, 72, 166, 82, 166, 92, 166, 102, 166, 112, 166, 122,
166, 133, 166, 143, 166, 153, 167, 66, 167, 76, 167, 86, 167, 96, 167, 106,
167, 116, 167, 126, 167, 137, 167, 147, 167, 157, 162, 227, 164, 248, 165, 250,
166, 190, 166, 236, 166, 253, 167, 202, 167, 245, 168, 150, 168, 160, 168, 237,
168, 247, 169, 93, 169, 144, 169, 155, 169, 241, 169, 251, 254, 81, 254, 91,
254, 101, 254, 111, 254, 121, 254, 132, 254, 142, 254, 152, 253, 156, 253, 157,
253, 158, 253, 159, 253, 160, 254, 64, 254, 71, 254, 75, 169, 85, 166, 227,
166, 235, 169, 109, 169, 118, 169, 129, 163, 161, 163, 171, 163, 181, 163, 191,
163, 201, 163, 211, 163, 221, 163, 231, 163, 241, 163, 251, 161, 233, 0
            });

        super.setUp();
    }

}
