/*
 * Copyright (C) 2010 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package libcore.java.net;

import java.net.URI;
import java.net.URISyntaxException;
import junit.framework.TestCase;

public class UriTest extends TestCase {

    /**
     * Regression test for http://b/issue?id=2604061
     */
    public void testParsingDotAsHostname() throws URISyntaxException {
        assertEquals(null, new URI("http://./").getHost());
    }

    public void testSquareBracketsWithIPv4() throws URISyntaxException {
        try {
            new URI("http://[192.168.0.1]/");
            fail();
        } catch (URISyntaxException e) {
        }
    }

    public void testSquareBracketsWithHostname() throws URISyntaxException {
        try {
            new URI("http://[google.com]/");
            fail();
        } catch (URISyntaxException e) {
        }
    }

    public void testIPv6WithoutSquareBrackets() throws URISyntaxException {
        assertEquals(null, new URI("http://fe80::1234/").getHost());
    }

    public void testEqualityWithNoPath() throws URISyntaxException {
        assertFalse(new URI("http://android.com").equals(new URI("http://android.com/")));
    }
}
