/*
 * Copyright (C) 2015 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.android.systemui.tuner;

import android.app.Activity;
import android.app.Fragment;
import android.os.Bundle;
import android.view.MenuItem;

public class TunerActivity extends Activity {

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);

        getFragmentManager().beginTransaction().replace(android.R.id.content, new TunerFragment())
                .commit();
    }

    /**
     * Base class for direct entry points into
     * tuner fragments
     */
    private static abstract class FragmentTunerActivityBase extends Activity {
        @Override
        protected void onCreate(Bundle savedInstanceState) {
            super.onCreate(savedInstanceState);
            getActionBar().setDisplayHomeAsUpEnabled(true);
            getFragmentManager().beginTransaction().replace(android.R.id.content,
                    getFragment()).commit();
        }

        protected abstract Fragment getFragment();

        @Override
        public final boolean onOptionsItemSelected(MenuItem item) {
            switch (item.getItemId()) {
                case android.R.id.home:
                    finish();
                    return true;
            }
            return super.onOptionsItemSelected(item);
        }
    }

    public static final class DemoModeActivity extends FragmentTunerActivityBase {
        @Override
        protected Fragment getFragment() {
            return new DemoModeFragment();
        }
    }

    public static final class StatusBarIconActivity extends FragmentTunerActivityBase {
        @Override
        protected Fragment getFragment() {
            return new StatusBarIconBlacklistFragment();
        }
    }
}
