/*
**
** Copyright 2006, The Android Open Source Project
**
** Licensed under the Apache License, Version 2.0 (the "License"); 
** you may not use this file except in compliance with the License. 
** You may obtain a copy of the License at 
**
**     http://www.apache.org/licenses/LICENSE-2.0 
**
** Unless required by applicable law or agreed to in writing, software 
** distributed under the License is distributed on an "AS IS" BASIS, 
** WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
** See the License for the specific language governing permissions and 
** limitations under the License.
*/

package com.google.android.gles_jni;

import javax.microedition.khronos.egl.*;

import android.view.Surface;
import android.view.SurfaceView;
import android.view.SurfaceHolder;
import android.view.View;

public class EGLImpl implements EGL10 {
    private EGLContextImpl mContext = new EGLContextImpl(-1);
    private EGLDisplayImpl mDisplay = new EGLDisplayImpl(-1);
    private EGLSurfaceImpl mSurface = new EGLSurfaceImpl(-1);

    public native boolean     eglInitialize(EGLDisplay display, int[] major_minor);
    public native boolean     eglQueryContext(EGLDisplay display, EGLContext context, int attribute, int[] value);    
    public native boolean     eglQuerySurface(EGLDisplay display, EGLSurface surface, int attribute, int[] value);
    public native boolean     eglChooseConfig(EGLDisplay display, int[] attrib_list, EGLConfig[] configs, int config_size, int[] num_config);
    public native boolean     eglGetConfigAttrib(EGLDisplay display, EGLConfig config, int attribute, int[] value);
    public native boolean     eglGetConfigs(EGLDisplay display, EGLConfig[] configs, int config_size, int[] num_config);    
    public native int         eglGetError();
    public native boolean     eglDestroyContext(EGLDisplay display, EGLContext context);
    public native boolean     eglDestroySurface(EGLDisplay display, EGLSurface surface);
    public native boolean     eglMakeCurrent(EGLDisplay display, EGLSurface draw, EGLSurface read, EGLContext context);
    public native String      eglQueryString(EGLDisplay display, int name);
    public native boolean     eglSwapBuffers(EGLDisplay display, EGLSurface surface);
    public native boolean     eglTerminate(EGLDisplay display);
    public native boolean     eglCopyBuffers(EGLDisplay display, EGLSurface surface, Object native_pixmap);
    public native boolean     eglWaitGL();
    public native boolean     eglWaitNative(int engine, Object bindTarget);

    public EGLContext eglCreateContext(EGLDisplay display, EGLConfig config, EGLContext share_context, int[] attrib_list) {
        return new EGLContextImpl( _eglCreateContext(display, config, share_context, attrib_list) );
    }

    public EGLSurface eglCreatePbufferSurface(EGLDisplay display, EGLConfig config, int[] attrib_list) {
        return new EGLSurfaceImpl( _eglCreatePbufferSurface(display, config, attrib_list) );
    }
    
    public EGLSurface eglCreatePixmapSurface(EGLDisplay display, EGLConfig config, Object native_pixmap, int[] attrib_list) {
        EGLSurfaceImpl sur = new EGLSurfaceImpl();
        _eglCreatePixmapSurface(sur, display, config, native_pixmap, attrib_list);
        return sur;
    }

    public EGLSurface eglCreateWindowSurface(EGLDisplay display, EGLConfig config, Object native_window, int[] attrib_list) {
        Surface sur;
        if (native_window instanceof SurfaceView) {
            SurfaceView surfaceView = (SurfaceView)native_window;
            sur = surfaceView.getHolder().getSurface();
        } else if (native_window instanceof SurfaceHolder) {
            SurfaceHolder holder = (SurfaceHolder)native_window;
            sur = holder.getSurface();
        } else {
            throw new java.lang.UnsupportedOperationException(
                "eglCreateWindowSurface() can only be called with an instance of " +
                "SurfaceView or SurfaceHolder at the moment, this will be fixed later.");
        }
        return new EGLSurfaceImpl( _eglCreateWindowSurface(display, config, sur, attrib_list) );
    }
    
    public synchronized EGLDisplay eglGetDisplay(Object native_display) {
        int value = _eglGetDisplay(native_display);
        if (mDisplay.mEGLDisplay != value)
            mDisplay = new EGLDisplayImpl(value);
        return mDisplay;
    }

    public synchronized EGLContext eglGetCurrentContext() {
        int value = _eglGetCurrentContext();
        if (mContext.mEGLContext != value)
            mContext = new EGLContextImpl(value);
        return mContext;
    }
    
    public synchronized EGLDisplay eglGetCurrentDisplay() {
        int value = _eglGetCurrentDisplay();
        if (mDisplay.mEGLDisplay != value)
            mDisplay = new EGLDisplayImpl(value);
        return mDisplay;
    }

    public synchronized EGLSurface eglGetCurrentSurface(int readdraw) {
        int value = _eglGetCurrentSurface(readdraw);
        if (mSurface.mEGLSurface != value)
            mSurface = new EGLSurfaceImpl(value);
        return mSurface;
    }

    private native int _eglCreateContext(EGLDisplay display, EGLConfig config, EGLContext share_context, int[] attrib_list);
    private native int _eglCreatePbufferSurface(EGLDisplay display, EGLConfig config, int[] attrib_list);
    private native void _eglCreatePixmapSurface(EGLSurface sur, EGLDisplay display, EGLConfig config, Object native_pixmap, int[] attrib_list);
    private native int _eglCreateWindowSurface(EGLDisplay display, EGLConfig config, Object native_window, int[] attrib_list);    
    private native int _eglGetDisplay(Object native_display);
    private native int _eglGetCurrentContext();
    private native int _eglGetCurrentDisplay();
    private native int _eglGetCurrentSurface(int readdraw);

    native private static void _nativeClassInit();
    static { _nativeClassInit(); }
}
