//===- subzero/crosstest/test_vector_ops.cpp - Vector tests -----*- C++ -*-===//
//
//                        The Subzero Code Generator
//
// This file is distributed under the University of Illinois Open Source
// License. See LICENSE.TXT for details.
//
//===----------------------------------------------------------------------===//
//
// This file implements the vector shuffle routines.
//
//===----------------------------------------------------------------------===//

#include "test_vector_ops.h"

#include <algorithm>
#include <type_traits>

namespace {
// SHUFFLETESTS_TABLE declares several shufflevector test cases. Each test case
// has 16 indexes because 16 is the max number of elements in a vector type in
// PNaCl bitcode. For vector types with fewer than 16 elements, the additional
// indexes are ignored. This strategy allows a single test table definition.
#define SHUFFLETESTS_TABLE                                                     \
  /* Indexes... */                                                             \
  /* Simple tests splatting elements. */                                       \
  X(0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)                            \
  X(1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1)                            \
  X(2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2)                            \
  X(3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3)                            \
  X(4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4)                            \
  X(5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5)                            \
  X(6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6)                            \
  X(7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7)                            \
  X(8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8)                            \
  X(9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9)                            \
  X(10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10)            \
  X(11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11)            \
  X(12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12)            \
  X(13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13)            \
  X(14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14)            \
  X(15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15)            \
  X(16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16)            \
  X(17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17)            \
  X(18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18)            \
  X(19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19)            \
  X(20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20)            \
  X(21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21)            \
  X(22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22)            \
  X(23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23)            \
  X(24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24)            \
  X(25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25)            \
  X(26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26)            \
  X(27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27)            \
  X(28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28)            \
  X(29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29)            \
  X(30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30)            \
  X(31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31)            \
  /* Rotating vectors. */                                                      \
  X(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16)                     \
  X(2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17)                    \
  X(3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18)                   \
  X(4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19)                  \
  X(5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20)                 \
  X(6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21)                \
  X(7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22)               \
  X(8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23)              \
  X(9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24)             \
  X(10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25)            \
  X(11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26)            \
  X(12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27)            \
  X(13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28)            \
  X(14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29)            \
  X(15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30)            \
  X(16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31)            \
  X(17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 0)             \
  X(18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 0, 1)              \
  X(19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 0, 1, 2)               \
  X(20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 0, 1, 2, 3)                \
  X(21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 0, 1, 2, 3, 4)                 \
  X(22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 0, 1, 2, 3, 4, 5)                  \
  X(23, 24, 25, 26, 27, 28, 29, 30, 31, 0, 1, 2, 3, 4, 5, 6)                   \
  X(24, 25, 26, 27, 28, 29, 30, 31, 0, 1, 2, 3, 4, 5, 6, 7)                    \
  X(25, 26, 27, 28, 29, 30, 31, 0, 1, 2, 3, 4, 5, 6, 7, 8)                     \
  X(26, 27, 28, 29, 30, 31, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9)                      \
  X(27, 28, 29, 30, 31, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10)                      \
  X(28, 29, 30, 31, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11)                      \
  X(29, 30, 31, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12)                      \
  X(30, 31, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13)                      \
  X(31, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14)                      \
  /* Swapping elements. */                                                     \
  X(1, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15)                      \
  X(2, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15)                      \
  X(3, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15)                      \
  X(4, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15)                      \
  X(5, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15)                      \
  X(6, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15)                      \
  X(7, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15)                      \
  X(8, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15)                      \
  X(9, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15)                      \
  X(10, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15)                     \
  X(11, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15)                     \
  X(12, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15)                     \
  X(13, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15)                     \
  X(14, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15)                     \
  X(15, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15)                     \
  X(16, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15)                     \
  X(17, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15)                     \
  X(18, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15)                     \
  X(19, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15)                     \
  X(20, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15)                     \
  X(21, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15)                     \
  X(22, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15)                     \
  X(23, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15)                     \
  X(24, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15)                     \
  X(25, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15)                     \
  X(26, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15)                     \
  X(27, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15)                     \
  X(28, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15)                     \
  X(29, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15)                     \
  X(30, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15)                     \
  X(31, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15)                     \
  X(0, 2, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15)                      \
  X(0, 3, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15)                      \
  X(0, 4, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15)                      \
  X(0, 5, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15)                      \
  X(0, 6, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15)                      \
  X(0, 7, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15)                      \
  X(0, 8, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15)                      \
  X(0, 9, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15)                      \
  X(0, 10, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15)                     \
  X(0, 11, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15)                     \
  X(0, 12, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15)                     \
  X(0, 13, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15)                     \
  X(0, 14, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15)                     \
  X(0, 15, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15)                     \
  X(0, 16, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15)                     \
  X(0, 17, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15)                     \
  X(0, 18, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15)                     \
  X(0, 19, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15)                     \
  X(0, 20, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15)                     \
  X(0, 21, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15)                     \
  X(0, 22, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15)                     \
  X(0, 23, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15)                     \
  X(0, 24, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15)                     \
  X(0, 25, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15)                     \
  X(0, 26, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15)                     \
  X(0, 27, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15)                     \
  X(0, 28, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15)                     \
  X(0, 29, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15)                     \
  X(0, 30, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15)                     \
  X(0, 31, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15)                     \
  X(0, 1, 0, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15)                      \
  X(0, 1, 1, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15)                      \
  X(0, 1, 3, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15)                      \
  X(0, 1, 4, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15)                      \
  X(0, 1, 5, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15)                      \
  X(0, 1, 6, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15)                      \
  X(0, 1, 7, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15)                      \
  X(0, 1, 8, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15)                      \
  X(0, 1, 9, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15)                      \
  X(0, 1, 10, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15)                     \
  X(0, 1, 11, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15)                     \
  X(0, 1, 12, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15)                     \
  X(0, 1, 13, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15)                     \
  X(0, 1, 14, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15)                     \
  X(0, 1, 15, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15)                     \
  X(0, 1, 16, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15)                     \
  X(0, 1, 17, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15)                     \
  X(0, 1, 18, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15)                     \
  X(0, 1, 19, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15)                     \
  X(0, 1, 20, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15)                     \
  X(0, 1, 21, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15)                     \
  X(0, 1, 22, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15)                     \
  X(0, 1, 23, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15)                     \
  X(0, 1, 24, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15)                     \
  X(0, 1, 25, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15)                     \
  X(0, 1, 26, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15)                     \
  X(0, 1, 27, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15)                     \
  X(0, 1, 28, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15)                     \
  X(0, 1, 29, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15)                     \
  X(0, 1, 30, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15)                     \
  X(0, 1, 31, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15)                     \
  X(0, 1, 2, 0, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15)                      \
  X(0, 1, 2, 1, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15)                      \
  X(0, 1, 2, 2, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15)                      \
  X(0, 1, 2, 4, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15)                      \
  X(0, 1, 2, 5, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15)                      \
  X(0, 1, 2, 6, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15)                      \
  X(0, 1, 2, 7, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15)                      \
  X(0, 1, 2, 8, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15)                      \
  X(0, 1, 2, 9, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15)                      \
  X(0, 1, 2, 10, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15)                     \
  X(0, 1, 2, 11, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15)                     \
  X(0, 1, 2, 12, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15)                     \
  X(0, 1, 2, 13, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15)                     \
  X(0, 1, 2, 14, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15)                     \
  X(0, 1, 2, 15, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15)                     \
  X(0, 1, 2, 16, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15)                     \
  X(0, 1, 2, 17, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15)                     \
  X(0, 1, 2, 18, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15)                     \
  X(0, 1, 2, 19, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15)                     \
  X(0, 1, 2, 20, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15)                     \
  X(0, 1, 2, 21, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15)                     \
  X(0, 1, 2, 22, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15)                     \
  X(0, 1, 2, 23, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15)                     \
  X(0, 1, 2, 24, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15)                     \
  X(0, 1, 2, 25, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15)                     \
  X(0, 1, 2, 26, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15)                     \
  X(0, 1, 2, 27, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15)                     \
  X(0, 1, 2, 28, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15)                     \
  X(0, 1, 2, 29, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15)                     \
  X(0, 1, 2, 30, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15)                     \
  X(0, 1, 2, 31, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15)                     \
  X(0, 1, 2, 3, 0, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15)                      \
  X(0, 1, 2, 3, 1, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15)                      \
  X(0, 1, 2, 3, 2, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15)                      \
  X(0, 1, 2, 3, 3, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15)                      \
  X(0, 1, 2, 3, 5, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15)                      \
  X(0, 1, 2, 3, 6, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15)                      \
  X(0, 1, 2, 3, 7, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15)                      \
  X(0, 1, 2, 3, 8, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15)                      \
  X(0, 1, 2, 3, 9, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15)                      \
  X(0, 1, 2, 3, 10, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15)                     \
  X(0, 1, 2, 3, 11, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15)                     \
  X(0, 1, 2, 3, 12, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15)                     \
  X(0, 1, 2, 3, 13, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15)                     \
  X(0, 1, 2, 3, 14, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15)                     \
  X(0, 1, 2, 3, 15, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15)                     \
  X(0, 1, 2, 3, 16, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15)                     \
  X(0, 1, 2, 3, 17, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15)                     \
  X(0, 1, 2, 3, 18, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15)                     \
  X(0, 1, 2, 3, 19, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15)                     \
  X(0, 1, 2, 3, 20, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15)                     \
  X(0, 1, 2, 3, 21, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15)                     \
  X(0, 1, 2, 3, 22, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15)                     \
  X(0, 1, 2, 3, 22, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15)                     \
  X(0, 1, 2, 3, 23, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15)                     \
  X(0, 1, 2, 3, 24, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15)                     \
  X(0, 1, 2, 3, 25, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15)                     \
  X(0, 1, 2, 3, 26, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15)                     \
  X(0, 1, 2, 3, 27, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15)                     \
  X(0, 1, 2, 3, 28, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15)                     \
  X(0, 1, 2, 3, 29, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15)                     \
  X(0, 1, 2, 3, 30, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15)                     \
  X(0, 1, 2, 3, 31, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15)                     \
  X(0, 1, 2, 3, 4, 0, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15)                      \
  X(0, 1, 2, 3, 4, 1, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15)                      \
  X(0, 1, 2, 3, 4, 2, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15)                      \
  X(0, 1, 2, 3, 4, 3, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15)                      \
  X(0, 1, 2, 3, 4, 4, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15)                      \
  X(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15)                      \
  X(0, 1, 2, 3, 4, 6, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15)                      \
  X(0, 1, 2, 3, 4, 7, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15)                      \
  X(0, 1, 2, 3, 4, 8, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15)                      \
  X(0, 1, 2, 3, 4, 9, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15)                      \
  X(0, 1, 2, 3, 4, 0, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15)                      \
  X(0, 1, 2, 3, 4, 11, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15)                     \
  X(0, 1, 2, 3, 4, 12, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15)                     \
  X(0, 1, 2, 3, 4, 13, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15)                     \
  X(0, 1, 2, 3, 4, 14, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15)                     \
  X(0, 1, 2, 3, 4, 15, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15)                     \
  X(0, 1, 2, 3, 4, 16, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15)                     \
  X(0, 1, 2, 3, 4, 17, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15)                     \
  X(0, 1, 2, 3, 4, 18, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15)                     \
  X(0, 1, 2, 3, 4, 19, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15)                     \
  X(0, 1, 2, 3, 4, 20, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15)                     \
  X(0, 1, 2, 3, 4, 21, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15)                     \
  X(0, 1, 2, 3, 4, 22, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15)                     \
  X(0, 1, 2, 3, 4, 23, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15)                     \
  X(0, 1, 2, 3, 4, 24, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15)                     \
  X(0, 1, 2, 3, 4, 25, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15)                     \
  X(0, 1, 2, 3, 4, 26, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15)                     \
  X(0, 1, 2, 3, 4, 27, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15)                     \
  X(0, 1, 2, 3, 4, 28, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15)                     \
  X(0, 1, 2, 3, 4, 29, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15)                     \
  X(0, 1, 2, 3, 4, 30, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15)                     \
  X(0, 1, 2, 3, 4, 31, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15)                     \
  X(0, 1, 2, 3, 4, 5, 0, 7, 8, 9, 10, 11, 12, 13, 14, 15)                      \
  X(0, 1, 2, 3, 4, 5, 1, 7, 8, 9, 10, 11, 12, 13, 14, 15)                      \
  X(0, 1, 2, 3, 4, 5, 2, 7, 8, 9, 10, 11, 12, 13, 14, 15)                      \
  X(0, 1, 2, 3, 4, 5, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15)                      \
  X(0, 1, 2, 3, 4, 5, 4, 7, 8, 9, 10, 11, 12, 13, 14, 15)                      \
  X(0, 1, 2, 3, 4, 5, 5, 7, 8, 9, 10, 11, 12, 13, 14, 15)                      \
  X(0, 1, 2, 3, 4, 5, 7, 7, 8, 9, 10, 11, 12, 13, 14, 15)                      \
  X(0, 1, 2, 3, 4, 5, 8, 7, 8, 9, 10, 11, 12, 13, 14, 15)                      \
  X(0, 1, 2, 3, 4, 5, 9, 7, 8, 9, 10, 11, 12, 13, 14, 15)                      \
  X(0, 1, 2, 3, 4, 5, 0, 7, 8, 9, 10, 11, 12, 13, 14, 15)                      \
  X(0, 1, 2, 3, 4, 5, 11, 7, 8, 9, 10, 11, 12, 13, 14, 15)                     \
  X(0, 1, 2, 3, 4, 5, 12, 7, 8, 9, 10, 11, 12, 13, 14, 15)                     \
  X(0, 1, 2, 3, 4, 5, 13, 7, 8, 9, 10, 11, 12, 13, 14, 15)                     \
  X(0, 1, 2, 3, 4, 5, 14, 7, 8, 9, 10, 11, 12, 13, 14, 15)                     \
  X(0, 1, 2, 3, 4, 5, 15, 7, 8, 9, 10, 11, 12, 13, 14, 15)                     \
  X(0, 1, 2, 3, 4, 5, 16, 7, 8, 9, 10, 11, 12, 13, 14, 15)                     \
  X(0, 1, 2, 3, 4, 5, 17, 7, 8, 9, 10, 11, 12, 13, 14, 15)                     \
  X(0, 1, 2, 3, 4, 5, 18, 7, 8, 9, 10, 11, 12, 13, 14, 15)                     \
  X(0, 1, 2, 3, 4, 5, 19, 7, 8, 9, 10, 11, 12, 13, 14, 15)                     \
  X(0, 1, 2, 3, 4, 5, 20, 7, 8, 9, 10, 11, 12, 13, 14, 15)                     \
  X(0, 1, 2, 3, 4, 5, 21, 7, 8, 9, 10, 11, 12, 13, 14, 15)                     \
  X(0, 1, 2, 3, 4, 5, 22, 7, 8, 9, 10, 11, 12, 13, 14, 15)                     \
  X(0, 1, 2, 3, 4, 5, 23, 7, 8, 9, 10, 11, 12, 13, 14, 15)                     \
  X(0, 1, 2, 3, 4, 5, 24, 7, 8, 9, 10, 11, 12, 13, 14, 15)                     \
  X(0, 1, 2, 3, 4, 5, 25, 7, 8, 9, 10, 11, 12, 13, 14, 15)                     \
  X(0, 1, 2, 3, 4, 5, 26, 7, 8, 9, 10, 11, 12, 13, 14, 15)                     \
  X(0, 1, 2, 3, 4, 5, 27, 7, 8, 9, 10, 11, 12, 13, 14, 15)                     \
  X(0, 1, 2, 3, 4, 5, 28, 7, 8, 9, 10, 11, 12, 13, 14, 15)                     \
  X(0, 1, 2, 3, 4, 5, 29, 7, 8, 9, 10, 11, 12, 13, 14, 15)                     \
  X(0, 1, 2, 3, 4, 5, 30, 7, 8, 9, 10, 11, 12, 13, 14, 15)                     \
  X(0, 1, 2, 3, 4, 5, 31, 7, 8, 9, 10, 11, 12, 13, 14, 15)                     \
  X(0, 1, 2, 3, 4, 5, 6, 0, 8, 9, 10, 11, 12, 13, 14, 15)                      \
  X(0, 1, 2, 3, 4, 5, 6, 1, 8, 9, 10, 11, 12, 13, 14, 15)                      \
  X(0, 1, 2, 3, 4, 5, 6, 2, 8, 9, 10, 11, 12, 13, 14, 15)                      \
  X(0, 1, 2, 3, 4, 5, 6, 3, 8, 9, 10, 11, 12, 13, 14, 15)                      \
  X(0, 1, 2, 3, 4, 5, 6, 4, 8, 9, 10, 11, 12, 13, 14, 15)                      \
  X(0, 1, 2, 3, 4, 5, 6, 5, 8, 9, 10, 11, 12, 13, 14, 15)                      \
  X(0, 1, 2, 3, 4, 5, 6, 6, 8, 9, 10, 11, 12, 13, 14, 15)                      \
  X(0, 1, 2, 3, 4, 5, 6, 8, 8, 9, 10, 11, 12, 13, 14, 15)                      \
  X(0, 1, 2, 3, 4, 5, 6, 9, 8, 9, 10, 11, 12, 13, 14, 15)                      \
  X(0, 1, 2, 3, 4, 5, 6, 10, 8, 9, 10, 11, 12, 13, 14, 15)                     \
  X(0, 1, 2, 3, 4, 5, 6, 11, 8, 9, 10, 11, 12, 13, 14, 15)                     \
  X(0, 1, 2, 3, 4, 5, 6, 12, 8, 9, 10, 11, 12, 13, 14, 15)                     \
  X(0, 1, 2, 3, 4, 5, 6, 13, 8, 9, 10, 11, 12, 13, 14, 15)                     \
  X(0, 1, 2, 3, 4, 5, 6, 14, 8, 9, 10, 11, 12, 13, 14, 15)                     \
  X(0, 1, 2, 3, 4, 5, 6, 15, 8, 9, 10, 11, 12, 13, 14, 15)                     \
  X(0, 1, 2, 3, 4, 5, 6, 16, 8, 9, 10, 11, 12, 13, 14, 15)                     \
  X(0, 1, 2, 3, 4, 5, 6, 17, 8, 9, 10, 11, 12, 13, 14, 15)                     \
  X(0, 1, 2, 3, 4, 5, 6, 18, 8, 9, 10, 11, 12, 13, 14, 15)                     \
  X(0, 1, 2, 3, 4, 5, 6, 19, 8, 9, 10, 11, 12, 13, 14, 15)                     \
  X(0, 1, 2, 3, 4, 5, 6, 20, 8, 9, 10, 11, 12, 13, 14, 15)                     \
  X(0, 1, 2, 3, 4, 5, 6, 21, 8, 9, 10, 11, 12, 13, 14, 15)                     \
  X(0, 1, 2, 3, 4, 5, 6, 22, 8, 9, 10, 11, 12, 13, 14, 15)                     \
  X(0, 1, 2, 3, 4, 5, 6, 23, 8, 9, 10, 11, 12, 13, 14, 15)                     \
  X(0, 1, 2, 3, 4, 5, 6, 24, 8, 9, 10, 11, 12, 13, 14, 15)                     \
  X(0, 1, 2, 3, 4, 5, 6, 25, 8, 9, 10, 11, 12, 13, 14, 15)                     \
  X(0, 1, 2, 3, 4, 5, 6, 26, 8, 9, 10, 11, 12, 13, 14, 15)                     \
  X(0, 1, 2, 3, 4, 5, 6, 27, 8, 9, 10, 11, 12, 13, 14, 15)                     \
  X(0, 1, 2, 3, 4, 5, 6, 28, 8, 9, 10, 11, 12, 13, 14, 15)                     \
  X(0, 1, 2, 3, 4, 5, 6, 29, 8, 9, 10, 11, 12, 13, 14, 15)                     \
  X(0, 1, 2, 3, 4, 5, 6, 30, 8, 9, 10, 11, 12, 13, 14, 15)                     \
  X(0, 1, 2, 3, 4, 5, 6, 31, 0, 9, 10, 11, 12, 13, 14, 15)                     \
  X(0, 1, 2, 3, 4, 5, 6, 7, 0, 9, 10, 11, 12, 13, 14, 15)                      \
  X(0, 1, 2, 3, 4, 5, 6, 7, 1, 9, 10, 11, 12, 13, 14, 15)                      \
  X(0, 1, 2, 3, 4, 5, 6, 7, 2, 9, 10, 11, 12, 13, 14, 15)                      \
  X(0, 1, 2, 3, 4, 5, 6, 7, 3, 9, 10, 11, 12, 13, 14, 15)                      \
  X(0, 1, 2, 3, 4, 5, 6, 7, 4, 9, 10, 11, 12, 13, 14, 15)                      \
  X(0, 1, 2, 3, 4, 5, 6, 7, 5, 9, 10, 11, 12, 13, 14, 15)                      \
  X(0, 1, 2, 3, 4, 5, 6, 7, 6, 9, 10, 11, 12, 13, 14, 15)                      \
  X(0, 1, 2, 3, 4, 5, 6, 7, 7, 9, 10, 11, 12, 13, 14, 15)                      \
  X(0, 1, 2, 3, 4, 5, 6, 7, 9, 9, 10, 11, 12, 13, 14, 15)                      \
  X(0, 1, 2, 3, 4, 5, 6, 7, 10, 9, 10, 11, 12, 13, 14, 15)                     \
  X(0, 1, 2, 3, 4, 5, 6, 7, 11, 9, 10, 11, 12, 13, 14, 15)                     \
  X(0, 1, 2, 3, 4, 5, 6, 7, 12, 9, 10, 11, 12, 13, 14, 15)                     \
  X(0, 1, 2, 3, 4, 5, 6, 7, 13, 9, 10, 11, 12, 13, 14, 15)                     \
  X(0, 1, 2, 3, 4, 5, 6, 7, 14, 9, 10, 11, 12, 13, 14, 15)                     \
  X(0, 1, 2, 3, 4, 5, 6, 7, 15, 9, 10, 11, 12, 13, 14, 15)                     \
  X(0, 1, 2, 3, 4, 5, 6, 7, 16, 9, 10, 11, 12, 13, 14, 15)                     \
  X(0, 1, 2, 3, 4, 5, 6, 7, 17, 9, 10, 11, 12, 13, 14, 15)                     \
  X(0, 1, 2, 3, 4, 5, 6, 7, 18, 9, 10, 11, 12, 13, 14, 15)                     \
  X(0, 1, 2, 3, 4, 5, 6, 7, 19, 9, 10, 11, 12, 13, 14, 15)                     \
  X(0, 1, 2, 3, 4, 5, 6, 7, 20, 9, 10, 11, 12, 13, 14, 15)                     \
  X(0, 1, 2, 3, 4, 5, 6, 7, 21, 9, 10, 11, 12, 13, 14, 15)                     \
  X(0, 1, 2, 3, 4, 5, 6, 7, 22, 9, 10, 11, 12, 13, 14, 15)                     \
  X(0, 1, 2, 3, 4, 5, 6, 7, 23, 9, 10, 11, 12, 13, 14, 15)                     \
  X(0, 1, 2, 3, 4, 5, 6, 7, 24, 9, 10, 11, 12, 13, 14, 15)                     \
  X(0, 1, 2, 3, 4, 5, 6, 7, 25, 9, 10, 11, 12, 13, 14, 15)                     \
  X(0, 1, 2, 3, 4, 5, 6, 7, 26, 9, 10, 11, 12, 13, 14, 15)                     \
  X(0, 1, 2, 3, 4, 5, 6, 7, 27, 9, 10, 11, 12, 13, 14, 15)                     \
  X(0, 1, 2, 3, 4, 5, 6, 7, 28, 9, 10, 11, 12, 13, 14, 15)                     \
  X(0, 1, 2, 3, 4, 5, 6, 7, 29, 9, 10, 11, 12, 13, 14, 15)                     \
  X(0, 1, 2, 3, 4, 5, 6, 7, 30, 9, 10, 11, 12, 13, 14, 15)                     \
  X(0, 1, 2, 3, 4, 5, 6, 7, 31, 9, 10, 11, 12, 13, 14, 15)                     \
  X(0, 1, 2, 3, 4, 5, 6, 7, 8, 0, 10, 11, 12, 13, 14, 15)                      \
  X(0, 1, 2, 3, 4, 5, 6, 7, 8, 1, 10, 11, 12, 13, 14, 15)                      \
  X(0, 1, 2, 3, 4, 5, 6, 7, 8, 2, 10, 11, 12, 13, 14, 15)                      \
  X(0, 1, 2, 3, 4, 5, 6, 7, 8, 3, 10, 11, 12, 13, 14, 15)                      \
  X(0, 1, 2, 3, 4, 5, 6, 7, 8, 4, 10, 11, 12, 13, 14, 15)                      \
  X(0, 1, 2, 3, 4, 5, 6, 7, 8, 5, 10, 11, 12, 13, 14, 15)                      \
  X(0, 1, 2, 3, 4, 5, 6, 7, 8, 6, 10, 11, 12, 13, 14, 15)                      \
  X(0, 1, 2, 3, 4, 5, 6, 7, 8, 7, 10, 11, 12, 13, 14, 15)                      \
  X(0, 1, 2, 3, 4, 5, 6, 7, 8, 8, 10, 11, 12, 13, 14, 15)                      \
  X(0, 1, 2, 3, 4, 5, 6, 7, 8, 10, 10, 11, 12, 13, 14, 15)                     \
  X(0, 1, 2, 3, 4, 5, 6, 7, 8, 11, 10, 11, 12, 13, 14, 15)                     \
  X(0, 1, 2, 3, 4, 5, 6, 7, 8, 12, 10, 11, 12, 13, 14, 15)                     \
  X(0, 1, 2, 3, 4, 5, 6, 7, 8, 13, 10, 11, 12, 13, 14, 15)                     \
  X(0, 1, 2, 3, 4, 5, 6, 7, 8, 14, 10, 11, 12, 13, 14, 15)                     \
  X(0, 1, 2, 3, 4, 5, 6, 7, 8, 15, 10, 11, 12, 13, 14, 15)                     \
  X(0, 1, 2, 3, 4, 5, 6, 7, 8, 16, 10, 11, 12, 13, 14, 15)                     \
  X(0, 1, 2, 3, 4, 5, 6, 7, 8, 17, 10, 11, 12, 13, 14, 15)                     \
  X(0, 1, 2, 3, 4, 5, 6, 7, 8, 18, 10, 11, 12, 13, 14, 15)                     \
  X(0, 1, 2, 3, 4, 5, 6, 7, 8, 19, 10, 11, 12, 13, 14, 15)                     \
  X(0, 1, 2, 3, 4, 5, 6, 7, 8, 20, 10, 11, 12, 13, 14, 15)                     \
  X(0, 1, 2, 3, 4, 5, 6, 7, 8, 21, 10, 11, 12, 13, 14, 15)                     \
  X(0, 1, 2, 3, 4, 5, 6, 7, 8, 22, 10, 11, 12, 13, 14, 15)                     \
  X(0, 1, 2, 3, 4, 5, 6, 7, 8, 23, 10, 11, 12, 13, 14, 15)                     \
  X(0, 1, 2, 3, 4, 5, 6, 7, 8, 24, 10, 11, 12, 13, 14, 15)                     \
  X(0, 1, 2, 3, 4, 5, 6, 7, 8, 25, 10, 11, 12, 13, 14, 15)                     \
  X(0, 1, 2, 3, 4, 5, 6, 7, 8, 26, 10, 11, 12, 13, 14, 15)                     \
  X(0, 1, 2, 3, 4, 5, 6, 7, 8, 27, 10, 11, 12, 13, 14, 15)                     \
  X(0, 1, 2, 3, 4, 5, 6, 7, 8, 28, 10, 11, 12, 13, 14, 15)                     \
  X(0, 1, 2, 3, 4, 5, 6, 7, 8, 29, 10, 11, 12, 13, 14, 15)                     \
  X(0, 1, 2, 3, 4, 5, 6, 7, 8, 30, 10, 11, 12, 13, 14, 15)                     \
  X(0, 1, 2, 3, 4, 5, 6, 7, 8, 31, 10, 11, 12, 13, 14, 15)                     \
  X(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 0, 11, 12, 13, 14, 15)                       \
  X(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 1, 11, 12, 13, 14, 15)                       \
  X(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 2, 11, 12, 13, 14, 15)                       \
  X(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 3, 11, 12, 13, 14, 15)                       \
  X(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 4, 11, 12, 13, 14, 15)                       \
  X(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 5, 11, 12, 13, 14, 15)                       \
  X(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 6, 11, 12, 13, 14, 15)                       \
  X(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 7, 11, 12, 13, 14, 15)                       \
  X(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 8, 11, 12, 13, 14, 15)                       \
  X(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 9, 11, 12, 13, 14, 15)                       \
  X(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 11, 11, 12, 13, 14, 15)                      \
  X(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 12, 11, 12, 13, 14, 15)                      \
  X(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 13, 11, 12, 13, 14, 15)                      \
  X(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 14, 11, 12, 13, 14, 15)                      \
  X(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 15, 11, 12, 13, 14, 15)                      \
  X(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 16, 11, 12, 13, 14, 15)                      \
  X(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 17, 11, 12, 13, 14, 15)                      \
  X(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 18, 11, 12, 13, 14, 15)                      \
  X(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 19, 11, 12, 13, 14, 15)                      \
  X(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 20, 11, 12, 13, 14, 15)                      \
  X(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 21, 11, 12, 13, 14, 15)                      \
  X(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 22, 11, 12, 13, 14, 15)                      \
  X(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 23, 11, 12, 13, 14, 15)                      \
  X(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 24, 11, 12, 13, 14, 15)                      \
  X(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 25, 11, 12, 13, 14, 15)                      \
  X(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 26, 11, 12, 13, 14, 15)                      \
  X(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 27, 11, 12, 13, 14, 15)                      \
  X(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 28, 11, 12, 13, 14, 15)                      \
  X(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 29, 11, 12, 13, 14, 15)                      \
  X(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 30, 11, 12, 13, 14, 15)                      \
  X(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 31, 11, 12, 13, 14, 15)                      \
  X(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 0, 12, 13, 14, 15)                       \
  X(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 1, 12, 13, 14, 15)                       \
  X(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 2, 12, 13, 14, 15)                       \
  X(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 3, 12, 13, 14, 15)                       \
  X(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 4, 12, 13, 14, 15)                       \
  X(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 5, 12, 13, 14, 15)                       \
  X(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 6, 12, 13, 14, 15)                       \
  X(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 7, 12, 13, 14, 15)                       \
  X(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 8, 12, 13, 14, 15)                       \
  X(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 9, 12, 13, 14, 15)                       \
  X(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 10, 12, 13, 14, 15)                      \
  X(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 12, 12, 13, 14, 15)                      \
  X(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 13, 12, 13, 14, 15)                      \
  X(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 14, 12, 13, 14, 15)                      \
  X(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 15, 12, 13, 14, 15)                      \
  X(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 16, 12, 13, 14, 15)                      \
  X(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 17, 12, 13, 14, 15)                      \
  X(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 18, 12, 13, 14, 15)                      \
  X(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 19, 12, 13, 14, 15)                      \
  X(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 20, 12, 13, 14, 15)                      \
  X(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 21, 12, 13, 14, 15)                      \
  X(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 22, 12, 13, 14, 15)                      \
  X(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 23, 12, 13, 14, 15)                      \
  X(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 24, 12, 13, 14, 15)                      \
  X(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 25, 12, 13, 14, 15)                      \
  X(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 26, 12, 13, 14, 15)                      \
  X(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 27, 12, 13, 14, 15)                      \
  X(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 28, 12, 13, 14, 15)                      \
  X(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 29, 12, 13, 14, 15)                      \
  X(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 30, 12, 13, 14, 15)                      \
  X(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 31, 12, 13, 14, 15)                      \
  X(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 0, 13, 14, 15)                       \
  X(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 1, 13, 14, 15)                       \
  X(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 2, 13, 14, 15)                       \
  X(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 3, 13, 14, 15)                       \
  X(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 4, 13, 14, 15)                       \
  X(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 5, 13, 14, 15)                       \
  X(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 6, 13, 14, 15)                       \
  X(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 7, 13, 14, 15)                       \
  X(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 8, 13, 14, 15)                       \
  X(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 9, 13, 14, 15)                       \
  X(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 0, 13, 14, 15)                       \
  X(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 11, 13, 14, 15)                      \
  X(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 13, 13, 14, 15)                      \
  X(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 14, 13, 14, 15)                      \
  X(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 15, 13, 14, 15)                      \
  X(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 16, 13, 14, 15)                      \
  X(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 17, 13, 14, 15)                      \
  X(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 18, 13, 14, 15)                      \
  X(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 19, 13, 14, 15)                      \
  X(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 20, 13, 14, 15)                      \
  X(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 21, 13, 14, 15)                      \
  X(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 22, 13, 14, 15)                      \
  X(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 23, 13, 14, 15)                      \
  X(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 24, 13, 14, 15)                      \
  X(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 25, 13, 14, 15)                      \
  X(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 26, 13, 14, 15)                      \
  X(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 27, 13, 14, 15)                      \
  X(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 28, 13, 14, 15)                      \
  X(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 29, 13, 14, 15)                      \
  X(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 30, 13, 14, 15)                      \
  X(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 31, 13, 14, 15)                      \
  X(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 0, 14, 15)                       \
  X(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 1, 14, 15)                       \
  X(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 2, 14, 15)                       \
  X(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 3, 14, 15)                       \
  X(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 4, 14, 15)                       \
  X(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 5, 14, 15)                       \
  X(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 6, 14, 15)                       \
  X(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 7, 14, 15)                       \
  X(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 8, 14, 15)                       \
  X(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 9, 14, 15)                       \
  X(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 10, 14, 15)                      \
  X(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 11, 14, 15)                      \
  X(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 12, 14, 15)                      \
  X(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15)                      \
  X(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 15, 14, 15)                      \
  X(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 16, 14, 15)                      \
  X(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 17, 14, 15)                      \
  X(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 18, 14, 15)                      \
  X(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 19, 14, 15)                      \
  X(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 20, 14, 15)                      \
  X(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 21, 14, 15)                      \
  X(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 22, 14, 15)                      \
  X(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 23, 14, 15)                      \
  X(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 24, 14, 15)                      \
  X(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 25, 14, 15)                      \
  X(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 26, 14, 15)                      \
  X(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 27, 14, 15)                      \
  X(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 28, 14, 15)                      \
  X(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 29, 14, 15)                      \
  X(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 30, 14, 15)                      \
  X(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 31, 14, 15)                      \
  X(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 0, 15)                       \
  X(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 1, 15)                       \
  X(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 2, 15)                       \
  X(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 3, 15)                       \
  X(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 4, 15)                       \
  X(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 5, 15)                       \
  X(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 6, 15)                       \
  X(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 7, 15)                       \
  X(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 8, 15)                       \
  X(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 9, 15)                       \
  X(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 10, 15)                      \
  X(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 11, 15)                      \
  X(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 12, 15)                      \
  X(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 13, 15)                      \
  X(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 15, 15)                      \
  X(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 16, 15)                      \
  X(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 17, 15)                      \
  X(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 18, 15)                      \
  X(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 19, 15)                      \
  X(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 20, 15)                      \
  X(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 21, 15)                      \
  X(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 22, 15)                      \
  X(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 23, 15)                      \
  X(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 24, 15)                      \
  X(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 25, 15)                      \
  X(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 26, 15)                      \
  X(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 27, 15)                      \
  X(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 28, 15)                      \
  X(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 29, 15)                      \
  X(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 30, 15)                      \
  X(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 31, 15)                      \
  X(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 0)                       \
  X(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 1)                       \
  X(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 2)                       \
  X(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 3)                       \
  X(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 4)                       \
  X(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 5)                       \
  X(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 6)                       \
  X(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 7)                       \
  X(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 8)                       \
  X(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 9)                       \
  X(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 10)                      \
  X(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 11)                      \
  X(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 12)                      \
  X(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 13)                      \
  X(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 14)                      \
  X(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 16)                      \
  X(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 17)                      \
  X(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 18)                      \
  X(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 19)                      \
  X(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 20)                      \
  X(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 21)                      \
  X(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 22)                      \
  X(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 23)                      \
  X(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 24)                      \
  X(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 25)                      \
  X(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 26)                      \
  X(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 27)                      \
  X(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 28)                      \
  X(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 29)                      \
  X(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 30)                      \
  X(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 31)                      \
  /* Testing the optimized shufflevectors for x86. */                          \
  /* (Src0, Src0, Src0, Src0) */                                               \
  X(3, 2, 1, 0, 3, 2, 1, 0, 3, 2, 1, 0, 3, 2, 1, 0)                            \
  X(2, 2, 3, 3, 2, 2, 3, 3, 2, 2, 3, 3, 2, 2, 3, 3)                            \
  /* (Src0, Src0, Src0, Src1) */                                               \
  X(0, 1, 3, 7, 0, 1, 3, 7, 0, 1, 3, 7, 0, 1, 3, 7)                            \
  X(2, 2, 2, 5, 2, 2, 2, 5, 2, 2, 2, 5, 2, 2, 2, 5)                            \
  /* (Src0, Src0, Src1, Src0) */                                               \
  X(1, 2, 6, 0, 1, 2, 6, 0, 1, 2, 6, 0, 1, 2, 6, 0)                            \
  X(3, 2, 3, 5, 3, 2, 3, 5, 3, 2, 3, 5, 3, 2, 3, 5)                            \
  /* (Src0, Src0, Src1, Src1) */                                               \
  X(2, 3, 5, 7, 2, 3, 5, 7, 2, 3, 5, 7, 2, 3, 5, 7)                            \
  X(3, 3, 7, 6, 3, 3, 7, 6, 3, 3, 7, 6, 3, 3, 7, 6)                            \
  /* (Src0, Src1, Src0, Src0) */                                               \
  X(3, 7, 0, 0, 3, 7, 0, 0, 3, 7, 0, 0, 3, 7, 0, 0)                            \
  X(1, 7, 3, 3, 1, 7, 3, 3, 1, 7, 3, 3, 1, 7, 3, 3)                            \
  /* (Src0, Src1, Src0, Src1) */                                               \
  X(0, 4, 1, 5, 0, 4, 1, 5, 0, 4, 1, 5, 0, 4, 1, 5)                            \
  X(0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7)                            \
  X(3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4)                            \
  X(1, 7, 3, 6, 1, 7, 3, 6, 1, 7, 3, 6, 1, 7, 3, 6)                            \
  X(0, 6, 3, 7, 0, 6, 3, 7, 0, 6, 3, 7, 0, 6, 3, 7)                            \
  /* (Src0, Src1, Src1, Src0) */                                               \
  X(0, 7, 7, 0, 0, 7, 7, 0, 0, 7, 7, 0, 0, 7, 7, 0)                            \
  X(3, 4, 4, 3, 3, 4, 4, 3, 3, 4, 4, 3, 3, 4, 4, 3)                            \
  X(1, 5, 3, 6, 1, 5, 3, 6, 1, 5, 3, 6, 1, 5, 3, 6)                            \
  X(0, 6, 2, 6, 0, 6, 2, 6, 0, 6, 2, 6, 0, 6, 2, 6)                            \
  /* (Src0, Src1, Src1, Src1) */                                               \
  X(0, 7, 7, 7, 0, 7, 7, 7, 0, 7, 7, 7, 0, 7, 7, 7)                            \
  X(3, 6, 7, 4, 3, 6, 7, 4, 3, 6, 7, 4, 3, 6, 7, 4)                            \
  /* (Src1, Src0, Src0, Src0) */                                               \
  X(4, 3, 3, 0, 4, 3, 3, 0, 4, 3, 3, 0, 4, 3, 3, 0)                            \
  X(6, 0, 0, 3, 6, 0, 0, 3, 6, 0, 0, 3, 6, 0, 0, 3)                            \
  /* (Src1, Src0, Src0, Src1) */                                               \
  X(4, 3, 2, 6, 4, 3, 2, 6, 4, 3, 2, 6, 4, 3, 2, 6)                            \
  X(5, 2, 1, 4, 5, 2, 1, 4, 5, 2, 1, 4, 5, 2, 1, 4)                            \
  X(6, 0, 0, 4, 6, 0, 0, 4, 6, 0, 0, 4, 6, 0, 0, 4)                            \
  X(5, 2, 2, 6, 5, 2, 2, 6, 5, 2, 2, 6, 5, 2, 2, 6)                            \
  /* (Src1, Src0, Src1, Src0) */                                               \
  X(4, 0, 5, 1, 4, 0, 5, 1, 4, 0, 5, 1, 4, 0, 5, 1)                            \
  X(7, 2, 7, 2, 7, 2, 7, 2, 7, 2, 7, 2, 7, 2, 7, 2)                            \
  X(4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3)                            \
  X(7, 1, 5, 0, 7, 1, 5, 0, 7, 1, 5, 0, 7, 1, 5, 0)                            \
  X(4, 3, 6, 2, 4, 3, 6, 2, 4, 3, 6, 2, 4, 3, 6, 2)                            \
  /* (Src1, Src0, Src1, Src1) */                                               \
  X(6, 0, 3, 2, 6, 0, 3, 2, 6, 0, 3, 2, 6, 0, 3, 2)                            \
  X(4, 2, 4, 7, 4, 2, 4, 7, 4, 2, 4, 7, 4, 2, 4, 7)                            \
  /* (Src1, Src1, Src0, Src0) */                                               \
  X(6, 5, 2, 3, 6, 5, 2, 3, 6, 5, 2, 3, 6, 5, 2, 3)                            \
  X(7, 7, 0, 1, 7, 7, 0, 1, 7, 7, 0, 1, 7, 7, 0, 1)                            \
  /* (Src1, Src1, Src0, Src1) */                                               \
  X(7, 6, 0, 5, 7, 6, 0, 5, 7, 6, 0, 5, 7, 6, 0, 5)                            \
  X(4, 5, 3, 7, 4, 5, 3, 7, 4, 5, 3, 7, 4, 5, 3, 7)                            \
  /* (Src1, Src1, Src1, Src0) */                                               \
  X(6, 6, 4, 0, 6, 6, 4, 0, 6, 6, 4, 0, 6, 6, 4, 0)                            \
  X(7, 4, 6, 1, 7, 4, 6, 1, 7, 4, 6, 1, 7, 4, 6, 1)                            \
  /* (Src1, Src1, Src1, Src1) */                                               \
  X(7, 6, 4, 4, 7, 6, 4, 4, 7, 6, 4, 4, 7, 6, 4, 4)                            \
  X(5, 7, 7, 6, 5, 7, 7, 6, 5, 7, 7, 6, 5, 7, 7, 6)
/* End of x86-optimized shufflevectors. */
//#define X(...)

// ShuffleVectorTest declares the template functions that are used to shuffle
// the test vectors. It has specific template methods depending on how many
// elements VecTy has.
template <typename VecTy> class ShuffleVectorTest {
  //----------------------------------------------------------------------------
  //
  // V4??? Shuffles.
  //
  //----------------------------------------------------------------------------
  template <typename Ty, uint8_t Idx0, uint8_t Idx1, uint8_t Idx2, uint8_t Idx3,
            uint8_t, uint8_t, uint8_t, uint8_t, uint8_t, uint8_t, uint8_t,
            uint8_t, uint8_t, uint8_t, uint8_t, uint8_t>
  static typename std::enable_if<Vectors<Ty>::NumElements == 4, Ty>::type
  shufflevector(Ty V1, Ty V2) {
    const uint8_t NumElements = 4;
    return __builtin_shufflevector(
        V1, V2, Idx0 % (NumElements * 2), Idx1 % (NumElements * 2),
        Idx2 % (NumElements * 2), Idx3 % (NumElements * 2));
  }

  //----------------------------------------------------------------------------
  //
  // V8??? Shuffles.
  //
  //----------------------------------------------------------------------------
  template <typename Ty, uint8_t Idx0, uint8_t Idx1, uint8_t Idx2, uint8_t Idx3,
            uint8_t Idx4, uint8_t Idx5, uint8_t Idx6, uint8_t Idx7, uint8_t,
            uint8_t, uint8_t, uint8_t, uint8_t, uint8_t, uint8_t, uint8_t>
  static typename std::enable_if<Vectors<Ty>::NumElements == 8, Ty>::type
  shufflevector(Ty V1, Ty V2) {
    const uint8_t NumElements = 8;
    return __builtin_shufflevector(
        V1, V2, Idx0 % (NumElements * 2), Idx1 % (NumElements * 2),
        Idx2 % (NumElements * 2), Idx3 % (NumElements * 2),
        Idx4 % (NumElements * 2), Idx5 % (NumElements * 2),
        Idx6 % (NumElements * 2), Idx7 % (NumElements * 2));
  }

  //----------------------------------------------------------------------------
  //
  // V16??? Shuffles.
  //
  //----------------------------------------------------------------------------
  template <typename Ty, uint8_t Idx0, uint8_t Idx1, uint8_t Idx2, uint8_t Idx3,
            uint8_t Idx4, uint8_t Idx5, uint8_t Idx6, uint8_t Idx7,
            uint8_t Idx8, uint8_t Idx9, uint8_t Idx10, uint8_t Idx11,
            uint8_t Idx12, uint8_t Idx13, uint8_t Idx14, uint8_t Idx15>
  static typename std::enable_if<Vectors<Ty>::NumElements == 16, Ty>::type
  shufflevector(Ty V1, Ty V2) {
    const uint8_t NumElements = 16;
    return __builtin_shufflevector(
        V1, V2, Idx0, Idx1 % (NumElements * 2), Idx2 % (NumElements * 2),
        Idx3 % (NumElements * 2), Idx4 % (NumElements * 2),
        Idx5 % (NumElements * 2), Idx6 % (NumElements * 2),
        Idx7 % (NumElements * 2), Idx8 % (NumElements * 2),
        Idx9 % (NumElements * 2), Idx10 % (NumElements * 2),
        Idx11 % (NumElements * 2), Idx12 % (NumElements * 2),
        Idx13 % (NumElements * 2), Idx14 % (NumElements * 2),
        Idx15 % (NumElements * 2));
  }

public:
  typedef VecTy (*TestFn)(VecTy V1, VecTy V2);
  static TestFn Tests[];
  static const uint32_t NumTests;
};

template <typename Ty>
typename ShuffleVectorTest<Ty>::TestFn ShuffleVectorTest<Ty>::Tests[] = {
#define X(...) &ShuffleVectorTest<Ty>::shufflevector<Ty, __VA_ARGS__>,
    SHUFFLETESTS_TABLE
#undef X
};

template <typename Ty>
const uint32_t ShuffleVectorTest<Ty>::NumTests = 0
#define X(...) +1
    SHUFFLETESTS_TABLE
#undef X
    ;
} // end of anonymous namespace

extern "C" {
#define X(Ty, ElmtTy, CastTy)                                                  \
  TY(Ty) shufflevector_##Ty(TY(Ty) V1, TY(Ty) V2, uint32_t Which) {            \
    return (*ShuffleVectorTest<TY(Ty)>::Tests[Which])(V1, V2);                 \
  }                                                                            \
  uint32_t shufflevector_count_##Ty() {                                        \
    return ShuffleVectorTest<TY(Ty)>::NumTests;                                \
  }
VECTOR_TYPE_TABLE
#undef X

#define X(I1Ty, Ty, numelements)                                               \
  TY(I1Ty) shufflevector_##I1Ty(TY(I1Ty) V1, TY(I1Ty) V2, uint32_t Which) {    \
    return (*ShuffleVectorTest<TY(I1Ty)>::Tests[Which])(V1, V2);               \
  }                                                                            \
  uint32_t shufflevector_count_##I1Ty() {                                      \
    return ShuffleVectorTest<TY(I1Ty)>::NumTests;                              \
  }
I1_VECTOR_TYPE_TABLE
#undef X
} // end of extern "C"
