/* ------------------------------------------------------------------
 * Copyright (C) 1998-2009 PacketVideo
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
 * express or implied.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 * -------------------------------------------------------------------
 */

#ifndef RTSP_PAR_COM_BASIC_DS_H_
#define RTSP_PAR_COM_BASIC_DS_H_

//#include "oscl_types.h"
#include "oscl_base.h"

#include "oscl_mem.h"
#include "oscl_str_ptr_len.h"
#include "rtprtcp.h"
// for RTSP method id
//
typedef enum
{
    METHOD_UNRECOGNIZED = 0,
    METHOD_DESCRIBE,
    METHOD_GET_PARAMETER,
    METHOD_OPTIONS,
    METHOD_PAUSE,
    METHOD_PLAY,
    METHOD_SETUP,
    METHOD_RECORD,
    METHOD_TEARDOWN,
    METHOD_END_OF_STREAM,
    METHOD_BINARY_DATA,
    METHOD_REDIRECT,
    METHOD_SET_PARAMETER,
    METHOD_GET,
    METHOD_POST,
    METHOD_PLAYLIST_PLAY,
    METHOD_NUM_ENTRIES //placeholder

} RTSPMethod;


// for easy transport access
//
typedef struct
{
    // fields TBD
} RTSPTransport;


// for easy range access
typedef struct
{
    // fields TBD
} RTSPRange;


// type of message
//
typedef enum
{
    RTSPRequestMsg,
    RTSPResponseMsg,
    RTSPUnknownMsg

} RTSPMsgType;

// return type for isMalformed
//
typedef enum
{
    RTSPOk,
    RTSPErrorVersion,
    RTSPErrorTooBig,
    RTSPErrorTooManyFields,
    RTSPErrorSyntax
} RTSPStructureStatus;


// RTSP response code values
//
typedef uint16 RTSPStatusCode;

// RTSP session id
//
typedef StrPtrLen RTSPSessionId;

// RTSP entity body
//
typedef struct OsclMemoryFragment RTSPEntityBody;

const RTSPStatusCode
Code100 = 100,  // continue
          CodeContinue = 100,

                         Code200 = 200, // ok
                                   CodeOK = 200,

                                            Code201 = 201,  // created
                                                      CodeCreated = 201,

                                                                    Code250 = 250,  // low on storage space
                                                                              CodeLowOnStorageSpace = 250,

                                                                                                      Code300 = 300,  // multiple choices
                                                                                                                CodeMultipleChoices = 300,

                                                                                                                                      Code301 = 301,  // moved permanently
                                                                                                                                                CodeMovedPermanently = 301,

                                                                                                                                                                       Code302 = 302,  // moved temporarily
                                                                                                                                                                                 CodeMovedTemporarily = 302,

                                                                                                                                                                                                        Code303 = 303,  // see other
                                                                                                                                                                                                                  CodeSeeOther = 303,

                                                                                                                                                                                                                                 Code304 = 304,  // not modified
                                                                                                                                                                                                                                           CodeNotModified = 304,

                                                                                                                                                                                                                                                             Code305 = 305,  // use proxy
                                                                                                                                                                                                                                                                       CodeUseProxy = 305,

                                                                                                                                                                                                                                                                                      Code400 = 400,    // bad request
                                                                                                                                                                                                                                                                                                CodeBadRequest = 400,

                                                                                                                                                                                                                                                                                                                 Code401 = 401, // unauthorized
                                                                                                                                                                                                                                                                                                                           CodeUnauthorized = 401,

                                                                                                                                                                                                                                                                                                                                              Code402 = 402,  // payment required
                                                                                                                                                                                                                                                                                                                                                        CodePaymentRequired = 402,

                                                                                                                                                                                                                                                                                                                                                                              Code403 = 403,  // forbidden
                                                                                                                                                                                                                                                                                                                                                                                        CodeForbidden = 403,

                                                                                                                                                                                                                                                                                                                                                                                                        Code404 = 404,  // not found
                                                                                                                                                                                                                                                                                                                                                                                                                  CodeNotFound = 404,

                                                                                                                                                                                                                                                                                                                                                                                                                                 Code405 = 405,  // method not allowed
                                                                                                                                                                                                                                                                                                                                                                                                                                           CodeMethodNotAllowed = 405,

                                                                                                                                                                                                                                                                                                                                                                                                                                                                  Code406 = 406,    // not acceptable
                                                                                                                                                                                                                                                                                                                                                                                                                                                                            CodeNotAcceptable = 406,

                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                Code407 = 407,  // proxy authentication required
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          CodeProxyAuthenticationRequired = 407,

                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            Code408 = 408,  // request time-out
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      CodeRequestTimeOut = 408,

                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           Code410 = 410,  // gone
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     CodeGone = 410,

                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                Code411 = 411,  // length required
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          CodeLengthRequired = 411,

                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               Code412 = 412,  // precondition failed
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         CodePreconditionFailed = 412,

                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  Code413 = 413,    // request entity too large
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            CodeRequestEntityTooLarge = 413,

                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        Code414 = 414,  // request-uri too large
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  CodeRequestURITooLarge = 414,

                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           Code415 = 415,  // unsupported media type
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     CodeUnsupportedMediaType = 415,

                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                Code451 = 451,  // parameter not understood
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          CodeParameterNotUnderstood = 451,

                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       Code452 = 452,  // conference not found
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 CodeConferenceNotFound = 452,

                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          Code453 = 453,  // not enough bandwidth
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    CodeNotEnoughBandwidth = 453,

                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             Code454 = 454, // session not found
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       CodeSessionNotFound = 454,

                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             Code455 = 455, // method not valid in this state
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       CodeMethodNotValidInThisState = 455,

                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       Code456 = 456,   // header field not valid for resource
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 CodeHeaderFieldNotValidForResource = 456,

                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      Code457 = 457,    // invalid range
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                CodeInvalidRange = 457,

                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   Code458 = 458,  // parameter is read-only
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             CodeParameterIsReadOnly = 458,

                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       Code459 = 459,   // aggregate operation not allowed
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 CodeAggregateOperationNotAllowed = 459,

                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    Code460 = 460,  // only aggregate operation allowed
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              CodeOnlyAggregateOperationAllowed = 460,

                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  Code461 = 461,    // unsupported transport
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            CodeUnsupportedTransport = 461,

                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       Code462 = 462,   // destination unreachable
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 CodeDestinationUnreachable = 462,

                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              Code480 = 480,  // unsupported client
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        CodeUnsupportedClient = 480,

                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                Code500 = 500,  // internal server error
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          CodeInternalServerError = 500,

                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    Code501 = 501,  // not implemented
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              CodeNotImplemented = 501,

                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   Code502 = 502,   // bad gateway
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             CodeBadGateway = 502,

                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              Code503 = 503,    // service unavailable
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        CodeServiceUnavailable = 503,

                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 Code504 = 504, // gateway timeout
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           CodeGatewayTimeout = 504,

                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                Code505 = 505,  // rtsp version not supported
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          CodeRTSPVersionNotSupported = 505,

                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        Code551 = 551,  // option not supported
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  CodeOptionNotSupported = 551
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           ;

typedef struct
{
    StrPtrLen     url;
    bool          urlIsSet;

    RtpSeqType    seq;
    bool          seqIsSet;

    RtpTimeStamp  rtptime;
    bool          rtptimeIsSet;

    uint32        ssrc;
    bool          ssrcIsSet;

} RTSPRTPInfo;

#endif // RTSP_PAR_COM_BASIC_DS_H_
