/* ------------------------------------------------------------------
 * Copyright (C) 1998-2009 PacketVideo
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
 * express or implied.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 * -------------------------------------------------------------------
 */
/*

 Filename: hcbtables_binary.cpp


------------------------------------------------------------------------------
 INPUT AND OUTPUT DEFINITIONS

 Inputs: None

 Local Stores/Buffers/Pointers Needed: None

 Global Stores/Buffers/Pointers Needed: None

 Outputs: None

 Pointers and Buffers Modified: None

 Local Stores Modified: None

 Global Stores Modified: None

------------------------------------------------------------------------------
 FUNCTION DESCRIPTION

 This file defines the 12 packed Huffman Tables and a structure that reference
 to these tables.

------------------------------------------------------------------------------
 REQUIREMENTS


------------------------------------------------------------------------------
 REFERENCES

 ISO/IEC 14496-3: 1999(E)
 Subpart 4          p78 (Table 4.6.1 and Table 4.6.2)
                    p77 (pseudo code)

------------------------------------------------------------------------------
 PSEUDO-CODE

------------------------------------------------------------------------------
*/
#include    "s_hcb.h"
#include    "hcbtables.h"

/* This file store packed Huffman tables for binary tree search */

/*
 * all tables are packed in the following way:
 * right pointer (7 bits) idx (9 bits)
 */


const Hcb hcbbook_binary[13] =
{

    { 0, -1,  -1, -1, -1 },   /* ZERO_HCB */
    { 1,  4,   3,  1,  1 },   /* codebook 1 */
    { 2,  4,   3,  1,  1 },   /* codebook 2 */
    { 3,  4,   3,  0,  0 },   /* codebook 3 */
    { 4,  4,   3,  0,  0 },   /* codebook 4 */
    { 5,  2,   9,  4,  1 },
    { 6,  2,   9,  4,  1 },
    { 7,  2,   8,  0,  0 },
    { 8,  2,   8,  0,  0 },
    { 9,  2,  13,  0,  0 },
    {10,  2,  13,  0,  0 },
    {11,  2,  17,  0,  0 },  /* codebook 11 ESC book */
    {12, -1,  -1, -1, -1 }   /* scalefactor codebook */


};


/* New look-up table for huffman decoding
   Created by ordering the codeword in the table according to their
   normalized shifted binary value, i.e., all the codewords are left
   shifted to meet the maximum codelength. Example, max codelength is
   10, the codeword with lenth 3 will left shift by 7.
   The binary values of after the shift are sorted.
   Then the sorted table is divided into several partition.
   At the VLC decoding period, input is read in at max codelenght.
   The partition is decided using if-else logic.
   Inside each partition, a look-up table is used to map the input value
   to a correct symbol. Table entries can appear to be repeated according
   to the humming distance between adjacent codewords.
*/

const Int32 huff_tab1[88] =
{
    0x430005,
    0xd0005,
    0x270005,
    0x310005,
    0x290005,
    0x250005,
    0x2b0005,
    0x1f0005,
    0x3a0007,
    0x160007,
    0x260007,
    0x2e0007,
    0x220007,
    0x2a0007,
    0x4c0007,
    0x240007,
    0x40007,
    0x1c0007,
    0x400007,
    0x300007,
    0x100007,
    0x2c0007,
    0x460007,
    0x200007,
    0x340007,
    0x320007,
    0xa0007,
    0x440007,
    0xc0007,
    0x420007,
    0xe0007,
    0x1e0007,
    0x490009,
    0x130009,
    0x3d0009,
    0x330009,
    0x2f0009,
    0x230009,
    0x210009,
    0x370009,
    0x410009,
    0x2d0009,
    0x190009,
    0xf0009,
    0x70009,
    0x1d0009,
    0x3b0009,
    0x390009,
    0x150009,
    0x10009,
    0x1b0009,
    0x350009,
    0x450009,
    0x4d0009,
    0x170009,
    0x4f0009,
    0x5000a,
    0x5000a,
    0x9000a,
    0x9000a,
    0x4b000a,
    0x4b000a,
    0x3f000a,
    0x3f000a,
    0xb000a,
    0xb000a,
    0x3000a,
    0x3000a,
    0x11000a,
    0x11000a,
    0x47000a,
    0x47000a,
    0x3c000b,
    0x14000b,
    0x18000b,
    0x38000b,
    0x50000b,
    0x8000b,
    0x48000b,
    0x6000b,
    0xb,
    0x4a000b,
    0x3e000b,
    0x1a000b,
    0x12000b,
    0x2000b,
    0x36000b,
    0x4e000b
};

const Int32 huff_tab2[90] =
{
    0x430004,
    0x430004,
    0x430004,
    0x430004,
    0xd0005,
    0xd0005,
    0x290005,
    0x290005,
    0x250005,
    0x250005,
    0x270005,
    0x270005,
    0x1f0005,
    0x1f0005,
    0x2b0005,
    0x2b0005,
    0x310005,
    0x310005,
    0x220006,
    0x160006,
    0x2e0006,
    0x2a0006,
    0x300006,
    0x260006,
    0xc0006,
    0x3a0006,
    0x400006,
    0x40006,
    0x240006,
    0x460006,
    0x440006,
    0x200006,
    0x100006,
    0x320006,
    0x1c0006,
    0xe0006,
    0x1e0006,
    0xa0006,
    0x4c0006,
    0x340006,
    0x2c0006,
    0x420006,
    0x2f0007,
    0x410007,
    0x130007,
    0x210007,
    0x3d0007,
    0x4b0007,
    0x470007,
    0x190007,
    0x1d0007,
    0x4f0007,
    0xf0007,
    0x10007,
    0xb0007,
    0x370007,
    0x490007,
    0x3b0008,
    0x150008,
    0x70008,
    0x110008,
    0x50008,
    0x30008,
    0x1b0008,
    0x450008,
    0x3f0008,
    0x2d0008,
    0x350008,
    0x170008,
    0x90008,
    0x330008,
    0x390008,
    0x230008,
    0x4d0008,
    0x3c0008,
    0x140008,
    0x380009,
    0x9,
    0x180009,
    0x1a0009,
    0x500009,
    0x60009,
    0x3e0009,
    0x120009,
    0x80009,
    0x480009,
    0x360009,
    0x20009,
    0x4a0009,
    0x4e0009
};

const Int32 huff_tab3[151] =
{
    0x1b0004,
    0x1b0004,
    0x1b0004,
    0x1b0004,
    0x10004,
    0x10004,
    0x10004,
    0x10004,
    0x90004,
    0x90004,
    0x90004,
    0x90004,
    0x30004,
    0x30004,
    0x30004,
    0x30004,
    0x240005,
    0x240005,
    0x40005,
    0x40005,
    0xc0006,
    0xa0006,
    0x1e0006,
    0xd0006,
    0x1c0006,
    0x270006,
    0x280007,
    0x280007,
    0x280007,
    0x280007,
    0x1f0007,
    0x1f0007,
    0x1f0007,
    0x1f0007,
    0x250007,
    0x250007,
    0x250007,
    0x250007,
    0x360008,
    0x360008,
    0x20008,
    0x20008,
    0x50008,
    0x50008,
    0x3f0008,
    0x3f0008,
    0x300008,
    0x300008,
    0x70009,
    0x100009,
    0x2d0009,
    0xe0009,
    0x420009,
    0x60009,
    0x150009,
    0xf0009,
    0x120009,
    0xb0009,
    0x390009,
    0x310009,
    0x160009,
    0x2a0009,
    0x2b0009,
    0x2e000a,
    0x21000a,
    0x22000a,
    0x13000a,
    0x43000a,
    0x29000a,
    0x40000a,
    0x20000a,
    0x8000a,
    0x11000a,
    0x4b000a,
    0x33000a,
    0x1d000a,
    0x37000a,
    0x19000a,
    0x48000b,
    0x48000b,
    0x34000b,
    0x34000b,
    0x26000b,
    0x26000b,
    0x3a000b,
    0x3a000b,
    0x2c000b,
    0x2c000b,
    0x4c000b,
    0x4c000b,
    0x18000b,
    0x18000b,
    0x17000b,
    0x17000b,
    0x23000c,
    0x49000c,
    0x45000c,
    0x4e000c,
    0x1a000c,
    0x4f000c,
    0x46000c,
    0x32000c,
    0x35000c,
    0x14000d,
    0x14000d,
    0x14000d,
    0x14000d,
    0x14000d,
    0x14000d,
    0x14000d,
    0x14000d,
    0x3c000d,
    0x3c000d,
    0x3c000d,
    0x3c000d,
    0x3c000d,
    0x3c000d,
    0x3c000d,
    0x3c000d,
    0x2f000d,
    0x2f000d,
    0x2f000d,
    0x2f000d,
    0x2f000d,
    0x2f000d,
    0x2f000d,
    0x2f000d,
    0x3d000e,
    0x3d000e,
    0x3d000e,
    0x3d000e,
    0x44000e,
    0x44000e,
    0x44000e,
    0x44000e,
    0x41000e,
    0x41000e,
    0x41000e,
    0x41000e,
    0x50000f,
    0x50000f,
    0x4d000f,
    0x4d000f,
    0x47000f,
    0x47000f,
    0x3b000f,
    0x3b000f,
    0x38000f,
    0x38000f,
    0x4a0010,
    0x3e0010
};

const Int32 huff_tab4[119] =
{
    0x280004,
    0x280004,
    0xd0004,
    0xd0004,
    0x250004,
    0x250004,
    0x270004,
    0x270004,
    0x1f0004,
    0x1f0004,
    0x1b0004,
    0x1b0004,
    0x240004,
    0x240004,
    0x4,
    0x4,
    0x40004,
    0x40004,
    0x1e0004,
    0x1e0004,
    0x1c0005,
    0xc0005,
    0x10005,
    0xa0005,
    0x30005,
    0x90005,
    0x430007,
    0x430007,
    0x2b0007,
    0x2b0007,
    0x310007,
    0x310007,
    0x290007,
    0x290007,
    0x420007,
    0x420007,
    0x400007,
    0x400007,
    0x300007,
    0x300007,
    0x3a0007,
    0x3a0007,
    0x100007,
    0x100007,
    0xe0008,
    0x2a0008,
    0x160008,
    0x200008,
    0x2e0008,
    0x260008,
    0x220008,
    0x3f0008,
    0x390008,
    0x2d0008,
    0x370008,
    0xb0008,
    0x150008,
    0x50008,
    0xf0008,
    0x130008,
    0x1d0008,
    0x70008,
    0x210008,
    0x360008,
    0x20008,
    0x120009,
    0x120009,
    0x60009,
    0x60009,
    0x340009,
    0x340009,
    0x4c0009,
    0x4c0009,
    0x460009,
    0x460009,
    0x2c0009,
    0x2c0009,
    0x320009,
    0x320009,
    0x440009,
    0x440009,
    0x33000a,
    0x4b000a,
    0x45000a,
    0x19000a,
    0x11000a,
    0x49000a,
    0x17000a,
    0x3d000a,
    0x23000a,
    0x4f000a,
    0x2f000a,
    0x3b000a,
    0x41000a,
    0x35000a,
    0x47000b,
    0x47000b,
    0x4d000b,
    0x4d000b,
    0x18000b,
    0x18000b,
    0x48000b,
    0x48000b,
    0x8000b,
    0x8000b,
    0x3c000b,
    0x3c000b,
    0x14000b,
    0x14000b,
    0x38000b,
    0x38000b,
    0x50000b,
    0x50000b,
    0x1a000b,
    0x1a000b,
    0x4e000b,
    0x4e000b,
    0x4a000c,
    0x3e000c
};

const Int32 huff_tab5[110] =
{
    0x1f0004,
    0x1f0004,
    0x310004,
    0x310004,
    0x290004,
    0x290004,
    0x270004,
    0x270004,
    0x300005,
    0x200005,
    0x1e0005,
    0x320005,
    0x160007,
    0x160007,
    0x2a0007,
    0x2a0007,
    0x3a0007,
    0x3a0007,
    0x260007,
    0x260007,
    0x150008,
    0x3b0008,
    0x1d0008,
    0x330008,
    0x170008,
    0x390008,
    0x210008,
    0x2f0008,
    0xd0008,
    0x430008,
    0x250008,
    0x2b0008,
    0xc0009,
    0xc0009,
    0x340009,
    0x340009,
    0x440009,
    0x440009,
    0x1c0009,
    0x1c0009,
    0xe0009,
    0xe0009,
    0x420009,
    0x420009,
    0x2e0009,
    0x2e0009,
    0x220009,
    0x220009,
    0x180009,
    0x180009,
    0x3c0009,
    0x3c0009,
    0x140009,
    0x140009,
    0x380009,
    0x380009,
    0xb000a,
    0x41000a,
    0x19000a,
    0x37000a,
    0x45000a,
    0x3d000a,
    0xf000a,
    0x13000a,
    0x24000a,
    0x4000a,
    0x4d000a,
    0x4c000a,
    0x3000b,
    0x2c000b,
    0x4b000b,
    0x1b000b,
    0x35000b,
    0x23000b,
    0x5000b,
    0x2d000b,
    0x40000b,
    0xa000b,
    0x10000b,
    0x1a000b,
    0x2000b,
    0x4e000b,
    0x36000b,
    0x3e000b,
    0x46000b,
    0x6000b,
    0x12000c,
    0x12000c,
    0x4a000c,
    0x4a000c,
    0x3f000c,
    0x3f000c,
    0x1000c,
    0x1000c,
    0x7000c,
    0x7000c,
    0x47000c,
    0x47000c,
    0x11000c,
    0x11000c,
    0x4f000c,
    0x4f000c,
    0x49000c,
    0x49000c,
    0x9000c,
    0x9000c,
    0x48000d,
    0x8000d,
    0x50000d,
    0xd
};
const Int32 huff_tab6[113] =
{
    0x280004,
    0x310004,
    0x270004,
    0x290004,
    0x1f0004,
    0x320004,
    0x200004,
    0x300004,
    0x1e0004,
    0x390006,
    0x390006,
    0x3b0006,
    0x3b0006,
    0x170006,
    0x170006,
    0x150006,
    0x150006,
    0x160006,
    0x160006,
    0x210006,
    0x210006,
    0x3a0006,
    0x3a0006,
    0x2f0006,
    0x2f0006,
    0x330006,
    0x330006,
    0x260006,
    0x260006,
    0x1d0006,
    0x1d0006,
    0x2a0006,
    0x2a0006,
    0x380006,
    0x380006,
    0x180006,
    0x180006,
    0x140006,
    0x140006,
    0x3c0006,
    0x3c0006,
    0xe0007,
    0x440007,
    0x420007,
    0x220007,
    0xc0007,
    0x340007,
    0x2e0007,
    0x1c0007,
    0x430007,
    0xd0007,
    0x250007,
    0x2b0007,
    0x450007,
    0xb0008,
    0xb0008,
    0x190008,
    0x190008,
    0x3d0008,
    0x3d0008,
    0x410008,
    0x410008,
    0x370008,
    0x370008,
    0x130008,
    0x130008,
    0xf0008,
    0xf0008,
    0x460008,
    0x460008,
    0x400009,
    0xa0009,
    0x100009,
    0x2d0009,
    0x1b0009,
    0x4d0009,
    0x50009,
    0x30009,
    0x350009,
    0x4b0009,
    0x230009,
    0x240009,
    0x60009,
    0x20009,
    0x3e0009,
    0x120009,
    0x40009,
    0x4e0009,
    0x4a0009,
    0x1a0009,
    0x4c0009,
    0x360009,
    0x2c0009,
    0x9000a,
    0x9000a,
    0x11000a,
    0x11000a,
    0x3f000a,
    0x3f000a,
    0x49000a,
    0x49000a,
    0x47000a,
    0x47000a,
    0x4f000a,
    0x4f000a,
    0x7000a,
    0x7000a,
    0x1000a,
    0x1000a,
    0x50000b,
    0x8000b,
    0xb,
    0x48000b
};

const Int32 huff_tab7[107] =
{
    0x80003,
    0x80003,
    0x80003,
    0x80003,
    0x80003,
    0x80003,
    0x80003,
    0x80003,
    0x10003,
    0x10003,
    0x10003,
    0x10003,
    0x10003,
    0x10003,
    0x10003,
    0x10003,
    0x90004,
    0x90004,
    0x90004,
    0x90004,
    0x110006,
    0xa0006,
    0x100006,
    0x20006,
    0x190007,
    0x190007,
    0xb0007,
    0xb0007,
    0x120007,
    0x120007,
    0x180007,
    0x180007,
    0x30007,
    0x30007,
    0x130008,
    0x1a0008,
    0xc0008,
    0x210008,
    0xd0008,
    0x290008,
    0x1b0008,
    0x140008,
    0x40008,
    0x200008,
    0x220009,
    0x220009,
    0x150009,
    0x150009,
    0x2a0009,
    0x2a0009,
    0x50009,
    0x50009,
    0x310009,
    0x310009,
    0x280009,
    0x280009,
    0xe0009,
    0xe0009,
    0x230009,
    0x230009,
    0x1d0009,
    0x1d0009,
    0x1c0009,
    0x1c0009,
    0x2b0009,
    0x2b0009,
    0x160009,
    0x160009,
    0x320009,
    0x320009,
    0xf0009,
    0xf0009,
    0x1e000a,
    0x6000a,
    0x30000a,
    0x24000a,
    0x39000a,
    0x25000a,
    0x3a000a,
    0x2c000a,
    0x33000a,
    0x17000a,
    0x3b000a,
    0x34000a,
    0x2d000a,
    0x26000a,
    0x1f000a,
    0x38000b,
    0x38000b,
    0x7000b,
    0x7000b,
    0x35000b,
    0x35000b,
    0x2e000b,
    0x2e000b,
    0x3c000b,
    0x3c000b,
    0x27000b,
    0x27000b,
    0x2f000b,
    0x2f000b,
    0x3d000b,
    0x3d000b,
    0x3e000c,
    0x36000c,
    0x37000c,
    0x3f000c
};
const Int32 huff_tab8[90] =
{
    0x90003,
    0x90003,
    0x90003,
    0x90003,
    0x110004,
    0x110004,
    0x80004,
    0x80004,
    0xa0004,
    0xa0004,
    0x10004,
    0x10004,
    0x120004,
    0x120004,
    0x5,
    0x100005,
    0x20005,
    0x190005,
    0xb0005,
    0x1a0005,
    0x130005,
    0x1b0006,
    0x1b0006,
    0x210006,
    0x210006,
    0xc0006,
    0xc0006,
    0x220006,
    0x220006,
    0x140006,
    0x140006,
    0x180006,
    0x180006,
    0x30006,
    0x30006,
    0x230006,
    0x230006,
    0x1c0006,
    0x1c0006,
    0x2a0006,
    0x2a0006,
    0x290007,
    0x150007,
    0xd0007,
    0x2b0007,
    0x1d0007,
    0x240007,
    0x2c0007,
    0x40007,
    0x250007,
    0x200007,
    0x160007,
    0x320007,
    0x310007,
    0xe0007,
    0x1e0008,
    0x330008,
    0x2d0008,
    0x280008,
    0x340008,
    0x50008,
    0x260008,
    0x390008,
    0x3a0008,
    0x170008,
    0x350008,
    0x3b0008,
    0xf0008,
    0x2e0008,
    0x1f0008,
    0x360009,
    0x360009,
    0x3c0009,
    0x3c0009,
    0x300009,
    0x300009,
    0x270009,
    0x270009,
    0x60009,
    0x60009,
    0x3d0009,
    0x3d0009,
    0x3e0009,
    0x3e0009,
    0x370009,
    0x370009,
    0x2f000a,
    0x38000a,
    0x7000a,
    0x3f000a
};
const Int32 huff_tab9[204] =
{
    0x1,
    0x1,
    0x1,
    0x1,
    0x1,
    0x1,
    0x1,
    0x1,
    0xd0003,
    0xd0003,
    0x10003,
    0x10003,
    0xe0004,
    0x1b0006,
    0x1b0006,
    0xf0006,
    0xf0006,
    0x1a0006,
    0x1a0006,
    0x20006,
    0x20006,
    0x280007,
    0x1c0007,
    0x100007,
    0x270008,
    0x270008,
    0x30008,
    0x30008,
    0x1d0008,
    0x1d0008,
    0x290008,
    0x290008,
    0x110008,
    0x110008,
    0x350008,
    0x350008,
    0x1e0008,
    0x1e0008,
    0x120008,
    0x120008,
    0x360009,
    0x2a0009,
    0x40009,
    0x340009,
    0x420009,
    0x1f0009,
    0x130009,
    0x2b0009,
    0x430009,
    0x4f0009,
    0x370009,
    0x5000a,
    0x20000a,
    0x41000a,
    0x14000a,
    0x2c000a,
    0x15000a,
    0x69000a,
    0x38000a,
    0x44000a,
    0x50000a,
    0x5c000a,
    0x6000a,
    0x6a000a,
    0x22000a,
    0x2d000a,
    0x21000a,
    0x39000a,
    0x76000a,
    0x16000a,
    0x5d000a,
    0x4e000b,
    0x45000b,
    0x51000b,
    0x6b000b,
    0x7000b,
    0x77000b,
    0x2f000b,
    0x3a000b,
    0x2e000b,
    0x8000b,
    0x83000b,
    0x52000b,
    0x23000b,
    0x46000b,
    0x68000b,
    0x5b000b,
    0x5e000b,
    0x84000b,
    0x78000b,
    0x6c000b,
    0x17000b,
    0x5f000b,
    0x53000b,
    0x47000b,
    0x3c000b,
    0x3b000b,
    0x30000b,
    0x90000b,
    0x49000b,
    0x75000b,
    0x6d000b,
    0x85000c,
    0x24000c,
    0x9000c,
    0x91000c,
    0x79000c,
    0x54000c,
    0x9d000c,
    0x3d000c,
    0x6e000c,
    0x18000c,
    0x7a000c,
    0x86000c,
    0x48000c,
    0x60000c,
    0x25000c,
    0x19000c,
    0x9e000c,
    0x92000c,
    0x31000c,
    0x4a000c,
    0x55000c,
    0x6f000c,
    0x93000c,
    0xa000c,
    0x61000c,
    0x9f000c,
    0x82000c,
    0x87000c,
    0x3e000c,
    0x56000c,
    0x26000c,
    0x7b000c,
    0x7c000c,
    0x3f000c,
    0x8f000c,
    0x57000c,
    0x32000c,
    0x4b000c,
    0x70000d,
    0x63000d,
    0xa1000d,
    0x33000d,
    0x94000d,
    0x62000d,
    0xa0000d,
    0x95000d,
    0x88000d,
    0x40000d,
    0x64000d,
    0x4c000d,
    0xb000d,
    0xa2000d,
    0x58000d,
    0x9c000d,
    0x89000d,
    0x4d000d,
    0x65000d,
    0x7d000d,
    0xc000d,
    0x96000d,
    0x71000d,
    0x7e000d,
    0x8a000d,
    0x66000d,
    0xa3000d,
    0x59000d,
    0x73000d,
    0x97000d,
    0x67000d,
    0x5a000d,
    0x72000e,
    0x72000e,
    0x8b000e,
    0x8b000e,
    0x74000e,
    0x74000e,
    0x7f000e,
    0x7f000e,
    0x80000e,
    0x80000e,
    0x81000e,
    0x81000e,
    0x8d000e,
    0x8d000e,
    0xa5000e,
    0xa5000e,
    0x8c000e,
    0x8c000e,
    0x98000e,
    0x98000e,
    0xa4000e,
    0xa4000e,
    0x99000e,
    0x99000e,
    0xa6000e,
    0xa6000e,
    0xa7000e,
    0xa7000e,
    0x8e000f,
    0x9a000f,
    0x9b000f,
    0xa8000f
};
const Int32 huff_tab10[186] =
{
    0xe0004,
    0xe0004,
    0xe0004,
    0xe0004,
    0xf0004,
    0xf0004,
    0xf0004,
    0xf0004,
    0x1b0004,
    0x1b0004,
    0x1b0004,
    0x1b0004,
    0x1c0005,
    0x1c0005,
    0xd0005,
    0xd0005,
    0x10005,
    0x10005,
    0x100005,
    0x100005,
    0x290005,
    0x290005,
    0x280005,
    0x280005,
    0x1d0005,
    0x1d0005,
    0x2a0005,
    0x2a0005,
    0x1a0006,
    0x20006,
    0x1e0006,
    0x360006,
    0x110006,
    0x350006,
    0x6,
    0x370006,
    0x2b0006,
    0x270006,
    0x30006,
    0x380006,
    0x1f0006,
    0x430006,
    0x120007,
    0x420007,
    0x440007,
    0x2c0007,
    0x450007,
    0x390007,
    0x500007,
    0x200007,
    0x510007,
    0x340007,
    0x4f0007,
    0x40007,
    0x130007,
    0x2d0007,
    0x460007,
    0x520007,
    0x3a0007,
    0x530008,
    0x5d0008,
    0x2e0008,
    0x210008,
    0x470008,
    0x6a0008,
    0x5e0008,
    0x410008,
    0x5c0008,
    0x50008,
    0x690008,
    0x140008,
    0x6b0008,
    0x5f0008,
    0x3b0008,
    0x220008,
    0x540008,
    0x600008,
    0x150008,
    0x2f0008,
    0x6c0008,
    0x3c0008,
    0x480008,
    0x6d0008,
    0x490008,
    0x610009,
    0x550009,
    0x770009,
    0x4e0009,
    0x560009,
    0x780009,
    0x300009,
    0x760009,
    0x230009,
    0x60009,
    0x6e0009,
    0x790009,
    0x3d0009,
    0x840009,
    0x160009,
    0x620009,
    0x6f0009,
    0x7a0009,
    0x630009,
    0x850009,
    0x4a0009,
    0x860009,
    0x240009,
    0x830009,
    0x310009,
    0x7b0009,
    0x570009,
    0x680009,
    0x3e0009,
    0x5b0009,
    0x910009,
    0x64000a,
    0x92000a,
    0x88000a,
    0x17000a,
    0x90000a,
    0x7c000a,
    0x7000a,
    0x70000a,
    0x87000a,
    0x32000a,
    0x4b000a,
    0x71000a,
    0x94000a,
    0x8000a,
    0x93000a,
    0x25000a,
    0x65000a,
    0x58000a,
    0x89000a,
    0x3f000a,
    0x18000a,
    0x9e000a,
    0x7d000a,
    0x9f000a,
    0x95000a,
    0x4c000a,
    0xa0000a,
    0x96000a,
    0xa1000a,
    0x33000a,
    0x59000a,
    0x75000a,
    0x8a000a,
    0x82000a,
    0x9d000a,
    0x9000a,
    0x40000a,
    0x7e000a,
    0xa2000a,
    0x26000a,
    0x72000a,
    0x7f000b,
    0x19000b,
    0x97000b,
    0xa3000b,
    0x66000b,
    0x4d000b,
    0x5a000b,
    0x8b000b,
    0x73000b,
    0xa4000b,
    0xa000b,
    0x67000b,
    0x8f000b,
    0x8c000b,
    0x98000b,
    0x99000b,
    0xb000b,
    0x9a000b,
    0x80000b,
    0x8d000b,
    0x9c000b,
    0x74000b,
    0xa5000c,
    0x8e000c,
    0x81000c,
    0x9b000c,
    0xa7000c,
    0xc000c,
    0xa6000c,
    0xa8000c
};
const Int32 huff_tab11[301] =
{
    0x4,
    0x4,
    0x4,
    0x4,
    0x120004,
    0x120004,
    0x120004,
    0x120004,
    0x1200005,
    0x1200005,
    0x110005,
    0x110005,
    0x10005,
    0x10005,
    0x230005,
    0x230005,
    0x130005,
    0x130005,
    0x240005,
    0x240005,
    0x140006,
    0x340006,
    0x350006,
    0x220006,
    0x250006,
    0x20006,
    0x360006,
    0x450007,
    0x150007,
    0x460007,
    0x260007,
    0x470007,
    0x370007,
    0x330007,
    0x30007,
    0x560007,
    0x570007,
    0x270007,
    0x480007,
    0x160007,
    0x580007,
    0x380007,
    0x590007,
    0x490008,
    0x680008,
    0x280008,
    0x670008,
    0x690008,
    0x390008,
    0x170008,
    0x540008,
    0x430008,
    0x1150008,
    0x1130008,
    0x1140008,
    0x6a0008,
    0x1160008,
    0x440008,
    0x4a0008,
    0x40008,
    0x320008,
    0x5a0008,
    0x650008,
    0x1170008,
    0x1120008,
    0x1180008,
    0x290008,
    0x790008,
    0x3a0008,
    0x6b0008,
    0x5b0008,
    0x760008,
    0x11a0008,
    0x7a0008,
    0x780008,
    0x1190008,
    0x870008,
    0x210008,
    0x180008,
    0x4b0008,
    0x11b0008,
    0x7b0008,
    0x11c0008,
    0x980008,
    0x1110008,
    0x6c0008,
    0xa90008,
    0x2a0008,
    0x5c0008,
    0xba0008,
    0x11d0008,
    0x8b0008,
    0x8a0008,
    0x3b0008,
    0x550008,
    0x11e0008,
    0xcb0008,
    0x7c0008,
    0x4c0008,
    0x6d0008,
    0x7d0008,
    0x50008,
    0x8c0009,
    0x11f0009,
    0xdc0009,
    0x190009,
    0x890009,
    0xfe0009,
    0x5d0009,
    0xed0009,
    0x3c0009,
    0x8d0009,
    0x7e0009,
    0x2b0009,
    0x8e0009,
    0x9b0009,
    0x9c0009,
    0x10f0009,
    0x4d0009,
    0x6e0009,
    0x660009,
    0x9d0009,
    0x5e0009,
    0x8f0009,
    0x7f0009,
    0x1a0009,
    0xad0009,
    0x60009,
    0xac0009,
    0x9a0009,
    0x9e0009,
    0x4e0009,
    0x2c0009,
    0x9f0009,
    0x3d0009,
    0x6f0009,
    0xae0009,
    0x900009,
    0xaf0009,
    0xa00009,
    0xbe0009,
    0x1b0009,
    0x770009,
    0xb00009,
    0x800009,
    0x3e0009,
    0x5f0009,
    0xab0009,
    0x4f0009,
    0xbd0009,
    0xdf0009,
    0x700009,
    0xe00009,
    0x2d0009,
    0x1100009,
    0x600009,
    0xc00009,
    0xbf000a,
    0xa1000a,
    0x81000a,
    0x91000a,
    0x10000a,
    0x51000a,
    0x7000a,
    0x40000a,
    0xc1000a,
    0xde000a,
    0xe1000a,
    0xcf000a,
    0x2f000a,
    0xe2000a,
    0x92000a,
    0x71000a,
    0xb2000a,
    0xb1000a,
    0xf0000a,
    0xd0000a,
    0x1c000a,
    0x50000a,
    0xbc000a,
    0x3f000a,
    0x1e000a,
    0xce000a,
    0x82000a,
    0x41000a,
    0x61000a,
    0x62000a,
    0xf2000a,
    0x52000a,
    0xc2000a,
    0xf1000a,
    0xd1000a,
    0xe3000a,
    0xd2000a,
    0x88000a,
    0xc3000a,
    0x2e000a,
    0xa2000a,
    0xf3000a,
    0x73000a,
    0xb4000a,
    0x101000a,
    0x93000a,
    0xa3000a,
    0xf4000a,
    0xb3000a,
    0x63000a,
    0xc4000a,
    0xef000a,
    0x30000a,
    0x72000a,
    0x1d000a,
    0xe5000a,
    0x8000a,
    0xe4000a,
    0x83000a,
    0xd3000a,
    0x84000a,
    0x102000a,
    0xcd000a,
    0x74000a,
    0x31000a,
    0x104000a,
    0x103000a,
    0x1f000a,
    0xa4000a,
    0x53000a,
    0xf5000a,
    0x95000a,
    0xe6000a,
    0x94000a,
    0x64000a,
    0x42000a,
    0xb5000a,
    0xc5000a,
    0xd4000a,
    0x105000a,
    0x106000a,
    0x96000a,
    0x100000a,
    0x85000a,
    0x99000a,
    0x9000a,
    0xa6000a,
    0xa5000a,
    0xd5000a,
    0xf6000a,
    0xb7000a,
    0xf7000a,
    0xd6000a,
    0x75000a,
    0x86000a,
    0xa7000b,
    0x107000b,
    0xc6000b,
    0xc9000b,
    0x20000b,
    0xb6000b,
    0xb8000b,
    0xe8000b,
    0xe7000b,
    0xc8000b,
    0xc7000b,
    0x97000b,
    0xf9000b,
    0xe9000b,
    0xd9000b,
    0x108000b,
    0xf8000b,
    0xaa000b,
    0xd7000b,
    0xa8000b,
    0xa000b,
    0xd8000b,
    0xbb000b,
    0xda000b,
    0xb9000b,
    0xea000b,
    0xd000b,
    0xfa000b,
    0x109000b,
    0x10a000b,
    0xca000b,
    0xfb000b,
    0xdd000b,
    0xb000b,
    0xeb000b,
    0x10b000b,
    0x10c000b,
    0xdb000b,
    0xee000b,
    0xfc000b,
    0xec000b,
    0xcc000b,
    0xfd000b,
    0xe000c,
    0xc000c,
    0x10d000c,
    0xff000c,
    0xf000c,
    0x10e000c
};

const UInt32 huff_tab_scl[188] =
{
    0x3b0003,
    0x3b0003,
    0x3b0003,
    0x3b0003,
    0x3b0003,
    0x3b0003,
    0x3b0003,
    0x3b0003,
    0x3d0004,
    0x3d0004,
    0x3d0004,
    0x3d0004,
    0x3a0004,
    0x3a0004,
    0x3a0004,
    0x3a0004,
    0x3e0004,
    0x3e0004,
    0x3e0004,
    0x3e0004,
    0x390005,
    0x390005,
    0x3f0005,
    0x3f0005,
    0x380006,
    0x400006,
    0x370006,
    0x410006,
    0x420007,
    0x420007,
    0x420007,
    0x420007,
    0x360007,
    0x360007,
    0x360007,
    0x360007,
    0x430007,
    0x430007,
    0x430007,
    0x430007,
    0x350008,
    0x350008,
    0x440008,
    0x440008,
    0x340008,
    0x340008,
    0x450008,
    0x450008,
    0x330008,
    0x330008,
    0x460009,
    0x320009,
    0x310009,
    0x470009,
    0x48000a,
    0x48000a,
    0x48000a,
    0x48000a,
    0x30000a,
    0x30000a,
    0x30000a,
    0x30000a,
    0x49000a,
    0x49000a,
    0x49000a,
    0x49000a,
    0x2f000a,
    0x2f000a,
    0x2f000a,
    0x2f000a,
    0x4a000a,
    0x4a000a,
    0x4a000a,
    0x4a000a,
    0x2e000a,
    0x2e000a,
    0x2e000a,
    0x2e000a,
    0x4c000b,
    0x4c000b,
    0x4b000b,
    0x4b000b,
    0x4d000b,
    0x4d000b,
    0x4e000b,
    0x4e000b,
    0x2d000b,
    0x2d000b,
    0x2b000b,
    0x2b000b,
    0x2c000c,
    0x4f000c,
    0x2a000c,
    0x29000c,
    0x50000c,
    0x28000c,
    0x51000d,
    0x51000d,
    0x27000d,
    0x27000d,
    0x52000d,
    0x52000d,
    0x26000d,
    0x26000d,
    0x53000d,
    0x53000d,
    0x25000e,
    0x23000e,
    0x55000e,
    0x21000e,
    0x24000e,
    0x22000e,
    0x54000e,
    0x20000e,
    0x57000f,
    0x57000f,
    0x59000f,
    0x59000f,
    0x1e000f,
    0x1e000f,
    0x1f000f,
    0x1f000f,
    0x560010,
    0x1d0010,
    0x1a0010,
    0x1b0010,
    0x1c0010,
    0x180010,
    0x580010,
    0x190011,
    0x190011,
    0x160011,
    0x160011,
    0x170011,
    0x170011,
    0x5a0012,
    0x150012,
    0x130012,
    0x30012,
    0x10012,
    0x20012,
    0x12,
    0x620013,
    0x630013,
    0x640013,
    0x650013,
    0x660013,
    0x750013,
    0x610013,
    0x5b0013,
    0x5c0013,
    0x5d0013,
    0x5e0013,
    0x5f0013,
    0x600013,
    0x680013,
    0x6f0013,
    0x700013,
    0x710013,
    0x720013,
    0x730013,
    0x740013,
    0x6e0013,
    0x690013,
    0x6a0013,
    0x6b0013,
    0x6c0013,
    0x6d0013,
    0x760013,
    0x60013,
    0x80013,
    0x90013,
    0xa0013,
    0x50013,
    0x670013,
    0x780013,
    0x770013,
    0x40013,
    0x70013,
    0xf0013,
    0x100013,
    0x120013,
    0x140013,
    0x110013,
    0xb0013,
    0xc0013,
    0xe0013,
    0xd0013
};
