/* ------------------------------------------------------------------
 * Copyright (C) 1998-2009 PacketVideo
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
 * express or implied.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 * -------------------------------------------------------------------
 */
#include "oscl_mem.h"
#include "golay.h"
#include "level2.h"
#include "h223.h"
//#define CORRUPT_MPL 10
//#define CORRUPT_MT 1
//#define CORRUPT_MUXCODE 4
//#define LOG_FLAG_EMULATIONS 1
#define SYNC_LOSS_INDICATE_THRESHOLD 160

/* WWUXC: enc table is changed */
static const int enc_tab[] =
{
    0, 7285, 9375, 14570, 19787, 20798, 27092, 30113, 34531, 39574, 41596, 48649, 52136, 55261, 61239, 62274,
    68019, 71110, 77100, 78169, 83192, 88205, 90215, 97298, 102224, 103205, 109519, 112570, 115227, 122478, 124548, 129777,
    133990, 136979, 143353, 144268, 149037, 154200, 156338, 163527, 167301, 168432, 174362, 177519, 180430, 187579, 189521, 194596,
    197333, 204448, 206410, 211519, 216990, 218091, 224001, 227188, 230454, 235587, 237737, 244956, 248189, 251144, 257506, 258455,
    265932, 266937, 272979, 276006, 279431, 286706, 288536, 293741, 297007, 300122, 306352, 307397, 312676, 317713, 319995, 327054,
    329599, 334602, 336864, 343957, 346676, 349761, 356011, 357086, 360860, 368105, 369923, 375158, 380119, 381090, 387144, 390205,
    394666, 399839, 401717, 408896, 411873, 414868, 420990, 421899, 426825, 433980, 436182, 441251, 445954, 447095, 453277, 456424,
    461849, 462956, 469126, 472307, 475474, 482599, 484813, 489912, 494330, 497295, 503397, 504336, 509873, 515012, 516910, 524123,
    524781, 531864, 533874, 538887, 543910, 544979, 550969, 554060, 558862, 564091, 566161, 573412, 576069, 579120, 585434, 586415,
    591966, 594987, 601281, 602292, 607509, 612704, 614794, 622079, 626365, 627400, 633378, 636503, 639990, 647043, 649065, 654108,
    658059, 661246, 667156, 668257, 673728, 678837, 680799, 687914, 691304, 692253, 698615, 701570, 704803, 712022, 714172, 719305,
    721720, 728909, 731047, 736210, 740979, 741894, 748268, 751257, 755163, 760238, 762180, 769329, 772240, 775397, 781327, 782458,
    790305, 791380, 797630, 800715, 803434, 810527, 812789, 817792, 821698, 824759, 830813, 831784, 836745, 841980, 843798, 851043,
    853650, 858855, 860685, 867960, 871385, 874412, 880454, 881459, 884849, 891908, 894190, 899227, 904506, 905551, 911781, 914896,
    918599, 923698, 925912, 933037, 936204, 939385, 945555, 946662, 950948, 958161, 960059, 965198, 970735, 971674, 977776, 980741,
    986612, 987521, 993643, 996638, 999615, 1006794, 1008672, 1013845, 1018647, 1021794, 1027976, 1029117, 1033820, 1038889, 1041091, 1048246,
    1049562, 1056687, 1058629, 1063728, 1068689, 1069796, 1075726, 1078907, 1082681, 1087820, 1089958, 1097171, 1099890, 1102855, 1109229, 1110168,
    1116777, 1119772, 1126134, 1127043, 1132322, 1137495, 1139645, 1146824, 1150090, 1151231, 1157141, 1160288, 1163713, 1170868, 1172830, 1177899,
    1181884, 1184969, 1190947, 1192022, 1197559, 1202562, 1204584, 1211677, 1216095, 1217066, 1223360, 1226421, 1229588, 1236833, 1238923, 1244158,
    1245455, 1252730, 1254800, 1260005, 1264708, 1265713, 1272027, 1275054, 1279980, 1285017, 1287027, 1294086, 1297063, 1300178, 1306168, 1307213,
    1314070, 1315171, 1321353, 1324540, 1327197, 1334312, 1336514, 1341623, 1346549, 1349504, 1355626, 1356575, 1361598, 1366731, 1368609, 1375828,
    1377445, 1382608, 1384506, 1391695, 1395182, 1398171, 1404273, 1405188, 1409606, 1416755, 1418969, 1424044, 1429261, 1430392, 1436562, 1439719,
    1443440, 1448453, 1450735, 1457818, 1461051, 1464142, 1470372, 1471441, 1474707, 1481958, 1483788, 1489017, 1494488, 1495469, 1501511, 1504562,
    1511363, 1512374, 1518428, 1521449, 1524360, 1531645, 1533463, 1538658, 1542432, 1545557, 1551807, 1552842, 1557611, 1562654, 1564916, 1571969,
    1573431, 1580610, 1582760, 1587933, 1593212, 1594121, 1600483, 1603478, 1606868, 1611937, 1613899, 1621054, 1624479, 1627626, 1633536, 1634677,
    1641348, 1644529, 1650459, 1651566, 1656527, 1661626, 1663568, 1670693, 1674599, 1675538, 1681912, 1684877, 1687596, 1694809, 1696947, 1702086,
    1706321, 1709348, 1715662, 1716667, 1721370, 1726575, 1728645, 1735920, 1740722, 1741767, 1747757, 1750872, 1753849, 1760908, 1762918, 1767955,
    1769698, 1776791, 1778813, 1783816, 1789353, 1790428, 1796406, 1799491, 1803777, 1809012, 1811102, 1818347, 1821514, 1824575, 1830869, 1831840,
    1838331, 1839246, 1845348, 1848337, 1851824, 1859013, 1860911, 1866074, 1870360, 1873517, 1879687, 1880818, 1886035, 1891110, 1893324, 1900473,
    1901896, 1907005, 1909207, 1916322, 1918979, 1922166, 1928348, 1929449, 1934251, 1941470, 1943348, 1948481, 1953504, 1954453, 1960575, 1963530,
    1968029, 1973224, 1975042, 1982327, 1985238, 1988259, 1994313, 1995324, 1999230, 2006283, 2008545, 2013588, 2018357, 2019392, 2025642, 2028767,
    2035246, 2036315, 2042545, 2045636, 2048869, 2055952, 2058234, 2063247, 2066637, 2069688, 2075730, 2076711, 2082182, 2087411, 2089241, 2096492,
    2099124, 2104257, 2106155, 2113374, 2116351, 2119306, 2125408, 2126357, 2130263, 2137378, 2139592, 2144701, 2149404, 2150505, 2156675, 2159862,
    2166279, 2167410, 2173592, 2176749, 2179916, 2187065, 2189267, 2194342, 2197732, 2200721, 2206843, 2207758, 2213295, 2218458, 2220336, 2227525,
    2231506, 2232487, 2238541, 2241592, 2245017, 2252268, 2254086, 2259315, 2263601, 2266692, 2272942, 2274011, 2279290, 2284303, 2286565, 2293648,
    2295137, 2300180, 2302462, 2309515, 2312234, 2315359, 2321589, 2322624, 2327426, 2334711, 2336541, 2341736, 2346697, 2347708, 2353750, 2356771,
    2361720, 2364685, 2371047, 2371986, 2376755, 2381894, 2384044, 2391257, 2396059, 2397166, 2403076, 2406257, 2409168, 2416293, 2418255, 2423354,
    2425035, 2432190, 2434132, 2439201, 2444672, 2445813, 2451743, 2454890, 2459176, 2464349, 2466487, 2473666, 2476899, 2479894, 2486268, 2487177,
    2490910, 2498155, 2500225, 2505460, 2510677, 2511648, 2517962, 2521023, 2524413, 2529416, 2531426, 2538519, 2542006, 2545091, 2551081, 2552156,
    2558893, 2562008, 2567986, 2569031, 2574054, 2579091, 2581113, 2588172, 2592078, 2593083, 2599377, 2602404, 2605061, 2612336, 2614426, 2619631,
    2623065, 2628140, 2630342, 2637491, 2640658, 2643815, 2649997, 2651128, 2654394, 2661583, 2663461, 2668624, 2674161, 2675076, 2681198, 2684187,
    2691050, 2691999, 2698101, 2701056, 2704033, 2711252, 2713150, 2718283, 2722057, 2725244, 2731414, 2732515, 2737218, 2742327, 2744541, 2751656,
    2755903, 2756938, 2763168, 2766293, 2769012, 2776065, 2778347, 2783390, 2788316, 2791337, 2797379, 2798390, 2803351, 2808546, 2810376, 2817661,
    2819212, 2824441, 2826259, 2833510, 2836935, 2839986, 2846040, 2847021, 2851439, 2858522, 2860784, 2865797, 2871076, 2872145, 2878395, 2881486,
    2885781, 2888928, 2894858, 2895999, 2901470, 2906539, 2908481, 2915636, 2920054, 2920963, 2927337, 2930332, 2933565, 2940744, 2942882, 2948055,
    2949414, 2956627, 2958777, 2963916, 2968685, 2969624, 2975986, 2978951, 2983877, 2988976, 2990938, 2998063, 3000974, 3004155, 3010065, 3011172,
    3015667, 3022726, 3024748, 3029785, 3034808, 3035853, 3041831, 3044946, 3048720, 3053925, 3056015, 3063290, 3065947, 3068974, 3075268, 3076273,
    3082816, 3085877, 3092191, 3093162, 3098379, 3103614, 3105684, 3112929, 3116195, 3117270, 3123260, 3126345, 3129832, 3136925, 3138935, 3143938,
    3146862, 3151899, 3154161, 3161220, 3164453, 3167568, 3173818, 3174863, 3179149, 3186424, 3188242, 3193447, 3198918, 3199923, 3205977, 3209004,
    3214813, 3215784, 3221826, 3224887, 3227798, 3235043, 3236873, 3242108, 3246910, 3249995, 3256225, 3257300, 3262069, 3267072, 3269354, 3276447,
    3280648, 3281789, 3287959, 3291106, 3293763, 3300918, 3303132, 3308201, 3312107, 3315102, 3321204, 3322113, 3327136, 3332309, 3334207, 3341386,
    3344059, 3349198, 3351076, 3358289, 3361776, 3364741, 3370863, 3371802, 3375192, 3382317, 3384519, 3389618, 3394835, 3395942, 3402124, 3405305,
    3410594, 3413719, 3419709, 3420744, 3426281, 3431324, 3433334, 3440387, 3443777, 3444788, 3451102, 3454123, 3457290, 3464575, 3466645, 3471840,
    3474193, 3481444, 3483534, 3488763, 3493466, 3494447, 3500741, 3503792, 3507698, 3512711, 3514733, 3521816, 3524793, 3527884, 3533862, 3534931,
    3539396, 3546545, 3548507, 3553582, 3558543, 3559674, 3565584, 3568741, 3573543, 3578706, 3580856, 3588045, 3590764, 3593753, 3600115, 3601030,
    3606647, 3609602, 3615976, 3616925, 3622204, 3627337, 3629475, 3636694, 3640980, 3642081, 3648011, 3651198, 3654623, 3661738, 3663680, 3668789,
    3671427, 3676662, 3678492, 3685737, 3688648, 3691709, 3697751, 3698722, 3703648, 3710741, 3713023, 3718026, 3722795, 3723870, 3730100, 3733185,
    3738672, 3739717, 3745967, 3749082, 3752315, 3759374, 3761636, 3766673, 3771091, 3774118, 3780172, 3781177, 3786648, 3791853, 3793671, 3800946,
    3804901, 3805840, 3811962, 3814927, 3818414, 3825627, 3827505, 3832644, 3835910, 3839091, 3845273, 3846380, 3851597, 3856696, 3858898, 3866023,
    3868502, 3873571, 3875785, 3882940, 3885597, 3888744, 3894914, 3896055, 3899829, 3907008, 3908906, 3914079, 3919102, 3920011, 3926113, 3929108,
    3935055, 3938106, 3944400, 3945381, 3950084, 3955313, 3957403, 3964654, 3968428, 3969497, 3975475, 3978566, 3981543, 3988626, 3990648, 3995661,
    3998460, 4005513, 4007523, 4012566, 4018103, 4019138, 4025128, 4028253, 4031519, 4036714, 4038784, 4046069, 4049236, 4052257, 4058571, 4059582,
    4063273, 4070492, 4072630, 4077763, 4083042, 4083991, 4090365, 4093320, 4097738, 4102847, 4104789, 4111904, 4115329, 4118516, 4124446, 4125547,
    4131226, 4134383, 4140293, 4141424, 4146385, 4151460, 4153422, 4160571, 4165497, 4166412, 4172774, 4175763, 4178482, 4185671, 4187821, 4192984,
    4197149, 4200296, 4206466, 4207607, 4212310, 4217379, 4219593, 4226748, 4230654, 4231563, 4237665, 4240660, 4243637, 4250816, 4252714, 4257887,
    4260526, 4267739, 4269617, 4274756, 4280293, 4281232, 4287354, 4290319, 4293709, 4298808, 4301010, 4308135, 4311302, 4314483, 4320665, 4321772,
    4325499, 4332558, 4334820, 4339857, 4345136, 4346181, 4352431, 4355546, 4359832, 4365037, 4366855, 4374130, 4377555, 4380582, 4386636, 4387641,
    4393416, 4396477, 4402519, 4403490, 4408451, 4413686, 4415516, 4422761, 4427563, 4428638, 4434868, 4437953, 4440672, 4447765, 4450047, 4455050,
    4457937, 4463012, 4464974, 4472123, 4475034, 4478191, 4484101, 4485232, 4490034, 4497223, 4499373, 4504536, 4509305, 4510220, 4516582, 4519571,
    4525154, 4526103, 4532477, 4535432, 4538665, 4545884, 4548022, 4553155, 4557441, 4560628, 4566558, 4567659, 4573130, 4578239, 4580181, 4587296,
    4591287, 4592322, 4598312, 4601437, 4604924, 4611977, 4613987, 4619030, 4622420, 4625441, 4631755, 4632766, 4637983, 4643178, 4645248, 4652533,
    4654852, 4660081, 4662171, 4669422, 4672079, 4675130, 4681424, 4682405, 4686311, 4693394, 4695416, 4700429, 4705452, 4706521, 4712499, 4715590,
    4721392, 4724357, 4730479, 4731418, 4736955, 4742094, 4743972, 4751185, 4754451, 4755558, 4761740, 4764921, 4768088, 4775213, 4777415, 4782514,
    4784963, 4792118, 4794332, 4799401, 4804104, 4805245, 4811415, 4814562, 4818336, 4823509, 4825407, 4832586, 4835563, 4838558, 4844660, 4845569,
    4850070, 4857315, 4859145, 4864380, 4869341, 4870312, 4876354, 4879415, 4884341, 4889344, 4891626, 4898719, 4901438, 4904523, 4910753, 4911828,
    4917285, 4920400, 4926650, 4927695, 4932974, 4938011, 4940273, 4947332, 4951750, 4952755, 4958809, 4961836, 4965261, 4972536, 4974354, 4979559,
    4981820, 4986953, 4989091, 4996310, 4999543, 5002498, 5008872, 5009821, 5014239, 5021354, 5023296, 5028405, 5033876, 5034977, 5040907, 5044094,
    5049743, 5050874, 5056784, 5059941, 5062852, 5070001, 5071963, 5077038, 5081964, 5084953, 5091315, 5092230, 5096999, 5102162, 5104312, 5111501,
    5115738, 5116719, 5123013, 5126064, 5128721, 5135972, 5138062, 5143291, 5147065, 5150156, 5156134, 5157203, 5162226, 5167239, 5169261, 5176344,
    5179113, 5184156, 5186166, 5193219, 5196706, 5199831, 5205821, 5206856, 5210122, 5217407, 5219477, 5224672, 5229889, 5230900, 5237214, 5240235,
    5245127, 5248178, 5254232, 5255213, 5260684, 5265913, 5267731, 5274982, 5279268, 5280337, 5286587, 5289678, 5292911, 5299994, 5302256, 5307269,
    5308788, 5315841, 5318123, 5323166, 5327935, 5328970, 5335200, 5338325, 5343127, 5348322, 5350152, 5357437, 5360348, 5363369, 5369411, 5370422,
    5374881, 5382100, 5383998, 5389131, 5394154, 5395103, 5401205, 5404160, 5408066, 5413175, 5415389, 5422504, 5425161, 5428348, 5434518, 5435619,
    5442066, 5445223, 5451405, 5452536, 5457753, 5462828, 5465030, 5472179, 5475569, 5476484, 5482606, 5485595, 5489082, 5496271, 5498149, 5503312,
    5506571, 5511806, 5513876, 5521121, 5524288, 5527349, 5533663, 5534634, 5538024, 5545117, 5547127, 5552130, 5557667, 5558742, 5564732, 5567817,
    5574584, 5575629, 5581607, 5584722, 5587699, 5594758, 5596780, 5601817, 5605723, 5608750, 5615044, 5616049, 5620752, 5625957, 5628047, 5635322,
    5639533, 5640472, 5646834, 5649799, 5652518, 5659731, 5661881, 5667020, 5671822, 5675003, 5680913, 5682020, 5686981, 5692080, 5694042, 5701167,
    5702878, 5707947, 5709889, 5717044, 5720469, 5723616, 5729546, 5730687, 5734973, 5742152, 5744290, 5749463, 5754742, 5755651, 5762025, 5765020,
    5769514, 5772639, 5778869, 5779904, 5784673, 5789716, 5791998, 5799051, 5803977, 5804988, 5811030, 5814051, 5816962, 5824247, 5826077, 5831272,
    5832857, 5840108, 5841926, 5847155, 5852626, 5853607, 5859661, 5862712, 5867130, 5872143, 5874405, 5881488, 5884721, 5887812, 5894062, 5895131,
    5898828, 5905977, 5908179, 5913254, 5918471, 5919602, 5925784, 5928941, 5932207, 5937370, 5939248, 5946437, 5949924, 5952913, 5959035, 5959950,
    5966847, 5969802, 5975904, 5976853, 5981876, 5987009, 5988907, 5996126, 5999900, 6001001, 6007171, 6010358, 6013015, 6020130, 6022344, 6027453,
    6031334, 6036371, 6038393, 6045452, 6048429, 6051544, 6057522, 6058567, 6062341, 6069616, 6071706, 6076911, 6081614, 6082619, 6088913, 6091940,
    6098517, 6099488, 6105802, 6108863, 6112030, 6119275, 6121345, 6126580, 6129846, 6132931, 6138921, 6139996, 6145533, 6150536, 6152546, 6159639,
    6163584, 6164725, 6170655, 6173802, 6177227, 6184382, 6186324, 6191393, 6195811, 6198806, 6205180, 6206089, 6211368, 6216541, 6218679, 6225858,
    6227251, 6232390, 6234540, 6241753, 6244472, 6247437, 6253799, 6254738, 6259664, 6266789, 6268751, 6273850, 6278811, 6279918, 6285828, 6289009,
    6294697, 6295772, 6301750, 6304835, 6308322, 6315415, 6317437, 6322440, 6326858, 6329919, 6336213, 6337184, 6342401, 6347636, 6349726, 6356971,
    6358298, 6363503, 6365573, 6372848, 6375505, 6378532, 6384846, 6385851, 6390777, 6397836, 6399846, 6404883, 6409906, 6410951, 6416941, 6420056,
    6424527, 6429626, 6431568, 6438693, 6441604, 6444785, 6450715, 6451822, 6455596, 6462809, 6464947, 6470086, 6474855, 6475794, 6482168, 6485133,
    6491772, 6492681, 6499043, 6502038, 6505271, 6512450, 6514600, 6519773, 6523039, 6526186, 6532096, 6533237, 6538708, 6543777, 6545739, 6552894,
    6554213, 6561296, 6563578, 6568591, 6573870, 6574939, 6581169, 6584260, 6587526, 6592755, 6594585, 6601836, 6605261, 6608312, 6614354, 6615335,
    6622166, 6625187, 6631241, 6632252, 6637213, 6642408, 6644226, 6651511, 6655285, 6656320, 6662570, 6665695, 6668414, 6675467, 6677729, 6682772,
    6686979, 6690166, 6696348, 6697449, 6702152, 6707261, 6709463, 6716578, 6721504, 6722453, 6728575, 6731530, 6734507, 6741726, 6743604, 6748737,
    6750384, 6757573, 6759471, 6764634, 6770171, 6771086, 6777188, 6780177, 6784595, 6789670, 6791884, 6799033, 6802200, 6805357, 6811527, 6812658,
    6819140, 6820145, 6826459, 6829486, 6832143, 6839418, 6841488, 6846693, 6851495, 6854610, 6860600, 6861645, 6866668, 6871705, 6873715, 6880774,
    6882551, 6887554, 6889576, 6896669, 6900156, 6903241, 6909219, 6910294, 6914580, 6921825, 6923915, 6929150, 6934367, 6935338, 6941632, 6944693,
    6948386, 6953559, 6955709, 6962888, 6966121, 6969116, 6975478, 6976387, 6979777, 6986932, 6988894, 6993963, 6999434, 7000575, 7006485, 7009632,
    7016337, 7017444, 7023374, 7026555, 7029466, 7036591, 7038533, 7043632, 7047538, 7050503, 7056877, 7057816, 7062585, 7067724, 7069862, 7077075,
    7078792, 7086077, 7087895, 7093090, 7098051, 7099062, 7105116, 7108137, 7112043, 7117086, 7119348, 7126401, 7129120, 7132245, 7138495, 7139530,
    7146043, 7149134, 7155364, 7156433, 7161712, 7166725, 7169007, 7176090, 7179480, 7180461, 7186503, 7189554, 7192979, 7200230, 7202060, 7207289,
    7211246, 7214235, 7220337, 7221252, 7226789, 7231952, 7233850, 7241039, 7245325, 7246456, 7252626, 7255783, 7258950, 7266099, 7268313, 7273388,
    7274845, 7281960, 7284162, 7289271, 7293974, 7295075, 7301257, 7304444, 7309246, 7314379, 7316257, 7323476, 7326453, 7329408, 7335530, 7336479,
    7343987, 7344902, 7351276, 7354265, 7356984, 7364173, 7366311, 7371474, 7375248, 7378405, 7384335, 7385466, 7390427, 7395502, 7397444, 7404593,
    7407296, 7412405, 7414367, 7421482, 7424907, 7428094, 7434004, 7435105, 7438371, 7445590, 7447740, 7452873, 7458152, 7459101, 7465463, 7468418,
    7472149, 7477344, 7479434, 7486719, 7489886, 7492907, 7499201, 7500212, 7504630, 7511683, 7513705, 7518748, 7524285, 7525320, 7531298, 7534423,
    7540134, 7541203, 7547193, 7550284, 7553261, 7560344, 7562354, 7567367, 7572293, 7575344, 7581658, 7582639, 7587342, 7592571, 7594641, 7601892,
    7602623, 7609802, 7611680, 7616853, 7621876, 7622785, 7628907, 7631902, 7636828, 7641897, 7644099, 7651254, 7653911, 7657058, 7663240, 7664381,
    7669772, 7672953, 7679123, 7680230, 7685447, 7690546, 7692760, 7699885, 7704303, 7705242, 7711344, 7714309, 7717796, 7725009, 7726907, 7732046,
    7736025, 7739052, 7745094, 7746099, 7751570, 7756775, 7758605, 7765880, 7769146, 7770191, 7776421, 7779536, 7782769, 7789828, 7792110, 7797147,
    7799658, 7806751, 7809013, 7814016, 7818785, 7819860, 7826110, 7829195, 7832969, 7838204, 7840022, 7847267, 7850178, 7853239, 7859293, 7860264,
    7868062, 7869163, 7875073, 7878260, 7881685, 7888800, 7890762, 7895871, 7899261, 7902216, 7908578, 7909527, 7914806, 7919939, 7922089, 7929308,
    7931693, 7936856, 7938994, 7946183, 7948902, 7951891, 7958265, 7959180, 7963086, 7970235, 7972177, 7977252, 7982213, 7983344, 7989274, 7992431,
    7996920, 8001933, 8003943, 8011026, 8014003, 8017094, 8023084, 8024153, 8028955, 8036206, 8038276, 8043505, 8048208, 8049189, 8055503, 8058554,
    8064075, 8065086, 8071380, 8074401, 8077568, 8084853, 8086943, 8092138, 8096424, 8099549, 8105527, 8106562, 8112099, 8117142, 8119164, 8126217,
    8126546, 8133671, 8135885, 8140984, 8146201, 8147308, 8153478, 8156659, 8160945, 8166084, 8167982, 8175195, 8178682, 8181647, 8187749, 8188688,
    8194529, 8197524, 8203646, 8204555, 8209578, 8214751, 8216629, 8223808, 8228610, 8229751, 8235933, 8239080, 8241737, 8248892, 8251094, 8256163,
    8260404, 8263489, 8269739, 8270814, 8275583, 8280586, 8282848, 8289941, 8293847, 8294818, 8300872, 8303933, 8306844, 8314089, 8315907, 8321142,
    8323719, 8330994, 8332824, 8338029, 8343500, 8344505, 8350547, 8353574, 8356964, 8362001, 8364283, 8371342, 8374575, 8377690, 8383920, 8384965,
    8392250, 8393295, 8399525, 8402640, 8405873, 8412932, 8415214, 8420251, 8423641, 8426668, 8432710, 8433715, 8439186, 8444391, 8446221, 8453496,
    8456073, 8461308, 8463126, 8470371, 8473282, 8476343, 8482397, 8483368, 8487274, 8494367, 8496629, 8501632, 8506401, 8507476, 8513726, 8516811,
    8521052, 8526121, 8528323, 8535478, 8538135, 8541282, 8547464, 8548605, 8553407, 8560586, 8562464, 8567637, 8572660, 8573569, 8579691, 8582686,
    8588527, 8589466, 8595568, 8598533, 8602020, 8609233, 8611131, 8616270, 8620556, 8623737, 8629907, 8631014, 8636231, 8641330, 8643544, 8650669,
    8650998, 8658051, 8660073, 8665116, 8670653, 8671688, 8677666, 8680791, 8685077, 8690272, 8692362, 8699647, 8702814, 8705835, 8712129, 8713140,
    8718661, 8721712, 8728026, 8729007, 8733710, 8738939, 8741009, 8748260, 8753062, 8754131, 8760121, 8763212, 8766189, 8773272, 8775282, 8780295,
    8784784, 8787941, 8793871, 8795002, 8799963, 8805038, 8806980, 8814129, 8818035, 8818950, 8825324, 8828313, 8831032, 8838221, 8840359, 8845522,
    8847907, 8855126, 8857276, 8862409, 8867688, 8868637, 8874999, 8877954, 8881344, 8886453, 8888415, 8895530, 8898955, 8902142, 8908052, 8909153,
    8916951, 8917922, 8923976, 8927037, 8929948, 8937193, 8939011, 8944246, 8948020, 8951105, 8957355, 8958430, 8963199, 8968202, 8970464, 8977557,
    8980068, 8985105, 8987387, 8994446, 8997679, 9000794, 9007024, 9008069, 9011335, 9018610, 9020440, 9025645, 9031116, 9032121, 9038163, 9041190,
    9045169, 9050308, 9052206, 9059419, 9062906, 9065871, 9071973, 9072912, 9077330, 9084455, 9086669, 9091768, 9096985, 9098092, 9104262, 9107443,
    9112834, 9113975, 9120157, 9123304, 9125961, 9133116, 9135318, 9140387, 9145313, 9148308, 9154430, 9155339, 9160362, 9165535, 9167413, 9174592,
    9175323, 9182574, 9184644, 9189873, 9194576, 9195557, 9201871, 9204922, 9209848, 9214861, 9216871, 9223954, 9226931, 9230022, 9236012, 9237081,
    9242792, 9245917, 9251895, 9252930, 9258467, 9263510, 9265532, 9272585, 9277003, 9278014, 9284308, 9287329, 9290496, 9297781, 9299871, 9305066,
    9308797, 9311752, 9318114, 9319063, 9324342, 9329475, 9331625, 9338844, 9342110, 9343211, 9349121, 9352308, 9355733, 9362848, 9364810, 9369919,
    9372622, 9379771, 9381713, 9386788, 9391749, 9392880, 9398810, 9401967, 9405741, 9410904, 9413042, 9420231, 9422950, 9425939, 9432313, 9433228,
    9440736, 9441685, 9447807, 9450762, 9453739, 9460958, 9462836, 9467969, 9472771, 9475958, 9482140, 9483241, 9487944, 9493053, 9495255, 9502370,
    9503827, 9508902, 9511116, 9518265, 9521432, 9524589, 9530759, 9531890, 9536176, 9543365, 9545263, 9550426, 9555963, 9556878, 9562980, 9565969,
    9569926, 9575155, 9576985, 9584236, 9587661, 9590712, 9596754, 9597735, 9601125, 9608208, 9610490, 9615503, 9620782, 9621851, 9628081, 9631172,
    9637685, 9638720, 9644970, 9648095, 9650814, 9657867, 9660129, 9665172, 9669078, 9672099, 9678153, 9679164, 9684125, 9689320, 9691138, 9698423,
    9700140, 9707353, 9709491, 9714630, 9719399, 9720338, 9726712, 9729677, 9733583, 9738682, 9740624, 9747749, 9750660, 9753841, 9759771, 9760878,
    9767583, 9770730, 9776640, 9777781, 9783252, 9788321, 9790283, 9797438, 9800828, 9801737, 9808099, 9811094, 9814327, 9821506, 9823656, 9828829,
    9832522, 9835583, 9841877, 9842848, 9848065, 9853300, 9855390, 9862635, 9866921, 9867996, 9873974, 9877059, 9880546, 9887639, 9889661, 9894664,
    9896441, 9903500, 9905510, 9910547, 9915570, 9916615, 9922605, 9925720, 9930522, 9935727, 9937797, 9945072, 9947729, 9950756, 9957070, 9958075,
    9964557, 9965688, 9971858, 9975015, 9978182, 9985331, 9987545, 9992620, 9997038, 10000027, 10006129, 10007044, 10012581, 10017744, 10019642, 10026831,
    10028478, 10033611, 10035489, 10042708, 10045685, 10048640, 10054762, 10055711, 10060637, 10067752, 10069954, 10075063, 10079766, 10080867, 10087049, 10090236,
    10094443, 10099486, 10101748, 10108801, 10111520, 10114645, 10120895, 10121930, 10125704, 10132989, 10134807, 10140002, 10144963, 10145974, 10152028, 10155049,
    10161880, 10162861, 10168903, 10171954, 10175379, 10182630, 10184460, 10189689, 10192955, 10196046, 10202276, 10203345, 10208624, 10213637, 10215919, 10223002,
    10224321, 10231476, 10233438, 10238507, 10243978, 10245119, 10251029, 10254176, 10257442, 10262615, 10264765, 10271944, 10275177, 10278172, 10284534, 10285443,
    10292082, 10295047, 10301421, 10302360, 10307129, 10312268, 10314406, 10321619, 10325393, 10326500, 10332430, 10335611, 10338522, 10345647, 10347589, 10352688,
    10357159, 10360274, 10366264, 10367309, 10372332, 10377369, 10379379, 10386438, 10391364, 10392369, 10398683, 10401710, 10404367, 10411642, 10413712, 10418917,
    10420244, 10427489, 10429579, 10434814, 10440031, 10441002, 10447296, 10450357, 10454775, 10459778, 10461800, 10468893, 10472380, 10475465, 10481443, 10482518,
    10488206, 10491387, 10497297, 10498404, 10503365, 10508464, 10510426, 10517551, 10522477, 10523416, 10529778, 10532743, 10535462, 10542675, 10544825, 10549964,
    10551357, 10558536, 10560674, 10565847, 10571126, 10572035, 10578409, 10581404, 10585822, 10590891, 10592833, 10599988, 10603413, 10606560, 10612490, 10613631,
    10617576, 10624669, 10626679, 10631682, 10637219, 10638294, 10644284, 10647369, 10650635, 10655870, 10657940, 10665185, 10668352, 10671413, 10677727, 10678698,
    10685275, 10688302, 10694596, 10695601, 10700304, 10705509, 10707599, 10714874, 10718648, 10719693, 10725671, 10728786, 10731763, 10738822, 10740844, 10745881,
    10749762, 10754871, 10757085, 10764200, 10766857, 10770044, 10776214, 10777315, 10781089, 10788308, 10790206, 10795339, 10800362, 10801311, 10807413, 10810368,
    10817265, 10818180, 10824302, 10827291, 10830778, 10837967, 10839845, 10845008, 10848274, 10851431, 10857613, 10858744, 10863961, 10869036, 10871238, 10878387,
    10882084, 10883153, 10889403, 10892494, 10895727, 10902810, 10905072, 10910085, 10914503, 10917554, 10923608, 10924589, 10930060, 10935289, 10937107, 10944358,
    10945943, 10951138, 10952968, 10960253, 10963164, 10966185, 10972227, 10973238, 10978164, 10985217, 10987499, 10992542, 10997311, 10998346, 11004576, 11007701,
    11012195, 11015190, 11021564, 11022473, 11027752, 11032925, 11035063, 11042242, 11046528, 11047669, 11053599, 11056746, 11060171, 11067326, 11069268, 11074337,
    11076048, 11083173, 11085135, 11090234, 11095195, 11096302, 11102212, 11105393, 11110195, 11115334, 11117484, 11124697, 11127416, 11130381, 11136743, 11137682,
    11141893, 11149168, 11151258, 11156463, 11161166, 11162171, 11168465, 11171492, 11175398, 11180435, 11182457, 11189516, 11192493, 11195608, 11201586, 11202631,
    11209398, 11212483, 11218473, 11219548, 11225085, 11230088, 11232098, 11239191, 11242581, 11243552, 11249866, 11252927, 11256094, 11263339, 11265409, 11270644,
    11273903, 11279066, 11280944, 11288133, 11291620, 11294609, 11300731, 11301646, 11305036, 11312185, 11314387, 11319462, 11324679, 11325810, 11331992, 11335149,
    11341596, 11342697, 11348867, 11352054, 11354711, 11361826, 11364040, 11369149, 11373055, 11376010, 11382112, 11383061, 11388084, 11393217, 11395115, 11402334,
    11406793, 11407804, 11413846, 11416867, 11419778, 11427063, 11428893, 11434088, 11438890, 11442015, 11448245, 11449280, 11454049, 11459092, 11461374, 11468427,
    11469946, 11474959, 11477221, 11484304, 11487537, 11490628, 11496878, 11497947, 11502233, 11509484, 11511302, 11516531, 11522002, 11522983, 11529037, 11532088,
    11536980, 11540001, 11546315, 11547326, 11552543, 11557738, 11559808, 11567093, 11570359, 11571394, 11577384, 11580509, 11583996, 11591049, 11593059, 11598102,
    11600871, 11607954, 11609976, 11614989, 11620012, 11621081, 11627059, 11630150, 11633924, 11639153, 11641243, 11648494, 11651151, 11654202, 11660496, 11661477,
    11665714, 11672903, 11675053, 11680216, 11684985, 11685900, 11692262, 11695251, 11700177, 11705252, 11707214, 11714363, 11717274, 11720431, 11726341, 11727472,
    11733121, 11736308, 11742238, 11743339, 11748810, 11753919, 11755861, 11762976, 11767394, 11768343, 11774717, 11777672, 11780905, 11788124, 11790262, 11795395,
    11797656, 11802861, 11804679, 11811954, 11815379, 11818406, 11824460, 11825465, 11829883, 11836942, 11839204, 11844241, 11849520, 11850565, 11856815, 11859930,
    11865387, 11866462, 11872692, 11875777, 11878496, 11885589, 11887871, 11892874, 11897800, 11900861, 11906903, 11907874, 11912835, 11918070, 11919900, 11927145,
    11931646, 11932555, 11938657, 11941652, 11944629, 11951808, 11953706, 11958879, 11962653, 11965800, 11971970, 11973111, 11977814, 11982883, 11985097, 11992252,
    11994701, 11999800, 12002002, 12009127, 12012294, 12015475, 12021657, 12022764, 12026030, 12033243, 12035121, 12040260, 12045797, 12046736, 12052858, 12055823,
    12061625, 12064716, 12070694, 12071763, 12076786, 12081799, 12083821, 12090904, 12094810, 12095791, 12102085, 12105136, 12107793, 12115044, 12117134, 12122363,
    12124682, 12131967, 12134037, 12139232, 12144449, 12145460, 12151774, 12154795, 12158185, 12163228, 12165238, 12172291, 12175778, 12178903, 12184893, 12185928,
    12189919, 12197034, 12198976, 12204085, 12209556, 12210657, 12216587, 12219774, 12224060, 12229193, 12231331, 12238550, 12241783, 12244738, 12251112, 12252061,
    12257644, 12260633, 12266995, 12267910, 12272679, 12277842, 12279992, 12287181, 12291983, 12293114, 12299024, 12302181, 12305092, 12312241, 12314203, 12319278,
    12322165, 12327168, 12329450, 12336543, 12339262, 12342347, 12348577, 12349652, 12354454, 12361699, 12363529, 12368764, 12373725, 12374696, 12380738, 12383799,
    12389574, 12390579, 12396633, 12399660, 12403085, 12410360, 12412178, 12417383, 12421669, 12424784, 12431034, 12432079, 12437358, 12442395, 12444657, 12451716,
    12455443, 12456550, 12462732, 12465913, 12469080, 12476205, 12478407, 12483506, 12486896, 12489861, 12495983, 12496922, 12502459, 12507598, 12509476, 12516689,
    12519328, 12524501, 12526399, 12533578, 12536555, 12539550, 12545652, 12546561, 12550467, 12557622, 12559836, 12564905, 12569608, 12570749, 12576919, 12580066,
    12584231, 12589394, 12591544, 12598733, 12601452, 12604441, 12610803, 12611718, 12616644, 12623793, 12625755, 12630830, 12635791, 12636922, 12642832, 12645989,
    12651668, 12652769, 12658699, 12661886, 12665311, 12672426, 12674368, 12679477, 12683895, 12686850, 12693224, 12694173, 12699452, 12704585, 12706723, 12713942,
    12717633, 12718644, 12724958, 12727979, 12731146, 12738431, 12740501, 12745696, 12748962, 12752087, 12758077, 12759112, 12764649, 12769692, 12771702, 12778755,
    12781554, 12786567, 12788589, 12795672, 12798649, 12801740, 12807718, 12808787, 12812561, 12819812, 12821902, 12827131, 12831834, 12832815, 12839109, 12842160,
    12848107, 12851102, 12857204, 12858113, 12863136, 12868309, 12870207, 12877386, 12881160, 12882301, 12888471, 12891618, 12894275, 12901430, 12903644, 12908713,
    12911192, 12918317, 12920519, 12925618, 12930835, 12931942, 12938124, 12941305, 12944571, 12949710, 12951588, 12958801, 12962288, 12965253, 12971375, 12972314,
    12976269, 12983544, 12985362, 12990567, 12996038, 12997043, 13003097, 13006124, 13010542, 13015579, 13017841, 13024900, 13028133, 13031248, 13037498, 13038543,
    13044030, 13047115, 13053345, 13054420, 13059189, 13064192, 13066474, 13073567, 13078493, 13079464, 13085506, 13088567, 13091478, 13098723, 13100553, 13105788,
    13108426, 13113535, 13115477, 13122592, 13126017, 13129204, 13135134, 13136235, 13140521, 13147740, 13149878, 13155011, 13160290, 13161239, 13167613, 13170568,
    13176185, 13177100, 13183462, 13186451, 13189170, 13196359, 13198509, 13203672, 13208474, 13211631, 13217541, 13218672, 13223633, 13228708, 13230670, 13237819,
    13242284, 13243353, 13249331, 13252422, 13255399, 13262482, 13264504, 13269517, 13273423, 13276474, 13282768, 13283749, 13288452, 13293681, 13295771, 13303022,
    13305375, 13310570, 13312640, 13319925, 13323092, 13326113, 13332427, 13333438, 13336828, 13343881, 13345891, 13350934, 13356471, 13357506, 13363496, 13366621,
    13371910, 13375091, 13381273, 13382380, 13387597, 13392696, 13394898, 13402023, 13405413, 13406352, 13412474, 13415439, 13418926, 13426139, 13428017, 13433156,
    13435829, 13443008, 13444906, 13450079, 13455102, 13456011, 13462113, 13465108, 13469014, 13474083, 13476297, 13483452, 13486109, 13489256, 13495426, 13496567,
    13500768, 13507861, 13510143, 13515146, 13519915, 13520990, 13527220, 13530305, 13535107, 13540342, 13542172, 13549417, 13552328, 13555389, 13561431, 13562402,
    13568211, 13571238, 13577292, 13578297, 13583768, 13588973, 13590791, 13598066, 13602352, 13603397, 13609647, 13612762, 13615995, 13623054, 13625316, 13630353,
    13633277, 13638280, 13640290, 13647383, 13650870, 13653955, 13659945, 13661020, 13664286, 13671531, 13673601, 13678836, 13684053, 13685024, 13691338, 13694399,
    13700942, 13701947, 13708241, 13711268, 13713925, 13721200, 13723290, 13728495, 13732269, 13735384, 13741362, 13742407, 13747430, 13752467, 13754489, 13761548,
    13766043, 13767150, 13773060, 13776241, 13779152, 13786277, 13788239, 13793338, 13798264, 13801229, 13807591, 13808530, 13813299, 13818438, 13820588, 13827801,
    13829160, 13834333, 13836471, 13843650, 13846883, 13849878, 13856252, 13857161, 13861579, 13868734, 13870676, 13875745, 13881216, 13882357, 13888287, 13891434,
    13895729, 13898820, 13905070, 13906139, 13911418, 13916431, 13918693, 13925776, 13930194, 13931175, 13937229, 13940280, 13943705, 13950956, 13952774, 13958003,
    13959554, 13966839, 13968669, 13973864, 13978825, 13979836, 13985878, 13988899, 13993825, 13998868, 14001150, 14008203, 14010922, 14014047, 14020277, 14021312,
    14025559, 14032674, 14034888, 14039997, 14044700, 14045801, 14051971, 14055158, 14058932, 14064065, 14065963, 14073182, 14076159, 14079114, 14085216, 14086165,
    14093028, 14096017, 14102139, 14103054, 14108591, 14113754, 14115632, 14122821, 14126087, 14127218, 14133400, 14136557, 14139724, 14146873, 14149075, 14154150,
    14157584, 14162789, 14164879, 14172154, 14174811, 14177838, 14184132, 14185137, 14189043, 14196102, 14198124, 14203161, 14208184, 14209229, 14215207, 14218322,
    14225059, 14226134, 14232124, 14235209, 14238696, 14245789, 14247799, 14252802, 14256192, 14259253, 14265567, 14266538, 14271755, 14276990, 14279060, 14286305,
    14290038, 14290947, 14297321, 14300316, 14303549, 14310728, 14312866, 14318039, 14322325, 14325472, 14331402, 14332543, 14338014, 14343083, 14345025, 14352180,
    14353861, 14358960, 14360922, 14368047, 14370958, 14374139, 14380049, 14381156, 14385958, 14393171, 14395321, 14400460, 14405229, 14406168, 14412530, 14415495,
    14420444, 14423465, 14429507, 14430518, 14435479, 14440674, 14442504, 14449789, 14454591, 14455626, 14461856, 14464981, 14467700, 14474753, 14477035, 14482078,
    14483567, 14490650, 14492912, 14497925, 14503204, 14504273, 14510523, 14513614, 14517900, 14523129, 14524947, 14532198, 14535623, 14538674, 14544728, 14545709,
    14549690, 14556879, 14558757, 14563920, 14569457, 14570372, 14576494, 14579483, 14582873, 14587948, 14590150, 14597299, 14600466, 14603623, 14609805, 14610936,
    14617353, 14620540, 14626710, 14627811, 14632514, 14637623, 14639837, 14646952, 14650858, 14651807, 14657909, 14660864, 14663841, 14671060, 14672958, 14678091,
    14680723, 14687974, 14689804, 14695033, 14700504, 14701485, 14707527, 14710578, 14713968, 14718981, 14721263, 14728346, 14731579, 14734670, 14740900, 14741969,
    14748448, 14751573, 14757823, 14758858, 14763627, 14768670, 14770932, 14777985, 14781891, 14782902, 14788956, 14791977, 14794888, 14802173, 14803991, 14809186,
    14813685, 14816640, 14822762, 14823711, 14828734, 14833867, 14835745, 14842964, 14847766, 14848867, 14855049, 14858236, 14860893, 14868008, 14870210, 14875319,
    14876742, 14883891, 14886105, 14891180, 14896397, 14897528, 14903698, 14906855, 14911141, 14916304, 14918202, 14925391, 14928878, 14931867, 14937969, 14938884,
    14945375, 14946346, 14952640, 14955701, 14958868, 14966113, 14968203, 14973438, 14977724, 14980809, 14986787, 14987862, 14993399, 14998402, 15000424, 15007517,
    15009260, 15014297, 15016307, 15023366, 15026343, 15029458, 15035448, 15036493, 15041295, 15048570, 15050640, 15055845, 15060548, 15061553, 15067867, 15070894,
    15075129, 15080268, 15082406, 15089619, 15092338, 15095303, 15101677, 15102616, 15106522, 15113647, 15115589, 15120688, 15125649, 15126756, 15132686, 15135867,
    15142538, 15143679, 15149589, 15152736, 15156161, 15163316, 15165278, 15170347, 15173737, 15176732, 15183094, 15184003, 15189282, 15194455, 15196605, 15203784,
    15205246, 15212299, 15214561, 15219604, 15224373, 15225408, 15231658, 15234783, 15238557, 15243752, 15245570, 15252855, 15255766, 15258787, 15264841, 15265852,
    15272653, 15275704, 15281746, 15282727, 15288198, 15293427, 15295257, 15302508, 15305774, 15306843, 15313073, 15316164, 15319397, 15326480, 15328762, 15333775,
    15337496, 15340653, 15346823, 15347954, 15353171, 15358246, 15360460, 15367609, 15372027, 15372942, 15379044, 15382033, 15385520, 15392709, 15394607, 15399770,
    15401387, 15408606, 15410484, 15415617, 15420640, 15421589, 15427711, 15430666, 15435592, 15440701, 15442903, 15450018, 15452675, 15455862, 15462044, 15463145,
    15470002, 15471047, 15477037, 15480152, 15483129, 15490188, 15492198, 15497235, 15502161, 15505188, 15511502, 15512507, 15517210, 15522415, 15524485, 15531760,
    15533057, 15538292, 15540382, 15547627, 15550794, 15553855, 15560149, 15561120, 15565538, 15572631, 15574653, 15579656, 15585193, 15586268, 15592246, 15595331,
    15599316, 15604385, 15606347, 15613502, 15616927, 15620074, 15625984, 15627125, 15630391, 15637570, 15639720, 15644893, 15650172, 15651081, 15657443, 15660438,
    15667047, 15667986, 15674360, 15677325, 15680044, 15687257, 15689395, 15694534, 15698308, 15701489, 15707419, 15708526, 15713487, 15718586, 15720528, 15727653,
    15728969, 15736124, 15738326, 15743395, 15748098, 15749239, 15755421, 15758568, 15763370, 15768543, 15770421, 15777600, 15780577, 15783572, 15789694, 15790603,
    15796474, 15799439, 15805541, 15806480, 15812017, 15817156, 15819054, 15826267, 15830553, 15831660, 15837830, 15841011, 15844178, 15851303, 15853517, 15858616,
    15862319, 15865434, 15871664, 15872709, 15877988, 15883025, 15885307, 15892366, 15895756, 15896761, 15902803, 15905830, 15909255, 15916530, 15918360, 15923565,
    15926172, 15933417, 15935235, 15940470, 15945431, 15946402, 15952456, 15955517, 15959423, 15964426, 15966688, 15973781, 15976500, 15979585, 15985835, 15986910,
    15994757, 15995888, 16001818, 16004975, 16007886, 16015035, 16016977, 16022052, 16025958, 16028947, 16035321, 16036236, 16041005, 16046168, 16048306, 16055495,
    16057910, 16063043, 16065193, 16072412, 16075645, 16078600, 16084962, 16085911, 16089301, 16096416, 16098378, 16103487, 16108958, 16110059, 16115969, 16119156,
    16123107, 16128150, 16130172, 16137225, 16140712, 16143837, 16149815, 16150850, 16155136, 16162421, 16164511, 16169706, 16174923, 16175934, 16182228, 16185249,
    16190800, 16191781, 16198095, 16201146, 16203803, 16211054, 16213124, 16218353, 16223155, 16226246, 16232236, 16233305, 16238328, 16243341, 16245351, 16252434,
    16253092, 16260305, 16262203, 16267342, 16272879, 16273818, 16279920, 16282885, 16287303, 16292402, 16294616, 16301741, 16304908, 16308089, 16314259, 16315366,
    16320791, 16323938, 16330120, 16331261, 16335964, 16341033, 16343235, 16350390, 16355316, 16356225, 16362347, 16365342, 16368319, 16375498, 16377376, 16382549,
    16387010, 16390071, 16396125, 16397096, 16402057, 16407292, 16409110, 16416355, 16420129, 16421204, 16427454, 16430539, 16433258, 16440351, 16442613, 16447616,
    16450161, 16457220, 16459502, 16464539, 16469818, 16470863, 16477093, 16480208, 16483474, 16488679, 16490509, 16497784, 16501209, 16504236, 16510278, 16511283,
    16518760, 16519709, 16526071, 16529026, 16532259, 16539478, 16541628, 16546761, 16550027, 16553214, 16559124, 16560225, 16565696, 16570805, 16572767, 16579882,
    16582619, 16587694, 16589636, 16596785, 16599696, 16602853, 16608783, 16609914, 16613688, 16620877, 16623015, 16628178, 16632947, 16633862, 16640236, 16643225,
    16647438, 16652667, 16654737, 16661988, 16664645, 16667696, 16674010, 16674991, 16679917, 16687000, 16689010, 16694023, 16699046, 16700115, 16706105, 16709196,
    16714941, 16715976, 16721954, 16725079, 16728566, 16735619, 16737641, 16742684, 16747102, 16750123, 16756417, 16757428, 16762645, 16767840, 16769930, 16777215
};

static const int dec_tab[] =
{
    0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 147488,
    16, 17, 18, 19, 20, 21, 22, 4268032, 24, 25, 26, 1574912, 28, 2097920, 294976, 5248,
    32, 33, 34, 35, 36, 37, 38, 147464, 40, 41, 42, 147460, 44, 147458, 147457, 147456,
    48, 49, 50, 33152, 52, 3136, 3149824, 786944, 56, 274432, 4195840, 2162752, 589952, 5275648, 10496, 147472,
    64, 65, 66, 67, 68, 69, 70, 2621568, 72, 73, 74, 9472, 76, 1118208, 294928, 4196864,
    80, 81, 82, 135680, 84, 3104, 294920, 1065216, 88, 4210816, 294916, 2162720, 294914, 663552, 294912, 294913,
    96, 97, 98, 5505024, 100, 3088, 66304, 45056, 104, 557568, 6272, 2162704, 6299648, 262528, 1573888, 147520,
    112, 3076, 548864, 2162696, 3073, 3072, 4325504, 3074, 1179904, 2162690, 2162689, 2162688, 20992, 3080, 294944, 2162692,
    128, 129, 130, 131, 132, 133, 134, 2621504, 136, 137, 138, 328192, 140, 43008, 5243136, 5136,
    144, 145, 146, 33056, 148, 1441792, 18944, 5128, 152, 4210752, 2236416, 5124, 589856, 5122, 5121, 5120,
    160, 161, 162, 33040, 164, 4198912, 271360, 1116160, 168, 3146752, 6208, 4726784, 589840, 262464, 2130432, 147584,
    176, 33026, 33025, 33024, 589832, 2121728, 4325440, 33028, 589828, 133632, 1327104, 33032, 589824, 589825, 589826, 5152,
    192, 193, 194, 2621444, 196, 2621442, 2621441, 2621440, 200, 4210704, 6176, 1212416, 132608, 262432, 90112, 2621448,
    208, 4210696, 1115136, 272384, 12544, 98816, 4325408, 2621456, 4210689, 4210688, 525056, 4210690, 3147776, 4210692, 295040, 5184,
    224, 204800, 6152, 17920, 1097728, 262408, 4325392, 2621472, 6146, 262404, 6144, 6145, 262401, 262400, 6148, 262402,
    2359808, 1576960, 4325380, 33088, 4325378, 3200, 4325376, 4325377, 41984, 4210720, 6160, 2162816, 589888, 262416, 4325384, 1057280,
    256, 257, 258, 259, 260, 261, 262, 268288, 264, 265, 266, 9280, 268, 2097680, 5243008, 622592,
    272, 273, 274, 32928, 276, 2097672, 656384, 1065024, 280, 2097668, 86016, 4587520, 2097665, 2097664, 10272, 2097666,
    288, 289, 290, 32912, 292, 1581056, 66112, 6292480, 296, 4261888, 2883584, 1053184, 37888, 262336, 10256, 147712,
    304, 32898, 32897, 32896, 4472832, 200704, 10248, 32900, 1179712, 541696, 10244, 32904, 10242, 2097696, 10240, 10241,
    320, 321, 322, 9224, 324, 4358144, 66080, 1064976, 328, 9218, 9217, 9216, 542720, 262304, 2232320, 9220,
    336, 851968, 6293504, 1064964, 12416, 1064962, 1064961, 1064960, 1179680, 38912, 524928, 9232, 4260864, 2097728, 295168, 1064968,
    352, 2117632, 66052, 657408, 66050, 262280, 66048, 66049, 1179664, 262276, 4243456, 9248, 262273, 262272, 66056, 262274,
    1179656, 4203008, 267264, 32960, 2654208, 3328, 66064, 1064992, 1179648, 1179649, 1179650, 2162944, 1179652, 262288, 10304, 4722688,
    384, 385, 386, 32816, 388, 82944, 5242888, 139776, 392, 659456, 5242884, 2115584, 5242882, 262240, 5242880, 5242881,
    400, 32802, 32801, 32800, 12352, 4720640, 2424832, 32804, 265216, 1122304, 524864, 32808, 180224, 2097792, 5242896, 5376,
    416, 32786, 32785, 32784, 2230272, 262216, 544768, 32788, 25088, 262212, 197632, 32792, 262209, 262208, 5242912, 262210,
    32771, 32770, 32769, 32768, 1050112, 32774, 32773, 32772, 6295552, 32778, 32777, 32776, 590080, 262224, 10368, 32780,
    448, 1051136, 409600, 4263936, 12304, 262184, 35840, 2621696, 2195456, 262180, 524816, 9344, 262177, 262176, 5242944, 262178,
    12292, 2229248, 524808, 32864, 12288, 12289, 12290, 1065088, 524802, 4210944, 524800, 524801, 12296, 262192, 524804, 198656,
    4719616, 262156, 3153920, 32848, 262153, 262152, 66176, 262154, 262149, 262148, 6400, 262150, 262145, 262144, 262147, 262146,
    83968, 32834, 32833, 32832, 12320, 262168, 4325632, 32836, 1179776, 262164, 524832, 32840, 262161, 262160, 2114560, 262162,
    512, 513, 514, 515, 516, 517, 518, 1082368, 520, 521, 522, 327808, 524, 2097424, 536576, 4196416,
    528, 529, 530, 135232, 532, 2097416, 18560, 786464, 536, 2097412, 4195360, 57344, 2097409, 2097408, 1245184, 2097410,
    544, 545, 546, 2107392, 548, 4198528, 65856, 786448, 552, 557120, 4195344, 1052928, 1312768, 74752, 2130048, 147968,
    560, 1130496, 4195336, 786436, 172032, 786434, 786433, 786432, 4195330, 133248, 4195328, 4195329, 20544, 2097440, 4195332, 786440,
    576, 577, 578, 135184, 580, 286720, 65824, 4196360, 584, 557088, 3162112, 4196356, 132224, 4196354, 4196353, 4196352,
    592, 135170, 135169, 135168, 5767168, 98432, 2106368, 135172, 75776, 1311744, 524672, 135176, 20512, 2097472, 295424, 4196368,
    608, 557064, 65796, 17536, 65794, 3276800, 65792, 65793, 557057, 557056, 401408, 557058, 20496, 557060, 65800, 4196384,
    2359424, 4202752, 1083392, 135200, 20488, 3584, 65808, 786496, 20484, 557072, 4195392, 2163200, 20480, 20481, 20482, 1056896,
    640, 641, 642, 327688, 644, 4198432, 18448, 139520, 648, 327682, 327681, 327680, 132160, 1589248, 2129952, 327684,
    656, 533504, 18436, 7340032, 18434, 98368, 18432, 18433, 1085440, 133152, 524608, 327696, 4464640, 2097536, 18440, 5632,
    672, 4198404, 1703936, 17472, 4198401, 4198400, 2129928, 4198402, 24832, 133136, 2129924, 327712, 2129922, 4198408, 2129920, 2129921,
    2359360, 133128, 77824, 33536, 1049856, 4198416, 18464, 786560, 133121, 133120, 4195456, 133122, 590336, 133124, 2129936, 1056832,
    704, 1050880, 4235264, 17440, 132104, 98320, 1314816, 2621952, 132100, 2109440, 524560, 327744, 132096, 132097, 132098, 4196480,
    2359328, 98308, 524552, 135296, 98305, 98304, 18496, 98306, 524546, 4211200, 524544, 524545, 132112, 98312, 524548, 1056800,
    2359312, 17410, 17409, 17408, 534528, 4198464, 65920, 17412, 5308416, 557184, 6656, 17416, 132128, 262912, 2129984, 1056784,
    2359296, 2359297, 2359298, 17424, 2359300, 98336, 4325888, 1056776, 2359304, 133184, 524576, 1056772, 20608, 1056770, 1056769, 1056768,
    768, 769, 770, 4734976, 772, 2097176, 65632, 139392, 776, 2097172, 165888, 1052704, 2097169, 2097168, 279552, 2097170,
    784, 2097164, 1318912, 68608, 2097161, 2097160, 4231168, 2097162, 2097157, 2097156, 524480, 2097158, 2097153, 2097152, 2097155, 2097154,
    800, 394240, 65604, 1052680, 65602, 51200, 65600, 65601, 24704, 1052674, 1052673, 1052672, 4849664, 2097200, 65608, 1052676,
    530432, 4202560, 2244608, 33408, 1049728, 2097192, 65616, 786688, 360448, 2097188, 4195584, 1052688, 2097185, 2097184, 10752, 2097186,
    832, 1050752, 65572, 2392064, 65570, 529408, 65568, 65569, 4460544, 212992, 524432, 9728, 1089536, 2097232, 65576, 4196608,
    50176, 4202528, 524424, 135424, 395264, 2097224, 65584, 1065472, 524418, 2097220, 524416, 524417, 2097217, 2097216, 524420, 2097218,
    65542, 4202512, 65540, 65541, 65538, 65539, 65536, 65537, 2100224, 557312, 65548, 1052736, 65546, 262784, 65544, 65545,
    4202497, 4202496, 65556, 4202498, 65554, 4202500, 65552, 65553, 1180160, 4202504, 524448, 280576, 20736, 2097248, 65560, 164864,
    896, 1050688, 2102272, 139268, 819200, 139266, 139265, 139264, 24608, 4228096, 524368, 327936, 71680, 2097296, 5243392, 139272,
    4390912, 282624, 524360, 33312, 1049632, 2097288, 18688, 139280, 524354, 2097284, 524352, 524353, 2097281, 2097280, 524356, 2097282,
    24584, 2686976, 4458496, 33296, 1049616, 4198656, 65728, 139296, 24576, 24577, 24578, 1052800, 24580, 262720, 2130176, 527360,
    1049604, 33282, 33281, 33280, 1049600, 1049601, 1049602, 33284, 24592, 133376, 524384, 33288, 1049608, 2097312, 397312, 4276224,
    1050625, 1050624, 524312, 1050626, 6307840, 1050628, 65696, 139328, 524306, 1050632, 524304, 524305, 132352, 262688, 524308, 53248,
    524298, 1050640, 524296, 524297, 12800, 98560, 524300, 4457472, 524290, 524291, 524288, 524289, 524294, 2097344, 524292, 524293,
    167936, 1050656, 65668, 17664, 65666, 262664, 65664, 65665, 24640, 262660, 524336, 6422528, 262657, 262656, 65672, 262658,
    2359552, 4202624, 524328, 33344, 1049664, 671744, 65680, 2103296, 524322, 70656, 524320, 524321, 4229120, 262672, 524324, 1057024,
    1024, 1025, 1026, 1027, 1028, 1029, 1030, 1081856, 1032, 1033, 1034, 8512, 1036, 4980736, 2164736, 4240,
    1040, 1041, 1042, 2375680, 1044, 2144, 655616, 4232, 1048, 229376, 4194848, 4228, 1073152, 4226, 4225, 4224,
    1056, 1057, 1058, 593920, 1060, 2128, 270464, 6291712, 1064, 3145856, 4194832, 296960, 37120, 74240, 1572928, 148480,
    1072, 2116, 4194824, 1187840, 2113, 2112, 114688, 2114, 4194818, 540928, 4194816, 4194817, 2490368, 2120, 4194820, 4256,
    1088, 1089, 1090, 8456, 1092, 2096, 4214784, 458752, 1096, 8450, 8449, 8448, 131712, 2146304, 1572896, 8452,
    1104, 2084, 1114240, 4751360, 2081, 2080, 2105856, 2082, 2625536, 1311232, 149504, 8464, 4260096, 2088, 295936, 4288,
    1120, 2068, 2260992, 17024, 2065, 2064, 1572872, 2066, 344064, 4329472, 1572868, 8480, 1572866, 2072, 1572864, 1572865,
    2053, 2052, 266496, 2054, 2049, 2048, 2051, 2050, 41088, 2060, 4194880, 2163712, 2057, 2056, 1572880, 2058,
    1152, 1153, 1154, 4327424, 1156, 82176, 270368, 4120, 1160, 3145760, 573440, 4116, 131648, 4114, 4113, 4112,
    1168, 532992, 1114176, 4108, 6324224, 4106, 4105, 4104, 264448, 4102, 4101, 4100, 4099, 4098, 4097, 4096,
    1184, 3145736, 270340, 16960, 270338, 688128, 270336, 270337, 3145729, 3145728, 196864, 3145730, 4212736, 3145732, 270344, 4144,
    151552, 4521984, 2623488, 34048, 1049344, 2240, 270352, 4136, 41024, 3145744, 4194944, 4132, 590848, 4130, 4129, 4128,
    1216, 299008, 1114128, 16928, 131592, 5251072, 35072, 2622464, 131588, 591872, 6553600, 8576, 131584, 131585, 131586, 4176,
    1114114, 2228480, 1114112, 1114113, 802816, 2208, 1114116, 4168, 40992, 4211712, 1114120, 4164, 131600, 4162, 4161, 4160,
    4718848, 16898, 16897, 16896, 2166784, 2192, 270400, 16900, 40976, 3145792, 7168, 16904, 131616, 263424, 1572992, 4292608,
    40968, 2180, 1114144, 16912, 2177, 2176, 4326400, 2178, 40960, 40961, 40962, 917504, 40964, 2184, 2113792, 4192,
    1280, 1281, 1282, 8264, 1284, 82048, 655376, 6291488, 1288, 8258, 8257, 8256, 36896, 1181696, 279040, 8260,
    1296, 5246976, 655364, 68096, 655362, 303104, 655360, 655361, 264320, 540704, 3178496, 8272, 4259904, 2098688, 655368, 4480,
    1312, 393728, 1067008, 6291460, 36872, 6291458, 6291457, 6291456, 36868, 540688, 196736, 8288, 36864, 36865, 36866, 6291464,
    2170880, 540680, 266304, 33920, 1049216, 2368, 655392, 6291472, 540673, 540672, 4195072, 540674, 36880, 540676, 11264, 1376256,
    1344, 8202, 8201, 8200, 3407872, 528896, 34944, 8204, 8195, 8194, 8193, 8192, 4259856, 8198, 8197, 8196,
    49664, 2228352, 266272, 8216, 4259848, 2336, 655424, 1065984, 4259844, 8210, 8209, 8208, 4259840, 4259841, 4259842, 8212,
    4718720, 1146880, 266256, 8232, 155648, 2320, 67072, 6291520, 2099712, 8226, 8225, 8224, 36928, 263296, 1573120, 8228,
    266242, 2308, 266240, 266241, 2305, 2304, 266244, 2306, 1180672, 540736, 266248, 8240, 4259872, 2312, 2113664, 164352,
    1408, 81924, 2101760, 1835008, 81921, 81920, 34880, 81922, 264208, 4227584, 196640, 8384, 2629632, 81928, 5243904, 4368,
    264200, 2228288, 4218880, 33824, 1049120, 81936, 655488, 4360, 264192, 264193, 264194, 4356, 264196, 4354, 4353, 4352,
    4718656, 14336, 196616, 33808, 1049104, 81952, 270592, 6291584, 196610, 3145984, 196608, 196609, 36992, 263232, 196612, 526848,
    1049092, 33794, 33793, 33792, 1049088, 1049089, 1049090, 33796, 264224, 540800, 196624, 33800, 1049096, 4333568, 2113600, 4384,
    4718624, 2228240, 34820, 8328, 34818, 81984, 34816, 34817, 1069056, 8322, 8321, 8320, 131840, 263200, 34824, 8324,
    2228225, 2228224, 1114368, 2228226, 13312, 2228228, 34832, 4456960, 264256, 2228232, 525824, 8336, 4259968, 1605632, 2113568, 4416,
    4718592, 4718593, 4718594, 17152, 4718596, 263176, 34848, 1183744, 4718600, 263172, 196672, 8352, 263169, 263168, 2113552, 263170,
    4718608, 2228256, 266368, 33856, 1049152, 2432, 2113544, 598016, 41216, 70144, 2113540, 5244928, 2113538, 263184, 2113536, 2113537,
    1536, 1537, 1538, 1081348, 1540, 1081346, 1081345, 1081344, 1544, 22528, 4194352, 2752512, 131264, 73760, 278784, 1081352,
    1552, 532608, 4194344, 67840, 331776, 4341760, 2105408, 1081360, 4194338, 1310784, 4194336, 4194337, 559104, 2098432, 4194340, 4736,
    1568, 393472, 4194328, 16576, 2637824, 73736, 137216, 1081376, 4194322, 73732, 4194320, 4194321, 73729, 73728, 4194324, 73730,
    4194314, 2134016, 4194312, 4194313, 1048960, 2624, 4194316, 787456, 4194306, 4194307, 4194304, 4194305, 4194310, 73744, 4194308, 4194309,
    1600, 6356992, 788480, 16544, 131208, 528640, 2105360, 1081408, 131204, 1310736, 102400, 8960, 131200, 131201, 131202, 4197376,
    49408, 1310728, 2105348, 136192, 2105346, 2592, 2105344, 2105345, 1310721, 1310720, 4194400, 1310722, 131216, 1310724, 2105352, 606208,
    1060864, 16514, 16513, 16512, 4489216, 2576, 66816, 16516, 2099456, 558080, 4194384, 16520, 131232, 73792, 1573376, 2363392,
    720896, 2564, 4194376, 16528, 2561, 2560, 2105376, 2562, 4194370, 1310752, 4194368, 4194369, 21504, 2568, 4194372, 164096,
    1664, 532496, 2101504, 16480, 131144, 2361344, 4784128, 1081472, 131140, 4227328, 1058816, 328704, 131136, 131137, 131138, 4624,
    532481, 532480, 425984, 532482, 1048864, 532484, 19456, 4616, 2179072, 532488, 4194464, 4612, 131152, 4610, 4609, 4608,
    100352, 16450, 16449, 16448, 1048848, 4199424, 270848, 16452, 790528, 3146240, 4194448, 16456, 131168, 73856, 2130944, 526592,
    1048836, 532512, 4194440, 16464, 1048832, 1048833, 1048834, 2293760, 4194434, 134144, 4194432, 4194433, 1048840, 311296, 4194436, 4640,
    131084, 16418, 16417, 16416, 131080, 131081, 131082, 16420, 131076, 131077, 131078, 16424, 131072, 131073, 131074, 131075,
    4200448, 532544, 1114624, 16432, 131096, 99328, 2105472, 4456704, 131092, 1310848, 525568, 2131968, 131088, 131089, 131090, 4672,
    16387, 16386, 16385, 16384, 131112, 16390, 16389, 16388, 131108, 16394, 16393, 16392, 131104, 131105, 131106, 16396,
    2360320, 16402, 16401, 16400, 1048896, 2688, 561152, 16404, 41472, 69888, 4194496, 16408, 131120, 6815744, 329728, 1057792,
    1792, 393248, 2101376, 67600, 4204544, 528448, 278536, 1081600, 1638400, 4227200, 278532, 8768, 278530, 2098192, 278528, 278529,
    49216, 67586, 67585, 67584, 1048736, 2098184, 655872, 67588, 143360, 2098180, 4194592, 67592, 2098177, 2098176, 278544, 2098178,
    393217, 393216, 565248, 393218, 1048720, 393220, 66624, 6291968, 2099264, 393224, 4194576, 1053696, 37376, 73984, 278560, 526464,
    1048708, 393232, 4194568, 67616, 1048704, 1048705, 1048706, 28672, 4194562, 541184, 4194560, 4194561, 1048712, 2098208, 4194564, 163904,
    49168, 528388, 5373952, 8712, 528385, 528384, 66592, 528386, 2099232, 8706, 8705, 8704, 131456, 528392, 278592, 8708,
    49152, 49153, 49154, 67648, 49156, 528400, 2105600, 4456576, 49160, 1310976, 525440, 8720, 4260352, 2098240, 1054720, 163872,
    2099208, 393280, 66564, 16768, 66562, 528416, 66560, 66561, 2099200, 2099201, 2099202, 8736, 2099204, 5259264, 66568, 163856,
    49184, 4203520, 266752, 3670016, 1048768, 2816, 66576, 163848, 2099216, 69760, 4194624, 163844, 794624, 163842, 163841, 163840,
    2101250, 4227080, 2101248, 2101249, 1048624, 82432, 2101252, 140288, 4227073, 4227072, 2101256, 4227074, 131392, 4227076, 278656, 526368,
    1048612, 532736, 2101264, 67712, 1048608, 1048609, 1048610, 4456512, 264704, 4227088, 525376, 1196032, 1048616, 2098304, 106496, 4864,
    1048596, 393344, 2101280, 16704, 1048592, 1048593, 1048594, 526344, 25600, 4227104, 197120, 526340, 1048600, 526338, 526337, 526336,
    1048580, 1048581, 1048582, 34304, 1048576, 1048577, 1048578, 1048579, 1048588, 69696, 4194688, 2367488, 1048584, 1048585, 1048586, 526352,
    335872, 1051648, 2101312, 16672, 131336, 528512, 35328, 4456464, 131332, 4227136, 525328, 8832, 131328, 131329, 131330, 3211264,
    49280, 2228736, 525320, 4456452, 1048672, 4456450, 4456449, 4456448, 525314, 69664, 525312, 525313, 131344, 26624, 525316, 4456456,
    4719104, 16642, 16641, 16640, 1048656, 2138112, 66688, 16644, 2099328, 69648, 1343488, 16648, 131360, 263680, 4206592, 526400,
    1048644, 69640, 141312, 16656, 1048640, 1048641, 1048642, 4456480, 69633, 69632, 525344, 69634, 1048648, 69636, 2114048, 163968
};

Level2PduParcom::Level2PduParcom(bool oh, int closing_cur):
        iEncTab(NULL),
        iDecTab(NULL)
{
    iBsbuf[0] = iBsbuf[1] = NULL;
    iLogger = PVLogger::GetLoggerObject("3g324m.h223.Level2");
    PVLOGGER_LOGMSG(PVLOGMSG_INST_HLDBG, iLogger, PVLOGMSG_STACK_TRACE, (0, "Level2PduParcom::Level2PduParcom"));
    iPduEndPos = &iPdu[H223_MAX_MUX_PDU_SIZE_LEVEL2-1];
    iPktsInUse = 0;
    iPrevMuxTblNum = 0;
    iPrevPm = 0;
    iCurrentInt32 = 0;
    iCurrentOp = ECopyHdr;
    iOh = oh;
    iUseOh = false;
    iClosingCur = closing_cur;
    iClosingNext = 0;
    iClosingNextRx = 0;
    iMpl = 0;
    iMplRemaining = 0;
    iMuxCode = -1;
    iPduHdrPos = iPduHdr;
    iCnt = 0;
    iRecoverCnt = 0;
    iCurBsBuf =  0;
    iThreshold = LEVEL2_THRESHOLD_SYNC;
    iCopyPduWithSync = false;
    iPduEndPos = iPdu + LEVEL2_MAX_PDU_SZ - 1;

    for (int n  = 0; n <= 0xFF; n++)
    {
        int m = n;
        int cnt = 0;
        while (m)
        {
            if (m & 0x1)
            {
                cnt++;
            }
            m >>= 1;
        }
        iNumOnes[n] = (uint8)cnt;
    }
    uint8 HecCrc[18] =
    {
        0x00, 0x05, 0x07, 0x02, 0x03, 0x06, 0x04, 0x01,
        0x06, 0x03, 0x01, 0x04, 0x05, 0x00, 0x02, 0x07
    };

    oscl_memcpy(iHecCrc, HecCrc, 18);
    ResetStats();
    PVLOGGER_LOGMSG(PVLOGMSG_INST_HLDBG, iLogger, PVLOGMSG_STACK_TRACE, (0, "Level2PduParcom::Level2PduParcom-d"));
}

void
Level2PduParcom::SetClosingCur(int32 closing)
{
    PVLOGGER_LOGMSG(PVLOGMSG_INST_HLDBG, iLogger, PVLOGMSG_STACK_TRACE, (0, "Level2PduParcom::SetClosingCur closing=%d", closing));
    iClosingCur = closing;
}

void
Level2PduParcom::Construct(uint16 max_outstanding_pdus)
{
    iEncTab = (int*)OSCL_DEFAULT_MALLOC(sizeof(enc_tab));
    oscl_memcpy(iEncTab, enc_tab, sizeof(enc_tab));
    iDecTab = (int*)OSCL_DEFAULT_MALLOC(sizeof(dec_tab));
    oscl_memcpy(iDecTab, dec_tab, sizeof(dec_tab));
    PVLOGGER_LOGMSG(PVLOGMSG_INST_HLDBG, iLogger, PVLOGMSG_STACK_TRACE, (0, "Level2PduParcom::Construct - iEncTab/iDecTab created"));

    iBsbuf[0] = (uint8*)OSCL_DEFAULT_MALLOC(H223_MAX_DEMUX_PDU_SIZE * 2);
    iBsbuf[1] = (uint8*)OSCL_DEFAULT_MALLOC(H223_MAX_DEMUX_PDU_SIZE * 2);
    PVLOGGER_LOGMSG(PVLOGMSG_INST_HLDBG, iLogger, PVLOGMSG_STACK_TRACE, (0, "Level2PduParcom::Construct - bsbufs created"));

    iHdrFragmentAlloc.SetLeaveOnAllocFailure(false);
    iHdrFragmentAlloc.size(max_outstanding_pdus, (uint16)H223GetMaxStuffingSz(H223_LEVEL2_OH));
}

void Level2PduParcom::GetHdrFragment(OsclRefCounterMemFrag& frag)
{
    frag = iHdrFragmentAlloc.get();
}

uint32
Level2PduParcom::GetStuffing(uint8* pPdu, uint32 max_size, uint8 mux_code)
{
    int32 stuffing_size = (int32)(iOh ? LEVEL2OH_STUFFING_SZ : LEVEL2_STUFFING_SZ);
    int32 size_left = max_size;
    while (size_left >= stuffing_size)
    {
        PV_STAT_INCR(iNumFlagsTx, 1)
        PV_STAT_INCR(iNumStuffingTx, 1)

        if (iClosingNext)
        {
            *pPdu = 0x1e;
            *(pPdu + 1) = 0xb2;
            iClosingNext = 0;
            PV_STAT_INCR(iNumClosingFlagsTx, 1)
        }
        else
        {
            *pPdu = 0xe1;
            *(pPdu + 1) = 0x4d;
        }
        int code = iEncTab[mux_code];
        *(pPdu + 2) = (uint8)((code >> 12) & 0xff);
        *(pPdu + 3) = (uint8)(((code >> 20) & 0xf) + ((code & 0xf) << 4));
        *(pPdu + 4) = (uint8)((code >> 4) & 0xff);

        if (iOh)
        {
            *(pPdu + 5) = (uint8)((iHecCrc[iPrevMuxTblNum] << 1) | (iPrevMuxTblNum << 4) | iPrevPm);
            iPrevMuxTblNum = mux_code;
            iPrevPm = 0;
        }
        pPdu += stuffing_size;
        size_left -= stuffing_size;
    }

    return (max_size - size_left);
}

PVMFStatus
Level2PduParcom::CompletePdu(OsclSharedPtr<PVMFMediaDataImpl>& pdu, int8 MuxTblNum, uint8 pm)
{
    OsclRefCounterMemFrag frag;
    pdu->getMediaFragment(0, frag);
    pdu->setMediaFragFilledLen(0, GetHeaderSz());

    int32 pdu_size = pdu->getFilledSize() - GetHeaderSz();
    if (pdu_size < 0)
    {
        PVLOGGER_LOGMSG(PVLOGMSG_INST_HLDBG, iLogger, PVLOGMSG_WARNING, (0, "Level2PduParcom::CompletePdu pdu_size=%d", pdu_size));
    }
#if defined(CORRUPT_MT)
    int MuxTblNumSav = MuxTblNum;
    MuxTblNum = 6;
#endif
    // header
    uint8* pPdu = (uint8*)frag.getMemFragPtr();
    OSCL_ASSERT(pPdu);
    PV_STAT_INCR(iNumFlagsTx, 1)
    PV_STAT_INCR(iNumPdusTx, 1)

    if (iClosingNext)
    {
        *pPdu = 0x1e;
        *(pPdu + 1) = 0xb2;
        PV_STAT_INCR(iNumClosingFlagsTx, 1)
    }
    else
    {
        *pPdu = 0xe1;
        *(pPdu + 1) = 0x4d;
    }
    iClosingNext = pm;

    int code;
    code = (pdu_size << 4) + MuxTblNum;
    //OSCL_ASSERT(code < 4096);
    code = iEncTab[code];//GolayEnc(code);
#if defined(CORRUPT_MUXCODE)
    int mask = 0x00;
    for (int num_errors = 0; num_errors < CORRUPT_MUXCODE; num_errors++)
    {
        if ((iRand.Rand() % 2) == 0)
        {
            mask |= (1 << (iRand.Rand() % 24));
        }
    }
    code ^= mask;
#endif
    *(pPdu + 2) = (uint8)((code >> 12) & 0xff);
    *(pPdu + 3) = (uint8)(((code >> 20) & 0xf) + ((code & 0xf) << 4));
    *(pPdu + 4) = (uint8)((code >> 4) & 0xff);
    if (iOh)
    {
        *(pPdu + 5) = (uint8)((iHecCrc[iPrevMuxTblNum] << 1) | (iPrevMuxTblNum << 4) | iPrevPm);
#if defined(CORRUPT_MT)
        MuxTblNum = MuxTblNumSav;
#endif
        iPrevMuxTblNum = MuxTblNum;
        iPrevPm = pm;
    }
    return PVMFSuccess;
}

bool Level2PduParcom::CheckFlag(uint8* buf, int* fClosing, int trsld = 16)
{
    uint16 match_cnt = (uint16)(iNumOnes[(buf[0] ^ 0xE1)]  + iNumOnes[(buf[1] ^ 0x4D)]);
    PV_STAT_INCR_COND(iNumFlagErrorsRx, 1, (match_cnt % 16))

    if (match_cnt >= trsld)
    {
        *fClosing = 1;
        PV_STAT_INCR(iNumClosingFlagsRx, 1)
        PV_STAT_INCR(iCumFlagErrorsRx, (16 - match_cnt))
        return true;
    }
    else if (match_cnt <= (16 - trsld))
    {
        *fClosing = 0;
        PV_STAT_INCR(iCumFlagErrorsRx, match_cnt)
        return true;
    }
    PV_STAT_INCR(iCumFlagErrorsRx, ((match_cnt > 8) ? (16 - match_cnt) : match_cnt))

    return false;
}

/* Set iPduPos, iMpl, iMplRemaining return < 0 if error*/
int Level2PduParcom::ParseHdr(int* fClosing, int* mpl, int* muxCode, int* numErrors, uint8* optional_header)
{
    OSCL_UNUSED_ARG(fClosing);

    int code = 0;
    uint8* pos = iPduHdr + 2;
    oscl_memcpy(iLastHdr, iPduHdr + 2, 3);

    code = (*pos << 12) + ((*(pos + 1) & 0xf) << 20) + (*(pos + 2) << 4)
           + (*(pos + 1) >> 4);
    code = GolayDec(code, numErrors);

    *mpl = (code >> 4);
    *muxCode = code & 0xF;

    if (*mpl >= 255)
    {
        PV_STAT_INCR(iNumPduHdrErrorsMplRx, 1)
        PVLOGGER_LOGMSG(PVLOGMSG_INST_HLDBG, iLogger, PVLOGMSG_WARNING, (0, "Mux[L2]: Bitstream error - mpl > 255\n"));
        *mpl = 0;
        *muxCode = -1;
    }

    if (iOh)
    {
        *optional_header = *(pos + 3);
    }
    return *mpl;
}

uint32 Level2PduParcom::Parse(uint8* buf, uint32 bufsz)
{
    int fClosing = 0, mpl = 0, muxCode = 0, sz = 0;
    uint8* bsbuf = buf;
    int bsbsz = bufsz;
    int num_errors = 0;
    uint8 optional_header = 0;
    unsigned hdr_sz = iOh ? LEVEL2OH_STUFFING_SZ : LEVEL2_STUFFING_SZ;

    while (bsbsz > 0)
    {
        switch (iCurrentOp)
        {
            case ECopyHdr:
                *iPduHdrPos++ = *bsbuf++;
                bsbsz--;
                if (iCopyPduWithSync)
                {
                    CopyOctetToPdu(iPduHdr[0]);
                }
                if ((iPduHdrPos - iPduHdr) == 2)
                {
                    // check for flag
                    iClosingNextRx = 0;
                    if (CheckFlag(iPduHdr, &iClosingNextRx, iThreshold)) // found a flag.
                    {
                        PV_STAT_INCR(iNumFlagsRx, 1)

                        // signal error if sync was lost
                        if (iNumSyncLossRx > SYNC_LOSS_INDICATE_THRESHOLD)
                        {
                            iObserver->MuxPduErrIndicate(EHeaderErr);
                        }
                        iNumSyncLossRx = 0;

                        iThreshold = LEVEL2_THRESHOLD_DATA;
                        if (iCopyPduWithSync)
                        {
                            iCopyPduWithSync = false;
                            iMpl = iPduPos - iPdu - 1;
                        }
                        IndicatePdu(0);
                    }
                    else  // CheckFlag returned FALSE
                    {
                        iThreshold = LEVEL2_THRESHOLD_SYNC;
                        PV_STAT_INCR_COND(iNumSyncLossRx, 1, iNumFlagsRx)
                        IndicatePdu(0);
                        iPduHdr[0] = iPduHdr[1];
                        iPduHdrPos--;
                    }
                }
                if ((unsigned)(iPduHdrPos - iPduHdr) == hdr_sz)
                {

                    OSCL_ASSERT((!iCopyPduWithSync));
                    sz = ParseHdr(&fClosing, &mpl, &muxCode, &num_errors, &optional_header);
                    PV_STAT_INCR_COND(iNumPduHdrErrorRx, 1, num_errors)
                    PV_STAT_INCR(iCumPduHdrErrorRx, num_errors)
                    PV_STAT_INCR_COND(iNumGolayCblePduHdrErrorsRx, 1, (num_errors && (num_errors < 4)))

                    /* Golay can correct upto 3 errors.  Dont bother with optional header if num_errors <= 3. */
                    if (num_errors < 4)
                    {
                        iMpl = mpl;
                        iMuxCode = muxCode;
                    }
                    else if (num_errors == 4)
                    {
                        iUseOh = true;
                    }
                    else
                    {
                        /* Drop the current pdu data and search for sync again */
                        iMpl = 0;
                        iMuxCode = -1;
                        iCurrentOp = ECopyHdr;
                    }
                    ResetPduHdr();

                    PV_STAT_INCR_COND(iNumStuffingRx, 1, (sz == 0))

                    if (iMpl > 0)
                    {
                        iThreshold = LEVEL2_THRESHOLD_DATA;
                        iCurrentOp = ECopyData;
                        iMplRemaining = iMpl;
                    }
                    else if (sz == -1)
                    {
                        iThreshold = LEVEL2_THRESHOLD_SYNC;
                    }
                }
                break;
            case ECopyData:
                OSCL_ASSERT((!iCopyPduWithSync));
                sz = (bsbsz > iMplRemaining) ? iMplRemaining : bsbsz;
                if ((iPduPos + sz - 1) > iPduEndPos)
                {
                    PVLOGGER_LOGMSG(PVLOGMSG_INST_HLDBG, iLogger, PVLOGMSG_WARNING, (0, "Level2PduParcom::Parse Bitstream error - mpl > 255"));
                }
                oscl_memcpy(iPduPos, bsbuf, sz);
                bsbuf += sz;
                iPduPos += sz;
                bsbsz -= sz;
                iMplRemaining -= sz;

                if (iMplRemaining == 0)
                {
                    PV_STAT_INCR(iNumPdusRx, 1)
                    /* pdu is complete. it gets indicated when next hdr is found */
                    iCurrentOp = ECopyHdr;
                }
                break;
        }
    }
    return 1;
}

void Level2PduParcom::IndicatePdu(uint8 optional_header)
{
    OSCL_UNUSED_ARG(optional_header);

    // indicate the pdu
    if (iMpl || (iMuxCode > 0) || iClosingCur)
    {
        iObserver->MuxPduIndicate(iPdu, (uint16)iMpl, iClosingCur, iMuxCode);
    }
    ResetPdu();
    iClosingCur = iClosingNextRx;
    iUseOh = false;
}

uint8* Level2PduParcom::FindSync(uint8* data, int len, int* closing)
{
    uint8* ptr = data;
    if (len < LEVEL2_FLAG_SZ)
    {
        return NULL;
    }
    for (int n1 = 0; n1 <= (len - LEVEL2_FLAG_SZ); n1++)
    {
        if (CheckFlag(ptr, closing, LEVEL2_THRESHOLD_SYNC))
        {
            return ptr;
        }
        ptr++;
    }
    return NULL;
}

bool Level2PduParcom::RecoverPduData(uint8*& bsbuf, int* bsbsz)
{
    bool search_for_sync = false;
    uint8* syncpos = NULL;
    int fClosing = 0;

    if (iMpl)
    {
        iThreshold = LEVEL2_THRESHOLD_SYNC;
        syncpos = FindSync(iPdu, iMpl, &fClosing);
        if (syncpos)
        {
            /* Sync found within PDU */
            int32 bytes_remaining = iMpl;
            /* Adjust mpl and indicate pdu */
            iMpl = syncpos - iPdu;
            iClosingNextRx = fClosing;
            bytes_remaining -= (iMpl + 2);
            IndicatePdu(0);
            /* Add remaining bytes to bsbuf */
            /* Create a buffer comprised of prev mpl data + flag + remaining data from current buffer */
            uint8* from_ptr = syncpos + 2;
            uint8* to_ptr = iBsbuf[iCurBsBuf];
            uint8* to_ptrstart =  to_ptr;
            iCurBsBuf  = (uint8)(1  - iCurBsBuf);
            if (bytes_remaining)
            {
                oscl_memcpy(to_ptr, from_ptr, bytes_remaining);
                to_ptr += bytes_remaining;
            }
            /* Add the 2 flag bytes back to bsbuf */
            oscl_memcpy(to_ptr, iPduHdr, LEVEL2_FLAG_SZ);
            to_ptr += LEVEL2_FLAG_SZ;
            bytes_remaining += LEVEL2_FLAG_SZ;
            oscl_memcpy(iPduHdr, syncpos, LEVEL2_FLAG_SZ);

            if (*bsbsz)
            {
                oscl_memcpy(to_ptr, bsbuf, *bsbsz);
                bytes_remaining += (*bsbsz);
            }
            *bsbsz = bytes_remaining;
            bsbuf = to_ptrstart;
        }
        else /* No sync found within PDU */
        {
            uint8 flag_check[2];
            flag_check[0] = iPdu[iMpl-1];
            flag_check[1] = iPduHdr[0];
            /* Check if there is a flag in the boundary of the pdu and header */
            if (CheckFlag(flag_check, &fClosing, iThreshold))
            {
                iMpl--;
                iClosingNextRx = fClosing;
                IndicatePdu(0);
                char c = iPduHdr[1];
                oscl_memcpy(iPduHdr, flag_check, LEVEL2_FLAG_SZ);
                iPduHdr[LEVEL2_FLAG_SZ] = c;
                iPduHdrPos++;
            }
            else  /* No flag in the boundary */
            {
                search_for_sync = true;
                /* Copy pdu data along with search for sync */
                iCopyPduWithSync = true;
            }
        }/* check for sync within PDU */
    }
    else  /* iMpl == 0 */
    {
        search_for_sync = true;
    }
    if (iCopyPduWithSync)
    {
        /* Copy invalid flags to pdu data */
        CopyOctetToPdu(iPduHdr[0]);
    }
    return search_for_sync;
}

void H223PduParcomBase::ResetStats()
{
    // Outgoing
    iNumFlagsTx = 0;
    iNumStuffingTx = 0;
    iNumPdusTx = 0;

    // Incoming
    iNumFlagsRx = 0;
    iNumStuffingRx = 0;
    iNumPdusRx = 0;
    iNumPmRx = 0;

    iNumFlagErrorsRx = 0;
    iCumFlagErrorsRx = 0;
    iNumSyncLossRx = 0;
    iNumBytesLossRx = 0;
    iNumPduHdrErrorRx = 0;
    iCumPduHdrErrorRx = 0;
}

void H223PduParcomBase::LogStats(TPVDirection dir)
{
    if (iLogger == NULL)
        return;
    if (dir & OUTGOING)
    {
        PVLOGGER_LOGMSG(PVLOGMSG_INST_HLDBG, iLogger, PVLOGMSG_STACK_TRACE, (0, "Mux-pdu(O) Statistics:\n"));
        PVLOGGER_LOGMSG(PVLOGMSG_INST_HLDBG, iLogger, PVLOGMSG_STACK_TRACE, (0, "Num flags tx - %d\n", iNumFlagsTx));
        PVLOGGER_LOGMSG(PVLOGMSG_INST_HLDBG, iLogger, PVLOGMSG_STACK_TRACE, (0, "Num stuffing tx - %d\n", iNumStuffingTx));
        PVLOGGER_LOGMSG(PVLOGMSG_INST_HLDBG, iLogger, PVLOGMSG_STACK_TRACE, (0, "Num pdus tx - %d\n", iNumPdusTx));
    }

    if (dir & INCOMING)
    {
        PVLOGGER_LOGMSG(PVLOGMSG_INST_HLDBG, iLogger, PVLOGMSG_STACK_TRACE, (0, "Mux-pdu(I) Statistics:\n"));
        PVLOGGER_LOGMSG(PVLOGMSG_INST_HLDBG, iLogger, PVLOGMSG_STACK_TRACE, (0, "Num flags rx - %d\n", iNumFlagsRx));
        PVLOGGER_LOGMSG(PVLOGMSG_INST_HLDBG, iLogger, PVLOGMSG_STACK_TRACE, (0, "Num stuffing rx - %d\n", iNumStuffingRx));
        PVLOGGER_LOGMSG(PVLOGMSG_INST_HLDBG, iLogger, PVLOGMSG_STACK_TRACE, (0, "Num pdus rx - %d\n", iNumPdusRx));
        PVLOGGER_LOGMSG(PVLOGMSG_INST_HLDBG, iLogger, PVLOGMSG_STACK_TRACE, (0, "Num pm rx - %d\n", iNumPmRx));
        PVLOGGER_LOGMSG(PVLOGMSG_INST_HLDBG, iLogger, PVLOGMSG_STACK_TRACE, (0, "Num flag errors rx - %d\n", iNumFlagErrorsRx));
        PVLOGGER_LOGMSG(PVLOGMSG_INST_HLDBG, iLogger, PVLOGMSG_STACK_TRACE, (0, "Cum flag errors rx - %d\n", iCumFlagErrorsRx));
        PVLOGGER_LOGMSG(PVLOGMSG_INST_HLDBG, iLogger, PVLOGMSG_STACK_TRACE, (0, "Num sync loss rx - %d\n", iNumSyncLossRx));
        PVLOGGER_LOGMSG(PVLOGMSG_INST_HLDBG, iLogger, PVLOGMSG_STACK_TRACE, (0, "Num bytes loss rx - %d\n", iNumBytesLossRx));
        PVLOGGER_LOGMSG(PVLOGMSG_INST_HLDBG, iLogger, PVLOGMSG_STACK_TRACE, (0, "Num pdu hdr errors rx - %d\n", iNumPduHdrErrorRx));
        PVLOGGER_LOGMSG(PVLOGMSG_INST_HLDBG, iLogger, PVLOGMSG_STACK_TRACE, (0, "Cum pdu hdr errors rx - %d\n", iCumPduHdrErrorRx));
    }
}

void Level2PduParcom::ResetStats()
{
    H223PduParcomBase::ResetStats();

    // Outgoing
    iNumClosingFlagsTx = 0;
    iNumFlagEmulation = 0;

    // Incoming
    iNumClosingFlagsRx = 0;
    iNumGolayCblePduHdrErrorsRx = 0;
    iNumPduHdrErrorsMplRx = 0;
    iNumCorruptedOhRx = 0;
    iNumHeadersCorrectedByOh = 0;
}

void Level2PduParcom::LogStats(TPVDirection dir)
{
    if (dir & OUTGOING)
    {
        H223PduParcomBase::LogStats(OUTGOING);
        PVLOGGER_LOGMSG(PVLOGMSG_INST_HLDBG, iLogger, PVLOGMSG_STACK_TRACE, (0, "Level 2 Mux Statistics:\n"));
        PVLOGGER_LOGMSG(PVLOGMSG_INST_HLDBG, iLogger, PVLOGMSG_STACK_TRACE, (0, "Num closing flags tx - %d\n", iNumClosingFlagsTx));
        PVLOGGER_LOGMSG(PVLOGMSG_INST_HLDBG, iLogger, PVLOGMSG_STACK_TRACE, (0, "Num flag emulation with threshold (%d) in tx bitstream - %d\n", LEVEL2_THRESHOLD_SYNC, iNumFlagEmulation));
    }
    if (dir & INCOMING)
    {
        H223PduParcomBase::LogStats(INCOMING);
        PVLOGGER_LOGMSG(PVLOGMSG_INST_HLDBG, iLogger, PVLOGMSG_STACK_TRACE, (0, "Level 2 Demux Statistics:\n"));
        PVLOGGER_LOGMSG(PVLOGMSG_INST_HLDBG, iLogger, PVLOGMSG_STACK_TRACE, (0, "Num closing flags rx - %d\n", iNumClosingFlagsRx));
        PVLOGGER_LOGMSG(PVLOGMSG_INST_HLDBG, iLogger, PVLOGMSG_STACK_TRACE, (0, "Num golay correctable hdr errors rx - %d\n", iNumGolayCblePduHdrErrorsRx));
        PVLOGGER_LOGMSG(PVLOGMSG_INST_HLDBG, iLogger, PVLOGMSG_STACK_TRACE, (0, "Num errors in mpl rx - %d\n", iNumPduHdrErrorsMplRx));
        PVLOGGER_LOGMSG(PVLOGMSG_INST_HLDBG, iLogger, PVLOGMSG_STACK_TRACE, (0, "Num corrupted OH rx - %d\n", iNumCorruptedOhRx));
        PVLOGGER_LOGMSG(PVLOGMSG_INST_HLDBG, iLogger, PVLOGMSG_STACK_TRACE, (0, "Num headers corrected using OH - %d\n", iNumHeadersCorrectedByOh));
    }
}
