#
# Copyright (C) 2011 Intel Corporation
# Copyright (C) 2010-2011 Chia-I Wu <olvaffe@gmail.com>
# Copyright (C) 2010-2011 LunarG
#
# Permission is hereby granted, free of charge, to any person obtaining a
# copy of this software and associated documentation files (the "Software"),
# to deal in the Software without restriction, including without limitation
# the rights to use, copy, modify, merge, publish, distribute, sublicense,
# and/or sell copies of the Software, and to permit persons to whom the
# Software is furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included
# in all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
# THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
# FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
# DEALINGS IN THE SOFTWARE.
#

LOCAL_PATH := $(call my-dir)
include $(CLEAR_VARS)

LOCAL_MODULE := i915_dri
LOCAL_MODULE_PATH := $(MESA_DRI_MODULE_PATH)
LOCAL_UNSTRIPPED_PATH := $(MESA_DRI_MODULE_UNSTRIPPED_PATH)

# Import variables i915_*.
include $(LOCAL_PATH)/Makefile.sources

# Overriding LOCAL_CC below is an ugly workaround.  We cannot place -std=c99
# in LOCAL_C_FLAGS because Android appends LOCAL_C_FLAGS to LOCAL_CPP_FLAGS.
LOCAL_CC := $(TARGET_CC) -std=c99

LOCAL_CFLAGS := \
	$(MESA_DRI_CFLAGS) \
	-DI915

LOCAL_C_INCLUDES := \
	$(addprefix $(MESA_TOP)/,$(i915_INCLUDES)) \
	$(MESA_DRI_C_INCLUDES) \
	$(DRM_TOP)/intel

LOCAL_SRC_FILES := \
	$(i915_C_SOURCES)

LOCAL_WHOLE_STATIC_LIBRARIES := \
	$(MESA_DRI_WHOLE_STATIC_LIBRARIES)

LOCAL_SHARED_LIBRARIES := \
	$(MESA_DRI_SHARED_LIBRARIES) \
	libdrm_intel

include $(MESA_COMMON_MK)
include $(BUILD_SHARED_LIBRARY)
