#include "intel_context.h"
#include "intel_tex.h"
#include "main/enums.h"
#include "main/formats.h"

/**
 * Returns the renderbuffer DataType for a MESA_FORMAT.
 */
GLenum
intel_mesa_format_to_rb_datatype(gl_format format)
{
   switch (format) {
   case MESA_FORMAT_ARGB8888:
   case MESA_FORMAT_XRGB8888:
   case MESA_FORMAT_SARGB8:
   case MESA_FORMAT_R8:
   case MESA_FORMAT_RG88:
   case MESA_FORMAT_A8:
   case MESA_FORMAT_AL88:
   case MESA_FORMAT_RGB565:
   case MESA_FORMAT_ARGB1555:
   case MESA_FORMAT_ARGB4444:
      return GL_UNSIGNED_BYTE;
   case MESA_FORMAT_R16:
   case MESA_FORMAT_RG1616:
   case MESA_FORMAT_Z16:
      return GL_UNSIGNED_SHORT;
   case MESA_FORMAT_X8_Z24:
      return GL_UNSIGNED_INT;
   case MESA_FORMAT_S8_Z24:
      return GL_UNSIGNED_INT_24_8_EXT;
   default:
      _mesa_problem(NULL, "unexpected MESA_FORMAT for renderbuffer");
      return GL_UNSIGNED_BYTE;
   }
}

int intel_compressed_num_bytes(GLuint mesaFormat)
{
   GLuint bw, bh;
   GLuint block_size;

   block_size = _mesa_get_format_bytes(mesaFormat);
   _mesa_get_format_block_size(mesaFormat, &bw, &bh);

   return block_size / bw;
}
