; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=i686-apple-darwin -mattr=avx2 | FileCheck %s --check-prefix=AVX2
; RUN: llc < %s -mtriple=i686-apple-darwin -mattr=avx512vl | FileCheck %s --check-prefix=AVX512VL

define <16 x i16> @test_x86_avx2_packssdw(<8 x i32> %a0, <8 x i32> %a1) {
; AVX2-LABEL: test_x86_avx2_packssdw:
; AVX2:       ## BB#0:
; AVX2-NEXT:    vpackssdw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_avx2_packssdw:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vpackssdw %ymm1, %ymm0, %ymm0
; AVX512VL-NEXT:    retl
  %res = call <16 x i16> @llvm.x86.avx2.packssdw(<8 x i32> %a0, <8 x i32> %a1) ; <<16 x i16>> [#uses=1]
  ret <16 x i16> %res
}
declare <16 x i16> @llvm.x86.avx2.packssdw(<8 x i32>, <8 x i32>) nounwind readnone


define <32 x i8> @test_x86_avx2_packsswb(<16 x i16> %a0, <16 x i16> %a1) {
; AVX2-LABEL: test_x86_avx2_packsswb:
; AVX2:       ## BB#0:
; AVX2-NEXT:    vpacksswb %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_avx2_packsswb:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vpacksswb %ymm1, %ymm0, %ymm0
; AVX512VL-NEXT:    retl
  %res = call <32 x i8> @llvm.x86.avx2.packsswb(<16 x i16> %a0, <16 x i16> %a1) ; <<32 x i8>> [#uses=1]
  ret <32 x i8> %res
}
declare <32 x i8> @llvm.x86.avx2.packsswb(<16 x i16>, <16 x i16>) nounwind readnone


define <32 x i8> @test_x86_avx2_packuswb(<16 x i16> %a0, <16 x i16> %a1) {
; AVX2-LABEL: test_x86_avx2_packuswb:
; AVX2:       ## BB#0:
; AVX2-NEXT:    vpackuswb %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_avx2_packuswb:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vpackuswb %ymm1, %ymm0, %ymm0
; AVX512VL-NEXT:    retl
  %res = call <32 x i8> @llvm.x86.avx2.packuswb(<16 x i16> %a0, <16 x i16> %a1) ; <<32 x i8>> [#uses=1]
  ret <32 x i8> %res
}
declare <32 x i8> @llvm.x86.avx2.packuswb(<16 x i16>, <16 x i16>) nounwind readnone


define <32 x i8> @test_x86_avx2_padds_b(<32 x i8> %a0, <32 x i8> %a1) {
; AVX2-LABEL: test_x86_avx2_padds_b:
; AVX2:       ## BB#0:
; AVX2-NEXT:    vpaddsb %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_avx2_padds_b:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vpaddsb %ymm1, %ymm0, %ymm0
; AVX512VL-NEXT:    retl
  %res = call <32 x i8> @llvm.x86.avx2.padds.b(<32 x i8> %a0, <32 x i8> %a1) ; <<32 x i8>> [#uses=1]
  ret <32 x i8> %res
}
declare <32 x i8> @llvm.x86.avx2.padds.b(<32 x i8>, <32 x i8>) nounwind readnone


define <16 x i16> @test_x86_avx2_padds_w(<16 x i16> %a0, <16 x i16> %a1) {
; AVX2-LABEL: test_x86_avx2_padds_w:
; AVX2:       ## BB#0:
; AVX2-NEXT:    vpaddsw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_avx2_padds_w:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vpaddsw %ymm1, %ymm0, %ymm0
; AVX512VL-NEXT:    retl
  %res = call <16 x i16> @llvm.x86.avx2.padds.w(<16 x i16> %a0, <16 x i16> %a1) ; <<16 x i16>> [#uses=1]
  ret <16 x i16> %res
}
declare <16 x i16> @llvm.x86.avx2.padds.w(<16 x i16>, <16 x i16>) nounwind readnone


define <32 x i8> @test_x86_avx2_paddus_b(<32 x i8> %a0, <32 x i8> %a1) {
; AVX2-LABEL: test_x86_avx2_paddus_b:
; AVX2:       ## BB#0:
; AVX2-NEXT:    vpaddusb %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_avx2_paddus_b:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vpaddusb %ymm1, %ymm0, %ymm0
; AVX512VL-NEXT:    retl
  %res = call <32 x i8> @llvm.x86.avx2.paddus.b(<32 x i8> %a0, <32 x i8> %a1) ; <<32 x i8>> [#uses=1]
  ret <32 x i8> %res
}
declare <32 x i8> @llvm.x86.avx2.paddus.b(<32 x i8>, <32 x i8>) nounwind readnone


define <16 x i16> @test_x86_avx2_paddus_w(<16 x i16> %a0, <16 x i16> %a1) {
; AVX2-LABEL: test_x86_avx2_paddus_w:
; AVX2:       ## BB#0:
; AVX2-NEXT:    vpaddusw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_avx2_paddus_w:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vpaddusw %ymm1, %ymm0, %ymm0
; AVX512VL-NEXT:    retl
  %res = call <16 x i16> @llvm.x86.avx2.paddus.w(<16 x i16> %a0, <16 x i16> %a1) ; <<16 x i16>> [#uses=1]
  ret <16 x i16> %res
}
declare <16 x i16> @llvm.x86.avx2.paddus.w(<16 x i16>, <16 x i16>) nounwind readnone


define <32 x i8> @test_x86_avx2_pavg_b(<32 x i8> %a0, <32 x i8> %a1) {
; AVX2-LABEL: test_x86_avx2_pavg_b:
; AVX2:       ## BB#0:
; AVX2-NEXT:    vpavgb %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_avx2_pavg_b:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vpavgb %ymm1, %ymm0, %ymm0
; AVX512VL-NEXT:    retl
  %res = call <32 x i8> @llvm.x86.avx2.pavg.b(<32 x i8> %a0, <32 x i8> %a1) ; <<32 x i8>> [#uses=1]
  ret <32 x i8> %res
}
declare <32 x i8> @llvm.x86.avx2.pavg.b(<32 x i8>, <32 x i8>) nounwind readnone


define <16 x i16> @test_x86_avx2_pavg_w(<16 x i16> %a0, <16 x i16> %a1) {
; AVX2-LABEL: test_x86_avx2_pavg_w:
; AVX2:       ## BB#0:
; AVX2-NEXT:    vpavgw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_avx2_pavg_w:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vpavgw %ymm1, %ymm0, %ymm0
; AVX512VL-NEXT:    retl
  %res = call <16 x i16> @llvm.x86.avx2.pavg.w(<16 x i16> %a0, <16 x i16> %a1) ; <<16 x i16>> [#uses=1]
  ret <16 x i16> %res
}
declare <16 x i16> @llvm.x86.avx2.pavg.w(<16 x i16>, <16 x i16>) nounwind readnone


define <8 x i32> @test_x86_avx2_pmadd_wd(<16 x i16> %a0, <16 x i16> %a1) {
; AVX2-LABEL: test_x86_avx2_pmadd_wd:
; AVX2:       ## BB#0:
; AVX2-NEXT:    vpmaddwd %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_avx2_pmadd_wd:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vpmaddwd %ymm1, %ymm0, %ymm0
; AVX512VL-NEXT:    retl
  %res = call <8 x i32> @llvm.x86.avx2.pmadd.wd(<16 x i16> %a0, <16 x i16> %a1) ; <<8 x i32>> [#uses=1]
  ret <8 x i32> %res
}
declare <8 x i32> @llvm.x86.avx2.pmadd.wd(<16 x i16>, <16 x i16>) nounwind readnone


define <16 x i16> @test_x86_avx2_pmaxs_w(<16 x i16> %a0, <16 x i16> %a1) {
; AVX2-LABEL: test_x86_avx2_pmaxs_w:
; AVX2:       ## BB#0:
; AVX2-NEXT:    vpmaxsw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_avx2_pmaxs_w:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vpmaxsw %ymm1, %ymm0, %ymm0
; AVX512VL-NEXT:    retl
  %res = call <16 x i16> @llvm.x86.avx2.pmaxs.w(<16 x i16> %a0, <16 x i16> %a1) ; <<16 x i16>> [#uses=1]
  ret <16 x i16> %res
}
declare <16 x i16> @llvm.x86.avx2.pmaxs.w(<16 x i16>, <16 x i16>) nounwind readnone


define <32 x i8> @test_x86_avx2_pmaxu_b(<32 x i8> %a0, <32 x i8> %a1) {
; AVX2-LABEL: test_x86_avx2_pmaxu_b:
; AVX2:       ## BB#0:
; AVX2-NEXT:    vpmaxub %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_avx2_pmaxu_b:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vpmaxub %ymm1, %ymm0, %ymm0
; AVX512VL-NEXT:    retl
  %res = call <32 x i8> @llvm.x86.avx2.pmaxu.b(<32 x i8> %a0, <32 x i8> %a1) ; <<32 x i8>> [#uses=1]
  ret <32 x i8> %res
}
declare <32 x i8> @llvm.x86.avx2.pmaxu.b(<32 x i8>, <32 x i8>) nounwind readnone


define <16 x i16> @test_x86_avx2_pmins_w(<16 x i16> %a0, <16 x i16> %a1) {
; AVX2-LABEL: test_x86_avx2_pmins_w:
; AVX2:       ## BB#0:
; AVX2-NEXT:    vpminsw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_avx2_pmins_w:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vpminsw %ymm1, %ymm0, %ymm0
; AVX512VL-NEXT:    retl
  %res = call <16 x i16> @llvm.x86.avx2.pmins.w(<16 x i16> %a0, <16 x i16> %a1) ; <<16 x i16>> [#uses=1]
  ret <16 x i16> %res
}
declare <16 x i16> @llvm.x86.avx2.pmins.w(<16 x i16>, <16 x i16>) nounwind readnone


define <32 x i8> @test_x86_avx2_pminu_b(<32 x i8> %a0, <32 x i8> %a1) {
; AVX2-LABEL: test_x86_avx2_pminu_b:
; AVX2:       ## BB#0:
; AVX2-NEXT:    vpminub %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_avx2_pminu_b:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vpminub %ymm1, %ymm0, %ymm0
; AVX512VL-NEXT:    retl
  %res = call <32 x i8> @llvm.x86.avx2.pminu.b(<32 x i8> %a0, <32 x i8> %a1) ; <<32 x i8>> [#uses=1]
  ret <32 x i8> %res
}
declare <32 x i8> @llvm.x86.avx2.pminu.b(<32 x i8>, <32 x i8>) nounwind readnone


define i32 @test_x86_avx2_pmovmskb(<32 x i8> %a0) {
; AVX2-LABEL: test_x86_avx2_pmovmskb:
; AVX2:       ## BB#0:
; AVX2-NEXT:    vpmovmskb %ymm0, %eax
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_avx2_pmovmskb:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vpmovmskb %ymm0, %eax
; AVX512VL-NEXT:    retl
  %res = call i32 @llvm.x86.avx2.pmovmskb(<32 x i8> %a0) ; <i32> [#uses=1]
  ret i32 %res
}
declare i32 @llvm.x86.avx2.pmovmskb(<32 x i8>) nounwind readnone


define <16 x i16> @test_x86_avx2_pmulh_w(<16 x i16> %a0, <16 x i16> %a1) {
; AVX2-LABEL: test_x86_avx2_pmulh_w:
; AVX2:       ## BB#0:
; AVX2-NEXT:    vpmulhw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_avx2_pmulh_w:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vpmulhw %ymm1, %ymm0, %ymm0
; AVX512VL-NEXT:    retl
  %res = call <16 x i16> @llvm.x86.avx2.pmulh.w(<16 x i16> %a0, <16 x i16> %a1) ; <<16 x i16>> [#uses=1]
  ret <16 x i16> %res
}
declare <16 x i16> @llvm.x86.avx2.pmulh.w(<16 x i16>, <16 x i16>) nounwind readnone


define <16 x i16> @test_x86_avx2_pmulhu_w(<16 x i16> %a0, <16 x i16> %a1) {
; AVX2-LABEL: test_x86_avx2_pmulhu_w:
; AVX2:       ## BB#0:
; AVX2-NEXT:    vpmulhuw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_avx2_pmulhu_w:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vpmulhuw %ymm1, %ymm0, %ymm0
; AVX512VL-NEXT:    retl
  %res = call <16 x i16> @llvm.x86.avx2.pmulhu.w(<16 x i16> %a0, <16 x i16> %a1) ; <<16 x i16>> [#uses=1]
  ret <16 x i16> %res
}
declare <16 x i16> @llvm.x86.avx2.pmulhu.w(<16 x i16>, <16 x i16>) nounwind readnone


define <4 x i64> @test_x86_avx2_pmulu_dq(<8 x i32> %a0, <8 x i32> %a1) {
; AVX2-LABEL: test_x86_avx2_pmulu_dq:
; AVX2:       ## BB#0:
; AVX2-NEXT:    vpmuludq %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_avx2_pmulu_dq:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vpmuludq %ymm1, %ymm0, %ymm0
; AVX512VL-NEXT:    retl
  %res = call <4 x i64> @llvm.x86.avx2.pmulu.dq(<8 x i32> %a0, <8 x i32> %a1) ; <<4 x i64>> [#uses=1]
  ret <4 x i64> %res
}
declare <4 x i64> @llvm.x86.avx2.pmulu.dq(<8 x i32>, <8 x i32>) nounwind readnone


define <4 x i64> @test_x86_avx2_psad_bw(<32 x i8> %a0, <32 x i8> %a1) {
; AVX2-LABEL: test_x86_avx2_psad_bw:
; AVX2:       ## BB#0:
; AVX2-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_avx2_psad_bw:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; AVX512VL-NEXT:    retl
  %res = call <4 x i64> @llvm.x86.avx2.psad.bw(<32 x i8> %a0, <32 x i8> %a1) ; <<4 x i64>> [#uses=1]
  ret <4 x i64> %res
}
declare <4 x i64> @llvm.x86.avx2.psad.bw(<32 x i8>, <32 x i8>) nounwind readnone


define <8 x i32> @test_x86_avx2_psll_d(<8 x i32> %a0, <4 x i32> %a1) {
; AVX2-LABEL: test_x86_avx2_psll_d:
; AVX2:       ## BB#0:
; AVX2-NEXT:    vpslld %xmm1, %ymm0, %ymm0
; AVX2-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_avx2_psll_d:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vpslld %xmm1, %ymm0, %ymm0
; AVX512VL-NEXT:    retl
  %res = call <8 x i32> @llvm.x86.avx2.psll.d(<8 x i32> %a0, <4 x i32> %a1) ; <<8 x i32>> [#uses=1]
  ret <8 x i32> %res
}
declare <8 x i32> @llvm.x86.avx2.psll.d(<8 x i32>, <4 x i32>) nounwind readnone


define <4 x i64> @test_x86_avx2_psll_q(<4 x i64> %a0, <2 x i64> %a1) {
; AVX2-LABEL: test_x86_avx2_psll_q:
; AVX2:       ## BB#0:
; AVX2-NEXT:    vpsllq %xmm1, %ymm0, %ymm0
; AVX2-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_avx2_psll_q:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vpsllq %xmm1, %ymm0, %ymm0
; AVX512VL-NEXT:    retl
  %res = call <4 x i64> @llvm.x86.avx2.psll.q(<4 x i64> %a0, <2 x i64> %a1) ; <<4 x i64>> [#uses=1]
  ret <4 x i64> %res
}
declare <4 x i64> @llvm.x86.avx2.psll.q(<4 x i64>, <2 x i64>) nounwind readnone


define <16 x i16> @test_x86_avx2_psll_w(<16 x i16> %a0, <8 x i16> %a1) {
; AVX2-LABEL: test_x86_avx2_psll_w:
; AVX2:       ## BB#0:
; AVX2-NEXT:    vpsllw %xmm1, %ymm0, %ymm0
; AVX2-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_avx2_psll_w:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vpsllw %xmm1, %ymm0, %ymm0
; AVX512VL-NEXT:    retl
  %res = call <16 x i16> @llvm.x86.avx2.psll.w(<16 x i16> %a0, <8 x i16> %a1) ; <<16 x i16>> [#uses=1]
  ret <16 x i16> %res
}
declare <16 x i16> @llvm.x86.avx2.psll.w(<16 x i16>, <8 x i16>) nounwind readnone


define <8 x i32> @test_x86_avx2_pslli_d(<8 x i32> %a0) {
; AVX2-LABEL: test_x86_avx2_pslli_d:
; AVX2:       ## BB#0:
; AVX2-NEXT:    vpslld $7, %ymm0, %ymm0
; AVX2-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_avx2_pslli_d:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vpslld $7, %ymm0, %ymm0
; AVX512VL-NEXT:    retl
  %res = call <8 x i32> @llvm.x86.avx2.pslli.d(<8 x i32> %a0, i32 7) ; <<8 x i32>> [#uses=1]
  ret <8 x i32> %res
}
declare <8 x i32> @llvm.x86.avx2.pslli.d(<8 x i32>, i32) nounwind readnone


define <4 x i64> @test_x86_avx2_pslli_q(<4 x i64> %a0) {
; AVX2-LABEL: test_x86_avx2_pslli_q:
; AVX2:       ## BB#0:
; AVX2-NEXT:    vpsllq $7, %ymm0, %ymm0
; AVX2-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_avx2_pslli_q:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vpsllq $7, %ymm0, %ymm0
; AVX512VL-NEXT:    retl
  %res = call <4 x i64> @llvm.x86.avx2.pslli.q(<4 x i64> %a0, i32 7) ; <<4 x i64>> [#uses=1]
  ret <4 x i64> %res
}
declare <4 x i64> @llvm.x86.avx2.pslli.q(<4 x i64>, i32) nounwind readnone


define <16 x i16> @test_x86_avx2_pslli_w(<16 x i16> %a0) {
; AVX2-LABEL: test_x86_avx2_pslli_w:
; AVX2:       ## BB#0:
; AVX2-NEXT:    vpsllw $7, %ymm0, %ymm0
; AVX2-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_avx2_pslli_w:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vpsllw $7, %ymm0, %ymm0
; AVX512VL-NEXT:    retl
  %res = call <16 x i16> @llvm.x86.avx2.pslli.w(<16 x i16> %a0, i32 7) ; <<16 x i16>> [#uses=1]
  ret <16 x i16> %res
}
declare <16 x i16> @llvm.x86.avx2.pslli.w(<16 x i16>, i32) nounwind readnone


define <8 x i32> @test_x86_avx2_psra_d(<8 x i32> %a0, <4 x i32> %a1) {
; AVX2-LABEL: test_x86_avx2_psra_d:
; AVX2:       ## BB#0:
; AVX2-NEXT:    vpsrad %xmm1, %ymm0, %ymm0
; AVX2-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_avx2_psra_d:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vpsrad %xmm1, %ymm0, %ymm0
; AVX512VL-NEXT:    retl
  %res = call <8 x i32> @llvm.x86.avx2.psra.d(<8 x i32> %a0, <4 x i32> %a1) ; <<8 x i32>> [#uses=1]
  ret <8 x i32> %res
}
declare <8 x i32> @llvm.x86.avx2.psra.d(<8 x i32>, <4 x i32>) nounwind readnone


define <16 x i16> @test_x86_avx2_psra_w(<16 x i16> %a0, <8 x i16> %a1) {
; AVX2-LABEL: test_x86_avx2_psra_w:
; AVX2:       ## BB#0:
; AVX2-NEXT:    vpsraw %xmm1, %ymm0, %ymm0
; AVX2-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_avx2_psra_w:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vpsraw %xmm1, %ymm0, %ymm0
; AVX512VL-NEXT:    retl
  %res = call <16 x i16> @llvm.x86.avx2.psra.w(<16 x i16> %a0, <8 x i16> %a1) ; <<16 x i16>> [#uses=1]
  ret <16 x i16> %res
}
declare <16 x i16> @llvm.x86.avx2.psra.w(<16 x i16>, <8 x i16>) nounwind readnone


define <8 x i32> @test_x86_avx2_psrai_d(<8 x i32> %a0) {
; AVX2-LABEL: test_x86_avx2_psrai_d:
; AVX2:       ## BB#0:
; AVX2-NEXT:    vpsrad $7, %ymm0, %ymm0
; AVX2-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_avx2_psrai_d:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vpsrad $7, %ymm0, %ymm0
; AVX512VL-NEXT:    retl
  %res = call <8 x i32> @llvm.x86.avx2.psrai.d(<8 x i32> %a0, i32 7) ; <<8 x i32>> [#uses=1]
  ret <8 x i32> %res
}
declare <8 x i32> @llvm.x86.avx2.psrai.d(<8 x i32>, i32) nounwind readnone


define <16 x i16> @test_x86_avx2_psrai_w(<16 x i16> %a0) {
; AVX2-LABEL: test_x86_avx2_psrai_w:
; AVX2:       ## BB#0:
; AVX2-NEXT:    vpsraw $7, %ymm0, %ymm0
; AVX2-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_avx2_psrai_w:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vpsraw $7, %ymm0, %ymm0
; AVX512VL-NEXT:    retl
  %res = call <16 x i16> @llvm.x86.avx2.psrai.w(<16 x i16> %a0, i32 7) ; <<16 x i16>> [#uses=1]
  ret <16 x i16> %res
}
declare <16 x i16> @llvm.x86.avx2.psrai.w(<16 x i16>, i32) nounwind readnone


define <8 x i32> @test_x86_avx2_psrl_d(<8 x i32> %a0, <4 x i32> %a1) {
; AVX2-LABEL: test_x86_avx2_psrl_d:
; AVX2:       ## BB#0:
; AVX2-NEXT:    vpsrld %xmm1, %ymm0, %ymm0
; AVX2-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_avx2_psrl_d:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vpsrld %xmm1, %ymm0, %ymm0
; AVX512VL-NEXT:    retl
  %res = call <8 x i32> @llvm.x86.avx2.psrl.d(<8 x i32> %a0, <4 x i32> %a1) ; <<8 x i32>> [#uses=1]
  ret <8 x i32> %res
}
declare <8 x i32> @llvm.x86.avx2.psrl.d(<8 x i32>, <4 x i32>) nounwind readnone


define <4 x i64> @test_x86_avx2_psrl_q(<4 x i64> %a0, <2 x i64> %a1) {
; AVX2-LABEL: test_x86_avx2_psrl_q:
; AVX2:       ## BB#0:
; AVX2-NEXT:    vpsrlq %xmm1, %ymm0, %ymm0
; AVX2-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_avx2_psrl_q:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vpsrlq %xmm1, %ymm0, %ymm0
; AVX512VL-NEXT:    retl
  %res = call <4 x i64> @llvm.x86.avx2.psrl.q(<4 x i64> %a0, <2 x i64> %a1) ; <<4 x i64>> [#uses=1]
  ret <4 x i64> %res
}
declare <4 x i64> @llvm.x86.avx2.psrl.q(<4 x i64>, <2 x i64>) nounwind readnone


define <16 x i16> @test_x86_avx2_psrl_w(<16 x i16> %a0, <8 x i16> %a1) {
; AVX2-LABEL: test_x86_avx2_psrl_w:
; AVX2:       ## BB#0:
; AVX2-NEXT:    vpsrlw %xmm1, %ymm0, %ymm0
; AVX2-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_avx2_psrl_w:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vpsrlw %xmm1, %ymm0, %ymm0
; AVX512VL-NEXT:    retl
  %res = call <16 x i16> @llvm.x86.avx2.psrl.w(<16 x i16> %a0, <8 x i16> %a1) ; <<16 x i16>> [#uses=1]
  ret <16 x i16> %res
}
declare <16 x i16> @llvm.x86.avx2.psrl.w(<16 x i16>, <8 x i16>) nounwind readnone


define <8 x i32> @test_x86_avx2_psrli_d(<8 x i32> %a0) {
; AVX2-LABEL: test_x86_avx2_psrli_d:
; AVX2:       ## BB#0:
; AVX2-NEXT:    vpsrld $7, %ymm0, %ymm0
; AVX2-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_avx2_psrli_d:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vpsrld $7, %ymm0, %ymm0
; AVX512VL-NEXT:    retl
  %res = call <8 x i32> @llvm.x86.avx2.psrli.d(<8 x i32> %a0, i32 7) ; <<8 x i32>> [#uses=1]
  ret <8 x i32> %res
}
declare <8 x i32> @llvm.x86.avx2.psrli.d(<8 x i32>, i32) nounwind readnone


define <4 x i64> @test_x86_avx2_psrli_q(<4 x i64> %a0) {
; AVX2-LABEL: test_x86_avx2_psrli_q:
; AVX2:       ## BB#0:
; AVX2-NEXT:    vpsrlq $7, %ymm0, %ymm0
; AVX2-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_avx2_psrli_q:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vpsrlq $7, %ymm0, %ymm0
; AVX512VL-NEXT:    retl
  %res = call <4 x i64> @llvm.x86.avx2.psrli.q(<4 x i64> %a0, i32 7) ; <<4 x i64>> [#uses=1]
  ret <4 x i64> %res
}
declare <4 x i64> @llvm.x86.avx2.psrli.q(<4 x i64>, i32) nounwind readnone


define <16 x i16> @test_x86_avx2_psrli_w(<16 x i16> %a0) {
; AVX2-LABEL: test_x86_avx2_psrli_w:
; AVX2:       ## BB#0:
; AVX2-NEXT:    vpsrlw $7, %ymm0, %ymm0
; AVX2-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_avx2_psrli_w:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vpsrlw $7, %ymm0, %ymm0
; AVX512VL-NEXT:    retl
  %res = call <16 x i16> @llvm.x86.avx2.psrli.w(<16 x i16> %a0, i32 7) ; <<16 x i16>> [#uses=1]
  ret <16 x i16> %res
}
declare <16 x i16> @llvm.x86.avx2.psrli.w(<16 x i16>, i32) nounwind readnone


define <32 x i8> @test_x86_avx2_psubs_b(<32 x i8> %a0, <32 x i8> %a1) {
; AVX2-LABEL: test_x86_avx2_psubs_b:
; AVX2:       ## BB#0:
; AVX2-NEXT:    vpsubsb %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_avx2_psubs_b:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vpsubsb %ymm1, %ymm0, %ymm0
; AVX512VL-NEXT:    retl
  %res = call <32 x i8> @llvm.x86.avx2.psubs.b(<32 x i8> %a0, <32 x i8> %a1) ; <<32 x i8>> [#uses=1]
  ret <32 x i8> %res
}
declare <32 x i8> @llvm.x86.avx2.psubs.b(<32 x i8>, <32 x i8>) nounwind readnone


define <16 x i16> @test_x86_avx2_psubs_w(<16 x i16> %a0, <16 x i16> %a1) {
; AVX2-LABEL: test_x86_avx2_psubs_w:
; AVX2:       ## BB#0:
; AVX2-NEXT:    vpsubsw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_avx2_psubs_w:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vpsubsw %ymm1, %ymm0, %ymm0
; AVX512VL-NEXT:    retl
  %res = call <16 x i16> @llvm.x86.avx2.psubs.w(<16 x i16> %a0, <16 x i16> %a1) ; <<16 x i16>> [#uses=1]
  ret <16 x i16> %res
}
declare <16 x i16> @llvm.x86.avx2.psubs.w(<16 x i16>, <16 x i16>) nounwind readnone


define <32 x i8> @test_x86_avx2_psubus_b(<32 x i8> %a0, <32 x i8> %a1) {
; AVX2-LABEL: test_x86_avx2_psubus_b:
; AVX2:       ## BB#0:
; AVX2-NEXT:    vpsubusb %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_avx2_psubus_b:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vpsubusb %ymm1, %ymm0, %ymm0
; AVX512VL-NEXT:    retl
  %res = call <32 x i8> @llvm.x86.avx2.psubus.b(<32 x i8> %a0, <32 x i8> %a1) ; <<32 x i8>> [#uses=1]
  ret <32 x i8> %res
}
declare <32 x i8> @llvm.x86.avx2.psubus.b(<32 x i8>, <32 x i8>) nounwind readnone


define <16 x i16> @test_x86_avx2_psubus_w(<16 x i16> %a0, <16 x i16> %a1) {
; AVX2-LABEL: test_x86_avx2_psubus_w:
; AVX2:       ## BB#0:
; AVX2-NEXT:    vpsubusw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_avx2_psubus_w:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vpsubusw %ymm1, %ymm0, %ymm0
; AVX512VL-NEXT:    retl
  %res = call <16 x i16> @llvm.x86.avx2.psubus.w(<16 x i16> %a0, <16 x i16> %a1) ; <<16 x i16>> [#uses=1]
  ret <16 x i16> %res
}
declare <16 x i16> @llvm.x86.avx2.psubus.w(<16 x i16>, <16 x i16>) nounwind readnone


define <32 x i8> @test_x86_avx2_pabs_b(<32 x i8> %a0) {
; AVX2-LABEL: test_x86_avx2_pabs_b:
; AVX2:       ## BB#0:
; AVX2-NEXT:    vpabsb %ymm0, %ymm0
; AVX2-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_avx2_pabs_b:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vpabsb %ymm0, %ymm0
; AVX512VL-NEXT:    retl
  %res = call <32 x i8> @llvm.x86.avx2.pabs.b(<32 x i8> %a0) ; <<32 x i8>> [#uses=1]
  ret <32 x i8> %res
}
declare <32 x i8> @llvm.x86.avx2.pabs.b(<32 x i8>) nounwind readnone


define <8 x i32> @test_x86_avx2_pabs_d(<8 x i32> %a0) {
; AVX2-LABEL: test_x86_avx2_pabs_d:
; AVX2:       ## BB#0:
; AVX2-NEXT:    vpabsd %ymm0, %ymm0
; AVX2-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_avx2_pabs_d:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vpabsd %ymm0, %ymm0
; AVX512VL-NEXT:    retl
  %res = call <8 x i32> @llvm.x86.avx2.pabs.d(<8 x i32> %a0) ; <<8 x i32>> [#uses=1]
  ret <8 x i32> %res
}
declare <8 x i32> @llvm.x86.avx2.pabs.d(<8 x i32>) nounwind readnone


define <16 x i16> @test_x86_avx2_pabs_w(<16 x i16> %a0) {
; AVX2-LABEL: test_x86_avx2_pabs_w:
; AVX2:       ## BB#0:
; AVX2-NEXT:    vpabsw %ymm0, %ymm0
; AVX2-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_avx2_pabs_w:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vpabsw %ymm0, %ymm0
; AVX512VL-NEXT:    retl
  %res = call <16 x i16> @llvm.x86.avx2.pabs.w(<16 x i16> %a0) ; <<16 x i16>> [#uses=1]
  ret <16 x i16> %res
}
declare <16 x i16> @llvm.x86.avx2.pabs.w(<16 x i16>) nounwind readnone


define <8 x i32> @test_x86_avx2_phadd_d(<8 x i32> %a0, <8 x i32> %a1) {
; AVX2-LABEL: test_x86_avx2_phadd_d:
; AVX2:       ## BB#0:
; AVX2-NEXT:    vphaddd %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_avx2_phadd_d:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vphaddd %ymm1, %ymm0, %ymm0
; AVX512VL-NEXT:    retl
  %res = call <8 x i32> @llvm.x86.avx2.phadd.d(<8 x i32> %a0, <8 x i32> %a1) ; <<8 x i32>> [#uses=1]
  ret <8 x i32> %res
}
declare <8 x i32> @llvm.x86.avx2.phadd.d(<8 x i32>, <8 x i32>) nounwind readnone


define <16 x i16> @test_x86_avx2_phadd_sw(<16 x i16> %a0, <16 x i16> %a1) {
; AVX2-LABEL: test_x86_avx2_phadd_sw:
; AVX2:       ## BB#0:
; AVX2-NEXT:    vphaddsw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_avx2_phadd_sw:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vphaddsw %ymm1, %ymm0, %ymm0
; AVX512VL-NEXT:    retl
  %res = call <16 x i16> @llvm.x86.avx2.phadd.sw(<16 x i16> %a0, <16 x i16> %a1) ; <<16 x i16>> [#uses=1]
  ret <16 x i16> %res
}
declare <16 x i16> @llvm.x86.avx2.phadd.sw(<16 x i16>, <16 x i16>) nounwind readnone


define <16 x i16> @test_x86_avx2_phadd_w(<16 x i16> %a0, <16 x i16> %a1) {
; AVX2-LABEL: test_x86_avx2_phadd_w:
; AVX2:       ## BB#0:
; AVX2-NEXT:    vphaddw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_avx2_phadd_w:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vphaddw %ymm1, %ymm0, %ymm0
; AVX512VL-NEXT:    retl
  %res = call <16 x i16> @llvm.x86.avx2.phadd.w(<16 x i16> %a0, <16 x i16> %a1) ; <<16 x i16>> [#uses=1]
  ret <16 x i16> %res
}
declare <16 x i16> @llvm.x86.avx2.phadd.w(<16 x i16>, <16 x i16>) nounwind readnone


define <8 x i32> @test_x86_avx2_phsub_d(<8 x i32> %a0, <8 x i32> %a1) {
; AVX2-LABEL: test_x86_avx2_phsub_d:
; AVX2:       ## BB#0:
; AVX2-NEXT:    vphsubd %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_avx2_phsub_d:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vphsubd %ymm1, %ymm0, %ymm0
; AVX512VL-NEXT:    retl
  %res = call <8 x i32> @llvm.x86.avx2.phsub.d(<8 x i32> %a0, <8 x i32> %a1) ; <<8 x i32>> [#uses=1]
  ret <8 x i32> %res
}
declare <8 x i32> @llvm.x86.avx2.phsub.d(<8 x i32>, <8 x i32>) nounwind readnone


define <16 x i16> @test_x86_avx2_phsub_sw(<16 x i16> %a0, <16 x i16> %a1) {
; AVX2-LABEL: test_x86_avx2_phsub_sw:
; AVX2:       ## BB#0:
; AVX2-NEXT:    vphsubsw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_avx2_phsub_sw:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vphsubsw %ymm1, %ymm0, %ymm0
; AVX512VL-NEXT:    retl
  %res = call <16 x i16> @llvm.x86.avx2.phsub.sw(<16 x i16> %a0, <16 x i16> %a1) ; <<16 x i16>> [#uses=1]
  ret <16 x i16> %res
}
declare <16 x i16> @llvm.x86.avx2.phsub.sw(<16 x i16>, <16 x i16>) nounwind readnone


define <16 x i16> @test_x86_avx2_phsub_w(<16 x i16> %a0, <16 x i16> %a1) {
; AVX2-LABEL: test_x86_avx2_phsub_w:
; AVX2:       ## BB#0:
; AVX2-NEXT:    vphsubw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_avx2_phsub_w:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vphsubw %ymm1, %ymm0, %ymm0
; AVX512VL-NEXT:    retl
  %res = call <16 x i16> @llvm.x86.avx2.phsub.w(<16 x i16> %a0, <16 x i16> %a1) ; <<16 x i16>> [#uses=1]
  ret <16 x i16> %res
}
declare <16 x i16> @llvm.x86.avx2.phsub.w(<16 x i16>, <16 x i16>) nounwind readnone


define <16 x i16> @test_x86_avx2_pmadd_ub_sw(<32 x i8> %a0, <32 x i8> %a1) {
; AVX2-LABEL: test_x86_avx2_pmadd_ub_sw:
; AVX2:       ## BB#0:
; AVX2-NEXT:    vpmaddubsw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_avx2_pmadd_ub_sw:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vpmaddubsw %ymm1, %ymm0, %ymm0
; AVX512VL-NEXT:    retl
  %res = call <16 x i16> @llvm.x86.avx2.pmadd.ub.sw(<32 x i8> %a0, <32 x i8> %a1) ; <<16 x i16>> [#uses=1]
  ret <16 x i16> %res
}
declare <16 x i16> @llvm.x86.avx2.pmadd.ub.sw(<32 x i8>, <32 x i8>) nounwind readnone


define <16 x i16> @test_x86_avx2_pmul_hr_sw(<16 x i16> %a0, <16 x i16> %a1) {
; AVX2-LABEL: test_x86_avx2_pmul_hr_sw:
; AVX2:       ## BB#0:
; AVX2-NEXT:    vpmulhrsw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_avx2_pmul_hr_sw:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vpmulhrsw %ymm1, %ymm0, %ymm0
; AVX512VL-NEXT:    retl
  %res = call <16 x i16> @llvm.x86.avx2.pmul.hr.sw(<16 x i16> %a0, <16 x i16> %a1) ; <<16 x i16>> [#uses=1]
  ret <16 x i16> %res
}
declare <16 x i16> @llvm.x86.avx2.pmul.hr.sw(<16 x i16>, <16 x i16>) nounwind readnone


define <32 x i8> @test_x86_avx2_pshuf_b(<32 x i8> %a0, <32 x i8> %a1) {
; AVX2-LABEL: test_x86_avx2_pshuf_b:
; AVX2:       ## BB#0:
; AVX2-NEXT:    vpshufb %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_avx2_pshuf_b:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vpshufb %ymm1, %ymm0, %ymm0
; AVX512VL-NEXT:    retl
  %res = call <32 x i8> @llvm.x86.avx2.pshuf.b(<32 x i8> %a0, <32 x i8> %a1) ; <<16 x i8>> [#uses=1]
  ret <32 x i8> %res
}
declare <32 x i8> @llvm.x86.avx2.pshuf.b(<32 x i8>, <32 x i8>) nounwind readnone


define <32 x i8> @test_x86_avx2_psign_b(<32 x i8> %a0, <32 x i8> %a1) {
; AVX2-LABEL: test_x86_avx2_psign_b:
; AVX2:       ## BB#0:
; AVX2-NEXT:    vpsignb %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_avx2_psign_b:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vpsignb %ymm1, %ymm0, %ymm0
; AVX512VL-NEXT:    retl
  %res = call <32 x i8> @llvm.x86.avx2.psign.b(<32 x i8> %a0, <32 x i8> %a1) ; <<32 x i8>> [#uses=1]
  ret <32 x i8> %res
}
declare <32 x i8> @llvm.x86.avx2.psign.b(<32 x i8>, <32 x i8>) nounwind readnone


define <8 x i32> @test_x86_avx2_psign_d(<8 x i32> %a0, <8 x i32> %a1) {
; AVX2-LABEL: test_x86_avx2_psign_d:
; AVX2:       ## BB#0:
; AVX2-NEXT:    vpsignd %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_avx2_psign_d:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vpsignd %ymm1, %ymm0, %ymm0
; AVX512VL-NEXT:    retl
  %res = call <8 x i32> @llvm.x86.avx2.psign.d(<8 x i32> %a0, <8 x i32> %a1) ; <<4 x i32>> [#uses=1]
  ret <8 x i32> %res
}
declare <8 x i32> @llvm.x86.avx2.psign.d(<8 x i32>, <8 x i32>) nounwind readnone


define <16 x i16> @test_x86_avx2_psign_w(<16 x i16> %a0, <16 x i16> %a1) {
; AVX2-LABEL: test_x86_avx2_psign_w:
; AVX2:       ## BB#0:
; AVX2-NEXT:    vpsignw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_avx2_psign_w:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vpsignw %ymm1, %ymm0, %ymm0
; AVX512VL-NEXT:    retl
  %res = call <16 x i16> @llvm.x86.avx2.psign.w(<16 x i16> %a0, <16 x i16> %a1) ; <<16 x i16>> [#uses=1]
  ret <16 x i16> %res
}
declare <16 x i16> @llvm.x86.avx2.psign.w(<16 x i16>, <16 x i16>) nounwind readnone


define <4 x i64> @test_x86_avx2_movntdqa(i8* %a0) {
; AVX2-LABEL: test_x86_avx2_movntdqa:
; AVX2:       ## BB#0:
; AVX2-NEXT:    movl {{[0-9]+}}(%esp), %eax
; AVX2-NEXT:    vmovntdqa (%eax), %ymm0
; AVX2-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_avx2_movntdqa:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    movl {{[0-9]+}}(%esp), %eax
; AVX512VL-NEXT:    vmovntdqa (%eax), %ymm0
; AVX512VL-NEXT:    retl
  %res = call <4 x i64> @llvm.x86.avx2.movntdqa(i8* %a0) ; <<4 x i64>> [#uses=1]
  ret <4 x i64> %res
}
declare <4 x i64> @llvm.x86.avx2.movntdqa(i8*) nounwind readonly


define <16 x i16> @test_x86_avx2_mpsadbw(<32 x i8> %a0, <32 x i8> %a1) {
; AVX2-LABEL: test_x86_avx2_mpsadbw:
; AVX2:       ## BB#0:
; AVX2-NEXT:    vmpsadbw $7, %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_avx2_mpsadbw:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vmpsadbw $7, %ymm1, %ymm0, %ymm0
; AVX512VL-NEXT:    retl
  %res = call <16 x i16> @llvm.x86.avx2.mpsadbw(<32 x i8> %a0, <32 x i8> %a1, i8 7) ; <<16 x i16>> [#uses=1]
  ret <16 x i16> %res
}
declare <16 x i16> @llvm.x86.avx2.mpsadbw(<32 x i8>, <32 x i8>, i8) nounwind readnone


define <16 x i16> @test_x86_avx2_packusdw(<8 x i32> %a0, <8 x i32> %a1) {
; AVX2-LABEL: test_x86_avx2_packusdw:
; AVX2:       ## BB#0:
; AVX2-NEXT:    vpackusdw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_avx2_packusdw:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vpackusdw %ymm1, %ymm0, %ymm0
; AVX512VL-NEXT:    retl
  %res = call <16 x i16> @llvm.x86.avx2.packusdw(<8 x i32> %a0, <8 x i32> %a1) ; <<16 x i16>> [#uses=1]
  ret <16 x i16> %res
}
declare <16 x i16> @llvm.x86.avx2.packusdw(<8 x i32>, <8 x i32>) nounwind readnone


define <32 x i8> @test_x86_avx2_pblendvb(<32 x i8> %a0, <32 x i8> %a1, <32 x i8> %a2) {
; AVX2-LABEL: test_x86_avx2_pblendvb:
; AVX2:       ## BB#0:
; AVX2-NEXT:    vpblendvb %ymm2, %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_avx2_pblendvb:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vpblendvb %ymm2, %ymm1, %ymm0, %ymm0
; AVX512VL-NEXT:    retl
  %res = call <32 x i8> @llvm.x86.avx2.pblendvb(<32 x i8> %a0, <32 x i8> %a1, <32 x i8> %a2) ; <<32 x i8>> [#uses=1]
  ret <32 x i8> %res
}
declare <32 x i8> @llvm.x86.avx2.pblendvb(<32 x i8>, <32 x i8>, <32 x i8>) nounwind readnone


define <16 x i16> @test_x86_avx2_pblendw(<16 x i16> %a0, <16 x i16> %a1) {
; AVX2-LABEL: test_x86_avx2_pblendw:
; AVX2:       ## BB#0:
; AVX2-NEXT:    vpblendw {{.*#+}} ymm0 = ymm1[0,1,2],ymm0[3,4,5,6,7],ymm1[8,9,10],ymm0[11,12,13,14,15]
; AVX2-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_avx2_pblendw:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vpblendw {{.*#+}} ymm0 = ymm1[0,1,2],ymm0[3,4,5,6,7],ymm1[8,9,10],ymm0[11,12,13,14,15]
; AVX512VL-NEXT:    retl
  %res = call <16 x i16> @llvm.x86.avx2.pblendw(<16 x i16> %a0, <16 x i16> %a1, i8 7) ; <<16 x i16>> [#uses=1]
  ret <16 x i16> %res
}
declare <16 x i16> @llvm.x86.avx2.pblendw(<16 x i16>, <16 x i16>, i8) nounwind readnone


define <32 x i8> @test_x86_avx2_pmaxsb(<32 x i8> %a0, <32 x i8> %a1) {
; AVX2-LABEL: test_x86_avx2_pmaxsb:
; AVX2:       ## BB#0:
; AVX2-NEXT:    vpmaxsb %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_avx2_pmaxsb:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vpmaxsb %ymm1, %ymm0, %ymm0
; AVX512VL-NEXT:    retl
  %res = call <32 x i8> @llvm.x86.avx2.pmaxs.b(<32 x i8> %a0, <32 x i8> %a1) ; <<32 x i8>> [#uses=1]
  ret <32 x i8> %res
}
declare <32 x i8> @llvm.x86.avx2.pmaxs.b(<32 x i8>, <32 x i8>) nounwind readnone


define <8 x i32> @test_x86_avx2_pmaxsd(<8 x i32> %a0, <8 x i32> %a1) {
; AVX2-LABEL: test_x86_avx2_pmaxsd:
; AVX2:       ## BB#0:
; AVX2-NEXT:    vpmaxsd %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_avx2_pmaxsd:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vpmaxsd %ymm1, %ymm0, %ymm0
; AVX512VL-NEXT:    retl
  %res = call <8 x i32> @llvm.x86.avx2.pmaxs.d(<8 x i32> %a0, <8 x i32> %a1) ; <<8 x i32>> [#uses=1]
  ret <8 x i32> %res
}
declare <8 x i32> @llvm.x86.avx2.pmaxs.d(<8 x i32>, <8 x i32>) nounwind readnone


define <8 x i32> @test_x86_avx2_pmaxud(<8 x i32> %a0, <8 x i32> %a1) {
; AVX2-LABEL: test_x86_avx2_pmaxud:
; AVX2:       ## BB#0:
; AVX2-NEXT:    vpmaxud %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_avx2_pmaxud:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vpmaxud %ymm1, %ymm0, %ymm0
; AVX512VL-NEXT:    retl
  %res = call <8 x i32> @llvm.x86.avx2.pmaxu.d(<8 x i32> %a0, <8 x i32> %a1) ; <<8 x i32>> [#uses=1]
  ret <8 x i32> %res
}
declare <8 x i32> @llvm.x86.avx2.pmaxu.d(<8 x i32>, <8 x i32>) nounwind readnone


define <16 x i16> @test_x86_avx2_pmaxuw(<16 x i16> %a0, <16 x i16> %a1) {
; AVX2-LABEL: test_x86_avx2_pmaxuw:
; AVX2:       ## BB#0:
; AVX2-NEXT:    vpmaxuw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_avx2_pmaxuw:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vpmaxuw %ymm1, %ymm0, %ymm0
; AVX512VL-NEXT:    retl
  %res = call <16 x i16> @llvm.x86.avx2.pmaxu.w(<16 x i16> %a0, <16 x i16> %a1) ; <<16 x i16>> [#uses=1]
  ret <16 x i16> %res
}
declare <16 x i16> @llvm.x86.avx2.pmaxu.w(<16 x i16>, <16 x i16>) nounwind readnone


define <32 x i8> @test_x86_avx2_pminsb(<32 x i8> %a0, <32 x i8> %a1) {
; AVX2-LABEL: test_x86_avx2_pminsb:
; AVX2:       ## BB#0:
; AVX2-NEXT:    vpminsb %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_avx2_pminsb:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vpminsb %ymm1, %ymm0, %ymm0
; AVX512VL-NEXT:    retl
  %res = call <32 x i8> @llvm.x86.avx2.pmins.b(<32 x i8> %a0, <32 x i8> %a1) ; <<32 x i8>> [#uses=1]
  ret <32 x i8> %res
}
declare <32 x i8> @llvm.x86.avx2.pmins.b(<32 x i8>, <32 x i8>) nounwind readnone


define <8 x i32> @test_x86_avx2_pminsd(<8 x i32> %a0, <8 x i32> %a1) {
; AVX2-LABEL: test_x86_avx2_pminsd:
; AVX2:       ## BB#0:
; AVX2-NEXT:    vpminsd %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_avx2_pminsd:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vpminsd %ymm1, %ymm0, %ymm0
; AVX512VL-NEXT:    retl
  %res = call <8 x i32> @llvm.x86.avx2.pmins.d(<8 x i32> %a0, <8 x i32> %a1) ; <<8 x i32>> [#uses=1]
  ret <8 x i32> %res
}
declare <8 x i32> @llvm.x86.avx2.pmins.d(<8 x i32>, <8 x i32>) nounwind readnone


define <8 x i32> @test_x86_avx2_pminud(<8 x i32> %a0, <8 x i32> %a1) {
; AVX2-LABEL: test_x86_avx2_pminud:
; AVX2:       ## BB#0:
; AVX2-NEXT:    vpminud %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_avx2_pminud:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vpminud %ymm1, %ymm0, %ymm0
; AVX512VL-NEXT:    retl
  %res = call <8 x i32> @llvm.x86.avx2.pminu.d(<8 x i32> %a0, <8 x i32> %a1) ; <<8 x i32>> [#uses=1]
  ret <8 x i32> %res
}
declare <8 x i32> @llvm.x86.avx2.pminu.d(<8 x i32>, <8 x i32>) nounwind readnone


define <16 x i16> @test_x86_avx2_pminuw(<16 x i16> %a0, <16 x i16> %a1) {
; AVX2-LABEL: test_x86_avx2_pminuw:
; AVX2:       ## BB#0:
; AVX2-NEXT:    vpminuw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_avx2_pminuw:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vpminuw %ymm1, %ymm0, %ymm0
; AVX512VL-NEXT:    retl
  %res = call <16 x i16> @llvm.x86.avx2.pminu.w(<16 x i16> %a0, <16 x i16> %a1) ; <<16 x i16>> [#uses=1]
  ret <16 x i16> %res
}
declare <16 x i16> @llvm.x86.avx2.pminu.w(<16 x i16>, <16 x i16>) nounwind readnone


define <4 x i64> @test_x86_avx2_pmul.dq(<8 x i32> %a0, <8 x i32> %a1) {
  %res = call <4 x i64> @llvm.x86.avx2.pmul.dq(<8 x i32> %a0, <8 x i32> %a1) ; <<2 x i64>> [#uses=1]
  ret <4 x i64> %res
}
declare <4 x i64> @llvm.x86.avx2.pmul.dq(<8 x i32>, <8 x i32>) nounwind readnone


define <4 x i32> @test_x86_avx2_pblendd_128(<4 x i32> %a0, <4 x i32> %a1) {
; AVX2-LABEL: test_x86_avx2_pblendd_128:
; AVX2:       ## BB#0:
; AVX2-NEXT:    vpblendd {{.*#+}} xmm0 = xmm1[0,1,2],xmm0[3]
; AVX2-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_avx2_pblendd_128:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vpblendd {{.*#+}} xmm0 = xmm1[0,1,2],xmm0[3]
; AVX512VL-NEXT:    retl
  %res = call <4 x i32> @llvm.x86.avx2.pblendd.128(<4 x i32> %a0, <4 x i32> %a1, i8 7) ; <<4 x i32>> [#uses=1]
  ret <4 x i32> %res
}
declare <4 x i32> @llvm.x86.avx2.pblendd.128(<4 x i32>, <4 x i32>, i8) nounwind readnone


define <8 x i32> @test_x86_avx2_pblendd_256(<8 x i32> %a0, <8 x i32> %a1) {
; AVX2-LABEL: test_x86_avx2_pblendd_256:
; AVX2:       ## BB#0:
; AVX2-NEXT:    vpblendd {{.*#+}} ymm0 = ymm1[0,1,2],ymm0[3,4,5,6,7]
; AVX2-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_avx2_pblendd_256:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vpblendd {{.*#+}} ymm0 = ymm1[0,1,2],ymm0[3,4,5,6,7]
; AVX512VL-NEXT:    retl
  %res = call <8 x i32> @llvm.x86.avx2.pblendd.256(<8 x i32> %a0, <8 x i32> %a1, i8 7) ; <<8 x i32>> [#uses=1]
  ret <8 x i32> %res
}
declare <8 x i32> @llvm.x86.avx2.pblendd.256(<8 x i32>, <8 x i32>, i8) nounwind readnone


; Check that the arguments are swapped between the intrinsic definition
; and its lowering. Indeed, the offsets are the first source in
; the instruction.
define <8 x i32> @test_x86_avx2_permd(<8 x i32> %a0, <8 x i32> %a1) {
; AVX2-LABEL: test_x86_avx2_permd:
; AVX2:       ## BB#0:
; AVX2-NEXT:    vpermd %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_avx2_permd:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vpermd %ymm0, %ymm1, %ymm0
; AVX512VL-NEXT:    retl
  %res = call <8 x i32> @llvm.x86.avx2.permd(<8 x i32> %a0, <8 x i32> %a1) ; <<8 x i32>> [#uses=1]
  ret <8 x i32> %res
}
declare <8 x i32> @llvm.x86.avx2.permd(<8 x i32>, <8 x i32>) nounwind readonly


; Check that the arguments are swapped between the intrinsic definition
; and its lowering. Indeed, the offsets are the first source in
; the instruction.
define <8 x float> @test_x86_avx2_permps(<8 x float> %a0, <8 x i32> %a1) {
; AVX2-LABEL: test_x86_avx2_permps:
; AVX2:       ## BB#0:
; AVX2-NEXT:    vpermps %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_avx2_permps:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vpermps %ymm0, %ymm1, %ymm0
; AVX512VL-NEXT:    retl
  %res = call <8 x float> @llvm.x86.avx2.permps(<8 x float> %a0, <8 x i32> %a1) ; <<8 x float>> [#uses=1]
  ret <8 x float> %res
}
declare <8 x float> @llvm.x86.avx2.permps(<8 x float>, <8 x i32>) nounwind readonly


define <4 x i64> @test_x86_avx2_vperm2i128(<4 x i64> %a0, <4 x i64> %a1) {
; AVX2-LABEL: test_x86_avx2_vperm2i128:
; AVX2:       ## BB#0:
; AVX2-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3,0,1]
; AVX2-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_avx2_vperm2i128:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3,0,1]
; AVX512VL-NEXT:    retl
  %res = call <4 x i64> @llvm.x86.avx2.vperm2i128(<4 x i64> %a0, <4 x i64> %a1, i8 1) ; <<4 x i64>> [#uses=1]
  ret <4 x i64> %res
}
declare <4 x i64> @llvm.x86.avx2.vperm2i128(<4 x i64>, <4 x i64>, i8) nounwind readonly


define <2 x i64> @test_x86_avx2_maskload_q(i8* %a0, <2 x i64> %a1) {
; AVX2-LABEL: test_x86_avx2_maskload_q:
; AVX2:       ## BB#0:
; AVX2-NEXT:    movl {{[0-9]+}}(%esp), %eax
; AVX2-NEXT:    vpmaskmovq (%eax), %xmm0, %xmm0
; AVX2-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_avx2_maskload_q:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    movl {{[0-9]+}}(%esp), %eax
; AVX512VL-NEXT:    vpmaskmovq (%eax), %xmm0, %xmm0
; AVX512VL-NEXT:    retl
  %res = call <2 x i64> @llvm.x86.avx2.maskload.q(i8* %a0, <2 x i64> %a1) ; <<2 x i64>> [#uses=1]
  ret <2 x i64> %res
}
declare <2 x i64> @llvm.x86.avx2.maskload.q(i8*, <2 x i64>) nounwind readonly


define <4 x i64> @test_x86_avx2_maskload_q_256(i8* %a0, <4 x i64> %a1) {
; AVX2-LABEL: test_x86_avx2_maskload_q_256:
; AVX2:       ## BB#0:
; AVX2-NEXT:    movl {{[0-9]+}}(%esp), %eax
; AVX2-NEXT:    vpmaskmovq (%eax), %ymm0, %ymm0
; AVX2-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_avx2_maskload_q_256:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    movl {{[0-9]+}}(%esp), %eax
; AVX512VL-NEXT:    vpmaskmovq (%eax), %ymm0, %ymm0
; AVX512VL-NEXT:    retl
  %res = call <4 x i64> @llvm.x86.avx2.maskload.q.256(i8* %a0, <4 x i64> %a1) ; <<4 x i64>> [#uses=1]
  ret <4 x i64> %res
}
declare <4 x i64> @llvm.x86.avx2.maskload.q.256(i8*, <4 x i64>) nounwind readonly


define <4 x i32> @test_x86_avx2_maskload_d(i8* %a0, <4 x i32> %a1) {
; AVX2-LABEL: test_x86_avx2_maskload_d:
; AVX2:       ## BB#0:
; AVX2-NEXT:    movl {{[0-9]+}}(%esp), %eax
; AVX2-NEXT:    vpmaskmovd (%eax), %xmm0, %xmm0
; AVX2-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_avx2_maskload_d:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    movl {{[0-9]+}}(%esp), %eax
; AVX512VL-NEXT:    vpmaskmovd (%eax), %xmm0, %xmm0
; AVX512VL-NEXT:    retl
  %res = call <4 x i32> @llvm.x86.avx2.maskload.d(i8* %a0, <4 x i32> %a1) ; <<4 x i32>> [#uses=1]
  ret <4 x i32> %res
}
declare <4 x i32> @llvm.x86.avx2.maskload.d(i8*, <4 x i32>) nounwind readonly


define <8 x i32> @test_x86_avx2_maskload_d_256(i8* %a0, <8 x i32> %a1) {
; AVX2-LABEL: test_x86_avx2_maskload_d_256:
; AVX2:       ## BB#0:
; AVX2-NEXT:    movl {{[0-9]+}}(%esp), %eax
; AVX2-NEXT:    vpmaskmovd (%eax), %ymm0, %ymm0
; AVX2-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_avx2_maskload_d_256:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    movl {{[0-9]+}}(%esp), %eax
; AVX512VL-NEXT:    vpmaskmovd (%eax), %ymm0, %ymm0
; AVX512VL-NEXT:    retl
  %res = call <8 x i32> @llvm.x86.avx2.maskload.d.256(i8* %a0, <8 x i32> %a1) ; <<8 x i32>> [#uses=1]
  ret <8 x i32> %res
}
declare <8 x i32> @llvm.x86.avx2.maskload.d.256(i8*, <8 x i32>) nounwind readonly


define void @test_x86_avx2_maskstore_q(i8* %a0, <2 x i64> %a1, <2 x i64> %a2) {
; AVX2-LABEL: test_x86_avx2_maskstore_q:
; AVX2:       ## BB#0:
; AVX2-NEXT:    movl {{[0-9]+}}(%esp), %eax
; AVX2-NEXT:    vpmaskmovq %xmm1, %xmm0, (%eax)
; AVX2-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_avx2_maskstore_q:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    movl {{[0-9]+}}(%esp), %eax
; AVX512VL-NEXT:    vpmaskmovq %xmm1, %xmm0, (%eax)
; AVX512VL-NEXT:    retl
  call void @llvm.x86.avx2.maskstore.q(i8* %a0, <2 x i64> %a1, <2 x i64> %a2)
  ret void
}
declare void @llvm.x86.avx2.maskstore.q(i8*, <2 x i64>, <2 x i64>) nounwind


define void @test_x86_avx2_maskstore_q_256(i8* %a0, <4 x i64> %a1, <4 x i64> %a2) {
; AVX2-LABEL: test_x86_avx2_maskstore_q_256:
; AVX2:       ## BB#0:
; AVX2-NEXT:    movl {{[0-9]+}}(%esp), %eax
; AVX2-NEXT:    vpmaskmovq %ymm1, %ymm0, (%eax)
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_avx2_maskstore_q_256:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    movl {{[0-9]+}}(%esp), %eax
; AVX512VL-NEXT:    vpmaskmovq %ymm1, %ymm0, (%eax)
; AVX512VL-NEXT:    retl
  call void @llvm.x86.avx2.maskstore.q.256(i8* %a0, <4 x i64> %a1, <4 x i64> %a2)
  ret void
}
declare void @llvm.x86.avx2.maskstore.q.256(i8*, <4 x i64>, <4 x i64>) nounwind


define void @test_x86_avx2_maskstore_d(i8* %a0, <4 x i32> %a1, <4 x i32> %a2) {
; AVX2-LABEL: test_x86_avx2_maskstore_d:
; AVX2:       ## BB#0:
; AVX2-NEXT:    movl {{[0-9]+}}(%esp), %eax
; AVX2-NEXT:    vpmaskmovd %xmm1, %xmm0, (%eax)
; AVX2-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_avx2_maskstore_d:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    movl {{[0-9]+}}(%esp), %eax
; AVX512VL-NEXT:    vpmaskmovd %xmm1, %xmm0, (%eax)
; AVX512VL-NEXT:    retl
  call void @llvm.x86.avx2.maskstore.d(i8* %a0, <4 x i32> %a1, <4 x i32> %a2)
  ret void
}
declare void @llvm.x86.avx2.maskstore.d(i8*, <4 x i32>, <4 x i32>) nounwind


define void @test_x86_avx2_maskstore_d_256(i8* %a0, <8 x i32> %a1, <8 x i32> %a2) {
; AVX2-LABEL: test_x86_avx2_maskstore_d_256:
; AVX2:       ## BB#0:
; AVX2-NEXT:    movl {{[0-9]+}}(%esp), %eax
; AVX2-NEXT:    vpmaskmovd %ymm1, %ymm0, (%eax)
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_avx2_maskstore_d_256:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    movl {{[0-9]+}}(%esp), %eax
; AVX512VL-NEXT:    vpmaskmovd %ymm1, %ymm0, (%eax)
; AVX512VL-NEXT:    retl
  call void @llvm.x86.avx2.maskstore.d.256(i8* %a0, <8 x i32> %a1, <8 x i32> %a2)
  ret void
}
declare void @llvm.x86.avx2.maskstore.d.256(i8*, <8 x i32>, <8 x i32>) nounwind


define <4 x i32> @test_x86_avx2_psllv_d(<4 x i32> %a0, <4 x i32> %a1) {
; AVX2-LABEL: test_x86_avx2_psllv_d:
; AVX2:       ## BB#0:
; AVX2-NEXT:    vpsllvd %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_avx2_psllv_d:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vpsllvd %xmm1, %xmm0, %xmm0
; AVX512VL-NEXT:    retl
  %res = call <4 x i32> @llvm.x86.avx2.psllv.d(<4 x i32> %a0, <4 x i32> %a1) ; <<4 x i32>> [#uses=1]
  ret <4 x i32> %res
}
declare <4 x i32> @llvm.x86.avx2.psllv.d(<4 x i32>, <4 x i32>) nounwind readnone


define <8 x i32> @test_x86_avx2_psllv_d_256(<8 x i32> %a0, <8 x i32> %a1) {
; AVX2-LABEL: test_x86_avx2_psllv_d_256:
; AVX2:       ## BB#0:
; AVX2-NEXT:    vpsllvd %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_avx2_psllv_d_256:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vpsllvd %ymm1, %ymm0, %ymm0
; AVX512VL-NEXT:    retl
  %res = call <8 x i32> @llvm.x86.avx2.psllv.d.256(<8 x i32> %a0, <8 x i32> %a1) ; <<8 x i32>> [#uses=1]
  ret <8 x i32> %res
}
declare <8 x i32> @llvm.x86.avx2.psllv.d.256(<8 x i32>, <8 x i32>) nounwind readnone


define <2 x i64> @test_x86_avx2_psllv_q(<2 x i64> %a0, <2 x i64> %a1) {
; AVX2-LABEL: test_x86_avx2_psllv_q:
; AVX2:       ## BB#0:
; AVX2-NEXT:    vpsllvq %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_avx2_psllv_q:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vpsllvq %xmm1, %xmm0, %xmm0
; AVX512VL-NEXT:    retl
  %res = call <2 x i64> @llvm.x86.avx2.psllv.q(<2 x i64> %a0, <2 x i64> %a1) ; <<2 x i64>> [#uses=1]
  ret <2 x i64> %res
}
declare <2 x i64> @llvm.x86.avx2.psllv.q(<2 x i64>, <2 x i64>) nounwind readnone


define <4 x i64> @test_x86_avx2_psllv_q_256(<4 x i64> %a0, <4 x i64> %a1) {
; AVX2-LABEL: test_x86_avx2_psllv_q_256:
; AVX2:       ## BB#0:
; AVX2-NEXT:    vpsllvq %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_avx2_psllv_q_256:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vpsllvq %ymm1, %ymm0, %ymm0
; AVX512VL-NEXT:    retl
  %res = call <4 x i64> @llvm.x86.avx2.psllv.q.256(<4 x i64> %a0, <4 x i64> %a1) ; <<4 x i64>> [#uses=1]
  ret <4 x i64> %res
}
declare <4 x i64> @llvm.x86.avx2.psllv.q.256(<4 x i64>, <4 x i64>) nounwind readnone


define <4 x i32> @test_x86_avx2_psrlv_d(<4 x i32> %a0, <4 x i32> %a1) {
; AVX2-LABEL: test_x86_avx2_psrlv_d:
; AVX2:       ## BB#0:
; AVX2-NEXT:    vpsrlvd %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_avx2_psrlv_d:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vpsrlvd %xmm1, %xmm0, %xmm0
; AVX512VL-NEXT:    retl
  %res = call <4 x i32> @llvm.x86.avx2.psrlv.d(<4 x i32> %a0, <4 x i32> %a1) ; <<4 x i32>> [#uses=1]
  ret <4 x i32> %res
}
declare <4 x i32> @llvm.x86.avx2.psrlv.d(<4 x i32>, <4 x i32>) nounwind readnone


define <8 x i32> @test_x86_avx2_psrlv_d_256(<8 x i32> %a0, <8 x i32> %a1) {
; AVX2-LABEL: test_x86_avx2_psrlv_d_256:
; AVX2:       ## BB#0:
; AVX2-NEXT:    vpsrlvd %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_avx2_psrlv_d_256:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vpsrlvd %ymm1, %ymm0, %ymm0
; AVX512VL-NEXT:    retl
  %res = call <8 x i32> @llvm.x86.avx2.psrlv.d.256(<8 x i32> %a0, <8 x i32> %a1) ; <<8 x i32>> [#uses=1]
  ret <8 x i32> %res
}
declare <8 x i32> @llvm.x86.avx2.psrlv.d.256(<8 x i32>, <8 x i32>) nounwind readnone


define <2 x i64> @test_x86_avx2_psrlv_q(<2 x i64> %a0, <2 x i64> %a1) {
; AVX2-LABEL: test_x86_avx2_psrlv_q:
; AVX2:       ## BB#0:
; AVX2-NEXT:    vpsrlvq %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_avx2_psrlv_q:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vpsrlvq %xmm1, %xmm0, %xmm0
; AVX512VL-NEXT:    retl
  %res = call <2 x i64> @llvm.x86.avx2.psrlv.q(<2 x i64> %a0, <2 x i64> %a1) ; <<2 x i64>> [#uses=1]
  ret <2 x i64> %res
}
declare <2 x i64> @llvm.x86.avx2.psrlv.q(<2 x i64>, <2 x i64>) nounwind readnone


define <4 x i64> @test_x86_avx2_psrlv_q_256(<4 x i64> %a0, <4 x i64> %a1) {
; AVX2-LABEL: test_x86_avx2_psrlv_q_256:
; AVX2:       ## BB#0:
; AVX2-NEXT:    vpsrlvq %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_avx2_psrlv_q_256:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vpsrlvq %ymm1, %ymm0, %ymm0
; AVX512VL-NEXT:    retl
  %res = call <4 x i64> @llvm.x86.avx2.psrlv.q.256(<4 x i64> %a0, <4 x i64> %a1) ; <<4 x i64>> [#uses=1]
  ret <4 x i64> %res
}
declare <4 x i64> @llvm.x86.avx2.psrlv.q.256(<4 x i64>, <4 x i64>) nounwind readnone


define <4 x i32> @test_x86_avx2_psrav_d(<4 x i32> %a0, <4 x i32> %a1) {
; AVX2-LABEL: test_x86_avx2_psrav_d:
; AVX2:       ## BB#0:
; AVX2-NEXT:    vpsravd %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_avx2_psrav_d:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vpsravd %xmm1, %xmm0, %xmm0
; AVX512VL-NEXT:    retl
  %res = call <4 x i32> @llvm.x86.avx2.psrav.d(<4 x i32> %a0, <4 x i32> %a1) ; <<4 x i32>> [#uses=1]
  ret <4 x i32> %res
}

define <4 x i32> @test_x86_avx2_psrav_d_const(<4 x i32> %a0, <4 x i32> %a1) {
; AVX2-LABEL: test_x86_avx2_psrav_d_const:
; AVX2:       ## BB#0:
; AVX2-NEXT:    vmovdqa {{.*#+}} xmm0 = [2,9,4294967284,23]
; AVX2-NEXT:    vpsravd LCPI90_1, %xmm0, %xmm0
; AVX2-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_avx2_psrav_d_const:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vmovdqa32 {{.*#+}} xmm0 = [2,9,4294967284,23]
; AVX512VL-NEXT:    vpsravd LCPI90_1, %xmm0, %xmm0
; AVX512VL-NEXT:    retl
  %res = call <4 x i32> @llvm.x86.avx2.psrav.d(<4 x i32> <i32 2, i32 9, i32 -12, i32 23>, <4 x i32> <i32 1, i32 18, i32 35, i32 52>)
  ret <4 x i32> %res
}
declare <4 x i32> @llvm.x86.avx2.psrav.d(<4 x i32>, <4 x i32>) nounwind readnone

define <8 x i32> @test_x86_avx2_psrav_d_256(<8 x i32> %a0, <8 x i32> %a1) {
; AVX2-LABEL: test_x86_avx2_psrav_d_256:
; AVX2:       ## BB#0:
; AVX2-NEXT:    vpsravd %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_avx2_psrav_d_256:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vpsravd %ymm1, %ymm0, %ymm0
; AVX512VL-NEXT:    retl
  %res = call <8 x i32> @llvm.x86.avx2.psrav.d.256(<8 x i32> %a0, <8 x i32> %a1) ; <<8 x i32>> [#uses=1]
  ret <8 x i32> %res
}

define <8 x i32> @test_x86_avx2_psrav_d_256_const(<8 x i32> %a0, <8 x i32> %a1) {
; AVX2-LABEL: test_x86_avx2_psrav_d_256_const:
; AVX2:       ## BB#0:
; AVX2-NEXT:    vmovdqa {{.*#+}} ymm0 = [2,9,4294967284,23,4294967270,37,4294967256,51]
; AVX2-NEXT:    vpsravd LCPI92_1, %ymm0, %ymm0
; AVX2-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_avx2_psrav_d_256_const:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vmovdqa32 {{.*#+}} ymm0 = [2,9,4294967284,23,4294967270,37,4294967256,51]
; AVX512VL-NEXT:    vpsravd LCPI92_1, %ymm0, %ymm0
; AVX512VL-NEXT:    retl
  %res = call <8 x i32> @llvm.x86.avx2.psrav.d.256(<8 x i32> <i32 2, i32 9, i32 -12, i32 23, i32 -26, i32 37, i32 -40, i32 51>, <8 x i32> <i32 1, i32 18, i32 35, i32 52, i32 69, i32 15, i32 32, i32 49>)
  ret <8 x i32> %res
}
declare <8 x i32> @llvm.x86.avx2.psrav.d.256(<8 x i32>, <8 x i32>) nounwind readnone

define <2 x double> @test_x86_avx2_gather_d_pd(<2 x double> %a0, i8* %a1, <4 x i32> %idx, <2 x double> %mask) {
; AVX2-LABEL: test_x86_avx2_gather_d_pd:
; AVX2:       ## BB#0:
; AVX2-NEXT:    movl {{[0-9]+}}(%esp), %eax
; AVX2-NEXT:    vgatherdpd %xmm2, (%eax,%xmm1,2), %xmm0
; AVX2-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_avx2_gather_d_pd:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    movl {{[0-9]+}}(%esp), %eax
; AVX512VL-NEXT:    vgatherdpd %xmm2, (%eax,%xmm1,2), %xmm0
; AVX512VL-NEXT:    retl
  %res = call <2 x double> @llvm.x86.avx2.gather.d.pd(<2 x double> %a0,
                            i8* %a1, <4 x i32> %idx, <2 x double> %mask, i8 2) ;
  ret <2 x double> %res
}
declare <2 x double> @llvm.x86.avx2.gather.d.pd(<2 x double>, i8*,
                      <4 x i32>, <2 x double>, i8) nounwind readonly

define <4 x double> @test_x86_avx2_gather_d_pd_256(<4 x double> %a0, i8* %a1, <4 x i32> %idx, <4 x double> %mask) {
; AVX2-LABEL: test_x86_avx2_gather_d_pd_256:
; AVX2:       ## BB#0:
; AVX2-NEXT:    movl {{[0-9]+}}(%esp), %eax
; AVX2-NEXT:    vgatherdpd %ymm2, (%eax,%xmm1,2), %ymm0
; AVX2-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_avx2_gather_d_pd_256:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    movl {{[0-9]+}}(%esp), %eax
; AVX512VL-NEXT:    vgatherdpd %ymm2, (%eax,%xmm1,2), %ymm0
; AVX512VL-NEXT:    retl
  %res = call <4 x double> @llvm.x86.avx2.gather.d.pd.256(<4 x double> %a0,
                            i8* %a1, <4 x i32> %idx, <4 x double> %mask, i8 2) ;
  ret <4 x double> %res
}
declare <4 x double> @llvm.x86.avx2.gather.d.pd.256(<4 x double>, i8*,
                      <4 x i32>, <4 x double>, i8) nounwind readonly

define <2 x double> @test_x86_avx2_gather_q_pd(<2 x double> %a0, i8* %a1, <2 x i64> %idx, <2 x double> %mask) {
; AVX2-LABEL: test_x86_avx2_gather_q_pd:
; AVX2:       ## BB#0:
; AVX2-NEXT:    movl {{[0-9]+}}(%esp), %eax
; AVX2-NEXT:    vgatherqpd %xmm2, (%eax,%xmm1,2), %xmm0
; AVX2-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_avx2_gather_q_pd:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    movl {{[0-9]+}}(%esp), %eax
; AVX512VL-NEXT:    vgatherqpd %xmm2, (%eax,%xmm1,2), %xmm0
; AVX512VL-NEXT:    retl
  %res = call <2 x double> @llvm.x86.avx2.gather.q.pd(<2 x double> %a0,
                            i8* %a1, <2 x i64> %idx, <2 x double> %mask, i8 2) ;
  ret <2 x double> %res
}
declare <2 x double> @llvm.x86.avx2.gather.q.pd(<2 x double>, i8*,
                      <2 x i64>, <2 x double>, i8) nounwind readonly

define <4 x double> @test_x86_avx2_gather_q_pd_256(<4 x double> %a0, i8* %a1, <4 x i64> %idx, <4 x double> %mask) {
; AVX2-LABEL: test_x86_avx2_gather_q_pd_256:
; AVX2:       ## BB#0:
; AVX2-NEXT:    movl {{[0-9]+}}(%esp), %eax
; AVX2-NEXT:    vgatherqpd %ymm2, (%eax,%ymm1,2), %ymm0
; AVX2-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_avx2_gather_q_pd_256:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    movl {{[0-9]+}}(%esp), %eax
; AVX512VL-NEXT:    vgatherqpd %ymm2, (%eax,%ymm1,2), %ymm0
; AVX512VL-NEXT:    retl
  %res = call <4 x double> @llvm.x86.avx2.gather.q.pd.256(<4 x double> %a0,
                            i8* %a1, <4 x i64> %idx, <4 x double> %mask, i8 2) ;
  ret <4 x double> %res
}
declare <4 x double> @llvm.x86.avx2.gather.q.pd.256(<4 x double>, i8*,
                      <4 x i64>, <4 x double>, i8) nounwind readonly

define <4 x float> @test_x86_avx2_gather_d_ps(<4 x float> %a0, i8* %a1, <4 x i32> %idx, <4 x float> %mask) {
; AVX2-LABEL: test_x86_avx2_gather_d_ps:
; AVX2:       ## BB#0:
; AVX2-NEXT:    movl {{[0-9]+}}(%esp), %eax
; AVX2-NEXT:    vgatherdps %xmm2, (%eax,%xmm1,2), %xmm0
; AVX2-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_avx2_gather_d_ps:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    movl {{[0-9]+}}(%esp), %eax
; AVX512VL-NEXT:    vgatherdps %xmm2, (%eax,%xmm1,2), %xmm0
; AVX512VL-NEXT:    retl
  %res = call <4 x float> @llvm.x86.avx2.gather.d.ps(<4 x float> %a0,
                            i8* %a1, <4 x i32> %idx, <4 x float> %mask, i8 2) ;
  ret <4 x float> %res
}
declare <4 x float> @llvm.x86.avx2.gather.d.ps(<4 x float>, i8*,
                      <4 x i32>, <4 x float>, i8) nounwind readonly

define <8 x float> @test_x86_avx2_gather_d_ps_256(<8 x float> %a0, i8* %a1, <8 x i32> %idx, <8 x float> %mask) {
; AVX2-LABEL: test_x86_avx2_gather_d_ps_256:
; AVX2:       ## BB#0:
; AVX2-NEXT:    movl {{[0-9]+}}(%esp), %eax
; AVX2-NEXT:    vgatherdps %ymm2, (%eax,%ymm1,2), %ymm0
; AVX2-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_avx2_gather_d_ps_256:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    movl {{[0-9]+}}(%esp), %eax
; AVX512VL-NEXT:    vgatherdps %ymm2, (%eax,%ymm1,2), %ymm0
; AVX512VL-NEXT:    retl
  %res = call <8 x float> @llvm.x86.avx2.gather.d.ps.256(<8 x float> %a0,
                            i8* %a1, <8 x i32> %idx, <8 x float> %mask, i8 2) ;
  ret <8 x float> %res
}
declare <8 x float> @llvm.x86.avx2.gather.d.ps.256(<8 x float>, i8*,
                      <8 x i32>, <8 x float>, i8) nounwind readonly

define <4 x float> @test_x86_avx2_gather_q_ps(<4 x float> %a0, i8* %a1, <2 x i64> %idx, <4 x float> %mask) {
; AVX2-LABEL: test_x86_avx2_gather_q_ps:
; AVX2:       ## BB#0:
; AVX2-NEXT:    movl {{[0-9]+}}(%esp), %eax
; AVX2-NEXT:    vgatherqps %xmm2, (%eax,%xmm1,2), %xmm0
; AVX2-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_avx2_gather_q_ps:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    movl {{[0-9]+}}(%esp), %eax
; AVX512VL-NEXT:    vgatherqps %xmm2, (%eax,%xmm1,2), %xmm0
; AVX512VL-NEXT:    retl
  %res = call <4 x float> @llvm.x86.avx2.gather.q.ps(<4 x float> %a0,
                            i8* %a1, <2 x i64> %idx, <4 x float> %mask, i8 2) ;
  ret <4 x float> %res
}
declare <4 x float> @llvm.x86.avx2.gather.q.ps(<4 x float>, i8*,
                      <2 x i64>, <4 x float>, i8) nounwind readonly

define <4 x float> @test_x86_avx2_gather_q_ps_256(<4 x float> %a0, i8* %a1, <4 x i64> %idx, <4 x float> %mask) {
; AVX2-LABEL: test_x86_avx2_gather_q_ps_256:
; AVX2:       ## BB#0:
; AVX2-NEXT:    movl {{[0-9]+}}(%esp), %eax
; AVX2-NEXT:    vgatherqps %xmm2, (%eax,%ymm1,2), %xmm0
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_avx2_gather_q_ps_256:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    movl {{[0-9]+}}(%esp), %eax
; AVX512VL-NEXT:    vgatherqps %xmm2, (%eax,%ymm1,2), %xmm0
; AVX512VL-NEXT:    retl
  %res = call <4 x float> @llvm.x86.avx2.gather.q.ps.256(<4 x float> %a0,
                            i8* %a1, <4 x i64> %idx, <4 x float> %mask, i8 2) ;
  ret <4 x float> %res
}
declare <4 x float> @llvm.x86.avx2.gather.q.ps.256(<4 x float>, i8*,
                      <4 x i64>, <4 x float>, i8) nounwind readonly

define <2 x i64> @test_x86_avx2_gather_d_q(<2 x i64> %a0, i8* %a1, <4 x i32> %idx, <2 x i64> %mask) {
; AVX2-LABEL: test_x86_avx2_gather_d_q:
; AVX2:       ## BB#0:
; AVX2-NEXT:    movl {{[0-9]+}}(%esp), %eax
; AVX2-NEXT:    vpgatherdq %xmm2, (%eax,%xmm1,2), %xmm0
; AVX2-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_avx2_gather_d_q:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    movl {{[0-9]+}}(%esp), %eax
; AVX512VL-NEXT:    vpgatherdq %xmm2, (%eax,%xmm1,2), %xmm0
; AVX512VL-NEXT:    retl
  %res = call <2 x i64> @llvm.x86.avx2.gather.d.q(<2 x i64> %a0,
                            i8* %a1, <4 x i32> %idx, <2 x i64> %mask, i8 2) ;
  ret <2 x i64> %res
}
declare <2 x i64> @llvm.x86.avx2.gather.d.q(<2 x i64>, i8*,
                      <4 x i32>, <2 x i64>, i8) nounwind readonly

define <4 x i64> @test_x86_avx2_gather_d_q_256(<4 x i64> %a0, i8* %a1, <4 x i32> %idx, <4 x i64> %mask) {
; AVX2-LABEL: test_x86_avx2_gather_d_q_256:
; AVX2:       ## BB#0:
; AVX2-NEXT:    movl {{[0-9]+}}(%esp), %eax
; AVX2-NEXT:    vpgatherdq %ymm2, (%eax,%xmm1,2), %ymm0
; AVX2-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_avx2_gather_d_q_256:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    movl {{[0-9]+}}(%esp), %eax
; AVX512VL-NEXT:    vpgatherdq %ymm2, (%eax,%xmm1,2), %ymm0
; AVX512VL-NEXT:    retl
  %res = call <4 x i64> @llvm.x86.avx2.gather.d.q.256(<4 x i64> %a0,
                            i8* %a1, <4 x i32> %idx, <4 x i64> %mask, i8 2) ;
  ret <4 x i64> %res
}
declare <4 x i64> @llvm.x86.avx2.gather.d.q.256(<4 x i64>, i8*,
                      <4 x i32>, <4 x i64>, i8) nounwind readonly

define <2 x i64> @test_x86_avx2_gather_q_q(<2 x i64> %a0, i8* %a1, <2 x i64> %idx, <2 x i64> %mask) {
; AVX2-LABEL: test_x86_avx2_gather_q_q:
; AVX2:       ## BB#0:
; AVX2-NEXT:    movl {{[0-9]+}}(%esp), %eax
; AVX2-NEXT:    vpgatherqq %xmm2, (%eax,%xmm1,2), %xmm0
; AVX2-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_avx2_gather_q_q:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    movl {{[0-9]+}}(%esp), %eax
; AVX512VL-NEXT:    vpgatherqq %xmm2, (%eax,%xmm1,2), %xmm0
; AVX512VL-NEXT:    retl
  %res = call <2 x i64> @llvm.x86.avx2.gather.q.q(<2 x i64> %a0,
                            i8* %a1, <2 x i64> %idx, <2 x i64> %mask, i8 2) ;
  ret <2 x i64> %res
}
declare <2 x i64> @llvm.x86.avx2.gather.q.q(<2 x i64>, i8*,
                      <2 x i64>, <2 x i64>, i8) nounwind readonly

define <4 x i64> @test_x86_avx2_gather_q_q_256(<4 x i64> %a0, i8* %a1, <4 x i64> %idx, <4 x i64> %mask) {
; AVX2-LABEL: test_x86_avx2_gather_q_q_256:
; AVX2:       ## BB#0:
; AVX2-NEXT:    movl {{[0-9]+}}(%esp), %eax
; AVX2-NEXT:    vpgatherqq %ymm2, (%eax,%ymm1,2), %ymm0
; AVX2-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_avx2_gather_q_q_256:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    movl {{[0-9]+}}(%esp), %eax
; AVX512VL-NEXT:    vpgatherqq %ymm2, (%eax,%ymm1,2), %ymm0
; AVX512VL-NEXT:    retl
  %res = call <4 x i64> @llvm.x86.avx2.gather.q.q.256(<4 x i64> %a0,
                            i8* %a1, <4 x i64> %idx, <4 x i64> %mask, i8 2) ;
  ret <4 x i64> %res
}
declare <4 x i64> @llvm.x86.avx2.gather.q.q.256(<4 x i64>, i8*,
                      <4 x i64>, <4 x i64>, i8) nounwind readonly

define <4 x i32> @test_x86_avx2_gather_d_d(<4 x i32> %a0, i8* %a1, <4 x i32> %idx, <4 x i32> %mask) {
; AVX2-LABEL: test_x86_avx2_gather_d_d:
; AVX2:       ## BB#0:
; AVX2-NEXT:    movl {{[0-9]+}}(%esp), %eax
; AVX2-NEXT:    vpgatherdd %xmm2, (%eax,%xmm1,2), %xmm0
; AVX2-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_avx2_gather_d_d:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    movl {{[0-9]+}}(%esp), %eax
; AVX512VL-NEXT:    vpgatherdd %xmm2, (%eax,%xmm1,2), %xmm0
; AVX512VL-NEXT:    retl
  %res = call <4 x i32> @llvm.x86.avx2.gather.d.d(<4 x i32> %a0,
                            i8* %a1, <4 x i32> %idx, <4 x i32> %mask, i8 2) ;
  ret <4 x i32> %res
}
declare <4 x i32> @llvm.x86.avx2.gather.d.d(<4 x i32>, i8*,
                      <4 x i32>, <4 x i32>, i8) nounwind readonly

define <8 x i32> @test_x86_avx2_gather_d_d_256(<8 x i32> %a0, i8* %a1, <8 x i32> %idx, <8 x i32> %mask) {
; AVX2-LABEL: test_x86_avx2_gather_d_d_256:
; AVX2:       ## BB#0:
; AVX2-NEXT:    movl {{[0-9]+}}(%esp), %eax
; AVX2-NEXT:    vpgatherdd %ymm2, (%eax,%ymm1,2), %ymm0
; AVX2-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_avx2_gather_d_d_256:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    movl {{[0-9]+}}(%esp), %eax
; AVX512VL-NEXT:    vpgatherdd %ymm2, (%eax,%ymm1,2), %ymm0
; AVX512VL-NEXT:    retl
  %res = call <8 x i32> @llvm.x86.avx2.gather.d.d.256(<8 x i32> %a0,
                            i8* %a1, <8 x i32> %idx, <8 x i32> %mask, i8 2) ;
  ret <8 x i32> %res
}
declare <8 x i32> @llvm.x86.avx2.gather.d.d.256(<8 x i32>, i8*,
                      <8 x i32>, <8 x i32>, i8) nounwind readonly

define <4 x i32> @test_x86_avx2_gather_q_d(<4 x i32> %a0, i8* %a1, <2 x i64> %idx, <4 x i32> %mask) {
; AVX2-LABEL: test_x86_avx2_gather_q_d:
; AVX2:       ## BB#0:
; AVX2-NEXT:    movl {{[0-9]+}}(%esp), %eax
; AVX2-NEXT:    vpgatherqd %xmm2, (%eax,%xmm1,2), %xmm0
; AVX2-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_avx2_gather_q_d:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    movl {{[0-9]+}}(%esp), %eax
; AVX512VL-NEXT:    vpgatherqd %xmm2, (%eax,%xmm1,2), %xmm0
; AVX512VL-NEXT:    retl
  %res = call <4 x i32> @llvm.x86.avx2.gather.q.d(<4 x i32> %a0,
                            i8* %a1, <2 x i64> %idx, <4 x i32> %mask, i8 2) ;
  ret <4 x i32> %res
}
declare <4 x i32> @llvm.x86.avx2.gather.q.d(<4 x i32>, i8*,
                      <2 x i64>, <4 x i32>, i8) nounwind readonly

define <4 x i32> @test_x86_avx2_gather_q_d_256(<4 x i32> %a0, i8* %a1, <4 x i64> %idx, <4 x i32> %mask) {
; AVX2-LABEL: test_x86_avx2_gather_q_d_256:
; AVX2:       ## BB#0:
; AVX2-NEXT:    movl {{[0-9]+}}(%esp), %eax
; AVX2-NEXT:    vpgatherqd %xmm2, (%eax,%ymm1,2), %xmm0
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_avx2_gather_q_d_256:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    movl {{[0-9]+}}(%esp), %eax
; AVX512VL-NEXT:    vpgatherqd %xmm2, (%eax,%ymm1,2), %xmm0
; AVX512VL-NEXT:    retl
  %res = call <4 x i32> @llvm.x86.avx2.gather.q.d.256(<4 x i32> %a0,
                            i8* %a1, <4 x i64> %idx, <4 x i32> %mask, i8 2) ;
  ret <4 x i32> %res
}
declare <4 x i32> @llvm.x86.avx2.gather.q.d.256(<4 x i32>, i8*,
                      <4 x i64>, <4 x i32>, i8) nounwind readonly

; PR13298
define <8 x float>  @test_gather_mask(<8 x float> %a0, float* %a, <8 x i32> %idx, <8 x float> %mask, float* nocapture %out) {
;; gather with mask
; AVX2-LABEL: test_gather_mask:
; AVX2:       ## BB#0:
; AVX2-NEXT:    movl {{[0-9]+}}(%esp), %eax
; AVX2-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; AVX2-NEXT:    vmovaps %ymm2, %ymm3
; AVX2-NEXT:    vgatherdps %ymm3, (%ecx,%ymm1,4), %ymm0
; AVX2-NEXT:    vmovups %ymm2, (%eax)
; AVX2-NEXT:    retl
;
; AVX512VL-LABEL: test_gather_mask:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    movl {{[0-9]+}}(%esp), %eax
; AVX512VL-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; AVX512VL-NEXT:    vmovaps %zmm2, %zmm3
; AVX512VL-NEXT:    vgatherdps %ymm3, (%ecx,%ymm1,4), %ymm0
; AVX512VL-NEXT:    vmovups %ymm2, (%eax)
; AVX512VL-NEXT:    retl
  %a_i8 = bitcast float* %a to i8*
  %res = call <8 x float> @llvm.x86.avx2.gather.d.ps.256(<8 x float> %a0,
                           i8* %a_i8, <8 x i32> %idx, <8 x float> %mask, i8 4) ;

;; for debugging, we'll just dump out the mask
  %out_ptr = bitcast float * %out to <8 x float> *
  store <8 x float> %mask, <8 x float> * %out_ptr, align 4

  ret <8 x float> %res
}
