// RUN: llvm-mc -triple x86_64-unknown-unknown -x86-asm-syntax=intel -output-asm-variant=1 -mcpu=knl --show-encoding %s | FileCheck %s

// CHECK: vaddps  zmm1, zmm1, zmmword ptr [rax]
// CHECK: encoding: [0x62,0xf1,0x74,0x48,0x58,0x08]
vaddps zmm1, zmm1, zmmword ptr [rax]

// CHECK: vaddpd  zmm1, zmm1, zmm2
// CHECK:  encoding: [0x62,0xf1,0xf5,0x48,0x58,0xca]
vaddpd zmm1, zmm1, zmm2

// CHECK: vaddpd  zmm1 {k5}, zmm1, zmm2
// CHECK:  encoding: [0x62,0xf1,0xf5,0x4d,0x58,0xca]
vaddpd zmm1 {k5}, zmm1, zmm2

// CHECK: vaddpd zmm1 {k5} {z}, zmm1, zmm2
// CHECK:  encoding: [0x62,0xf1,0xf5,0xcd,0x58,0xca]
vaddpd zmm1 {k5} {z}, zmm1, zmm2

// CHECK: vaddpd zmm1, zmm1, zmm2, {rn-sae}
// CHECK:  encoding: [0x62,0xf1,0xf5,0x18,0x58,0xca]
vaddpd zmm1, zmm1, zmm2, {rn-sae}

// CHECK: vaddpd zmm1, zmm1, zmm2, {ru-sae}
// CHECK:  encoding: [0x62,0xf1,0xf5,0x58,0x58,0xca]
vaddpd zmm1, zmm1, zmm2, {ru-sae}

// CHECK:  vaddpd zmm1, zmm1, zmm2, {rd-sae}
// CHECK:  encoding: [0x62,0xf1,0xf5,0x38,0x58,0xca]
vaddpd zmm1, zmm1, zmm2, {rd-sae}

// CHECK: vaddpd zmm1, zmm1, zmm2, {rz-sae}
// CHECK:  encoding: [0x62,0xf1,0xf5,0x78,0x58,0xca]
vaddpd zmm1, zmm1, zmm2, {rz-sae}

// CHECK: vcmppd k2, zmm12, zmm26, 171
// CHECK:  encoding: [0x62,0x91,0x9d,0x48,0xc2,0xd2,0xab]
          vcmppd k2,zmm12,zmm26,0xab

// CHECK: vcmppd k2 {k3}, zmm12, zmm26, 171
// CHECK:  encoding: [0x62,0x91,0x9d,0x4b,0xc2,0xd2,0xab]
          vcmppd k2{k3},zmm12,zmm26,0xab

// CHECK: vcmppd k2, zmm12, zmm26, {sae}, 171
// CHECK:  encoding: [0x62,0x91,0x9d,0x18,0xc2,0xd2,0xab]
          vcmppd k2,zmm12,zmm26,{sae},0xab

// CHECK: vcmppd k2, zmm12, zmm26, 123
// CHECK:  encoding: [0x62,0x91,0x9d,0x48,0xc2,0xd2,0x7b]
          vcmppd k2 ,zmm12,zmm26,0x7b

// CHECK: vcmppd k2, zmm12, zmm26, {sae}, 123
// CHECK:  encoding: [0x62,0x91,0x9d,0x18,0xc2,0xd2,0x7b]
          vcmppd k2,zmm12,zmm26,{sae},0x7b

// CHECK: vcmppd k2, zmm12, zmmword ptr [rcx], 123
// CHECK:  encoding: [0x62,0xf1,0x9d,0x48,0xc2,0x11,0x7b]
          vcmppd k2,zmm12,zmmword PTR [rcx],0x7b

// CHECK: vcmppd  k2, zmm12, zmmword ptr [rax + 8*r14 + 291], 123
// CHECK:  encoding: [0x62,0xb1,0x9d,0x48,0xc2,0x94,0xf0,0x23,0x01,0x00,0x00,0x7b]
          vcmppd k2 ,zmm12,zmmword PTR [rax+r14*8+0x123],0x7b

// CHECK: vcmppd  k2, zmm12, qword ptr [rcx]{1to8}, 123
// CHECK:  encoding: [0x62,0xf1,0x9d,0x58,0xc2,0x11,0x7b]
          vcmppd k2,zmm12,QWORD PTR [rcx]{1to8},0x7b

// CHECK: vcmppd  k2, zmm12, zmmword ptr [rdx + 8128], 123
// CHECK:  encoding: [0x62,0xf1,0x9d,0x48,0xc2,0x52,0x7f,0x7b]
          vcmppd k2,zmm12,zmmword PTR [rdx+0x1fc0],0x7b

// CHECK: vcmppd  k2, zmm12, zmmword ptr [rdx + 8192], 123
// CHECK:  encoding: [0x62,0xf1,0x9d,0x48,0xc2,0x92,0x00,0x20,0x00,0x00,0x7b]
          vcmppd k2,zmm12,zmmword PTR [rdx+0x2000],0x7b

// CHECK: vcmppd  k2, zmm12, zmmword ptr [rdx - 8192], 123
// CHECK:  encoding: [0x62,0xf1,0x9d,0x48,0xc2,0x52,0x80,0x7b]
          vcmppd k2,zmm12,zmmword PTR [rdx-0x2000],0x7b

// CHECK: vcmppd  k2, zmm12, zmmword ptr [rdx - 8256], 123
// CHECK:  encoding: [0x62,0xf1,0x9d,0x48,0xc2,0x92,0xc0,0xdf,0xff,0xff,0x7b]
          vcmppd k2,zmm12,zmmword PTR [rdx-0x2040],0x7b

// CHECK: vcmppd  k2, zmm12, qword ptr [rdx + 1016]{1to8}, 123
// CHECK:  encoding: [0x62,0xf1,0x9d,0x58,0xc2,0x52,0x7f,0x7b]
          vcmppd k2,zmm12,QWORD PTR [rdx+0x3f8]{1to8},0x7b

// CHECK: vcmppd  k2, zmm12, qword ptr [rdx + 1024]{1to8}, 123
// CHECK:  encoding: [0x62,0xf1,0x9d,0x58,0xc2,0x92,0x00,0x04,0x00,0x00,0x7b]
          vcmppd k2,zmm12,QWORD PTR [rdx+0x400]{1to8},0x7b

// CHECK: vcmppd  k2, zmm12, qword ptr [rdx - 1024]{1to8}, 123
// CHECK:  encoding: [0x62,0xf1,0x9d,0x58,0xc2,0x52,0x80,0x7b]
          vcmppd k2,zmm12,QWORD PTR [rdx-0x400]{1to8},0x7b

// CHECK: vcmppd  k2, zmm12, qword ptr [rdx - 1032]{1to8}, 123
// CHECK:  encoding: [0x62,0xf1,0x9d,0x58,0xc2,0x92,0xf8,0xfb,0xff,0xff,0x7b]
          vcmppd k2,zmm12,QWORD PTR [rdx-0x408]{1to8},0x7b

// CHECK: vcmpps  k2, zmm17, zmm22, 171
// CHECK:  encoding: [0x62,0xb1,0x74,0x40,0xc2,0xd6,0xab]
          vcmpps k2,zmm17,zmm22,0xab

// CHECK: vcmpps  k2 {k3}, zmm17, zmm22, 171
// CHECK:  encoding: [0x62,0xb1,0x74,0x43,0xc2,0xd6,0xab]
          vcmpps k2{k3},zmm17,zmm22,0xab

// CHECK: vcmpps  k2, zmm17, zmm22, {sae}, 171
// CHECK:  encoding: [0x62,0xb1,0x74,0x10,0xc2,0xd6,0xab]
          vcmpps k2,zmm17,zmm22,{sae},0xab

// CHECK: vcmpps  k2, zmm17, zmm22, 123
// CHECK:  encoding: [0x62,0xb1,0x74,0x40,0xc2,0xd6,0x7b]
          vcmpps k2,zmm17,zmm22,0x7b

// CHECK: vcmpps  k2, zmm17, zmm22, {sae}, 123
// CHECK:  encoding: [0x62,0xb1,0x74,0x10,0xc2,0xd6,0x7b]
          vcmpps k2,zmm17,zmm22,{sae},0x7b

// CHECK: vcmpps  k2, zmm17, zmmword ptr [rcx], 123
// CHECK:  encoding: [0x62,0xf1,0x74,0x40,0xc2,0x11,0x7b]
          vcmpps k2,zmm17,zmmword PTR [rcx],0x7b

// CHECK: vcmpps  k2, zmm17, zmmword ptr [rax + 8*r14 + 291], 123
// CHECK:  encoding: [0x62,0xb1,0x74,0x40,0xc2,0x94,0xf0,0x23,0x01,0x00,0x00,0x7b]
          vcmpps k2,zmm17,zmmword PTR [rax+r14*8+0x123],0x7b

// CHECK: vcmpps  k2, zmm17, dword ptr [rcx]{1to16}, 123
// CHECK:  encoding: [0x62,0xf1,0x74,0x50,0xc2,0x11,0x7b]
          vcmpps k2,zmm17,DWORD PTR [rcx]{1to16},0x7b

// CHECK: vcmpps  k2, zmm17, zmmword ptr [rdx + 8128], 123
// CHECK:  encoding: [0x62,0xf1,0x74,0x40,0xc2,0x52,0x7f,0x7b]
          vcmpps k2,zmm17,zmmword PTR [rdx+0x1fc0],0x7b

// CHECK: vcmpps  k2, zmm17, zmmword ptr [rdx + 8192], 123
// CHECK:  encoding: [0x62,0xf1,0x74,0x40,0xc2,0x92,0x00,0x20,0x00,0x00,0x7b]
          vcmpps k2,zmm17,zmmword PTR [rdx+0x2000],0x7b

// CHECK: vcmpps  k2, zmm17, zmmword ptr [rdx - 8192], 123
// CHECK:  encoding: [0x62,0xf1,0x74,0x40,0xc2,0x52,0x80,0x7b]
          vcmpps k2,zmm17,zmmword PTR [rdx-0x2000],0x7b

// CHECK: vcmpps  k2, zmm17, zmmword ptr [rdx - 8256], 123
// CHECK:  encoding: [0x62,0xf1,0x74,0x40,0xc2,0x92,0xc0,0xdf,0xff,0xff,0x7b]
          vcmpps k2,zmm17,zmmword PTR [rdx-0x2040],0x7b

// CHECK: vcmpps  k2, zmm17, dword ptr [rdx + 508]{1to16}, 123
// CHECK:  encoding: [0x62,0xf1,0x74,0x50,0xc2,0x52,0x7f,0x7b]
          vcmpps k2,zmm17,DWORD PTR [rdx+0x1fc]{1to16},0x7b

// CHECK: vcmpps  k2, zmm17, dword ptr [rdx + 512]{1to16}, 123
// CHECK:  encoding: [0x62,0xf1,0x74,0x50,0xc2,0x92,0x00,0x02,0x00,0x00,0x7b]
          vcmpps k2,zmm17,DWORD PTR [rdx+0x200]{1to16},0x7b

// CHECK: vcmpps  k2, zmm17, dword ptr [rdx - 512]{1to16}, 123
// CHECK:  encoding: [0x62,0xf1,0x74,0x50,0xc2,0x52,0x80,0x7b]
          vcmpps k2,zmm17,DWORD PTR [rdx-0x200]{1to16},0x7b

// CHECK: vcmpps  k2, zmm17, dword ptr [rdx - 516]{1to16}, 123
// CHECK:  encoding: [0x62,0xf1,0x74,0x50,0xc2,0x92,0xfc,0xfd,0xff,0xff,0x7b]
          vcmpps k2,zmm17,DWORD PTR [rdx-0x204]{1to16},0x7b


// CHECK:  vfixupimmss  xmm15, xmm18, xmm28, 171
// CHECK:  encoding: [0x62,0x13,0x6d,0x00,0x55,0xfc,0xab]
          vfixupimmss xmm15,xmm18,xmm28,0xab

// CHECK:  vfixupimmss  xmm15 {k5}, xmm18, xmm28, 171
// CHECK:  encoding: [0x62,0x13,0x6d,0x05,0x55,0xfc,0xab]
          vfixupimmss xmm15{k5},xmm18,xmm28,0xab

// CHECK:  vfixupimmss  xmm15 {k5} {z}, xmm18, xmm28, 171
// CHECK:  encoding: [0x62,0x13,0x6d,0x85,0x55,0xfc,0xab]
          vfixupimmss xmm15{k5} {z},xmm18,xmm28,0xab

// CHECK:  vfixupimmss  xmm15, xmm18, xmm28, {sae}, 171
// CHECK:  encoding: [0x62,0x13,0x6d,0x10,0x55,0xfc,0xab]
          vfixupimmss xmm15,xmm18,xmm28,{sae},0xab

// CHECK:  vfixupimmss  xmm15, xmm18, xmm28, 123
// CHECK:  encoding: [0x62,0x13,0x6d,0x00,0x55,0xfc,0x7b]
          vfixupimmss xmm15,xmm18,xmm28,0x7b

// CHECK:  vfixupimmss  xmm15, xmm18, xmm28, {sae}, 123
// CHECK:  encoding: [0x62,0x13,0x6d,0x10,0x55,0xfc,0x7b]
          vfixupimmss xmm15,xmm18,xmm28,{sae},0x7b

// CHECK:  vfixupimmss  xmm15, xmm18, dword ptr [rcx], 123
// CHECK:  encoding: [0x62,0x73,0x6d,0x00,0x55,0x39,0x7b]
          vfixupimmss xmm15,xmm18,DWORD PTR [rcx],0x7b

// CHECK:  vfixupimmss  xmm15, xmm18, dword ptr [rax + 8*r14 + 291], 123
// CHECK:  encoding: [0x62,0x33,0x6d,0x00,0x55,0xbc,0xf0,0x23,0x01,0x00,0x00,0x7b]
          vfixupimmss xmm15,xmm18,DWORD PTR [rax+r14*8+0x123],0x7b

// CHECK:  vfixupimmss  xmm15, xmm18, dword ptr [rdx + 508], 123
// CHECK:  encoding: [0x62,0x73,0x6d,0x00,0x55,0x7a,0x7f,0x7b]
          vfixupimmss xmm15,xmm18,DWORD PTR [rdx+0x1fc],0x7b

// CHECK:  vfixupimmss  xmm15, xmm18, dword ptr [rdx + 512], 123
// CHECK:  encoding: [0x62,0x73,0x6d,0x00,0x55,0xba,0x00,0x02,0x00,0x00,0x7b]
          vfixupimmss xmm15,xmm18,DWORD PTR [rdx+0x200],0x7b

// CHECK:  vfixupimmss  xmm15, xmm18, dword ptr [rdx - 512], 123
// CHECK:  encoding: [0x62,0x73,0x6d,0x00,0x55,0x7a,0x80,0x7b]
          vfixupimmss xmm15,xmm18,DWORD PTR [rdx-0x200],0x7b

// CHECK:  vfixupimmss  xmm15, xmm18, dword ptr [rdx - 516], 123
// CHECK:  encoding: [0x62,0x73,0x6d,0x00,0x55,0xba,0xfc,0xfd,0xff,0xff,0x7b]
          vfixupimmss xmm15,xmm18,DWORD PTR [rdx-0x204],0x7b

// CHECK:  vfixupimmsd  xmm13, xmm26, xmm5, 171
// CHECK:  encoding: [0x62,0x73,0xad,0x00,0x55,0xed,0xab]
          vfixupimmsd xmm13,xmm26,xmm5,0xab

// CHECK:  vfixupimmsd  xmm13 {k6}, xmm26, xmm5, 171
// CHECK:  encoding: [0x62,0x73,0xad,0x06,0x55,0xed,0xab]
          vfixupimmsd xmm13{k6},xmm26,xmm5,0xab

// CHECK:  vfixupimmsd  xmm13 {k6} {z}, xmm26, xmm5, 171
// CHECK:  encoding: [0x62,0x73,0xad,0x86,0x55,0xed,0xab]
          vfixupimmsd xmm13{k6} {z},xmm26,xmm5,0xab

// CHECK:  vfixupimmsd  xmm13, xmm26, xmm5, {sae}, 171
// CHECK:  encoding: [0x62,0x73,0xad,0x10,0x55,0xed,0xab]
          vfixupimmsd xmm13,xmm26,xmm5,{sae},0xab

// CHECK:  vfixupimmsd  xmm13, xmm26, xmm5, 123
// CHECK:  encoding: [0x62,0x73,0xad,0x00,0x55,0xed,0x7b]
          vfixupimmsd xmm13,xmm26,xmm5,0x7b

// CHECK:  vfixupimmsd  xmm13, xmm26, xmm5, {sae}, 123
// CHECK:  encoding: [0x62,0x73,0xad,0x10,0x55,0xed,0x7b]
          vfixupimmsd xmm13,xmm26,xmm5,{sae},0x7b

// CHECK:  vfixupimmsd  xmm13, xmm26, qword ptr [rcx], 123
// CHECK:  encoding: [0x62,0x73,0xad,0x00,0x55,0x29,0x7b]
          vfixupimmsd xmm13,xmm26,QWORD PTR [rcx],0x7b

// CHECK:  vfixupimmsd  xmm13, xmm26, qword ptr [rax + 8*r14 + 291], 123
// CHECK:  encoding: [0x62,0x33,0xad,0x00,0x55,0xac,0xf0,0x23,0x01,0x00,0x00,0x7b]
          vfixupimmsd xmm13,xmm26,QWORD PTR [rax+r14*8+0x123],0x7b

// CHECK:  vfixupimmsd  xmm13, xmm26, qword ptr [rdx + 1016], 123
// CHECK:  encoding: [0x62,0x73,0xad,0x00,0x55,0x6a,0x7f,0x7b]
          vfixupimmsd xmm13,xmm26,QWORD PTR [rdx+0x3f8],0x7b

// CHECK:  vfixupimmsd  xmm13, xmm26, qword ptr [rdx + 1024], 123
// CHECK:  encoding: [0x62,0x73,0xad,0x00,0x55,0xaa,0x00,0x04,0x00,0x00,0x7b]
          vfixupimmsd xmm13,xmm26,QWORD PTR [rdx+0x400],0x7b

// CHECK:  vfixupimmsd  xmm13, xmm26, qword ptr [rdx - 1024], 123
// CHECK:  encoding: [0x62,0x73,0xad,0x00,0x55,0x6a,0x80,0x7b]
          vfixupimmsd xmm13,xmm26,QWORD PTR [rdx-0x400],0x7b

// CHECK:  vfixupimmsd  xmm13, xmm26, qword ptr [rdx - 1032], 123
// CHECK:  encoding: [0x62,0x73,0xad,0x00,0x55,0xaa,0xf8,0xfb,0xff,0xff,0x7b]
          vfixupimmsd xmm13,xmm26,QWORD PTR [rdx-0x408],0x7b

// CHECK:  vcomisd xmm23, qword ptr [rcx]
// CHECK:  encoding: [0x62,0xe1,0xfd,0x08,0x2f,0x39]
          vcomisd xmm23, QWORD PTR [rcx]

// CHECK:  vcomiss xmm16, dword ptr [rcx]
// CHECK:  encoding: [0x62,0xe1,0x7c,0x08,0x2f,0x01]
          vcomiss xmm16, DWORD PTR [rcx]

// CHECK: vmovss dword ptr [rcx] {k2}, xmm13
// CHECK:  encoding: [0x62,0x71,0x7e,0x0a,0x11,0x29]
          vmovss dword ptr [rcx] {k2}, xmm13

// CHECK: vmovss dword ptr [rax + 8*r14 + 4660], xmm13
// CHECK:  encoding: [0xc4,0x21,0x7a,0x11,0xac,0xf0,0x34,0x12,0x00,0x00]
          vmovss dword ptr [rax+r14*8+0x1234],xmm13

// CHECK: vmovss dword ptr [rdx + 508], xmm13
// CHECK:  encoding: [0xc5,0x7a,0x11,0xaa,0xfc,0x01,0x00,0x00]
          vmovss dword ptr [rdx+0x1fc],xmm13

// CHECK: vmovss dword ptr [rdx + 512], xmm13
// CHECK:  encoding: [0xc5,0x7a,0x11,0xaa,0x00,0x02,0x00,0x00]
          vmovss dword ptr [rdx+0x200],xmm13

// CHECK: vmovss dword ptr [rdx - 512], xmm13
// CHECK:  encoding: [0xc5,0x7a,0x11,0xaa,0x00,0xfe,0xff,0xff]
          vmovss dword ptr [rdx-0x200],xmm13

// CHECK: vmovss dword ptr [rdx - 516], xmm13
// CHECK:  encoding: [0xc5,0x7a,0x11,0xaa,0xfc,0xfd,0xff,0xff]
          vmovss dword ptr [rdx-0x204],xmm13

// CHECK: vmovss dword ptr [rdx + 508], xmm5
// CHECK:  encoding: [0xc5,0xfa,0x11,0xaa,0xfc,0x01,0x00,0x00]
          vmovss dword ptr [rdx+0x1fc],xmm5

// CHECK: vmovss dword ptr [rdx + 512], xmm5
// CHECK:  encoding: [0xc5,0xfa,0x11,0xaa,0x00,0x02,0x00,0x00]
          vmovss dword ptr [rdx+0x200],xmm5

// CHECK: vmovss dword ptr [rdx - 512], xmm5
// CHECK:  encoding: [0xc5,0xfa,0x11,0xaa,0x00,0xfe,0xff,0xff]
          vmovss dword ptr [rdx-0x200], xmm5

// CHECK: vmovss dword ptr [rdx - 516], xmm5
// CHECK:  encoding: [0xc5,0xfa,0x11,0xaa,0xfc,0xfd,0xff,0xff]
          vmovss dword ptr [rdx-0x204],xmm5

// CHECK: vmovss dword ptr [rcx], xmm13
// CHECK:  encoding: [0xc5,0x7a,0x11,0x29]
          vmovss dword ptr [rcx], xmm13

// CHECK: vmovss xmm2, dword ptr [rcx]
// CHECK:  encoding: [0xc5,0xfa,0x10,0x11]
          vmovss xmm2, dword ptr [rcx]

// CHECK: vmovss xmm2 {k4}, dword ptr [rcx]
// CHECK:  encoding: [0x62,0xf1,0x7e,0x0c,0x10,0x11]
          vmovss xmm2 {k4}, dword ptr [rcx]

// CHECK: vmovss xmm2 {k4} {z}, dword ptr [rcx]
// CHECK:  encoding: [0x62,0xf1,0x7e,0x8c,0x10,0x11]
          vmovss xmm2 {k4} {z}, dword ptr [rcx]

// CHECK: vmovsd xmm25, qword ptr [rcx]
// CHECK:  encoding: [0x62,0x61,0xff,0x08,0x10,0x09]
          vmovsd xmm25, qword ptr [rcx]

// CHECK: vmovsd xmm25 {k3}, qword ptr [rcx]
// CHECK:  encoding: [0x62,0x61,0xff,0x0b,0x10,0x09]
          vmovsd xmm25 {k3}, qword ptr [rcx]

// CHECK: vmovsd xmm25 {k3} {z}, qword ptr [rcx]
// CHECK:  encoding: [0x62,0x61,0xff,0x8b,0x10,0x09]
          vmovsd xmm25 {k3} {z}, qword ptr [rcx]

// CHECK: vmovsd xmm25, qword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0x21,0xff,0x08,0x10,0x8c,0xf0,0x23,0x01,0x00,0x00]
          vmovsd xmm25, qword ptr [rax+r14*8+0x123]

// CHECK: vmovsd xmm25, qword ptr [rdx + 1016]
// CHECK:  encoding: [0x62,0x61,0xff,0x08,0x10,0x4a,0x7f]
          vmovsd xmm25, qword ptr [rdx+0x3f8]

// CHECK: vmovsd xmm25, qword ptr [rdx + 1024]
// CHECK:  encoding: [0x62,0x61,0xff,0x08,0x10,0x8a,0x00,0x04,0x00,0x00]
          vmovsd xmm25, qword ptr [rdx+0x400]

// CHECK: vmovsd xmm25, qword ptr [rdx - 1024]
// CHECK:  encoding: [0x62,0x61,0xff,0x08,0x10,0x4a,0x80]
          vmovsd xmm25, qword ptr [rdx-0x400]

// CHECK: vmovsd xmm25, qword ptr [rdx - 1032]
// CHECK:  encoding: [0x62,0x61,0xff,0x08,0x10,0x8a,0xf8,0xfb,0xff,0xff]
          vmovsd xmm25, qword ptr [rdx-0x408]

// CHECK: vaddpd zmm8, zmm27, zmm6
// CHECK:  encoding: [0x62,0x71,0xa5,0x40,0x58,0xc6]
          vaddpd zmm8, zmm27, zmm6

// CHECK: vaddpd zmm8 {k7}, zmm27, zmm6
// CHECK:  encoding: [0x62,0x71,0xa5,0x47,0x58,0xc6]
          vaddpd zmm8 {k7}, zmm27, zmm6

// CHECK: vaddpd zmm8 {k7} {z}, zmm27, zmm6
// CHECK:  encoding: [0x62,0x71,0xa5,0xc7,0x58,0xc6]
          vaddpd zmm8 {k7} {z}, zmm27, zmm6

// CHECK: vaddpd zmm8, zmm27, zmm6, {rn-sae}
// CHECK:  encoding: [0x62,0x71,0xa5,0x10,0x58,0xc6]
          vaddpd zmm8, zmm27, zmm6, {rn-sae}

// CHECK: vaddpd zmm8, zmm27, zmm6, {ru-sae}
// CHECK:  encoding: [0x62,0x71,0xa5,0x50,0x58,0xc6]
          vaddpd zmm8, zmm27, zmm6, {ru-sae}

// CHECK: vaddpd zmm8, zmm27, zmm6, {rd-sae}
// CHECK:  encoding: [0x62,0x71,0xa5,0x30,0x58,0xc6]
          vaddpd zmm8, zmm27, zmm6, {rd-sae}

// CHECK: vaddpd zmm8, zmm27, zmm6, {rz-sae}
// CHECK:  encoding: [0x62,0x71,0xa5,0x70,0x58,0xc6]
          vaddpd zmm8, zmm27, zmm6, {rz-sae}

// CHECK: vaddpd zmm8, zmm27, zmmword ptr [rcx]
// CHECK:  encoding: [0x62,0x71,0xa5,0x40,0x58,0x01]
          vaddpd zmm8, zmm27, zmmword ptr [rcx]

// CHECK: vaddpd zmm8, zmm27, zmmword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0x31,0xa5,0x40,0x58,0x84,0xf0,0x23,0x01,0x00,0x00]
          vaddpd zmm8, zmm27, zmmword ptr [rax + 8*r14 + 291]

// CHECK: vaddpd zmm8, zmm27, qword ptr [rcx]{1to8}
// CHECK:  encoding: [0x62,0x71,0xa5,0x50,0x58,0x01]
          vaddpd zmm8, zmm27, qword ptr [rcx]{1to8}

// CHECK: vaddpd zmm8, zmm27, zmmword ptr [rdx + 8128]
// CHECK:  encoding: [0x62,0x71,0xa5,0x40,0x58,0x42,0x7f]
          vaddpd zmm8, zmm27, zmmword ptr [rdx + 8128]

// CHECK: vaddpd zmm8, zmm27, zmmword ptr [rdx + 8192]
// CHECK:  encoding: [0x62,0x71,0xa5,0x40,0x58,0x82,0x00,0x20,0x00,0x00]
          vaddpd zmm8, zmm27, zmmword ptr [rdx + 8192]

// CHECK: vaddpd zmm8, zmm27, zmmword ptr [rdx - 8192]
// CHECK:  encoding: [0x62,0x71,0xa5,0x40,0x58,0x42,0x80]
          vaddpd zmm8, zmm27, zmmword ptr [rdx - 8192]

// CHECK: vaddpd zmm8, zmm27, zmmword ptr [rdx - 8256]
// CHECK:  encoding: [0x62,0x71,0xa5,0x40,0x58,0x82,0xc0,0xdf,0xff,0xff]
          vaddpd zmm8, zmm27, zmmword ptr [rdx - 8256]

// CHECK: vaddpd zmm8, zmm27, qword ptr [rdx + 1016]{1to8}
// CHECK:  encoding: [0x62,0x71,0xa5,0x50,0x58,0x42,0x7f]
          vaddpd zmm8, zmm27, qword ptr [rdx + 1016]{1to8}

// CHECK: vaddpd zmm8, zmm27, qword ptr [rdx + 1024]{1to8}
// CHECK:  encoding: [0x62,0x71,0xa5,0x50,0x58,0x82,0x00,0x04,0x00,0x00]
          vaddpd zmm8, zmm27, qword ptr [rdx + 1024]{1to8}

// CHECK: vaddpd zmm8, zmm27, qword ptr [rdx - 1024]{1to8}
// CHECK:  encoding: [0x62,0x71,0xa5,0x50,0x58,0x42,0x80]
          vaddpd zmm8, zmm27, qword ptr [rdx - 1024]{1to8}

// CHECK: vaddpd zmm8, zmm27, qword ptr [rdx - 1032]{1to8}
// CHECK:  encoding: [0x62,0x71,0xa5,0x50,0x58,0x82,0xf8,0xfb,0xff,0xff]
          vaddpd zmm8, zmm27, qword ptr [rdx - 1032]{1to8}

// CHECK: vaddps zmm18, zmm13, zmm2
// CHECK:  encoding: [0x62,0xe1,0x14,0x48,0x58,0xd2]
          vaddps zmm18, zmm13, zmm2

// CHECK: vaddps zmm18 {k4}, zmm13, zmm2
// CHECK:  encoding: [0x62,0xe1,0x14,0x4c,0x58,0xd2]
          vaddps zmm18 {k4}, zmm13, zmm2

// CHECK: vaddps zmm18 {k4} {z}, zmm13, zmm2
// CHECK:  encoding: [0x62,0xe1,0x14,0xcc,0x58,0xd2]
          vaddps zmm18 {k4} {z}, zmm13, zmm2

// CHECK: vaddps zmm18, zmm13, zmm2, {rn-sae}
// CHECK:  encoding: [0x62,0xe1,0x14,0x18,0x58,0xd2]
          vaddps zmm18, zmm13, zmm2, {rn-sae}

// CHECK: vaddps zmm18, zmm13, zmm2, {ru-sae}
// CHECK:  encoding: [0x62,0xe1,0x14,0x58,0x58,0xd2]
          vaddps zmm18, zmm13, zmm2, {ru-sae}

// CHECK: vaddps zmm18, zmm13, zmm2, {rd-sae}
// CHECK:  encoding: [0x62,0xe1,0x14,0x38,0x58,0xd2]
          vaddps zmm18, zmm13, zmm2, {rd-sae}

// CHECK: vaddps zmm18, zmm13, zmm2, {rz-sae}
// CHECK:  encoding: [0x62,0xe1,0x14,0x78,0x58,0xd2]
          vaddps zmm18, zmm13, zmm2, {rz-sae}

// CHECK: vaddps zmm18, zmm13, zmmword ptr [rcx]
// CHECK:  encoding: [0x62,0xe1,0x14,0x48,0x58,0x11]
          vaddps zmm18, zmm13, zmmword ptr [rcx]

// CHECK: vaddps zmm18, zmm13, zmmword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0xa1,0x14,0x48,0x58,0x94,0xf0,0x23,0x01,0x00,0x00]
          vaddps zmm18, zmm13, zmmword ptr [rax + 8*r14 + 291]

// CHECK: vaddps zmm18, zmm13, dword ptr [rcx]{1to16}
// CHECK:  encoding: [0x62,0xe1,0x14,0x58,0x58,0x11]
          vaddps zmm18, zmm13, dword ptr [rcx]{1to16}

// CHECK: vaddps zmm18, zmm13, zmmword ptr [rdx + 8128]
// CHECK:  encoding: [0x62,0xe1,0x14,0x48,0x58,0x52,0x7f]
          vaddps zmm18, zmm13, zmmword ptr [rdx + 8128]

// CHECK: vaddps zmm18, zmm13, zmmword ptr [rdx + 8192]
// CHECK:  encoding: [0x62,0xe1,0x14,0x48,0x58,0x92,0x00,0x20,0x00,0x00]
          vaddps zmm18, zmm13, zmmword ptr [rdx + 8192]

// CHECK: vaddps zmm18, zmm13, zmmword ptr [rdx - 8192]
// CHECK:  encoding: [0x62,0xe1,0x14,0x48,0x58,0x52,0x80]
          vaddps zmm18, zmm13, zmmword ptr [rdx - 8192]

// CHECK: vaddps zmm18, zmm13, zmmword ptr [rdx - 8256]
// CHECK:  encoding: [0x62,0xe1,0x14,0x48,0x58,0x92,0xc0,0xdf,0xff,0xff]
          vaddps zmm18, zmm13, zmmword ptr [rdx - 8256]

// CHECK: vaddps zmm18, zmm13, dword ptr [rdx + 508]{1to16}
// CHECK:  encoding: [0x62,0xe1,0x14,0x58,0x58,0x52,0x7f]
          vaddps zmm18, zmm13, dword ptr [rdx + 508]{1to16}

// CHECK: vaddps zmm18, zmm13, dword ptr [rdx + 512]{1to16}
// CHECK:  encoding: [0x62,0xe1,0x14,0x58,0x58,0x92,0x00,0x02,0x00,0x00]
          vaddps zmm18, zmm13, dword ptr [rdx + 512]{1to16}

// CHECK: vaddps zmm18, zmm13, dword ptr [rdx - 512]{1to16}
// CHECK:  encoding: [0x62,0xe1,0x14,0x58,0x58,0x52,0x80]
          vaddps zmm18, zmm13, dword ptr [rdx - 512]{1to16}

// CHECK: vaddps zmm18, zmm13, dword ptr [rdx - 516]{1to16}
// CHECK:  encoding: [0x62,0xe1,0x14,0x58,0x58,0x92,0xfc,0xfd,0xff,0xff]
          vaddps zmm18, zmm13, dword ptr [rdx - 516]{1to16}

// CHECK: vaddsd xmm3, xmm17, xmm8
// CHECK:  encoding: [0x62,0xd1,0xf7,0x00,0x58,0xd8]
          vaddsd xmm3, xmm17, xmm8

// CHECK: vaddsd xmm3 {k3}, xmm17, xmm8
// CHECK:  encoding: [0x62,0xd1,0xf7,0x03,0x58,0xd8]
          vaddsd xmm3 {k3}, xmm17, xmm8

// CHECK: vaddsd xmm3 {k3} {z}, xmm17, xmm8
// CHECK:  encoding: [0x62,0xd1,0xf7,0x83,0x58,0xd8]
          vaddsd xmm3 {k3} {z}, xmm17, xmm8

// CHECK: vaddsd xmm3, xmm17, xmm8, {rn-sae}
// CHECK:  encoding: [0x62,0xd1,0xf7,0x10,0x58,0xd8]
          vaddsd xmm3, xmm17, xmm8, {rn-sae}

// CHECK: vaddsd xmm3, xmm17, xmm8, {ru-sae}
// CHECK:  encoding: [0x62,0xd1,0xf7,0x50,0x58,0xd8]
          vaddsd xmm3, xmm17, xmm8, {ru-sae}

// CHECK: vaddsd xmm3, xmm17, xmm8, {rd-sae}
// CHECK:  encoding: [0x62,0xd1,0xf7,0x30,0x58,0xd8]
          vaddsd xmm3, xmm17, xmm8, {rd-sae}

// CHECK: vaddsd xmm3, xmm17, xmm8, {rz-sae}
// CHECK:  encoding: [0x62,0xd1,0xf7,0x70,0x58,0xd8]
          vaddsd xmm3, xmm17, xmm8, {rz-sae}

// CHECK: vaddsd xmm3, xmm17, qword ptr [rcx]
// CHECK:  encoding: [0x62,0xf1,0xf7,0x00,0x58,0x19]
          vaddsd xmm3, xmm17, qword ptr [rcx]

// CHECK: vaddsd xmm3, xmm17, qword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0xb1,0xf7,0x00,0x58,0x9c,0xf0,0x23,0x01,0x00,0x00]
          vaddsd xmm3, xmm17, qword ptr [rax + 8*r14 + 291]

// CHECK: vaddsd xmm3, xmm17, qword ptr [rdx + 1016]
// CHECK:  encoding: [0x62,0xf1,0xf7,0x00,0x58,0x5a,0x7f]
          vaddsd xmm3, xmm17, qword ptr [rdx + 1016]

// CHECK: vaddsd xmm3, xmm17, qword ptr [rdx + 1024]
// CHECK:  encoding: [0x62,0xf1,0xf7,0x00,0x58,0x9a,0x00,0x04,0x00,0x00]
          vaddsd xmm3, xmm17, qword ptr [rdx + 1024]

// CHECK: vaddsd xmm3, xmm17, qword ptr [rdx - 1024]
// CHECK:  encoding: [0x62,0xf1,0xf7,0x00,0x58,0x5a,0x80]
          vaddsd xmm3, xmm17, qword ptr [rdx - 1024]

// CHECK: vaddsd xmm3, xmm17, qword ptr [rdx - 1032]
// CHECK:  encoding: [0x62,0xf1,0xf7,0x00,0x58,0x9a,0xf8,0xfb,0xff,0xff]
          vaddsd xmm3, xmm17, qword ptr [rdx - 1032]

// CHECK: vaddss xmm7, xmm5, xmm19
// CHECK:  encoding: [0x62,0xb1,0x56,0x08,0x58,0xfb]
          vaddss xmm7, xmm5, xmm19

// CHECK: vaddss xmm7 {k2}, xmm5, xmm19
// CHECK:  encoding: [0x62,0xb1,0x56,0x0a,0x58,0xfb]
          vaddss xmm7 {k2}, xmm5, xmm19

// CHECK: vaddss xmm7 {k2} {z}, xmm5, xmm19
// CHECK:  encoding: [0x62,0xb1,0x56,0x8a,0x58,0xfb]
          vaddss xmm7 {k2} {z}, xmm5, xmm19

// CHECK: vaddss xmm7, xmm5, xmm19, {rn-sae}
// CHECK:  encoding: [0x62,0xb1,0x56,0x18,0x58,0xfb]
          vaddss xmm7, xmm5, xmm19, {rn-sae}

// CHECK: vaddss xmm7, xmm5, xmm19, {ru-sae}
// CHECK:  encoding: [0x62,0xb1,0x56,0x58,0x58,0xfb]
          vaddss xmm7, xmm5, xmm19, {ru-sae}

// CHECK: vaddss xmm7, xmm5, xmm19, {rd-sae}
// CHECK:  encoding: [0x62,0xb1,0x56,0x38,0x58,0xfb]
          vaddss xmm7, xmm5, xmm19, {rd-sae}

// CHECK: vaddss xmm7, xmm5, xmm19, {rz-sae}
// CHECK:  encoding: [0x62,0xb1,0x56,0x78,0x58,0xfb]
          vaddss xmm7, xmm5, xmm19, {rz-sae}

// CHECK: vaddss xmm7, xmm5, dword ptr [rcx]
// CHECK:  encoding: [0xc5,0xd2,0x58,0x39]
          vaddss xmm7, xmm5, dword ptr [rcx]

// CHECK: vaddss xmm7, xmm5, dword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0xc4,0xa1,0x52,0x58,0xbc,0xf0,0x23,0x01,0x00,0x00]
          vaddss xmm7, xmm5, dword ptr [rax + 8*r14 + 291]

// CHECK: vaddss xmm7, xmm5, dword ptr [rdx + 508]
// CHECK:  encoding: [0xc5,0xd2,0x58,0xba,0xfc,0x01,0x00,0x00]
          vaddss xmm7, xmm5, dword ptr [rdx + 508]

// CHECK: vaddss xmm7, xmm5, dword ptr [rdx + 512]
// CHECK:  encoding: [0xc5,0xd2,0x58,0xba,0x00,0x02,0x00,0x00]
          vaddss xmm7, xmm5, dword ptr [rdx + 512]

// CHECK: vaddss xmm7, xmm5, dword ptr [rdx - 512]
// CHECK:  encoding: [0xc5,0xd2,0x58,0xba,0x00,0xfe,0xff,0xff]
          vaddss xmm7, xmm5, dword ptr [rdx - 512]

// CHECK: vaddss xmm7, xmm5, dword ptr [rdx - 516]
// CHECK:  encoding: [0xc5,0xd2,0x58,0xba,0xfc,0xfd,0xff,0xff]
          vaddss xmm7, xmm5, dword ptr [rdx - 516]

// CHECK: valignd zmm9, zmm18, zmm26, 171
// CHECK:  encoding: [0x62,0x13,0x6d,0x40,0x03,0xca,0xab]
          valignd zmm9, zmm18, zmm26, 171

// CHECK: valignd zmm9 {k4}, zmm18, zmm26, 171
// CHECK:  encoding: [0x62,0x13,0x6d,0x44,0x03,0xca,0xab]
          valignd zmm9 {k4}, zmm18, zmm26, 171

// CHECK: valignd zmm9 {k4} {z}, zmm18, zmm26, 171
// CHECK:  encoding: [0x62,0x13,0x6d,0xc4,0x03,0xca,0xab]
          valignd zmm9 {k4} {z}, zmm18, zmm26, 171

// CHECK: valignd zmm9, zmm18, zmm26, 123
// CHECK:  encoding: [0x62,0x13,0x6d,0x40,0x03,0xca,0x7b]
          valignd zmm9, zmm18, zmm26, 123

// CHECK: valignd zmm9, zmm18, zmmword ptr [rcx], 123
// CHECK:  encoding: [0x62,0x73,0x6d,0x40,0x03,0x09,0x7b]
          valignd zmm9, zmm18, zmmword ptr [rcx], 123

// CHECK: valignd zmm9, zmm18, zmmword ptr [rax + 8*r14 + 291], 123
// CHECK:  encoding: [0x62,0x33,0x6d,0x40,0x03,0x8c,0xf0,0x23,0x01,0x00,0x00,0x7b]
          valignd zmm9, zmm18, zmmword ptr [rax + 8*r14 + 291], 123

// CHECK: valignd zmm9, zmm18, dword ptr [rcx]{1to16}, 123
// CHECK:  encoding: [0x62,0x73,0x6d,0x50,0x03,0x09,0x7b]
          valignd zmm9, zmm18, dword ptr [rcx]{1to16}, 123

// CHECK: valignd zmm9, zmm18, zmmword ptr [rdx + 8128], 123
// CHECK:  encoding: [0x62,0x73,0x6d,0x40,0x03,0x4a,0x7f,0x7b]
          valignd zmm9, zmm18, zmmword ptr [rdx + 8128], 123

// CHECK: valignd zmm9, zmm18, zmmword ptr [rdx + 8192], 123
// CHECK:  encoding: [0x62,0x73,0x6d,0x40,0x03,0x8a,0x00,0x20,0x00,0x00,0x7b]
          valignd zmm9, zmm18, zmmword ptr [rdx + 8192], 123

// CHECK: valignd zmm9, zmm18, zmmword ptr [rdx - 8192], 123
// CHECK:  encoding: [0x62,0x73,0x6d,0x40,0x03,0x4a,0x80,0x7b]
          valignd zmm9, zmm18, zmmword ptr [rdx - 8192], 123

// CHECK: valignd zmm9, zmm18, zmmword ptr [rdx - 8256], 123
// CHECK:  encoding: [0x62,0x73,0x6d,0x40,0x03,0x8a,0xc0,0xdf,0xff,0xff,0x7b]
          valignd zmm9, zmm18, zmmword ptr [rdx - 8256], 123

// CHECK: valignd zmm9, zmm18, dword ptr [rdx + 508]{1to16}, 123
// CHECK:  encoding: [0x62,0x73,0x6d,0x50,0x03,0x4a,0x7f,0x7b]
          valignd zmm9, zmm18, dword ptr [rdx + 508]{1to16}, 123

// CHECK: valignd zmm9, zmm18, dword ptr [rdx + 512]{1to16}, 123
// CHECK:  encoding: [0x62,0x73,0x6d,0x50,0x03,0x8a,0x00,0x02,0x00,0x00,0x7b]
          valignd zmm9, zmm18, dword ptr [rdx + 512]{1to16}, 123

// CHECK: valignd zmm9, zmm18, dword ptr [rdx - 512]{1to16}, 123
// CHECK:  encoding: [0x62,0x73,0x6d,0x50,0x03,0x4a,0x80,0x7b]
          valignd zmm9, zmm18, dword ptr [rdx - 512]{1to16}, 123

// CHECK: valignd zmm9, zmm18, dword ptr [rdx - 516]{1to16}, 123
// CHECK:  encoding: [0x62,0x73,0x6d,0x50,0x03,0x8a,0xfc,0xfd,0xff,0xff,0x7b]
          valignd zmm9, zmm18, dword ptr [rdx - 516]{1to16}, 123

// CHECK: vblendmpd zmm8, zmm28, zmm12
// CHECK:  encoding: [0x62,0x52,0x9d,0x40,0x65,0xc4]
          vblendmpd zmm8, zmm28, zmm12

// CHECK: vblendmpd zmm8 {k1}, zmm28, zmm12
// CHECK:  encoding: [0x62,0x52,0x9d,0x41,0x65,0xc4]
          vblendmpd zmm8 {k1}, zmm28, zmm12

// CHECK: vblendmpd zmm8 {k1} {z}, zmm28, zmm12
// CHECK:  encoding: [0x62,0x52,0x9d,0xc1,0x65,0xc4]
          vblendmpd zmm8 {k1} {z}, zmm28, zmm12

// CHECK: vblendmpd zmm8, zmm28, zmmword ptr [rcx]
// CHECK:  encoding: [0x62,0x72,0x9d,0x40,0x65,0x01]
          vblendmpd zmm8, zmm28, zmmword ptr [rcx]

// CHECK: vblendmpd zmm8, zmm28, zmmword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0x32,0x9d,0x40,0x65,0x84,0xf0,0x23,0x01,0x00,0x00]
          vblendmpd zmm8, zmm28, zmmword ptr [rax + 8*r14 + 291]

// CHECK: vblendmpd zmm8, zmm28, qword ptr [rcx]{1to8}
// CHECK:  encoding: [0x62,0x72,0x9d,0x50,0x65,0x01]
          vblendmpd zmm8, zmm28, qword ptr [rcx]{1to8}

// CHECK: vblendmpd zmm8, zmm28, zmmword ptr [rdx + 8128]
// CHECK:  encoding: [0x62,0x72,0x9d,0x40,0x65,0x42,0x7f]
          vblendmpd zmm8, zmm28, zmmword ptr [rdx + 8128]

// CHECK: vblendmpd zmm8, zmm28, zmmword ptr [rdx + 8192]
// CHECK:  encoding: [0x62,0x72,0x9d,0x40,0x65,0x82,0x00,0x20,0x00,0x00]
          vblendmpd zmm8, zmm28, zmmword ptr [rdx + 8192]

// CHECK: vblendmpd zmm8, zmm28, zmmword ptr [rdx - 8192]
// CHECK:  encoding: [0x62,0x72,0x9d,0x40,0x65,0x42,0x80]
          vblendmpd zmm8, zmm28, zmmword ptr [rdx - 8192]

// CHECK: vblendmpd zmm8, zmm28, zmmword ptr [rdx - 8256]
// CHECK:  encoding: [0x62,0x72,0x9d,0x40,0x65,0x82,0xc0,0xdf,0xff,0xff]
          vblendmpd zmm8, zmm28, zmmword ptr [rdx - 8256]

// CHECK: vblendmpd zmm8, zmm28, qword ptr [rdx + 1016]{1to8}
// CHECK:  encoding: [0x62,0x72,0x9d,0x50,0x65,0x42,0x7f]
          vblendmpd zmm8, zmm28, qword ptr [rdx + 1016]{1to8}

// CHECK: vblendmpd zmm8, zmm28, qword ptr [rdx + 1024]{1to8}
// CHECK:  encoding: [0x62,0x72,0x9d,0x50,0x65,0x82,0x00,0x04,0x00,0x00]
          vblendmpd zmm8, zmm28, qword ptr [rdx + 1024]{1to8}

// CHECK: vblendmpd zmm8, zmm28, qword ptr [rdx - 1024]{1to8}
// CHECK:  encoding: [0x62,0x72,0x9d,0x50,0x65,0x42,0x80]
          vblendmpd zmm8, zmm28, qword ptr [rdx - 1024]{1to8}

// CHECK: vblendmpd zmm8, zmm28, qword ptr [rdx - 1032]{1to8}
// CHECK:  encoding: [0x62,0x72,0x9d,0x50,0x65,0x82,0xf8,0xfb,0xff,0xff]
          vblendmpd zmm8, zmm28, qword ptr [rdx - 1032]{1to8}

// CHECK: vblendmps zmm15, zmm28, zmm4
// CHECK:  encoding: [0x62,0x72,0x1d,0x40,0x65,0xfc]
          vblendmps zmm15, zmm28, zmm4

// CHECK: vblendmps zmm15 {k3}, zmm28, zmm4
// CHECK:  encoding: [0x62,0x72,0x1d,0x43,0x65,0xfc]
          vblendmps zmm15 {k3}, zmm28, zmm4

// CHECK: vblendmps zmm15 {k3} {z}, zmm28, zmm4
// CHECK:  encoding: [0x62,0x72,0x1d,0xc3,0x65,0xfc]
          vblendmps zmm15 {k3} {z}, zmm28, zmm4

// CHECK: vblendmps zmm15, zmm28, zmmword ptr [rcx]
// CHECK:  encoding: [0x62,0x72,0x1d,0x40,0x65,0x39]
          vblendmps zmm15, zmm28, zmmword ptr [rcx]

// CHECK: vblendmps zmm15, zmm28, zmmword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0x32,0x1d,0x40,0x65,0xbc,0xf0,0x23,0x01,0x00,0x00]
          vblendmps zmm15, zmm28, zmmword ptr [rax + 8*r14 + 291]

// CHECK: vblendmps zmm15, zmm28, dword ptr [rcx]{1to16}
// CHECK:  encoding: [0x62,0x72,0x1d,0x50,0x65,0x39]
          vblendmps zmm15, zmm28, dword ptr [rcx]{1to16}

// CHECK: vblendmps zmm15, zmm28, zmmword ptr [rdx + 8128]
// CHECK:  encoding: [0x62,0x72,0x1d,0x40,0x65,0x7a,0x7f]
          vblendmps zmm15, zmm28, zmmword ptr [rdx + 8128]

// CHECK: vblendmps zmm15, zmm28, zmmword ptr [rdx + 8192]
// CHECK:  encoding: [0x62,0x72,0x1d,0x40,0x65,0xba,0x00,0x20,0x00,0x00]
          vblendmps zmm15, zmm28, zmmword ptr [rdx + 8192]

// CHECK: vblendmps zmm15, zmm28, zmmword ptr [rdx - 8192]
// CHECK:  encoding: [0x62,0x72,0x1d,0x40,0x65,0x7a,0x80]
          vblendmps zmm15, zmm28, zmmword ptr [rdx - 8192]

// CHECK: vblendmps zmm15, zmm28, zmmword ptr [rdx - 8256]
// CHECK:  encoding: [0x62,0x72,0x1d,0x40,0x65,0xba,0xc0,0xdf,0xff,0xff]
          vblendmps zmm15, zmm28, zmmword ptr [rdx - 8256]

// CHECK: vblendmps zmm15, zmm28, dword ptr [rdx + 508]{1to16}
// CHECK:  encoding: [0x62,0x72,0x1d,0x50,0x65,0x7a,0x7f]
          vblendmps zmm15, zmm28, dword ptr [rdx + 508]{1to16}

// CHECK: vblendmps zmm15, zmm28, dword ptr [rdx + 512]{1to16}
// CHECK:  encoding: [0x62,0x72,0x1d,0x50,0x65,0xba,0x00,0x02,0x00,0x00]
          vblendmps zmm15, zmm28, dword ptr [rdx + 512]{1to16}

// CHECK: vblendmps zmm15, zmm28, dword ptr [rdx - 512]{1to16}
// CHECK:  encoding: [0x62,0x72,0x1d,0x50,0x65,0x7a,0x80]
          vblendmps zmm15, zmm28, dword ptr [rdx - 512]{1to16}

// CHECK: vblendmps zmm15, zmm28, dword ptr [rdx - 516]{1to16}
// CHECK:  encoding: [0x62,0x72,0x1d,0x50,0x65,0xba,0xfc,0xfd,0xff,0xff]
          vblendmps zmm15, zmm28, dword ptr [rdx - 516]{1to16}

// CHECK: vbroadcastf32x4 zmm3, xmmword ptr [rcx]
// CHECK:  encoding: [0x62,0xf2,0x7d,0x48,0x1a,0x19]
          vbroadcastf32x4 zmm3, xmmword ptr [rcx]

// CHECK: vbroadcastf32x4 zmm3 {k7}, xmmword ptr [rcx]
// CHECK:  encoding: [0x62,0xf2,0x7d,0x4f,0x1a,0x19]
          vbroadcastf32x4 zmm3 {k7}, xmmword ptr [rcx]

// CHECK: vbroadcastf32x4 zmm3 {k7} {z}, xmmword ptr [rcx]
// CHECK:  encoding: [0x62,0xf2,0x7d,0xcf,0x1a,0x19]
          vbroadcastf32x4 zmm3 {k7} {z}, xmmword ptr [rcx]

// CHECK: vbroadcastf32x4 zmm3, xmmword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0xb2,0x7d,0x48,0x1a,0x9c,0xf0,0x23,0x01,0x00,0x00]
          vbroadcastf32x4 zmm3, xmmword ptr [rax + 8*r14 + 291]

// CHECK: vbroadcastf32x4 zmm3, xmmword ptr [rdx + 2032]
// CHECK:  encoding: [0x62,0xf2,0x7d,0x48,0x1a,0x5a,0x7f]
          vbroadcastf32x4 zmm3, xmmword ptr [rdx + 2032]

// CHECK: vbroadcastf32x4 zmm3, xmmword ptr [rdx + 2048]
// CHECK:  encoding: [0x62,0xf2,0x7d,0x48,0x1a,0x9a,0x00,0x08,0x00,0x00]
          vbroadcastf32x4 zmm3, xmmword ptr [rdx + 2048]

// CHECK: vbroadcastf32x4 zmm3, xmmword ptr [rdx - 2048]
// CHECK:  encoding: [0x62,0xf2,0x7d,0x48,0x1a,0x5a,0x80]
          vbroadcastf32x4 zmm3, xmmword ptr [rdx - 2048]

// CHECK: vbroadcastf32x4 zmm3, xmmword ptr [rdx - 2064]
// CHECK:  encoding: [0x62,0xf2,0x7d,0x48,0x1a,0x9a,0xf0,0xf7,0xff,0xff]
          vbroadcastf32x4 zmm3, xmmword ptr [rdx - 2064]

// CHECK: vbroadcastf64x4 zmm25, ymmword ptr [rcx]
// CHECK:  encoding: [0x62,0x62,0xfd,0x48,0x1b,0x09]
          vbroadcastf64x4 zmm25, ymmword ptr [rcx]

// CHECK: vbroadcastf64x4 zmm25 {k6}, ymmword ptr [rcx]
// CHECK:  encoding: [0x62,0x62,0xfd,0x4e,0x1b,0x09]
          vbroadcastf64x4 zmm25 {k6}, ymmword ptr [rcx]

// CHECK: vbroadcastf64x4 zmm25 {k6} {z}, ymmword ptr [rcx]
// CHECK:  encoding: [0x62,0x62,0xfd,0xce,0x1b,0x09]
          vbroadcastf64x4 zmm25 {k6} {z}, ymmword ptr [rcx]

// CHECK: vbroadcastf64x4 zmm25, ymmword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0x22,0xfd,0x48,0x1b,0x8c,0xf0,0x23,0x01,0x00,0x00]
          vbroadcastf64x4 zmm25, ymmword ptr [rax + 8*r14 + 291]

// CHECK: vbroadcastf64x4 zmm25, ymmword ptr [rdx + 4064]
// CHECK:  encoding: [0x62,0x62,0xfd,0x48,0x1b,0x4a,0x7f]
          vbroadcastf64x4 zmm25, ymmword ptr [rdx + 4064]

// CHECK: vbroadcastf64x4 zmm25, ymmword ptr [rdx + 4096]
// CHECK:  encoding: [0x62,0x62,0xfd,0x48,0x1b,0x8a,0x00,0x10,0x00,0x00]
          vbroadcastf64x4 zmm25, ymmword ptr [rdx + 4096]

// CHECK: vbroadcastf64x4 zmm25, ymmword ptr [rdx - 4096]
// CHECK:  encoding: [0x62,0x62,0xfd,0x48,0x1b,0x4a,0x80]
          vbroadcastf64x4 zmm25, ymmword ptr [rdx - 4096]

// CHECK: vbroadcastf64x4 zmm25, ymmword ptr [rdx - 4128]
// CHECK:  encoding: [0x62,0x62,0xfd,0x48,0x1b,0x8a,0xe0,0xef,0xff,0xff]
          vbroadcastf64x4 zmm25, ymmword ptr [rdx - 4128]

// CHECK: vbroadcasti32x4 zmm30, xmmword ptr [rcx]
// CHECK:  encoding: [0x62,0x62,0x7d,0x48,0x5a,0x31]
          vbroadcasti32x4 zmm30, xmmword ptr [rcx]

// CHECK: vbroadcasti32x4 zmm30 {k3}, xmmword ptr [rcx]
// CHECK:  encoding: [0x62,0x62,0x7d,0x4b,0x5a,0x31]
          vbroadcasti32x4 zmm30 {k3}, xmmword ptr [rcx]

// CHECK: vbroadcasti32x4 zmm30 {k3} {z}, xmmword ptr [rcx]
// CHECK:  encoding: [0x62,0x62,0x7d,0xcb,0x5a,0x31]
          vbroadcasti32x4 zmm30 {k3} {z}, xmmword ptr [rcx]

// CHECK: vbroadcasti32x4 zmm30, xmmword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0x22,0x7d,0x48,0x5a,0xb4,0xf0,0x23,0x01,0x00,0x00]
          vbroadcasti32x4 zmm30, xmmword ptr [rax + 8*r14 + 291]

// CHECK: vbroadcasti32x4 zmm30, xmmword ptr [rdx + 2032]
// CHECK:  encoding: [0x62,0x62,0x7d,0x48,0x5a,0x72,0x7f]
          vbroadcasti32x4 zmm30, xmmword ptr [rdx + 2032]

// CHECK: vbroadcasti32x4 zmm30, xmmword ptr [rdx + 2048]
// CHECK:  encoding: [0x62,0x62,0x7d,0x48,0x5a,0xb2,0x00,0x08,0x00,0x00]
          vbroadcasti32x4 zmm30, xmmword ptr [rdx + 2048]

// CHECK: vbroadcasti32x4 zmm30, xmmword ptr [rdx - 2048]
// CHECK:  encoding: [0x62,0x62,0x7d,0x48,0x5a,0x72,0x80]
          vbroadcasti32x4 zmm30, xmmword ptr [rdx - 2048]

// CHECK: vbroadcasti32x4 zmm30, xmmword ptr [rdx - 2064]
// CHECK:  encoding: [0x62,0x62,0x7d,0x48,0x5a,0xb2,0xf0,0xf7,0xff,0xff]
          vbroadcasti32x4 zmm30, xmmword ptr [rdx - 2064]

// CHECK: vbroadcasti64x4 zmm13, ymmword ptr [rcx]
// CHECK:  encoding: [0x62,0x72,0xfd,0x48,0x5b,0x29]
          vbroadcasti64x4 zmm13, ymmword ptr [rcx]

// CHECK: vbroadcasti64x4 zmm13 {k4}, ymmword ptr [rcx]
// CHECK:  encoding: [0x62,0x72,0xfd,0x4c,0x5b,0x29]
          vbroadcasti64x4 zmm13 {k4}, ymmword ptr [rcx]

// CHECK: vbroadcasti64x4 zmm13 {k4} {z}, ymmword ptr [rcx]
// CHECK:  encoding: [0x62,0x72,0xfd,0xcc,0x5b,0x29]
          vbroadcasti64x4 zmm13 {k4} {z}, ymmword ptr [rcx]

// CHECK: vbroadcasti64x4 zmm13, ymmword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0x32,0xfd,0x48,0x5b,0xac,0xf0,0x23,0x01,0x00,0x00]
          vbroadcasti64x4 zmm13, ymmword ptr [rax + 8*r14 + 291]

// CHECK: vbroadcasti64x4 zmm13, ymmword ptr [rdx + 4064]
// CHECK:  encoding: [0x62,0x72,0xfd,0x48,0x5b,0x6a,0x7f]
          vbroadcasti64x4 zmm13, ymmword ptr [rdx + 4064]

// CHECK: vbroadcasti64x4 zmm13, ymmword ptr [rdx + 4096]
// CHECK:  encoding: [0x62,0x72,0xfd,0x48,0x5b,0xaa,0x00,0x10,0x00,0x00]
          vbroadcasti64x4 zmm13, ymmword ptr [rdx + 4096]

// CHECK: vbroadcasti64x4 zmm13, ymmword ptr [rdx - 4096]
// CHECK:  encoding: [0x62,0x72,0xfd,0x48,0x5b,0x6a,0x80]
          vbroadcasti64x4 zmm13, ymmword ptr [rdx - 4096]

// CHECK: vbroadcasti64x4 zmm13, ymmword ptr [rdx - 4128]
// CHECK:  encoding: [0x62,0x72,0xfd,0x48,0x5b,0xaa,0xe0,0xef,0xff,0xff]
          vbroadcasti64x4 zmm13, ymmword ptr [rdx - 4128]

// CHECK: vbroadcastsd zmm30, qword ptr [rcx]
// CHECK:  encoding: [0x62,0x62,0xfd,0x48,0x19,0x31]
          vbroadcastsd zmm30, qword ptr [rcx]

// CHECK: vbroadcastsd zmm30 {k4}, qword ptr [rcx]
// CHECK:  encoding: [0x62,0x62,0xfd,0x4c,0x19,0x31]
          vbroadcastsd zmm30 {k4}, qword ptr [rcx]

// CHECK: vbroadcastsd zmm30 {k4} {z}, qword ptr [rcx]
// CHECK:  encoding: [0x62,0x62,0xfd,0xcc,0x19,0x31]
          vbroadcastsd zmm30 {k4} {z}, qword ptr [rcx]

// CHECK: vbroadcastsd zmm30, qword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0x22,0xfd,0x48,0x19,0xb4,0xf0,0x23,0x01,0x00,0x00]
          vbroadcastsd zmm30, qword ptr [rax + 8*r14 + 291]

// CHECK: vbroadcastsd zmm30, qword ptr [rdx + 1016]
// CHECK:  encoding: [0x62,0x62,0xfd,0x48,0x19,0x72,0x7f]
          vbroadcastsd zmm30, qword ptr [rdx + 1016]

// CHECK: vbroadcastsd zmm30, qword ptr [rdx + 1024]
// CHECK:  encoding: [0x62,0x62,0xfd,0x48,0x19,0xb2,0x00,0x04,0x00,0x00]
          vbroadcastsd zmm30, qword ptr [rdx + 1024]

// CHECK: vbroadcastsd zmm30, qword ptr [rdx - 1024]
// CHECK:  encoding: [0x62,0x62,0xfd,0x48,0x19,0x72,0x80]
          vbroadcastsd zmm30, qword ptr [rdx - 1024]

// CHECK: vbroadcastsd zmm30, qword ptr [rdx - 1032]
// CHECK:  encoding: [0x62,0x62,0xfd,0x48,0x19,0xb2,0xf8,0xfb,0xff,0xff]
          vbroadcastsd zmm30, qword ptr [rdx - 1032]

// CHECK: vbroadcastsd zmm21, xmm22
// CHECK:  encoding: [0x62,0xa2,0xfd,0x48,0x19,0xee]
          vbroadcastsd zmm21, xmm22

// CHECK: vbroadcastsd zmm21 {k7}, xmm22
// CHECK:  encoding: [0x62,0xa2,0xfd,0x4f,0x19,0xee]
          vbroadcastsd zmm21 {k7}, xmm22

// CHECK: vbroadcastsd zmm21 {k7} {z}, xmm22
// CHECK:  encoding: [0x62,0xa2,0xfd,0xcf,0x19,0xee]
          vbroadcastsd zmm21 {k7} {z}, xmm22

// CHECK: vbroadcastss zmm3, dword ptr [rcx]
// CHECK:  encoding: [0x62,0xf2,0x7d,0x48,0x18,0x19]
          vbroadcastss zmm3, dword ptr [rcx]

// CHECK: vbroadcastss zmm3 {k4}, dword ptr [rcx]
// CHECK:  encoding: [0x62,0xf2,0x7d,0x4c,0x18,0x19]
          vbroadcastss zmm3 {k4}, dword ptr [rcx]

// CHECK: vbroadcastss zmm3 {k4} {z}, dword ptr [rcx]
// CHECK:  encoding: [0x62,0xf2,0x7d,0xcc,0x18,0x19]
          vbroadcastss zmm3 {k4} {z}, dword ptr [rcx]

// CHECK: vbroadcastss zmm3, dword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0xb2,0x7d,0x48,0x18,0x9c,0xf0,0x23,0x01,0x00,0x00]
          vbroadcastss zmm3, dword ptr [rax + 8*r14 + 291]

// CHECK: vbroadcastss zmm3, dword ptr [rdx + 508]
// CHECK:  encoding: [0x62,0xf2,0x7d,0x48,0x18,0x5a,0x7f]
          vbroadcastss zmm3, dword ptr [rdx + 508]

// CHECK: vbroadcastss zmm3, dword ptr [rdx + 512]
// CHECK:  encoding: [0x62,0xf2,0x7d,0x48,0x18,0x9a,0x00,0x02,0x00,0x00]
          vbroadcastss zmm3, dword ptr [rdx + 512]

// CHECK: vbroadcastss zmm3, dword ptr [rdx - 512]
// CHECK:  encoding: [0x62,0xf2,0x7d,0x48,0x18,0x5a,0x80]
          vbroadcastss zmm3, dword ptr [rdx - 512]

// CHECK: vbroadcastss zmm3, dword ptr [rdx - 516]
// CHECK:  encoding: [0x62,0xf2,0x7d,0x48,0x18,0x9a,0xfc,0xfd,0xff,0xff]
          vbroadcastss zmm3, dword ptr [rdx - 516]

// CHECK: vbroadcastss zmm18, xmm18
// CHECK:  encoding: [0x62,0xa2,0x7d,0x48,0x18,0xd2]
          vbroadcastss zmm18, xmm18

// CHECK: vbroadcastss zmm18 {k2}, xmm18
// CHECK:  encoding: [0x62,0xa2,0x7d,0x4a,0x18,0xd2]
          vbroadcastss zmm18 {k2}, xmm18

// CHECK: vbroadcastss zmm18 {k2} {z}, xmm18
// CHECK:  encoding: [0x62,0xa2,0x7d,0xca,0x18,0xd2]
          vbroadcastss zmm18 {k2} {z}, xmm18

// CHECK: vcmppd k2, zmm12, zmm26, 171
// CHECK:  encoding: [0x62,0x91,0x9d,0x48,0xc2,0xd2,0xab]
          vcmppd k2, zmm12, zmm26, 171

// CHECK: vcmppd k2 {k3}, zmm12, zmm26, 171
// CHECK:  encoding: [0x62,0x91,0x9d,0x4b,0xc2,0xd2,0xab]
          vcmppd k2 {k3}, zmm12, zmm26, 171

// CHECK: vcmppd k2, zmm12, zmm26, {sae}, 171
// CHECK:  encoding: [0x62,0x91,0x9d,0x18,0xc2,0xd2,0xab]
          vcmppd k2, zmm12, zmm26, {sae}, 171

// CHECK: vcmppd k2, zmm12, zmm26, 123
// CHECK:  encoding: [0x62,0x91,0x9d,0x48,0xc2,0xd2,0x7b]
          vcmppd k2, zmm12, zmm26, 123

// CHECK: vcmppd k2, zmm12, zmm26, {sae}, 123
// CHECK:  encoding: [0x62,0x91,0x9d,0x18,0xc2,0xd2,0x7b]
          vcmppd k2, zmm12, zmm26, {sae}, 123

// CHECK: vcmppd k2, zmm12, zmmword ptr [rcx], 123
// CHECK:  encoding: [0x62,0xf1,0x9d,0x48,0xc2,0x11,0x7b]
          vcmppd k2, zmm12, zmmword ptr [rcx], 123

// CHECK: vcmppd k2, zmm12, zmmword ptr [rax + 8*r14 + 291], 123
// CHECK:  encoding: [0x62,0xb1,0x9d,0x48,0xc2,0x94,0xf0,0x23,0x01,0x00,0x00,0x7b]
          vcmppd k2, zmm12, zmmword ptr [rax + 8*r14 + 291], 123

// CHECK: vcmppd k2, zmm12, qword ptr [rcx]{1to8}, 123
// CHECK:  encoding: [0x62,0xf1,0x9d,0x58,0xc2,0x11,0x7b]
          vcmppd k2, zmm12, qword ptr [rcx]{1to8}, 123

// CHECK: vcmppd k2, zmm12, zmmword ptr [rdx + 8128], 123
// CHECK:  encoding: [0x62,0xf1,0x9d,0x48,0xc2,0x52,0x7f,0x7b]
          vcmppd k2, zmm12, zmmword ptr [rdx + 8128], 123

// CHECK: vcmppd k2, zmm12, zmmword ptr [rdx + 8192], 123
// CHECK:  encoding: [0x62,0xf1,0x9d,0x48,0xc2,0x92,0x00,0x20,0x00,0x00,0x7b]
          vcmppd k2, zmm12, zmmword ptr [rdx + 8192], 123

// CHECK: vcmppd k2, zmm12, zmmword ptr [rdx - 8192], 123
// CHECK:  encoding: [0x62,0xf1,0x9d,0x48,0xc2,0x52,0x80,0x7b]
          vcmppd k2, zmm12, zmmword ptr [rdx - 8192], 123

// CHECK: vcmppd k2, zmm12, zmmword ptr [rdx - 8256], 123
// CHECK:  encoding: [0x62,0xf1,0x9d,0x48,0xc2,0x92,0xc0,0xdf,0xff,0xff,0x7b]
          vcmppd k2, zmm12, zmmword ptr [rdx - 8256], 123

// CHECK: vcmppd k2, zmm12, qword ptr [rdx + 1016]{1to8}, 123
// CHECK:  encoding: [0x62,0xf1,0x9d,0x58,0xc2,0x52,0x7f,0x7b]
          vcmppd k2, zmm12, qword ptr [rdx + 1016]{1to8}, 123

// CHECK: vcmppd k2, zmm12, qword ptr [rdx + 1024]{1to8}, 123
// CHECK:  encoding: [0x62,0xf1,0x9d,0x58,0xc2,0x92,0x00,0x04,0x00,0x00,0x7b]
          vcmppd k2, zmm12, qword ptr [rdx + 1024]{1to8}, 123

// CHECK: vcmppd k2, zmm12, qword ptr [rdx - 1024]{1to8}, 123
// CHECK:  encoding: [0x62,0xf1,0x9d,0x58,0xc2,0x52,0x80,0x7b]
          vcmppd k2, zmm12, qword ptr [rdx - 1024]{1to8}, 123

// CHECK: vcmppd k2, zmm12, qword ptr [rdx - 1032]{1to8}, 123
// CHECK:  encoding: [0x62,0xf1,0x9d,0x58,0xc2,0x92,0xf8,0xfb,0xff,0xff,0x7b]
          vcmppd k2, zmm12, qword ptr [rdx - 1032]{1to8}, 123

// CHECK: vcmpps k2, zmm17, zmm22, 171
// CHECK:  encoding: [0x62,0xb1,0x74,0x40,0xc2,0xd6,0xab]
          vcmpps k2, zmm17, zmm22, 171

// CHECK: vcmpps k2 {k3}, zmm17, zmm22, 171
// CHECK:  encoding: [0x62,0xb1,0x74,0x43,0xc2,0xd6,0xab]
          vcmpps k2 {k3}, zmm17, zmm22, 171

// CHECK: vcmpps k2, zmm17, zmm22, {sae}, 171
// CHECK:  encoding: [0x62,0xb1,0x74,0x10,0xc2,0xd6,0xab]
          vcmpps k2, zmm17, zmm22, {sae}, 171

// CHECK: vcmpps k2, zmm17, zmm22, 123
// CHECK:  encoding: [0x62,0xb1,0x74,0x40,0xc2,0xd6,0x7b]
          vcmpps k2, zmm17, zmm22, 123

// CHECK: vcmpps k2, zmm17, zmm22, {sae}, 123
// CHECK:  encoding: [0x62,0xb1,0x74,0x10,0xc2,0xd6,0x7b]
          vcmpps k2, zmm17, zmm22, {sae}, 123

// CHECK: vcmpps k2, zmm17, zmmword ptr [rcx], 123
// CHECK:  encoding: [0x62,0xf1,0x74,0x40,0xc2,0x11,0x7b]
          vcmpps k2, zmm17, zmmword ptr [rcx], 123

// CHECK: vcmpps k2, zmm17, zmmword ptr [rax + 8*r14 + 291], 123
// CHECK:  encoding: [0x62,0xb1,0x74,0x40,0xc2,0x94,0xf0,0x23,0x01,0x00,0x00,0x7b]
          vcmpps k2, zmm17, zmmword ptr [rax + 8*r14 + 291], 123

// CHECK: vcmpps k2, zmm17, dword ptr [rcx]{1to16}, 123
// CHECK:  encoding: [0x62,0xf1,0x74,0x50,0xc2,0x11,0x7b]
          vcmpps k2, zmm17, dword ptr [rcx]{1to16}, 123

// CHECK: vcmpps k2, zmm17, zmmword ptr [rdx + 8128], 123
// CHECK:  encoding: [0x62,0xf1,0x74,0x40,0xc2,0x52,0x7f,0x7b]
          vcmpps k2, zmm17, zmmword ptr [rdx + 8128], 123

// CHECK: vcmpps k2, zmm17, zmmword ptr [rdx + 8192], 123
// CHECK:  encoding: [0x62,0xf1,0x74,0x40,0xc2,0x92,0x00,0x20,0x00,0x00,0x7b]
          vcmpps k2, zmm17, zmmword ptr [rdx + 8192], 123

// CHECK: vcmpps k2, zmm17, zmmword ptr [rdx - 8192], 123
// CHECK:  encoding: [0x62,0xf1,0x74,0x40,0xc2,0x52,0x80,0x7b]
          vcmpps k2, zmm17, zmmword ptr [rdx - 8192], 123

// CHECK: vcmpps k2, zmm17, zmmword ptr [rdx - 8256], 123
// CHECK:  encoding: [0x62,0xf1,0x74,0x40,0xc2,0x92,0xc0,0xdf,0xff,0xff,0x7b]
          vcmpps k2, zmm17, zmmword ptr [rdx - 8256], 123

// CHECK: vcmpps k2, zmm17, dword ptr [rdx + 508]{1to16}, 123
// CHECK:  encoding: [0x62,0xf1,0x74,0x50,0xc2,0x52,0x7f,0x7b]
          vcmpps k2, zmm17, dword ptr [rdx + 508]{1to16}, 123

// CHECK: vcmpps k2, zmm17, dword ptr [rdx + 512]{1to16}, 123
// CHECK:  encoding: [0x62,0xf1,0x74,0x50,0xc2,0x92,0x00,0x02,0x00,0x00,0x7b]
          vcmpps k2, zmm17, dword ptr [rdx + 512]{1to16}, 123

// CHECK: vcmpps k2, zmm17, dword ptr [rdx - 512]{1to16}, 123
// CHECK:  encoding: [0x62,0xf1,0x74,0x50,0xc2,0x52,0x80,0x7b]
          vcmpps k2, zmm17, dword ptr [rdx - 512]{1to16}, 123

// CHECK: vcmpps k2, zmm17, dword ptr [rdx - 516]{1to16}, 123
// CHECK:  encoding: [0x62,0xf1,0x74,0x50,0xc2,0x92,0xfc,0xfd,0xff,0xff,0x7b]
          vcmpps k2, zmm17, dword ptr [rdx - 516]{1to16}, 123

// CHECK: vcmpsd k5, xmm19, xmm4, 171
// CHECK:  encoding: [0x62,0xf1,0xe7,0x00,0xc2,0xec,0xab]
          vcmpsd k5, xmm19, xmm4, 171

// CHECK: vcmpsd k5 {k1}, xmm19, xmm4, 171
// CHECK:  encoding: [0x62,0xf1,0xe7,0x01,0xc2,0xec,0xab]
          vcmpsd k5 {k1}, xmm19, xmm4, 171

// CHECK: vcmpsd k5, xmm19, xmm4, {sae}, 171
// CHECK:  encoding: [0x62,0xf1,0xe7,0x10,0xc2,0xec,0xab]
          vcmpsd k5, xmm19, xmm4, {sae}, 171

// CHECK: vcmpsd k5, xmm19, xmm4, 123
// CHECK:  encoding: [0x62,0xf1,0xe7,0x00,0xc2,0xec,0x7b]
          vcmpsd k5, xmm19, xmm4, 123

// CHECK: vcmpsd k5, xmm19, xmm4, {sae}, 123
// CHECK:  encoding: [0x62,0xf1,0xe7,0x10,0xc2,0xec,0x7b]
          vcmpsd k5, xmm19, xmm4, {sae}, 123

// CHECK: vcmpsd k5, xmm19, qword ptr [rcx], 123
// CHECK:  encoding: [0x62,0xf1,0xe7,0x00,0xc2,0x29,0x7b]
          vcmpsd k5, xmm19, qword ptr [rcx], 123

// CHECK: vcmpsd k5, xmm19, qword ptr [rax + 8*r14 + 291], 123
// CHECK:  encoding: [0x62,0xb1,0xe7,0x00,0xc2,0xac,0xf0,0x23,0x01,0x00,0x00,0x7b]
          vcmpsd k5, xmm19, qword ptr [rax + 8*r14 + 291], 123

// CHECK: vcmpsd k5, xmm19, qword ptr [rdx + 1016], 123
// CHECK:  encoding: [0x62,0xf1,0xe7,0x00,0xc2,0x6a,0x7f,0x7b]
          vcmpsd k5, xmm19, qword ptr [rdx + 1016], 123

// CHECK: vcmpsd k5, xmm19, qword ptr [rdx + 1024], 123
// CHECK:  encoding: [0x62,0xf1,0xe7,0x00,0xc2,0xaa,0x00,0x04,0x00,0x00,0x7b]
          vcmpsd k5, xmm19, qword ptr [rdx + 1024], 123

// CHECK: vcmpsd k5, xmm19, qword ptr [rdx - 1024], 123
// CHECK:  encoding: [0x62,0xf1,0xe7,0x00,0xc2,0x6a,0x80,0x7b]
          vcmpsd k5, xmm19, qword ptr [rdx - 1024], 123

// CHECK: vcmpsd k5, xmm19, qword ptr [rdx - 1032], 123
// CHECK:  encoding: [0x62,0xf1,0xe7,0x00,0xc2,0xaa,0xf8,0xfb,0xff,0xff,0x7b]
          vcmpsd k5, xmm19, qword ptr [rdx - 1032], 123

// CHECK: vcmpss k4, xmm15, xmm12, 171
// CHECK:  encoding: [0x62,0xd1,0x06,0x08,0xc2,0xe4,0xab]
          vcmpss k4, xmm15, xmm12, 171

// CHECK: vcmpss k4 {k5}, xmm15, xmm12, 171
// CHECK:  encoding: [0x62,0xd1,0x06,0x0d,0xc2,0xe4,0xab]
          vcmpss k4 {k5}, xmm15, xmm12, 171

// CHECK: vcmpss k4, xmm15, xmm12, {sae}, 171
// CHECK:  encoding: [0x62,0xd1,0x06,0x18,0xc2,0xe4,0xab]
          vcmpss k4, xmm15, xmm12, {sae}, 171

// CHECK: vcmpss k4, xmm15, xmm12, 123
// CHECK:  encoding: [0x62,0xd1,0x06,0x08,0xc2,0xe4,0x7b]
          vcmpss k4, xmm15, xmm12, 123

// CHECK: vcmpss k4, xmm15, xmm12, {sae}, 123
// CHECK:  encoding: [0x62,0xd1,0x06,0x18,0xc2,0xe4,0x7b]
          vcmpss k4, xmm15, xmm12, {sae}, 123

// CHECK: vcmpss k4, xmm15, dword ptr [rcx], 123
// CHECK:  encoding: [0x62,0xf1,0x06,0x08,0xc2,0x21,0x7b]
          vcmpss k4, xmm15, dword ptr [rcx], 123

// CHECK: vcmpss k4, xmm15, dword ptr [rax + 8*r14 + 291], 123
// CHECK:  encoding: [0x62,0xb1,0x06,0x08,0xc2,0xa4,0xf0,0x23,0x01,0x00,0x00,0x7b]
          vcmpss k4, xmm15, dword ptr [rax + 8*r14 + 291], 123

// CHECK: vcmpss k4, xmm15, dword ptr [rdx + 508], 123
// CHECK:  encoding: [0x62,0xf1,0x06,0x08,0xc2,0x62,0x7f,0x7b]
          vcmpss k4, xmm15, dword ptr [rdx + 508], 123

// CHECK: vcmpss k4, xmm15, dword ptr [rdx + 512], 123
// CHECK:  encoding: [0x62,0xf1,0x06,0x08,0xc2,0xa2,0x00,0x02,0x00,0x00,0x7b]
          vcmpss k4, xmm15, dword ptr [rdx + 512], 123

// CHECK: vcmpss k4, xmm15, dword ptr [rdx - 512], 123
// CHECK:  encoding: [0x62,0xf1,0x06,0x08,0xc2,0x62,0x80,0x7b]
          vcmpss k4, xmm15, dword ptr [rdx - 512], 123

// CHECK: vcmpss k4, xmm15, dword ptr [rdx - 516], 123
// CHECK:  encoding: [0x62,0xf1,0x06,0x08,0xc2,0xa2,0xfc,0xfd,0xff,0xff,0x7b]
          vcmpss k4, xmm15, dword ptr [rdx - 516], 123

// CHECK: vcomisd xmm23, xmm21
// CHECK:  encoding: [0x62,0xa1,0xfd,0x08,0x2f,0xfd]
          vcomisd xmm23, xmm21

// CHECK: vcomisd xmm23, xmm21, {sae}
// CHECK:  encoding: [0x62,0xa1,0xfd,0x18,0x2f,0xfd]
          vcomisd xmm23, xmm21, {sae}

// CHECK: vcomisd xmm23, qword ptr [rcx]
// CHECK:  encoding: [0x62,0xe1,0xfd,0x08,0x2f,0x39]
          vcomisd xmm23, qword ptr [rcx]

// CHECK: vcomisd xmm23, qword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0xa1,0xfd,0x08,0x2f,0xbc,0xf0,0x23,0x01,0x00,0x00]
          vcomisd xmm23, qword ptr [rax + 8*r14 + 291]

// CHECK: vcomisd xmm23, qword ptr [rdx + 1016]
// CHECK:  encoding: [0x62,0xe1,0xfd,0x08,0x2f,0x7a,0x7f]
          vcomisd xmm23, qword ptr [rdx + 1016]

// CHECK: vcomisd xmm23, qword ptr [rdx + 1024]
// CHECK:  encoding: [0x62,0xe1,0xfd,0x08,0x2f,0xba,0x00,0x04,0x00,0x00]
          vcomisd xmm23, qword ptr [rdx + 1024]

// CHECK: vcomisd xmm23, qword ptr [rdx - 1024]
// CHECK:  encoding: [0x62,0xe1,0xfd,0x08,0x2f,0x7a,0x80]
          vcomisd xmm23, qword ptr [rdx - 1024]

// CHECK: vcomisd xmm23, qword ptr [rdx - 1032]
// CHECK:  encoding: [0x62,0xe1,0xfd,0x08,0x2f,0xba,0xf8,0xfb,0xff,0xff]
          vcomisd xmm23, qword ptr [rdx - 1032]

// CHECK: vcomiss xmm14, xmm28
// CHECK:  encoding: [0x62,0x11,0x7c,0x08,0x2f,0xf4]
          vcomiss xmm14, xmm28

// CHECK: vcomiss xmm14, xmm28, {sae}
// CHECK:  encoding: [0x62,0x11,0x7c,0x18,0x2f,0xf4]
          vcomiss xmm14, xmm28, {sae}

// CHECK: vcomiss xmm14, dword ptr [rcx]
// CHECK:  encoding: [0xc5,0x78,0x2f,0x31]
          vcomiss xmm14, dword ptr [rcx]

// CHECK: vcomiss xmm14, dword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0xc4,0x21,0x78,0x2f,0xb4,0xf0,0x23,0x01,0x00,0x00]
          vcomiss xmm14, dword ptr [rax + 8*r14 + 291]

// CHECK: vcomiss xmm14, dword ptr [rdx + 508]
// CHECK:  encoding: [0xc5,0x78,0x2f,0xb2,0xfc,0x01,0x00,0x00]
          vcomiss xmm14, dword ptr [rdx + 508]

// CHECK: vcomiss xmm14, dword ptr [rdx + 512]
// CHECK:  encoding: [0xc5,0x78,0x2f,0xb2,0x00,0x02,0x00,0x00]
          vcomiss xmm14, dword ptr [rdx + 512]

// CHECK: vcomiss xmm14, dword ptr [rdx - 512]
// CHECK:  encoding: [0xc5,0x78,0x2f,0xb2,0x00,0xfe,0xff,0xff]
          vcomiss xmm14, dword ptr [rdx - 512]

// CHECK: vcomiss xmm14, dword ptr [rdx - 516]
// CHECK:  encoding: [0xc5,0x78,0x2f,0xb2,0xfc,0xfd,0xff,0xff]
          vcomiss xmm14, dword ptr [rdx - 516]

// CHECK: vcompresspd zmmword ptr [rcx], zmm9
// CHECK:  encoding: [0x62,0x72,0xfd,0x48,0x8a,0x09]
          vcompresspd zmmword ptr [rcx], zmm9

// CHECK: vcompresspd zmmword ptr [rcx] {k4}, zmm9
// CHECK:  encoding: [0x62,0x72,0xfd,0x4c,0x8a,0x09]
          vcompresspd zmmword ptr [rcx] {k4}, zmm9

// CHECK: vcompresspd zmmword ptr [rax + 8*r14 + 291], zmm9
// CHECK:  encoding: [0x62,0x32,0xfd,0x48,0x8a,0x8c,0xf0,0x23,0x01,0x00,0x00]
          vcompresspd zmmword ptr [rax + 8*r14 + 291], zmm9

// CHECK: vcompresspd zmmword ptr [rdx + 1016], zmm9
// CHECK:  encoding: [0x62,0x72,0xfd,0x48,0x8a,0x4a,0x7f]
          vcompresspd zmmword ptr [rdx + 1016], zmm9

// CHECK: vcompresspd zmmword ptr [rdx + 1024], zmm9
// CHECK:  encoding: [0x62,0x72,0xfd,0x48,0x8a,0x8a,0x00,0x04,0x00,0x00]
          vcompresspd zmmword ptr [rdx + 1024], zmm9

// CHECK: vcompresspd zmmword ptr [rdx - 1024], zmm9
// CHECK:  encoding: [0x62,0x72,0xfd,0x48,0x8a,0x4a,0x80]
          vcompresspd zmmword ptr [rdx - 1024], zmm9

// CHECK: vcompresspd zmmword ptr [rdx - 1032], zmm9
// CHECK:  encoding: [0x62,0x72,0xfd,0x48,0x8a,0x8a,0xf8,0xfb,0xff,0xff]
          vcompresspd zmmword ptr [rdx - 1032], zmm9

// CHECK: vcompresspd zmm8, zmm4
// CHECK:  encoding: [0x62,0xd2,0xfd,0x48,0x8a,0xe0]
          vcompresspd zmm8, zmm4

// CHECK: vcompresspd zmm8 {k6}, zmm4
// CHECK:  encoding: [0x62,0xd2,0xfd,0x4e,0x8a,0xe0]
          vcompresspd zmm8 {k6}, zmm4

// CHECK: vcompresspd zmm8 {k6} {z}, zmm4
// CHECK:  encoding: [0x62,0xd2,0xfd,0xce,0x8a,0xe0]
          vcompresspd zmm8 {k6} {z}, zmm4

// CHECK: vcompressps zmmword ptr [rcx], zmm10
// CHECK:  encoding: [0x62,0x72,0x7d,0x48,0x8a,0x11]
          vcompressps zmmword ptr [rcx], zmm10

// CHECK: vcompressps zmmword ptr [rcx] {k7}, zmm10
// CHECK:  encoding: [0x62,0x72,0x7d,0x4f,0x8a,0x11]
          vcompressps zmmword ptr [rcx] {k7}, zmm10

// CHECK: vcompressps zmmword ptr [rax + 8*r14 + 291], zmm10
// CHECK:  encoding: [0x62,0x32,0x7d,0x48,0x8a,0x94,0xf0,0x23,0x01,0x00,0x00]
          vcompressps zmmword ptr [rax + 8*r14 + 291], zmm10

// CHECK: vcompressps zmmword ptr [rdx + 508], zmm10
// CHECK:  encoding: [0x62,0x72,0x7d,0x48,0x8a,0x52,0x7f]
          vcompressps zmmword ptr [rdx + 508], zmm10

// CHECK: vcompressps zmmword ptr [rdx + 512], zmm10
// CHECK:  encoding: [0x62,0x72,0x7d,0x48,0x8a,0x92,0x00,0x02,0x00,0x00]
          vcompressps zmmword ptr [rdx + 512], zmm10

// CHECK: vcompressps zmmword ptr [rdx - 512], zmm10
// CHECK:  encoding: [0x62,0x72,0x7d,0x48,0x8a,0x52,0x80]
          vcompressps zmmword ptr [rdx - 512], zmm10

// CHECK: vcompressps zmmword ptr [rdx - 516], zmm10
// CHECK:  encoding: [0x62,0x72,0x7d,0x48,0x8a,0x92,0xfc,0xfd,0xff,0xff]
          vcompressps zmmword ptr [rdx - 516], zmm10

// CHECK: vcompressps zmm4, zmm14
// CHECK:  encoding: [0x62,0x72,0x7d,0x48,0x8a,0xf4]
          vcompressps zmm4, zmm14

// CHECK: vcompressps zmm4 {k2}, zmm14
// CHECK:  encoding: [0x62,0x72,0x7d,0x4a,0x8a,0xf4]
          vcompressps zmm4 {k2}, zmm14

// CHECK: vcompressps zmm4 {k2} {z}, zmm14
// CHECK:  encoding: [0x62,0x72,0x7d,0xca,0x8a,0xf4]
          vcompressps zmm4 {k2} {z}, zmm14

// CHECK: vcvtdq2pd zmm22, ymm24
// CHECK:  encoding: [0x62,0x81,0x7e,0x48,0xe6,0xf0]
          vcvtdq2pd zmm22, ymm24

// CHECK: vcvtdq2pd zmm22 {k4}, ymm24
// CHECK:  encoding: [0x62,0x81,0x7e,0x4c,0xe6,0xf0]
          vcvtdq2pd zmm22 {k4}, ymm24

// CHECK: vcvtdq2pd zmm22 {k4} {z}, ymm24
// CHECK:  encoding: [0x62,0x81,0x7e,0xcc,0xe6,0xf0]
          vcvtdq2pd zmm22 {k4} {z}, ymm24

// CHECK: vcvtdq2pd zmm22, ymmword ptr [rcx]
// CHECK:  encoding: [0x62,0xe1,0x7e,0x48,0xe6,0x31]
          vcvtdq2pd zmm22, ymmword ptr [rcx]

// CHECK: vcvtdq2pd zmm22, ymmword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0xa1,0x7e,0x48,0xe6,0xb4,0xf0,0x23,0x01,0x00,0x00]
          vcvtdq2pd zmm22, ymmword ptr [rax + 8*r14 + 291]

// CHECK: vcvtdq2pd zmm22, dword ptr [rcx]{1to8}
// CHECK:  encoding: [0x62,0xe1,0x7e,0x58,0xe6,0x31]
          vcvtdq2pd zmm22, dword ptr [rcx]{1to8}

// CHECK: vcvtdq2pd zmm22, ymmword ptr [rdx + 4064]
// CHECK:  encoding: [0x62,0xe1,0x7e,0x48,0xe6,0x72,0x7f]
          vcvtdq2pd zmm22, ymmword ptr [rdx + 4064]

// CHECK: vcvtdq2pd zmm22, ymmword ptr [rdx + 4096]
// CHECK:  encoding: [0x62,0xe1,0x7e,0x48,0xe6,0xb2,0x00,0x10,0x00,0x00]
          vcvtdq2pd zmm22, ymmword ptr [rdx + 4096]

// CHECK: vcvtdq2pd zmm22, ymmword ptr [rdx - 4096]
// CHECK:  encoding: [0x62,0xe1,0x7e,0x48,0xe6,0x72,0x80]
          vcvtdq2pd zmm22, ymmword ptr [rdx - 4096]

// CHECK: vcvtdq2pd zmm22, ymmword ptr [rdx - 4128]
// CHECK:  encoding: [0x62,0xe1,0x7e,0x48,0xe6,0xb2,0xe0,0xef,0xff,0xff]
          vcvtdq2pd zmm22, ymmword ptr [rdx - 4128]

// CHECK: vcvtdq2pd zmm22, dword ptr [rdx + 508]{1to8}
// CHECK:  encoding: [0x62,0xe1,0x7e,0x58,0xe6,0x72,0x7f]
          vcvtdq2pd zmm22, dword ptr [rdx + 508]{1to8}

// CHECK: vcvtdq2pd zmm22, dword ptr [rdx + 512]{1to8}
// CHECK:  encoding: [0x62,0xe1,0x7e,0x58,0xe6,0xb2,0x00,0x02,0x00,0x00]
          vcvtdq2pd zmm22, dword ptr [rdx + 512]{1to8}

// CHECK: vcvtdq2pd zmm22, dword ptr [rdx - 512]{1to8}
// CHECK:  encoding: [0x62,0xe1,0x7e,0x58,0xe6,0x72,0x80]
          vcvtdq2pd zmm22, dword ptr [rdx - 512]{1to8}

// CHECK: vcvtdq2pd zmm22, dword ptr [rdx - 516]{1to8}
// CHECK:  encoding: [0x62,0xe1,0x7e,0x58,0xe6,0xb2,0xfc,0xfd,0xff,0xff]
          vcvtdq2pd zmm22, dword ptr [rdx - 516]{1to8}

// CHECK: vcvtdq2ps zmm7, zmm25
// CHECK:  encoding: [0x62,0x91,0x7c,0x48,0x5b,0xf9]
          vcvtdq2ps zmm7, zmm25

// CHECK: vcvtdq2ps zmm7 {k5}, zmm25
// CHECK:  encoding: [0x62,0x91,0x7c,0x4d,0x5b,0xf9]
          vcvtdq2ps zmm7 {k5}, zmm25

// CHECK: vcvtdq2ps zmm7 {k5} {z}, zmm25
// CHECK:  encoding: [0x62,0x91,0x7c,0xcd,0x5b,0xf9]
          vcvtdq2ps zmm7 {k5} {z}, zmm25

// CHECK: vcvtdq2ps zmm7, zmm25, {rn-sae}
// CHECK:  encoding: [0x62,0x91,0x7c,0x18,0x5b,0xf9]
          vcvtdq2ps zmm7, zmm25, {rn-sae}

// CHECK: vcvtdq2ps zmm7, zmm25, {ru-sae}
// CHECK:  encoding: [0x62,0x91,0x7c,0x58,0x5b,0xf9]
          vcvtdq2ps zmm7, zmm25, {ru-sae}

// CHECK: vcvtdq2ps zmm7, zmm25, {rd-sae}
// CHECK:  encoding: [0x62,0x91,0x7c,0x38,0x5b,0xf9]
          vcvtdq2ps zmm7, zmm25, {rd-sae}

// CHECK: vcvtdq2ps zmm7, zmm25, {rz-sae}
// CHECK:  encoding: [0x62,0x91,0x7c,0x78,0x5b,0xf9]
          vcvtdq2ps zmm7, zmm25, {rz-sae}

// CHECK: vcvtdq2ps zmm7, zmmword ptr [rcx]
// CHECK:  encoding: [0x62,0xf1,0x7c,0x48,0x5b,0x39]
          vcvtdq2ps zmm7, zmmword ptr [rcx]

// CHECK: vcvtdq2ps zmm7, zmmword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0xb1,0x7c,0x48,0x5b,0xbc,0xf0,0x23,0x01,0x00,0x00]
          vcvtdq2ps zmm7, zmmword ptr [rax + 8*r14 + 291]

// CHECK: vcvtdq2ps zmm7, dword ptr [rcx]{1to16}
// CHECK:  encoding: [0x62,0xf1,0x7c,0x58,0x5b,0x39]
          vcvtdq2ps zmm7, dword ptr [rcx]{1to16}

// CHECK: vcvtdq2ps zmm7, zmmword ptr [rdx + 8128]
// CHECK:  encoding: [0x62,0xf1,0x7c,0x48,0x5b,0x7a,0x7f]
          vcvtdq2ps zmm7, zmmword ptr [rdx + 8128]

// CHECK: vcvtdq2ps zmm7, zmmword ptr [rdx + 8192]
// CHECK:  encoding: [0x62,0xf1,0x7c,0x48,0x5b,0xba,0x00,0x20,0x00,0x00]
          vcvtdq2ps zmm7, zmmword ptr [rdx + 8192]

// CHECK: vcvtdq2ps zmm7, zmmword ptr [rdx - 8192]
// CHECK:  encoding: [0x62,0xf1,0x7c,0x48,0x5b,0x7a,0x80]
          vcvtdq2ps zmm7, zmmword ptr [rdx - 8192]

// CHECK: vcvtdq2ps zmm7, zmmword ptr [rdx - 8256]
// CHECK:  encoding: [0x62,0xf1,0x7c,0x48,0x5b,0xba,0xc0,0xdf,0xff,0xff]
          vcvtdq2ps zmm7, zmmword ptr [rdx - 8256]

// CHECK: vcvtdq2ps zmm7, dword ptr [rdx + 508]{1to16}
// CHECK:  encoding: [0x62,0xf1,0x7c,0x58,0x5b,0x7a,0x7f]
          vcvtdq2ps zmm7, dword ptr [rdx + 508]{1to16}

// CHECK: vcvtdq2ps zmm7, dword ptr [rdx + 512]{1to16}
// CHECK:  encoding: [0x62,0xf1,0x7c,0x58,0x5b,0xba,0x00,0x02,0x00,0x00]
          vcvtdq2ps zmm7, dword ptr [rdx + 512]{1to16}

// CHECK: vcvtdq2ps zmm7, dword ptr [rdx - 512]{1to16}
// CHECK:  encoding: [0x62,0xf1,0x7c,0x58,0x5b,0x7a,0x80]
          vcvtdq2ps zmm7, dword ptr [rdx - 512]{1to16}

// CHECK: vcvtdq2ps zmm7, dword ptr [rdx - 516]{1to16}
// CHECK:  encoding: [0x62,0xf1,0x7c,0x58,0x5b,0xba,0xfc,0xfd,0xff,0xff]
          vcvtdq2ps zmm7, dword ptr [rdx - 516]{1to16}

// CHECK: vcvtpd2dq ymm24, zmm15
// CHECK:  encoding: [0x62,0x41,0xff,0x48,0xe6,0xc7]
          vcvtpd2dq ymm24, zmm15

// CHECK: vcvtpd2dq ymm24 {k3}, zmm15
// CHECK:  encoding: [0x62,0x41,0xff,0x4b,0xe6,0xc7]
          vcvtpd2dq ymm24 {k3}, zmm15

// CHECK: vcvtpd2dq ymm24 {k3} {z}, zmm15
// CHECK:  encoding: [0x62,0x41,0xff,0xcb,0xe6,0xc7]
          vcvtpd2dq ymm24 {k3} {z}, zmm15

// CHECK: vcvtpd2dq ymm24, zmm15, {rn-sae}
// CHECK:  encoding: [0x62,0x41,0xff,0x18,0xe6,0xc7]
          vcvtpd2dq ymm24, zmm15, {rn-sae}

// CHECK: vcvtpd2dq ymm24, zmm15, {ru-sae}
// CHECK:  encoding: [0x62,0x41,0xff,0x58,0xe6,0xc7]
          vcvtpd2dq ymm24, zmm15, {ru-sae}

// CHECK: vcvtpd2dq ymm24, zmm15, {rd-sae}
// CHECK:  encoding: [0x62,0x41,0xff,0x38,0xe6,0xc7]
          vcvtpd2dq ymm24, zmm15, {rd-sae}

// CHECK: vcvtpd2dq ymm24, zmm15, {rz-sae}
// CHECK:  encoding: [0x62,0x41,0xff,0x78,0xe6,0xc7]
          vcvtpd2dq ymm24, zmm15, {rz-sae}

// CHECK: vcvtpd2dq ymm24, zmmword ptr [rcx]
// CHECK:  encoding: [0x62,0x61,0xff,0x48,0xe6,0x01]
          vcvtpd2dq ymm24, zmmword ptr [rcx]

// CHECK: vcvtpd2dq ymm24, zmmword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0x21,0xff,0x48,0xe6,0x84,0xf0,0x23,0x01,0x00,0x00]
          vcvtpd2dq ymm24, zmmword ptr [rax + 8*r14 + 291]

// CHECK: vcvtpd2dq ymm24, qword ptr [rcx]{1to8}
// CHECK:  encoding: [0x62,0x61,0xff,0x58,0xe6,0x01]
          vcvtpd2dq ymm24, qword ptr [rcx]{1to8}

// CHECK: vcvtpd2dq ymm24, zmmword ptr [rdx + 8128]
// CHECK:  encoding: [0x62,0x61,0xff,0x48,0xe6,0x42,0x7f]
          vcvtpd2dq ymm24, zmmword ptr [rdx + 8128]

// CHECK: vcvtpd2dq ymm24, zmmword ptr [rdx + 8192]
// CHECK:  encoding: [0x62,0x61,0xff,0x48,0xe6,0x82,0x00,0x20,0x00,0x00]
          vcvtpd2dq ymm24, zmmword ptr [rdx + 8192]

// CHECK: vcvtpd2dq ymm24, zmmword ptr [rdx - 8192]
// CHECK:  encoding: [0x62,0x61,0xff,0x48,0xe6,0x42,0x80]
          vcvtpd2dq ymm24, zmmword ptr [rdx - 8192]

// CHECK: vcvtpd2dq ymm24, zmmword ptr [rdx - 8256]
// CHECK:  encoding: [0x62,0x61,0xff,0x48,0xe6,0x82,0xc0,0xdf,0xff,0xff]
          vcvtpd2dq ymm24, zmmword ptr [rdx - 8256]

// CHECK: vcvtpd2dq ymm24, qword ptr [rdx + 1016]{1to8}
// CHECK:  encoding: [0x62,0x61,0xff,0x58,0xe6,0x42,0x7f]
          vcvtpd2dq ymm24, qword ptr [rdx + 1016]{1to8}

// CHECK: vcvtpd2dq ymm24, qword ptr [rdx + 1024]{1to8}
// CHECK:  encoding: [0x62,0x61,0xff,0x58,0xe6,0x82,0x00,0x04,0x00,0x00]
          vcvtpd2dq ymm24, qword ptr [rdx + 1024]{1to8}

// CHECK: vcvtpd2dq ymm24, qword ptr [rdx - 1024]{1to8}
// CHECK:  encoding: [0x62,0x61,0xff,0x58,0xe6,0x42,0x80]
          vcvtpd2dq ymm24, qword ptr [rdx - 1024]{1to8}

// CHECK: vcvtpd2dq ymm24, qword ptr [rdx - 1032]{1to8}
// CHECK:  encoding: [0x62,0x61,0xff,0x58,0xe6,0x82,0xf8,0xfb,0xff,0xff]
          vcvtpd2dq ymm24, qword ptr [rdx - 1032]{1to8}

// CHECK: vcvtpd2ps ymm5, zmm23
// CHECK:  encoding: [0x62,0xb1,0xfd,0x48,0x5a,0xef]
          vcvtpd2ps ymm5, zmm23

// CHECK: vcvtpd2ps ymm5 {k5}, zmm23
// CHECK:  encoding: [0x62,0xb1,0xfd,0x4d,0x5a,0xef]
          vcvtpd2ps ymm5 {k5}, zmm23

// CHECK: vcvtpd2ps ymm5 {k5} {z}, zmm23
// CHECK:  encoding: [0x62,0xb1,0xfd,0xcd,0x5a,0xef]
          vcvtpd2ps ymm5 {k5} {z}, zmm23

// CHECK: vcvtpd2ps ymm5, zmm23, {rn-sae}
// CHECK:  encoding: [0x62,0xb1,0xfd,0x18,0x5a,0xef]
          vcvtpd2ps ymm5, zmm23, {rn-sae}

// CHECK: vcvtpd2ps ymm5, zmm23, {ru-sae}
// CHECK:  encoding: [0x62,0xb1,0xfd,0x58,0x5a,0xef]
          vcvtpd2ps ymm5, zmm23, {ru-sae}

// CHECK: vcvtpd2ps ymm5, zmm23, {rd-sae}
// CHECK:  encoding: [0x62,0xb1,0xfd,0x38,0x5a,0xef]
          vcvtpd2ps ymm5, zmm23, {rd-sae}

// CHECK: vcvtpd2ps ymm5, zmm23, {rz-sae}
// CHECK:  encoding: [0x62,0xb1,0xfd,0x78,0x5a,0xef]
          vcvtpd2ps ymm5, zmm23, {rz-sae}

// CHECK: vcvtpd2ps ymm5, zmmword ptr [rcx]
// CHECK:  encoding: [0x62,0xf1,0xfd,0x48,0x5a,0x29]
          vcvtpd2ps ymm5, zmmword ptr [rcx]

// CHECK: vcvtpd2ps ymm5, zmmword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0xb1,0xfd,0x48,0x5a,0xac,0xf0,0x23,0x01,0x00,0x00]
          vcvtpd2ps ymm5, zmmword ptr [rax + 8*r14 + 291]

// CHECK: vcvtpd2ps ymm5, qword ptr [rcx]{1to8}
// CHECK:  encoding: [0x62,0xf1,0xfd,0x58,0x5a,0x29]
          vcvtpd2ps ymm5, qword ptr [rcx]{1to8}

// CHECK: vcvtpd2ps ymm5, zmmword ptr [rdx + 8128]
// CHECK:  encoding: [0x62,0xf1,0xfd,0x48,0x5a,0x6a,0x7f]
          vcvtpd2ps ymm5, zmmword ptr [rdx + 8128]

// CHECK: vcvtpd2ps ymm5, zmmword ptr [rdx + 8192]
// CHECK:  encoding: [0x62,0xf1,0xfd,0x48,0x5a,0xaa,0x00,0x20,0x00,0x00]
          vcvtpd2ps ymm5, zmmword ptr [rdx + 8192]

// CHECK: vcvtpd2ps ymm5, zmmword ptr [rdx - 8192]
// CHECK:  encoding: [0x62,0xf1,0xfd,0x48,0x5a,0x6a,0x80]
          vcvtpd2ps ymm5, zmmword ptr [rdx - 8192]

// CHECK: vcvtpd2ps ymm5, zmmword ptr [rdx - 8256]
// CHECK:  encoding: [0x62,0xf1,0xfd,0x48,0x5a,0xaa,0xc0,0xdf,0xff,0xff]
          vcvtpd2ps ymm5, zmmword ptr [rdx - 8256]

// CHECK: vcvtpd2ps ymm5, qword ptr [rdx + 1016]{1to8}
// CHECK:  encoding: [0x62,0xf1,0xfd,0x58,0x5a,0x6a,0x7f]
          vcvtpd2ps ymm5, qword ptr [rdx + 1016]{1to8}

// CHECK: vcvtpd2ps ymm5, qword ptr [rdx + 1024]{1to8}
// CHECK:  encoding: [0x62,0xf1,0xfd,0x58,0x5a,0xaa,0x00,0x04,0x00,0x00]
          vcvtpd2ps ymm5, qword ptr [rdx + 1024]{1to8}

// CHECK: vcvtpd2ps ymm5, qword ptr [rdx - 1024]{1to8}
// CHECK:  encoding: [0x62,0xf1,0xfd,0x58,0x5a,0x6a,0x80]
          vcvtpd2ps ymm5, qword ptr [rdx - 1024]{1to8}

// CHECK: vcvtpd2ps ymm5, qword ptr [rdx - 1032]{1to8}
// CHECK:  encoding: [0x62,0xf1,0xfd,0x58,0x5a,0xaa,0xf8,0xfb,0xff,0xff]
          vcvtpd2ps ymm5, qword ptr [rdx - 1032]{1to8}

// CHECK: vcvtpd2udq ymm15, zmm19
// CHECK:  encoding: [0x62,0x31,0xfc,0x48,0x79,0xfb]
          vcvtpd2udq ymm15, zmm19

// CHECK: vcvtpd2udq ymm15 {k7}, zmm19
// CHECK:  encoding: [0x62,0x31,0xfc,0x4f,0x79,0xfb]
          vcvtpd2udq ymm15 {k7}, zmm19

// CHECK: vcvtpd2udq ymm15 {k7} {z}, zmm19
// CHECK:  encoding: [0x62,0x31,0xfc,0xcf,0x79,0xfb]
          vcvtpd2udq ymm15 {k7} {z}, zmm19

// CHECK: vcvtpd2udq ymm15, zmm19, {rn-sae}
// CHECK:  encoding: [0x62,0x31,0xfc,0x18,0x79,0xfb]
          vcvtpd2udq ymm15, zmm19, {rn-sae}

// CHECK: vcvtpd2udq ymm15, zmm19, {ru-sae}
// CHECK:  encoding: [0x62,0x31,0xfc,0x58,0x79,0xfb]
          vcvtpd2udq ymm15, zmm19, {ru-sae}

// CHECK: vcvtpd2udq ymm15, zmm19, {rd-sae}
// CHECK:  encoding: [0x62,0x31,0xfc,0x38,0x79,0xfb]
          vcvtpd2udq ymm15, zmm19, {rd-sae}

// CHECK: vcvtpd2udq ymm15, zmm19, {rz-sae}
// CHECK:  encoding: [0x62,0x31,0xfc,0x78,0x79,0xfb]
          vcvtpd2udq ymm15, zmm19, {rz-sae}

// CHECK: vcvtpd2udq ymm15, zmmword ptr [rcx]
// CHECK:  encoding: [0x62,0x71,0xfc,0x48,0x79,0x39]
          vcvtpd2udq ymm15, zmmword ptr [rcx]

// CHECK: vcvtpd2udq ymm15, zmmword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0x31,0xfc,0x48,0x79,0xbc,0xf0,0x23,0x01,0x00,0x00]
          vcvtpd2udq ymm15, zmmword ptr [rax + 8*r14 + 291]

// CHECK: vcvtpd2udq ymm15, qword ptr [rcx]{1to8}
// CHECK:  encoding: [0x62,0x71,0xfc,0x58,0x79,0x39]
          vcvtpd2udq ymm15, qword ptr [rcx]{1to8}

// CHECK: vcvtpd2udq ymm15, zmmword ptr [rdx + 8128]
// CHECK:  encoding: [0x62,0x71,0xfc,0x48,0x79,0x7a,0x7f]
          vcvtpd2udq ymm15, zmmword ptr [rdx + 8128]

// CHECK: vcvtpd2udq ymm15, zmmword ptr [rdx + 8192]
// CHECK:  encoding: [0x62,0x71,0xfc,0x48,0x79,0xba,0x00,0x20,0x00,0x00]
          vcvtpd2udq ymm15, zmmword ptr [rdx + 8192]

// CHECK: vcvtpd2udq ymm15, zmmword ptr [rdx - 8192]
// CHECK:  encoding: [0x62,0x71,0xfc,0x48,0x79,0x7a,0x80]
          vcvtpd2udq ymm15, zmmword ptr [rdx - 8192]

// CHECK: vcvtpd2udq ymm15, zmmword ptr [rdx - 8256]
// CHECK:  encoding: [0x62,0x71,0xfc,0x48,0x79,0xba,0xc0,0xdf,0xff,0xff]
          vcvtpd2udq ymm15, zmmword ptr [rdx - 8256]

// CHECK: vcvtpd2udq ymm15, qword ptr [rdx + 1016]{1to8}
// CHECK:  encoding: [0x62,0x71,0xfc,0x58,0x79,0x7a,0x7f]
          vcvtpd2udq ymm15, qword ptr [rdx + 1016]{1to8}

// CHECK: vcvtpd2udq ymm15, qword ptr [rdx + 1024]{1to8}
// CHECK:  encoding: [0x62,0x71,0xfc,0x58,0x79,0xba,0x00,0x04,0x00,0x00]
          vcvtpd2udq ymm15, qword ptr [rdx + 1024]{1to8}

// CHECK: vcvtpd2udq ymm15, qword ptr [rdx - 1024]{1to8}
// CHECK:  encoding: [0x62,0x71,0xfc,0x58,0x79,0x7a,0x80]
          vcvtpd2udq ymm15, qword ptr [rdx - 1024]{1to8}

// CHECK: vcvtpd2udq ymm15, qword ptr [rdx - 1032]{1to8}
// CHECK:  encoding: [0x62,0x71,0xfc,0x58,0x79,0xba,0xf8,0xfb,0xff,0xff]
          vcvtpd2udq ymm15, qword ptr [rdx - 1032]{1to8}

// CHECK: vcvtph2ps zmm13, ymm27
// CHECK:  encoding: [0x62,0x12,0x7d,0x48,0x13,0xeb]
          vcvtph2ps zmm13, ymm27

// CHECK: vcvtph2ps zmm13 {k3}, ymm27
// CHECK:  encoding: [0x62,0x12,0x7d,0x4b,0x13,0xeb]
          vcvtph2ps zmm13 {k3}, ymm27

// CHECK: vcvtph2ps zmm13 {k3} {z}, ymm27
// CHECK:  encoding: [0x62,0x12,0x7d,0xcb,0x13,0xeb]
          vcvtph2ps zmm13 {k3} {z}, ymm27

// CHECK: vcvtph2ps zmm13, ymm27, {sae}
// CHECK:  encoding: [0x62,0x12,0x7d,0x18,0x13,0xeb]
          vcvtph2ps zmm13, ymm27, {sae}

// CHECK: vcvtph2ps zmm13, ymmword ptr [rcx]
// CHECK:  encoding: [0x62,0x72,0x7d,0x48,0x13,0x29]
          vcvtph2ps zmm13, ymmword ptr [rcx]

// CHECK: vcvtph2ps zmm13, ymmword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0x32,0x7d,0x48,0x13,0xac,0xf0,0x23,0x01,0x00,0x00]
          vcvtph2ps zmm13, ymmword ptr [rax + 8*r14 + 291]

// CHECK: vcvtph2ps zmm13, ymmword ptr [rdx + 4064]
// CHECK:  encoding: [0x62,0x72,0x7d,0x48,0x13,0x6a,0x7f]
          vcvtph2ps zmm13, ymmword ptr [rdx + 4064]

// CHECK: vcvtph2ps zmm13, ymmword ptr [rdx + 4096]
// CHECK:  encoding: [0x62,0x72,0x7d,0x48,0x13,0xaa,0x00,0x10,0x00,0x00]
          vcvtph2ps zmm13, ymmword ptr [rdx + 4096]

// CHECK: vcvtph2ps zmm13, ymmword ptr [rdx - 4096]
// CHECK:  encoding: [0x62,0x72,0x7d,0x48,0x13,0x6a,0x80]
          vcvtph2ps zmm13, ymmword ptr [rdx - 4096]

// CHECK: vcvtph2ps zmm13, ymmword ptr [rdx - 4128]
// CHECK:  encoding: [0x62,0x72,0x7d,0x48,0x13,0xaa,0xe0,0xef,0xff,0xff]
          vcvtph2ps zmm13, ymmword ptr [rdx - 4128]

// CHECK: vcvtps2dq zmm12, zmm24
// CHECK:  encoding: [0x62,0x11,0x7d,0x48,0x5b,0xe0]
          vcvtps2dq zmm12, zmm24

// CHECK: vcvtps2dq zmm12 {k4}, zmm24
// CHECK:  encoding: [0x62,0x11,0x7d,0x4c,0x5b,0xe0]
          vcvtps2dq zmm12 {k4}, zmm24

// CHECK: vcvtps2dq zmm12 {k4} {z}, zmm24
// CHECK:  encoding: [0x62,0x11,0x7d,0xcc,0x5b,0xe0]
          vcvtps2dq zmm12 {k4} {z}, zmm24

// CHECK: vcvtps2dq zmm12, zmm24, {rn-sae}
// CHECK:  encoding: [0x62,0x11,0x7d,0x18,0x5b,0xe0]
          vcvtps2dq zmm12, zmm24, {rn-sae}

// CHECK: vcvtps2dq zmm12, zmm24, {ru-sae}
// CHECK:  encoding: [0x62,0x11,0x7d,0x58,0x5b,0xe0]
          vcvtps2dq zmm12, zmm24, {ru-sae}

// CHECK: vcvtps2dq zmm12, zmm24, {rd-sae}
// CHECK:  encoding: [0x62,0x11,0x7d,0x38,0x5b,0xe0]
          vcvtps2dq zmm12, zmm24, {rd-sae}

// CHECK: vcvtps2dq zmm12, zmm24, {rz-sae}
// CHECK:  encoding: [0x62,0x11,0x7d,0x78,0x5b,0xe0]
          vcvtps2dq zmm12, zmm24, {rz-sae}

// CHECK: vcvtps2dq zmm12, zmmword ptr [rcx]
// CHECK:  encoding: [0x62,0x71,0x7d,0x48,0x5b,0x21]
          vcvtps2dq zmm12, zmmword ptr [rcx]

// CHECK: vcvtps2dq zmm12, zmmword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0x31,0x7d,0x48,0x5b,0xa4,0xf0,0x23,0x01,0x00,0x00]
          vcvtps2dq zmm12, zmmword ptr [rax + 8*r14 + 291]

// CHECK: vcvtps2dq zmm12, dword ptr [rcx]{1to16}
// CHECK:  encoding: [0x62,0x71,0x7d,0x58,0x5b,0x21]
          vcvtps2dq zmm12, dword ptr [rcx]{1to16}

// CHECK: vcvtps2dq zmm12, zmmword ptr [rdx + 8128]
// CHECK:  encoding: [0x62,0x71,0x7d,0x48,0x5b,0x62,0x7f]
          vcvtps2dq zmm12, zmmword ptr [rdx + 8128]

// CHECK: vcvtps2dq zmm12, zmmword ptr [rdx + 8192]
// CHECK:  encoding: [0x62,0x71,0x7d,0x48,0x5b,0xa2,0x00,0x20,0x00,0x00]
          vcvtps2dq zmm12, zmmword ptr [rdx + 8192]

// CHECK: vcvtps2dq zmm12, zmmword ptr [rdx - 8192]
// CHECK:  encoding: [0x62,0x71,0x7d,0x48,0x5b,0x62,0x80]
          vcvtps2dq zmm12, zmmword ptr [rdx - 8192]

// CHECK: vcvtps2dq zmm12, zmmword ptr [rdx - 8256]
// CHECK:  encoding: [0x62,0x71,0x7d,0x48,0x5b,0xa2,0xc0,0xdf,0xff,0xff]
          vcvtps2dq zmm12, zmmword ptr [rdx - 8256]

// CHECK: vcvtps2dq zmm12, dword ptr [rdx + 508]{1to16}
// CHECK:  encoding: [0x62,0x71,0x7d,0x58,0x5b,0x62,0x7f]
          vcvtps2dq zmm12, dword ptr [rdx + 508]{1to16}

// CHECK: vcvtps2dq zmm12, dword ptr [rdx + 512]{1to16}
// CHECK:  encoding: [0x62,0x71,0x7d,0x58,0x5b,0xa2,0x00,0x02,0x00,0x00]
          vcvtps2dq zmm12, dword ptr [rdx + 512]{1to16}

// CHECK: vcvtps2dq zmm12, dword ptr [rdx - 512]{1to16}
// CHECK:  encoding: [0x62,0x71,0x7d,0x58,0x5b,0x62,0x80]
          vcvtps2dq zmm12, dword ptr [rdx - 512]{1to16}

// CHECK: vcvtps2dq zmm12, dword ptr [rdx - 516]{1to16}
// CHECK:  encoding: [0x62,0x71,0x7d,0x58,0x5b,0xa2,0xfc,0xfd,0xff,0xff]
          vcvtps2dq zmm12, dword ptr [rdx - 516]{1to16}

// CHECK: vcvtps2pd zmm13, ymm6
// CHECK:  encoding: [0x62,0x71,0x7c,0x48,0x5a,0xee]
          vcvtps2pd zmm13, ymm6

// CHECK: vcvtps2pd zmm13 {k3}, ymm6
// CHECK:  encoding: [0x62,0x71,0x7c,0x4b,0x5a,0xee]
          vcvtps2pd zmm13 {k3}, ymm6

// CHECK: vcvtps2pd zmm13 {k3} {z}, ymm6
// CHECK:  encoding: [0x62,0x71,0x7c,0xcb,0x5a,0xee]
          vcvtps2pd zmm13 {k3} {z}, ymm6

// CHECK: vcvtps2pd zmm13, ymm6, {sae}
// CHECK:  encoding: [0x62,0x71,0x7c,0x18,0x5a,0xee]
          vcvtps2pd zmm13, ymm6, {sae}

// CHECK: vcvtps2pd zmm13, ymmword ptr [rcx]
// CHECK:  encoding: [0x62,0x71,0x7c,0x48,0x5a,0x29]
          vcvtps2pd zmm13, ymmword ptr [rcx]

// CHECK: vcvtps2pd zmm13, ymmword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0x31,0x7c,0x48,0x5a,0xac,0xf0,0x23,0x01,0x00,0x00]
          vcvtps2pd zmm13, ymmword ptr [rax + 8*r14 + 291]

// CHECK: vcvtps2pd zmm13, dword ptr [rcx]{1to8}
// CHECK:  encoding: [0x62,0x71,0x7c,0x58,0x5a,0x29]
          vcvtps2pd zmm13, dword ptr [rcx]{1to8}

// CHECK: vcvtps2pd zmm13, ymmword ptr [rdx + 4064]
// CHECK:  encoding: [0x62,0x71,0x7c,0x48,0x5a,0x6a,0x7f]
          vcvtps2pd zmm13, ymmword ptr [rdx + 4064]

// CHECK: vcvtps2pd zmm13, ymmword ptr [rdx + 4096]
// CHECK:  encoding: [0x62,0x71,0x7c,0x48,0x5a,0xaa,0x00,0x10,0x00,0x00]
          vcvtps2pd zmm13, ymmword ptr [rdx + 4096]

// CHECK: vcvtps2pd zmm13, ymmword ptr [rdx - 4096]
// CHECK:  encoding: [0x62,0x71,0x7c,0x48,0x5a,0x6a,0x80]
          vcvtps2pd zmm13, ymmword ptr [rdx - 4096]

// CHECK: vcvtps2pd zmm13, ymmword ptr [rdx - 4128]
// CHECK:  encoding: [0x62,0x71,0x7c,0x48,0x5a,0xaa,0xe0,0xef,0xff,0xff]
          vcvtps2pd zmm13, ymmword ptr [rdx - 4128]

// CHECK: vcvtps2pd zmm13, dword ptr [rdx + 508]{1to8}
// CHECK:  encoding: [0x62,0x71,0x7c,0x58,0x5a,0x6a,0x7f]
          vcvtps2pd zmm13, dword ptr [rdx + 508]{1to8}

// CHECK: vcvtps2pd zmm13, dword ptr [rdx + 512]{1to8}
// CHECK:  encoding: [0x62,0x71,0x7c,0x58,0x5a,0xaa,0x00,0x02,0x00,0x00]
          vcvtps2pd zmm13, dword ptr [rdx + 512]{1to8}

// CHECK: vcvtps2pd zmm13, dword ptr [rdx - 512]{1to8}
// CHECK:  encoding: [0x62,0x71,0x7c,0x58,0x5a,0x6a,0x80]
          vcvtps2pd zmm13, dword ptr [rdx - 512]{1to8}

// CHECK: vcvtps2pd zmm13, dword ptr [rdx - 516]{1to8}
// CHECK:  encoding: [0x62,0x71,0x7c,0x58,0x5a,0xaa,0xfc,0xfd,0xff,0xff]
          vcvtps2pd zmm13, dword ptr [rdx - 516]{1to8}

// CHECK: vcvtps2ph ymm11, zmm14, 171
// CHECK:  encoding: [0x62,0x53,0x7d,0x48,0x1d,0xf3,0xab]
          vcvtps2ph ymm11, zmm14, 171

// CHECK: vcvtps2ph ymm11 {k6}, zmm14, 171
// CHECK:  encoding: [0x62,0x53,0x7d,0x4e,0x1d,0xf3,0xab]
          vcvtps2ph ymm11 {k6}, zmm14, 171

// CHECK: vcvtps2ph ymm11 {k6} {z}, zmm14, 171
// CHECK:  encoding: [0x62,0x53,0x7d,0xce,0x1d,0xf3,0xab]
          vcvtps2ph ymm11 {k6} {z}, zmm14, 171

// CHECK: vcvtps2ph ymm11, zmm14, {sae}, 171
// CHECK:  encoding: [0x62,0x53,0x7d,0x18,0x1d,0xf3,0xab]
          vcvtps2ph ymm11, zmm14, {sae}, 171

// CHECK: vcvtps2ph ymm11, zmm14, 123
// CHECK:  encoding: [0x62,0x53,0x7d,0x48,0x1d,0xf3,0x7b]
          vcvtps2ph ymm11, zmm14, 123

// CHECK: vcvtps2ph ymm11, zmm14, {sae}, 123
// CHECK:  encoding: [0x62,0x53,0x7d,0x18,0x1d,0xf3,0x7b]
          vcvtps2ph ymm11, zmm14, {sae}, 123

// CHECK: vcvtps2udq zmm12, zmm26
// CHECK:  encoding: [0x62,0x11,0x7c,0x48,0x79,0xe2]
          vcvtps2udq zmm12, zmm26

// CHECK: vcvtps2udq zmm12 {k4}, zmm26
// CHECK:  encoding: [0x62,0x11,0x7c,0x4c,0x79,0xe2]
          vcvtps2udq zmm12 {k4}, zmm26

// CHECK: vcvtps2udq zmm12 {k4} {z}, zmm26
// CHECK:  encoding: [0x62,0x11,0x7c,0xcc,0x79,0xe2]
          vcvtps2udq zmm12 {k4} {z}, zmm26

// CHECK: vcvtps2udq zmm12, zmm26, {rn-sae}
// CHECK:  encoding: [0x62,0x11,0x7c,0x18,0x79,0xe2]
          vcvtps2udq zmm12, zmm26, {rn-sae}

// CHECK: vcvtps2udq zmm12, zmm26, {ru-sae}
// CHECK:  encoding: [0x62,0x11,0x7c,0x58,0x79,0xe2]
          vcvtps2udq zmm12, zmm26, {ru-sae}

// CHECK: vcvtps2udq zmm12, zmm26, {rd-sae}
// CHECK:  encoding: [0x62,0x11,0x7c,0x38,0x79,0xe2]
          vcvtps2udq zmm12, zmm26, {rd-sae}

// CHECK: vcvtps2udq zmm12, zmm26, {rz-sae}
// CHECK:  encoding: [0x62,0x11,0x7c,0x78,0x79,0xe2]
          vcvtps2udq zmm12, zmm26, {rz-sae}

// CHECK: vcvtps2udq zmm12, zmmword ptr [rcx]
// CHECK:  encoding: [0x62,0x71,0x7c,0x48,0x79,0x21]
          vcvtps2udq zmm12, zmmword ptr [rcx]

// CHECK: vcvtps2udq zmm12, zmmword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0x31,0x7c,0x48,0x79,0xa4,0xf0,0x23,0x01,0x00,0x00]
          vcvtps2udq zmm12, zmmword ptr [rax + 8*r14 + 291]

// CHECK: vcvtps2udq zmm12, dword ptr [rcx]{1to16}
// CHECK:  encoding: [0x62,0x71,0x7c,0x58,0x79,0x21]
          vcvtps2udq zmm12, dword ptr [rcx]{1to16}

// CHECK: vcvtps2udq zmm12, zmmword ptr [rdx + 8128]
// CHECK:  encoding: [0x62,0x71,0x7c,0x48,0x79,0x62,0x7f]
          vcvtps2udq zmm12, zmmword ptr [rdx + 8128]

// CHECK: vcvtps2udq zmm12, zmmword ptr [rdx + 8192]
// CHECK:  encoding: [0x62,0x71,0x7c,0x48,0x79,0xa2,0x00,0x20,0x00,0x00]
          vcvtps2udq zmm12, zmmword ptr [rdx + 8192]

// CHECK: vcvtps2udq zmm12, zmmword ptr [rdx - 8192]
// CHECK:  encoding: [0x62,0x71,0x7c,0x48,0x79,0x62,0x80]
          vcvtps2udq zmm12, zmmword ptr [rdx - 8192]

// CHECK: vcvtps2udq zmm12, zmmword ptr [rdx - 8256]
// CHECK:  encoding: [0x62,0x71,0x7c,0x48,0x79,0xa2,0xc0,0xdf,0xff,0xff]
          vcvtps2udq zmm12, zmmword ptr [rdx - 8256]

// CHECK: vcvtps2udq zmm12, dword ptr [rdx + 508]{1to16}
// CHECK:  encoding: [0x62,0x71,0x7c,0x58,0x79,0x62,0x7f]
          vcvtps2udq zmm12, dword ptr [rdx + 508]{1to16}

// CHECK: vcvtps2udq zmm12, dword ptr [rdx + 512]{1to16}
// CHECK:  encoding: [0x62,0x71,0x7c,0x58,0x79,0xa2,0x00,0x02,0x00,0x00]
          vcvtps2udq zmm12, dword ptr [rdx + 512]{1to16}

// CHECK: vcvtps2udq zmm12, dword ptr [rdx - 512]{1to16}
// CHECK:  encoding: [0x62,0x71,0x7c,0x58,0x79,0x62,0x80]
          vcvtps2udq zmm12, dword ptr [rdx - 512]{1to16}

// CHECK: vcvtps2udq zmm12, dword ptr [rdx - 516]{1to16}
// CHECK:  encoding: [0x62,0x71,0x7c,0x58,0x79,0xa2,0xfc,0xfd,0xff,0xff]
          vcvtps2udq zmm12, dword ptr [rdx - 516]{1to16}

// CHECK: vcvtsd2si eax, xmm7, {rn-sae}
// CHECK:  encoding: [0x62,0xf1,0x7f,0x18,0x2d,0xc7]
          vcvtsd2si eax, xmm7, {rn-sae}

// CHECK: vcvtsd2si eax, xmm7, {ru-sae}
// CHECK:  encoding: [0x62,0xf1,0x7f,0x58,0x2d,0xc7]
          vcvtsd2si eax, xmm7, {ru-sae}

// CHECK: vcvtsd2si eax, xmm7, {rd-sae}
// CHECK:  encoding: [0x62,0xf1,0x7f,0x38,0x2d,0xc7]
          vcvtsd2si eax, xmm7, {rd-sae}

// CHECK: vcvtsd2si eax, xmm7, {rz-sae}
// CHECK:  encoding: [0x62,0xf1,0x7f,0x78,0x2d,0xc7]
          vcvtsd2si eax, xmm7, {rz-sae}

// CHECK: vcvtsd2si ebp, xmm7, {rn-sae}
// CHECK:  encoding: [0x62,0xf1,0x7f,0x18,0x2d,0xef]
          vcvtsd2si ebp, xmm7, {rn-sae}

// CHECK: vcvtsd2si ebp, xmm7, {ru-sae}
// CHECK:  encoding: [0x62,0xf1,0x7f,0x58,0x2d,0xef]
          vcvtsd2si ebp, xmm7, {ru-sae}

// CHECK: vcvtsd2si ebp, xmm7, {rd-sae}
// CHECK:  encoding: [0x62,0xf1,0x7f,0x38,0x2d,0xef]
          vcvtsd2si ebp, xmm7, {rd-sae}

// CHECK: vcvtsd2si ebp, xmm7, {rz-sae}
// CHECK:  encoding: [0x62,0xf1,0x7f,0x78,0x2d,0xef]
          vcvtsd2si ebp, xmm7, {rz-sae}

// CHECK: vcvtsd2si r13d, xmm7, {rn-sae}
// CHECK:  encoding: [0x62,0x71,0x7f,0x18,0x2d,0xef]
          vcvtsd2si r13d, xmm7, {rn-sae}

// CHECK: vcvtsd2si r13d, xmm7, {ru-sae}
// CHECK:  encoding: [0x62,0x71,0x7f,0x58,0x2d,0xef]
          vcvtsd2si r13d, xmm7, {ru-sae}

// CHECK: vcvtsd2si r13d, xmm7, {rd-sae}
// CHECK:  encoding: [0x62,0x71,0x7f,0x38,0x2d,0xef]
          vcvtsd2si r13d, xmm7, {rd-sae}

// CHECK: vcvtsd2si r13d, xmm7, {rz-sae}
// CHECK:  encoding: [0x62,0x71,0x7f,0x78,0x2d,0xef]
          vcvtsd2si r13d, xmm7, {rz-sae}

// CHECK: vcvtsd2si rax, xmm10, {rn-sae}
// CHECK:  encoding: [0x62,0xd1,0xff,0x18,0x2d,0xc2]
          vcvtsd2si rax, xmm10, {rn-sae}

// CHECK: vcvtsd2si rax, xmm10, {ru-sae}
// CHECK:  encoding: [0x62,0xd1,0xff,0x58,0x2d,0xc2]
          vcvtsd2si rax, xmm10, {ru-sae}

// CHECK: vcvtsd2si rax, xmm10, {rd-sae}
// CHECK:  encoding: [0x62,0xd1,0xff,0x38,0x2d,0xc2]
          vcvtsd2si rax, xmm10, {rd-sae}

// CHECK: vcvtsd2si rax, xmm10, {rz-sae}
// CHECK:  encoding: [0x62,0xd1,0xff,0x78,0x2d,0xc2]
          vcvtsd2si rax, xmm10, {rz-sae}

// CHECK: vcvtsd2si r8, xmm10, {rn-sae}
// CHECK:  encoding: [0x62,0x51,0xff,0x18,0x2d,0xc2]
          vcvtsd2si r8, xmm10, {rn-sae}

// CHECK: vcvtsd2si r8, xmm10, {ru-sae}
// CHECK:  encoding: [0x62,0x51,0xff,0x58,0x2d,0xc2]
          vcvtsd2si r8, xmm10, {ru-sae}

// CHECK: vcvtsd2si r8, xmm10, {rd-sae}
// CHECK:  encoding: [0x62,0x51,0xff,0x38,0x2d,0xc2]
          vcvtsd2si r8, xmm10, {rd-sae}

// CHECK: vcvtsd2si r8, xmm10, {rz-sae}
// CHECK:  encoding: [0x62,0x51,0xff,0x78,0x2d,0xc2]
          vcvtsd2si r8, xmm10, {rz-sae}

// CHECK: vcvtsd2ss xmm17, xmm9, xmm12
// CHECK:  encoding: [0x62,0xc1,0xb7,0x48,0x5a,0xcc]
          vcvtsd2ss xmm17, xmm9, xmm12

// CHECK: vcvtsd2ss xmm17 {k6}, xmm9, xmm12
// CHECK:  encoding: [0x62,0xc1,0xb7,0x4e,0x5a,0xcc]
          vcvtsd2ss xmm17 {k6}, xmm9, xmm12

// CHECK: vcvtsd2ss xmm17 {k6} {z}, xmm9, xmm12
// CHECK:  encoding: [0x62,0xc1,0xb7,0xce,0x5a,0xcc]
          vcvtsd2ss xmm17 {k6} {z}, xmm9, xmm12

// CHECK: vcvtsd2ss xmm17, xmm9, xmm12, {rn-sae}
// CHECK:  encoding: [0x62,0xc1,0xb7,0x18,0x5a,0xcc]
          vcvtsd2ss xmm17, xmm9, xmm12, {rn-sae}

// CHECK: vcvtsd2ss xmm17, xmm9, xmm12, {ru-sae}
// CHECK:  encoding: [0x62,0xc1,0xb7,0x58,0x5a,0xcc]
          vcvtsd2ss xmm17, xmm9, xmm12, {ru-sae}

// CHECK: vcvtsd2ss xmm17, xmm9, xmm12, {rd-sae}
// CHECK:  encoding: [0x62,0xc1,0xb7,0x38,0x5a,0xcc]
          vcvtsd2ss xmm17, xmm9, xmm12, {rd-sae}

// CHECK: vcvtsd2ss xmm17, xmm9, xmm12, {rz-sae}
// CHECK:  encoding: [0x62,0xc1,0xb7,0x78,0x5a,0xcc]
          vcvtsd2ss xmm17, xmm9, xmm12, {rz-sae}

// CHECK: vcvtsd2ss xmm17, xmm9, qword ptr [rcx]
// CHECK:  encoding: [0x62,0xe1,0xb7,0x48,0x5a,0x09]
          vcvtsd2ss xmm17, xmm9, qword ptr [rcx]

// CHECK: vcvtsd2ss xmm17, xmm9, qword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0xa1,0xb7,0x48,0x5a,0x8c,0xf0,0x23,0x01,0x00,0x00]
          vcvtsd2ss xmm17, xmm9, qword ptr [rax + 8*r14 + 291]

// CHECK: vcvtsd2ss xmm17, xmm9, qword ptr [rdx + 1016]
// CHECK:  encoding: [0x62,0xe1,0xb7,0x48,0x5a,0x4a,0x7f]
          vcvtsd2ss xmm17, xmm9, qword ptr [rdx + 1016]

// CHECK: vcvtsd2ss xmm17, xmm9, qword ptr [rdx + 1024]
// CHECK:  encoding: [0x62,0xe1,0xb7,0x48,0x5a,0x8a,0x00,0x04,0x00,0x00]
          vcvtsd2ss xmm17, xmm9, qword ptr [rdx + 1024]

// CHECK: vcvtsd2ss xmm17, xmm9, qword ptr [rdx - 1024]
// CHECK:  encoding: [0x62,0xe1,0xb7,0x48,0x5a,0x4a,0x80]
          vcvtsd2ss xmm17, xmm9, qword ptr [rdx - 1024]

// CHECK: vcvtsd2ss xmm17, xmm9, qword ptr [rdx - 1032]
// CHECK:  encoding: [0x62,0xe1,0xb7,0x48,0x5a,0x8a,0xf8,0xfb,0xff,0xff]
          vcvtsd2ss xmm17, xmm9, qword ptr [rdx - 1032]

// CHECK: vcvtsi2sd xmm7, xmm10, eax
// CHECK:  encoding: [0xc5,0xab,0x2a,0xf8]
          vcvtsi2sd xmm7, xmm10, eax

// CHECK: vcvtsi2sd xmm7, xmm10, ebp
// CHECK:  encoding: [0xc5,0xab,0x2a,0xfd]
          vcvtsi2sd xmm7, xmm10, ebp

// CHECK: vcvtsi2sd xmm7, xmm10, r13d
// CHECK:  encoding: [0xc4,0xc1,0x2b,0x2a,0xfd]
          vcvtsi2sd xmm7, xmm10, r13d

// CHECK: vcvtsi2sd xmm7, xmm10, dword ptr [rcx]
// CHECK:  encoding: [0xc5,0xab,0x2a,0x39]
          vcvtsi2sd xmm7, xmm10, dword ptr [rcx]

// CHECK: vcvtsi2sd xmm7, xmm10, dword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0xc4,0xa1,0x2b,0x2a,0xbc,0xf0,0x23,0x01,0x00,0x00]
          vcvtsi2sd xmm7, xmm10, dword ptr [rax + 8*r14 + 291]

// CHECK: vcvtsi2sd xmm7, xmm10, dword ptr [rdx + 508]
// CHECK:  encoding: [0xc5,0xab,0x2a,0xba,0xfc,0x01,0x00,0x00]
          vcvtsi2sd xmm7, xmm10, dword ptr [rdx + 508]

// CHECK: vcvtsi2sd xmm7, xmm10, dword ptr [rdx + 512]
// CHECK:  encoding: [0xc5,0xab,0x2a,0xba,0x00,0x02,0x00,0x00]
          vcvtsi2sd xmm7, xmm10, dword ptr [rdx + 512]

// CHECK: vcvtsi2sd xmm7, xmm10, dword ptr [rdx - 512]
// CHECK:  encoding: [0xc5,0xab,0x2a,0xba,0x00,0xfe,0xff,0xff]
          vcvtsi2sd xmm7, xmm10, dword ptr [rdx - 512]

// CHECK: vcvtsi2sd xmm7, xmm10, dword ptr [rdx - 516]
// CHECK:  encoding: [0xc5,0xab,0x2a,0xba,0xfc,0xfd,0xff,0xff]
          vcvtsi2sd xmm7, xmm10, dword ptr [rdx - 516]

// CHECK: vcvtsi2sd xmm29, xmm12, rax
// CHECK:  encoding: [0x62,0x61,0x9f,0x08,0x2a,0xe8]
          vcvtsi2sd xmm29, xmm12, rax

// CHECK: vcvtsi2sd xmm29, xmm12, {rn-sae}, rax
// CHECK:  encoding: [0x62,0x61,0x9f,0x18,0x2a,0xe8]
          vcvtsi2sd xmm29, xmm12, {rn-sae}, rax

// CHECK: vcvtsi2sd xmm29, xmm12, {ru-sae}, rax
// CHECK:  encoding: [0x62,0x61,0x9f,0x58,0x2a,0xe8]
          vcvtsi2sd xmm29, xmm12, {ru-sae}, rax

// CHECK: vcvtsi2sd xmm29, xmm12, {rd-sae}, rax
// CHECK:  encoding: [0x62,0x61,0x9f,0x38,0x2a,0xe8]
          vcvtsi2sd xmm29, xmm12, {rd-sae}, rax

// CHECK: vcvtsi2sd xmm29, xmm12, {rz-sae}, rax
// CHECK:  encoding: [0x62,0x61,0x9f,0x78,0x2a,0xe8]
          vcvtsi2sd xmm29, xmm12, {rz-sae}, rax

// CHECK: vcvtsi2sd xmm29, xmm12, r8
// CHECK:  encoding: [0x62,0x41,0x9f,0x08,0x2a,0xe8]
          vcvtsi2sd xmm29, xmm12, r8

// CHECK: vcvtsi2sd xmm29, xmm12, {rn-sae}, r8
// CHECK:  encoding: [0x62,0x41,0x9f,0x18,0x2a,0xe8]
          vcvtsi2sd xmm29, xmm12, {rn-sae}, r8

// CHECK: vcvtsi2sd xmm29, xmm12, {ru-sae}, r8
// CHECK:  encoding: [0x62,0x41,0x9f,0x58,0x2a,0xe8]
          vcvtsi2sd xmm29, xmm12, {ru-sae}, r8

// CHECK: vcvtsi2sd xmm29, xmm12, {rd-sae}, r8
// CHECK:  encoding: [0x62,0x41,0x9f,0x38,0x2a,0xe8]
          vcvtsi2sd xmm29, xmm12, {rd-sae}, r8

// CHECK: vcvtsi2sd xmm29, xmm12, {rz-sae}, r8
// CHECK:  encoding: [0x62,0x41,0x9f,0x78,0x2a,0xe8]
          vcvtsi2sd xmm29, xmm12, {rz-sae}, r8

// CHECK: vcvtsi2sd xmm29, xmm12, qword ptr [rcx]
// CHECK:  encoding: [0x62,0x61,0x9f,0x08,0x2a,0x29]
          vcvtsi2sd xmm29, xmm12, qword ptr [rcx]

// CHECK: vcvtsi2sd xmm29, xmm12, qword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0x21,0x9f,0x08,0x2a,0xac,0xf0,0x23,0x01,0x00,0x00]
          vcvtsi2sd xmm29, xmm12, qword ptr [rax + 8*r14 + 291]

// CHECK: vcvtsi2sd xmm29, xmm12, qword ptr [rdx + 1016]
// CHECK:  encoding: [0x62,0x61,0x9f,0x08,0x2a,0x6a,0x7f]
          vcvtsi2sd xmm29, xmm12, qword ptr [rdx + 1016]

// CHECK: vcvtsi2sd xmm29, xmm12, qword ptr [rdx + 1024]
// CHECK:  encoding: [0x62,0x61,0x9f,0x08,0x2a,0xaa,0x00,0x04,0x00,0x00]
          vcvtsi2sd xmm29, xmm12, qword ptr [rdx + 1024]

// CHECK: vcvtsi2sd xmm29, xmm12, qword ptr [rdx - 1024]
// CHECK:  encoding: [0x62,0x61,0x9f,0x08,0x2a,0x6a,0x80]
          vcvtsi2sd xmm29, xmm12, qword ptr [rdx - 1024]

// CHECK: vcvtsi2sd xmm29, xmm12, qword ptr [rdx - 1032]
// CHECK:  encoding: [0x62,0x61,0x9f,0x08,0x2a,0xaa,0xf8,0xfb,0xff,0xff]
          vcvtsi2sd xmm29, xmm12, qword ptr [rdx - 1032]

// CHECK: vcvtsi2ss xmm15, xmm10, eax
// CHECK:  encoding: [0xc5,0x2a,0x2a,0xf8]
          vcvtsi2ss xmm15, xmm10, eax

// CHECK: vcvtsi2ss xmm15, xmm10, {rn-sae}, eax
// CHECK:  encoding: [0x62,0x71,0x2e,0x18,0x2a,0xf8]
          vcvtsi2ss xmm15, xmm10, {rn-sae}, eax

// CHECK: vcvtsi2ss xmm15, xmm10, {ru-sae}, eax
// CHECK:  encoding: [0x62,0x71,0x2e,0x58,0x2a,0xf8]
          vcvtsi2ss xmm15, xmm10, {ru-sae}, eax

// CHECK: vcvtsi2ss xmm15, xmm10, {rd-sae}, eax
// CHECK:  encoding: [0x62,0x71,0x2e,0x38,0x2a,0xf8]
          vcvtsi2ss xmm15, xmm10, {rd-sae}, eax

// CHECK: vcvtsi2ss xmm15, xmm10, {rz-sae}, eax
// CHECK:  encoding: [0x62,0x71,0x2e,0x78,0x2a,0xf8]
          vcvtsi2ss xmm15, xmm10, {rz-sae}, eax

// CHECK: vcvtsi2ss xmm15, xmm10, ebp
// CHECK:  encoding: [0xc5,0x2a,0x2a,0xfd]
          vcvtsi2ss xmm15, xmm10, ebp

// CHECK: vcvtsi2ss xmm15, xmm10, {rn-sae}, ebp
// CHECK:  encoding: [0x62,0x71,0x2e,0x18,0x2a,0xfd]
          vcvtsi2ss xmm15, xmm10, {rn-sae}, ebp

// CHECK: vcvtsi2ss xmm15, xmm10, {ru-sae}, ebp
// CHECK:  encoding: [0x62,0x71,0x2e,0x58,0x2a,0xfd]
          vcvtsi2ss xmm15, xmm10, {ru-sae}, ebp

// CHECK: vcvtsi2ss xmm15, xmm10, {rd-sae}, ebp
// CHECK:  encoding: [0x62,0x71,0x2e,0x38,0x2a,0xfd]
          vcvtsi2ss xmm15, xmm10, {rd-sae}, ebp

// CHECK: vcvtsi2ss xmm15, xmm10, {rz-sae}, ebp
// CHECK:  encoding: [0x62,0x71,0x2e,0x78,0x2a,0xfd]
          vcvtsi2ss xmm15, xmm10, {rz-sae}, ebp

// CHECK: vcvtsi2ss xmm15, xmm10, r13d
// CHECK:  encoding: [0xc4,0x41,0x2a,0x2a,0xfd]
          vcvtsi2ss xmm15, xmm10, r13d

// CHECK: vcvtsi2ss xmm15, xmm10, {rn-sae}, r13d
// CHECK:  encoding: [0x62,0x51,0x2e,0x18,0x2a,0xfd]
          vcvtsi2ss xmm15, xmm10, {rn-sae}, r13d

// CHECK: vcvtsi2ss xmm15, xmm10, {ru-sae}, r13d
// CHECK:  encoding: [0x62,0x51,0x2e,0x58,0x2a,0xfd]
          vcvtsi2ss xmm15, xmm10, {ru-sae}, r13d

// CHECK: vcvtsi2ss xmm15, xmm10, {rd-sae}, r13d
// CHECK:  encoding: [0x62,0x51,0x2e,0x38,0x2a,0xfd]
          vcvtsi2ss xmm15, xmm10, {rd-sae}, r13d

// CHECK: vcvtsi2ss xmm15, xmm10, {rz-sae}, r13d
// CHECK:  encoding: [0x62,0x51,0x2e,0x78,0x2a,0xfd]
          vcvtsi2ss xmm15, xmm10, {rz-sae}, r13d

// CHECK: vcvtsi2ss xmm15, xmm10, dword ptr [rcx]
// CHECK:  encoding: [0xc5,0x2a,0x2a,0x39]
          vcvtsi2ss xmm15, xmm10, dword ptr [rcx]

// CHECK: vcvtsi2ss xmm15, xmm10, dword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0xc4,0x21,0x2a,0x2a,0xbc,0xf0,0x23,0x01,0x00,0x00]
          vcvtsi2ss xmm15, xmm10, dword ptr [rax + 8*r14 + 291]

// CHECK: vcvtsi2ss xmm15, xmm10, dword ptr [rdx + 508]
// CHECK:  encoding: [0xc5,0x2a,0x2a,0xba,0xfc,0x01,0x00,0x00]
          vcvtsi2ss xmm15, xmm10, dword ptr [rdx + 508]

// CHECK: vcvtsi2ss xmm15, xmm10, dword ptr [rdx + 512]
// CHECK:  encoding: [0xc5,0x2a,0x2a,0xba,0x00,0x02,0x00,0x00]
          vcvtsi2ss xmm15, xmm10, dword ptr [rdx + 512]

// CHECK: vcvtsi2ss xmm15, xmm10, dword ptr [rdx - 512]
// CHECK:  encoding: [0xc5,0x2a,0x2a,0xba,0x00,0xfe,0xff,0xff]
          vcvtsi2ss xmm15, xmm10, dword ptr [rdx - 512]

// CHECK: vcvtsi2ss xmm15, xmm10, dword ptr [rdx - 516]
// CHECK:  encoding: [0xc5,0x2a,0x2a,0xba,0xfc,0xfd,0xff,0xff]
          vcvtsi2ss xmm15, xmm10, dword ptr [rdx - 516]

// CHECK: vcvtsi2ss xmm16, xmm10, rax
// CHECK:  encoding: [0x62,0xe1,0xae,0x08,0x2a,0xc0]
          vcvtsi2ss xmm16, xmm10, rax

// CHECK: vcvtsi2ss xmm16, xmm10, {rn-sae}, rax
// CHECK:  encoding: [0x62,0xe1,0xae,0x18,0x2a,0xc0]
          vcvtsi2ss xmm16, xmm10, {rn-sae}, rax

// CHECK: vcvtsi2ss xmm16, xmm10, {ru-sae}, rax
// CHECK:  encoding: [0x62,0xe1,0xae,0x58,0x2a,0xc0]
          vcvtsi2ss xmm16, xmm10, {ru-sae}, rax

// CHECK: vcvtsi2ss xmm16, xmm10, {rd-sae}, rax
// CHECK:  encoding: [0x62,0xe1,0xae,0x38,0x2a,0xc0]
          vcvtsi2ss xmm16, xmm10, {rd-sae}, rax

// CHECK: vcvtsi2ss xmm16, xmm10, {rz-sae}, rax
// CHECK:  encoding: [0x62,0xe1,0xae,0x78,0x2a,0xc0]
          vcvtsi2ss xmm16, xmm10, {rz-sae}, rax

// CHECK: vcvtsi2ss xmm16, xmm10, r8
// CHECK:  encoding: [0x62,0xc1,0xae,0x08,0x2a,0xc0]
          vcvtsi2ss xmm16, xmm10, r8

// CHECK: vcvtsi2ss xmm16, xmm10, {rn-sae}, r8
// CHECK:  encoding: [0x62,0xc1,0xae,0x18,0x2a,0xc0]
          vcvtsi2ss xmm16, xmm10, {rn-sae}, r8

// CHECK: vcvtsi2ss xmm16, xmm10, {ru-sae}, r8
// CHECK:  encoding: [0x62,0xc1,0xae,0x58,0x2a,0xc0]
          vcvtsi2ss xmm16, xmm10, {ru-sae}, r8

// CHECK: vcvtsi2ss xmm16, xmm10, {rd-sae}, r8
// CHECK:  encoding: [0x62,0xc1,0xae,0x38,0x2a,0xc0]
          vcvtsi2ss xmm16, xmm10, {rd-sae}, r8

// CHECK: vcvtsi2ss xmm16, xmm10, {rz-sae}, r8
// CHECK:  encoding: [0x62,0xc1,0xae,0x78,0x2a,0xc0]
          vcvtsi2ss xmm16, xmm10, {rz-sae}, r8

// CHECK: vcvtsi2ss xmm16, xmm10, qword ptr [rcx]
// CHECK:  encoding: [0x62,0xe1,0xae,0x08,0x2a,0x01]
          vcvtsi2ss xmm16, xmm10, qword ptr [rcx]

// CHECK: vcvtsi2ss xmm16, xmm10, qword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0xa1,0xae,0x08,0x2a,0x84,0xf0,0x23,0x01,0x00,0x00]
          vcvtsi2ss xmm16, xmm10, qword ptr [rax + 8*r14 + 291]

// CHECK: vcvtsi2ss xmm16, xmm10, qword ptr [rdx + 1016]
// CHECK:  encoding: [0x62,0xe1,0xae,0x08,0x2a,0x42,0x7f]
          vcvtsi2ss xmm16, xmm10, qword ptr [rdx + 1016]

// CHECK: vcvtsi2ss xmm16, xmm10, qword ptr [rdx + 1024]
// CHECK:  encoding: [0x62,0xe1,0xae,0x08,0x2a,0x82,0x00,0x04,0x00,0x00]
          vcvtsi2ss xmm16, xmm10, qword ptr [rdx + 1024]

// CHECK: vcvtsi2ss xmm16, xmm10, qword ptr [rdx - 1024]
// CHECK:  encoding: [0x62,0xe1,0xae,0x08,0x2a,0x42,0x80]
          vcvtsi2ss xmm16, xmm10, qword ptr [rdx - 1024]

// CHECK: vcvtsi2ss xmm16, xmm10, qword ptr [rdx - 1032]
// CHECK:  encoding: [0x62,0xe1,0xae,0x08,0x2a,0x82,0xf8,0xfb,0xff,0xff]
          vcvtsi2ss xmm16, xmm10, qword ptr [rdx - 1032]

// CHECK: vcvtss2sd xmm28, xmm6, xmm6
// CHECK:  encoding: [0x62,0x61,0x4e,0x48,0x5a,0xe6]
          vcvtss2sd xmm28, xmm6, xmm6

// CHECK: vcvtss2sd xmm28 {k3}, xmm6, xmm6
// CHECK:  encoding: [0x62,0x61,0x4e,0x4b,0x5a,0xe6]
          vcvtss2sd xmm28 {k3}, xmm6, xmm6

// CHECK: vcvtss2sd xmm28 {k3} {z}, xmm6, xmm6
// CHECK:  encoding: [0x62,0x61,0x4e,0xcb,0x5a,0xe6]
          vcvtss2sd xmm28 {k3} {z}, xmm6, xmm6

// CHECK: vcvtss2sd xmm28, xmm6, xmm6, {sae}
// CHECK:  encoding: [0x62,0x61,0x4e,0x18,0x5a,0xe6]
          vcvtss2sd xmm28, xmm6, xmm6, {sae}

// CHECK: vcvtss2sd xmm28, xmm6, dword ptr [rcx]
// CHECK:  encoding: [0x62,0x61,0x4e,0x48,0x5a,0x21]
          vcvtss2sd xmm28, xmm6, dword ptr [rcx]

// CHECK: vcvtss2sd xmm28, xmm6, dword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0x21,0x4e,0x48,0x5a,0xa4,0xf0,0x23,0x01,0x00,0x00]
          vcvtss2sd xmm28, xmm6, dword ptr [rax + 8*r14 + 291]

// CHECK: vcvtss2sd xmm28, xmm6, dword ptr [rdx + 508]
// CHECK:  encoding: [0x62,0x61,0x4e,0x48,0x5a,0x62,0x7f]
          vcvtss2sd xmm28, xmm6, dword ptr [rdx + 508]

// CHECK: vcvtss2sd xmm28, xmm6, dword ptr [rdx + 512]
// CHECK:  encoding: [0x62,0x61,0x4e,0x48,0x5a,0xa2,0x00,0x02,0x00,0x00]
          vcvtss2sd xmm28, xmm6, dword ptr [rdx + 512]

// CHECK: vcvtss2sd xmm28, xmm6, dword ptr [rdx - 512]
// CHECK:  encoding: [0x62,0x61,0x4e,0x48,0x5a,0x62,0x80]
          vcvtss2sd xmm28, xmm6, dword ptr [rdx - 512]

// CHECK: vcvtss2sd xmm28, xmm6, dword ptr [rdx - 516]
// CHECK:  encoding: [0x62,0x61,0x4e,0x48,0x5a,0xa2,0xfc,0xfd,0xff,0xff]
          vcvtss2sd xmm28, xmm6, dword ptr [rdx - 516]

// CHECK: vcvtss2si eax, xmm22, {rn-sae}
// CHECK:  encoding: [0x62,0xb1,0x7e,0x18,0x2d,0xc6]
          vcvtss2si eax, xmm22, {rn-sae}

// CHECK: vcvtss2si eax, xmm22, {ru-sae}
// CHECK:  encoding: [0x62,0xb1,0x7e,0x58,0x2d,0xc6]
          vcvtss2si eax, xmm22, {ru-sae}

// CHECK: vcvtss2si eax, xmm22, {rd-sae}
// CHECK:  encoding: [0x62,0xb1,0x7e,0x38,0x2d,0xc6]
          vcvtss2si eax, xmm22, {rd-sae}

// CHECK: vcvtss2si eax, xmm22, {rz-sae}
// CHECK:  encoding: [0x62,0xb1,0x7e,0x78,0x2d,0xc6]
          vcvtss2si eax, xmm22, {rz-sae}

// CHECK: vcvtss2si ebp, xmm22, {rn-sae}
// CHECK:  encoding: [0x62,0xb1,0x7e,0x18,0x2d,0xee]
          vcvtss2si ebp, xmm22, {rn-sae}

// CHECK: vcvtss2si ebp, xmm22, {ru-sae}
// CHECK:  encoding: [0x62,0xb1,0x7e,0x58,0x2d,0xee]
          vcvtss2si ebp, xmm22, {ru-sae}

// CHECK: vcvtss2si ebp, xmm22, {rd-sae}
// CHECK:  encoding: [0x62,0xb1,0x7e,0x38,0x2d,0xee]
          vcvtss2si ebp, xmm22, {rd-sae}

// CHECK: vcvtss2si ebp, xmm22, {rz-sae}
// CHECK:  encoding: [0x62,0xb1,0x7e,0x78,0x2d,0xee]
          vcvtss2si ebp, xmm22, {rz-sae}

// CHECK: vcvtss2si r13d, xmm22, {rn-sae}
// CHECK:  encoding: [0x62,0x31,0x7e,0x18,0x2d,0xee]
          vcvtss2si r13d, xmm22, {rn-sae}

// CHECK: vcvtss2si r13d, xmm22, {ru-sae}
// CHECK:  encoding: [0x62,0x31,0x7e,0x58,0x2d,0xee]
          vcvtss2si r13d, xmm22, {ru-sae}

// CHECK: vcvtss2si r13d, xmm22, {rd-sae}
// CHECK:  encoding: [0x62,0x31,0x7e,0x38,0x2d,0xee]
          vcvtss2si r13d, xmm22, {rd-sae}

// CHECK: vcvtss2si r13d, xmm22, {rz-sae}
// CHECK:  encoding: [0x62,0x31,0x7e,0x78,0x2d,0xee]
          vcvtss2si r13d, xmm22, {rz-sae}

// CHECK: vcvtss2si rax, xmm29, {rn-sae}
// CHECK:  encoding: [0x62,0x91,0xfe,0x18,0x2d,0xc5]
          vcvtss2si rax, xmm29, {rn-sae}

// CHECK: vcvtss2si rax, xmm29, {ru-sae}
// CHECK:  encoding: [0x62,0x91,0xfe,0x58,0x2d,0xc5]
          vcvtss2si rax, xmm29, {ru-sae}

// CHECK: vcvtss2si rax, xmm29, {rd-sae}
// CHECK:  encoding: [0x62,0x91,0xfe,0x38,0x2d,0xc5]
          vcvtss2si rax, xmm29, {rd-sae}

// CHECK: vcvtss2si rax, xmm29, {rz-sae}
// CHECK:  encoding: [0x62,0x91,0xfe,0x78,0x2d,0xc5]
          vcvtss2si rax, xmm29, {rz-sae}

// CHECK: vcvtss2si r8, xmm29, {rn-sae}
// CHECK:  encoding: [0x62,0x11,0xfe,0x18,0x2d,0xc5]
          vcvtss2si r8, xmm29, {rn-sae}

// CHECK: vcvtss2si r8, xmm29, {ru-sae}
// CHECK:  encoding: [0x62,0x11,0xfe,0x58,0x2d,0xc5]
          vcvtss2si r8, xmm29, {ru-sae}

// CHECK: vcvtss2si r8, xmm29, {rd-sae}
// CHECK:  encoding: [0x62,0x11,0xfe,0x38,0x2d,0xc5]
          vcvtss2si r8, xmm29, {rd-sae}

// CHECK: vcvtss2si r8, xmm29, {rz-sae}
// CHECK:  encoding: [0x62,0x11,0xfe,0x78,0x2d,0xc5]
          vcvtss2si r8, xmm29, {rz-sae}

// CHECK: vcvttpd2dq ymm27, zmm9
// CHECK:  encoding: [0x62,0x41,0xfd,0x48,0xe6,0xd9]
          vcvttpd2dq ymm27, zmm9

// CHECK: vcvttpd2dq ymm27 {k5}, zmm9
// CHECK:  encoding: [0x62,0x41,0xfd,0x4d,0xe6,0xd9]
          vcvttpd2dq ymm27 {k5}, zmm9

// CHECK: vcvttpd2dq ymm27 {k5} {z}, zmm9
// CHECK:  encoding: [0x62,0x41,0xfd,0xcd,0xe6,0xd9]
          vcvttpd2dq ymm27 {k5} {z}, zmm9

// CHECK: vcvttpd2dq ymm27, zmm9, {sae}
// CHECK:  encoding: [0x62,0x41,0xfd,0x18,0xe6,0xd9]
          vcvttpd2dq ymm27, zmm9, {sae}

// CHECK: vcvttpd2dq ymm27, zmmword ptr [rcx]
// CHECK:  encoding: [0x62,0x61,0xfd,0x48,0xe6,0x19]
          vcvttpd2dq ymm27, zmmword ptr [rcx]

// CHECK: vcvttpd2dq ymm27, zmmword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0x21,0xfd,0x48,0xe6,0x9c,0xf0,0x23,0x01,0x00,0x00]
          vcvttpd2dq ymm27, zmmword ptr [rax + 8*r14 + 291]

// CHECK: vcvttpd2dq ymm27, qword ptr [rcx]{1to8}
// CHECK:  encoding: [0x62,0x61,0xfd,0x58,0xe6,0x19]
          vcvttpd2dq ymm27, qword ptr [rcx]{1to8}

// CHECK: vcvttpd2dq ymm27, zmmword ptr [rdx + 8128]
// CHECK:  encoding: [0x62,0x61,0xfd,0x48,0xe6,0x5a,0x7f]
          vcvttpd2dq ymm27, zmmword ptr [rdx + 8128]

// CHECK: vcvttpd2dq ymm27, zmmword ptr [rdx + 8192]
// CHECK:  encoding: [0x62,0x61,0xfd,0x48,0xe6,0x9a,0x00,0x20,0x00,0x00]
          vcvttpd2dq ymm27, zmmword ptr [rdx + 8192]

// CHECK: vcvttpd2dq ymm27, zmmword ptr [rdx - 8192]
// CHECK:  encoding: [0x62,0x61,0xfd,0x48,0xe6,0x5a,0x80]
          vcvttpd2dq ymm27, zmmword ptr [rdx - 8192]

// CHECK: vcvttpd2dq ymm27, zmmword ptr [rdx - 8256]
// CHECK:  encoding: [0x62,0x61,0xfd,0x48,0xe6,0x9a,0xc0,0xdf,0xff,0xff]
          vcvttpd2dq ymm27, zmmword ptr [rdx - 8256]

// CHECK: vcvttpd2dq ymm27, qword ptr [rdx + 1016]{1to8}
// CHECK:  encoding: [0x62,0x61,0xfd,0x58,0xe6,0x5a,0x7f]
          vcvttpd2dq ymm27, qword ptr [rdx + 1016]{1to8}

// CHECK: vcvttpd2dq ymm27, qword ptr [rdx + 1024]{1to8}
// CHECK:  encoding: [0x62,0x61,0xfd,0x58,0xe6,0x9a,0x00,0x04,0x00,0x00]
          vcvttpd2dq ymm27, qword ptr [rdx + 1024]{1to8}

// CHECK: vcvttpd2dq ymm27, qword ptr [rdx - 1024]{1to8}
// CHECK:  encoding: [0x62,0x61,0xfd,0x58,0xe6,0x5a,0x80]
          vcvttpd2dq ymm27, qword ptr [rdx - 1024]{1to8}

// CHECK: vcvttpd2dq ymm27, qword ptr [rdx - 1032]{1to8}
// CHECK:  encoding: [0x62,0x61,0xfd,0x58,0xe6,0x9a,0xf8,0xfb,0xff,0xff]
          vcvttpd2dq ymm27, qword ptr [rdx - 1032]{1to8}

// CHECK: vcvttps2dq zmm14, zmm25
// CHECK:  encoding: [0x62,0x11,0x7e,0x48,0x5b,0xf1]
          vcvttps2dq zmm14, zmm25

// CHECK: vcvttps2dq zmm14 {k3}, zmm25
// CHECK:  encoding: [0x62,0x11,0x7e,0x4b,0x5b,0xf1]
          vcvttps2dq zmm14 {k3}, zmm25

// CHECK: vcvttps2dq zmm14 {k3} {z}, zmm25
// CHECK:  encoding: [0x62,0x11,0x7e,0xcb,0x5b,0xf1]
          vcvttps2dq zmm14 {k3} {z}, zmm25

// CHECK: vcvttps2dq zmm14, zmm25, {sae}
// CHECK:  encoding: [0x62,0x11,0x7e,0x18,0x5b,0xf1]
          vcvttps2dq zmm14, zmm25, {sae}

// CHECK: vcvttps2dq zmm14, zmmword ptr [rcx]
// CHECK:  encoding: [0x62,0x71,0x7e,0x48,0x5b,0x31]
          vcvttps2dq zmm14, zmmword ptr [rcx]

// CHECK: vcvttps2dq zmm14, zmmword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0x31,0x7e,0x48,0x5b,0xb4,0xf0,0x23,0x01,0x00,0x00]
          vcvttps2dq zmm14, zmmword ptr [rax + 8*r14 + 291]

// CHECK: vcvttps2dq zmm14, dword ptr [rcx]{1to16}
// CHECK:  encoding: [0x62,0x71,0x7e,0x58,0x5b,0x31]
          vcvttps2dq zmm14, dword ptr [rcx]{1to16}

// CHECK: vcvttps2dq zmm14, zmmword ptr [rdx + 8128]
// CHECK:  encoding: [0x62,0x71,0x7e,0x48,0x5b,0x72,0x7f]
          vcvttps2dq zmm14, zmmword ptr [rdx + 8128]

// CHECK: vcvttps2dq zmm14, zmmword ptr [rdx + 8192]
// CHECK:  encoding: [0x62,0x71,0x7e,0x48,0x5b,0xb2,0x00,0x20,0x00,0x00]
          vcvttps2dq zmm14, zmmword ptr [rdx + 8192]

// CHECK: vcvttps2dq zmm14, zmmword ptr [rdx - 8192]
// CHECK:  encoding: [0x62,0x71,0x7e,0x48,0x5b,0x72,0x80]
          vcvttps2dq zmm14, zmmword ptr [rdx - 8192]

// CHECK: vcvttps2dq zmm14, zmmword ptr [rdx - 8256]
// CHECK:  encoding: [0x62,0x71,0x7e,0x48,0x5b,0xb2,0xc0,0xdf,0xff,0xff]
          vcvttps2dq zmm14, zmmword ptr [rdx - 8256]

// CHECK: vcvttps2dq zmm14, dword ptr [rdx + 508]{1to16}
// CHECK:  encoding: [0x62,0x71,0x7e,0x58,0x5b,0x72,0x7f]
          vcvttps2dq zmm14, dword ptr [rdx + 508]{1to16}

// CHECK: vcvttps2dq zmm14, dword ptr [rdx + 512]{1to16}
// CHECK:  encoding: [0x62,0x71,0x7e,0x58,0x5b,0xb2,0x00,0x02,0x00,0x00]
          vcvttps2dq zmm14, dword ptr [rdx + 512]{1to16}

// CHECK: vcvttps2dq zmm14, dword ptr [rdx - 512]{1to16}
// CHECK:  encoding: [0x62,0x71,0x7e,0x58,0x5b,0x72,0x80]
          vcvttps2dq zmm14, dword ptr [rdx - 512]{1to16}

// CHECK: vcvttps2dq zmm14, dword ptr [rdx - 516]{1to16}
// CHECK:  encoding: [0x62,0x71,0x7e,0x58,0x5b,0xb2,0xfc,0xfd,0xff,0xff]
          vcvttps2dq zmm14, dword ptr [rdx - 516]{1to16}

// CHECK: vcvttsd2si eax, xmm3, {sae}
// CHECK:  encoding: [0x62,0xf1,0x7f,0x18,0x2c,0xc3]
          vcvttsd2si eax, xmm3, {sae}

// CHECK: vcvttsd2si ebp, xmm3, {sae}
// CHECK:  encoding: [0x62,0xf1,0x7f,0x18,0x2c,0xeb]
          vcvttsd2si ebp, xmm3, {sae}

// CHECK: vcvttsd2si r13d, xmm3, {sae}
// CHECK:  encoding: [0x62,0x71,0x7f,0x18,0x2c,0xeb]
          vcvttsd2si r13d, xmm3, {sae}

// CHECK: vcvttsd2si rax, xmm1, {sae}
// CHECK:  encoding: [0x62,0xf1,0xff,0x18,0x2c,0xc1]
          vcvttsd2si rax, xmm1, {sae}

// CHECK: vcvttsd2si r8, xmm1, {sae}
// CHECK:  encoding: [0x62,0x71,0xff,0x18,0x2c,0xc1]
          vcvttsd2si r8, xmm1, {sae}

// CHECK: vcvttss2si eax, xmm14, {sae}
// CHECK:  encoding: [0x62,0xd1,0x7e,0x18,0x2c,0xc6]
          vcvttss2si eax, xmm14, {sae}

// CHECK: vcvttss2si ebp, xmm14, {sae}
// CHECK:  encoding: [0x62,0xd1,0x7e,0x18,0x2c,0xee]
          vcvttss2si ebp, xmm14, {sae}

// CHECK: vcvttss2si r13d, xmm14, {sae}
// CHECK:  encoding: [0x62,0x51,0x7e,0x18,0x2c,0xee]
          vcvttss2si r13d, xmm14, {sae}

// CHECK: vcvttss2si rax, xmm21, {sae}
// CHECK:  encoding: [0x62,0xb1,0xfe,0x18,0x2c,0xc5]
          vcvttss2si rax, xmm21, {sae}

// CHECK: vcvttss2si r8, xmm21, {sae}
// CHECK:  encoding: [0x62,0x31,0xfe,0x18,0x2c,0xc5]
          vcvttss2si r8, xmm21, {sae}

// CHECK: vcvtudq2pd zmm18, ymm14
// CHECK:  encoding: [0x62,0xc1,0x7e,0x48,0x7a,0xd6]
          vcvtudq2pd zmm18, ymm14

// CHECK: vcvtudq2pd zmm18 {k3}, ymm14
// CHECK:  encoding: [0x62,0xc1,0x7e,0x4b,0x7a,0xd6]
          vcvtudq2pd zmm18 {k3}, ymm14

// CHECK: vcvtudq2pd zmm18 {k3} {z}, ymm14
// CHECK:  encoding: [0x62,0xc1,0x7e,0xcb,0x7a,0xd6]
          vcvtudq2pd zmm18 {k3} {z}, ymm14

// CHECK: vcvtudq2pd zmm18, ymmword ptr [rcx]
// CHECK:  encoding: [0x62,0xe1,0x7e,0x48,0x7a,0x11]
          vcvtudq2pd zmm18, ymmword ptr [rcx]

// CHECK: vcvtudq2pd zmm18, ymmword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0xa1,0x7e,0x48,0x7a,0x94,0xf0,0x23,0x01,0x00,0x00]
          vcvtudq2pd zmm18, ymmword ptr [rax + 8*r14 + 291]

// CHECK: vcvtudq2pd zmm18, dword ptr [rcx]{1to8}
// CHECK:  encoding: [0x62,0xe1,0x7e,0x58,0x7a,0x11]
          vcvtudq2pd zmm18, dword ptr [rcx]{1to8}

// CHECK: vcvtudq2pd zmm18, ymmword ptr [rdx + 4064]
// CHECK:  encoding: [0x62,0xe1,0x7e,0x48,0x7a,0x52,0x7f]
          vcvtudq2pd zmm18, ymmword ptr [rdx + 4064]

// CHECK: vcvtudq2pd zmm18, ymmword ptr [rdx + 4096]
// CHECK:  encoding: [0x62,0xe1,0x7e,0x48,0x7a,0x92,0x00,0x10,0x00,0x00]
          vcvtudq2pd zmm18, ymmword ptr [rdx + 4096]

// CHECK: vcvtudq2pd zmm18, ymmword ptr [rdx - 4096]
// CHECK:  encoding: [0x62,0xe1,0x7e,0x48,0x7a,0x52,0x80]
          vcvtudq2pd zmm18, ymmword ptr [rdx - 4096]

// CHECK: vcvtudq2pd zmm18, ymmword ptr [rdx - 4128]
// CHECK:  encoding: [0x62,0xe1,0x7e,0x48,0x7a,0x92,0xe0,0xef,0xff,0xff]
          vcvtudq2pd zmm18, ymmword ptr [rdx - 4128]

// CHECK: vcvtudq2pd zmm18, dword ptr [rdx + 508]{1to8}
// CHECK:  encoding: [0x62,0xe1,0x7e,0x58,0x7a,0x52,0x7f]
          vcvtudq2pd zmm18, dword ptr [rdx + 508]{1to8}

// CHECK: vcvtudq2pd zmm18, dword ptr [rdx + 512]{1to8}
// CHECK:  encoding: [0x62,0xe1,0x7e,0x58,0x7a,0x92,0x00,0x02,0x00,0x00]
          vcvtudq2pd zmm18, dword ptr [rdx + 512]{1to8}

// CHECK: vcvtudq2pd zmm18, dword ptr [rdx - 512]{1to8}
// CHECK:  encoding: [0x62,0xe1,0x7e,0x58,0x7a,0x52,0x80]
          vcvtudq2pd zmm18, dword ptr [rdx - 512]{1to8}

// CHECK: vcvtudq2pd zmm18, dword ptr [rdx - 516]{1to8}
// CHECK:  encoding: [0x62,0xe1,0x7e,0x58,0x7a,0x92,0xfc,0xfd,0xff,0xff]
          vcvtudq2pd zmm18, dword ptr [rdx - 516]{1to8}

// CHECK: vcvtudq2ps zmm18, zmm7
// CHECK:  encoding: [0x62,0xe1,0x7f,0x48,0x7a,0xd7]
          vcvtudq2ps zmm18, zmm7

// CHECK: vcvtudq2ps zmm18 {k2}, zmm7
// CHECK:  encoding: [0x62,0xe1,0x7f,0x4a,0x7a,0xd7]
          vcvtudq2ps zmm18 {k2}, zmm7

// CHECK: vcvtudq2ps zmm18 {k2} {z}, zmm7
// CHECK:  encoding: [0x62,0xe1,0x7f,0xca,0x7a,0xd7]
          vcvtudq2ps zmm18 {k2} {z}, zmm7

// CHECK: vcvtudq2ps zmm18, zmm7, {rn-sae}
// CHECK:  encoding: [0x62,0xe1,0x7f,0x18,0x7a,0xd7]
          vcvtudq2ps zmm18, zmm7, {rn-sae}

// CHECK: vcvtudq2ps zmm18, zmm7, {ru-sae}
// CHECK:  encoding: [0x62,0xe1,0x7f,0x58,0x7a,0xd7]
          vcvtudq2ps zmm18, zmm7, {ru-sae}

// CHECK: vcvtudq2ps zmm18, zmm7, {rd-sae}
// CHECK:  encoding: [0x62,0xe1,0x7f,0x38,0x7a,0xd7]
          vcvtudq2ps zmm18, zmm7, {rd-sae}

// CHECK: vcvtudq2ps zmm18, zmm7, {rz-sae}
// CHECK:  encoding: [0x62,0xe1,0x7f,0x78,0x7a,0xd7]
          vcvtudq2ps zmm18, zmm7, {rz-sae}

// CHECK: vcvtudq2ps zmm18, zmmword ptr [rcx]
// CHECK:  encoding: [0x62,0xe1,0x7f,0x48,0x7a,0x11]
          vcvtudq2ps zmm18, zmmword ptr [rcx]

// CHECK: vcvtudq2ps zmm18, zmmword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0xa1,0x7f,0x48,0x7a,0x94,0xf0,0x23,0x01,0x00,0x00]
          vcvtudq2ps zmm18, zmmword ptr [rax + 8*r14 + 291]

// CHECK: vcvtudq2ps zmm18, dword ptr [rcx]{1to16}
// CHECK:  encoding: [0x62,0xe1,0x7f,0x58,0x7a,0x11]
          vcvtudq2ps zmm18, dword ptr [rcx]{1to16}

// CHECK: vcvtudq2ps zmm18, zmmword ptr [rdx + 8128]
// CHECK:  encoding: [0x62,0xe1,0x7f,0x48,0x7a,0x52,0x7f]
          vcvtudq2ps zmm18, zmmword ptr [rdx + 8128]

// CHECK: vcvtudq2ps zmm18, zmmword ptr [rdx + 8192]
// CHECK:  encoding: [0x62,0xe1,0x7f,0x48,0x7a,0x92,0x00,0x20,0x00,0x00]
          vcvtudq2ps zmm18, zmmword ptr [rdx + 8192]

// CHECK: vcvtudq2ps zmm18, zmmword ptr [rdx - 8192]
// CHECK:  encoding: [0x62,0xe1,0x7f,0x48,0x7a,0x52,0x80]
          vcvtudq2ps zmm18, zmmword ptr [rdx - 8192]

// CHECK: vcvtudq2ps zmm18, zmmword ptr [rdx - 8256]
// CHECK:  encoding: [0x62,0xe1,0x7f,0x48,0x7a,0x92,0xc0,0xdf,0xff,0xff]
          vcvtudq2ps zmm18, zmmword ptr [rdx - 8256]

// CHECK: vcvtudq2ps zmm18, dword ptr [rdx + 508]{1to16}
// CHECK:  encoding: [0x62,0xe1,0x7f,0x58,0x7a,0x52,0x7f]
          vcvtudq2ps zmm18, dword ptr [rdx + 508]{1to16}

// CHECK: vcvtudq2ps zmm18, dword ptr [rdx + 512]{1to16}
// CHECK:  encoding: [0x62,0xe1,0x7f,0x58,0x7a,0x92,0x00,0x02,0x00,0x00]
          vcvtudq2ps zmm18, dword ptr [rdx + 512]{1to16}

// CHECK: vcvtudq2ps zmm18, dword ptr [rdx - 512]{1to16}
// CHECK:  encoding: [0x62,0xe1,0x7f,0x58,0x7a,0x52,0x80]
          vcvtudq2ps zmm18, dword ptr [rdx - 512]{1to16}

// CHECK: vcvtudq2ps zmm18, dword ptr [rdx - 516]{1to16}
// CHECK:  encoding: [0x62,0xe1,0x7f,0x58,0x7a,0x92,0xfc,0xfd,0xff,0xff]
          vcvtudq2ps zmm18, dword ptr [rdx - 516]{1to16}

// CHECK: vdivpd zmm18, zmm6, zmm11
// CHECK:  encoding: [0x62,0xc1,0xcd,0x48,0x5e,0xd3]
          vdivpd zmm18, zmm6, zmm11

// CHECK: vdivpd zmm18 {k4}, zmm6, zmm11
// CHECK:  encoding: [0x62,0xc1,0xcd,0x4c,0x5e,0xd3]
          vdivpd zmm18 {k4}, zmm6, zmm11

// CHECK: vdivpd zmm18 {k4} {z}, zmm6, zmm11
// CHECK:  encoding: [0x62,0xc1,0xcd,0xcc,0x5e,0xd3]
          vdivpd zmm18 {k4} {z}, zmm6, zmm11

// CHECK: vdivpd zmm18, zmm6, zmm11, {rn-sae}
// CHECK:  encoding: [0x62,0xc1,0xcd,0x18,0x5e,0xd3]
          vdivpd zmm18, zmm6, zmm11, {rn-sae}

// CHECK: vdivpd zmm18, zmm6, zmm11, {ru-sae}
// CHECK:  encoding: [0x62,0xc1,0xcd,0x58,0x5e,0xd3]
          vdivpd zmm18, zmm6, zmm11, {ru-sae}

// CHECK: vdivpd zmm18, zmm6, zmm11, {rd-sae}
// CHECK:  encoding: [0x62,0xc1,0xcd,0x38,0x5e,0xd3]
          vdivpd zmm18, zmm6, zmm11, {rd-sae}

// CHECK: vdivpd zmm18, zmm6, zmm11, {rz-sae}
// CHECK:  encoding: [0x62,0xc1,0xcd,0x78,0x5e,0xd3]
          vdivpd zmm18, zmm6, zmm11, {rz-sae}

// CHECK: vdivpd zmm18, zmm6, zmmword ptr [rcx]
// CHECK:  encoding: [0x62,0xe1,0xcd,0x48,0x5e,0x11]
          vdivpd zmm18, zmm6, zmmword ptr [rcx]

// CHECK: vdivpd zmm18, zmm6, zmmword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0xa1,0xcd,0x48,0x5e,0x94,0xf0,0x23,0x01,0x00,0x00]
          vdivpd zmm18, zmm6, zmmword ptr [rax + 8*r14 + 291]

// CHECK: vdivpd zmm18, zmm6, qword ptr [rcx]{1to8}
// CHECK:  encoding: [0x62,0xe1,0xcd,0x58,0x5e,0x11]
          vdivpd zmm18, zmm6, qword ptr [rcx]{1to8}

// CHECK: vdivpd zmm18, zmm6, zmmword ptr [rdx + 8128]
// CHECK:  encoding: [0x62,0xe1,0xcd,0x48,0x5e,0x52,0x7f]
          vdivpd zmm18, zmm6, zmmword ptr [rdx + 8128]

// CHECK: vdivpd zmm18, zmm6, zmmword ptr [rdx + 8192]
// CHECK:  encoding: [0x62,0xe1,0xcd,0x48,0x5e,0x92,0x00,0x20,0x00,0x00]
          vdivpd zmm18, zmm6, zmmword ptr [rdx + 8192]

// CHECK: vdivpd zmm18, zmm6, zmmword ptr [rdx - 8192]
// CHECK:  encoding: [0x62,0xe1,0xcd,0x48,0x5e,0x52,0x80]
          vdivpd zmm18, zmm6, zmmword ptr [rdx - 8192]

// CHECK: vdivpd zmm18, zmm6, zmmword ptr [rdx - 8256]
// CHECK:  encoding: [0x62,0xe1,0xcd,0x48,0x5e,0x92,0xc0,0xdf,0xff,0xff]
          vdivpd zmm18, zmm6, zmmword ptr [rdx - 8256]

// CHECK: vdivpd zmm18, zmm6, qword ptr [rdx + 1016]{1to8}
// CHECK:  encoding: [0x62,0xe1,0xcd,0x58,0x5e,0x52,0x7f]
          vdivpd zmm18, zmm6, qword ptr [rdx + 1016]{1to8}

// CHECK: vdivpd zmm18, zmm6, qword ptr [rdx + 1024]{1to8}
// CHECK:  encoding: [0x62,0xe1,0xcd,0x58,0x5e,0x92,0x00,0x04,0x00,0x00]
          vdivpd zmm18, zmm6, qword ptr [rdx + 1024]{1to8}

// CHECK: vdivpd zmm18, zmm6, qword ptr [rdx - 1024]{1to8}
// CHECK:  encoding: [0x62,0xe1,0xcd,0x58,0x5e,0x52,0x80]
          vdivpd zmm18, zmm6, qword ptr [rdx - 1024]{1to8}

// CHECK: vdivpd zmm18, zmm6, qword ptr [rdx - 1032]{1to8}
// CHECK:  encoding: [0x62,0xe1,0xcd,0x58,0x5e,0x92,0xf8,0xfb,0xff,0xff]
          vdivpd zmm18, zmm6, qword ptr [rdx - 1032]{1to8}

// CHECK: vdivps zmm23, zmm23, zmm28
// CHECK:  encoding: [0x62,0x81,0x44,0x40,0x5e,0xfc]
          vdivps zmm23, zmm23, zmm28

// CHECK: vdivps zmm23 {k2}, zmm23, zmm28
// CHECK:  encoding: [0x62,0x81,0x44,0x42,0x5e,0xfc]
          vdivps zmm23 {k2}, zmm23, zmm28

// CHECK: vdivps zmm23 {k2} {z}, zmm23, zmm28
// CHECK:  encoding: [0x62,0x81,0x44,0xc2,0x5e,0xfc]
          vdivps zmm23 {k2} {z}, zmm23, zmm28

// CHECK: vdivps zmm23, zmm23, zmm28, {rn-sae}
// CHECK:  encoding: [0x62,0x81,0x44,0x10,0x5e,0xfc]
          vdivps zmm23, zmm23, zmm28, {rn-sae}

// CHECK: vdivps zmm23, zmm23, zmm28, {ru-sae}
// CHECK:  encoding: [0x62,0x81,0x44,0x50,0x5e,0xfc]
          vdivps zmm23, zmm23, zmm28, {ru-sae}

// CHECK: vdivps zmm23, zmm23, zmm28, {rd-sae}
// CHECK:  encoding: [0x62,0x81,0x44,0x30,0x5e,0xfc]
          vdivps zmm23, zmm23, zmm28, {rd-sae}

// CHECK: vdivps zmm23, zmm23, zmm28, {rz-sae}
// CHECK:  encoding: [0x62,0x81,0x44,0x70,0x5e,0xfc]
          vdivps zmm23, zmm23, zmm28, {rz-sae}

// CHECK: vdivps zmm23, zmm23, zmmword ptr [rcx]
// CHECK:  encoding: [0x62,0xe1,0x44,0x40,0x5e,0x39]
          vdivps zmm23, zmm23, zmmword ptr [rcx]

// CHECK: vdivps zmm23, zmm23, zmmword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0xa1,0x44,0x40,0x5e,0xbc,0xf0,0x23,0x01,0x00,0x00]
          vdivps zmm23, zmm23, zmmword ptr [rax + 8*r14 + 291]

// CHECK: vdivps zmm23, zmm23, dword ptr [rcx]{1to16}
// CHECK:  encoding: [0x62,0xe1,0x44,0x50,0x5e,0x39]
          vdivps zmm23, zmm23, dword ptr [rcx]{1to16}

// CHECK: vdivps zmm23, zmm23, zmmword ptr [rdx + 8128]
// CHECK:  encoding: [0x62,0xe1,0x44,0x40,0x5e,0x7a,0x7f]
          vdivps zmm23, zmm23, zmmword ptr [rdx + 8128]

// CHECK: vdivps zmm23, zmm23, zmmword ptr [rdx + 8192]
// CHECK:  encoding: [0x62,0xe1,0x44,0x40,0x5e,0xba,0x00,0x20,0x00,0x00]
          vdivps zmm23, zmm23, zmmword ptr [rdx + 8192]

// CHECK: vdivps zmm23, zmm23, zmmword ptr [rdx - 8192]
// CHECK:  encoding: [0x62,0xe1,0x44,0x40,0x5e,0x7a,0x80]
          vdivps zmm23, zmm23, zmmword ptr [rdx - 8192]

// CHECK: vdivps zmm23, zmm23, zmmword ptr [rdx - 8256]
// CHECK:  encoding: [0x62,0xe1,0x44,0x40,0x5e,0xba,0xc0,0xdf,0xff,0xff]
          vdivps zmm23, zmm23, zmmword ptr [rdx - 8256]

// CHECK: vdivps zmm23, zmm23, dword ptr [rdx + 508]{1to16}
// CHECK:  encoding: [0x62,0xe1,0x44,0x50,0x5e,0x7a,0x7f]
          vdivps zmm23, zmm23, dword ptr [rdx + 508]{1to16}

// CHECK: vdivps zmm23, zmm23, dword ptr [rdx + 512]{1to16}
// CHECK:  encoding: [0x62,0xe1,0x44,0x50,0x5e,0xba,0x00,0x02,0x00,0x00]
          vdivps zmm23, zmm23, dword ptr [rdx + 512]{1to16}

// CHECK: vdivps zmm23, zmm23, dword ptr [rdx - 512]{1to16}
// CHECK:  encoding: [0x62,0xe1,0x44,0x50,0x5e,0x7a,0x80]
          vdivps zmm23, zmm23, dword ptr [rdx - 512]{1to16}

// CHECK: vdivps zmm23, zmm23, dword ptr [rdx - 516]{1to16}
// CHECK:  encoding: [0x62,0xe1,0x44,0x50,0x5e,0xba,0xfc,0xfd,0xff,0xff]
          vdivps zmm23, zmm23, dword ptr [rdx - 516]{1to16}

// CHECK: vdivsd xmm29, xmm13, xmm22
// CHECK:  encoding: [0x62,0x21,0x97,0x08,0x5e,0xee]
          vdivsd xmm29, xmm13, xmm22

// CHECK: vdivsd xmm29 {k3}, xmm13, xmm22
// CHECK:  encoding: [0x62,0x21,0x97,0x0b,0x5e,0xee]
          vdivsd xmm29 {k3}, xmm13, xmm22

// CHECK: vdivsd xmm29 {k3} {z}, xmm13, xmm22
// CHECK:  encoding: [0x62,0x21,0x97,0x8b,0x5e,0xee]
          vdivsd xmm29 {k3} {z}, xmm13, xmm22

// CHECK: vdivsd xmm29, xmm13, xmm22, {rn-sae}
// CHECK:  encoding: [0x62,0x21,0x97,0x18,0x5e,0xee]
          vdivsd xmm29, xmm13, xmm22, {rn-sae}

// CHECK: vdivsd xmm29, xmm13, xmm22, {ru-sae}
// CHECK:  encoding: [0x62,0x21,0x97,0x58,0x5e,0xee]
          vdivsd xmm29, xmm13, xmm22, {ru-sae}

// CHECK: vdivsd xmm29, xmm13, xmm22, {rd-sae}
// CHECK:  encoding: [0x62,0x21,0x97,0x38,0x5e,0xee]
          vdivsd xmm29, xmm13, xmm22, {rd-sae}

// CHECK: vdivsd xmm29, xmm13, xmm22, {rz-sae}
// CHECK:  encoding: [0x62,0x21,0x97,0x78,0x5e,0xee]
          vdivsd xmm29, xmm13, xmm22, {rz-sae}

// CHECK: vdivsd xmm29, xmm13, qword ptr [rcx]
// CHECK:  encoding: [0x62,0x61,0x97,0x08,0x5e,0x29]
          vdivsd xmm29, xmm13, qword ptr [rcx]

// CHECK: vdivsd xmm29, xmm13, qword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0x21,0x97,0x08,0x5e,0xac,0xf0,0x23,0x01,0x00,0x00]
          vdivsd xmm29, xmm13, qword ptr [rax + 8*r14 + 291]

// CHECK: vdivsd xmm29, xmm13, qword ptr [rdx + 1016]
// CHECK:  encoding: [0x62,0x61,0x97,0x08,0x5e,0x6a,0x7f]
          vdivsd xmm29, xmm13, qword ptr [rdx + 1016]

// CHECK: vdivsd xmm29, xmm13, qword ptr [rdx + 1024]
// CHECK:  encoding: [0x62,0x61,0x97,0x08,0x5e,0xaa,0x00,0x04,0x00,0x00]
          vdivsd xmm29, xmm13, qword ptr [rdx + 1024]

// CHECK: vdivsd xmm29, xmm13, qword ptr [rdx - 1024]
// CHECK:  encoding: [0x62,0x61,0x97,0x08,0x5e,0x6a,0x80]
          vdivsd xmm29, xmm13, qword ptr [rdx - 1024]

// CHECK: vdivsd xmm29, xmm13, qword ptr [rdx - 1032]
// CHECK:  encoding: [0x62,0x61,0x97,0x08,0x5e,0xaa,0xf8,0xfb,0xff,0xff]
          vdivsd xmm29, xmm13, qword ptr [rdx - 1032]

// CHECK: vdivss xmm21, xmm6, xmm17
// CHECK:  encoding: [0x62,0xa1,0x4e,0x08,0x5e,0xe9]
          vdivss xmm21, xmm6, xmm17

// CHECK: vdivss xmm21 {k5}, xmm6, xmm17
// CHECK:  encoding: [0x62,0xa1,0x4e,0x0d,0x5e,0xe9]
          vdivss xmm21 {k5}, xmm6, xmm17

// CHECK: vdivss xmm21 {k5} {z}, xmm6, xmm17
// CHECK:  encoding: [0x62,0xa1,0x4e,0x8d,0x5e,0xe9]
          vdivss xmm21 {k5} {z}, xmm6, xmm17

// CHECK: vdivss xmm21, xmm6, xmm17, {rn-sae}
// CHECK:  encoding: [0x62,0xa1,0x4e,0x18,0x5e,0xe9]
          vdivss xmm21, xmm6, xmm17, {rn-sae}

// CHECK: vdivss xmm21, xmm6, xmm17, {ru-sae}
// CHECK:  encoding: [0x62,0xa1,0x4e,0x58,0x5e,0xe9]
          vdivss xmm21, xmm6, xmm17, {ru-sae}

// CHECK: vdivss xmm21, xmm6, xmm17, {rd-sae}
// CHECK:  encoding: [0x62,0xa1,0x4e,0x38,0x5e,0xe9]
          vdivss xmm21, xmm6, xmm17, {rd-sae}

// CHECK: vdivss xmm21, xmm6, xmm17, {rz-sae}
// CHECK:  encoding: [0x62,0xa1,0x4e,0x78,0x5e,0xe9]
          vdivss xmm21, xmm6, xmm17, {rz-sae}

// CHECK: vdivss xmm21, xmm6, dword ptr [rcx]
// CHECK:  encoding: [0x62,0xe1,0x4e,0x08,0x5e,0x29]
          vdivss xmm21, xmm6, dword ptr [rcx]

// CHECK: vdivss xmm21, xmm6, dword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0xa1,0x4e,0x08,0x5e,0xac,0xf0,0x23,0x01,0x00,0x00]
          vdivss xmm21, xmm6, dword ptr [rax + 8*r14 + 291]

// CHECK: vdivss xmm21, xmm6, dword ptr [rdx + 508]
// CHECK:  encoding: [0x62,0xe1,0x4e,0x08,0x5e,0x6a,0x7f]
          vdivss xmm21, xmm6, dword ptr [rdx + 508]

// CHECK: vdivss xmm21, xmm6, dword ptr [rdx + 512]
// CHECK:  encoding: [0x62,0xe1,0x4e,0x08,0x5e,0xaa,0x00,0x02,0x00,0x00]
          vdivss xmm21, xmm6, dword ptr [rdx + 512]

// CHECK: vdivss xmm21, xmm6, dword ptr [rdx - 512]
// CHECK:  encoding: [0x62,0xe1,0x4e,0x08,0x5e,0x6a,0x80]
          vdivss xmm21, xmm6, dword ptr [rdx - 512]

// CHECK: vdivss xmm21, xmm6, dword ptr [rdx - 516]
// CHECK:  encoding: [0x62,0xe1,0x4e,0x08,0x5e,0xaa,0xfc,0xfd,0xff,0xff]
          vdivss xmm21, xmm6, dword ptr [rdx - 516]

// CHECK: vexpandpd zmm24, zmmword ptr [rcx]
// CHECK:  encoding: [0x62,0x62,0xfd,0x48,0x88,0x01]
          vexpandpd zmm24, zmmword ptr [rcx]

// CHECK: vexpandpd zmm24 {k4}, zmmword ptr [rcx]
// CHECK:  encoding: [0x62,0x62,0xfd,0x4c,0x88,0x01]
          vexpandpd zmm24 {k4}, zmmword ptr [rcx]

// CHECK: vexpandpd zmm24 {k4} {z}, zmmword ptr [rcx]
// CHECK:  encoding: [0x62,0x62,0xfd,0xcc,0x88,0x01]
          vexpandpd zmm24 {k4} {z}, zmmword ptr [rcx]

// CHECK: vexpandpd zmm24, zmmword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0x22,0xfd,0x48,0x88,0x84,0xf0,0x23,0x01,0x00,0x00]
          vexpandpd zmm24, zmmword ptr [rax + 8*r14 + 291]

// CHECK: vexpandpd zmm24, zmmword ptr [rdx + 1016]
// CHECK:  encoding: [0x62,0x62,0xfd,0x48,0x88,0x42,0x7f]
          vexpandpd zmm24, zmmword ptr [rdx + 1016]

// CHECK: vexpandpd zmm24, zmmword ptr [rdx + 1024]
// CHECK:  encoding: [0x62,0x62,0xfd,0x48,0x88,0x82,0x00,0x04,0x00,0x00]
          vexpandpd zmm24, zmmword ptr [rdx + 1024]

// CHECK: vexpandpd zmm24, zmmword ptr [rdx - 1024]
// CHECK:  encoding: [0x62,0x62,0xfd,0x48,0x88,0x42,0x80]
          vexpandpd zmm24, zmmword ptr [rdx - 1024]

// CHECK: vexpandpd zmm24, zmmword ptr [rdx - 1032]
// CHECK:  encoding: [0x62,0x62,0xfd,0x48,0x88,0x82,0xf8,0xfb,0xff,0xff]
          vexpandpd zmm24, zmmword ptr [rdx - 1032]

// CHECK: vexpandpd zmm23, zmm15
// CHECK:  encoding: [0x62,0xc2,0xfd,0x48,0x88,0xff]
          vexpandpd zmm23, zmm15

// CHECK: vexpandpd zmm23 {k5}, zmm15
// CHECK:  encoding: [0x62,0xc2,0xfd,0x4d,0x88,0xff]
          vexpandpd zmm23 {k5}, zmm15

// CHECK: vexpandpd zmm23 {k5} {z}, zmm15
// CHECK:  encoding: [0x62,0xc2,0xfd,0xcd,0x88,0xff]
          vexpandpd zmm23 {k5} {z}, zmm15

// CHECK: vexpandps zmm4, zmmword ptr [rcx]
// CHECK:  encoding: [0x62,0xf2,0x7d,0x48,0x88,0x21]
          vexpandps zmm4, zmmword ptr [rcx]

// CHECK: vexpandps zmm4 {k6}, zmmword ptr [rcx]
// CHECK:  encoding: [0x62,0xf2,0x7d,0x4e,0x88,0x21]
          vexpandps zmm4 {k6}, zmmword ptr [rcx]

// CHECK: vexpandps zmm4 {k6} {z}, zmmword ptr [rcx]
// CHECK:  encoding: [0x62,0xf2,0x7d,0xce,0x88,0x21]
          vexpandps zmm4 {k6} {z}, zmmword ptr [rcx]

// CHECK: vexpandps zmm4, zmmword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0xb2,0x7d,0x48,0x88,0xa4,0xf0,0x23,0x01,0x00,0x00]
          vexpandps zmm4, zmmword ptr [rax + 8*r14 + 291]

// CHECK: vexpandps zmm4, zmmword ptr [rdx + 508]
// CHECK:  encoding: [0x62,0xf2,0x7d,0x48,0x88,0x62,0x7f]
          vexpandps zmm4, zmmword ptr [rdx + 508]

// CHECK: vexpandps zmm4, zmmword ptr [rdx + 512]
// CHECK:  encoding: [0x62,0xf2,0x7d,0x48,0x88,0xa2,0x00,0x02,0x00,0x00]
          vexpandps zmm4, zmmword ptr [rdx + 512]

// CHECK: vexpandps zmm4, zmmword ptr [rdx - 512]
// CHECK:  encoding: [0x62,0xf2,0x7d,0x48,0x88,0x62,0x80]
          vexpandps zmm4, zmmword ptr [rdx - 512]

// CHECK: vexpandps zmm4, zmmword ptr [rdx - 516]
// CHECK:  encoding: [0x62,0xf2,0x7d,0x48,0x88,0xa2,0xfc,0xfd,0xff,0xff]
          vexpandps zmm4, zmmword ptr [rdx - 516]

// CHECK: vexpandps zmm14, zmm9
// CHECK:  encoding: [0x62,0x52,0x7d,0x48,0x88,0xf1]
          vexpandps zmm14, zmm9

// CHECK: vexpandps zmm14 {k2}, zmm9
// CHECK:  encoding: [0x62,0x52,0x7d,0x4a,0x88,0xf1]
          vexpandps zmm14 {k2}, zmm9

// CHECK: vexpandps zmm14 {k2} {z}, zmm9
// CHECK:  encoding: [0x62,0x52,0x7d,0xca,0x88,0xf1]
          vexpandps zmm14 {k2} {z}, zmm9

// CHECK: vextractf32x4 xmm15, zmm21, 171
// CHECK:  encoding: [0x62,0xc3,0x7d,0x48,0x19,0xef,0xab]
          vextractf32x4 xmm15, zmm21, 171

// CHECK: vextractf32x4 xmm15 {k1}, zmm21, 171
// CHECK:  encoding: [0x62,0xc3,0x7d,0x49,0x19,0xef,0xab]
          vextractf32x4 xmm15 {k1}, zmm21, 171

// CHECK: vextractf32x4 xmm15 {k1} {z}, zmm21, 171
// CHECK:  encoding: [0x62,0xc3,0x7d,0xc9,0x19,0xef,0xab]
          vextractf32x4 xmm15 {k1} {z}, zmm21, 171

// CHECK: vextractf32x4 xmm15, zmm21, 123
// CHECK:  encoding: [0x62,0xc3,0x7d,0x48,0x19,0xef,0x7b]
          vextractf32x4 xmm15, zmm21, 123

// CHECK: vextractf64x4 ymm11, zmm24, 171
// CHECK:  encoding: [0x62,0x43,0xfd,0x48,0x1b,0xc3,0xab]
          vextractf64x4 ymm11, zmm24, 171

// CHECK: vextractf64x4 ymm11 {k5}, zmm24, 171
// CHECK:  encoding: [0x62,0x43,0xfd,0x4d,0x1b,0xc3,0xab]
          vextractf64x4 ymm11 {k5}, zmm24, 171

// CHECK: vextractf64x4 ymm11 {k5} {z}, zmm24, 171
// CHECK:  encoding: [0x62,0x43,0xfd,0xcd,0x1b,0xc3,0xab]
          vextractf64x4 ymm11 {k5} {z}, zmm24, 171

// CHECK: vextractf64x4 ymm11, zmm24, 123
// CHECK:  encoding: [0x62,0x43,0xfd,0x48,0x1b,0xc3,0x7b]
          vextractf64x4 ymm11, zmm24, 123

// CHECK: vextracti32x4 xmm13, zmm16, 171
// CHECK:  encoding: [0x62,0xc3,0x7d,0x48,0x39,0xc5,0xab]
          vextracti32x4 xmm13, zmm16, 171

// CHECK: vextracti32x4 xmm13 {k5}, zmm16, 171
// CHECK:  encoding: [0x62,0xc3,0x7d,0x4d,0x39,0xc5,0xab]
          vextracti32x4 xmm13 {k5}, zmm16, 171

// CHECK: vextracti32x4 xmm13 {k5} {z}, zmm16, 171
// CHECK:  encoding: [0x62,0xc3,0x7d,0xcd,0x39,0xc5,0xab]
          vextracti32x4 xmm13 {k5} {z}, zmm16, 171

// CHECK: vextracti32x4 xmm13, zmm16, 123
// CHECK:  encoding: [0x62,0xc3,0x7d,0x48,0x39,0xc5,0x7b]
          vextracti32x4 xmm13, zmm16, 123

// CHECK: vextracti64x4 ymm13, zmm16, 171
// CHECK:  encoding: [0x62,0xc3,0xfd,0x48,0x3b,0xc5,0xab]
          vextracti64x4 ymm13, zmm16, 171

// CHECK: vextracti64x4 ymm13 {k3}, zmm16, 171
// CHECK:  encoding: [0x62,0xc3,0xfd,0x4b,0x3b,0xc5,0xab]
          vextracti64x4 ymm13 {k3}, zmm16, 171

// CHECK: vextracti64x4 ymm13 {k3} {z}, zmm16, 171
// CHECK:  encoding: [0x62,0xc3,0xfd,0xcb,0x3b,0xc5,0xab]
          vextracti64x4 ymm13 {k3} {z}, zmm16, 171

// CHECK: vextracti64x4 ymm13, zmm16, 123
// CHECK:  encoding: [0x62,0xc3,0xfd,0x48,0x3b,0xc5,0x7b]
          vextracti64x4 ymm13, zmm16, 123

// CHECK: vextractps	eax, xmm24, 171
// CHECK: encoding: [0x62,0x63,0x7d,0x08,0x17,0xc0,0xab]
          vextractps	eax, xmm24, 171

// CHECK: vextractps	eax, xmm24, 123
// CHECK: encoding: [0x62,0x63,0x7d,0x08,0x17,0xc0,0x7b]
          vextractps	eax, xmm24, 123

// CHECK: vextractps	r8d, xmm24, 123
// CHECK: encoding: [0x62,0x43,0x7d,0x08,0x17,0xc0,0x7b]
          vextractps	r8d, xmm24, 123

// CHECK: vextractps	dword ptr [rcx], xmm24, 123
// CHECK: encoding: [0x62,0x63,0x7d,0x08,0x17,0x01,0x7b]
          vextractps	dword ptr [rcx], xmm24, 123

// CHECK: vextractps	dword ptr [rax + 8*r14 + 291], xmm24, 123
// CHECK: encoding: [0x62,0x23,0x7d,0x08,0x17,0x84,0xf0,0x23,0x01,0x00,0x00,0x7b]
          vextractps	dword ptr [rax + 8*r14 + 291], xmm24, 123

// CHECK: vextractps	dword ptr [rdx + 508], xmm24, 123
// CHECK: encoding: [0x62,0x63,0x7d,0x08,0x17,0x42,0x7f,0x7b]
          vextractps	dword ptr [rdx + 508], xmm24, 123

// CHECK: vextractps	dword ptr [rdx + 512], xmm24, 123
// CHECK: encoding: [0x62,0x63,0x7d,0x08,0x17,0x82,0x00,0x02,0x00,0x00,0x7b]
          vextractps	dword ptr [rdx + 512], xmm24, 123

// CHECK: vextractps	dword ptr [rdx - 512], xmm24, 123
// CHECK: encoding: [0x62,0x63,0x7d,0x08,0x17,0x42,0x80,0x7b]
          vextractps	dword ptr [rdx - 512], xmm24, 123

// CHECK: vextractps	dword ptr [rdx - 516], xmm24, 123
// CHECK: encoding: [0x62,0x63,0x7d,0x08,0x17,0x82,0xfc,0xfd,0xff,0xff,0x7b]
          vextractps	dword ptr [rdx - 516], xmm24, 123

// CHECK: vfmadd132pd zmm26, zmm16, zmm21
// CHECK:  encoding: [0x62,0x22,0xfd,0x40,0x98,0xd5]
          vfmadd132pd zmm26, zmm16, zmm21

// CHECK: vfmadd132pd zmm26 {k5}, zmm16, zmm21
// CHECK:  encoding: [0x62,0x22,0xfd,0x45,0x98,0xd5]
          vfmadd132pd zmm26 {k5}, zmm16, zmm21

// CHECK: vfmadd132pd zmm26 {k5} {z}, zmm16, zmm21
// CHECK:  encoding: [0x62,0x22,0xfd,0xc5,0x98,0xd5]
          vfmadd132pd zmm26 {k5} {z}, zmm16, zmm21

// CHECK: vfmadd132pd zmm26, zmm16, zmm21, {rn-sae}
// CHECK:  encoding: [0x62,0x22,0xfd,0x10,0x98,0xd5]
          vfmadd132pd zmm26, zmm16, zmm21, {rn-sae}

// CHECK: vfmadd132pd zmm26, zmm16, zmm21, {ru-sae}
// CHECK:  encoding: [0x62,0x22,0xfd,0x50,0x98,0xd5]
          vfmadd132pd zmm26, zmm16, zmm21, {ru-sae}

// CHECK: vfmadd132pd zmm26, zmm16, zmm21, {rd-sae}
// CHECK:  encoding: [0x62,0x22,0xfd,0x30,0x98,0xd5]
          vfmadd132pd zmm26, zmm16, zmm21, {rd-sae}

// CHECK: vfmadd132pd zmm26, zmm16, zmm21, {rz-sae}
// CHECK:  encoding: [0x62,0x22,0xfd,0x70,0x98,0xd5]
          vfmadd132pd zmm26, zmm16, zmm21, {rz-sae}

// CHECK: vfmadd132pd zmm26, zmm16, zmmword ptr [rcx]
// CHECK:  encoding: [0x62,0x62,0xfd,0x40,0x98,0x11]
          vfmadd132pd zmm26, zmm16, zmmword ptr [rcx]

// CHECK: vfmadd132pd zmm26, zmm16, zmmword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0x22,0xfd,0x40,0x98,0x94,0xf0,0x23,0x01,0x00,0x00]
          vfmadd132pd zmm26, zmm16, zmmword ptr [rax + 8*r14 + 291]

// CHECK: vfmadd132pd zmm26, zmm16, qword ptr [rcx]{1to8}
// CHECK:  encoding: [0x62,0x62,0xfd,0x50,0x98,0x11]
          vfmadd132pd zmm26, zmm16, qword ptr [rcx]{1to8}

// CHECK: vfmadd132pd zmm26, zmm16, zmmword ptr [rdx + 8128]
// CHECK:  encoding: [0x62,0x62,0xfd,0x40,0x98,0x52,0x7f]
          vfmadd132pd zmm26, zmm16, zmmword ptr [rdx + 8128]

// CHECK: vfmadd132pd zmm26, zmm16, zmmword ptr [rdx + 8192]
// CHECK:  encoding: [0x62,0x62,0xfd,0x40,0x98,0x92,0x00,0x20,0x00,0x00]
          vfmadd132pd zmm26, zmm16, zmmword ptr [rdx + 8192]

// CHECK: vfmadd132pd zmm26, zmm16, zmmword ptr [rdx - 8192]
// CHECK:  encoding: [0x62,0x62,0xfd,0x40,0x98,0x52,0x80]
          vfmadd132pd zmm26, zmm16, zmmword ptr [rdx - 8192]

// CHECK: vfmadd132pd zmm26, zmm16, zmmword ptr [rdx - 8256]
// CHECK:  encoding: [0x62,0x62,0xfd,0x40,0x98,0x92,0xc0,0xdf,0xff,0xff]
          vfmadd132pd zmm26, zmm16, zmmword ptr [rdx - 8256]

// CHECK: vfmadd132pd zmm26, zmm16, qword ptr [rdx + 1016]{1to8}
// CHECK:  encoding: [0x62,0x62,0xfd,0x50,0x98,0x52,0x7f]
          vfmadd132pd zmm26, zmm16, qword ptr [rdx + 1016]{1to8}

// CHECK: vfmadd132pd zmm26, zmm16, qword ptr [rdx + 1024]{1to8}
// CHECK:  encoding: [0x62,0x62,0xfd,0x50,0x98,0x92,0x00,0x04,0x00,0x00]
          vfmadd132pd zmm26, zmm16, qword ptr [rdx + 1024]{1to8}

// CHECK: vfmadd132pd zmm26, zmm16, qword ptr [rdx - 1024]{1to8}
// CHECK:  encoding: [0x62,0x62,0xfd,0x50,0x98,0x52,0x80]
          vfmadd132pd zmm26, zmm16, qword ptr [rdx - 1024]{1to8}

// CHECK: vfmadd132pd zmm26, zmm16, qword ptr [rdx - 1032]{1to8}
// CHECK:  encoding: [0x62,0x62,0xfd,0x50,0x98,0x92,0xf8,0xfb,0xff,0xff]
          vfmadd132pd zmm26, zmm16, qword ptr [rdx - 1032]{1to8}

// CHECK: vfmadd132ps zmm1, zmm20, zmm25
// CHECK:  encoding: [0x62,0x92,0x5d,0x40,0x98,0xc9]
          vfmadd132ps zmm1, zmm20, zmm25

// CHECK: vfmadd132ps zmm1 {k1}, zmm20, zmm25
// CHECK:  encoding: [0x62,0x92,0x5d,0x41,0x98,0xc9]
          vfmadd132ps zmm1 {k1}, zmm20, zmm25

// CHECK: vfmadd132ps zmm1 {k1} {z}, zmm20, zmm25
// CHECK:  encoding: [0x62,0x92,0x5d,0xc1,0x98,0xc9]
          vfmadd132ps zmm1 {k1} {z}, zmm20, zmm25

// CHECK: vfmadd132ps zmm1, zmm20, zmm25, {rn-sae}
// CHECK:  encoding: [0x62,0x92,0x5d,0x10,0x98,0xc9]
          vfmadd132ps zmm1, zmm20, zmm25, {rn-sae}

// CHECK: vfmadd132ps zmm1, zmm20, zmm25, {ru-sae}
// CHECK:  encoding: [0x62,0x92,0x5d,0x50,0x98,0xc9]
          vfmadd132ps zmm1, zmm20, zmm25, {ru-sae}

// CHECK: vfmadd132ps zmm1, zmm20, zmm25, {rd-sae}
// CHECK:  encoding: [0x62,0x92,0x5d,0x30,0x98,0xc9]
          vfmadd132ps zmm1, zmm20, zmm25, {rd-sae}

// CHECK: vfmadd132ps zmm1, zmm20, zmm25, {rz-sae}
// CHECK:  encoding: [0x62,0x92,0x5d,0x70,0x98,0xc9]
          vfmadd132ps zmm1, zmm20, zmm25, {rz-sae}

// CHECK: vfmadd132ps zmm1, zmm20, zmmword ptr [rcx]
// CHECK:  encoding: [0x62,0xf2,0x5d,0x40,0x98,0x09]
          vfmadd132ps zmm1, zmm20, zmmword ptr [rcx]

// CHECK: vfmadd132ps zmm1, zmm20, zmmword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0xb2,0x5d,0x40,0x98,0x8c,0xf0,0x23,0x01,0x00,0x00]
          vfmadd132ps zmm1, zmm20, zmmword ptr [rax + 8*r14 + 291]

// CHECK: vfmadd132ps zmm1, zmm20, dword ptr [rcx]{1to16}
// CHECK:  encoding: [0x62,0xf2,0x5d,0x50,0x98,0x09]
          vfmadd132ps zmm1, zmm20, dword ptr [rcx]{1to16}

// CHECK: vfmadd132ps zmm1, zmm20, zmmword ptr [rdx + 8128]
// CHECK:  encoding: [0x62,0xf2,0x5d,0x40,0x98,0x4a,0x7f]
          vfmadd132ps zmm1, zmm20, zmmword ptr [rdx + 8128]

// CHECK: vfmadd132ps zmm1, zmm20, zmmword ptr [rdx + 8192]
// CHECK:  encoding: [0x62,0xf2,0x5d,0x40,0x98,0x8a,0x00,0x20,0x00,0x00]
          vfmadd132ps zmm1, zmm20, zmmword ptr [rdx + 8192]

// CHECK: vfmadd132ps zmm1, zmm20, zmmword ptr [rdx - 8192]
// CHECK:  encoding: [0x62,0xf2,0x5d,0x40,0x98,0x4a,0x80]
          vfmadd132ps zmm1, zmm20, zmmword ptr [rdx - 8192]

// CHECK: vfmadd132ps zmm1, zmm20, zmmword ptr [rdx - 8256]
// CHECK:  encoding: [0x62,0xf2,0x5d,0x40,0x98,0x8a,0xc0,0xdf,0xff,0xff]
          vfmadd132ps zmm1, zmm20, zmmword ptr [rdx - 8256]

// CHECK: vfmadd132ps zmm1, zmm20, dword ptr [rdx + 508]{1to16}
// CHECK:  encoding: [0x62,0xf2,0x5d,0x50,0x98,0x4a,0x7f]
          vfmadd132ps zmm1, zmm20, dword ptr [rdx + 508]{1to16}

// CHECK: vfmadd132ps zmm1, zmm20, dword ptr [rdx + 512]{1to16}
// CHECK:  encoding: [0x62,0xf2,0x5d,0x50,0x98,0x8a,0x00,0x02,0x00,0x00]
          vfmadd132ps zmm1, zmm20, dword ptr [rdx + 512]{1to16}

// CHECK: vfmadd132ps zmm1, zmm20, dword ptr [rdx - 512]{1to16}
// CHECK:  encoding: [0x62,0xf2,0x5d,0x50,0x98,0x4a,0x80]
          vfmadd132ps zmm1, zmm20, dword ptr [rdx - 512]{1to16}

// CHECK: vfmadd132ps zmm1, zmm20, dword ptr [rdx - 516]{1to16}
// CHECK:  encoding: [0x62,0xf2,0x5d,0x50,0x98,0x8a,0xfc,0xfd,0xff,0xff]
          vfmadd132ps zmm1, zmm20, dword ptr [rdx - 516]{1to16}

// CHECK: vfmadd132sd xmm28, xmm17, xmm3
// CHECK:  encoding: [0x62,0x62,0xf5,0x00,0x99,0xe3]
          vfmadd132sd xmm28, xmm17, xmm3

// CHECK: vfmadd132sd xmm28 {k2}, xmm17, xmm3
// CHECK:  encoding: [0x62,0x62,0xf5,0x02,0x99,0xe3]
          vfmadd132sd xmm28 {k2}, xmm17, xmm3

// CHECK: vfmadd132sd xmm28 {k2} {z}, xmm17, xmm3
// CHECK:  encoding: [0x62,0x62,0xf5,0x82,0x99,0xe3]
          vfmadd132sd xmm28 {k2} {z}, xmm17, xmm3

// CHECK: vfmadd132sd xmm28, xmm17, xmm3, {rn-sae}
// CHECK:  encoding: [0x62,0x62,0xf5,0x10,0x99,0xe3]
          vfmadd132sd xmm28, xmm17, xmm3, {rn-sae}

// CHECK: vfmadd132sd xmm28, xmm17, xmm3, {ru-sae}
// CHECK:  encoding: [0x62,0x62,0xf5,0x50,0x99,0xe3]
          vfmadd132sd xmm28, xmm17, xmm3, {ru-sae}

// CHECK: vfmadd132sd xmm28, xmm17, xmm3, {rd-sae}
// CHECK:  encoding: [0x62,0x62,0xf5,0x30,0x99,0xe3]
          vfmadd132sd xmm28, xmm17, xmm3, {rd-sae}

// CHECK: vfmadd132sd xmm28, xmm17, xmm3, {rz-sae}
// CHECK:  encoding: [0x62,0x62,0xf5,0x70,0x99,0xe3]
          vfmadd132sd xmm28, xmm17, xmm3, {rz-sae}

// CHECK: vfmadd132sd xmm28, xmm17, qword ptr [rcx]
// CHECK:  encoding: [0x62,0x62,0xf5,0x00,0x99,0x21]
          vfmadd132sd xmm28, xmm17, qword ptr [rcx]

// CHECK: vfmadd132sd xmm28, xmm17, qword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0x22,0xf5,0x00,0x99,0xa4,0xf0,0x23,0x01,0x00,0x00]
          vfmadd132sd xmm28, xmm17, qword ptr [rax + 8*r14 + 291]

// CHECK: vfmadd132sd xmm28, xmm17, qword ptr [rdx + 1016]
// CHECK:  encoding: [0x62,0x62,0xf5,0x00,0x99,0x62,0x7f]
          vfmadd132sd xmm28, xmm17, qword ptr [rdx + 1016]

// CHECK: vfmadd132sd xmm28, xmm17, qword ptr [rdx + 1024]
// CHECK:  encoding: [0x62,0x62,0xf5,0x00,0x99,0xa2,0x00,0x04,0x00,0x00]
          vfmadd132sd xmm28, xmm17, qword ptr [rdx + 1024]

// CHECK: vfmadd132sd xmm28, xmm17, qword ptr [rdx - 1024]
// CHECK:  encoding: [0x62,0x62,0xf5,0x00,0x99,0x62,0x80]
          vfmadd132sd xmm28, xmm17, qword ptr [rdx - 1024]

// CHECK: vfmadd132sd xmm28, xmm17, qword ptr [rdx - 1032]
// CHECK:  encoding: [0x62,0x62,0xf5,0x00,0x99,0xa2,0xf8,0xfb,0xff,0xff]
          vfmadd132sd xmm28, xmm17, qword ptr [rdx - 1032]

// CHECK: vfmadd132ss xmm30, xmm17, xmm22
// CHECK:  encoding: [0x62,0x22,0x75,0x00,0x99,0xf6]
          vfmadd132ss xmm30, xmm17, xmm22

// CHECK: vfmadd132ss xmm30 {k3}, xmm17, xmm22
// CHECK:  encoding: [0x62,0x22,0x75,0x03,0x99,0xf6]
          vfmadd132ss xmm30 {k3}, xmm17, xmm22

// CHECK: vfmadd132ss xmm30 {k3} {z}, xmm17, xmm22
// CHECK:  encoding: [0x62,0x22,0x75,0x83,0x99,0xf6]
          vfmadd132ss xmm30 {k3} {z}, xmm17, xmm22

// CHECK: vfmadd132ss xmm30, xmm17, xmm22, {rn-sae}
// CHECK:  encoding: [0x62,0x22,0x75,0x10,0x99,0xf6]
          vfmadd132ss xmm30, xmm17, xmm22, {rn-sae}

// CHECK: vfmadd132ss xmm30, xmm17, xmm22, {ru-sae}
// CHECK:  encoding: [0x62,0x22,0x75,0x50,0x99,0xf6]
          vfmadd132ss xmm30, xmm17, xmm22, {ru-sae}

// CHECK: vfmadd132ss xmm30, xmm17, xmm22, {rd-sae}
// CHECK:  encoding: [0x62,0x22,0x75,0x30,0x99,0xf6]
          vfmadd132ss xmm30, xmm17, xmm22, {rd-sae}

// CHECK: vfmadd132ss xmm30, xmm17, xmm22, {rz-sae}
// CHECK:  encoding: [0x62,0x22,0x75,0x70,0x99,0xf6]
          vfmadd132ss xmm30, xmm17, xmm22, {rz-sae}

// CHECK: vfmadd132ss xmm30, xmm17, dword ptr [rcx]
// CHECK:  encoding: [0x62,0x62,0x75,0x00,0x99,0x31]
          vfmadd132ss xmm30, xmm17, dword ptr [rcx]

// CHECK: vfmadd132ss xmm30, xmm17, dword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0x22,0x75,0x00,0x99,0xb4,0xf0,0x23,0x01,0x00,0x00]
          vfmadd132ss xmm30, xmm17, dword ptr [rax + 8*r14 + 291]

// CHECK: vfmadd132ss xmm30, xmm17, dword ptr [rdx + 508]
// CHECK:  encoding: [0x62,0x62,0x75,0x00,0x99,0x72,0x7f]
          vfmadd132ss xmm30, xmm17, dword ptr [rdx + 508]

// CHECK: vfmadd132ss xmm30, xmm17, dword ptr [rdx + 512]
// CHECK:  encoding: [0x62,0x62,0x75,0x00,0x99,0xb2,0x00,0x02,0x00,0x00]
          vfmadd132ss xmm30, xmm17, dword ptr [rdx + 512]

// CHECK: vfmadd132ss xmm30, xmm17, dword ptr [rdx - 512]
// CHECK:  encoding: [0x62,0x62,0x75,0x00,0x99,0x72,0x80]
          vfmadd132ss xmm30, xmm17, dword ptr [rdx - 512]

// CHECK: vfmadd132ss xmm30, xmm17, dword ptr [rdx - 516]
// CHECK:  encoding: [0x62,0x62,0x75,0x00,0x99,0xb2,0xfc,0xfd,0xff,0xff]
          vfmadd132ss xmm30, xmm17, dword ptr [rdx - 516]

// CHECK: vfmadd213pd zmm18, zmm16, zmm25
// CHECK:  encoding: [0x62,0x82,0xfd,0x40,0xa8,0xd1]
          vfmadd213pd zmm18, zmm16, zmm25

// CHECK: vfmadd213pd zmm18 {k3}, zmm16, zmm25
// CHECK:  encoding: [0x62,0x82,0xfd,0x43,0xa8,0xd1]
          vfmadd213pd zmm18 {k3}, zmm16, zmm25

// CHECK: vfmadd213pd zmm18 {k3} {z}, zmm16, zmm25
// CHECK:  encoding: [0x62,0x82,0xfd,0xc3,0xa8,0xd1]
          vfmadd213pd zmm18 {k3} {z}, zmm16, zmm25

// CHECK: vfmadd213pd zmm18, zmm16, zmm25, {rn-sae}
// CHECK:  encoding: [0x62,0x82,0xfd,0x10,0xa8,0xd1]
          vfmadd213pd zmm18, zmm16, zmm25, {rn-sae}

// CHECK: vfmadd213pd zmm18, zmm16, zmm25, {ru-sae}
// CHECK:  encoding: [0x62,0x82,0xfd,0x50,0xa8,0xd1]
          vfmadd213pd zmm18, zmm16, zmm25, {ru-sae}

// CHECK: vfmadd213pd zmm18, zmm16, zmm25, {rd-sae}
// CHECK:  encoding: [0x62,0x82,0xfd,0x30,0xa8,0xd1]
          vfmadd213pd zmm18, zmm16, zmm25, {rd-sae}

// CHECK: vfmadd213pd zmm18, zmm16, zmm25, {rz-sae}
// CHECK:  encoding: [0x62,0x82,0xfd,0x70,0xa8,0xd1]
          vfmadd213pd zmm18, zmm16, zmm25, {rz-sae}

// CHECK: vfmadd213pd zmm18, zmm16, zmmword ptr [rcx]
// CHECK:  encoding: [0x62,0xe2,0xfd,0x40,0xa8,0x11]
          vfmadd213pd zmm18, zmm16, zmmword ptr [rcx]

// CHECK: vfmadd213pd zmm18, zmm16, zmmword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0xa2,0xfd,0x40,0xa8,0x94,0xf0,0x23,0x01,0x00,0x00]
          vfmadd213pd zmm18, zmm16, zmmword ptr [rax + 8*r14 + 291]

// CHECK: vfmadd213pd zmm18, zmm16, qword ptr [rcx]{1to8}
// CHECK:  encoding: [0x62,0xe2,0xfd,0x50,0xa8,0x11]
          vfmadd213pd zmm18, zmm16, qword ptr [rcx]{1to8}

// CHECK: vfmadd213pd zmm18, zmm16, zmmword ptr [rdx + 8128]
// CHECK:  encoding: [0x62,0xe2,0xfd,0x40,0xa8,0x52,0x7f]
          vfmadd213pd zmm18, zmm16, zmmword ptr [rdx + 8128]

// CHECK: vfmadd213pd zmm18, zmm16, zmmword ptr [rdx + 8192]
// CHECK:  encoding: [0x62,0xe2,0xfd,0x40,0xa8,0x92,0x00,0x20,0x00,0x00]
          vfmadd213pd zmm18, zmm16, zmmword ptr [rdx + 8192]

// CHECK: vfmadd213pd zmm18, zmm16, zmmword ptr [rdx - 8192]
// CHECK:  encoding: [0x62,0xe2,0xfd,0x40,0xa8,0x52,0x80]
          vfmadd213pd zmm18, zmm16, zmmword ptr [rdx - 8192]

// CHECK: vfmadd213pd zmm18, zmm16, zmmword ptr [rdx - 8256]
// CHECK:  encoding: [0x62,0xe2,0xfd,0x40,0xa8,0x92,0xc0,0xdf,0xff,0xff]
          vfmadd213pd zmm18, zmm16, zmmword ptr [rdx - 8256]

// CHECK: vfmadd213pd zmm18, zmm16, qword ptr [rdx + 1016]{1to8}
// CHECK:  encoding: [0x62,0xe2,0xfd,0x50,0xa8,0x52,0x7f]
          vfmadd213pd zmm18, zmm16, qword ptr [rdx + 1016]{1to8}

// CHECK: vfmadd213pd zmm18, zmm16, qword ptr [rdx + 1024]{1to8}
// CHECK:  encoding: [0x62,0xe2,0xfd,0x50,0xa8,0x92,0x00,0x04,0x00,0x00]
          vfmadd213pd zmm18, zmm16, qword ptr [rdx + 1024]{1to8}

// CHECK: vfmadd213pd zmm18, zmm16, qword ptr [rdx - 1024]{1to8}
// CHECK:  encoding: [0x62,0xe2,0xfd,0x50,0xa8,0x52,0x80]
          vfmadd213pd zmm18, zmm16, qword ptr [rdx - 1024]{1to8}

// CHECK: vfmadd213pd zmm18, zmm16, qword ptr [rdx - 1032]{1to8}
// CHECK:  encoding: [0x62,0xe2,0xfd,0x50,0xa8,0x92,0xf8,0xfb,0xff,0xff]
          vfmadd213pd zmm18, zmm16, qword ptr [rdx - 1032]{1to8}

// CHECK: vfmadd213ps zmm20, zmm19, zmm14
// CHECK:  encoding: [0x62,0xc2,0x65,0x40,0xa8,0xe6]
          vfmadd213ps zmm20, zmm19, zmm14

// CHECK: vfmadd213ps zmm20 {k4}, zmm19, zmm14
// CHECK:  encoding: [0x62,0xc2,0x65,0x44,0xa8,0xe6]
          vfmadd213ps zmm20 {k4}, zmm19, zmm14

// CHECK: vfmadd213ps zmm20 {k4} {z}, zmm19, zmm14
// CHECK:  encoding: [0x62,0xc2,0x65,0xc4,0xa8,0xe6]
          vfmadd213ps zmm20 {k4} {z}, zmm19, zmm14

// CHECK: vfmadd213ps zmm20, zmm19, zmm14, {rn-sae}
// CHECK:  encoding: [0x62,0xc2,0x65,0x10,0xa8,0xe6]
          vfmadd213ps zmm20, zmm19, zmm14, {rn-sae}

// CHECK: vfmadd213ps zmm20, zmm19, zmm14, {ru-sae}
// CHECK:  encoding: [0x62,0xc2,0x65,0x50,0xa8,0xe6]
          vfmadd213ps zmm20, zmm19, zmm14, {ru-sae}

// CHECK: vfmadd213ps zmm20, zmm19, zmm14, {rd-sae}
// CHECK:  encoding: [0x62,0xc2,0x65,0x30,0xa8,0xe6]
          vfmadd213ps zmm20, zmm19, zmm14, {rd-sae}

// CHECK: vfmadd213ps zmm20, zmm19, zmm14, {rz-sae}
// CHECK:  encoding: [0x62,0xc2,0x65,0x70,0xa8,0xe6]
          vfmadd213ps zmm20, zmm19, zmm14, {rz-sae}

// CHECK: vfmadd213ps zmm20, zmm19, zmmword ptr [rcx]
// CHECK:  encoding: [0x62,0xe2,0x65,0x40,0xa8,0x21]
          vfmadd213ps zmm20, zmm19, zmmword ptr [rcx]

// CHECK: vfmadd213ps zmm20, zmm19, zmmword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0xa2,0x65,0x40,0xa8,0xa4,0xf0,0x23,0x01,0x00,0x00]
          vfmadd213ps zmm20, zmm19, zmmword ptr [rax + 8*r14 + 291]

// CHECK: vfmadd213ps zmm20, zmm19, dword ptr [rcx]{1to16}
// CHECK:  encoding: [0x62,0xe2,0x65,0x50,0xa8,0x21]
          vfmadd213ps zmm20, zmm19, dword ptr [rcx]{1to16}

// CHECK: vfmadd213ps zmm20, zmm19, zmmword ptr [rdx + 8128]
// CHECK:  encoding: [0x62,0xe2,0x65,0x40,0xa8,0x62,0x7f]
          vfmadd213ps zmm20, zmm19, zmmword ptr [rdx + 8128]

// CHECK: vfmadd213ps zmm20, zmm19, zmmword ptr [rdx + 8192]
// CHECK:  encoding: [0x62,0xe2,0x65,0x40,0xa8,0xa2,0x00,0x20,0x00,0x00]
          vfmadd213ps zmm20, zmm19, zmmword ptr [rdx + 8192]

// CHECK: vfmadd213ps zmm20, zmm19, zmmword ptr [rdx - 8192]
// CHECK:  encoding: [0x62,0xe2,0x65,0x40,0xa8,0x62,0x80]
          vfmadd213ps zmm20, zmm19, zmmword ptr [rdx - 8192]

// CHECK: vfmadd213ps zmm20, zmm19, zmmword ptr [rdx - 8256]
// CHECK:  encoding: [0x62,0xe2,0x65,0x40,0xa8,0xa2,0xc0,0xdf,0xff,0xff]
          vfmadd213ps zmm20, zmm19, zmmword ptr [rdx - 8256]

// CHECK: vfmadd213ps zmm20, zmm19, dword ptr [rdx + 508]{1to16}
// CHECK:  encoding: [0x62,0xe2,0x65,0x50,0xa8,0x62,0x7f]
          vfmadd213ps zmm20, zmm19, dword ptr [rdx + 508]{1to16}

// CHECK: vfmadd213ps zmm20, zmm19, dword ptr [rdx + 512]{1to16}
// CHECK:  encoding: [0x62,0xe2,0x65,0x50,0xa8,0xa2,0x00,0x02,0x00,0x00]
          vfmadd213ps zmm20, zmm19, dword ptr [rdx + 512]{1to16}

// CHECK: vfmadd213ps zmm20, zmm19, dword ptr [rdx - 512]{1to16}
// CHECK:  encoding: [0x62,0xe2,0x65,0x50,0xa8,0x62,0x80]
          vfmadd213ps zmm20, zmm19, dword ptr [rdx - 512]{1to16}

// CHECK: vfmadd213ps zmm20, zmm19, dword ptr [rdx - 516]{1to16}
// CHECK:  encoding: [0x62,0xe2,0x65,0x50,0xa8,0xa2,0xfc,0xfd,0xff,0xff]
          vfmadd213ps zmm20, zmm19, dword ptr [rdx - 516]{1to16}

// CHECK: vfmadd213sd xmm24, xmm26, xmm13
// CHECK:  encoding: [0x62,0x42,0xad,0x00,0xa9,0xc5]
          vfmadd213sd xmm24, xmm26, xmm13

// CHECK: vfmadd213sd xmm24 {k3}, xmm26, xmm13
// CHECK:  encoding: [0x62,0x42,0xad,0x03,0xa9,0xc5]
          vfmadd213sd xmm24 {k3}, xmm26, xmm13

// CHECK: vfmadd213sd xmm24 {k3} {z}, xmm26, xmm13
// CHECK:  encoding: [0x62,0x42,0xad,0x83,0xa9,0xc5]
          vfmadd213sd xmm24 {k3} {z}, xmm26, xmm13

// CHECK: vfmadd213sd xmm24, xmm26, xmm13, {rn-sae}
// CHECK:  encoding: [0x62,0x42,0xad,0x10,0xa9,0xc5]
          vfmadd213sd xmm24, xmm26, xmm13, {rn-sae}

// CHECK: vfmadd213sd xmm24, xmm26, xmm13, {ru-sae}
// CHECK:  encoding: [0x62,0x42,0xad,0x50,0xa9,0xc5]
          vfmadd213sd xmm24, xmm26, xmm13, {ru-sae}

// CHECK: vfmadd213sd xmm24, xmm26, xmm13, {rd-sae}
// CHECK:  encoding: [0x62,0x42,0xad,0x30,0xa9,0xc5]
          vfmadd213sd xmm24, xmm26, xmm13, {rd-sae}

// CHECK: vfmadd213sd xmm24, xmm26, xmm13, {rz-sae}
// CHECK:  encoding: [0x62,0x42,0xad,0x70,0xa9,0xc5]
          vfmadd213sd xmm24, xmm26, xmm13, {rz-sae}

// CHECK: vfmadd213sd xmm24, xmm26, qword ptr [rcx]
// CHECK:  encoding: [0x62,0x62,0xad,0x00,0xa9,0x01]
          vfmadd213sd xmm24, xmm26, qword ptr [rcx]

// CHECK: vfmadd213sd xmm24, xmm26, qword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0x22,0xad,0x00,0xa9,0x84,0xf0,0x23,0x01,0x00,0x00]
          vfmadd213sd xmm24, xmm26, qword ptr [rax + 8*r14 + 291]

// CHECK: vfmadd213sd xmm24, xmm26, qword ptr [rdx + 1016]
// CHECK:  encoding: [0x62,0x62,0xad,0x00,0xa9,0x42,0x7f]
          vfmadd213sd xmm24, xmm26, qword ptr [rdx + 1016]

// CHECK: vfmadd213sd xmm24, xmm26, qword ptr [rdx + 1024]
// CHECK:  encoding: [0x62,0x62,0xad,0x00,0xa9,0x82,0x00,0x04,0x00,0x00]
          vfmadd213sd xmm24, xmm26, qword ptr [rdx + 1024]

// CHECK: vfmadd213sd xmm24, xmm26, qword ptr [rdx - 1024]
// CHECK:  encoding: [0x62,0x62,0xad,0x00,0xa9,0x42,0x80]
          vfmadd213sd xmm24, xmm26, qword ptr [rdx - 1024]

// CHECK: vfmadd213sd xmm24, xmm26, qword ptr [rdx - 1032]
// CHECK:  encoding: [0x62,0x62,0xad,0x00,0xa9,0x82,0xf8,0xfb,0xff,0xff]
          vfmadd213sd xmm24, xmm26, qword ptr [rdx - 1032]

// CHECK: vfmadd213ss xmm30, xmm22, xmm16
// CHECK:  encoding: [0x62,0x22,0x4d,0x00,0xa9,0xf0]
          vfmadd213ss xmm30, xmm22, xmm16

// CHECK: vfmadd213ss xmm30 {k1}, xmm22, xmm16
// CHECK:  encoding: [0x62,0x22,0x4d,0x01,0xa9,0xf0]
          vfmadd213ss xmm30 {k1}, xmm22, xmm16

// CHECK: vfmadd213ss xmm30 {k1} {z}, xmm22, xmm16
// CHECK:  encoding: [0x62,0x22,0x4d,0x81,0xa9,0xf0]
          vfmadd213ss xmm30 {k1} {z}, xmm22, xmm16

// CHECK: vfmadd213ss xmm30, xmm22, xmm16, {rn-sae}
// CHECK:  encoding: [0x62,0x22,0x4d,0x10,0xa9,0xf0]
          vfmadd213ss xmm30, xmm22, xmm16, {rn-sae}

// CHECK: vfmadd213ss xmm30, xmm22, xmm16, {ru-sae}
// CHECK:  encoding: [0x62,0x22,0x4d,0x50,0xa9,0xf0]
          vfmadd213ss xmm30, xmm22, xmm16, {ru-sae}

// CHECK: vfmadd213ss xmm30, xmm22, xmm16, {rd-sae}
// CHECK:  encoding: [0x62,0x22,0x4d,0x30,0xa9,0xf0]
          vfmadd213ss xmm30, xmm22, xmm16, {rd-sae}

// CHECK: vfmadd213ss xmm30, xmm22, xmm16, {rz-sae}
// CHECK:  encoding: [0x62,0x22,0x4d,0x70,0xa9,0xf0]
          vfmadd213ss xmm30, xmm22, xmm16, {rz-sae}

// CHECK: vfmadd213ss xmm30, xmm22, dword ptr [rcx]
// CHECK:  encoding: [0x62,0x62,0x4d,0x00,0xa9,0x31]
          vfmadd213ss xmm30, xmm22, dword ptr [rcx]

// CHECK: vfmadd213ss xmm30, xmm22, dword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0x22,0x4d,0x00,0xa9,0xb4,0xf0,0x23,0x01,0x00,0x00]
          vfmadd213ss xmm30, xmm22, dword ptr [rax + 8*r14 + 291]

// CHECK: vfmadd213ss xmm30, xmm22, dword ptr [rdx + 508]
// CHECK:  encoding: [0x62,0x62,0x4d,0x00,0xa9,0x72,0x7f]
          vfmadd213ss xmm30, xmm22, dword ptr [rdx + 508]

// CHECK: vfmadd213ss xmm30, xmm22, dword ptr [rdx + 512]
// CHECK:  encoding: [0x62,0x62,0x4d,0x00,0xa9,0xb2,0x00,0x02,0x00,0x00]
          vfmadd213ss xmm30, xmm22, dword ptr [rdx + 512]

// CHECK: vfmadd213ss xmm30, xmm22, dword ptr [rdx - 512]
// CHECK:  encoding: [0x62,0x62,0x4d,0x00,0xa9,0x72,0x80]
          vfmadd213ss xmm30, xmm22, dword ptr [rdx - 512]

// CHECK: vfmadd213ss xmm30, xmm22, dword ptr [rdx - 516]
// CHECK:  encoding: [0x62,0x62,0x4d,0x00,0xa9,0xb2,0xfc,0xfd,0xff,0xff]
          vfmadd213ss xmm30, xmm22, dword ptr [rdx - 516]

// CHECK: vfmadd231pd zmm30, zmm6, zmm9
// CHECK:  encoding: [0x62,0x42,0xcd,0x48,0xb8,0xf1]
          vfmadd231pd zmm30, zmm6, zmm9

// CHECK: vfmadd231pd zmm30 {k4}, zmm6, zmm9
// CHECK:  encoding: [0x62,0x42,0xcd,0x4c,0xb8,0xf1]
          vfmadd231pd zmm30 {k4}, zmm6, zmm9

// CHECK: vfmadd231pd zmm30 {k4} {z}, zmm6, zmm9
// CHECK:  encoding: [0x62,0x42,0xcd,0xcc,0xb8,0xf1]
          vfmadd231pd zmm30 {k4} {z}, zmm6, zmm9

// CHECK: vfmadd231pd zmm30, zmm6, zmm9, {rn-sae}
// CHECK:  encoding: [0x62,0x42,0xcd,0x18,0xb8,0xf1]
          vfmadd231pd zmm30, zmm6, zmm9, {rn-sae}

// CHECK: vfmadd231pd zmm30, zmm6, zmm9, {ru-sae}
// CHECK:  encoding: [0x62,0x42,0xcd,0x58,0xb8,0xf1]
          vfmadd231pd zmm30, zmm6, zmm9, {ru-sae}

// CHECK: vfmadd231pd zmm30, zmm6, zmm9, {rd-sae}
// CHECK:  encoding: [0x62,0x42,0xcd,0x38,0xb8,0xf1]
          vfmadd231pd zmm30, zmm6, zmm9, {rd-sae}

// CHECK: vfmadd231pd zmm30, zmm6, zmm9, {rz-sae}
// CHECK:  encoding: [0x62,0x42,0xcd,0x78,0xb8,0xf1]
          vfmadd231pd zmm30, zmm6, zmm9, {rz-sae}

// CHECK: vfmadd231pd zmm30, zmm6, zmmword ptr [rcx]
// CHECK:  encoding: [0x62,0x62,0xcd,0x48,0xb8,0x31]
          vfmadd231pd zmm30, zmm6, zmmword ptr [rcx]

// CHECK: vfmadd231pd zmm30, zmm6, zmmword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0x22,0xcd,0x48,0xb8,0xb4,0xf0,0x23,0x01,0x00,0x00]
          vfmadd231pd zmm30, zmm6, zmmword ptr [rax + 8*r14 + 291]

// CHECK: vfmadd231pd zmm30, zmm6, qword ptr [rcx]{1to8}
// CHECK:  encoding: [0x62,0x62,0xcd,0x58,0xb8,0x31]
          vfmadd231pd zmm30, zmm6, qword ptr [rcx]{1to8}

// CHECK: vfmadd231pd zmm30, zmm6, zmmword ptr [rdx + 8128]
// CHECK:  encoding: [0x62,0x62,0xcd,0x48,0xb8,0x72,0x7f]
          vfmadd231pd zmm30, zmm6, zmmword ptr [rdx + 8128]

// CHECK: vfmadd231pd zmm30, zmm6, zmmword ptr [rdx + 8192]
// CHECK:  encoding: [0x62,0x62,0xcd,0x48,0xb8,0xb2,0x00,0x20,0x00,0x00]
          vfmadd231pd zmm30, zmm6, zmmword ptr [rdx + 8192]

// CHECK: vfmadd231pd zmm30, zmm6, zmmword ptr [rdx - 8192]
// CHECK:  encoding: [0x62,0x62,0xcd,0x48,0xb8,0x72,0x80]
          vfmadd231pd zmm30, zmm6, zmmword ptr [rdx - 8192]

// CHECK: vfmadd231pd zmm30, zmm6, zmmword ptr [rdx - 8256]
// CHECK:  encoding: [0x62,0x62,0xcd,0x48,0xb8,0xb2,0xc0,0xdf,0xff,0xff]
          vfmadd231pd zmm30, zmm6, zmmword ptr [rdx - 8256]

// CHECK: vfmadd231pd zmm30, zmm6, qword ptr [rdx + 1016]{1to8}
// CHECK:  encoding: [0x62,0x62,0xcd,0x58,0xb8,0x72,0x7f]
          vfmadd231pd zmm30, zmm6, qword ptr [rdx + 1016]{1to8}

// CHECK: vfmadd231pd zmm30, zmm6, qword ptr [rdx + 1024]{1to8}
// CHECK:  encoding: [0x62,0x62,0xcd,0x58,0xb8,0xb2,0x00,0x04,0x00,0x00]
          vfmadd231pd zmm30, zmm6, qword ptr [rdx + 1024]{1to8}

// CHECK: vfmadd231pd zmm30, zmm6, qword ptr [rdx - 1024]{1to8}
// CHECK:  encoding: [0x62,0x62,0xcd,0x58,0xb8,0x72,0x80]
          vfmadd231pd zmm30, zmm6, qword ptr [rdx - 1024]{1to8}

// CHECK: vfmadd231pd zmm30, zmm6, qword ptr [rdx - 1032]{1to8}
// CHECK:  encoding: [0x62,0x62,0xcd,0x58,0xb8,0xb2,0xf8,0xfb,0xff,0xff]
          vfmadd231pd zmm30, zmm6, qword ptr [rdx - 1032]{1to8}

// CHECK: vfmadd231ps zmm27, zmm28, zmm25
// CHECK:  encoding: [0x62,0x02,0x1d,0x40,0xb8,0xd9]
          vfmadd231ps zmm27, zmm28, zmm25

// CHECK: vfmadd231ps zmm27 {k3}, zmm28, zmm25
// CHECK:  encoding: [0x62,0x02,0x1d,0x43,0xb8,0xd9]
          vfmadd231ps zmm27 {k3}, zmm28, zmm25

// CHECK: vfmadd231ps zmm27 {k3} {z}, zmm28, zmm25
// CHECK:  encoding: [0x62,0x02,0x1d,0xc3,0xb8,0xd9]
          vfmadd231ps zmm27 {k3} {z}, zmm28, zmm25

// CHECK: vfmadd231ps zmm27, zmm28, zmm25, {rn-sae}
// CHECK:  encoding: [0x62,0x02,0x1d,0x10,0xb8,0xd9]
          vfmadd231ps zmm27, zmm28, zmm25, {rn-sae}

// CHECK: vfmadd231ps zmm27, zmm28, zmm25, {ru-sae}
// CHECK:  encoding: [0x62,0x02,0x1d,0x50,0xb8,0xd9]
          vfmadd231ps zmm27, zmm28, zmm25, {ru-sae}

// CHECK: vfmadd231ps zmm27, zmm28, zmm25, {rd-sae}
// CHECK:  encoding: [0x62,0x02,0x1d,0x30,0xb8,0xd9]
          vfmadd231ps zmm27, zmm28, zmm25, {rd-sae}

// CHECK: vfmadd231ps zmm27, zmm28, zmm25, {rz-sae}
// CHECK:  encoding: [0x62,0x02,0x1d,0x70,0xb8,0xd9]
          vfmadd231ps zmm27, zmm28, zmm25, {rz-sae}

// CHECK: vfmadd231ps zmm27, zmm28, zmmword ptr [rcx]
// CHECK:  encoding: [0x62,0x62,0x1d,0x40,0xb8,0x19]
          vfmadd231ps zmm27, zmm28, zmmword ptr [rcx]

// CHECK: vfmadd231ps zmm27, zmm28, zmmword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0x22,0x1d,0x40,0xb8,0x9c,0xf0,0x23,0x01,0x00,0x00]
          vfmadd231ps zmm27, zmm28, zmmword ptr [rax + 8*r14 + 291]

// CHECK: vfmadd231ps zmm27, zmm28, dword ptr [rcx]{1to16}
// CHECK:  encoding: [0x62,0x62,0x1d,0x50,0xb8,0x19]
          vfmadd231ps zmm27, zmm28, dword ptr [rcx]{1to16}

// CHECK: vfmadd231ps zmm27, zmm28, zmmword ptr [rdx + 8128]
// CHECK:  encoding: [0x62,0x62,0x1d,0x40,0xb8,0x5a,0x7f]
          vfmadd231ps zmm27, zmm28, zmmword ptr [rdx + 8128]

// CHECK: vfmadd231ps zmm27, zmm28, zmmword ptr [rdx + 8192]
// CHECK:  encoding: [0x62,0x62,0x1d,0x40,0xb8,0x9a,0x00,0x20,0x00,0x00]
          vfmadd231ps zmm27, zmm28, zmmword ptr [rdx + 8192]

// CHECK: vfmadd231ps zmm27, zmm28, zmmword ptr [rdx - 8192]
// CHECK:  encoding: [0x62,0x62,0x1d,0x40,0xb8,0x5a,0x80]
          vfmadd231ps zmm27, zmm28, zmmword ptr [rdx - 8192]

// CHECK: vfmadd231ps zmm27, zmm28, zmmword ptr [rdx - 8256]
// CHECK:  encoding: [0x62,0x62,0x1d,0x40,0xb8,0x9a,0xc0,0xdf,0xff,0xff]
          vfmadd231ps zmm27, zmm28, zmmword ptr [rdx - 8256]

// CHECK: vfmadd231ps zmm27, zmm28, dword ptr [rdx + 508]{1to16}
// CHECK:  encoding: [0x62,0x62,0x1d,0x50,0xb8,0x5a,0x7f]
          vfmadd231ps zmm27, zmm28, dword ptr [rdx + 508]{1to16}

// CHECK: vfmadd231ps zmm27, zmm28, dword ptr [rdx + 512]{1to16}
// CHECK:  encoding: [0x62,0x62,0x1d,0x50,0xb8,0x9a,0x00,0x02,0x00,0x00]
          vfmadd231ps zmm27, zmm28, dword ptr [rdx + 512]{1to16}

// CHECK: vfmadd231ps zmm27, zmm28, dword ptr [rdx - 512]{1to16}
// CHECK:  encoding: [0x62,0x62,0x1d,0x50,0xb8,0x5a,0x80]
          vfmadd231ps zmm27, zmm28, dword ptr [rdx - 512]{1to16}

// CHECK: vfmadd231ps zmm27, zmm28, dword ptr [rdx - 516]{1to16}
// CHECK:  encoding: [0x62,0x62,0x1d,0x50,0xb8,0x9a,0xfc,0xfd,0xff,0xff]
          vfmadd231ps zmm27, zmm28, dword ptr [rdx - 516]{1to16}

// CHECK: vfmadd231sd xmm4, xmm1, xmm14
// CHECK:  encoding: [0xc4,0xc2,0xf1,0xb9,0xe6]
          vfmadd231sd xmm4, xmm1, xmm14

// CHECK: vfmadd231sd xmm4 {k1}, xmm1, xmm14
// CHECK:  encoding: [0x62,0xd2,0xf5,0x09,0xb9,0xe6]
          vfmadd231sd xmm4 {k1}, xmm1, xmm14

// CHECK: vfmadd231sd xmm4 {k1} {z}, xmm1, xmm14
// CHECK:  encoding: [0x62,0xd2,0xf5,0x89,0xb9,0xe6]
          vfmadd231sd xmm4 {k1} {z}, xmm1, xmm14

// CHECK: vfmadd231sd xmm4, xmm1, xmm14, {rn-sae}
// CHECK:  encoding: [0x62,0xd2,0xf5,0x18,0xb9,0xe6]
          vfmadd231sd xmm4, xmm1, xmm14, {rn-sae}

// CHECK: vfmadd231sd xmm4, xmm1, xmm14, {ru-sae}
// CHECK:  encoding: [0x62,0xd2,0xf5,0x58,0xb9,0xe6]
          vfmadd231sd xmm4, xmm1, xmm14, {ru-sae}

// CHECK: vfmadd231sd xmm4, xmm1, xmm14, {rd-sae}
// CHECK:  encoding: [0x62,0xd2,0xf5,0x38,0xb9,0xe6]
          vfmadd231sd xmm4, xmm1, xmm14, {rd-sae}

// CHECK: vfmadd231sd xmm4, xmm1, xmm14, {rz-sae}
// CHECK:  encoding: [0x62,0xd2,0xf5,0x78,0xb9,0xe6]
          vfmadd231sd xmm4, xmm1, xmm14, {rz-sae}

// CHECK: vfmadd231sd xmm4, xmm1, qword ptr [rcx]
// CHECK:  encoding: [0xc4,0xe2,0xf1,0xb9,0x21]
          vfmadd231sd xmm4, xmm1, qword ptr [rcx]

// CHECK: vfmadd231sd xmm4, xmm1, qword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0xc4,0xa2,0xf1,0xb9,0xa4,0xf0,0x23,0x01,0x00,0x00]
          vfmadd231sd xmm4, xmm1, qword ptr [rax + 8*r14 + 291]

// CHECK: vfmadd231sd xmm4, xmm1, qword ptr [rdx + 1016]
// CHECK:  encoding: [0xc4,0xe2,0xf1,0xb9,0xa2,0xf8,0x03,0x00,0x00]
          vfmadd231sd xmm4, xmm1, qword ptr [rdx + 1016]

// CHECK: vfmadd231sd xmm4, xmm1, qword ptr [rdx + 1024]
// CHECK:  encoding: [0xc4,0xe2,0xf1,0xb9,0xa2,0x00,0x04,0x00,0x00]
          vfmadd231sd xmm4, xmm1, qword ptr [rdx + 1024]

// CHECK: vfmadd231sd xmm4, xmm1, qword ptr [rdx - 1024]
// CHECK:  encoding: [0xc4,0xe2,0xf1,0xb9,0xa2,0x00,0xfc,0xff,0xff]
          vfmadd231sd xmm4, xmm1, qword ptr [rdx - 1024]

// CHECK: vfmadd231sd xmm4, xmm1, qword ptr [rdx - 1032]
// CHECK:  encoding: [0xc4,0xe2,0xf1,0xb9,0xa2,0xf8,0xfb,0xff,0xff]
          vfmadd231sd xmm4, xmm1, qword ptr [rdx - 1032]

// CHECK: vfmadd231ss xmm29, xmm15, xmm10
// CHECK:  encoding: [0x62,0x42,0x05,0x08,0xb9,0xea]
          vfmadd231ss xmm29, xmm15, xmm10

// CHECK: vfmadd231ss xmm29 {k4}, xmm15, xmm10
// CHECK:  encoding: [0x62,0x42,0x05,0x0c,0xb9,0xea]
          vfmadd231ss xmm29 {k4}, xmm15, xmm10

// CHECK: vfmadd231ss xmm29 {k4} {z}, xmm15, xmm10
// CHECK:  encoding: [0x62,0x42,0x05,0x8c,0xb9,0xea]
          vfmadd231ss xmm29 {k4} {z}, xmm15, xmm10

// CHECK: vfmadd231ss xmm29, xmm15, xmm10, {rn-sae}
// CHECK:  encoding: [0x62,0x42,0x05,0x18,0xb9,0xea]
          vfmadd231ss xmm29, xmm15, xmm10, {rn-sae}

// CHECK: vfmadd231ss xmm29, xmm15, xmm10, {ru-sae}
// CHECK:  encoding: [0x62,0x42,0x05,0x58,0xb9,0xea]
          vfmadd231ss xmm29, xmm15, xmm10, {ru-sae}

// CHECK: vfmadd231ss xmm29, xmm15, xmm10, {rd-sae}
// CHECK:  encoding: [0x62,0x42,0x05,0x38,0xb9,0xea]
          vfmadd231ss xmm29, xmm15, xmm10, {rd-sae}

// CHECK: vfmadd231ss xmm29, xmm15, xmm10, {rz-sae}
// CHECK:  encoding: [0x62,0x42,0x05,0x78,0xb9,0xea]
          vfmadd231ss xmm29, xmm15, xmm10, {rz-sae}

// CHECK: vfmadd231ss xmm29, xmm15, dword ptr [rcx]
// CHECK:  encoding: [0x62,0x62,0x05,0x08,0xb9,0x29]
          vfmadd231ss xmm29, xmm15, dword ptr [rcx]

// CHECK: vfmadd231ss xmm29, xmm15, dword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0x22,0x05,0x08,0xb9,0xac,0xf0,0x23,0x01,0x00,0x00]
          vfmadd231ss xmm29, xmm15, dword ptr [rax + 8*r14 + 291]

// CHECK: vfmadd231ss xmm29, xmm15, dword ptr [rdx + 508]
// CHECK:  encoding: [0x62,0x62,0x05,0x08,0xb9,0x6a,0x7f]
          vfmadd231ss xmm29, xmm15, dword ptr [rdx + 508]

// CHECK: vfmadd231ss xmm29, xmm15, dword ptr [rdx + 512]
// CHECK:  encoding: [0x62,0x62,0x05,0x08,0xb9,0xaa,0x00,0x02,0x00,0x00]
          vfmadd231ss xmm29, xmm15, dword ptr [rdx + 512]

// CHECK: vfmadd231ss xmm29, xmm15, dword ptr [rdx - 512]
// CHECK:  encoding: [0x62,0x62,0x05,0x08,0xb9,0x6a,0x80]
          vfmadd231ss xmm29, xmm15, dword ptr [rdx - 512]

// CHECK: vfmadd231ss xmm29, xmm15, dword ptr [rdx - 516]
// CHECK:  encoding: [0x62,0x62,0x05,0x08,0xb9,0xaa,0xfc,0xfd,0xff,0xff]
          vfmadd231ss xmm29, xmm15, dword ptr [rdx - 516]

// CHECK: vfmaddsub132pd zmm20, zmm25, zmm21
// CHECK:  encoding: [0x62,0xa2,0xb5,0x40,0x96,0xe5]
          vfmaddsub132pd zmm20, zmm25, zmm21

// CHECK: vfmaddsub132pd zmm20 {k2}, zmm25, zmm21
// CHECK:  encoding: [0x62,0xa2,0xb5,0x42,0x96,0xe5]
          vfmaddsub132pd zmm20 {k2}, zmm25, zmm21

// CHECK: vfmaddsub132pd zmm20 {k2} {z}, zmm25, zmm21
// CHECK:  encoding: [0x62,0xa2,0xb5,0xc2,0x96,0xe5]
          vfmaddsub132pd zmm20 {k2} {z}, zmm25, zmm21

// CHECK: vfmaddsub132pd zmm20, zmm25, zmm21, {rn-sae}
// CHECK:  encoding: [0x62,0xa2,0xb5,0x10,0x96,0xe5]
          vfmaddsub132pd zmm20, zmm25, zmm21, {rn-sae}

// CHECK: vfmaddsub132pd zmm20, zmm25, zmm21, {ru-sae}
// CHECK:  encoding: [0x62,0xa2,0xb5,0x50,0x96,0xe5]
          vfmaddsub132pd zmm20, zmm25, zmm21, {ru-sae}

// CHECK: vfmaddsub132pd zmm20, zmm25, zmm21, {rd-sae}
// CHECK:  encoding: [0x62,0xa2,0xb5,0x30,0x96,0xe5]
          vfmaddsub132pd zmm20, zmm25, zmm21, {rd-sae}

// CHECK: vfmaddsub132pd zmm20, zmm25, zmm21, {rz-sae}
// CHECK:  encoding: [0x62,0xa2,0xb5,0x70,0x96,0xe5]
          vfmaddsub132pd zmm20, zmm25, zmm21, {rz-sae}

// CHECK: vfmaddsub132pd zmm20, zmm25, zmmword ptr [rcx]
// CHECK:  encoding: [0x62,0xe2,0xb5,0x40,0x96,0x21]
          vfmaddsub132pd zmm20, zmm25, zmmword ptr [rcx]

// CHECK: vfmaddsub132pd zmm20, zmm25, zmmword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0xa2,0xb5,0x40,0x96,0xa4,0xf0,0x23,0x01,0x00,0x00]
          vfmaddsub132pd zmm20, zmm25, zmmword ptr [rax + 8*r14 + 291]

// CHECK: vfmaddsub132pd zmm20, zmm25, qword ptr [rcx]{1to8}
// CHECK:  encoding: [0x62,0xe2,0xb5,0x50,0x96,0x21]
          vfmaddsub132pd zmm20, zmm25, qword ptr [rcx]{1to8}

// CHECK: vfmaddsub132pd zmm20, zmm25, zmmword ptr [rdx + 8128]
// CHECK:  encoding: [0x62,0xe2,0xb5,0x40,0x96,0x62,0x7f]
          vfmaddsub132pd zmm20, zmm25, zmmword ptr [rdx + 8128]

// CHECK: vfmaddsub132pd zmm20, zmm25, zmmword ptr [rdx + 8192]
// CHECK:  encoding: [0x62,0xe2,0xb5,0x40,0x96,0xa2,0x00,0x20,0x00,0x00]
          vfmaddsub132pd zmm20, zmm25, zmmword ptr [rdx + 8192]

// CHECK: vfmaddsub132pd zmm20, zmm25, zmmword ptr [rdx - 8192]
// CHECK:  encoding: [0x62,0xe2,0xb5,0x40,0x96,0x62,0x80]
          vfmaddsub132pd zmm20, zmm25, zmmword ptr [rdx - 8192]

// CHECK: vfmaddsub132pd zmm20, zmm25, zmmword ptr [rdx - 8256]
// CHECK:  encoding: [0x62,0xe2,0xb5,0x40,0x96,0xa2,0xc0,0xdf,0xff,0xff]
          vfmaddsub132pd zmm20, zmm25, zmmword ptr [rdx - 8256]

// CHECK: vfmaddsub132pd zmm20, zmm25, qword ptr [rdx + 1016]{1to8}
// CHECK:  encoding: [0x62,0xe2,0xb5,0x50,0x96,0x62,0x7f]
          vfmaddsub132pd zmm20, zmm25, qword ptr [rdx + 1016]{1to8}

// CHECK: vfmaddsub132pd zmm20, zmm25, qword ptr [rdx + 1024]{1to8}
// CHECK:  encoding: [0x62,0xe2,0xb5,0x50,0x96,0xa2,0x00,0x04,0x00,0x00]
          vfmaddsub132pd zmm20, zmm25, qword ptr [rdx + 1024]{1to8}

// CHECK: vfmaddsub132pd zmm20, zmm25, qword ptr [rdx - 1024]{1to8}
// CHECK:  encoding: [0x62,0xe2,0xb5,0x50,0x96,0x62,0x80]
          vfmaddsub132pd zmm20, zmm25, qword ptr [rdx - 1024]{1to8}

// CHECK: vfmaddsub132pd zmm20, zmm25, qword ptr [rdx - 1032]{1to8}
// CHECK:  encoding: [0x62,0xe2,0xb5,0x50,0x96,0xa2,0xf8,0xfb,0xff,0xff]
          vfmaddsub132pd zmm20, zmm25, qword ptr [rdx - 1032]{1to8}

// CHECK: vfmaddsub132ps zmm10, zmm9, zmm20
// CHECK:  encoding: [0x62,0x32,0x35,0x48,0x96,0xd4]
          vfmaddsub132ps zmm10, zmm9, zmm20

// CHECK: vfmaddsub132ps zmm10 {k3}, zmm9, zmm20
// CHECK:  encoding: [0x62,0x32,0x35,0x4b,0x96,0xd4]
          vfmaddsub132ps zmm10 {k3}, zmm9, zmm20

// CHECK: vfmaddsub132ps zmm10 {k3} {z}, zmm9, zmm20
// CHECK:  encoding: [0x62,0x32,0x35,0xcb,0x96,0xd4]
          vfmaddsub132ps zmm10 {k3} {z}, zmm9, zmm20

// CHECK: vfmaddsub132ps zmm10, zmm9, zmm20, {rn-sae}
// CHECK:  encoding: [0x62,0x32,0x35,0x18,0x96,0xd4]
          vfmaddsub132ps zmm10, zmm9, zmm20, {rn-sae}

// CHECK: vfmaddsub132ps zmm10, zmm9, zmm20, {ru-sae}
// CHECK:  encoding: [0x62,0x32,0x35,0x58,0x96,0xd4]
          vfmaddsub132ps zmm10, zmm9, zmm20, {ru-sae}

// CHECK: vfmaddsub132ps zmm10, zmm9, zmm20, {rd-sae}
// CHECK:  encoding: [0x62,0x32,0x35,0x38,0x96,0xd4]
          vfmaddsub132ps zmm10, zmm9, zmm20, {rd-sae}

// CHECK: vfmaddsub132ps zmm10, zmm9, zmm20, {rz-sae}
// CHECK:  encoding: [0x62,0x32,0x35,0x78,0x96,0xd4]
          vfmaddsub132ps zmm10, zmm9, zmm20, {rz-sae}

// CHECK: vfmaddsub132ps zmm10, zmm9, zmmword ptr [rcx]
// CHECK:  encoding: [0x62,0x72,0x35,0x48,0x96,0x11]
          vfmaddsub132ps zmm10, zmm9, zmmword ptr [rcx]

// CHECK: vfmaddsub132ps zmm10, zmm9, zmmword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0x32,0x35,0x48,0x96,0x94,0xf0,0x23,0x01,0x00,0x00]
          vfmaddsub132ps zmm10, zmm9, zmmword ptr [rax + 8*r14 + 291]

// CHECK: vfmaddsub132ps zmm10, zmm9, dword ptr [rcx]{1to16}
// CHECK:  encoding: [0x62,0x72,0x35,0x58,0x96,0x11]
          vfmaddsub132ps zmm10, zmm9, dword ptr [rcx]{1to16}

// CHECK: vfmaddsub132ps zmm10, zmm9, zmmword ptr [rdx + 8128]
// CHECK:  encoding: [0x62,0x72,0x35,0x48,0x96,0x52,0x7f]
          vfmaddsub132ps zmm10, zmm9, zmmword ptr [rdx + 8128]

// CHECK: vfmaddsub132ps zmm10, zmm9, zmmword ptr [rdx + 8192]
// CHECK:  encoding: [0x62,0x72,0x35,0x48,0x96,0x92,0x00,0x20,0x00,0x00]
          vfmaddsub132ps zmm10, zmm9, zmmword ptr [rdx + 8192]

// CHECK: vfmaddsub132ps zmm10, zmm9, zmmword ptr [rdx - 8192]
// CHECK:  encoding: [0x62,0x72,0x35,0x48,0x96,0x52,0x80]
          vfmaddsub132ps zmm10, zmm9, zmmword ptr [rdx - 8192]

// CHECK: vfmaddsub132ps zmm10, zmm9, zmmword ptr [rdx - 8256]
// CHECK:  encoding: [0x62,0x72,0x35,0x48,0x96,0x92,0xc0,0xdf,0xff,0xff]
          vfmaddsub132ps zmm10, zmm9, zmmword ptr [rdx - 8256]

// CHECK: vfmaddsub132ps zmm10, zmm9, dword ptr [rdx + 508]{1to16}
// CHECK:  encoding: [0x62,0x72,0x35,0x58,0x96,0x52,0x7f]
          vfmaddsub132ps zmm10, zmm9, dword ptr [rdx + 508]{1to16}

// CHECK: vfmaddsub132ps zmm10, zmm9, dword ptr [rdx + 512]{1to16}
// CHECK:  encoding: [0x62,0x72,0x35,0x58,0x96,0x92,0x00,0x02,0x00,0x00]
          vfmaddsub132ps zmm10, zmm9, dword ptr [rdx + 512]{1to16}

// CHECK: vfmaddsub132ps zmm10, zmm9, dword ptr [rdx - 512]{1to16}
// CHECK:  encoding: [0x62,0x72,0x35,0x58,0x96,0x52,0x80]
          vfmaddsub132ps zmm10, zmm9, dword ptr [rdx - 512]{1to16}

// CHECK: vfmaddsub132ps zmm10, zmm9, dword ptr [rdx - 516]{1to16}
// CHECK:  encoding: [0x62,0x72,0x35,0x58,0x96,0x92,0xfc,0xfd,0xff,0xff]
          vfmaddsub132ps zmm10, zmm9, dword ptr [rdx - 516]{1to16}

// CHECK: vfmaddsub213pd zmm26, zmm6, zmm10
// CHECK:  encoding: [0x62,0x42,0xcd,0x48,0xa6,0xd2]
          vfmaddsub213pd zmm26, zmm6, zmm10

// CHECK: vfmaddsub213pd zmm26 {k6}, zmm6, zmm10
// CHECK:  encoding: [0x62,0x42,0xcd,0x4e,0xa6,0xd2]
          vfmaddsub213pd zmm26 {k6}, zmm6, zmm10

// CHECK: vfmaddsub213pd zmm26 {k6} {z}, zmm6, zmm10
// CHECK:  encoding: [0x62,0x42,0xcd,0xce,0xa6,0xd2]
          vfmaddsub213pd zmm26 {k6} {z}, zmm6, zmm10

// CHECK: vfmaddsub213pd zmm26, zmm6, zmm10, {rn-sae}
// CHECK:  encoding: [0x62,0x42,0xcd,0x18,0xa6,0xd2]
          vfmaddsub213pd zmm26, zmm6, zmm10, {rn-sae}

// CHECK: vfmaddsub213pd zmm26, zmm6, zmm10, {ru-sae}
// CHECK:  encoding: [0x62,0x42,0xcd,0x58,0xa6,0xd2]
          vfmaddsub213pd zmm26, zmm6, zmm10, {ru-sae}

// CHECK: vfmaddsub213pd zmm26, zmm6, zmm10, {rd-sae}
// CHECK:  encoding: [0x62,0x42,0xcd,0x38,0xa6,0xd2]
          vfmaddsub213pd zmm26, zmm6, zmm10, {rd-sae}

// CHECK: vfmaddsub213pd zmm26, zmm6, zmm10, {rz-sae}
// CHECK:  encoding: [0x62,0x42,0xcd,0x78,0xa6,0xd2]
          vfmaddsub213pd zmm26, zmm6, zmm10, {rz-sae}

// CHECK: vfmaddsub213pd zmm26, zmm6, zmmword ptr [rcx]
// CHECK:  encoding: [0x62,0x62,0xcd,0x48,0xa6,0x11]
          vfmaddsub213pd zmm26, zmm6, zmmword ptr [rcx]

// CHECK: vfmaddsub213pd zmm26, zmm6, zmmword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0x22,0xcd,0x48,0xa6,0x94,0xf0,0x23,0x01,0x00,0x00]
          vfmaddsub213pd zmm26, zmm6, zmmword ptr [rax + 8*r14 + 291]

// CHECK: vfmaddsub213pd zmm26, zmm6, qword ptr [rcx]{1to8}
// CHECK:  encoding: [0x62,0x62,0xcd,0x58,0xa6,0x11]
          vfmaddsub213pd zmm26, zmm6, qword ptr [rcx]{1to8}

// CHECK: vfmaddsub213pd zmm26, zmm6, zmmword ptr [rdx + 8128]
// CHECK:  encoding: [0x62,0x62,0xcd,0x48,0xa6,0x52,0x7f]
          vfmaddsub213pd zmm26, zmm6, zmmword ptr [rdx + 8128]

// CHECK: vfmaddsub213pd zmm26, zmm6, zmmword ptr [rdx + 8192]
// CHECK:  encoding: [0x62,0x62,0xcd,0x48,0xa6,0x92,0x00,0x20,0x00,0x00]
          vfmaddsub213pd zmm26, zmm6, zmmword ptr [rdx + 8192]

// CHECK: vfmaddsub213pd zmm26, zmm6, zmmword ptr [rdx - 8192]
// CHECK:  encoding: [0x62,0x62,0xcd,0x48,0xa6,0x52,0x80]
          vfmaddsub213pd zmm26, zmm6, zmmword ptr [rdx - 8192]

// CHECK: vfmaddsub213pd zmm26, zmm6, zmmword ptr [rdx - 8256]
// CHECK:  encoding: [0x62,0x62,0xcd,0x48,0xa6,0x92,0xc0,0xdf,0xff,0xff]
          vfmaddsub213pd zmm26, zmm6, zmmword ptr [rdx - 8256]

// CHECK: vfmaddsub213pd zmm26, zmm6, qword ptr [rdx + 1016]{1to8}
// CHECK:  encoding: [0x62,0x62,0xcd,0x58,0xa6,0x52,0x7f]
          vfmaddsub213pd zmm26, zmm6, qword ptr [rdx + 1016]{1to8}

// CHECK: vfmaddsub213pd zmm26, zmm6, qword ptr [rdx + 1024]{1to8}
// CHECK:  encoding: [0x62,0x62,0xcd,0x58,0xa6,0x92,0x00,0x04,0x00,0x00]
          vfmaddsub213pd zmm26, zmm6, qword ptr [rdx + 1024]{1to8}

// CHECK: vfmaddsub213pd zmm26, zmm6, qword ptr [rdx - 1024]{1to8}
// CHECK:  encoding: [0x62,0x62,0xcd,0x58,0xa6,0x52,0x80]
          vfmaddsub213pd zmm26, zmm6, qword ptr [rdx - 1024]{1to8}

// CHECK: vfmaddsub213pd zmm26, zmm6, qword ptr [rdx - 1032]{1to8}
// CHECK:  encoding: [0x62,0x62,0xcd,0x58,0xa6,0x92,0xf8,0xfb,0xff,0xff]
          vfmaddsub213pd zmm26, zmm6, qword ptr [rdx - 1032]{1to8}

// CHECK: vfmaddsub213ps zmm17, zmm24, zmm28
// CHECK:  encoding: [0x62,0x82,0x3d,0x40,0xa6,0xcc]
          vfmaddsub213ps zmm17, zmm24, zmm28

// CHECK: vfmaddsub213ps zmm17 {k6}, zmm24, zmm28
// CHECK:  encoding: [0x62,0x82,0x3d,0x46,0xa6,0xcc]
          vfmaddsub213ps zmm17 {k6}, zmm24, zmm28

// CHECK: vfmaddsub213ps zmm17 {k6} {z}, zmm24, zmm28
// CHECK:  encoding: [0x62,0x82,0x3d,0xc6,0xa6,0xcc]
          vfmaddsub213ps zmm17 {k6} {z}, zmm24, zmm28

// CHECK: vfmaddsub213ps zmm17, zmm24, zmm28, {rn-sae}
// CHECK:  encoding: [0x62,0x82,0x3d,0x10,0xa6,0xcc]
          vfmaddsub213ps zmm17, zmm24, zmm28, {rn-sae}

// CHECK: vfmaddsub213ps zmm17, zmm24, zmm28, {ru-sae}
// CHECK:  encoding: [0x62,0x82,0x3d,0x50,0xa6,0xcc]
          vfmaddsub213ps zmm17, zmm24, zmm28, {ru-sae}

// CHECK: vfmaddsub213ps zmm17, zmm24, zmm28, {rd-sae}
// CHECK:  encoding: [0x62,0x82,0x3d,0x30,0xa6,0xcc]
          vfmaddsub213ps zmm17, zmm24, zmm28, {rd-sae}

// CHECK: vfmaddsub213ps zmm17, zmm24, zmm28, {rz-sae}
// CHECK:  encoding: [0x62,0x82,0x3d,0x70,0xa6,0xcc]
          vfmaddsub213ps zmm17, zmm24, zmm28, {rz-sae}

// CHECK: vfmaddsub213ps zmm17, zmm24, zmmword ptr [rcx]
// CHECK:  encoding: [0x62,0xe2,0x3d,0x40,0xa6,0x09]
          vfmaddsub213ps zmm17, zmm24, zmmword ptr [rcx]

// CHECK: vfmaddsub213ps zmm17, zmm24, zmmword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0xa2,0x3d,0x40,0xa6,0x8c,0xf0,0x23,0x01,0x00,0x00]
          vfmaddsub213ps zmm17, zmm24, zmmword ptr [rax + 8*r14 + 291]

// CHECK: vfmaddsub213ps zmm17, zmm24, dword ptr [rcx]{1to16}
// CHECK:  encoding: [0x62,0xe2,0x3d,0x50,0xa6,0x09]
          vfmaddsub213ps zmm17, zmm24, dword ptr [rcx]{1to16}

// CHECK: vfmaddsub213ps zmm17, zmm24, zmmword ptr [rdx + 8128]
// CHECK:  encoding: [0x62,0xe2,0x3d,0x40,0xa6,0x4a,0x7f]
          vfmaddsub213ps zmm17, zmm24, zmmword ptr [rdx + 8128]

// CHECK: vfmaddsub213ps zmm17, zmm24, zmmword ptr [rdx + 8192]
// CHECK:  encoding: [0x62,0xe2,0x3d,0x40,0xa6,0x8a,0x00,0x20,0x00,0x00]
          vfmaddsub213ps zmm17, zmm24, zmmword ptr [rdx + 8192]

// CHECK: vfmaddsub213ps zmm17, zmm24, zmmword ptr [rdx - 8192]
// CHECK:  encoding: [0x62,0xe2,0x3d,0x40,0xa6,0x4a,0x80]
          vfmaddsub213ps zmm17, zmm24, zmmword ptr [rdx - 8192]

// CHECK: vfmaddsub213ps zmm17, zmm24, zmmword ptr [rdx - 8256]
// CHECK:  encoding: [0x62,0xe2,0x3d,0x40,0xa6,0x8a,0xc0,0xdf,0xff,0xff]
          vfmaddsub213ps zmm17, zmm24, zmmword ptr [rdx - 8256]

// CHECK: vfmaddsub213ps zmm17, zmm24, dword ptr [rdx + 508]{1to16}
// CHECK:  encoding: [0x62,0xe2,0x3d,0x50,0xa6,0x4a,0x7f]
          vfmaddsub213ps zmm17, zmm24, dword ptr [rdx + 508]{1to16}

// CHECK: vfmaddsub213ps zmm17, zmm24, dword ptr [rdx + 512]{1to16}
// CHECK:  encoding: [0x62,0xe2,0x3d,0x50,0xa6,0x8a,0x00,0x02,0x00,0x00]
          vfmaddsub213ps zmm17, zmm24, dword ptr [rdx + 512]{1to16}

// CHECK: vfmaddsub213ps zmm17, zmm24, dword ptr [rdx - 512]{1to16}
// CHECK:  encoding: [0x62,0xe2,0x3d,0x50,0xa6,0x4a,0x80]
          vfmaddsub213ps zmm17, zmm24, dword ptr [rdx - 512]{1to16}

// CHECK: vfmaddsub213ps zmm17, zmm24, dword ptr [rdx - 516]{1to16}
// CHECK:  encoding: [0x62,0xe2,0x3d,0x50,0xa6,0x8a,0xfc,0xfd,0xff,0xff]
          vfmaddsub213ps zmm17, zmm24, dword ptr [rdx - 516]{1to16}

// CHECK: vfmaddsub231pd zmm9, zmm27, zmm24
// CHECK:  encoding: [0x62,0x12,0xa5,0x40,0xb6,0xc8]
          vfmaddsub231pd zmm9, zmm27, zmm24

// CHECK: vfmaddsub231pd zmm9 {k7}, zmm27, zmm24
// CHECK:  encoding: [0x62,0x12,0xa5,0x47,0xb6,0xc8]
          vfmaddsub231pd zmm9 {k7}, zmm27, zmm24

// CHECK: vfmaddsub231pd zmm9 {k7} {z}, zmm27, zmm24
// CHECK:  encoding: [0x62,0x12,0xa5,0xc7,0xb6,0xc8]
          vfmaddsub231pd zmm9 {k7} {z}, zmm27, zmm24

// CHECK: vfmaddsub231pd zmm9, zmm27, zmm24, {rn-sae}
// CHECK:  encoding: [0x62,0x12,0xa5,0x10,0xb6,0xc8]
          vfmaddsub231pd zmm9, zmm27, zmm24, {rn-sae}

// CHECK: vfmaddsub231pd zmm9, zmm27, zmm24, {ru-sae}
// CHECK:  encoding: [0x62,0x12,0xa5,0x50,0xb6,0xc8]
          vfmaddsub231pd zmm9, zmm27, zmm24, {ru-sae}

// CHECK: vfmaddsub231pd zmm9, zmm27, zmm24, {rd-sae}
// CHECK:  encoding: [0x62,0x12,0xa5,0x30,0xb6,0xc8]
          vfmaddsub231pd zmm9, zmm27, zmm24, {rd-sae}

// CHECK: vfmaddsub231pd zmm9, zmm27, zmm24, {rz-sae}
// CHECK:  encoding: [0x62,0x12,0xa5,0x70,0xb6,0xc8]
          vfmaddsub231pd zmm9, zmm27, zmm24, {rz-sae}

// CHECK: vfmaddsub231pd zmm9, zmm27, zmmword ptr [rcx]
// CHECK:  encoding: [0x62,0x72,0xa5,0x40,0xb6,0x09]
          vfmaddsub231pd zmm9, zmm27, zmmword ptr [rcx]

// CHECK: vfmaddsub231pd zmm9, zmm27, zmmword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0x32,0xa5,0x40,0xb6,0x8c,0xf0,0x23,0x01,0x00,0x00]
          vfmaddsub231pd zmm9, zmm27, zmmword ptr [rax + 8*r14 + 291]

// CHECK: vfmaddsub231pd zmm9, zmm27, qword ptr [rcx]{1to8}
// CHECK:  encoding: [0x62,0x72,0xa5,0x50,0xb6,0x09]
          vfmaddsub231pd zmm9, zmm27, qword ptr [rcx]{1to8}

// CHECK: vfmaddsub231pd zmm9, zmm27, zmmword ptr [rdx + 8128]
// CHECK:  encoding: [0x62,0x72,0xa5,0x40,0xb6,0x4a,0x7f]
          vfmaddsub231pd zmm9, zmm27, zmmword ptr [rdx + 8128]

// CHECK: vfmaddsub231pd zmm9, zmm27, zmmword ptr [rdx + 8192]
// CHECK:  encoding: [0x62,0x72,0xa5,0x40,0xb6,0x8a,0x00,0x20,0x00,0x00]
          vfmaddsub231pd zmm9, zmm27, zmmword ptr [rdx + 8192]

// CHECK: vfmaddsub231pd zmm9, zmm27, zmmword ptr [rdx - 8192]
// CHECK:  encoding: [0x62,0x72,0xa5,0x40,0xb6,0x4a,0x80]
          vfmaddsub231pd zmm9, zmm27, zmmword ptr [rdx - 8192]

// CHECK: vfmaddsub231pd zmm9, zmm27, zmmword ptr [rdx - 8256]
// CHECK:  encoding: [0x62,0x72,0xa5,0x40,0xb6,0x8a,0xc0,0xdf,0xff,0xff]
          vfmaddsub231pd zmm9, zmm27, zmmword ptr [rdx - 8256]

// CHECK: vfmaddsub231pd zmm9, zmm27, qword ptr [rdx + 1016]{1to8}
// CHECK:  encoding: [0x62,0x72,0xa5,0x50,0xb6,0x4a,0x7f]
          vfmaddsub231pd zmm9, zmm27, qword ptr [rdx + 1016]{1to8}

// CHECK: vfmaddsub231pd zmm9, zmm27, qword ptr [rdx + 1024]{1to8}
// CHECK:  encoding: [0x62,0x72,0xa5,0x50,0xb6,0x8a,0x00,0x04,0x00,0x00]
          vfmaddsub231pd zmm9, zmm27, qword ptr [rdx + 1024]{1to8}

// CHECK: vfmaddsub231pd zmm9, zmm27, qword ptr [rdx - 1024]{1to8}
// CHECK:  encoding: [0x62,0x72,0xa5,0x50,0xb6,0x4a,0x80]
          vfmaddsub231pd zmm9, zmm27, qword ptr [rdx - 1024]{1to8}

// CHECK: vfmaddsub231pd zmm9, zmm27, qword ptr [rdx - 1032]{1to8}
// CHECK:  encoding: [0x62,0x72,0xa5,0x50,0xb6,0x8a,0xf8,0xfb,0xff,0xff]
          vfmaddsub231pd zmm9, zmm27, qword ptr [rdx - 1032]{1to8}

// CHECK: vfmaddsub231ps zmm15, zmm21, zmm19
// CHECK:  encoding: [0x62,0x32,0x55,0x40,0xb6,0xfb]
          vfmaddsub231ps zmm15, zmm21, zmm19

// CHECK: vfmaddsub231ps zmm15 {k6}, zmm21, zmm19
// CHECK:  encoding: [0x62,0x32,0x55,0x46,0xb6,0xfb]
          vfmaddsub231ps zmm15 {k6}, zmm21, zmm19

// CHECK: vfmaddsub231ps zmm15 {k6} {z}, zmm21, zmm19
// CHECK:  encoding: [0x62,0x32,0x55,0xc6,0xb6,0xfb]
          vfmaddsub231ps zmm15 {k6} {z}, zmm21, zmm19

// CHECK: vfmaddsub231ps zmm15, zmm21, zmm19, {rn-sae}
// CHECK:  encoding: [0x62,0x32,0x55,0x10,0xb6,0xfb]
          vfmaddsub231ps zmm15, zmm21, zmm19, {rn-sae}

// CHECK: vfmaddsub231ps zmm15, zmm21, zmm19, {ru-sae}
// CHECK:  encoding: [0x62,0x32,0x55,0x50,0xb6,0xfb]
          vfmaddsub231ps zmm15, zmm21, zmm19, {ru-sae}

// CHECK: vfmaddsub231ps zmm15, zmm21, zmm19, {rd-sae}
// CHECK:  encoding: [0x62,0x32,0x55,0x30,0xb6,0xfb]
          vfmaddsub231ps zmm15, zmm21, zmm19, {rd-sae}

// CHECK: vfmaddsub231ps zmm15, zmm21, zmm19, {rz-sae}
// CHECK:  encoding: [0x62,0x32,0x55,0x70,0xb6,0xfb]
          vfmaddsub231ps zmm15, zmm21, zmm19, {rz-sae}

// CHECK: vfmaddsub231ps zmm15, zmm21, zmmword ptr [rcx]
// CHECK:  encoding: [0x62,0x72,0x55,0x40,0xb6,0x39]
          vfmaddsub231ps zmm15, zmm21, zmmword ptr [rcx]

// CHECK: vfmaddsub231ps zmm15, zmm21, zmmword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0x32,0x55,0x40,0xb6,0xbc,0xf0,0x23,0x01,0x00,0x00]
          vfmaddsub231ps zmm15, zmm21, zmmword ptr [rax + 8*r14 + 291]

// CHECK: vfmaddsub231ps zmm15, zmm21, dword ptr [rcx]{1to16}
// CHECK:  encoding: [0x62,0x72,0x55,0x50,0xb6,0x39]
          vfmaddsub231ps zmm15, zmm21, dword ptr [rcx]{1to16}

// CHECK: vfmaddsub231ps zmm15, zmm21, zmmword ptr [rdx + 8128]
// CHECK:  encoding: [0x62,0x72,0x55,0x40,0xb6,0x7a,0x7f]
          vfmaddsub231ps zmm15, zmm21, zmmword ptr [rdx + 8128]

// CHECK: vfmaddsub231ps zmm15, zmm21, zmmword ptr [rdx + 8192]
// CHECK:  encoding: [0x62,0x72,0x55,0x40,0xb6,0xba,0x00,0x20,0x00,0x00]
          vfmaddsub231ps zmm15, zmm21, zmmword ptr [rdx + 8192]

// CHECK: vfmaddsub231ps zmm15, zmm21, zmmword ptr [rdx - 8192]
// CHECK:  encoding: [0x62,0x72,0x55,0x40,0xb6,0x7a,0x80]
          vfmaddsub231ps zmm15, zmm21, zmmword ptr [rdx - 8192]

// CHECK: vfmaddsub231ps zmm15, zmm21, zmmword ptr [rdx - 8256]
// CHECK:  encoding: [0x62,0x72,0x55,0x40,0xb6,0xba,0xc0,0xdf,0xff,0xff]
          vfmaddsub231ps zmm15, zmm21, zmmword ptr [rdx - 8256]

// CHECK: vfmaddsub231ps zmm15, zmm21, dword ptr [rdx + 508]{1to16}
// CHECK:  encoding: [0x62,0x72,0x55,0x50,0xb6,0x7a,0x7f]
          vfmaddsub231ps zmm15, zmm21, dword ptr [rdx + 508]{1to16}

// CHECK: vfmaddsub231ps zmm15, zmm21, dword ptr [rdx + 512]{1to16}
// CHECK:  encoding: [0x62,0x72,0x55,0x50,0xb6,0xba,0x00,0x02,0x00,0x00]
          vfmaddsub231ps zmm15, zmm21, dword ptr [rdx + 512]{1to16}

// CHECK: vfmaddsub231ps zmm15, zmm21, dword ptr [rdx - 512]{1to16}
// CHECK:  encoding: [0x62,0x72,0x55,0x50,0xb6,0x7a,0x80]
          vfmaddsub231ps zmm15, zmm21, dword ptr [rdx - 512]{1to16}

// CHECK: vfmaddsub231ps zmm15, zmm21, dword ptr [rdx - 516]{1to16}
// CHECK:  encoding: [0x62,0x72,0x55,0x50,0xb6,0xba,0xfc,0xfd,0xff,0xff]
          vfmaddsub231ps zmm15, zmm21, dword ptr [rdx - 516]{1to16}

// CHECK: vfmsub132pd zmm22, zmm12, zmm27
// CHECK:  encoding: [0x62,0x82,0x9d,0x48,0x9a,0xf3]
          vfmsub132pd zmm22, zmm12, zmm27

// CHECK: vfmsub132pd zmm22 {k2}, zmm12, zmm27
// CHECK:  encoding: [0x62,0x82,0x9d,0x4a,0x9a,0xf3]
          vfmsub132pd zmm22 {k2}, zmm12, zmm27

// CHECK: vfmsub132pd zmm22 {k2} {z}, zmm12, zmm27
// CHECK:  encoding: [0x62,0x82,0x9d,0xca,0x9a,0xf3]
          vfmsub132pd zmm22 {k2} {z}, zmm12, zmm27

// CHECK: vfmsub132pd zmm22, zmm12, zmm27, {rn-sae}
// CHECK:  encoding: [0x62,0x82,0x9d,0x18,0x9a,0xf3]
          vfmsub132pd zmm22, zmm12, zmm27, {rn-sae}

// CHECK: vfmsub132pd zmm22, zmm12, zmm27, {ru-sae}
// CHECK:  encoding: [0x62,0x82,0x9d,0x58,0x9a,0xf3]
          vfmsub132pd zmm22, zmm12, zmm27, {ru-sae}

// CHECK: vfmsub132pd zmm22, zmm12, zmm27, {rd-sae}
// CHECK:  encoding: [0x62,0x82,0x9d,0x38,0x9a,0xf3]
          vfmsub132pd zmm22, zmm12, zmm27, {rd-sae}

// CHECK: vfmsub132pd zmm22, zmm12, zmm27, {rz-sae}
// CHECK:  encoding: [0x62,0x82,0x9d,0x78,0x9a,0xf3]
          vfmsub132pd zmm22, zmm12, zmm27, {rz-sae}

// CHECK: vfmsub132pd zmm22, zmm12, zmmword ptr [rcx]
// CHECK:  encoding: [0x62,0xe2,0x9d,0x48,0x9a,0x31]
          vfmsub132pd zmm22, zmm12, zmmword ptr [rcx]

// CHECK: vfmsub132pd zmm22, zmm12, zmmword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0xa2,0x9d,0x48,0x9a,0xb4,0xf0,0x23,0x01,0x00,0x00]
          vfmsub132pd zmm22, zmm12, zmmword ptr [rax + 8*r14 + 291]

// CHECK: vfmsub132pd zmm22, zmm12, qword ptr [rcx]{1to8}
// CHECK:  encoding: [0x62,0xe2,0x9d,0x58,0x9a,0x31]
          vfmsub132pd zmm22, zmm12, qword ptr [rcx]{1to8}

// CHECK: vfmsub132pd zmm22, zmm12, zmmword ptr [rdx + 8128]
// CHECK:  encoding: [0x62,0xe2,0x9d,0x48,0x9a,0x72,0x7f]
          vfmsub132pd zmm22, zmm12, zmmword ptr [rdx + 8128]

// CHECK: vfmsub132pd zmm22, zmm12, zmmword ptr [rdx + 8192]
// CHECK:  encoding: [0x62,0xe2,0x9d,0x48,0x9a,0xb2,0x00,0x20,0x00,0x00]
          vfmsub132pd zmm22, zmm12, zmmword ptr [rdx + 8192]

// CHECK: vfmsub132pd zmm22, zmm12, zmmword ptr [rdx - 8192]
// CHECK:  encoding: [0x62,0xe2,0x9d,0x48,0x9a,0x72,0x80]
          vfmsub132pd zmm22, zmm12, zmmword ptr [rdx - 8192]

// CHECK: vfmsub132pd zmm22, zmm12, zmmword ptr [rdx - 8256]
// CHECK:  encoding: [0x62,0xe2,0x9d,0x48,0x9a,0xb2,0xc0,0xdf,0xff,0xff]
          vfmsub132pd zmm22, zmm12, zmmword ptr [rdx - 8256]

// CHECK: vfmsub132pd zmm22, zmm12, qword ptr [rdx + 1016]{1to8}
// CHECK:  encoding: [0x62,0xe2,0x9d,0x58,0x9a,0x72,0x7f]
          vfmsub132pd zmm22, zmm12, qword ptr [rdx + 1016]{1to8}

// CHECK: vfmsub132pd zmm22, zmm12, qword ptr [rdx + 1024]{1to8}
// CHECK:  encoding: [0x62,0xe2,0x9d,0x58,0x9a,0xb2,0x00,0x04,0x00,0x00]
          vfmsub132pd zmm22, zmm12, qword ptr [rdx + 1024]{1to8}

// CHECK: vfmsub132pd zmm22, zmm12, qword ptr [rdx - 1024]{1to8}
// CHECK:  encoding: [0x62,0xe2,0x9d,0x58,0x9a,0x72,0x80]
          vfmsub132pd zmm22, zmm12, qword ptr [rdx - 1024]{1to8}

// CHECK: vfmsub132pd zmm22, zmm12, qword ptr [rdx - 1032]{1to8}
// CHECK:  encoding: [0x62,0xe2,0x9d,0x58,0x9a,0xb2,0xf8,0xfb,0xff,0xff]
          vfmsub132pd zmm22, zmm12, qword ptr [rdx - 1032]{1to8}

// CHECK: vfmsub132ps zmm1, zmm13, zmm16
// CHECK:  encoding: [0x62,0xb2,0x15,0x48,0x9a,0xc8]
          vfmsub132ps zmm1, zmm13, zmm16

// CHECK: vfmsub132ps zmm1 {k4}, zmm13, zmm16
// CHECK:  encoding: [0x62,0xb2,0x15,0x4c,0x9a,0xc8]
          vfmsub132ps zmm1 {k4}, zmm13, zmm16

// CHECK: vfmsub132ps zmm1 {k4} {z}, zmm13, zmm16
// CHECK:  encoding: [0x62,0xb2,0x15,0xcc,0x9a,0xc8]
          vfmsub132ps zmm1 {k4} {z}, zmm13, zmm16

// CHECK: vfmsub132ps zmm1, zmm13, zmm16, {rn-sae}
// CHECK:  encoding: [0x62,0xb2,0x15,0x18,0x9a,0xc8]
          vfmsub132ps zmm1, zmm13, zmm16, {rn-sae}

// CHECK: vfmsub132ps zmm1, zmm13, zmm16, {ru-sae}
// CHECK:  encoding: [0x62,0xb2,0x15,0x58,0x9a,0xc8]
          vfmsub132ps zmm1, zmm13, zmm16, {ru-sae}

// CHECK: vfmsub132ps zmm1, zmm13, zmm16, {rd-sae}
// CHECK:  encoding: [0x62,0xb2,0x15,0x38,0x9a,0xc8]
          vfmsub132ps zmm1, zmm13, zmm16, {rd-sae}

// CHECK: vfmsub132ps zmm1, zmm13, zmm16, {rz-sae}
// CHECK:  encoding: [0x62,0xb2,0x15,0x78,0x9a,0xc8]
          vfmsub132ps zmm1, zmm13, zmm16, {rz-sae}

// CHECK: vfmsub132ps zmm1, zmm13, zmmword ptr [rcx]
// CHECK:  encoding: [0x62,0xf2,0x15,0x48,0x9a,0x09]
          vfmsub132ps zmm1, zmm13, zmmword ptr [rcx]

// CHECK: vfmsub132ps zmm1, zmm13, zmmword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0xb2,0x15,0x48,0x9a,0x8c,0xf0,0x23,0x01,0x00,0x00]
          vfmsub132ps zmm1, zmm13, zmmword ptr [rax + 8*r14 + 291]

// CHECK: vfmsub132ps zmm1, zmm13, dword ptr [rcx]{1to16}
// CHECK:  encoding: [0x62,0xf2,0x15,0x58,0x9a,0x09]
          vfmsub132ps zmm1, zmm13, dword ptr [rcx]{1to16}

// CHECK: vfmsub132ps zmm1, zmm13, zmmword ptr [rdx + 8128]
// CHECK:  encoding: [0x62,0xf2,0x15,0x48,0x9a,0x4a,0x7f]
          vfmsub132ps zmm1, zmm13, zmmword ptr [rdx + 8128]

// CHECK: vfmsub132ps zmm1, zmm13, zmmword ptr [rdx + 8192]
// CHECK:  encoding: [0x62,0xf2,0x15,0x48,0x9a,0x8a,0x00,0x20,0x00,0x00]
          vfmsub132ps zmm1, zmm13, zmmword ptr [rdx + 8192]

// CHECK: vfmsub132ps zmm1, zmm13, zmmword ptr [rdx - 8192]
// CHECK:  encoding: [0x62,0xf2,0x15,0x48,0x9a,0x4a,0x80]
          vfmsub132ps zmm1, zmm13, zmmword ptr [rdx - 8192]

// CHECK: vfmsub132ps zmm1, zmm13, zmmword ptr [rdx - 8256]
// CHECK:  encoding: [0x62,0xf2,0x15,0x48,0x9a,0x8a,0xc0,0xdf,0xff,0xff]
          vfmsub132ps zmm1, zmm13, zmmword ptr [rdx - 8256]

// CHECK: vfmsub132ps zmm1, zmm13, dword ptr [rdx + 508]{1to16}
// CHECK:  encoding: [0x62,0xf2,0x15,0x58,0x9a,0x4a,0x7f]
          vfmsub132ps zmm1, zmm13, dword ptr [rdx + 508]{1to16}

// CHECK: vfmsub132ps zmm1, zmm13, dword ptr [rdx + 512]{1to16}
// CHECK:  encoding: [0x62,0xf2,0x15,0x58,0x9a,0x8a,0x00,0x02,0x00,0x00]
          vfmsub132ps zmm1, zmm13, dword ptr [rdx + 512]{1to16}

// CHECK: vfmsub132ps zmm1, zmm13, dword ptr [rdx - 512]{1to16}
// CHECK:  encoding: [0x62,0xf2,0x15,0x58,0x9a,0x4a,0x80]
          vfmsub132ps zmm1, zmm13, dword ptr [rdx - 512]{1to16}

// CHECK: vfmsub132ps zmm1, zmm13, dword ptr [rdx - 516]{1to16}
// CHECK:  encoding: [0x62,0xf2,0x15,0x58,0x9a,0x8a,0xfc,0xfd,0xff,0xff]
          vfmsub132ps zmm1, zmm13, dword ptr [rdx - 516]{1to16}

// CHECK: vfmsub132sd xmm12, xmm8, xmm27
// CHECK:  encoding: [0x62,0x12,0xbd,0x08,0x9b,0xe3]
          vfmsub132sd xmm12, xmm8, xmm27

// CHECK: vfmsub132sd xmm12 {k3}, xmm8, xmm27
// CHECK:  encoding: [0x62,0x12,0xbd,0x0b,0x9b,0xe3]
          vfmsub132sd xmm12 {k3}, xmm8, xmm27

// CHECK: vfmsub132sd xmm12 {k3} {z}, xmm8, xmm27
// CHECK:  encoding: [0x62,0x12,0xbd,0x8b,0x9b,0xe3]
          vfmsub132sd xmm12 {k3} {z}, xmm8, xmm27

// CHECK: vfmsub132sd xmm12, xmm8, xmm27, {rn-sae}
// CHECK:  encoding: [0x62,0x12,0xbd,0x18,0x9b,0xe3]
          vfmsub132sd xmm12, xmm8, xmm27, {rn-sae}

// CHECK: vfmsub132sd xmm12, xmm8, xmm27, {ru-sae}
// CHECK:  encoding: [0x62,0x12,0xbd,0x58,0x9b,0xe3]
          vfmsub132sd xmm12, xmm8, xmm27, {ru-sae}

// CHECK: vfmsub132sd xmm12, xmm8, xmm27, {rd-sae}
// CHECK:  encoding: [0x62,0x12,0xbd,0x38,0x9b,0xe3]
          vfmsub132sd xmm12, xmm8, xmm27, {rd-sae}

// CHECK: vfmsub132sd xmm12, xmm8, xmm27, {rz-sae}
// CHECK:  encoding: [0x62,0x12,0xbd,0x78,0x9b,0xe3]
          vfmsub132sd xmm12, xmm8, xmm27, {rz-sae}

// CHECK: vfmsub132sd xmm12, xmm8, qword ptr [rcx]
// CHECK:  encoding: [0xc4,0x62,0xb9,0x9b,0x21]
          vfmsub132sd xmm12, xmm8, qword ptr [rcx]

// CHECK: vfmsub132sd xmm12, xmm8, qword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0xc4,0x22,0xb9,0x9b,0xa4,0xf0,0x23,0x01,0x00,0x00]
          vfmsub132sd xmm12, xmm8, qword ptr [rax + 8*r14 + 291]

// CHECK: vfmsub132sd xmm12, xmm8, qword ptr [rdx + 1016]
// CHECK:  encoding: [0xc4,0x62,0xb9,0x9b,0xa2,0xf8,0x03,0x00,0x00]
          vfmsub132sd xmm12, xmm8, qword ptr [rdx + 1016]

// CHECK: vfmsub132sd xmm12, xmm8, qword ptr [rdx + 1024]
// CHECK:  encoding: [0xc4,0x62,0xb9,0x9b,0xa2,0x00,0x04,0x00,0x00]
          vfmsub132sd xmm12, xmm8, qword ptr [rdx + 1024]

// CHECK: vfmsub132sd xmm12, xmm8, qword ptr [rdx - 1024]
// CHECK:  encoding: [0xc4,0x62,0xb9,0x9b,0xa2,0x00,0xfc,0xff,0xff]
          vfmsub132sd xmm12, xmm8, qword ptr [rdx - 1024]

// CHECK: vfmsub132sd xmm12, xmm8, qword ptr [rdx - 1032]
// CHECK:  encoding: [0xc4,0x62,0xb9,0x9b,0xa2,0xf8,0xfb,0xff,0xff]
          vfmsub132sd xmm12, xmm8, qword ptr [rdx - 1032]

// CHECK: vfmsub132ss xmm30, xmm22, xmm27
// CHECK:  encoding: [0x62,0x02,0x4d,0x00,0x9b,0xf3]
          vfmsub132ss xmm30, xmm22, xmm27

// CHECK: vfmsub132ss xmm30 {k3}, xmm22, xmm27
// CHECK:  encoding: [0x62,0x02,0x4d,0x03,0x9b,0xf3]
          vfmsub132ss xmm30 {k3}, xmm22, xmm27

// CHECK: vfmsub132ss xmm30 {k3} {z}, xmm22, xmm27
// CHECK:  encoding: [0x62,0x02,0x4d,0x83,0x9b,0xf3]
          vfmsub132ss xmm30 {k3} {z}, xmm22, xmm27

// CHECK: vfmsub132ss xmm30, xmm22, xmm27, {rn-sae}
// CHECK:  encoding: [0x62,0x02,0x4d,0x10,0x9b,0xf3]
          vfmsub132ss xmm30, xmm22, xmm27, {rn-sae}

// CHECK: vfmsub132ss xmm30, xmm22, xmm27, {ru-sae}
// CHECK:  encoding: [0x62,0x02,0x4d,0x50,0x9b,0xf3]
          vfmsub132ss xmm30, xmm22, xmm27, {ru-sae}

// CHECK: vfmsub132ss xmm30, xmm22, xmm27, {rd-sae}
// CHECK:  encoding: [0x62,0x02,0x4d,0x30,0x9b,0xf3]
          vfmsub132ss xmm30, xmm22, xmm27, {rd-sae}

// CHECK: vfmsub132ss xmm30, xmm22, xmm27, {rz-sae}
// CHECK:  encoding: [0x62,0x02,0x4d,0x70,0x9b,0xf3]
          vfmsub132ss xmm30, xmm22, xmm27, {rz-sae}

// CHECK: vfmsub132ss xmm30, xmm22, dword ptr [rcx]
// CHECK:  encoding: [0x62,0x62,0x4d,0x00,0x9b,0x31]
          vfmsub132ss xmm30, xmm22, dword ptr [rcx]

// CHECK: vfmsub132ss xmm30, xmm22, dword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0x22,0x4d,0x00,0x9b,0xb4,0xf0,0x23,0x01,0x00,0x00]
          vfmsub132ss xmm30, xmm22, dword ptr [rax + 8*r14 + 291]

// CHECK: vfmsub132ss xmm30, xmm22, dword ptr [rdx + 508]
// CHECK:  encoding: [0x62,0x62,0x4d,0x00,0x9b,0x72,0x7f]
          vfmsub132ss xmm30, xmm22, dword ptr [rdx + 508]

// CHECK: vfmsub132ss xmm30, xmm22, dword ptr [rdx + 512]
// CHECK:  encoding: [0x62,0x62,0x4d,0x00,0x9b,0xb2,0x00,0x02,0x00,0x00]
          vfmsub132ss xmm30, xmm22, dword ptr [rdx + 512]

// CHECK: vfmsub132ss xmm30, xmm22, dword ptr [rdx - 512]
// CHECK:  encoding: [0x62,0x62,0x4d,0x00,0x9b,0x72,0x80]
          vfmsub132ss xmm30, xmm22, dword ptr [rdx - 512]

// CHECK: vfmsub132ss xmm30, xmm22, dword ptr [rdx - 516]
// CHECK:  encoding: [0x62,0x62,0x4d,0x00,0x9b,0xb2,0xfc,0xfd,0xff,0xff]
          vfmsub132ss xmm30, xmm22, dword ptr [rdx - 516]

// CHECK: vfmsub213pd zmm5, zmm10, zmm4
// CHECK:  encoding: [0x62,0xf2,0xad,0x48,0xaa,0xec]
          vfmsub213pd zmm5, zmm10, zmm4

// CHECK: vfmsub213pd zmm5 {k1}, zmm10, zmm4
// CHECK:  encoding: [0x62,0xf2,0xad,0x49,0xaa,0xec]
          vfmsub213pd zmm5 {k1}, zmm10, zmm4

// CHECK: vfmsub213pd zmm5 {k1} {z}, zmm10, zmm4
// CHECK:  encoding: [0x62,0xf2,0xad,0xc9,0xaa,0xec]
          vfmsub213pd zmm5 {k1} {z}, zmm10, zmm4

// CHECK: vfmsub213pd zmm5, zmm10, zmm4, {rn-sae}
// CHECK:  encoding: [0x62,0xf2,0xad,0x18,0xaa,0xec]
          vfmsub213pd zmm5, zmm10, zmm4, {rn-sae}

// CHECK: vfmsub213pd zmm5, zmm10, zmm4, {ru-sae}
// CHECK:  encoding: [0x62,0xf2,0xad,0x58,0xaa,0xec]
          vfmsub213pd zmm5, zmm10, zmm4, {ru-sae}

// CHECK: vfmsub213pd zmm5, zmm10, zmm4, {rd-sae}
// CHECK:  encoding: [0x62,0xf2,0xad,0x38,0xaa,0xec]
          vfmsub213pd zmm5, zmm10, zmm4, {rd-sae}

// CHECK: vfmsub213pd zmm5, zmm10, zmm4, {rz-sae}
// CHECK:  encoding: [0x62,0xf2,0xad,0x78,0xaa,0xec]
          vfmsub213pd zmm5, zmm10, zmm4, {rz-sae}

// CHECK: vfmsub213pd zmm5, zmm10, zmmword ptr [rcx]
// CHECK:  encoding: [0x62,0xf2,0xad,0x48,0xaa,0x29]
          vfmsub213pd zmm5, zmm10, zmmword ptr [rcx]

// CHECK: vfmsub213pd zmm5, zmm10, zmmword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0xb2,0xad,0x48,0xaa,0xac,0xf0,0x23,0x01,0x00,0x00]
          vfmsub213pd zmm5, zmm10, zmmword ptr [rax + 8*r14 + 291]

// CHECK: vfmsub213pd zmm5, zmm10, qword ptr [rcx]{1to8}
// CHECK:  encoding: [0x62,0xf2,0xad,0x58,0xaa,0x29]
          vfmsub213pd zmm5, zmm10, qword ptr [rcx]{1to8}

// CHECK: vfmsub213pd zmm5, zmm10, zmmword ptr [rdx + 8128]
// CHECK:  encoding: [0x62,0xf2,0xad,0x48,0xaa,0x6a,0x7f]
          vfmsub213pd zmm5, zmm10, zmmword ptr [rdx + 8128]

// CHECK: vfmsub213pd zmm5, zmm10, zmmword ptr [rdx + 8192]
// CHECK:  encoding: [0x62,0xf2,0xad,0x48,0xaa,0xaa,0x00,0x20,0x00,0x00]
          vfmsub213pd zmm5, zmm10, zmmword ptr [rdx + 8192]

// CHECK: vfmsub213pd zmm5, zmm10, zmmword ptr [rdx - 8192]
// CHECK:  encoding: [0x62,0xf2,0xad,0x48,0xaa,0x6a,0x80]
          vfmsub213pd zmm5, zmm10, zmmword ptr [rdx - 8192]

// CHECK: vfmsub213pd zmm5, zmm10, zmmword ptr [rdx - 8256]
// CHECK:  encoding: [0x62,0xf2,0xad,0x48,0xaa,0xaa,0xc0,0xdf,0xff,0xff]
          vfmsub213pd zmm5, zmm10, zmmword ptr [rdx - 8256]

// CHECK: vfmsub213pd zmm5, zmm10, qword ptr [rdx + 1016]{1to8}
// CHECK:  encoding: [0x62,0xf2,0xad,0x58,0xaa,0x6a,0x7f]
          vfmsub213pd zmm5, zmm10, qword ptr [rdx + 1016]{1to8}

// CHECK: vfmsub213pd zmm5, zmm10, qword ptr [rdx + 1024]{1to8}
// CHECK:  encoding: [0x62,0xf2,0xad,0x58,0xaa,0xaa,0x00,0x04,0x00,0x00]
          vfmsub213pd zmm5, zmm10, qword ptr [rdx + 1024]{1to8}

// CHECK: vfmsub213pd zmm5, zmm10, qword ptr [rdx - 1024]{1to8}
// CHECK:  encoding: [0x62,0xf2,0xad,0x58,0xaa,0x6a,0x80]
          vfmsub213pd zmm5, zmm10, qword ptr [rdx - 1024]{1to8}

// CHECK: vfmsub213pd zmm5, zmm10, qword ptr [rdx - 1032]{1to8}
// CHECK:  encoding: [0x62,0xf2,0xad,0x58,0xaa,0xaa,0xf8,0xfb,0xff,0xff]
          vfmsub213pd zmm5, zmm10, qword ptr [rdx - 1032]{1to8}

// CHECK: vfmsub213ps zmm22, zmm22, zmm10
// CHECK:  encoding: [0x62,0xc2,0x4d,0x40,0xaa,0xf2]
          vfmsub213ps zmm22, zmm22, zmm10

// CHECK: vfmsub213ps zmm22 {k6}, zmm22, zmm10
// CHECK:  encoding: [0x62,0xc2,0x4d,0x46,0xaa,0xf2]
          vfmsub213ps zmm22 {k6}, zmm22, zmm10

// CHECK: vfmsub213ps zmm22 {k6} {z}, zmm22, zmm10
// CHECK:  encoding: [0x62,0xc2,0x4d,0xc6,0xaa,0xf2]
          vfmsub213ps zmm22 {k6} {z}, zmm22, zmm10

// CHECK: vfmsub213ps zmm22, zmm22, zmm10, {rn-sae}
// CHECK:  encoding: [0x62,0xc2,0x4d,0x10,0xaa,0xf2]
          vfmsub213ps zmm22, zmm22, zmm10, {rn-sae}

// CHECK: vfmsub213ps zmm22, zmm22, zmm10, {ru-sae}
// CHECK:  encoding: [0x62,0xc2,0x4d,0x50,0xaa,0xf2]
          vfmsub213ps zmm22, zmm22, zmm10, {ru-sae}

// CHECK: vfmsub213ps zmm22, zmm22, zmm10, {rd-sae}
// CHECK:  encoding: [0x62,0xc2,0x4d,0x30,0xaa,0xf2]
          vfmsub213ps zmm22, zmm22, zmm10, {rd-sae}

// CHECK: vfmsub213ps zmm22, zmm22, zmm10, {rz-sae}
// CHECK:  encoding: [0x62,0xc2,0x4d,0x70,0xaa,0xf2]
          vfmsub213ps zmm22, zmm22, zmm10, {rz-sae}

// CHECK: vfmsub213ps zmm22, zmm22, zmmword ptr [rcx]
// CHECK:  encoding: [0x62,0xe2,0x4d,0x40,0xaa,0x31]
          vfmsub213ps zmm22, zmm22, zmmword ptr [rcx]

// CHECK: vfmsub213ps zmm22, zmm22, zmmword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0xa2,0x4d,0x40,0xaa,0xb4,0xf0,0x23,0x01,0x00,0x00]
          vfmsub213ps zmm22, zmm22, zmmword ptr [rax + 8*r14 + 291]

// CHECK: vfmsub213ps zmm22, zmm22, dword ptr [rcx]{1to16}
// CHECK:  encoding: [0x62,0xe2,0x4d,0x50,0xaa,0x31]
          vfmsub213ps zmm22, zmm22, dword ptr [rcx]{1to16}

// CHECK: vfmsub213ps zmm22, zmm22, zmmword ptr [rdx + 8128]
// CHECK:  encoding: [0x62,0xe2,0x4d,0x40,0xaa,0x72,0x7f]
          vfmsub213ps zmm22, zmm22, zmmword ptr [rdx + 8128]

// CHECK: vfmsub213ps zmm22, zmm22, zmmword ptr [rdx + 8192]
// CHECK:  encoding: [0x62,0xe2,0x4d,0x40,0xaa,0xb2,0x00,0x20,0x00,0x00]
          vfmsub213ps zmm22, zmm22, zmmword ptr [rdx + 8192]

// CHECK: vfmsub213ps zmm22, zmm22, zmmword ptr [rdx - 8192]
// CHECK:  encoding: [0x62,0xe2,0x4d,0x40,0xaa,0x72,0x80]
          vfmsub213ps zmm22, zmm22, zmmword ptr [rdx - 8192]

// CHECK: vfmsub213ps zmm22, zmm22, zmmword ptr [rdx - 8256]
// CHECK:  encoding: [0x62,0xe2,0x4d,0x40,0xaa,0xb2,0xc0,0xdf,0xff,0xff]
          vfmsub213ps zmm22, zmm22, zmmword ptr [rdx - 8256]

// CHECK: vfmsub213ps zmm22, zmm22, dword ptr [rdx + 508]{1to16}
// CHECK:  encoding: [0x62,0xe2,0x4d,0x50,0xaa,0x72,0x7f]
          vfmsub213ps zmm22, zmm22, dword ptr [rdx + 508]{1to16}

// CHECK: vfmsub213ps zmm22, zmm22, dword ptr [rdx + 512]{1to16}
// CHECK:  encoding: [0x62,0xe2,0x4d,0x50,0xaa,0xb2,0x00,0x02,0x00,0x00]
          vfmsub213ps zmm22, zmm22, dword ptr [rdx + 512]{1to16}

// CHECK: vfmsub213ps zmm22, zmm22, dword ptr [rdx - 512]{1to16}
// CHECK:  encoding: [0x62,0xe2,0x4d,0x50,0xaa,0x72,0x80]
          vfmsub213ps zmm22, zmm22, dword ptr [rdx - 512]{1to16}

// CHECK: vfmsub213ps zmm22, zmm22, dword ptr [rdx - 516]{1to16}
// CHECK:  encoding: [0x62,0xe2,0x4d,0x50,0xaa,0xb2,0xfc,0xfd,0xff,0xff]
          vfmsub213ps zmm22, zmm22, dword ptr [rdx - 516]{1to16}

// CHECK: vfmsub213sd xmm6, xmm8, xmm12
// CHECK:  encoding: [0xc4,0xc2,0xb9,0xab,0xf4]
          vfmsub213sd xmm6, xmm8, xmm12

// CHECK: vfmsub213sd xmm6 {k1}, xmm8, xmm12
// CHECK:  encoding: [0x62,0xd2,0xbd,0x09,0xab,0xf4]
          vfmsub213sd xmm6 {k1}, xmm8, xmm12

// CHECK: vfmsub213sd xmm6 {k1} {z}, xmm8, xmm12
// CHECK:  encoding: [0x62,0xd2,0xbd,0x89,0xab,0xf4]
          vfmsub213sd xmm6 {k1} {z}, xmm8, xmm12

// CHECK: vfmsub213sd xmm6, xmm8, xmm12, {rn-sae}
// CHECK:  encoding: [0x62,0xd2,0xbd,0x18,0xab,0xf4]
          vfmsub213sd xmm6, xmm8, xmm12, {rn-sae}

// CHECK: vfmsub213sd xmm6, xmm8, xmm12, {ru-sae}
// CHECK:  encoding: [0x62,0xd2,0xbd,0x58,0xab,0xf4]
          vfmsub213sd xmm6, xmm8, xmm12, {ru-sae}

// CHECK: vfmsub213sd xmm6, xmm8, xmm12, {rd-sae}
// CHECK:  encoding: [0x62,0xd2,0xbd,0x38,0xab,0xf4]
          vfmsub213sd xmm6, xmm8, xmm12, {rd-sae}

// CHECK: vfmsub213sd xmm6, xmm8, xmm12, {rz-sae}
// CHECK:  encoding: [0x62,0xd2,0xbd,0x78,0xab,0xf4]
          vfmsub213sd xmm6, xmm8, xmm12, {rz-sae}

// CHECK: vfmsub213sd xmm6, xmm8, qword ptr [rcx]
// CHECK:  encoding: [0xc4,0xe2,0xb9,0xab,0x31]
          vfmsub213sd xmm6, xmm8, qword ptr [rcx]

// CHECK: vfmsub213sd xmm6, xmm8, qword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0xc4,0xa2,0xb9,0xab,0xb4,0xf0,0x23,0x01,0x00,0x00]
          vfmsub213sd xmm6, xmm8, qword ptr [rax + 8*r14 + 291]

// CHECK: vfmsub213sd xmm6, xmm8, qword ptr [rdx + 1016]
// CHECK:  encoding: [0xc4,0xe2,0xb9,0xab,0xb2,0xf8,0x03,0x00,0x00]
          vfmsub213sd xmm6, xmm8, qword ptr [rdx + 1016]

// CHECK: vfmsub213sd xmm6, xmm8, qword ptr [rdx + 1024]
// CHECK:  encoding: [0xc4,0xe2,0xb9,0xab,0xb2,0x00,0x04,0x00,0x00]
          vfmsub213sd xmm6, xmm8, qword ptr [rdx + 1024]

// CHECK: vfmsub213sd xmm6, xmm8, qword ptr [rdx - 1024]
// CHECK:  encoding: [0xc4,0xe2,0xb9,0xab,0xb2,0x00,0xfc,0xff,0xff]
          vfmsub213sd xmm6, xmm8, qword ptr [rdx - 1024]

// CHECK: vfmsub213sd xmm6, xmm8, qword ptr [rdx - 1032]
// CHECK:  encoding: [0xc4,0xe2,0xb9,0xab,0xb2,0xf8,0xfb,0xff,0xff]
          vfmsub213sd xmm6, xmm8, qword ptr [rdx - 1032]

// CHECK: vfmsub213ss xmm30, xmm13, xmm26
// CHECK:  encoding: [0x62,0x02,0x15,0x08,0xab,0xf2]
          vfmsub213ss xmm30, xmm13, xmm26

// CHECK: vfmsub213ss xmm30 {k1}, xmm13, xmm26
// CHECK:  encoding: [0x62,0x02,0x15,0x09,0xab,0xf2]
          vfmsub213ss xmm30 {k1}, xmm13, xmm26

// CHECK: vfmsub213ss xmm30 {k1} {z}, xmm13, xmm26
// CHECK:  encoding: [0x62,0x02,0x15,0x89,0xab,0xf2]
          vfmsub213ss xmm30 {k1} {z}, xmm13, xmm26

// CHECK: vfmsub213ss xmm30, xmm13, xmm26, {rn-sae}
// CHECK:  encoding: [0x62,0x02,0x15,0x18,0xab,0xf2]
          vfmsub213ss xmm30, xmm13, xmm26, {rn-sae}

// CHECK: vfmsub213ss xmm30, xmm13, xmm26, {ru-sae}
// CHECK:  encoding: [0x62,0x02,0x15,0x58,0xab,0xf2]
          vfmsub213ss xmm30, xmm13, xmm26, {ru-sae}

// CHECK: vfmsub213ss xmm30, xmm13, xmm26, {rd-sae}
// CHECK:  encoding: [0x62,0x02,0x15,0x38,0xab,0xf2]
          vfmsub213ss xmm30, xmm13, xmm26, {rd-sae}

// CHECK: vfmsub213ss xmm30, xmm13, xmm26, {rz-sae}
// CHECK:  encoding: [0x62,0x02,0x15,0x78,0xab,0xf2]
          vfmsub213ss xmm30, xmm13, xmm26, {rz-sae}

// CHECK: vfmsub213ss xmm30, xmm13, dword ptr [rcx]
// CHECK:  encoding: [0x62,0x62,0x15,0x08,0xab,0x31]
          vfmsub213ss xmm30, xmm13, dword ptr [rcx]

// CHECK: vfmsub213ss xmm30, xmm13, dword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0x22,0x15,0x08,0xab,0xb4,0xf0,0x23,0x01,0x00,0x00]
          vfmsub213ss xmm30, xmm13, dword ptr [rax + 8*r14 + 291]

// CHECK: vfmsub213ss xmm30, xmm13, dword ptr [rdx + 508]
// CHECK:  encoding: [0x62,0x62,0x15,0x08,0xab,0x72,0x7f]
          vfmsub213ss xmm30, xmm13, dword ptr [rdx + 508]

// CHECK: vfmsub213ss xmm30, xmm13, dword ptr [rdx + 512]
// CHECK:  encoding: [0x62,0x62,0x15,0x08,0xab,0xb2,0x00,0x02,0x00,0x00]
          vfmsub213ss xmm30, xmm13, dword ptr [rdx + 512]

// CHECK: vfmsub213ss xmm30, xmm13, dword ptr [rdx - 512]
// CHECK:  encoding: [0x62,0x62,0x15,0x08,0xab,0x72,0x80]
          vfmsub213ss xmm30, xmm13, dword ptr [rdx - 512]

// CHECK: vfmsub213ss xmm30, xmm13, dword ptr [rdx - 516]
// CHECK:  encoding: [0x62,0x62,0x15,0x08,0xab,0xb2,0xfc,0xfd,0xff,0xff]
          vfmsub213ss xmm30, xmm13, dword ptr [rdx - 516]

// CHECK: vfmsub231pd zmm5, zmm12, zmm11
// CHECK:  encoding: [0x62,0xd2,0x9d,0x48,0xba,0xeb]
          vfmsub231pd zmm5, zmm12, zmm11

// CHECK: vfmsub231pd zmm5 {k2}, zmm12, zmm11
// CHECK:  encoding: [0x62,0xd2,0x9d,0x4a,0xba,0xeb]
          vfmsub231pd zmm5 {k2}, zmm12, zmm11

// CHECK: vfmsub231pd zmm5 {k2} {z}, zmm12, zmm11
// CHECK:  encoding: [0x62,0xd2,0x9d,0xca,0xba,0xeb]
          vfmsub231pd zmm5 {k2} {z}, zmm12, zmm11

// CHECK: vfmsub231pd zmm5, zmm12, zmm11, {rn-sae}
// CHECK:  encoding: [0x62,0xd2,0x9d,0x18,0xba,0xeb]
          vfmsub231pd zmm5, zmm12, zmm11, {rn-sae}

// CHECK: vfmsub231pd zmm5, zmm12, zmm11, {ru-sae}
// CHECK:  encoding: [0x62,0xd2,0x9d,0x58,0xba,0xeb]
          vfmsub231pd zmm5, zmm12, zmm11, {ru-sae}

// CHECK: vfmsub231pd zmm5, zmm12, zmm11, {rd-sae}
// CHECK:  encoding: [0x62,0xd2,0x9d,0x38,0xba,0xeb]
          vfmsub231pd zmm5, zmm12, zmm11, {rd-sae}

// CHECK: vfmsub231pd zmm5, zmm12, zmm11, {rz-sae}
// CHECK:  encoding: [0x62,0xd2,0x9d,0x78,0xba,0xeb]
          vfmsub231pd zmm5, zmm12, zmm11, {rz-sae}

// CHECK: vfmsub231pd zmm5, zmm12, zmmword ptr [rcx]
// CHECK:  encoding: [0x62,0xf2,0x9d,0x48,0xba,0x29]
          vfmsub231pd zmm5, zmm12, zmmword ptr [rcx]

// CHECK: vfmsub231pd zmm5, zmm12, zmmword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0xb2,0x9d,0x48,0xba,0xac,0xf0,0x23,0x01,0x00,0x00]
          vfmsub231pd zmm5, zmm12, zmmword ptr [rax + 8*r14 + 291]

// CHECK: vfmsub231pd zmm5, zmm12, qword ptr [rcx]{1to8}
// CHECK:  encoding: [0x62,0xf2,0x9d,0x58,0xba,0x29]
          vfmsub231pd zmm5, zmm12, qword ptr [rcx]{1to8}

// CHECK: vfmsub231pd zmm5, zmm12, zmmword ptr [rdx + 8128]
// CHECK:  encoding: [0x62,0xf2,0x9d,0x48,0xba,0x6a,0x7f]
          vfmsub231pd zmm5, zmm12, zmmword ptr [rdx + 8128]

// CHECK: vfmsub231pd zmm5, zmm12, zmmword ptr [rdx + 8192]
// CHECK:  encoding: [0x62,0xf2,0x9d,0x48,0xba,0xaa,0x00,0x20,0x00,0x00]
          vfmsub231pd zmm5, zmm12, zmmword ptr [rdx + 8192]

// CHECK: vfmsub231pd zmm5, zmm12, zmmword ptr [rdx - 8192]
// CHECK:  encoding: [0x62,0xf2,0x9d,0x48,0xba,0x6a,0x80]
          vfmsub231pd zmm5, zmm12, zmmword ptr [rdx - 8192]

// CHECK: vfmsub231pd zmm5, zmm12, zmmword ptr [rdx - 8256]
// CHECK:  encoding: [0x62,0xf2,0x9d,0x48,0xba,0xaa,0xc0,0xdf,0xff,0xff]
          vfmsub231pd zmm5, zmm12, zmmword ptr [rdx - 8256]

// CHECK: vfmsub231pd zmm5, zmm12, qword ptr [rdx + 1016]{1to8}
// CHECK:  encoding: [0x62,0xf2,0x9d,0x58,0xba,0x6a,0x7f]
          vfmsub231pd zmm5, zmm12, qword ptr [rdx + 1016]{1to8}

// CHECK: vfmsub231pd zmm5, zmm12, qword ptr [rdx + 1024]{1to8}
// CHECK:  encoding: [0x62,0xf2,0x9d,0x58,0xba,0xaa,0x00,0x04,0x00,0x00]
          vfmsub231pd zmm5, zmm12, qword ptr [rdx + 1024]{1to8}

// CHECK: vfmsub231pd zmm5, zmm12, qword ptr [rdx - 1024]{1to8}
// CHECK:  encoding: [0x62,0xf2,0x9d,0x58,0xba,0x6a,0x80]
          vfmsub231pd zmm5, zmm12, qword ptr [rdx - 1024]{1to8}

// CHECK: vfmsub231pd zmm5, zmm12, qword ptr [rdx - 1032]{1to8}
// CHECK:  encoding: [0x62,0xf2,0x9d,0x58,0xba,0xaa,0xf8,0xfb,0xff,0xff]
          vfmsub231pd zmm5, zmm12, qword ptr [rdx - 1032]{1to8}

// CHECK: vfmsub231ps zmm6, zmm21, zmm27
// CHECK:  encoding: [0x62,0x92,0x55,0x40,0xba,0xf3]
          vfmsub231ps zmm6, zmm21, zmm27

// CHECK: vfmsub231ps zmm6 {k3}, zmm21, zmm27
// CHECK:  encoding: [0x62,0x92,0x55,0x43,0xba,0xf3]
          vfmsub231ps zmm6 {k3}, zmm21, zmm27

// CHECK: vfmsub231ps zmm6 {k3} {z}, zmm21, zmm27
// CHECK:  encoding: [0x62,0x92,0x55,0xc3,0xba,0xf3]
          vfmsub231ps zmm6 {k3} {z}, zmm21, zmm27

// CHECK: vfmsub231ps zmm6, zmm21, zmm27, {rn-sae}
// CHECK:  encoding: [0x62,0x92,0x55,0x10,0xba,0xf3]
          vfmsub231ps zmm6, zmm21, zmm27, {rn-sae}

// CHECK: vfmsub231ps zmm6, zmm21, zmm27, {ru-sae}
// CHECK:  encoding: [0x62,0x92,0x55,0x50,0xba,0xf3]
          vfmsub231ps zmm6, zmm21, zmm27, {ru-sae}

// CHECK: vfmsub231ps zmm6, zmm21, zmm27, {rd-sae}
// CHECK:  encoding: [0x62,0x92,0x55,0x30,0xba,0xf3]
          vfmsub231ps zmm6, zmm21, zmm27, {rd-sae}

// CHECK: vfmsub231ps zmm6, zmm21, zmm27, {rz-sae}
// CHECK:  encoding: [0x62,0x92,0x55,0x70,0xba,0xf3]
          vfmsub231ps zmm6, zmm21, zmm27, {rz-sae}

// CHECK: vfmsub231ps zmm6, zmm21, zmmword ptr [rcx]
// CHECK:  encoding: [0x62,0xf2,0x55,0x40,0xba,0x31]
          vfmsub231ps zmm6, zmm21, zmmword ptr [rcx]

// CHECK: vfmsub231ps zmm6, zmm21, zmmword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0xb2,0x55,0x40,0xba,0xb4,0xf0,0x23,0x01,0x00,0x00]
          vfmsub231ps zmm6, zmm21, zmmword ptr [rax + 8*r14 + 291]

// CHECK: vfmsub231ps zmm6, zmm21, dword ptr [rcx]{1to16}
// CHECK:  encoding: [0x62,0xf2,0x55,0x50,0xba,0x31]
          vfmsub231ps zmm6, zmm21, dword ptr [rcx]{1to16}

// CHECK: vfmsub231ps zmm6, zmm21, zmmword ptr [rdx + 8128]
// CHECK:  encoding: [0x62,0xf2,0x55,0x40,0xba,0x72,0x7f]
          vfmsub231ps zmm6, zmm21, zmmword ptr [rdx + 8128]

// CHECK: vfmsub231ps zmm6, zmm21, zmmword ptr [rdx + 8192]
// CHECK:  encoding: [0x62,0xf2,0x55,0x40,0xba,0xb2,0x00,0x20,0x00,0x00]
          vfmsub231ps zmm6, zmm21, zmmword ptr [rdx + 8192]

// CHECK: vfmsub231ps zmm6, zmm21, zmmword ptr [rdx - 8192]
// CHECK:  encoding: [0x62,0xf2,0x55,0x40,0xba,0x72,0x80]
          vfmsub231ps zmm6, zmm21, zmmword ptr [rdx - 8192]

// CHECK: vfmsub231ps zmm6, zmm21, zmmword ptr [rdx - 8256]
// CHECK:  encoding: [0x62,0xf2,0x55,0x40,0xba,0xb2,0xc0,0xdf,0xff,0xff]
          vfmsub231ps zmm6, zmm21, zmmword ptr [rdx - 8256]

// CHECK: vfmsub231ps zmm6, zmm21, dword ptr [rdx + 508]{1to16}
// CHECK:  encoding: [0x62,0xf2,0x55,0x50,0xba,0x72,0x7f]
          vfmsub231ps zmm6, zmm21, dword ptr [rdx + 508]{1to16}

// CHECK: vfmsub231ps zmm6, zmm21, dword ptr [rdx + 512]{1to16}
// CHECK:  encoding: [0x62,0xf2,0x55,0x50,0xba,0xb2,0x00,0x02,0x00,0x00]
          vfmsub231ps zmm6, zmm21, dword ptr [rdx + 512]{1to16}

// CHECK: vfmsub231ps zmm6, zmm21, dword ptr [rdx - 512]{1to16}
// CHECK:  encoding: [0x62,0xf2,0x55,0x50,0xba,0x72,0x80]
          vfmsub231ps zmm6, zmm21, dword ptr [rdx - 512]{1to16}

// CHECK: vfmsub231ps zmm6, zmm21, dword ptr [rdx - 516]{1to16}
// CHECK:  encoding: [0x62,0xf2,0x55,0x50,0xba,0xb2,0xfc,0xfd,0xff,0xff]
          vfmsub231ps zmm6, zmm21, dword ptr [rdx - 516]{1to16}

// CHECK: vfmsub231sd xmm3, xmm11, xmm6
// CHECK:  encoding: [0xc4,0xe2,0xa1,0xbb,0xde]
          vfmsub231sd xmm3, xmm11, xmm6

// CHECK: vfmsub231sd xmm3 {k7}, xmm11, xmm6
// CHECK:  encoding: [0x62,0xf2,0xa5,0x0f,0xbb,0xde]
          vfmsub231sd xmm3 {k7}, xmm11, xmm6

// CHECK: vfmsub231sd xmm3 {k7} {z}, xmm11, xmm6
// CHECK:  encoding: [0x62,0xf2,0xa5,0x8f,0xbb,0xde]
          vfmsub231sd xmm3 {k7} {z}, xmm11, xmm6

// CHECK: vfmsub231sd xmm3, xmm11, xmm6, {rn-sae}
// CHECK:  encoding: [0x62,0xf2,0xa5,0x18,0xbb,0xde]
          vfmsub231sd xmm3, xmm11, xmm6, {rn-sae}

// CHECK: vfmsub231sd xmm3, xmm11, xmm6, {ru-sae}
// CHECK:  encoding: [0x62,0xf2,0xa5,0x58,0xbb,0xde]
          vfmsub231sd xmm3, xmm11, xmm6, {ru-sae}

// CHECK: vfmsub231sd xmm3, xmm11, xmm6, {rd-sae}
// CHECK:  encoding: [0x62,0xf2,0xa5,0x38,0xbb,0xde]
          vfmsub231sd xmm3, xmm11, xmm6, {rd-sae}

// CHECK: vfmsub231sd xmm3, xmm11, xmm6, {rz-sae}
// CHECK:  encoding: [0x62,0xf2,0xa5,0x78,0xbb,0xde]
          vfmsub231sd xmm3, xmm11, xmm6, {rz-sae}

// CHECK: vfmsub231sd xmm3, xmm11, qword ptr [rcx]
// CHECK:  encoding: [0xc4,0xe2,0xa1,0xbb,0x19]
          vfmsub231sd xmm3, xmm11, qword ptr [rcx]

// CHECK: vfmsub231sd xmm3, xmm11, qword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0xc4,0xa2,0xa1,0xbb,0x9c,0xf0,0x23,0x01,0x00,0x00]
          vfmsub231sd xmm3, xmm11, qword ptr [rax + 8*r14 + 291]

// CHECK: vfmsub231sd xmm3, xmm11, qword ptr [rdx + 1016]
// CHECK:  encoding: [0xc4,0xe2,0xa1,0xbb,0x9a,0xf8,0x03,0x00,0x00]
          vfmsub231sd xmm3, xmm11, qword ptr [rdx + 1016]

// CHECK: vfmsub231sd xmm3, xmm11, qword ptr [rdx + 1024]
// CHECK:  encoding: [0xc4,0xe2,0xa1,0xbb,0x9a,0x00,0x04,0x00,0x00]
          vfmsub231sd xmm3, xmm11, qword ptr [rdx + 1024]

// CHECK: vfmsub231sd xmm3, xmm11, qword ptr [rdx - 1024]
// CHECK:  encoding: [0xc4,0xe2,0xa1,0xbb,0x9a,0x00,0xfc,0xff,0xff]
          vfmsub231sd xmm3, xmm11, qword ptr [rdx - 1024]

// CHECK: vfmsub231sd xmm3, xmm11, qword ptr [rdx - 1032]
// CHECK:  encoding: [0xc4,0xe2,0xa1,0xbb,0x9a,0xf8,0xfb,0xff,0xff]
          vfmsub231sd xmm3, xmm11, qword ptr [rdx - 1032]

// CHECK: vfmsub231ss xmm29, xmm3, xmm5
// CHECK:  encoding: [0x62,0x62,0x65,0x08,0xbb,0xed]
          vfmsub231ss xmm29, xmm3, xmm5

// CHECK: vfmsub231ss xmm29 {k6}, xmm3, xmm5
// CHECK:  encoding: [0x62,0x62,0x65,0x0e,0xbb,0xed]
          vfmsub231ss xmm29 {k6}, xmm3, xmm5

// CHECK: vfmsub231ss xmm29 {k6} {z}, xmm3, xmm5
// CHECK:  encoding: [0x62,0x62,0x65,0x8e,0xbb,0xed]
          vfmsub231ss xmm29 {k6} {z}, xmm3, xmm5

// CHECK: vfmsub231ss xmm29, xmm3, xmm5, {rn-sae}
// CHECK:  encoding: [0x62,0x62,0x65,0x18,0xbb,0xed]
          vfmsub231ss xmm29, xmm3, xmm5, {rn-sae}

// CHECK: vfmsub231ss xmm29, xmm3, xmm5, {ru-sae}
// CHECK:  encoding: [0x62,0x62,0x65,0x58,0xbb,0xed]
          vfmsub231ss xmm29, xmm3, xmm5, {ru-sae}

// CHECK: vfmsub231ss xmm29, xmm3, xmm5, {rd-sae}
// CHECK:  encoding: [0x62,0x62,0x65,0x38,0xbb,0xed]
          vfmsub231ss xmm29, xmm3, xmm5, {rd-sae}

// CHECK: vfmsub231ss xmm29, xmm3, xmm5, {rz-sae}
// CHECK:  encoding: [0x62,0x62,0x65,0x78,0xbb,0xed]
          vfmsub231ss xmm29, xmm3, xmm5, {rz-sae}

// CHECK: vfmsub231ss xmm29, xmm3, dword ptr [rcx]
// CHECK:  encoding: [0x62,0x62,0x65,0x08,0xbb,0x29]
          vfmsub231ss xmm29, xmm3, dword ptr [rcx]

// CHECK: vfmsub231ss xmm29, xmm3, dword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0x22,0x65,0x08,0xbb,0xac,0xf0,0x23,0x01,0x00,0x00]
          vfmsub231ss xmm29, xmm3, dword ptr [rax + 8*r14 + 291]

// CHECK: vfmsub231ss xmm29, xmm3, dword ptr [rdx + 508]
// CHECK:  encoding: [0x62,0x62,0x65,0x08,0xbb,0x6a,0x7f]
          vfmsub231ss xmm29, xmm3, dword ptr [rdx + 508]

// CHECK: vfmsub231ss xmm29, xmm3, dword ptr [rdx + 512]
// CHECK:  encoding: [0x62,0x62,0x65,0x08,0xbb,0xaa,0x00,0x02,0x00,0x00]
          vfmsub231ss xmm29, xmm3, dword ptr [rdx + 512]

// CHECK: vfmsub231ss xmm29, xmm3, dword ptr [rdx - 512]
// CHECK:  encoding: [0x62,0x62,0x65,0x08,0xbb,0x6a,0x80]
          vfmsub231ss xmm29, xmm3, dword ptr [rdx - 512]

// CHECK: vfmsub231ss xmm29, xmm3, dword ptr [rdx - 516]
// CHECK:  encoding: [0x62,0x62,0x65,0x08,0xbb,0xaa,0xfc,0xfd,0xff,0xff]
          vfmsub231ss xmm29, xmm3, dword ptr [rdx - 516]

// CHECK: vfmsubadd132pd zmm21, zmm28, zmm18
// CHECK:  encoding: [0x62,0xa2,0x9d,0x40,0x97,0xea]
          vfmsubadd132pd zmm21, zmm28, zmm18

// CHECK: vfmsubadd132pd zmm21 {k7}, zmm28, zmm18
// CHECK:  encoding: [0x62,0xa2,0x9d,0x47,0x97,0xea]
          vfmsubadd132pd zmm21 {k7}, zmm28, zmm18

// CHECK: vfmsubadd132pd zmm21 {k7} {z}, zmm28, zmm18
// CHECK:  encoding: [0x62,0xa2,0x9d,0xc7,0x97,0xea]
          vfmsubadd132pd zmm21 {k7} {z}, zmm28, zmm18

// CHECK: vfmsubadd132pd zmm21, zmm28, zmm18, {rn-sae}
// CHECK:  encoding: [0x62,0xa2,0x9d,0x10,0x97,0xea]
          vfmsubadd132pd zmm21, zmm28, zmm18, {rn-sae}

// CHECK: vfmsubadd132pd zmm21, zmm28, zmm18, {ru-sae}
// CHECK:  encoding: [0x62,0xa2,0x9d,0x50,0x97,0xea]
          vfmsubadd132pd zmm21, zmm28, zmm18, {ru-sae}

// CHECK: vfmsubadd132pd zmm21, zmm28, zmm18, {rd-sae}
// CHECK:  encoding: [0x62,0xa2,0x9d,0x30,0x97,0xea]
          vfmsubadd132pd zmm21, zmm28, zmm18, {rd-sae}

// CHECK: vfmsubadd132pd zmm21, zmm28, zmm18, {rz-sae}
// CHECK:  encoding: [0x62,0xa2,0x9d,0x70,0x97,0xea]
          vfmsubadd132pd zmm21, zmm28, zmm18, {rz-sae}

// CHECK: vfmsubadd132pd zmm21, zmm28, zmmword ptr [rcx]
// CHECK:  encoding: [0x62,0xe2,0x9d,0x40,0x97,0x29]
          vfmsubadd132pd zmm21, zmm28, zmmword ptr [rcx]

// CHECK: vfmsubadd132pd zmm21, zmm28, zmmword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0xa2,0x9d,0x40,0x97,0xac,0xf0,0x23,0x01,0x00,0x00]
          vfmsubadd132pd zmm21, zmm28, zmmword ptr [rax + 8*r14 + 291]

// CHECK: vfmsubadd132pd zmm21, zmm28, qword ptr [rcx]{1to8}
// CHECK:  encoding: [0x62,0xe2,0x9d,0x50,0x97,0x29]
          vfmsubadd132pd zmm21, zmm28, qword ptr [rcx]{1to8}

// CHECK: vfmsubadd132pd zmm21, zmm28, zmmword ptr [rdx + 8128]
// CHECK:  encoding: [0x62,0xe2,0x9d,0x40,0x97,0x6a,0x7f]
          vfmsubadd132pd zmm21, zmm28, zmmword ptr [rdx + 8128]

// CHECK: vfmsubadd132pd zmm21, zmm28, zmmword ptr [rdx + 8192]
// CHECK:  encoding: [0x62,0xe2,0x9d,0x40,0x97,0xaa,0x00,0x20,0x00,0x00]
          vfmsubadd132pd zmm21, zmm28, zmmword ptr [rdx + 8192]

// CHECK: vfmsubadd132pd zmm21, zmm28, zmmword ptr [rdx - 8192]
// CHECK:  encoding: [0x62,0xe2,0x9d,0x40,0x97,0x6a,0x80]
          vfmsubadd132pd zmm21, zmm28, zmmword ptr [rdx - 8192]

// CHECK: vfmsubadd132pd zmm21, zmm28, zmmword ptr [rdx - 8256]
// CHECK:  encoding: [0x62,0xe2,0x9d,0x40,0x97,0xaa,0xc0,0xdf,0xff,0xff]
          vfmsubadd132pd zmm21, zmm28, zmmword ptr [rdx - 8256]

// CHECK: vfmsubadd132pd zmm21, zmm28, qword ptr [rdx + 1016]{1to8}
// CHECK:  encoding: [0x62,0xe2,0x9d,0x50,0x97,0x6a,0x7f]
          vfmsubadd132pd zmm21, zmm28, qword ptr [rdx + 1016]{1to8}

// CHECK: vfmsubadd132pd zmm21, zmm28, qword ptr [rdx + 1024]{1to8}
// CHECK:  encoding: [0x62,0xe2,0x9d,0x50,0x97,0xaa,0x00,0x04,0x00,0x00]
          vfmsubadd132pd zmm21, zmm28, qword ptr [rdx + 1024]{1to8}

// CHECK: vfmsubadd132pd zmm21, zmm28, qword ptr [rdx - 1024]{1to8}
// CHECK:  encoding: [0x62,0xe2,0x9d,0x50,0x97,0x6a,0x80]
          vfmsubadd132pd zmm21, zmm28, qword ptr [rdx - 1024]{1to8}

// CHECK: vfmsubadd132pd zmm21, zmm28, qword ptr [rdx - 1032]{1to8}
// CHECK:  encoding: [0x62,0xe2,0x9d,0x50,0x97,0xaa,0xf8,0xfb,0xff,0xff]
          vfmsubadd132pd zmm21, zmm28, qword ptr [rdx - 1032]{1to8}

// CHECK: vfmsubadd132ps zmm2, zmm13, zmm21
// CHECK:  encoding: [0x62,0xb2,0x15,0x48,0x97,0xd5]
          vfmsubadd132ps zmm2, zmm13, zmm21

// CHECK: vfmsubadd132ps zmm2 {k7}, zmm13, zmm21
// CHECK:  encoding: [0x62,0xb2,0x15,0x4f,0x97,0xd5]
          vfmsubadd132ps zmm2 {k7}, zmm13, zmm21

// CHECK: vfmsubadd132ps zmm2 {k7} {z}, zmm13, zmm21
// CHECK:  encoding: [0x62,0xb2,0x15,0xcf,0x97,0xd5]
          vfmsubadd132ps zmm2 {k7} {z}, zmm13, zmm21

// CHECK: vfmsubadd132ps zmm2, zmm13, zmm21, {rn-sae}
// CHECK:  encoding: [0x62,0xb2,0x15,0x18,0x97,0xd5]
          vfmsubadd132ps zmm2, zmm13, zmm21, {rn-sae}

// CHECK: vfmsubadd132ps zmm2, zmm13, zmm21, {ru-sae}
// CHECK:  encoding: [0x62,0xb2,0x15,0x58,0x97,0xd5]
          vfmsubadd132ps zmm2, zmm13, zmm21, {ru-sae}

// CHECK: vfmsubadd132ps zmm2, zmm13, zmm21, {rd-sae}
// CHECK:  encoding: [0x62,0xb2,0x15,0x38,0x97,0xd5]
          vfmsubadd132ps zmm2, zmm13, zmm21, {rd-sae}

// CHECK: vfmsubadd132ps zmm2, zmm13, zmm21, {rz-sae}
// CHECK:  encoding: [0x62,0xb2,0x15,0x78,0x97,0xd5]
          vfmsubadd132ps zmm2, zmm13, zmm21, {rz-sae}

// CHECK: vfmsubadd132ps zmm2, zmm13, zmmword ptr [rcx]
// CHECK:  encoding: [0x62,0xf2,0x15,0x48,0x97,0x11]
          vfmsubadd132ps zmm2, zmm13, zmmword ptr [rcx]

// CHECK: vfmsubadd132ps zmm2, zmm13, zmmword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0xb2,0x15,0x48,0x97,0x94,0xf0,0x23,0x01,0x00,0x00]
          vfmsubadd132ps zmm2, zmm13, zmmword ptr [rax + 8*r14 + 291]

// CHECK: vfmsubadd132ps zmm2, zmm13, dword ptr [rcx]{1to16}
// CHECK:  encoding: [0x62,0xf2,0x15,0x58,0x97,0x11]
          vfmsubadd132ps zmm2, zmm13, dword ptr [rcx]{1to16}

// CHECK: vfmsubadd132ps zmm2, zmm13, zmmword ptr [rdx + 8128]
// CHECK:  encoding: [0x62,0xf2,0x15,0x48,0x97,0x52,0x7f]
          vfmsubadd132ps zmm2, zmm13, zmmword ptr [rdx + 8128]

// CHECK: vfmsubadd132ps zmm2, zmm13, zmmword ptr [rdx + 8192]
// CHECK:  encoding: [0x62,0xf2,0x15,0x48,0x97,0x92,0x00,0x20,0x00,0x00]
          vfmsubadd132ps zmm2, zmm13, zmmword ptr [rdx + 8192]

// CHECK: vfmsubadd132ps zmm2, zmm13, zmmword ptr [rdx - 8192]
// CHECK:  encoding: [0x62,0xf2,0x15,0x48,0x97,0x52,0x80]
          vfmsubadd132ps zmm2, zmm13, zmmword ptr [rdx - 8192]

// CHECK: vfmsubadd132ps zmm2, zmm13, zmmword ptr [rdx - 8256]
// CHECK:  encoding: [0x62,0xf2,0x15,0x48,0x97,0x92,0xc0,0xdf,0xff,0xff]
          vfmsubadd132ps zmm2, zmm13, zmmword ptr [rdx - 8256]

// CHECK: vfmsubadd132ps zmm2, zmm13, dword ptr [rdx + 508]{1to16}
// CHECK:  encoding: [0x62,0xf2,0x15,0x58,0x97,0x52,0x7f]
          vfmsubadd132ps zmm2, zmm13, dword ptr [rdx + 508]{1to16}

// CHECK: vfmsubadd132ps zmm2, zmm13, dword ptr [rdx + 512]{1to16}
// CHECK:  encoding: [0x62,0xf2,0x15,0x58,0x97,0x92,0x00,0x02,0x00,0x00]
          vfmsubadd132ps zmm2, zmm13, dword ptr [rdx + 512]{1to16}

// CHECK: vfmsubadd132ps zmm2, zmm13, dword ptr [rdx - 512]{1to16}
// CHECK:  encoding: [0x62,0xf2,0x15,0x58,0x97,0x52,0x80]
          vfmsubadd132ps zmm2, zmm13, dword ptr [rdx - 512]{1to16}

// CHECK: vfmsubadd132ps zmm2, zmm13, dword ptr [rdx - 516]{1to16}
// CHECK:  encoding: [0x62,0xf2,0x15,0x58,0x97,0x92,0xfc,0xfd,0xff,0xff]
          vfmsubadd132ps zmm2, zmm13, dword ptr [rdx - 516]{1to16}

// CHECK: vfmsubadd213pd zmm2, zmm23, zmm2
// CHECK:  encoding: [0x62,0xf2,0xc5,0x40,0xa7,0xd2]
          vfmsubadd213pd zmm2, zmm23, zmm2

// CHECK: vfmsubadd213pd zmm2 {k6}, zmm23, zmm2
// CHECK:  encoding: [0x62,0xf2,0xc5,0x46,0xa7,0xd2]
          vfmsubadd213pd zmm2 {k6}, zmm23, zmm2

// CHECK: vfmsubadd213pd zmm2 {k6} {z}, zmm23, zmm2
// CHECK:  encoding: [0x62,0xf2,0xc5,0xc6,0xa7,0xd2]
          vfmsubadd213pd zmm2 {k6} {z}, zmm23, zmm2

// CHECK: vfmsubadd213pd zmm2, zmm23, zmm2, {rn-sae}
// CHECK:  encoding: [0x62,0xf2,0xc5,0x10,0xa7,0xd2]
          vfmsubadd213pd zmm2, zmm23, zmm2, {rn-sae}

// CHECK: vfmsubadd213pd zmm2, zmm23, zmm2, {ru-sae}
// CHECK:  encoding: [0x62,0xf2,0xc5,0x50,0xa7,0xd2]
          vfmsubadd213pd zmm2, zmm23, zmm2, {ru-sae}

// CHECK: vfmsubadd213pd zmm2, zmm23, zmm2, {rd-sae}
// CHECK:  encoding: [0x62,0xf2,0xc5,0x30,0xa7,0xd2]
          vfmsubadd213pd zmm2, zmm23, zmm2, {rd-sae}

// CHECK: vfmsubadd213pd zmm2, zmm23, zmm2, {rz-sae}
// CHECK:  encoding: [0x62,0xf2,0xc5,0x70,0xa7,0xd2]
          vfmsubadd213pd zmm2, zmm23, zmm2, {rz-sae}

// CHECK: vfmsubadd213pd zmm2, zmm23, zmmword ptr [rcx]
// CHECK:  encoding: [0x62,0xf2,0xc5,0x40,0xa7,0x11]
          vfmsubadd213pd zmm2, zmm23, zmmword ptr [rcx]

// CHECK: vfmsubadd213pd zmm2, zmm23, zmmword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0xb2,0xc5,0x40,0xa7,0x94,0xf0,0x23,0x01,0x00,0x00]
          vfmsubadd213pd zmm2, zmm23, zmmword ptr [rax + 8*r14 + 291]

// CHECK: vfmsubadd213pd zmm2, zmm23, qword ptr [rcx]{1to8}
// CHECK:  encoding: [0x62,0xf2,0xc5,0x50,0xa7,0x11]
          vfmsubadd213pd zmm2, zmm23, qword ptr [rcx]{1to8}

// CHECK: vfmsubadd213pd zmm2, zmm23, zmmword ptr [rdx + 8128]
// CHECK:  encoding: [0x62,0xf2,0xc5,0x40,0xa7,0x52,0x7f]
          vfmsubadd213pd zmm2, zmm23, zmmword ptr [rdx + 8128]

// CHECK: vfmsubadd213pd zmm2, zmm23, zmmword ptr [rdx + 8192]
// CHECK:  encoding: [0x62,0xf2,0xc5,0x40,0xa7,0x92,0x00,0x20,0x00,0x00]
          vfmsubadd213pd zmm2, zmm23, zmmword ptr [rdx + 8192]

// CHECK: vfmsubadd213pd zmm2, zmm23, zmmword ptr [rdx - 8192]
// CHECK:  encoding: [0x62,0xf2,0xc5,0x40,0xa7,0x52,0x80]
          vfmsubadd213pd zmm2, zmm23, zmmword ptr [rdx - 8192]

// CHECK: vfmsubadd213pd zmm2, zmm23, zmmword ptr [rdx - 8256]
// CHECK:  encoding: [0x62,0xf2,0xc5,0x40,0xa7,0x92,0xc0,0xdf,0xff,0xff]
          vfmsubadd213pd zmm2, zmm23, zmmword ptr [rdx - 8256]

// CHECK: vfmsubadd213pd zmm2, zmm23, qword ptr [rdx + 1016]{1to8}
// CHECK:  encoding: [0x62,0xf2,0xc5,0x50,0xa7,0x52,0x7f]
          vfmsubadd213pd zmm2, zmm23, qword ptr [rdx + 1016]{1to8}

// CHECK: vfmsubadd213pd zmm2, zmm23, qword ptr [rdx + 1024]{1to8}
// CHECK:  encoding: [0x62,0xf2,0xc5,0x50,0xa7,0x92,0x00,0x04,0x00,0x00]
          vfmsubadd213pd zmm2, zmm23, qword ptr [rdx + 1024]{1to8}

// CHECK: vfmsubadd213pd zmm2, zmm23, qword ptr [rdx - 1024]{1to8}
// CHECK:  encoding: [0x62,0xf2,0xc5,0x50,0xa7,0x52,0x80]
          vfmsubadd213pd zmm2, zmm23, qword ptr [rdx - 1024]{1to8}

// CHECK: vfmsubadd213pd zmm2, zmm23, qword ptr [rdx - 1032]{1to8}
// CHECK:  encoding: [0x62,0xf2,0xc5,0x50,0xa7,0x92,0xf8,0xfb,0xff,0xff]
          vfmsubadd213pd zmm2, zmm23, qword ptr [rdx - 1032]{1to8}

// CHECK: vfmsubadd213ps zmm22, zmm12, zmm14
// CHECK:  encoding: [0x62,0xc2,0x1d,0x48,0xa7,0xf6]
          vfmsubadd213ps zmm22, zmm12, zmm14

// CHECK: vfmsubadd213ps zmm22 {k6}, zmm12, zmm14
// CHECK:  encoding: [0x62,0xc2,0x1d,0x4e,0xa7,0xf6]
          vfmsubadd213ps zmm22 {k6}, zmm12, zmm14

// CHECK: vfmsubadd213ps zmm22 {k6} {z}, zmm12, zmm14
// CHECK:  encoding: [0x62,0xc2,0x1d,0xce,0xa7,0xf6]
          vfmsubadd213ps zmm22 {k6} {z}, zmm12, zmm14

// CHECK: vfmsubadd213ps zmm22, zmm12, zmm14, {rn-sae}
// CHECK:  encoding: [0x62,0xc2,0x1d,0x18,0xa7,0xf6]
          vfmsubadd213ps zmm22, zmm12, zmm14, {rn-sae}

// CHECK: vfmsubadd213ps zmm22, zmm12, zmm14, {ru-sae}
// CHECK:  encoding: [0x62,0xc2,0x1d,0x58,0xa7,0xf6]
          vfmsubadd213ps zmm22, zmm12, zmm14, {ru-sae}

// CHECK: vfmsubadd213ps zmm22, zmm12, zmm14, {rd-sae}
// CHECK:  encoding: [0x62,0xc2,0x1d,0x38,0xa7,0xf6]
          vfmsubadd213ps zmm22, zmm12, zmm14, {rd-sae}

// CHECK: vfmsubadd213ps zmm22, zmm12, zmm14, {rz-sae}
// CHECK:  encoding: [0x62,0xc2,0x1d,0x78,0xa7,0xf6]
          vfmsubadd213ps zmm22, zmm12, zmm14, {rz-sae}

// CHECK: vfmsubadd213ps zmm22, zmm12, zmmword ptr [rcx]
// CHECK:  encoding: [0x62,0xe2,0x1d,0x48,0xa7,0x31]
          vfmsubadd213ps zmm22, zmm12, zmmword ptr [rcx]

// CHECK: vfmsubadd213ps zmm22, zmm12, zmmword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0xa2,0x1d,0x48,0xa7,0xb4,0xf0,0x23,0x01,0x00,0x00]
          vfmsubadd213ps zmm22, zmm12, zmmword ptr [rax + 8*r14 + 291]

// CHECK: vfmsubadd213ps zmm22, zmm12, dword ptr [rcx]{1to16}
// CHECK:  encoding: [0x62,0xe2,0x1d,0x58,0xa7,0x31]
          vfmsubadd213ps zmm22, zmm12, dword ptr [rcx]{1to16}

// CHECK: vfmsubadd213ps zmm22, zmm12, zmmword ptr [rdx + 8128]
// CHECK:  encoding: [0x62,0xe2,0x1d,0x48,0xa7,0x72,0x7f]
          vfmsubadd213ps zmm22, zmm12, zmmword ptr [rdx + 8128]

// CHECK: vfmsubadd213ps zmm22, zmm12, zmmword ptr [rdx + 8192]
// CHECK:  encoding: [0x62,0xe2,0x1d,0x48,0xa7,0xb2,0x00,0x20,0x00,0x00]
          vfmsubadd213ps zmm22, zmm12, zmmword ptr [rdx + 8192]

// CHECK: vfmsubadd213ps zmm22, zmm12, zmmword ptr [rdx - 8192]
// CHECK:  encoding: [0x62,0xe2,0x1d,0x48,0xa7,0x72,0x80]
          vfmsubadd213ps zmm22, zmm12, zmmword ptr [rdx - 8192]

// CHECK: vfmsubadd213ps zmm22, zmm12, zmmword ptr [rdx - 8256]
// CHECK:  encoding: [0x62,0xe2,0x1d,0x48,0xa7,0xb2,0xc0,0xdf,0xff,0xff]
          vfmsubadd213ps zmm22, zmm12, zmmword ptr [rdx - 8256]

// CHECK: vfmsubadd213ps zmm22, zmm12, dword ptr [rdx + 508]{1to16}
// CHECK:  encoding: [0x62,0xe2,0x1d,0x58,0xa7,0x72,0x7f]
          vfmsubadd213ps zmm22, zmm12, dword ptr [rdx + 508]{1to16}

// CHECK: vfmsubadd213ps zmm22, zmm12, dword ptr [rdx + 512]{1to16}
// CHECK:  encoding: [0x62,0xe2,0x1d,0x58,0xa7,0xb2,0x00,0x02,0x00,0x00]
          vfmsubadd213ps zmm22, zmm12, dword ptr [rdx + 512]{1to16}

// CHECK: vfmsubadd213ps zmm22, zmm12, dword ptr [rdx - 512]{1to16}
// CHECK:  encoding: [0x62,0xe2,0x1d,0x58,0xa7,0x72,0x80]
          vfmsubadd213ps zmm22, zmm12, dword ptr [rdx - 512]{1to16}

// CHECK: vfmsubadd213ps zmm22, zmm12, dword ptr [rdx - 516]{1to16}
// CHECK:  encoding: [0x62,0xe2,0x1d,0x58,0xa7,0xb2,0xfc,0xfd,0xff,0xff]
          vfmsubadd213ps zmm22, zmm12, dword ptr [rdx - 516]{1to16}

// CHECK: vfmsubadd231pd zmm16, zmm27, zmm21
// CHECK:  encoding: [0x62,0xa2,0xa5,0x40,0xb7,0xc5]
          vfmsubadd231pd zmm16, zmm27, zmm21

// CHECK: vfmsubadd231pd zmm16 {k2}, zmm27, zmm21
// CHECK:  encoding: [0x62,0xa2,0xa5,0x42,0xb7,0xc5]
          vfmsubadd231pd zmm16 {k2}, zmm27, zmm21

// CHECK: vfmsubadd231pd zmm16 {k2} {z}, zmm27, zmm21
// CHECK:  encoding: [0x62,0xa2,0xa5,0xc2,0xb7,0xc5]
          vfmsubadd231pd zmm16 {k2} {z}, zmm27, zmm21

// CHECK: vfmsubadd231pd zmm16, zmm27, zmm21, {rn-sae}
// CHECK:  encoding: [0x62,0xa2,0xa5,0x10,0xb7,0xc5]
          vfmsubadd231pd zmm16, zmm27, zmm21, {rn-sae}

// CHECK: vfmsubadd231pd zmm16, zmm27, zmm21, {ru-sae}
// CHECK:  encoding: [0x62,0xa2,0xa5,0x50,0xb7,0xc5]
          vfmsubadd231pd zmm16, zmm27, zmm21, {ru-sae}

// CHECK: vfmsubadd231pd zmm16, zmm27, zmm21, {rd-sae}
// CHECK:  encoding: [0x62,0xa2,0xa5,0x30,0xb7,0xc5]
          vfmsubadd231pd zmm16, zmm27, zmm21, {rd-sae}

// CHECK: vfmsubadd231pd zmm16, zmm27, zmm21, {rz-sae}
// CHECK:  encoding: [0x62,0xa2,0xa5,0x70,0xb7,0xc5]
          vfmsubadd231pd zmm16, zmm27, zmm21, {rz-sae}

// CHECK: vfmsubadd231pd zmm16, zmm27, zmmword ptr [rcx]
// CHECK:  encoding: [0x62,0xe2,0xa5,0x40,0xb7,0x01]
          vfmsubadd231pd zmm16, zmm27, zmmword ptr [rcx]

// CHECK: vfmsubadd231pd zmm16, zmm27, zmmword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0xa2,0xa5,0x40,0xb7,0x84,0xf0,0x23,0x01,0x00,0x00]
          vfmsubadd231pd zmm16, zmm27, zmmword ptr [rax + 8*r14 + 291]

// CHECK: vfmsubadd231pd zmm16, zmm27, qword ptr [rcx]{1to8}
// CHECK:  encoding: [0x62,0xe2,0xa5,0x50,0xb7,0x01]
          vfmsubadd231pd zmm16, zmm27, qword ptr [rcx]{1to8}

// CHECK: vfmsubadd231pd zmm16, zmm27, zmmword ptr [rdx + 8128]
// CHECK:  encoding: [0x62,0xe2,0xa5,0x40,0xb7,0x42,0x7f]
          vfmsubadd231pd zmm16, zmm27, zmmword ptr [rdx + 8128]

// CHECK: vfmsubadd231pd zmm16, zmm27, zmmword ptr [rdx + 8192]
// CHECK:  encoding: [0x62,0xe2,0xa5,0x40,0xb7,0x82,0x00,0x20,0x00,0x00]
          vfmsubadd231pd zmm16, zmm27, zmmword ptr [rdx + 8192]

// CHECK: vfmsubadd231pd zmm16, zmm27, zmmword ptr [rdx - 8192]
// CHECK:  encoding: [0x62,0xe2,0xa5,0x40,0xb7,0x42,0x80]
          vfmsubadd231pd zmm16, zmm27, zmmword ptr [rdx - 8192]

// CHECK: vfmsubadd231pd zmm16, zmm27, zmmword ptr [rdx - 8256]
// CHECK:  encoding: [0x62,0xe2,0xa5,0x40,0xb7,0x82,0xc0,0xdf,0xff,0xff]
          vfmsubadd231pd zmm16, zmm27, zmmword ptr [rdx - 8256]

// CHECK: vfmsubadd231pd zmm16, zmm27, qword ptr [rdx + 1016]{1to8}
// CHECK:  encoding: [0x62,0xe2,0xa5,0x50,0xb7,0x42,0x7f]
          vfmsubadd231pd zmm16, zmm27, qword ptr [rdx + 1016]{1to8}

// CHECK: vfmsubadd231pd zmm16, zmm27, qword ptr [rdx + 1024]{1to8}
// CHECK:  encoding: [0x62,0xe2,0xa5,0x50,0xb7,0x82,0x00,0x04,0x00,0x00]
          vfmsubadd231pd zmm16, zmm27, qword ptr [rdx + 1024]{1to8}

// CHECK: vfmsubadd231pd zmm16, zmm27, qword ptr [rdx - 1024]{1to8}
// CHECK:  encoding: [0x62,0xe2,0xa5,0x50,0xb7,0x42,0x80]
          vfmsubadd231pd zmm16, zmm27, qword ptr [rdx - 1024]{1to8}

// CHECK: vfmsubadd231pd zmm16, zmm27, qword ptr [rdx - 1032]{1to8}
// CHECK:  encoding: [0x62,0xe2,0xa5,0x50,0xb7,0x82,0xf8,0xfb,0xff,0xff]
          vfmsubadd231pd zmm16, zmm27, qword ptr [rdx - 1032]{1to8}

// CHECK: vfmsubadd231ps zmm8, zmm19, zmm1
// CHECK:  encoding: [0x62,0x72,0x65,0x40,0xb7,0xc1]
          vfmsubadd231ps zmm8, zmm19, zmm1

// CHECK: vfmsubadd231ps zmm8 {k2}, zmm19, zmm1
// CHECK:  encoding: [0x62,0x72,0x65,0x42,0xb7,0xc1]
          vfmsubadd231ps zmm8 {k2}, zmm19, zmm1

// CHECK: vfmsubadd231ps zmm8 {k2} {z}, zmm19, zmm1
// CHECK:  encoding: [0x62,0x72,0x65,0xc2,0xb7,0xc1]
          vfmsubadd231ps zmm8 {k2} {z}, zmm19, zmm1

// CHECK: vfmsubadd231ps zmm8, zmm19, zmm1, {rn-sae}
// CHECK:  encoding: [0x62,0x72,0x65,0x10,0xb7,0xc1]
          vfmsubadd231ps zmm8, zmm19, zmm1, {rn-sae}

// CHECK: vfmsubadd231ps zmm8, zmm19, zmm1, {ru-sae}
// CHECK:  encoding: [0x62,0x72,0x65,0x50,0xb7,0xc1]
          vfmsubadd231ps zmm8, zmm19, zmm1, {ru-sae}

// CHECK: vfmsubadd231ps zmm8, zmm19, zmm1, {rd-sae}
// CHECK:  encoding: [0x62,0x72,0x65,0x30,0xb7,0xc1]
          vfmsubadd231ps zmm8, zmm19, zmm1, {rd-sae}

// CHECK: vfmsubadd231ps zmm8, zmm19, zmm1, {rz-sae}
// CHECK:  encoding: [0x62,0x72,0x65,0x70,0xb7,0xc1]
          vfmsubadd231ps zmm8, zmm19, zmm1, {rz-sae}

// CHECK: vfmsubadd231ps zmm8, zmm19, zmmword ptr [rcx]
// CHECK:  encoding: [0x62,0x72,0x65,0x40,0xb7,0x01]
          vfmsubadd231ps zmm8, zmm19, zmmword ptr [rcx]

// CHECK: vfmsubadd231ps zmm8, zmm19, zmmword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0x32,0x65,0x40,0xb7,0x84,0xf0,0x23,0x01,0x00,0x00]
          vfmsubadd231ps zmm8, zmm19, zmmword ptr [rax + 8*r14 + 291]

// CHECK: vfmsubadd231ps zmm8, zmm19, dword ptr [rcx]{1to16}
// CHECK:  encoding: [0x62,0x72,0x65,0x50,0xb7,0x01]
          vfmsubadd231ps zmm8, zmm19, dword ptr [rcx]{1to16}

// CHECK: vfmsubadd231ps zmm8, zmm19, zmmword ptr [rdx + 8128]
// CHECK:  encoding: [0x62,0x72,0x65,0x40,0xb7,0x42,0x7f]
          vfmsubadd231ps zmm8, zmm19, zmmword ptr [rdx + 8128]

// CHECK: vfmsubadd231ps zmm8, zmm19, zmmword ptr [rdx + 8192]
// CHECK:  encoding: [0x62,0x72,0x65,0x40,0xb7,0x82,0x00,0x20,0x00,0x00]
          vfmsubadd231ps zmm8, zmm19, zmmword ptr [rdx + 8192]

// CHECK: vfmsubadd231ps zmm8, zmm19, zmmword ptr [rdx - 8192]
// CHECK:  encoding: [0x62,0x72,0x65,0x40,0xb7,0x42,0x80]
          vfmsubadd231ps zmm8, zmm19, zmmword ptr [rdx - 8192]

// CHECK: vfmsubadd231ps zmm8, zmm19, zmmword ptr [rdx - 8256]
// CHECK:  encoding: [0x62,0x72,0x65,0x40,0xb7,0x82,0xc0,0xdf,0xff,0xff]
          vfmsubadd231ps zmm8, zmm19, zmmword ptr [rdx - 8256]

// CHECK: vfmsubadd231ps zmm8, zmm19, dword ptr [rdx + 508]{1to16}
// CHECK:  encoding: [0x62,0x72,0x65,0x50,0xb7,0x42,0x7f]
          vfmsubadd231ps zmm8, zmm19, dword ptr [rdx + 508]{1to16}

// CHECK: vfmsubadd231ps zmm8, zmm19, dword ptr [rdx + 512]{1to16}
// CHECK:  encoding: [0x62,0x72,0x65,0x50,0xb7,0x82,0x00,0x02,0x00,0x00]
          vfmsubadd231ps zmm8, zmm19, dword ptr [rdx + 512]{1to16}

// CHECK: vfmsubadd231ps zmm8, zmm19, dword ptr [rdx - 512]{1to16}
// CHECK:  encoding: [0x62,0x72,0x65,0x50,0xb7,0x42,0x80]
          vfmsubadd231ps zmm8, zmm19, dword ptr [rdx - 512]{1to16}

// CHECK: vfmsubadd231ps zmm8, zmm19, dword ptr [rdx - 516]{1to16}
// CHECK:  encoding: [0x62,0x72,0x65,0x50,0xb7,0x82,0xfc,0xfd,0xff,0xff]
          vfmsubadd231ps zmm8, zmm19, dword ptr [rdx - 516]{1to16}

// CHECK: vfnmadd132pd zmm12, zmm14, zmm1
// CHECK:  encoding: [0x62,0x72,0x8d,0x48,0x9c,0xe1]
          vfnmadd132pd zmm12, zmm14, zmm1

// CHECK: vfnmadd132pd zmm12 {k7}, zmm14, zmm1
// CHECK:  encoding: [0x62,0x72,0x8d,0x4f,0x9c,0xe1]
          vfnmadd132pd zmm12 {k7}, zmm14, zmm1

// CHECK: vfnmadd132pd zmm12 {k7} {z}, zmm14, zmm1
// CHECK:  encoding: [0x62,0x72,0x8d,0xcf,0x9c,0xe1]
          vfnmadd132pd zmm12 {k7} {z}, zmm14, zmm1

// CHECK: vfnmadd132pd zmm12, zmm14, zmm1, {rn-sae}
// CHECK:  encoding: [0x62,0x72,0x8d,0x18,0x9c,0xe1]
          vfnmadd132pd zmm12, zmm14, zmm1, {rn-sae}

// CHECK: vfnmadd132pd zmm12, zmm14, zmm1, {ru-sae}
// CHECK:  encoding: [0x62,0x72,0x8d,0x58,0x9c,0xe1]
          vfnmadd132pd zmm12, zmm14, zmm1, {ru-sae}

// CHECK: vfnmadd132pd zmm12, zmm14, zmm1, {rd-sae}
// CHECK:  encoding: [0x62,0x72,0x8d,0x38,0x9c,0xe1]
          vfnmadd132pd zmm12, zmm14, zmm1, {rd-sae}

// CHECK: vfnmadd132pd zmm12, zmm14, zmm1, {rz-sae}
// CHECK:  encoding: [0x62,0x72,0x8d,0x78,0x9c,0xe1]
          vfnmadd132pd zmm12, zmm14, zmm1, {rz-sae}

// CHECK: vfnmadd132pd zmm12, zmm14, zmmword ptr [rcx]
// CHECK:  encoding: [0x62,0x72,0x8d,0x48,0x9c,0x21]
          vfnmadd132pd zmm12, zmm14, zmmword ptr [rcx]

// CHECK: vfnmadd132pd zmm12, zmm14, zmmword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0x32,0x8d,0x48,0x9c,0xa4,0xf0,0x23,0x01,0x00,0x00]
          vfnmadd132pd zmm12, zmm14, zmmword ptr [rax + 8*r14 + 291]

// CHECK: vfnmadd132pd zmm12, zmm14, qword ptr [rcx]{1to8}
// CHECK:  encoding: [0x62,0x72,0x8d,0x58,0x9c,0x21]
          vfnmadd132pd zmm12, zmm14, qword ptr [rcx]{1to8}

// CHECK: vfnmadd132pd zmm12, zmm14, zmmword ptr [rdx + 8128]
// CHECK:  encoding: [0x62,0x72,0x8d,0x48,0x9c,0x62,0x7f]
          vfnmadd132pd zmm12, zmm14, zmmword ptr [rdx + 8128]

// CHECK: vfnmadd132pd zmm12, zmm14, zmmword ptr [rdx + 8192]
// CHECK:  encoding: [0x62,0x72,0x8d,0x48,0x9c,0xa2,0x00,0x20,0x00,0x00]
          vfnmadd132pd zmm12, zmm14, zmmword ptr [rdx + 8192]

// CHECK: vfnmadd132pd zmm12, zmm14, zmmword ptr [rdx - 8192]
// CHECK:  encoding: [0x62,0x72,0x8d,0x48,0x9c,0x62,0x80]
          vfnmadd132pd zmm12, zmm14, zmmword ptr [rdx - 8192]

// CHECK: vfnmadd132pd zmm12, zmm14, zmmword ptr [rdx - 8256]
// CHECK:  encoding: [0x62,0x72,0x8d,0x48,0x9c,0xa2,0xc0,0xdf,0xff,0xff]
          vfnmadd132pd zmm12, zmm14, zmmword ptr [rdx - 8256]

// CHECK: vfnmadd132pd zmm12, zmm14, qword ptr [rdx + 1016]{1to8}
// CHECK:  encoding: [0x62,0x72,0x8d,0x58,0x9c,0x62,0x7f]
          vfnmadd132pd zmm12, zmm14, qword ptr [rdx + 1016]{1to8}

// CHECK: vfnmadd132pd zmm12, zmm14, qword ptr [rdx + 1024]{1to8}
// CHECK:  encoding: [0x62,0x72,0x8d,0x58,0x9c,0xa2,0x00,0x04,0x00,0x00]
          vfnmadd132pd zmm12, zmm14, qword ptr [rdx + 1024]{1to8}

// CHECK: vfnmadd132pd zmm12, zmm14, qword ptr [rdx - 1024]{1to8}
// CHECK:  encoding: [0x62,0x72,0x8d,0x58,0x9c,0x62,0x80]
          vfnmadd132pd zmm12, zmm14, qword ptr [rdx - 1024]{1to8}

// CHECK: vfnmadd132pd zmm12, zmm14, qword ptr [rdx - 1032]{1to8}
// CHECK:  encoding: [0x62,0x72,0x8d,0x58,0x9c,0xa2,0xf8,0xfb,0xff,0xff]
          vfnmadd132pd zmm12, zmm14, qword ptr [rdx - 1032]{1to8}

// CHECK: vfnmadd132ps zmm21, zmm16, zmm10
// CHECK:  encoding: [0x62,0xc2,0x7d,0x40,0x9c,0xea]
          vfnmadd132ps zmm21, zmm16, zmm10

// CHECK: vfnmadd132ps zmm21 {k5}, zmm16, zmm10
// CHECK:  encoding: [0x62,0xc2,0x7d,0x45,0x9c,0xea]
          vfnmadd132ps zmm21 {k5}, zmm16, zmm10

// CHECK: vfnmadd132ps zmm21 {k5} {z}, zmm16, zmm10
// CHECK:  encoding: [0x62,0xc2,0x7d,0xc5,0x9c,0xea]
          vfnmadd132ps zmm21 {k5} {z}, zmm16, zmm10

// CHECK: vfnmadd132ps zmm21, zmm16, zmm10, {rn-sae}
// CHECK:  encoding: [0x62,0xc2,0x7d,0x10,0x9c,0xea]
          vfnmadd132ps zmm21, zmm16, zmm10, {rn-sae}

// CHECK: vfnmadd132ps zmm21, zmm16, zmm10, {ru-sae}
// CHECK:  encoding: [0x62,0xc2,0x7d,0x50,0x9c,0xea]
          vfnmadd132ps zmm21, zmm16, zmm10, {ru-sae}

// CHECK: vfnmadd132ps zmm21, zmm16, zmm10, {rd-sae}
// CHECK:  encoding: [0x62,0xc2,0x7d,0x30,0x9c,0xea]
          vfnmadd132ps zmm21, zmm16, zmm10, {rd-sae}

// CHECK: vfnmadd132ps zmm21, zmm16, zmm10, {rz-sae}
// CHECK:  encoding: [0x62,0xc2,0x7d,0x70,0x9c,0xea]
          vfnmadd132ps zmm21, zmm16, zmm10, {rz-sae}

// CHECK: vfnmadd132ps zmm21, zmm16, zmmword ptr [rcx]
// CHECK:  encoding: [0x62,0xe2,0x7d,0x40,0x9c,0x29]
          vfnmadd132ps zmm21, zmm16, zmmword ptr [rcx]

// CHECK: vfnmadd132ps zmm21, zmm16, zmmword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0xa2,0x7d,0x40,0x9c,0xac,0xf0,0x23,0x01,0x00,0x00]
          vfnmadd132ps zmm21, zmm16, zmmword ptr [rax + 8*r14 + 291]

// CHECK: vfnmadd132ps zmm21, zmm16, dword ptr [rcx]{1to16}
// CHECK:  encoding: [0x62,0xe2,0x7d,0x50,0x9c,0x29]
          vfnmadd132ps zmm21, zmm16, dword ptr [rcx]{1to16}

// CHECK: vfnmadd132ps zmm21, zmm16, zmmword ptr [rdx + 8128]
// CHECK:  encoding: [0x62,0xe2,0x7d,0x40,0x9c,0x6a,0x7f]
          vfnmadd132ps zmm21, zmm16, zmmword ptr [rdx + 8128]

// CHECK: vfnmadd132ps zmm21, zmm16, zmmword ptr [rdx + 8192]
// CHECK:  encoding: [0x62,0xe2,0x7d,0x40,0x9c,0xaa,0x00,0x20,0x00,0x00]
          vfnmadd132ps zmm21, zmm16, zmmword ptr [rdx + 8192]

// CHECK: vfnmadd132ps zmm21, zmm16, zmmword ptr [rdx - 8192]
// CHECK:  encoding: [0x62,0xe2,0x7d,0x40,0x9c,0x6a,0x80]
          vfnmadd132ps zmm21, zmm16, zmmword ptr [rdx - 8192]

// CHECK: vfnmadd132ps zmm21, zmm16, zmmword ptr [rdx - 8256]
// CHECK:  encoding: [0x62,0xe2,0x7d,0x40,0x9c,0xaa,0xc0,0xdf,0xff,0xff]
          vfnmadd132ps zmm21, zmm16, zmmword ptr [rdx - 8256]

// CHECK: vfnmadd132ps zmm21, zmm16, dword ptr [rdx + 508]{1to16}
// CHECK:  encoding: [0x62,0xe2,0x7d,0x50,0x9c,0x6a,0x7f]
          vfnmadd132ps zmm21, zmm16, dword ptr [rdx + 508]{1to16}

// CHECK: vfnmadd132ps zmm21, zmm16, dword ptr [rdx + 512]{1to16}
// CHECK:  encoding: [0x62,0xe2,0x7d,0x50,0x9c,0xaa,0x00,0x02,0x00,0x00]
          vfnmadd132ps zmm21, zmm16, dword ptr [rdx + 512]{1to16}

// CHECK: vfnmadd132ps zmm21, zmm16, dword ptr [rdx - 512]{1to16}
// CHECK:  encoding: [0x62,0xe2,0x7d,0x50,0x9c,0x6a,0x80]
          vfnmadd132ps zmm21, zmm16, dword ptr [rdx - 512]{1to16}

// CHECK: vfnmadd132ps zmm21, zmm16, dword ptr [rdx - 516]{1to16}
// CHECK:  encoding: [0x62,0xe2,0x7d,0x50,0x9c,0xaa,0xfc,0xfd,0xff,0xff]
          vfnmadd132ps zmm21, zmm16, dword ptr [rdx - 516]{1to16}

// CHECK: vfnmadd132sd xmm19, xmm3, xmm11
// CHECK:  encoding: [0x62,0xc2,0xe5,0x08,0x9d,0xdb]
          vfnmadd132sd xmm19, xmm3, xmm11

// CHECK: vfnmadd132sd xmm19 {k2}, xmm3, xmm11
// CHECK:  encoding: [0x62,0xc2,0xe5,0x0a,0x9d,0xdb]
          vfnmadd132sd xmm19 {k2}, xmm3, xmm11

// CHECK: vfnmadd132sd xmm19 {k2} {z}, xmm3, xmm11
// CHECK:  encoding: [0x62,0xc2,0xe5,0x8a,0x9d,0xdb]
          vfnmadd132sd xmm19 {k2} {z}, xmm3, xmm11

// CHECK: vfnmadd132sd xmm19, xmm3, xmm11, {rn-sae}
// CHECK:  encoding: [0x62,0xc2,0xe5,0x18,0x9d,0xdb]
          vfnmadd132sd xmm19, xmm3, xmm11, {rn-sae}

// CHECK: vfnmadd132sd xmm19, xmm3, xmm11, {ru-sae}
// CHECK:  encoding: [0x62,0xc2,0xe5,0x58,0x9d,0xdb]
          vfnmadd132sd xmm19, xmm3, xmm11, {ru-sae}

// CHECK: vfnmadd132sd xmm19, xmm3, xmm11, {rd-sae}
// CHECK:  encoding: [0x62,0xc2,0xe5,0x38,0x9d,0xdb]
          vfnmadd132sd xmm19, xmm3, xmm11, {rd-sae}

// CHECK: vfnmadd132sd xmm19, xmm3, xmm11, {rz-sae}
// CHECK:  encoding: [0x62,0xc2,0xe5,0x78,0x9d,0xdb]
          vfnmadd132sd xmm19, xmm3, xmm11, {rz-sae}

// CHECK: vfnmadd132sd xmm19, xmm3, qword ptr [rcx]
// CHECK:  encoding: [0x62,0xe2,0xe5,0x08,0x9d,0x19]
          vfnmadd132sd xmm19, xmm3, qword ptr [rcx]

// CHECK: vfnmadd132sd xmm19, xmm3, qword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0xa2,0xe5,0x08,0x9d,0x9c,0xf0,0x23,0x01,0x00,0x00]
          vfnmadd132sd xmm19, xmm3, qword ptr [rax + 8*r14 + 291]

// CHECK: vfnmadd132sd xmm19, xmm3, qword ptr [rdx + 1016]
// CHECK:  encoding: [0x62,0xe2,0xe5,0x08,0x9d,0x5a,0x7f]
          vfnmadd132sd xmm19, xmm3, qword ptr [rdx + 1016]

// CHECK: vfnmadd132sd xmm19, xmm3, qword ptr [rdx + 1024]
// CHECK:  encoding: [0x62,0xe2,0xe5,0x08,0x9d,0x9a,0x00,0x04,0x00,0x00]
          vfnmadd132sd xmm19, xmm3, qword ptr [rdx + 1024]

// CHECK: vfnmadd132sd xmm19, xmm3, qword ptr [rdx - 1024]
// CHECK:  encoding: [0x62,0xe2,0xe5,0x08,0x9d,0x5a,0x80]
          vfnmadd132sd xmm19, xmm3, qword ptr [rdx - 1024]

// CHECK: vfnmadd132sd xmm19, xmm3, qword ptr [rdx - 1032]
// CHECK:  encoding: [0x62,0xe2,0xe5,0x08,0x9d,0x9a,0xf8,0xfb,0xff,0xff]
          vfnmadd132sd xmm19, xmm3, qword ptr [rdx - 1032]

// CHECK: vfnmadd132ss xmm25, xmm1, xmm23
// CHECK:  encoding: [0x62,0x22,0x75,0x08,0x9d,0xcf]
          vfnmadd132ss xmm25, xmm1, xmm23

// CHECK: vfnmadd132ss xmm25 {k3}, xmm1, xmm23
// CHECK:  encoding: [0x62,0x22,0x75,0x0b,0x9d,0xcf]
          vfnmadd132ss xmm25 {k3}, xmm1, xmm23

// CHECK: vfnmadd132ss xmm25 {k3} {z}, xmm1, xmm23
// CHECK:  encoding: [0x62,0x22,0x75,0x8b,0x9d,0xcf]
          vfnmadd132ss xmm25 {k3} {z}, xmm1, xmm23

// CHECK: vfnmadd132ss xmm25, xmm1, xmm23, {rn-sae}
// CHECK:  encoding: [0x62,0x22,0x75,0x18,0x9d,0xcf]
          vfnmadd132ss xmm25, xmm1, xmm23, {rn-sae}

// CHECK: vfnmadd132ss xmm25, xmm1, xmm23, {ru-sae}
// CHECK:  encoding: [0x62,0x22,0x75,0x58,0x9d,0xcf]
          vfnmadd132ss xmm25, xmm1, xmm23, {ru-sae}

// CHECK: vfnmadd132ss xmm25, xmm1, xmm23, {rd-sae}
// CHECK:  encoding: [0x62,0x22,0x75,0x38,0x9d,0xcf]
          vfnmadd132ss xmm25, xmm1, xmm23, {rd-sae}

// CHECK: vfnmadd132ss xmm25, xmm1, xmm23, {rz-sae}
// CHECK:  encoding: [0x62,0x22,0x75,0x78,0x9d,0xcf]
          vfnmadd132ss xmm25, xmm1, xmm23, {rz-sae}

// CHECK: vfnmadd132ss xmm25, xmm1, dword ptr [rcx]
// CHECK:  encoding: [0x62,0x62,0x75,0x08,0x9d,0x09]
          vfnmadd132ss xmm25, xmm1, dword ptr [rcx]

// CHECK: vfnmadd132ss xmm25, xmm1, dword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0x22,0x75,0x08,0x9d,0x8c,0xf0,0x23,0x01,0x00,0x00]
          vfnmadd132ss xmm25, xmm1, dword ptr [rax + 8*r14 + 291]

// CHECK: vfnmadd132ss xmm25, xmm1, dword ptr [rdx + 508]
// CHECK:  encoding: [0x62,0x62,0x75,0x08,0x9d,0x4a,0x7f]
          vfnmadd132ss xmm25, xmm1, dword ptr [rdx + 508]

// CHECK: vfnmadd132ss xmm25, xmm1, dword ptr [rdx + 512]
// CHECK:  encoding: [0x62,0x62,0x75,0x08,0x9d,0x8a,0x00,0x02,0x00,0x00]
          vfnmadd132ss xmm25, xmm1, dword ptr [rdx + 512]

// CHECK: vfnmadd132ss xmm25, xmm1, dword ptr [rdx - 512]
// CHECK:  encoding: [0x62,0x62,0x75,0x08,0x9d,0x4a,0x80]
          vfnmadd132ss xmm25, xmm1, dword ptr [rdx - 512]

// CHECK: vfnmadd132ss xmm25, xmm1, dword ptr [rdx - 516]
// CHECK:  encoding: [0x62,0x62,0x75,0x08,0x9d,0x8a,0xfc,0xfd,0xff,0xff]
          vfnmadd132ss xmm25, xmm1, dword ptr [rdx - 516]

// CHECK: vfnmadd213pd zmm17, zmm16, zmm9
// CHECK:  encoding: [0x62,0xc2,0xfd,0x40,0xac,0xc9]
          vfnmadd213pd zmm17, zmm16, zmm9

// CHECK: vfnmadd213pd zmm17 {k4}, zmm16, zmm9
// CHECK:  encoding: [0x62,0xc2,0xfd,0x44,0xac,0xc9]
          vfnmadd213pd zmm17 {k4}, zmm16, zmm9

// CHECK: vfnmadd213pd zmm17 {k4} {z}, zmm16, zmm9
// CHECK:  encoding: [0x62,0xc2,0xfd,0xc4,0xac,0xc9]
          vfnmadd213pd zmm17 {k4} {z}, zmm16, zmm9

// CHECK: vfnmadd213pd zmm17, zmm16, zmm9, {rn-sae}
// CHECK:  encoding: [0x62,0xc2,0xfd,0x10,0xac,0xc9]
          vfnmadd213pd zmm17, zmm16, zmm9, {rn-sae}

// CHECK: vfnmadd213pd zmm17, zmm16, zmm9, {ru-sae}
// CHECK:  encoding: [0x62,0xc2,0xfd,0x50,0xac,0xc9]
          vfnmadd213pd zmm17, zmm16, zmm9, {ru-sae}

// CHECK: vfnmadd213pd zmm17, zmm16, zmm9, {rd-sae}
// CHECK:  encoding: [0x62,0xc2,0xfd,0x30,0xac,0xc9]
          vfnmadd213pd zmm17, zmm16, zmm9, {rd-sae}

// CHECK: vfnmadd213pd zmm17, zmm16, zmm9, {rz-sae}
// CHECK:  encoding: [0x62,0xc2,0xfd,0x70,0xac,0xc9]
          vfnmadd213pd zmm17, zmm16, zmm9, {rz-sae}

// CHECK: vfnmadd213pd zmm17, zmm16, zmmword ptr [rcx]
// CHECK:  encoding: [0x62,0xe2,0xfd,0x40,0xac,0x09]
          vfnmadd213pd zmm17, zmm16, zmmword ptr [rcx]

// CHECK: vfnmadd213pd zmm17, zmm16, zmmword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0xa2,0xfd,0x40,0xac,0x8c,0xf0,0x23,0x01,0x00,0x00]
          vfnmadd213pd zmm17, zmm16, zmmword ptr [rax + 8*r14 + 291]

// CHECK: vfnmadd213pd zmm17, zmm16, qword ptr [rcx]{1to8}
// CHECK:  encoding: [0x62,0xe2,0xfd,0x50,0xac,0x09]
          vfnmadd213pd zmm17, zmm16, qword ptr [rcx]{1to8}

// CHECK: vfnmadd213pd zmm17, zmm16, zmmword ptr [rdx + 8128]
// CHECK:  encoding: [0x62,0xe2,0xfd,0x40,0xac,0x4a,0x7f]
          vfnmadd213pd zmm17, zmm16, zmmword ptr [rdx + 8128]

// CHECK: vfnmadd213pd zmm17, zmm16, zmmword ptr [rdx + 8192]
// CHECK:  encoding: [0x62,0xe2,0xfd,0x40,0xac,0x8a,0x00,0x20,0x00,0x00]
          vfnmadd213pd zmm17, zmm16, zmmword ptr [rdx + 8192]

// CHECK: vfnmadd213pd zmm17, zmm16, zmmword ptr [rdx - 8192]
// CHECK:  encoding: [0x62,0xe2,0xfd,0x40,0xac,0x4a,0x80]
          vfnmadd213pd zmm17, zmm16, zmmword ptr [rdx - 8192]

// CHECK: vfnmadd213pd zmm17, zmm16, zmmword ptr [rdx - 8256]
// CHECK:  encoding: [0x62,0xe2,0xfd,0x40,0xac,0x8a,0xc0,0xdf,0xff,0xff]
          vfnmadd213pd zmm17, zmm16, zmmword ptr [rdx - 8256]

// CHECK: vfnmadd213pd zmm17, zmm16, qword ptr [rdx + 1016]{1to8}
// CHECK:  encoding: [0x62,0xe2,0xfd,0x50,0xac,0x4a,0x7f]
          vfnmadd213pd zmm17, zmm16, qword ptr [rdx + 1016]{1to8}

// CHECK: vfnmadd213pd zmm17, zmm16, qword ptr [rdx + 1024]{1to8}
// CHECK:  encoding: [0x62,0xe2,0xfd,0x50,0xac,0x8a,0x00,0x04,0x00,0x00]
          vfnmadd213pd zmm17, zmm16, qword ptr [rdx + 1024]{1to8}

// CHECK: vfnmadd213pd zmm17, zmm16, qword ptr [rdx - 1024]{1to8}
// CHECK:  encoding: [0x62,0xe2,0xfd,0x50,0xac,0x4a,0x80]
          vfnmadd213pd zmm17, zmm16, qword ptr [rdx - 1024]{1to8}

// CHECK: vfnmadd213pd zmm17, zmm16, qword ptr [rdx - 1032]{1to8}
// CHECK:  encoding: [0x62,0xe2,0xfd,0x50,0xac,0x8a,0xf8,0xfb,0xff,0xff]
          vfnmadd213pd zmm17, zmm16, qword ptr [rdx - 1032]{1to8}

// CHECK: vfnmadd213ps zmm26, zmm10, zmm6
// CHECK:  encoding: [0x62,0x62,0x2d,0x48,0xac,0xd6]
          vfnmadd213ps zmm26, zmm10, zmm6

// CHECK: vfnmadd213ps zmm26 {k6}, zmm10, zmm6
// CHECK:  encoding: [0x62,0x62,0x2d,0x4e,0xac,0xd6]
          vfnmadd213ps zmm26 {k6}, zmm10, zmm6

// CHECK: vfnmadd213ps zmm26 {k6} {z}, zmm10, zmm6
// CHECK:  encoding: [0x62,0x62,0x2d,0xce,0xac,0xd6]
          vfnmadd213ps zmm26 {k6} {z}, zmm10, zmm6

// CHECK: vfnmadd213ps zmm26, zmm10, zmm6, {rn-sae}
// CHECK:  encoding: [0x62,0x62,0x2d,0x18,0xac,0xd6]
          vfnmadd213ps zmm26, zmm10, zmm6, {rn-sae}

// CHECK: vfnmadd213ps zmm26, zmm10, zmm6, {ru-sae}
// CHECK:  encoding: [0x62,0x62,0x2d,0x58,0xac,0xd6]
          vfnmadd213ps zmm26, zmm10, zmm6, {ru-sae}

// CHECK: vfnmadd213ps zmm26, zmm10, zmm6, {rd-sae}
// CHECK:  encoding: [0x62,0x62,0x2d,0x38,0xac,0xd6]
          vfnmadd213ps zmm26, zmm10, zmm6, {rd-sae}

// CHECK: vfnmadd213ps zmm26, zmm10, zmm6, {rz-sae}
// CHECK:  encoding: [0x62,0x62,0x2d,0x78,0xac,0xd6]
          vfnmadd213ps zmm26, zmm10, zmm6, {rz-sae}

// CHECK: vfnmadd213ps zmm26, zmm10, zmmword ptr [rcx]
// CHECK:  encoding: [0x62,0x62,0x2d,0x48,0xac,0x11]
          vfnmadd213ps zmm26, zmm10, zmmword ptr [rcx]

// CHECK: vfnmadd213ps zmm26, zmm10, zmmword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0x22,0x2d,0x48,0xac,0x94,0xf0,0x23,0x01,0x00,0x00]
          vfnmadd213ps zmm26, zmm10, zmmword ptr [rax + 8*r14 + 291]

// CHECK: vfnmadd213ps zmm26, zmm10, dword ptr [rcx]{1to16}
// CHECK:  encoding: [0x62,0x62,0x2d,0x58,0xac,0x11]
          vfnmadd213ps zmm26, zmm10, dword ptr [rcx]{1to16}

// CHECK: vfnmadd213ps zmm26, zmm10, zmmword ptr [rdx + 8128]
// CHECK:  encoding: [0x62,0x62,0x2d,0x48,0xac,0x52,0x7f]
          vfnmadd213ps zmm26, zmm10, zmmword ptr [rdx + 8128]

// CHECK: vfnmadd213ps zmm26, zmm10, zmmword ptr [rdx + 8192]
// CHECK:  encoding: [0x62,0x62,0x2d,0x48,0xac,0x92,0x00,0x20,0x00,0x00]
          vfnmadd213ps zmm26, zmm10, zmmword ptr [rdx + 8192]

// CHECK: vfnmadd213ps zmm26, zmm10, zmmword ptr [rdx - 8192]
// CHECK:  encoding: [0x62,0x62,0x2d,0x48,0xac,0x52,0x80]
          vfnmadd213ps zmm26, zmm10, zmmword ptr [rdx - 8192]

// CHECK: vfnmadd213ps zmm26, zmm10, zmmword ptr [rdx - 8256]
// CHECK:  encoding: [0x62,0x62,0x2d,0x48,0xac,0x92,0xc0,0xdf,0xff,0xff]
          vfnmadd213ps zmm26, zmm10, zmmword ptr [rdx - 8256]

// CHECK: vfnmadd213ps zmm26, zmm10, dword ptr [rdx + 508]{1to16}
// CHECK:  encoding: [0x62,0x62,0x2d,0x58,0xac,0x52,0x7f]
          vfnmadd213ps zmm26, zmm10, dword ptr [rdx + 508]{1to16}

// CHECK: vfnmadd213ps zmm26, zmm10, dword ptr [rdx + 512]{1to16}
// CHECK:  encoding: [0x62,0x62,0x2d,0x58,0xac,0x92,0x00,0x02,0x00,0x00]
          vfnmadd213ps zmm26, zmm10, dword ptr [rdx + 512]{1to16}

// CHECK: vfnmadd213ps zmm26, zmm10, dword ptr [rdx - 512]{1to16}
// CHECK:  encoding: [0x62,0x62,0x2d,0x58,0xac,0x52,0x80]
          vfnmadd213ps zmm26, zmm10, dword ptr [rdx - 512]{1to16}

// CHECK: vfnmadd213ps zmm26, zmm10, dword ptr [rdx - 516]{1to16}
// CHECK:  encoding: [0x62,0x62,0x2d,0x58,0xac,0x92,0xfc,0xfd,0xff,0xff]
          vfnmadd213ps zmm26, zmm10, dword ptr [rdx - 516]{1to16}

// CHECK: vfnmadd213sd xmm13, xmm27, xmm2
// CHECK:  encoding: [0x62,0x72,0xa5,0x00,0xad,0xea]
          vfnmadd213sd xmm13, xmm27, xmm2

// CHECK: vfnmadd213sd xmm13 {k7}, xmm27, xmm2
// CHECK:  encoding: [0x62,0x72,0xa5,0x07,0xad,0xea]
          vfnmadd213sd xmm13 {k7}, xmm27, xmm2

// CHECK: vfnmadd213sd xmm13 {k7} {z}, xmm27, xmm2
// CHECK:  encoding: [0x62,0x72,0xa5,0x87,0xad,0xea]
          vfnmadd213sd xmm13 {k7} {z}, xmm27, xmm2

// CHECK: vfnmadd213sd xmm13, xmm27, xmm2, {rn-sae}
// CHECK:  encoding: [0x62,0x72,0xa5,0x10,0xad,0xea]
          vfnmadd213sd xmm13, xmm27, xmm2, {rn-sae}

// CHECK: vfnmadd213sd xmm13, xmm27, xmm2, {ru-sae}
// CHECK:  encoding: [0x62,0x72,0xa5,0x50,0xad,0xea]
          vfnmadd213sd xmm13, xmm27, xmm2, {ru-sae}

// CHECK: vfnmadd213sd xmm13, xmm27, xmm2, {rd-sae}
// CHECK:  encoding: [0x62,0x72,0xa5,0x30,0xad,0xea]
          vfnmadd213sd xmm13, xmm27, xmm2, {rd-sae}

// CHECK: vfnmadd213sd xmm13, xmm27, xmm2, {rz-sae}
// CHECK:  encoding: [0x62,0x72,0xa5,0x70,0xad,0xea]
          vfnmadd213sd xmm13, xmm27, xmm2, {rz-sae}

// CHECK: vfnmadd213sd xmm13, xmm27, qword ptr [rcx]
// CHECK:  encoding: [0x62,0x72,0xa5,0x00,0xad,0x29]
          vfnmadd213sd xmm13, xmm27, qword ptr [rcx]

// CHECK: vfnmadd213sd xmm13, xmm27, qword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0x32,0xa5,0x00,0xad,0xac,0xf0,0x23,0x01,0x00,0x00]
          vfnmadd213sd xmm13, xmm27, qword ptr [rax + 8*r14 + 291]

// CHECK: vfnmadd213sd xmm13, xmm27, qword ptr [rdx + 1016]
// CHECK:  encoding: [0x62,0x72,0xa5,0x00,0xad,0x6a,0x7f]
          vfnmadd213sd xmm13, xmm27, qword ptr [rdx + 1016]

// CHECK: vfnmadd213sd xmm13, xmm27, qword ptr [rdx + 1024]
// CHECK:  encoding: [0x62,0x72,0xa5,0x00,0xad,0xaa,0x00,0x04,0x00,0x00]
          vfnmadd213sd xmm13, xmm27, qword ptr [rdx + 1024]

// CHECK: vfnmadd213sd xmm13, xmm27, qword ptr [rdx - 1024]
// CHECK:  encoding: [0x62,0x72,0xa5,0x00,0xad,0x6a,0x80]
          vfnmadd213sd xmm13, xmm27, qword ptr [rdx - 1024]

// CHECK: vfnmadd213sd xmm13, xmm27, qword ptr [rdx - 1032]
// CHECK:  encoding: [0x62,0x72,0xa5,0x00,0xad,0xaa,0xf8,0xfb,0xff,0xff]
          vfnmadd213sd xmm13, xmm27, qword ptr [rdx - 1032]

// CHECK: vfnmadd213ss xmm29, xmm7, xmm28
// CHECK:  encoding: [0x62,0x02,0x45,0x08,0xad,0xec]
          vfnmadd213ss xmm29, xmm7, xmm28

// CHECK: vfnmadd213ss xmm29 {k2}, xmm7, xmm28
// CHECK:  encoding: [0x62,0x02,0x45,0x0a,0xad,0xec]
          vfnmadd213ss xmm29 {k2}, xmm7, xmm28

// CHECK: vfnmadd213ss xmm29 {k2} {z}, xmm7, xmm28
// CHECK:  encoding: [0x62,0x02,0x45,0x8a,0xad,0xec]
          vfnmadd213ss xmm29 {k2} {z}, xmm7, xmm28

// CHECK: vfnmadd213ss xmm29, xmm7, xmm28, {rn-sae}
// CHECK:  encoding: [0x62,0x02,0x45,0x18,0xad,0xec]
          vfnmadd213ss xmm29, xmm7, xmm28, {rn-sae}

// CHECK: vfnmadd213ss xmm29, xmm7, xmm28, {ru-sae}
// CHECK:  encoding: [0x62,0x02,0x45,0x58,0xad,0xec]
          vfnmadd213ss xmm29, xmm7, xmm28, {ru-sae}

// CHECK: vfnmadd213ss xmm29, xmm7, xmm28, {rd-sae}
// CHECK:  encoding: [0x62,0x02,0x45,0x38,0xad,0xec]
          vfnmadd213ss xmm29, xmm7, xmm28, {rd-sae}

// CHECK: vfnmadd213ss xmm29, xmm7, xmm28, {rz-sae}
// CHECK:  encoding: [0x62,0x02,0x45,0x78,0xad,0xec]
          vfnmadd213ss xmm29, xmm7, xmm28, {rz-sae}

// CHECK: vfnmadd213ss xmm29, xmm7, dword ptr [rcx]
// CHECK:  encoding: [0x62,0x62,0x45,0x08,0xad,0x29]
          vfnmadd213ss xmm29, xmm7, dword ptr [rcx]

// CHECK: vfnmadd213ss xmm29, xmm7, dword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0x22,0x45,0x08,0xad,0xac,0xf0,0x23,0x01,0x00,0x00]
          vfnmadd213ss xmm29, xmm7, dword ptr [rax + 8*r14 + 291]

// CHECK: vfnmadd213ss xmm29, xmm7, dword ptr [rdx + 508]
// CHECK:  encoding: [0x62,0x62,0x45,0x08,0xad,0x6a,0x7f]
          vfnmadd213ss xmm29, xmm7, dword ptr [rdx + 508]

// CHECK: vfnmadd213ss xmm29, xmm7, dword ptr [rdx + 512]
// CHECK:  encoding: [0x62,0x62,0x45,0x08,0xad,0xaa,0x00,0x02,0x00,0x00]
          vfnmadd213ss xmm29, xmm7, dword ptr [rdx + 512]

// CHECK: vfnmadd213ss xmm29, xmm7, dword ptr [rdx - 512]
// CHECK:  encoding: [0x62,0x62,0x45,0x08,0xad,0x6a,0x80]
          vfnmadd213ss xmm29, xmm7, dword ptr [rdx - 512]

// CHECK: vfnmadd213ss xmm29, xmm7, dword ptr [rdx - 516]
// CHECK:  encoding: [0x62,0x62,0x45,0x08,0xad,0xaa,0xfc,0xfd,0xff,0xff]
          vfnmadd213ss xmm29, xmm7, dword ptr [rdx - 516]

// CHECK: vfnmadd231pd zmm12, zmm11, zmm16
// CHECK:  encoding: [0x62,0x32,0xa5,0x48,0xbc,0xe0]
          vfnmadd231pd zmm12, zmm11, zmm16

// CHECK: vfnmadd231pd zmm12 {k6}, zmm11, zmm16
// CHECK:  encoding: [0x62,0x32,0xa5,0x4e,0xbc,0xe0]
          vfnmadd231pd zmm12 {k6}, zmm11, zmm16

// CHECK: vfnmadd231pd zmm12 {k6} {z}, zmm11, zmm16
// CHECK:  encoding: [0x62,0x32,0xa5,0xce,0xbc,0xe0]
          vfnmadd231pd zmm12 {k6} {z}, zmm11, zmm16

// CHECK: vfnmadd231pd zmm12, zmm11, zmm16, {rn-sae}
// CHECK:  encoding: [0x62,0x32,0xa5,0x18,0xbc,0xe0]
          vfnmadd231pd zmm12, zmm11, zmm16, {rn-sae}

// CHECK: vfnmadd231pd zmm12, zmm11, zmm16, {ru-sae}
// CHECK:  encoding: [0x62,0x32,0xa5,0x58,0xbc,0xe0]
          vfnmadd231pd zmm12, zmm11, zmm16, {ru-sae}

// CHECK: vfnmadd231pd zmm12, zmm11, zmm16, {rd-sae}
// CHECK:  encoding: [0x62,0x32,0xa5,0x38,0xbc,0xe0]
          vfnmadd231pd zmm12, zmm11, zmm16, {rd-sae}

// CHECK: vfnmadd231pd zmm12, zmm11, zmm16, {rz-sae}
// CHECK:  encoding: [0x62,0x32,0xa5,0x78,0xbc,0xe0]
          vfnmadd231pd zmm12, zmm11, zmm16, {rz-sae}

// CHECK: vfnmadd231pd zmm12, zmm11, zmmword ptr [rcx]
// CHECK:  encoding: [0x62,0x72,0xa5,0x48,0xbc,0x21]
          vfnmadd231pd zmm12, zmm11, zmmword ptr [rcx]

// CHECK: vfnmadd231pd zmm12, zmm11, zmmword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0x32,0xa5,0x48,0xbc,0xa4,0xf0,0x23,0x01,0x00,0x00]
          vfnmadd231pd zmm12, zmm11, zmmword ptr [rax + 8*r14 + 291]

// CHECK: vfnmadd231pd zmm12, zmm11, qword ptr [rcx]{1to8}
// CHECK:  encoding: [0x62,0x72,0xa5,0x58,0xbc,0x21]
          vfnmadd231pd zmm12, zmm11, qword ptr [rcx]{1to8}

// CHECK: vfnmadd231pd zmm12, zmm11, zmmword ptr [rdx + 8128]
// CHECK:  encoding: [0x62,0x72,0xa5,0x48,0xbc,0x62,0x7f]
          vfnmadd231pd zmm12, zmm11, zmmword ptr [rdx + 8128]

// CHECK: vfnmadd231pd zmm12, zmm11, zmmword ptr [rdx + 8192]
// CHECK:  encoding: [0x62,0x72,0xa5,0x48,0xbc,0xa2,0x00,0x20,0x00,0x00]
          vfnmadd231pd zmm12, zmm11, zmmword ptr [rdx + 8192]

// CHECK: vfnmadd231pd zmm12, zmm11, zmmword ptr [rdx - 8192]
// CHECK:  encoding: [0x62,0x72,0xa5,0x48,0xbc,0x62,0x80]
          vfnmadd231pd zmm12, zmm11, zmmword ptr [rdx - 8192]

// CHECK: vfnmadd231pd zmm12, zmm11, zmmword ptr [rdx - 8256]
// CHECK:  encoding: [0x62,0x72,0xa5,0x48,0xbc,0xa2,0xc0,0xdf,0xff,0xff]
          vfnmadd231pd zmm12, zmm11, zmmword ptr [rdx - 8256]

// CHECK: vfnmadd231pd zmm12, zmm11, qword ptr [rdx + 1016]{1to8}
// CHECK:  encoding: [0x62,0x72,0xa5,0x58,0xbc,0x62,0x7f]
          vfnmadd231pd zmm12, zmm11, qword ptr [rdx + 1016]{1to8}

// CHECK: vfnmadd231pd zmm12, zmm11, qword ptr [rdx + 1024]{1to8}
// CHECK:  encoding: [0x62,0x72,0xa5,0x58,0xbc,0xa2,0x00,0x04,0x00,0x00]
          vfnmadd231pd zmm12, zmm11, qword ptr [rdx + 1024]{1to8}

// CHECK: vfnmadd231pd zmm12, zmm11, qword ptr [rdx - 1024]{1to8}
// CHECK:  encoding: [0x62,0x72,0xa5,0x58,0xbc,0x62,0x80]
          vfnmadd231pd zmm12, zmm11, qword ptr [rdx - 1024]{1to8}

// CHECK: vfnmadd231pd zmm12, zmm11, qword ptr [rdx - 1032]{1to8}
// CHECK:  encoding: [0x62,0x72,0xa5,0x58,0xbc,0xa2,0xf8,0xfb,0xff,0xff]
          vfnmadd231pd zmm12, zmm11, qword ptr [rdx - 1032]{1to8}

// CHECK: vfnmadd231ps zmm14, zmm7, zmm24
// CHECK:  encoding: [0x62,0x12,0x45,0x48,0xbc,0xf0]
          vfnmadd231ps zmm14, zmm7, zmm24

// CHECK: vfnmadd231ps zmm14 {k5}, zmm7, zmm24
// CHECK:  encoding: [0x62,0x12,0x45,0x4d,0xbc,0xf0]
          vfnmadd231ps zmm14 {k5}, zmm7, zmm24

// CHECK: vfnmadd231ps zmm14 {k5} {z}, zmm7, zmm24
// CHECK:  encoding: [0x62,0x12,0x45,0xcd,0xbc,0xf0]
          vfnmadd231ps zmm14 {k5} {z}, zmm7, zmm24

// CHECK: vfnmadd231ps zmm14, zmm7, zmm24, {rn-sae}
// CHECK:  encoding: [0x62,0x12,0x45,0x18,0xbc,0xf0]
          vfnmadd231ps zmm14, zmm7, zmm24, {rn-sae}

// CHECK: vfnmadd231ps zmm14, zmm7, zmm24, {ru-sae}
// CHECK:  encoding: [0x62,0x12,0x45,0x58,0xbc,0xf0]
          vfnmadd231ps zmm14, zmm7, zmm24, {ru-sae}

// CHECK: vfnmadd231ps zmm14, zmm7, zmm24, {rd-sae}
// CHECK:  encoding: [0x62,0x12,0x45,0x38,0xbc,0xf0]
          vfnmadd231ps zmm14, zmm7, zmm24, {rd-sae}

// CHECK: vfnmadd231ps zmm14, zmm7, zmm24, {rz-sae}
// CHECK:  encoding: [0x62,0x12,0x45,0x78,0xbc,0xf0]
          vfnmadd231ps zmm14, zmm7, zmm24, {rz-sae}

// CHECK: vfnmadd231ps zmm14, zmm7, zmmword ptr [rcx]
// CHECK:  encoding: [0x62,0x72,0x45,0x48,0xbc,0x31]
          vfnmadd231ps zmm14, zmm7, zmmword ptr [rcx]

// CHECK: vfnmadd231ps zmm14, zmm7, zmmword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0x32,0x45,0x48,0xbc,0xb4,0xf0,0x23,0x01,0x00,0x00]
          vfnmadd231ps zmm14, zmm7, zmmword ptr [rax + 8*r14 + 291]

// CHECK: vfnmadd231ps zmm14, zmm7, dword ptr [rcx]{1to16}
// CHECK:  encoding: [0x62,0x72,0x45,0x58,0xbc,0x31]
          vfnmadd231ps zmm14, zmm7, dword ptr [rcx]{1to16}

// CHECK: vfnmadd231ps zmm14, zmm7, zmmword ptr [rdx + 8128]
// CHECK:  encoding: [0x62,0x72,0x45,0x48,0xbc,0x72,0x7f]
          vfnmadd231ps zmm14, zmm7, zmmword ptr [rdx + 8128]

// CHECK: vfnmadd231ps zmm14, zmm7, zmmword ptr [rdx + 8192]
// CHECK:  encoding: [0x62,0x72,0x45,0x48,0xbc,0xb2,0x00,0x20,0x00,0x00]
          vfnmadd231ps zmm14, zmm7, zmmword ptr [rdx + 8192]

// CHECK: vfnmadd231ps zmm14, zmm7, zmmword ptr [rdx - 8192]
// CHECK:  encoding: [0x62,0x72,0x45,0x48,0xbc,0x72,0x80]
          vfnmadd231ps zmm14, zmm7, zmmword ptr [rdx - 8192]

// CHECK: vfnmadd231ps zmm14, zmm7, zmmword ptr [rdx - 8256]
// CHECK:  encoding: [0x62,0x72,0x45,0x48,0xbc,0xb2,0xc0,0xdf,0xff,0xff]
          vfnmadd231ps zmm14, zmm7, zmmword ptr [rdx - 8256]

// CHECK: vfnmadd231ps zmm14, zmm7, dword ptr [rdx + 508]{1to16}
// CHECK:  encoding: [0x62,0x72,0x45,0x58,0xbc,0x72,0x7f]
          vfnmadd231ps zmm14, zmm7, dword ptr [rdx + 508]{1to16}

// CHECK: vfnmadd231ps zmm14, zmm7, dword ptr [rdx + 512]{1to16}
// CHECK:  encoding: [0x62,0x72,0x45,0x58,0xbc,0xb2,0x00,0x02,0x00,0x00]
          vfnmadd231ps zmm14, zmm7, dword ptr [rdx + 512]{1to16}

// CHECK: vfnmadd231ps zmm14, zmm7, dword ptr [rdx - 512]{1to16}
// CHECK:  encoding: [0x62,0x72,0x45,0x58,0xbc,0x72,0x80]
          vfnmadd231ps zmm14, zmm7, dword ptr [rdx - 512]{1to16}

// CHECK: vfnmadd231ps zmm14, zmm7, dword ptr [rdx - 516]{1to16}
// CHECK:  encoding: [0x62,0x72,0x45,0x58,0xbc,0xb2,0xfc,0xfd,0xff,0xff]
          vfnmadd231ps zmm14, zmm7, dword ptr [rdx - 516]{1to16}

// CHECK: vfnmadd231sd xmm6, xmm11, xmm18
// CHECK:  encoding: [0x62,0xb2,0xa5,0x08,0xbd,0xf2]
          vfnmadd231sd xmm6, xmm11, xmm18

// CHECK: vfnmadd231sd xmm6 {k3}, xmm11, xmm18
// CHECK:  encoding: [0x62,0xb2,0xa5,0x0b,0xbd,0xf2]
          vfnmadd231sd xmm6 {k3}, xmm11, xmm18

// CHECK: vfnmadd231sd xmm6 {k3} {z}, xmm11, xmm18
// CHECK:  encoding: [0x62,0xb2,0xa5,0x8b,0xbd,0xf2]
          vfnmadd231sd xmm6 {k3} {z}, xmm11, xmm18

// CHECK: vfnmadd231sd xmm6, xmm11, xmm18, {rn-sae}
// CHECK:  encoding: [0x62,0xb2,0xa5,0x18,0xbd,0xf2]
          vfnmadd231sd xmm6, xmm11, xmm18, {rn-sae}

// CHECK: vfnmadd231sd xmm6, xmm11, xmm18, {ru-sae}
// CHECK:  encoding: [0x62,0xb2,0xa5,0x58,0xbd,0xf2]
          vfnmadd231sd xmm6, xmm11, xmm18, {ru-sae}

// CHECK: vfnmadd231sd xmm6, xmm11, xmm18, {rd-sae}
// CHECK:  encoding: [0x62,0xb2,0xa5,0x38,0xbd,0xf2]
          vfnmadd231sd xmm6, xmm11, xmm18, {rd-sae}

// CHECK: vfnmadd231sd xmm6, xmm11, xmm18, {rz-sae}
// CHECK:  encoding: [0x62,0xb2,0xa5,0x78,0xbd,0xf2]
          vfnmadd231sd xmm6, xmm11, xmm18, {rz-sae}

// CHECK: vfnmadd231sd xmm6, xmm11, qword ptr [rcx]
// CHECK:  encoding: [0xc4,0xe2,0xa1,0xbd,0x31]
          vfnmadd231sd xmm6, xmm11, qword ptr [rcx]

// CHECK: vfnmadd231sd xmm6, xmm11, qword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0xc4,0xa2,0xa1,0xbd,0xb4,0xf0,0x23,0x01,0x00,0x00]
          vfnmadd231sd xmm6, xmm11, qword ptr [rax + 8*r14 + 291]

// CHECK: vfnmadd231sd xmm6, xmm11, qword ptr [rdx + 1016]
// CHECK:  encoding: [0xc4,0xe2,0xa1,0xbd,0xb2,0xf8,0x03,0x00,0x00]
          vfnmadd231sd xmm6, xmm11, qword ptr [rdx + 1016]

// CHECK: vfnmadd231sd xmm6, xmm11, qword ptr [rdx + 1024]
// CHECK:  encoding: [0xc4,0xe2,0xa1,0xbd,0xb2,0x00,0x04,0x00,0x00]
          vfnmadd231sd xmm6, xmm11, qword ptr [rdx + 1024]

// CHECK: vfnmadd231sd xmm6, xmm11, qword ptr [rdx - 1024]
// CHECK:  encoding: [0xc4,0xe2,0xa1,0xbd,0xb2,0x00,0xfc,0xff,0xff]
          vfnmadd231sd xmm6, xmm11, qword ptr [rdx - 1024]

// CHECK: vfnmadd231sd xmm6, xmm11, qword ptr [rdx - 1032]
// CHECK:  encoding: [0xc4,0xe2,0xa1,0xbd,0xb2,0xf8,0xfb,0xff,0xff]
          vfnmadd231sd xmm6, xmm11, qword ptr [rdx - 1032]

// CHECK: vfnmadd231ss xmm27, xmm2, xmm17
// CHECK:  encoding: [0x62,0x22,0x6d,0x08,0xbd,0xd9]
          vfnmadd231ss xmm27, xmm2, xmm17

// CHECK: vfnmadd231ss xmm27 {k1}, xmm2, xmm17
// CHECK:  encoding: [0x62,0x22,0x6d,0x09,0xbd,0xd9]
          vfnmadd231ss xmm27 {k1}, xmm2, xmm17

// CHECK: vfnmadd231ss xmm27 {k1} {z}, xmm2, xmm17
// CHECK:  encoding: [0x62,0x22,0x6d,0x89,0xbd,0xd9]
          vfnmadd231ss xmm27 {k1} {z}, xmm2, xmm17

// CHECK: vfnmadd231ss xmm27, xmm2, xmm17, {rn-sae}
// CHECK:  encoding: [0x62,0x22,0x6d,0x18,0xbd,0xd9]
          vfnmadd231ss xmm27, xmm2, xmm17, {rn-sae}

// CHECK: vfnmadd231ss xmm27, xmm2, xmm17, {ru-sae}
// CHECK:  encoding: [0x62,0x22,0x6d,0x58,0xbd,0xd9]
          vfnmadd231ss xmm27, xmm2, xmm17, {ru-sae}

// CHECK: vfnmadd231ss xmm27, xmm2, xmm17, {rd-sae}
// CHECK:  encoding: [0x62,0x22,0x6d,0x38,0xbd,0xd9]
          vfnmadd231ss xmm27, xmm2, xmm17, {rd-sae}

// CHECK: vfnmadd231ss xmm27, xmm2, xmm17, {rz-sae}
// CHECK:  encoding: [0x62,0x22,0x6d,0x78,0xbd,0xd9]
          vfnmadd231ss xmm27, xmm2, xmm17, {rz-sae}

// CHECK: vfnmadd231ss xmm27, xmm2, dword ptr [rcx]
// CHECK:  encoding: [0x62,0x62,0x6d,0x08,0xbd,0x19]
          vfnmadd231ss xmm27, xmm2, dword ptr [rcx]

// CHECK: vfnmadd231ss xmm27, xmm2, dword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0x22,0x6d,0x08,0xbd,0x9c,0xf0,0x23,0x01,0x00,0x00]
          vfnmadd231ss xmm27, xmm2, dword ptr [rax + 8*r14 + 291]

// CHECK: vfnmadd231ss xmm27, xmm2, dword ptr [rdx + 508]
// CHECK:  encoding: [0x62,0x62,0x6d,0x08,0xbd,0x5a,0x7f]
          vfnmadd231ss xmm27, xmm2, dword ptr [rdx + 508]

// CHECK: vfnmadd231ss xmm27, xmm2, dword ptr [rdx + 512]
// CHECK:  encoding: [0x62,0x62,0x6d,0x08,0xbd,0x9a,0x00,0x02,0x00,0x00]
          vfnmadd231ss xmm27, xmm2, dword ptr [rdx + 512]

// CHECK: vfnmadd231ss xmm27, xmm2, dword ptr [rdx - 512]
// CHECK:  encoding: [0x62,0x62,0x6d,0x08,0xbd,0x5a,0x80]
          vfnmadd231ss xmm27, xmm2, dword ptr [rdx - 512]

// CHECK: vfnmadd231ss xmm27, xmm2, dword ptr [rdx - 516]
// CHECK:  encoding: [0x62,0x62,0x6d,0x08,0xbd,0x9a,0xfc,0xfd,0xff,0xff]
          vfnmadd231ss xmm27, xmm2, dword ptr [rdx - 516]

// CHECK: vfnmsub132pd zmm28, zmm5, zmm6
// CHECK:  encoding: [0x62,0x62,0xd5,0x48,0x9e,0xe6]
          vfnmsub132pd zmm28, zmm5, zmm6

// CHECK: vfnmsub132pd zmm28 {k2}, zmm5, zmm6
// CHECK:  encoding: [0x62,0x62,0xd5,0x4a,0x9e,0xe6]
          vfnmsub132pd zmm28 {k2}, zmm5, zmm6

// CHECK: vfnmsub132pd zmm28 {k2} {z}, zmm5, zmm6
// CHECK:  encoding: [0x62,0x62,0xd5,0xca,0x9e,0xe6]
          vfnmsub132pd zmm28 {k2} {z}, zmm5, zmm6

// CHECK: vfnmsub132pd zmm28, zmm5, zmm6, {rn-sae}
// CHECK:  encoding: [0x62,0x62,0xd5,0x18,0x9e,0xe6]
          vfnmsub132pd zmm28, zmm5, zmm6, {rn-sae}

// CHECK: vfnmsub132pd zmm28, zmm5, zmm6, {ru-sae}
// CHECK:  encoding: [0x62,0x62,0xd5,0x58,0x9e,0xe6]
          vfnmsub132pd zmm28, zmm5, zmm6, {ru-sae}

// CHECK: vfnmsub132pd zmm28, zmm5, zmm6, {rd-sae}
// CHECK:  encoding: [0x62,0x62,0xd5,0x38,0x9e,0xe6]
          vfnmsub132pd zmm28, zmm5, zmm6, {rd-sae}

// CHECK: vfnmsub132pd zmm28, zmm5, zmm6, {rz-sae}
// CHECK:  encoding: [0x62,0x62,0xd5,0x78,0x9e,0xe6]
          vfnmsub132pd zmm28, zmm5, zmm6, {rz-sae}

// CHECK: vfnmsub132pd zmm28, zmm5, zmmword ptr [rcx]
// CHECK:  encoding: [0x62,0x62,0xd5,0x48,0x9e,0x21]
          vfnmsub132pd zmm28, zmm5, zmmword ptr [rcx]

// CHECK: vfnmsub132pd zmm28, zmm5, zmmword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0x22,0xd5,0x48,0x9e,0xa4,0xf0,0x23,0x01,0x00,0x00]
          vfnmsub132pd zmm28, zmm5, zmmword ptr [rax + 8*r14 + 291]

// CHECK: vfnmsub132pd zmm28, zmm5, qword ptr [rcx]{1to8}
// CHECK:  encoding: [0x62,0x62,0xd5,0x58,0x9e,0x21]
          vfnmsub132pd zmm28, zmm5, qword ptr [rcx]{1to8}

// CHECK: vfnmsub132pd zmm28, zmm5, zmmword ptr [rdx + 8128]
// CHECK:  encoding: [0x62,0x62,0xd5,0x48,0x9e,0x62,0x7f]
          vfnmsub132pd zmm28, zmm5, zmmword ptr [rdx + 8128]

// CHECK: vfnmsub132pd zmm28, zmm5, zmmword ptr [rdx + 8192]
// CHECK:  encoding: [0x62,0x62,0xd5,0x48,0x9e,0xa2,0x00,0x20,0x00,0x00]
          vfnmsub132pd zmm28, zmm5, zmmword ptr [rdx + 8192]

// CHECK: vfnmsub132pd zmm28, zmm5, zmmword ptr [rdx - 8192]
// CHECK:  encoding: [0x62,0x62,0xd5,0x48,0x9e,0x62,0x80]
          vfnmsub132pd zmm28, zmm5, zmmword ptr [rdx - 8192]

// CHECK: vfnmsub132pd zmm28, zmm5, zmmword ptr [rdx - 8256]
// CHECK:  encoding: [0x62,0x62,0xd5,0x48,0x9e,0xa2,0xc0,0xdf,0xff,0xff]
          vfnmsub132pd zmm28, zmm5, zmmword ptr [rdx - 8256]

// CHECK: vfnmsub132pd zmm28, zmm5, qword ptr [rdx + 1016]{1to8}
// CHECK:  encoding: [0x62,0x62,0xd5,0x58,0x9e,0x62,0x7f]
          vfnmsub132pd zmm28, zmm5, qword ptr [rdx + 1016]{1to8}

// CHECK: vfnmsub132pd zmm28, zmm5, qword ptr [rdx + 1024]{1to8}
// CHECK:  encoding: [0x62,0x62,0xd5,0x58,0x9e,0xa2,0x00,0x04,0x00,0x00]
          vfnmsub132pd zmm28, zmm5, qword ptr [rdx + 1024]{1to8}

// CHECK: vfnmsub132pd zmm28, zmm5, qword ptr [rdx - 1024]{1to8}
// CHECK:  encoding: [0x62,0x62,0xd5,0x58,0x9e,0x62,0x80]
          vfnmsub132pd zmm28, zmm5, qword ptr [rdx - 1024]{1to8}

// CHECK: vfnmsub132pd zmm28, zmm5, qword ptr [rdx - 1032]{1to8}
// CHECK:  encoding: [0x62,0x62,0xd5,0x58,0x9e,0xa2,0xf8,0xfb,0xff,0xff]
          vfnmsub132pd zmm28, zmm5, qword ptr [rdx - 1032]{1to8}

// CHECK: vfnmsub132ps zmm4, zmm18, zmm6
// CHECK:  encoding: [0x62,0xf2,0x6d,0x40,0x9e,0xe6]
          vfnmsub132ps zmm4, zmm18, zmm6

// CHECK: vfnmsub132ps zmm4 {k2}, zmm18, zmm6
// CHECK:  encoding: [0x62,0xf2,0x6d,0x42,0x9e,0xe6]
          vfnmsub132ps zmm4 {k2}, zmm18, zmm6

// CHECK: vfnmsub132ps zmm4 {k2} {z}, zmm18, zmm6
// CHECK:  encoding: [0x62,0xf2,0x6d,0xc2,0x9e,0xe6]
          vfnmsub132ps zmm4 {k2} {z}, zmm18, zmm6

// CHECK: vfnmsub132ps zmm4, zmm18, zmm6, {rn-sae}
// CHECK:  encoding: [0x62,0xf2,0x6d,0x10,0x9e,0xe6]
          vfnmsub132ps zmm4, zmm18, zmm6, {rn-sae}

// CHECK: vfnmsub132ps zmm4, zmm18, zmm6, {ru-sae}
// CHECK:  encoding: [0x62,0xf2,0x6d,0x50,0x9e,0xe6]
          vfnmsub132ps zmm4, zmm18, zmm6, {ru-sae}

// CHECK: vfnmsub132ps zmm4, zmm18, zmm6, {rd-sae}
// CHECK:  encoding: [0x62,0xf2,0x6d,0x30,0x9e,0xe6]
          vfnmsub132ps zmm4, zmm18, zmm6, {rd-sae}

// CHECK: vfnmsub132ps zmm4, zmm18, zmm6, {rz-sae}
// CHECK:  encoding: [0x62,0xf2,0x6d,0x70,0x9e,0xe6]
          vfnmsub132ps zmm4, zmm18, zmm6, {rz-sae}

// CHECK: vfnmsub132ps zmm4, zmm18, zmmword ptr [rcx]
// CHECK:  encoding: [0x62,0xf2,0x6d,0x40,0x9e,0x21]
          vfnmsub132ps zmm4, zmm18, zmmword ptr [rcx]

// CHECK: vfnmsub132ps zmm4, zmm18, zmmword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0xb2,0x6d,0x40,0x9e,0xa4,0xf0,0x23,0x01,0x00,0x00]
          vfnmsub132ps zmm4, zmm18, zmmword ptr [rax + 8*r14 + 291]

// CHECK: vfnmsub132ps zmm4, zmm18, dword ptr [rcx]{1to16}
// CHECK:  encoding: [0x62,0xf2,0x6d,0x50,0x9e,0x21]
          vfnmsub132ps zmm4, zmm18, dword ptr [rcx]{1to16}

// CHECK: vfnmsub132ps zmm4, zmm18, zmmword ptr [rdx + 8128]
// CHECK:  encoding: [0x62,0xf2,0x6d,0x40,0x9e,0x62,0x7f]
          vfnmsub132ps zmm4, zmm18, zmmword ptr [rdx + 8128]

// CHECK: vfnmsub132ps zmm4, zmm18, zmmword ptr [rdx + 8192]
// CHECK:  encoding: [0x62,0xf2,0x6d,0x40,0x9e,0xa2,0x00,0x20,0x00,0x00]
          vfnmsub132ps zmm4, zmm18, zmmword ptr [rdx + 8192]

// CHECK: vfnmsub132ps zmm4, zmm18, zmmword ptr [rdx - 8192]
// CHECK:  encoding: [0x62,0xf2,0x6d,0x40,0x9e,0x62,0x80]
          vfnmsub132ps zmm4, zmm18, zmmword ptr [rdx - 8192]

// CHECK: vfnmsub132ps zmm4, zmm18, zmmword ptr [rdx - 8256]
// CHECK:  encoding: [0x62,0xf2,0x6d,0x40,0x9e,0xa2,0xc0,0xdf,0xff,0xff]
          vfnmsub132ps zmm4, zmm18, zmmword ptr [rdx - 8256]

// CHECK: vfnmsub132ps zmm4, zmm18, dword ptr [rdx + 508]{1to16}
// CHECK:  encoding: [0x62,0xf2,0x6d,0x50,0x9e,0x62,0x7f]
          vfnmsub132ps zmm4, zmm18, dword ptr [rdx + 508]{1to16}

// CHECK: vfnmsub132ps zmm4, zmm18, dword ptr [rdx + 512]{1to16}
// CHECK:  encoding: [0x62,0xf2,0x6d,0x50,0x9e,0xa2,0x00,0x02,0x00,0x00]
          vfnmsub132ps zmm4, zmm18, dword ptr [rdx + 512]{1to16}

// CHECK: vfnmsub132ps zmm4, zmm18, dword ptr [rdx - 512]{1to16}
// CHECK:  encoding: [0x62,0xf2,0x6d,0x50,0x9e,0x62,0x80]
          vfnmsub132ps zmm4, zmm18, dword ptr [rdx - 512]{1to16}

// CHECK: vfnmsub132ps zmm4, zmm18, dword ptr [rdx - 516]{1to16}
// CHECK:  encoding: [0x62,0xf2,0x6d,0x50,0x9e,0xa2,0xfc,0xfd,0xff,0xff]
          vfnmsub132ps zmm4, zmm18, dword ptr [rdx - 516]{1to16}

// CHECK: vfnmsub132sd xmm26, xmm11, xmm13
// CHECK:  encoding: [0x62,0x42,0xa5,0x08,0x9f,0xd5]
          vfnmsub132sd xmm26, xmm11, xmm13

// CHECK: vfnmsub132sd xmm26 {k6}, xmm11, xmm13
// CHECK:  encoding: [0x62,0x42,0xa5,0x0e,0x9f,0xd5]
          vfnmsub132sd xmm26 {k6}, xmm11, xmm13

// CHECK: vfnmsub132sd xmm26 {k6} {z}, xmm11, xmm13
// CHECK:  encoding: [0x62,0x42,0xa5,0x8e,0x9f,0xd5]
          vfnmsub132sd xmm26 {k6} {z}, xmm11, xmm13

// CHECK: vfnmsub132sd xmm26, xmm11, xmm13, {rn-sae}
// CHECK:  encoding: [0x62,0x42,0xa5,0x18,0x9f,0xd5]
          vfnmsub132sd xmm26, xmm11, xmm13, {rn-sae}

// CHECK: vfnmsub132sd xmm26, xmm11, xmm13, {ru-sae}
// CHECK:  encoding: [0x62,0x42,0xa5,0x58,0x9f,0xd5]
          vfnmsub132sd xmm26, xmm11, xmm13, {ru-sae}

// CHECK: vfnmsub132sd xmm26, xmm11, xmm13, {rd-sae}
// CHECK:  encoding: [0x62,0x42,0xa5,0x38,0x9f,0xd5]
          vfnmsub132sd xmm26, xmm11, xmm13, {rd-sae}

// CHECK: vfnmsub132sd xmm26, xmm11, xmm13, {rz-sae}
// CHECK:  encoding: [0x62,0x42,0xa5,0x78,0x9f,0xd5]
          vfnmsub132sd xmm26, xmm11, xmm13, {rz-sae}

// CHECK: vfnmsub132sd xmm26, xmm11, qword ptr [rcx]
// CHECK:  encoding: [0x62,0x62,0xa5,0x08,0x9f,0x11]
          vfnmsub132sd xmm26, xmm11, qword ptr [rcx]

// CHECK: vfnmsub132sd xmm26, xmm11, qword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0x22,0xa5,0x08,0x9f,0x94,0xf0,0x23,0x01,0x00,0x00]
          vfnmsub132sd xmm26, xmm11, qword ptr [rax + 8*r14 + 291]

// CHECK: vfnmsub132sd xmm26, xmm11, qword ptr [rdx + 1016]
// CHECK:  encoding: [0x62,0x62,0xa5,0x08,0x9f,0x52,0x7f]
          vfnmsub132sd xmm26, xmm11, qword ptr [rdx + 1016]

// CHECK: vfnmsub132sd xmm26, xmm11, qword ptr [rdx + 1024]
// CHECK:  encoding: [0x62,0x62,0xa5,0x08,0x9f,0x92,0x00,0x04,0x00,0x00]
          vfnmsub132sd xmm26, xmm11, qword ptr [rdx + 1024]

// CHECK: vfnmsub132sd xmm26, xmm11, qword ptr [rdx - 1024]
// CHECK:  encoding: [0x62,0x62,0xa5,0x08,0x9f,0x52,0x80]
          vfnmsub132sd xmm26, xmm11, qword ptr [rdx - 1024]

// CHECK: vfnmsub132sd xmm26, xmm11, qword ptr [rdx - 1032]
// CHECK:  encoding: [0x62,0x62,0xa5,0x08,0x9f,0x92,0xf8,0xfb,0xff,0xff]
          vfnmsub132sd xmm26, xmm11, qword ptr [rdx - 1032]

// CHECK: vfnmsub132ss xmm23, xmm22, xmm24
// CHECK:  encoding: [0x62,0x82,0x4d,0x00,0x9f,0xf8]
          vfnmsub132ss xmm23, xmm22, xmm24

// CHECK: vfnmsub132ss xmm23 {k6}, xmm22, xmm24
// CHECK:  encoding: [0x62,0x82,0x4d,0x06,0x9f,0xf8]
          vfnmsub132ss xmm23 {k6}, xmm22, xmm24

// CHECK: vfnmsub132ss xmm23 {k6} {z}, xmm22, xmm24
// CHECK:  encoding: [0x62,0x82,0x4d,0x86,0x9f,0xf8]
          vfnmsub132ss xmm23 {k6} {z}, xmm22, xmm24

// CHECK: vfnmsub132ss xmm23, xmm22, xmm24, {rn-sae}
// CHECK:  encoding: [0x62,0x82,0x4d,0x10,0x9f,0xf8]
          vfnmsub132ss xmm23, xmm22, xmm24, {rn-sae}

// CHECK: vfnmsub132ss xmm23, xmm22, xmm24, {ru-sae}
// CHECK:  encoding: [0x62,0x82,0x4d,0x50,0x9f,0xf8]
          vfnmsub132ss xmm23, xmm22, xmm24, {ru-sae}

// CHECK: vfnmsub132ss xmm23, xmm22, xmm24, {rd-sae}
// CHECK:  encoding: [0x62,0x82,0x4d,0x30,0x9f,0xf8]
          vfnmsub132ss xmm23, xmm22, xmm24, {rd-sae}

// CHECK: vfnmsub132ss xmm23, xmm22, xmm24, {rz-sae}
// CHECK:  encoding: [0x62,0x82,0x4d,0x70,0x9f,0xf8]
          vfnmsub132ss xmm23, xmm22, xmm24, {rz-sae}

// CHECK: vfnmsub132ss xmm23, xmm22, dword ptr [rcx]
// CHECK:  encoding: [0x62,0xe2,0x4d,0x00,0x9f,0x39]
          vfnmsub132ss xmm23, xmm22, dword ptr [rcx]

// CHECK: vfnmsub132ss xmm23, xmm22, dword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0xa2,0x4d,0x00,0x9f,0xbc,0xf0,0x23,0x01,0x00,0x00]
          vfnmsub132ss xmm23, xmm22, dword ptr [rax + 8*r14 + 291]

// CHECK: vfnmsub132ss xmm23, xmm22, dword ptr [rdx + 508]
// CHECK:  encoding: [0x62,0xe2,0x4d,0x00,0x9f,0x7a,0x7f]
          vfnmsub132ss xmm23, xmm22, dword ptr [rdx + 508]

// CHECK: vfnmsub132ss xmm23, xmm22, dword ptr [rdx + 512]
// CHECK:  encoding: [0x62,0xe2,0x4d,0x00,0x9f,0xba,0x00,0x02,0x00,0x00]
          vfnmsub132ss xmm23, xmm22, dword ptr [rdx + 512]

// CHECK: vfnmsub132ss xmm23, xmm22, dword ptr [rdx - 512]
// CHECK:  encoding: [0x62,0xe2,0x4d,0x00,0x9f,0x7a,0x80]
          vfnmsub132ss xmm23, xmm22, dword ptr [rdx - 512]

// CHECK: vfnmsub132ss xmm23, xmm22, dword ptr [rdx - 516]
// CHECK:  encoding: [0x62,0xe2,0x4d,0x00,0x9f,0xba,0xfc,0xfd,0xff,0xff]
          vfnmsub132ss xmm23, xmm22, dword ptr [rdx - 516]

// CHECK: vfnmsub213pd zmm23, zmm18, zmm11
// CHECK:  encoding: [0x62,0xc2,0xed,0x40,0xae,0xfb]
          vfnmsub213pd zmm23, zmm18, zmm11

// CHECK: vfnmsub213pd zmm23 {k2}, zmm18, zmm11
// CHECK:  encoding: [0x62,0xc2,0xed,0x42,0xae,0xfb]
          vfnmsub213pd zmm23 {k2}, zmm18, zmm11

// CHECK: vfnmsub213pd zmm23 {k2} {z}, zmm18, zmm11
// CHECK:  encoding: [0x62,0xc2,0xed,0xc2,0xae,0xfb]
          vfnmsub213pd zmm23 {k2} {z}, zmm18, zmm11

// CHECK: vfnmsub213pd zmm23, zmm18, zmm11, {rn-sae}
// CHECK:  encoding: [0x62,0xc2,0xed,0x10,0xae,0xfb]
          vfnmsub213pd zmm23, zmm18, zmm11, {rn-sae}

// CHECK: vfnmsub213pd zmm23, zmm18, zmm11, {ru-sae}
// CHECK:  encoding: [0x62,0xc2,0xed,0x50,0xae,0xfb]
          vfnmsub213pd zmm23, zmm18, zmm11, {ru-sae}

// CHECK: vfnmsub213pd zmm23, zmm18, zmm11, {rd-sae}
// CHECK:  encoding: [0x62,0xc2,0xed,0x30,0xae,0xfb]
          vfnmsub213pd zmm23, zmm18, zmm11, {rd-sae}

// CHECK: vfnmsub213pd zmm23, zmm18, zmm11, {rz-sae}
// CHECK:  encoding: [0x62,0xc2,0xed,0x70,0xae,0xfb]
          vfnmsub213pd zmm23, zmm18, zmm11, {rz-sae}

// CHECK: vfnmsub213pd zmm23, zmm18, zmmword ptr [rcx]
// CHECK:  encoding: [0x62,0xe2,0xed,0x40,0xae,0x39]
          vfnmsub213pd zmm23, zmm18, zmmword ptr [rcx]

// CHECK: vfnmsub213pd zmm23, zmm18, zmmword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0xa2,0xed,0x40,0xae,0xbc,0xf0,0x23,0x01,0x00,0x00]
          vfnmsub213pd zmm23, zmm18, zmmword ptr [rax + 8*r14 + 291]

// CHECK: vfnmsub213pd zmm23, zmm18, qword ptr [rcx]{1to8}
// CHECK:  encoding: [0x62,0xe2,0xed,0x50,0xae,0x39]
          vfnmsub213pd zmm23, zmm18, qword ptr [rcx]{1to8}

// CHECK: vfnmsub213pd zmm23, zmm18, zmmword ptr [rdx + 8128]
// CHECK:  encoding: [0x62,0xe2,0xed,0x40,0xae,0x7a,0x7f]
          vfnmsub213pd zmm23, zmm18, zmmword ptr [rdx + 8128]

// CHECK: vfnmsub213pd zmm23, zmm18, zmmword ptr [rdx + 8192]
// CHECK:  encoding: [0x62,0xe2,0xed,0x40,0xae,0xba,0x00,0x20,0x00,0x00]
          vfnmsub213pd zmm23, zmm18, zmmword ptr [rdx + 8192]

// CHECK: vfnmsub213pd zmm23, zmm18, zmmword ptr [rdx - 8192]
// CHECK:  encoding: [0x62,0xe2,0xed,0x40,0xae,0x7a,0x80]
          vfnmsub213pd zmm23, zmm18, zmmword ptr [rdx - 8192]

// CHECK: vfnmsub213pd zmm23, zmm18, zmmword ptr [rdx - 8256]
// CHECK:  encoding: [0x62,0xe2,0xed,0x40,0xae,0xba,0xc0,0xdf,0xff,0xff]
          vfnmsub213pd zmm23, zmm18, zmmword ptr [rdx - 8256]

// CHECK: vfnmsub213pd zmm23, zmm18, qword ptr [rdx + 1016]{1to8}
// CHECK:  encoding: [0x62,0xe2,0xed,0x50,0xae,0x7a,0x7f]
          vfnmsub213pd zmm23, zmm18, qword ptr [rdx + 1016]{1to8}

// CHECK: vfnmsub213pd zmm23, zmm18, qword ptr [rdx + 1024]{1to8}
// CHECK:  encoding: [0x62,0xe2,0xed,0x50,0xae,0xba,0x00,0x04,0x00,0x00]
          vfnmsub213pd zmm23, zmm18, qword ptr [rdx + 1024]{1to8}

// CHECK: vfnmsub213pd zmm23, zmm18, qword ptr [rdx - 1024]{1to8}
// CHECK:  encoding: [0x62,0xe2,0xed,0x50,0xae,0x7a,0x80]
          vfnmsub213pd zmm23, zmm18, qword ptr [rdx - 1024]{1to8}

// CHECK: vfnmsub213pd zmm23, zmm18, qword ptr [rdx - 1032]{1to8}
// CHECK:  encoding: [0x62,0xe2,0xed,0x50,0xae,0xba,0xf8,0xfb,0xff,0xff]
          vfnmsub213pd zmm23, zmm18, qword ptr [rdx - 1032]{1to8}

// CHECK: vfnmsub213ps zmm21, zmm13, zmm2
// CHECK:  encoding: [0x62,0xe2,0x15,0x48,0xae,0xea]
          vfnmsub213ps zmm21, zmm13, zmm2

// CHECK: vfnmsub213ps zmm21 {k3}, zmm13, zmm2
// CHECK:  encoding: [0x62,0xe2,0x15,0x4b,0xae,0xea]
          vfnmsub213ps zmm21 {k3}, zmm13, zmm2

// CHECK: vfnmsub213ps zmm21 {k3} {z}, zmm13, zmm2
// CHECK:  encoding: [0x62,0xe2,0x15,0xcb,0xae,0xea]
          vfnmsub213ps zmm21 {k3} {z}, zmm13, zmm2

// CHECK: vfnmsub213ps zmm21, zmm13, zmm2, {rn-sae}
// CHECK:  encoding: [0x62,0xe2,0x15,0x18,0xae,0xea]
          vfnmsub213ps zmm21, zmm13, zmm2, {rn-sae}

// CHECK: vfnmsub213ps zmm21, zmm13, zmm2, {ru-sae}
// CHECK:  encoding: [0x62,0xe2,0x15,0x58,0xae,0xea]
          vfnmsub213ps zmm21, zmm13, zmm2, {ru-sae}

// CHECK: vfnmsub213ps zmm21, zmm13, zmm2, {rd-sae}
// CHECK:  encoding: [0x62,0xe2,0x15,0x38,0xae,0xea]
          vfnmsub213ps zmm21, zmm13, zmm2, {rd-sae}

// CHECK: vfnmsub213ps zmm21, zmm13, zmm2, {rz-sae}
// CHECK:  encoding: [0x62,0xe2,0x15,0x78,0xae,0xea]
          vfnmsub213ps zmm21, zmm13, zmm2, {rz-sae}

// CHECK: vfnmsub213ps zmm21, zmm13, zmmword ptr [rcx]
// CHECK:  encoding: [0x62,0xe2,0x15,0x48,0xae,0x29]
          vfnmsub213ps zmm21, zmm13, zmmword ptr [rcx]

// CHECK: vfnmsub213ps zmm21, zmm13, zmmword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0xa2,0x15,0x48,0xae,0xac,0xf0,0x23,0x01,0x00,0x00]
          vfnmsub213ps zmm21, zmm13, zmmword ptr [rax + 8*r14 + 291]

// CHECK: vfnmsub213ps zmm21, zmm13, dword ptr [rcx]{1to16}
// CHECK:  encoding: [0x62,0xe2,0x15,0x58,0xae,0x29]
          vfnmsub213ps zmm21, zmm13, dword ptr [rcx]{1to16}

// CHECK: vfnmsub213ps zmm21, zmm13, zmmword ptr [rdx + 8128]
// CHECK:  encoding: [0x62,0xe2,0x15,0x48,0xae,0x6a,0x7f]
          vfnmsub213ps zmm21, zmm13, zmmword ptr [rdx + 8128]

// CHECK: vfnmsub213ps zmm21, zmm13, zmmword ptr [rdx + 8192]
// CHECK:  encoding: [0x62,0xe2,0x15,0x48,0xae,0xaa,0x00,0x20,0x00,0x00]
          vfnmsub213ps zmm21, zmm13, zmmword ptr [rdx + 8192]

// CHECK: vfnmsub213ps zmm21, zmm13, zmmword ptr [rdx - 8192]
// CHECK:  encoding: [0x62,0xe2,0x15,0x48,0xae,0x6a,0x80]
          vfnmsub213ps zmm21, zmm13, zmmword ptr [rdx - 8192]

// CHECK: vfnmsub213ps zmm21, zmm13, zmmword ptr [rdx - 8256]
// CHECK:  encoding: [0x62,0xe2,0x15,0x48,0xae,0xaa,0xc0,0xdf,0xff,0xff]
          vfnmsub213ps zmm21, zmm13, zmmword ptr [rdx - 8256]

// CHECK: vfnmsub213ps zmm21, zmm13, dword ptr [rdx + 508]{1to16}
// CHECK:  encoding: [0x62,0xe2,0x15,0x58,0xae,0x6a,0x7f]
          vfnmsub213ps zmm21, zmm13, dword ptr [rdx + 508]{1to16}

// CHECK: vfnmsub213ps zmm21, zmm13, dword ptr [rdx + 512]{1to16}
// CHECK:  encoding: [0x62,0xe2,0x15,0x58,0xae,0xaa,0x00,0x02,0x00,0x00]
          vfnmsub213ps zmm21, zmm13, dword ptr [rdx + 512]{1to16}

// CHECK: vfnmsub213ps zmm21, zmm13, dword ptr [rdx - 512]{1to16}
// CHECK:  encoding: [0x62,0xe2,0x15,0x58,0xae,0x6a,0x80]
          vfnmsub213ps zmm21, zmm13, dword ptr [rdx - 512]{1to16}

// CHECK: vfnmsub213ps zmm21, zmm13, dword ptr [rdx - 516]{1to16}
// CHECK:  encoding: [0x62,0xe2,0x15,0x58,0xae,0xaa,0xfc,0xfd,0xff,0xff]
          vfnmsub213ps zmm21, zmm13, dword ptr [rdx - 516]{1to16}

// CHECK: vfnmsub213sd xmm29, xmm23, xmm28
// CHECK:  encoding: [0x62,0x02,0xc5,0x00,0xaf,0xec]
          vfnmsub213sd xmm29, xmm23, xmm28

// CHECK: vfnmsub213sd xmm29 {k3}, xmm23, xmm28
// CHECK:  encoding: [0x62,0x02,0xc5,0x03,0xaf,0xec]
          vfnmsub213sd xmm29 {k3}, xmm23, xmm28

// CHECK: vfnmsub213sd xmm29 {k3} {z}, xmm23, xmm28
// CHECK:  encoding: [0x62,0x02,0xc5,0x83,0xaf,0xec]
          vfnmsub213sd xmm29 {k3} {z}, xmm23, xmm28

// CHECK: vfnmsub213sd xmm29, xmm23, xmm28, {rn-sae}
// CHECK:  encoding: [0x62,0x02,0xc5,0x10,0xaf,0xec]
          vfnmsub213sd xmm29, xmm23, xmm28, {rn-sae}

// CHECK: vfnmsub213sd xmm29, xmm23, xmm28, {ru-sae}
// CHECK:  encoding: [0x62,0x02,0xc5,0x50,0xaf,0xec]
          vfnmsub213sd xmm29, xmm23, xmm28, {ru-sae}

// CHECK: vfnmsub213sd xmm29, xmm23, xmm28, {rd-sae}
// CHECK:  encoding: [0x62,0x02,0xc5,0x30,0xaf,0xec]
          vfnmsub213sd xmm29, xmm23, xmm28, {rd-sae}

// CHECK: vfnmsub213sd xmm29, xmm23, xmm28, {rz-sae}
// CHECK:  encoding: [0x62,0x02,0xc5,0x70,0xaf,0xec]
          vfnmsub213sd xmm29, xmm23, xmm28, {rz-sae}

// CHECK: vfnmsub213sd xmm29, xmm23, qword ptr [rcx]
// CHECK:  encoding: [0x62,0x62,0xc5,0x00,0xaf,0x29]
          vfnmsub213sd xmm29, xmm23, qword ptr [rcx]

// CHECK: vfnmsub213sd xmm29, xmm23, qword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0x22,0xc5,0x00,0xaf,0xac,0xf0,0x23,0x01,0x00,0x00]
          vfnmsub213sd xmm29, xmm23, qword ptr [rax + 8*r14 + 291]

// CHECK: vfnmsub213sd xmm29, xmm23, qword ptr [rdx + 1016]
// CHECK:  encoding: [0x62,0x62,0xc5,0x00,0xaf,0x6a,0x7f]
          vfnmsub213sd xmm29, xmm23, qword ptr [rdx + 1016]

// CHECK: vfnmsub213sd xmm29, xmm23, qword ptr [rdx + 1024]
// CHECK:  encoding: [0x62,0x62,0xc5,0x00,0xaf,0xaa,0x00,0x04,0x00,0x00]
          vfnmsub213sd xmm29, xmm23, qword ptr [rdx + 1024]

// CHECK: vfnmsub213sd xmm29, xmm23, qword ptr [rdx - 1024]
// CHECK:  encoding: [0x62,0x62,0xc5,0x00,0xaf,0x6a,0x80]
          vfnmsub213sd xmm29, xmm23, qword ptr [rdx - 1024]

// CHECK: vfnmsub213sd xmm29, xmm23, qword ptr [rdx - 1032]
// CHECK:  encoding: [0x62,0x62,0xc5,0x00,0xaf,0xaa,0xf8,0xfb,0xff,0xff]
          vfnmsub213sd xmm29, xmm23, qword ptr [rdx - 1032]

// CHECK: vfnmsub213ss xmm14, xmm28, xmm12
// CHECK:  encoding: [0x62,0x52,0x1d,0x00,0xaf,0xf4]
          vfnmsub213ss xmm14, xmm28, xmm12

// CHECK: vfnmsub213ss xmm14 {k4}, xmm28, xmm12
// CHECK:  encoding: [0x62,0x52,0x1d,0x04,0xaf,0xf4]
          vfnmsub213ss xmm14 {k4}, xmm28, xmm12

// CHECK: vfnmsub213ss xmm14 {k4} {z}, xmm28, xmm12
// CHECK:  encoding: [0x62,0x52,0x1d,0x84,0xaf,0xf4]
          vfnmsub213ss xmm14 {k4} {z}, xmm28, xmm12

// CHECK: vfnmsub213ss xmm14, xmm28, xmm12, {rn-sae}
// CHECK:  encoding: [0x62,0x52,0x1d,0x10,0xaf,0xf4]
          vfnmsub213ss xmm14, xmm28, xmm12, {rn-sae}

// CHECK: vfnmsub213ss xmm14, xmm28, xmm12, {ru-sae}
// CHECK:  encoding: [0x62,0x52,0x1d,0x50,0xaf,0xf4]
          vfnmsub213ss xmm14, xmm28, xmm12, {ru-sae}

// CHECK: vfnmsub213ss xmm14, xmm28, xmm12, {rd-sae}
// CHECK:  encoding: [0x62,0x52,0x1d,0x30,0xaf,0xf4]
          vfnmsub213ss xmm14, xmm28, xmm12, {rd-sae}

// CHECK: vfnmsub213ss xmm14, xmm28, xmm12, {rz-sae}
// CHECK:  encoding: [0x62,0x52,0x1d,0x70,0xaf,0xf4]
          vfnmsub213ss xmm14, xmm28, xmm12, {rz-sae}

// CHECK: vfnmsub213ss xmm14, xmm28, dword ptr [rcx]
// CHECK:  encoding: [0x62,0x72,0x1d,0x00,0xaf,0x31]
          vfnmsub213ss xmm14, xmm28, dword ptr [rcx]

// CHECK: vfnmsub213ss xmm14, xmm28, dword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0x32,0x1d,0x00,0xaf,0xb4,0xf0,0x23,0x01,0x00,0x00]
          vfnmsub213ss xmm14, xmm28, dword ptr [rax + 8*r14 + 291]

// CHECK: vfnmsub213ss xmm14, xmm28, dword ptr [rdx + 508]
// CHECK:  encoding: [0x62,0x72,0x1d,0x00,0xaf,0x72,0x7f]
          vfnmsub213ss xmm14, xmm28, dword ptr [rdx + 508]

// CHECK: vfnmsub213ss xmm14, xmm28, dword ptr [rdx + 512]
// CHECK:  encoding: [0x62,0x72,0x1d,0x00,0xaf,0xb2,0x00,0x02,0x00,0x00]
          vfnmsub213ss xmm14, xmm28, dword ptr [rdx + 512]

// CHECK: vfnmsub213ss xmm14, xmm28, dword ptr [rdx - 512]
// CHECK:  encoding: [0x62,0x72,0x1d,0x00,0xaf,0x72,0x80]
          vfnmsub213ss xmm14, xmm28, dword ptr [rdx - 512]

// CHECK: vfnmsub213ss xmm14, xmm28, dword ptr [rdx - 516]
// CHECK:  encoding: [0x62,0x72,0x1d,0x00,0xaf,0xb2,0xfc,0xfd,0xff,0xff]
          vfnmsub213ss xmm14, xmm28, dword ptr [rdx - 516]

// CHECK: vfnmsub231pd zmm29, zmm4, zmm24
// CHECK:  encoding: [0x62,0x02,0xdd,0x48,0xbe,0xe8]
          vfnmsub231pd zmm29, zmm4, zmm24

// CHECK: vfnmsub231pd zmm29 {k7}, zmm4, zmm24
// CHECK:  encoding: [0x62,0x02,0xdd,0x4f,0xbe,0xe8]
          vfnmsub231pd zmm29 {k7}, zmm4, zmm24

// CHECK: vfnmsub231pd zmm29 {k7} {z}, zmm4, zmm24
// CHECK:  encoding: [0x62,0x02,0xdd,0xcf,0xbe,0xe8]
          vfnmsub231pd zmm29 {k7} {z}, zmm4, zmm24

// CHECK: vfnmsub231pd zmm29, zmm4, zmm24, {rn-sae}
// CHECK:  encoding: [0x62,0x02,0xdd,0x18,0xbe,0xe8]
          vfnmsub231pd zmm29, zmm4, zmm24, {rn-sae}

// CHECK: vfnmsub231pd zmm29, zmm4, zmm24, {ru-sae}
// CHECK:  encoding: [0x62,0x02,0xdd,0x58,0xbe,0xe8]
          vfnmsub231pd zmm29, zmm4, zmm24, {ru-sae}

// CHECK: vfnmsub231pd zmm29, zmm4, zmm24, {rd-sae}
// CHECK:  encoding: [0x62,0x02,0xdd,0x38,0xbe,0xe8]
          vfnmsub231pd zmm29, zmm4, zmm24, {rd-sae}

// CHECK: vfnmsub231pd zmm29, zmm4, zmm24, {rz-sae}
// CHECK:  encoding: [0x62,0x02,0xdd,0x78,0xbe,0xe8]
          vfnmsub231pd zmm29, zmm4, zmm24, {rz-sae}

// CHECK: vfnmsub231pd zmm29, zmm4, zmmword ptr [rcx]
// CHECK:  encoding: [0x62,0x62,0xdd,0x48,0xbe,0x29]
          vfnmsub231pd zmm29, zmm4, zmmword ptr [rcx]

// CHECK: vfnmsub231pd zmm29, zmm4, zmmword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0x22,0xdd,0x48,0xbe,0xac,0xf0,0x23,0x01,0x00,0x00]
          vfnmsub231pd zmm29, zmm4, zmmword ptr [rax + 8*r14 + 291]

// CHECK: vfnmsub231pd zmm29, zmm4, qword ptr [rcx]{1to8}
// CHECK:  encoding: [0x62,0x62,0xdd,0x58,0xbe,0x29]
          vfnmsub231pd zmm29, zmm4, qword ptr [rcx]{1to8}

// CHECK: vfnmsub231pd zmm29, zmm4, zmmword ptr [rdx + 8128]
// CHECK:  encoding: [0x62,0x62,0xdd,0x48,0xbe,0x6a,0x7f]
          vfnmsub231pd zmm29, zmm4, zmmword ptr [rdx + 8128]

// CHECK: vfnmsub231pd zmm29, zmm4, zmmword ptr [rdx + 8192]
// CHECK:  encoding: [0x62,0x62,0xdd,0x48,0xbe,0xaa,0x00,0x20,0x00,0x00]
          vfnmsub231pd zmm29, zmm4, zmmword ptr [rdx + 8192]

// CHECK: vfnmsub231pd zmm29, zmm4, zmmword ptr [rdx - 8192]
// CHECK:  encoding: [0x62,0x62,0xdd,0x48,0xbe,0x6a,0x80]
          vfnmsub231pd zmm29, zmm4, zmmword ptr [rdx - 8192]

// CHECK: vfnmsub231pd zmm29, zmm4, zmmword ptr [rdx - 8256]
// CHECK:  encoding: [0x62,0x62,0xdd,0x48,0xbe,0xaa,0xc0,0xdf,0xff,0xff]
          vfnmsub231pd zmm29, zmm4, zmmword ptr [rdx - 8256]

// CHECK: vfnmsub231pd zmm29, zmm4, qword ptr [rdx + 1016]{1to8}
// CHECK:  encoding: [0x62,0x62,0xdd,0x58,0xbe,0x6a,0x7f]
          vfnmsub231pd zmm29, zmm4, qword ptr [rdx + 1016]{1to8}

// CHECK: vfnmsub231pd zmm29, zmm4, qword ptr [rdx + 1024]{1to8}
// CHECK:  encoding: [0x62,0x62,0xdd,0x58,0xbe,0xaa,0x00,0x04,0x00,0x00]
          vfnmsub231pd zmm29, zmm4, qword ptr [rdx + 1024]{1to8}

// CHECK: vfnmsub231pd zmm29, zmm4, qword ptr [rdx - 1024]{1to8}
// CHECK:  encoding: [0x62,0x62,0xdd,0x58,0xbe,0x6a,0x80]
          vfnmsub231pd zmm29, zmm4, qword ptr [rdx - 1024]{1to8}

// CHECK: vfnmsub231pd zmm29, zmm4, qword ptr [rdx - 1032]{1to8}
// CHECK:  encoding: [0x62,0x62,0xdd,0x58,0xbe,0xaa,0xf8,0xfb,0xff,0xff]
          vfnmsub231pd zmm29, zmm4, qword ptr [rdx - 1032]{1to8}

// CHECK: vfnmsub231ps zmm8, zmm6, zmm13
// CHECK:  encoding: [0x62,0x52,0x4d,0x48,0xbe,0xc5]
          vfnmsub231ps zmm8, zmm6, zmm13

// CHECK: vfnmsub231ps zmm8 {k2}, zmm6, zmm13
// CHECK:  encoding: [0x62,0x52,0x4d,0x4a,0xbe,0xc5]
          vfnmsub231ps zmm8 {k2}, zmm6, zmm13

// CHECK: vfnmsub231ps zmm8 {k2} {z}, zmm6, zmm13
// CHECK:  encoding: [0x62,0x52,0x4d,0xca,0xbe,0xc5]
          vfnmsub231ps zmm8 {k2} {z}, zmm6, zmm13

// CHECK: vfnmsub231ps zmm8, zmm6, zmm13, {rn-sae}
// CHECK:  encoding: [0x62,0x52,0x4d,0x18,0xbe,0xc5]
          vfnmsub231ps zmm8, zmm6, zmm13, {rn-sae}

// CHECK: vfnmsub231ps zmm8, zmm6, zmm13, {ru-sae}
// CHECK:  encoding: [0x62,0x52,0x4d,0x58,0xbe,0xc5]
          vfnmsub231ps zmm8, zmm6, zmm13, {ru-sae}

// CHECK: vfnmsub231ps zmm8, zmm6, zmm13, {rd-sae}
// CHECK:  encoding: [0x62,0x52,0x4d,0x38,0xbe,0xc5]
          vfnmsub231ps zmm8, zmm6, zmm13, {rd-sae}

// CHECK: vfnmsub231ps zmm8, zmm6, zmm13, {rz-sae}
// CHECK:  encoding: [0x62,0x52,0x4d,0x78,0xbe,0xc5]
          vfnmsub231ps zmm8, zmm6, zmm13, {rz-sae}

// CHECK: vfnmsub231ps zmm8, zmm6, zmmword ptr [rcx]
// CHECK:  encoding: [0x62,0x72,0x4d,0x48,0xbe,0x01]
          vfnmsub231ps zmm8, zmm6, zmmword ptr [rcx]

// CHECK: vfnmsub231ps zmm8, zmm6, zmmword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0x32,0x4d,0x48,0xbe,0x84,0xf0,0x23,0x01,0x00,0x00]
          vfnmsub231ps zmm8, zmm6, zmmword ptr [rax + 8*r14 + 291]

// CHECK: vfnmsub231ps zmm8, zmm6, dword ptr [rcx]{1to16}
// CHECK:  encoding: [0x62,0x72,0x4d,0x58,0xbe,0x01]
          vfnmsub231ps zmm8, zmm6, dword ptr [rcx]{1to16}

// CHECK: vfnmsub231ps zmm8, zmm6, zmmword ptr [rdx + 8128]
// CHECK:  encoding: [0x62,0x72,0x4d,0x48,0xbe,0x42,0x7f]
          vfnmsub231ps zmm8, zmm6, zmmword ptr [rdx + 8128]

// CHECK: vfnmsub231ps zmm8, zmm6, zmmword ptr [rdx + 8192]
// CHECK:  encoding: [0x62,0x72,0x4d,0x48,0xbe,0x82,0x00,0x20,0x00,0x00]
          vfnmsub231ps zmm8, zmm6, zmmword ptr [rdx + 8192]

// CHECK: vfnmsub231ps zmm8, zmm6, zmmword ptr [rdx - 8192]
// CHECK:  encoding: [0x62,0x72,0x4d,0x48,0xbe,0x42,0x80]
          vfnmsub231ps zmm8, zmm6, zmmword ptr [rdx - 8192]

// CHECK: vfnmsub231ps zmm8, zmm6, zmmword ptr [rdx - 8256]
// CHECK:  encoding: [0x62,0x72,0x4d,0x48,0xbe,0x82,0xc0,0xdf,0xff,0xff]
          vfnmsub231ps zmm8, zmm6, zmmword ptr [rdx - 8256]

// CHECK: vfnmsub231ps zmm8, zmm6, dword ptr [rdx + 508]{1to16}
// CHECK:  encoding: [0x62,0x72,0x4d,0x58,0xbe,0x42,0x7f]
          vfnmsub231ps zmm8, zmm6, dword ptr [rdx + 508]{1to16}

// CHECK: vfnmsub231ps zmm8, zmm6, dword ptr [rdx + 512]{1to16}
// CHECK:  encoding: [0x62,0x72,0x4d,0x58,0xbe,0x82,0x00,0x02,0x00,0x00]
          vfnmsub231ps zmm8, zmm6, dword ptr [rdx + 512]{1to16}

// CHECK: vfnmsub231ps zmm8, zmm6, dword ptr [rdx - 512]{1to16}
// CHECK:  encoding: [0x62,0x72,0x4d,0x58,0xbe,0x42,0x80]
          vfnmsub231ps zmm8, zmm6, dword ptr [rdx - 512]{1to16}

// CHECK: vfnmsub231ps zmm8, zmm6, dword ptr [rdx - 516]{1to16}
// CHECK:  encoding: [0x62,0x72,0x4d,0x58,0xbe,0x82,0xfc,0xfd,0xff,0xff]
          vfnmsub231ps zmm8, zmm6, dword ptr [rdx - 516]{1to16}

// CHECK: vfnmsub231sd xmm6, xmm20, xmm14
// CHECK:  encoding: [0x62,0xd2,0xdd,0x00,0xbf,0xf6]
          vfnmsub231sd xmm6, xmm20, xmm14

// CHECK: vfnmsub231sd xmm6 {k1}, xmm20, xmm14
// CHECK:  encoding: [0x62,0xd2,0xdd,0x01,0xbf,0xf6]
          vfnmsub231sd xmm6 {k1}, xmm20, xmm14

// CHECK: vfnmsub231sd xmm6 {k1} {z}, xmm20, xmm14
// CHECK:  encoding: [0x62,0xd2,0xdd,0x81,0xbf,0xf6]
          vfnmsub231sd xmm6 {k1} {z}, xmm20, xmm14

// CHECK: vfnmsub231sd xmm6, xmm20, xmm14, {rn-sae}
// CHECK:  encoding: [0x62,0xd2,0xdd,0x10,0xbf,0xf6]
          vfnmsub231sd xmm6, xmm20, xmm14, {rn-sae}

// CHECK: vfnmsub231sd xmm6, xmm20, xmm14, {ru-sae}
// CHECK:  encoding: [0x62,0xd2,0xdd,0x50,0xbf,0xf6]
          vfnmsub231sd xmm6, xmm20, xmm14, {ru-sae}

// CHECK: vfnmsub231sd xmm6, xmm20, xmm14, {rd-sae}
// CHECK:  encoding: [0x62,0xd2,0xdd,0x30,0xbf,0xf6]
          vfnmsub231sd xmm6, xmm20, xmm14, {rd-sae}

// CHECK: vfnmsub231sd xmm6, xmm20, xmm14, {rz-sae}
// CHECK:  encoding: [0x62,0xd2,0xdd,0x70,0xbf,0xf6]
          vfnmsub231sd xmm6, xmm20, xmm14, {rz-sae}

// CHECK: vfnmsub231sd xmm6, xmm20, qword ptr [rcx]
// CHECK:  encoding: [0x62,0xf2,0xdd,0x00,0xbf,0x31]
          vfnmsub231sd xmm6, xmm20, qword ptr [rcx]

// CHECK: vfnmsub231sd xmm6, xmm20, qword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0xb2,0xdd,0x00,0xbf,0xb4,0xf0,0x23,0x01,0x00,0x00]
          vfnmsub231sd xmm6, xmm20, qword ptr [rax + 8*r14 + 291]

// CHECK: vfnmsub231sd xmm6, xmm20, qword ptr [rdx + 1016]
// CHECK:  encoding: [0x62,0xf2,0xdd,0x00,0xbf,0x72,0x7f]
          vfnmsub231sd xmm6, xmm20, qword ptr [rdx + 1016]

// CHECK: vfnmsub231sd xmm6, xmm20, qword ptr [rdx + 1024]
// CHECK:  encoding: [0x62,0xf2,0xdd,0x00,0xbf,0xb2,0x00,0x04,0x00,0x00]
          vfnmsub231sd xmm6, xmm20, qword ptr [rdx + 1024]

// CHECK: vfnmsub231sd xmm6, xmm20, qword ptr [rdx - 1024]
// CHECK:  encoding: [0x62,0xf2,0xdd,0x00,0xbf,0x72,0x80]
          vfnmsub231sd xmm6, xmm20, qword ptr [rdx - 1024]

// CHECK: vfnmsub231sd xmm6, xmm20, qword ptr [rdx - 1032]
// CHECK:  encoding: [0x62,0xf2,0xdd,0x00,0xbf,0xb2,0xf8,0xfb,0xff,0xff]
          vfnmsub231sd xmm6, xmm20, qword ptr [rdx - 1032]

// CHECK: vfnmsub231ss xmm26, xmm13, xmm10
// CHECK:  encoding: [0x62,0x42,0x15,0x08,0xbf,0xd2]
          vfnmsub231ss xmm26, xmm13, xmm10

// CHECK: vfnmsub231ss xmm26 {k4}, xmm13, xmm10
// CHECK:  encoding: [0x62,0x42,0x15,0x0c,0xbf,0xd2]
          vfnmsub231ss xmm26 {k4}, xmm13, xmm10

// CHECK: vfnmsub231ss xmm26 {k4} {z}, xmm13, xmm10
// CHECK:  encoding: [0x62,0x42,0x15,0x8c,0xbf,0xd2]
          vfnmsub231ss xmm26 {k4} {z}, xmm13, xmm10

// CHECK: vfnmsub231ss xmm26, xmm13, xmm10, {rn-sae}
// CHECK:  encoding: [0x62,0x42,0x15,0x18,0xbf,0xd2]
          vfnmsub231ss xmm26, xmm13, xmm10, {rn-sae}

// CHECK: vfnmsub231ss xmm26, xmm13, xmm10, {ru-sae}
// CHECK:  encoding: [0x62,0x42,0x15,0x58,0xbf,0xd2]
          vfnmsub231ss xmm26, xmm13, xmm10, {ru-sae}

// CHECK: vfnmsub231ss xmm26, xmm13, xmm10, {rd-sae}
// CHECK:  encoding: [0x62,0x42,0x15,0x38,0xbf,0xd2]
          vfnmsub231ss xmm26, xmm13, xmm10, {rd-sae}

// CHECK: vfnmsub231ss xmm26, xmm13, xmm10, {rz-sae}
// CHECK:  encoding: [0x62,0x42,0x15,0x78,0xbf,0xd2]
          vfnmsub231ss xmm26, xmm13, xmm10, {rz-sae}

// CHECK: vfnmsub231ss xmm26, xmm13, dword ptr [rcx]
// CHECK:  encoding: [0x62,0x62,0x15,0x08,0xbf,0x11]
          vfnmsub231ss xmm26, xmm13, dword ptr [rcx]

// CHECK: vfnmsub231ss xmm26, xmm13, dword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0x22,0x15,0x08,0xbf,0x94,0xf0,0x23,0x01,0x00,0x00]
          vfnmsub231ss xmm26, xmm13, dword ptr [rax + 8*r14 + 291]

// CHECK: vfnmsub231ss xmm26, xmm13, dword ptr [rdx + 508]
// CHECK:  encoding: [0x62,0x62,0x15,0x08,0xbf,0x52,0x7f]
          vfnmsub231ss xmm26, xmm13, dword ptr [rdx + 508]

// CHECK: vfnmsub231ss xmm26, xmm13, dword ptr [rdx + 512]
// CHECK:  encoding: [0x62,0x62,0x15,0x08,0xbf,0x92,0x00,0x02,0x00,0x00]
          vfnmsub231ss xmm26, xmm13, dword ptr [rdx + 512]

// CHECK: vfnmsub231ss xmm26, xmm13, dword ptr [rdx - 512]
// CHECK:  encoding: [0x62,0x62,0x15,0x08,0xbf,0x52,0x80]
          vfnmsub231ss xmm26, xmm13, dword ptr [rdx - 512]

// CHECK: vfnmsub231ss xmm26, xmm13, dword ptr [rdx - 516]
// CHECK:  encoding: [0x62,0x62,0x15,0x08,0xbf,0x92,0xfc,0xfd,0xff,0xff]
          vfnmsub231ss xmm26, xmm13, dword ptr [rdx - 516]

// CHECK: vgetexppd zmm14, zmm25
// CHECK:  encoding: [0x62,0x12,0xfd,0x48,0x42,0xf1]
          vgetexppd zmm14, zmm25

// CHECK: vgetexppd zmm14 {k5}, zmm25
// CHECK:  encoding: [0x62,0x12,0xfd,0x4d,0x42,0xf1]
          vgetexppd zmm14 {k5}, zmm25

// CHECK: vgetexppd zmm14 {k5} {z}, zmm25
// CHECK:  encoding: [0x62,0x12,0xfd,0xcd,0x42,0xf1]
          vgetexppd zmm14 {k5} {z}, zmm25

// CHECK: vgetexppd zmm14, zmm25, {sae}
// CHECK:  encoding: [0x62,0x12,0xfd,0x18,0x42,0xf1]
          vgetexppd zmm14, zmm25, {sae}

// CHECK: vgetexppd zmm14, zmmword ptr [rcx]
// CHECK:  encoding: [0x62,0x72,0xfd,0x48,0x42,0x31]
          vgetexppd zmm14, zmmword ptr [rcx]

// CHECK: vgetexppd zmm14, zmmword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0x32,0xfd,0x48,0x42,0xb4,0xf0,0x23,0x01,0x00,0x00]
          vgetexppd zmm14, zmmword ptr [rax + 8*r14 + 291]

// CHECK: vgetexppd zmm14, qword ptr [rcx]{1to8}
// CHECK:  encoding: [0x62,0x72,0xfd,0x58,0x42,0x31]
          vgetexppd zmm14, qword ptr [rcx]{1to8}

// CHECK: vgetexppd zmm14, zmmword ptr [rdx + 8128]
// CHECK:  encoding: [0x62,0x72,0xfd,0x48,0x42,0x72,0x7f]
          vgetexppd zmm14, zmmword ptr [rdx + 8128]

// CHECK: vgetexppd zmm14, zmmword ptr [rdx + 8192]
// CHECK:  encoding: [0x62,0x72,0xfd,0x48,0x42,0xb2,0x00,0x20,0x00,0x00]
          vgetexppd zmm14, zmmword ptr [rdx + 8192]

// CHECK: vgetexppd zmm14, zmmword ptr [rdx - 8192]
// CHECK:  encoding: [0x62,0x72,0xfd,0x48,0x42,0x72,0x80]
          vgetexppd zmm14, zmmword ptr [rdx - 8192]

// CHECK: vgetexppd zmm14, zmmword ptr [rdx - 8256]
// CHECK:  encoding: [0x62,0x72,0xfd,0x48,0x42,0xb2,0xc0,0xdf,0xff,0xff]
          vgetexppd zmm14, zmmword ptr [rdx - 8256]

// CHECK: vgetexppd zmm14, qword ptr [rdx + 1016]{1to8}
// CHECK:  encoding: [0x62,0x72,0xfd,0x58,0x42,0x72,0x7f]
          vgetexppd zmm14, qword ptr [rdx + 1016]{1to8}

// CHECK: vgetexppd zmm14, qword ptr [rdx + 1024]{1to8}
// CHECK:  encoding: [0x62,0x72,0xfd,0x58,0x42,0xb2,0x00,0x04,0x00,0x00]
          vgetexppd zmm14, qword ptr [rdx + 1024]{1to8}

// CHECK: vgetexppd zmm14, qword ptr [rdx - 1024]{1to8}
// CHECK:  encoding: [0x62,0x72,0xfd,0x58,0x42,0x72,0x80]
          vgetexppd zmm14, qword ptr [rdx - 1024]{1to8}

// CHECK: vgetexppd zmm14, qword ptr [rdx - 1032]{1to8}
// CHECK:  encoding: [0x62,0x72,0xfd,0x58,0x42,0xb2,0xf8,0xfb,0xff,0xff]
          vgetexppd zmm14, qword ptr [rdx - 1032]{1to8}

// CHECK: vgetexpps zmm1, zmm6
// CHECK:  encoding: [0x62,0xf2,0x7d,0x48,0x42,0xce]
          vgetexpps zmm1, zmm6

// CHECK: vgetexpps zmm1 {k3}, zmm6
// CHECK:  encoding: [0x62,0xf2,0x7d,0x4b,0x42,0xce]
          vgetexpps zmm1 {k3}, zmm6

// CHECK: vgetexpps zmm1 {k3} {z}, zmm6
// CHECK:  encoding: [0x62,0xf2,0x7d,0xcb,0x42,0xce]
          vgetexpps zmm1 {k3} {z}, zmm6

// CHECK: vgetexpps zmm1, zmm6, {sae}
// CHECK:  encoding: [0x62,0xf2,0x7d,0x18,0x42,0xce]
          vgetexpps zmm1, zmm6, {sae}

// CHECK: vgetexpps zmm1, zmmword ptr [rcx]
// CHECK:  encoding: [0x62,0xf2,0x7d,0x48,0x42,0x09]
          vgetexpps zmm1, zmmword ptr [rcx]

// CHECK: vgetexpps zmm1, zmmword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0xb2,0x7d,0x48,0x42,0x8c,0xf0,0x23,0x01,0x00,0x00]
          vgetexpps zmm1, zmmword ptr [rax + 8*r14 + 291]

// CHECK: vgetexpps zmm1, dword ptr [rcx]{1to16}
// CHECK:  encoding: [0x62,0xf2,0x7d,0x58,0x42,0x09]
          vgetexpps zmm1, dword ptr [rcx]{1to16}

// CHECK: vgetexpps zmm1, zmmword ptr [rdx + 8128]
// CHECK:  encoding: [0x62,0xf2,0x7d,0x48,0x42,0x4a,0x7f]
          vgetexpps zmm1, zmmword ptr [rdx + 8128]

// CHECK: vgetexpps zmm1, zmmword ptr [rdx + 8192]
// CHECK:  encoding: [0x62,0xf2,0x7d,0x48,0x42,0x8a,0x00,0x20,0x00,0x00]
          vgetexpps zmm1, zmmword ptr [rdx + 8192]

// CHECK: vgetexpps zmm1, zmmword ptr [rdx - 8192]
// CHECK:  encoding: [0x62,0xf2,0x7d,0x48,0x42,0x4a,0x80]
          vgetexpps zmm1, zmmword ptr [rdx - 8192]

// CHECK: vgetexpps zmm1, zmmword ptr [rdx - 8256]
// CHECK:  encoding: [0x62,0xf2,0x7d,0x48,0x42,0x8a,0xc0,0xdf,0xff,0xff]
          vgetexpps zmm1, zmmword ptr [rdx - 8256]

// CHECK: vgetexpps zmm1, dword ptr [rdx + 508]{1to16}
// CHECK:  encoding: [0x62,0xf2,0x7d,0x58,0x42,0x4a,0x7f]
          vgetexpps zmm1, dword ptr [rdx + 508]{1to16}

// CHECK: vgetexpps zmm1, dword ptr [rdx + 512]{1to16}
// CHECK:  encoding: [0x62,0xf2,0x7d,0x58,0x42,0x8a,0x00,0x02,0x00,0x00]
          vgetexpps zmm1, dword ptr [rdx + 512]{1to16}

// CHECK: vgetexpps zmm1, dword ptr [rdx - 512]{1to16}
// CHECK:  encoding: [0x62,0xf2,0x7d,0x58,0x42,0x4a,0x80]
          vgetexpps zmm1, dword ptr [rdx - 512]{1to16}

// CHECK: vgetexpps zmm1, dword ptr [rdx - 516]{1to16}
// CHECK:  encoding: [0x62,0xf2,0x7d,0x58,0x42,0x8a,0xfc,0xfd,0xff,0xff]
          vgetexpps zmm1, dword ptr [rdx - 516]{1to16}

// CHECK: vgetexpsd xmm2, xmm7, xmm2
// CHECK:  encoding: [0x62,0xf2,0xc5,0x08,0x43,0xd2]
          vgetexpsd xmm2, xmm7, xmm2

// CHECK: vgetexpsd xmm2 {k5}, xmm7, xmm2
// CHECK:  encoding: [0x62,0xf2,0xc5,0x0d,0x43,0xd2]
          vgetexpsd xmm2 {k5}, xmm7, xmm2

// CHECK: vgetexpsd xmm2 {k5} {z}, xmm7, xmm2
// CHECK:  encoding: [0x62,0xf2,0xc5,0x8d,0x43,0xd2]
          vgetexpsd xmm2 {k5} {z}, xmm7, xmm2

// CHECK: vgetexpsd xmm2, xmm7, xmm2, {sae}
// CHECK:  encoding: [0x62,0xf2,0xc5,0x18,0x43,0xd2]
          vgetexpsd xmm2, xmm7, xmm2, {sae}

// CHECK: vgetexpsd xmm2, xmm7, qword ptr [rcx]
// CHECK:  encoding: [0x62,0xf2,0xc5,0x08,0x43,0x11]
          vgetexpsd xmm2, xmm7, qword ptr [rcx]

// CHECK: vgetexpsd xmm2, xmm7, qword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0xb2,0xc5,0x08,0x43,0x94,0xf0,0x23,0x01,0x00,0x00]
          vgetexpsd xmm2, xmm7, qword ptr [rax + 8*r14 + 291]

// CHECK: vgetexpsd xmm2, xmm7, qword ptr [rdx + 1016]
// CHECK:  encoding: [0x62,0xf2,0xc5,0x08,0x43,0x52,0x7f]
          vgetexpsd xmm2, xmm7, qword ptr [rdx + 1016]

// CHECK: vgetexpsd xmm2, xmm7, qword ptr [rdx + 1024]
// CHECK:  encoding: [0x62,0xf2,0xc5,0x08,0x43,0x92,0x00,0x04,0x00,0x00]
          vgetexpsd xmm2, xmm7, qword ptr [rdx + 1024]

// CHECK: vgetexpsd xmm2, xmm7, qword ptr [rdx - 1024]
// CHECK:  encoding: [0x62,0xf2,0xc5,0x08,0x43,0x52,0x80]
          vgetexpsd xmm2, xmm7, qword ptr [rdx - 1024]

// CHECK: vgetexpsd xmm2, xmm7, qword ptr [rdx - 1032]
// CHECK:  encoding: [0x62,0xf2,0xc5,0x08,0x43,0x92,0xf8,0xfb,0xff,0xff]
          vgetexpsd xmm2, xmm7, qword ptr [rdx - 1032]

// CHECK: vgetexpss xmm20, xmm1, xmm26
// CHECK:  encoding: [0x62,0x82,0x75,0x08,0x43,0xe2]
          vgetexpss xmm20, xmm1, xmm26

// CHECK: vgetexpss xmm20 {k7}, xmm1, xmm26
// CHECK:  encoding: [0x62,0x82,0x75,0x0f,0x43,0xe2]
          vgetexpss xmm20 {k7}, xmm1, xmm26

// CHECK: vgetexpss xmm20 {k7} {z}, xmm1, xmm26
// CHECK:  encoding: [0x62,0x82,0x75,0x8f,0x43,0xe2]
          vgetexpss xmm20 {k7} {z}, xmm1, xmm26

// CHECK: vgetexpss xmm20, xmm1, xmm26, {sae}
// CHECK:  encoding: [0x62,0x82,0x75,0x18,0x43,0xe2]
          vgetexpss xmm20, xmm1, xmm26, {sae}

// CHECK: vgetexpss xmm20, xmm1, dword ptr [rcx]
// CHECK:  encoding: [0x62,0xe2,0x75,0x08,0x43,0x21]
          vgetexpss xmm20, xmm1, dword ptr [rcx]

// CHECK: vgetexpss xmm20, xmm1, dword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0xa2,0x75,0x08,0x43,0xa4,0xf0,0x23,0x01,0x00,0x00]
          vgetexpss xmm20, xmm1, dword ptr [rax + 8*r14 + 291]

// CHECK: vgetexpss xmm20, xmm1, dword ptr [rdx + 508]
// CHECK:  encoding: [0x62,0xe2,0x75,0x08,0x43,0x62,0x7f]
          vgetexpss xmm20, xmm1, dword ptr [rdx + 508]

// CHECK: vgetexpss xmm20, xmm1, dword ptr [rdx + 512]
// CHECK:  encoding: [0x62,0xe2,0x75,0x08,0x43,0xa2,0x00,0x02,0x00,0x00]
          vgetexpss xmm20, xmm1, dword ptr [rdx + 512]

// CHECK: vgetexpss xmm20, xmm1, dword ptr [rdx - 512]
// CHECK:  encoding: [0x62,0xe2,0x75,0x08,0x43,0x62,0x80]
          vgetexpss xmm20, xmm1, dword ptr [rdx - 512]

// CHECK: vgetexpss xmm20, xmm1, dword ptr [rdx - 516]
// CHECK:  encoding: [0x62,0xe2,0x75,0x08,0x43,0xa2,0xfc,0xfd,0xff,0xff]
          vgetexpss xmm20, xmm1, dword ptr [rdx - 516]

// CHECK: vgetmantpd zmm2, zmm26, 171
// CHECK:  encoding: [0x62,0x93,0xfd,0x48,0x26,0xd2,0xab]
          vgetmantpd zmm2, zmm26, 171

// CHECK: vgetmantpd zmm2 {k7}, zmm26, 171
// CHECK:  encoding: [0x62,0x93,0xfd,0x4f,0x26,0xd2,0xab]
          vgetmantpd zmm2 {k7}, zmm26, 171

// CHECK: vgetmantpd zmm2 {k7} {z}, zmm26, 171
// CHECK:  encoding: [0x62,0x93,0xfd,0xcf,0x26,0xd2,0xab]
          vgetmantpd zmm2 {k7} {z}, zmm26, 171

// CHECK: vgetmantpd zmm2, zmm26, {sae}, 171
// CHECK:  encoding: [0x62,0x93,0xfd,0x18,0x26,0xd2,0xab]
          vgetmantpd zmm2, zmm26, {sae}, 171

// CHECK: vgetmantpd zmm2, zmm26, 123
// CHECK:  encoding: [0x62,0x93,0xfd,0x48,0x26,0xd2,0x7b]
          vgetmantpd zmm2, zmm26, 123

// CHECK: vgetmantpd zmm2, zmm26, {sae}, 123
// CHECK:  encoding: [0x62,0x93,0xfd,0x18,0x26,0xd2,0x7b]
          vgetmantpd zmm2, zmm26, {sae}, 123

// CHECK: vgetmantpd zmm2, zmmword ptr [rcx], 123
// CHECK:  encoding: [0x62,0xf3,0xfd,0x48,0x26,0x11,0x7b]
          vgetmantpd zmm2, zmmword ptr [rcx], 123

// CHECK: vgetmantpd zmm2, zmmword ptr [rax + 8*r14 + 291], 123
// CHECK:  encoding: [0x62,0xb3,0xfd,0x48,0x26,0x94,0xf0,0x23,0x01,0x00,0x00,0x7b]
          vgetmantpd zmm2, zmmword ptr [rax + 8*r14 + 291], 123

// CHECK: vgetmantpd zmm2, qword ptr [rcx]{1to8}, 123
// CHECK:  encoding: [0x62,0xf3,0xfd,0x58,0x26,0x11,0x7b]
          vgetmantpd zmm2, qword ptr [rcx]{1to8}, 123

// CHECK: vgetmantpd zmm2, zmmword ptr [rdx + 8128], 123
// CHECK:  encoding: [0x62,0xf3,0xfd,0x48,0x26,0x52,0x7f,0x7b]
          vgetmantpd zmm2, zmmword ptr [rdx + 8128], 123

// CHECK: vgetmantpd zmm2, zmmword ptr [rdx + 8192], 123
// CHECK:  encoding: [0x62,0xf3,0xfd,0x48,0x26,0x92,0x00,0x20,0x00,0x00,0x7b]
          vgetmantpd zmm2, zmmword ptr [rdx + 8192], 123

// CHECK: vgetmantpd zmm2, zmmword ptr [rdx - 8192], 123
// CHECK:  encoding: [0x62,0xf3,0xfd,0x48,0x26,0x52,0x80,0x7b]
          vgetmantpd zmm2, zmmword ptr [rdx - 8192], 123

// CHECK: vgetmantpd zmm2, zmmword ptr [rdx - 8256], 123
// CHECK:  encoding: [0x62,0xf3,0xfd,0x48,0x26,0x92,0xc0,0xdf,0xff,0xff,0x7b]
          vgetmantpd zmm2, zmmword ptr [rdx - 8256], 123

// CHECK: vgetmantpd zmm2, qword ptr [rdx + 1016]{1to8}, 123
// CHECK:  encoding: [0x62,0xf3,0xfd,0x58,0x26,0x52,0x7f,0x7b]
          vgetmantpd zmm2, qword ptr [rdx + 1016]{1to8}, 123

// CHECK: vgetmantpd zmm2, qword ptr [rdx + 1024]{1to8}, 123
// CHECK:  encoding: [0x62,0xf3,0xfd,0x58,0x26,0x92,0x00,0x04,0x00,0x00,0x7b]
          vgetmantpd zmm2, qword ptr [rdx + 1024]{1to8}, 123

// CHECK: vgetmantpd zmm2, qword ptr [rdx - 1024]{1to8}, 123
// CHECK:  encoding: [0x62,0xf3,0xfd,0x58,0x26,0x52,0x80,0x7b]
          vgetmantpd zmm2, qword ptr [rdx - 1024]{1to8}, 123

// CHECK: vgetmantpd zmm2, qword ptr [rdx - 1032]{1to8}, 123
// CHECK:  encoding: [0x62,0xf3,0xfd,0x58,0x26,0x92,0xf8,0xfb,0xff,0xff,0x7b]
          vgetmantpd zmm2, qword ptr [rdx - 1032]{1to8}, 123

// CHECK: vgetmantps zmm22, zmm28, 171
// CHECK:  encoding: [0x62,0x83,0x7d,0x48,0x26,0xf4,0xab]
          vgetmantps zmm22, zmm28, 171

// CHECK: vgetmantps zmm22 {k3}, zmm28, 171
// CHECK:  encoding: [0x62,0x83,0x7d,0x4b,0x26,0xf4,0xab]
          vgetmantps zmm22 {k3}, zmm28, 171

// CHECK: vgetmantps zmm22 {k3} {z}, zmm28, 171
// CHECK:  encoding: [0x62,0x83,0x7d,0xcb,0x26,0xf4,0xab]
          vgetmantps zmm22 {k3} {z}, zmm28, 171

// CHECK: vgetmantps zmm22, zmm28, {sae}, 171
// CHECK:  encoding: [0x62,0x83,0x7d,0x18,0x26,0xf4,0xab]
          vgetmantps zmm22, zmm28, {sae}, 171

// CHECK: vgetmantps zmm22, zmm28, 123
// CHECK:  encoding: [0x62,0x83,0x7d,0x48,0x26,0xf4,0x7b]
          vgetmantps zmm22, zmm28, 123

// CHECK: vgetmantps zmm22, zmm28, {sae}, 123
// CHECK:  encoding: [0x62,0x83,0x7d,0x18,0x26,0xf4,0x7b]
          vgetmantps zmm22, zmm28, {sae}, 123

// CHECK: vgetmantps zmm22, zmmword ptr [rcx], 123
// CHECK:  encoding: [0x62,0xe3,0x7d,0x48,0x26,0x31,0x7b]
          vgetmantps zmm22, zmmword ptr [rcx], 123

// CHECK: vgetmantps zmm22, zmmword ptr [rax + 8*r14 + 291], 123
// CHECK:  encoding: [0x62,0xa3,0x7d,0x48,0x26,0xb4,0xf0,0x23,0x01,0x00,0x00,0x7b]
          vgetmantps zmm22, zmmword ptr [rax + 8*r14 + 291], 123

// CHECK: vgetmantps zmm22, dword ptr [rcx]{1to16}, 123
// CHECK:  encoding: [0x62,0xe3,0x7d,0x58,0x26,0x31,0x7b]
          vgetmantps zmm22, dword ptr [rcx]{1to16}, 123

// CHECK: vgetmantps zmm22, zmmword ptr [rdx + 8128], 123
// CHECK:  encoding: [0x62,0xe3,0x7d,0x48,0x26,0x72,0x7f,0x7b]
          vgetmantps zmm22, zmmword ptr [rdx + 8128], 123

// CHECK: vgetmantps zmm22, zmmword ptr [rdx + 8192], 123
// CHECK:  encoding: [0x62,0xe3,0x7d,0x48,0x26,0xb2,0x00,0x20,0x00,0x00,0x7b]
          vgetmantps zmm22, zmmword ptr [rdx + 8192], 123

// CHECK: vgetmantps zmm22, zmmword ptr [rdx - 8192], 123
// CHECK:  encoding: [0x62,0xe3,0x7d,0x48,0x26,0x72,0x80,0x7b]
          vgetmantps zmm22, zmmword ptr [rdx - 8192], 123

// CHECK: vgetmantps zmm22, zmmword ptr [rdx - 8256], 123
// CHECK:  encoding: [0x62,0xe3,0x7d,0x48,0x26,0xb2,0xc0,0xdf,0xff,0xff,0x7b]
          vgetmantps zmm22, zmmword ptr [rdx - 8256], 123

// CHECK: vgetmantps zmm22, dword ptr [rdx + 508]{1to16}, 123
// CHECK:  encoding: [0x62,0xe3,0x7d,0x58,0x26,0x72,0x7f,0x7b]
          vgetmantps zmm22, dword ptr [rdx + 508]{1to16}, 123

// CHECK: vgetmantps zmm22, dword ptr [rdx + 512]{1to16}, 123
// CHECK:  encoding: [0x62,0xe3,0x7d,0x58,0x26,0xb2,0x00,0x02,0x00,0x00,0x7b]
          vgetmantps zmm22, dword ptr [rdx + 512]{1to16}, 123

// CHECK: vgetmantps zmm22, dword ptr [rdx - 512]{1to16}, 123
// CHECK:  encoding: [0x62,0xe3,0x7d,0x58,0x26,0x72,0x80,0x7b]
          vgetmantps zmm22, dword ptr [rdx - 512]{1to16}, 123

// CHECK: vgetmantps zmm22, dword ptr [rdx - 516]{1to16}, 123
// CHECK:  encoding: [0x62,0xe3,0x7d,0x58,0x26,0xb2,0xfc,0xfd,0xff,0xff,0x7b]
          vgetmantps zmm22, dword ptr [rdx - 516]{1to16}, 123

// CHECK: vgetmantsd xmm3, xmm27, xmm8, 171
// CHECK:  encoding: [0x62,0xd3,0xa5,0x00,0x27,0xd8,0xab]
          vgetmantsd xmm3, xmm27, xmm8, 171

// CHECK: vgetmantsd xmm3 {k6}, xmm27, xmm8, 171
// CHECK:  encoding: [0x62,0xd3,0xa5,0x06,0x27,0xd8,0xab]
          vgetmantsd xmm3 {k6}, xmm27, xmm8, 171

// CHECK: vgetmantsd xmm3 {k6} {z}, xmm27, xmm8, 171
// CHECK:  encoding: [0x62,0xd3,0xa5,0x86,0x27,0xd8,0xab]
          vgetmantsd xmm3 {k6} {z}, xmm27, xmm8, 171

// CHECK: vgetmantsd xmm3, xmm27, xmm8, {sae}, 171
// CHECK:  encoding: [0x62,0xd3,0xa5,0x10,0x27,0xd8,0xab]
          vgetmantsd xmm3, xmm27, xmm8, {sae}, 171

// CHECK: vgetmantsd xmm3, xmm27, xmm8, 123
// CHECK:  encoding: [0x62,0xd3,0xa5,0x00,0x27,0xd8,0x7b]
          vgetmantsd xmm3, xmm27, xmm8, 123

// CHECK: vgetmantsd xmm3, xmm27, xmm8, {sae}, 123
// CHECK:  encoding: [0x62,0xd3,0xa5,0x10,0x27,0xd8,0x7b]
          vgetmantsd xmm3, xmm27, xmm8, {sae}, 123

// CHECK: vgetmantsd xmm3, xmm27, qword ptr [rcx], 123
// CHECK:  encoding: [0x62,0xf3,0xa5,0x00,0x27,0x19,0x7b]
          vgetmantsd xmm3, xmm27, qword ptr [rcx], 123

// CHECK: vgetmantsd xmm3, xmm27, qword ptr [rax + 8*r14 + 291], 123
// CHECK:  encoding: [0x62,0xb3,0xa5,0x00,0x27,0x9c,0xf0,0x23,0x01,0x00,0x00,0x7b]
          vgetmantsd xmm3, xmm27, qword ptr [rax + 8*r14 + 291], 123

// CHECK: vgetmantsd xmm3, xmm27, qword ptr [rdx + 1016], 123
// CHECK:  encoding: [0x62,0xf3,0xa5,0x00,0x27,0x5a,0x7f,0x7b]
          vgetmantsd xmm3, xmm27, qword ptr [rdx + 1016], 123

// CHECK: vgetmantsd xmm3, xmm27, qword ptr [rdx + 1024], 123
// CHECK:  encoding: [0x62,0xf3,0xa5,0x00,0x27,0x9a,0x00,0x04,0x00,0x00,0x7b]
          vgetmantsd xmm3, xmm27, qword ptr [rdx + 1024], 123

// CHECK: vgetmantsd xmm3, xmm27, qword ptr [rdx - 1024], 123
// CHECK:  encoding: [0x62,0xf3,0xa5,0x00,0x27,0x5a,0x80,0x7b]
          vgetmantsd xmm3, xmm27, qword ptr [rdx - 1024], 123

// CHECK: vgetmantsd xmm3, xmm27, qword ptr [rdx - 1032], 123
// CHECK:  encoding: [0x62,0xf3,0xa5,0x00,0x27,0x9a,0xf8,0xfb,0xff,0xff,0x7b]
          vgetmantsd xmm3, xmm27, qword ptr [rdx - 1032], 123

// CHECK: vgetmantss xmm3, xmm2, xmm12, 171
// CHECK:  encoding: [0x62,0xd3,0x6d,0x08,0x27,0xdc,0xab]
          vgetmantss xmm3, xmm2, xmm12, 171

// CHECK: vgetmantss xmm3 {k7}, xmm2, xmm12, 171
// CHECK:  encoding: [0x62,0xd3,0x6d,0x0f,0x27,0xdc,0xab]
          vgetmantss xmm3 {k7}, xmm2, xmm12, 171

// CHECK: vgetmantss xmm3 {k7} {z}, xmm2, xmm12, 171
// CHECK:  encoding: [0x62,0xd3,0x6d,0x8f,0x27,0xdc,0xab]
          vgetmantss xmm3 {k7} {z}, xmm2, xmm12, 171

// CHECK: vgetmantss xmm3, xmm2, xmm12, {sae}, 171
// CHECK:  encoding: [0x62,0xd3,0x6d,0x18,0x27,0xdc,0xab]
          vgetmantss xmm3, xmm2, xmm12, {sae}, 171

// CHECK: vgetmantss xmm3, xmm2, xmm12, 123
// CHECK:  encoding: [0x62,0xd3,0x6d,0x08,0x27,0xdc,0x7b]
          vgetmantss xmm3, xmm2, xmm12, 123

// CHECK: vgetmantss xmm3, xmm2, xmm12, {sae}, 123
// CHECK:  encoding: [0x62,0xd3,0x6d,0x18,0x27,0xdc,0x7b]
          vgetmantss xmm3, xmm2, xmm12, {sae}, 123

// CHECK: vgetmantss xmm3, xmm2, dword ptr [rcx], 123
// CHECK:  encoding: [0x62,0xf3,0x6d,0x08,0x27,0x19,0x7b]
          vgetmantss xmm3, xmm2, dword ptr [rcx], 123

// CHECK: vgetmantss xmm3, xmm2, dword ptr [rax + 8*r14 + 291], 123
// CHECK:  encoding: [0x62,0xb3,0x6d,0x08,0x27,0x9c,0xf0,0x23,0x01,0x00,0x00,0x7b]
          vgetmantss xmm3, xmm2, dword ptr [rax + 8*r14 + 291], 123

// CHECK: vgetmantss xmm3, xmm2, dword ptr [rdx + 508], 123
// CHECK:  encoding: [0x62,0xf3,0x6d,0x08,0x27,0x5a,0x7f,0x7b]
          vgetmantss xmm3, xmm2, dword ptr [rdx + 508], 123

// CHECK: vgetmantss xmm3, xmm2, dword ptr [rdx + 512], 123
// CHECK:  encoding: [0x62,0xf3,0x6d,0x08,0x27,0x9a,0x00,0x02,0x00,0x00,0x7b]
          vgetmantss xmm3, xmm2, dword ptr [rdx + 512], 123
// CHECK: vgetmantss xmm3, xmm2, dword ptr [rdx - 512], 123
// CHECK:  encoding: [0x62,0xf3,0x6d,0x08,0x27,0x5a,0x80,0x7b]
          vgetmantss xmm3, xmm2, dword ptr [rdx - 512], 123

// CHECK: vgetmantss xmm3, xmm2, dword ptr [rdx - 516], 123
// CHECK:  encoding: [0x62,0xf3,0x6d,0x08,0x27,0x9a,0xfc,0xfd,0xff,0xff,0x7b]
          vgetmantss xmm3, xmm2, dword ptr [rdx - 516], 123

// CHECK: vinsertf32x4 zmm11, zmm26, xmm3, 171
// CHECK:  encoding: [0x62,0x73,0x2d,0x40,0x18,0xdb,0xab]
          vinsertf32x4 zmm11, zmm26, xmm3, 171

// CHECK: vinsertf32x4 zmm11 {k1}, zmm26, xmm3, 171
// CHECK:  encoding: [0x62,0x73,0x2d,0x41,0x18,0xdb,0xab]
          vinsertf32x4 zmm11 {k1}, zmm26, xmm3, 171

// CHECK: vinsertf32x4 zmm11 {k1} {z}, zmm26, xmm3, 171
// CHECK:  encoding: [0x62,0x73,0x2d,0xc1,0x18,0xdb,0xab]
          vinsertf32x4 zmm11 {k1} {z}, zmm26, xmm3, 171

// CHECK: vinsertf32x4 zmm11, zmm26, xmm3, 123
// CHECK:  encoding: [0x62,0x73,0x2d,0x40,0x18,0xdb,0x7b]
          vinsertf32x4 zmm11, zmm26, xmm3, 123

// CHECK: vinsertf32x4 zmm11, zmm26, xmmword ptr [rcx], 123
// CHECK:  encoding: [0x62,0x73,0x2d,0x40,0x18,0x19,0x7b]
          vinsertf32x4 zmm11, zmm26, xmmword ptr [rcx], 123

// CHECK: vinsertf32x4 zmm11, zmm26, xmmword ptr [rax + 8*r14 + 291], 123
// CHECK:  encoding: [0x62,0x33,0x2d,0x40,0x18,0x9c,0xf0,0x23,0x01,0x00,0x00,0x7b]
          vinsertf32x4 zmm11, zmm26, xmmword ptr [rax + 8*r14 + 291], 123

// CHECK: vinsertf32x4 zmm11, zmm26, xmmword ptr [rdx + 2032], 123
// CHECK:  encoding: [0x62,0x73,0x2d,0x40,0x18,0x5a,0x7f,0x7b]
          vinsertf32x4 zmm11, zmm26, xmmword ptr [rdx + 2032], 123

// CHECK: vinsertf32x4 zmm11, zmm26, xmmword ptr [rdx + 2048], 123
// CHECK:  encoding: [0x62,0x73,0x2d,0x40,0x18,0x9a,0x00,0x08,0x00,0x00,0x7b]
          vinsertf32x4 zmm11, zmm26, xmmword ptr [rdx + 2048], 123

// CHECK: vinsertf32x4 zmm11, zmm26, xmmword ptr [rdx - 2048], 123
// CHECK:  encoding: [0x62,0x73,0x2d,0x40,0x18,0x5a,0x80,0x7b]
          vinsertf32x4 zmm11, zmm26, xmmword ptr [rdx - 2048], 123

// CHECK: vinsertf32x4 zmm11, zmm26, xmmword ptr [rdx - 2064], 123
// CHECK:  encoding: [0x62,0x73,0x2d,0x40,0x18,0x9a,0xf0,0xf7,0xff,0xff,0x7b]
          vinsertf32x4 zmm11, zmm26, xmmword ptr [rdx - 2064], 123

// CHECK: vinsertf64x4 zmm1, zmm5, ymm7, 171
// CHECK:  encoding: [0x62,0xf3,0xd5,0x48,0x1a,0xcf,0xab]
          vinsertf64x4 zmm1, zmm5, ymm7, 171

// CHECK: vinsertf64x4 zmm1 {k1}, zmm5, ymm7, 171
// CHECK:  encoding: [0x62,0xf3,0xd5,0x49,0x1a,0xcf,0xab]
          vinsertf64x4 zmm1 {k1}, zmm5, ymm7, 171

// CHECK: vinsertf64x4 zmm1 {k1} {z}, zmm5, ymm7, 171
// CHECK:  encoding: [0x62,0xf3,0xd5,0xc9,0x1a,0xcf,0xab]
          vinsertf64x4 zmm1 {k1} {z}, zmm5, ymm7, 171

// CHECK: vinsertf64x4 zmm1, zmm5, ymm7, 123
// CHECK:  encoding: [0x62,0xf3,0xd5,0x48,0x1a,0xcf,0x7b]
          vinsertf64x4 zmm1, zmm5, ymm7, 123

// CHECK: vinsertf64x4 zmm1, zmm5, ymmword ptr [rcx], 123
// CHECK:  encoding: [0x62,0xf3,0xd5,0x48,0x1a,0x09,0x7b]
          vinsertf64x4 zmm1, zmm5, ymmword ptr [rcx], 123

// CHECK: vinsertf64x4 zmm1, zmm5, ymmword ptr [rax + 8*r14 + 291], 123
// CHECK:  encoding: [0x62,0xb3,0xd5,0x48,0x1a,0x8c,0xf0,0x23,0x01,0x00,0x00,0x7b]
          vinsertf64x4 zmm1, zmm5, ymmword ptr [rax + 8*r14 + 291], 123

// CHECK: vinsertf64x4 zmm1, zmm5, ymmword ptr [rdx + 4064], 123
// CHECK:  encoding: [0x62,0xf3,0xd5,0x48,0x1a,0x4a,0x7f,0x7b]
          vinsertf64x4 zmm1, zmm5, ymmword ptr [rdx + 4064], 123

// CHECK: vinsertf64x4 zmm1, zmm5, ymmword ptr [rdx + 4096], 123
// CHECK:  encoding: [0x62,0xf3,0xd5,0x48,0x1a,0x8a,0x00,0x10,0x00,0x00,0x7b]
          vinsertf64x4 zmm1, zmm5, ymmword ptr [rdx + 4096], 123

// CHECK: vinsertf64x4 zmm1, zmm5, ymmword ptr [rdx - 4096], 123
// CHECK:  encoding: [0x62,0xf3,0xd5,0x48,0x1a,0x4a,0x80,0x7b]
          vinsertf64x4 zmm1, zmm5, ymmword ptr [rdx - 4096], 123

// CHECK: vinsertf64x4 zmm1, zmm5, ymmword ptr [rdx - 4128], 123
// CHECK:  encoding: [0x62,0xf3,0xd5,0x48,0x1a,0x8a,0xe0,0xef,0xff,0xff,0x7b]
          vinsertf64x4 zmm1, zmm5, ymmword ptr [rdx - 4128], 123

// CHECK: vinserti32x4 zmm17, zmm13, xmm10, 171
// CHECK:  encoding: [0x62,0xc3,0x15,0x48,0x38,0xca,0xab]
          vinserti32x4 zmm17, zmm13, xmm10, 171

// CHECK: vinserti32x4 zmm17 {k6}, zmm13, xmm10, 171
// CHECK:  encoding: [0x62,0xc3,0x15,0x4e,0x38,0xca,0xab]
          vinserti32x4 zmm17 {k6}, zmm13, xmm10, 171

// CHECK: vinserti32x4 zmm17 {k6} {z}, zmm13, xmm10, 171
// CHECK:  encoding: [0x62,0xc3,0x15,0xce,0x38,0xca,0xab]
          vinserti32x4 zmm17 {k6} {z}, zmm13, xmm10, 171

// CHECK: vinserti32x4 zmm17, zmm13, xmm10, 123
// CHECK:  encoding: [0x62,0xc3,0x15,0x48,0x38,0xca,0x7b]
          vinserti32x4 zmm17, zmm13, xmm10, 123

// CHECK: vinserti32x4 zmm17, zmm13, xmmword ptr [rcx], 123
// CHECK:  encoding: [0x62,0xe3,0x15,0x48,0x38,0x09,0x7b]
          vinserti32x4 zmm17, zmm13, xmmword ptr [rcx], 123

// CHECK: vinserti32x4 zmm17, zmm13, xmmword ptr [rax + 8*r14 + 291], 123
// CHECK:  encoding: [0x62,0xa3,0x15,0x48,0x38,0x8c,0xf0,0x23,0x01,0x00,0x00,0x7b]
          vinserti32x4 zmm17, zmm13, xmmword ptr [rax + 8*r14 + 291], 123

// CHECK: vinserti32x4 zmm17, zmm13, xmmword ptr [rdx + 2032], 123
// CHECK:  encoding: [0x62,0xe3,0x15,0x48,0x38,0x4a,0x7f,0x7b]
          vinserti32x4 zmm17, zmm13, xmmword ptr [rdx + 2032], 123

// CHECK: vinserti32x4 zmm17, zmm13, xmmword ptr [rdx + 2048], 123
// CHECK:  encoding: [0x62,0xe3,0x15,0x48,0x38,0x8a,0x00,0x08,0x00,0x00,0x7b]
          vinserti32x4 zmm17, zmm13, xmmword ptr [rdx + 2048], 123

// CHECK: vinserti32x4 zmm17, zmm13, xmmword ptr [rdx - 2048], 123
// CHECK:  encoding: [0x62,0xe3,0x15,0x48,0x38,0x4a,0x80,0x7b]
          vinserti32x4 zmm17, zmm13, xmmword ptr [rdx - 2048], 123

// CHECK: vinserti32x4 zmm17, zmm13, xmmword ptr [rdx - 2064], 123
// CHECK:  encoding: [0x62,0xe3,0x15,0x48,0x38,0x8a,0xf0,0xf7,0xff,0xff,0x7b]
          vinserti32x4 zmm17, zmm13, xmmword ptr [rdx - 2064], 123

// CHECK: vinserti64x4 zmm4, zmm25, ymm4, 171
// CHECK:  encoding: [0x62,0xf3,0xb5,0x40,0x3a,0xe4,0xab]
          vinserti64x4 zmm4, zmm25, ymm4, 171

// CHECK: vinserti64x4 zmm4 {k1}, zmm25, ymm4, 171
// CHECK:  encoding: [0x62,0xf3,0xb5,0x41,0x3a,0xe4,0xab]
          vinserti64x4 zmm4 {k1}, zmm25, ymm4, 171

// CHECK: vinserti64x4 zmm4 {k1} {z}, zmm25, ymm4, 171
// CHECK:  encoding: [0x62,0xf3,0xb5,0xc1,0x3a,0xe4,0xab]
          vinserti64x4 zmm4 {k1} {z}, zmm25, ymm4, 171

// CHECK: vinserti64x4 zmm4, zmm25, ymm4, 123
// CHECK:  encoding: [0x62,0xf3,0xb5,0x40,0x3a,0xe4,0x7b]
          vinserti64x4 zmm4, zmm25, ymm4, 123

// CHECK: vinserti64x4 zmm4, zmm25, ymmword ptr [rcx], 123
// CHECK:  encoding: [0x62,0xf3,0xb5,0x40,0x3a,0x21,0x7b]
          vinserti64x4 zmm4, zmm25, ymmword ptr [rcx], 123

// CHECK: vinserti64x4 zmm4, zmm25, ymmword ptr [rax + 8*r14 + 291], 123
// CHECK:  encoding: [0x62,0xb3,0xb5,0x40,0x3a,0xa4,0xf0,0x23,0x01,0x00,0x00,0x7b]
          vinserti64x4 zmm4, zmm25, ymmword ptr [rax + 8*r14 + 291], 123

// CHECK: vinserti64x4 zmm4, zmm25, ymmword ptr [rdx + 4064], 123
// CHECK:  encoding: [0x62,0xf3,0xb5,0x40,0x3a,0x62,0x7f,0x7b]
          vinserti64x4 zmm4, zmm25, ymmword ptr [rdx + 4064], 123

// CHECK: vinserti64x4 zmm4, zmm25, ymmword ptr [rdx + 4096], 123
// CHECK:  encoding: [0x62,0xf3,0xb5,0x40,0x3a,0xa2,0x00,0x10,0x00,0x00,0x7b]
          vinserti64x4 zmm4, zmm25, ymmword ptr [rdx + 4096], 123

// CHECK: vinserti64x4 zmm4, zmm25, ymmword ptr [rdx - 4096], 123
// CHECK:  encoding: [0x62,0xf3,0xb5,0x40,0x3a,0x62,0x80,0x7b]
          vinserti64x4 zmm4, zmm25, ymmword ptr [rdx - 4096], 123

// CHECK: vinserti64x4 zmm4, zmm25, ymmword ptr [rdx - 4128], 123
// CHECK:  encoding: [0x62,0xf3,0xb5,0x40,0x3a,0xa2,0xe0,0xef,0xff,0xff,0x7b]
          vinserti64x4 zmm4, zmm25, ymmword ptr [rdx - 4128], 123

// CHECK: vinsertps xmm30, xmm17, xmm5, 171
// CHECK:  encoding: [0x62,0x63,0x75,0x00,0x21,0xf5,0xab]
          vinsertps xmm30, xmm17, xmm5, 171

// CHECK: vinsertps xmm30, xmm17, xmm5, 123
// CHECK:  encoding: [0x62,0x63,0x75,0x00,0x21,0xf5,0x7b]
          vinsertps xmm30, xmm17, xmm5, 123

// CHECK: vinsertps xmm30, xmm17, dword ptr [rcx], 123
// CHECK:  encoding: [0x62,0x63,0x75,0x00,0x21,0x31,0x7b]
          vinsertps xmm30, xmm17, dword ptr [rcx], 123

// CHECK: vinsertps xmm30, xmm17, dword ptr [rax + 8*r14 + 291], 123
// CHECK:  encoding: [0x62,0x23,0x75,0x00,0x21,0xb4,0xf0,0x23,0x01,0x00,0x00,0x7b]
          vinsertps xmm30, xmm17, dword ptr [rax + 8*r14 + 291], 123

// CHECK: vinsertps xmm30, xmm17, dword ptr [rdx + 508], 123
// CHECK:  encoding: [0x62,0x63,0x75,0x00,0x21,0x72,0x7f,0x7b]
          vinsertps xmm30, xmm17, dword ptr [rdx + 508], 123

// CHECK: vinsertps xmm30, xmm17, dword ptr [rdx + 512], 123
// CHECK:  encoding: [0x62,0x63,0x75,0x00,0x21,0xb2,0x00,0x02,0x00,0x00,0x7b]
          vinsertps xmm30, xmm17, dword ptr [rdx + 512], 123

// CHECK: vinsertps xmm30, xmm17, dword ptr [rdx - 512], 123
// CHECK:  encoding: [0x62,0x63,0x75,0x00,0x21,0x72,0x80,0x7b]
          vinsertps xmm30, xmm17, dword ptr [rdx - 512], 123

// CHECK: vinsertps xmm30, xmm17, dword ptr [rdx - 516], 123
// CHECK:  encoding: [0x62,0x63,0x75,0x00,0x21,0xb2,0xfc,0xfd,0xff,0xff,0x7b]
          vinsertps xmm30, xmm17, dword ptr [rdx - 516], 123

// CHECK: vmaxpd zmm30, zmm28, zmm20
// CHECK:  encoding: [0x62,0x21,0x9d,0x40,0x5f,0xf4]
          vmaxpd zmm30, zmm28, zmm20

// CHECK: vmaxpd zmm30 {k1}, zmm28, zmm20
// CHECK:  encoding: [0x62,0x21,0x9d,0x41,0x5f,0xf4]
          vmaxpd zmm30 {k1}, zmm28, zmm20

// CHECK: vmaxpd zmm30 {k1} {z}, zmm28, zmm20
// CHECK:  encoding: [0x62,0x21,0x9d,0xc1,0x5f,0xf4]
          vmaxpd zmm30 {k1} {z}, zmm28, zmm20

// CHECK: vmaxpd zmm30, zmm28, zmm20, {sae}
// CHECK:  encoding: [0x62,0x21,0x9d,0x10,0x5f,0xf4]
          vmaxpd zmm30, zmm28, zmm20, {sae}

// CHECK: vmaxpd zmm30, zmm28, zmmword ptr [rcx]
// CHECK:  encoding: [0x62,0x61,0x9d,0x40,0x5f,0x31]
          vmaxpd zmm30, zmm28, zmmword ptr [rcx]

// CHECK: vmaxpd zmm30, zmm28, zmmword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0x21,0x9d,0x40,0x5f,0xb4,0xf0,0x23,0x01,0x00,0x00]
          vmaxpd zmm30, zmm28, zmmword ptr [rax + 8*r14 + 291]

// CHECK: vmaxpd zmm30, zmm28, qword ptr [rcx]{1to8}
// CHECK:  encoding: [0x62,0x61,0x9d,0x50,0x5f,0x31]
          vmaxpd zmm30, zmm28, qword ptr [rcx]{1to8}

// CHECK: vmaxpd zmm30, zmm28, zmmword ptr [rdx + 8128]
// CHECK:  encoding: [0x62,0x61,0x9d,0x40,0x5f,0x72,0x7f]
          vmaxpd zmm30, zmm28, zmmword ptr [rdx + 8128]

// CHECK: vmaxpd zmm30, zmm28, zmmword ptr [rdx + 8192]
// CHECK:  encoding: [0x62,0x61,0x9d,0x40,0x5f,0xb2,0x00,0x20,0x00,0x00]
          vmaxpd zmm30, zmm28, zmmword ptr [rdx + 8192]

// CHECK: vmaxpd zmm30, zmm28, zmmword ptr [rdx - 8192]
// CHECK:  encoding: [0x62,0x61,0x9d,0x40,0x5f,0x72,0x80]
          vmaxpd zmm30, zmm28, zmmword ptr [rdx - 8192]

// CHECK: vmaxpd zmm30, zmm28, zmmword ptr [rdx - 8256]
// CHECK:  encoding: [0x62,0x61,0x9d,0x40,0x5f,0xb2,0xc0,0xdf,0xff,0xff]
          vmaxpd zmm30, zmm28, zmmword ptr [rdx - 8256]

// CHECK: vmaxpd zmm30, zmm28, qword ptr [rdx + 1016]{1to8}
// CHECK:  encoding: [0x62,0x61,0x9d,0x50,0x5f,0x72,0x7f]
          vmaxpd zmm30, zmm28, qword ptr [rdx + 1016]{1to8}

// CHECK: vmaxpd zmm30, zmm28, qword ptr [rdx + 1024]{1to8}
// CHECK:  encoding: [0x62,0x61,0x9d,0x50,0x5f,0xb2,0x00,0x04,0x00,0x00]
          vmaxpd zmm30, zmm28, qword ptr [rdx + 1024]{1to8}

// CHECK: vmaxpd zmm30, zmm28, qword ptr [rdx - 1024]{1to8}
// CHECK:  encoding: [0x62,0x61,0x9d,0x50,0x5f,0x72,0x80]
          vmaxpd zmm30, zmm28, qword ptr [rdx - 1024]{1to8}

// CHECK: vmaxpd zmm30, zmm28, qword ptr [rdx - 1032]{1to8}
// CHECK:  encoding: [0x62,0x61,0x9d,0x50,0x5f,0xb2,0xf8,0xfb,0xff,0xff]
          vmaxpd zmm30, zmm28, qword ptr [rdx - 1032]{1to8}

// CHECK: vmaxps zmm25, zmm6, zmm20
// CHECK:  encoding: [0x62,0x21,0x4c,0x48,0x5f,0xcc]
          vmaxps zmm25, zmm6, zmm20

// CHECK: vmaxps zmm25 {k1}, zmm6, zmm20
// CHECK:  encoding: [0x62,0x21,0x4c,0x49,0x5f,0xcc]
          vmaxps zmm25 {k1}, zmm6, zmm20

// CHECK: vmaxps zmm25 {k1} {z}, zmm6, zmm20
// CHECK:  encoding: [0x62,0x21,0x4c,0xc9,0x5f,0xcc]
          vmaxps zmm25 {k1} {z}, zmm6, zmm20

// CHECK: vmaxps zmm25, zmm6, zmm20, {sae}
// CHECK:  encoding: [0x62,0x21,0x4c,0x18,0x5f,0xcc]
          vmaxps zmm25, zmm6, zmm20, {sae}

// CHECK: vmaxps zmm25, zmm6, zmmword ptr [rcx]
// CHECK:  encoding: [0x62,0x61,0x4c,0x48,0x5f,0x09]
          vmaxps zmm25, zmm6, zmmword ptr [rcx]

// CHECK: vmaxps zmm25, zmm6, zmmword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0x21,0x4c,0x48,0x5f,0x8c,0xf0,0x23,0x01,0x00,0x00]
          vmaxps zmm25, zmm6, zmmword ptr [rax + 8*r14 + 291]

// CHECK: vmaxps zmm25, zmm6, dword ptr [rcx]{1to16}
// CHECK:  encoding: [0x62,0x61,0x4c,0x58,0x5f,0x09]
          vmaxps zmm25, zmm6, dword ptr [rcx]{1to16}

// CHECK: vmaxps zmm25, zmm6, zmmword ptr [rdx + 8128]
// CHECK:  encoding: [0x62,0x61,0x4c,0x48,0x5f,0x4a,0x7f]
          vmaxps zmm25, zmm6, zmmword ptr [rdx + 8128]

// CHECK: vmaxps zmm25, zmm6, zmmword ptr [rdx + 8192]
// CHECK:  encoding: [0x62,0x61,0x4c,0x48,0x5f,0x8a,0x00,0x20,0x00,0x00]
          vmaxps zmm25, zmm6, zmmword ptr [rdx + 8192]

// CHECK: vmaxps zmm25, zmm6, zmmword ptr [rdx - 8192]
// CHECK:  encoding: [0x62,0x61,0x4c,0x48,0x5f,0x4a,0x80]
          vmaxps zmm25, zmm6, zmmword ptr [rdx - 8192]

// CHECK: vmaxps zmm25, zmm6, zmmword ptr [rdx - 8256]
// CHECK:  encoding: [0x62,0x61,0x4c,0x48,0x5f,0x8a,0xc0,0xdf,0xff,0xff]
          vmaxps zmm25, zmm6, zmmword ptr [rdx - 8256]

// CHECK: vmaxps zmm25, zmm6, dword ptr [rdx + 508]{1to16}
// CHECK:  encoding: [0x62,0x61,0x4c,0x58,0x5f,0x4a,0x7f]
          vmaxps zmm25, zmm6, dword ptr [rdx + 508]{1to16}

// CHECK: vmaxps zmm25, zmm6, dword ptr [rdx + 512]{1to16}
// CHECK:  encoding: [0x62,0x61,0x4c,0x58,0x5f,0x8a,0x00,0x02,0x00,0x00]
          vmaxps zmm25, zmm6, dword ptr [rdx + 512]{1to16}

// CHECK: vmaxps zmm25, zmm6, dword ptr [rdx - 512]{1to16}
// CHECK:  encoding: [0x62,0x61,0x4c,0x58,0x5f,0x4a,0x80]
          vmaxps zmm25, zmm6, dword ptr [rdx - 512]{1to16}

// CHECK: vmaxps zmm25, zmm6, dword ptr [rdx - 516]{1to16}
// CHECK:  encoding: [0x62,0x61,0x4c,0x58,0x5f,0x8a,0xfc,0xfd,0xff,0xff]
          vmaxps zmm25, zmm6, dword ptr [rdx - 516]{1to16}

// CHECK: vmaxsd xmm20, xmm19, xmm25
// CHECK:  encoding: [0x62,0x81,0xe7,0x00,0x5f,0xe1]
          vmaxsd xmm20, xmm19, xmm25

// CHECK: vmaxsd xmm20 {k3}, xmm19, xmm25
// CHECK:  encoding: [0x62,0x81,0xe7,0x03,0x5f,0xe1]
          vmaxsd xmm20 {k3}, xmm19, xmm25

// CHECK: vmaxsd xmm20 {k3} {z}, xmm19, xmm25
// CHECK:  encoding: [0x62,0x81,0xe7,0x83,0x5f,0xe1]
          vmaxsd xmm20 {k3} {z}, xmm19, xmm25

// CHECK: vmaxsd xmm20, xmm19, xmm25, {sae}
// CHECK:  encoding: [0x62,0x81,0xe7,0x10,0x5f,0xe1]
          vmaxsd xmm20, xmm19, xmm25, {sae}

// CHECK: vmaxsd xmm20, xmm19, qword ptr [rcx]
// CHECK:  encoding: [0x62,0xe1,0xe7,0x00,0x5f,0x21]
          vmaxsd xmm20, xmm19, qword ptr [rcx]

// CHECK: vmaxsd xmm20, xmm19, qword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0xa1,0xe7,0x00,0x5f,0xa4,0xf0,0x23,0x01,0x00,0x00]
          vmaxsd xmm20, xmm19, qword ptr [rax + 8*r14 + 291]

// CHECK: vmaxsd xmm20, xmm19, qword ptr [rdx + 1016]
// CHECK:  encoding: [0x62,0xe1,0xe7,0x00,0x5f,0x62,0x7f]
          vmaxsd xmm20, xmm19, qword ptr [rdx + 1016]

// CHECK: vmaxsd xmm20, xmm19, qword ptr [rdx + 1024]
// CHECK:  encoding: [0x62,0xe1,0xe7,0x00,0x5f,0xa2,0x00,0x04,0x00,0x00]
          vmaxsd xmm20, xmm19, qword ptr [rdx + 1024]

// CHECK: vmaxsd xmm20, xmm19, qword ptr [rdx - 1024]
// CHECK:  encoding: [0x62,0xe1,0xe7,0x00,0x5f,0x62,0x80]
          vmaxsd xmm20, xmm19, qword ptr [rdx - 1024]

// CHECK: vmaxsd xmm20, xmm19, qword ptr [rdx - 1032]
// CHECK:  encoding: [0x62,0xe1,0xe7,0x00,0x5f,0xa2,0xf8,0xfb,0xff,0xff]
          vmaxsd xmm20, xmm19, qword ptr [rdx - 1032]

// CHECK: vmaxss xmm8, xmm4, xmm6
// CHECK:  encoding: [0xc5,0x5a,0x5f,0xc6]
          vmaxss xmm8, xmm4, xmm6

// CHECK: vmaxss xmm8 {k4}, xmm4, xmm6
// CHECK:  encoding: [0x62,0x71,0x5e,0x0c,0x5f,0xc6]
          vmaxss xmm8 {k4}, xmm4, xmm6

// CHECK: vmaxss xmm8 {k4} {z}, xmm4, xmm6
// CHECK:  encoding: [0x62,0x71,0x5e,0x8c,0x5f,0xc6]
          vmaxss xmm8 {k4} {z}, xmm4, xmm6

// CHECK: vmaxss xmm8, xmm4, xmm6, {sae}
// CHECK:  encoding: [0x62,0x71,0x5e,0x18,0x5f,0xc6]
          vmaxss xmm8, xmm4, xmm6, {sae}

// CHECK: vmaxss xmm8, xmm4, dword ptr [rcx]
// CHECK:  encoding: [0xc5,0x5a,0x5f,0x01]
          vmaxss xmm8, xmm4, dword ptr [rcx]

// CHECK: vmaxss xmm8, xmm4, dword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0xc4,0x21,0x5a,0x5f,0x84,0xf0,0x23,0x01,0x00,0x00]
          vmaxss xmm8, xmm4, dword ptr [rax + 8*r14 + 291]

// CHECK: vmaxss xmm8, xmm4, dword ptr [rdx + 508]
// CHECK:  encoding: [0xc5,0x5a,0x5f,0x82,0xfc,0x01,0x00,0x00]
          vmaxss xmm8, xmm4, dword ptr [rdx + 508]

// CHECK: vmaxss xmm8, xmm4, dword ptr [rdx + 512]
// CHECK:  encoding: [0xc5,0x5a,0x5f,0x82,0x00,0x02,0x00,0x00]
          vmaxss xmm8, xmm4, dword ptr [rdx + 512]

// CHECK: vmaxss xmm8, xmm4, dword ptr [rdx - 512]
// CHECK:  encoding: [0xc5,0x5a,0x5f,0x82,0x00,0xfe,0xff,0xff]
          vmaxss xmm8, xmm4, dword ptr [rdx - 512]

// CHECK: vmaxss xmm8, xmm4, dword ptr [rdx - 516]
// CHECK:  encoding: [0xc5,0x5a,0x5f,0x82,0xfc,0xfd,0xff,0xff]
          vmaxss xmm8, xmm4, dword ptr [rdx - 516]

// CHECK: vminpd zmm6, zmm6, zmm22
// CHECK:  encoding: [0x62,0xb1,0xcd,0x48,0x5d,0xf6]
          vminpd zmm6, zmm6, zmm22

// CHECK: vminpd zmm6 {k7}, zmm6, zmm22
// CHECK:  encoding: [0x62,0xb1,0xcd,0x4f,0x5d,0xf6]
          vminpd zmm6 {k7}, zmm6, zmm22

// CHECK: vminpd zmm6 {k7} {z}, zmm6, zmm22
// CHECK:  encoding: [0x62,0xb1,0xcd,0xcf,0x5d,0xf6]
          vminpd zmm6 {k7} {z}, zmm6, zmm22

// CHECK: vminpd zmm6, zmm6, zmm22, {sae}
// CHECK:  encoding: [0x62,0xb1,0xcd,0x18,0x5d,0xf6]
          vminpd zmm6, zmm6, zmm22, {sae}

// CHECK: vminpd zmm6, zmm6, zmmword ptr [rcx]
// CHECK:  encoding: [0x62,0xf1,0xcd,0x48,0x5d,0x31]
          vminpd zmm6, zmm6, zmmword ptr [rcx]

// CHECK: vminpd zmm6, zmm6, zmmword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0xb1,0xcd,0x48,0x5d,0xb4,0xf0,0x23,0x01,0x00,0x00]
          vminpd zmm6, zmm6, zmmword ptr [rax + 8*r14 + 291]

// CHECK: vminpd zmm6, zmm6, qword ptr [rcx]{1to8}
// CHECK:  encoding: [0x62,0xf1,0xcd,0x58,0x5d,0x31]
          vminpd zmm6, zmm6, qword ptr [rcx]{1to8}

// CHECK: vminpd zmm6, zmm6, zmmword ptr [rdx + 8128]
// CHECK:  encoding: [0x62,0xf1,0xcd,0x48,0x5d,0x72,0x7f]
          vminpd zmm6, zmm6, zmmword ptr [rdx + 8128]

// CHECK: vminpd zmm6, zmm6, zmmword ptr [rdx + 8192]
// CHECK:  encoding: [0x62,0xf1,0xcd,0x48,0x5d,0xb2,0x00,0x20,0x00,0x00]
          vminpd zmm6, zmm6, zmmword ptr [rdx + 8192]

// CHECK: vminpd zmm6, zmm6, zmmword ptr [rdx - 8192]
// CHECK:  encoding: [0x62,0xf1,0xcd,0x48,0x5d,0x72,0x80]
          vminpd zmm6, zmm6, zmmword ptr [rdx - 8192]

// CHECK: vminpd zmm6, zmm6, zmmword ptr [rdx - 8256]
// CHECK:  encoding: [0x62,0xf1,0xcd,0x48,0x5d,0xb2,0xc0,0xdf,0xff,0xff]
          vminpd zmm6, zmm6, zmmword ptr [rdx - 8256]

// CHECK: vminpd zmm6, zmm6, qword ptr [rdx + 1016]{1to8}
// CHECK:  encoding: [0x62,0xf1,0xcd,0x58,0x5d,0x72,0x7f]
          vminpd zmm6, zmm6, qword ptr [rdx + 1016]{1to8}

// CHECK: vminpd zmm6, zmm6, qword ptr [rdx + 1024]{1to8}
// CHECK:  encoding: [0x62,0xf1,0xcd,0x58,0x5d,0xb2,0x00,0x04,0x00,0x00]
          vminpd zmm6, zmm6, qword ptr [rdx + 1024]{1to8}

// CHECK: vminpd zmm6, zmm6, qword ptr [rdx - 1024]{1to8}
// CHECK:  encoding: [0x62,0xf1,0xcd,0x58,0x5d,0x72,0x80]
          vminpd zmm6, zmm6, qword ptr [rdx - 1024]{1to8}

// CHECK: vminpd zmm6, zmm6, qword ptr [rdx - 1032]{1to8}
// CHECK:  encoding: [0x62,0xf1,0xcd,0x58,0x5d,0xb2,0xf8,0xfb,0xff,0xff]
          vminpd zmm6, zmm6, qword ptr [rdx - 1032]{1to8}

// CHECK: vminps zmm3, zmm3, zmm7
// CHECK:  encoding: [0x62,0xf1,0x64,0x48,0x5d,0xdf]
          vminps zmm3, zmm3, zmm7

// CHECK: vminps zmm3 {k3}, zmm3, zmm7
// CHECK:  encoding: [0x62,0xf1,0x64,0x4b,0x5d,0xdf]
          vminps zmm3 {k3}, zmm3, zmm7

// CHECK: vminps zmm3 {k3} {z}, zmm3, zmm7
// CHECK:  encoding: [0x62,0xf1,0x64,0xcb,0x5d,0xdf]
          vminps zmm3 {k3} {z}, zmm3, zmm7

// CHECK: vminps zmm3, zmm3, zmm7, {sae}
// CHECK:  encoding: [0x62,0xf1,0x64,0x18,0x5d,0xdf]
          vminps zmm3, zmm3, zmm7, {sae}

// CHECK: vminps zmm3, zmm3, zmmword ptr [rcx]
// CHECK:  encoding: [0x62,0xf1,0x64,0x48,0x5d,0x19]
          vminps zmm3, zmm3, zmmword ptr [rcx]

// CHECK: vminps zmm3, zmm3, zmmword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0xb1,0x64,0x48,0x5d,0x9c,0xf0,0x23,0x01,0x00,0x00]
          vminps zmm3, zmm3, zmmword ptr [rax + 8*r14 + 291]

// CHECK: vminps zmm3, zmm3, dword ptr [rcx]{1to16}
// CHECK:  encoding: [0x62,0xf1,0x64,0x58,0x5d,0x19]
          vminps zmm3, zmm3, dword ptr [rcx]{1to16}

// CHECK: vminps zmm3, zmm3, zmmword ptr [rdx + 8128]
// CHECK:  encoding: [0x62,0xf1,0x64,0x48,0x5d,0x5a,0x7f]
          vminps zmm3, zmm3, zmmword ptr [rdx + 8128]

// CHECK: vminps zmm3, zmm3, zmmword ptr [rdx + 8192]
// CHECK:  encoding: [0x62,0xf1,0x64,0x48,0x5d,0x9a,0x00,0x20,0x00,0x00]
          vminps zmm3, zmm3, zmmword ptr [rdx + 8192]

// CHECK: vminps zmm3, zmm3, zmmword ptr [rdx - 8192]
// CHECK:  encoding: [0x62,0xf1,0x64,0x48,0x5d,0x5a,0x80]
          vminps zmm3, zmm3, zmmword ptr [rdx - 8192]

// CHECK: vminps zmm3, zmm3, zmmword ptr [rdx - 8256]
// CHECK:  encoding: [0x62,0xf1,0x64,0x48,0x5d,0x9a,0xc0,0xdf,0xff,0xff]
          vminps zmm3, zmm3, zmmword ptr [rdx - 8256]

// CHECK: vminps zmm3, zmm3, dword ptr [rdx + 508]{1to16}
// CHECK:  encoding: [0x62,0xf1,0x64,0x58,0x5d,0x5a,0x7f]
          vminps zmm3, zmm3, dword ptr [rdx + 508]{1to16}

// CHECK: vminps zmm3, zmm3, dword ptr [rdx + 512]{1to16}
// CHECK:  encoding: [0x62,0xf1,0x64,0x58,0x5d,0x9a,0x00,0x02,0x00,0x00]
          vminps zmm3, zmm3, dword ptr [rdx + 512]{1to16}

// CHECK: vminps zmm3, zmm3, dword ptr [rdx - 512]{1to16}
// CHECK:  encoding: [0x62,0xf1,0x64,0x58,0x5d,0x5a,0x80]
          vminps zmm3, zmm3, dword ptr [rdx - 512]{1to16}

// CHECK: vminps zmm3, zmm3, dword ptr [rdx - 516]{1to16}
// CHECK:  encoding: [0x62,0xf1,0x64,0x58,0x5d,0x9a,0xfc,0xfd,0xff,0xff]
          vminps zmm3, zmm3, dword ptr [rdx - 516]{1to16}

// CHECK: vminsd xmm5, xmm25, xmm26
// CHECK:  encoding: [0x62,0x91,0xb7,0x00,0x5d,0xea]
          vminsd xmm5, xmm25, xmm26

// CHECK: vminsd xmm5 {k3}, xmm25, xmm26
// CHECK:  encoding: [0x62,0x91,0xb7,0x03,0x5d,0xea]
          vminsd xmm5 {k3}, xmm25, xmm26

// CHECK: vminsd xmm5 {k3} {z}, xmm25, xmm26
// CHECK:  encoding: [0x62,0x91,0xb7,0x83,0x5d,0xea]
          vminsd xmm5 {k3} {z}, xmm25, xmm26

// CHECK: vminsd xmm5, xmm25, xmm26, {sae}
// CHECK:  encoding: [0x62,0x91,0xb7,0x10,0x5d,0xea]
          vminsd xmm5, xmm25, xmm26, {sae}

// CHECK: vminsd xmm5, xmm25, qword ptr [rcx]
// CHECK:  encoding: [0x62,0xf1,0xb7,0x00,0x5d,0x29]
          vminsd xmm5, xmm25, qword ptr [rcx]

// CHECK: vminsd xmm5, xmm25, qword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0xb1,0xb7,0x00,0x5d,0xac,0xf0,0x23,0x01,0x00,0x00]
          vminsd xmm5, xmm25, qword ptr [rax + 8*r14 + 291]

// CHECK: vminsd xmm5, xmm25, qword ptr [rdx + 1016]
// CHECK:  encoding: [0x62,0xf1,0xb7,0x00,0x5d,0x6a,0x7f]
          vminsd xmm5, xmm25, qword ptr [rdx + 1016]

// CHECK: vminsd xmm5, xmm25, qword ptr [rdx + 1024]
// CHECK:  encoding: [0x62,0xf1,0xb7,0x00,0x5d,0xaa,0x00,0x04,0x00,0x00]
          vminsd xmm5, xmm25, qword ptr [rdx + 1024]

// CHECK: vminsd xmm5, xmm25, qword ptr [rdx - 1024]
// CHECK:  encoding: [0x62,0xf1,0xb7,0x00,0x5d,0x6a,0x80]
          vminsd xmm5, xmm25, qword ptr [rdx - 1024]

// CHECK: vminsd xmm5, xmm25, qword ptr [rdx - 1032]
// CHECK:  encoding: [0x62,0xf1,0xb7,0x00,0x5d,0xaa,0xf8,0xfb,0xff,0xff]
          vminsd xmm5, xmm25, qword ptr [rdx - 1032]

// CHECK: vminss xmm10, xmm17, xmm19
// CHECK:  encoding: [0x62,0x31,0x76,0x00,0x5d,0xd3]
          vminss xmm10, xmm17, xmm19

// CHECK: vminss xmm10 {k5}, xmm17, xmm19
// CHECK:  encoding: [0x62,0x31,0x76,0x05,0x5d,0xd3]
          vminss xmm10 {k5}, xmm17, xmm19

// CHECK: vminss xmm10 {k5} {z}, xmm17, xmm19
// CHECK:  encoding: [0x62,0x31,0x76,0x85,0x5d,0xd3]
          vminss xmm10 {k5} {z}, xmm17, xmm19

// CHECK: vminss xmm10, xmm17, xmm19, {sae}
// CHECK:  encoding: [0x62,0x31,0x76,0x10,0x5d,0xd3]
          vminss xmm10, xmm17, xmm19, {sae}

// CHECK: vminss xmm10, xmm17, dword ptr [rcx]
// CHECK:  encoding: [0x62,0x71,0x76,0x00,0x5d,0x11]
          vminss xmm10, xmm17, dword ptr [rcx]

// CHECK: vminss xmm10, xmm17, dword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0x31,0x76,0x00,0x5d,0x94,0xf0,0x23,0x01,0x00,0x00]
          vminss xmm10, xmm17, dword ptr [rax + 8*r14 + 291]

// CHECK: vminss xmm10, xmm17, dword ptr [rdx + 508]
// CHECK:  encoding: [0x62,0x71,0x76,0x00,0x5d,0x52,0x7f]
          vminss xmm10, xmm17, dword ptr [rdx + 508]

// CHECK: vminss xmm10, xmm17, dword ptr [rdx + 512]
// CHECK:  encoding: [0x62,0x71,0x76,0x00,0x5d,0x92,0x00,0x02,0x00,0x00]
          vminss xmm10, xmm17, dword ptr [rdx + 512]

// CHECK: vminss xmm10, xmm17, dword ptr [rdx - 512]
// CHECK:  encoding: [0x62,0x71,0x76,0x00,0x5d,0x52,0x80]
          vminss xmm10, xmm17, dword ptr [rdx - 512]

// CHECK: vminss xmm10, xmm17, dword ptr [rdx - 516]
// CHECK:  encoding: [0x62,0x71,0x76,0x00,0x5d,0x92,0xfc,0xfd,0xff,0xff]
          vminss xmm10, xmm17, dword ptr [rdx - 516]

// CHECK: vmovapd zmm7, zmm14
// CHECK:  encoding: [0x62,0xd1,0xfd,0x48,0x28,0xfe]
          vmovapd zmm7, zmm14

// CHECK: vmovapd zmm7 {k5}, zmm14
// CHECK:  encoding: [0x62,0xd1,0xfd,0x4d,0x28,0xfe]
          vmovapd zmm7 {k5}, zmm14

// CHECK: vmovapd zmm7 {k5} {z}, zmm14
// CHECK:  encoding: [0x62,0xd1,0xfd,0xcd,0x28,0xfe]
          vmovapd zmm7 {k5} {z}, zmm14

// CHECK: vmovapd zmm7, zmmword ptr [rcx]
// CHECK:  encoding: [0x62,0xf1,0xfd,0x48,0x28,0x39]
          vmovapd zmm7, zmmword ptr [rcx]

// CHECK: vmovapd zmm7, zmmword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0xb1,0xfd,0x48,0x28,0xbc,0xf0,0x23,0x01,0x00,0x00]
          vmovapd zmm7, zmmword ptr [rax + 8*r14 + 291]

// CHECK: vmovapd zmm7, zmmword ptr [rdx + 8128]
// CHECK:  encoding: [0x62,0xf1,0xfd,0x48,0x28,0x7a,0x7f]
          vmovapd zmm7, zmmword ptr [rdx + 8128]

// CHECK: vmovapd zmm7, zmmword ptr [rdx + 8192]
// CHECK:  encoding: [0x62,0xf1,0xfd,0x48,0x28,0xba,0x00,0x20,0x00,0x00]
          vmovapd zmm7, zmmword ptr [rdx + 8192]

// CHECK: vmovapd zmm7, zmmword ptr [rdx - 8192]
// CHECK:  encoding: [0x62,0xf1,0xfd,0x48,0x28,0x7a,0x80]
          vmovapd zmm7, zmmword ptr [rdx - 8192]

// CHECK: vmovapd zmm7, zmmword ptr [rdx - 8256]
// CHECK:  encoding: [0x62,0xf1,0xfd,0x48,0x28,0xba,0xc0,0xdf,0xff,0xff]
          vmovapd zmm7, zmmword ptr [rdx - 8256]

// CHECK: vmovaps zmm5, zmm9
// CHECK:  encoding: [0x62,0xd1,0x7c,0x48,0x28,0xe9]
          vmovaps zmm5, zmm9

// CHECK: vmovaps zmm5 {k1}, zmm9
// CHECK:  encoding: [0x62,0xd1,0x7c,0x49,0x28,0xe9]
          vmovaps zmm5 {k1}, zmm9

// CHECK: vmovaps zmm5 {k1} {z}, zmm9
// CHECK:  encoding: [0x62,0xd1,0x7c,0xc9,0x28,0xe9]
          vmovaps zmm5 {k1} {z}, zmm9

// CHECK: vmovaps zmm5, zmmword ptr [rcx]
// CHECK:  encoding: [0x62,0xf1,0x7c,0x48,0x28,0x29]
          vmovaps zmm5, zmmword ptr [rcx]

// CHECK: vmovaps zmm5, zmmword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0xb1,0x7c,0x48,0x28,0xac,0xf0,0x23,0x01,0x00,0x00]
          vmovaps zmm5, zmmword ptr [rax + 8*r14 + 291]

// CHECK: vmovaps zmm5, zmmword ptr [rdx + 8128]
// CHECK:  encoding: [0x62,0xf1,0x7c,0x48,0x28,0x6a,0x7f]
          vmovaps zmm5, zmmword ptr [rdx + 8128]

// CHECK: vmovaps zmm5, zmmword ptr [rdx + 8192]
// CHECK:  encoding: [0x62,0xf1,0x7c,0x48,0x28,0xaa,0x00,0x20,0x00,0x00]
          vmovaps zmm5, zmmword ptr [rdx + 8192]

// CHECK: vmovaps zmm5, zmmword ptr [rdx - 8192]
// CHECK:  encoding: [0x62,0xf1,0x7c,0x48,0x28,0x6a,0x80]
          vmovaps zmm5, zmmword ptr [rdx - 8192]

// CHECK: vmovaps zmm5, zmmword ptr [rdx - 8256]
// CHECK:  encoding: [0x62,0xf1,0x7c,0x48,0x28,0xaa,0xc0,0xdf,0xff,0xff]
          vmovaps zmm5, zmmword ptr [rdx - 8256]

// CHECK: vmovd  xmm26, eax
// CHECK:  encoding: [0x62,0x61,0x7d,0x08,0x6e,0xd0]
          vmovd  xmm26, eax

// CHECK: vmovd  xmm26, ebp
// CHECK:  encoding: [0x62,0x61,0x7d,0x08,0x6e,0xd5]
          vmovd  xmm26, ebp

// CHECK: vmovd  xmm26, r13d
// CHECK:  encoding: [0x62,0x41,0x7d,0x08,0x6e,0xd5]
          vmovd  xmm26, r13d

// CHECK: vmovd  xmm26, dword ptr [rcx]
// CHECK:  encoding: [0x62,0x61,0x7d,0x08,0x6e,0x11]
          vmovd  xmm26, dword ptr [rcx]

// CHECK: vmovd  xmm26, dword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0x21,0x7d,0x08,0x6e,0x94,0xf0,0x23,0x01,0x00,0x00]
          vmovd  xmm26, dword ptr [rax + 8*r14 + 291]

// CHECK: vmovd  xmm26, dword ptr [rdx + 508]
// CHECK:  encoding: [0x62,0x61,0x7d,0x08,0x6e,0x52,0x7f]
          vmovd  xmm26, dword ptr [rdx + 508]

// CHECK: vmovd  xmm26, dword ptr [rdx + 512]
// CHECK:  encoding: [0x62,0x61,0x7d,0x08,0x6e,0x92,0x00,0x02,0x00,0x00]
          vmovd  xmm26, dword ptr [rdx + 512]

// CHECK: vmovd  xmm26, dword ptr [rdx - 512]
// CHECK:  encoding: [0x62,0x61,0x7d,0x08,0x6e,0x52,0x80]
          vmovd  xmm26, dword ptr [rdx - 512]

// CHECK: vmovd  xmm26, dword ptr [rdx - 516]
// CHECK:  encoding: [0x62,0x61,0x7d,0x08,0x6e,0x92,0xfc,0xfd,0xff,0xff]
          vmovd  xmm26, dword ptr [rdx - 516]

// CHECK: vmovd  dword ptr [rcx], xmm5
// CHECK:  encoding: [0xc5,0xf9,0x7e,0x29]
          vmovd  dword ptr [rcx], xmm5

// CHECK: vmovd  dword ptr [rax + 8*r14 + 291], xmm5
// CHECK:  encoding: [0xc4,0xa1,0x79,0x7e,0xac,0xf0,0x23,0x01,0x00,0x00]
          vmovd  dword ptr [rax + 8*r14 + 291], xmm5

// CHECK: vmovd  dword ptr [rdx + 508], xmm5
// CHECK:  encoding: [0xc5,0xf9,0x7e,0xaa,0xfc,0x01,0x00,0x00]
          vmovd  dword ptr [rdx + 508], xmm5

// CHECK: vmovd  dword ptr [rdx + 512], xmm5
// CHECK:  encoding: [0xc5,0xf9,0x7e,0xaa,0x00,0x02,0x00,0x00]
          vmovd  dword ptr [rdx + 512], xmm5

// CHECK: vmovd  dword ptr [rdx - 512], xmm5
// CHECK:  encoding: [0xc5,0xf9,0x7e,0xaa,0x00,0xfe,0xff,0xff]
          vmovd  dword ptr [rdx - 512], xmm5

// CHECK: vmovd  dword ptr [rdx - 516], xmm5
// CHECK:  encoding: [0xc5,0xf9,0x7e,0xaa,0xfc,0xfd,0xff,0xff]
          vmovd  dword ptr [rdx - 516], xmm5

// CHECK: vmovddup zmm5, zmm29
// CHECK:  encoding: [0x62,0x91,0xff,0x48,0x12,0xed]
          vmovddup zmm5, zmm29

// CHECK: vmovddup zmm5 {k4}, zmm29
// CHECK:  encoding: [0x62,0x91,0xff,0x4c,0x12,0xed]
          vmovddup zmm5 {k4}, zmm29

// CHECK: vmovddup zmm5 {k4} {z}, zmm29
// CHECK:  encoding: [0x62,0x91,0xff,0xcc,0x12,0xed]
          vmovddup zmm5 {k4} {z}, zmm29

// CHECK: vmovddup zmm5, zmmword ptr [rcx]
// CHECK:  encoding: [0x62,0xf1,0xff,0x48,0x12,0x29]
          vmovddup zmm5, zmmword ptr [rcx]

// CHECK: vmovddup zmm5, zmmword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0xb1,0xff,0x48,0x12,0xac,0xf0,0x23,0x01,0x00,0x00]
          vmovddup zmm5, zmmword ptr [rax + 8*r14 + 291]

// CHECK: vmovddup zmm5, zmmword ptr [rdx + 8128]
// CHECK:  encoding: [0x62,0xf1,0xff,0x48,0x12,0x6a,0x7f]
          vmovddup zmm5, zmmword ptr [rdx + 8128]

// CHECK: vmovddup zmm5, zmmword ptr [rdx + 8192]
// CHECK:  encoding: [0x62,0xf1,0xff,0x48,0x12,0xaa,0x00,0x20,0x00,0x00]
          vmovddup zmm5, zmmword ptr [rdx + 8192]

// CHECK: vmovddup zmm5, zmmword ptr [rdx - 8192]
// CHECK:  encoding: [0x62,0xf1,0xff,0x48,0x12,0x6a,0x80]
          vmovddup zmm5, zmmword ptr [rdx - 8192]

// CHECK: vmovddup zmm5, zmmword ptr [rdx - 8256]
// CHECK:  encoding: [0x62,0xf1,0xff,0x48,0x12,0xaa,0xc0,0xdf,0xff,0xff]
          vmovddup zmm5, zmmword ptr [rdx - 8256]

// CHECK: vmovdqa32 zmm22, zmm18
// CHECK:  encoding: [0x62,0xa1,0x7d,0x48,0x6f,0xf2]
          vmovdqa32 zmm22, zmm18

// CHECK: vmovdqa32 zmm22 {k6}, zmm18
// CHECK:  encoding: [0x62,0xa1,0x7d,0x4e,0x6f,0xf2]
          vmovdqa32 zmm22 {k6}, zmm18

// CHECK: vmovdqa32 zmm22 {k6} {z}, zmm18
// CHECK:  encoding: [0x62,0xa1,0x7d,0xce,0x6f,0xf2]
          vmovdqa32 zmm22 {k6} {z}, zmm18

// CHECK: vmovdqa32 zmm22, zmmword ptr [rcx]
// CHECK:  encoding: [0x62,0xe1,0x7d,0x48,0x6f,0x31]
          vmovdqa32 zmm22, zmmword ptr [rcx]

// CHECK: vmovdqa32 zmm22, zmmword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0xa1,0x7d,0x48,0x6f,0xb4,0xf0,0x23,0x01,0x00,0x00]
          vmovdqa32 zmm22, zmmword ptr [rax + 8*r14 + 291]

// CHECK: vmovdqa32 zmm22, zmmword ptr [rdx + 8128]
// CHECK:  encoding: [0x62,0xe1,0x7d,0x48,0x6f,0x72,0x7f]
          vmovdqa32 zmm22, zmmword ptr [rdx + 8128]

// CHECK: vmovdqa32 zmm22, zmmword ptr [rdx + 8192]
// CHECK:  encoding: [0x62,0xe1,0x7d,0x48,0x6f,0xb2,0x00,0x20,0x00,0x00]
          vmovdqa32 zmm22, zmmword ptr [rdx + 8192]

// CHECK: vmovdqa32 zmm22, zmmword ptr [rdx - 8192]
// CHECK:  encoding: [0x62,0xe1,0x7d,0x48,0x6f,0x72,0x80]
          vmovdqa32 zmm22, zmmword ptr [rdx - 8192]

// CHECK: vmovdqa32 zmm22, zmmword ptr [rdx - 8256]
// CHECK:  encoding: [0x62,0xe1,0x7d,0x48,0x6f,0xb2,0xc0,0xdf,0xff,0xff]
          vmovdqa32 zmm22, zmmword ptr [rdx - 8256]

// CHECK: vmovdqa64 zmm22, zmm12
// CHECK:  encoding: [0x62,0xc1,0xfd,0x48,0x6f,0xf4]
          vmovdqa64 zmm22, zmm12

// CHECK: vmovdqa64 zmm22 {k5}, zmm12
// CHECK:  encoding: [0x62,0xc1,0xfd,0x4d,0x6f,0xf4]
          vmovdqa64 zmm22 {k5}, zmm12

// CHECK: vmovdqa64 zmm22 {k5} {z}, zmm12
// CHECK:  encoding: [0x62,0xc1,0xfd,0xcd,0x6f,0xf4]
          vmovdqa64 zmm22 {k5} {z}, zmm12

// CHECK: vmovdqa64 zmm22, zmmword ptr [rcx]
// CHECK:  encoding: [0x62,0xe1,0xfd,0x48,0x6f,0x31]
          vmovdqa64 zmm22, zmmword ptr [rcx]

// CHECK: vmovdqa64 zmm22, zmmword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0xa1,0xfd,0x48,0x6f,0xb4,0xf0,0x23,0x01,0x00,0x00]
          vmovdqa64 zmm22, zmmword ptr [rax + 8*r14 + 291]

// CHECK: vmovdqa64 zmm22, zmmword ptr [rdx + 8128]
// CHECK:  encoding: [0x62,0xe1,0xfd,0x48,0x6f,0x72,0x7f]
          vmovdqa64 zmm22, zmmword ptr [rdx + 8128]

// CHECK: vmovdqa64 zmm22, zmmword ptr [rdx + 8192]
// CHECK:  encoding: [0x62,0xe1,0xfd,0x48,0x6f,0xb2,0x00,0x20,0x00,0x00]
          vmovdqa64 zmm22, zmmword ptr [rdx + 8192]

// CHECK: vmovdqa64 zmm22, zmmword ptr [rdx - 8192]
// CHECK:  encoding: [0x62,0xe1,0xfd,0x48,0x6f,0x72,0x80]
          vmovdqa64 zmm22, zmmword ptr [rdx - 8192]

// CHECK: vmovdqa64 zmm22, zmmword ptr [rdx - 8256]
// CHECK:  encoding: [0x62,0xe1,0xfd,0x48,0x6f,0xb2,0xc0,0xdf,0xff,0xff]
          vmovdqa64 zmm22, zmmword ptr [rdx - 8256]

// CHECK: vmovdqu32 zmm5, zmm24
// CHECK:  encoding: [0x62,0x91,0x7e,0x48,0x6f,0xe8]
          vmovdqu32 zmm5, zmm24

// CHECK: vmovdqu32 zmm5 {k5}, zmm24
// CHECK:  encoding: [0x62,0x91,0x7e,0x4d,0x6f,0xe8]
          vmovdqu32 zmm5 {k5}, zmm24

// CHECK: vmovdqu32 zmm5 {k5} {z}, zmm24
// CHECK:  encoding: [0x62,0x91,0x7e,0xcd,0x6f,0xe8]
          vmovdqu32 zmm5 {k5} {z}, zmm24

// CHECK: vmovdqu32 zmm5, zmmword ptr [rcx]
// CHECK:  encoding: [0x62,0xf1,0x7e,0x48,0x6f,0x29]
          vmovdqu32 zmm5, zmmword ptr [rcx]

// CHECK: vmovdqu32 zmm5, zmmword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0xb1,0x7e,0x48,0x6f,0xac,0xf0,0x23,0x01,0x00,0x00]
          vmovdqu32 zmm5, zmmword ptr [rax + 8*r14 + 291]

// CHECK: vmovdqu32 zmm5, zmmword ptr [rdx + 8128]
// CHECK:  encoding: [0x62,0xf1,0x7e,0x48,0x6f,0x6a,0x7f]
          vmovdqu32 zmm5, zmmword ptr [rdx + 8128]

// CHECK: vmovdqu32 zmm5, zmmword ptr [rdx + 8192]
// CHECK:  encoding: [0x62,0xf1,0x7e,0x48,0x6f,0xaa,0x00,0x20,0x00,0x00]
          vmovdqu32 zmm5, zmmword ptr [rdx + 8192]

// CHECK: vmovdqu32 zmm5, zmmword ptr [rdx - 8192]
// CHECK:  encoding: [0x62,0xf1,0x7e,0x48,0x6f,0x6a,0x80]
          vmovdqu32 zmm5, zmmword ptr [rdx - 8192]

// CHECK: vmovdqu32 zmm5, zmmword ptr [rdx - 8256]
// CHECK:  encoding: [0x62,0xf1,0x7e,0x48,0x6f,0xaa,0xc0,0xdf,0xff,0xff]
          vmovdqu32 zmm5, zmmword ptr [rdx - 8256]

// CHECK: vmovdqu64 zmm6, zmm15
// CHECK:  encoding: [0x62,0xd1,0xfe,0x48,0x6f,0xf7]
          vmovdqu64 zmm6, zmm15

// CHECK: vmovdqu64 zmm6 {k3}, zmm15
// CHECK:  encoding: [0x62,0xd1,0xfe,0x4b,0x6f,0xf7]
          vmovdqu64 zmm6 {k3}, zmm15

// CHECK: vmovdqu64 zmm6 {k3} {z}, zmm15
// CHECK:  encoding: [0x62,0xd1,0xfe,0xcb,0x6f,0xf7]
          vmovdqu64 zmm6 {k3} {z}, zmm15

// CHECK: vmovdqu64 zmm6, zmmword ptr [rcx]
// CHECK:  encoding: [0x62,0xf1,0xfe,0x48,0x6f,0x31]
          vmovdqu64 zmm6, zmmword ptr [rcx]

// CHECK: vmovdqu64 zmm6, zmmword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0xb1,0xfe,0x48,0x6f,0xb4,0xf0,0x23,0x01,0x00,0x00]
          vmovdqu64 zmm6, zmmword ptr [rax + 8*r14 + 291]

// CHECK: vmovdqu64 zmm6, zmmword ptr [rdx + 8128]
// CHECK:  encoding: [0x62,0xf1,0xfe,0x48,0x6f,0x72,0x7f]
          vmovdqu64 zmm6, zmmword ptr [rdx + 8128]

// CHECK: vmovdqu64 zmm6, zmmword ptr [rdx + 8192]
// CHECK:  encoding: [0x62,0xf1,0xfe,0x48,0x6f,0xb2,0x00,0x20,0x00,0x00]
          vmovdqu64 zmm6, zmmword ptr [rdx + 8192]

// CHECK: vmovdqu64 zmm6, zmmword ptr [rdx - 8192]
// CHECK:  encoding: [0x62,0xf1,0xfe,0x48,0x6f,0x72,0x80]
          vmovdqu64 zmm6, zmmword ptr [rdx - 8192]

// CHECK: vmovdqu64 zmm6, zmmword ptr [rdx - 8256]
// CHECK:  encoding: [0x62,0xf1,0xfe,0x48,0x6f,0xb2,0xc0,0xdf,0xff,0xff]
          vmovdqu64 zmm6, zmmword ptr [rdx - 8256]

// CHECK: vmovhlps xmm18, xmm1, xmm23
// CHECK:  encoding: [0x62,0xa1,0x74,0x08,0x12,0xd7]
          vmovhlps xmm18, xmm1, xmm23

// CHECK: vmovhpd xmm19, xmm28, qword ptr [rcx]
// CHECK:  encoding: [0x62,0xe1,0x9d,0x00,0x16,0x19]
          vmovhpd xmm19, xmm28, qword ptr [rcx]

// CHECK: vmovhpd xmm19, xmm28, qword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0xa1,0x9d,0x00,0x16,0x9c,0xf0,0x23,0x01,0x00,0x00]
          vmovhpd xmm19, xmm28, qword ptr [rax + 8*r14 + 291]

// CHECK: vmovhpd xmm19, xmm28, qword ptr [rdx + 1016]
// CHECK:  encoding: [0x62,0xe1,0x9d,0x00,0x16,0x5a,0x7f]
          vmovhpd xmm19, xmm28, qword ptr [rdx + 1016]

// CHECK: vmovhpd xmm19, xmm28, qword ptr [rdx + 1024]
// CHECK:  encoding: [0x62,0xe1,0x9d,0x00,0x16,0x9a,0x00,0x04,0x00,0x00]
          vmovhpd xmm19, xmm28, qword ptr [rdx + 1024]

// CHECK: vmovhpd xmm19, xmm28, qword ptr [rdx - 1024]
// CHECK:  encoding: [0x62,0xe1,0x9d,0x00,0x16,0x5a,0x80]
          vmovhpd xmm19, xmm28, qword ptr [rdx - 1024]

// CHECK: vmovhpd xmm19, xmm28, qword ptr [rdx - 1032]
// CHECK:  encoding: [0x62,0xe1,0x9d,0x00,0x16,0x9a,0xf8,0xfb,0xff,0xff]
          vmovhpd xmm19, xmm28, qword ptr [rdx - 1032]

// CHECK: vmovhpd qword ptr [rcx], xmm15
// CHECK:  encoding: [0xc5,0x79,0x17,0x39]
          vmovhpd qword ptr [rcx], xmm15

// CHECK: vmovhpd qword ptr [rax + 8*r14 + 291], xmm15
// CHECK:  encoding: [0xc4,0x21,0x79,0x17,0xbc,0xf0,0x23,0x01,0x00,0x00]
          vmovhpd qword ptr [rax + 8*r14 + 291], xmm15

// CHECK: vmovhpd qword ptr [rdx + 1016], xmm15
// CHECK:  encoding: [0xc5,0x79,0x17,0xba,0xf8,0x03,0x00,0x00]
          vmovhpd qword ptr [rdx + 1016], xmm15

// CHECK: vmovhpd qword ptr [rdx + 1024], xmm15
// CHECK:  encoding: [0xc5,0x79,0x17,0xba,0x00,0x04,0x00,0x00]
          vmovhpd qword ptr [rdx + 1024], xmm15

// CHECK: vmovhpd qword ptr [rdx - 1024], xmm15
// CHECK:  encoding: [0xc5,0x79,0x17,0xba,0x00,0xfc,0xff,0xff]
          vmovhpd qword ptr [rdx - 1024], xmm15

// CHECK: vmovhpd qword ptr [rdx - 1032], xmm15
// CHECK:  encoding: [0xc5,0x79,0x17,0xba,0xf8,0xfb,0xff,0xff]
          vmovhpd qword ptr [rdx - 1032], xmm15

// CHECK: vmovhps xmm20, xmm17, qword ptr [rcx]
// CHECK:  encoding: [0x62,0xe1,0x74,0x00,0x16,0x21]
          vmovhps xmm20, xmm17, qword ptr [rcx]

// CHECK: vmovhps xmm20, xmm17, qword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0xa1,0x74,0x00,0x16,0xa4,0xf0,0x23,0x01,0x00,0x00]
          vmovhps xmm20, xmm17, qword ptr [rax + 8*r14 + 291]

// CHECK: vmovhps xmm20, xmm17, qword ptr [rdx + 1016]
// CHECK:  encoding: [0x62,0xe1,0x74,0x00,0x16,0x62,0x7f]
          vmovhps xmm20, xmm17, qword ptr [rdx + 1016]

// CHECK: vmovhps xmm20, xmm17, qword ptr [rdx + 1024]
// CHECK:  encoding: [0x62,0xe1,0x74,0x00,0x16,0xa2,0x00,0x04,0x00,0x00]
          vmovhps xmm20, xmm17, qword ptr [rdx + 1024]

// CHECK: vmovhps xmm20, xmm17, qword ptr [rdx - 1024]
// CHECK:  encoding: [0x62,0xe1,0x74,0x00,0x16,0x62,0x80]
          vmovhps xmm20, xmm17, qword ptr [rdx - 1024]

// CHECK: vmovhps xmm20, xmm17, qword ptr [rdx - 1032]
// CHECK:  encoding: [0x62,0xe1,0x74,0x00,0x16,0xa2,0xf8,0xfb,0xff,0xff]
          vmovhps xmm20, xmm17, qword ptr [rdx - 1032]

// CHECK: vmovhps qword ptr [rcx], xmm18
// CHECK:  encoding: [0x62,0xe1,0x7c,0x08,0x17,0x11]
          vmovhps qword ptr [rcx], xmm18

// CHECK: vmovhps qword ptr [rax + 8*r14 + 291], xmm18
// CHECK:  encoding: [0x62,0xa1,0x7c,0x08,0x17,0x94,0xf0,0x23,0x01,0x00,0x00]
          vmovhps qword ptr [rax + 8*r14 + 291], xmm18

// CHECK: vmovhps qword ptr [rdx + 1016], xmm18
// CHECK:  encoding: [0x62,0xe1,0x7c,0x08,0x17,0x52,0x7f]
          vmovhps qword ptr [rdx + 1016], xmm18

// CHECK: vmovhps qword ptr [rdx + 1024], xmm18
// CHECK:  encoding: [0x62,0xe1,0x7c,0x08,0x17,0x92,0x00,0x04,0x00,0x00]
          vmovhps qword ptr [rdx + 1024], xmm18

// CHECK: vmovhps qword ptr [rdx - 1024], xmm18
// CHECK:  encoding: [0x62,0xe1,0x7c,0x08,0x17,0x52,0x80]
          vmovhps qword ptr [rdx - 1024], xmm18

// CHECK: vmovhps qword ptr [rdx - 1032], xmm18
// CHECK:  encoding: [0x62,0xe1,0x7c,0x08,0x17,0x92,0xf8,0xfb,0xff,0xff]
          vmovhps qword ptr [rdx - 1032], xmm18

// CHECK: vmovlhps xmm13, xmm13, xmm28
// CHECK:  encoding: [0x62,0x11,0x14,0x08,0x16,0xec]
          vmovlhps xmm13, xmm13, xmm28

// CHECK: vmovlpd xmm29, xmm6, qword ptr [rcx]
// CHECK:  encoding: [0x62,0x61,0xcd,0x08,0x12,0x29]
          vmovlpd xmm29, xmm6, qword ptr [rcx]

// CHECK: vmovlpd xmm29, xmm6, qword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0x21,0xcd,0x08,0x12,0xac,0xf0,0x23,0x01,0x00,0x00]
          vmovlpd xmm29, xmm6, qword ptr [rax + 8*r14 + 291]

// CHECK: vmovlpd xmm29, xmm6, qword ptr [rdx + 1016]
// CHECK:  encoding: [0x62,0x61,0xcd,0x08,0x12,0x6a,0x7f]
          vmovlpd xmm29, xmm6, qword ptr [rdx + 1016]

// CHECK: vmovlpd xmm29, xmm6, qword ptr [rdx + 1024]
// CHECK:  encoding: [0x62,0x61,0xcd,0x08,0x12,0xaa,0x00,0x04,0x00,0x00]
          vmovlpd xmm29, xmm6, qword ptr [rdx + 1024]

// CHECK: vmovlpd xmm29, xmm6, qword ptr [rdx - 1024]
// CHECK:  encoding: [0x62,0x61,0xcd,0x08,0x12,0x6a,0x80]
          vmovlpd xmm29, xmm6, qword ptr [rdx - 1024]

// CHECK: vmovlpd xmm29, xmm6, qword ptr [rdx - 1032]
// CHECK:  encoding: [0x62,0x61,0xcd,0x08,0x12,0xaa,0xf8,0xfb,0xff,0xff]
          vmovlpd xmm29, xmm6, qword ptr [rdx - 1032]

// CHECK: vmovlpd qword ptr [rcx], xmm15
// CHECK:  encoding: [0xc5,0x79,0x13,0x39]
          vmovlpd qword ptr [rcx], xmm15

// CHECK: vmovlpd qword ptr [rax + 8*r14 + 291], xmm15
// CHECK:  encoding: [0xc4,0x21,0x79,0x13,0xbc,0xf0,0x23,0x01,0x00,0x00]
          vmovlpd qword ptr [rax + 8*r14 + 291], xmm15

// CHECK: vmovlpd qword ptr [rdx + 1016], xmm15
// CHECK:  encoding: [0xc5,0x79,0x13,0xba,0xf8,0x03,0x00,0x00]
          vmovlpd qword ptr [rdx + 1016], xmm15

// CHECK: vmovlpd qword ptr [rdx + 1024], xmm15
// CHECK:  encoding: [0xc5,0x79,0x13,0xba,0x00,0x04,0x00,0x00]
          vmovlpd qword ptr [rdx + 1024], xmm15

// CHECK: vmovlpd qword ptr [rdx - 1024], xmm15
// CHECK:  encoding: [0xc5,0x79,0x13,0xba,0x00,0xfc,0xff,0xff]
          vmovlpd qword ptr [rdx - 1024], xmm15

// CHECK: vmovlpd qword ptr [rdx - 1032], xmm15
// CHECK:  encoding: [0xc5,0x79,0x13,0xba,0xf8,0xfb,0xff,0xff]
          vmovlpd qword ptr [rdx - 1032], xmm15

// CHECK: vmovlps xmm7, xmm20, qword ptr [rcx]
// CHECK:  encoding: [0x62,0xf1,0x5c,0x00,0x12,0x39]
          vmovlps xmm7, xmm20, qword ptr [rcx]

// CHECK: vmovlps xmm7, xmm20, qword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0xb1,0x5c,0x00,0x12,0xbc,0xf0,0x23,0x01,0x00,0x00]
          vmovlps xmm7, xmm20, qword ptr [rax + 8*r14 + 291]

// CHECK: vmovlps xmm7, xmm20, qword ptr [rdx + 1016]
// CHECK:  encoding: [0x62,0xf1,0x5c,0x00,0x12,0x7a,0x7f]
          vmovlps xmm7, xmm20, qword ptr [rdx + 1016]

// CHECK: vmovlps xmm7, xmm20, qword ptr [rdx + 1024]
// CHECK:  encoding: [0x62,0xf1,0x5c,0x00,0x12,0xba,0x00,0x04,0x00,0x00]
          vmovlps xmm7, xmm20, qword ptr [rdx + 1024]

// CHECK: vmovlps xmm7, xmm20, qword ptr [rdx - 1024]
// CHECK:  encoding: [0x62,0xf1,0x5c,0x00,0x12,0x7a,0x80]
          vmovlps xmm7, xmm20, qword ptr [rdx - 1024]

// CHECK: vmovlps xmm7, xmm20, qword ptr [rdx - 1032]
// CHECK:  encoding: [0x62,0xf1,0x5c,0x00,0x12,0xba,0xf8,0xfb,0xff,0xff]
          vmovlps xmm7, xmm20, qword ptr [rdx - 1032]

// CHECK: vmovlps qword ptr [rcx], xmm27
// CHECK:  encoding: [0x62,0x61,0x7c,0x08,0x13,0x19]
          vmovlps qword ptr [rcx], xmm27

// CHECK: vmovlps qword ptr [rax + 8*r14 + 291], xmm27
// CHECK:  encoding: [0x62,0x21,0x7c,0x08,0x13,0x9c,0xf0,0x23,0x01,0x00,0x00]
          vmovlps qword ptr [rax + 8*r14 + 291], xmm27

// CHECK: vmovlps qword ptr [rdx + 1016], xmm27
// CHECK:  encoding: [0x62,0x61,0x7c,0x08,0x13,0x5a,0x7f]
          vmovlps qword ptr [rdx + 1016], xmm27

// CHECK: vmovlps qword ptr [rdx + 1024], xmm27
// CHECK:  encoding: [0x62,0x61,0x7c,0x08,0x13,0x9a,0x00,0x04,0x00,0x00]
          vmovlps qword ptr [rdx + 1024], xmm27

// CHECK: vmovlps qword ptr [rdx - 1024], xmm27
// CHECK:  encoding: [0x62,0x61,0x7c,0x08,0x13,0x5a,0x80]
          vmovlps qword ptr [rdx - 1024], xmm27

// CHECK: vmovlps qword ptr [rdx - 1032], xmm27
// CHECK:  encoding: [0x62,0x61,0x7c,0x08,0x13,0x9a,0xf8,0xfb,0xff,0xff]
          vmovlps qword ptr [rdx - 1032], xmm27

// CHECK: vmovntdq zmmword ptr [rcx], zmm24
// CHECK:  encoding: [0x62,0x61,0x7d,0x48,0xe7,0x01]
          vmovntdq zmmword ptr [rcx], zmm24

// CHECK: vmovntdq zmmword ptr [rax + 8*r14 + 291], zmm24
// CHECK:  encoding: [0x62,0x21,0x7d,0x48,0xe7,0x84,0xf0,0x23,0x01,0x00,0x00]
          vmovntdq zmmword ptr [rax + 8*r14 + 291], zmm24

// CHECK: vmovntdq zmmword ptr [rdx + 8128], zmm24
// CHECK:  encoding: [0x62,0x61,0x7d,0x48,0xe7,0x42,0x7f]
          vmovntdq zmmword ptr [rdx + 8128], zmm24

// CHECK: vmovntdq zmmword ptr [rdx + 8192], zmm24
// CHECK:  encoding: [0x62,0x61,0x7d,0x48,0xe7,0x82,0x00,0x20,0x00,0x00]
          vmovntdq zmmword ptr [rdx + 8192], zmm24

// CHECK: vmovntdq zmmword ptr [rdx - 8192], zmm24
// CHECK:  encoding: [0x62,0x61,0x7d,0x48,0xe7,0x42,0x80]
          vmovntdq zmmword ptr [rdx - 8192], zmm24

// CHECK: vmovntdq zmmword ptr [rdx - 8256], zmm24
// CHECK:  encoding: [0x62,0x61,0x7d,0x48,0xe7,0x82,0xc0,0xdf,0xff,0xff]
          vmovntdq zmmword ptr [rdx - 8256], zmm24

// CHECK: vmovntdqa zmm17, zmmword ptr [rcx]
// CHECK:  encoding: [0x62,0xe2,0x7d,0x48,0x2a,0x09]
          vmovntdqa zmm17, zmmword ptr [rcx]

// CHECK: vmovntdqa zmm17, zmmword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0xa2,0x7d,0x48,0x2a,0x8c,0xf0,0x23,0x01,0x00,0x00]
          vmovntdqa zmm17, zmmword ptr [rax + 8*r14 + 291]

// CHECK: vmovntdqa zmm17, zmmword ptr [rdx + 8128]
// CHECK:  encoding: [0x62,0xe2,0x7d,0x48,0x2a,0x4a,0x7f]
          vmovntdqa zmm17, zmmword ptr [rdx + 8128]

// CHECK: vmovntdqa zmm17, zmmword ptr [rdx + 8192]
// CHECK:  encoding: [0x62,0xe2,0x7d,0x48,0x2a,0x8a,0x00,0x20,0x00,0x00]
          vmovntdqa zmm17, zmmword ptr [rdx + 8192]

// CHECK: vmovntdqa zmm17, zmmword ptr [rdx - 8192]
// CHECK:  encoding: [0x62,0xe2,0x7d,0x48,0x2a,0x4a,0x80]
          vmovntdqa zmm17, zmmword ptr [rdx - 8192]

// CHECK: vmovntdqa zmm17, zmmword ptr [rdx - 8256]
// CHECK:  encoding: [0x62,0xe2,0x7d,0x48,0x2a,0x8a,0xc0,0xdf,0xff,0xff]
          vmovntdqa zmm17, zmmword ptr [rdx - 8256]

// CHECK: vmovntpd zmmword ptr [rcx], zmm17
// CHECK:  encoding: [0x62,0xe1,0xfd,0x48,0x2b,0x09]
          vmovntpd zmmword ptr [rcx], zmm17

// CHECK: vmovntpd zmmword ptr [rax + 8*r14 + 291], zmm17
// CHECK:  encoding: [0x62,0xa1,0xfd,0x48,0x2b,0x8c,0xf0,0x23,0x01,0x00,0x00]
          vmovntpd zmmword ptr [rax + 8*r14 + 291], zmm17

// CHECK: vmovntpd zmmword ptr [rdx + 8128], zmm17
// CHECK:  encoding: [0x62,0xe1,0xfd,0x48,0x2b,0x4a,0x7f]
          vmovntpd zmmword ptr [rdx + 8128], zmm17

// CHECK: vmovntpd zmmword ptr [rdx + 8192], zmm17
// CHECK:  encoding: [0x62,0xe1,0xfd,0x48,0x2b,0x8a,0x00,0x20,0x00,0x00]
          vmovntpd zmmword ptr [rdx + 8192], zmm17

// CHECK: vmovntpd zmmword ptr [rdx - 8192], zmm17
// CHECK:  encoding: [0x62,0xe1,0xfd,0x48,0x2b,0x4a,0x80]
          vmovntpd zmmword ptr [rdx - 8192], zmm17

// CHECK: vmovntpd zmmword ptr [rdx - 8256], zmm17
// CHECK:  encoding: [0x62,0xe1,0xfd,0x48,0x2b,0x8a,0xc0,0xdf,0xff,0xff]
          vmovntpd zmmword ptr [rdx - 8256], zmm17

// CHECK: vmovntps zmmword ptr [rcx], zmm5
// CHECK:  encoding: [0x62,0xf1,0x7c,0x48,0x2b,0x29]
          vmovntps zmmword ptr [rcx], zmm5

// CHECK: vmovntps zmmword ptr [rax + 8*r14 + 291], zmm5
// CHECK:  encoding: [0x62,0xb1,0x7c,0x48,0x2b,0xac,0xf0,0x23,0x01,0x00,0x00]
          vmovntps zmmword ptr [rax + 8*r14 + 291], zmm5

// CHECK: vmovntps zmmword ptr [rdx + 8128], zmm5
// CHECK:  encoding: [0x62,0xf1,0x7c,0x48,0x2b,0x6a,0x7f]
          vmovntps zmmword ptr [rdx + 8128], zmm5

// CHECK: vmovntps zmmword ptr [rdx + 8192], zmm5
// CHECK:  encoding: [0x62,0xf1,0x7c,0x48,0x2b,0xaa,0x00,0x20,0x00,0x00]
          vmovntps zmmword ptr [rdx + 8192], zmm5

// CHECK: vmovntps zmmword ptr [rdx - 8192], zmm5
// CHECK:  encoding: [0x62,0xf1,0x7c,0x48,0x2b,0x6a,0x80]
          vmovntps zmmword ptr [rdx - 8192], zmm5

// CHECK: vmovntps zmmword ptr [rdx - 8256], zmm5
// CHECK:  encoding: [0x62,0xf1,0x7c,0x48,0x2b,0xaa,0xc0,0xdf,0xff,0xff]
          vmovntps zmmword ptr [rdx - 8256], zmm5

// CHECK: vmovsd xmm25, qword ptr [rcx]
// CHECK:  encoding: [0x62,0x61,0xff,0x08,0x10,0x09]
          vmovsd xmm25, qword ptr [rcx]

// CHECK: vmovsd xmm25 {k3}, qword ptr [rcx]
// CHECK:  encoding: [0x62,0x61,0xff,0x0b,0x10,0x09]
          vmovsd xmm25 {k3}, qword ptr [rcx]

// CHECK: vmovsd xmm25 {k3} {z}, qword ptr [rcx]
// CHECK:  encoding: [0x62,0x61,0xff,0x8b,0x10,0x09]
          vmovsd xmm25 {k3} {z}, qword ptr [rcx]

// CHECK: vmovsd xmm25, qword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0x21,0xff,0x08,0x10,0x8c,0xf0,0x23,0x01,0x00,0x00]
          vmovsd xmm25, qword ptr [rax + 8*r14 + 291]

// CHECK: vmovsd xmm25, qword ptr [rdx + 1016]
// CHECK:  encoding: [0x62,0x61,0xff,0x08,0x10,0x4a,0x7f]
          vmovsd xmm25, qword ptr [rdx + 1016]

// CHECK: vmovsd xmm25, qword ptr [rdx + 1024]
// CHECK:  encoding: [0x62,0x61,0xff,0x08,0x10,0x8a,0x00,0x04,0x00,0x00]
          vmovsd xmm25, qword ptr [rdx + 1024]

// CHECK: vmovsd xmm25, qword ptr [rdx - 1024]
// CHECK:  encoding: [0x62,0x61,0xff,0x08,0x10,0x4a,0x80]
          vmovsd xmm25, qword ptr [rdx - 1024]

// CHECK: vmovsd xmm25, qword ptr [rdx - 1032]
// CHECK:  encoding: [0x62,0x61,0xff,0x08,0x10,0x8a,0xf8,0xfb,0xff,0xff]
          vmovsd xmm25, qword ptr [rdx - 1032]

// CHECK: vmovsd qword ptr [rcx], xmm25
// CHECK:  encoding: [0x62,0x61,0xff,0x08,0x11,0x09]
          vmovsd qword ptr [rcx], xmm25

// CHECK: vmovsd qword ptr [rcx] {k2}, xmm25
// CHECK:  encoding: [0x62,0x61,0xff,0x0a,0x11,0x09]
          vmovsd qword ptr [rcx] {k2}, xmm25

// CHECK: vmovsd qword ptr [rax + 8*r14 + 291], xmm25
// CHECK:  encoding: [0x62,0x21,0xff,0x08,0x11,0x8c,0xf0,0x23,0x01,0x00,0x00]
          vmovsd qword ptr [rax + 8*r14 + 291], xmm25

// CHECK: vmovsd qword ptr [rdx + 1016], xmm25
// CHECK:  encoding: [0x62,0x61,0xff,0x08,0x11,0x4a,0x7f]
          vmovsd qword ptr [rdx + 1016], xmm25

// CHECK: vmovsd qword ptr [rdx + 1024], xmm25
// CHECK:  encoding: [0x62,0x61,0xff,0x08,0x11,0x8a,0x00,0x04,0x00,0x00]
          vmovsd qword ptr [rdx + 1024], xmm25

// CHECK: vmovsd qword ptr [rdx - 1024], xmm25
// CHECK:  encoding: [0x62,0x61,0xff,0x08,0x11,0x4a,0x80]
          vmovsd qword ptr [rdx - 1024], xmm25

// CHECK: vmovsd qword ptr [rdx - 1032], xmm25
// CHECK:  encoding: [0x62,0x61,0xff,0x08,0x11,0x8a,0xf8,0xfb,0xff,0xff]
          vmovsd qword ptr [rdx - 1032], xmm25

// CHECK: vmovsd xmm27, xmm3, xmm19
// CHECK:  encoding: [0x62,0x21,0xe7,0x08,0x10,0xdb]
          vmovsd xmm27, xmm3, xmm19

// CHECK: vmovsd xmm27 {k3}, xmm3, xmm19
// CHECK:  encoding: [0x62,0x21,0xe7,0x0b,0x10,0xdb]
          vmovsd xmm27 {k3}, xmm3, xmm19

// CHECK: vmovsd xmm27 {k3} {z}, xmm3, xmm19
// CHECK:  encoding: [0x62,0x21,0xe7,0x8b,0x10,0xdb]
          vmovsd xmm27 {k3} {z}, xmm3, xmm19

// CHECK: vmovshdup zmm16, zmm27
// CHECK:  encoding: [0x62,0x81,0x7e,0x48,0x16,0xc3]
          vmovshdup zmm16, zmm27

// CHECK: vmovshdup zmm16 {k4}, zmm27
// CHECK:  encoding: [0x62,0x81,0x7e,0x4c,0x16,0xc3]
          vmovshdup zmm16 {k4}, zmm27

// CHECK: vmovshdup zmm16 {k4} {z}, zmm27
// CHECK:  encoding: [0x62,0x81,0x7e,0xcc,0x16,0xc3]
          vmovshdup zmm16 {k4} {z}, zmm27

// CHECK: vmovshdup zmm16, zmmword ptr [rcx]
// CHECK:  encoding: [0x62,0xe1,0x7e,0x48,0x16,0x01]
          vmovshdup zmm16, zmmword ptr [rcx]

// CHECK: vmovshdup zmm16, zmmword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0xa1,0x7e,0x48,0x16,0x84,0xf0,0x23,0x01,0x00,0x00]
          vmovshdup zmm16, zmmword ptr [rax + 8*r14 + 291]

// CHECK: vmovshdup zmm16, zmmword ptr [rdx + 8128]
// CHECK:  encoding: [0x62,0xe1,0x7e,0x48,0x16,0x42,0x7f]
          vmovshdup zmm16, zmmword ptr [rdx + 8128]

// CHECK: vmovshdup zmm16, zmmword ptr [rdx + 8192]
// CHECK:  encoding: [0x62,0xe1,0x7e,0x48,0x16,0x82,0x00,0x20,0x00,0x00]
          vmovshdup zmm16, zmmword ptr [rdx + 8192]

// CHECK: vmovshdup zmm16, zmmword ptr [rdx - 8192]
// CHECK:  encoding: [0x62,0xe1,0x7e,0x48,0x16,0x42,0x80]
          vmovshdup zmm16, zmmword ptr [rdx - 8192]

// CHECK: vmovshdup zmm16, zmmword ptr [rdx - 8256]
// CHECK:  encoding: [0x62,0xe1,0x7e,0x48,0x16,0x82,0xc0,0xdf,0xff,0xff]
          vmovshdup zmm16, zmmword ptr [rdx - 8256]

// CHECK: vmovsldup zmm13, zmm14
// CHECK:  encoding: [0x62,0x51,0x7e,0x48,0x12,0xee]
          vmovsldup zmm13, zmm14

// CHECK: vmovsldup zmm13 {k6}, zmm14
// CHECK:  encoding: [0x62,0x51,0x7e,0x4e,0x12,0xee]
          vmovsldup zmm13 {k6}, zmm14

// CHECK: vmovsldup zmm13 {k6} {z}, zmm14
// CHECK:  encoding: [0x62,0x51,0x7e,0xce,0x12,0xee]
          vmovsldup zmm13 {k6} {z}, zmm14

// CHECK: vmovsldup zmm13, zmmword ptr [rcx]
// CHECK:  encoding: [0x62,0x71,0x7e,0x48,0x12,0x29]
          vmovsldup zmm13, zmmword ptr [rcx]

// CHECK: vmovsldup zmm13, zmmword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0x31,0x7e,0x48,0x12,0xac,0xf0,0x23,0x01,0x00,0x00]
          vmovsldup zmm13, zmmword ptr [rax + 8*r14 + 291]

// CHECK: vmovsldup zmm13, zmmword ptr [rdx + 8128]
// CHECK:  encoding: [0x62,0x71,0x7e,0x48,0x12,0x6a,0x7f]
          vmovsldup zmm13, zmmword ptr [rdx + 8128]

// CHECK: vmovsldup zmm13, zmmword ptr [rdx + 8192]
// CHECK:  encoding: [0x62,0x71,0x7e,0x48,0x12,0xaa,0x00,0x20,0x00,0x00]
          vmovsldup zmm13, zmmword ptr [rdx + 8192]

// CHECK: vmovsldup zmm13, zmmword ptr [rdx - 8192]
// CHECK:  encoding: [0x62,0x71,0x7e,0x48,0x12,0x6a,0x80]
          vmovsldup zmm13, zmmword ptr [rdx - 8192]

// CHECK: vmovsldup zmm13, zmmword ptr [rdx - 8256]
// CHECK:  encoding: [0x62,0x71,0x7e,0x48,0x12,0xaa,0xc0,0xdf,0xff,0xff]
          vmovsldup zmm13, zmmword ptr [rdx - 8256]

// CHECK: vmovss xmm2, dword ptr [rcx]
// CHECK:  encoding: [0xc5,0xfa,0x10,0x11]
          vmovss xmm2, dword ptr [rcx]

// CHECK: vmovss xmm2 {k4}, dword ptr [rcx]
// CHECK:  encoding: [0x62,0xf1,0x7e,0x0c,0x10,0x11]
          vmovss xmm2 {k4}, dword ptr [rcx]

// CHECK: vmovss xmm2 {k4} {z}, dword ptr [rcx]
// CHECK:  encoding: [0x62,0xf1,0x7e,0x8c,0x10,0x11]
          vmovss xmm2 {k4} {z}, dword ptr [rcx]

// CHECK: vmovss xmm2, dword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0xc4,0xa1,0x7a,0x10,0x94,0xf0,0x23,0x01,0x00,0x00]
          vmovss xmm2, dword ptr [rax + 8*r14 + 291]

// CHECK: vmovss xmm2, dword ptr [rdx + 508]
// CHECK:  encoding: [0xc5,0xfa,0x10,0x92,0xfc,0x01,0x00,0x00]
          vmovss xmm2, dword ptr [rdx + 508]

// CHECK: vmovss xmm2, dword ptr [rdx + 512]
// CHECK:  encoding: [0xc5,0xfa,0x10,0x92,0x00,0x02,0x00,0x00]
          vmovss xmm2, dword ptr [rdx + 512]

// CHECK: vmovss xmm2, dword ptr [rdx - 512]
// CHECK:  encoding: [0xc5,0xfa,0x10,0x92,0x00,0xfe,0xff,0xff]
          vmovss xmm2, dword ptr [rdx - 512]

// CHECK: vmovss xmm2, dword ptr [rdx - 516]
// CHECK:  encoding: [0xc5,0xfa,0x10,0x92,0xfc,0xfd,0xff,0xff]
          vmovss xmm2, dword ptr [rdx - 516]

// CHECK: vmovss dword ptr [rcx], xmm5
// CHECK:  encoding: [0xc5,0xfa,0x11,0x29]
          vmovss dword ptr [rcx], xmm5

// CHECK: vmovss dword ptr [rcx] {k6}, xmm5
// CHECK:  encoding: [0x62,0xf1,0x7e,0x0e,0x11,0x29]
          vmovss dword ptr [rcx] {k6}, xmm5

// CHECK: vmovss dword ptr [rax + 8*r14 + 291], xmm5
// CHECK:  encoding: [0xc4,0xa1,0x7a,0x11,0xac,0xf0,0x23,0x01,0x00,0x00]
          vmovss dword ptr [rax + 8*r14 + 291], xmm5

// CHECK: vmovss dword ptr [rdx + 508], xmm5
// CHECK:  encoding: [0xc5,0xfa,0x11,0xaa,0xfc,0x01,0x00,0x00]
          vmovss dword ptr [rdx + 508], xmm5

// CHECK: vmovss dword ptr [rdx + 512], xmm5
// CHECK:  encoding: [0xc5,0xfa,0x11,0xaa,0x00,0x02,0x00,0x00]
          vmovss dword ptr [rdx + 512], xmm5

// CHECK: vmovss dword ptr [rdx - 512], xmm5
// CHECK:  encoding: [0xc5,0xfa,0x11,0xaa,0x00,0xfe,0xff,0xff]
          vmovss dword ptr [rdx - 512], xmm5

// CHECK: vmovss dword ptr [rdx - 516], xmm5
// CHECK:  encoding: [0xc5,0xfa,0x11,0xaa,0xfc,0xfd,0xff,0xff]
          vmovss dword ptr [rdx - 516], xmm5

// CHECK: vmovss xmm28, xmm9, xmm26
// CHECK:  encoding: [0x62,0x01,0x36,0x08,0x10,0xe2]
          vmovss xmm28, xmm9, xmm26

// CHECK: vmovss xmm28 {k4}, xmm9, xmm26
// CHECK:  encoding: [0x62,0x01,0x36,0x0c,0x10,0xe2]
          vmovss xmm28 {k4}, xmm9, xmm26

// CHECK: vmovss xmm28 {k4} {z}, xmm9, xmm26
// CHECK:  encoding: [0x62,0x01,0x36,0x8c,0x10,0xe2]
          vmovss xmm28 {k4} {z}, xmm9, xmm26

// CHECK: vmovupd zmm27, zmm9
// CHECK:  encoding: [0x62,0x41,0xfd,0x48,0x10,0xd9]
          vmovupd zmm27, zmm9

// CHECK: vmovupd zmm27 {k2}, zmm9
// CHECK:  encoding: [0x62,0x41,0xfd,0x4a,0x10,0xd9]
          vmovupd zmm27 {k2}, zmm9

// CHECK: vmovupd zmm27 {k2} {z}, zmm9
// CHECK:  encoding: [0x62,0x41,0xfd,0xca,0x10,0xd9]
          vmovupd zmm27 {k2} {z}, zmm9

// CHECK: vmovupd zmm27, zmmword ptr [rcx]
// CHECK:  encoding: [0x62,0x61,0xfd,0x48,0x10,0x19]
          vmovupd zmm27, zmmword ptr [rcx]

// CHECK: vmovupd zmm27, zmmword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0x21,0xfd,0x48,0x10,0x9c,0xf0,0x23,0x01,0x00,0x00]
          vmovupd zmm27, zmmword ptr [rax + 8*r14 + 291]

// CHECK: vmovupd zmm27, zmmword ptr [rdx + 8128]
// CHECK:  encoding: [0x62,0x61,0xfd,0x48,0x10,0x5a,0x7f]
          vmovupd zmm27, zmmword ptr [rdx + 8128]

// CHECK: vmovupd zmm27, zmmword ptr [rdx + 8192]
// CHECK:  encoding: [0x62,0x61,0xfd,0x48,0x10,0x9a,0x00,0x20,0x00,0x00]
          vmovupd zmm27, zmmword ptr [rdx + 8192]

// CHECK: vmovupd zmm27, zmmword ptr [rdx - 8192]
// CHECK:  encoding: [0x62,0x61,0xfd,0x48,0x10,0x5a,0x80]
          vmovupd zmm27, zmmword ptr [rdx - 8192]

// CHECK: vmovupd zmm27, zmmword ptr [rdx - 8256]
// CHECK:  encoding: [0x62,0x61,0xfd,0x48,0x10,0x9a,0xc0,0xdf,0xff,0xff]
          vmovupd zmm27, zmmword ptr [rdx - 8256]

// CHECK: vmovups zmm22, zmm22
// CHECK:  encoding: [0x62,0xa1,0x7c,0x48,0x10,0xf6]
          vmovups zmm22, zmm22

// CHECK: vmovups zmm22 {k3}, zmm22
// CHECK:  encoding: [0x62,0xa1,0x7c,0x4b,0x10,0xf6]
          vmovups zmm22 {k3}, zmm22

// CHECK: vmovups zmm22 {k3} {z}, zmm22
// CHECK:  encoding: [0x62,0xa1,0x7c,0xcb,0x10,0xf6]
          vmovups zmm22 {k3} {z}, zmm22

// CHECK: vmovups zmm22, zmmword ptr [rcx]
// CHECK:  encoding: [0x62,0xe1,0x7c,0x48,0x10,0x31]
          vmovups zmm22, zmmword ptr [rcx]

// CHECK: vmovups zmm22, zmmword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0xa1,0x7c,0x48,0x10,0xb4,0xf0,0x23,0x01,0x00,0x00]
          vmovups zmm22, zmmword ptr [rax + 8*r14 + 291]

// CHECK: vmovups zmm22, zmmword ptr [rdx + 8128]
// CHECK:  encoding: [0x62,0xe1,0x7c,0x48,0x10,0x72,0x7f]
          vmovups zmm22, zmmword ptr [rdx + 8128]

// CHECK: vmovups zmm22, zmmword ptr [rdx + 8192]
// CHECK:  encoding: [0x62,0xe1,0x7c,0x48,0x10,0xb2,0x00,0x20,0x00,0x00]
          vmovups zmm22, zmmword ptr [rdx + 8192]

// CHECK: vmovups zmm22, zmmword ptr [rdx - 8192]
// CHECK:  encoding: [0x62,0xe1,0x7c,0x48,0x10,0x72,0x80]
          vmovups zmm22, zmmword ptr [rdx - 8192]

// CHECK: vmovups zmm22, zmmword ptr [rdx - 8256]
// CHECK:  encoding: [0x62,0xe1,0x7c,0x48,0x10,0xb2,0xc0,0xdf,0xff,0xff]
          vmovups zmm22, zmmword ptr [rdx - 8256]

// CHECK: vmulpd zmm24, zmm4, zmm23
// CHECK:  encoding: [0x62,0x21,0xdd,0x48,0x59,0xc7]
          vmulpd zmm24, zmm4, zmm23

// CHECK: vmulpd zmm24 {k6}, zmm4, zmm23
// CHECK:  encoding: [0x62,0x21,0xdd,0x4e,0x59,0xc7]
          vmulpd zmm24 {k6}, zmm4, zmm23

// CHECK: vmulpd zmm24 {k6} {z}, zmm4, zmm23
// CHECK:  encoding: [0x62,0x21,0xdd,0xce,0x59,0xc7]
          vmulpd zmm24 {k6} {z}, zmm4, zmm23

// CHECK: vmulpd zmm24, zmm4, zmm23, {rn-sae}
// CHECK:  encoding: [0x62,0x21,0xdd,0x18,0x59,0xc7]
          vmulpd zmm24, zmm4, zmm23, {rn-sae}

// CHECK: vmulpd zmm24, zmm4, zmm23, {ru-sae}
// CHECK:  encoding: [0x62,0x21,0xdd,0x58,0x59,0xc7]
          vmulpd zmm24, zmm4, zmm23, {ru-sae}

// CHECK: vmulpd zmm24, zmm4, zmm23, {rd-sae}
// CHECK:  encoding: [0x62,0x21,0xdd,0x38,0x59,0xc7]
          vmulpd zmm24, zmm4, zmm23, {rd-sae}

// CHECK: vmulpd zmm24, zmm4, zmm23, {rz-sae}
// CHECK:  encoding: [0x62,0x21,0xdd,0x78,0x59,0xc7]
          vmulpd zmm24, zmm4, zmm23, {rz-sae}

// CHECK: vmulpd zmm24, zmm4, zmmword ptr [rcx]
// CHECK:  encoding: [0x62,0x61,0xdd,0x48,0x59,0x01]
          vmulpd zmm24, zmm4, zmmword ptr [rcx]

// CHECK: vmulpd zmm24, zmm4, zmmword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0x21,0xdd,0x48,0x59,0x84,0xf0,0x23,0x01,0x00,0x00]
          vmulpd zmm24, zmm4, zmmword ptr [rax + 8*r14 + 291]

// CHECK: vmulpd zmm24, zmm4, qword ptr [rcx]{1to8}
// CHECK:  encoding: [0x62,0x61,0xdd,0x58,0x59,0x01]
          vmulpd zmm24, zmm4, qword ptr [rcx]{1to8}

// CHECK: vmulpd zmm24, zmm4, zmmword ptr [rdx + 8128]
// CHECK:  encoding: [0x62,0x61,0xdd,0x48,0x59,0x42,0x7f]
          vmulpd zmm24, zmm4, zmmword ptr [rdx + 8128]

// CHECK: vmulpd zmm24, zmm4, zmmword ptr [rdx + 8192]
// CHECK:  encoding: [0x62,0x61,0xdd,0x48,0x59,0x82,0x00,0x20,0x00,0x00]
          vmulpd zmm24, zmm4, zmmword ptr [rdx + 8192]

// CHECK: vmulpd zmm24, zmm4, zmmword ptr [rdx - 8192]
// CHECK:  encoding: [0x62,0x61,0xdd,0x48,0x59,0x42,0x80]
          vmulpd zmm24, zmm4, zmmword ptr [rdx - 8192]

// CHECK: vmulpd zmm24, zmm4, zmmword ptr [rdx - 8256]
// CHECK:  encoding: [0x62,0x61,0xdd,0x48,0x59,0x82,0xc0,0xdf,0xff,0xff]
          vmulpd zmm24, zmm4, zmmword ptr [rdx - 8256]

// CHECK: vmulpd zmm24, zmm4, qword ptr [rdx + 1016]{1to8}
// CHECK:  encoding: [0x62,0x61,0xdd,0x58,0x59,0x42,0x7f]
          vmulpd zmm24, zmm4, qword ptr [rdx + 1016]{1to8}

// CHECK: vmulpd zmm24, zmm4, qword ptr [rdx + 1024]{1to8}
// CHECK:  encoding: [0x62,0x61,0xdd,0x58,0x59,0x82,0x00,0x04,0x00,0x00]
          vmulpd zmm24, zmm4, qword ptr [rdx + 1024]{1to8}

// CHECK: vmulpd zmm24, zmm4, qword ptr [rdx - 1024]{1to8}
// CHECK:  encoding: [0x62,0x61,0xdd,0x58,0x59,0x42,0x80]
          vmulpd zmm24, zmm4, qword ptr [rdx - 1024]{1to8}

// CHECK: vmulpd zmm24, zmm4, qword ptr [rdx - 1032]{1to8}
// CHECK:  encoding: [0x62,0x61,0xdd,0x58,0x59,0x82,0xf8,0xfb,0xff,0xff]
          vmulpd zmm24, zmm4, qword ptr [rdx - 1032]{1to8}

// CHECK: vmulps zmm3, zmm6, zmm24
// CHECK:  encoding: [0x62,0x91,0x4c,0x48,0x59,0xd8]
          vmulps zmm3, zmm6, zmm24

// CHECK: vmulps zmm3 {k4}, zmm6, zmm24
// CHECK:  encoding: [0x62,0x91,0x4c,0x4c,0x59,0xd8]
          vmulps zmm3 {k4}, zmm6, zmm24

// CHECK: vmulps zmm3 {k4} {z}, zmm6, zmm24
// CHECK:  encoding: [0x62,0x91,0x4c,0xcc,0x59,0xd8]
          vmulps zmm3 {k4} {z}, zmm6, zmm24

// CHECK: vmulps zmm3, zmm6, zmm24, {rn-sae}
// CHECK:  encoding: [0x62,0x91,0x4c,0x18,0x59,0xd8]
          vmulps zmm3, zmm6, zmm24, {rn-sae}

// CHECK: vmulps zmm3, zmm6, zmm24, {ru-sae}
// CHECK:  encoding: [0x62,0x91,0x4c,0x58,0x59,0xd8]
          vmulps zmm3, zmm6, zmm24, {ru-sae}

// CHECK: vmulps zmm3, zmm6, zmm24, {rd-sae}
// CHECK:  encoding: [0x62,0x91,0x4c,0x38,0x59,0xd8]
          vmulps zmm3, zmm6, zmm24, {rd-sae}

// CHECK: vmulps zmm3, zmm6, zmm24, {rz-sae}
// CHECK:  encoding: [0x62,0x91,0x4c,0x78,0x59,0xd8]
          vmulps zmm3, zmm6, zmm24, {rz-sae}

// CHECK: vmulps zmm3, zmm6, zmmword ptr [rcx]
// CHECK:  encoding: [0x62,0xf1,0x4c,0x48,0x59,0x19]
          vmulps zmm3, zmm6, zmmword ptr [rcx]

// CHECK: vmulps zmm3, zmm6, zmmword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0xb1,0x4c,0x48,0x59,0x9c,0xf0,0x23,0x01,0x00,0x00]
          vmulps zmm3, zmm6, zmmword ptr [rax + 8*r14 + 291]

// CHECK: vmulps zmm3, zmm6, dword ptr [rcx]{1to16}
// CHECK:  encoding: [0x62,0xf1,0x4c,0x58,0x59,0x19]
          vmulps zmm3, zmm6, dword ptr [rcx]{1to16}

// CHECK: vmulps zmm3, zmm6, zmmword ptr [rdx + 8128]
// CHECK:  encoding: [0x62,0xf1,0x4c,0x48,0x59,0x5a,0x7f]
          vmulps zmm3, zmm6, zmmword ptr [rdx + 8128]

// CHECK: vmulps zmm3, zmm6, zmmword ptr [rdx + 8192]
// CHECK:  encoding: [0x62,0xf1,0x4c,0x48,0x59,0x9a,0x00,0x20,0x00,0x00]
          vmulps zmm3, zmm6, zmmword ptr [rdx + 8192]

// CHECK: vmulps zmm3, zmm6, zmmword ptr [rdx - 8192]
// CHECK:  encoding: [0x62,0xf1,0x4c,0x48,0x59,0x5a,0x80]
          vmulps zmm3, zmm6, zmmword ptr [rdx - 8192]

// CHECK: vmulps zmm3, zmm6, zmmword ptr [rdx - 8256]
// CHECK:  encoding: [0x62,0xf1,0x4c,0x48,0x59,0x9a,0xc0,0xdf,0xff,0xff]
          vmulps zmm3, zmm6, zmmword ptr [rdx - 8256]

// CHECK: vmulps zmm3, zmm6, dword ptr [rdx + 508]{1to16}
// CHECK:  encoding: [0x62,0xf1,0x4c,0x58,0x59,0x5a,0x7f]
          vmulps zmm3, zmm6, dword ptr [rdx + 508]{1to16}

// CHECK: vmulps zmm3, zmm6, dword ptr [rdx + 512]{1to16}
// CHECK:  encoding: [0x62,0xf1,0x4c,0x58,0x59,0x9a,0x00,0x02,0x00,0x00]
          vmulps zmm3, zmm6, dword ptr [rdx + 512]{1to16}

// CHECK: vmulps zmm3, zmm6, dword ptr [rdx - 512]{1to16}
// CHECK:  encoding: [0x62,0xf1,0x4c,0x58,0x59,0x5a,0x80]
          vmulps zmm3, zmm6, dword ptr [rdx - 512]{1to16}

// CHECK: vmulps zmm3, zmm6, dword ptr [rdx - 516]{1to16}
// CHECK:  encoding: [0x62,0xf1,0x4c,0x58,0x59,0x9a,0xfc,0xfd,0xff,0xff]
          vmulps zmm3, zmm6, dword ptr [rdx - 516]{1to16}

// CHECK: vmulsd xmm13, xmm4, xmm18
// CHECK:  encoding: [0x62,0x31,0xdf,0x08,0x59,0xea]
          vmulsd xmm13, xmm4, xmm18

// CHECK: vmulsd xmm13 {k2}, xmm4, xmm18
// CHECK:  encoding: [0x62,0x31,0xdf,0x0a,0x59,0xea]
          vmulsd xmm13 {k2}, xmm4, xmm18

// CHECK: vmulsd xmm13 {k2} {z}, xmm4, xmm18
// CHECK:  encoding: [0x62,0x31,0xdf,0x8a,0x59,0xea]
          vmulsd xmm13 {k2} {z}, xmm4, xmm18

// CHECK: vmulsd xmm13, xmm4, xmm18, {rn-sae}
// CHECK:  encoding: [0x62,0x31,0xdf,0x18,0x59,0xea]
          vmulsd xmm13, xmm4, xmm18, {rn-sae}

// CHECK: vmulsd xmm13, xmm4, xmm18, {ru-sae}
// CHECK:  encoding: [0x62,0x31,0xdf,0x58,0x59,0xea]
          vmulsd xmm13, xmm4, xmm18, {ru-sae}

// CHECK: vmulsd xmm13, xmm4, xmm18, {rd-sae}
// CHECK:  encoding: [0x62,0x31,0xdf,0x38,0x59,0xea]
          vmulsd xmm13, xmm4, xmm18, {rd-sae}

// CHECK: vmulsd xmm13, xmm4, xmm18, {rz-sae}
// CHECK:  encoding: [0x62,0x31,0xdf,0x78,0x59,0xea]
          vmulsd xmm13, xmm4, xmm18, {rz-sae}

// CHECK: vmulsd xmm13, xmm4, qword ptr [rcx]
// CHECK:  encoding: [0xc5,0x5b,0x59,0x29]
          vmulsd xmm13, xmm4, qword ptr [rcx]

// CHECK: vmulsd xmm13, xmm4, qword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0xc4,0x21,0x5b,0x59,0xac,0xf0,0x23,0x01,0x00,0x00]
          vmulsd xmm13, xmm4, qword ptr [rax + 8*r14 + 291]

// CHECK: vmulsd xmm13, xmm4, qword ptr [rdx + 1016]
// CHECK:  encoding: [0xc5,0x5b,0x59,0xaa,0xf8,0x03,0x00,0x00]
          vmulsd xmm13, xmm4, qword ptr [rdx + 1016]

// CHECK: vmulsd xmm13, xmm4, qword ptr [rdx + 1024]
// CHECK:  encoding: [0xc5,0x5b,0x59,0xaa,0x00,0x04,0x00,0x00]
          vmulsd xmm13, xmm4, qword ptr [rdx + 1024]

// CHECK: vmulsd xmm13, xmm4, qword ptr [rdx - 1024]
// CHECK:  encoding: [0xc5,0x5b,0x59,0xaa,0x00,0xfc,0xff,0xff]
          vmulsd xmm13, xmm4, qword ptr [rdx - 1024]

// CHECK: vmulsd xmm13, xmm4, qword ptr [rdx - 1032]
// CHECK:  encoding: [0xc5,0x5b,0x59,0xaa,0xf8,0xfb,0xff,0xff]
          vmulsd xmm13, xmm4, qword ptr [rdx - 1032]

// CHECK: vmulss xmm22, xmm10, xmm14
// CHECK:  encoding: [0x62,0xc1,0x2e,0x08,0x59,0xf6]
          vmulss xmm22, xmm10, xmm14

// CHECK: vmulss xmm22 {k4}, xmm10, xmm14
// CHECK:  encoding: [0x62,0xc1,0x2e,0x0c,0x59,0xf6]
          vmulss xmm22 {k4}, xmm10, xmm14

// CHECK: vmulss xmm22 {k4} {z}, xmm10, xmm14
// CHECK:  encoding: [0x62,0xc1,0x2e,0x8c,0x59,0xf6]
          vmulss xmm22 {k4} {z}, xmm10, xmm14

// CHECK: vmulss xmm22, xmm10, xmm14, {rn-sae}
// CHECK:  encoding: [0x62,0xc1,0x2e,0x18,0x59,0xf6]
          vmulss xmm22, xmm10, xmm14, {rn-sae}

// CHECK: vmulss xmm22, xmm10, xmm14, {ru-sae}
// CHECK:  encoding: [0x62,0xc1,0x2e,0x58,0x59,0xf6]
          vmulss xmm22, xmm10, xmm14, {ru-sae}

// CHECK: vmulss xmm22, xmm10, xmm14, {rd-sae}
// CHECK:  encoding: [0x62,0xc1,0x2e,0x38,0x59,0xf6]
          vmulss xmm22, xmm10, xmm14, {rd-sae}

// CHECK: vmulss xmm22, xmm10, xmm14, {rz-sae}
// CHECK:  encoding: [0x62,0xc1,0x2e,0x78,0x59,0xf6]
          vmulss xmm22, xmm10, xmm14, {rz-sae}

// CHECK: vmulss xmm22, xmm10, dword ptr [rcx]
// CHECK:  encoding: [0x62,0xe1,0x2e,0x08,0x59,0x31]
          vmulss xmm22, xmm10, dword ptr [rcx]

// CHECK: vmulss xmm22, xmm10, dword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0xa1,0x2e,0x08,0x59,0xb4,0xf0,0x23,0x01,0x00,0x00]
          vmulss xmm22, xmm10, dword ptr [rax + 8*r14 + 291]

// CHECK: vmulss xmm22, xmm10, dword ptr [rdx + 508]
// CHECK:  encoding: [0x62,0xe1,0x2e,0x08,0x59,0x72,0x7f]
          vmulss xmm22, xmm10, dword ptr [rdx + 508]

// CHECK: vmulss xmm22, xmm10, dword ptr [rdx + 512]
// CHECK:  encoding: [0x62,0xe1,0x2e,0x08,0x59,0xb2,0x00,0x02,0x00,0x00]
          vmulss xmm22, xmm10, dword ptr [rdx + 512]

// CHECK: vmulss xmm22, xmm10, dword ptr [rdx - 512]
// CHECK:  encoding: [0x62,0xe1,0x2e,0x08,0x59,0x72,0x80]
          vmulss xmm22, xmm10, dword ptr [rdx - 512]

// CHECK: vmulss xmm22, xmm10, dword ptr [rdx - 516]
// CHECK:  encoding: [0x62,0xe1,0x2e,0x08,0x59,0xb2,0xfc,0xfd,0xff,0xff]
          vmulss xmm22, xmm10, dword ptr [rdx - 516]

// CHECK: vpabsd zmm15, zmm14
// CHECK:  encoding: [0x62,0x52,0x7d,0x48,0x1e,0xfe]
          vpabsd zmm15, zmm14

// CHECK: vpabsd zmm15 {k6}, zmm14
// CHECK:  encoding: [0x62,0x52,0x7d,0x4e,0x1e,0xfe]
          vpabsd zmm15 {k6}, zmm14

// CHECK: vpabsd zmm15 {k6} {z}, zmm14
// CHECK:  encoding: [0x62,0x52,0x7d,0xce,0x1e,0xfe]
          vpabsd zmm15 {k6} {z}, zmm14

// CHECK: vpabsd zmm15, zmmword ptr [rcx]
// CHECK:  encoding: [0x62,0x72,0x7d,0x48,0x1e,0x39]
          vpabsd zmm15, zmmword ptr [rcx]

// CHECK: vpabsd zmm15, zmmword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0x32,0x7d,0x48,0x1e,0xbc,0xf0,0x23,0x01,0x00,0x00]
          vpabsd zmm15, zmmword ptr [rax + 8*r14 + 291]

// CHECK: vpabsd zmm15, dword ptr [rcx]{1to16}
// CHECK:  encoding: [0x62,0x72,0x7d,0x58,0x1e,0x39]
          vpabsd zmm15, dword ptr [rcx]{1to16}

// CHECK: vpabsd zmm15, zmmword ptr [rdx + 8128]
// CHECK:  encoding: [0x62,0x72,0x7d,0x48,0x1e,0x7a,0x7f]
          vpabsd zmm15, zmmword ptr [rdx + 8128]

// CHECK: vpabsd zmm15, zmmword ptr [rdx + 8192]
// CHECK:  encoding: [0x62,0x72,0x7d,0x48,0x1e,0xba,0x00,0x20,0x00,0x00]
          vpabsd zmm15, zmmword ptr [rdx + 8192]

// CHECK: vpabsd zmm15, zmmword ptr [rdx - 8192]
// CHECK:  encoding: [0x62,0x72,0x7d,0x48,0x1e,0x7a,0x80]
          vpabsd zmm15, zmmword ptr [rdx - 8192]

// CHECK: vpabsd zmm15, zmmword ptr [rdx - 8256]
// CHECK:  encoding: [0x62,0x72,0x7d,0x48,0x1e,0xba,0xc0,0xdf,0xff,0xff]
          vpabsd zmm15, zmmword ptr [rdx - 8256]

// CHECK: vpabsd zmm15, dword ptr [rdx + 508]{1to16}
// CHECK:  encoding: [0x62,0x72,0x7d,0x58,0x1e,0x7a,0x7f]
          vpabsd zmm15, dword ptr [rdx + 508]{1to16}

// CHECK: vpabsd zmm15, dword ptr [rdx + 512]{1to16}
// CHECK:  encoding: [0x62,0x72,0x7d,0x58,0x1e,0xba,0x00,0x02,0x00,0x00]
          vpabsd zmm15, dword ptr [rdx + 512]{1to16}

// CHECK: vpabsd zmm15, dword ptr [rdx - 512]{1to16}
// CHECK:  encoding: [0x62,0x72,0x7d,0x58,0x1e,0x7a,0x80]
          vpabsd zmm15, dword ptr [rdx - 512]{1to16}

// CHECK: vpabsd zmm15, dword ptr [rdx - 516]{1to16}
// CHECK:  encoding: [0x62,0x72,0x7d,0x58,0x1e,0xba,0xfc,0xfd,0xff,0xff]
          vpabsd zmm15, dword ptr [rdx - 516]{1to16}

// CHECK: vpabsq zmm5, zmm24
// CHECK:  encoding: [0x62,0x92,0xfd,0x48,0x1f,0xe8]
          vpabsq zmm5, zmm24

// CHECK: vpabsq zmm5 {k6}, zmm24
// CHECK:  encoding: [0x62,0x92,0xfd,0x4e,0x1f,0xe8]
          vpabsq zmm5 {k6}, zmm24

// CHECK: vpabsq zmm5 {k6} {z}, zmm24
// CHECK:  encoding: [0x62,0x92,0xfd,0xce,0x1f,0xe8]
          vpabsq zmm5 {k6} {z}, zmm24

// CHECK: vpabsq zmm5, zmmword ptr [rcx]
// CHECK:  encoding: [0x62,0xf2,0xfd,0x48,0x1f,0x29]
          vpabsq zmm5, zmmword ptr [rcx]

// CHECK: vpabsq zmm5, zmmword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0xb2,0xfd,0x48,0x1f,0xac,0xf0,0x23,0x01,0x00,0x00]
          vpabsq zmm5, zmmword ptr [rax + 8*r14 + 291]

// CHECK: vpabsq zmm5, qword ptr [rcx]{1to8}
// CHECK:  encoding: [0x62,0xf2,0xfd,0x58,0x1f,0x29]
          vpabsq zmm5, qword ptr [rcx]{1to8}

// CHECK: vpabsq zmm5, zmmword ptr [rdx + 8128]
// CHECK:  encoding: [0x62,0xf2,0xfd,0x48,0x1f,0x6a,0x7f]
          vpabsq zmm5, zmmword ptr [rdx + 8128]

// CHECK: vpabsq zmm5, zmmword ptr [rdx + 8192]
// CHECK:  encoding: [0x62,0xf2,0xfd,0x48,0x1f,0xaa,0x00,0x20,0x00,0x00]
          vpabsq zmm5, zmmword ptr [rdx + 8192]

// CHECK: vpabsq zmm5, zmmword ptr [rdx - 8192]
// CHECK:  encoding: [0x62,0xf2,0xfd,0x48,0x1f,0x6a,0x80]
          vpabsq zmm5, zmmword ptr [rdx - 8192]

// CHECK: vpabsq zmm5, zmmword ptr [rdx - 8256]
// CHECK:  encoding: [0x62,0xf2,0xfd,0x48,0x1f,0xaa,0xc0,0xdf,0xff,0xff]
          vpabsq zmm5, zmmword ptr [rdx - 8256]

// CHECK: vpabsq zmm5, qword ptr [rdx + 1016]{1to8}
// CHECK:  encoding: [0x62,0xf2,0xfd,0x58,0x1f,0x6a,0x7f]
          vpabsq zmm5, qword ptr [rdx + 1016]{1to8}

// CHECK: vpabsq zmm5, qword ptr [rdx + 1024]{1to8}
// CHECK:  encoding: [0x62,0xf2,0xfd,0x58,0x1f,0xaa,0x00,0x04,0x00,0x00]
          vpabsq zmm5, qword ptr [rdx + 1024]{1to8}

// CHECK: vpabsq zmm5, qword ptr [rdx - 1024]{1to8}
// CHECK:  encoding: [0x62,0xf2,0xfd,0x58,0x1f,0x6a,0x80]
          vpabsq zmm5, qword ptr [rdx - 1024]{1to8}

// CHECK: vpabsq zmm5, qword ptr [rdx - 1032]{1to8}
// CHECK:  encoding: [0x62,0xf2,0xfd,0x58,0x1f,0xaa,0xf8,0xfb,0xff,0xff]
          vpabsq zmm5, qword ptr [rdx - 1032]{1to8}

// CHECK: vpaddd zmm26, zmm5, zmm20
// CHECK:  encoding: [0x62,0x21,0x55,0x48,0xfe,0xd4]
          vpaddd zmm26, zmm5, zmm20

// CHECK: vpaddd zmm26 {k1}, zmm5, zmm20
// CHECK:  encoding: [0x62,0x21,0x55,0x49,0xfe,0xd4]
          vpaddd zmm26 {k1}, zmm5, zmm20

// CHECK: vpaddd zmm26 {k1} {z}, zmm5, zmm20
// CHECK:  encoding: [0x62,0x21,0x55,0xc9,0xfe,0xd4]
          vpaddd zmm26 {k1} {z}, zmm5, zmm20

// CHECK: vpaddd zmm26, zmm5, zmmword ptr [rcx]
// CHECK:  encoding: [0x62,0x61,0x55,0x48,0xfe,0x11]
          vpaddd zmm26, zmm5, zmmword ptr [rcx]

// CHECK: vpaddd zmm26, zmm5, zmmword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0x21,0x55,0x48,0xfe,0x94,0xf0,0x23,0x01,0x00,0x00]
          vpaddd zmm26, zmm5, zmmword ptr [rax + 8*r14 + 291]

// CHECK: vpaddd zmm26, zmm5, dword ptr [rcx]{1to16}
// CHECK:  encoding: [0x62,0x61,0x55,0x58,0xfe,0x11]
          vpaddd zmm26, zmm5, dword ptr [rcx]{1to16}

// CHECK: vpaddd zmm26, zmm5, zmmword ptr [rdx + 8128]
// CHECK:  encoding: [0x62,0x61,0x55,0x48,0xfe,0x52,0x7f]
          vpaddd zmm26, zmm5, zmmword ptr [rdx + 8128]

// CHECK: vpaddd zmm26, zmm5, zmmword ptr [rdx + 8192]
// CHECK:  encoding: [0x62,0x61,0x55,0x48,0xfe,0x92,0x00,0x20,0x00,0x00]
          vpaddd zmm26, zmm5, zmmword ptr [rdx + 8192]

// CHECK: vpaddd zmm26, zmm5, zmmword ptr [rdx - 8192]
// CHECK:  encoding: [0x62,0x61,0x55,0x48,0xfe,0x52,0x80]
          vpaddd zmm26, zmm5, zmmword ptr [rdx - 8192]

// CHECK: vpaddd zmm26, zmm5, zmmword ptr [rdx - 8256]
// CHECK:  encoding: [0x62,0x61,0x55,0x48,0xfe,0x92,0xc0,0xdf,0xff,0xff]
          vpaddd zmm26, zmm5, zmmword ptr [rdx - 8256]

// CHECK: vpaddd zmm26, zmm5, dword ptr [rdx + 508]{1to16}
// CHECK:  encoding: [0x62,0x61,0x55,0x58,0xfe,0x52,0x7f]
          vpaddd zmm26, zmm5, dword ptr [rdx + 508]{1to16}

// CHECK: vpaddd zmm26, zmm5, dword ptr [rdx + 512]{1to16}
// CHECK:  encoding: [0x62,0x61,0x55,0x58,0xfe,0x92,0x00,0x02,0x00,0x00]
          vpaddd zmm26, zmm5, dword ptr [rdx + 512]{1to16}

// CHECK: vpaddd zmm26, zmm5, dword ptr [rdx - 512]{1to16}
// CHECK:  encoding: [0x62,0x61,0x55,0x58,0xfe,0x52,0x80]
          vpaddd zmm26, zmm5, dword ptr [rdx - 512]{1to16}

// CHECK: vpaddd zmm26, zmm5, dword ptr [rdx - 516]{1to16}
// CHECK:  encoding: [0x62,0x61,0x55,0x58,0xfe,0x92,0xfc,0xfd,0xff,0xff]
          vpaddd zmm26, zmm5, dword ptr [rdx - 516]{1to16}

// CHECK: vpaddq zmm8, zmm25, zmm14
// CHECK:  encoding: [0x62,0x51,0xb5,0x40,0xd4,0xc6]
          vpaddq zmm8, zmm25, zmm14

// CHECK: vpaddq zmm8 {k3}, zmm25, zmm14
// CHECK:  encoding: [0x62,0x51,0xb5,0x43,0xd4,0xc6]
          vpaddq zmm8 {k3}, zmm25, zmm14

// CHECK: vpaddq zmm8 {k3} {z}, zmm25, zmm14
// CHECK:  encoding: [0x62,0x51,0xb5,0xc3,0xd4,0xc6]
          vpaddq zmm8 {k3} {z}, zmm25, zmm14

// CHECK: vpaddq zmm8, zmm25, zmmword ptr [rcx]
// CHECK:  encoding: [0x62,0x71,0xb5,0x40,0xd4,0x01]
          vpaddq zmm8, zmm25, zmmword ptr [rcx]

// CHECK: vpaddq zmm8, zmm25, zmmword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0x31,0xb5,0x40,0xd4,0x84,0xf0,0x23,0x01,0x00,0x00]
          vpaddq zmm8, zmm25, zmmword ptr [rax + 8*r14 + 291]

// CHECK: vpaddq zmm8, zmm25, qword ptr [rcx]{1to8}
// CHECK:  encoding: [0x62,0x71,0xb5,0x50,0xd4,0x01]
          vpaddq zmm8, zmm25, qword ptr [rcx]{1to8}

// CHECK: vpaddq zmm8, zmm25, zmmword ptr [rdx + 8128]
// CHECK:  encoding: [0x62,0x71,0xb5,0x40,0xd4,0x42,0x7f]
          vpaddq zmm8, zmm25, zmmword ptr [rdx + 8128]

// CHECK: vpaddq zmm8, zmm25, zmmword ptr [rdx + 8192]
// CHECK:  encoding: [0x62,0x71,0xb5,0x40,0xd4,0x82,0x00,0x20,0x00,0x00]
          vpaddq zmm8, zmm25, zmmword ptr [rdx + 8192]

// CHECK: vpaddq zmm8, zmm25, zmmword ptr [rdx - 8192]
// CHECK:  encoding: [0x62,0x71,0xb5,0x40,0xd4,0x42,0x80]
          vpaddq zmm8, zmm25, zmmword ptr [rdx - 8192]

// CHECK: vpaddq zmm8, zmm25, zmmword ptr [rdx - 8256]
// CHECK:  encoding: [0x62,0x71,0xb5,0x40,0xd4,0x82,0xc0,0xdf,0xff,0xff]
          vpaddq zmm8, zmm25, zmmword ptr [rdx - 8256]

// CHECK: vpaddq zmm8, zmm25, qword ptr [rdx + 1016]{1to8}
// CHECK:  encoding: [0x62,0x71,0xb5,0x50,0xd4,0x42,0x7f]
          vpaddq zmm8, zmm25, qword ptr [rdx + 1016]{1to8}

// CHECK: vpaddq zmm8, zmm25, qword ptr [rdx + 1024]{1to8}
// CHECK:  encoding: [0x62,0x71,0xb5,0x50,0xd4,0x82,0x00,0x04,0x00,0x00]
          vpaddq zmm8, zmm25, qword ptr [rdx + 1024]{1to8}

// CHECK: vpaddq zmm8, zmm25, qword ptr [rdx - 1024]{1to8}
// CHECK:  encoding: [0x62,0x71,0xb5,0x50,0xd4,0x42,0x80]
          vpaddq zmm8, zmm25, qword ptr [rdx - 1024]{1to8}

// CHECK: vpaddq zmm8, zmm25, qword ptr [rdx - 1032]{1to8}
// CHECK:  encoding: [0x62,0x71,0xb5,0x50,0xd4,0x82,0xf8,0xfb,0xff,0xff]
          vpaddq zmm8, zmm25, qword ptr [rdx - 1032]{1to8}

// CHECK: vpandd zmm19, zmm22, zmm25
// CHECK:  encoding: [0x62,0x81,0x4d,0x40,0xdb,0xd9]
          vpandd zmm19, zmm22, zmm25

// CHECK: vpandd zmm19 {k1}, zmm22, zmm25
// CHECK:  encoding: [0x62,0x81,0x4d,0x41,0xdb,0xd9]
          vpandd zmm19 {k1}, zmm22, zmm25

// CHECK: vpandd zmm19 {k1} {z}, zmm22, zmm25
// CHECK:  encoding: [0x62,0x81,0x4d,0xc1,0xdb,0xd9]
          vpandd zmm19 {k1} {z}, zmm22, zmm25

// CHECK: vpandd zmm19, zmm22, zmmword ptr [rcx]
// CHECK:  encoding: [0x62,0xe1,0x4d,0x40,0xdb,0x19]
          vpandd zmm19, zmm22, zmmword ptr [rcx]

// CHECK: vpandd zmm19, zmm22, zmmword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0xa1,0x4d,0x40,0xdb,0x9c,0xf0,0x23,0x01,0x00,0x00]
          vpandd zmm19, zmm22, zmmword ptr [rax + 8*r14 + 291]

// CHECK: vpandd zmm19, zmm22, dword ptr [rcx]{1to16}
// CHECK:  encoding: [0x62,0xe1,0x4d,0x50,0xdb,0x19]
          vpandd zmm19, zmm22, dword ptr [rcx]{1to16}

// CHECK: vpandd zmm19, zmm22, zmmword ptr [rdx + 8128]
// CHECK:  encoding: [0x62,0xe1,0x4d,0x40,0xdb,0x5a,0x7f]
          vpandd zmm19, zmm22, zmmword ptr [rdx + 8128]

// CHECK: vpandd zmm19, zmm22, zmmword ptr [rdx + 8192]
// CHECK:  encoding: [0x62,0xe1,0x4d,0x40,0xdb,0x9a,0x00,0x20,0x00,0x00]
          vpandd zmm19, zmm22, zmmword ptr [rdx + 8192]

// CHECK: vpandd zmm19, zmm22, zmmword ptr [rdx - 8192]
// CHECK:  encoding: [0x62,0xe1,0x4d,0x40,0xdb,0x5a,0x80]
          vpandd zmm19, zmm22, zmmword ptr [rdx - 8192]

// CHECK: vpandd zmm19, zmm22, zmmword ptr [rdx - 8256]
// CHECK:  encoding: [0x62,0xe1,0x4d,0x40,0xdb,0x9a,0xc0,0xdf,0xff,0xff]
          vpandd zmm19, zmm22, zmmword ptr [rdx - 8256]

// CHECK: vpandd zmm19, zmm22, dword ptr [rdx + 508]{1to16}
// CHECK:  encoding: [0x62,0xe1,0x4d,0x50,0xdb,0x5a,0x7f]
          vpandd zmm19, zmm22, dword ptr [rdx + 508]{1to16}

// CHECK: vpandd zmm19, zmm22, dword ptr [rdx + 512]{1to16}
// CHECK:  encoding: [0x62,0xe1,0x4d,0x50,0xdb,0x9a,0x00,0x02,0x00,0x00]
          vpandd zmm19, zmm22, dword ptr [rdx + 512]{1to16}

// CHECK: vpandd zmm19, zmm22, dword ptr [rdx - 512]{1to16}
// CHECK:  encoding: [0x62,0xe1,0x4d,0x50,0xdb,0x5a,0x80]
          vpandd zmm19, zmm22, dword ptr [rdx - 512]{1to16}

// CHECK: vpandd zmm19, zmm22, dword ptr [rdx - 516]{1to16}
// CHECK:  encoding: [0x62,0xe1,0x4d,0x50,0xdb,0x9a,0xfc,0xfd,0xff,0xff]
          vpandd zmm19, zmm22, dword ptr [rdx - 516]{1to16}

// CHECK: vpandnd zmm30, zmm28, zmm15
// CHECK:  encoding: [0x62,0x41,0x1d,0x40,0xdf,0xf7]
          vpandnd zmm30, zmm28, zmm15

// CHECK: vpandnd zmm30 {k3}, zmm28, zmm15
// CHECK:  encoding: [0x62,0x41,0x1d,0x43,0xdf,0xf7]
          vpandnd zmm30 {k3}, zmm28, zmm15

// CHECK: vpandnd zmm30 {k3} {z}, zmm28, zmm15
// CHECK:  encoding: [0x62,0x41,0x1d,0xc3,0xdf,0xf7]
          vpandnd zmm30 {k3} {z}, zmm28, zmm15

// CHECK: vpandnd zmm30, zmm28, zmmword ptr [rcx]
// CHECK:  encoding: [0x62,0x61,0x1d,0x40,0xdf,0x31]
          vpandnd zmm30, zmm28, zmmword ptr [rcx]

// CHECK: vpandnd zmm30, zmm28, zmmword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0x21,0x1d,0x40,0xdf,0xb4,0xf0,0x23,0x01,0x00,0x00]
          vpandnd zmm30, zmm28, zmmword ptr [rax + 8*r14 + 291]

// CHECK: vpandnd zmm30, zmm28, dword ptr [rcx]{1to16}
// CHECK:  encoding: [0x62,0x61,0x1d,0x50,0xdf,0x31]
          vpandnd zmm30, zmm28, dword ptr [rcx]{1to16}

// CHECK: vpandnd zmm30, zmm28, zmmword ptr [rdx + 8128]
// CHECK:  encoding: [0x62,0x61,0x1d,0x40,0xdf,0x72,0x7f]
          vpandnd zmm30, zmm28, zmmword ptr [rdx + 8128]

// CHECK: vpandnd zmm30, zmm28, zmmword ptr [rdx + 8192]
// CHECK:  encoding: [0x62,0x61,0x1d,0x40,0xdf,0xb2,0x00,0x20,0x00,0x00]
          vpandnd zmm30, zmm28, zmmword ptr [rdx + 8192]

// CHECK: vpandnd zmm30, zmm28, zmmword ptr [rdx - 8192]
// CHECK:  encoding: [0x62,0x61,0x1d,0x40,0xdf,0x72,0x80]
          vpandnd zmm30, zmm28, zmmword ptr [rdx - 8192]

// CHECK: vpandnd zmm30, zmm28, zmmword ptr [rdx - 8256]
// CHECK:  encoding: [0x62,0x61,0x1d,0x40,0xdf,0xb2,0xc0,0xdf,0xff,0xff]
          vpandnd zmm30, zmm28, zmmword ptr [rdx - 8256]

// CHECK: vpandnd zmm30, zmm28, dword ptr [rdx + 508]{1to16}
// CHECK:  encoding: [0x62,0x61,0x1d,0x50,0xdf,0x72,0x7f]
          vpandnd zmm30, zmm28, dword ptr [rdx + 508]{1to16}

// CHECK: vpandnd zmm30, zmm28, dword ptr [rdx + 512]{1to16}
// CHECK:  encoding: [0x62,0x61,0x1d,0x50,0xdf,0xb2,0x00,0x02,0x00,0x00]
          vpandnd zmm30, zmm28, dword ptr [rdx + 512]{1to16}

// CHECK: vpandnd zmm30, zmm28, dword ptr [rdx - 512]{1to16}
// CHECK:  encoding: [0x62,0x61,0x1d,0x50,0xdf,0x72,0x80]
          vpandnd zmm30, zmm28, dword ptr [rdx - 512]{1to16}

// CHECK: vpandnd zmm30, zmm28, dword ptr [rdx - 516]{1to16}
// CHECK:  encoding: [0x62,0x61,0x1d,0x50,0xdf,0xb2,0xfc,0xfd,0xff,0xff]
          vpandnd zmm30, zmm28, dword ptr [rdx - 516]{1to16}

// CHECK: vpandnq zmm20, zmm7, zmm19
// CHECK:  encoding: [0x62,0xa1,0xc5,0x48,0xdf,0xe3]
          vpandnq zmm20, zmm7, zmm19

// CHECK: vpandnq zmm20 {k5}, zmm7, zmm19
// CHECK:  encoding: [0x62,0xa1,0xc5,0x4d,0xdf,0xe3]
          vpandnq zmm20 {k5}, zmm7, zmm19

// CHECK: vpandnq zmm20 {k5} {z}, zmm7, zmm19
// CHECK:  encoding: [0x62,0xa1,0xc5,0xcd,0xdf,0xe3]
          vpandnq zmm20 {k5} {z}, zmm7, zmm19

// CHECK: vpandnq zmm20, zmm7, zmmword ptr [rcx]
// CHECK:  encoding: [0x62,0xe1,0xc5,0x48,0xdf,0x21]
          vpandnq zmm20, zmm7, zmmword ptr [rcx]

// CHECK: vpandnq zmm20, zmm7, zmmword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0xa1,0xc5,0x48,0xdf,0xa4,0xf0,0x23,0x01,0x00,0x00]
          vpandnq zmm20, zmm7, zmmword ptr [rax + 8*r14 + 291]

// CHECK: vpandnq zmm20, zmm7, qword ptr [rcx]{1to8}
// CHECK:  encoding: [0x62,0xe1,0xc5,0x58,0xdf,0x21]
          vpandnq zmm20, zmm7, qword ptr [rcx]{1to8}

// CHECK: vpandnq zmm20, zmm7, zmmword ptr [rdx + 8128]
// CHECK:  encoding: [0x62,0xe1,0xc5,0x48,0xdf,0x62,0x7f]
          vpandnq zmm20, zmm7, zmmword ptr [rdx + 8128]

// CHECK: vpandnq zmm20, zmm7, zmmword ptr [rdx + 8192]
// CHECK:  encoding: [0x62,0xe1,0xc5,0x48,0xdf,0xa2,0x00,0x20,0x00,0x00]
          vpandnq zmm20, zmm7, zmmword ptr [rdx + 8192]

// CHECK: vpandnq zmm20, zmm7, zmmword ptr [rdx - 8192]
// CHECK:  encoding: [0x62,0xe1,0xc5,0x48,0xdf,0x62,0x80]
          vpandnq zmm20, zmm7, zmmword ptr [rdx - 8192]

// CHECK: vpandnq zmm20, zmm7, zmmword ptr [rdx - 8256]
// CHECK:  encoding: [0x62,0xe1,0xc5,0x48,0xdf,0xa2,0xc0,0xdf,0xff,0xff]
          vpandnq zmm20, zmm7, zmmword ptr [rdx - 8256]

// CHECK: vpandnq zmm20, zmm7, qword ptr [rdx + 1016]{1to8}
// CHECK:  encoding: [0x62,0xe1,0xc5,0x58,0xdf,0x62,0x7f]
          vpandnq zmm20, zmm7, qword ptr [rdx + 1016]{1to8}

// CHECK: vpandnq zmm20, zmm7, qword ptr [rdx + 1024]{1to8}
// CHECK:  encoding: [0x62,0xe1,0xc5,0x58,0xdf,0xa2,0x00,0x04,0x00,0x00]
          vpandnq zmm20, zmm7, qword ptr [rdx + 1024]{1to8}

// CHECK: vpandnq zmm20, zmm7, qword ptr [rdx - 1024]{1to8}
// CHECK:  encoding: [0x62,0xe1,0xc5,0x58,0xdf,0x62,0x80]
          vpandnq zmm20, zmm7, qword ptr [rdx - 1024]{1to8}

// CHECK: vpandnq zmm20, zmm7, qword ptr [rdx - 1032]{1to8}
// CHECK:  encoding: [0x62,0xe1,0xc5,0x58,0xdf,0xa2,0xf8,0xfb,0xff,0xff]
          vpandnq zmm20, zmm7, qword ptr [rdx - 1032]{1to8}

// CHECK: vpandq zmm17, zmm4, zmm26
// CHECK:  encoding: [0x62,0x81,0xdd,0x48,0xdb,0xca]
          vpandq zmm17, zmm4, zmm26

// CHECK: vpandq zmm17 {k7}, zmm4, zmm26
// CHECK:  encoding: [0x62,0x81,0xdd,0x4f,0xdb,0xca]
          vpandq zmm17 {k7}, zmm4, zmm26

// CHECK: vpandq zmm17 {k7} {z}, zmm4, zmm26
// CHECK:  encoding: [0x62,0x81,0xdd,0xcf,0xdb,0xca]
          vpandq zmm17 {k7} {z}, zmm4, zmm26

// CHECK: vpandq zmm17, zmm4, zmmword ptr [rcx]
// CHECK:  encoding: [0x62,0xe1,0xdd,0x48,0xdb,0x09]
          vpandq zmm17, zmm4, zmmword ptr [rcx]

// CHECK: vpandq zmm17, zmm4, zmmword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0xa1,0xdd,0x48,0xdb,0x8c,0xf0,0x23,0x01,0x00,0x00]
          vpandq zmm17, zmm4, zmmword ptr [rax + 8*r14 + 291]

// CHECK: vpandq zmm17, zmm4, qword ptr [rcx]{1to8}
// CHECK:  encoding: [0x62,0xe1,0xdd,0x58,0xdb,0x09]
          vpandq zmm17, zmm4, qword ptr [rcx]{1to8}

// CHECK: vpandq zmm17, zmm4, zmmword ptr [rdx + 8128]
// CHECK:  encoding: [0x62,0xe1,0xdd,0x48,0xdb,0x4a,0x7f]
          vpandq zmm17, zmm4, zmmword ptr [rdx + 8128]

// CHECK: vpandq zmm17, zmm4, zmmword ptr [rdx + 8192]
// CHECK:  encoding: [0x62,0xe1,0xdd,0x48,0xdb,0x8a,0x00,0x20,0x00,0x00]
          vpandq zmm17, zmm4, zmmword ptr [rdx + 8192]

// CHECK: vpandq zmm17, zmm4, zmmword ptr [rdx - 8192]
// CHECK:  encoding: [0x62,0xe1,0xdd,0x48,0xdb,0x4a,0x80]
          vpandq zmm17, zmm4, zmmword ptr [rdx - 8192]

// CHECK: vpandq zmm17, zmm4, zmmword ptr [rdx - 8256]
// CHECK:  encoding: [0x62,0xe1,0xdd,0x48,0xdb,0x8a,0xc0,0xdf,0xff,0xff]
          vpandq zmm17, zmm4, zmmword ptr [rdx - 8256]

// CHECK: vpandq zmm17, zmm4, qword ptr [rdx + 1016]{1to8}
// CHECK:  encoding: [0x62,0xe1,0xdd,0x58,0xdb,0x4a,0x7f]
          vpandq zmm17, zmm4, qword ptr [rdx + 1016]{1to8}

// CHECK: vpandq zmm17, zmm4, qword ptr [rdx + 1024]{1to8}
// CHECK:  encoding: [0x62,0xe1,0xdd,0x58,0xdb,0x8a,0x00,0x04,0x00,0x00]
          vpandq zmm17, zmm4, qword ptr [rdx + 1024]{1to8}

// CHECK: vpandq zmm17, zmm4, qword ptr [rdx - 1024]{1to8}
// CHECK:  encoding: [0x62,0xe1,0xdd,0x58,0xdb,0x4a,0x80]
          vpandq zmm17, zmm4, qword ptr [rdx - 1024]{1to8}

// CHECK: vpandq zmm17, zmm4, qword ptr [rdx - 1032]{1to8}
// CHECK:  encoding: [0x62,0xe1,0xdd,0x58,0xdb,0x8a,0xf8,0xfb,0xff,0xff]
          vpandq zmm17, zmm4, qword ptr [rdx - 1032]{1to8}

// CHECK: vpblendmd zmm5, zmm25, zmm11
// CHECK:  encoding: [0x62,0xd2,0x35,0x40,0x64,0xeb]
          vpblendmd zmm5, zmm25, zmm11

// CHECK: vpblendmd zmm5 {k3}, zmm25, zmm11
// CHECK:  encoding: [0x62,0xd2,0x35,0x43,0x64,0xeb]
          vpblendmd zmm5 {k3}, zmm25, zmm11

// CHECK: vpblendmd zmm5 {k3} {z}, zmm25, zmm11
// CHECK:  encoding: [0x62,0xd2,0x35,0xc3,0x64,0xeb]
          vpblendmd zmm5 {k3} {z}, zmm25, zmm11

// CHECK: vpblendmd zmm5, zmm25, zmmword ptr [rcx]
// CHECK:  encoding: [0x62,0xf2,0x35,0x40,0x64,0x29]
          vpblendmd zmm5, zmm25, zmmword ptr [rcx]

// CHECK: vpblendmd zmm5, zmm25, zmmword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0xb2,0x35,0x40,0x64,0xac,0xf0,0x23,0x01,0x00,0x00]
          vpblendmd zmm5, zmm25, zmmword ptr [rax + 8*r14 + 291]

// CHECK: vpblendmd zmm5, zmm25, dword ptr [rcx]{1to16}
// CHECK:  encoding: [0x62,0xf2,0x35,0x50,0x64,0x29]
          vpblendmd zmm5, zmm25, dword ptr [rcx]{1to16}

// CHECK: vpblendmd zmm5, zmm25, zmmword ptr [rdx + 8128]
// CHECK:  encoding: [0x62,0xf2,0x35,0x40,0x64,0x6a,0x7f]
          vpblendmd zmm5, zmm25, zmmword ptr [rdx + 8128]

// CHECK: vpblendmd zmm5, zmm25, zmmword ptr [rdx + 8192]
// CHECK:  encoding: [0x62,0xf2,0x35,0x40,0x64,0xaa,0x00,0x20,0x00,0x00]
          vpblendmd zmm5, zmm25, zmmword ptr [rdx + 8192]

// CHECK: vpblendmd zmm5, zmm25, zmmword ptr [rdx - 8192]
// CHECK:  encoding: [0x62,0xf2,0x35,0x40,0x64,0x6a,0x80]
          vpblendmd zmm5, zmm25, zmmword ptr [rdx - 8192]

// CHECK: vpblendmd zmm5, zmm25, zmmword ptr [rdx - 8256]
// CHECK:  encoding: [0x62,0xf2,0x35,0x40,0x64,0xaa,0xc0,0xdf,0xff,0xff]
          vpblendmd zmm5, zmm25, zmmword ptr [rdx - 8256]

// CHECK: vpblendmd zmm5, zmm25, dword ptr [rdx + 508]{1to16}
// CHECK:  encoding: [0x62,0xf2,0x35,0x50,0x64,0x6a,0x7f]
          vpblendmd zmm5, zmm25, dword ptr [rdx + 508]{1to16}

// CHECK: vpblendmd zmm5, zmm25, dword ptr [rdx + 512]{1to16}
// CHECK:  encoding: [0x62,0xf2,0x35,0x50,0x64,0xaa,0x00,0x02,0x00,0x00]
          vpblendmd zmm5, zmm25, dword ptr [rdx + 512]{1to16}

// CHECK: vpblendmd zmm5, zmm25, dword ptr [rdx - 512]{1to16}
// CHECK:  encoding: [0x62,0xf2,0x35,0x50,0x64,0x6a,0x80]
          vpblendmd zmm5, zmm25, dword ptr [rdx - 512]{1to16}

// CHECK: vpblendmd zmm5, zmm25, dword ptr [rdx - 516]{1to16}
// CHECK:  encoding: [0x62,0xf2,0x35,0x50,0x64,0xaa,0xfc,0xfd,0xff,0xff]
          vpblendmd zmm5, zmm25, dword ptr [rdx - 516]{1to16}

// CHECK: vpbroadcastd zmm26, dword ptr [rcx]
// CHECK:  encoding: [0x62,0x62,0x7d,0x48,0x58,0x11]
          vpbroadcastd zmm26, dword ptr [rcx]

// CHECK: vpbroadcastd zmm26 {k2}, dword ptr [rcx]
// CHECK:  encoding: [0x62,0x62,0x7d,0x4a,0x58,0x11]
          vpbroadcastd zmm26 {k2}, dword ptr [rcx]

// CHECK: vpbroadcastd zmm26 {k2} {z}, dword ptr [rcx]
// CHECK:  encoding: [0x62,0x62,0x7d,0xca,0x58,0x11]
          vpbroadcastd zmm26 {k2} {z}, dword ptr [rcx]

// CHECK: vpbroadcastd zmm26, dword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0x22,0x7d,0x48,0x58,0x94,0xf0,0x23,0x01,0x00,0x00]
          vpbroadcastd zmm26, dword ptr [rax + 8*r14 + 291]

// CHECK: vpbroadcastd zmm26, dword ptr [rdx + 508]
// CHECK:  encoding: [0x62,0x62,0x7d,0x48,0x58,0x52,0x7f]
          vpbroadcastd zmm26, dword ptr [rdx + 508]

// CHECK: vpbroadcastd zmm26, dword ptr [rdx + 512]
// CHECK:  encoding: [0x62,0x62,0x7d,0x48,0x58,0x92,0x00,0x02,0x00,0x00]
          vpbroadcastd zmm26, dword ptr [rdx + 512]

// CHECK: vpbroadcastd zmm26, dword ptr [rdx - 512]
// CHECK:  encoding: [0x62,0x62,0x7d,0x48,0x58,0x52,0x80]
          vpbroadcastd zmm26, dword ptr [rdx - 512]

// CHECK: vpbroadcastd zmm26, dword ptr [rdx - 516]
// CHECK:  encoding: [0x62,0x62,0x7d,0x48,0x58,0x92,0xfc,0xfd,0xff,0xff]
          vpbroadcastd zmm26, dword ptr [rdx - 516]

// CHECK: vpbroadcastd zmm10, xmm22
// CHECK:  encoding: [0x62,0x32,0x7d,0x48,0x58,0xd6]
          vpbroadcastd zmm10, xmm22

// CHECK: vpbroadcastd zmm10 {k7}, xmm22
// CHECK:  encoding: [0x62,0x32,0x7d,0x4f,0x58,0xd6]
          vpbroadcastd zmm10 {k7}, xmm22

// CHECK: vpbroadcastd zmm10 {k7} {z}, xmm22
// CHECK:  encoding: [0x62,0x32,0x7d,0xcf,0x58,0xd6]
          vpbroadcastd zmm10 {k7} {z}, xmm22

// CHECK: vpbroadcastd zmm11, eax
// CHECK:  encoding: [0x62,0x72,0x7d,0x48,0x7c,0xd8]
          vpbroadcastd zmm11, eax

// CHECK: vpbroadcastd zmm11 {k6}, eax
// CHECK:  encoding: [0x62,0x72,0x7d,0x4e,0x7c,0xd8]
          vpbroadcastd zmm11 {k6}, eax

// CHECK: vpbroadcastd zmm11 {k6} {z}, eax
// CHECK:  encoding: [0x62,0x72,0x7d,0xce,0x7c,0xd8]
          vpbroadcastd zmm11 {k6} {z}, eax

// CHECK: vpbroadcastd zmm11, ebp
// CHECK:  encoding: [0x62,0x72,0x7d,0x48,0x7c,0xdd]
          vpbroadcastd zmm11, ebp

// CHECK: vpbroadcastd zmm11, r13d
// CHECK:  encoding: [0x62,0x52,0x7d,0x48,0x7c,0xdd]
          vpbroadcastd zmm11, r13d

// CHECK: vpbroadcastq zmm25, qword ptr [rcx]
// CHECK:  encoding: [0x62,0x62,0xfd,0x48,0x59,0x09]
          vpbroadcastq zmm25, qword ptr [rcx]

// CHECK: vpbroadcastq zmm25 {k2}, qword ptr [rcx]
// CHECK:  encoding: [0x62,0x62,0xfd,0x4a,0x59,0x09]
          vpbroadcastq zmm25 {k2}, qword ptr [rcx]

// CHECK: vpbroadcastq zmm25 {k2} {z}, qword ptr [rcx]
// CHECK:  encoding: [0x62,0x62,0xfd,0xca,0x59,0x09]
          vpbroadcastq zmm25 {k2} {z}, qword ptr [rcx]

// CHECK: vpbroadcastq zmm25, qword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0x22,0xfd,0x48,0x59,0x8c,0xf0,0x23,0x01,0x00,0x00]
          vpbroadcastq zmm25, qword ptr [rax + 8*r14 + 291]

// CHECK: vpbroadcastq zmm25, qword ptr [rdx + 1016]
// CHECK:  encoding: [0x62,0x62,0xfd,0x48,0x59,0x4a,0x7f]
          vpbroadcastq zmm25, qword ptr [rdx + 1016]

// CHECK: vpbroadcastq zmm25, qword ptr [rdx + 1024]
// CHECK:  encoding: [0x62,0x62,0xfd,0x48,0x59,0x8a,0x00,0x04,0x00,0x00]
          vpbroadcastq zmm25, qword ptr [rdx + 1024]

// CHECK: vpbroadcastq zmm25, qword ptr [rdx - 1024]
// CHECK:  encoding: [0x62,0x62,0xfd,0x48,0x59,0x4a,0x80]
          vpbroadcastq zmm25, qword ptr [rdx - 1024]

// CHECK: vpbroadcastq zmm25, qword ptr [rdx - 1032]
// CHECK:  encoding: [0x62,0x62,0xfd,0x48,0x59,0x8a,0xf8,0xfb,0xff,0xff]
          vpbroadcastq zmm25, qword ptr [rdx - 1032]

// CHECK: vpbroadcastq zmm3, xmm5
// CHECK:  encoding: [0x62,0xf2,0xfd,0x48,0x59,0xdd]
          vpbroadcastq zmm3, xmm5

// CHECK: vpbroadcastq zmm3 {k5}, xmm5
// CHECK:  encoding: [0x62,0xf2,0xfd,0x4d,0x59,0xdd]
          vpbroadcastq zmm3 {k5}, xmm5

// CHECK: vpbroadcastq zmm3 {k5} {z}, xmm5
// CHECK:  encoding: [0x62,0xf2,0xfd,0xcd,0x59,0xdd]
          vpbroadcastq zmm3 {k5} {z}, xmm5

// CHECK: vpbroadcastq zmm1, rax
// CHECK:  encoding: [0x62,0xf2,0xfd,0x48,0x7c,0xc8]
          vpbroadcastq zmm1, rax

// CHECK: vpbroadcastq zmm1 {k6}, rax
// CHECK:  encoding: [0x62,0xf2,0xfd,0x4e,0x7c,0xc8]
          vpbroadcastq zmm1 {k6}, rax

// CHECK: vpbroadcastq zmm1 {k6} {z}, rax
// CHECK:  encoding: [0x62,0xf2,0xfd,0xce,0x7c,0xc8]
          vpbroadcastq zmm1 {k6} {z}, rax

// CHECK: vpbroadcastq zmm1, r8
// CHECK:  encoding: [0x62,0xd2,0xfd,0x48,0x7c,0xc8]
          vpbroadcastq zmm1, r8

// CHECK: vpcmpd k5, zmm25, zmm10, 171
// CHECK:  encoding: [0x62,0xd3,0x35,0x40,0x1f,0xea,0xab]
          vpcmpd k5, zmm25, zmm10, 171

// CHECK: vpcmpd k5 {k3}, zmm25, zmm10, 171
// CHECK:  encoding: [0x62,0xd3,0x35,0x43,0x1f,0xea,0xab]
          vpcmpd k5 {k3}, zmm25, zmm10, 171

// CHECK: vpcmpd k5, zmm25, zmm10, 123
// CHECK:  encoding: [0x62,0xd3,0x35,0x40,0x1f,0xea,0x7b]
          vpcmpd k5, zmm25, zmm10, 123

// CHECK: vpcmpd k5, zmm25, zmmword ptr [rcx], 123
// CHECK:  encoding: [0x62,0xf3,0x35,0x40,0x1f,0x29,0x7b]
          vpcmpd k5, zmm25, zmmword ptr [rcx], 123

// CHECK: vpcmpd k5, zmm25, zmmword ptr [rax + 8*r14 + 291], 123
// CHECK:  encoding: [0x62,0xb3,0x35,0x40,0x1f,0xac,0xf0,0x23,0x01,0x00,0x00,0x7b]
          vpcmpd k5, zmm25, zmmword ptr [rax + 8*r14 + 291], 123

// CHECK: vpcmpd k5, zmm25, dword ptr [rcx]{1to16}, 123
// CHECK:  encoding: [0x62,0xf3,0x35,0x50,0x1f,0x29,0x7b]
          vpcmpd k5, zmm25, dword ptr [rcx]{1to16}, 123

// CHECK: vpcmpd k5, zmm25, zmmword ptr [rdx + 8128], 123
// CHECK:  encoding: [0x62,0xf3,0x35,0x40,0x1f,0x6a,0x7f,0x7b]
          vpcmpd k5, zmm25, zmmword ptr [rdx + 8128], 123

// CHECK: vpcmpd k5, zmm25, zmmword ptr [rdx + 8192], 123
// CHECK:  encoding: [0x62,0xf3,0x35,0x40,0x1f,0xaa,0x00,0x20,0x00,0x00,0x7b]
          vpcmpd k5, zmm25, zmmword ptr [rdx + 8192], 123

// CHECK: vpcmpd k5, zmm25, zmmword ptr [rdx - 8192], 123
// CHECK:  encoding: [0x62,0xf3,0x35,0x40,0x1f,0x6a,0x80,0x7b]
          vpcmpd k5, zmm25, zmmword ptr [rdx - 8192], 123

// CHECK: vpcmpd k5, zmm25, zmmword ptr [rdx - 8256], 123
// CHECK:  encoding: [0x62,0xf3,0x35,0x40,0x1f,0xaa,0xc0,0xdf,0xff,0xff,0x7b]
          vpcmpd k5, zmm25, zmmword ptr [rdx - 8256], 123

// CHECK: vpcmpd k5, zmm25, dword ptr [rdx + 508]{1to16}, 123
// CHECK:  encoding: [0x62,0xf3,0x35,0x50,0x1f,0x6a,0x7f,0x7b]
          vpcmpd k5, zmm25, dword ptr [rdx + 508]{1to16}, 123

// CHECK: vpcmpd k5, zmm25, dword ptr [rdx + 512]{1to16}, 123
// CHECK:  encoding: [0x62,0xf3,0x35,0x50,0x1f,0xaa,0x00,0x02,0x00,0x00,0x7b]
          vpcmpd k5, zmm25, dword ptr [rdx + 512]{1to16}, 123

// CHECK: vpcmpd k5, zmm25, dword ptr [rdx - 512]{1to16}, 123
// CHECK:  encoding: [0x62,0xf3,0x35,0x50,0x1f,0x6a,0x80,0x7b]
          vpcmpd k5, zmm25, dword ptr [rdx - 512]{1to16}, 123

// CHECK: vpcmpd k5, zmm25, dword ptr [rdx - 516]{1to16}, 123
// CHECK:  encoding: [0x62,0xf3,0x35,0x50,0x1f,0xaa,0xfc,0xfd,0xff,0xff,0x7b]
          vpcmpd k5, zmm25, dword ptr [rdx - 516]{1to16}, 123

// CHECK: vpcmpeqd k5, zmm2, zmm10
// CHECK:  encoding: [0x62,0xd1,0x6d,0x48,0x76,0xea]
          vpcmpeqd k5, zmm2, zmm10

// CHECK: vpcmpeqd k5 {k7}, zmm2, zmm10
// CHECK:  encoding: [0x62,0xd1,0x6d,0x4f,0x76,0xea]
          vpcmpeqd k5 {k7}, zmm2, zmm10

// CHECK: vpcmpeqd k5, zmm2, zmmword ptr [rcx]
// CHECK:  encoding: [0x62,0xf1,0x6d,0x48,0x76,0x29]
          vpcmpeqd k5, zmm2, zmmword ptr [rcx]

// CHECK: vpcmpeqd k5, zmm2, zmmword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0xb1,0x6d,0x48,0x76,0xac,0xf0,0x23,0x01,0x00,0x00]
          vpcmpeqd k5, zmm2, zmmword ptr [rax + 8*r14 + 291]

// CHECK: vpcmpeqd k5, zmm2, dword ptr [rcx]{1to16}
// CHECK:  encoding: [0x62,0xf1,0x6d,0x58,0x76,0x29]
          vpcmpeqd k5, zmm2, dword ptr [rcx]{1to16}

// CHECK: vpcmpeqd k5, zmm2, zmmword ptr [rdx + 8128]
// CHECK:  encoding: [0x62,0xf1,0x6d,0x48,0x76,0x6a,0x7f]
          vpcmpeqd k5, zmm2, zmmword ptr [rdx + 8128]

// CHECK: vpcmpeqd k5, zmm2, zmmword ptr [rdx + 8192]
// CHECK:  encoding: [0x62,0xf1,0x6d,0x48,0x76,0xaa,0x00,0x20,0x00,0x00]
          vpcmpeqd k5, zmm2, zmmword ptr [rdx + 8192]

// CHECK: vpcmpeqd k5, zmm2, zmmword ptr [rdx - 8192]
// CHECK:  encoding: [0x62,0xf1,0x6d,0x48,0x76,0x6a,0x80]
          vpcmpeqd k5, zmm2, zmmword ptr [rdx - 8192]

// CHECK: vpcmpeqd k5, zmm2, zmmword ptr [rdx - 8256]
// CHECK:  encoding: [0x62,0xf1,0x6d,0x48,0x76,0xaa,0xc0,0xdf,0xff,0xff]
          vpcmpeqd k5, zmm2, zmmword ptr [rdx - 8256]

// CHECK: vpcmpeqd k5, zmm2, dword ptr [rdx + 508]{1to16}
// CHECK:  encoding: [0x62,0xf1,0x6d,0x58,0x76,0x6a,0x7f]
          vpcmpeqd k5, zmm2, dword ptr [rdx + 508]{1to16}

// CHECK: vpcmpeqd k5, zmm2, dword ptr [rdx + 512]{1to16}
// CHECK:  encoding: [0x62,0xf1,0x6d,0x58,0x76,0xaa,0x00,0x02,0x00,0x00]
          vpcmpeqd k5, zmm2, dword ptr [rdx + 512]{1to16}

// CHECK: vpcmpeqd k5, zmm2, dword ptr [rdx - 512]{1to16}
// CHECK:  encoding: [0x62,0xf1,0x6d,0x58,0x76,0x6a,0x80]
          vpcmpeqd k5, zmm2, dword ptr [rdx - 512]{1to16}

// CHECK: vpcmpeqd k5, zmm2, dword ptr [rdx - 516]{1to16}
// CHECK:  encoding: [0x62,0xf1,0x6d,0x58,0x76,0xaa,0xfc,0xfd,0xff,0xff]
          vpcmpeqd k5, zmm2, dword ptr [rdx - 516]{1to16}

// CHECK: vpcmpeqq k3, zmm22, zmm2
// CHECK:  encoding: [0x62,0xf2,0xcd,0x40,0x29,0xda]
          vpcmpeqq k3, zmm22, zmm2

// CHECK: vpcmpeqq k3 {k6}, zmm22, zmm2
// CHECK:  encoding: [0x62,0xf2,0xcd,0x46,0x29,0xda]
          vpcmpeqq k3 {k6}, zmm22, zmm2

// CHECK: vpcmpeqq k3, zmm22, zmmword ptr [rcx]
// CHECK:  encoding: [0x62,0xf2,0xcd,0x40,0x29,0x19]
          vpcmpeqq k3, zmm22, zmmword ptr [rcx]

// CHECK: vpcmpeqq k3, zmm22, zmmword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0xb2,0xcd,0x40,0x29,0x9c,0xf0,0x23,0x01,0x00,0x00]
          vpcmpeqq k3, zmm22, zmmword ptr [rax + 8*r14 + 291]

// CHECK: vpcmpeqq k3, zmm22, qword ptr [rcx]{1to8}
// CHECK:  encoding: [0x62,0xf2,0xcd,0x50,0x29,0x19]
          vpcmpeqq k3, zmm22, qword ptr [rcx]{1to8}

// CHECK: vpcmpeqq k3, zmm22, zmmword ptr [rdx + 8128]
// CHECK:  encoding: [0x62,0xf2,0xcd,0x40,0x29,0x5a,0x7f]
          vpcmpeqq k3, zmm22, zmmword ptr [rdx + 8128]

// CHECK: vpcmpeqq k3, zmm22, zmmword ptr [rdx + 8192]
// CHECK:  encoding: [0x62,0xf2,0xcd,0x40,0x29,0x9a,0x00,0x20,0x00,0x00]
          vpcmpeqq k3, zmm22, zmmword ptr [rdx + 8192]

// CHECK: vpcmpeqq k3, zmm22, zmmword ptr [rdx - 8192]
// CHECK:  encoding: [0x62,0xf2,0xcd,0x40,0x29,0x5a,0x80]
          vpcmpeqq k3, zmm22, zmmword ptr [rdx - 8192]

// CHECK: vpcmpeqq k3, zmm22, zmmword ptr [rdx - 8256]
// CHECK:  encoding: [0x62,0xf2,0xcd,0x40,0x29,0x9a,0xc0,0xdf,0xff,0xff]
          vpcmpeqq k3, zmm22, zmmword ptr [rdx - 8256]

// CHECK: vpcmpeqq k3, zmm22, qword ptr [rdx + 1016]{1to8}
// CHECK:  encoding: [0x62,0xf2,0xcd,0x50,0x29,0x5a,0x7f]
          vpcmpeqq k3, zmm22, qword ptr [rdx + 1016]{1to8}

// CHECK: vpcmpeqq k3, zmm22, qword ptr [rdx + 1024]{1to8}
// CHECK:  encoding: [0x62,0xf2,0xcd,0x50,0x29,0x9a,0x00,0x04,0x00,0x00]
          vpcmpeqq k3, zmm22, qword ptr [rdx + 1024]{1to8}

// CHECK: vpcmpeqq k3, zmm22, qword ptr [rdx - 1024]{1to8}
// CHECK:  encoding: [0x62,0xf2,0xcd,0x50,0x29,0x5a,0x80]
          vpcmpeqq k3, zmm22, qword ptr [rdx - 1024]{1to8}

// CHECK: vpcmpeqq k3, zmm22, qword ptr [rdx - 1032]{1to8}
// CHECK:  encoding: [0x62,0xf2,0xcd,0x50,0x29,0x9a,0xf8,0xfb,0xff,0xff]
          vpcmpeqq k3, zmm22, qword ptr [rdx - 1032]{1to8}

// CHECK: vpcmpgtd k5, zmm21, zmm8
// CHECK:  encoding: [0x62,0xd1,0x55,0x40,0x66,0xe8]
          vpcmpgtd k5, zmm21, zmm8

// CHECK: vpcmpgtd k5 {k5}, zmm21, zmm8
// CHECK:  encoding: [0x62,0xd1,0x55,0x45,0x66,0xe8]
          vpcmpgtd k5 {k5}, zmm21, zmm8

// CHECK: vpcmpgtd k5, zmm21, zmmword ptr [rcx]
// CHECK:  encoding: [0x62,0xf1,0x55,0x40,0x66,0x29]
          vpcmpgtd k5, zmm21, zmmword ptr [rcx]

// CHECK: vpcmpgtd k5, zmm21, zmmword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0xb1,0x55,0x40,0x66,0xac,0xf0,0x23,0x01,0x00,0x00]
          vpcmpgtd k5, zmm21, zmmword ptr [rax + 8*r14 + 291]

// CHECK: vpcmpgtd k5, zmm21, dword ptr [rcx]{1to16}
// CHECK:  encoding: [0x62,0xf1,0x55,0x50,0x66,0x29]
          vpcmpgtd k5, zmm21, dword ptr [rcx]{1to16}

// CHECK: vpcmpgtd k5, zmm21, zmmword ptr [rdx + 8128]
// CHECK:  encoding: [0x62,0xf1,0x55,0x40,0x66,0x6a,0x7f]
          vpcmpgtd k5, zmm21, zmmword ptr [rdx + 8128]

// CHECK: vpcmpgtd k5, zmm21, zmmword ptr [rdx + 8192]
// CHECK:  encoding: [0x62,0xf1,0x55,0x40,0x66,0xaa,0x00,0x20,0x00,0x00]
          vpcmpgtd k5, zmm21, zmmword ptr [rdx + 8192]

// CHECK: vpcmpgtd k5, zmm21, zmmword ptr [rdx - 8192]
// CHECK:  encoding: [0x62,0xf1,0x55,0x40,0x66,0x6a,0x80]
          vpcmpgtd k5, zmm21, zmmword ptr [rdx - 8192]

// CHECK: vpcmpgtd k5, zmm21, zmmword ptr [rdx - 8256]
// CHECK:  encoding: [0x62,0xf1,0x55,0x40,0x66,0xaa,0xc0,0xdf,0xff,0xff]
          vpcmpgtd k5, zmm21, zmmword ptr [rdx - 8256]

// CHECK: vpcmpgtd k5, zmm21, dword ptr [rdx + 508]{1to16}
// CHECK:  encoding: [0x62,0xf1,0x55,0x50,0x66,0x6a,0x7f]
          vpcmpgtd k5, zmm21, dword ptr [rdx + 508]{1to16}

// CHECK: vpcmpgtd k5, zmm21, dword ptr [rdx + 512]{1to16}
// CHECK:  encoding: [0x62,0xf1,0x55,0x50,0x66,0xaa,0x00,0x02,0x00,0x00]
          vpcmpgtd k5, zmm21, dword ptr [rdx + 512]{1to16}

// CHECK: vpcmpgtd k5, zmm21, dword ptr [rdx - 512]{1to16}
// CHECK:  encoding: [0x62,0xf1,0x55,0x50,0x66,0x6a,0x80]
          vpcmpgtd k5, zmm21, dword ptr [rdx - 512]{1to16}

// CHECK: vpcmpgtd k5, zmm21, dword ptr [rdx - 516]{1to16}
// CHECK:  encoding: [0x62,0xf1,0x55,0x50,0x66,0xaa,0xfc,0xfd,0xff,0xff]
          vpcmpgtd k5, zmm21, dword ptr [rdx - 516]{1to16}

// CHECK: vpcmpgtq k2, zmm20, zmm17
// CHECK:  encoding: [0x62,0xb2,0xdd,0x40,0x37,0xd1]
          vpcmpgtq k2, zmm20, zmm17

// CHECK: vpcmpgtq k2 {k3}, zmm20, zmm17
// CHECK:  encoding: [0x62,0xb2,0xdd,0x43,0x37,0xd1]
          vpcmpgtq k2 {k3}, zmm20, zmm17

// CHECK: vpcmpgtq k2, zmm20, zmmword ptr [rcx]
// CHECK:  encoding: [0x62,0xf2,0xdd,0x40,0x37,0x11]
          vpcmpgtq k2, zmm20, zmmword ptr [rcx]

// CHECK: vpcmpgtq k2, zmm20, zmmword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0xb2,0xdd,0x40,0x37,0x94,0xf0,0x23,0x01,0x00,0x00]
          vpcmpgtq k2, zmm20, zmmword ptr [rax + 8*r14 + 291]

// CHECK: vpcmpgtq k2, zmm20, qword ptr [rcx]{1to8}
// CHECK:  encoding: [0x62,0xf2,0xdd,0x50,0x37,0x11]
          vpcmpgtq k2, zmm20, qword ptr [rcx]{1to8}

// CHECK: vpcmpgtq k2, zmm20, zmmword ptr [rdx + 8128]
// CHECK:  encoding: [0x62,0xf2,0xdd,0x40,0x37,0x52,0x7f]
          vpcmpgtq k2, zmm20, zmmword ptr [rdx + 8128]

// CHECK: vpcmpgtq k2, zmm20, zmmword ptr [rdx + 8192]
// CHECK:  encoding: [0x62,0xf2,0xdd,0x40,0x37,0x92,0x00,0x20,0x00,0x00]
          vpcmpgtq k2, zmm20, zmmword ptr [rdx + 8192]

// CHECK: vpcmpgtq k2, zmm20, zmmword ptr [rdx - 8192]
// CHECK:  encoding: [0x62,0xf2,0xdd,0x40,0x37,0x52,0x80]
          vpcmpgtq k2, zmm20, zmmword ptr [rdx - 8192]

// CHECK: vpcmpgtq k2, zmm20, zmmword ptr [rdx - 8256]
// CHECK:  encoding: [0x62,0xf2,0xdd,0x40,0x37,0x92,0xc0,0xdf,0xff,0xff]
          vpcmpgtq k2, zmm20, zmmword ptr [rdx - 8256]

// CHECK: vpcmpgtq k2, zmm20, qword ptr [rdx + 1016]{1to8}
// CHECK:  encoding: [0x62,0xf2,0xdd,0x50,0x37,0x52,0x7f]
          vpcmpgtq k2, zmm20, qword ptr [rdx + 1016]{1to8}

// CHECK: vpcmpgtq k2, zmm20, qword ptr [rdx + 1024]{1to8}
// CHECK:  encoding: [0x62,0xf2,0xdd,0x50,0x37,0x92,0x00,0x04,0x00,0x00]
          vpcmpgtq k2, zmm20, qword ptr [rdx + 1024]{1to8}

// CHECK: vpcmpgtq k2, zmm20, qword ptr [rdx - 1024]{1to8}
// CHECK:  encoding: [0x62,0xf2,0xdd,0x50,0x37,0x52,0x80]
          vpcmpgtq k2, zmm20, qword ptr [rdx - 1024]{1to8}

// CHECK: vpcmpgtq k2, zmm20, qword ptr [rdx - 1032]{1to8}
// CHECK:  encoding: [0x62,0xf2,0xdd,0x50,0x37,0x92,0xf8,0xfb,0xff,0xff]
          vpcmpgtq k2, zmm20, qword ptr [rdx - 1032]{1to8}

// CHECK: vpcmpq k5, zmm28, zmm28, 171
// CHECK:  encoding: [0x62,0x93,0x9d,0x40,0x1f,0xec,0xab]
          vpcmpq k5, zmm28, zmm28, 171

// CHECK: vpcmpq k5 {k3}, zmm28, zmm28, 171
// CHECK:  encoding: [0x62,0x93,0x9d,0x43,0x1f,0xec,0xab]
          vpcmpq k5 {k3}, zmm28, zmm28, 171

// CHECK: vpcmpq k5, zmm28, zmm28, 123
// CHECK:  encoding: [0x62,0x93,0x9d,0x40,0x1f,0xec,0x7b]
          vpcmpq k5, zmm28, zmm28, 123

// CHECK: vpcmpq k5, zmm28, zmmword ptr [rcx], 123
// CHECK:  encoding: [0x62,0xf3,0x9d,0x40,0x1f,0x29,0x7b]
          vpcmpq k5, zmm28, zmmword ptr [rcx], 123

// CHECK: vpcmpq k5, zmm28, zmmword ptr [rax + 8*r14 + 291], 123
// CHECK:  encoding: [0x62,0xb3,0x9d,0x40,0x1f,0xac,0xf0,0x23,0x01,0x00,0x00,0x7b]
          vpcmpq k5, zmm28, zmmword ptr [rax + 8*r14 + 291], 123

// CHECK: vpcmpq k5, zmm28, qword ptr [rcx]{1to8}, 123
// CHECK:  encoding: [0x62,0xf3,0x9d,0x50,0x1f,0x29,0x7b]
          vpcmpq k5, zmm28, qword ptr [rcx]{1to8}, 123

// CHECK: vpcmpq k5, zmm28, zmmword ptr [rdx + 8128], 123
// CHECK:  encoding: [0x62,0xf3,0x9d,0x40,0x1f,0x6a,0x7f,0x7b]
          vpcmpq k5, zmm28, zmmword ptr [rdx + 8128], 123

// CHECK: vpcmpq k5, zmm28, zmmword ptr [rdx + 8192], 123
// CHECK:  encoding: [0x62,0xf3,0x9d,0x40,0x1f,0xaa,0x00,0x20,0x00,0x00,0x7b]
          vpcmpq k5, zmm28, zmmword ptr [rdx + 8192], 123

// CHECK: vpcmpq k5, zmm28, zmmword ptr [rdx - 8192], 123
// CHECK:  encoding: [0x62,0xf3,0x9d,0x40,0x1f,0x6a,0x80,0x7b]
          vpcmpq k5, zmm28, zmmword ptr [rdx - 8192], 123

// CHECK: vpcmpq k5, zmm28, zmmword ptr [rdx - 8256], 123
// CHECK:  encoding: [0x62,0xf3,0x9d,0x40,0x1f,0xaa,0xc0,0xdf,0xff,0xff,0x7b]
          vpcmpq k5, zmm28, zmmword ptr [rdx - 8256], 123

// CHECK: vpcmpq k5, zmm28, qword ptr [rdx + 1016]{1to8}, 123
// CHECK:  encoding: [0x62,0xf3,0x9d,0x50,0x1f,0x6a,0x7f,0x7b]
          vpcmpq k5, zmm28, qword ptr [rdx + 1016]{1to8}, 123

// CHECK: vpcmpq k5, zmm28, qword ptr [rdx + 1024]{1to8}, 123
// CHECK:  encoding: [0x62,0xf3,0x9d,0x50,0x1f,0xaa,0x00,0x04,0x00,0x00,0x7b]
          vpcmpq k5, zmm28, qword ptr [rdx + 1024]{1to8}, 123

// CHECK: vpcmpq k5, zmm28, qword ptr [rdx - 1024]{1to8}, 123
// CHECK:  encoding: [0x62,0xf3,0x9d,0x50,0x1f,0x6a,0x80,0x7b]
          vpcmpq k5, zmm28, qword ptr [rdx - 1024]{1to8}, 123

// CHECK: vpcmpq k5, zmm28, qword ptr [rdx - 1032]{1to8}, 123
// CHECK:  encoding: [0x62,0xf3,0x9d,0x50,0x1f,0xaa,0xf8,0xfb,0xff,0xff,0x7b]
          vpcmpq k5, zmm28, qword ptr [rdx - 1032]{1to8}, 123

// CHECK: vpcmpud k2, zmm25, zmm7, 171
// CHECK:  encoding: [0x62,0xf3,0x35,0x40,0x1e,0xd7,0xab]
          vpcmpud k2, zmm25, zmm7, 171

// CHECK: vpcmpud k2 {k1}, zmm25, zmm7, 171
// CHECK:  encoding: [0x62,0xf3,0x35,0x41,0x1e,0xd7,0xab]
          vpcmpud k2 {k1}, zmm25, zmm7, 171

// CHECK: vpcmpud k2, zmm25, zmm7, 123
// CHECK:  encoding: [0x62,0xf3,0x35,0x40,0x1e,0xd7,0x7b]
          vpcmpud k2, zmm25, zmm7, 123

// CHECK: vpcmpud k2, zmm25, zmmword ptr [rcx], 123
// CHECK:  encoding: [0x62,0xf3,0x35,0x40,0x1e,0x11,0x7b]
          vpcmpud k2, zmm25, zmmword ptr [rcx], 123

// CHECK: vpcmpud k2, zmm25, zmmword ptr [rax + 8*r14 + 291], 123
// CHECK:  encoding: [0x62,0xb3,0x35,0x40,0x1e,0x94,0xf0,0x23,0x01,0x00,0x00,0x7b]
          vpcmpud k2, zmm25, zmmword ptr [rax + 8*r14 + 291], 123

// CHECK: vpcmpud k2, zmm25, dword ptr [rcx]{1to16}, 123
// CHECK:  encoding: [0x62,0xf3,0x35,0x50,0x1e,0x11,0x7b]
          vpcmpud k2, zmm25, dword ptr [rcx]{1to16}, 123

// CHECK: vpcmpud k2, zmm25, zmmword ptr [rdx + 8128], 123
// CHECK:  encoding: [0x62,0xf3,0x35,0x40,0x1e,0x52,0x7f,0x7b]
          vpcmpud k2, zmm25, zmmword ptr [rdx + 8128], 123

// CHECK: vpcmpud k2, zmm25, zmmword ptr [rdx + 8192], 123
// CHECK:  encoding: [0x62,0xf3,0x35,0x40,0x1e,0x92,0x00,0x20,0x00,0x00,0x7b]
          vpcmpud k2, zmm25, zmmword ptr [rdx + 8192], 123

// CHECK: vpcmpud k2, zmm25, zmmword ptr [rdx - 8192], 123
// CHECK:  encoding: [0x62,0xf3,0x35,0x40,0x1e,0x52,0x80,0x7b]
          vpcmpud k2, zmm25, zmmword ptr [rdx - 8192], 123

// CHECK: vpcmpud k2, zmm25, zmmword ptr [rdx - 8256], 123
// CHECK:  encoding: [0x62,0xf3,0x35,0x40,0x1e,0x92,0xc0,0xdf,0xff,0xff,0x7b]
          vpcmpud k2, zmm25, zmmword ptr [rdx - 8256], 123

// CHECK: vpcmpud k2, zmm25, dword ptr [rdx + 508]{1to16}, 123
// CHECK:  encoding: [0x62,0xf3,0x35,0x50,0x1e,0x52,0x7f,0x7b]
          vpcmpud k2, zmm25, dword ptr [rdx + 508]{1to16}, 123

// CHECK: vpcmpud k2, zmm25, dword ptr [rdx + 512]{1to16}, 123
// CHECK:  encoding: [0x62,0xf3,0x35,0x50,0x1e,0x92,0x00,0x02,0x00,0x00,0x7b]
          vpcmpud k2, zmm25, dword ptr [rdx + 512]{1to16}, 123

// CHECK: vpcmpud k2, zmm25, dword ptr [rdx - 512]{1to16}, 123
// CHECK:  encoding: [0x62,0xf3,0x35,0x50,0x1e,0x52,0x80,0x7b]
          vpcmpud k2, zmm25, dword ptr [rdx - 512]{1to16}, 123

// CHECK: vpcmpud k2, zmm25, dword ptr [rdx - 516]{1to16}, 123
// CHECK:  encoding: [0x62,0xf3,0x35,0x50,0x1e,0x92,0xfc,0xfd,0xff,0xff,0x7b]
          vpcmpud k2, zmm25, dword ptr [rdx - 516]{1to16}, 123

// CHECK: vpcmpuq k3, zmm14, zmm8, 171
// CHECK:  encoding: [0x62,0xd3,0x8d,0x48,0x1e,0xd8,0xab]
          vpcmpuq k3, zmm14, zmm8, 171

// CHECK: vpcmpuq k3 {k2}, zmm14, zmm8, 171
// CHECK:  encoding: [0x62,0xd3,0x8d,0x4a,0x1e,0xd8,0xab]
          vpcmpuq k3 {k2}, zmm14, zmm8, 171

// CHECK: vpcmpuq k3, zmm14, zmm8, 123
// CHECK:  encoding: [0x62,0xd3,0x8d,0x48,0x1e,0xd8,0x7b]
          vpcmpuq k3, zmm14, zmm8, 123

// CHECK: vpcmpuq k3, zmm14, zmmword ptr [rcx], 123
// CHECK:  encoding: [0x62,0xf3,0x8d,0x48,0x1e,0x19,0x7b]
          vpcmpuq k3, zmm14, zmmword ptr [rcx], 123

// CHECK: vpcmpuq k3, zmm14, zmmword ptr [rax + 8*r14 + 291], 123
// CHECK:  encoding: [0x62,0xb3,0x8d,0x48,0x1e,0x9c,0xf0,0x23,0x01,0x00,0x00,0x7b]
          vpcmpuq k3, zmm14, zmmword ptr [rax + 8*r14 + 291], 123

// CHECK: vpcmpuq k3, zmm14, qword ptr [rcx]{1to8}, 123
// CHECK:  encoding: [0x62,0xf3,0x8d,0x58,0x1e,0x19,0x7b]
          vpcmpuq k3, zmm14, qword ptr [rcx]{1to8}, 123

// CHECK: vpcmpuq k3, zmm14, zmmword ptr [rdx + 8128], 123
// CHECK:  encoding: [0x62,0xf3,0x8d,0x48,0x1e,0x5a,0x7f,0x7b]
          vpcmpuq k3, zmm14, zmmword ptr [rdx + 8128], 123

// CHECK: vpcmpuq k3, zmm14, zmmword ptr [rdx + 8192], 123
// CHECK:  encoding: [0x62,0xf3,0x8d,0x48,0x1e,0x9a,0x00,0x20,0x00,0x00,0x7b]
          vpcmpuq k3, zmm14, zmmword ptr [rdx + 8192], 123

// CHECK: vpcmpuq k3, zmm14, zmmword ptr [rdx - 8192], 123
// CHECK:  encoding: [0x62,0xf3,0x8d,0x48,0x1e,0x5a,0x80,0x7b]
          vpcmpuq k3, zmm14, zmmword ptr [rdx - 8192], 123

// CHECK: vpcmpuq k3, zmm14, zmmword ptr [rdx - 8256], 123
// CHECK:  encoding: [0x62,0xf3,0x8d,0x48,0x1e,0x9a,0xc0,0xdf,0xff,0xff,0x7b]
          vpcmpuq k3, zmm14, zmmword ptr [rdx - 8256], 123

// CHECK: vpcmpuq k3, zmm14, qword ptr [rdx + 1016]{1to8}, 123
// CHECK:  encoding: [0x62,0xf3,0x8d,0x58,0x1e,0x5a,0x7f,0x7b]
          vpcmpuq k3, zmm14, qword ptr [rdx + 1016]{1to8}, 123

// CHECK: vpcmpuq k3, zmm14, qword ptr [rdx + 1024]{1to8}, 123
// CHECK:  encoding: [0x62,0xf3,0x8d,0x58,0x1e,0x9a,0x00,0x04,0x00,0x00,0x7b]
          vpcmpuq k3, zmm14, qword ptr [rdx + 1024]{1to8}, 123

// CHECK: vpcmpuq k3, zmm14, qword ptr [rdx - 1024]{1to8}, 123
// CHECK:  encoding: [0x62,0xf3,0x8d,0x58,0x1e,0x5a,0x80,0x7b]
          vpcmpuq k3, zmm14, qword ptr [rdx - 1024]{1to8}, 123

// CHECK: vpcmpuq k3, zmm14, qword ptr [rdx - 1032]{1to8}, 123
// CHECK:  encoding: [0x62,0xf3,0x8d,0x58,0x1e,0x9a,0xf8,0xfb,0xff,0xff,0x7b]
          vpcmpuq k3, zmm14, qword ptr [rdx - 1032]{1to8}, 123

// CHECK: vpblendmq zmm27, zmm14, zmm17
// CHECK:  encoding: [0x62,0x22,0x8d,0x48,0x64,0xd9]
          vpblendmq zmm27, zmm14, zmm17

// CHECK: vpblendmq zmm27 {k5}, zmm14, zmm17
// CHECK:  encoding: [0x62,0x22,0x8d,0x4d,0x64,0xd9]
          vpblendmq zmm27 {k5}, zmm14, zmm17

// CHECK: vpblendmq zmm27 {k5} {z}, zmm14, zmm17
// CHECK:  encoding: [0x62,0x22,0x8d,0xcd,0x64,0xd9]
          vpblendmq zmm27 {k5} {z}, zmm14, zmm17

// CHECK: vpblendmq zmm27, zmm14, zmmword ptr [rcx]
// CHECK:  encoding: [0x62,0x62,0x8d,0x48,0x64,0x19]
          vpblendmq zmm27, zmm14, zmmword ptr [rcx]

// CHECK: vpblendmq zmm27, zmm14, zmmword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0x22,0x8d,0x48,0x64,0x9c,0xf0,0x23,0x01,0x00,0x00]
          vpblendmq zmm27, zmm14, zmmword ptr [rax + 8*r14 + 291]

// CHECK: vpblendmq zmm27, zmm14, qword ptr [rcx]{1to8}
// CHECK:  encoding: [0x62,0x62,0x8d,0x58,0x64,0x19]
          vpblendmq zmm27, zmm14, qword ptr [rcx]{1to8}

// CHECK: vpblendmq zmm27, zmm14, zmmword ptr [rdx + 8128]
// CHECK:  encoding: [0x62,0x62,0x8d,0x48,0x64,0x5a,0x7f]
          vpblendmq zmm27, zmm14, zmmword ptr [rdx + 8128]

// CHECK: vpblendmq zmm27, zmm14, zmmword ptr [rdx + 8192]
// CHECK:  encoding: [0x62,0x62,0x8d,0x48,0x64,0x9a,0x00,0x20,0x00,0x00]
          vpblendmq zmm27, zmm14, zmmword ptr [rdx + 8192]

// CHECK: vpblendmq zmm27, zmm14, zmmword ptr [rdx - 8192]
// CHECK:  encoding: [0x62,0x62,0x8d,0x48,0x64,0x5a,0x80]
          vpblendmq zmm27, zmm14, zmmword ptr [rdx - 8192]

// CHECK: vpblendmq zmm27, zmm14, zmmword ptr [rdx - 8256]
// CHECK:  encoding: [0x62,0x62,0x8d,0x48,0x64,0x9a,0xc0,0xdf,0xff,0xff]
          vpblendmq zmm27, zmm14, zmmword ptr [rdx - 8256]

// CHECK: vpblendmq zmm27, zmm14, qword ptr [rdx + 1016]{1to8}
// CHECK:  encoding: [0x62,0x62,0x8d,0x58,0x64,0x5a,0x7f]
          vpblendmq zmm27, zmm14, qword ptr [rdx + 1016]{1to8}

// CHECK: vpblendmq zmm27, zmm14, qword ptr [rdx + 1024]{1to8}
// CHECK:  encoding: [0x62,0x62,0x8d,0x58,0x64,0x9a,0x00,0x04,0x00,0x00]
          vpblendmq zmm27, zmm14, qword ptr [rdx + 1024]{1to8}

// CHECK: vpblendmq zmm27, zmm14, qword ptr [rdx - 1024]{1to8}
// CHECK:  encoding: [0x62,0x62,0x8d,0x58,0x64,0x5a,0x80]
          vpblendmq zmm27, zmm14, qword ptr [rdx - 1024]{1to8}

// CHECK: vpblendmq zmm27, zmm14, qword ptr [rdx - 1032]{1to8}
// CHECK:  encoding: [0x62,0x62,0x8d,0x58,0x64,0x9a,0xf8,0xfb,0xff,0xff]
          vpblendmq zmm27, zmm14, qword ptr [rdx - 1032]{1to8}

// CHECK: vpcompressd zmmword ptr [rcx], zmm23
// CHECK:  encoding: [0x62,0xe2,0x7d,0x48,0x8b,0x39]
          vpcompressd zmmword ptr [rcx], zmm23

// CHECK: vpcompressd zmmword ptr [rcx] {k7}, zmm23
// CHECK:  encoding: [0x62,0xe2,0x7d,0x4f,0x8b,0x39]
          vpcompressd zmmword ptr [rcx] {k7}, zmm23

// CHECK: vpcompressd zmmword ptr [rax + 8*r14 + 291], zmm23
// CHECK:  encoding: [0x62,0xa2,0x7d,0x48,0x8b,0xbc,0xf0,0x23,0x01,0x00,0x00]
          vpcompressd zmmword ptr [rax + 8*r14 + 291], zmm23

// CHECK: vpcompressd zmmword ptr [rdx + 508], zmm23
// CHECK:  encoding: [0x62,0xe2,0x7d,0x48,0x8b,0x7a,0x7f]
          vpcompressd zmmword ptr [rdx + 508], zmm23

// CHECK: vpcompressd zmmword ptr [rdx + 512], zmm23
// CHECK:  encoding: [0x62,0xe2,0x7d,0x48,0x8b,0xba,0x00,0x02,0x00,0x00]
          vpcompressd zmmword ptr [rdx + 512], zmm23

// CHECK: vpcompressd zmmword ptr [rdx - 512], zmm23
// CHECK:  encoding: [0x62,0xe2,0x7d,0x48,0x8b,0x7a,0x80]
          vpcompressd zmmword ptr [rdx - 512], zmm23

// CHECK: vpcompressd zmmword ptr [rdx - 516], zmm23
// CHECK:  encoding: [0x62,0xe2,0x7d,0x48,0x8b,0xba,0xfc,0xfd,0xff,0xff]
          vpcompressd zmmword ptr [rdx - 516], zmm23

// CHECK: vpcompressd zmm16, zmm18
// CHECK:  encoding: [0x62,0xa2,0x7d,0x48,0x8b,0xd0]
          vpcompressd zmm16, zmm18

// CHECK: vpcompressd zmm16 {k2}, zmm18
// CHECK:  encoding: [0x62,0xa2,0x7d,0x4a,0x8b,0xd0]
          vpcompressd zmm16 {k2}, zmm18

// CHECK: vpcompressd zmm16 {k2} {z}, zmm18
// CHECK:  encoding: [0x62,0xa2,0x7d,0xca,0x8b,0xd0]
          vpcompressd zmm16 {k2} {z}, zmm18

// CHECK: vpermd zmm22, zmm28, zmm9
// CHECK:  encoding: [0x62,0xc2,0x1d,0x40,0x36,0xf1]
          vpermd zmm22, zmm28, zmm9

// CHECK: vpermd zmm22 {k1}, zmm28, zmm9
// CHECK:  encoding: [0x62,0xc2,0x1d,0x41,0x36,0xf1]
          vpermd zmm22 {k1}, zmm28, zmm9

// CHECK: vpermd zmm22 {k1} {z}, zmm28, zmm9
// CHECK:  encoding: [0x62,0xc2,0x1d,0xc1,0x36,0xf1]
          vpermd zmm22 {k1} {z}, zmm28, zmm9

// CHECK: vpermd zmm22, zmm28, zmmword ptr [rcx]
// CHECK:  encoding: [0x62,0xe2,0x1d,0x40,0x36,0x31]
          vpermd zmm22, zmm28, zmmword ptr [rcx]

// CHECK: vpermd zmm22, zmm28, zmmword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0xa2,0x1d,0x40,0x36,0xb4,0xf0,0x23,0x01,0x00,0x00]
          vpermd zmm22, zmm28, zmmword ptr [rax + 8*r14 + 291]

// CHECK: vpermd zmm22, zmm28, dword ptr [rcx]{1to16}
// CHECK:  encoding: [0x62,0xe2,0x1d,0x50,0x36,0x31]
          vpermd zmm22, zmm28, dword ptr [rcx]{1to16}

// CHECK: vpermd zmm22, zmm28, zmmword ptr [rdx + 8128]
// CHECK:  encoding: [0x62,0xe2,0x1d,0x40,0x36,0x72,0x7f]
          vpermd zmm22, zmm28, zmmword ptr [rdx + 8128]

// CHECK: vpermd zmm22, zmm28, zmmword ptr [rdx + 8192]
// CHECK:  encoding: [0x62,0xe2,0x1d,0x40,0x36,0xb2,0x00,0x20,0x00,0x00]
          vpermd zmm22, zmm28, zmmword ptr [rdx + 8192]

// CHECK: vpermd zmm22, zmm28, zmmword ptr [rdx - 8192]
// CHECK:  encoding: [0x62,0xe2,0x1d,0x40,0x36,0x72,0x80]
          vpermd zmm22, zmm28, zmmword ptr [rdx - 8192]

// CHECK: vpermd zmm22, zmm28, zmmword ptr [rdx - 8256]
// CHECK:  encoding: [0x62,0xe2,0x1d,0x40,0x36,0xb2,0xc0,0xdf,0xff,0xff]
          vpermd zmm22, zmm28, zmmword ptr [rdx - 8256]

// CHECK: vpermd zmm22, zmm28, dword ptr [rdx + 508]{1to16}
// CHECK:  encoding: [0x62,0xe2,0x1d,0x50,0x36,0x72,0x7f]
          vpermd zmm22, zmm28, dword ptr [rdx + 508]{1to16}

// CHECK: vpermd zmm22, zmm28, dword ptr [rdx + 512]{1to16}
// CHECK:  encoding: [0x62,0xe2,0x1d,0x50,0x36,0xb2,0x00,0x02,0x00,0x00]
          vpermd zmm22, zmm28, dword ptr [rdx + 512]{1to16}

// CHECK: vpermd zmm22, zmm28, dword ptr [rdx - 512]{1to16}
// CHECK:  encoding: [0x62,0xe2,0x1d,0x50,0x36,0x72,0x80]
          vpermd zmm22, zmm28, dword ptr [rdx - 512]{1to16}

// CHECK: vpermd zmm22, zmm28, dword ptr [rdx - 516]{1to16}
// CHECK:  encoding: [0x62,0xe2,0x1d,0x50,0x36,0xb2,0xfc,0xfd,0xff,0xff]
          vpermd zmm22, zmm28, dword ptr [rdx - 516]{1to16}

// CHECK: vpermilpd zmm19, zmm4, 171
// CHECK:  encoding: [0x62,0xe3,0xfd,0x48,0x05,0xdc,0xab]
          vpermilpd zmm19, zmm4, 171

// CHECK: vpermilpd zmm19 {k1}, zmm4, 171
// CHECK:  encoding: [0x62,0xe3,0xfd,0x49,0x05,0xdc,0xab]
          vpermilpd zmm19 {k1}, zmm4, 171

// CHECK: vpermilpd zmm19 {k1} {z}, zmm4, 171
// CHECK:  encoding: [0x62,0xe3,0xfd,0xc9,0x05,0xdc,0xab]
          vpermilpd zmm19 {k1} {z}, zmm4, 171

// CHECK: vpermilpd zmm19, zmm4, 123
// CHECK:  encoding: [0x62,0xe3,0xfd,0x48,0x05,0xdc,0x7b]
          vpermilpd zmm19, zmm4, 123

// CHECK: vpermilpd zmm19, zmmword ptr [rcx], 123
// CHECK:  encoding: [0x62,0xe3,0xfd,0x48,0x05,0x19,0x7b]
          vpermilpd zmm19, zmmword ptr [rcx], 123

// CHECK: vpermilpd zmm19, zmmword ptr [rax + 8*r14 + 291], 123
// CHECK:  encoding: [0x62,0xa3,0xfd,0x48,0x05,0x9c,0xf0,0x23,0x01,0x00,0x00,0x7b]
          vpermilpd zmm19, zmmword ptr [rax + 8*r14 + 291], 123

// CHECK: vpermilpd zmm19, qword ptr [rcx]{1to8}, 123
// CHECK:  encoding: [0x62,0xe3,0xfd,0x58,0x05,0x19,0x7b]
          vpermilpd zmm19, qword ptr [rcx]{1to8}, 123

// CHECK: vpermilpd zmm19, zmmword ptr [rdx + 8128], 123
// CHECK:  encoding: [0x62,0xe3,0xfd,0x48,0x05,0x5a,0x7f,0x7b]
          vpermilpd zmm19, zmmword ptr [rdx + 8128], 123

// CHECK: vpermilpd zmm19, zmmword ptr [rdx + 8192], 123
// CHECK:  encoding: [0x62,0xe3,0xfd,0x48,0x05,0x9a,0x00,0x20,0x00,0x00,0x7b]
          vpermilpd zmm19, zmmword ptr [rdx + 8192], 123

// CHECK: vpermilpd zmm19, zmmword ptr [rdx - 8192], 123
// CHECK:  encoding: [0x62,0xe3,0xfd,0x48,0x05,0x5a,0x80,0x7b]
          vpermilpd zmm19, zmmword ptr [rdx - 8192], 123

// CHECK: vpermilpd zmm19, zmmword ptr [rdx - 8256], 123
// CHECK:  encoding: [0x62,0xe3,0xfd,0x48,0x05,0x9a,0xc0,0xdf,0xff,0xff,0x7b]
          vpermilpd zmm19, zmmword ptr [rdx - 8256], 123

// CHECK: vpermilpd zmm19, qword ptr [rdx + 1016]{1to8}, 123
// CHECK:  encoding: [0x62,0xe3,0xfd,0x58,0x05,0x5a,0x7f,0x7b]
          vpermilpd zmm19, qword ptr [rdx + 1016]{1to8}, 123

// CHECK: vpermilpd zmm19, qword ptr [rdx + 1024]{1to8}, 123
// CHECK:  encoding: [0x62,0xe3,0xfd,0x58,0x05,0x9a,0x00,0x04,0x00,0x00,0x7b]
          vpermilpd zmm19, qword ptr [rdx + 1024]{1to8}, 123

// CHECK: vpermilpd zmm19, qword ptr [rdx - 1024]{1to8}, 123
// CHECK:  encoding: [0x62,0xe3,0xfd,0x58,0x05,0x5a,0x80,0x7b]
          vpermilpd zmm19, qword ptr [rdx - 1024]{1to8}, 123

// CHECK: vpermilpd zmm19, qword ptr [rdx - 1032]{1to8}, 123
// CHECK:  encoding: [0x62,0xe3,0xfd,0x58,0x05,0x9a,0xf8,0xfb,0xff,0xff,0x7b]
          vpermilpd zmm19, qword ptr [rdx - 1032]{1to8}, 123

// CHECK: vpermilpd zmm1, zmm26, zmm21
// CHECK:  encoding: [0x62,0xb2,0xad,0x40,0x0d,0xcd]
          vpermilpd zmm1, zmm26, zmm21

// CHECK: vpermilpd zmm1 {k2}, zmm26, zmm21
// CHECK:  encoding: [0x62,0xb2,0xad,0x42,0x0d,0xcd]
          vpermilpd zmm1 {k2}, zmm26, zmm21

// CHECK: vpermilpd zmm1 {k2} {z}, zmm26, zmm21
// CHECK:  encoding: [0x62,0xb2,0xad,0xc2,0x0d,0xcd]
          vpermilpd zmm1 {k2} {z}, zmm26, zmm21

// CHECK: vpermilpd zmm1, zmm26, zmmword ptr [rcx]
// CHECK:  encoding: [0x62,0xf2,0xad,0x40,0x0d,0x09]
          vpermilpd zmm1, zmm26, zmmword ptr [rcx]

// CHECK: vpermilpd zmm1, zmm26, zmmword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0xb2,0xad,0x40,0x0d,0x8c,0xf0,0x23,0x01,0x00,0x00]
          vpermilpd zmm1, zmm26, zmmword ptr [rax + 8*r14 + 291]

// CHECK: vpermilpd zmm1, zmm26, qword ptr [rcx]{1to8}
// CHECK:  encoding: [0x62,0xf2,0xad,0x50,0x0d,0x09]
          vpermilpd zmm1, zmm26, qword ptr [rcx]{1to8}

// CHECK: vpermilpd zmm1, zmm26, zmmword ptr [rdx + 8128]
// CHECK:  encoding: [0x62,0xf2,0xad,0x40,0x0d,0x4a,0x7f]
          vpermilpd zmm1, zmm26, zmmword ptr [rdx + 8128]

// CHECK: vpermilpd zmm1, zmm26, zmmword ptr [rdx + 8192]
// CHECK:  encoding: [0x62,0xf2,0xad,0x40,0x0d,0x8a,0x00,0x20,0x00,0x00]
          vpermilpd zmm1, zmm26, zmmword ptr [rdx + 8192]

// CHECK: vpermilpd zmm1, zmm26, zmmword ptr [rdx - 8192]
// CHECK:  encoding: [0x62,0xf2,0xad,0x40,0x0d,0x4a,0x80]
          vpermilpd zmm1, zmm26, zmmword ptr [rdx - 8192]

// CHECK: vpermilpd zmm1, zmm26, zmmword ptr [rdx - 8256]
// CHECK:  encoding: [0x62,0xf2,0xad,0x40,0x0d,0x8a,0xc0,0xdf,0xff,0xff]
          vpermilpd zmm1, zmm26, zmmword ptr [rdx - 8256]

// CHECK: vpermilpd zmm1, zmm26, qword ptr [rdx + 1016]{1to8}
// CHECK:  encoding: [0x62,0xf2,0xad,0x50,0x0d,0x4a,0x7f]
          vpermilpd zmm1, zmm26, qword ptr [rdx + 1016]{1to8}

// CHECK: vpermilpd zmm1, zmm26, qword ptr [rdx + 1024]{1to8}
// CHECK:  encoding: [0x62,0xf2,0xad,0x50,0x0d,0x8a,0x00,0x04,0x00,0x00]
          vpermilpd zmm1, zmm26, qword ptr [rdx + 1024]{1to8}

// CHECK: vpermilpd zmm1, zmm26, qword ptr [rdx - 1024]{1to8}
// CHECK:  encoding: [0x62,0xf2,0xad,0x50,0x0d,0x4a,0x80]
          vpermilpd zmm1, zmm26, qword ptr [rdx - 1024]{1to8}

// CHECK: vpermilpd zmm1, zmm26, qword ptr [rdx - 1032]{1to8}
// CHECK:  encoding: [0x62,0xf2,0xad,0x50,0x0d,0x8a,0xf8,0xfb,0xff,0xff]
          vpermilpd zmm1, zmm26, qword ptr [rdx - 1032]{1to8}

// CHECK: vpermilps zmm2, zmm22, 171
// CHECK:  encoding: [0x62,0xb3,0x7d,0x48,0x04,0xd6,0xab]
          vpermilps zmm2, zmm22, 171

// CHECK: vpermilps zmm2 {k2}, zmm22, 171
// CHECK:  encoding: [0x62,0xb3,0x7d,0x4a,0x04,0xd6,0xab]
          vpermilps zmm2 {k2}, zmm22, 171

// CHECK: vpermilps zmm2 {k2} {z}, zmm22, 171
// CHECK:  encoding: [0x62,0xb3,0x7d,0xca,0x04,0xd6,0xab]
          vpermilps zmm2 {k2} {z}, zmm22, 171

// CHECK: vpermilps zmm2, zmm22, 123
// CHECK:  encoding: [0x62,0xb3,0x7d,0x48,0x04,0xd6,0x7b]
          vpermilps zmm2, zmm22, 123

// CHECK: vpermilps zmm2, zmmword ptr [rcx], 123
// CHECK:  encoding: [0x62,0xf3,0x7d,0x48,0x04,0x11,0x7b]
          vpermilps zmm2, zmmword ptr [rcx], 123

// CHECK: vpermilps zmm2, zmmword ptr [rax + 8*r14 + 291], 123
// CHECK:  encoding: [0x62,0xb3,0x7d,0x48,0x04,0x94,0xf0,0x23,0x01,0x00,0x00,0x7b]
          vpermilps zmm2, zmmword ptr [rax + 8*r14 + 291], 123

// CHECK: vpermilps zmm2, dword ptr [rcx]{1to16}, 123
// CHECK:  encoding: [0x62,0xf3,0x7d,0x58,0x04,0x11,0x7b]
          vpermilps zmm2, dword ptr [rcx]{1to16}, 123

// CHECK: vpermilps zmm2, zmmword ptr [rdx + 8128], 123
// CHECK:  encoding: [0x62,0xf3,0x7d,0x48,0x04,0x52,0x7f,0x7b]
          vpermilps zmm2, zmmword ptr [rdx + 8128], 123

// CHECK: vpermilps zmm2, zmmword ptr [rdx + 8192], 123
// CHECK:  encoding: [0x62,0xf3,0x7d,0x48,0x04,0x92,0x00,0x20,0x00,0x00,0x7b]
          vpermilps zmm2, zmmword ptr [rdx + 8192], 123

// CHECK: vpermilps zmm2, zmmword ptr [rdx - 8192], 123
// CHECK:  encoding: [0x62,0xf3,0x7d,0x48,0x04,0x52,0x80,0x7b]
          vpermilps zmm2, zmmword ptr [rdx - 8192], 123

// CHECK: vpermilps zmm2, zmmword ptr [rdx - 8256], 123
// CHECK:  encoding: [0x62,0xf3,0x7d,0x48,0x04,0x92,0xc0,0xdf,0xff,0xff,0x7b]
          vpermilps zmm2, zmmword ptr [rdx - 8256], 123

// CHECK: vpermilps zmm2, dword ptr [rdx + 508]{1to16}, 123
// CHECK:  encoding: [0x62,0xf3,0x7d,0x58,0x04,0x52,0x7f,0x7b]
          vpermilps zmm2, dword ptr [rdx + 508]{1to16}, 123

// CHECK: vpermilps zmm2, dword ptr [rdx + 512]{1to16}, 123
// CHECK:  encoding: [0x62,0xf3,0x7d,0x58,0x04,0x92,0x00,0x02,0x00,0x00,0x7b]
          vpermilps zmm2, dword ptr [rdx + 512]{1to16}, 123

// CHECK: vpermilps zmm2, dword ptr [rdx - 512]{1to16}, 123
// CHECK:  encoding: [0x62,0xf3,0x7d,0x58,0x04,0x52,0x80,0x7b]
          vpermilps zmm2, dword ptr [rdx - 512]{1to16}, 123

// CHECK: vpermilps zmm2, dword ptr [rdx - 516]{1to16}, 123
// CHECK:  encoding: [0x62,0xf3,0x7d,0x58,0x04,0x92,0xfc,0xfd,0xff,0xff,0x7b]
          vpermilps zmm2, dword ptr [rdx - 516]{1to16}, 123

// CHECK: vpermilps zmm13, zmm20, zmm2
// CHECK:  encoding: [0x62,0x72,0x5d,0x40,0x0c,0xea]
          vpermilps zmm13, zmm20, zmm2

// CHECK: vpermilps zmm13 {k1}, zmm20, zmm2
// CHECK:  encoding: [0x62,0x72,0x5d,0x41,0x0c,0xea]
          vpermilps zmm13 {k1}, zmm20, zmm2

// CHECK: vpermilps zmm13 {k1} {z}, zmm20, zmm2
// CHECK:  encoding: [0x62,0x72,0x5d,0xc1,0x0c,0xea]
          vpermilps zmm13 {k1} {z}, zmm20, zmm2

// CHECK: vpermilps zmm13, zmm20, zmmword ptr [rcx]
// CHECK:  encoding: [0x62,0x72,0x5d,0x40,0x0c,0x29]
          vpermilps zmm13, zmm20, zmmword ptr [rcx]

// CHECK: vpermilps zmm13, zmm20, zmmword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0x32,0x5d,0x40,0x0c,0xac,0xf0,0x23,0x01,0x00,0x00]
          vpermilps zmm13, zmm20, zmmword ptr [rax + 8*r14 + 291]

// CHECK: vpermilps zmm13, zmm20, dword ptr [rcx]{1to16}
// CHECK:  encoding: [0x62,0x72,0x5d,0x50,0x0c,0x29]
          vpermilps zmm13, zmm20, dword ptr [rcx]{1to16}

// CHECK: vpermilps zmm13, zmm20, zmmword ptr [rdx + 8128]
// CHECK:  encoding: [0x62,0x72,0x5d,0x40,0x0c,0x6a,0x7f]
          vpermilps zmm13, zmm20, zmmword ptr [rdx + 8128]

// CHECK: vpermilps zmm13, zmm20, zmmword ptr [rdx + 8192]
// CHECK:  encoding: [0x62,0x72,0x5d,0x40,0x0c,0xaa,0x00,0x20,0x00,0x00]
          vpermilps zmm13, zmm20, zmmword ptr [rdx + 8192]

// CHECK: vpermilps zmm13, zmm20, zmmword ptr [rdx - 8192]
// CHECK:  encoding: [0x62,0x72,0x5d,0x40,0x0c,0x6a,0x80]
          vpermilps zmm13, zmm20, zmmword ptr [rdx - 8192]

// CHECK: vpermilps zmm13, zmm20, zmmword ptr [rdx - 8256]
// CHECK:  encoding: [0x62,0x72,0x5d,0x40,0x0c,0xaa,0xc0,0xdf,0xff,0xff]
          vpermilps zmm13, zmm20, zmmword ptr [rdx - 8256]

// CHECK: vpermilps zmm13, zmm20, dword ptr [rdx + 508]{1to16}
// CHECK:  encoding: [0x62,0x72,0x5d,0x50,0x0c,0x6a,0x7f]
          vpermilps zmm13, zmm20, dword ptr [rdx + 508]{1to16}

// CHECK: vpermilps zmm13, zmm20, dword ptr [rdx + 512]{1to16}
// CHECK:  encoding: [0x62,0x72,0x5d,0x50,0x0c,0xaa,0x00,0x02,0x00,0x00]
          vpermilps zmm13, zmm20, dword ptr [rdx + 512]{1to16}

// CHECK: vpermilps zmm13, zmm20, dword ptr [rdx - 512]{1to16}
// CHECK:  encoding: [0x62,0x72,0x5d,0x50,0x0c,0x6a,0x80]
          vpermilps zmm13, zmm20, dword ptr [rdx - 512]{1to16}

// CHECK: vpermilps zmm13, zmm20, dword ptr [rdx - 516]{1to16}
// CHECK:  encoding: [0x62,0x72,0x5d,0x50,0x0c,0xaa,0xfc,0xfd,0xff,0xff]
          vpermilps zmm13, zmm20, dword ptr [rdx - 516]{1to16}

// CHECK: vpermpd zmm3, zmm27, 171
// CHECK:  encoding: [0x62,0x93,0xfd,0x48,0x01,0xdb,0xab]
          vpermpd zmm3, zmm27, 171

// CHECK: vpermpd zmm3 {k2}, zmm27, 171
// CHECK:  encoding: [0x62,0x93,0xfd,0x4a,0x01,0xdb,0xab]
          vpermpd zmm3 {k2}, zmm27, 171

// CHECK: vpermpd zmm3 {k2} {z}, zmm27, 171
// CHECK:  encoding: [0x62,0x93,0xfd,0xca,0x01,0xdb,0xab]
          vpermpd zmm3 {k2} {z}, zmm27, 171

// CHECK: vpermpd zmm3, zmm27, 123
// CHECK:  encoding: [0x62,0x93,0xfd,0x48,0x01,0xdb,0x7b]
          vpermpd zmm3, zmm27, 123

// CHECK: vpermpd zmm3, zmmword ptr [rcx], 123
// CHECK:  encoding: [0x62,0xf3,0xfd,0x48,0x01,0x19,0x7b]
          vpermpd zmm3, zmmword ptr [rcx], 123

// CHECK: vpermpd zmm3, zmmword ptr [rax + 8*r14 + 291], 123
// CHECK:  encoding: [0x62,0xb3,0xfd,0x48,0x01,0x9c,0xf0,0x23,0x01,0x00,0x00,0x7b]
          vpermpd zmm3, zmmword ptr [rax + 8*r14 + 291], 123

// CHECK: vpermpd zmm3, qword ptr [rcx]{1to8}, 123
// CHECK:  encoding: [0x62,0xf3,0xfd,0x58,0x01,0x19,0x7b]
          vpermpd zmm3, qword ptr [rcx]{1to8}, 123

// CHECK: vpermpd zmm3, zmmword ptr [rdx + 8128], 123
// CHECK:  encoding: [0x62,0xf3,0xfd,0x48,0x01,0x5a,0x7f,0x7b]
          vpermpd zmm3, zmmword ptr [rdx + 8128], 123

// CHECK: vpermpd zmm3, zmmword ptr [rdx + 8192], 123
// CHECK:  encoding: [0x62,0xf3,0xfd,0x48,0x01,0x9a,0x00,0x20,0x00,0x00,0x7b]
          vpermpd zmm3, zmmword ptr [rdx + 8192], 123

// CHECK: vpermpd zmm3, zmmword ptr [rdx - 8192], 123
// CHECK:  encoding: [0x62,0xf3,0xfd,0x48,0x01,0x5a,0x80,0x7b]
          vpermpd zmm3, zmmword ptr [rdx - 8192], 123

// CHECK: vpermpd zmm3, zmmword ptr [rdx - 8256], 123
// CHECK:  encoding: [0x62,0xf3,0xfd,0x48,0x01,0x9a,0xc0,0xdf,0xff,0xff,0x7b]
          vpermpd zmm3, zmmword ptr [rdx - 8256], 123

// CHECK: vpermpd zmm3, qword ptr [rdx + 1016]{1to8}, 123
// CHECK:  encoding: [0x62,0xf3,0xfd,0x58,0x01,0x5a,0x7f,0x7b]
          vpermpd zmm3, qword ptr [rdx + 1016]{1to8}, 123

// CHECK: vpermpd zmm3, qword ptr [rdx + 1024]{1to8}, 123
// CHECK:  encoding: [0x62,0xf3,0xfd,0x58,0x01,0x9a,0x00,0x04,0x00,0x00,0x7b]
          vpermpd zmm3, qword ptr [rdx + 1024]{1to8}, 123

// CHECK: vpermpd zmm3, qword ptr [rdx - 1024]{1to8}, 123
// CHECK:  encoding: [0x62,0xf3,0xfd,0x58,0x01,0x5a,0x80,0x7b]
          vpermpd zmm3, qword ptr [rdx - 1024]{1to8}, 123

// CHECK: vpermpd zmm3, qword ptr [rdx - 1032]{1to8}, 123
// CHECK:  encoding: [0x62,0xf3,0xfd,0x58,0x01,0x9a,0xf8,0xfb,0xff,0xff,0x7b]
          vpermpd zmm3, qword ptr [rdx - 1032]{1to8}, 123

// CHECK: vpermps zmm4, zmm2, zmm24
// CHECK:  encoding: [0x62,0x92,0x6d,0x48,0x16,0xe0]
          vpermps zmm4, zmm2, zmm24

// CHECK: vpermps zmm4 {k4}, zmm2, zmm24
// CHECK:  encoding: [0x62,0x92,0x6d,0x4c,0x16,0xe0]
          vpermps zmm4 {k4}, zmm2, zmm24

// CHECK: vpermps zmm4 {k4} {z}, zmm2, zmm24
// CHECK:  encoding: [0x62,0x92,0x6d,0xcc,0x16,0xe0]
          vpermps zmm4 {k4} {z}, zmm2, zmm24

// CHECK: vpermps zmm4, zmm2, zmmword ptr [rcx]
// CHECK:  encoding: [0x62,0xf2,0x6d,0x48,0x16,0x21]
          vpermps zmm4, zmm2, zmmword ptr [rcx]

// CHECK: vpermps zmm4, zmm2, zmmword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0xb2,0x6d,0x48,0x16,0xa4,0xf0,0x23,0x01,0x00,0x00]
          vpermps zmm4, zmm2, zmmword ptr [rax + 8*r14 + 291]

// CHECK: vpermps zmm4, zmm2, dword ptr [rcx]{1to16}
// CHECK:  encoding: [0x62,0xf2,0x6d,0x58,0x16,0x21]
          vpermps zmm4, zmm2, dword ptr [rcx]{1to16}

// CHECK: vpermps zmm4, zmm2, zmmword ptr [rdx + 8128]
// CHECK:  encoding: [0x62,0xf2,0x6d,0x48,0x16,0x62,0x7f]
          vpermps zmm4, zmm2, zmmword ptr [rdx + 8128]

// CHECK: vpermps zmm4, zmm2, zmmword ptr [rdx + 8192]
// CHECK:  encoding: [0x62,0xf2,0x6d,0x48,0x16,0xa2,0x00,0x20,0x00,0x00]
          vpermps zmm4, zmm2, zmmword ptr [rdx + 8192]

// CHECK: vpermps zmm4, zmm2, zmmword ptr [rdx - 8192]
// CHECK:  encoding: [0x62,0xf2,0x6d,0x48,0x16,0x62,0x80]
          vpermps zmm4, zmm2, zmmword ptr [rdx - 8192]

// CHECK: vpermps zmm4, zmm2, zmmword ptr [rdx - 8256]
// CHECK:  encoding: [0x62,0xf2,0x6d,0x48,0x16,0xa2,0xc0,0xdf,0xff,0xff]
          vpermps zmm4, zmm2, zmmword ptr [rdx - 8256]

// CHECK: vpermps zmm4, zmm2, dword ptr [rdx + 508]{1to16}
// CHECK:  encoding: [0x62,0xf2,0x6d,0x58,0x16,0x62,0x7f]
          vpermps zmm4, zmm2, dword ptr [rdx + 508]{1to16}

// CHECK: vpermps zmm4, zmm2, dword ptr [rdx + 512]{1to16}
// CHECK:  encoding: [0x62,0xf2,0x6d,0x58,0x16,0xa2,0x00,0x02,0x00,0x00]
          vpermps zmm4, zmm2, dword ptr [rdx + 512]{1to16}

// CHECK: vpermps zmm4, zmm2, dword ptr [rdx - 512]{1to16}
// CHECK:  encoding: [0x62,0xf2,0x6d,0x58,0x16,0x62,0x80]
          vpermps zmm4, zmm2, dword ptr [rdx - 512]{1to16}

// CHECK: vpermps zmm4, zmm2, dword ptr [rdx - 516]{1to16}
// CHECK:  encoding: [0x62,0xf2,0x6d,0x58,0x16,0xa2,0xfc,0xfd,0xff,0xff]
          vpermps zmm4, zmm2, dword ptr [rdx - 516]{1to16}

// CHECK: vpermq zmm25, zmm4, 171
// CHECK:  encoding: [0x62,0x63,0xfd,0x48,0x00,0xcc,0xab]
          vpermq zmm25, zmm4, 171

// CHECK: vpermq zmm25 {k6}, zmm4, 171
// CHECK:  encoding: [0x62,0x63,0xfd,0x4e,0x00,0xcc,0xab]
          vpermq zmm25 {k6}, zmm4, 171

// CHECK: vpermq zmm25 {k6} {z}, zmm4, 171
// CHECK:  encoding: [0x62,0x63,0xfd,0xce,0x00,0xcc,0xab]
          vpermq zmm25 {k6} {z}, zmm4, 171

// CHECK: vpermq zmm25, zmm4, 123
// CHECK:  encoding: [0x62,0x63,0xfd,0x48,0x00,0xcc,0x7b]
          vpermq zmm25, zmm4, 123

// CHECK: vpermq zmm25, zmmword ptr [rcx], 123
// CHECK:  encoding: [0x62,0x63,0xfd,0x48,0x00,0x09,0x7b]
          vpermq zmm25, zmmword ptr [rcx], 123

// CHECK: vpermq zmm25, zmmword ptr [rax + 8*r14 + 291], 123
// CHECK:  encoding: [0x62,0x23,0xfd,0x48,0x00,0x8c,0xf0,0x23,0x01,0x00,0x00,0x7b]
          vpermq zmm25, zmmword ptr [rax + 8*r14 + 291], 123

// CHECK: vpermq zmm25, qword ptr [rcx]{1to8}, 123
// CHECK:  encoding: [0x62,0x63,0xfd,0x58,0x00,0x09,0x7b]
          vpermq zmm25, qword ptr [rcx]{1to8}, 123

// CHECK: vpermq zmm25, zmmword ptr [rdx + 8128], 123
// CHECK:  encoding: [0x62,0x63,0xfd,0x48,0x00,0x4a,0x7f,0x7b]
          vpermq zmm25, zmmword ptr [rdx + 8128], 123

// CHECK: vpermq zmm25, zmmword ptr [rdx + 8192], 123
// CHECK:  encoding: [0x62,0x63,0xfd,0x48,0x00,0x8a,0x00,0x20,0x00,0x00,0x7b]
          vpermq zmm25, zmmword ptr [rdx + 8192], 123

// CHECK: vpermq zmm25, zmmword ptr [rdx - 8192], 123
// CHECK:  encoding: [0x62,0x63,0xfd,0x48,0x00,0x4a,0x80,0x7b]
          vpermq zmm25, zmmword ptr [rdx - 8192], 123

// CHECK: vpermq zmm25, zmmword ptr [rdx - 8256], 123
// CHECK:  encoding: [0x62,0x63,0xfd,0x48,0x00,0x8a,0xc0,0xdf,0xff,0xff,0x7b]
          vpermq zmm25, zmmword ptr [rdx - 8256], 123

// CHECK: vpermq zmm25, qword ptr [rdx + 1016]{1to8}, 123
// CHECK:  encoding: [0x62,0x63,0xfd,0x58,0x00,0x4a,0x7f,0x7b]
          vpermq zmm25, qword ptr [rdx + 1016]{1to8}, 123

// CHECK: vpermq zmm25, qword ptr [rdx + 1024]{1to8}, 123
// CHECK:  encoding: [0x62,0x63,0xfd,0x58,0x00,0x8a,0x00,0x04,0x00,0x00,0x7b]
          vpermq zmm25, qword ptr [rdx + 1024]{1to8}, 123

// CHECK: vpermq zmm25, qword ptr [rdx - 1024]{1to8}, 123
// CHECK:  encoding: [0x62,0x63,0xfd,0x58,0x00,0x4a,0x80,0x7b]
          vpermq zmm25, qword ptr [rdx - 1024]{1to8}, 123

// CHECK: vpermq zmm25, qword ptr [rdx - 1032]{1to8}, 123
// CHECK:  encoding: [0x62,0x63,0xfd,0x58,0x00,0x8a,0xf8,0xfb,0xff,0xff,0x7b]
          vpermq zmm25, qword ptr [rdx - 1032]{1to8}, 123

// CHECK: vpexpandd zmm1, zmmword ptr [rcx]
// CHECK:  encoding: [0x62,0xf2,0x7d,0x48,0x89,0x09]
          vpexpandd zmm1, zmmword ptr [rcx]

// CHECK: vpexpandd zmm1 {k7}, zmmword ptr [rcx]
// CHECK:  encoding: [0x62,0xf2,0x7d,0x4f,0x89,0x09]
          vpexpandd zmm1 {k7}, zmmword ptr [rcx]

// CHECK: vpexpandd zmm1 {k7} {z}, zmmword ptr [rcx]
// CHECK:  encoding: [0x62,0xf2,0x7d,0xcf,0x89,0x09]
          vpexpandd zmm1 {k7} {z}, zmmword ptr [rcx]

// CHECK: vpexpandd zmm1, zmmword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0xb2,0x7d,0x48,0x89,0x8c,0xf0,0x23,0x01,0x00,0x00]
          vpexpandd zmm1, zmmword ptr [rax + 8*r14 + 291]

// CHECK: vpexpandd zmm1, zmmword ptr [rdx + 508]
// CHECK:  encoding: [0x62,0xf2,0x7d,0x48,0x89,0x4a,0x7f]
          vpexpandd zmm1, zmmword ptr [rdx + 508]

// CHECK: vpexpandd zmm1, zmmword ptr [rdx + 512]
// CHECK:  encoding: [0x62,0xf2,0x7d,0x48,0x89,0x8a,0x00,0x02,0x00,0x00]
          vpexpandd zmm1, zmmword ptr [rdx + 512]

// CHECK: vpexpandd zmm1, zmmword ptr [rdx - 512]
// CHECK:  encoding: [0x62,0xf2,0x7d,0x48,0x89,0x4a,0x80]
          vpexpandd zmm1, zmmword ptr [rdx - 512]

// CHECK: vpexpandd zmm1, zmmword ptr [rdx - 516]
// CHECK:  encoding: [0x62,0xf2,0x7d,0x48,0x89,0x8a,0xfc,0xfd,0xff,0xff]
          vpexpandd zmm1, zmmword ptr [rdx - 516]

// CHECK: vpexpandd zmm19, zmm25
// CHECK:  encoding: [0x62,0x82,0x7d,0x48,0x89,0xd9]
          vpexpandd zmm19, zmm25

// CHECK: vpexpandd zmm19 {k5}, zmm25
// CHECK:  encoding: [0x62,0x82,0x7d,0x4d,0x89,0xd9]
          vpexpandd zmm19 {k5}, zmm25

// CHECK: vpexpandd zmm19 {k5} {z}, zmm25
// CHECK:  encoding: [0x62,0x82,0x7d,0xcd,0x89,0xd9]
          vpexpandd zmm19 {k5} {z}, zmm25

// CHECK: vpexpandq zmm24, zmmword ptr [rcx]
// CHECK:  encoding: [0x62,0x62,0xfd,0x48,0x89,0x01]
          vpexpandq zmm24, zmmword ptr [rcx]

// CHECK: vpexpandq zmm24 {k7}, zmmword ptr [rcx]
// CHECK:  encoding: [0x62,0x62,0xfd,0x4f,0x89,0x01]
          vpexpandq zmm24 {k7}, zmmword ptr [rcx]

// CHECK: vpexpandq zmm24 {k7} {z}, zmmword ptr [rcx]
// CHECK:  encoding: [0x62,0x62,0xfd,0xcf,0x89,0x01]
          vpexpandq zmm24 {k7} {z}, zmmword ptr [rcx]

// CHECK: vpexpandq zmm24, zmmword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0x22,0xfd,0x48,0x89,0x84,0xf0,0x23,0x01,0x00,0x00]
          vpexpandq zmm24, zmmword ptr [rax + 8*r14 + 291]

// CHECK: vpexpandq zmm24, zmmword ptr [rdx + 1016]
// CHECK:  encoding: [0x62,0x62,0xfd,0x48,0x89,0x42,0x7f]
          vpexpandq zmm24, zmmword ptr [rdx + 1016]

// CHECK: vpexpandq zmm24, zmmword ptr [rdx + 1024]
// CHECK:  encoding: [0x62,0x62,0xfd,0x48,0x89,0x82,0x00,0x04,0x00,0x00]
          vpexpandq zmm24, zmmword ptr [rdx + 1024]

// CHECK: vpexpandq zmm24, zmmword ptr [rdx - 1024]
// CHECK:  encoding: [0x62,0x62,0xfd,0x48,0x89,0x42,0x80]
          vpexpandq zmm24, zmmword ptr [rdx - 1024]

// CHECK: vpexpandq zmm24, zmmword ptr [rdx - 1032]
// CHECK:  encoding: [0x62,0x62,0xfd,0x48,0x89,0x82,0xf8,0xfb,0xff,0xff]
          vpexpandq zmm24, zmmword ptr [rdx - 1032]

// CHECK: vpexpandq zmm15, zmm8
// CHECK:  encoding: [0x62,0x52,0xfd,0x48,0x89,0xf8]
          vpexpandq zmm15, zmm8

// CHECK: vpexpandq zmm15 {k7}, zmm8
// CHECK:  encoding: [0x62,0x52,0xfd,0x4f,0x89,0xf8]
          vpexpandq zmm15 {k7}, zmm8

// CHECK: vpexpandq zmm15 {k7} {z}, zmm8
// CHECK:  encoding: [0x62,0x52,0xfd,0xcf,0x89,0xf8]
          vpexpandq zmm15 {k7} {z}, zmm8

// CHECK: vpmaxsd zmm6, zmm8, zmm16
// CHECK:  encoding: [0x62,0xb2,0x3d,0x48,0x3d,0xf0]
          vpmaxsd zmm6, zmm8, zmm16

// CHECK: vpmaxsd zmm6 {k3}, zmm8, zmm16
// CHECK:  encoding: [0x62,0xb2,0x3d,0x4b,0x3d,0xf0]
          vpmaxsd zmm6 {k3}, zmm8, zmm16

// CHECK: vpmaxsd zmm6 {k3} {z}, zmm8, zmm16
// CHECK:  encoding: [0x62,0xb2,0x3d,0xcb,0x3d,0xf0]
          vpmaxsd zmm6 {k3} {z}, zmm8, zmm16

// CHECK: vpmaxsd zmm6, zmm8, zmmword ptr [rcx]
// CHECK:  encoding: [0x62,0xf2,0x3d,0x48,0x3d,0x31]
          vpmaxsd zmm6, zmm8, zmmword ptr [rcx]

// CHECK: vpmaxsd zmm6, zmm8, zmmword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0xb2,0x3d,0x48,0x3d,0xb4,0xf0,0x23,0x01,0x00,0x00]
          vpmaxsd zmm6, zmm8, zmmword ptr [rax + 8*r14 + 291]

// CHECK: vpmaxsd zmm6, zmm8, dword ptr [rcx]{1to16}
// CHECK:  encoding: [0x62,0xf2,0x3d,0x58,0x3d,0x31]
          vpmaxsd zmm6, zmm8, dword ptr [rcx]{1to16}

// CHECK: vpmaxsd zmm6, zmm8, zmmword ptr [rdx + 8128]
// CHECK:  encoding: [0x62,0xf2,0x3d,0x48,0x3d,0x72,0x7f]
          vpmaxsd zmm6, zmm8, zmmword ptr [rdx + 8128]

// CHECK: vpmaxsd zmm6, zmm8, zmmword ptr [rdx + 8192]
// CHECK:  encoding: [0x62,0xf2,0x3d,0x48,0x3d,0xb2,0x00,0x20,0x00,0x00]
          vpmaxsd zmm6, zmm8, zmmword ptr [rdx + 8192]

// CHECK: vpmaxsd zmm6, zmm8, zmmword ptr [rdx - 8192]
// CHECK:  encoding: [0x62,0xf2,0x3d,0x48,0x3d,0x72,0x80]
          vpmaxsd zmm6, zmm8, zmmword ptr [rdx - 8192]

// CHECK: vpmaxsd zmm6, zmm8, zmmword ptr [rdx - 8256]
// CHECK:  encoding: [0x62,0xf2,0x3d,0x48,0x3d,0xb2,0xc0,0xdf,0xff,0xff]
          vpmaxsd zmm6, zmm8, zmmword ptr [rdx - 8256]

// CHECK: vpmaxsd zmm6, zmm8, dword ptr [rdx + 508]{1to16}
// CHECK:  encoding: [0x62,0xf2,0x3d,0x58,0x3d,0x72,0x7f]
          vpmaxsd zmm6, zmm8, dword ptr [rdx + 508]{1to16}

// CHECK: vpmaxsd zmm6, zmm8, dword ptr [rdx + 512]{1to16}
// CHECK:  encoding: [0x62,0xf2,0x3d,0x58,0x3d,0xb2,0x00,0x02,0x00,0x00]
          vpmaxsd zmm6, zmm8, dword ptr [rdx + 512]{1to16}

// CHECK: vpmaxsd zmm6, zmm8, dword ptr [rdx - 512]{1to16}
// CHECK:  encoding: [0x62,0xf2,0x3d,0x58,0x3d,0x72,0x80]
          vpmaxsd zmm6, zmm8, dword ptr [rdx - 512]{1to16}

// CHECK: vpmaxsd zmm6, zmm8, dword ptr [rdx - 516]{1to16}
// CHECK:  encoding: [0x62,0xf2,0x3d,0x58,0x3d,0xb2,0xfc,0xfd,0xff,0xff]
          vpmaxsd zmm6, zmm8, dword ptr [rdx - 516]{1to16}

// CHECK: vpmaxsq zmm6, zmm6, zmm1
// CHECK:  encoding: [0x62,0xf2,0xcd,0x48,0x3d,0xf1]
          vpmaxsq zmm6, zmm6, zmm1

// CHECK: vpmaxsq zmm6 {k7}, zmm6, zmm1
// CHECK:  encoding: [0x62,0xf2,0xcd,0x4f,0x3d,0xf1]
          vpmaxsq zmm6 {k7}, zmm6, zmm1

// CHECK: vpmaxsq zmm6 {k7} {z}, zmm6, zmm1
// CHECK:  encoding: [0x62,0xf2,0xcd,0xcf,0x3d,0xf1]
          vpmaxsq zmm6 {k7} {z}, zmm6, zmm1

// CHECK: vpmaxsq zmm6, zmm6, zmmword ptr [rcx]
// CHECK:  encoding: [0x62,0xf2,0xcd,0x48,0x3d,0x31]
          vpmaxsq zmm6, zmm6, zmmword ptr [rcx]

// CHECK: vpmaxsq zmm6, zmm6, zmmword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0xb2,0xcd,0x48,0x3d,0xb4,0xf0,0x23,0x01,0x00,0x00]
          vpmaxsq zmm6, zmm6, zmmword ptr [rax + 8*r14 + 291]

// CHECK: vpmaxsq zmm6, zmm6, qword ptr [rcx]{1to8}
// CHECK:  encoding: [0x62,0xf2,0xcd,0x58,0x3d,0x31]
          vpmaxsq zmm6, zmm6, qword ptr [rcx]{1to8}

// CHECK: vpmaxsq zmm6, zmm6, zmmword ptr [rdx + 8128]
// CHECK:  encoding: [0x62,0xf2,0xcd,0x48,0x3d,0x72,0x7f]
          vpmaxsq zmm6, zmm6, zmmword ptr [rdx + 8128]

// CHECK: vpmaxsq zmm6, zmm6, zmmword ptr [rdx + 8192]
// CHECK:  encoding: [0x62,0xf2,0xcd,0x48,0x3d,0xb2,0x00,0x20,0x00,0x00]
          vpmaxsq zmm6, zmm6, zmmword ptr [rdx + 8192]

// CHECK: vpmaxsq zmm6, zmm6, zmmword ptr [rdx - 8192]
// CHECK:  encoding: [0x62,0xf2,0xcd,0x48,0x3d,0x72,0x80]
          vpmaxsq zmm6, zmm6, zmmword ptr [rdx - 8192]

// CHECK: vpmaxsq zmm6, zmm6, zmmword ptr [rdx - 8256]
// CHECK:  encoding: [0x62,0xf2,0xcd,0x48,0x3d,0xb2,0xc0,0xdf,0xff,0xff]
          vpmaxsq zmm6, zmm6, zmmword ptr [rdx - 8256]

// CHECK: vpmaxsq zmm6, zmm6, qword ptr [rdx + 1016]{1to8}
// CHECK:  encoding: [0x62,0xf2,0xcd,0x58,0x3d,0x72,0x7f]
          vpmaxsq zmm6, zmm6, qword ptr [rdx + 1016]{1to8}

// CHECK: vpmaxsq zmm6, zmm6, qword ptr [rdx + 1024]{1to8}
// CHECK:  encoding: [0x62,0xf2,0xcd,0x58,0x3d,0xb2,0x00,0x04,0x00,0x00]
          vpmaxsq zmm6, zmm6, qword ptr [rdx + 1024]{1to8}

// CHECK: vpmaxsq zmm6, zmm6, qword ptr [rdx - 1024]{1to8}
// CHECK:  encoding: [0x62,0xf2,0xcd,0x58,0x3d,0x72,0x80]
          vpmaxsq zmm6, zmm6, qword ptr [rdx - 1024]{1to8}

// CHECK: vpmaxsq zmm6, zmm6, qword ptr [rdx - 1032]{1to8}
// CHECK:  encoding: [0x62,0xf2,0xcd,0x58,0x3d,0xb2,0xf8,0xfb,0xff,0xff]
          vpmaxsq zmm6, zmm6, qword ptr [rdx - 1032]{1to8}

// CHECK: vpmaxud zmm17, zmm7, zmm25
// CHECK:  encoding: [0x62,0x82,0x45,0x48,0x3f,0xc9]
          vpmaxud zmm17, zmm7, zmm25

// CHECK: vpmaxud zmm17 {k5}, zmm7, zmm25
// CHECK:  encoding: [0x62,0x82,0x45,0x4d,0x3f,0xc9]
          vpmaxud zmm17 {k5}, zmm7, zmm25

// CHECK: vpmaxud zmm17 {k5} {z}, zmm7, zmm25
// CHECK:  encoding: [0x62,0x82,0x45,0xcd,0x3f,0xc9]
          vpmaxud zmm17 {k5} {z}, zmm7, zmm25

// CHECK: vpmaxud zmm17, zmm7, zmmword ptr [rcx]
// CHECK:  encoding: [0x62,0xe2,0x45,0x48,0x3f,0x09]
          vpmaxud zmm17, zmm7, zmmword ptr [rcx]

// CHECK: vpmaxud zmm17, zmm7, zmmword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0xa2,0x45,0x48,0x3f,0x8c,0xf0,0x23,0x01,0x00,0x00]
          vpmaxud zmm17, zmm7, zmmword ptr [rax + 8*r14 + 291]

// CHECK: vpmaxud zmm17, zmm7, dword ptr [rcx]{1to16}
// CHECK:  encoding: [0x62,0xe2,0x45,0x58,0x3f,0x09]
          vpmaxud zmm17, zmm7, dword ptr [rcx]{1to16}

// CHECK: vpmaxud zmm17, zmm7, zmmword ptr [rdx + 8128]
// CHECK:  encoding: [0x62,0xe2,0x45,0x48,0x3f,0x4a,0x7f]
          vpmaxud zmm17, zmm7, zmmword ptr [rdx + 8128]

// CHECK: vpmaxud zmm17, zmm7, zmmword ptr [rdx + 8192]
// CHECK:  encoding: [0x62,0xe2,0x45,0x48,0x3f,0x8a,0x00,0x20,0x00,0x00]
          vpmaxud zmm17, zmm7, zmmword ptr [rdx + 8192]

// CHECK: vpmaxud zmm17, zmm7, zmmword ptr [rdx - 8192]
// CHECK:  encoding: [0x62,0xe2,0x45,0x48,0x3f,0x4a,0x80]
          vpmaxud zmm17, zmm7, zmmword ptr [rdx - 8192]

// CHECK: vpmaxud zmm17, zmm7, zmmword ptr [rdx - 8256]
// CHECK:  encoding: [0x62,0xe2,0x45,0x48,0x3f,0x8a,0xc0,0xdf,0xff,0xff]
          vpmaxud zmm17, zmm7, zmmword ptr [rdx - 8256]

// CHECK: vpmaxud zmm17, zmm7, dword ptr [rdx + 508]{1to16}
// CHECK:  encoding: [0x62,0xe2,0x45,0x58,0x3f,0x4a,0x7f]
          vpmaxud zmm17, zmm7, dword ptr [rdx + 508]{1to16}

// CHECK: vpmaxud zmm17, zmm7, dword ptr [rdx + 512]{1to16}
// CHECK:  encoding: [0x62,0xe2,0x45,0x58,0x3f,0x8a,0x00,0x02,0x00,0x00]
          vpmaxud zmm17, zmm7, dword ptr [rdx + 512]{1to16}

// CHECK: vpmaxud zmm17, zmm7, dword ptr [rdx - 512]{1to16}
// CHECK:  encoding: [0x62,0xe2,0x45,0x58,0x3f,0x4a,0x80]
          vpmaxud zmm17, zmm7, dword ptr [rdx - 512]{1to16}

// CHECK: vpmaxud zmm17, zmm7, dword ptr [rdx - 516]{1to16}
// CHECK:  encoding: [0x62,0xe2,0x45,0x58,0x3f,0x8a,0xfc,0xfd,0xff,0xff]
          vpmaxud zmm17, zmm7, dword ptr [rdx - 516]{1to16}

// CHECK: vpmaxuq zmm30, zmm22, zmm25
// CHECK:  encoding: [0x62,0x02,0xcd,0x40,0x3f,0xf1]
          vpmaxuq zmm30, zmm22, zmm25

// CHECK: vpmaxuq zmm30 {k1}, zmm22, zmm25
// CHECK:  encoding: [0x62,0x02,0xcd,0x41,0x3f,0xf1]
          vpmaxuq zmm30 {k1}, zmm22, zmm25

// CHECK: vpmaxuq zmm30 {k1} {z}, zmm22, zmm25
// CHECK:  encoding: [0x62,0x02,0xcd,0xc1,0x3f,0xf1]
          vpmaxuq zmm30 {k1} {z}, zmm22, zmm25

// CHECK: vpmaxuq zmm30, zmm22, zmmword ptr [rcx]
// CHECK:  encoding: [0x62,0x62,0xcd,0x40,0x3f,0x31]
          vpmaxuq zmm30, zmm22, zmmword ptr [rcx]

// CHECK: vpmaxuq zmm30, zmm22, zmmword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0x22,0xcd,0x40,0x3f,0xb4,0xf0,0x23,0x01,0x00,0x00]
          vpmaxuq zmm30, zmm22, zmmword ptr [rax + 8*r14 + 291]

// CHECK: vpmaxuq zmm30, zmm22, qword ptr [rcx]{1to8}
// CHECK:  encoding: [0x62,0x62,0xcd,0x50,0x3f,0x31]
          vpmaxuq zmm30, zmm22, qword ptr [rcx]{1to8}

// CHECK: vpmaxuq zmm30, zmm22, zmmword ptr [rdx + 8128]
// CHECK:  encoding: [0x62,0x62,0xcd,0x40,0x3f,0x72,0x7f]
          vpmaxuq zmm30, zmm22, zmmword ptr [rdx + 8128]

// CHECK: vpmaxuq zmm30, zmm22, zmmword ptr [rdx + 8192]
// CHECK:  encoding: [0x62,0x62,0xcd,0x40,0x3f,0xb2,0x00,0x20,0x00,0x00]
          vpmaxuq zmm30, zmm22, zmmword ptr [rdx + 8192]

// CHECK: vpmaxuq zmm30, zmm22, zmmword ptr [rdx - 8192]
// CHECK:  encoding: [0x62,0x62,0xcd,0x40,0x3f,0x72,0x80]
          vpmaxuq zmm30, zmm22, zmmword ptr [rdx - 8192]

// CHECK: vpmaxuq zmm30, zmm22, zmmword ptr [rdx - 8256]
// CHECK:  encoding: [0x62,0x62,0xcd,0x40,0x3f,0xb2,0xc0,0xdf,0xff,0xff]
          vpmaxuq zmm30, zmm22, zmmword ptr [rdx - 8256]

// CHECK: vpmaxuq zmm30, zmm22, qword ptr [rdx + 1016]{1to8}
// CHECK:  encoding: [0x62,0x62,0xcd,0x50,0x3f,0x72,0x7f]
          vpmaxuq zmm30, zmm22, qword ptr [rdx + 1016]{1to8}

// CHECK: vpmaxuq zmm30, zmm22, qword ptr [rdx + 1024]{1to8}
// CHECK:  encoding: [0x62,0x62,0xcd,0x50,0x3f,0xb2,0x00,0x04,0x00,0x00]
          vpmaxuq zmm30, zmm22, qword ptr [rdx + 1024]{1to8}

// CHECK: vpmaxuq zmm30, zmm22, qword ptr [rdx - 1024]{1to8}
// CHECK:  encoding: [0x62,0x62,0xcd,0x50,0x3f,0x72,0x80]
          vpmaxuq zmm30, zmm22, qword ptr [rdx - 1024]{1to8}

// CHECK: vpmaxuq zmm30, zmm22, qword ptr [rdx - 1032]{1to8}
// CHECK:  encoding: [0x62,0x62,0xcd,0x50,0x3f,0xb2,0xf8,0xfb,0xff,0xff]
          vpmaxuq zmm30, zmm22, qword ptr [rdx - 1032]{1to8}

// CHECK: vpminsd zmm2, zmm16, zmm24
// CHECK:  encoding: [0x62,0x92,0x7d,0x40,0x39,0xd0]
          vpminsd zmm2, zmm16, zmm24

// CHECK: vpminsd zmm2 {k3}, zmm16, zmm24
// CHECK:  encoding: [0x62,0x92,0x7d,0x43,0x39,0xd0]
          vpminsd zmm2 {k3}, zmm16, zmm24

// CHECK: vpminsd zmm2 {k3} {z}, zmm16, zmm24
// CHECK:  encoding: [0x62,0x92,0x7d,0xc3,0x39,0xd0]
          vpminsd zmm2 {k3} {z}, zmm16, zmm24

// CHECK: vpminsd zmm2, zmm16, zmmword ptr [rcx]
// CHECK:  encoding: [0x62,0xf2,0x7d,0x40,0x39,0x11]
          vpminsd zmm2, zmm16, zmmword ptr [rcx]

// CHECK: vpminsd zmm2, zmm16, zmmword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0xb2,0x7d,0x40,0x39,0x94,0xf0,0x23,0x01,0x00,0x00]
          vpminsd zmm2, zmm16, zmmword ptr [rax + 8*r14 + 291]

// CHECK: vpminsd zmm2, zmm16, dword ptr [rcx]{1to16}
// CHECK:  encoding: [0x62,0xf2,0x7d,0x50,0x39,0x11]
          vpminsd zmm2, zmm16, dword ptr [rcx]{1to16}

// CHECK: vpminsd zmm2, zmm16, zmmword ptr [rdx + 8128]
// CHECK:  encoding: [0x62,0xf2,0x7d,0x40,0x39,0x52,0x7f]
          vpminsd zmm2, zmm16, zmmword ptr [rdx + 8128]

// CHECK: vpminsd zmm2, zmm16, zmmword ptr [rdx + 8192]
// CHECK:  encoding: [0x62,0xf2,0x7d,0x40,0x39,0x92,0x00,0x20,0x00,0x00]
          vpminsd zmm2, zmm16, zmmword ptr [rdx + 8192]

// CHECK: vpminsd zmm2, zmm16, zmmword ptr [rdx - 8192]
// CHECK:  encoding: [0x62,0xf2,0x7d,0x40,0x39,0x52,0x80]
          vpminsd zmm2, zmm16, zmmword ptr [rdx - 8192]

// CHECK: vpminsd zmm2, zmm16, zmmword ptr [rdx - 8256]
// CHECK:  encoding: [0x62,0xf2,0x7d,0x40,0x39,0x92,0xc0,0xdf,0xff,0xff]
          vpminsd zmm2, zmm16, zmmword ptr [rdx - 8256]

// CHECK: vpminsd zmm2, zmm16, dword ptr [rdx + 508]{1to16}
// CHECK:  encoding: [0x62,0xf2,0x7d,0x50,0x39,0x52,0x7f]
          vpminsd zmm2, zmm16, dword ptr [rdx + 508]{1to16}

// CHECK: vpminsd zmm2, zmm16, dword ptr [rdx + 512]{1to16}
// CHECK:  encoding: [0x62,0xf2,0x7d,0x50,0x39,0x92,0x00,0x02,0x00,0x00]
          vpminsd zmm2, zmm16, dword ptr [rdx + 512]{1to16}

// CHECK: vpminsd zmm2, zmm16, dword ptr [rdx - 512]{1to16}
// CHECK:  encoding: [0x62,0xf2,0x7d,0x50,0x39,0x52,0x80]
          vpminsd zmm2, zmm16, dword ptr [rdx - 512]{1to16}

// CHECK: vpminsd zmm2, zmm16, dword ptr [rdx - 516]{1to16}
// CHECK:  encoding: [0x62,0xf2,0x7d,0x50,0x39,0x92,0xfc,0xfd,0xff,0xff]
          vpminsd zmm2, zmm16, dword ptr [rdx - 516]{1to16}

// CHECK: vpminsq zmm20, zmm16, zmm17
// CHECK:  encoding: [0x62,0xa2,0xfd,0x40,0x39,0xe1]
          vpminsq zmm20, zmm16, zmm17

// CHECK: vpminsq zmm20 {k6}, zmm16, zmm17
// CHECK:  encoding: [0x62,0xa2,0xfd,0x46,0x39,0xe1]
          vpminsq zmm20 {k6}, zmm16, zmm17

// CHECK: vpminsq zmm20 {k6} {z}, zmm16, zmm17
// CHECK:  encoding: [0x62,0xa2,0xfd,0xc6,0x39,0xe1]
          vpminsq zmm20 {k6} {z}, zmm16, zmm17

// CHECK: vpminsq zmm20, zmm16, zmmword ptr [rcx]
// CHECK:  encoding: [0x62,0xe2,0xfd,0x40,0x39,0x21]
          vpminsq zmm20, zmm16, zmmword ptr [rcx]

// CHECK: vpminsq zmm20, zmm16, zmmword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0xa2,0xfd,0x40,0x39,0xa4,0xf0,0x23,0x01,0x00,0x00]
          vpminsq zmm20, zmm16, zmmword ptr [rax + 8*r14 + 291]

// CHECK: vpminsq zmm20, zmm16, qword ptr [rcx]{1to8}
// CHECK:  encoding: [0x62,0xe2,0xfd,0x50,0x39,0x21]
          vpminsq zmm20, zmm16, qword ptr [rcx]{1to8}

// CHECK: vpminsq zmm20, zmm16, zmmword ptr [rdx + 8128]
// CHECK:  encoding: [0x62,0xe2,0xfd,0x40,0x39,0x62,0x7f]
          vpminsq zmm20, zmm16, zmmword ptr [rdx + 8128]

// CHECK: vpminsq zmm20, zmm16, zmmword ptr [rdx + 8192]
// CHECK:  encoding: [0x62,0xe2,0xfd,0x40,0x39,0xa2,0x00,0x20,0x00,0x00]
          vpminsq zmm20, zmm16, zmmword ptr [rdx + 8192]

// CHECK: vpminsq zmm20, zmm16, zmmword ptr [rdx - 8192]
// CHECK:  encoding: [0x62,0xe2,0xfd,0x40,0x39,0x62,0x80]
          vpminsq zmm20, zmm16, zmmword ptr [rdx - 8192]

// CHECK: vpminsq zmm20, zmm16, zmmword ptr [rdx - 8256]
// CHECK:  encoding: [0x62,0xe2,0xfd,0x40,0x39,0xa2,0xc0,0xdf,0xff,0xff]
          vpminsq zmm20, zmm16, zmmword ptr [rdx - 8256]

// CHECK: vpminsq zmm20, zmm16, qword ptr [rdx + 1016]{1to8}
// CHECK:  encoding: [0x62,0xe2,0xfd,0x50,0x39,0x62,0x7f]
          vpminsq zmm20, zmm16, qword ptr [rdx + 1016]{1to8}

// CHECK: vpminsq zmm20, zmm16, qword ptr [rdx + 1024]{1to8}
// CHECK:  encoding: [0x62,0xe2,0xfd,0x50,0x39,0xa2,0x00,0x04,0x00,0x00]
          vpminsq zmm20, zmm16, qword ptr [rdx + 1024]{1to8}

// CHECK: vpminsq zmm20, zmm16, qword ptr [rdx - 1024]{1to8}
// CHECK:  encoding: [0x62,0xe2,0xfd,0x50,0x39,0x62,0x80]
          vpminsq zmm20, zmm16, qword ptr [rdx - 1024]{1to8}

// CHECK: vpminsq zmm20, zmm16, qword ptr [rdx - 1032]{1to8}
// CHECK:  encoding: [0x62,0xe2,0xfd,0x50,0x39,0xa2,0xf8,0xfb,0xff,0xff]
          vpminsq zmm20, zmm16, qword ptr [rdx - 1032]{1to8}

// CHECK: vpminud zmm3, zmm23, zmm20
// CHECK:  encoding: [0x62,0xb2,0x45,0x40,0x3b,0xdc]
          vpminud zmm3, zmm23, zmm20

// CHECK: vpminud zmm3 {k3}, zmm23, zmm20
// CHECK:  encoding: [0x62,0xb2,0x45,0x43,0x3b,0xdc]
          vpminud zmm3 {k3}, zmm23, zmm20

// CHECK: vpminud zmm3 {k3} {z}, zmm23, zmm20
// CHECK:  encoding: [0x62,0xb2,0x45,0xc3,0x3b,0xdc]
          vpminud zmm3 {k3} {z}, zmm23, zmm20

// CHECK: vpminud zmm3, zmm23, zmmword ptr [rcx]
// CHECK:  encoding: [0x62,0xf2,0x45,0x40,0x3b,0x19]
          vpminud zmm3, zmm23, zmmword ptr [rcx]

// CHECK: vpminud zmm3, zmm23, zmmword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0xb2,0x45,0x40,0x3b,0x9c,0xf0,0x23,0x01,0x00,0x00]
          vpminud zmm3, zmm23, zmmword ptr [rax + 8*r14 + 291]

// CHECK: vpminud zmm3, zmm23, dword ptr [rcx]{1to16}
// CHECK:  encoding: [0x62,0xf2,0x45,0x50,0x3b,0x19]
          vpminud zmm3, zmm23, dword ptr [rcx]{1to16}

// CHECK: vpminud zmm3, zmm23, zmmword ptr [rdx + 8128]
// CHECK:  encoding: [0x62,0xf2,0x45,0x40,0x3b,0x5a,0x7f]
          vpminud zmm3, zmm23, zmmword ptr [rdx + 8128]

// CHECK: vpminud zmm3, zmm23, zmmword ptr [rdx + 8192]
// CHECK:  encoding: [0x62,0xf2,0x45,0x40,0x3b,0x9a,0x00,0x20,0x00,0x00]
          vpminud zmm3, zmm23, zmmword ptr [rdx + 8192]

// CHECK: vpminud zmm3, zmm23, zmmword ptr [rdx - 8192]
// CHECK:  encoding: [0x62,0xf2,0x45,0x40,0x3b,0x5a,0x80]
          vpminud zmm3, zmm23, zmmword ptr [rdx - 8192]

// CHECK: vpminud zmm3, zmm23, zmmword ptr [rdx - 8256]
// CHECK:  encoding: [0x62,0xf2,0x45,0x40,0x3b,0x9a,0xc0,0xdf,0xff,0xff]
          vpminud zmm3, zmm23, zmmword ptr [rdx - 8256]

// CHECK: vpminud zmm3, zmm23, dword ptr [rdx + 508]{1to16}
// CHECK:  encoding: [0x62,0xf2,0x45,0x50,0x3b,0x5a,0x7f]
          vpminud zmm3, zmm23, dword ptr [rdx + 508]{1to16}

// CHECK: vpminud zmm3, zmm23, dword ptr [rdx + 512]{1to16}
// CHECK:  encoding: [0x62,0xf2,0x45,0x50,0x3b,0x9a,0x00,0x02,0x00,0x00]
          vpminud zmm3, zmm23, dword ptr [rdx + 512]{1to16}

// CHECK: vpminud zmm3, zmm23, dword ptr [rdx - 512]{1to16}
// CHECK:  encoding: [0x62,0xf2,0x45,0x50,0x3b,0x5a,0x80]
          vpminud zmm3, zmm23, dword ptr [rdx - 512]{1to16}

// CHECK: vpminud zmm3, zmm23, dword ptr [rdx - 516]{1to16}
// CHECK:  encoding: [0x62,0xf2,0x45,0x50,0x3b,0x9a,0xfc,0xfd,0xff,0xff]
          vpminud zmm3, zmm23, dword ptr [rdx - 516]{1to16}

// CHECK: vpminuq zmm11, zmm26, zmm7
// CHECK:  encoding: [0x62,0x72,0xad,0x40,0x3b,0xdf]
          vpminuq zmm11, zmm26, zmm7

// CHECK: vpminuq zmm11 {k5}, zmm26, zmm7
// CHECK:  encoding: [0x62,0x72,0xad,0x45,0x3b,0xdf]
          vpminuq zmm11 {k5}, zmm26, zmm7

// CHECK: vpminuq zmm11 {k5} {z}, zmm26, zmm7
// CHECK:  encoding: [0x62,0x72,0xad,0xc5,0x3b,0xdf]
          vpminuq zmm11 {k5} {z}, zmm26, zmm7

// CHECK: vpminuq zmm11, zmm26, zmmword ptr [rcx]
// CHECK:  encoding: [0x62,0x72,0xad,0x40,0x3b,0x19]
          vpminuq zmm11, zmm26, zmmword ptr [rcx]

// CHECK: vpminuq zmm11, zmm26, zmmword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0x32,0xad,0x40,0x3b,0x9c,0xf0,0x23,0x01,0x00,0x00]
          vpminuq zmm11, zmm26, zmmword ptr [rax + 8*r14 + 291]

// CHECK: vpminuq zmm11, zmm26, qword ptr [rcx]{1to8}
// CHECK:  encoding: [0x62,0x72,0xad,0x50,0x3b,0x19]
          vpminuq zmm11, zmm26, qword ptr [rcx]{1to8}

// CHECK: vpminuq zmm11, zmm26, zmmword ptr [rdx + 8128]
// CHECK:  encoding: [0x62,0x72,0xad,0x40,0x3b,0x5a,0x7f]
          vpminuq zmm11, zmm26, zmmword ptr [rdx + 8128]

// CHECK: vpminuq zmm11, zmm26, zmmword ptr [rdx + 8192]
// CHECK:  encoding: [0x62,0x72,0xad,0x40,0x3b,0x9a,0x00,0x20,0x00,0x00]
          vpminuq zmm11, zmm26, zmmword ptr [rdx + 8192]

// CHECK: vpminuq zmm11, zmm26, zmmword ptr [rdx - 8192]
// CHECK:  encoding: [0x62,0x72,0xad,0x40,0x3b,0x5a,0x80]
          vpminuq zmm11, zmm26, zmmword ptr [rdx - 8192]

// CHECK: vpminuq zmm11, zmm26, zmmword ptr [rdx - 8256]
// CHECK:  encoding: [0x62,0x72,0xad,0x40,0x3b,0x9a,0xc0,0xdf,0xff,0xff]
          vpminuq zmm11, zmm26, zmmword ptr [rdx - 8256]

// CHECK: vpminuq zmm11, zmm26, qword ptr [rdx + 1016]{1to8}
// CHECK:  encoding: [0x62,0x72,0xad,0x50,0x3b,0x5a,0x7f]
          vpminuq zmm11, zmm26, qword ptr [rdx + 1016]{1to8}

// CHECK: vpminuq zmm11, zmm26, qword ptr [rdx + 1024]{1to8}
// CHECK:  encoding: [0x62,0x72,0xad,0x50,0x3b,0x9a,0x00,0x04,0x00,0x00]
          vpminuq zmm11, zmm26, qword ptr [rdx + 1024]{1to8}

// CHECK: vpminuq zmm11, zmm26, qword ptr [rdx - 1024]{1to8}
// CHECK:  encoding: [0x62,0x72,0xad,0x50,0x3b,0x5a,0x80]
          vpminuq zmm11, zmm26, qword ptr [rdx - 1024]{1to8}

// CHECK: vpminuq zmm11, zmm26, qword ptr [rdx - 1032]{1to8}
// CHECK:  encoding: [0x62,0x72,0xad,0x50,0x3b,0x9a,0xf8,0xfb,0xff,0xff]
          vpminuq zmm11, zmm26, qword ptr [rdx - 1032]{1to8}

// CHECK: vpmovsxbd zmm27, xmm7
// CHECK:  encoding: [0x62,0x62,0x7d,0x48,0x21,0xdf]
          vpmovsxbd zmm27, xmm7

// CHECK: vpmovsxbd zmm27 {k5}, xmm7
// CHECK:  encoding: [0x62,0x62,0x7d,0x4d,0x21,0xdf]
          vpmovsxbd zmm27 {k5}, xmm7

// CHECK: vpmovsxbd zmm27 {k5} {z}, xmm7
// CHECK:  encoding: [0x62,0x62,0x7d,0xcd,0x21,0xdf]
          vpmovsxbd zmm27 {k5} {z}, xmm7

// CHECK: vpmovsxbd zmm27, xmmword ptr [rcx]
// CHECK:  encoding: [0x62,0x62,0x7d,0x48,0x21,0x19]
          vpmovsxbd zmm27, xmmword ptr [rcx]

// CHECK: vpmovsxbd zmm27, xmmword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0x22,0x7d,0x48,0x21,0x9c,0xf0,0x23,0x01,0x00,0x00]
          vpmovsxbd zmm27, xmmword ptr [rax + 8*r14 + 291]

// CHECK: vpmovsxbd zmm27, xmmword ptr [rdx + 2032]
// CHECK:  encoding: [0x62,0x62,0x7d,0x48,0x21,0x5a,0x7f]
          vpmovsxbd zmm27, xmmword ptr [rdx + 2032]

// CHECK: vpmovsxbd zmm27, xmmword ptr [rdx + 2048]
// CHECK:  encoding: [0x62,0x62,0x7d,0x48,0x21,0x9a,0x00,0x08,0x00,0x00]
          vpmovsxbd zmm27, xmmword ptr [rdx + 2048]

// CHECK: vpmovsxbd zmm27, xmmword ptr [rdx - 2048]
// CHECK:  encoding: [0x62,0x62,0x7d,0x48,0x21,0x5a,0x80]
          vpmovsxbd zmm27, xmmword ptr [rdx - 2048]

// CHECK: vpmovsxbd zmm27, xmmword ptr [rdx - 2064]
// CHECK:  encoding: [0x62,0x62,0x7d,0x48,0x21,0x9a,0xf0,0xf7,0xff,0xff]
          vpmovsxbd zmm27, xmmword ptr [rdx - 2064]

// CHECK: vpmovsxbq zmm11, xmm11
// CHECK:  encoding: [0x62,0x52,0x7d,0x48,0x22,0xdb]
          vpmovsxbq zmm11, xmm11

// CHECK: vpmovsxbq zmm11 {k5}, xmm11
// CHECK:  encoding: [0x62,0x52,0x7d,0x4d,0x22,0xdb]
          vpmovsxbq zmm11 {k5}, xmm11

// CHECK: vpmovsxbq zmm11 {k5} {z}, xmm11
// CHECK:  encoding: [0x62,0x52,0x7d,0xcd,0x22,0xdb]
          vpmovsxbq zmm11 {k5} {z}, xmm11

// CHECK: vpmovsxbq zmm11, qword ptr [rcx]
// CHECK:  encoding: [0x62,0x72,0x7d,0x48,0x22,0x19]
          vpmovsxbq zmm11, qword ptr [rcx]

// CHECK: vpmovsxbq zmm11, qword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0x32,0x7d,0x48,0x22,0x9c,0xf0,0x23,0x01,0x00,0x00]
          vpmovsxbq zmm11, qword ptr [rax + 8*r14 + 291]

// CHECK: vpmovsxbq zmm11, qword ptr [rdx + 1016]
// CHECK:  encoding: [0x62,0x72,0x7d,0x48,0x22,0x5a,0x7f]
          vpmovsxbq zmm11, qword ptr [rdx + 1016]

// CHECK: vpmovsxbq zmm11, qword ptr [rdx + 1024]
// CHECK:  encoding: [0x62,0x72,0x7d,0x48,0x22,0x9a,0x00,0x04,0x00,0x00]
          vpmovsxbq zmm11, qword ptr [rdx + 1024]

// CHECK: vpmovsxbq zmm11, qword ptr [rdx - 1024]
// CHECK:  encoding: [0x62,0x72,0x7d,0x48,0x22,0x5a,0x80]
          vpmovsxbq zmm11, qword ptr [rdx - 1024]

// CHECK: vpmovsxbq zmm11, qword ptr [rdx - 1032]
// CHECK:  encoding: [0x62,0x72,0x7d,0x48,0x22,0x9a,0xf8,0xfb,0xff,0xff]
          vpmovsxbq zmm11, qword ptr [rdx - 1032]

// CHECK: vpmovsxdq zmm26, ymm29
// CHECK:  encoding: [0x62,0x02,0x7d,0x48,0x25,0xd5]
          vpmovsxdq zmm26, ymm29

// CHECK: vpmovsxdq zmm26 {k1}, ymm29
// CHECK:  encoding: [0x62,0x02,0x7d,0x49,0x25,0xd5]
          vpmovsxdq zmm26 {k1}, ymm29

// CHECK: vpmovsxdq zmm26 {k1} {z}, ymm29
// CHECK:  encoding: [0x62,0x02,0x7d,0xc9,0x25,0xd5]
          vpmovsxdq zmm26 {k1} {z}, ymm29

// CHECK: vpmovsxdq zmm26, ymmword ptr [rcx]
// CHECK:  encoding: [0x62,0x62,0x7d,0x48,0x25,0x11]
          vpmovsxdq zmm26, ymmword ptr [rcx]

// CHECK: vpmovsxdq zmm26, ymmword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0x22,0x7d,0x48,0x25,0x94,0xf0,0x23,0x01,0x00,0x00]
          vpmovsxdq zmm26, ymmword ptr [rax + 8*r14 + 291]

// CHECK: vpmovsxdq zmm26, ymmword ptr [rdx + 4064]
// CHECK:  encoding: [0x62,0x62,0x7d,0x48,0x25,0x52,0x7f]
          vpmovsxdq zmm26, ymmword ptr [rdx + 4064]

// CHECK: vpmovsxdq zmm26, ymmword ptr [rdx + 4096]
// CHECK:  encoding: [0x62,0x62,0x7d,0x48,0x25,0x92,0x00,0x10,0x00,0x00]
          vpmovsxdq zmm26, ymmword ptr [rdx + 4096]

// CHECK: vpmovsxdq zmm26, ymmword ptr [rdx - 4096]
// CHECK:  encoding: [0x62,0x62,0x7d,0x48,0x25,0x52,0x80]
          vpmovsxdq zmm26, ymmword ptr [rdx - 4096]

// CHECK: vpmovsxdq zmm26, ymmword ptr [rdx - 4128]
// CHECK:  encoding: [0x62,0x62,0x7d,0x48,0x25,0x92,0xe0,0xef,0xff,0xff]
          vpmovsxdq zmm26, ymmword ptr [rdx - 4128]

// CHECK: vpmovsxwd zmm23, ymm11
// CHECK:  encoding: [0x62,0xc2,0x7d,0x48,0x23,0xfb]
          vpmovsxwd zmm23, ymm11

// CHECK: vpmovsxwd zmm23 {k2}, ymm11
// CHECK:  encoding: [0x62,0xc2,0x7d,0x4a,0x23,0xfb]
          vpmovsxwd zmm23 {k2}, ymm11

// CHECK: vpmovsxwd zmm23 {k2} {z}, ymm11
// CHECK:  encoding: [0x62,0xc2,0x7d,0xca,0x23,0xfb]
          vpmovsxwd zmm23 {k2} {z}, ymm11

// CHECK: vpmovsxwd zmm23, ymmword ptr [rcx]
// CHECK:  encoding: [0x62,0xe2,0x7d,0x48,0x23,0x39]
          vpmovsxwd zmm23, ymmword ptr [rcx]

// CHECK: vpmovsxwd zmm23, ymmword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0xa2,0x7d,0x48,0x23,0xbc,0xf0,0x23,0x01,0x00,0x00]
          vpmovsxwd zmm23, ymmword ptr [rax + 8*r14 + 291]

// CHECK: vpmovsxwd zmm23, ymmword ptr [rdx + 4064]
// CHECK:  encoding: [0x62,0xe2,0x7d,0x48,0x23,0x7a,0x7f]
          vpmovsxwd zmm23, ymmword ptr [rdx + 4064]

// CHECK: vpmovsxwd zmm23, ymmword ptr [rdx + 4096]
// CHECK:  encoding: [0x62,0xe2,0x7d,0x48,0x23,0xba,0x00,0x10,0x00,0x00]
          vpmovsxwd zmm23, ymmword ptr [rdx + 4096]

// CHECK: vpmovsxwd zmm23, ymmword ptr [rdx - 4096]
// CHECK:  encoding: [0x62,0xe2,0x7d,0x48,0x23,0x7a,0x80]
          vpmovsxwd zmm23, ymmword ptr [rdx - 4096]

// CHECK: vpmovsxwd zmm23, ymmword ptr [rdx - 4128]
// CHECK:  encoding: [0x62,0xe2,0x7d,0x48,0x23,0xba,0xe0,0xef,0xff,0xff]
          vpmovsxwd zmm23, ymmword ptr [rdx - 4128]

// CHECK: vpmovsxwq zmm25, xmm25
// CHECK:  encoding: [0x62,0x02,0x7d,0x48,0x24,0xc9]
          vpmovsxwq zmm25, xmm25

// CHECK: vpmovsxwq zmm25 {k4}, xmm25
// CHECK:  encoding: [0x62,0x02,0x7d,0x4c,0x24,0xc9]
          vpmovsxwq zmm25 {k4}, xmm25

// CHECK: vpmovsxwq zmm25 {k4} {z}, xmm25
// CHECK:  encoding: [0x62,0x02,0x7d,0xcc,0x24,0xc9]
          vpmovsxwq zmm25 {k4} {z}, xmm25

// CHECK: vpmovsxwq zmm25, xmmword ptr [rcx]
// CHECK:  encoding: [0x62,0x62,0x7d,0x48,0x24,0x09]
          vpmovsxwq zmm25, xmmword ptr [rcx]

// CHECK: vpmovsxwq zmm25, xmmword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0x22,0x7d,0x48,0x24,0x8c,0xf0,0x23,0x01,0x00,0x00]
          vpmovsxwq zmm25, xmmword ptr [rax + 8*r14 + 291]

// CHECK: vpmovsxwq zmm25, xmmword ptr [rdx + 2032]
// CHECK:  encoding: [0x62,0x62,0x7d,0x48,0x24,0x4a,0x7f]
          vpmovsxwq zmm25, xmmword ptr [rdx + 2032]

// CHECK: vpmovsxwq zmm25, xmmword ptr [rdx + 2048]
// CHECK:  encoding: [0x62,0x62,0x7d,0x48,0x24,0x8a,0x00,0x08,0x00,0x00]
          vpmovsxwq zmm25, xmmword ptr [rdx + 2048]

// CHECK: vpmovsxwq zmm25, xmmword ptr [rdx - 2048]
// CHECK:  encoding: [0x62,0x62,0x7d,0x48,0x24,0x4a,0x80]
          vpmovsxwq zmm25, xmmword ptr [rdx - 2048]

// CHECK: vpmovsxwq zmm25, xmmword ptr [rdx - 2064]
// CHECK:  encoding: [0x62,0x62,0x7d,0x48,0x24,0x8a,0xf0,0xf7,0xff,0xff]
          vpmovsxwq zmm25, xmmword ptr [rdx - 2064]

// CHECK: vpmovzxbd zmm18, xmm25
// CHECK:  encoding: [0x62,0x82,0x7d,0x48,0x31,0xd1]
          vpmovzxbd zmm18, xmm25

// CHECK: vpmovzxbd zmm18 {k7}, xmm25
// CHECK:  encoding: [0x62,0x82,0x7d,0x4f,0x31,0xd1]
          vpmovzxbd zmm18 {k7}, xmm25

// CHECK: vpmovzxbd zmm18 {k7} {z}, xmm25
// CHECK:  encoding: [0x62,0x82,0x7d,0xcf,0x31,0xd1]
          vpmovzxbd zmm18 {k7} {z}, xmm25

// CHECK: vpmovzxbd zmm18, xmmword ptr [rcx]
// CHECK:  encoding: [0x62,0xe2,0x7d,0x48,0x31,0x11]
          vpmovzxbd zmm18, xmmword ptr [rcx]

// CHECK: vpmovzxbd zmm18, xmmword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0xa2,0x7d,0x48,0x31,0x94,0xf0,0x23,0x01,0x00,0x00]
          vpmovzxbd zmm18, xmmword ptr [rax + 8*r14 + 291]

// CHECK: vpmovzxbd zmm18, xmmword ptr [rdx + 2032]
// CHECK:  encoding: [0x62,0xe2,0x7d,0x48,0x31,0x52,0x7f]
          vpmovzxbd zmm18, xmmword ptr [rdx + 2032]

// CHECK: vpmovzxbd zmm18, xmmword ptr [rdx + 2048]
// CHECK:  encoding: [0x62,0xe2,0x7d,0x48,0x31,0x92,0x00,0x08,0x00,0x00]
          vpmovzxbd zmm18, xmmword ptr [rdx + 2048]

// CHECK: vpmovzxbd zmm18, xmmword ptr [rdx - 2048]
// CHECK:  encoding: [0x62,0xe2,0x7d,0x48,0x31,0x52,0x80]
          vpmovzxbd zmm18, xmmword ptr [rdx - 2048]

// CHECK: vpmovzxbd zmm18, xmmword ptr [rdx - 2064]
// CHECK:  encoding: [0x62,0xe2,0x7d,0x48,0x31,0x92,0xf0,0xf7,0xff,0xff]
          vpmovzxbd zmm18, xmmword ptr [rdx - 2064]

// CHECK: vpmovzxbq zmm5, xmm15
// CHECK:  encoding: [0x62,0xd2,0x7d,0x48,0x32,0xef]
          vpmovzxbq zmm5, xmm15

// CHECK: vpmovzxbq zmm5 {k1}, xmm15
// CHECK:  encoding: [0x62,0xd2,0x7d,0x49,0x32,0xef]
          vpmovzxbq zmm5 {k1}, xmm15

// CHECK: vpmovzxbq zmm5 {k1} {z}, xmm15
// CHECK:  encoding: [0x62,0xd2,0x7d,0xc9,0x32,0xef]
          vpmovzxbq zmm5 {k1} {z}, xmm15

// CHECK: vpmovzxbq zmm5, qword ptr [rcx]
// CHECK:  encoding: [0x62,0xf2,0x7d,0x48,0x32,0x29]
          vpmovzxbq zmm5, qword ptr [rcx]

// CHECK: vpmovzxbq zmm5, qword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0xb2,0x7d,0x48,0x32,0xac,0xf0,0x23,0x01,0x00,0x00]
          vpmovzxbq zmm5, qword ptr [rax + 8*r14 + 291]

// CHECK: vpmovzxbq zmm5, qword ptr [rdx + 1016]
// CHECK:  encoding: [0x62,0xf2,0x7d,0x48,0x32,0x6a,0x7f]
          vpmovzxbq zmm5, qword ptr [rdx + 1016]

// CHECK: vpmovzxbq zmm5, qword ptr [rdx + 1024]
// CHECK:  encoding: [0x62,0xf2,0x7d,0x48,0x32,0xaa,0x00,0x04,0x00,0x00]
          vpmovzxbq zmm5, qword ptr [rdx + 1024]

// CHECK: vpmovzxbq zmm5, qword ptr [rdx - 1024]
// CHECK:  encoding: [0x62,0xf2,0x7d,0x48,0x32,0x6a,0x80]
          vpmovzxbq zmm5, qword ptr [rdx - 1024]

// CHECK: vpmovzxbq zmm5, qword ptr [rdx - 1032]
// CHECK:  encoding: [0x62,0xf2,0x7d,0x48,0x32,0xaa,0xf8,0xfb,0xff,0xff]
          vpmovzxbq zmm5, qword ptr [rdx - 1032]

// CHECK: vpmovzxdq zmm20, ymm4
// CHECK:  encoding: [0x62,0xe2,0x7d,0x48,0x35,0xe4]
          vpmovzxdq zmm20, ymm4

// CHECK: vpmovzxdq zmm20 {k3}, ymm4
// CHECK:  encoding: [0x62,0xe2,0x7d,0x4b,0x35,0xe4]
          vpmovzxdq zmm20 {k3}, ymm4

// CHECK: vpmovzxdq zmm20 {k3} {z}, ymm4
// CHECK:  encoding: [0x62,0xe2,0x7d,0xcb,0x35,0xe4]
          vpmovzxdq zmm20 {k3} {z}, ymm4

// CHECK: vpmovzxdq zmm20, ymmword ptr [rcx]
// CHECK:  encoding: [0x62,0xe2,0x7d,0x48,0x35,0x21]
          vpmovzxdq zmm20, ymmword ptr [rcx]

// CHECK: vpmovzxdq zmm20, ymmword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0xa2,0x7d,0x48,0x35,0xa4,0xf0,0x23,0x01,0x00,0x00]
          vpmovzxdq zmm20, ymmword ptr [rax + 8*r14 + 291]

// CHECK: vpmovzxdq zmm20, ymmword ptr [rdx + 4064]
// CHECK:  encoding: [0x62,0xe2,0x7d,0x48,0x35,0x62,0x7f]
          vpmovzxdq zmm20, ymmword ptr [rdx + 4064]

// CHECK: vpmovzxdq zmm20, ymmword ptr [rdx + 4096]
// CHECK:  encoding: [0x62,0xe2,0x7d,0x48,0x35,0xa2,0x00,0x10,0x00,0x00]
          vpmovzxdq zmm20, ymmword ptr [rdx + 4096]

// CHECK: vpmovzxdq zmm20, ymmword ptr [rdx - 4096]
// CHECK:  encoding: [0x62,0xe2,0x7d,0x48,0x35,0x62,0x80]
          vpmovzxdq zmm20, ymmword ptr [rdx - 4096]

// CHECK: vpmovzxdq zmm20, ymmword ptr [rdx - 4128]
// CHECK:  encoding: [0x62,0xe2,0x7d,0x48,0x35,0xa2,0xe0,0xef,0xff,0xff]
          vpmovzxdq zmm20, ymmword ptr [rdx - 4128]

// CHECK: vpmovzxwd zmm8, ymm6
// CHECK:  encoding: [0x62,0x72,0x7d,0x48,0x33,0xc6]
          vpmovzxwd zmm8, ymm6

// CHECK: vpmovzxwd zmm8 {k7}, ymm6
// CHECK:  encoding: [0x62,0x72,0x7d,0x4f,0x33,0xc6]
          vpmovzxwd zmm8 {k7}, ymm6

// CHECK: vpmovzxwd zmm8 {k7} {z}, ymm6
// CHECK:  encoding: [0x62,0x72,0x7d,0xcf,0x33,0xc6]
          vpmovzxwd zmm8 {k7} {z}, ymm6

// CHECK: vpmovzxwd zmm8, ymmword ptr [rcx]
// CHECK:  encoding: [0x62,0x72,0x7d,0x48,0x33,0x01]
          vpmovzxwd zmm8, ymmword ptr [rcx]

// CHECK: vpmovzxwd zmm8, ymmword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0x32,0x7d,0x48,0x33,0x84,0xf0,0x23,0x01,0x00,0x00]
          vpmovzxwd zmm8, ymmword ptr [rax + 8*r14 + 291]

// CHECK: vpmovzxwd zmm8, ymmword ptr [rdx + 4064]
// CHECK:  encoding: [0x62,0x72,0x7d,0x48,0x33,0x42,0x7f]
          vpmovzxwd zmm8, ymmword ptr [rdx + 4064]

// CHECK: vpmovzxwd zmm8, ymmword ptr [rdx + 4096]
// CHECK:  encoding: [0x62,0x72,0x7d,0x48,0x33,0x82,0x00,0x10,0x00,0x00]
          vpmovzxwd zmm8, ymmword ptr [rdx + 4096]

// CHECK: vpmovzxwd zmm8, ymmword ptr [rdx - 4096]
// CHECK:  encoding: [0x62,0x72,0x7d,0x48,0x33,0x42,0x80]
          vpmovzxwd zmm8, ymmword ptr [rdx - 4096]

// CHECK: vpmovzxwd zmm8, ymmword ptr [rdx - 4128]
// CHECK:  encoding: [0x62,0x72,0x7d,0x48,0x33,0x82,0xe0,0xef,0xff,0xff]
          vpmovzxwd zmm8, ymmword ptr [rdx - 4128]

// CHECK: vpmovzxwq zmm5, xmm15
// CHECK:  encoding: [0x62,0xd2,0x7d,0x48,0x34,0xef]
          vpmovzxwq zmm5, xmm15

// CHECK: vpmovzxwq zmm5 {k7}, xmm15
// CHECK:  encoding: [0x62,0xd2,0x7d,0x4f,0x34,0xef]
          vpmovzxwq zmm5 {k7}, xmm15

// CHECK: vpmovzxwq zmm5 {k7} {z}, xmm15
// CHECK:  encoding: [0x62,0xd2,0x7d,0xcf,0x34,0xef]
          vpmovzxwq zmm5 {k7} {z}, xmm15

// CHECK: vpmovzxwq zmm5, xmmword ptr [rcx]
// CHECK:  encoding: [0x62,0xf2,0x7d,0x48,0x34,0x29]
          vpmovzxwq zmm5, xmmword ptr [rcx]

// CHECK: vpmovzxwq zmm5, xmmword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0xb2,0x7d,0x48,0x34,0xac,0xf0,0x23,0x01,0x00,0x00]
          vpmovzxwq zmm5, xmmword ptr [rax + 8*r14 + 291]

// CHECK: vpmovzxwq zmm5, xmmword ptr [rdx + 2032]
// CHECK:  encoding: [0x62,0xf2,0x7d,0x48,0x34,0x6a,0x7f]
          vpmovzxwq zmm5, xmmword ptr [rdx + 2032]

// CHECK: vpmovzxwq zmm5, xmmword ptr [rdx + 2048]
// CHECK:  encoding: [0x62,0xf2,0x7d,0x48,0x34,0xaa,0x00,0x08,0x00,0x00]
          vpmovzxwq zmm5, xmmword ptr [rdx + 2048]

// CHECK: vpmovzxwq zmm5, xmmword ptr [rdx - 2048]
// CHECK:  encoding: [0x62,0xf2,0x7d,0x48,0x34,0x6a,0x80]
          vpmovzxwq zmm5, xmmword ptr [rdx - 2048]

// CHECK: vpmovzxwq zmm5, xmmword ptr [rdx - 2064]
// CHECK:  encoding: [0x62,0xf2,0x7d,0x48,0x34,0xaa,0xf0,0xf7,0xff,0xff]
          vpmovzxwq zmm5, xmmword ptr [rdx - 2064]

// CHECK: vpmuldq zmm29, zmm9, zmm9
// CHECK:  encoding: [0x62,0x42,0xb5,0x48,0x28,0xe9]
          vpmuldq zmm29, zmm9, zmm9

// CHECK: vpmuldq zmm29 {k5}, zmm9, zmm9
// CHECK:  encoding: [0x62,0x42,0xb5,0x4d,0x28,0xe9]
          vpmuldq zmm29 {k5}, zmm9, zmm9

// CHECK: vpmuldq zmm29 {k5} {z}, zmm9, zmm9
// CHECK:  encoding: [0x62,0x42,0xb5,0xcd,0x28,0xe9]
          vpmuldq zmm29 {k5} {z}, zmm9, zmm9

// CHECK: vpmuldq zmm29, zmm9, zmmword ptr [rcx]
// CHECK:  encoding: [0x62,0x62,0xb5,0x48,0x28,0x29]
          vpmuldq zmm29, zmm9, zmmword ptr [rcx]

// CHECK: vpmuldq zmm29, zmm9, zmmword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0x22,0xb5,0x48,0x28,0xac,0xf0,0x23,0x01,0x00,0x00]
          vpmuldq zmm29, zmm9, zmmword ptr [rax + 8*r14 + 291]

// CHECK: vpmuldq zmm29, zmm9, qword ptr [rcx]{1to8}
// CHECK:  encoding: [0x62,0x62,0xb5,0x58,0x28,0x29]
          vpmuldq zmm29, zmm9, qword ptr [rcx]{1to8}

// CHECK: vpmuldq zmm29, zmm9, zmmword ptr [rdx + 8128]
// CHECK:  encoding: [0x62,0x62,0xb5,0x48,0x28,0x6a,0x7f]
          vpmuldq zmm29, zmm9, zmmword ptr [rdx + 8128]

// CHECK: vpmuldq zmm29, zmm9, zmmword ptr [rdx + 8192]
// CHECK:  encoding: [0x62,0x62,0xb5,0x48,0x28,0xaa,0x00,0x20,0x00,0x00]
          vpmuldq zmm29, zmm9, zmmword ptr [rdx + 8192]

// CHECK: vpmuldq zmm29, zmm9, zmmword ptr [rdx - 8192]
// CHECK:  encoding: [0x62,0x62,0xb5,0x48,0x28,0x6a,0x80]
          vpmuldq zmm29, zmm9, zmmword ptr [rdx - 8192]

// CHECK: vpmuldq zmm29, zmm9, zmmword ptr [rdx - 8256]
// CHECK:  encoding: [0x62,0x62,0xb5,0x48,0x28,0xaa,0xc0,0xdf,0xff,0xff]
          vpmuldq zmm29, zmm9, zmmword ptr [rdx - 8256]

// CHECK: vpmuldq zmm29, zmm9, qword ptr [rdx + 1016]{1to8}
// CHECK:  encoding: [0x62,0x62,0xb5,0x58,0x28,0x6a,0x7f]
          vpmuldq zmm29, zmm9, qword ptr [rdx + 1016]{1to8}

// CHECK: vpmuldq zmm29, zmm9, qword ptr [rdx + 1024]{1to8}
// CHECK:  encoding: [0x62,0x62,0xb5,0x58,0x28,0xaa,0x00,0x04,0x00,0x00]
          vpmuldq zmm29, zmm9, qword ptr [rdx + 1024]{1to8}

// CHECK: vpmuldq zmm29, zmm9, qword ptr [rdx - 1024]{1to8}
// CHECK:  encoding: [0x62,0x62,0xb5,0x58,0x28,0x6a,0x80]
          vpmuldq zmm29, zmm9, qword ptr [rdx - 1024]{1to8}

// CHECK: vpmuldq zmm29, zmm9, qword ptr [rdx - 1032]{1to8}
// CHECK:  encoding: [0x62,0x62,0xb5,0x58,0x28,0xaa,0xf8,0xfb,0xff,0xff]
          vpmuldq zmm29, zmm9, qword ptr [rdx - 1032]{1to8}

// CHECK: vpmulld zmm12, zmm3, zmm2
// CHECK:  encoding: [0x62,0x72,0x65,0x48,0x40,0xe2]
          vpmulld zmm12, zmm3, zmm2

// CHECK: vpmulld zmm12 {k6}, zmm3, zmm2
// CHECK:  encoding: [0x62,0x72,0x65,0x4e,0x40,0xe2]
          vpmulld zmm12 {k6}, zmm3, zmm2

// CHECK: vpmulld zmm12 {k6} {z}, zmm3, zmm2
// CHECK:  encoding: [0x62,0x72,0x65,0xce,0x40,0xe2]
          vpmulld zmm12 {k6} {z}, zmm3, zmm2

// CHECK: vpmulld zmm12, zmm3, zmmword ptr [rcx]
// CHECK:  encoding: [0x62,0x72,0x65,0x48,0x40,0x21]
          vpmulld zmm12, zmm3, zmmword ptr [rcx]

// CHECK: vpmulld zmm12, zmm3, zmmword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0x32,0x65,0x48,0x40,0xa4,0xf0,0x23,0x01,0x00,0x00]
          vpmulld zmm12, zmm3, zmmword ptr [rax + 8*r14 + 291]

// CHECK: vpmulld zmm12, zmm3, dword ptr [rcx]{1to16}
// CHECK:  encoding: [0x62,0x72,0x65,0x58,0x40,0x21]
          vpmulld zmm12, zmm3, dword ptr [rcx]{1to16}

// CHECK: vpmulld zmm12, zmm3, zmmword ptr [rdx + 8128]
// CHECK:  encoding: [0x62,0x72,0x65,0x48,0x40,0x62,0x7f]
          vpmulld zmm12, zmm3, zmmword ptr [rdx + 8128]

// CHECK: vpmulld zmm12, zmm3, zmmword ptr [rdx + 8192]
// CHECK:  encoding: [0x62,0x72,0x65,0x48,0x40,0xa2,0x00,0x20,0x00,0x00]
          vpmulld zmm12, zmm3, zmmword ptr [rdx + 8192]

// CHECK: vpmulld zmm12, zmm3, zmmword ptr [rdx - 8192]
// CHECK:  encoding: [0x62,0x72,0x65,0x48,0x40,0x62,0x80]
          vpmulld zmm12, zmm3, zmmword ptr [rdx - 8192]

// CHECK: vpmulld zmm12, zmm3, zmmword ptr [rdx - 8256]
// CHECK:  encoding: [0x62,0x72,0x65,0x48,0x40,0xa2,0xc0,0xdf,0xff,0xff]
          vpmulld zmm12, zmm3, zmmword ptr [rdx - 8256]

// CHECK: vpmulld zmm12, zmm3, dword ptr [rdx + 508]{1to16}
// CHECK:  encoding: [0x62,0x72,0x65,0x58,0x40,0x62,0x7f]
          vpmulld zmm12, zmm3, dword ptr [rdx + 508]{1to16}

// CHECK: vpmulld zmm12, zmm3, dword ptr [rdx + 512]{1to16}
// CHECK:  encoding: [0x62,0x72,0x65,0x58,0x40,0xa2,0x00,0x02,0x00,0x00]
          vpmulld zmm12, zmm3, dword ptr [rdx + 512]{1to16}

// CHECK: vpmulld zmm12, zmm3, dword ptr [rdx - 512]{1to16}
// CHECK:  encoding: [0x62,0x72,0x65,0x58,0x40,0x62,0x80]
          vpmulld zmm12, zmm3, dword ptr [rdx - 512]{1to16}

// CHECK: vpmulld zmm12, zmm3, dword ptr [rdx - 516]{1to16}
// CHECK:  encoding: [0x62,0x72,0x65,0x58,0x40,0xa2,0xfc,0xfd,0xff,0xff]
          vpmulld zmm12, zmm3, dword ptr [rdx - 516]{1to16}

// CHECK: vpmuludq zmm23, zmm5, zmm9
// CHECK:  encoding: [0x62,0xc1,0xd5,0x48,0xf4,0xf9]
          vpmuludq zmm23, zmm5, zmm9

// CHECK: vpmuludq zmm23 {k4}, zmm5, zmm9
// CHECK:  encoding: [0x62,0xc1,0xd5,0x4c,0xf4,0xf9]
          vpmuludq zmm23 {k4}, zmm5, zmm9

// CHECK: vpmuludq zmm23 {k4} {z}, zmm5, zmm9
// CHECK:  encoding: [0x62,0xc1,0xd5,0xcc,0xf4,0xf9]
          vpmuludq zmm23 {k4} {z}, zmm5, zmm9

// CHECK: vpmuludq zmm23, zmm5, zmmword ptr [rcx]
// CHECK:  encoding: [0x62,0xe1,0xd5,0x48,0xf4,0x39]
          vpmuludq zmm23, zmm5, zmmword ptr [rcx]

// CHECK: vpmuludq zmm23, zmm5, zmmword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0xa1,0xd5,0x48,0xf4,0xbc,0xf0,0x23,0x01,0x00,0x00]
          vpmuludq zmm23, zmm5, zmmword ptr [rax + 8*r14 + 291]

// CHECK: vpmuludq zmm23, zmm5, qword ptr [rcx]{1to8}
// CHECK:  encoding: [0x62,0xe1,0xd5,0x58,0xf4,0x39]
          vpmuludq zmm23, zmm5, qword ptr [rcx]{1to8}

// CHECK: vpmuludq zmm23, zmm5, zmmword ptr [rdx + 8128]
// CHECK:  encoding: [0x62,0xe1,0xd5,0x48,0xf4,0x7a,0x7f]
          vpmuludq zmm23, zmm5, zmmword ptr [rdx + 8128]

// CHECK: vpmuludq zmm23, zmm5, zmmword ptr [rdx + 8192]
// CHECK:  encoding: [0x62,0xe1,0xd5,0x48,0xf4,0xba,0x00,0x20,0x00,0x00]
          vpmuludq zmm23, zmm5, zmmword ptr [rdx + 8192]

// CHECK: vpmuludq zmm23, zmm5, zmmword ptr [rdx - 8192]
// CHECK:  encoding: [0x62,0xe1,0xd5,0x48,0xf4,0x7a,0x80]
          vpmuludq zmm23, zmm5, zmmword ptr [rdx - 8192]

// CHECK: vpmuludq zmm23, zmm5, zmmword ptr [rdx - 8256]
// CHECK:  encoding: [0x62,0xe1,0xd5,0x48,0xf4,0xba,0xc0,0xdf,0xff,0xff]
          vpmuludq zmm23, zmm5, zmmword ptr [rdx - 8256]

// CHECK: vpmuludq zmm23, zmm5, qword ptr [rdx + 1016]{1to8}
// CHECK:  encoding: [0x62,0xe1,0xd5,0x58,0xf4,0x7a,0x7f]
          vpmuludq zmm23, zmm5, qword ptr [rdx + 1016]{1to8}

// CHECK: vpmuludq zmm23, zmm5, qword ptr [rdx + 1024]{1to8}
// CHECK:  encoding: [0x62,0xe1,0xd5,0x58,0xf4,0xba,0x00,0x04,0x00,0x00]
          vpmuludq zmm23, zmm5, qword ptr [rdx + 1024]{1to8}

// CHECK: vpmuludq zmm23, zmm5, qword ptr [rdx - 1024]{1to8}
// CHECK:  encoding: [0x62,0xe1,0xd5,0x58,0xf4,0x7a,0x80]
          vpmuludq zmm23, zmm5, qword ptr [rdx - 1024]{1to8}

// CHECK: vpmuludq zmm23, zmm5, qword ptr [rdx - 1032]{1to8}
// CHECK:  encoding: [0x62,0xe1,0xd5,0x58,0xf4,0xba,0xf8,0xfb,0xff,0xff]
          vpmuludq zmm23, zmm5, qword ptr [rdx - 1032]{1to8}

// CHECK: vpord  zmm23, zmm2, zmm20
// CHECK:  encoding: [0x62,0xa1,0x6d,0x48,0xeb,0xfc]
          vpord  zmm23, zmm2, zmm20

// CHECK: vpord  zmm23 {k2}, zmm2, zmm20
// CHECK:  encoding: [0x62,0xa1,0x6d,0x4a,0xeb,0xfc]
          vpord  zmm23 {k2}, zmm2, zmm20

// CHECK: vpord  zmm23 {k2} {z}, zmm2, zmm20
// CHECK:  encoding: [0x62,0xa1,0x6d,0xca,0xeb,0xfc]
          vpord  zmm23 {k2} {z}, zmm2, zmm20

// CHECK: vpord  zmm23, zmm2, zmmword ptr [rcx]
// CHECK:  encoding: [0x62,0xe1,0x6d,0x48,0xeb,0x39]
          vpord  zmm23, zmm2, zmmword ptr [rcx]

// CHECK: vpord  zmm23, zmm2, zmmword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0xa1,0x6d,0x48,0xeb,0xbc,0xf0,0x23,0x01,0x00,0x00]
          vpord  zmm23, zmm2, zmmword ptr [rax + 8*r14 + 291]

// CHECK: vpord  zmm23, zmm2, dword ptr [rcx]{1to16}
// CHECK:  encoding: [0x62,0xe1,0x6d,0x58,0xeb,0x39]
          vpord  zmm23, zmm2, dword ptr [rcx]{1to16}

// CHECK: vpord  zmm23, zmm2, zmmword ptr [rdx + 8128]
// CHECK:  encoding: [0x62,0xe1,0x6d,0x48,0xeb,0x7a,0x7f]
          vpord  zmm23, zmm2, zmmword ptr [rdx + 8128]

// CHECK: vpord  zmm23, zmm2, zmmword ptr [rdx + 8192]
// CHECK:  encoding: [0x62,0xe1,0x6d,0x48,0xeb,0xba,0x00,0x20,0x00,0x00]
          vpord  zmm23, zmm2, zmmword ptr [rdx + 8192]

// CHECK: vpord  zmm23, zmm2, zmmword ptr [rdx - 8192]
// CHECK:  encoding: [0x62,0xe1,0x6d,0x48,0xeb,0x7a,0x80]
          vpord  zmm23, zmm2, zmmword ptr [rdx - 8192]

// CHECK: vpord  zmm23, zmm2, zmmword ptr [rdx - 8256]
// CHECK:  encoding: [0x62,0xe1,0x6d,0x48,0xeb,0xba,0xc0,0xdf,0xff,0xff]
          vpord  zmm23, zmm2, zmmword ptr [rdx - 8256]

// CHECK: vpord  zmm23, zmm2, dword ptr [rdx + 508]{1to16}
// CHECK:  encoding: [0x62,0xe1,0x6d,0x58,0xeb,0x7a,0x7f]
          vpord  zmm23, zmm2, dword ptr [rdx + 508]{1to16}

// CHECK: vpord  zmm23, zmm2, dword ptr [rdx + 512]{1to16}
// CHECK:  encoding: [0x62,0xe1,0x6d,0x58,0xeb,0xba,0x00,0x02,0x00,0x00]
          vpord  zmm23, zmm2, dword ptr [rdx + 512]{1to16}

// CHECK: vpord  zmm23, zmm2, dword ptr [rdx - 512]{1to16}
// CHECK:  encoding: [0x62,0xe1,0x6d,0x58,0xeb,0x7a,0x80]
          vpord  zmm23, zmm2, dword ptr [rdx - 512]{1to16}

// CHECK: vpord  zmm23, zmm2, dword ptr [rdx - 516]{1to16}
// CHECK:  encoding: [0x62,0xe1,0x6d,0x58,0xeb,0xba,0xfc,0xfd,0xff,0xff]
          vpord  zmm23, zmm2, dword ptr [rdx - 516]{1to16}

// CHECK: vporq  zmm1, zmm10, zmm6
// CHECK:  encoding: [0x62,0xf1,0xad,0x48,0xeb,0xce]
          vporq  zmm1, zmm10, zmm6

// CHECK: vporq  zmm1 {k2}, zmm10, zmm6
// CHECK:  encoding: [0x62,0xf1,0xad,0x4a,0xeb,0xce]
          vporq  zmm1 {k2}, zmm10, zmm6

// CHECK: vporq  zmm1 {k2} {z}, zmm10, zmm6
// CHECK:  encoding: [0x62,0xf1,0xad,0xca,0xeb,0xce]
          vporq  zmm1 {k2} {z}, zmm10, zmm6

// CHECK: vporq  zmm1, zmm10, zmmword ptr [rcx]
// CHECK:  encoding: [0x62,0xf1,0xad,0x48,0xeb,0x09]
          vporq  zmm1, zmm10, zmmword ptr [rcx]

// CHECK: vporq  zmm1, zmm10, zmmword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0xb1,0xad,0x48,0xeb,0x8c,0xf0,0x23,0x01,0x00,0x00]
          vporq  zmm1, zmm10, zmmword ptr [rax + 8*r14 + 291]

// CHECK: vporq  zmm1, zmm10, qword ptr [rcx]{1to8}
// CHECK:  encoding: [0x62,0xf1,0xad,0x58,0xeb,0x09]
          vporq  zmm1, zmm10, qword ptr [rcx]{1to8}

// CHECK: vporq  zmm1, zmm10, zmmword ptr [rdx + 8128]
// CHECK:  encoding: [0x62,0xf1,0xad,0x48,0xeb,0x4a,0x7f]
          vporq  zmm1, zmm10, zmmword ptr [rdx + 8128]

// CHECK: vporq  zmm1, zmm10, zmmword ptr [rdx + 8192]
// CHECK:  encoding: [0x62,0xf1,0xad,0x48,0xeb,0x8a,0x00,0x20,0x00,0x00]
          vporq  zmm1, zmm10, zmmword ptr [rdx + 8192]

// CHECK: vporq  zmm1, zmm10, zmmword ptr [rdx - 8192]
// CHECK:  encoding: [0x62,0xf1,0xad,0x48,0xeb,0x4a,0x80]
          vporq  zmm1, zmm10, zmmword ptr [rdx - 8192]

// CHECK: vporq  zmm1, zmm10, zmmword ptr [rdx - 8256]
// CHECK:  encoding: [0x62,0xf1,0xad,0x48,0xeb,0x8a,0xc0,0xdf,0xff,0xff]
          vporq  zmm1, zmm10, zmmword ptr [rdx - 8256]

// CHECK: vporq  zmm1, zmm10, qword ptr [rdx + 1016]{1to8}
// CHECK:  encoding: [0x62,0xf1,0xad,0x58,0xeb,0x4a,0x7f]
          vporq  zmm1, zmm10, qword ptr [rdx + 1016]{1to8}

// CHECK: vporq  zmm1, zmm10, qword ptr [rdx + 1024]{1to8}
// CHECK:  encoding: [0x62,0xf1,0xad,0x58,0xeb,0x8a,0x00,0x04,0x00,0x00]
          vporq  zmm1, zmm10, qword ptr [rdx + 1024]{1to8}

// CHECK: vporq  zmm1, zmm10, qword ptr [rdx - 1024]{1to8}
// CHECK:  encoding: [0x62,0xf1,0xad,0x58,0xeb,0x4a,0x80]
          vporq  zmm1, zmm10, qword ptr [rdx - 1024]{1to8}

// CHECK: vporq  zmm1, zmm10, qword ptr [rdx - 1032]{1to8}
// CHECK:  encoding: [0x62,0xf1,0xad,0x58,0xeb,0x8a,0xf8,0xfb,0xff,0xff]
          vporq  zmm1, zmm10, qword ptr [rdx - 1032]{1to8}

// CHECK: vpshufd zmm19, zmm25, 171
// CHECK:  encoding: [0x62,0x81,0x7d,0x48,0x70,0xd9,0xab]
          vpshufd zmm19, zmm25, 171

// CHECK: vpshufd zmm19 {k6}, zmm25, 171
// CHECK:  encoding: [0x62,0x81,0x7d,0x4e,0x70,0xd9,0xab]
          vpshufd zmm19 {k6}, zmm25, 171

// CHECK: vpshufd zmm19 {k6} {z}, zmm25, 171
// CHECK:  encoding: [0x62,0x81,0x7d,0xce,0x70,0xd9,0xab]
          vpshufd zmm19 {k6} {z}, zmm25, 171

// CHECK: vpshufd zmm19, zmm25, 123
// CHECK:  encoding: [0x62,0x81,0x7d,0x48,0x70,0xd9,0x7b]
          vpshufd zmm19, zmm25, 123

// CHECK: vpshufd zmm19, zmmword ptr [rcx], 123
// CHECK:  encoding: [0x62,0xe1,0x7d,0x48,0x70,0x19,0x7b]
          vpshufd zmm19, zmmword ptr [rcx], 123

// CHECK: vpshufd zmm19, zmmword ptr [rax + 8*r14 + 291], 123
// CHECK:  encoding: [0x62,0xa1,0x7d,0x48,0x70,0x9c,0xf0,0x23,0x01,0x00,0x00,0x7b]
          vpshufd zmm19, zmmword ptr [rax + 8*r14 + 291], 123

// CHECK: vpshufd zmm19, dword ptr [rcx]{1to16}, 123
// CHECK:  encoding: [0x62,0xe1,0x7d,0x58,0x70,0x19,0x7b]
          vpshufd zmm19, dword ptr [rcx]{1to16}, 123

// CHECK: vpshufd zmm19, zmmword ptr [rdx + 8128], 123
// CHECK:  encoding: [0x62,0xe1,0x7d,0x48,0x70,0x5a,0x7f,0x7b]
          vpshufd zmm19, zmmword ptr [rdx + 8128], 123

// CHECK: vpshufd zmm19, zmmword ptr [rdx + 8192], 123
// CHECK:  encoding: [0x62,0xe1,0x7d,0x48,0x70,0x9a,0x00,0x20,0x00,0x00,0x7b]
          vpshufd zmm19, zmmword ptr [rdx + 8192], 123

// CHECK: vpshufd zmm19, zmmword ptr [rdx - 8192], 123
// CHECK:  encoding: [0x62,0xe1,0x7d,0x48,0x70,0x5a,0x80,0x7b]
          vpshufd zmm19, zmmword ptr [rdx - 8192], 123

// CHECK: vpshufd zmm19, zmmword ptr [rdx - 8256], 123
// CHECK:  encoding: [0x62,0xe1,0x7d,0x48,0x70,0x9a,0xc0,0xdf,0xff,0xff,0x7b]
          vpshufd zmm19, zmmword ptr [rdx - 8256], 123

// CHECK: vpshufd zmm19, dword ptr [rdx + 508]{1to16}, 123
// CHECK:  encoding: [0x62,0xe1,0x7d,0x58,0x70,0x5a,0x7f,0x7b]
          vpshufd zmm19, dword ptr [rdx + 508]{1to16}, 123

// CHECK: vpshufd zmm19, dword ptr [rdx + 512]{1to16}, 123
// CHECK:  encoding: [0x62,0xe1,0x7d,0x58,0x70,0x9a,0x00,0x02,0x00,0x00,0x7b]
          vpshufd zmm19, dword ptr [rdx + 512]{1to16}, 123

// CHECK: vpshufd zmm19, dword ptr [rdx - 512]{1to16}, 123
// CHECK:  encoding: [0x62,0xe1,0x7d,0x58,0x70,0x5a,0x80,0x7b]
          vpshufd zmm19, dword ptr [rdx - 512]{1to16}, 123

// CHECK: vpshufd zmm19, dword ptr [rdx - 516]{1to16}, 123
// CHECK:  encoding: [0x62,0xe1,0x7d,0x58,0x70,0x9a,0xfc,0xfd,0xff,0xff,0x7b]
          vpshufd zmm19, dword ptr [rdx - 516]{1to16}, 123

// CHECK: vpslld zmm17, zmm6, xmm3
// CHECK:  encoding: [0x62,0xe1,0x4d,0x48,0xf2,0xcb]
          vpslld zmm17, zmm6, xmm3

// CHECK: vpslld zmm17 {k3}, zmm6, xmm3
// CHECK:  encoding: [0x62,0xe1,0x4d,0x4b,0xf2,0xcb]
          vpslld zmm17 {k3}, zmm6, xmm3

// CHECK: vpslld zmm17 {k3} {z}, zmm6, xmm3
// CHECK:  encoding: [0x62,0xe1,0x4d,0xcb,0xf2,0xcb]
          vpslld zmm17 {k3} {z}, zmm6, xmm3

// CHECK: vpslld zmm17, zmm6, xmmword ptr [rcx]
// CHECK:  encoding: [0x62,0xe1,0x4d,0x48,0xf2,0x09]
          vpslld zmm17, zmm6, xmmword ptr [rcx]

// CHECK: vpslld zmm17, zmm6, xmmword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0xa1,0x4d,0x48,0xf2,0x8c,0xf0,0x23,0x01,0x00,0x00]
          vpslld zmm17, zmm6, xmmword ptr [rax + 8*r14 + 291]

// CHECK: vpslld zmm17, zmm6, xmmword ptr [rdx + 2032]
// CHECK:  encoding: [0x62,0xe1,0x4d,0x48,0xf2,0x4a,0x7f]
          vpslld zmm17, zmm6, xmmword ptr [rdx + 2032]

// CHECK: vpslld zmm17, zmm6, xmmword ptr [rdx + 2048]
// CHECK:  encoding: [0x62,0xe1,0x4d,0x48,0xf2,0x8a,0x00,0x08,0x00,0x00]
          vpslld zmm17, zmm6, xmmword ptr [rdx + 2048]

// CHECK: vpslld zmm17, zmm6, xmmword ptr [rdx - 2048]
// CHECK:  encoding: [0x62,0xe1,0x4d,0x48,0xf2,0x4a,0x80]
          vpslld zmm17, zmm6, xmmword ptr [rdx - 2048]

// CHECK: vpslld zmm17, zmm6, xmmword ptr [rdx - 2064]
// CHECK:  encoding: [0x62,0xe1,0x4d,0x48,0xf2,0x8a,0xf0,0xf7,0xff,0xff]
          vpslld zmm17, zmm6, xmmword ptr [rdx - 2064]

// CHECK: vpsllq zmm26, zmm17, xmm23
// CHECK:  encoding: [0x62,0x21,0xf5,0x40,0xf3,0xd7]
          vpsllq zmm26, zmm17, xmm23

// CHECK: vpsllq zmm26 {k6}, zmm17, xmm23
// CHECK:  encoding: [0x62,0x21,0xf5,0x46,0xf3,0xd7]
          vpsllq zmm26 {k6}, zmm17, xmm23

// CHECK: vpsllq zmm26 {k6} {z}, zmm17, xmm23
// CHECK:  encoding: [0x62,0x21,0xf5,0xc6,0xf3,0xd7]
          vpsllq zmm26 {k6} {z}, zmm17, xmm23

// CHECK: vpsllq zmm26, zmm17, xmmword ptr [rcx]
// CHECK:  encoding: [0x62,0x61,0xf5,0x40,0xf3,0x11]
          vpsllq zmm26, zmm17, xmmword ptr [rcx]

// CHECK: vpsllq zmm26, zmm17, xmmword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0x21,0xf5,0x40,0xf3,0x94,0xf0,0x23,0x01,0x00,0x00]
          vpsllq zmm26, zmm17, xmmword ptr [rax + 8*r14 + 291]

// CHECK: vpsllq zmm26, zmm17, xmmword ptr [rdx + 2032]
// CHECK:  encoding: [0x62,0x61,0xf5,0x40,0xf3,0x52,0x7f]
          vpsllq zmm26, zmm17, xmmword ptr [rdx + 2032]

// CHECK: vpsllq zmm26, zmm17, xmmword ptr [rdx + 2048]
// CHECK:  encoding: [0x62,0x61,0xf5,0x40,0xf3,0x92,0x00,0x08,0x00,0x00]
          vpsllq zmm26, zmm17, xmmword ptr [rdx + 2048]

// CHECK: vpsllq zmm26, zmm17, xmmword ptr [rdx - 2048]
// CHECK:  encoding: [0x62,0x61,0xf5,0x40,0xf3,0x52,0x80]
          vpsllq zmm26, zmm17, xmmword ptr [rdx - 2048]

// CHECK: vpsllq zmm26, zmm17, xmmword ptr [rdx - 2064]
// CHECK:  encoding: [0x62,0x61,0xf5,0x40,0xf3,0x92,0xf0,0xf7,0xff,0xff]
          vpsllq zmm26, zmm17, xmmword ptr [rdx - 2064]

// CHECK: vpsllvd zmm10, zmm12, zmm22
// CHECK:  encoding: [0x62,0x32,0x1d,0x48,0x47,0xd6]
          vpsllvd zmm10, zmm12, zmm22

// CHECK: vpsllvd zmm10 {k6}, zmm12, zmm22
// CHECK:  encoding: [0x62,0x32,0x1d,0x4e,0x47,0xd6]
          vpsllvd zmm10 {k6}, zmm12, zmm22

// CHECK: vpsllvd zmm10 {k6} {z}, zmm12, zmm22
// CHECK:  encoding: [0x62,0x32,0x1d,0xce,0x47,0xd6]
          vpsllvd zmm10 {k6} {z}, zmm12, zmm22

// CHECK: vpsllvd zmm10, zmm12, zmmword ptr [rcx]
// CHECK:  encoding: [0x62,0x72,0x1d,0x48,0x47,0x11]
          vpsllvd zmm10, zmm12, zmmword ptr [rcx]

// CHECK: vpsllvd zmm10, zmm12, zmmword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0x32,0x1d,0x48,0x47,0x94,0xf0,0x23,0x01,0x00,0x00]
          vpsllvd zmm10, zmm12, zmmword ptr [rax + 8*r14 + 291]

// CHECK: vpsllvd zmm10, zmm12, dword ptr [rcx]{1to16}
// CHECK:  encoding: [0x62,0x72,0x1d,0x58,0x47,0x11]
          vpsllvd zmm10, zmm12, dword ptr [rcx]{1to16}

// CHECK: vpsllvd zmm10, zmm12, zmmword ptr [rdx + 8128]
// CHECK:  encoding: [0x62,0x72,0x1d,0x48,0x47,0x52,0x7f]
          vpsllvd zmm10, zmm12, zmmword ptr [rdx + 8128]

// CHECK: vpsllvd zmm10, zmm12, zmmword ptr [rdx + 8192]
// CHECK:  encoding: [0x62,0x72,0x1d,0x48,0x47,0x92,0x00,0x20,0x00,0x00]
          vpsllvd zmm10, zmm12, zmmword ptr [rdx + 8192]

// CHECK: vpsllvd zmm10, zmm12, zmmword ptr [rdx - 8192]
// CHECK:  encoding: [0x62,0x72,0x1d,0x48,0x47,0x52,0x80]
          vpsllvd zmm10, zmm12, zmmword ptr [rdx - 8192]

// CHECK: vpsllvd zmm10, zmm12, zmmword ptr [rdx - 8256]
// CHECK:  encoding: [0x62,0x72,0x1d,0x48,0x47,0x92,0xc0,0xdf,0xff,0xff]
          vpsllvd zmm10, zmm12, zmmword ptr [rdx - 8256]

// CHECK: vpsllvd zmm10, zmm12, dword ptr [rdx + 508]{1to16}
// CHECK:  encoding: [0x62,0x72,0x1d,0x58,0x47,0x52,0x7f]
          vpsllvd zmm10, zmm12, dword ptr [rdx + 508]{1to16}

// CHECK: vpsllvd zmm10, zmm12, dword ptr [rdx + 512]{1to16}
// CHECK:  encoding: [0x62,0x72,0x1d,0x58,0x47,0x92,0x00,0x02,0x00,0x00]
          vpsllvd zmm10, zmm12, dword ptr [rdx + 512]{1to16}

// CHECK: vpsllvd zmm10, zmm12, dword ptr [rdx - 512]{1to16}
// CHECK:  encoding: [0x62,0x72,0x1d,0x58,0x47,0x52,0x80]
          vpsllvd zmm10, zmm12, dword ptr [rdx - 512]{1to16}

// CHECK: vpsllvd zmm10, zmm12, dword ptr [rdx - 516]{1to16}
// CHECK:  encoding: [0x62,0x72,0x1d,0x58,0x47,0x92,0xfc,0xfd,0xff,0xff]
          vpsllvd zmm10, zmm12, dword ptr [rdx - 516]{1to16}

// CHECK: vpsllvq zmm16, zmm5, zmm26
// CHECK:  encoding: [0x62,0x82,0xd5,0x48,0x47,0xc2]
          vpsllvq zmm16, zmm5, zmm26

// CHECK: vpsllvq zmm16 {k5}, zmm5, zmm26
// CHECK:  encoding: [0x62,0x82,0xd5,0x4d,0x47,0xc2]
          vpsllvq zmm16 {k5}, zmm5, zmm26

// CHECK: vpsllvq zmm16 {k5} {z}, zmm5, zmm26
// CHECK:  encoding: [0x62,0x82,0xd5,0xcd,0x47,0xc2]
          vpsllvq zmm16 {k5} {z}, zmm5, zmm26

// CHECK: vpsllvq zmm16, zmm5, zmmword ptr [rcx]
// CHECK:  encoding: [0x62,0xe2,0xd5,0x48,0x47,0x01]
          vpsllvq zmm16, zmm5, zmmword ptr [rcx]

// CHECK: vpsllvq zmm16, zmm5, zmmword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0xa2,0xd5,0x48,0x47,0x84,0xf0,0x23,0x01,0x00,0x00]
          vpsllvq zmm16, zmm5, zmmword ptr [rax + 8*r14 + 291]

// CHECK: vpsllvq zmm16, zmm5, qword ptr [rcx]{1to8}
// CHECK:  encoding: [0x62,0xe2,0xd5,0x58,0x47,0x01]
          vpsllvq zmm16, zmm5, qword ptr [rcx]{1to8}

// CHECK: vpsllvq zmm16, zmm5, zmmword ptr [rdx + 8128]
// CHECK:  encoding: [0x62,0xe2,0xd5,0x48,0x47,0x42,0x7f]
          vpsllvq zmm16, zmm5, zmmword ptr [rdx + 8128]

// CHECK: vpsllvq zmm16, zmm5, zmmword ptr [rdx + 8192]
// CHECK:  encoding: [0x62,0xe2,0xd5,0x48,0x47,0x82,0x00,0x20,0x00,0x00]
          vpsllvq zmm16, zmm5, zmmword ptr [rdx + 8192]

// CHECK: vpsllvq zmm16, zmm5, zmmword ptr [rdx - 8192]
// CHECK:  encoding: [0x62,0xe2,0xd5,0x48,0x47,0x42,0x80]
          vpsllvq zmm16, zmm5, zmmword ptr [rdx - 8192]

// CHECK: vpsllvq zmm16, zmm5, zmmword ptr [rdx - 8256]
// CHECK:  encoding: [0x62,0xe2,0xd5,0x48,0x47,0x82,0xc0,0xdf,0xff,0xff]
          vpsllvq zmm16, zmm5, zmmword ptr [rdx - 8256]

// CHECK: vpsllvq zmm16, zmm5, qword ptr [rdx + 1016]{1to8}
// CHECK:  encoding: [0x62,0xe2,0xd5,0x58,0x47,0x42,0x7f]
          vpsllvq zmm16, zmm5, qword ptr [rdx + 1016]{1to8}

// CHECK: vpsllvq zmm16, zmm5, qword ptr [rdx + 1024]{1to8}
// CHECK:  encoding: [0x62,0xe2,0xd5,0x58,0x47,0x82,0x00,0x04,0x00,0x00]
          vpsllvq zmm16, zmm5, qword ptr [rdx + 1024]{1to8}

// CHECK: vpsllvq zmm16, zmm5, qword ptr [rdx - 1024]{1to8}
// CHECK:  encoding: [0x62,0xe2,0xd5,0x58,0x47,0x42,0x80]
          vpsllvq zmm16, zmm5, qword ptr [rdx - 1024]{1to8}

// CHECK: vpsllvq zmm16, zmm5, qword ptr [rdx - 1032]{1to8}
// CHECK:  encoding: [0x62,0xe2,0xd5,0x58,0x47,0x82,0xf8,0xfb,0xff,0xff]
          vpsllvq zmm16, zmm5, qword ptr [rdx - 1032]{1to8}

// CHECK: vpsrad zmm18, zmm14, xmm6
// CHECK:  encoding: [0x62,0xe1,0x0d,0x48,0xe2,0xd6]
          vpsrad zmm18, zmm14, xmm6

// CHECK: vpsrad zmm18 {k1}, zmm14, xmm6
// CHECK:  encoding: [0x62,0xe1,0x0d,0x49,0xe2,0xd6]
          vpsrad zmm18 {k1}, zmm14, xmm6

// CHECK: vpsrad zmm18 {k1} {z}, zmm14, xmm6
// CHECK:  encoding: [0x62,0xe1,0x0d,0xc9,0xe2,0xd6]
          vpsrad zmm18 {k1} {z}, zmm14, xmm6

// CHECK: vpsrad zmm18, zmm14, xmmword ptr [rcx]
// CHECK:  encoding: [0x62,0xe1,0x0d,0x48,0xe2,0x11]
          vpsrad zmm18, zmm14, xmmword ptr [rcx]

// CHECK: vpsrad zmm18, zmm14, xmmword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0xa1,0x0d,0x48,0xe2,0x94,0xf0,0x23,0x01,0x00,0x00]
          vpsrad zmm18, zmm14, xmmword ptr [rax + 8*r14 + 291]

// CHECK: vpsrad zmm18, zmm14, xmmword ptr [rdx + 2032]
// CHECK:  encoding: [0x62,0xe1,0x0d,0x48,0xe2,0x52,0x7f]
          vpsrad zmm18, zmm14, xmmword ptr [rdx + 2032]

// CHECK: vpsrad zmm18, zmm14, xmmword ptr [rdx + 2048]
// CHECK:  encoding: [0x62,0xe1,0x0d,0x48,0xe2,0x92,0x00,0x08,0x00,0x00]
          vpsrad zmm18, zmm14, xmmword ptr [rdx + 2048]

// CHECK: vpsrad zmm18, zmm14, xmmword ptr [rdx - 2048]
// CHECK:  encoding: [0x62,0xe1,0x0d,0x48,0xe2,0x52,0x80]
          vpsrad zmm18, zmm14, xmmword ptr [rdx - 2048]

// CHECK: vpsrad zmm18, zmm14, xmmword ptr [rdx - 2064]
// CHECK:  encoding: [0x62,0xe1,0x0d,0x48,0xe2,0x92,0xf0,0xf7,0xff,0xff]
          vpsrad zmm18, zmm14, xmmword ptr [rdx - 2064]

// CHECK: vpsraq zmm21, zmm17, xmm22
// CHECK:  encoding: [0x62,0xa1,0xf5,0x40,0xe2,0xee]
          vpsraq zmm21, zmm17, xmm22

// CHECK: vpsraq zmm21 {k3}, zmm17, xmm22
// CHECK:  encoding: [0x62,0xa1,0xf5,0x43,0xe2,0xee]
          vpsraq zmm21 {k3}, zmm17, xmm22

// CHECK: vpsraq zmm21 {k3} {z}, zmm17, xmm22
// CHECK:  encoding: [0x62,0xa1,0xf5,0xc3,0xe2,0xee]
          vpsraq zmm21 {k3} {z}, zmm17, xmm22

// CHECK: vpsraq zmm21, zmm17, xmmword ptr [rcx]
// CHECK:  encoding: [0x62,0xe1,0xf5,0x40,0xe2,0x29]
          vpsraq zmm21, zmm17, xmmword ptr [rcx]

// CHECK: vpsraq zmm21, zmm17, xmmword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0xa1,0xf5,0x40,0xe2,0xac,0xf0,0x23,0x01,0x00,0x00]
          vpsraq zmm21, zmm17, xmmword ptr [rax + 8*r14 + 291]

// CHECK: vpsraq zmm21, zmm17, xmmword ptr [rdx + 2032]
// CHECK:  encoding: [0x62,0xe1,0xf5,0x40,0xe2,0x6a,0x7f]
          vpsraq zmm21, zmm17, xmmword ptr [rdx + 2032]

// CHECK: vpsraq zmm21, zmm17, xmmword ptr [rdx + 2048]
// CHECK:  encoding: [0x62,0xe1,0xf5,0x40,0xe2,0xaa,0x00,0x08,0x00,0x00]
          vpsraq zmm21, zmm17, xmmword ptr [rdx + 2048]

// CHECK: vpsraq zmm21, zmm17, xmmword ptr [rdx - 2048]
// CHECK:  encoding: [0x62,0xe1,0xf5,0x40,0xe2,0x6a,0x80]
          vpsraq zmm21, zmm17, xmmword ptr [rdx - 2048]

// CHECK: vpsraq zmm21, zmm17, xmmword ptr [rdx - 2064]
// CHECK:  encoding: [0x62,0xe1,0xf5,0x40,0xe2,0xaa,0xf0,0xf7,0xff,0xff]
          vpsraq zmm21, zmm17, xmmword ptr [rdx - 2064]

// CHECK: vpsravd zmm29, zmm29, zmm17
// CHECK:  encoding: [0x62,0x22,0x15,0x40,0x46,0xe9]
          vpsravd zmm29, zmm29, zmm17

// CHECK: vpsravd zmm29 {k2}, zmm29, zmm17
// CHECK:  encoding: [0x62,0x22,0x15,0x42,0x46,0xe9]
          vpsravd zmm29 {k2}, zmm29, zmm17

// CHECK: vpsravd zmm29 {k2} {z}, zmm29, zmm17
// CHECK:  encoding: [0x62,0x22,0x15,0xc2,0x46,0xe9]
          vpsravd zmm29 {k2} {z}, zmm29, zmm17

// CHECK: vpsravd zmm29, zmm29, zmmword ptr [rcx]
// CHECK:  encoding: [0x62,0x62,0x15,0x40,0x46,0x29]
          vpsravd zmm29, zmm29, zmmword ptr [rcx]

// CHECK: vpsravd zmm29, zmm29, zmmword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0x22,0x15,0x40,0x46,0xac,0xf0,0x23,0x01,0x00,0x00]
          vpsravd zmm29, zmm29, zmmword ptr [rax + 8*r14 + 291]

// CHECK: vpsravd zmm29, zmm29, dword ptr [rcx]{1to16}
// CHECK:  encoding: [0x62,0x62,0x15,0x50,0x46,0x29]
          vpsravd zmm29, zmm29, dword ptr [rcx]{1to16}

// CHECK: vpsravd zmm29, zmm29, zmmword ptr [rdx + 8128]
// CHECK:  encoding: [0x62,0x62,0x15,0x40,0x46,0x6a,0x7f]
          vpsravd zmm29, zmm29, zmmword ptr [rdx + 8128]

// CHECK: vpsravd zmm29, zmm29, zmmword ptr [rdx + 8192]
// CHECK:  encoding: [0x62,0x62,0x15,0x40,0x46,0xaa,0x00,0x20,0x00,0x00]
          vpsravd zmm29, zmm29, zmmword ptr [rdx + 8192]

// CHECK: vpsravd zmm29, zmm29, zmmword ptr [rdx - 8192]
// CHECK:  encoding: [0x62,0x62,0x15,0x40,0x46,0x6a,0x80]
          vpsravd zmm29, zmm29, zmmword ptr [rdx - 8192]

// CHECK: vpsravd zmm29, zmm29, zmmword ptr [rdx - 8256]
// CHECK:  encoding: [0x62,0x62,0x15,0x40,0x46,0xaa,0xc0,0xdf,0xff,0xff]
          vpsravd zmm29, zmm29, zmmword ptr [rdx - 8256]

// CHECK: vpsravd zmm29, zmm29, dword ptr [rdx + 508]{1to16}
// CHECK:  encoding: [0x62,0x62,0x15,0x50,0x46,0x6a,0x7f]
          vpsravd zmm29, zmm29, dword ptr [rdx + 508]{1to16}

// CHECK: vpsravd zmm29, zmm29, dword ptr [rdx + 512]{1to16}
// CHECK:  encoding: [0x62,0x62,0x15,0x50,0x46,0xaa,0x00,0x02,0x00,0x00]
          vpsravd zmm29, zmm29, dword ptr [rdx + 512]{1to16}

// CHECK: vpsravd zmm29, zmm29, dword ptr [rdx - 512]{1to16}
// CHECK:  encoding: [0x62,0x62,0x15,0x50,0x46,0x6a,0x80]
          vpsravd zmm29, zmm29, dword ptr [rdx - 512]{1to16}

// CHECK: vpsravd zmm29, zmm29, dword ptr [rdx - 516]{1to16}
// CHECK:  encoding: [0x62,0x62,0x15,0x50,0x46,0xaa,0xfc,0xfd,0xff,0xff]
          vpsravd zmm29, zmm29, dword ptr [rdx - 516]{1to16}

// CHECK: vpsravq zmm22, zmm20, zmm2
// CHECK:  encoding: [0x62,0xe2,0xdd,0x40,0x46,0xf2]
          vpsravq zmm22, zmm20, zmm2

// CHECK: vpsravq zmm22 {k2}, zmm20, zmm2
// CHECK:  encoding: [0x62,0xe2,0xdd,0x42,0x46,0xf2]
          vpsravq zmm22 {k2}, zmm20, zmm2

// CHECK: vpsravq zmm22 {k2} {z}, zmm20, zmm2
// CHECK:  encoding: [0x62,0xe2,0xdd,0xc2,0x46,0xf2]
          vpsravq zmm22 {k2} {z}, zmm20, zmm2

// CHECK: vpsravq zmm22, zmm20, zmmword ptr [rcx]
// CHECK:  encoding: [0x62,0xe2,0xdd,0x40,0x46,0x31]
          vpsravq zmm22, zmm20, zmmword ptr [rcx]

// CHECK: vpsravq zmm22, zmm20, zmmword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0xa2,0xdd,0x40,0x46,0xb4,0xf0,0x23,0x01,0x00,0x00]
          vpsravq zmm22, zmm20, zmmword ptr [rax + 8*r14 + 291]

// CHECK: vpsravq zmm22, zmm20, qword ptr [rcx]{1to8}
// CHECK:  encoding: [0x62,0xe2,0xdd,0x50,0x46,0x31]
          vpsravq zmm22, zmm20, qword ptr [rcx]{1to8}

// CHECK: vpsravq zmm22, zmm20, zmmword ptr [rdx + 8128]
// CHECK:  encoding: [0x62,0xe2,0xdd,0x40,0x46,0x72,0x7f]
          vpsravq zmm22, zmm20, zmmword ptr [rdx + 8128]

// CHECK: vpsravq zmm22, zmm20, zmmword ptr [rdx + 8192]
// CHECK:  encoding: [0x62,0xe2,0xdd,0x40,0x46,0xb2,0x00,0x20,0x00,0x00]
          vpsravq zmm22, zmm20, zmmword ptr [rdx + 8192]

// CHECK: vpsravq zmm22, zmm20, zmmword ptr [rdx - 8192]
// CHECK:  encoding: [0x62,0xe2,0xdd,0x40,0x46,0x72,0x80]
          vpsravq zmm22, zmm20, zmmword ptr [rdx - 8192]

// CHECK: vpsravq zmm22, zmm20, zmmword ptr [rdx - 8256]
// CHECK:  encoding: [0x62,0xe2,0xdd,0x40,0x46,0xb2,0xc0,0xdf,0xff,0xff]
          vpsravq zmm22, zmm20, zmmword ptr [rdx - 8256]

// CHECK: vpsravq zmm22, zmm20, qword ptr [rdx + 1016]{1to8}
// CHECK:  encoding: [0x62,0xe2,0xdd,0x50,0x46,0x72,0x7f]
          vpsravq zmm22, zmm20, qword ptr [rdx + 1016]{1to8}

// CHECK: vpsravq zmm22, zmm20, qword ptr [rdx + 1024]{1to8}
// CHECK:  encoding: [0x62,0xe2,0xdd,0x50,0x46,0xb2,0x00,0x04,0x00,0x00]
          vpsravq zmm22, zmm20, qword ptr [rdx + 1024]{1to8}

// CHECK: vpsravq zmm22, zmm20, qword ptr [rdx - 1024]{1to8}
// CHECK:  encoding: [0x62,0xe2,0xdd,0x50,0x46,0x72,0x80]
          vpsravq zmm22, zmm20, qword ptr [rdx - 1024]{1to8}

// CHECK: vpsravq zmm22, zmm20, qword ptr [rdx - 1032]{1to8}
// CHECK:  encoding: [0x62,0xe2,0xdd,0x50,0x46,0xb2,0xf8,0xfb,0xff,0xff]
          vpsravq zmm22, zmm20, qword ptr [rdx - 1032]{1to8}

// CHECK: vpsrld zmm1, zmm17, xmm25
// CHECK:  encoding: [0x62,0x91,0x75,0x40,0xd2,0xc9]
          vpsrld zmm1, zmm17, xmm25

// CHECK: vpsrld zmm1 {k4}, zmm17, xmm25
// CHECK:  encoding: [0x62,0x91,0x75,0x44,0xd2,0xc9]
          vpsrld zmm1 {k4}, zmm17, xmm25

// CHECK: vpsrld zmm1 {k4} {z}, zmm17, xmm25
// CHECK:  encoding: [0x62,0x91,0x75,0xc4,0xd2,0xc9]
          vpsrld zmm1 {k4} {z}, zmm17, xmm25

// CHECK: vpsrld zmm1, zmm17, xmmword ptr [rcx]
// CHECK:  encoding: [0x62,0xf1,0x75,0x40,0xd2,0x09]
          vpsrld zmm1, zmm17, xmmword ptr [rcx]

// CHECK: vpsrld zmm1, zmm17, xmmword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0xb1,0x75,0x40,0xd2,0x8c,0xf0,0x23,0x01,0x00,0x00]
          vpsrld zmm1, zmm17, xmmword ptr [rax + 8*r14 + 291]

// CHECK: vpsrld zmm1, zmm17, xmmword ptr [rdx + 2032]
// CHECK:  encoding: [0x62,0xf1,0x75,0x40,0xd2,0x4a,0x7f]
          vpsrld zmm1, zmm17, xmmword ptr [rdx + 2032]

// CHECK: vpsrld zmm1, zmm17, xmmword ptr [rdx + 2048]
// CHECK:  encoding: [0x62,0xf1,0x75,0x40,0xd2,0x8a,0x00,0x08,0x00,0x00]
          vpsrld zmm1, zmm17, xmmword ptr [rdx + 2048]

// CHECK: vpsrld zmm1, zmm17, xmmword ptr [rdx - 2048]
// CHECK:  encoding: [0x62,0xf1,0x75,0x40,0xd2,0x4a,0x80]
          vpsrld zmm1, zmm17, xmmword ptr [rdx - 2048]

// CHECK: vpsrld zmm1, zmm17, xmmword ptr [rdx - 2064]
// CHECK:  encoding: [0x62,0xf1,0x75,0x40,0xd2,0x8a,0xf0,0xf7,0xff,0xff]
          vpsrld zmm1, zmm17, xmmword ptr [rdx - 2064]

// CHECK: vpsrlq zmm9, zmm11, xmm3
// CHECK:  encoding: [0x62,0x71,0xa5,0x48,0xd3,0xcb]
          vpsrlq zmm9, zmm11, xmm3

// CHECK: vpsrlq zmm9 {k5}, zmm11, xmm3
// CHECK:  encoding: [0x62,0x71,0xa5,0x4d,0xd3,0xcb]
          vpsrlq zmm9 {k5}, zmm11, xmm3

// CHECK: vpsrlq zmm9 {k5} {z}, zmm11, xmm3
// CHECK:  encoding: [0x62,0x71,0xa5,0xcd,0xd3,0xcb]
          vpsrlq zmm9 {k5} {z}, zmm11, xmm3

// CHECK: vpsrlq zmm9, zmm11, xmmword ptr [rcx]
// CHECK:  encoding: [0x62,0x71,0xa5,0x48,0xd3,0x09]
          vpsrlq zmm9, zmm11, xmmword ptr [rcx]

// CHECK: vpsrlq zmm9, zmm11, xmmword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0x31,0xa5,0x48,0xd3,0x8c,0xf0,0x23,0x01,0x00,0x00]
          vpsrlq zmm9, zmm11, xmmword ptr [rax + 8*r14 + 291]

// CHECK: vpsrlq zmm9, zmm11, xmmword ptr [rdx + 2032]
// CHECK:  encoding: [0x62,0x71,0xa5,0x48,0xd3,0x4a,0x7f]
          vpsrlq zmm9, zmm11, xmmword ptr [rdx + 2032]

// CHECK: vpsrlq zmm9, zmm11, xmmword ptr [rdx + 2048]
// CHECK:  encoding: [0x62,0x71,0xa5,0x48,0xd3,0x8a,0x00,0x08,0x00,0x00]
          vpsrlq zmm9, zmm11, xmmword ptr [rdx + 2048]

// CHECK: vpsrlq zmm9, zmm11, xmmword ptr [rdx - 2048]
// CHECK:  encoding: [0x62,0x71,0xa5,0x48,0xd3,0x4a,0x80]
          vpsrlq zmm9, zmm11, xmmword ptr [rdx - 2048]

// CHECK: vpsrlq zmm9, zmm11, xmmword ptr [rdx - 2064]
// CHECK:  encoding: [0x62,0x71,0xa5,0x48,0xd3,0x8a,0xf0,0xf7,0xff,0xff]
          vpsrlq zmm9, zmm11, xmmword ptr [rdx - 2064]

// CHECK: vpsrlvd zmm8, zmm14, zmm28
// CHECK:  encoding: [0x62,0x12,0x0d,0x48,0x45,0xc4]
          vpsrlvd zmm8, zmm14, zmm28

// CHECK: vpsrlvd zmm8 {k4}, zmm14, zmm28
// CHECK:  encoding: [0x62,0x12,0x0d,0x4c,0x45,0xc4]
          vpsrlvd zmm8 {k4}, zmm14, zmm28

// CHECK: vpsrlvd zmm8 {k4} {z}, zmm14, zmm28
// CHECK:  encoding: [0x62,0x12,0x0d,0xcc,0x45,0xc4]
          vpsrlvd zmm8 {k4} {z}, zmm14, zmm28

// CHECK: vpsrlvd zmm8, zmm14, zmmword ptr [rcx]
// CHECK:  encoding: [0x62,0x72,0x0d,0x48,0x45,0x01]
          vpsrlvd zmm8, zmm14, zmmword ptr [rcx]

// CHECK: vpsrlvd zmm8, zmm14, zmmword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0x32,0x0d,0x48,0x45,0x84,0xf0,0x23,0x01,0x00,0x00]
          vpsrlvd zmm8, zmm14, zmmword ptr [rax + 8*r14 + 291]

// CHECK: vpsrlvd zmm8, zmm14, dword ptr [rcx]{1to16}
// CHECK:  encoding: [0x62,0x72,0x0d,0x58,0x45,0x01]
          vpsrlvd zmm8, zmm14, dword ptr [rcx]{1to16}

// CHECK: vpsrlvd zmm8, zmm14, zmmword ptr [rdx + 8128]
// CHECK:  encoding: [0x62,0x72,0x0d,0x48,0x45,0x42,0x7f]
          vpsrlvd zmm8, zmm14, zmmword ptr [rdx + 8128]

// CHECK: vpsrlvd zmm8, zmm14, zmmword ptr [rdx + 8192]
// CHECK:  encoding: [0x62,0x72,0x0d,0x48,0x45,0x82,0x00,0x20,0x00,0x00]
          vpsrlvd zmm8, zmm14, zmmword ptr [rdx + 8192]

// CHECK: vpsrlvd zmm8, zmm14, zmmword ptr [rdx - 8192]
// CHECK:  encoding: [0x62,0x72,0x0d,0x48,0x45,0x42,0x80]
          vpsrlvd zmm8, zmm14, zmmword ptr [rdx - 8192]

// CHECK: vpsrlvd zmm8, zmm14, zmmword ptr [rdx - 8256]
// CHECK:  encoding: [0x62,0x72,0x0d,0x48,0x45,0x82,0xc0,0xdf,0xff,0xff]
          vpsrlvd zmm8, zmm14, zmmword ptr [rdx - 8256]

// CHECK: vpsrlvd zmm8, zmm14, dword ptr [rdx + 508]{1to16}
// CHECK:  encoding: [0x62,0x72,0x0d,0x58,0x45,0x42,0x7f]
          vpsrlvd zmm8, zmm14, dword ptr [rdx + 508]{1to16}

// CHECK: vpsrlvd zmm8, zmm14, dword ptr [rdx + 512]{1to16}
// CHECK:  encoding: [0x62,0x72,0x0d,0x58,0x45,0x82,0x00,0x02,0x00,0x00]
          vpsrlvd zmm8, zmm14, dword ptr [rdx + 512]{1to16}

// CHECK: vpsrlvd zmm8, zmm14, dword ptr [rdx - 512]{1to16}
// CHECK:  encoding: [0x62,0x72,0x0d,0x58,0x45,0x42,0x80]
          vpsrlvd zmm8, zmm14, dword ptr [rdx - 512]{1to16}

// CHECK: vpsrlvd zmm8, zmm14, dword ptr [rdx - 516]{1to16}
// CHECK:  encoding: [0x62,0x72,0x0d,0x58,0x45,0x82,0xfc,0xfd,0xff,0xff]
          vpsrlvd zmm8, zmm14, dword ptr [rdx - 516]{1to16}

// CHECK: vpsrlvq zmm20, zmm7, zmm26
// CHECK:  encoding: [0x62,0x82,0xc5,0x48,0x45,0xe2]
          vpsrlvq zmm20, zmm7, zmm26

// CHECK: vpsrlvq zmm20 {k5}, zmm7, zmm26
// CHECK:  encoding: [0x62,0x82,0xc5,0x4d,0x45,0xe2]
          vpsrlvq zmm20 {k5}, zmm7, zmm26

// CHECK: vpsrlvq zmm20 {k5} {z}, zmm7, zmm26
// CHECK:  encoding: [0x62,0x82,0xc5,0xcd,0x45,0xe2]
          vpsrlvq zmm20 {k5} {z}, zmm7, zmm26

// CHECK: vpsrlvq zmm20, zmm7, zmmword ptr [rcx]
// CHECK:  encoding: [0x62,0xe2,0xc5,0x48,0x45,0x21]
          vpsrlvq zmm20, zmm7, zmmword ptr [rcx]

// CHECK: vpsrlvq zmm20, zmm7, zmmword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0xa2,0xc5,0x48,0x45,0xa4,0xf0,0x23,0x01,0x00,0x00]
          vpsrlvq zmm20, zmm7, zmmword ptr [rax + 8*r14 + 291]

// CHECK: vpsrlvq zmm20, zmm7, qword ptr [rcx]{1to8}
// CHECK:  encoding: [0x62,0xe2,0xc5,0x58,0x45,0x21]
          vpsrlvq zmm20, zmm7, qword ptr [rcx]{1to8}

// CHECK: vpsrlvq zmm20, zmm7, zmmword ptr [rdx + 8128]
// CHECK:  encoding: [0x62,0xe2,0xc5,0x48,0x45,0x62,0x7f]
          vpsrlvq zmm20, zmm7, zmmword ptr [rdx + 8128]

// CHECK: vpsrlvq zmm20, zmm7, zmmword ptr [rdx + 8192]
// CHECK:  encoding: [0x62,0xe2,0xc5,0x48,0x45,0xa2,0x00,0x20,0x00,0x00]
          vpsrlvq zmm20, zmm7, zmmword ptr [rdx + 8192]

// CHECK: vpsrlvq zmm20, zmm7, zmmword ptr [rdx - 8192]
// CHECK:  encoding: [0x62,0xe2,0xc5,0x48,0x45,0x62,0x80]
          vpsrlvq zmm20, zmm7, zmmword ptr [rdx - 8192]

// CHECK: vpsrlvq zmm20, zmm7, zmmword ptr [rdx - 8256]
// CHECK:  encoding: [0x62,0xe2,0xc5,0x48,0x45,0xa2,0xc0,0xdf,0xff,0xff]
          vpsrlvq zmm20, zmm7, zmmword ptr [rdx - 8256]

// CHECK: vpsrlvq zmm20, zmm7, qword ptr [rdx + 1016]{1to8}
// CHECK:  encoding: [0x62,0xe2,0xc5,0x58,0x45,0x62,0x7f]
          vpsrlvq zmm20, zmm7, qword ptr [rdx + 1016]{1to8}

// CHECK: vpsrlvq zmm20, zmm7, qword ptr [rdx + 1024]{1to8}
// CHECK:  encoding: [0x62,0xe2,0xc5,0x58,0x45,0xa2,0x00,0x04,0x00,0x00]
          vpsrlvq zmm20, zmm7, qword ptr [rdx + 1024]{1to8}

// CHECK: vpsrlvq zmm20, zmm7, qword ptr [rdx - 1024]{1to8}
// CHECK:  encoding: [0x62,0xe2,0xc5,0x58,0x45,0x62,0x80]
          vpsrlvq zmm20, zmm7, qword ptr [rdx - 1024]{1to8}

// CHECK: vpsrlvq zmm20, zmm7, qword ptr [rdx - 1032]{1to8}
// CHECK:  encoding: [0x62,0xe2,0xc5,0x58,0x45,0xa2,0xf8,0xfb,0xff,0xff]
          vpsrlvq zmm20, zmm7, qword ptr [rdx - 1032]{1to8}

// CHECK: vpsrld zmm3, zmm5, 171
// CHECK:  encoding: [0x62,0xf1,0x65,0x48,0x72,0xd5,0xab]
          vpsrld zmm3, zmm5, 171

// CHECK: vpsrld zmm3 {k4}, zmm5, 171
// CHECK:  encoding: [0x62,0xf1,0x65,0x4c,0x72,0xd5,0xab]
          vpsrld zmm3 {k4}, zmm5, 171

// CHECK: vpsrld zmm3 {k4} {z}, zmm5, 171
// CHECK:  encoding: [0x62,0xf1,0x65,0xcc,0x72,0xd5,0xab]
          vpsrld zmm3 {k4} {z}, zmm5, 171

// CHECK: vpsrld zmm3, zmm5, 123
// CHECK:  encoding: [0x62,0xf1,0x65,0x48,0x72,0xd5,0x7b]
          vpsrld zmm3, zmm5, 123

// CHECK: vpsrld zmm3, zmmword ptr [rcx], 123
// CHECK:  encoding: [0x62,0xf1,0x65,0x48,0x72,0x11,0x7b]
          vpsrld zmm3, zmmword ptr [rcx], 123

// CHECK: vpsrld zmm3, zmmword ptr [rax + 8*r14 + 291], 123
// CHECK:  encoding: [0x62,0xb1,0x65,0x48,0x72,0x94,0xf0,0x23,0x01,0x00,0x00,0x7b]
          vpsrld zmm3, zmmword ptr [rax + 8*r14 + 291], 123

// CHECK: vpsrld zmm3, dword ptr [rcx]{1to16}, 123
// CHECK:  encoding: [0x62,0xf1,0x65,0x58,0x72,0x11,0x7b]
          vpsrld zmm3, dword ptr [rcx]{1to16}, 123

// CHECK: vpsrld zmm3, zmmword ptr [rdx + 8128], 123
// CHECK:  encoding: [0x62,0xf1,0x65,0x48,0x72,0x52,0x7f,0x7b]
          vpsrld zmm3, zmmword ptr [rdx + 8128], 123

// CHECK: vpsrld zmm3, zmmword ptr [rdx + 8192], 123
// CHECK:  encoding: [0x62,0xf1,0x65,0x48,0x72,0x92,0x00,0x20,0x00,0x00,0x7b]
          vpsrld zmm3, zmmword ptr [rdx + 8192], 123

// CHECK: vpsrld zmm3, zmmword ptr [rdx - 8192], 123
// CHECK:  encoding: [0x62,0xf1,0x65,0x48,0x72,0x52,0x80,0x7b]
          vpsrld zmm3, zmmword ptr [rdx - 8192], 123

// CHECK: vpsrld zmm3, zmmword ptr [rdx - 8256], 123
// CHECK:  encoding: [0x62,0xf1,0x65,0x48,0x72,0x92,0xc0,0xdf,0xff,0xff,0x7b]
          vpsrld zmm3, zmmword ptr [rdx - 8256], 123

// CHECK: vpsrld zmm3, dword ptr [rdx + 508]{1to16}, 123
// CHECK:  encoding: [0x62,0xf1,0x65,0x58,0x72,0x52,0x7f,0x7b]
          vpsrld zmm3, dword ptr [rdx + 508]{1to16}, 123

// CHECK: vpsrld zmm3, dword ptr [rdx + 512]{1to16}, 123
// CHECK:  encoding: [0x62,0xf1,0x65,0x58,0x72,0x92,0x00,0x02,0x00,0x00,0x7b]
          vpsrld zmm3, dword ptr [rdx + 512]{1to16}, 123

// CHECK: vpsrld zmm3, dword ptr [rdx - 512]{1to16}, 123
// CHECK:  encoding: [0x62,0xf1,0x65,0x58,0x72,0x52,0x80,0x7b]
          vpsrld zmm3, dword ptr [rdx - 512]{1to16}, 123

// CHECK: vpsrld zmm3, dword ptr [rdx - 516]{1to16}, 123
// CHECK:  encoding: [0x62,0xf1,0x65,0x58,0x72,0x92,0xfc,0xfd,0xff,0xff,0x7b]
          vpsrld zmm3, dword ptr [rdx - 516]{1to16}, 123

// CHECK: vpsrlq zmm18, zmm25, 171
// CHECK:  encoding: [0x62,0x91,0xed,0x40,0x73,0xd1,0xab]
          vpsrlq zmm18, zmm25, 171

// CHECK: vpsrlq zmm18 {k1}, zmm25, 171
// CHECK:  encoding: [0x62,0x91,0xed,0x41,0x73,0xd1,0xab]
          vpsrlq zmm18 {k1}, zmm25, 171

// CHECK: vpsrlq zmm18 {k1} {z}, zmm25, 171
// CHECK:  encoding: [0x62,0x91,0xed,0xc1,0x73,0xd1,0xab]
          vpsrlq zmm18 {k1} {z}, zmm25, 171

// CHECK: vpsrlq zmm18, zmm25, 123
// CHECK:  encoding: [0x62,0x91,0xed,0x40,0x73,0xd1,0x7b]
          vpsrlq zmm18, zmm25, 123

// CHECK: vpsrlq zmm18, zmmword ptr [rcx], 123
// CHECK:  encoding: [0x62,0xf1,0xed,0x40,0x73,0x11,0x7b]
          vpsrlq zmm18, zmmword ptr [rcx], 123

// CHECK: vpsrlq zmm18, zmmword ptr [rax + 8*r14 + 291], 123
// CHECK:  encoding: [0x62,0xb1,0xed,0x40,0x73,0x94,0xf0,0x23,0x01,0x00,0x00,0x7b]
          vpsrlq zmm18, zmmword ptr [rax + 8*r14 + 291], 123

// CHECK: vpsrlq zmm18, qword ptr [rcx]{1to8}, 123
// CHECK:  encoding: [0x62,0xf1,0xed,0x50,0x73,0x11,0x7b]
          vpsrlq zmm18, qword ptr [rcx]{1to8}, 123

// CHECK: vpsrlq zmm18, zmmword ptr [rdx + 8128], 123
// CHECK:  encoding: [0x62,0xf1,0xed,0x40,0x73,0x52,0x7f,0x7b]
          vpsrlq zmm18, zmmword ptr [rdx + 8128], 123

// CHECK: vpsrlq zmm18, zmmword ptr [rdx + 8192], 123
// CHECK:  encoding: [0x62,0xf1,0xed,0x40,0x73,0x92,0x00,0x20,0x00,0x00,0x7b]
          vpsrlq zmm18, zmmword ptr [rdx + 8192], 123

// CHECK: vpsrlq zmm18, zmmword ptr [rdx - 8192], 123
// CHECK:  encoding: [0x62,0xf1,0xed,0x40,0x73,0x52,0x80,0x7b]
          vpsrlq zmm18, zmmword ptr [rdx - 8192], 123

// CHECK: vpsrlq zmm18, zmmword ptr [rdx - 8256], 123
// CHECK:  encoding: [0x62,0xf1,0xed,0x40,0x73,0x92,0xc0,0xdf,0xff,0xff,0x7b]
          vpsrlq zmm18, zmmword ptr [rdx - 8256], 123

// CHECK: vpsrlq zmm18, qword ptr [rdx + 1016]{1to8}, 123
// CHECK:  encoding: [0x62,0xf1,0xed,0x50,0x73,0x52,0x7f,0x7b]
          vpsrlq zmm18, qword ptr [rdx + 1016]{1to8}, 123

// CHECK: vpsrlq zmm18, qword ptr [rdx + 1024]{1to8}, 123
// CHECK:  encoding: [0x62,0xf1,0xed,0x50,0x73,0x92,0x00,0x04,0x00,0x00,0x7b]
          vpsrlq zmm18, qword ptr [rdx + 1024]{1to8}, 123

// CHECK: vpsrlq zmm18, qword ptr [rdx - 1024]{1to8}, 123
// CHECK:  encoding: [0x62,0xf1,0xed,0x50,0x73,0x52,0x80,0x7b]
          vpsrlq zmm18, qword ptr [rdx - 1024]{1to8}, 123

// CHECK: vpsrlq zmm18, qword ptr [rdx - 1032]{1to8}, 123
// CHECK:  encoding: [0x62,0xf1,0xed,0x50,0x73,0x92,0xf8,0xfb,0xff,0xff,0x7b]
          vpsrlq zmm18, qword ptr [rdx - 1032]{1to8}, 123

// CHECK: vpsubd zmm7, zmm28, zmm7
// CHECK:  encoding: [0x62,0xf1,0x1d,0x40,0xfa,0xff]
          vpsubd zmm7, zmm28, zmm7

// CHECK: vpsubd zmm7 {k3}, zmm28, zmm7
// CHECK:  encoding: [0x62,0xf1,0x1d,0x43,0xfa,0xff]
          vpsubd zmm7 {k3}, zmm28, zmm7

// CHECK: vpsubd zmm7 {k3} {z}, zmm28, zmm7
// CHECK:  encoding: [0x62,0xf1,0x1d,0xc3,0xfa,0xff]
          vpsubd zmm7 {k3} {z}, zmm28, zmm7

// CHECK: vpsubd zmm7, zmm28, zmmword ptr [rcx]
// CHECK:  encoding: [0x62,0xf1,0x1d,0x40,0xfa,0x39]
          vpsubd zmm7, zmm28, zmmword ptr [rcx]

// CHECK: vpsubd zmm7, zmm28, zmmword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0xb1,0x1d,0x40,0xfa,0xbc,0xf0,0x23,0x01,0x00,0x00]
          vpsubd zmm7, zmm28, zmmword ptr [rax + 8*r14 + 291]

// CHECK: vpsubd zmm7, zmm28, dword ptr [rcx]{1to16}
// CHECK:  encoding: [0x62,0xf1,0x1d,0x50,0xfa,0x39]
          vpsubd zmm7, zmm28, dword ptr [rcx]{1to16}

// CHECK: vpsubd zmm7, zmm28, zmmword ptr [rdx + 8128]
// CHECK:  encoding: [0x62,0xf1,0x1d,0x40,0xfa,0x7a,0x7f]
          vpsubd zmm7, zmm28, zmmword ptr [rdx + 8128]

// CHECK: vpsubd zmm7, zmm28, zmmword ptr [rdx + 8192]
// CHECK:  encoding: [0x62,0xf1,0x1d,0x40,0xfa,0xba,0x00,0x20,0x00,0x00]
          vpsubd zmm7, zmm28, zmmword ptr [rdx + 8192]

// CHECK: vpsubd zmm7, zmm28, zmmword ptr [rdx - 8192]
// CHECK:  encoding: [0x62,0xf1,0x1d,0x40,0xfa,0x7a,0x80]
          vpsubd zmm7, zmm28, zmmword ptr [rdx - 8192]

// CHECK: vpsubd zmm7, zmm28, zmmword ptr [rdx - 8256]
// CHECK:  encoding: [0x62,0xf1,0x1d,0x40,0xfa,0xba,0xc0,0xdf,0xff,0xff]
          vpsubd zmm7, zmm28, zmmword ptr [rdx - 8256]

// CHECK: vpsubd zmm7, zmm28, dword ptr [rdx + 508]{1to16}
// CHECK:  encoding: [0x62,0xf1,0x1d,0x50,0xfa,0x7a,0x7f]
          vpsubd zmm7, zmm28, dword ptr [rdx + 508]{1to16}

// CHECK: vpsubd zmm7, zmm28, dword ptr [rdx + 512]{1to16}
// CHECK:  encoding: [0x62,0xf1,0x1d,0x50,0xfa,0xba,0x00,0x02,0x00,0x00]
          vpsubd zmm7, zmm28, dword ptr [rdx + 512]{1to16}

// CHECK: vpsubd zmm7, zmm28, dword ptr [rdx - 512]{1to16}
// CHECK:  encoding: [0x62,0xf1,0x1d,0x50,0xfa,0x7a,0x80]
          vpsubd zmm7, zmm28, dword ptr [rdx - 512]{1to16}

// CHECK: vpsubd zmm7, zmm28, dword ptr [rdx - 516]{1to16}
// CHECK:  encoding: [0x62,0xf1,0x1d,0x50,0xfa,0xba,0xfc,0xfd,0xff,0xff]
          vpsubd zmm7, zmm28, dword ptr [rdx - 516]{1to16}

// CHECK: vpsubq zmm29, zmm28, zmm17
// CHECK:  encoding: [0x62,0x21,0x9d,0x40,0xfb,0xe9]
          vpsubq zmm29, zmm28, zmm17

// CHECK: vpsubq zmm29 {k2}, zmm28, zmm17
// CHECK:  encoding: [0x62,0x21,0x9d,0x42,0xfb,0xe9]
          vpsubq zmm29 {k2}, zmm28, zmm17

// CHECK: vpsubq zmm29 {k2} {z}, zmm28, zmm17
// CHECK:  encoding: [0x62,0x21,0x9d,0xc2,0xfb,0xe9]
          vpsubq zmm29 {k2} {z}, zmm28, zmm17

// CHECK: vpsubq zmm29, zmm28, zmmword ptr [rcx]
// CHECK:  encoding: [0x62,0x61,0x9d,0x40,0xfb,0x29]
          vpsubq zmm29, zmm28, zmmword ptr [rcx]

// CHECK: vpsubq zmm29, zmm28, zmmword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0x21,0x9d,0x40,0xfb,0xac,0xf0,0x23,0x01,0x00,0x00]
          vpsubq zmm29, zmm28, zmmword ptr [rax + 8*r14 + 291]

// CHECK: vpsubq zmm29, zmm28, qword ptr [rcx]{1to8}
// CHECK:  encoding: [0x62,0x61,0x9d,0x50,0xfb,0x29]
          vpsubq zmm29, zmm28, qword ptr [rcx]{1to8}

// CHECK: vpsubq zmm29, zmm28, zmmword ptr [rdx + 8128]
// CHECK:  encoding: [0x62,0x61,0x9d,0x40,0xfb,0x6a,0x7f]
          vpsubq zmm29, zmm28, zmmword ptr [rdx + 8128]

// CHECK: vpsubq zmm29, zmm28, zmmword ptr [rdx + 8192]
// CHECK:  encoding: [0x62,0x61,0x9d,0x40,0xfb,0xaa,0x00,0x20,0x00,0x00]
          vpsubq zmm29, zmm28, zmmword ptr [rdx + 8192]

// CHECK: vpsubq zmm29, zmm28, zmmword ptr [rdx - 8192]
// CHECK:  encoding: [0x62,0x61,0x9d,0x40,0xfb,0x6a,0x80]
          vpsubq zmm29, zmm28, zmmword ptr [rdx - 8192]

// CHECK: vpsubq zmm29, zmm28, zmmword ptr [rdx - 8256]
// CHECK:  encoding: [0x62,0x61,0x9d,0x40,0xfb,0xaa,0xc0,0xdf,0xff,0xff]
          vpsubq zmm29, zmm28, zmmword ptr [rdx - 8256]

// CHECK: vpsubq zmm29, zmm28, qword ptr [rdx + 1016]{1to8}
// CHECK:  encoding: [0x62,0x61,0x9d,0x50,0xfb,0x6a,0x7f]
          vpsubq zmm29, zmm28, qword ptr [rdx + 1016]{1to8}

// CHECK: vpsubq zmm29, zmm28, qword ptr [rdx + 1024]{1to8}
// CHECK:  encoding: [0x62,0x61,0x9d,0x50,0xfb,0xaa,0x00,0x04,0x00,0x00]
          vpsubq zmm29, zmm28, qword ptr [rdx + 1024]{1to8}

// CHECK: vpsubq zmm29, zmm28, qword ptr [rdx - 1024]{1to8}
// CHECK:  encoding: [0x62,0x61,0x9d,0x50,0xfb,0x6a,0x80]
          vpsubq zmm29, zmm28, qword ptr [rdx - 1024]{1to8}

// CHECK: vpsubq zmm29, zmm28, qword ptr [rdx - 1032]{1to8}
// CHECK:  encoding: [0x62,0x61,0x9d,0x50,0xfb,0xaa,0xf8,0xfb,0xff,0xff]
          vpsubq zmm29, zmm28, qword ptr [rdx - 1032]{1to8}

// CHECK: vptestmd k2, zmm12, zmm16
// CHECK:  encoding: [0x62,0xb2,0x1d,0x48,0x27,0xd0]
          vptestmd k2, zmm12, zmm16

// CHECK: vptestmd k2 {k1}, zmm12, zmm16
// CHECK:  encoding: [0x62,0xb2,0x1d,0x49,0x27,0xd0]
          vptestmd k2 {k1}, zmm12, zmm16

// CHECK: vptestmd k2, zmm12, zmmword ptr [rcx]
// CHECK:  encoding: [0x62,0xf2,0x1d,0x48,0x27,0x11]
          vptestmd k2, zmm12, zmmword ptr [rcx]

// CHECK: vptestmd k2, zmm12, zmmword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0xb2,0x1d,0x48,0x27,0x94,0xf0,0x23,0x01,0x00,0x00]
          vptestmd k2, zmm12, zmmword ptr [rax + 8*r14 + 291]

// CHECK: vptestmd k2, zmm12, dword ptr [rcx]{1to16}
// CHECK:  encoding: [0x62,0xf2,0x1d,0x58,0x27,0x11]
          vptestmd k2, zmm12, dword ptr [rcx]{1to16}

// CHECK: vptestmd k2, zmm12, zmmword ptr [rdx + 8128]
// CHECK:  encoding: [0x62,0xf2,0x1d,0x48,0x27,0x52,0x7f]
          vptestmd k2, zmm12, zmmword ptr [rdx + 8128]

// CHECK: vptestmd k2, zmm12, zmmword ptr [rdx + 8192]
// CHECK:  encoding: [0x62,0xf2,0x1d,0x48,0x27,0x92,0x00,0x20,0x00,0x00]
          vptestmd k2, zmm12, zmmword ptr [rdx + 8192]

// CHECK: vptestmd k2, zmm12, zmmword ptr [rdx - 8192]
// CHECK:  encoding: [0x62,0xf2,0x1d,0x48,0x27,0x52,0x80]
          vptestmd k2, zmm12, zmmword ptr [rdx - 8192]

// CHECK: vptestmd k2, zmm12, zmmword ptr [rdx - 8256]
// CHECK:  encoding: [0x62,0xf2,0x1d,0x48,0x27,0x92,0xc0,0xdf,0xff,0xff]
          vptestmd k2, zmm12, zmmword ptr [rdx - 8256]

// CHECK: vptestmd k2, zmm12, dword ptr [rdx + 508]{1to16}
// CHECK:  encoding: [0x62,0xf2,0x1d,0x58,0x27,0x52,0x7f]
          vptestmd k2, zmm12, dword ptr [rdx + 508]{1to16}

// CHECK: vptestmd k2, zmm12, dword ptr [rdx + 512]{1to16}
// CHECK:  encoding: [0x62,0xf2,0x1d,0x58,0x27,0x92,0x00,0x02,0x00,0x00]
          vptestmd k2, zmm12, dword ptr [rdx + 512]{1to16}

// CHECK: vptestmd k2, zmm12, dword ptr [rdx - 512]{1to16}
// CHECK:  encoding: [0x62,0xf2,0x1d,0x58,0x27,0x52,0x80]
          vptestmd k2, zmm12, dword ptr [rdx - 512]{1to16}

// CHECK: vptestmd k2, zmm12, dword ptr [rdx - 516]{1to16}
// CHECK:  encoding: [0x62,0xf2,0x1d,0x58,0x27,0x92,0xfc,0xfd,0xff,0xff]
          vptestmd k2, zmm12, dword ptr [rdx - 516]{1to16}

// CHECK: vptestmq k5, zmm6, zmm21
// CHECK:  encoding: [0x62,0xb2,0xcd,0x48,0x27,0xed]
          vptestmq k5, zmm6, zmm21

// CHECK: vptestmq k5 {k5}, zmm6, zmm21
// CHECK:  encoding: [0x62,0xb2,0xcd,0x4d,0x27,0xed]
          vptestmq k5 {k5}, zmm6, zmm21

// CHECK: vptestmq k5, zmm6, zmmword ptr [rcx]
// CHECK:  encoding: [0x62,0xf2,0xcd,0x48,0x27,0x29]
          vptestmq k5, zmm6, zmmword ptr [rcx]

// CHECK: vptestmq k5, zmm6, zmmword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0xb2,0xcd,0x48,0x27,0xac,0xf0,0x23,0x01,0x00,0x00]
          vptestmq k5, zmm6, zmmword ptr [rax + 8*r14 + 291]

// CHECK: vptestmq k5, zmm6, qword ptr [rcx]{1to8}
// CHECK:  encoding: [0x62,0xf2,0xcd,0x58,0x27,0x29]
          vptestmq k5, zmm6, qword ptr [rcx]{1to8}

// CHECK: vptestmq k5, zmm6, zmmword ptr [rdx + 8128]
// CHECK:  encoding: [0x62,0xf2,0xcd,0x48,0x27,0x6a,0x7f]
          vptestmq k5, zmm6, zmmword ptr [rdx + 8128]

// CHECK: vptestmq k5, zmm6, zmmword ptr [rdx + 8192]
// CHECK:  encoding: [0x62,0xf2,0xcd,0x48,0x27,0xaa,0x00,0x20,0x00,0x00]
          vptestmq k5, zmm6, zmmword ptr [rdx + 8192]

// CHECK: vptestmq k5, zmm6, zmmword ptr [rdx - 8192]
// CHECK:  encoding: [0x62,0xf2,0xcd,0x48,0x27,0x6a,0x80]
          vptestmq k5, zmm6, zmmword ptr [rdx - 8192]

// CHECK: vptestmq k5, zmm6, zmmword ptr [rdx - 8256]
// CHECK:  encoding: [0x62,0xf2,0xcd,0x48,0x27,0xaa,0xc0,0xdf,0xff,0xff]
          vptestmq k5, zmm6, zmmword ptr [rdx - 8256]

// CHECK: vptestmq k5, zmm6, qword ptr [rdx + 1016]{1to8}
// CHECK:  encoding: [0x62,0xf2,0xcd,0x58,0x27,0x6a,0x7f]
          vptestmq k5, zmm6, qword ptr [rdx + 1016]{1to8}

// CHECK: vptestmq k5, zmm6, qword ptr [rdx + 1024]{1to8}
// CHECK:  encoding: [0x62,0xf2,0xcd,0x58,0x27,0xaa,0x00,0x04,0x00,0x00]
          vptestmq k5, zmm6, qword ptr [rdx + 1024]{1to8}

// CHECK: vptestmq k5, zmm6, qword ptr [rdx - 1024]{1to8}
// CHECK:  encoding: [0x62,0xf2,0xcd,0x58,0x27,0x6a,0x80]
          vptestmq k5, zmm6, qword ptr [rdx - 1024]{1to8}

// CHECK: vptestmq k5, zmm6, qword ptr [rdx - 1032]{1to8}
// CHECK:  encoding: [0x62,0xf2,0xcd,0x58,0x27,0xaa,0xf8,0xfb,0xff,0xff]
          vptestmq k5, zmm6, qword ptr [rdx - 1032]{1to8}

// CHECK: vpunpckhdq zmm6, zmm4, zmm13
// CHECK:  encoding: [0x62,0xd1,0x5d,0x48,0x6a,0xf5]
          vpunpckhdq zmm6, zmm4, zmm13

// CHECK: vpunpckhdq zmm6 {k5}, zmm4, zmm13
// CHECK:  encoding: [0x62,0xd1,0x5d,0x4d,0x6a,0xf5]
          vpunpckhdq zmm6 {k5}, zmm4, zmm13

// CHECK: vpunpckhdq zmm6 {k5} {z}, zmm4, zmm13
// CHECK:  encoding: [0x62,0xd1,0x5d,0xcd,0x6a,0xf5]
          vpunpckhdq zmm6 {k5} {z}, zmm4, zmm13

// CHECK: vpunpckhdq zmm6, zmm4, zmmword ptr [rcx]
// CHECK:  encoding: [0x62,0xf1,0x5d,0x48,0x6a,0x31]
          vpunpckhdq zmm6, zmm4, zmmword ptr [rcx]

// CHECK: vpunpckhdq zmm6, zmm4, zmmword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0xb1,0x5d,0x48,0x6a,0xb4,0xf0,0x23,0x01,0x00,0x00]
          vpunpckhdq zmm6, zmm4, zmmword ptr [rax + 8*r14 + 291]

// CHECK: vpunpckhdq zmm6, zmm4, dword ptr [rcx]{1to16}
// CHECK:  encoding: [0x62,0xf1,0x5d,0x58,0x6a,0x31]
          vpunpckhdq zmm6, zmm4, dword ptr [rcx]{1to16}

// CHECK: vpunpckhdq zmm6, zmm4, zmmword ptr [rdx + 8128]
// CHECK:  encoding: [0x62,0xf1,0x5d,0x48,0x6a,0x72,0x7f]
          vpunpckhdq zmm6, zmm4, zmmword ptr [rdx + 8128]

// CHECK: vpunpckhdq zmm6, zmm4, zmmword ptr [rdx + 8192]
// CHECK:  encoding: [0x62,0xf1,0x5d,0x48,0x6a,0xb2,0x00,0x20,0x00,0x00]
          vpunpckhdq zmm6, zmm4, zmmword ptr [rdx + 8192]

// CHECK: vpunpckhdq zmm6, zmm4, zmmword ptr [rdx - 8192]
// CHECK:  encoding: [0x62,0xf1,0x5d,0x48,0x6a,0x72,0x80]
          vpunpckhdq zmm6, zmm4, zmmword ptr [rdx - 8192]

// CHECK: vpunpckhdq zmm6, zmm4, zmmword ptr [rdx - 8256]
// CHECK:  encoding: [0x62,0xf1,0x5d,0x48,0x6a,0xb2,0xc0,0xdf,0xff,0xff]
          vpunpckhdq zmm6, zmm4, zmmword ptr [rdx - 8256]

// CHECK: vpunpckhdq zmm6, zmm4, dword ptr [rdx + 508]{1to16}
// CHECK:  encoding: [0x62,0xf1,0x5d,0x58,0x6a,0x72,0x7f]
          vpunpckhdq zmm6, zmm4, dword ptr [rdx + 508]{1to16}

// CHECK: vpunpckhdq zmm6, zmm4, dword ptr [rdx + 512]{1to16}
// CHECK:  encoding: [0x62,0xf1,0x5d,0x58,0x6a,0xb2,0x00,0x02,0x00,0x00]
          vpunpckhdq zmm6, zmm4, dword ptr [rdx + 512]{1to16}

// CHECK: vpunpckhdq zmm6, zmm4, dword ptr [rdx - 512]{1to16}
// CHECK:  encoding: [0x62,0xf1,0x5d,0x58,0x6a,0x72,0x80]
          vpunpckhdq zmm6, zmm4, dword ptr [rdx - 512]{1to16}

// CHECK: vpunpckhdq zmm6, zmm4, dword ptr [rdx - 516]{1to16}
// CHECK:  encoding: [0x62,0xf1,0x5d,0x58,0x6a,0xb2,0xfc,0xfd,0xff,0xff]
          vpunpckhdq zmm6, zmm4, dword ptr [rdx - 516]{1to16}

// CHECK: vpunpckhqdq zmm27, zmm15, zmm16
// CHECK:  encoding: [0x62,0x21,0x85,0x48,0x6d,0xd8]
          vpunpckhqdq zmm27, zmm15, zmm16

// CHECK: vpunpckhqdq zmm27 {k3}, zmm15, zmm16
// CHECK:  encoding: [0x62,0x21,0x85,0x4b,0x6d,0xd8]
          vpunpckhqdq zmm27 {k3}, zmm15, zmm16

// CHECK: vpunpckhqdq zmm27 {k3} {z}, zmm15, zmm16
// CHECK:  encoding: [0x62,0x21,0x85,0xcb,0x6d,0xd8]
          vpunpckhqdq zmm27 {k3} {z}, zmm15, zmm16

// CHECK: vpunpckhqdq zmm27, zmm15, zmmword ptr [rcx]
// CHECK:  encoding: [0x62,0x61,0x85,0x48,0x6d,0x19]
          vpunpckhqdq zmm27, zmm15, zmmword ptr [rcx]

// CHECK: vpunpckhqdq zmm27, zmm15, zmmword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0x21,0x85,0x48,0x6d,0x9c,0xf0,0x23,0x01,0x00,0x00]
          vpunpckhqdq zmm27, zmm15, zmmword ptr [rax + 8*r14 + 291]

// CHECK: vpunpckhqdq zmm27, zmm15, qword ptr [rcx]{1to8}
// CHECK:  encoding: [0x62,0x61,0x85,0x58,0x6d,0x19]
          vpunpckhqdq zmm27, zmm15, qword ptr [rcx]{1to8}

// CHECK: vpunpckhqdq zmm27, zmm15, zmmword ptr [rdx + 8128]
// CHECK:  encoding: [0x62,0x61,0x85,0x48,0x6d,0x5a,0x7f]
          vpunpckhqdq zmm27, zmm15, zmmword ptr [rdx + 8128]

// CHECK: vpunpckhqdq zmm27, zmm15, zmmword ptr [rdx + 8192]
// CHECK:  encoding: [0x62,0x61,0x85,0x48,0x6d,0x9a,0x00,0x20,0x00,0x00]
          vpunpckhqdq zmm27, zmm15, zmmword ptr [rdx + 8192]

// CHECK: vpunpckhqdq zmm27, zmm15, zmmword ptr [rdx - 8192]
// CHECK:  encoding: [0x62,0x61,0x85,0x48,0x6d,0x5a,0x80]
          vpunpckhqdq zmm27, zmm15, zmmword ptr [rdx - 8192]

// CHECK: vpunpckhqdq zmm27, zmm15, zmmword ptr [rdx - 8256]
// CHECK:  encoding: [0x62,0x61,0x85,0x48,0x6d,0x9a,0xc0,0xdf,0xff,0xff]
          vpunpckhqdq zmm27, zmm15, zmmword ptr [rdx - 8256]

// CHECK: vpunpckhqdq zmm27, zmm15, qword ptr [rdx + 1016]{1to8}
// CHECK:  encoding: [0x62,0x61,0x85,0x58,0x6d,0x5a,0x7f]
          vpunpckhqdq zmm27, zmm15, qword ptr [rdx + 1016]{1to8}

// CHECK: vpunpckhqdq zmm27, zmm15, qword ptr [rdx + 1024]{1to8}
// CHECK:  encoding: [0x62,0x61,0x85,0x58,0x6d,0x9a,0x00,0x04,0x00,0x00]
          vpunpckhqdq zmm27, zmm15, qword ptr [rdx + 1024]{1to8}

// CHECK: vpunpckhqdq zmm27, zmm15, qword ptr [rdx - 1024]{1to8}
// CHECK:  encoding: [0x62,0x61,0x85,0x58,0x6d,0x5a,0x80]
          vpunpckhqdq zmm27, zmm15, qword ptr [rdx - 1024]{1to8}

// CHECK: vpunpckhqdq zmm27, zmm15, qword ptr [rdx - 1032]{1to8}
// CHECK:  encoding: [0x62,0x61,0x85,0x58,0x6d,0x9a,0xf8,0xfb,0xff,0xff]
          vpunpckhqdq zmm27, zmm15, qword ptr [rdx - 1032]{1to8}

// CHECK: vpunpckldq zmm24, zmm3, zmm17
// CHECK:  encoding: [0x62,0x21,0x65,0x48,0x62,0xc1]
          vpunpckldq zmm24, zmm3, zmm17

// CHECK: vpunpckldq zmm24 {k3}, zmm3, zmm17
// CHECK:  encoding: [0x62,0x21,0x65,0x4b,0x62,0xc1]
          vpunpckldq zmm24 {k3}, zmm3, zmm17

// CHECK: vpunpckldq zmm24 {k3} {z}, zmm3, zmm17
// CHECK:  encoding: [0x62,0x21,0x65,0xcb,0x62,0xc1]
          vpunpckldq zmm24 {k3} {z}, zmm3, zmm17

// CHECK: vpunpckldq zmm24, zmm3, zmmword ptr [rcx]
// CHECK:  encoding: [0x62,0x61,0x65,0x48,0x62,0x01]
          vpunpckldq zmm24, zmm3, zmmword ptr [rcx]

// CHECK: vpunpckldq zmm24, zmm3, zmmword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0x21,0x65,0x48,0x62,0x84,0xf0,0x23,0x01,0x00,0x00]
          vpunpckldq zmm24, zmm3, zmmword ptr [rax + 8*r14 + 291]

// CHECK: vpunpckldq zmm24, zmm3, dword ptr [rcx]{1to16}
// CHECK:  encoding: [0x62,0x61,0x65,0x58,0x62,0x01]
          vpunpckldq zmm24, zmm3, dword ptr [rcx]{1to16}

// CHECK: vpunpckldq zmm24, zmm3, zmmword ptr [rdx + 8128]
// CHECK:  encoding: [0x62,0x61,0x65,0x48,0x62,0x42,0x7f]
          vpunpckldq zmm24, zmm3, zmmword ptr [rdx + 8128]

// CHECK: vpunpckldq zmm24, zmm3, zmmword ptr [rdx + 8192]
// CHECK:  encoding: [0x62,0x61,0x65,0x48,0x62,0x82,0x00,0x20,0x00,0x00]
          vpunpckldq zmm24, zmm3, zmmword ptr [rdx + 8192]

// CHECK: vpunpckldq zmm24, zmm3, zmmword ptr [rdx - 8192]
// CHECK:  encoding: [0x62,0x61,0x65,0x48,0x62,0x42,0x80]
          vpunpckldq zmm24, zmm3, zmmword ptr [rdx - 8192]

// CHECK: vpunpckldq zmm24, zmm3, zmmword ptr [rdx - 8256]
// CHECK:  encoding: [0x62,0x61,0x65,0x48,0x62,0x82,0xc0,0xdf,0xff,0xff]
          vpunpckldq zmm24, zmm3, zmmword ptr [rdx - 8256]

// CHECK: vpunpckldq zmm24, zmm3, dword ptr [rdx + 508]{1to16}
// CHECK:  encoding: [0x62,0x61,0x65,0x58,0x62,0x42,0x7f]
          vpunpckldq zmm24, zmm3, dword ptr [rdx + 508]{1to16}

// CHECK: vpunpckldq zmm24, zmm3, dword ptr [rdx + 512]{1to16}
// CHECK:  encoding: [0x62,0x61,0x65,0x58,0x62,0x82,0x00,0x02,0x00,0x00]
          vpunpckldq zmm24, zmm3, dword ptr [rdx + 512]{1to16}

// CHECK: vpunpckldq zmm24, zmm3, dword ptr [rdx - 512]{1to16}
// CHECK:  encoding: [0x62,0x61,0x65,0x58,0x62,0x42,0x80]
          vpunpckldq zmm24, zmm3, dword ptr [rdx - 512]{1to16}

// CHECK: vpunpckldq zmm24, zmm3, dword ptr [rdx - 516]{1to16}
// CHECK:  encoding: [0x62,0x61,0x65,0x58,0x62,0x82,0xfc,0xfd,0xff,0xff]
          vpunpckldq zmm24, zmm3, dword ptr [rdx - 516]{1to16}

// CHECK: vpunpcklqdq zmm3, zmm4, zmm17
// CHECK:  encoding: [0x62,0xb1,0xdd,0x48,0x6c,0xd9]
          vpunpcklqdq zmm3, zmm4, zmm17

// CHECK: vpunpcklqdq zmm3 {k1}, zmm4, zmm17
// CHECK:  encoding: [0x62,0xb1,0xdd,0x49,0x6c,0xd9]
          vpunpcklqdq zmm3 {k1}, zmm4, zmm17

// CHECK: vpunpcklqdq zmm3 {k1} {z}, zmm4, zmm17
// CHECK:  encoding: [0x62,0xb1,0xdd,0xc9,0x6c,0xd9]
          vpunpcklqdq zmm3 {k1} {z}, zmm4, zmm17

// CHECK: vpunpcklqdq zmm3, zmm4, zmmword ptr [rcx]
// CHECK:  encoding: [0x62,0xf1,0xdd,0x48,0x6c,0x19]
          vpunpcklqdq zmm3, zmm4, zmmword ptr [rcx]

// CHECK: vpunpcklqdq zmm3, zmm4, zmmword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0xb1,0xdd,0x48,0x6c,0x9c,0xf0,0x23,0x01,0x00,0x00]
          vpunpcklqdq zmm3, zmm4, zmmword ptr [rax + 8*r14 + 291]

// CHECK: vpunpcklqdq zmm3, zmm4, qword ptr [rcx]{1to8}
// CHECK:  encoding: [0x62,0xf1,0xdd,0x58,0x6c,0x19]
          vpunpcklqdq zmm3, zmm4, qword ptr [rcx]{1to8}

// CHECK: vpunpcklqdq zmm3, zmm4, zmmword ptr [rdx + 8128]
// CHECK:  encoding: [0x62,0xf1,0xdd,0x48,0x6c,0x5a,0x7f]
          vpunpcklqdq zmm3, zmm4, zmmword ptr [rdx + 8128]

// CHECK: vpunpcklqdq zmm3, zmm4, zmmword ptr [rdx + 8192]
// CHECK:  encoding: [0x62,0xf1,0xdd,0x48,0x6c,0x9a,0x00,0x20,0x00,0x00]
          vpunpcklqdq zmm3, zmm4, zmmword ptr [rdx + 8192]

// CHECK: vpunpcklqdq zmm3, zmm4, zmmword ptr [rdx - 8192]
// CHECK:  encoding: [0x62,0xf1,0xdd,0x48,0x6c,0x5a,0x80]
          vpunpcklqdq zmm3, zmm4, zmmword ptr [rdx - 8192]

// CHECK: vpunpcklqdq zmm3, zmm4, zmmword ptr [rdx - 8256]
// CHECK:  encoding: [0x62,0xf1,0xdd,0x48,0x6c,0x9a,0xc0,0xdf,0xff,0xff]
          vpunpcklqdq zmm3, zmm4, zmmword ptr [rdx - 8256]

// CHECK: vpunpcklqdq zmm3, zmm4, qword ptr [rdx + 1016]{1to8}
// CHECK:  encoding: [0x62,0xf1,0xdd,0x58,0x6c,0x5a,0x7f]
          vpunpcklqdq zmm3, zmm4, qword ptr [rdx + 1016]{1to8}

// CHECK: vpunpcklqdq zmm3, zmm4, qword ptr [rdx + 1024]{1to8}
// CHECK:  encoding: [0x62,0xf1,0xdd,0x58,0x6c,0x9a,0x00,0x04,0x00,0x00]
          vpunpcklqdq zmm3, zmm4, qword ptr [rdx + 1024]{1to8}

// CHECK: vpunpcklqdq zmm3, zmm4, qword ptr [rdx - 1024]{1to8}
// CHECK:  encoding: [0x62,0xf1,0xdd,0x58,0x6c,0x5a,0x80]
          vpunpcklqdq zmm3, zmm4, qword ptr [rdx - 1024]{1to8}

// CHECK: vpunpcklqdq zmm3, zmm4, qword ptr [rdx - 1032]{1to8}
// CHECK:  encoding: [0x62,0xf1,0xdd,0x58,0x6c,0x9a,0xf8,0xfb,0xff,0xff]
          vpunpcklqdq zmm3, zmm4, qword ptr [rdx - 1032]{1to8}

// CHECK: vpxord zmm8, zmm12, zmm24
// CHECK:  encoding: [0x62,0x11,0x1d,0x48,0xef,0xc0]
          vpxord zmm8, zmm12, zmm24

// CHECK: vpxord zmm8 {k6}, zmm12, zmm24
// CHECK:  encoding: [0x62,0x11,0x1d,0x4e,0xef,0xc0]
          vpxord zmm8 {k6}, zmm12, zmm24

// CHECK: vpxord zmm8 {k6} {z}, zmm12, zmm24
// CHECK:  encoding: [0x62,0x11,0x1d,0xce,0xef,0xc0]
          vpxord zmm8 {k6} {z}, zmm12, zmm24

// CHECK: vpxord zmm8, zmm12, zmmword ptr [rcx]
// CHECK:  encoding: [0x62,0x71,0x1d,0x48,0xef,0x01]
          vpxord zmm8, zmm12, zmmword ptr [rcx]

// CHECK: vpxord zmm8, zmm12, zmmword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0x31,0x1d,0x48,0xef,0x84,0xf0,0x23,0x01,0x00,0x00]
          vpxord zmm8, zmm12, zmmword ptr [rax + 8*r14 + 291]

// CHECK: vpxord zmm8, zmm12, dword ptr [rcx]{1to16}
// CHECK:  encoding: [0x62,0x71,0x1d,0x58,0xef,0x01]
          vpxord zmm8, zmm12, dword ptr [rcx]{1to16}

// CHECK: vpxord zmm8, zmm12, zmmword ptr [rdx + 8128]
// CHECK:  encoding: [0x62,0x71,0x1d,0x48,0xef,0x42,0x7f]
          vpxord zmm8, zmm12, zmmword ptr [rdx + 8128]

// CHECK: vpxord zmm8, zmm12, zmmword ptr [rdx + 8192]
// CHECK:  encoding: [0x62,0x71,0x1d,0x48,0xef,0x82,0x00,0x20,0x00,0x00]
          vpxord zmm8, zmm12, zmmword ptr [rdx + 8192]

// CHECK: vpxord zmm8, zmm12, zmmword ptr [rdx - 8192]
// CHECK:  encoding: [0x62,0x71,0x1d,0x48,0xef,0x42,0x80]
          vpxord zmm8, zmm12, zmmword ptr [rdx - 8192]

// CHECK: vpxord zmm8, zmm12, zmmword ptr [rdx - 8256]
// CHECK:  encoding: [0x62,0x71,0x1d,0x48,0xef,0x82,0xc0,0xdf,0xff,0xff]
          vpxord zmm8, zmm12, zmmword ptr [rdx - 8256]

// CHECK: vpxord zmm8, zmm12, dword ptr [rdx + 508]{1to16}
// CHECK:  encoding: [0x62,0x71,0x1d,0x58,0xef,0x42,0x7f]
          vpxord zmm8, zmm12, dword ptr [rdx + 508]{1to16}

// CHECK: vpxord zmm8, zmm12, dword ptr [rdx + 512]{1to16}
// CHECK:  encoding: [0x62,0x71,0x1d,0x58,0xef,0x82,0x00,0x02,0x00,0x00]
          vpxord zmm8, zmm12, dword ptr [rdx + 512]{1to16}

// CHECK: vpxord zmm8, zmm12, dword ptr [rdx - 512]{1to16}
// CHECK:  encoding: [0x62,0x71,0x1d,0x58,0xef,0x42,0x80]
          vpxord zmm8, zmm12, dword ptr [rdx - 512]{1to16}

// CHECK: vpxord zmm8, zmm12, dword ptr [rdx - 516]{1to16}
// CHECK:  encoding: [0x62,0x71,0x1d,0x58,0xef,0x82,0xfc,0xfd,0xff,0xff]
          vpxord zmm8, zmm12, dword ptr [rdx - 516]{1to16}

// CHECK: vpxorq zmm7, zmm22, zmm10
// CHECK:  encoding: [0x62,0xd1,0xcd,0x40,0xef,0xfa]
          vpxorq zmm7, zmm22, zmm10

// CHECK: vpxorq zmm7 {k6}, zmm22, zmm10
// CHECK:  encoding: [0x62,0xd1,0xcd,0x46,0xef,0xfa]
          vpxorq zmm7 {k6}, zmm22, zmm10

// CHECK: vpxorq zmm7 {k6} {z}, zmm22, zmm10
// CHECK:  encoding: [0x62,0xd1,0xcd,0xc6,0xef,0xfa]
          vpxorq zmm7 {k6} {z}, zmm22, zmm10

// CHECK: vpxorq zmm7, zmm22, zmmword ptr [rcx]
// CHECK:  encoding: [0x62,0xf1,0xcd,0x40,0xef,0x39]
          vpxorq zmm7, zmm22, zmmword ptr [rcx]

// CHECK: vpxorq zmm7, zmm22, zmmword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0xb1,0xcd,0x40,0xef,0xbc,0xf0,0x23,0x01,0x00,0x00]
          vpxorq zmm7, zmm22, zmmword ptr [rax + 8*r14 + 291]

// CHECK: vpxorq zmm7, zmm22, qword ptr [rcx]{1to8}
// CHECK:  encoding: [0x62,0xf1,0xcd,0x50,0xef,0x39]
          vpxorq zmm7, zmm22, qword ptr [rcx]{1to8}

// CHECK: vpxorq zmm7, zmm22, zmmword ptr [rdx + 8128]
// CHECK:  encoding: [0x62,0xf1,0xcd,0x40,0xef,0x7a,0x7f]
          vpxorq zmm7, zmm22, zmmword ptr [rdx + 8128]

// CHECK: vpxorq zmm7, zmm22, zmmword ptr [rdx + 8192]
// CHECK:  encoding: [0x62,0xf1,0xcd,0x40,0xef,0xba,0x00,0x20,0x00,0x00]
          vpxorq zmm7, zmm22, zmmword ptr [rdx + 8192]

// CHECK: vpxorq zmm7, zmm22, zmmword ptr [rdx - 8192]
// CHECK:  encoding: [0x62,0xf1,0xcd,0x40,0xef,0x7a,0x80]
          vpxorq zmm7, zmm22, zmmword ptr [rdx - 8192]

// CHECK: vpxorq zmm7, zmm22, zmmword ptr [rdx - 8256]
// CHECK:  encoding: [0x62,0xf1,0xcd,0x40,0xef,0xba,0xc0,0xdf,0xff,0xff]
          vpxorq zmm7, zmm22, zmmword ptr [rdx - 8256]

// CHECK: vpxorq zmm7, zmm22, qword ptr [rdx + 1016]{1to8}
// CHECK:  encoding: [0x62,0xf1,0xcd,0x50,0xef,0x7a,0x7f]
          vpxorq zmm7, zmm22, qword ptr [rdx + 1016]{1to8}

// CHECK: vpxorq zmm7, zmm22, qword ptr [rdx + 1024]{1to8}
// CHECK:  encoding: [0x62,0xf1,0xcd,0x50,0xef,0xba,0x00,0x04,0x00,0x00]
          vpxorq zmm7, zmm22, qword ptr [rdx + 1024]{1to8}

// CHECK: vpxorq zmm7, zmm22, qword ptr [rdx - 1024]{1to8}
// CHECK:  encoding: [0x62,0xf1,0xcd,0x50,0xef,0x7a,0x80]
          vpxorq zmm7, zmm22, qword ptr [rdx - 1024]{1to8}

// CHECK: vpxorq zmm7, zmm22, qword ptr [rdx - 1032]{1to8}
// CHECK:  encoding: [0x62,0xf1,0xcd,0x50,0xef,0xba,0xf8,0xfb,0xff,0xff]
          vpxorq zmm7, zmm22, qword ptr [rdx - 1032]{1to8}

// CHECK: vrcp14pd zmm13, zmm4
// CHECK:  encoding: [0x62,0x72,0xfd,0x48,0x4c,0xec]
          vrcp14pd zmm13, zmm4

// CHECK: vrcp14pd zmm13 {k5}, zmm4
// CHECK:  encoding: [0x62,0x72,0xfd,0x4d,0x4c,0xec]
          vrcp14pd zmm13 {k5}, zmm4

// CHECK: vrcp14pd zmm13 {k5} {z}, zmm4
// CHECK:  encoding: [0x62,0x72,0xfd,0xcd,0x4c,0xec]
          vrcp14pd zmm13 {k5} {z}, zmm4

// CHECK: vrcp14pd zmm13, zmmword ptr [rcx]
// CHECK:  encoding: [0x62,0x72,0xfd,0x48,0x4c,0x29]
          vrcp14pd zmm13, zmmword ptr [rcx]

// CHECK: vrcp14pd zmm13, zmmword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0x32,0xfd,0x48,0x4c,0xac,0xf0,0x23,0x01,0x00,0x00]
          vrcp14pd zmm13, zmmword ptr [rax + 8*r14 + 291]

// CHECK: vrcp14pd zmm13, qword ptr [rcx]{1to8}
// CHECK:  encoding: [0x62,0x72,0xfd,0x58,0x4c,0x29]
          vrcp14pd zmm13, qword ptr [rcx]{1to8}

// CHECK: vrcp14pd zmm13, zmmword ptr [rdx + 8128]
// CHECK:  encoding: [0x62,0x72,0xfd,0x48,0x4c,0x6a,0x7f]
          vrcp14pd zmm13, zmmword ptr [rdx + 8128]

// CHECK: vrcp14pd zmm13, zmmword ptr [rdx + 8192]
// CHECK:  encoding: [0x62,0x72,0xfd,0x48,0x4c,0xaa,0x00,0x20,0x00,0x00]
          vrcp14pd zmm13, zmmword ptr [rdx + 8192]

// CHECK: vrcp14pd zmm13, zmmword ptr [rdx - 8192]
// CHECK:  encoding: [0x62,0x72,0xfd,0x48,0x4c,0x6a,0x80]
          vrcp14pd zmm13, zmmword ptr [rdx - 8192]

// CHECK: vrcp14pd zmm13, zmmword ptr [rdx - 8256]
// CHECK:  encoding: [0x62,0x72,0xfd,0x48,0x4c,0xaa,0xc0,0xdf,0xff,0xff]
          vrcp14pd zmm13, zmmword ptr [rdx - 8256]

// CHECK: vrcp14pd zmm13, qword ptr [rdx + 1016]{1to8}
// CHECK:  encoding: [0x62,0x72,0xfd,0x58,0x4c,0x6a,0x7f]
          vrcp14pd zmm13, qword ptr [rdx + 1016]{1to8}

// CHECK: vrcp14pd zmm13, qword ptr [rdx + 1024]{1to8}
// CHECK:  encoding: [0x62,0x72,0xfd,0x58,0x4c,0xaa,0x00,0x04,0x00,0x00]
          vrcp14pd zmm13, qword ptr [rdx + 1024]{1to8}

// CHECK: vrcp14pd zmm13, qword ptr [rdx - 1024]{1to8}
// CHECK:  encoding: [0x62,0x72,0xfd,0x58,0x4c,0x6a,0x80]
          vrcp14pd zmm13, qword ptr [rdx - 1024]{1to8}

// CHECK: vrcp14pd zmm13, qword ptr [rdx - 1032]{1to8}
// CHECK:  encoding: [0x62,0x72,0xfd,0x58,0x4c,0xaa,0xf8,0xfb,0xff,0xff]
          vrcp14pd zmm13, qword ptr [rdx - 1032]{1to8}

// CHECK: vrcp14ps zmm10, zmm25
// CHECK:  encoding: [0x62,0x12,0x7d,0x48,0x4c,0xd1]
          vrcp14ps zmm10, zmm25

// CHECK: vrcp14ps zmm10 {k1}, zmm25
// CHECK:  encoding: [0x62,0x12,0x7d,0x49,0x4c,0xd1]
          vrcp14ps zmm10 {k1}, zmm25

// CHECK: vrcp14ps zmm10 {k1} {z}, zmm25
// CHECK:  encoding: [0x62,0x12,0x7d,0xc9,0x4c,0xd1]
          vrcp14ps zmm10 {k1} {z}, zmm25

// CHECK: vrcp14ps zmm10, zmmword ptr [rcx]
// CHECK:  encoding: [0x62,0x72,0x7d,0x48,0x4c,0x11]
          vrcp14ps zmm10, zmmword ptr [rcx]

// CHECK: vrcp14ps zmm10, zmmword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0x32,0x7d,0x48,0x4c,0x94,0xf0,0x23,0x01,0x00,0x00]
          vrcp14ps zmm10, zmmword ptr [rax + 8*r14 + 291]

// CHECK: vrcp14ps zmm10, dword ptr [rcx]{1to16}
// CHECK:  encoding: [0x62,0x72,0x7d,0x58,0x4c,0x11]
          vrcp14ps zmm10, dword ptr [rcx]{1to16}

// CHECK: vrcp14ps zmm10, zmmword ptr [rdx + 8128]
// CHECK:  encoding: [0x62,0x72,0x7d,0x48,0x4c,0x52,0x7f]
          vrcp14ps zmm10, zmmword ptr [rdx + 8128]

// CHECK: vrcp14ps zmm10, zmmword ptr [rdx + 8192]
// CHECK:  encoding: [0x62,0x72,0x7d,0x48,0x4c,0x92,0x00,0x20,0x00,0x00]
          vrcp14ps zmm10, zmmword ptr [rdx + 8192]

// CHECK: vrcp14ps zmm10, zmmword ptr [rdx - 8192]
// CHECK:  encoding: [0x62,0x72,0x7d,0x48,0x4c,0x52,0x80]
          vrcp14ps zmm10, zmmword ptr [rdx - 8192]

// CHECK: vrcp14ps zmm10, zmmword ptr [rdx - 8256]
// CHECK:  encoding: [0x62,0x72,0x7d,0x48,0x4c,0x92,0xc0,0xdf,0xff,0xff]
          vrcp14ps zmm10, zmmword ptr [rdx - 8256]

// CHECK: vrcp14ps zmm10, dword ptr [rdx + 508]{1to16}
// CHECK:  encoding: [0x62,0x72,0x7d,0x58,0x4c,0x52,0x7f]
          vrcp14ps zmm10, dword ptr [rdx + 508]{1to16}

// CHECK: vrcp14ps zmm10, dword ptr [rdx + 512]{1to16}
// CHECK:  encoding: [0x62,0x72,0x7d,0x58,0x4c,0x92,0x00,0x02,0x00,0x00]
          vrcp14ps zmm10, dword ptr [rdx + 512]{1to16}

// CHECK: vrcp14ps zmm10, dword ptr [rdx - 512]{1to16}
// CHECK:  encoding: [0x62,0x72,0x7d,0x58,0x4c,0x52,0x80]
          vrcp14ps zmm10, dword ptr [rdx - 512]{1to16}

// CHECK: vrcp14ps zmm10, dword ptr [rdx - 516]{1to16}
// CHECK:  encoding: [0x62,0x72,0x7d,0x58,0x4c,0x92,0xfc,0xfd,0xff,0xff]
          vrcp14ps zmm10, dword ptr [rdx - 516]{1to16}

// CHECK: vrcp14sd xmm12, xmm22, xmm14
// CHECK:  encoding: [0x62,0x52,0xcd,0x00,0x4d,0xe6]
          vrcp14sd xmm12, xmm22, xmm14

// CHECK: vrcp14sd xmm12 {k2}, xmm22, xmm14
// CHECK:  encoding: [0x62,0x52,0xcd,0x02,0x4d,0xe6]
          vrcp14sd xmm12 {k2}, xmm22, xmm14

// CHECK: vrcp14sd xmm12 {k2} {z}, xmm22, xmm14
// CHECK:  encoding: [0x62,0x52,0xcd,0x82,0x4d,0xe6]
          vrcp14sd xmm12 {k2} {z}, xmm22, xmm14

// CHECK: vrcp14sd xmm12, xmm22, qword ptr [rcx]
// CHECK:  encoding: [0x62,0x72,0xcd,0x00,0x4d,0x21]
          vrcp14sd xmm12, xmm22, qword ptr [rcx]

// CHECK: vrcp14sd xmm12, xmm22, qword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0x32,0xcd,0x00,0x4d,0xa4,0xf0,0x23,0x01,0x00,0x00]
          vrcp14sd xmm12, xmm22, qword ptr [rax + 8*r14 + 291]

// CHECK: vrcp14sd xmm12, xmm22, qword ptr [rdx + 1016]
// CHECK:  encoding: [0x62,0x72,0xcd,0x00,0x4d,0x62,0x7f]
          vrcp14sd xmm12, xmm22, qword ptr [rdx + 1016]

// CHECK: vrcp14sd xmm12, xmm22, qword ptr [rdx + 1024]
// CHECK:  encoding: [0x62,0x72,0xcd,0x00,0x4d,0xa2,0x00,0x04,0x00,0x00]
          vrcp14sd xmm12, xmm22, qword ptr [rdx + 1024]

// CHECK: vrcp14sd xmm12, xmm22, qword ptr [rdx - 1024]
// CHECK:  encoding: [0x62,0x72,0xcd,0x00,0x4d,0x62,0x80]
          vrcp14sd xmm12, xmm22, qword ptr [rdx - 1024]

// CHECK: vrcp14sd xmm12, xmm22, qword ptr [rdx - 1032]
// CHECK:  encoding: [0x62,0x72,0xcd,0x00,0x4d,0xa2,0xf8,0xfb,0xff,0xff]
          vrcp14sd xmm12, xmm22, qword ptr [rdx - 1032]

// CHECK: vrcp14ss xmm8, xmm8, xmm3
// CHECK:  encoding: [0x62,0x72,0x3d,0x08,0x4d,0xc3]
          vrcp14ss xmm8, xmm8, xmm3

// CHECK: vrcp14ss xmm8 {k7}, xmm8, xmm3
// CHECK:  encoding: [0x62,0x72,0x3d,0x0f,0x4d,0xc3]
          vrcp14ss xmm8 {k7}, xmm8, xmm3

// CHECK: vrcp14ss xmm8 {k7} {z}, xmm8, xmm3
// CHECK:  encoding: [0x62,0x72,0x3d,0x8f,0x4d,0xc3]
          vrcp14ss xmm8 {k7} {z}, xmm8, xmm3

// CHECK: vrcp14ss xmm8, xmm8, dword ptr [rcx]
// CHECK:  encoding: [0x62,0x72,0x3d,0x08,0x4d,0x01]
          vrcp14ss xmm8, xmm8, dword ptr [rcx]

// CHECK: vrcp14ss xmm8, xmm8, dword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0x32,0x3d,0x08,0x4d,0x84,0xf0,0x23,0x01,0x00,0x00]
          vrcp14ss xmm8, xmm8, dword ptr [rax + 8*r14 + 291]

// CHECK: vrcp14ss xmm8, xmm8, dword ptr [rdx + 508]
// CHECK:  encoding: [0x62,0x72,0x3d,0x08,0x4d,0x42,0x7f]
          vrcp14ss xmm8, xmm8, dword ptr [rdx + 508]

// CHECK: vrcp14ss xmm8, xmm8, dword ptr [rdx + 512]
// CHECK:  encoding: [0x62,0x72,0x3d,0x08,0x4d,0x82,0x00,0x02,0x00,0x00]
          vrcp14ss xmm8, xmm8, dword ptr [rdx + 512]

// CHECK: vrcp14ss xmm8, xmm8, dword ptr [rdx - 512]
// CHECK:  encoding: [0x62,0x72,0x3d,0x08,0x4d,0x42,0x80]
          vrcp14ss xmm8, xmm8, dword ptr [rdx - 512]

// CHECK: vrcp14ss xmm8, xmm8, dword ptr [rdx - 516]
// CHECK:  encoding: [0x62,0x72,0x3d,0x08,0x4d,0x82,0xfc,0xfd,0xff,0xff]
          vrcp14ss xmm8, xmm8, dword ptr [rdx - 516]

// CHECK: vrsqrt14pd zmm19, zmm14
// CHECK:  encoding: [0x62,0xc2,0xfd,0x48,0x4e,0xde]
          vrsqrt14pd zmm19, zmm14

// CHECK: vrsqrt14pd zmm19 {k1}, zmm14
// CHECK:  encoding: [0x62,0xc2,0xfd,0x49,0x4e,0xde]
          vrsqrt14pd zmm19 {k1}, zmm14

// CHECK: vrsqrt14pd zmm19 {k1} {z}, zmm14
// CHECK:  encoding: [0x62,0xc2,0xfd,0xc9,0x4e,0xde]
          vrsqrt14pd zmm19 {k1} {z}, zmm14

// CHECK: vrsqrt14pd zmm19, zmmword ptr [rcx]
// CHECK:  encoding: [0x62,0xe2,0xfd,0x48,0x4e,0x19]
          vrsqrt14pd zmm19, zmmword ptr [rcx]

// CHECK: vrsqrt14pd zmm19, zmmword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0xa2,0xfd,0x48,0x4e,0x9c,0xf0,0x23,0x01,0x00,0x00]
          vrsqrt14pd zmm19, zmmword ptr [rax + 8*r14 + 291]

// CHECK: vrsqrt14pd zmm19, qword ptr [rcx]{1to8}
// CHECK:  encoding: [0x62,0xe2,0xfd,0x58,0x4e,0x19]
          vrsqrt14pd zmm19, qword ptr [rcx]{1to8}

// CHECK: vrsqrt14pd zmm19, zmmword ptr [rdx + 8128]
// CHECK:  encoding: [0x62,0xe2,0xfd,0x48,0x4e,0x5a,0x7f]
          vrsqrt14pd zmm19, zmmword ptr [rdx + 8128]

// CHECK: vrsqrt14pd zmm19, zmmword ptr [rdx + 8192]
// CHECK:  encoding: [0x62,0xe2,0xfd,0x48,0x4e,0x9a,0x00,0x20,0x00,0x00]
          vrsqrt14pd zmm19, zmmword ptr [rdx + 8192]

// CHECK: vrsqrt14pd zmm19, zmmword ptr [rdx - 8192]
// CHECK:  encoding: [0x62,0xe2,0xfd,0x48,0x4e,0x5a,0x80]
          vrsqrt14pd zmm19, zmmword ptr [rdx - 8192]

// CHECK: vrsqrt14pd zmm19, zmmword ptr [rdx - 8256]
// CHECK:  encoding: [0x62,0xe2,0xfd,0x48,0x4e,0x9a,0xc0,0xdf,0xff,0xff]
          vrsqrt14pd zmm19, zmmword ptr [rdx - 8256]

// CHECK: vrsqrt14pd zmm19, qword ptr [rdx + 1016]{1to8}
// CHECK:  encoding: [0x62,0xe2,0xfd,0x58,0x4e,0x5a,0x7f]
          vrsqrt14pd zmm19, qword ptr [rdx + 1016]{1to8}

// CHECK: vrsqrt14pd zmm19, qword ptr [rdx + 1024]{1to8}
// CHECK:  encoding: [0x62,0xe2,0xfd,0x58,0x4e,0x9a,0x00,0x04,0x00,0x00]
          vrsqrt14pd zmm19, qword ptr [rdx + 1024]{1to8}

// CHECK: vrsqrt14pd zmm19, qword ptr [rdx - 1024]{1to8}
// CHECK:  encoding: [0x62,0xe2,0xfd,0x58,0x4e,0x5a,0x80]
          vrsqrt14pd zmm19, qword ptr [rdx - 1024]{1to8}

// CHECK: vrsqrt14pd zmm19, qword ptr [rdx - 1032]{1to8}
// CHECK:  encoding: [0x62,0xe2,0xfd,0x58,0x4e,0x9a,0xf8,0xfb,0xff,0xff]
          vrsqrt14pd zmm19, qword ptr [rdx - 1032]{1to8}

// CHECK: vrsqrt14ps zmm16, zmm9
// CHECK:  encoding: [0x62,0xc2,0x7d,0x48,0x4e,0xc1]
          vrsqrt14ps zmm16, zmm9

// CHECK: vrsqrt14ps zmm16 {k5}, zmm9
// CHECK:  encoding: [0x62,0xc2,0x7d,0x4d,0x4e,0xc1]
          vrsqrt14ps zmm16 {k5}, zmm9

// CHECK: vrsqrt14ps zmm16 {k5} {z}, zmm9
// CHECK:  encoding: [0x62,0xc2,0x7d,0xcd,0x4e,0xc1]
          vrsqrt14ps zmm16 {k5} {z}, zmm9

// CHECK: vrsqrt14ps zmm16, zmmword ptr [rcx]
// CHECK:  encoding: [0x62,0xe2,0x7d,0x48,0x4e,0x01]
          vrsqrt14ps zmm16, zmmword ptr [rcx]

// CHECK: vrsqrt14ps zmm16, zmmword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0xa2,0x7d,0x48,0x4e,0x84,0xf0,0x23,0x01,0x00,0x00]
          vrsqrt14ps zmm16, zmmword ptr [rax + 8*r14 + 291]

// CHECK: vrsqrt14ps zmm16, dword ptr [rcx]{1to16}
// CHECK:  encoding: [0x62,0xe2,0x7d,0x58,0x4e,0x01]
          vrsqrt14ps zmm16, dword ptr [rcx]{1to16}

// CHECK: vrsqrt14ps zmm16, zmmword ptr [rdx + 8128]
// CHECK:  encoding: [0x62,0xe2,0x7d,0x48,0x4e,0x42,0x7f]
          vrsqrt14ps zmm16, zmmword ptr [rdx + 8128]

// CHECK: vrsqrt14ps zmm16, zmmword ptr [rdx + 8192]
// CHECK:  encoding: [0x62,0xe2,0x7d,0x48,0x4e,0x82,0x00,0x20,0x00,0x00]
          vrsqrt14ps zmm16, zmmword ptr [rdx + 8192]

// CHECK: vrsqrt14ps zmm16, zmmword ptr [rdx - 8192]
// CHECK:  encoding: [0x62,0xe2,0x7d,0x48,0x4e,0x42,0x80]
          vrsqrt14ps zmm16, zmmword ptr [rdx - 8192]

// CHECK: vrsqrt14ps zmm16, zmmword ptr [rdx - 8256]
// CHECK:  encoding: [0x62,0xe2,0x7d,0x48,0x4e,0x82,0xc0,0xdf,0xff,0xff]
          vrsqrt14ps zmm16, zmmword ptr [rdx - 8256]

// CHECK: vrsqrt14ps zmm16, dword ptr [rdx + 508]{1to16}
// CHECK:  encoding: [0x62,0xe2,0x7d,0x58,0x4e,0x42,0x7f]
          vrsqrt14ps zmm16, dword ptr [rdx + 508]{1to16}

// CHECK: vrsqrt14ps zmm16, dword ptr [rdx + 512]{1to16}
// CHECK:  encoding: [0x62,0xe2,0x7d,0x58,0x4e,0x82,0x00,0x02,0x00,0x00]
          vrsqrt14ps zmm16, dword ptr [rdx + 512]{1to16}

// CHECK: vrsqrt14ps zmm16, dword ptr [rdx - 512]{1to16}
// CHECK:  encoding: [0x62,0xe2,0x7d,0x58,0x4e,0x42,0x80]
          vrsqrt14ps zmm16, dword ptr [rdx - 512]{1to16}

// CHECK: vrsqrt14ps zmm16, dword ptr [rdx - 516]{1to16}
// CHECK:  encoding: [0x62,0xe2,0x7d,0x58,0x4e,0x82,0xfc,0xfd,0xff,0xff]
          vrsqrt14ps zmm16, dword ptr [rdx - 516]{1to16}

// CHECK: vrsqrt14sd xmm26, xmm6, xmm10
// CHECK:  encoding: [0x62,0x42,0xcd,0x08,0x4f,0xd2]
          vrsqrt14sd xmm26, xmm6, xmm10

// CHECK: vrsqrt14sd xmm26 {k5}, xmm6, xmm10
// CHECK:  encoding: [0x62,0x42,0xcd,0x0d,0x4f,0xd2]
          vrsqrt14sd xmm26 {k5}, xmm6, xmm10

// CHECK: vrsqrt14sd xmm26 {k5} {z}, xmm6, xmm10
// CHECK:  encoding: [0x62,0x42,0xcd,0x8d,0x4f,0xd2]
          vrsqrt14sd xmm26 {k5} {z}, xmm6, xmm10

// CHECK: vrsqrt14sd xmm26, xmm6, qword ptr [rcx]
// CHECK:  encoding: [0x62,0x62,0xcd,0x08,0x4f,0x11]
          vrsqrt14sd xmm26, xmm6, qword ptr [rcx]

// CHECK: vrsqrt14sd xmm26, xmm6, qword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0x22,0xcd,0x08,0x4f,0x94,0xf0,0x23,0x01,0x00,0x00]
          vrsqrt14sd xmm26, xmm6, qword ptr [rax + 8*r14 + 291]

// CHECK: vrsqrt14sd xmm26, xmm6, qword ptr [rdx + 1016]
// CHECK:  encoding: [0x62,0x62,0xcd,0x08,0x4f,0x52,0x7f]
          vrsqrt14sd xmm26, xmm6, qword ptr [rdx + 1016]

// CHECK: vrsqrt14sd xmm26, xmm6, qword ptr [rdx + 1024]
// CHECK:  encoding: [0x62,0x62,0xcd,0x08,0x4f,0x92,0x00,0x04,0x00,0x00]
          vrsqrt14sd xmm26, xmm6, qword ptr [rdx + 1024]

// CHECK: vrsqrt14sd xmm26, xmm6, qword ptr [rdx - 1024]
// CHECK:  encoding: [0x62,0x62,0xcd,0x08,0x4f,0x52,0x80]
          vrsqrt14sd xmm26, xmm6, qword ptr [rdx - 1024]

// CHECK: vrsqrt14sd xmm26, xmm6, qword ptr [rdx - 1032]
// CHECK:  encoding: [0x62,0x62,0xcd,0x08,0x4f,0x92,0xf8,0xfb,0xff,0xff]
          vrsqrt14sd xmm26, xmm6, qword ptr [rdx - 1032]

// CHECK: vrsqrt14ss xmm14, xmm14, xmm9
// CHECK:  encoding: [0x62,0x52,0x0d,0x08,0x4f,0xf1]
          vrsqrt14ss xmm14, xmm14, xmm9

// CHECK: vrsqrt14ss xmm14 {k1}, xmm14, xmm9
// CHECK:  encoding: [0x62,0x52,0x0d,0x09,0x4f,0xf1]
          vrsqrt14ss xmm14 {k1}, xmm14, xmm9

// CHECK: vrsqrt14ss xmm14 {k1} {z}, xmm14, xmm9
// CHECK:  encoding: [0x62,0x52,0x0d,0x89,0x4f,0xf1]
          vrsqrt14ss xmm14 {k1} {z}, xmm14, xmm9

// CHECK: vrsqrt14ss xmm14, xmm14, dword ptr [rcx]
// CHECK:  encoding: [0x62,0x72,0x0d,0x08,0x4f,0x31]
          vrsqrt14ss xmm14, xmm14, dword ptr [rcx]

// CHECK: vrsqrt14ss xmm14, xmm14, dword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0x32,0x0d,0x08,0x4f,0xb4,0xf0,0x23,0x01,0x00,0x00]
          vrsqrt14ss xmm14, xmm14, dword ptr [rax + 8*r14 + 291]

// CHECK: vrsqrt14ss xmm14, xmm14, dword ptr [rdx + 508]
// CHECK:  encoding: [0x62,0x72,0x0d,0x08,0x4f,0x72,0x7f]
          vrsqrt14ss xmm14, xmm14, dword ptr [rdx + 508]

// CHECK: vrsqrt14ss xmm14, xmm14, dword ptr [rdx + 512]
// CHECK:  encoding: [0x62,0x72,0x0d,0x08,0x4f,0xb2,0x00,0x02,0x00,0x00]
          vrsqrt14ss xmm14, xmm14, dword ptr [rdx + 512]

// CHECK: vrsqrt14ss xmm14, xmm14, dword ptr [rdx - 512]
// CHECK:  encoding: [0x62,0x72,0x0d,0x08,0x4f,0x72,0x80]
          vrsqrt14ss xmm14, xmm14, dword ptr [rdx - 512]

// CHECK: vrsqrt14ss xmm14, xmm14, dword ptr [rdx - 516]
// CHECK:  encoding: [0x62,0x72,0x0d,0x08,0x4f,0xb2,0xfc,0xfd,0xff,0xff]
          vrsqrt14ss xmm14, xmm14, dword ptr [rdx - 516]

// CHECK: vshufpd zmm28, zmm8, zmm22, 171
// CHECK:  encoding: [0x62,0x21,0xbd,0x48,0xc6,0xe6,0xab]
          vshufpd zmm28, zmm8, zmm22, 171

// CHECK: vshufpd zmm28 {k2}, zmm8, zmm22, 171
// CHECK:  encoding: [0x62,0x21,0xbd,0x4a,0xc6,0xe6,0xab]
          vshufpd zmm28 {k2}, zmm8, zmm22, 171

// CHECK: vshufpd zmm28 {k2} {z}, zmm8, zmm22, 171
// CHECK:  encoding: [0x62,0x21,0xbd,0xca,0xc6,0xe6,0xab]
          vshufpd zmm28 {k2} {z}, zmm8, zmm22, 171

// CHECK: vshufpd zmm28, zmm8, zmm22, 123
// CHECK:  encoding: [0x62,0x21,0xbd,0x48,0xc6,0xe6,0x7b]
          vshufpd zmm28, zmm8, zmm22, 123

// CHECK: vshufpd zmm28, zmm8, zmmword ptr [rcx], 123
// CHECK:  encoding: [0x62,0x61,0xbd,0x48,0xc6,0x21,0x7b]
          vshufpd zmm28, zmm8, zmmword ptr [rcx], 123

// CHECK: vshufpd zmm28, zmm8, zmmword ptr [rax + 8*r14 + 291], 123
// CHECK:  encoding: [0x62,0x21,0xbd,0x48,0xc6,0xa4,0xf0,0x23,0x01,0x00,0x00,0x7b]
          vshufpd zmm28, zmm8, zmmword ptr [rax + 8*r14 + 291], 123

// CHECK: vshufpd zmm28, zmm8, qword ptr [rcx]{1to8}, 123
// CHECK:  encoding: [0x62,0x61,0xbd,0x58,0xc6,0x21,0x7b]
          vshufpd zmm28, zmm8, qword ptr [rcx]{1to8}, 123

// CHECK: vshufpd zmm28, zmm8, zmmword ptr [rdx + 8128], 123
// CHECK:  encoding: [0x62,0x61,0xbd,0x48,0xc6,0x62,0x7f,0x7b]
          vshufpd zmm28, zmm8, zmmword ptr [rdx + 8128], 123

// CHECK: vshufpd zmm28, zmm8, zmmword ptr [rdx + 8192], 123
// CHECK:  encoding: [0x62,0x61,0xbd,0x48,0xc6,0xa2,0x00,0x20,0x00,0x00,0x7b]
          vshufpd zmm28, zmm8, zmmword ptr [rdx + 8192], 123

// CHECK: vshufpd zmm28, zmm8, zmmword ptr [rdx - 8192], 123
// CHECK:  encoding: [0x62,0x61,0xbd,0x48,0xc6,0x62,0x80,0x7b]
          vshufpd zmm28, zmm8, zmmword ptr [rdx - 8192], 123

// CHECK: vshufpd zmm28, zmm8, zmmword ptr [rdx - 8256], 123
// CHECK:  encoding: [0x62,0x61,0xbd,0x48,0xc6,0xa2,0xc0,0xdf,0xff,0xff,0x7b]
          vshufpd zmm28, zmm8, zmmword ptr [rdx - 8256], 123

// CHECK: vshufpd zmm28, zmm8, qword ptr [rdx + 1016]{1to8}, 123
// CHECK:  encoding: [0x62,0x61,0xbd,0x58,0xc6,0x62,0x7f,0x7b]
          vshufpd zmm28, zmm8, qword ptr [rdx + 1016]{1to8}, 123

// CHECK: vshufpd zmm28, zmm8, qword ptr [rdx + 1024]{1to8}, 123
// CHECK:  encoding: [0x62,0x61,0xbd,0x58,0xc6,0xa2,0x00,0x04,0x00,0x00,0x7b]
          vshufpd zmm28, zmm8, qword ptr [rdx + 1024]{1to8}, 123

// CHECK: vshufpd zmm28, zmm8, qword ptr [rdx - 1024]{1to8}, 123
// CHECK:  encoding: [0x62,0x61,0xbd,0x58,0xc6,0x62,0x80,0x7b]
          vshufpd zmm28, zmm8, qword ptr [rdx - 1024]{1to8}, 123

// CHECK: vshufpd zmm28, zmm8, qword ptr [rdx - 1032]{1to8}, 123
// CHECK:  encoding: [0x62,0x61,0xbd,0x58,0xc6,0xa2,0xf8,0xfb,0xff,0xff,0x7b]
          vshufpd zmm28, zmm8, qword ptr [rdx - 1032]{1to8}, 123

// CHECK: vshufps zmm5, zmm6, zmm9, 171
// CHECK:  encoding: [0x62,0xd1,0x4c,0x48,0xc6,0xe9,0xab]
          vshufps zmm5, zmm6, zmm9, 171

// CHECK: vshufps zmm5 {k6}, zmm6, zmm9, 171
// CHECK:  encoding: [0x62,0xd1,0x4c,0x4e,0xc6,0xe9,0xab]
          vshufps zmm5 {k6}, zmm6, zmm9, 171

// CHECK: vshufps zmm5 {k6} {z}, zmm6, zmm9, 171
// CHECK:  encoding: [0x62,0xd1,0x4c,0xce,0xc6,0xe9,0xab]
          vshufps zmm5 {k6} {z}, zmm6, zmm9, 171

// CHECK: vshufps zmm5, zmm6, zmm9, 123
// CHECK:  encoding: [0x62,0xd1,0x4c,0x48,0xc6,0xe9,0x7b]
          vshufps zmm5, zmm6, zmm9, 123

// CHECK: vshufps zmm5, zmm6, zmmword ptr [rcx], 123
// CHECK:  encoding: [0x62,0xf1,0x4c,0x48,0xc6,0x29,0x7b]
          vshufps zmm5, zmm6, zmmword ptr [rcx], 123

// CHECK: vshufps zmm5, zmm6, zmmword ptr [rax + 8*r14 + 291], 123
// CHECK:  encoding: [0x62,0xb1,0x4c,0x48,0xc6,0xac,0xf0,0x23,0x01,0x00,0x00,0x7b]
          vshufps zmm5, zmm6, zmmword ptr [rax + 8*r14 + 291], 123

// CHECK: vshufps zmm5, zmm6, dword ptr [rcx]{1to16}, 123
// CHECK:  encoding: [0x62,0xf1,0x4c,0x58,0xc6,0x29,0x7b]
          vshufps zmm5, zmm6, dword ptr [rcx]{1to16}, 123

// CHECK: vshufps zmm5, zmm6, zmmword ptr [rdx + 8128], 123
// CHECK:  encoding: [0x62,0xf1,0x4c,0x48,0xc6,0x6a,0x7f,0x7b]
          vshufps zmm5, zmm6, zmmword ptr [rdx + 8128], 123

// CHECK: vshufps zmm5, zmm6, zmmword ptr [rdx + 8192], 123
// CHECK:  encoding: [0x62,0xf1,0x4c,0x48,0xc6,0xaa,0x00,0x20,0x00,0x00,0x7b]
          vshufps zmm5, zmm6, zmmword ptr [rdx + 8192], 123

// CHECK: vshufps zmm5, zmm6, zmmword ptr [rdx - 8192], 123
// CHECK:  encoding: [0x62,0xf1,0x4c,0x48,0xc6,0x6a,0x80,0x7b]
          vshufps zmm5, zmm6, zmmword ptr [rdx - 8192], 123

// CHECK: vshufps zmm5, zmm6, zmmword ptr [rdx - 8256], 123
// CHECK:  encoding: [0x62,0xf1,0x4c,0x48,0xc6,0xaa,0xc0,0xdf,0xff,0xff,0x7b]
          vshufps zmm5, zmm6, zmmword ptr [rdx - 8256], 123

// CHECK: vshufps zmm5, zmm6, dword ptr [rdx + 508]{1to16}, 123
// CHECK:  encoding: [0x62,0xf1,0x4c,0x58,0xc6,0x6a,0x7f,0x7b]
          vshufps zmm5, zmm6, dword ptr [rdx + 508]{1to16}, 123

// CHECK: vshufps zmm5, zmm6, dword ptr [rdx + 512]{1to16}, 123
// CHECK:  encoding: [0x62,0xf1,0x4c,0x58,0xc6,0xaa,0x00,0x02,0x00,0x00,0x7b]
          vshufps zmm5, zmm6, dword ptr [rdx + 512]{1to16}, 123

// CHECK: vshufps zmm5, zmm6, dword ptr [rdx - 512]{1to16}, 123
// CHECK:  encoding: [0x62,0xf1,0x4c,0x58,0xc6,0x6a,0x80,0x7b]
          vshufps zmm5, zmm6, dword ptr [rdx - 512]{1to16}, 123

// CHECK: vshufps zmm5, zmm6, dword ptr [rdx - 516]{1to16}, 123
// CHECK:  encoding: [0x62,0xf1,0x4c,0x58,0xc6,0xaa,0xfc,0xfd,0xff,0xff,0x7b]
          vshufps zmm5, zmm6, dword ptr [rdx - 516]{1to16}, 123

// CHECK: vsqrtpd zmm19, zmm19
// CHECK:  encoding: [0x62,0xa1,0xfd,0x48,0x51,0xdb]
          vsqrtpd zmm19, zmm19

// CHECK: vsqrtpd zmm19 {k5}, zmm19
// CHECK:  encoding: [0x62,0xa1,0xfd,0x4d,0x51,0xdb]
          vsqrtpd zmm19 {k5}, zmm19

// CHECK: vsqrtpd zmm19 {k5} {z}, zmm19
// CHECK:  encoding: [0x62,0xa1,0xfd,0xcd,0x51,0xdb]
          vsqrtpd zmm19 {k5} {z}, zmm19

// CHECK: vsqrtpd zmm19, zmm19, {rn-sae}
// CHECK:  encoding: [0x62,0xa1,0xfd,0x18,0x51,0xdb]
          vsqrtpd zmm19, zmm19, {rn-sae}

// CHECK: vsqrtpd zmm19, zmm19, {ru-sae}
// CHECK:  encoding: [0x62,0xa1,0xfd,0x58,0x51,0xdb]
          vsqrtpd zmm19, zmm19, {ru-sae}

// CHECK: vsqrtpd zmm19, zmm19, {rd-sae}
// CHECK:  encoding: [0x62,0xa1,0xfd,0x38,0x51,0xdb]
          vsqrtpd zmm19, zmm19, {rd-sae}

// CHECK: vsqrtpd zmm19, zmm19, {rz-sae}
// CHECK:  encoding: [0x62,0xa1,0xfd,0x78,0x51,0xdb]
          vsqrtpd zmm19, zmm19, {rz-sae}

// CHECK: vsqrtpd zmm19, zmmword ptr [rcx]
// CHECK:  encoding: [0x62,0xe1,0xfd,0x48,0x51,0x19]
          vsqrtpd zmm19, zmmword ptr [rcx]

// CHECK: vsqrtpd zmm19, zmmword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0xa1,0xfd,0x48,0x51,0x9c,0xf0,0x23,0x01,0x00,0x00]
          vsqrtpd zmm19, zmmword ptr [rax + 8*r14 + 291]

// CHECK: vsqrtpd zmm19, qword ptr [rcx]{1to8}
// CHECK:  encoding: [0x62,0xe1,0xfd,0x58,0x51,0x19]
          vsqrtpd zmm19, qword ptr [rcx]{1to8}

// CHECK: vsqrtpd zmm19, zmmword ptr [rdx + 8128]
// CHECK:  encoding: [0x62,0xe1,0xfd,0x48,0x51,0x5a,0x7f]
          vsqrtpd zmm19, zmmword ptr [rdx + 8128]

// CHECK: vsqrtpd zmm19, zmmword ptr [rdx + 8192]
// CHECK:  encoding: [0x62,0xe1,0xfd,0x48,0x51,0x9a,0x00,0x20,0x00,0x00]
          vsqrtpd zmm19, zmmword ptr [rdx + 8192]

// CHECK: vsqrtpd zmm19, zmmword ptr [rdx - 8192]
// CHECK:  encoding: [0x62,0xe1,0xfd,0x48,0x51,0x5a,0x80]
          vsqrtpd zmm19, zmmword ptr [rdx - 8192]

// CHECK: vsqrtpd zmm19, zmmword ptr [rdx - 8256]
// CHECK:  encoding: [0x62,0xe1,0xfd,0x48,0x51,0x9a,0xc0,0xdf,0xff,0xff]
          vsqrtpd zmm19, zmmword ptr [rdx - 8256]

// CHECK: vsqrtpd zmm19, qword ptr [rdx + 1016]{1to8}
// CHECK:  encoding: [0x62,0xe1,0xfd,0x58,0x51,0x5a,0x7f]
          vsqrtpd zmm19, qword ptr [rdx + 1016]{1to8}

// CHECK: vsqrtpd zmm19, qword ptr [rdx + 1024]{1to8}
// CHECK:  encoding: [0x62,0xe1,0xfd,0x58,0x51,0x9a,0x00,0x04,0x00,0x00]
          vsqrtpd zmm19, qword ptr [rdx + 1024]{1to8}

// CHECK: vsqrtpd zmm19, qword ptr [rdx - 1024]{1to8}
// CHECK:  encoding: [0x62,0xe1,0xfd,0x58,0x51,0x5a,0x80]
          vsqrtpd zmm19, qword ptr [rdx - 1024]{1to8}

// CHECK: vsqrtpd zmm19, qword ptr [rdx - 1032]{1to8}
// CHECK:  encoding: [0x62,0xe1,0xfd,0x58,0x51,0x9a,0xf8,0xfb,0xff,0xff]
          vsqrtpd zmm19, qword ptr [rdx - 1032]{1to8}

// CHECK: vsqrtps zmm28, zmm29
// CHECK:  encoding: [0x62,0x01,0x7c,0x48,0x51,0xe5]
          vsqrtps zmm28, zmm29

// CHECK: vsqrtps zmm28 {k3}, zmm29
// CHECK:  encoding: [0x62,0x01,0x7c,0x4b,0x51,0xe5]
          vsqrtps zmm28 {k3}, zmm29

// CHECK: vsqrtps zmm28 {k3} {z}, zmm29
// CHECK:  encoding: [0x62,0x01,0x7c,0xcb,0x51,0xe5]
          vsqrtps zmm28 {k3} {z}, zmm29

// CHECK: vsqrtps zmm28, zmm29, {rn-sae}
// CHECK:  encoding: [0x62,0x01,0x7c,0x18,0x51,0xe5]
          vsqrtps zmm28, zmm29, {rn-sae}

// CHECK: vsqrtps zmm28, zmm29, {ru-sae}
// CHECK:  encoding: [0x62,0x01,0x7c,0x58,0x51,0xe5]
          vsqrtps zmm28, zmm29, {ru-sae}

// CHECK: vsqrtps zmm28, zmm29, {rd-sae}
// CHECK:  encoding: [0x62,0x01,0x7c,0x38,0x51,0xe5]
          vsqrtps zmm28, zmm29, {rd-sae}

// CHECK: vsqrtps zmm28, zmm29, {rz-sae}
// CHECK:  encoding: [0x62,0x01,0x7c,0x78,0x51,0xe5]
          vsqrtps zmm28, zmm29, {rz-sae}

// CHECK: vsqrtps zmm28, zmmword ptr [rcx]
// CHECK:  encoding: [0x62,0x61,0x7c,0x48,0x51,0x21]
          vsqrtps zmm28, zmmword ptr [rcx]

// CHECK: vsqrtps zmm28, zmmword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0x21,0x7c,0x48,0x51,0xa4,0xf0,0x23,0x01,0x00,0x00]
          vsqrtps zmm28, zmmword ptr [rax + 8*r14 + 291]

// CHECK: vsqrtps zmm28, dword ptr [rcx]{1to16}
// CHECK:  encoding: [0x62,0x61,0x7c,0x58,0x51,0x21]
          vsqrtps zmm28, dword ptr [rcx]{1to16}

// CHECK: vsqrtps zmm28, zmmword ptr [rdx + 8128]
// CHECK:  encoding: [0x62,0x61,0x7c,0x48,0x51,0x62,0x7f]
          vsqrtps zmm28, zmmword ptr [rdx + 8128]

// CHECK: vsqrtps zmm28, zmmword ptr [rdx + 8192]
// CHECK:  encoding: [0x62,0x61,0x7c,0x48,0x51,0xa2,0x00,0x20,0x00,0x00]
          vsqrtps zmm28, zmmword ptr [rdx + 8192]

// CHECK: vsqrtps zmm28, zmmword ptr [rdx - 8192]
// CHECK:  encoding: [0x62,0x61,0x7c,0x48,0x51,0x62,0x80]
          vsqrtps zmm28, zmmword ptr [rdx - 8192]

// CHECK: vsqrtps zmm28, zmmword ptr [rdx - 8256]
// CHECK:  encoding: [0x62,0x61,0x7c,0x48,0x51,0xa2,0xc0,0xdf,0xff,0xff]
          vsqrtps zmm28, zmmword ptr [rdx - 8256]

// CHECK: vsqrtps zmm28, dword ptr [rdx + 508]{1to16}
// CHECK:  encoding: [0x62,0x61,0x7c,0x58,0x51,0x62,0x7f]
          vsqrtps zmm28, dword ptr [rdx + 508]{1to16}

// CHECK: vsqrtps zmm28, dword ptr [rdx + 512]{1to16}
// CHECK:  encoding: [0x62,0x61,0x7c,0x58,0x51,0xa2,0x00,0x02,0x00,0x00]
          vsqrtps zmm28, dword ptr [rdx + 512]{1to16}

// CHECK: vsqrtps zmm28, dword ptr [rdx - 512]{1to16}
// CHECK:  encoding: [0x62,0x61,0x7c,0x58,0x51,0x62,0x80]
          vsqrtps zmm28, dword ptr [rdx - 512]{1to16}

// CHECK: vsqrtps zmm28, dword ptr [rdx - 516]{1to16}
// CHECK:  encoding: [0x62,0x61,0x7c,0x58,0x51,0xa2,0xfc,0xfd,0xff,0xff]
          vsqrtps zmm28, dword ptr [rdx - 516]{1to16}

// CHECK: vsqrtsd xmm6, xmm2, xmm12
// CHECK:  encoding: [0xc4,0xc1,0x6b,0x51,0xf4]
          vsqrtsd xmm6, xmm2, xmm12

// CHECK: vsqrtsd xmm6 {k7}, xmm2, xmm12
// CHECK:  encoding: [0x62,0xd1,0xef,0x0f,0x51,0xf4]
          vsqrtsd xmm6 {k7}, xmm2, xmm12

// CHECK: vsqrtsd xmm6 {k7} {z}, xmm2, xmm12
// CHECK:  encoding: [0x62,0xd1,0xef,0x8f,0x51,0xf4]
          vsqrtsd xmm6 {k7} {z}, xmm2, xmm12

// CHECK: vsqrtsd xmm6, xmm2, xmm12, {rn-sae}
// CHECK:  encoding: [0x62,0xd1,0xef,0x18,0x51,0xf4]
          vsqrtsd xmm6, xmm2, xmm12, {rn-sae}

// CHECK: vsqrtsd xmm6, xmm2, xmm12, {ru-sae}
// CHECK:  encoding: [0x62,0xd1,0xef,0x58,0x51,0xf4]
          vsqrtsd xmm6, xmm2, xmm12, {ru-sae}

// CHECK: vsqrtsd xmm6, xmm2, xmm12, {rd-sae}
// CHECK:  encoding: [0x62,0xd1,0xef,0x38,0x51,0xf4]
          vsqrtsd xmm6, xmm2, xmm12, {rd-sae}

// CHECK: vsqrtsd xmm6, xmm2, xmm12, {rz-sae}
// CHECK:  encoding: [0x62,0xd1,0xef,0x78,0x51,0xf4]
          vsqrtsd xmm6, xmm2, xmm12, {rz-sae}

// CHECK: vsqrtsd xmm6, xmm2, qword ptr [rcx]
// CHECK:  encoding: [0xc5,0xeb,0x51,0x31]
          vsqrtsd xmm6, xmm2, qword ptr [rcx]

// CHECK: vsqrtsd xmm6, xmm2, qword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0xc4,0xa1,0x6b,0x51,0xb4,0xf0,0x23,0x01,0x00,0x00]
          vsqrtsd xmm6, xmm2, qword ptr [rax + 8*r14 + 291]

// CHECK: vsqrtsd xmm6, xmm2, qword ptr [rdx + 1016]
// CHECK:  encoding: [0xc5,0xeb,0x51,0xb2,0xf8,0x03,0x00,0x00]
          vsqrtsd xmm6, xmm2, qword ptr [rdx + 1016]

// CHECK: vsqrtsd xmm6, xmm2, qword ptr [rdx + 1024]
// CHECK:  encoding: [0xc5,0xeb,0x51,0xb2,0x00,0x04,0x00,0x00]
          vsqrtsd xmm6, xmm2, qword ptr [rdx + 1024]

// CHECK: vsqrtsd xmm6, xmm2, qword ptr [rdx - 1024]
// CHECK:  encoding: [0xc5,0xeb,0x51,0xb2,0x00,0xfc,0xff,0xff]
          vsqrtsd xmm6, xmm2, qword ptr [rdx - 1024]

// CHECK: vsqrtsd xmm6, xmm2, qword ptr [rdx - 1032]
// CHECK:  encoding: [0xc5,0xeb,0x51,0xb2,0xf8,0xfb,0xff,0xff]
          vsqrtsd xmm6, xmm2, qword ptr [rdx - 1032]

// CHECK: vsqrtss xmm22, xmm19, xmm8
// CHECK:  encoding: [0x62,0xc1,0x66,0x00,0x51,0xf0]
          vsqrtss xmm22, xmm19, xmm8

// CHECK: vsqrtss xmm22 {k1}, xmm19, xmm8
// CHECK:  encoding: [0x62,0xc1,0x66,0x01,0x51,0xf0]
          vsqrtss xmm22 {k1}, xmm19, xmm8

// CHECK: vsqrtss xmm22 {k1} {z}, xmm19, xmm8
// CHECK:  encoding: [0x62,0xc1,0x66,0x81,0x51,0xf0]
          vsqrtss xmm22 {k1} {z}, xmm19, xmm8

// CHECK: vsqrtss xmm22, xmm19, xmm8, {rn-sae}
// CHECK:  encoding: [0x62,0xc1,0x66,0x10,0x51,0xf0]
          vsqrtss xmm22, xmm19, xmm8, {rn-sae}

// CHECK: vsqrtss xmm22, xmm19, xmm8, {ru-sae}
// CHECK:  encoding: [0x62,0xc1,0x66,0x50,0x51,0xf0]
          vsqrtss xmm22, xmm19, xmm8, {ru-sae}

// CHECK: vsqrtss xmm22, xmm19, xmm8, {rd-sae}
// CHECK:  encoding: [0x62,0xc1,0x66,0x30,0x51,0xf0]
          vsqrtss xmm22, xmm19, xmm8, {rd-sae}

// CHECK: vsqrtss xmm22, xmm19, xmm8, {rz-sae}
// CHECK:  encoding: [0x62,0xc1,0x66,0x70,0x51,0xf0]
          vsqrtss xmm22, xmm19, xmm8, {rz-sae}

// CHECK: vsqrtss xmm22, xmm19, dword ptr [rcx]
// CHECK:  encoding: [0x62,0xe1,0x66,0x00,0x51,0x31]
          vsqrtss xmm22, xmm19, dword ptr [rcx]

// CHECK: vsqrtss xmm22, xmm19, dword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0xa1,0x66,0x00,0x51,0xb4,0xf0,0x23,0x01,0x00,0x00]
          vsqrtss xmm22, xmm19, dword ptr [rax + 8*r14 + 291]

// CHECK: vsqrtss xmm22, xmm19, dword ptr [rdx + 508]
// CHECK:  encoding: [0x62,0xe1,0x66,0x00,0x51,0x72,0x7f]
          vsqrtss xmm22, xmm19, dword ptr [rdx + 508]

// CHECK: vsqrtss xmm22, xmm19, dword ptr [rdx + 512]
// CHECK:  encoding: [0x62,0xe1,0x66,0x00,0x51,0xb2,0x00,0x02,0x00,0x00]
          vsqrtss xmm22, xmm19, dword ptr [rdx + 512]

// CHECK: vsqrtss xmm22, xmm19, dword ptr [rdx - 512]
// CHECK:  encoding: [0x62,0xe1,0x66,0x00,0x51,0x72,0x80]
          vsqrtss xmm22, xmm19, dword ptr [rdx - 512]

// CHECK: vsqrtss xmm22, xmm19, dword ptr [rdx - 516]
// CHECK:  encoding: [0x62,0xe1,0x66,0x00,0x51,0xb2,0xfc,0xfd,0xff,0xff]
          vsqrtss xmm22, xmm19, dword ptr [rdx - 516]

// CHECK: vsubpd zmm9, zmm12, zmm9
// CHECK:  encoding: [0x62,0x51,0x9d,0x48,0x5c,0xc9]
          vsubpd zmm9, zmm12, zmm9

// CHECK: vsubpd zmm9 {k7}, zmm12, zmm9
// CHECK:  encoding: [0x62,0x51,0x9d,0x4f,0x5c,0xc9]
          vsubpd zmm9 {k7}, zmm12, zmm9

// CHECK: vsubpd zmm9 {k7} {z}, zmm12, zmm9
// CHECK:  encoding: [0x62,0x51,0x9d,0xcf,0x5c,0xc9]
          vsubpd zmm9 {k7} {z}, zmm12, zmm9

// CHECK: vsubpd zmm9, zmm12, zmm9, {rn-sae}
// CHECK:  encoding: [0x62,0x51,0x9d,0x18,0x5c,0xc9]
          vsubpd zmm9, zmm12, zmm9, {rn-sae}

// CHECK: vsubpd zmm9, zmm12, zmm9, {ru-sae}
// CHECK:  encoding: [0x62,0x51,0x9d,0x58,0x5c,0xc9]
          vsubpd zmm9, zmm12, zmm9, {ru-sae}

// CHECK: vsubpd zmm9, zmm12, zmm9, {rd-sae}
// CHECK:  encoding: [0x62,0x51,0x9d,0x38,0x5c,0xc9]
          vsubpd zmm9, zmm12, zmm9, {rd-sae}

// CHECK: vsubpd zmm9, zmm12, zmm9, {rz-sae}
// CHECK:  encoding: [0x62,0x51,0x9d,0x78,0x5c,0xc9]
          vsubpd zmm9, zmm12, zmm9, {rz-sae}

// CHECK: vsubpd zmm9, zmm12, zmmword ptr [rcx]
// CHECK:  encoding: [0x62,0x71,0x9d,0x48,0x5c,0x09]
          vsubpd zmm9, zmm12, zmmword ptr [rcx]

// CHECK: vsubpd zmm9, zmm12, zmmword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0x31,0x9d,0x48,0x5c,0x8c,0xf0,0x23,0x01,0x00,0x00]
          vsubpd zmm9, zmm12, zmmword ptr [rax + 8*r14 + 291]

// CHECK: vsubpd zmm9, zmm12, qword ptr [rcx]{1to8}
// CHECK:  encoding: [0x62,0x71,0x9d,0x58,0x5c,0x09]
          vsubpd zmm9, zmm12, qword ptr [rcx]{1to8}

// CHECK: vsubpd zmm9, zmm12, zmmword ptr [rdx + 8128]
// CHECK:  encoding: [0x62,0x71,0x9d,0x48,0x5c,0x4a,0x7f]
          vsubpd zmm9, zmm12, zmmword ptr [rdx + 8128]

// CHECK: vsubpd zmm9, zmm12, zmmword ptr [rdx + 8192]
// CHECK:  encoding: [0x62,0x71,0x9d,0x48,0x5c,0x8a,0x00,0x20,0x00,0x00]
          vsubpd zmm9, zmm12, zmmword ptr [rdx + 8192]

// CHECK: vsubpd zmm9, zmm12, zmmword ptr [rdx - 8192]
// CHECK:  encoding: [0x62,0x71,0x9d,0x48,0x5c,0x4a,0x80]
          vsubpd zmm9, zmm12, zmmword ptr [rdx - 8192]

// CHECK: vsubpd zmm9, zmm12, zmmword ptr [rdx - 8256]
// CHECK:  encoding: [0x62,0x71,0x9d,0x48,0x5c,0x8a,0xc0,0xdf,0xff,0xff]
          vsubpd zmm9, zmm12, zmmword ptr [rdx - 8256]

// CHECK: vsubpd zmm9, zmm12, qword ptr [rdx + 1016]{1to8}
// CHECK:  encoding: [0x62,0x71,0x9d,0x58,0x5c,0x4a,0x7f]
          vsubpd zmm9, zmm12, qword ptr [rdx + 1016]{1to8}

// CHECK: vsubpd zmm9, zmm12, qword ptr [rdx + 1024]{1to8}
// CHECK:  encoding: [0x62,0x71,0x9d,0x58,0x5c,0x8a,0x00,0x04,0x00,0x00]
          vsubpd zmm9, zmm12, qword ptr [rdx + 1024]{1to8}

// CHECK: vsubpd zmm9, zmm12, qword ptr [rdx - 1024]{1to8}
// CHECK:  encoding: [0x62,0x71,0x9d,0x58,0x5c,0x4a,0x80]
          vsubpd zmm9, zmm12, qword ptr [rdx - 1024]{1to8}

// CHECK: vsubpd zmm9, zmm12, qword ptr [rdx - 1032]{1to8}
// CHECK:  encoding: [0x62,0x71,0x9d,0x58,0x5c,0x8a,0xf8,0xfb,0xff,0xff]
          vsubpd zmm9, zmm12, qword ptr [rdx - 1032]{1to8}

// CHECK: vsubps zmm14, zmm27, zmm21
// CHECK:  encoding: [0x62,0x31,0x24,0x40,0x5c,0xf5]
          vsubps zmm14, zmm27, zmm21

// CHECK: vsubps zmm14 {k5}, zmm27, zmm21
// CHECK:  encoding: [0x62,0x31,0x24,0x45,0x5c,0xf5]
          vsubps zmm14 {k5}, zmm27, zmm21

// CHECK: vsubps zmm14 {k5} {z}, zmm27, zmm21
// CHECK:  encoding: [0x62,0x31,0x24,0xc5,0x5c,0xf5]
          vsubps zmm14 {k5} {z}, zmm27, zmm21

// CHECK: vsubps zmm14, zmm27, zmm21, {rn-sae}
// CHECK:  encoding: [0x62,0x31,0x24,0x10,0x5c,0xf5]
          vsubps zmm14, zmm27, zmm21, {rn-sae}

// CHECK: vsubps zmm14, zmm27, zmm21, {ru-sae}
// CHECK:  encoding: [0x62,0x31,0x24,0x50,0x5c,0xf5]
          vsubps zmm14, zmm27, zmm21, {ru-sae}

// CHECK: vsubps zmm14, zmm27, zmm21, {rd-sae}
// CHECK:  encoding: [0x62,0x31,0x24,0x30,0x5c,0xf5]
          vsubps zmm14, zmm27, zmm21, {rd-sae}

// CHECK: vsubps zmm14, zmm27, zmm21, {rz-sae}
// CHECK:  encoding: [0x62,0x31,0x24,0x70,0x5c,0xf5]
          vsubps zmm14, zmm27, zmm21, {rz-sae}

// CHECK: vsubps zmm14, zmm27, zmmword ptr [rcx]
// CHECK:  encoding: [0x62,0x71,0x24,0x40,0x5c,0x31]
          vsubps zmm14, zmm27, zmmword ptr [rcx]

// CHECK: vsubps zmm14, zmm27, zmmword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0x31,0x24,0x40,0x5c,0xb4,0xf0,0x23,0x01,0x00,0x00]
          vsubps zmm14, zmm27, zmmword ptr [rax + 8*r14 + 291]

// CHECK: vsubps zmm14, zmm27, dword ptr [rcx]{1to16}
// CHECK:  encoding: [0x62,0x71,0x24,0x50,0x5c,0x31]
          vsubps zmm14, zmm27, dword ptr [rcx]{1to16}

// CHECK: vsubps zmm14, zmm27, zmmword ptr [rdx + 8128]
// CHECK:  encoding: [0x62,0x71,0x24,0x40,0x5c,0x72,0x7f]
          vsubps zmm14, zmm27, zmmword ptr [rdx + 8128]

// CHECK: vsubps zmm14, zmm27, zmmword ptr [rdx + 8192]
// CHECK:  encoding: [0x62,0x71,0x24,0x40,0x5c,0xb2,0x00,0x20,0x00,0x00]
          vsubps zmm14, zmm27, zmmword ptr [rdx + 8192]

// CHECK: vsubps zmm14, zmm27, zmmword ptr [rdx - 8192]
// CHECK:  encoding: [0x62,0x71,0x24,0x40,0x5c,0x72,0x80]
          vsubps zmm14, zmm27, zmmword ptr [rdx - 8192]

// CHECK: vsubps zmm14, zmm27, zmmword ptr [rdx - 8256]
// CHECK:  encoding: [0x62,0x71,0x24,0x40,0x5c,0xb2,0xc0,0xdf,0xff,0xff]
          vsubps zmm14, zmm27, zmmword ptr [rdx - 8256]

// CHECK: vsubps zmm14, zmm27, dword ptr [rdx + 508]{1to16}
// CHECK:  encoding: [0x62,0x71,0x24,0x50,0x5c,0x72,0x7f]
          vsubps zmm14, zmm27, dword ptr [rdx + 508]{1to16}

// CHECK: vsubps zmm14, zmm27, dword ptr [rdx + 512]{1to16}
// CHECK:  encoding: [0x62,0x71,0x24,0x50,0x5c,0xb2,0x00,0x02,0x00,0x00]
          vsubps zmm14, zmm27, dword ptr [rdx + 512]{1to16}

// CHECK: vsubps zmm14, zmm27, dword ptr [rdx - 512]{1to16}
// CHECK:  encoding: [0x62,0x71,0x24,0x50,0x5c,0x72,0x80]
          vsubps zmm14, zmm27, dword ptr [rdx - 512]{1to16}

// CHECK: vsubps zmm14, zmm27, dword ptr [rdx - 516]{1to16}
// CHECK:  encoding: [0x62,0x71,0x24,0x50,0x5c,0xb2,0xfc,0xfd,0xff,0xff]
          vsubps zmm14, zmm27, dword ptr [rdx - 516]{1to16}

// CHECK: vsubsd xmm20, xmm27, xmm15
// CHECK:  encoding: [0x62,0xc1,0xa7,0x00,0x5c,0xe7]
          vsubsd xmm20, xmm27, xmm15

// CHECK: vsubsd xmm20 {k5}, xmm27, xmm15
// CHECK:  encoding: [0x62,0xc1,0xa7,0x05,0x5c,0xe7]
          vsubsd xmm20 {k5}, xmm27, xmm15

// CHECK: vsubsd xmm20 {k5} {z}, xmm27, xmm15
// CHECK:  encoding: [0x62,0xc1,0xa7,0x85,0x5c,0xe7]
          vsubsd xmm20 {k5} {z}, xmm27, xmm15

// CHECK: vsubsd xmm20, xmm27, xmm15, {rn-sae}
// CHECK:  encoding: [0x62,0xc1,0xa7,0x10,0x5c,0xe7]
          vsubsd xmm20, xmm27, xmm15, {rn-sae}

// CHECK: vsubsd xmm20, xmm27, xmm15, {ru-sae}
// CHECK:  encoding: [0x62,0xc1,0xa7,0x50,0x5c,0xe7]
          vsubsd xmm20, xmm27, xmm15, {ru-sae}

// CHECK: vsubsd xmm20, xmm27, xmm15, {rd-sae}
// CHECK:  encoding: [0x62,0xc1,0xa7,0x30,0x5c,0xe7]
          vsubsd xmm20, xmm27, xmm15, {rd-sae}

// CHECK: vsubsd xmm20, xmm27, xmm15, {rz-sae}
// CHECK:  encoding: [0x62,0xc1,0xa7,0x70,0x5c,0xe7]
          vsubsd xmm20, xmm27, xmm15, {rz-sae}

// CHECK: vsubsd xmm20, xmm27, qword ptr [rcx]
// CHECK:  encoding: [0x62,0xe1,0xa7,0x00,0x5c,0x21]
          vsubsd xmm20, xmm27, qword ptr [rcx]

// CHECK: vsubsd xmm20, xmm27, qword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0xa1,0xa7,0x00,0x5c,0xa4,0xf0,0x23,0x01,0x00,0x00]
          vsubsd xmm20, xmm27, qword ptr [rax + 8*r14 + 291]

// CHECK: vsubsd xmm20, xmm27, qword ptr [rdx + 1016]
// CHECK:  encoding: [0x62,0xe1,0xa7,0x00,0x5c,0x62,0x7f]
          vsubsd xmm20, xmm27, qword ptr [rdx + 1016]

// CHECK: vsubsd xmm20, xmm27, qword ptr [rdx + 1024]
// CHECK:  encoding: [0x62,0xe1,0xa7,0x00,0x5c,0xa2,0x00,0x04,0x00,0x00]
          vsubsd xmm20, xmm27, qword ptr [rdx + 1024]

// CHECK: vsubsd xmm20, xmm27, qword ptr [rdx - 1024]
// CHECK:  encoding: [0x62,0xe1,0xa7,0x00,0x5c,0x62,0x80]
          vsubsd xmm20, xmm27, qword ptr [rdx - 1024]

// CHECK: vsubsd xmm20, xmm27, qword ptr [rdx - 1032]
// CHECK:  encoding: [0x62,0xe1,0xa7,0x00,0x5c,0xa2,0xf8,0xfb,0xff,0xff]
          vsubsd xmm20, xmm27, qword ptr [rdx - 1032]

// CHECK: vsubss xmm5, xmm25, xmm9
// CHECK:  encoding: [0x62,0xd1,0x36,0x00,0x5c,0xe9]
          vsubss xmm5, xmm25, xmm9

// CHECK: vsubss xmm5 {k3}, xmm25, xmm9
// CHECK:  encoding: [0x62,0xd1,0x36,0x03,0x5c,0xe9]
          vsubss xmm5 {k3}, xmm25, xmm9

// CHECK: vsubss xmm5 {k3} {z}, xmm25, xmm9
// CHECK:  encoding: [0x62,0xd1,0x36,0x83,0x5c,0xe9]
          vsubss xmm5 {k3} {z}, xmm25, xmm9

// CHECK: vsubss xmm5, xmm25, xmm9, {rn-sae}
// CHECK:  encoding: [0x62,0xd1,0x36,0x10,0x5c,0xe9]
          vsubss xmm5, xmm25, xmm9, {rn-sae}

// CHECK: vsubss xmm5, xmm25, xmm9, {ru-sae}
// CHECK:  encoding: [0x62,0xd1,0x36,0x50,0x5c,0xe9]
          vsubss xmm5, xmm25, xmm9, {ru-sae}

// CHECK: vsubss xmm5, xmm25, xmm9, {rd-sae}
// CHECK:  encoding: [0x62,0xd1,0x36,0x30,0x5c,0xe9]
          vsubss xmm5, xmm25, xmm9, {rd-sae}

// CHECK: vsubss xmm5, xmm25, xmm9, {rz-sae}
// CHECK:  encoding: [0x62,0xd1,0x36,0x70,0x5c,0xe9]
          vsubss xmm5, xmm25, xmm9, {rz-sae}

// CHECK: vsubss xmm5, xmm25, dword ptr [rcx]
// CHECK:  encoding: [0x62,0xf1,0x36,0x00,0x5c,0x29]
          vsubss xmm5, xmm25, dword ptr [rcx]

// CHECK: vsubss xmm5, xmm25, dword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0xb1,0x36,0x00,0x5c,0xac,0xf0,0x23,0x01,0x00,0x00]
          vsubss xmm5, xmm25, dword ptr [rax + 8*r14 + 291]

// CHECK: vsubss xmm5, xmm25, dword ptr [rdx + 508]
// CHECK:  encoding: [0x62,0xf1,0x36,0x00,0x5c,0x6a,0x7f]
          vsubss xmm5, xmm25, dword ptr [rdx + 508]

// CHECK: vsubss xmm5, xmm25, dword ptr [rdx + 512]
// CHECK:  encoding: [0x62,0xf1,0x36,0x00,0x5c,0xaa,0x00,0x02,0x00,0x00]
          vsubss xmm5, xmm25, dword ptr [rdx + 512]

// CHECK: vsubss xmm5, xmm25, dword ptr [rdx - 512]
// CHECK:  encoding: [0x62,0xf1,0x36,0x00,0x5c,0x6a,0x80]
          vsubss xmm5, xmm25, dword ptr [rdx - 512]

// CHECK: vsubss xmm5, xmm25, dword ptr [rdx - 516]
// CHECK:  encoding: [0x62,0xf1,0x36,0x00,0x5c,0xaa,0xfc,0xfd,0xff,0xff]
          vsubss xmm5, xmm25, dword ptr [rdx - 516]

// CHECK: vucomisd xmm11, xmm10
// CHECK:  encoding: [0xc4,0x41,0x79,0x2e,0xda]
          vucomisd xmm11, xmm10

// CHECK: vucomisd xmm11, xmm10, {sae}
// CHECK:  encoding: [0x62,0x51,0xfd,0x18,0x2e,0xda]
          vucomisd xmm11, xmm10, {sae}

// CHECK: vucomisd xmm11, qword ptr [rcx]
// CHECK:  encoding: [0xc5,0x79,0x2e,0x19]
          vucomisd xmm11, qword ptr [rcx]

// CHECK: vucomisd xmm11, qword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0xc4,0x21,0x79,0x2e,0x9c,0xf0,0x23,0x01,0x00,0x00]
          vucomisd xmm11, qword ptr [rax + 8*r14 + 291]

// CHECK: vucomisd xmm11, qword ptr [rdx + 1016]
// CHECK:  encoding: [0xc5,0x79,0x2e,0x9a,0xf8,0x03,0x00,0x00]
          vucomisd xmm11, qword ptr [rdx + 1016]

// CHECK: vucomisd xmm11, qword ptr [rdx + 1024]
// CHECK:  encoding: [0xc5,0x79,0x2e,0x9a,0x00,0x04,0x00,0x00]
          vucomisd xmm11, qword ptr [rdx + 1024]

// CHECK: vucomisd xmm11, qword ptr [rdx - 1024]
// CHECK:  encoding: [0xc5,0x79,0x2e,0x9a,0x00,0xfc,0xff,0xff]
          vucomisd xmm11, qword ptr [rdx - 1024]

// CHECK: vucomisd xmm11, qword ptr [rdx - 1032]
// CHECK:  encoding: [0xc5,0x79,0x2e,0x9a,0xf8,0xfb,0xff,0xff]
          vucomisd xmm11, qword ptr [rdx - 1032]

// CHECK: vucomiss xmm22, xmm11
// CHECK:  encoding: [0x62,0xc1,0x7c,0x08,0x2e,0xf3]
          vucomiss xmm22, xmm11

// CHECK: vucomiss xmm22, xmm11, {sae}
// CHECK:  encoding: [0x62,0xc1,0x7c,0x18,0x2e,0xf3]
          vucomiss xmm22, xmm11, {sae}

// CHECK: vucomiss xmm22, dword ptr [rcx]
// CHECK:  encoding: [0x62,0xe1,0x7c,0x08,0x2e,0x31]
          vucomiss xmm22, dword ptr [rcx]

// CHECK: vucomiss xmm22, dword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0xa1,0x7c,0x08,0x2e,0xb4,0xf0,0x23,0x01,0x00,0x00]
          vucomiss xmm22, dword ptr [rax + 8*r14 + 291]

// CHECK: vucomiss xmm22, dword ptr [rdx + 508]
// CHECK:  encoding: [0x62,0xe1,0x7c,0x08,0x2e,0x72,0x7f]
          vucomiss xmm22, dword ptr [rdx + 508]

// CHECK: vucomiss xmm22, dword ptr [rdx + 512]
// CHECK:  encoding: [0x62,0xe1,0x7c,0x08,0x2e,0xb2,0x00,0x02,0x00,0x00]
          vucomiss xmm22, dword ptr [rdx + 512]

// CHECK: vucomiss xmm22, dword ptr [rdx - 512]
// CHECK:  encoding: [0x62,0xe1,0x7c,0x08,0x2e,0x72,0x80]
          vucomiss xmm22, dword ptr [rdx - 512]

// CHECK: vucomiss xmm22, dword ptr [rdx - 516]
// CHECK:  encoding: [0x62,0xe1,0x7c,0x08,0x2e,0xb2,0xfc,0xfd,0xff,0xff]
          vucomiss xmm22, dword ptr [rdx - 516]

// CHECK: vunpckhpd zmm25, zmm19, zmm26
// CHECK:  encoding: [0x62,0x01,0xe5,0x40,0x15,0xca]
          vunpckhpd zmm25, zmm19, zmm26

// CHECK: vunpckhpd zmm25 {k5}, zmm19, zmm26
// CHECK:  encoding: [0x62,0x01,0xe5,0x45,0x15,0xca]
          vunpckhpd zmm25 {k5}, zmm19, zmm26

// CHECK: vunpckhpd zmm25 {k5} {z}, zmm19, zmm26
// CHECK:  encoding: [0x62,0x01,0xe5,0xc5,0x15,0xca]
          vunpckhpd zmm25 {k5} {z}, zmm19, zmm26

// CHECK: vunpckhpd zmm25, zmm19, zmmword ptr [rcx]
// CHECK:  encoding: [0x62,0x61,0xe5,0x40,0x15,0x09]
          vunpckhpd zmm25, zmm19, zmmword ptr [rcx]

// CHECK: vunpckhpd zmm25, zmm19, zmmword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0x21,0xe5,0x40,0x15,0x8c,0xf0,0x23,0x01,0x00,0x00]
          vunpckhpd zmm25, zmm19, zmmword ptr [rax + 8*r14 + 291]

// CHECK: vunpckhpd zmm25, zmm19, qword ptr [rcx]{1to8}
// CHECK:  encoding: [0x62,0x61,0xe5,0x50,0x15,0x09]
          vunpckhpd zmm25, zmm19, qword ptr [rcx]{1to8}

// CHECK: vunpckhpd zmm25, zmm19, zmmword ptr [rdx + 8128]
// CHECK:  encoding: [0x62,0x61,0xe5,0x40,0x15,0x4a,0x7f]
          vunpckhpd zmm25, zmm19, zmmword ptr [rdx + 8128]

// CHECK: vunpckhpd zmm25, zmm19, zmmword ptr [rdx + 8192]
// CHECK:  encoding: [0x62,0x61,0xe5,0x40,0x15,0x8a,0x00,0x20,0x00,0x00]
          vunpckhpd zmm25, zmm19, zmmword ptr [rdx + 8192]

// CHECK: vunpckhpd zmm25, zmm19, zmmword ptr [rdx - 8192]
// CHECK:  encoding: [0x62,0x61,0xe5,0x40,0x15,0x4a,0x80]
          vunpckhpd zmm25, zmm19, zmmword ptr [rdx - 8192]

// CHECK: vunpckhpd zmm25, zmm19, zmmword ptr [rdx - 8256]
// CHECK:  encoding: [0x62,0x61,0xe5,0x40,0x15,0x8a,0xc0,0xdf,0xff,0xff]
          vunpckhpd zmm25, zmm19, zmmword ptr [rdx - 8256]

// CHECK: vunpckhpd zmm25, zmm19, qword ptr [rdx + 1016]{1to8}
// CHECK:  encoding: [0x62,0x61,0xe5,0x50,0x15,0x4a,0x7f]
          vunpckhpd zmm25, zmm19, qword ptr [rdx + 1016]{1to8}

// CHECK: vunpckhpd zmm25, zmm19, qword ptr [rdx + 1024]{1to8}
// CHECK:  encoding: [0x62,0x61,0xe5,0x50,0x15,0x8a,0x00,0x04,0x00,0x00]
          vunpckhpd zmm25, zmm19, qword ptr [rdx + 1024]{1to8}

// CHECK: vunpckhpd zmm25, zmm19, qword ptr [rdx - 1024]{1to8}
// CHECK:  encoding: [0x62,0x61,0xe5,0x50,0x15,0x4a,0x80]
          vunpckhpd zmm25, zmm19, qword ptr [rdx - 1024]{1to8}

// CHECK: vunpckhpd zmm25, zmm19, qword ptr [rdx - 1032]{1to8}
// CHECK:  encoding: [0x62,0x61,0xe5,0x50,0x15,0x8a,0xf8,0xfb,0xff,0xff]
          vunpckhpd zmm25, zmm19, qword ptr [rdx - 1032]{1to8}

// CHECK: vunpckhps zmm5, zmm14, zmm16
// CHECK:  encoding: [0x62,0xb1,0x0c,0x48,0x15,0xe8]
          vunpckhps zmm5, zmm14, zmm16

// CHECK: vunpckhps zmm5 {k6}, zmm14, zmm16
// CHECK:  encoding: [0x62,0xb1,0x0c,0x4e,0x15,0xe8]
          vunpckhps zmm5 {k6}, zmm14, zmm16

// CHECK: vunpckhps zmm5 {k6} {z}, zmm14, zmm16
// CHECK:  encoding: [0x62,0xb1,0x0c,0xce,0x15,0xe8]
          vunpckhps zmm5 {k6} {z}, zmm14, zmm16

// CHECK: vunpckhps zmm5, zmm14, zmmword ptr [rcx]
// CHECK:  encoding: [0x62,0xf1,0x0c,0x48,0x15,0x29]
          vunpckhps zmm5, zmm14, zmmword ptr [rcx]

// CHECK: vunpckhps zmm5, zmm14, zmmword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0xb1,0x0c,0x48,0x15,0xac,0xf0,0x23,0x01,0x00,0x00]
          vunpckhps zmm5, zmm14, zmmword ptr [rax + 8*r14 + 291]

// CHECK: vunpckhps zmm5, zmm14, dword ptr [rcx]{1to16}
// CHECK:  encoding: [0x62,0xf1,0x0c,0x58,0x15,0x29]
          vunpckhps zmm5, zmm14, dword ptr [rcx]{1to16}

// CHECK: vunpckhps zmm5, zmm14, zmmword ptr [rdx + 8128]
// CHECK:  encoding: [0x62,0xf1,0x0c,0x48,0x15,0x6a,0x7f]
          vunpckhps zmm5, zmm14, zmmword ptr [rdx + 8128]

// CHECK: vunpckhps zmm5, zmm14, zmmword ptr [rdx + 8192]
// CHECK:  encoding: [0x62,0xf1,0x0c,0x48,0x15,0xaa,0x00,0x20,0x00,0x00]
          vunpckhps zmm5, zmm14, zmmword ptr [rdx + 8192]

// CHECK: vunpckhps zmm5, zmm14, zmmword ptr [rdx - 8192]
// CHECK:  encoding: [0x62,0xf1,0x0c,0x48,0x15,0x6a,0x80]
          vunpckhps zmm5, zmm14, zmmword ptr [rdx - 8192]

// CHECK: vunpckhps zmm5, zmm14, zmmword ptr [rdx - 8256]
// CHECK:  encoding: [0x62,0xf1,0x0c,0x48,0x15,0xaa,0xc0,0xdf,0xff,0xff]
          vunpckhps zmm5, zmm14, zmmword ptr [rdx - 8256]

// CHECK: vunpckhps zmm5, zmm14, dword ptr [rdx + 508]{1to16}
// CHECK:  encoding: [0x62,0xf1,0x0c,0x58,0x15,0x6a,0x7f]
          vunpckhps zmm5, zmm14, dword ptr [rdx + 508]{1to16}

// CHECK: vunpckhps zmm5, zmm14, dword ptr [rdx + 512]{1to16}
// CHECK:  encoding: [0x62,0xf1,0x0c,0x58,0x15,0xaa,0x00,0x02,0x00,0x00]
          vunpckhps zmm5, zmm14, dword ptr [rdx + 512]{1to16}

// CHECK: vunpckhps zmm5, zmm14, dword ptr [rdx - 512]{1to16}
// CHECK:  encoding: [0x62,0xf1,0x0c,0x58,0x15,0x6a,0x80]
          vunpckhps zmm5, zmm14, dword ptr [rdx - 512]{1to16}

// CHECK: vunpckhps zmm5, zmm14, dword ptr [rdx - 516]{1to16}
// CHECK:  encoding: [0x62,0xf1,0x0c,0x58,0x15,0xaa,0xfc,0xfd,0xff,0xff]
          vunpckhps zmm5, zmm14, dword ptr [rdx - 516]{1to16}

// CHECK: vunpcklpd zmm18, zmm29, zmm21
// CHECK:  encoding: [0x62,0xa1,0x95,0x40,0x14,0xd5]
          vunpcklpd zmm18, zmm29, zmm21

// CHECK: vunpcklpd zmm18 {k6}, zmm29, zmm21
// CHECK:  encoding: [0x62,0xa1,0x95,0x46,0x14,0xd5]
          vunpcklpd zmm18 {k6}, zmm29, zmm21

// CHECK: vunpcklpd zmm18 {k6} {z}, zmm29, zmm21
// CHECK:  encoding: [0x62,0xa1,0x95,0xc6,0x14,0xd5]
          vunpcklpd zmm18 {k6} {z}, zmm29, zmm21

// CHECK: vunpcklpd zmm18, zmm29, zmmword ptr [rcx]
// CHECK:  encoding: [0x62,0xe1,0x95,0x40,0x14,0x11]
          vunpcklpd zmm18, zmm29, zmmword ptr [rcx]

// CHECK: vunpcklpd zmm18, zmm29, zmmword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0xa1,0x95,0x40,0x14,0x94,0xf0,0x23,0x01,0x00,0x00]
          vunpcklpd zmm18, zmm29, zmmword ptr [rax + 8*r14 + 291]

// CHECK: vunpcklpd zmm18, zmm29, qword ptr [rcx]{1to8}
// CHECK:  encoding: [0x62,0xe1,0x95,0x50,0x14,0x11]
          vunpcklpd zmm18, zmm29, qword ptr [rcx]{1to8}

// CHECK: vunpcklpd zmm18, zmm29, zmmword ptr [rdx + 8128]
// CHECK:  encoding: [0x62,0xe1,0x95,0x40,0x14,0x52,0x7f]
          vunpcklpd zmm18, zmm29, zmmword ptr [rdx + 8128]

// CHECK: vunpcklpd zmm18, zmm29, zmmword ptr [rdx + 8192]
// CHECK:  encoding: [0x62,0xe1,0x95,0x40,0x14,0x92,0x00,0x20,0x00,0x00]
          vunpcklpd zmm18, zmm29, zmmword ptr [rdx + 8192]

// CHECK: vunpcklpd zmm18, zmm29, zmmword ptr [rdx - 8192]
// CHECK:  encoding: [0x62,0xe1,0x95,0x40,0x14,0x52,0x80]
          vunpcklpd zmm18, zmm29, zmmword ptr [rdx - 8192]

// CHECK: vunpcklpd zmm18, zmm29, zmmword ptr [rdx - 8256]
// CHECK:  encoding: [0x62,0xe1,0x95,0x40,0x14,0x92,0xc0,0xdf,0xff,0xff]
          vunpcklpd zmm18, zmm29, zmmword ptr [rdx - 8256]

// CHECK: vunpcklpd zmm18, zmm29, qword ptr [rdx + 1016]{1to8}
// CHECK:  encoding: [0x62,0xe1,0x95,0x50,0x14,0x52,0x7f]
          vunpcklpd zmm18, zmm29, qword ptr [rdx + 1016]{1to8}

// CHECK: vunpcklpd zmm18, zmm29, qword ptr [rdx + 1024]{1to8}
// CHECK:  encoding: [0x62,0xe1,0x95,0x50,0x14,0x92,0x00,0x04,0x00,0x00]
          vunpcklpd zmm18, zmm29, qword ptr [rdx + 1024]{1to8}

// CHECK: vunpcklpd zmm18, zmm29, qword ptr [rdx - 1024]{1to8}
// CHECK:  encoding: [0x62,0xe1,0x95,0x50,0x14,0x52,0x80]
          vunpcklpd zmm18, zmm29, qword ptr [rdx - 1024]{1to8}

// CHECK: vunpcklpd zmm18, zmm29, qword ptr [rdx - 1032]{1to8}
// CHECK:  encoding: [0x62,0xe1,0x95,0x50,0x14,0x92,0xf8,0xfb,0xff,0xff]
          vunpcklpd zmm18, zmm29, qword ptr [rdx - 1032]{1to8}

// CHECK: vunpcklps zmm1, zmm3, zmm2
// CHECK:  encoding: [0x62,0xf1,0x64,0x48,0x14,0xca]
          vunpcklps zmm1, zmm3, zmm2

// CHECK: vunpcklps zmm1 {k3}, zmm3, zmm2
// CHECK:  encoding: [0x62,0xf1,0x64,0x4b,0x14,0xca]
          vunpcklps zmm1 {k3}, zmm3, zmm2

// CHECK: vunpcklps zmm1 {k3} {z}, zmm3, zmm2
// CHECK:  encoding: [0x62,0xf1,0x64,0xcb,0x14,0xca]
          vunpcklps zmm1 {k3} {z}, zmm3, zmm2

// CHECK: vunpcklps zmm1, zmm3, zmmword ptr [rcx]
// CHECK:  encoding: [0x62,0xf1,0x64,0x48,0x14,0x09]
          vunpcklps zmm1, zmm3, zmmword ptr [rcx]

// CHECK: vunpcklps zmm1, zmm3, zmmword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0xb1,0x64,0x48,0x14,0x8c,0xf0,0x23,0x01,0x00,0x00]
          vunpcklps zmm1, zmm3, zmmword ptr [rax + 8*r14 + 291]

// CHECK: vunpcklps zmm1, zmm3, dword ptr [rcx]{1to16}
// CHECK:  encoding: [0x62,0xf1,0x64,0x58,0x14,0x09]
          vunpcklps zmm1, zmm3, dword ptr [rcx]{1to16}

// CHECK: vunpcklps zmm1, zmm3, zmmword ptr [rdx + 8128]
// CHECK:  encoding: [0x62,0xf1,0x64,0x48,0x14,0x4a,0x7f]
          vunpcklps zmm1, zmm3, zmmword ptr [rdx + 8128]

// CHECK: vunpcklps zmm1, zmm3, zmmword ptr [rdx + 8192]
// CHECK:  encoding: [0x62,0xf1,0x64,0x48,0x14,0x8a,0x00,0x20,0x00,0x00]
          vunpcklps zmm1, zmm3, zmmword ptr [rdx + 8192]

// CHECK: vunpcklps zmm1, zmm3, zmmword ptr [rdx - 8192]
// CHECK:  encoding: [0x62,0xf1,0x64,0x48,0x14,0x4a,0x80]
          vunpcklps zmm1, zmm3, zmmword ptr [rdx - 8192]

// CHECK: vunpcklps zmm1, zmm3, zmmword ptr [rdx - 8256]
// CHECK:  encoding: [0x62,0xf1,0x64,0x48,0x14,0x8a,0xc0,0xdf,0xff,0xff]
          vunpcklps zmm1, zmm3, zmmword ptr [rdx - 8256]

// CHECK: vunpcklps zmm1, zmm3, dword ptr [rdx + 508]{1to16}
// CHECK:  encoding: [0x62,0xf1,0x64,0x58,0x14,0x4a,0x7f]
          vunpcklps zmm1, zmm3, dword ptr [rdx + 508]{1to16}

// CHECK: vunpcklps zmm1, zmm3, dword ptr [rdx + 512]{1to16}
// CHECK:  encoding: [0x62,0xf1,0x64,0x58,0x14,0x8a,0x00,0x02,0x00,0x00]
          vunpcklps zmm1, zmm3, dword ptr [rdx + 512]{1to16}

// CHECK: vunpcklps zmm1, zmm3, dword ptr [rdx - 512]{1to16}
// CHECK:  encoding: [0x62,0xf1,0x64,0x58,0x14,0x4a,0x80]
          vunpcklps zmm1, zmm3, dword ptr [rdx - 512]{1to16}

// CHECK: vunpcklps zmm1, zmm3, dword ptr [rdx - 516]{1to16}
// CHECK:  encoding: [0x62,0xf1,0x64,0x58,0x14,0x8a,0xfc,0xfd,0xff,0xff]
          vunpcklps zmm1, zmm3, dword ptr [rdx - 516]{1to16}

// CHECK: vpternlogd zmm12, zmm14, zmm20, 171
// CHECK:  encoding: [0x62,0x33,0x0d,0x48,0x25,0xe4,0xab]
          vpternlogd zmm12, zmm14, zmm20, 171

// CHECK: vpternlogd zmm12 {k7}, zmm14, zmm20, 171
// CHECK:  encoding: [0x62,0x33,0x0d,0x4f,0x25,0xe4,0xab]
          vpternlogd zmm12 {k7}, zmm14, zmm20, 171

// CHECK: vpternlogd zmm12 {k7} {z}, zmm14, zmm20, 171
// CHECK:  encoding: [0x62,0x33,0x0d,0xcf,0x25,0xe4,0xab]
          vpternlogd zmm12 {k7} {z}, zmm14, zmm20, 171

// CHECK: vpternlogd zmm12, zmm14, zmm20, 123
// CHECK:  encoding: [0x62,0x33,0x0d,0x48,0x25,0xe4,0x7b]
          vpternlogd zmm12, zmm14, zmm20, 123

// CHECK: vpternlogd zmm12, zmm14, zmmword ptr [rcx], 123
// CHECK:  encoding: [0x62,0x73,0x0d,0x48,0x25,0x21,0x7b]
          vpternlogd zmm12, zmm14, zmmword ptr [rcx], 123

// CHECK: vpternlogd zmm12, zmm14, zmmword ptr [rax + 8*r14 + 291], 123
// CHECK:  encoding: [0x62,0x33,0x0d,0x48,0x25,0xa4,0xf0,0x23,0x01,0x00,0x00,0x7b]
          vpternlogd zmm12, zmm14, zmmword ptr [rax + 8*r14 + 291], 123

// CHECK: vpternlogd zmm12, zmm14, dword ptr [rcx]{1to16}, 123
// CHECK:  encoding: [0x62,0x73,0x0d,0x58,0x25,0x21,0x7b]
          vpternlogd zmm12, zmm14, dword ptr [rcx]{1to16}, 123

// CHECK: vpternlogd zmm12, zmm14, zmmword ptr [rdx + 8128], 123
// CHECK:  encoding: [0x62,0x73,0x0d,0x48,0x25,0x62,0x7f,0x7b]
          vpternlogd zmm12, zmm14, zmmword ptr [rdx + 8128], 123

// CHECK: vpternlogd zmm12, zmm14, zmmword ptr [rdx + 8192], 123
// CHECK:  encoding: [0x62,0x73,0x0d,0x48,0x25,0xa2,0x00,0x20,0x00,0x00,0x7b]
          vpternlogd zmm12, zmm14, zmmword ptr [rdx + 8192], 123

// CHECK: vpternlogd zmm12, zmm14, zmmword ptr [rdx - 8192], 123
// CHECK:  encoding: [0x62,0x73,0x0d,0x48,0x25,0x62,0x80,0x7b]
          vpternlogd zmm12, zmm14, zmmword ptr [rdx - 8192], 123

// CHECK: vpternlogd zmm12, zmm14, zmmword ptr [rdx - 8256], 123
// CHECK:  encoding: [0x62,0x73,0x0d,0x48,0x25,0xa2,0xc0,0xdf,0xff,0xff,0x7b]
          vpternlogd zmm12, zmm14, zmmword ptr [rdx - 8256], 123

// CHECK: vpternlogd zmm12, zmm14, dword ptr [rdx + 508]{1to16}, 123
// CHECK:  encoding: [0x62,0x73,0x0d,0x58,0x25,0x62,0x7f,0x7b]
          vpternlogd zmm12, zmm14, dword ptr [rdx + 508]{1to16}, 123

// CHECK: vpternlogd zmm12, zmm14, dword ptr [rdx + 512]{1to16}, 123
// CHECK:  encoding: [0x62,0x73,0x0d,0x58,0x25,0xa2,0x00,0x02,0x00,0x00,0x7b]
          vpternlogd zmm12, zmm14, dword ptr [rdx + 512]{1to16}, 123

// CHECK: vpternlogd zmm12, zmm14, dword ptr [rdx - 512]{1to16}, 123
// CHECK:  encoding: [0x62,0x73,0x0d,0x58,0x25,0x62,0x80,0x7b]
          vpternlogd zmm12, zmm14, dword ptr [rdx - 512]{1to16}, 123

// CHECK: vpternlogd zmm12, zmm14, dword ptr [rdx - 516]{1to16}, 123
// CHECK:  encoding: [0x62,0x73,0x0d,0x58,0x25,0xa2,0xfc,0xfd,0xff,0xff,0x7b]
          vpternlogd zmm12, zmm14, dword ptr [rdx - 516]{1to16}, 123

// CHECK: vpternlogq zmm15, zmm2, zmm21, 171
// CHECK:  encoding: [0x62,0x33,0xed,0x48,0x25,0xfd,0xab]
          vpternlogq zmm15, zmm2, zmm21, 171

// CHECK: vpternlogq zmm15 {k3}, zmm2, zmm21, 171
// CHECK:  encoding: [0x62,0x33,0xed,0x4b,0x25,0xfd,0xab]
          vpternlogq zmm15 {k3}, zmm2, zmm21, 171

// CHECK: vpternlogq zmm15 {k3} {z}, zmm2, zmm21, 171
// CHECK:  encoding: [0x62,0x33,0xed,0xcb,0x25,0xfd,0xab]
          vpternlogq zmm15 {k3} {z}, zmm2, zmm21, 171

// CHECK: vpternlogq zmm15, zmm2, zmm21, 123
// CHECK:  encoding: [0x62,0x33,0xed,0x48,0x25,0xfd,0x7b]
          vpternlogq zmm15, zmm2, zmm21, 123

// CHECK: vpternlogq zmm15, zmm2, zmmword ptr [rcx], 123
// CHECK:  encoding: [0x62,0x73,0xed,0x48,0x25,0x39,0x7b]
          vpternlogq zmm15, zmm2, zmmword ptr [rcx], 123

// CHECK: vpternlogq zmm15, zmm2, zmmword ptr [rax + 8*r14 + 291], 123
// CHECK:  encoding: [0x62,0x33,0xed,0x48,0x25,0xbc,0xf0,0x23,0x01,0x00,0x00,0x7b]
          vpternlogq zmm15, zmm2, zmmword ptr [rax + 8*r14 + 291], 123

// CHECK: vpternlogq zmm15, zmm2, qword ptr [rcx]{1to8}, 123
// CHECK:  encoding: [0x62,0x73,0xed,0x58,0x25,0x39,0x7b]
          vpternlogq zmm15, zmm2, qword ptr [rcx]{1to8}, 123

// CHECK: vpternlogq zmm15, zmm2, zmmword ptr [rdx + 8128], 123
// CHECK:  encoding: [0x62,0x73,0xed,0x48,0x25,0x7a,0x7f,0x7b]
          vpternlogq zmm15, zmm2, zmmword ptr [rdx + 8128], 123

// CHECK: vpternlogq zmm15, zmm2, zmmword ptr [rdx + 8192], 123
// CHECK:  encoding: [0x62,0x73,0xed,0x48,0x25,0xba,0x00,0x20,0x00,0x00,0x7b]
          vpternlogq zmm15, zmm2, zmmword ptr [rdx + 8192], 123

// CHECK: vpternlogq zmm15, zmm2, zmmword ptr [rdx - 8192], 123
// CHECK:  encoding: [0x62,0x73,0xed,0x48,0x25,0x7a,0x80,0x7b]
          vpternlogq zmm15, zmm2, zmmword ptr [rdx - 8192], 123

// CHECK: vpternlogq zmm15, zmm2, zmmword ptr [rdx - 8256], 123
// CHECK:  encoding: [0x62,0x73,0xed,0x48,0x25,0xba,0xc0,0xdf,0xff,0xff,0x7b]
          vpternlogq zmm15, zmm2, zmmword ptr [rdx - 8256], 123

// CHECK: vpternlogq zmm15, zmm2, qword ptr [rdx + 1016]{1to8}, 123
// CHECK:  encoding: [0x62,0x73,0xed,0x58,0x25,0x7a,0x7f,0x7b]
          vpternlogq zmm15, zmm2, qword ptr [rdx + 1016]{1to8}, 123

// CHECK: vpternlogq zmm15, zmm2, qword ptr [rdx + 1024]{1to8}, 123
// CHECK:  encoding: [0x62,0x73,0xed,0x58,0x25,0xba,0x00,0x04,0x00,0x00,0x7b]
          vpternlogq zmm15, zmm2, qword ptr [rdx + 1024]{1to8}, 123

// CHECK: vpternlogq zmm15, zmm2, qword ptr [rdx - 1024]{1to8}, 123
// CHECK:  encoding: [0x62,0x73,0xed,0x58,0x25,0x7a,0x80,0x7b]
          vpternlogq zmm15, zmm2, qword ptr [rdx - 1024]{1to8}, 123

// CHECK: vpternlogq zmm15, zmm2, qword ptr [rdx - 1032]{1to8}, 123
// CHECK:  encoding: [0x62,0x73,0xed,0x58,0x25,0xba,0xf8,0xfb,0xff,0xff,0x7b]
          vpternlogq zmm15, zmm2, qword ptr [rdx - 1032]{1to8}, 123

// CHECK: vpmovqb xmm3, zmm2
// CHECK:  encoding: [0x62,0xf2,0x7e,0x48,0x32,0xd3]
          vpmovqb xmm3, zmm2

// CHECK: vpmovqb xmm3 {k1}, zmm2
// CHECK:  encoding: [0x62,0xf2,0x7e,0x49,0x32,0xd3]
          vpmovqb xmm3 {k1}, zmm2

// CHECK: vpmovqb xmm3 {k1} {z}, zmm2
// CHECK:  encoding: [0x62,0xf2,0x7e,0xc9,0x32,0xd3]
          vpmovqb xmm3 {k1} {z}, zmm2

// CHECK: vpmovsqb xmm30, zmm29
// CHECK:  encoding: [0x62,0x02,0x7e,0x48,0x22,0xee]
          vpmovsqb xmm30, zmm29

// CHECK: vpmovsqb xmm30 {k5}, zmm29
// CHECK:  encoding: [0x62,0x02,0x7e,0x4d,0x22,0xee]
          vpmovsqb xmm30 {k5}, zmm29

// CHECK: vpmovsqb xmm30 {k5} {z}, zmm29
// CHECK:  encoding: [0x62,0x02,0x7e,0xcd,0x22,0xee]
          vpmovsqb xmm30 {k5} {z}, zmm29

// CHECK: vpmovusqb xmm24, zmm28
// CHECK:  encoding: [0x62,0x02,0x7e,0x48,0x12,0xe0]
          vpmovusqb xmm24, zmm28

// CHECK: vpmovusqb xmm24 {k7}, zmm28
// CHECK:  encoding: [0x62,0x02,0x7e,0x4f,0x12,0xe0]
          vpmovusqb xmm24 {k7}, zmm28

// CHECK: vpmovusqb xmm24 {k7} {z}, zmm28
// CHECK:  encoding: [0x62,0x02,0x7e,0xcf,0x12,0xe0]
          vpmovusqb xmm24 {k7} {z}, zmm28

// CHECK: vpmovqw xmm6, zmm18
// CHECK:  encoding: [0x62,0xe2,0x7e,0x48,0x34,0xd6]
          vpmovqw xmm6, zmm18

// CHECK: vpmovqw xmm6 {k1}, zmm18
// CHECK:  encoding: [0x62,0xe2,0x7e,0x49,0x34,0xd6]
          vpmovqw xmm6 {k1}, zmm18

// CHECK: vpmovqw xmm6 {k1} {z}, zmm18
// CHECK:  encoding: [0x62,0xe2,0x7e,0xc9,0x34,0xd6]
          vpmovqw xmm6 {k1} {z}, zmm18

// CHECK: vpmovsqw xmm27, zmm19
// CHECK:  encoding: [0x62,0x82,0x7e,0x48,0x24,0xdb]
          vpmovsqw xmm27, zmm19

// CHECK: vpmovsqw xmm27 {k6}, zmm19
// CHECK:  encoding: [0x62,0x82,0x7e,0x4e,0x24,0xdb]
          vpmovsqw xmm27 {k6}, zmm19

// CHECK: vpmovsqw xmm27 {k6} {z}, zmm19
// CHECK:  encoding: [0x62,0x82,0x7e,0xce,0x24,0xdb]
          vpmovsqw xmm27 {k6} {z}, zmm19

// CHECK: vpmovusqw xmm28, zmm10
// CHECK:  encoding: [0x62,0x12,0x7e,0x48,0x14,0xd4]
          vpmovusqw xmm28, zmm10

// CHECK: vpmovusqw xmm28 {k7}, zmm10
// CHECK:  encoding: [0x62,0x12,0x7e,0x4f,0x14,0xd4]
          vpmovusqw xmm28 {k7}, zmm10

// CHECK: vpmovusqw xmm28 {k7} {z}, zmm10
// CHECK:  encoding: [0x62,0x12,0x7e,0xcf,0x14,0xd4]
          vpmovusqw xmm28 {k7} {z}, zmm10

// CHECK: vpmovqd ymm6, zmm25
// CHECK:  encoding: [0x62,0x62,0x7e,0x48,0x35,0xce]
          vpmovqd ymm6, zmm25

// CHECK: vpmovqd ymm6 {k5}, zmm25
// CHECK:  encoding: [0x62,0x62,0x7e,0x4d,0x35,0xce]
          vpmovqd ymm6 {k5}, zmm25

// CHECK: vpmovqd ymm6 {k5} {z}, zmm25
// CHECK:  encoding: [0x62,0x62,0x7e,0xcd,0x35,0xce]
          vpmovqd ymm6 {k5} {z}, zmm25

// CHECK: vpmovsqd ymm15, zmm2
// CHECK:  encoding: [0x62,0xd2,0x7e,0x48,0x25,0xd7]
          vpmovsqd ymm15, zmm2

// CHECK: vpmovsqd ymm15 {k2}, zmm2
// CHECK:  encoding: [0x62,0xd2,0x7e,0x4a,0x25,0xd7]
          vpmovsqd ymm15 {k2}, zmm2

// CHECK: vpmovsqd ymm15 {k2} {z}, zmm2
// CHECK:  encoding: [0x62,0xd2,0x7e,0xca,0x25,0xd7]
          vpmovsqd ymm15 {k2} {z}, zmm2

// CHECK: vpmovusqd ymm8, zmm4
// CHECK:  encoding: [0x62,0xd2,0x7e,0x48,0x15,0xe0]
          vpmovusqd ymm8, zmm4

// CHECK: vpmovusqd ymm8 {k4}, zmm4
// CHECK:  encoding: [0x62,0xd2,0x7e,0x4c,0x15,0xe0]
          vpmovusqd ymm8 {k4}, zmm4

// CHECK: vpmovusqd ymm8 {k4} {z}, zmm4
// CHECK:  encoding: [0x62,0xd2,0x7e,0xcc,0x15,0xe0]
          vpmovusqd ymm8 {k4} {z}, zmm4

// CHECK: vpmovdb xmm2, zmm5
// CHECK:  encoding: [0x62,0xf2,0x7e,0x48,0x31,0xea]
          vpmovdb xmm2, zmm5

// CHECK: vpmovdb xmm2 {k5}, zmm5
// CHECK:  encoding: [0x62,0xf2,0x7e,0x4d,0x31,0xea]
          vpmovdb xmm2 {k5}, zmm5

// CHECK: vpmovdb xmm2 {k5} {z}, zmm5
// CHECK:  encoding: [0x62,0xf2,0x7e,0xcd,0x31,0xea]
          vpmovdb xmm2 {k5} {z}, zmm5

// CHECK: vpmovsdb xmm21, zmm2
// CHECK:  encoding: [0x62,0xb2,0x7e,0x48,0x21,0xd5]
          vpmovsdb xmm21, zmm2

// CHECK: vpmovsdb xmm21 {k4}, zmm2
// CHECK:  encoding: [0x62,0xb2,0x7e,0x4c,0x21,0xd5]
          vpmovsdb xmm21 {k4}, zmm2

// CHECK: vpmovsdb xmm21 {k4} {z}, zmm2
// CHECK:  encoding: [0x62,0xb2,0x7e,0xcc,0x21,0xd5]
          vpmovsdb xmm21 {k4} {z}, zmm2

// CHECK: vpmovusdb xmm20, zmm2
// CHECK:  encoding: [0x62,0xb2,0x7e,0x48,0x11,0xd4]
          vpmovusdb xmm20, zmm2

// CHECK: vpmovusdb xmm20 {k3}, zmm2
// CHECK:  encoding: [0x62,0xb2,0x7e,0x4b,0x11,0xd4]
          vpmovusdb xmm20 {k3}, zmm2

// CHECK: vpmovusdb xmm20 {k3} {z}, zmm2
// CHECK:  encoding: [0x62,0xb2,0x7e,0xcb,0x11,0xd4]
          vpmovusdb xmm20 {k3} {z}, zmm2

// CHECK: vpmovdw ymm22, zmm29
// CHECK:  encoding: [0x62,0x22,0x7e,0x48,0x33,0xee]
          vpmovdw ymm22, zmm29

// CHECK: vpmovdw ymm22 {k5}, zmm29
// CHECK:  encoding: [0x62,0x22,0x7e,0x4d,0x33,0xee]
          vpmovdw ymm22 {k5}, zmm29

// CHECK: vpmovdw ymm22 {k5} {z}, zmm29
// CHECK:  encoding: [0x62,0x22,0x7e,0xcd,0x33,0xee]
          vpmovdw ymm22 {k5} {z}, zmm29

// CHECK: vpmovsdw ymm25, zmm14
// CHECK:  encoding: [0x62,0x12,0x7e,0x48,0x23,0xf1]
          vpmovsdw ymm25, zmm14

// CHECK: vpmovsdw ymm25 {k4}, zmm14
// CHECK:  encoding: [0x62,0x12,0x7e,0x4c,0x23,0xf1]
          vpmovsdw ymm25 {k4}, zmm14

// CHECK: vpmovsdw ymm25 {k4} {z}, zmm14
// CHECK:  encoding: [0x62,0x12,0x7e,0xcc,0x23,0xf1]
          vpmovsdw ymm25 {k4} {z}, zmm14

// CHECK: vpmovusdw ymm8, zmm7
// CHECK:  encoding: [0x62,0xd2,0x7e,0x48,0x13,0xf8]
          vpmovusdw ymm8, zmm7

// CHECK: vpmovusdw ymm8 {k1}, zmm7
// CHECK:  encoding: [0x62,0xd2,0x7e,0x49,0x13,0xf8]
          vpmovusdw ymm8 {k1}, zmm7

// CHECK: vpmovusdw ymm8 {k1} {z}, zmm7
// CHECK:  encoding: [0x62,0xd2,0x7e,0xc9,0x13,0xf8]
          vpmovusdw ymm8 {k1} {z}, zmm7

// CHECK: vshuff32x4 zmm6, zmm24, zmm3, 171
// CHECK:  encoding: [0x62,0xf3,0x3d,0x40,0x23,0xf3,0xab]
          vshuff32x4 zmm6, zmm24, zmm3, 171

// CHECK: vshuff32x4 zmm6 {k2}, zmm24, zmm3, 171
// CHECK:  encoding: [0x62,0xf3,0x3d,0x42,0x23,0xf3,0xab]
          vshuff32x4 zmm6 {k2}, zmm24, zmm3, 171

// CHECK: vshuff32x4 zmm6 {k2} {z}, zmm24, zmm3, 171
// CHECK:  encoding: [0x62,0xf3,0x3d,0xc2,0x23,0xf3,0xab]
          vshuff32x4 zmm6 {k2} {z}, zmm24, zmm3, 171

// CHECK: vshuff32x4 zmm6, zmm24, zmm3, 123
// CHECK:  encoding: [0x62,0xf3,0x3d,0x40,0x23,0xf3,0x7b]
          vshuff32x4 zmm6, zmm24, zmm3, 123

// CHECK: vshuff32x4 zmm6, zmm24, zmmword ptr [rcx], 123
// CHECK:  encoding: [0x62,0xf3,0x3d,0x40,0x23,0x31,0x7b]
          vshuff32x4 zmm6, zmm24, zmmword ptr [rcx], 123

// CHECK: vshuff32x4 zmm6, zmm24, zmmword ptr [rax + 8*r14 + 291], 123
// CHECK:  encoding: [0x62,0xb3,0x3d,0x40,0x23,0xb4,0xf0,0x23,0x01,0x00,0x00,0x7b]
          vshuff32x4 zmm6, zmm24, zmmword ptr [rax + 8*r14 + 291], 123

// CHECK: vshuff32x4 zmm6, zmm24, dword ptr [rcx]{1to16}, 123
// CHECK:  encoding: [0x62,0xf3,0x3d,0x50,0x23,0x31,0x7b]
          vshuff32x4 zmm6, zmm24, dword ptr [rcx]{1to16}, 123

// CHECK: vshuff32x4 zmm6, zmm24, zmmword ptr [rdx + 8128], 123
// CHECK:  encoding: [0x62,0xf3,0x3d,0x40,0x23,0x72,0x7f,0x7b]
          vshuff32x4 zmm6, zmm24, zmmword ptr [rdx + 8128], 123

// CHECK: vshuff32x4 zmm6, zmm24, zmmword ptr [rdx + 8192], 123
// CHECK:  encoding: [0x62,0xf3,0x3d,0x40,0x23,0xb2,0x00,0x20,0x00,0x00,0x7b]
          vshuff32x4 zmm6, zmm24, zmmword ptr [rdx + 8192], 123

// CHECK: vshuff32x4 zmm6, zmm24, zmmword ptr [rdx - 8192], 123
// CHECK:  encoding: [0x62,0xf3,0x3d,0x40,0x23,0x72,0x80,0x7b]
          vshuff32x4 zmm6, zmm24, zmmword ptr [rdx - 8192], 123

// CHECK: vshuff32x4 zmm6, zmm24, zmmword ptr [rdx - 8256], 123
// CHECK:  encoding: [0x62,0xf3,0x3d,0x40,0x23,0xb2,0xc0,0xdf,0xff,0xff,0x7b]
          vshuff32x4 zmm6, zmm24, zmmword ptr [rdx - 8256], 123

// CHECK: vshuff32x4 zmm6, zmm24, dword ptr [rdx + 508]{1to16}, 123
// CHECK:  encoding: [0x62,0xf3,0x3d,0x50,0x23,0x72,0x7f,0x7b]
          vshuff32x4 zmm6, zmm24, dword ptr [rdx + 508]{1to16}, 123

// CHECK: vshuff32x4 zmm6, zmm24, dword ptr [rdx + 512]{1to16}, 123
// CHECK:  encoding: [0x62,0xf3,0x3d,0x50,0x23,0xb2,0x00,0x02,0x00,0x00,0x7b]
          vshuff32x4 zmm6, zmm24, dword ptr [rdx + 512]{1to16}, 123

// CHECK: vshuff32x4 zmm6, zmm24, dword ptr [rdx - 512]{1to16}, 123
// CHECK:  encoding: [0x62,0xf3,0x3d,0x50,0x23,0x72,0x80,0x7b]
          vshuff32x4 zmm6, zmm24, dword ptr [rdx - 512]{1to16}, 123

// CHECK: vshuff32x4 zmm6, zmm24, dword ptr [rdx - 516]{1to16}, 123
// CHECK:  encoding: [0x62,0xf3,0x3d,0x50,0x23,0xb2,0xfc,0xfd,0xff,0xff,0x7b]
          vshuff32x4 zmm6, zmm24, dword ptr [rdx - 516]{1to16}, 123

// CHECK: vshuff64x2 zmm15, zmm25, zmm11, 171
// CHECK:  encoding: [0x62,0x53,0xb5,0x40,0x23,0xfb,0xab]
          vshuff64x2 zmm15, zmm25, zmm11, 171

// CHECK: vshuff64x2 zmm15 {k2}, zmm25, zmm11, 171
// CHECK:  encoding: [0x62,0x53,0xb5,0x42,0x23,0xfb,0xab]
          vshuff64x2 zmm15 {k2}, zmm25, zmm11, 171

// CHECK: vshuff64x2 zmm15 {k2} {z}, zmm25, zmm11, 171
// CHECK:  encoding: [0x62,0x53,0xb5,0xc2,0x23,0xfb,0xab]
          vshuff64x2 zmm15 {k2} {z}, zmm25, zmm11, 171

// CHECK: vshuff64x2 zmm15, zmm25, zmm11, 123
// CHECK:  encoding: [0x62,0x53,0xb5,0x40,0x23,0xfb,0x7b]
          vshuff64x2 zmm15, zmm25, zmm11, 123

// CHECK: vshuff64x2 zmm15, zmm25, zmmword ptr [rcx], 123
// CHECK:  encoding: [0x62,0x73,0xb5,0x40,0x23,0x39,0x7b]
          vshuff64x2 zmm15, zmm25, zmmword ptr [rcx], 123

// CHECK: vshuff64x2 zmm15, zmm25, zmmword ptr [rax + 8*r14 + 291], 123
// CHECK:  encoding: [0x62,0x33,0xb5,0x40,0x23,0xbc,0xf0,0x23,0x01,0x00,0x00,0x7b]
          vshuff64x2 zmm15, zmm25, zmmword ptr [rax + 8*r14 + 291], 123

// CHECK: vshuff64x2 zmm15, zmm25, qword ptr [rcx]{1to8}, 123
// CHECK:  encoding: [0x62,0x73,0xb5,0x50,0x23,0x39,0x7b]
          vshuff64x2 zmm15, zmm25, qword ptr [rcx]{1to8}, 123

// CHECK: vshuff64x2 zmm15, zmm25, zmmword ptr [rdx + 8128], 123
// CHECK:  encoding: [0x62,0x73,0xb5,0x40,0x23,0x7a,0x7f,0x7b]
          vshuff64x2 zmm15, zmm25, zmmword ptr [rdx + 8128], 123

// CHECK: vshuff64x2 zmm15, zmm25, zmmword ptr [rdx + 8192], 123
// CHECK:  encoding: [0x62,0x73,0xb5,0x40,0x23,0xba,0x00,0x20,0x00,0x00,0x7b]
          vshuff64x2 zmm15, zmm25, zmmword ptr [rdx + 8192], 123

// CHECK: vshuff64x2 zmm15, zmm25, zmmword ptr [rdx - 8192], 123
// CHECK:  encoding: [0x62,0x73,0xb5,0x40,0x23,0x7a,0x80,0x7b]
          vshuff64x2 zmm15, zmm25, zmmword ptr [rdx - 8192], 123

// CHECK: vshuff64x2 zmm15, zmm25, zmmword ptr [rdx - 8256], 123
// CHECK:  encoding: [0x62,0x73,0xb5,0x40,0x23,0xba,0xc0,0xdf,0xff,0xff,0x7b]
          vshuff64x2 zmm15, zmm25, zmmword ptr [rdx - 8256], 123

// CHECK: vshuff64x2 zmm15, zmm25, qword ptr [rdx + 1016]{1to8}, 123
// CHECK:  encoding: [0x62,0x73,0xb5,0x50,0x23,0x7a,0x7f,0x7b]
          vshuff64x2 zmm15, zmm25, qword ptr [rdx + 1016]{1to8}, 123

// CHECK: vshuff64x2 zmm15, zmm25, qword ptr [rdx + 1024]{1to8}, 123
// CHECK:  encoding: [0x62,0x73,0xb5,0x50,0x23,0xba,0x00,0x04,0x00,0x00,0x7b]
          vshuff64x2 zmm15, zmm25, qword ptr [rdx + 1024]{1to8}, 123

// CHECK: vshuff64x2 zmm15, zmm25, qword ptr [rdx - 1024]{1to8}, 123
// CHECK:  encoding: [0x62,0x73,0xb5,0x50,0x23,0x7a,0x80,0x7b]
          vshuff64x2 zmm15, zmm25, qword ptr [rdx - 1024]{1to8}, 123

// CHECK: vshuff64x2 zmm15, zmm25, qword ptr [rdx - 1032]{1to8}, 123
// CHECK:  encoding: [0x62,0x73,0xb5,0x50,0x23,0xba,0xf8,0xfb,0xff,0xff,0x7b]
          vshuff64x2 zmm15, zmm25, qword ptr [rdx - 1032]{1to8}, 123

// CHECK: vshufi32x4 zmm1, zmm28, zmm25, 171
// CHECK:  encoding: [0x62,0x93,0x1d,0x40,0x43,0xc9,0xab]
          vshufi32x4 zmm1, zmm28, zmm25, 171

// CHECK: vshufi32x4 zmm1 {k4}, zmm28, zmm25, 171
// CHECK:  encoding: [0x62,0x93,0x1d,0x44,0x43,0xc9,0xab]
          vshufi32x4 zmm1 {k4}, zmm28, zmm25, 171

// CHECK: vshufi32x4 zmm1 {k4} {z}, zmm28, zmm25, 171
// CHECK:  encoding: [0x62,0x93,0x1d,0xc4,0x43,0xc9,0xab]
          vshufi32x4 zmm1 {k4} {z}, zmm28, zmm25, 171

// CHECK: vshufi32x4 zmm1, zmm28, zmm25, 123
// CHECK:  encoding: [0x62,0x93,0x1d,0x40,0x43,0xc9,0x7b]
          vshufi32x4 zmm1, zmm28, zmm25, 123

// CHECK: vshufi32x4 zmm1, zmm28, zmmword ptr [rcx], 123
// CHECK:  encoding: [0x62,0xf3,0x1d,0x40,0x43,0x09,0x7b]
          vshufi32x4 zmm1, zmm28, zmmword ptr [rcx], 123

// CHECK: vshufi32x4 zmm1, zmm28, zmmword ptr [rax + 8*r14 + 291], 123
// CHECK:  encoding: [0x62,0xb3,0x1d,0x40,0x43,0x8c,0xf0,0x23,0x01,0x00,0x00,0x7b]
          vshufi32x4 zmm1, zmm28, zmmword ptr [rax + 8*r14 + 291], 123

// CHECK: vshufi32x4 zmm1, zmm28, dword ptr [rcx]{1to16}, 123
// CHECK:  encoding: [0x62,0xf3,0x1d,0x50,0x43,0x09,0x7b]
          vshufi32x4 zmm1, zmm28, dword ptr [rcx]{1to16}, 123

// CHECK: vshufi32x4 zmm1, zmm28, zmmword ptr [rdx + 8128], 123
// CHECK:  encoding: [0x62,0xf3,0x1d,0x40,0x43,0x4a,0x7f,0x7b]
          vshufi32x4 zmm1, zmm28, zmmword ptr [rdx + 8128], 123

// CHECK: vshufi32x4 zmm1, zmm28, zmmword ptr [rdx + 8192], 123
// CHECK:  encoding: [0x62,0xf3,0x1d,0x40,0x43,0x8a,0x00,0x20,0x00,0x00,0x7b]
          vshufi32x4 zmm1, zmm28, zmmword ptr [rdx + 8192], 123

// CHECK: vshufi32x4 zmm1, zmm28, zmmword ptr [rdx - 8192], 123
// CHECK:  encoding: [0x62,0xf3,0x1d,0x40,0x43,0x4a,0x80,0x7b]
          vshufi32x4 zmm1, zmm28, zmmword ptr [rdx - 8192], 123

// CHECK: vshufi32x4 zmm1, zmm28, zmmword ptr [rdx - 8256], 123
// CHECK:  encoding: [0x62,0xf3,0x1d,0x40,0x43,0x8a,0xc0,0xdf,0xff,0xff,0x7b]
          vshufi32x4 zmm1, zmm28, zmmword ptr [rdx - 8256], 123

// CHECK: vshufi32x4 zmm1, zmm28, dword ptr [rdx + 508]{1to16}, 123
// CHECK:  encoding: [0x62,0xf3,0x1d,0x50,0x43,0x4a,0x7f,0x7b]
          vshufi32x4 zmm1, zmm28, dword ptr [rdx + 508]{1to16}, 123

// CHECK: vshufi32x4 zmm1, zmm28, dword ptr [rdx + 512]{1to16}, 123
// CHECK:  encoding: [0x62,0xf3,0x1d,0x50,0x43,0x8a,0x00,0x02,0x00,0x00,0x7b]
          vshufi32x4 zmm1, zmm28, dword ptr [rdx + 512]{1to16}, 123

// CHECK: vshufi32x4 zmm1, zmm28, dword ptr [rdx - 512]{1to16}, 123
// CHECK:  encoding: [0x62,0xf3,0x1d,0x50,0x43,0x4a,0x80,0x7b]
          vshufi32x4 zmm1, zmm28, dword ptr [rdx - 512]{1to16}, 123

// CHECK: vshufi32x4 zmm1, zmm28, dword ptr [rdx - 516]{1to16}, 123
// CHECK:  encoding: [0x62,0xf3,0x1d,0x50,0x43,0x8a,0xfc,0xfd,0xff,0xff,0x7b]
          vshufi32x4 zmm1, zmm28, dword ptr [rdx - 516]{1to16}, 123

// CHECK: vshufi64x2 zmm3, zmm16, zmm19, 171
// CHECK:  encoding: [0x62,0xb3,0xfd,0x40,0x43,0xdb,0xab]
          vshufi64x2 zmm3, zmm16, zmm19, 171

// CHECK: vshufi64x2 zmm3 {k7}, zmm16, zmm19, 171
// CHECK:  encoding: [0x62,0xb3,0xfd,0x47,0x43,0xdb,0xab]
          vshufi64x2 zmm3 {k7}, zmm16, zmm19, 171

// CHECK: vshufi64x2 zmm3 {k7} {z}, zmm16, zmm19, 171
// CHECK:  encoding: [0x62,0xb3,0xfd,0xc7,0x43,0xdb,0xab]
          vshufi64x2 zmm3 {k7} {z}, zmm16, zmm19, 171

// CHECK: vshufi64x2 zmm3, zmm16, zmm19, 123
// CHECK:  encoding: [0x62,0xb3,0xfd,0x40,0x43,0xdb,0x7b]
          vshufi64x2 zmm3, zmm16, zmm19, 123

// CHECK: vshufi64x2 zmm3, zmm16, zmmword ptr [rcx], 123
// CHECK:  encoding: [0x62,0xf3,0xfd,0x40,0x43,0x19,0x7b]
          vshufi64x2 zmm3, zmm16, zmmword ptr [rcx], 123

// CHECK: vshufi64x2 zmm3, zmm16, zmmword ptr [rax + 8*r14 + 291], 123
// CHECK:  encoding: [0x62,0xb3,0xfd,0x40,0x43,0x9c,0xf0,0x23,0x01,0x00,0x00,0x7b]
          vshufi64x2 zmm3, zmm16, zmmword ptr [rax + 8*r14 + 291], 123

// CHECK: vshufi64x2 zmm3, zmm16, qword ptr [rcx]{1to8}, 123
// CHECK:  encoding: [0x62,0xf3,0xfd,0x50,0x43,0x19,0x7b]
          vshufi64x2 zmm3, zmm16, qword ptr [rcx]{1to8}, 123

// CHECK: vshufi64x2 zmm3, zmm16, zmmword ptr [rdx + 8128], 123
// CHECK:  encoding: [0x62,0xf3,0xfd,0x40,0x43,0x5a,0x7f,0x7b]
          vshufi64x2 zmm3, zmm16, zmmword ptr [rdx + 8128], 123

// CHECK: vshufi64x2 zmm3, zmm16, zmmword ptr [rdx + 8192], 123
// CHECK:  encoding: [0x62,0xf3,0xfd,0x40,0x43,0x9a,0x00,0x20,0x00,0x00,0x7b]
          vshufi64x2 zmm3, zmm16, zmmword ptr [rdx + 8192], 123

// CHECK: vshufi64x2 zmm3, zmm16, zmmword ptr [rdx - 8192], 123
// CHECK:  encoding: [0x62,0xf3,0xfd,0x40,0x43,0x5a,0x80,0x7b]
          vshufi64x2 zmm3, zmm16, zmmword ptr [rdx - 8192], 123

// CHECK: vshufi64x2 zmm3, zmm16, zmmword ptr [rdx - 8256], 123
// CHECK:  encoding: [0x62,0xf3,0xfd,0x40,0x43,0x9a,0xc0,0xdf,0xff,0xff,0x7b]
          vshufi64x2 zmm3, zmm16, zmmword ptr [rdx - 8256], 123

// CHECK: vshufi64x2 zmm3, zmm16, qword ptr [rdx + 1016]{1to8}, 123
// CHECK:  encoding: [0x62,0xf3,0xfd,0x50,0x43,0x5a,0x7f,0x7b]
          vshufi64x2 zmm3, zmm16, qword ptr [rdx + 1016]{1to8}, 123

// CHECK: vshufi64x2 zmm3, zmm16, qword ptr [rdx + 1024]{1to8}, 123
// CHECK:  encoding: [0x62,0xf3,0xfd,0x50,0x43,0x9a,0x00,0x04,0x00,0x00,0x7b]
          vshufi64x2 zmm3, zmm16, qword ptr [rdx + 1024]{1to8}, 123

// CHECK: vshufi64x2 zmm3, zmm16, qword ptr [rdx - 1024]{1to8}, 123
// CHECK:  encoding: [0x62,0xf3,0xfd,0x50,0x43,0x5a,0x80,0x7b]
          vshufi64x2 zmm3, zmm16, qword ptr [rdx - 1024]{1to8}, 123

// CHECK: vshufi64x2 zmm3, zmm16, qword ptr [rdx - 1032]{1to8}, 123
// CHECK:  encoding: [0x62,0xf3,0xfd,0x50,0x43,0x9a,0xf8,0xfb,0xff,0xff,0x7b]
          vshufi64x2 zmm3, zmm16, qword ptr [rdx - 1032]{1to8}, 123

// CHECK: vpermq zmm21, zmm23, zmm22
// CHECK:  encoding: [0x62,0xa2,0xc5,0x40,0x36,0xee]
          vpermq zmm21, zmm23, zmm22

// CHECK: vpermq zmm21 {k1}, zmm23, zmm22
// CHECK:  encoding: [0x62,0xa2,0xc5,0x41,0x36,0xee]
          vpermq zmm21 {k1}, zmm23, zmm22

// CHECK: vpermq zmm21 {k1} {z}, zmm23, zmm22
// CHECK:  encoding: [0x62,0xa2,0xc5,0xc1,0x36,0xee]
          vpermq zmm21 {k1} {z}, zmm23, zmm22

// CHECK: vpermq zmm21, zmm23, zmmword ptr [rcx]
// CHECK:  encoding: [0x62,0xe2,0xc5,0x40,0x36,0x29]
          vpermq zmm21, zmm23, zmmword ptr [rcx]

// CHECK: vpermq zmm21, zmm23, zmmword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0xa2,0xc5,0x40,0x36,0xac,0xf0,0x23,0x01,0x00,0x00]
          vpermq zmm21, zmm23, zmmword ptr [rax + 8*r14 + 291]

// CHECK: vpermq zmm21, zmm23, qword ptr [rcx]{1to8}
// CHECK:  encoding: [0x62,0xe2,0xc5,0x50,0x36,0x29]
          vpermq zmm21, zmm23, qword ptr [rcx]{1to8}

// CHECK: vpermq zmm21, zmm23, zmmword ptr [rdx + 8128]
// CHECK:  encoding: [0x62,0xe2,0xc5,0x40,0x36,0x6a,0x7f]
          vpermq zmm21, zmm23, zmmword ptr [rdx + 8128]

// CHECK: vpermq zmm21, zmm23, zmmword ptr [rdx + 8192]
// CHECK:  encoding: [0x62,0xe2,0xc5,0x40,0x36,0xaa,0x00,0x20,0x00,0x00]
          vpermq zmm21, zmm23, zmmword ptr [rdx + 8192]

// CHECK: vpermq zmm21, zmm23, zmmword ptr [rdx - 8192]
// CHECK:  encoding: [0x62,0xe2,0xc5,0x40,0x36,0x6a,0x80]
          vpermq zmm21, zmm23, zmmword ptr [rdx - 8192]

// CHECK: vpermq zmm21, zmm23, zmmword ptr [rdx - 8256]
// CHECK:  encoding: [0x62,0xe2,0xc5,0x40,0x36,0xaa,0xc0,0xdf,0xff,0xff]
          vpermq zmm21, zmm23, zmmword ptr [rdx - 8256]

// CHECK: vpermq zmm21, zmm23, qword ptr [rdx + 1016]{1to8}
// CHECK:  encoding: [0x62,0xe2,0xc5,0x50,0x36,0x6a,0x7f]
          vpermq zmm21, zmm23, qword ptr [rdx + 1016]{1to8}

// CHECK: vpermq zmm21, zmm23, qword ptr [rdx + 1024]{1to8}
// CHECK:  encoding: [0x62,0xe2,0xc5,0x50,0x36,0xaa,0x00,0x04,0x00,0x00]
          vpermq zmm21, zmm23, qword ptr [rdx + 1024]{1to8}

// CHECK: vpermq zmm21, zmm23, qword ptr [rdx - 1024]{1to8}
// CHECK:  encoding: [0x62,0xe2,0xc5,0x50,0x36,0x6a,0x80]
          vpermq zmm21, zmm23, qword ptr [rdx - 1024]{1to8}

// CHECK: vpermq zmm21, zmm23, qword ptr [rdx - 1032]{1to8}
// CHECK:  encoding: [0x62,0xe2,0xc5,0x50,0x36,0xaa,0xf8,0xfb,0xff,0xff]
          vpermq zmm21, zmm23, qword ptr [rdx - 1032]{1to8}

// CHECK: vpermpd zmm26, zmm29, zmm18
// CHECK:  encoding: [0x62,0x22,0x95,0x40,0x16,0xd2]
          vpermpd zmm26, zmm29, zmm18

// CHECK: vpermpd zmm26 {k6}, zmm29, zmm18
// CHECK:  encoding: [0x62,0x22,0x95,0x46,0x16,0xd2]
          vpermpd zmm26 {k6}, zmm29, zmm18

// CHECK: vpermpd zmm26 {k6} {z}, zmm29, zmm18
// CHECK:  encoding: [0x62,0x22,0x95,0xc6,0x16,0xd2]
          vpermpd zmm26 {k6} {z}, zmm29, zmm18

// CHECK: vpermpd zmm26, zmm29, zmmword ptr [rcx]
// CHECK:  encoding: [0x62,0x62,0x95,0x40,0x16,0x11]
          vpermpd zmm26, zmm29, zmmword ptr [rcx]

// CHECK: vpermpd zmm26, zmm29, zmmword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0x22,0x95,0x40,0x16,0x94,0xf0,0x23,0x01,0x00,0x00]
          vpermpd zmm26, zmm29, zmmword ptr [rax + 8*r14 + 291]

// CHECK: vpermpd zmm26, zmm29, qword ptr [rcx]{1to8}
// CHECK:  encoding: [0x62,0x62,0x95,0x50,0x16,0x11]
          vpermpd zmm26, zmm29, qword ptr [rcx]{1to8}

// CHECK: vpermpd zmm26, zmm29, zmmword ptr [rdx + 8128]
// CHECK:  encoding: [0x62,0x62,0x95,0x40,0x16,0x52,0x7f]
          vpermpd zmm26, zmm29, zmmword ptr [rdx + 8128]

// CHECK: vpermpd zmm26, zmm29, zmmword ptr [rdx + 8192]
// CHECK:  encoding: [0x62,0x62,0x95,0x40,0x16,0x92,0x00,0x20,0x00,0x00]
          vpermpd zmm26, zmm29, zmmword ptr [rdx + 8192]

// CHECK: vpermpd zmm26, zmm29, zmmword ptr [rdx - 8192]
// CHECK:  encoding: [0x62,0x62,0x95,0x40,0x16,0x52,0x80]
          vpermpd zmm26, zmm29, zmmword ptr [rdx - 8192]

// CHECK: vpermpd zmm26, zmm29, zmmword ptr [rdx - 8256]
// CHECK:  encoding: [0x62,0x62,0x95,0x40,0x16,0x92,0xc0,0xdf,0xff,0xff]
          vpermpd zmm26, zmm29, zmmword ptr [rdx - 8256]

// CHECK: vpermpd zmm26, zmm29, qword ptr [rdx + 1016]{1to8}
// CHECK:  encoding: [0x62,0x62,0x95,0x50,0x16,0x52,0x7f]
          vpermpd zmm26, zmm29, qword ptr [rdx + 1016]{1to8}

// CHECK: vpermpd zmm26, zmm29, qword ptr [rdx + 1024]{1to8}
// CHECK:  encoding: [0x62,0x62,0x95,0x50,0x16,0x92,0x00,0x04,0x00,0x00]
          vpermpd zmm26, zmm29, qword ptr [rdx + 1024]{1to8}

// CHECK: vpermpd zmm26, zmm29, qword ptr [rdx - 1024]{1to8}
// CHECK:  encoding: [0x62,0x62,0x95,0x50,0x16,0x52,0x80]
          vpermpd zmm26, zmm29, qword ptr [rdx - 1024]{1to8}

// CHECK: vpermpd zmm26, zmm29, qword ptr [rdx - 1032]{1to8}
// CHECK:  encoding: [0x62,0x62,0x95,0x50,0x16,0x92,0xf8,0xfb,0xff,0xff]
          vpermpd zmm26, zmm29, qword ptr [rdx - 1032]{1to8}

// CHECK: vpermt2d zmm13, zmm6, zmm6
// CHECK:  encoding: [0x62,0x72,0x4d,0x48,0x7e,0xee]
          vpermt2d zmm13, zmm6, zmm6

// CHECK: vpermt2d zmm13 {k6}, zmm6, zmm6
// CHECK:  encoding: [0x62,0x72,0x4d,0x4e,0x7e,0xee]
          vpermt2d zmm13 {k6}, zmm6, zmm6

// CHECK: vpermt2d zmm13 {k6} {z}, zmm6, zmm6
// CHECK:  encoding: [0x62,0x72,0x4d,0xce,0x7e,0xee]
          vpermt2d zmm13 {k6} {z}, zmm6, zmm6

// CHECK: vpermt2d zmm13, zmm6, zmmword ptr [rcx]
// CHECK:  encoding: [0x62,0x72,0x4d,0x48,0x7e,0x29]
          vpermt2d zmm13, zmm6, zmmword ptr [rcx]

// CHECK: vpermt2d zmm13, zmm6, zmmword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0x32,0x4d,0x48,0x7e,0xac,0xf0,0x23,0x01,0x00,0x00]
          vpermt2d zmm13, zmm6, zmmword ptr [rax + 8*r14 + 291]

// CHECK: vpermt2d zmm13, zmm6, dword ptr [rcx]{1to16}
// CHECK:  encoding: [0x62,0x72,0x4d,0x58,0x7e,0x29]
          vpermt2d zmm13, zmm6, dword ptr [rcx]{1to16}

// CHECK: vpermt2d zmm13, zmm6, zmmword ptr [rdx + 8128]
// CHECK:  encoding: [0x62,0x72,0x4d,0x48,0x7e,0x6a,0x7f]
          vpermt2d zmm13, zmm6, zmmword ptr [rdx + 8128]

// CHECK: vpermt2d zmm13, zmm6, zmmword ptr [rdx + 8192]
// CHECK:  encoding: [0x62,0x72,0x4d,0x48,0x7e,0xaa,0x00,0x20,0x00,0x00]
          vpermt2d zmm13, zmm6, zmmword ptr [rdx + 8192]

// CHECK: vpermt2d zmm13, zmm6, zmmword ptr [rdx - 8192]
// CHECK:  encoding: [0x62,0x72,0x4d,0x48,0x7e,0x6a,0x80]
          vpermt2d zmm13, zmm6, zmmword ptr [rdx - 8192]

// CHECK: vpermt2d zmm13, zmm6, zmmword ptr [rdx - 8256]
// CHECK:  encoding: [0x62,0x72,0x4d,0x48,0x7e,0xaa,0xc0,0xdf,0xff,0xff]
          vpermt2d zmm13, zmm6, zmmword ptr [rdx - 8256]

// CHECK: vpermt2d zmm13, zmm6, dword ptr [rdx + 508]{1to16}
// CHECK:  encoding: [0x62,0x72,0x4d,0x58,0x7e,0x6a,0x7f]
          vpermt2d zmm13, zmm6, dword ptr [rdx + 508]{1to16}

// CHECK: vpermt2d zmm13, zmm6, dword ptr [rdx + 512]{1to16}
// CHECK:  encoding: [0x62,0x72,0x4d,0x58,0x7e,0xaa,0x00,0x02,0x00,0x00]
          vpermt2d zmm13, zmm6, dword ptr [rdx + 512]{1to16}

// CHECK: vpermt2d zmm13, zmm6, dword ptr [rdx - 512]{1to16}
// CHECK:  encoding: [0x62,0x72,0x4d,0x58,0x7e,0x6a,0x80]
          vpermt2d zmm13, zmm6, dword ptr [rdx - 512]{1to16}

// CHECK: vpermt2d zmm13, zmm6, dword ptr [rdx - 516]{1to16}
// CHECK:  encoding: [0x62,0x72,0x4d,0x58,0x7e,0xaa,0xfc,0xfd,0xff,0xff]
          vpermt2d zmm13, zmm6, dword ptr [rdx - 516]{1to16}

// CHECK: vpermt2q zmm21, zmm12, zmm16
// CHECK:  encoding: [0x62,0xa2,0x9d,0x48,0x7e,0xe8]
          vpermt2q zmm21, zmm12, zmm16

// CHECK: vpermt2q zmm21 {k2}, zmm12, zmm16
// CHECK:  encoding: [0x62,0xa2,0x9d,0x4a,0x7e,0xe8]
          vpermt2q zmm21 {k2}, zmm12, zmm16

// CHECK: vpermt2q zmm21 {k2} {z}, zmm12, zmm16
// CHECK:  encoding: [0x62,0xa2,0x9d,0xca,0x7e,0xe8]
          vpermt2q zmm21 {k2} {z}, zmm12, zmm16

// CHECK: vpermt2q zmm21, zmm12, zmmword ptr [rcx]
// CHECK:  encoding: [0x62,0xe2,0x9d,0x48,0x7e,0x29]
          vpermt2q zmm21, zmm12, zmmword ptr [rcx]

// CHECK: vpermt2q zmm21, zmm12, zmmword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0xa2,0x9d,0x48,0x7e,0xac,0xf0,0x23,0x01,0x00,0x00]
          vpermt2q zmm21, zmm12, zmmword ptr [rax + 8*r14 + 291]

// CHECK: vpermt2q zmm21, zmm12, qword ptr [rcx]{1to8}
// CHECK:  encoding: [0x62,0xe2,0x9d,0x58,0x7e,0x29]
          vpermt2q zmm21, zmm12, qword ptr [rcx]{1to8}

// CHECK: vpermt2q zmm21, zmm12, zmmword ptr [rdx + 8128]
// CHECK:  encoding: [0x62,0xe2,0x9d,0x48,0x7e,0x6a,0x7f]
          vpermt2q zmm21, zmm12, zmmword ptr [rdx + 8128]

// CHECK: vpermt2q zmm21, zmm12, zmmword ptr [rdx + 8192]
// CHECK:  encoding: [0x62,0xe2,0x9d,0x48,0x7e,0xaa,0x00,0x20,0x00,0x00]
          vpermt2q zmm21, zmm12, zmmword ptr [rdx + 8192]

// CHECK: vpermt2q zmm21, zmm12, zmmword ptr [rdx - 8192]
// CHECK:  encoding: [0x62,0xe2,0x9d,0x48,0x7e,0x6a,0x80]
          vpermt2q zmm21, zmm12, zmmword ptr [rdx - 8192]

// CHECK: vpermt2q zmm21, zmm12, zmmword ptr [rdx - 8256]
// CHECK:  encoding: [0x62,0xe2,0x9d,0x48,0x7e,0xaa,0xc0,0xdf,0xff,0xff]
          vpermt2q zmm21, zmm12, zmmword ptr [rdx - 8256]

// CHECK: vpermt2q zmm21, zmm12, qword ptr [rdx + 1016]{1to8}
// CHECK:  encoding: [0x62,0xe2,0x9d,0x58,0x7e,0x6a,0x7f]
          vpermt2q zmm21, zmm12, qword ptr [rdx + 1016]{1to8}

// CHECK: vpermt2q zmm21, zmm12, qword ptr [rdx + 1024]{1to8}
// CHECK:  encoding: [0x62,0xe2,0x9d,0x58,0x7e,0xaa,0x00,0x04,0x00,0x00]
          vpermt2q zmm21, zmm12, qword ptr [rdx + 1024]{1to8}

// CHECK: vpermt2q zmm21, zmm12, qword ptr [rdx - 1024]{1to8}
// CHECK:  encoding: [0x62,0xe2,0x9d,0x58,0x7e,0x6a,0x80]
          vpermt2q zmm21, zmm12, qword ptr [rdx - 1024]{1to8}

// CHECK: vpermt2q zmm21, zmm12, qword ptr [rdx - 1032]{1to8}
// CHECK:  encoding: [0x62,0xe2,0x9d,0x58,0x7e,0xaa,0xf8,0xfb,0xff,0xff]
          vpermt2q zmm21, zmm12, qword ptr [rdx - 1032]{1to8}

// CHECK: vpermt2ps zmm11, zmm28, zmm2
// CHECK:  encoding: [0x62,0x72,0x1d,0x40,0x7f,0xda]
          vpermt2ps zmm11, zmm28, zmm2

// CHECK: vpermt2ps zmm11 {k1}, zmm28, zmm2
// CHECK:  encoding: [0x62,0x72,0x1d,0x41,0x7f,0xda]
          vpermt2ps zmm11 {k1}, zmm28, zmm2

// CHECK: vpermt2ps zmm11 {k1} {z}, zmm28, zmm2
// CHECK:  encoding: [0x62,0x72,0x1d,0xc1,0x7f,0xda]
          vpermt2ps zmm11 {k1} {z}, zmm28, zmm2

// CHECK: vpermt2ps zmm11, zmm28, zmmword ptr [rcx]
// CHECK:  encoding: [0x62,0x72,0x1d,0x40,0x7f,0x19]
          vpermt2ps zmm11, zmm28, zmmword ptr [rcx]

// CHECK: vpermt2ps zmm11, zmm28, zmmword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0x32,0x1d,0x40,0x7f,0x9c,0xf0,0x23,0x01,0x00,0x00]
          vpermt2ps zmm11, zmm28, zmmword ptr [rax + 8*r14 + 291]

// CHECK: vpermt2ps zmm11, zmm28, dword ptr [rcx]{1to16}
// CHECK:  encoding: [0x62,0x72,0x1d,0x50,0x7f,0x19]
          vpermt2ps zmm11, zmm28, dword ptr [rcx]{1to16}

// CHECK: vpermt2ps zmm11, zmm28, zmmword ptr [rdx + 8128]
// CHECK:  encoding: [0x62,0x72,0x1d,0x40,0x7f,0x5a,0x7f]
          vpermt2ps zmm11, zmm28, zmmword ptr [rdx + 8128]

// CHECK: vpermt2ps zmm11, zmm28, zmmword ptr [rdx + 8192]
// CHECK:  encoding: [0x62,0x72,0x1d,0x40,0x7f,0x9a,0x00,0x20,0x00,0x00]
          vpermt2ps zmm11, zmm28, zmmword ptr [rdx + 8192]

// CHECK: vpermt2ps zmm11, zmm28, zmmword ptr [rdx - 8192]
// CHECK:  encoding: [0x62,0x72,0x1d,0x40,0x7f,0x5a,0x80]
          vpermt2ps zmm11, zmm28, zmmword ptr [rdx - 8192]

// CHECK: vpermt2ps zmm11, zmm28, zmmword ptr [rdx - 8256]
// CHECK:  encoding: [0x62,0x72,0x1d,0x40,0x7f,0x9a,0xc0,0xdf,0xff,0xff]
          vpermt2ps zmm11, zmm28, zmmword ptr [rdx - 8256]

// CHECK: vpermt2ps zmm11, zmm28, dword ptr [rdx + 508]{1to16}
// CHECK:  encoding: [0x62,0x72,0x1d,0x50,0x7f,0x5a,0x7f]
          vpermt2ps zmm11, zmm28, dword ptr [rdx + 508]{1to16}

// CHECK: vpermt2ps zmm11, zmm28, dword ptr [rdx + 512]{1to16}
// CHECK:  encoding: [0x62,0x72,0x1d,0x50,0x7f,0x9a,0x00,0x02,0x00,0x00]
          vpermt2ps zmm11, zmm28, dword ptr [rdx + 512]{1to16}

// CHECK: vpermt2ps zmm11, zmm28, dword ptr [rdx - 512]{1to16}
// CHECK:  encoding: [0x62,0x72,0x1d,0x50,0x7f,0x5a,0x80]
          vpermt2ps zmm11, zmm28, dword ptr [rdx - 512]{1to16}

// CHECK: vpermt2ps zmm11, zmm28, dword ptr [rdx - 516]{1to16}
// CHECK:  encoding: [0x62,0x72,0x1d,0x50,0x7f,0x9a,0xfc,0xfd,0xff,0xff]
          vpermt2ps zmm11, zmm28, dword ptr [rdx - 516]{1to16}

// CHECK: vpermt2pd zmm3, zmm27, zmm11
// CHECK:  encoding: [0x62,0xd2,0xa5,0x40,0x7f,0xdb]
          vpermt2pd zmm3, zmm27, zmm11

// CHECK: vpermt2pd zmm3 {k2}, zmm27, zmm11
// CHECK:  encoding: [0x62,0xd2,0xa5,0x42,0x7f,0xdb]
          vpermt2pd zmm3 {k2}, zmm27, zmm11

// CHECK: vpermt2pd zmm3 {k2} {z}, zmm27, zmm11
// CHECK:  encoding: [0x62,0xd2,0xa5,0xc2,0x7f,0xdb]
          vpermt2pd zmm3 {k2} {z}, zmm27, zmm11

// CHECK: vpermt2pd zmm3, zmm27, zmmword ptr [rcx]
// CHECK:  encoding: [0x62,0xf2,0xa5,0x40,0x7f,0x19]
          vpermt2pd zmm3, zmm27, zmmword ptr [rcx]

// CHECK: vpermt2pd zmm3, zmm27, zmmword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0xb2,0xa5,0x40,0x7f,0x9c,0xf0,0x23,0x01,0x00,0x00]
          vpermt2pd zmm3, zmm27, zmmword ptr [rax + 8*r14 + 291]

// CHECK: vpermt2pd zmm3, zmm27, qword ptr [rcx]{1to8}
// CHECK:  encoding: [0x62,0xf2,0xa5,0x50,0x7f,0x19]
          vpermt2pd zmm3, zmm27, qword ptr [rcx]{1to8}

// CHECK: vpermt2pd zmm3, zmm27, zmmword ptr [rdx + 8128]
// CHECK:  encoding: [0x62,0xf2,0xa5,0x40,0x7f,0x5a,0x7f]
          vpermt2pd zmm3, zmm27, zmmword ptr [rdx + 8128]

// CHECK: vpermt2pd zmm3, zmm27, zmmword ptr [rdx + 8192]
// CHECK:  encoding: [0x62,0xf2,0xa5,0x40,0x7f,0x9a,0x00,0x20,0x00,0x00]
          vpermt2pd zmm3, zmm27, zmmword ptr [rdx + 8192]

// CHECK: vpermt2pd zmm3, zmm27, zmmword ptr [rdx - 8192]
// CHECK:  encoding: [0x62,0xf2,0xa5,0x40,0x7f,0x5a,0x80]
          vpermt2pd zmm3, zmm27, zmmword ptr [rdx - 8192]

// CHECK: vpermt2pd zmm3, zmm27, zmmword ptr [rdx - 8256]
// CHECK:  encoding: [0x62,0xf2,0xa5,0x40,0x7f,0x9a,0xc0,0xdf,0xff,0xff]
          vpermt2pd zmm3, zmm27, zmmword ptr [rdx - 8256]

// CHECK: vpermt2pd zmm3, zmm27, qword ptr [rdx + 1016]{1to8}
// CHECK:  encoding: [0x62,0xf2,0xa5,0x50,0x7f,0x5a,0x7f]
          vpermt2pd zmm3, zmm27, qword ptr [rdx + 1016]{1to8}

// CHECK: vpermt2pd zmm3, zmm27, qword ptr [rdx + 1024]{1to8}
// CHECK:  encoding: [0x62,0xf2,0xa5,0x50,0x7f,0x9a,0x00,0x04,0x00,0x00]
          vpermt2pd zmm3, zmm27, qword ptr [rdx + 1024]{1to8}

// CHECK: vpermt2pd zmm3, zmm27, qword ptr [rdx - 1024]{1to8}
// CHECK:  encoding: [0x62,0xf2,0xa5,0x50,0x7f,0x5a,0x80]
          vpermt2pd zmm3, zmm27, qword ptr [rdx - 1024]{1to8}

// CHECK: vpermt2pd zmm3, zmm27, qword ptr [rdx - 1032]{1to8}
// CHECK:  encoding: [0x62,0xf2,0xa5,0x50,0x7f,0x9a,0xf8,0xfb,0xff,0xff]
          vpermt2pd zmm3, zmm27, qword ptr [rdx - 1032]{1to8}

// CHECK: valignq zmm28, zmm4, zmm23, 171
// CHECK:  encoding: [0x62,0x23,0xdd,0x48,0x03,0xe7,0xab]
          valignq zmm28, zmm4, zmm23, 171

// CHECK: valignq zmm28 {k3}, zmm4, zmm23, 171
// CHECK:  encoding: [0x62,0x23,0xdd,0x4b,0x03,0xe7,0xab]
          valignq zmm28 {k3}, zmm4, zmm23, 171

// CHECK: valignq zmm28 {k3} {z}, zmm4, zmm23, 171
// CHECK:  encoding: [0x62,0x23,0xdd,0xcb,0x03,0xe7,0xab]
          valignq zmm28 {k3} {z}, zmm4, zmm23, 171

// CHECK: valignq zmm28, zmm4, zmm23, 123
// CHECK:  encoding: [0x62,0x23,0xdd,0x48,0x03,0xe7,0x7b]
          valignq zmm28, zmm4, zmm23, 123

// CHECK: valignq zmm28, zmm4, zmmword ptr [rcx], 123
// CHECK:  encoding: [0x62,0x63,0xdd,0x48,0x03,0x21,0x7b]
          valignq zmm28, zmm4, zmmword ptr [rcx], 123

// CHECK: valignq zmm28, zmm4, zmmword ptr [rax + 8*r14 + 291], 123
// CHECK:  encoding: [0x62,0x23,0xdd,0x48,0x03,0xa4,0xf0,0x23,0x01,0x00,0x00,0x7b]
          valignq zmm28, zmm4, zmmword ptr [rax + 8*r14 + 291], 123

// CHECK: valignq zmm28, zmm4, qword ptr [rcx]{1to8}, 123
// CHECK:  encoding: [0x62,0x63,0xdd,0x58,0x03,0x21,0x7b]
          valignq zmm28, zmm4, qword ptr [rcx]{1to8}, 123

// CHECK: valignq zmm28, zmm4, zmmword ptr [rdx + 8128], 123
// CHECK:  encoding: [0x62,0x63,0xdd,0x48,0x03,0x62,0x7f,0x7b]
          valignq zmm28, zmm4, zmmword ptr [rdx + 8128], 123

// CHECK: valignq zmm28, zmm4, zmmword ptr [rdx + 8192], 123
// CHECK:  encoding: [0x62,0x63,0xdd,0x48,0x03,0xa2,0x00,0x20,0x00,0x00,0x7b]
          valignq zmm28, zmm4, zmmword ptr [rdx + 8192], 123

// CHECK: valignq zmm28, zmm4, zmmword ptr [rdx - 8192], 123
// CHECK:  encoding: [0x62,0x63,0xdd,0x48,0x03,0x62,0x80,0x7b]
          valignq zmm28, zmm4, zmmword ptr [rdx - 8192], 123

// CHECK: valignq zmm28, zmm4, zmmword ptr [rdx - 8256], 123
// CHECK:  encoding: [0x62,0x63,0xdd,0x48,0x03,0xa2,0xc0,0xdf,0xff,0xff,0x7b]
          valignq zmm28, zmm4, zmmword ptr [rdx - 8256], 123

// CHECK: valignq zmm28, zmm4, qword ptr [rdx + 1016]{1to8}, 123
// CHECK:  encoding: [0x62,0x63,0xdd,0x58,0x03,0x62,0x7f,0x7b]
          valignq zmm28, zmm4, qword ptr [rdx + 1016]{1to8}, 123

// CHECK: valignq zmm28, zmm4, qword ptr [rdx + 1024]{1to8}, 123
// CHECK:  encoding: [0x62,0x63,0xdd,0x58,0x03,0xa2,0x00,0x04,0x00,0x00,0x7b]
          valignq zmm28, zmm4, qword ptr [rdx + 1024]{1to8}, 123

// CHECK: valignq zmm28, zmm4, qword ptr [rdx - 1024]{1to8}, 123
// CHECK:  encoding: [0x62,0x63,0xdd,0x58,0x03,0x62,0x80,0x7b]
          valignq zmm28, zmm4, qword ptr [rdx - 1024]{1to8}, 123

// CHECK: valignq zmm28, zmm4, qword ptr [rdx - 1032]{1to8}, 123
// CHECK:  encoding: [0x62,0x63,0xdd,0x58,0x03,0xa2,0xf8,0xfb,0xff,0xff,0x7b]
          valignq zmm28, zmm4, qword ptr [rdx - 1032]{1to8}, 123

// CHECK: vcvtsd2usi eax, xmm30
// CHECK:  encoding: [0x62,0x91,0x7f,0x08,0x79,0xc6]
          vcvtsd2usi eax, xmm30

// CHECK: vcvtsd2usi eax, xmm30, {rn-sae}
// CHECK:  encoding: [0x62,0x91,0x7f,0x18,0x79,0xc6]
          vcvtsd2usi eax, xmm30, {rn-sae}

// CHECK: vcvtsd2usi eax, xmm30, {ru-sae}
// CHECK:  encoding: [0x62,0x91,0x7f,0x58,0x79,0xc6]
          vcvtsd2usi eax, xmm30, {ru-sae}

// CHECK: vcvtsd2usi eax, xmm30, {rd-sae}
// CHECK:  encoding: [0x62,0x91,0x7f,0x38,0x79,0xc6]
          vcvtsd2usi eax, xmm30, {rd-sae}

// CHECK: vcvtsd2usi eax, xmm30, {rz-sae}
// CHECK:  encoding: [0x62,0x91,0x7f,0x78,0x79,0xc6]
          vcvtsd2usi eax, xmm30, {rz-sae}

// CHECK: vcvtsd2usi eax, qword ptr [rcx]
// CHECK:  encoding: [0x62,0xf1,0x7f,0x08,0x79,0x01]
          vcvtsd2usi eax, qword ptr [rcx]

// CHECK: vcvtsd2usi eax, qword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0xb1,0x7f,0x08,0x79,0x84,0xf0,0x23,0x01,0x00,0x00]
          vcvtsd2usi eax, qword ptr [rax + 8*r14 + 291]

// CHECK: vcvtsd2usi eax, qword ptr [rdx + 1016]
// CHECK:  encoding: [0x62,0xf1,0x7f,0x08,0x79,0x42,0x7f]
          vcvtsd2usi eax, qword ptr [rdx + 1016]

// CHECK: vcvtsd2usi eax, qword ptr [rdx + 1024]
// CHECK:  encoding: [0x62,0xf1,0x7f,0x08,0x79,0x82,0x00,0x04,0x00,0x00]
          vcvtsd2usi eax, qword ptr [rdx + 1024]

// CHECK: vcvtsd2usi eax, qword ptr [rdx - 1024]
// CHECK:  encoding: [0x62,0xf1,0x7f,0x08,0x79,0x42,0x80]
          vcvtsd2usi eax, qword ptr [rdx - 1024]

// CHECK: vcvtsd2usi eax, qword ptr [rdx - 1032]
// CHECK:  encoding: [0x62,0xf1,0x7f,0x08,0x79,0x82,0xf8,0xfb,0xff,0xff]
          vcvtsd2usi eax, qword ptr [rdx - 1032]

// CHECK: vcvtsd2usi ebp, xmm30
// CHECK:  encoding: [0x62,0x91,0x7f,0x08,0x79,0xee]
          vcvtsd2usi ebp, xmm30

// CHECK: vcvtsd2usi ebp, xmm30, {rn-sae}
// CHECK:  encoding: [0x62,0x91,0x7f,0x18,0x79,0xee]
          vcvtsd2usi ebp, xmm30, {rn-sae}

// CHECK: vcvtsd2usi ebp, xmm30, {ru-sae}
// CHECK:  encoding: [0x62,0x91,0x7f,0x58,0x79,0xee]
          vcvtsd2usi ebp, xmm30, {ru-sae}

// CHECK: vcvtsd2usi ebp, xmm30, {rd-sae}
// CHECK:  encoding: [0x62,0x91,0x7f,0x38,0x79,0xee]
          vcvtsd2usi ebp, xmm30, {rd-sae}

// CHECK: vcvtsd2usi ebp, xmm30, {rz-sae}
// CHECK:  encoding: [0x62,0x91,0x7f,0x78,0x79,0xee]
          vcvtsd2usi ebp, xmm30, {rz-sae}

// CHECK: vcvtsd2usi ebp, qword ptr [rcx]
// CHECK:  encoding: [0x62,0xf1,0x7f,0x08,0x79,0x29]
          vcvtsd2usi ebp, qword ptr [rcx]

// CHECK: vcvtsd2usi ebp, qword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0xb1,0x7f,0x08,0x79,0xac,0xf0,0x23,0x01,0x00,0x00]
          vcvtsd2usi ebp, qword ptr [rax + 8*r14 + 291]

// CHECK: vcvtsd2usi ebp, qword ptr [rdx + 1016]
// CHECK:  encoding: [0x62,0xf1,0x7f,0x08,0x79,0x6a,0x7f]
          vcvtsd2usi ebp, qword ptr [rdx + 1016]

// CHECK: vcvtsd2usi ebp, qword ptr [rdx + 1024]
// CHECK:  encoding: [0x62,0xf1,0x7f,0x08,0x79,0xaa,0x00,0x04,0x00,0x00]
          vcvtsd2usi ebp, qword ptr [rdx + 1024]

// CHECK: vcvtsd2usi ebp, qword ptr [rdx - 1024]
// CHECK:  encoding: [0x62,0xf1,0x7f,0x08,0x79,0x6a,0x80]
          vcvtsd2usi ebp, qword ptr [rdx - 1024]

// CHECK: vcvtsd2usi ebp, qword ptr [rdx - 1032]
// CHECK:  encoding: [0x62,0xf1,0x7f,0x08,0x79,0xaa,0xf8,0xfb,0xff,0xff]
          vcvtsd2usi ebp, qword ptr [rdx - 1032]

// CHECK: vcvtsd2usi r13d, xmm30
// CHECK:  encoding: [0x62,0x11,0x7f,0x08,0x79,0xee]
          vcvtsd2usi r13d, xmm30

// CHECK: vcvtsd2usi r13d, xmm30, {rn-sae}
// CHECK:  encoding: [0x62,0x11,0x7f,0x18,0x79,0xee]
          vcvtsd2usi r13d, xmm30, {rn-sae}

// CHECK: vcvtsd2usi r13d, xmm30, {ru-sae}
// CHECK:  encoding: [0x62,0x11,0x7f,0x58,0x79,0xee]
          vcvtsd2usi r13d, xmm30, {ru-sae}

// CHECK: vcvtsd2usi r13d, xmm30, {rd-sae}
// CHECK:  encoding: [0x62,0x11,0x7f,0x38,0x79,0xee]
          vcvtsd2usi r13d, xmm30, {rd-sae}

// CHECK: vcvtsd2usi r13d, xmm30, {rz-sae}
// CHECK:  encoding: [0x62,0x11,0x7f,0x78,0x79,0xee]
          vcvtsd2usi r13d, xmm30, {rz-sae}

// CHECK: vcvtsd2usi r13d, qword ptr [rcx]
// CHECK:  encoding: [0x62,0x71,0x7f,0x08,0x79,0x29]
          vcvtsd2usi r13d, qword ptr [rcx]

// CHECK: vcvtsd2usi r13d, qword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0x31,0x7f,0x08,0x79,0xac,0xf0,0x23,0x01,0x00,0x00]
          vcvtsd2usi r13d, qword ptr [rax + 8*r14 + 291]

// CHECK: vcvtsd2usi r13d, qword ptr [rdx + 1016]
// CHECK:  encoding: [0x62,0x71,0x7f,0x08,0x79,0x6a,0x7f]
          vcvtsd2usi r13d, qword ptr [rdx + 1016]

// CHECK: vcvtsd2usi r13d, qword ptr [rdx + 1024]
// CHECK:  encoding: [0x62,0x71,0x7f,0x08,0x79,0xaa,0x00,0x04,0x00,0x00]
          vcvtsd2usi r13d, qword ptr [rdx + 1024]

// CHECK: vcvtsd2usi r13d, qword ptr [rdx - 1024]
// CHECK:  encoding: [0x62,0x71,0x7f,0x08,0x79,0x6a,0x80]
          vcvtsd2usi r13d, qword ptr [rdx - 1024]

// CHECK: vcvtsd2usi r13d, qword ptr [rdx - 1032]
// CHECK:  encoding: [0x62,0x71,0x7f,0x08,0x79,0xaa,0xf8,0xfb,0xff,0xff]
          vcvtsd2usi r13d, qword ptr [rdx - 1032]

// CHECK: vcvtsd2usi rax, xmm18
// CHECK:  encoding: [0x62,0xb1,0xff,0x08,0x79,0xc2]
          vcvtsd2usi rax, xmm18

// CHECK: vcvtsd2usi rax, xmm18, {rn-sae}
// CHECK:  encoding: [0x62,0xb1,0xff,0x18,0x79,0xc2]
          vcvtsd2usi rax, xmm18, {rn-sae}

// CHECK: vcvtsd2usi rax, xmm18, {ru-sae}
// CHECK:  encoding: [0x62,0xb1,0xff,0x58,0x79,0xc2]
          vcvtsd2usi rax, xmm18, {ru-sae}

// CHECK: vcvtsd2usi rax, xmm18, {rd-sae}
// CHECK:  encoding: [0x62,0xb1,0xff,0x38,0x79,0xc2]
          vcvtsd2usi rax, xmm18, {rd-sae}

// CHECK: vcvtsd2usi rax, xmm18, {rz-sae}
// CHECK:  encoding: [0x62,0xb1,0xff,0x78,0x79,0xc2]
          vcvtsd2usi rax, xmm18, {rz-sae}

// CHECK: vcvtsd2usi rax, qword ptr [rcx]
// CHECK:  encoding: [0x62,0xf1,0xff,0x08,0x79,0x01]
          vcvtsd2usi rax, qword ptr [rcx]

// CHECK: vcvtsd2usi rax, qword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0xb1,0xff,0x08,0x79,0x84,0xf0,0x23,0x01,0x00,0x00]
          vcvtsd2usi rax, qword ptr [rax + 8*r14 + 291]

// CHECK: vcvtsd2usi rax, qword ptr [rdx + 1016]
// CHECK:  encoding: [0x62,0xf1,0xff,0x08,0x79,0x42,0x7f]
          vcvtsd2usi rax, qword ptr [rdx + 1016]

// CHECK: vcvtsd2usi rax, qword ptr [rdx + 1024]
// CHECK:  encoding: [0x62,0xf1,0xff,0x08,0x79,0x82,0x00,0x04,0x00,0x00]
          vcvtsd2usi rax, qword ptr [rdx + 1024]

// CHECK: vcvtsd2usi rax, qword ptr [rdx - 1024]
// CHECK:  encoding: [0x62,0xf1,0xff,0x08,0x79,0x42,0x80]
          vcvtsd2usi rax, qword ptr [rdx - 1024]

// CHECK: vcvtsd2usi rax, qword ptr [rdx - 1032]
// CHECK:  encoding: [0x62,0xf1,0xff,0x08,0x79,0x82,0xf8,0xfb,0xff,0xff]
          vcvtsd2usi rax, qword ptr [rdx - 1032]

// CHECK: vcvtsd2usi r8, xmm18
// CHECK:  encoding: [0x62,0x31,0xff,0x08,0x79,0xc2]
          vcvtsd2usi r8, xmm18

// CHECK: vcvtsd2usi r8, xmm18, {rn-sae}
// CHECK:  encoding: [0x62,0x31,0xff,0x18,0x79,0xc2]
          vcvtsd2usi r8, xmm18, {rn-sae}

// CHECK: vcvtsd2usi r8, xmm18, {ru-sae}
// CHECK:  encoding: [0x62,0x31,0xff,0x58,0x79,0xc2]
          vcvtsd2usi r8, xmm18, {ru-sae}

// CHECK: vcvtsd2usi r8, xmm18, {rd-sae}
// CHECK:  encoding: [0x62,0x31,0xff,0x38,0x79,0xc2]
          vcvtsd2usi r8, xmm18, {rd-sae}

// CHECK: vcvtsd2usi r8, xmm18, {rz-sae}
// CHECK:  encoding: [0x62,0x31,0xff,0x78,0x79,0xc2]
          vcvtsd2usi r8, xmm18, {rz-sae}

// CHECK: vcvtsd2usi r8, qword ptr [rcx]
// CHECK:  encoding: [0x62,0x71,0xff,0x08,0x79,0x01]
          vcvtsd2usi r8, qword ptr [rcx]

// CHECK: vcvtsd2usi r8, qword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0x31,0xff,0x08,0x79,0x84,0xf0,0x23,0x01,0x00,0x00]
          vcvtsd2usi r8, qword ptr [rax + 8*r14 + 291]

// CHECK: vcvtsd2usi r8, qword ptr [rdx + 1016]
// CHECK:  encoding: [0x62,0x71,0xff,0x08,0x79,0x42,0x7f]
          vcvtsd2usi r8, qword ptr [rdx + 1016]

// CHECK: vcvtsd2usi r8, qword ptr [rdx + 1024]
// CHECK:  encoding: [0x62,0x71,0xff,0x08,0x79,0x82,0x00,0x04,0x00,0x00]
          vcvtsd2usi r8, qword ptr [rdx + 1024]

// CHECK: vcvtsd2usi r8, qword ptr [rdx - 1024]
// CHECK:  encoding: [0x62,0x71,0xff,0x08,0x79,0x42,0x80]
          vcvtsd2usi r8, qword ptr [rdx - 1024]

// CHECK: vcvtsd2usi r8, qword ptr [rdx - 1032]
// CHECK:  encoding: [0x62,0x71,0xff,0x08,0x79,0x82,0xf8,0xfb,0xff,0xff]
          vcvtsd2usi r8, qword ptr [rdx - 1032]

// CHECK: vcvtss2usi eax, xmm28
// CHECK:  encoding: [0x62,0x91,0x7e,0x08,0x79,0xc4]
          vcvtss2usi eax, xmm28

// CHECK: vcvtss2usi eax, xmm28, {rn-sae}
// CHECK:  encoding: [0x62,0x91,0x7e,0x18,0x79,0xc4]
          vcvtss2usi eax, xmm28, {rn-sae}

// CHECK: vcvtss2usi eax, xmm28, {ru-sae}
// CHECK:  encoding: [0x62,0x91,0x7e,0x58,0x79,0xc4]
          vcvtss2usi eax, xmm28, {ru-sae}

// CHECK: vcvtss2usi eax, xmm28, {rd-sae}
// CHECK:  encoding: [0x62,0x91,0x7e,0x38,0x79,0xc4]
          vcvtss2usi eax, xmm28, {rd-sae}

// CHECK: vcvtss2usi eax, xmm28, {rz-sae}
// CHECK:  encoding: [0x62,0x91,0x7e,0x78,0x79,0xc4]
          vcvtss2usi eax, xmm28, {rz-sae}

// CHECK: vcvtss2usi eax, dword ptr [rcx]
// CHECK:  encoding: [0x62,0xf1,0x7e,0x08,0x79,0x01]
          vcvtss2usi eax, dword ptr [rcx]

// CHECK: vcvtss2usi eax, dword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0xb1,0x7e,0x08,0x79,0x84,0xf0,0x23,0x01,0x00,0x00]
          vcvtss2usi eax, dword ptr [rax + 8*r14 + 291]

// CHECK: vcvtss2usi eax, dword ptr [rdx + 508]
// CHECK:  encoding: [0x62,0xf1,0x7e,0x08,0x79,0x42,0x7f]
          vcvtss2usi eax, dword ptr [rdx + 508]

// CHECK: vcvtss2usi eax, dword ptr [rdx + 512]
// CHECK:  encoding: [0x62,0xf1,0x7e,0x08,0x79,0x82,0x00,0x02,0x00,0x00]
          vcvtss2usi eax, dword ptr [rdx + 512]

// CHECK: vcvtss2usi eax, dword ptr [rdx - 512]
// CHECK:  encoding: [0x62,0xf1,0x7e,0x08,0x79,0x42,0x80]
          vcvtss2usi eax, dword ptr [rdx - 512]

// CHECK: vcvtss2usi eax, dword ptr [rdx - 516]
// CHECK:  encoding: [0x62,0xf1,0x7e,0x08,0x79,0x82,0xfc,0xfd,0xff,0xff]
          vcvtss2usi eax, dword ptr [rdx - 516]

// CHECK: vcvtss2usi ebp, xmm28
// CHECK:  encoding: [0x62,0x91,0x7e,0x08,0x79,0xec]
          vcvtss2usi ebp, xmm28

// CHECK: vcvtss2usi ebp, xmm28, {rn-sae}
// CHECK:  encoding: [0x62,0x91,0x7e,0x18,0x79,0xec]
          vcvtss2usi ebp, xmm28, {rn-sae}

// CHECK: vcvtss2usi ebp, xmm28, {ru-sae}
// CHECK:  encoding: [0x62,0x91,0x7e,0x58,0x79,0xec]
          vcvtss2usi ebp, xmm28, {ru-sae}

// CHECK: vcvtss2usi ebp, xmm28, {rd-sae}
// CHECK:  encoding: [0x62,0x91,0x7e,0x38,0x79,0xec]
          vcvtss2usi ebp, xmm28, {rd-sae}

// CHECK: vcvtss2usi ebp, xmm28, {rz-sae}
// CHECK:  encoding: [0x62,0x91,0x7e,0x78,0x79,0xec]
          vcvtss2usi ebp, xmm28, {rz-sae}

// CHECK: vcvtss2usi ebp, dword ptr [rcx]
// CHECK:  encoding: [0x62,0xf1,0x7e,0x08,0x79,0x29]
          vcvtss2usi ebp, dword ptr [rcx]

// CHECK: vcvtss2usi ebp, dword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0xb1,0x7e,0x08,0x79,0xac,0xf0,0x23,0x01,0x00,0x00]
          vcvtss2usi ebp, dword ptr [rax + 8*r14 + 291]

// CHECK: vcvtss2usi ebp, dword ptr [rdx + 508]
// CHECK:  encoding: [0x62,0xf1,0x7e,0x08,0x79,0x6a,0x7f]
          vcvtss2usi ebp, dword ptr [rdx + 508]

// CHECK: vcvtss2usi ebp, dword ptr [rdx + 512]
// CHECK:  encoding: [0x62,0xf1,0x7e,0x08,0x79,0xaa,0x00,0x02,0x00,0x00]
          vcvtss2usi ebp, dword ptr [rdx + 512]

// CHECK: vcvtss2usi ebp, dword ptr [rdx - 512]
// CHECK:  encoding: [0x62,0xf1,0x7e,0x08,0x79,0x6a,0x80]
          vcvtss2usi ebp, dword ptr [rdx - 512]

// CHECK: vcvtss2usi ebp, dword ptr [rdx - 516]
// CHECK:  encoding: [0x62,0xf1,0x7e,0x08,0x79,0xaa,0xfc,0xfd,0xff,0xff]
          vcvtss2usi ebp, dword ptr [rdx - 516]

// CHECK: vcvtss2usi r13d, xmm28
// CHECK:  encoding: [0x62,0x11,0x7e,0x08,0x79,0xec]
          vcvtss2usi r13d, xmm28

// CHECK: vcvtss2usi r13d, xmm28, {rn-sae}
// CHECK:  encoding: [0x62,0x11,0x7e,0x18,0x79,0xec]
          vcvtss2usi r13d, xmm28, {rn-sae}

// CHECK: vcvtss2usi r13d, xmm28, {ru-sae}
// CHECK:  encoding: [0x62,0x11,0x7e,0x58,0x79,0xec]
          vcvtss2usi r13d, xmm28, {ru-sae}

// CHECK: vcvtss2usi r13d, xmm28, {rd-sae}
// CHECK:  encoding: [0x62,0x11,0x7e,0x38,0x79,0xec]
          vcvtss2usi r13d, xmm28, {rd-sae}

// CHECK: vcvtss2usi r13d, xmm28, {rz-sae}
// CHECK:  encoding: [0x62,0x11,0x7e,0x78,0x79,0xec]
          vcvtss2usi r13d, xmm28, {rz-sae}

// CHECK: vcvtss2usi r13d, dword ptr [rcx]
// CHECK:  encoding: [0x62,0x71,0x7e,0x08,0x79,0x29]
          vcvtss2usi r13d, dword ptr [rcx]

// CHECK: vcvtss2usi r13d, dword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0x31,0x7e,0x08,0x79,0xac,0xf0,0x23,0x01,0x00,0x00]
          vcvtss2usi r13d, dword ptr [rax + 8*r14 + 291]

// CHECK: vcvtss2usi r13d, dword ptr [rdx + 508]
// CHECK:  encoding: [0x62,0x71,0x7e,0x08,0x79,0x6a,0x7f]
          vcvtss2usi r13d, dword ptr [rdx + 508]

// CHECK: vcvtss2usi r13d, dword ptr [rdx + 512]
// CHECK:  encoding: [0x62,0x71,0x7e,0x08,0x79,0xaa,0x00,0x02,0x00,0x00]
          vcvtss2usi r13d, dword ptr [rdx + 512]

// CHECK: vcvtss2usi r13d, dword ptr [rdx - 512]
// CHECK:  encoding: [0x62,0x71,0x7e,0x08,0x79,0x6a,0x80]
          vcvtss2usi r13d, dword ptr [rdx - 512]

// CHECK: vcvtss2usi r13d, dword ptr [rdx - 516]
// CHECK:  encoding: [0x62,0x71,0x7e,0x08,0x79,0xaa,0xfc,0xfd,0xff,0xff]
          vcvtss2usi r13d, dword ptr [rdx - 516]

// CHECK: vcvtss2usi rax, xmm23
// CHECK:  encoding: [0x62,0xb1,0xfe,0x08,0x79,0xc7]
          vcvtss2usi rax, xmm23

// CHECK: vcvtss2usi rax, xmm23, {rn-sae}
// CHECK:  encoding: [0x62,0xb1,0xfe,0x18,0x79,0xc7]
          vcvtss2usi rax, xmm23, {rn-sae}

// CHECK: vcvtss2usi rax, xmm23, {ru-sae}
// CHECK:  encoding: [0x62,0xb1,0xfe,0x58,0x79,0xc7]
          vcvtss2usi rax, xmm23, {ru-sae}

// CHECK: vcvtss2usi rax, xmm23, {rd-sae}
// CHECK:  encoding: [0x62,0xb1,0xfe,0x38,0x79,0xc7]
          vcvtss2usi rax, xmm23, {rd-sae}

// CHECK: vcvtss2usi rax, xmm23, {rz-sae}
// CHECK:  encoding: [0x62,0xb1,0xfe,0x78,0x79,0xc7]
          vcvtss2usi rax, xmm23, {rz-sae}

// CHECK: vcvtss2usi rax, dword ptr [rcx]
// CHECK:  encoding: [0x62,0xf1,0xfe,0x08,0x79,0x01]
          vcvtss2usi rax, dword ptr [rcx]

// CHECK: vcvtss2usi rax, dword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0xb1,0xfe,0x08,0x79,0x84,0xf0,0x23,0x01,0x00,0x00]
          vcvtss2usi rax, dword ptr [rax + 8*r14 + 291]

// CHECK: vcvtss2usi rax, dword ptr [rdx + 508]
// CHECK:  encoding: [0x62,0xf1,0xfe,0x08,0x79,0x42,0x7f]
          vcvtss2usi rax, dword ptr [rdx + 508]

// CHECK: vcvtss2usi rax, dword ptr [rdx + 512]
// CHECK:  encoding: [0x62,0xf1,0xfe,0x08,0x79,0x82,0x00,0x02,0x00,0x00]
          vcvtss2usi rax, dword ptr [rdx + 512]

// CHECK: vcvtss2usi rax, dword ptr [rdx - 512]
// CHECK:  encoding: [0x62,0xf1,0xfe,0x08,0x79,0x42,0x80]
          vcvtss2usi rax, dword ptr [rdx - 512]

// CHECK: vcvtss2usi rax, dword ptr [rdx - 516]
// CHECK:  encoding: [0x62,0xf1,0xfe,0x08,0x79,0x82,0xfc,0xfd,0xff,0xff]
          vcvtss2usi rax, dword ptr [rdx - 516]

// CHECK: vcvtss2usi r8, xmm23
// CHECK:  encoding: [0x62,0x31,0xfe,0x08,0x79,0xc7]
          vcvtss2usi r8, xmm23

// CHECK: vcvtss2usi r8, xmm23, {rn-sae}
// CHECK:  encoding: [0x62,0x31,0xfe,0x18,0x79,0xc7]
          vcvtss2usi r8, xmm23, {rn-sae}

// CHECK: vcvtss2usi r8, xmm23, {ru-sae}
// CHECK:  encoding: [0x62,0x31,0xfe,0x58,0x79,0xc7]
          vcvtss2usi r8, xmm23, {ru-sae}

// CHECK: vcvtss2usi r8, xmm23, {rd-sae}
// CHECK:  encoding: [0x62,0x31,0xfe,0x38,0x79,0xc7]
          vcvtss2usi r8, xmm23, {rd-sae}

// CHECK: vcvtss2usi r8, xmm23, {rz-sae}
// CHECK:  encoding: [0x62,0x31,0xfe,0x78,0x79,0xc7]
          vcvtss2usi r8, xmm23, {rz-sae}

// CHECK: vcvtss2usi r8, dword ptr [rcx]
// CHECK:  encoding: [0x62,0x71,0xfe,0x08,0x79,0x01]
          vcvtss2usi r8, dword ptr [rcx]

// CHECK: vcvtss2usi r8, dword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0x31,0xfe,0x08,0x79,0x84,0xf0,0x23,0x01,0x00,0x00]
          vcvtss2usi r8, dword ptr [rax + 8*r14 + 291]

// CHECK: vcvtss2usi r8, dword ptr [rdx + 508]
// CHECK:  encoding: [0x62,0x71,0xfe,0x08,0x79,0x42,0x7f]
          vcvtss2usi r8, dword ptr [rdx + 508]

// CHECK: vcvtss2usi r8, dword ptr [rdx + 512]
// CHECK:  encoding: [0x62,0x71,0xfe,0x08,0x79,0x82,0x00,0x02,0x00,0x00]
          vcvtss2usi r8, dword ptr [rdx + 512]

// CHECK: vcvtss2usi r8, dword ptr [rdx - 512]
// CHECK:  encoding: [0x62,0x71,0xfe,0x08,0x79,0x42,0x80]
          vcvtss2usi r8, dword ptr [rdx - 512]

// CHECK: vcvtss2usi r8, dword ptr [rdx - 516]
// CHECK:  encoding: [0x62,0x71,0xfe,0x08,0x79,0x82,0xfc,0xfd,0xff,0xff]
          vcvtss2usi r8, dword ptr [rdx - 516]

// CHECK: vcvtusi2sd xmm19, xmm1, eax
// CHECK:  encoding: [0x62,0xe1,0x77,0x08,0x7b,0xd8]
          vcvtusi2sd xmm19, xmm1, eax

// CHECK: vcvtusi2sd xmm19, xmm1, ebp
// CHECK:  encoding: [0x62,0xe1,0x77,0x08,0x7b,0xdd]
          vcvtusi2sd xmm19, xmm1, ebp

// CHECK: vcvtusi2sd xmm19, xmm1, r13d
// CHECK:  encoding: [0x62,0xc1,0x77,0x08,0x7b,0xdd]
          vcvtusi2sd xmm19, xmm1, r13d

// CHECK: vcvtusi2sd xmm19, xmm1, dword ptr [rcx]
// CHECK:  encoding: [0x62,0xe1,0x77,0x08,0x7b,0x19]
          vcvtusi2sd xmm19, xmm1, dword ptr [rcx]

// CHECK: vcvtusi2sd xmm19, xmm1, dword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0xa1,0x77,0x08,0x7b,0x9c,0xf0,0x23,0x01,0x00,0x00]
          vcvtusi2sd xmm19, xmm1, dword ptr [rax + 8*r14 + 291]

// CHECK: vcvtusi2sd xmm19, xmm1, dword ptr [rdx + 508]
// CHECK:  encoding: [0x62,0xe1,0x77,0x08,0x7b,0x5a,0x7f]
          vcvtusi2sd xmm19, xmm1, dword ptr [rdx + 508]

// CHECK: vcvtusi2sd xmm19, xmm1, dword ptr [rdx + 512]
// CHECK:  encoding: [0x62,0xe1,0x77,0x08,0x7b,0x9a,0x00,0x02,0x00,0x00]
          vcvtusi2sd xmm19, xmm1, dword ptr [rdx + 512]

// CHECK: vcvtusi2sd xmm19, xmm1, dword ptr [rdx - 512]
// CHECK:  encoding: [0x62,0xe1,0x77,0x08,0x7b,0x5a,0x80]
          vcvtusi2sd xmm19, xmm1, dword ptr [rdx - 512]

// CHECK: vcvtusi2sd xmm19, xmm1, dword ptr [rdx - 516]
// CHECK:  encoding: [0x62,0xe1,0x77,0x08,0x7b,0x9a,0xfc,0xfd,0xff,0xff]
          vcvtusi2sd xmm19, xmm1, dword ptr [rdx - 516]

// CHECK: vcvtusi2sd xmm14, xmm26, rax
// CHECK:  encoding: [0x62,0x71,0xaf,0x00,0x7b,0xf0]
          vcvtusi2sd xmm14, xmm26, rax

// CHECK: vcvtusi2sd xmm14, xmm26, {rn-sae}, rax
// CHECK:  encoding: [0x62,0x71,0xaf,0x10,0x7b,0xf0]
          vcvtusi2sd xmm14, xmm26, {rn-sae}, rax

// CHECK: vcvtusi2sd xmm14, xmm26, {ru-sae}, rax
// CHECK:  encoding: [0x62,0x71,0xaf,0x50,0x7b,0xf0]
          vcvtusi2sd xmm14, xmm26, {ru-sae}, rax

// CHECK: vcvtusi2sd xmm14, xmm26, {rd-sae}, rax
// CHECK:  encoding: [0x62,0x71,0xaf,0x30,0x7b,0xf0]
          vcvtusi2sd xmm14, xmm26, {rd-sae}, rax

// CHECK: vcvtusi2sd xmm14, xmm26, {rz-sae}, rax
// CHECK:  encoding: [0x62,0x71,0xaf,0x70,0x7b,0xf0]
          vcvtusi2sd xmm14, xmm26, {rz-sae}, rax

// CHECK: vcvtusi2sd xmm14, xmm26, r8
// CHECK:  encoding: [0x62,0x51,0xaf,0x00,0x7b,0xf0]
          vcvtusi2sd xmm14, xmm26, r8

// CHECK: vcvtusi2sd xmm14, xmm26, {rn-sae}, r8
// CHECK:  encoding: [0x62,0x51,0xaf,0x10,0x7b,0xf0]
          vcvtusi2sd xmm14, xmm26, {rn-sae}, r8

// CHECK: vcvtusi2sd xmm14, xmm26, {ru-sae}, r8
// CHECK:  encoding: [0x62,0x51,0xaf,0x50,0x7b,0xf0]
          vcvtusi2sd xmm14, xmm26, {ru-sae}, r8

// CHECK: vcvtusi2sd xmm14, xmm26, {rd-sae}, r8
// CHECK:  encoding: [0x62,0x51,0xaf,0x30,0x7b,0xf0]
          vcvtusi2sd xmm14, xmm26, {rd-sae}, r8

// CHECK: vcvtusi2sd xmm14, xmm26, {rz-sae}, r8
// CHECK:  encoding: [0x62,0x51,0xaf,0x70,0x7b,0xf0]
          vcvtusi2sd xmm14, xmm26, {rz-sae}, r8

// CHECK: vcvtusi2sd xmm14, xmm26, qword ptr [rcx]
// CHECK:  encoding: [0x62,0x71,0xaf,0x00,0x7b,0x31]
          vcvtusi2sd xmm14, xmm26, qword ptr [rcx]

// CHECK: vcvtusi2sd xmm14, xmm26, qword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0x31,0xaf,0x00,0x7b,0xb4,0xf0,0x23,0x01,0x00,0x00]
          vcvtusi2sd xmm14, xmm26, qword ptr [rax + 8*r14 + 291]

// CHECK: vcvtusi2sd xmm14, xmm26, qword ptr [rdx + 1016]
// CHECK:  encoding: [0x62,0x71,0xaf,0x00,0x7b,0x72,0x7f]
          vcvtusi2sd xmm14, xmm26, qword ptr [rdx + 1016]

// CHECK: vcvtusi2sd xmm14, xmm26, qword ptr [rdx + 1024]
// CHECK:  encoding: [0x62,0x71,0xaf,0x00,0x7b,0xb2,0x00,0x04,0x00,0x00]
          vcvtusi2sd xmm14, xmm26, qword ptr [rdx + 1024]

// CHECK: vcvtusi2sd xmm14, xmm26, qword ptr [rdx - 1024]
// CHECK:  encoding: [0x62,0x71,0xaf,0x00,0x7b,0x72,0x80]
          vcvtusi2sd xmm14, xmm26, qword ptr [rdx - 1024]

// CHECK: vcvtusi2sd xmm14, xmm26, qword ptr [rdx - 1032]
// CHECK:  encoding: [0x62,0x71,0xaf,0x00,0x7b,0xb2,0xf8,0xfb,0xff,0xff]
          vcvtusi2sd xmm14, xmm26, qword ptr [rdx - 1032]

// CHECK: vcvtusi2ss xmm5, xmm26, eax
// CHECK:  encoding: [0x62,0xf1,0x2e,0x00,0x7b,0xe8]
          vcvtusi2ss xmm5, xmm26, eax

// CHECK: vcvtusi2ss xmm5, xmm26, {rn-sae}, eax
// CHECK:  encoding: [0x62,0xf1,0x2e,0x10,0x7b,0xe8]
          vcvtusi2ss xmm5, xmm26, {rn-sae}, eax

// CHECK: vcvtusi2ss xmm5, xmm26, {ru-sae}, eax
// CHECK:  encoding: [0x62,0xf1,0x2e,0x50,0x7b,0xe8]
          vcvtusi2ss xmm5, xmm26, {ru-sae}, eax

// CHECK: vcvtusi2ss xmm5, xmm26, {rd-sae}, eax
// CHECK:  encoding: [0x62,0xf1,0x2e,0x30,0x7b,0xe8]
          vcvtusi2ss xmm5, xmm26, {rd-sae}, eax

// CHECK: vcvtusi2ss xmm5, xmm26, {rz-sae}, eax
// CHECK:  encoding: [0x62,0xf1,0x2e,0x70,0x7b,0xe8]
          vcvtusi2ss xmm5, xmm26, {rz-sae}, eax

// CHECK: vcvtusi2ss xmm5, xmm26, ebp
// CHECK:  encoding: [0x62,0xf1,0x2e,0x00,0x7b,0xed]
          vcvtusi2ss xmm5, xmm26, ebp

// CHECK: vcvtusi2ss xmm5, xmm26, {rn-sae}, ebp
// CHECK:  encoding: [0x62,0xf1,0x2e,0x10,0x7b,0xed]
          vcvtusi2ss xmm5, xmm26, {rn-sae}, ebp

// CHECK: vcvtusi2ss xmm5, xmm26, {ru-sae}, ebp
// CHECK:  encoding: [0x62,0xf1,0x2e,0x50,0x7b,0xed]
          vcvtusi2ss xmm5, xmm26, {ru-sae}, ebp

// CHECK: vcvtusi2ss xmm5, xmm26, {rd-sae}, ebp
// CHECK:  encoding: [0x62,0xf1,0x2e,0x30,0x7b,0xed]
          vcvtusi2ss xmm5, xmm26, {rd-sae}, ebp

// CHECK: vcvtusi2ss xmm5, xmm26, {rz-sae}, ebp
// CHECK:  encoding: [0x62,0xf1,0x2e,0x70,0x7b,0xed]
          vcvtusi2ss xmm5, xmm26, {rz-sae}, ebp

// CHECK: vcvtusi2ss xmm5, xmm26, r13d
// CHECK:  encoding: [0x62,0xd1,0x2e,0x00,0x7b,0xed]
          vcvtusi2ss xmm5, xmm26, r13d

// CHECK: vcvtusi2ss xmm5, xmm26, {rn-sae}, r13d
// CHECK:  encoding: [0x62,0xd1,0x2e,0x10,0x7b,0xed]
          vcvtusi2ss xmm5, xmm26, {rn-sae}, r13d

// CHECK: vcvtusi2ss xmm5, xmm26, {ru-sae}, r13d
// CHECK:  encoding: [0x62,0xd1,0x2e,0x50,0x7b,0xed]
          vcvtusi2ss xmm5, xmm26, {ru-sae}, r13d

// CHECK: vcvtusi2ss xmm5, xmm26, {rd-sae}, r13d
// CHECK:  encoding: [0x62,0xd1,0x2e,0x30,0x7b,0xed]
          vcvtusi2ss xmm5, xmm26, {rd-sae}, r13d

// CHECK: vcvtusi2ss xmm5, xmm26, {rz-sae}, r13d
// CHECK:  encoding: [0x62,0xd1,0x2e,0x70,0x7b,0xed]
          vcvtusi2ss xmm5, xmm26, {rz-sae}, r13d

// CHECK: vcvtusi2ss xmm5, xmm26, dword ptr [rcx]
// CHECK:  encoding: [0x62,0xf1,0x2e,0x00,0x7b,0x29]
          vcvtusi2ss xmm5, xmm26, dword ptr [rcx]

// CHECK: vcvtusi2ss xmm5, xmm26, dword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0xb1,0x2e,0x00,0x7b,0xac,0xf0,0x23,0x01,0x00,0x00]
          vcvtusi2ss xmm5, xmm26, dword ptr [rax + 8*r14 + 291]

// CHECK: vcvtusi2ss xmm5, xmm26, dword ptr [rdx + 508]
// CHECK:  encoding: [0x62,0xf1,0x2e,0x00,0x7b,0x6a,0x7f]
          vcvtusi2ss xmm5, xmm26, dword ptr [rdx + 508]

// CHECK: vcvtusi2ss xmm5, xmm26, dword ptr [rdx + 512]
// CHECK:  encoding: [0x62,0xf1,0x2e,0x00,0x7b,0xaa,0x00,0x02,0x00,0x00]
          vcvtusi2ss xmm5, xmm26, dword ptr [rdx + 512]

// CHECK: vcvtusi2ss xmm5, xmm26, dword ptr [rdx - 512]
// CHECK:  encoding: [0x62,0xf1,0x2e,0x00,0x7b,0x6a,0x80]
          vcvtusi2ss xmm5, xmm26, dword ptr [rdx - 512]

// CHECK: vcvtusi2ss xmm5, xmm26, dword ptr [rdx - 516]
// CHECK:  encoding: [0x62,0xf1,0x2e,0x00,0x7b,0xaa,0xfc,0xfd,0xff,0xff]
          vcvtusi2ss xmm5, xmm26, dword ptr [rdx - 516]

// CHECK: vcvtusi2ss xmm14, xmm22, rax
// CHECK:  encoding: [0x62,0x71,0xce,0x00,0x7b,0xf0]
          vcvtusi2ss xmm14, xmm22, rax

// CHECK: vcvtusi2ss xmm14, xmm22, {rn-sae}, rax
// CHECK:  encoding: [0x62,0x71,0xce,0x10,0x7b,0xf0]
          vcvtusi2ss xmm14, xmm22, {rn-sae}, rax

// CHECK: vcvtusi2ss xmm14, xmm22, {ru-sae}, rax
// CHECK:  encoding: [0x62,0x71,0xce,0x50,0x7b,0xf0]
          vcvtusi2ss xmm14, xmm22, {ru-sae}, rax

// CHECK: vcvtusi2ss xmm14, xmm22, {rd-sae}, rax
// CHECK:  encoding: [0x62,0x71,0xce,0x30,0x7b,0xf0]
          vcvtusi2ss xmm14, xmm22, {rd-sae}, rax

// CHECK: vcvtusi2ss xmm14, xmm22, {rz-sae}, rax
// CHECK:  encoding: [0x62,0x71,0xce,0x70,0x7b,0xf0]
          vcvtusi2ss xmm14, xmm22, {rz-sae}, rax

// CHECK: vcvtusi2ss xmm14, xmm22, r8
// CHECK:  encoding: [0x62,0x51,0xce,0x00,0x7b,0xf0]
          vcvtusi2ss xmm14, xmm22, r8

// CHECK: vcvtusi2ss xmm14, xmm22, {rn-sae}, r8
// CHECK:  encoding: [0x62,0x51,0xce,0x10,0x7b,0xf0]
          vcvtusi2ss xmm14, xmm22, {rn-sae}, r8

// CHECK: vcvtusi2ss xmm14, xmm22, {ru-sae}, r8
// CHECK:  encoding: [0x62,0x51,0xce,0x50,0x7b,0xf0]
          vcvtusi2ss xmm14, xmm22, {ru-sae}, r8

// CHECK: vcvtusi2ss xmm14, xmm22, {rd-sae}, r8
// CHECK:  encoding: [0x62,0x51,0xce,0x30,0x7b,0xf0]
          vcvtusi2ss xmm14, xmm22, {rd-sae}, r8

// CHECK: vcvtusi2ss xmm14, xmm22, {rz-sae}, r8
// CHECK:  encoding: [0x62,0x51,0xce,0x70,0x7b,0xf0]
          vcvtusi2ss xmm14, xmm22, {rz-sae}, r8

// CHECK: vcvtusi2ss xmm14, xmm22, qword ptr [rcx]
// CHECK:  encoding: [0x62,0x71,0xce,0x00,0x7b,0x31]
          vcvtusi2ss xmm14, xmm22, qword ptr [rcx]

// CHECK: vcvtusi2ss xmm14, xmm22, qword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0x31,0xce,0x00,0x7b,0xb4,0xf0,0x23,0x01,0x00,0x00]
          vcvtusi2ss xmm14, xmm22, qword ptr [rax + 8*r14 + 291]

// CHECK: vcvtusi2ss xmm14, xmm22, qword ptr [rdx + 1016]
// CHECK:  encoding: [0x62,0x71,0xce,0x00,0x7b,0x72,0x7f]
          vcvtusi2ss xmm14, xmm22, qword ptr [rdx + 1016]

// CHECK: vcvtusi2ss xmm14, xmm22, qword ptr [rdx + 1024]
// CHECK:  encoding: [0x62,0x71,0xce,0x00,0x7b,0xb2,0x00,0x04,0x00,0x00]
          vcvtusi2ss xmm14, xmm22, qword ptr [rdx + 1024]

// CHECK: vcvtusi2ss xmm14, xmm22, qword ptr [rdx - 1024]
// CHECK:  encoding: [0x62,0x71,0xce,0x00,0x7b,0x72,0x80]
          vcvtusi2ss xmm14, xmm22, qword ptr [rdx - 1024]

// CHECK: vcvtusi2ss xmm14, xmm22, qword ptr [rdx - 1032]
// CHECK:  encoding: [0x62,0x71,0xce,0x00,0x7b,0xb2,0xf8,0xfb,0xff,0xff]
          vcvtusi2ss xmm14, xmm22, qword ptr [rdx - 1032]

// CHECK: vscalefpd zmm26, zmm26, zmm28
// CHECK:  encoding: [0x62,0x02,0xad,0x40,0x2c,0xd4]
          vscalefpd zmm26, zmm26, zmm28

// CHECK: vscalefpd zmm26 {k5}, zmm26, zmm28
// CHECK:  encoding: [0x62,0x02,0xad,0x45,0x2c,0xd4]
          vscalefpd zmm26 {k5}, zmm26, zmm28

// CHECK: vscalefpd zmm26 {k5} {z}, zmm26, zmm28
// CHECK:  encoding: [0x62,0x02,0xad,0xc5,0x2c,0xd4]
          vscalefpd zmm26 {k5} {z}, zmm26, zmm28

// CHECK: vscalefpd zmm26, zmm26, zmm28, {rn-sae}
// CHECK:  encoding: [0x62,0x02,0xad,0x10,0x2c,0xd4]
          vscalefpd zmm26, zmm26, zmm28, {rn-sae}

// CHECK: vscalefpd zmm26, zmm26, zmm28, {ru-sae}
// CHECK:  encoding: [0x62,0x02,0xad,0x50,0x2c,0xd4]
          vscalefpd zmm26, zmm26, zmm28, {ru-sae}

// CHECK: vscalefpd zmm26, zmm26, zmm28, {rd-sae}
// CHECK:  encoding: [0x62,0x02,0xad,0x30,0x2c,0xd4]
          vscalefpd zmm26, zmm26, zmm28, {rd-sae}

// CHECK: vscalefpd zmm26, zmm26, zmm28, {rz-sae}
// CHECK:  encoding: [0x62,0x02,0xad,0x70,0x2c,0xd4]
          vscalefpd zmm26, zmm26, zmm28, {rz-sae}

// CHECK: vscalefpd zmm26, zmm26, zmmword ptr [rcx]
// CHECK:  encoding: [0x62,0x62,0xad,0x40,0x2c,0x11]
          vscalefpd zmm26, zmm26, zmmword ptr [rcx]

// CHECK: vscalefpd zmm26, zmm26, zmmword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0x22,0xad,0x40,0x2c,0x94,0xf0,0x23,0x01,0x00,0x00]
          vscalefpd zmm26, zmm26, zmmword ptr [rax + 8*r14 + 291]

// CHECK: vscalefpd zmm26, zmm26, qword ptr [rcx]{1to8}
// CHECK:  encoding: [0x62,0x62,0xad,0x50,0x2c,0x11]
          vscalefpd zmm26, zmm26, qword ptr [rcx]{1to8}

// CHECK: vscalefpd zmm26, zmm26, zmmword ptr [rdx + 8128]
// CHECK:  encoding: [0x62,0x62,0xad,0x40,0x2c,0x52,0x7f]
          vscalefpd zmm26, zmm26, zmmword ptr [rdx + 8128]

// CHECK: vscalefpd zmm26, zmm26, zmmword ptr [rdx + 8192]
// CHECK:  encoding: [0x62,0x62,0xad,0x40,0x2c,0x92,0x00,0x20,0x00,0x00]
          vscalefpd zmm26, zmm26, zmmword ptr [rdx + 8192]

// CHECK: vscalefpd zmm26, zmm26, zmmword ptr [rdx - 8192]
// CHECK:  encoding: [0x62,0x62,0xad,0x40,0x2c,0x52,0x80]
          vscalefpd zmm26, zmm26, zmmword ptr [rdx - 8192]

// CHECK: vscalefpd zmm26, zmm26, zmmword ptr [rdx - 8256]
// CHECK:  encoding: [0x62,0x62,0xad,0x40,0x2c,0x92,0xc0,0xdf,0xff,0xff]
          vscalefpd zmm26, zmm26, zmmword ptr [rdx - 8256]

// CHECK: vscalefpd zmm26, zmm26, qword ptr [rdx + 1016]{1to8}
// CHECK:  encoding: [0x62,0x62,0xad,0x50,0x2c,0x52,0x7f]
          vscalefpd zmm26, zmm26, qword ptr [rdx + 1016]{1to8}

// CHECK: vscalefpd zmm26, zmm26, qword ptr [rdx + 1024]{1to8}
// CHECK:  encoding: [0x62,0x62,0xad,0x50,0x2c,0x92,0x00,0x04,0x00,0x00]
          vscalefpd zmm26, zmm26, qword ptr [rdx + 1024]{1to8}

// CHECK: vscalefpd zmm26, zmm26, qword ptr [rdx - 1024]{1to8}
// CHECK:  encoding: [0x62,0x62,0xad,0x50,0x2c,0x52,0x80]
          vscalefpd zmm26, zmm26, qword ptr [rdx - 1024]{1to8}

// CHECK: vscalefpd zmm26, zmm26, qword ptr [rdx - 1032]{1to8}
// CHECK:  encoding: [0x62,0x62,0xad,0x50,0x2c,0x92,0xf8,0xfb,0xff,0xff]
          vscalefpd zmm26, zmm26, qword ptr [rdx - 1032]{1to8}

// CHECK: vscalefps zmm19, zmm6, zmm18
// CHECK:  encoding: [0x62,0xa2,0x4d,0x48,0x2c,0xda]
          vscalefps zmm19, zmm6, zmm18

// CHECK: vscalefps zmm19 {k6}, zmm6, zmm18
// CHECK:  encoding: [0x62,0xa2,0x4d,0x4e,0x2c,0xda]
          vscalefps zmm19 {k6}, zmm6, zmm18

// CHECK: vscalefps zmm19 {k6} {z}, zmm6, zmm18
// CHECK:  encoding: [0x62,0xa2,0x4d,0xce,0x2c,0xda]
          vscalefps zmm19 {k6} {z}, zmm6, zmm18

// CHECK: vscalefps zmm19, zmm6, zmm18, {rn-sae}
// CHECK:  encoding: [0x62,0xa2,0x4d,0x18,0x2c,0xda]
          vscalefps zmm19, zmm6, zmm18, {rn-sae}

// CHECK: vscalefps zmm19, zmm6, zmm18, {ru-sae}
// CHECK:  encoding: [0x62,0xa2,0x4d,0x58,0x2c,0xda]
          vscalefps zmm19, zmm6, zmm18, {ru-sae}

// CHECK: vscalefps zmm19, zmm6, zmm18, {rd-sae}
// CHECK:  encoding: [0x62,0xa2,0x4d,0x38,0x2c,0xda]
          vscalefps zmm19, zmm6, zmm18, {rd-sae}

// CHECK: vscalefps zmm19, zmm6, zmm18, {rz-sae}
// CHECK:  encoding: [0x62,0xa2,0x4d,0x78,0x2c,0xda]
          vscalefps zmm19, zmm6, zmm18, {rz-sae}

// CHECK: vscalefps zmm19, zmm6, zmmword ptr [rcx]
// CHECK:  encoding: [0x62,0xe2,0x4d,0x48,0x2c,0x19]
          vscalefps zmm19, zmm6, zmmword ptr [rcx]

// CHECK: vscalefps zmm19, zmm6, zmmword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0xa2,0x4d,0x48,0x2c,0x9c,0xf0,0x23,0x01,0x00,0x00]
          vscalefps zmm19, zmm6, zmmword ptr [rax + 8*r14 + 291]

// CHECK: vscalefps zmm19, zmm6, dword ptr [rcx]{1to16}
// CHECK:  encoding: [0x62,0xe2,0x4d,0x58,0x2c,0x19]
          vscalefps zmm19, zmm6, dword ptr [rcx]{1to16}

// CHECK: vscalefps zmm19, zmm6, zmmword ptr [rdx + 8128]
// CHECK:  encoding: [0x62,0xe2,0x4d,0x48,0x2c,0x5a,0x7f]
          vscalefps zmm19, zmm6, zmmword ptr [rdx + 8128]

// CHECK: vscalefps zmm19, zmm6, zmmword ptr [rdx + 8192]
// CHECK:  encoding: [0x62,0xe2,0x4d,0x48,0x2c,0x9a,0x00,0x20,0x00,0x00]
          vscalefps zmm19, zmm6, zmmword ptr [rdx + 8192]

// CHECK: vscalefps zmm19, zmm6, zmmword ptr [rdx - 8192]
// CHECK:  encoding: [0x62,0xe2,0x4d,0x48,0x2c,0x5a,0x80]
          vscalefps zmm19, zmm6, zmmword ptr [rdx - 8192]

// CHECK: vscalefps zmm19, zmm6, zmmword ptr [rdx - 8256]
// CHECK:  encoding: [0x62,0xe2,0x4d,0x48,0x2c,0x9a,0xc0,0xdf,0xff,0xff]
          vscalefps zmm19, zmm6, zmmword ptr [rdx - 8256]

// CHECK: vscalefps zmm19, zmm6, dword ptr [rdx + 508]{1to16}
// CHECK:  encoding: [0x62,0xe2,0x4d,0x58,0x2c,0x5a,0x7f]
          vscalefps zmm19, zmm6, dword ptr [rdx + 508]{1to16}

// CHECK: vscalefps zmm19, zmm6, dword ptr [rdx + 512]{1to16}
// CHECK:  encoding: [0x62,0xe2,0x4d,0x58,0x2c,0x9a,0x00,0x02,0x00,0x00]
          vscalefps zmm19, zmm6, dword ptr [rdx + 512]{1to16}

// CHECK: vscalefps zmm19, zmm6, dword ptr [rdx - 512]{1to16}
// CHECK:  encoding: [0x62,0xe2,0x4d,0x58,0x2c,0x5a,0x80]
          vscalefps zmm19, zmm6, dword ptr [rdx - 512]{1to16}

// CHECK: vscalefps zmm19, zmm6, dword ptr [rdx - 516]{1to16}
// CHECK:  encoding: [0x62,0xe2,0x4d,0x58,0x2c,0x9a,0xfc,0xfd,0xff,0xff]
          vscalefps zmm19, zmm6, dword ptr [rdx - 516]{1to16}

// CHECK: vscalefsd xmm21, xmm22, xmm21
// CHECK:  encoding: [0x62,0xa2,0xcd,0x00,0x2d,0xed]
          vscalefsd xmm21, xmm22, xmm21

// CHECK: vscalefsd xmm21 {k2}, xmm22, xmm21
// CHECK:  encoding: [0x62,0xa2,0xcd,0x02,0x2d,0xed]
          vscalefsd xmm21 {k2}, xmm22, xmm21

// CHECK: vscalefsd xmm21 {k2} {z}, xmm22, xmm21
// CHECK:  encoding: [0x62,0xa2,0xcd,0x82,0x2d,0xed]
          vscalefsd xmm21 {k2} {z}, xmm22, xmm21

// CHECK: vscalefsd xmm21, xmm22, xmm21, {rn-sae}
// CHECK:  encoding: [0x62,0xa2,0xcd,0x10,0x2d,0xed]
          vscalefsd xmm21, xmm22, xmm21, {rn-sae}

// CHECK: vscalefsd xmm21, xmm22, xmm21, {ru-sae}
// CHECK:  encoding: [0x62,0xa2,0xcd,0x50,0x2d,0xed]
          vscalefsd xmm21, xmm22, xmm21, {ru-sae}

// CHECK: vscalefsd xmm21, xmm22, xmm21, {rd-sae}
// CHECK:  encoding: [0x62,0xa2,0xcd,0x30,0x2d,0xed]
          vscalefsd xmm21, xmm22, xmm21, {rd-sae}

// CHECK: vscalefsd xmm21, xmm22, xmm21, {rz-sae}
// CHECK:  encoding: [0x62,0xa2,0xcd,0x70,0x2d,0xed]
          vscalefsd xmm21, xmm22, xmm21, {rz-sae}

// CHECK: vscalefsd xmm21, xmm22, qword ptr [rcx]
// CHECK:  encoding: [0x62,0xe2,0xcd,0x00,0x2d,0x29]
          vscalefsd xmm21, xmm22, qword ptr [rcx]

// CHECK: vscalefsd xmm21, xmm22, qword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0xa2,0xcd,0x00,0x2d,0xac,0xf0,0x23,0x01,0x00,0x00]
          vscalefsd xmm21, xmm22, qword ptr [rax + 8*r14 + 291]

// CHECK: vscalefsd xmm21, xmm22, qword ptr [rdx + 1016]
// CHECK:  encoding: [0x62,0xe2,0xcd,0x00,0x2d,0x6a,0x7f]
          vscalefsd xmm21, xmm22, qword ptr [rdx + 1016]

// CHECK: vscalefsd xmm21, xmm22, qword ptr [rdx + 1024]
// CHECK:  encoding: [0x62,0xe2,0xcd,0x00,0x2d,0xaa,0x00,0x04,0x00,0x00]
          vscalefsd xmm21, xmm22, qword ptr [rdx + 1024]

// CHECK: vscalefsd xmm21, xmm22, qword ptr [rdx - 1024]
// CHECK:  encoding: [0x62,0xe2,0xcd,0x00,0x2d,0x6a,0x80]
          vscalefsd xmm21, xmm22, qword ptr [rdx - 1024]

// CHECK: vscalefsd xmm21, xmm22, qword ptr [rdx - 1032]
// CHECK:  encoding: [0x62,0xe2,0xcd,0x00,0x2d,0xaa,0xf8,0xfb,0xff,0xff]
          vscalefsd xmm21, xmm22, qword ptr [rdx - 1032]

// CHECK: vscalefss xmm13, xmm15, xmm23
// CHECK:  encoding: [0x62,0x32,0x05,0x08,0x2d,0xef]
          vscalefss xmm13, xmm15, xmm23

// CHECK: vscalefss xmm13 {k3}, xmm15, xmm23
// CHECK:  encoding: [0x62,0x32,0x05,0x0b,0x2d,0xef]
          vscalefss xmm13 {k3}, xmm15, xmm23

// CHECK: vscalefss xmm13 {k3} {z}, xmm15, xmm23
// CHECK:  encoding: [0x62,0x32,0x05,0x8b,0x2d,0xef]
          vscalefss xmm13 {k3} {z}, xmm15, xmm23

// CHECK: vscalefss xmm13, xmm15, xmm23, {rn-sae}
// CHECK:  encoding: [0x62,0x32,0x05,0x18,0x2d,0xef]
          vscalefss xmm13, xmm15, xmm23, {rn-sae}

// CHECK: vscalefss xmm13, xmm15, xmm23, {ru-sae}
// CHECK:  encoding: [0x62,0x32,0x05,0x58,0x2d,0xef]
          vscalefss xmm13, xmm15, xmm23, {ru-sae}

// CHECK: vscalefss xmm13, xmm15, xmm23, {rd-sae}
// CHECK:  encoding: [0x62,0x32,0x05,0x38,0x2d,0xef]
          vscalefss xmm13, xmm15, xmm23, {rd-sae}

// CHECK: vscalefss xmm13, xmm15, xmm23, {rz-sae}
// CHECK:  encoding: [0x62,0x32,0x05,0x78,0x2d,0xef]
          vscalefss xmm13, xmm15, xmm23, {rz-sae}

// CHECK: vscalefss xmm13, xmm15, dword ptr [rcx]
// CHECK:  encoding: [0x62,0x72,0x05,0x08,0x2d,0x29]
          vscalefss xmm13, xmm15, dword ptr [rcx]

// CHECK: vscalefss xmm13, xmm15, dword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0x32,0x05,0x08,0x2d,0xac,0xf0,0x23,0x01,0x00,0x00]
          vscalefss xmm13, xmm15, dword ptr [rax + 8*r14 + 291]

// CHECK: vscalefss xmm13, xmm15, dword ptr [rdx + 508]
// CHECK:  encoding: [0x62,0x72,0x05,0x08,0x2d,0x6a,0x7f]
          vscalefss xmm13, xmm15, dword ptr [rdx + 508]

// CHECK: vscalefss xmm13, xmm15, dword ptr [rdx + 512]
// CHECK:  encoding: [0x62,0x72,0x05,0x08,0x2d,0xaa,0x00,0x02,0x00,0x00]
          vscalefss xmm13, xmm15, dword ptr [rdx + 512]

// CHECK: vscalefss xmm13, xmm15, dword ptr [rdx - 512]
// CHECK:  encoding: [0x62,0x72,0x05,0x08,0x2d,0x6a,0x80]
          vscalefss xmm13, xmm15, dword ptr [rdx - 512]

// CHECK: vscalefss xmm13, xmm15, dword ptr [rdx - 516]
// CHECK:  encoding: [0x62,0x72,0x05,0x08,0x2d,0xaa,0xfc,0xfd,0xff,0xff]
          vscalefss xmm13, xmm15, dword ptr [rdx - 516]

// CHECK: vfixupimmps zmm15, zmm26, zmm2, 171
// CHECK:  encoding: [0x62,0x73,0x2d,0x40,0x54,0xfa,0xab]
          vfixupimmps zmm15, zmm26, zmm2, 171

// CHECK: vfixupimmps zmm15 {k4}, zmm26, zmm2, 171
// CHECK:  encoding: [0x62,0x73,0x2d,0x44,0x54,0xfa,0xab]
          vfixupimmps zmm15 {k4}, zmm26, zmm2, 171

// CHECK: vfixupimmps zmm15 {k4} {z}, zmm26, zmm2, 171
// CHECK:  encoding: [0x62,0x73,0x2d,0xc4,0x54,0xfa,0xab]
          vfixupimmps zmm15 {k4} {z}, zmm26, zmm2, 171

// CHECK: vfixupimmps zmm15, zmm26, zmm2, {sae}, 171
// CHECK:  encoding: [0x62,0x73,0x2d,0x10,0x54,0xfa,0xab]
          vfixupimmps zmm15, zmm26, zmm2, {sae}, 171

// CHECK: vfixupimmps zmm15, zmm26, zmm2, 123
// CHECK:  encoding: [0x62,0x73,0x2d,0x40,0x54,0xfa,0x7b]
          vfixupimmps zmm15, zmm26, zmm2, 123

// CHECK: vfixupimmps zmm15, zmm26, zmm2, {sae}, 123
// CHECK:  encoding: [0x62,0x73,0x2d,0x10,0x54,0xfa,0x7b]
          vfixupimmps zmm15, zmm26, zmm2, {sae}, 123

// CHECK: vfixupimmps zmm15, zmm26, zmmword ptr [rcx], 123
// CHECK:  encoding: [0x62,0x73,0x2d,0x40,0x54,0x39,0x7b]
          vfixupimmps zmm15, zmm26, zmmword ptr [rcx], 123

// CHECK: vfixupimmps zmm15, zmm26, zmmword ptr [rax + 8*r14 + 291], 123
// CHECK:  encoding: [0x62,0x33,0x2d,0x40,0x54,0xbc,0xf0,0x23,0x01,0x00,0x00,0x7b]
          vfixupimmps zmm15, zmm26, zmmword ptr [rax + 8*r14 + 291], 123

// CHECK: vfixupimmps zmm15, zmm26, dword ptr [rcx]{1to16}, 123
// CHECK:  encoding: [0x62,0x73,0x2d,0x50,0x54,0x39,0x7b]
          vfixupimmps zmm15, zmm26, dword ptr [rcx]{1to16}, 123

// CHECK: vfixupimmps zmm15, zmm26, zmmword ptr [rdx + 8128], 123
// CHECK:  encoding: [0x62,0x73,0x2d,0x40,0x54,0x7a,0x7f,0x7b]
          vfixupimmps zmm15, zmm26, zmmword ptr [rdx + 8128], 123

// CHECK: vfixupimmps zmm15, zmm26, zmmword ptr [rdx + 8192], 123
// CHECK:  encoding: [0x62,0x73,0x2d,0x40,0x54,0xba,0x00,0x20,0x00,0x00,0x7b]
          vfixupimmps zmm15, zmm26, zmmword ptr [rdx + 8192], 123

// CHECK: vfixupimmps zmm15, zmm26, zmmword ptr [rdx - 8192], 123
// CHECK:  encoding: [0x62,0x73,0x2d,0x40,0x54,0x7a,0x80,0x7b]
          vfixupimmps zmm15, zmm26, zmmword ptr [rdx - 8192], 123

// CHECK: vfixupimmps zmm15, zmm26, zmmword ptr [rdx - 8256], 123
// CHECK:  encoding: [0x62,0x73,0x2d,0x40,0x54,0xba,0xc0,0xdf,0xff,0xff,0x7b]
          vfixupimmps zmm15, zmm26, zmmword ptr [rdx - 8256], 123

// CHECK: vfixupimmps zmm15, zmm26, dword ptr [rdx + 508]{1to16}, 123
// CHECK:  encoding: [0x62,0x73,0x2d,0x50,0x54,0x7a,0x7f,0x7b]
          vfixupimmps zmm15, zmm26, dword ptr [rdx + 508]{1to16}, 123

// CHECK: vfixupimmps zmm15, zmm26, dword ptr [rdx + 512]{1to16}, 123
// CHECK:  encoding: [0x62,0x73,0x2d,0x50,0x54,0xba,0x00,0x02,0x00,0x00,0x7b]
          vfixupimmps zmm15, zmm26, dword ptr [rdx + 512]{1to16}, 123

// CHECK: vfixupimmps zmm15, zmm26, dword ptr [rdx - 512]{1to16}, 123
// CHECK:  encoding: [0x62,0x73,0x2d,0x50,0x54,0x7a,0x80,0x7b]
          vfixupimmps zmm15, zmm26, dword ptr [rdx - 512]{1to16}, 123

// CHECK: vfixupimmps zmm15, zmm26, dword ptr [rdx - 516]{1to16}, 123
// CHECK:  encoding: [0x62,0x73,0x2d,0x50,0x54,0xba,0xfc,0xfd,0xff,0xff,0x7b]
          vfixupimmps zmm15, zmm26, dword ptr [rdx - 516]{1to16}, 123

// CHECK: vfixupimmpd zmm9, zmm21, zmm19, 171
// CHECK:  encoding: [0x62,0x33,0xd5,0x40,0x54,0xcb,0xab]
          vfixupimmpd zmm9, zmm21, zmm19, 171

// CHECK: vfixupimmpd zmm9 {k2}, zmm21, zmm19, 171
// CHECK:  encoding: [0x62,0x33,0xd5,0x42,0x54,0xcb,0xab]
          vfixupimmpd zmm9 {k2}, zmm21, zmm19, 171

// CHECK: vfixupimmpd zmm9 {k2} {z}, zmm21, zmm19, 171
// CHECK:  encoding: [0x62,0x33,0xd5,0xc2,0x54,0xcb,0xab]
          vfixupimmpd zmm9 {k2} {z}, zmm21, zmm19, 171

// CHECK: vfixupimmpd zmm9, zmm21, zmm19, {sae}, 171
// CHECK:  encoding: [0x62,0x33,0xd5,0x10,0x54,0xcb,0xab]
          vfixupimmpd zmm9, zmm21, zmm19, {sae}, 171

// CHECK: vfixupimmpd zmm9, zmm21, zmm19, 123
// CHECK:  encoding: [0x62,0x33,0xd5,0x40,0x54,0xcb,0x7b]
          vfixupimmpd zmm9, zmm21, zmm19, 123

// CHECK: vfixupimmpd zmm9, zmm21, zmm19, {sae}, 123
// CHECK:  encoding: [0x62,0x33,0xd5,0x10,0x54,0xcb,0x7b]
          vfixupimmpd zmm9, zmm21, zmm19, {sae}, 123

// CHECK: vfixupimmpd zmm9, zmm21, zmmword ptr [rcx], 123
// CHECK:  encoding: [0x62,0x73,0xd5,0x40,0x54,0x09,0x7b]
          vfixupimmpd zmm9, zmm21, zmmword ptr [rcx], 123

// CHECK: vfixupimmpd zmm9, zmm21, zmmword ptr [rax + 8*r14 + 291], 123
// CHECK:  encoding: [0x62,0x33,0xd5,0x40,0x54,0x8c,0xf0,0x23,0x01,0x00,0x00,0x7b]
          vfixupimmpd zmm9, zmm21, zmmword ptr [rax + 8*r14 + 291], 123

// CHECK: vfixupimmpd zmm9, zmm21, qword ptr [rcx]{1to8}, 123
// CHECK:  encoding: [0x62,0x73,0xd5,0x50,0x54,0x09,0x7b]
          vfixupimmpd zmm9, zmm21, qword ptr [rcx]{1to8}, 123

// CHECK: vfixupimmpd zmm9, zmm21, zmmword ptr [rdx + 8128], 123
// CHECK:  encoding: [0x62,0x73,0xd5,0x40,0x54,0x4a,0x7f,0x7b]
          vfixupimmpd zmm9, zmm21, zmmword ptr [rdx + 8128], 123

// CHECK: vfixupimmpd zmm9, zmm21, zmmword ptr [rdx + 8192], 123
// CHECK:  encoding: [0x62,0x73,0xd5,0x40,0x54,0x8a,0x00,0x20,0x00,0x00,0x7b]
          vfixupimmpd zmm9, zmm21, zmmword ptr [rdx + 8192], 123

// CHECK: vfixupimmpd zmm9, zmm21, zmmword ptr [rdx - 8192], 123
// CHECK:  encoding: [0x62,0x73,0xd5,0x40,0x54,0x4a,0x80,0x7b]
          vfixupimmpd zmm9, zmm21, zmmword ptr [rdx - 8192], 123

// CHECK: vfixupimmpd zmm9, zmm21, zmmword ptr [rdx - 8256], 123
// CHECK:  encoding: [0x62,0x73,0xd5,0x40,0x54,0x8a,0xc0,0xdf,0xff,0xff,0x7b]
          vfixupimmpd zmm9, zmm21, zmmword ptr [rdx - 8256], 123

// CHECK: vfixupimmpd zmm9, zmm21, qword ptr [rdx + 1016]{1to8}, 123
// CHECK:  encoding: [0x62,0x73,0xd5,0x50,0x54,0x4a,0x7f,0x7b]
          vfixupimmpd zmm9, zmm21, qword ptr [rdx + 1016]{1to8}, 123

// CHECK: vfixupimmpd zmm9, zmm21, qword ptr [rdx + 1024]{1to8}, 123
// CHECK:  encoding: [0x62,0x73,0xd5,0x50,0x54,0x8a,0x00,0x04,0x00,0x00,0x7b]
          vfixupimmpd zmm9, zmm21, qword ptr [rdx + 1024]{1to8}, 123

// CHECK: vfixupimmpd zmm9, zmm21, qword ptr [rdx - 1024]{1to8}, 123
// CHECK:  encoding: [0x62,0x73,0xd5,0x50,0x54,0x4a,0x80,0x7b]
          vfixupimmpd zmm9, zmm21, qword ptr [rdx - 1024]{1to8}, 123

// CHECK: vfixupimmpd zmm9, zmm21, qword ptr [rdx - 1032]{1to8}, 123
// CHECK:  encoding: [0x62,0x73,0xd5,0x50,0x54,0x8a,0xf8,0xfb,0xff,0xff,0x7b]
          vfixupimmpd zmm9, zmm21, qword ptr [rdx - 1032]{1to8}, 123

// CHECK: vfixupimmss xmm15, xmm18, xmm28, 171
// CHECK:  encoding: [0x62,0x13,0x6d,0x00,0x55,0xfc,0xab]
          vfixupimmss xmm15, xmm18, xmm28, 171

// CHECK: vfixupimmss xmm15 {k5}, xmm18, xmm28, 171
// CHECK:  encoding: [0x62,0x13,0x6d,0x05,0x55,0xfc,0xab]
          vfixupimmss xmm15 {k5}, xmm18, xmm28, 171

// CHECK: vfixupimmss xmm15 {k5} {z}, xmm18, xmm28, 171
// CHECK:  encoding: [0x62,0x13,0x6d,0x85,0x55,0xfc,0xab]
          vfixupimmss xmm15 {k5} {z}, xmm18, xmm28, 171

// CHECK: vfixupimmss xmm15, xmm18, xmm28, {sae}, 171
// CHECK:  encoding: [0x62,0x13,0x6d,0x10,0x55,0xfc,0xab]
          vfixupimmss xmm15, xmm18, xmm28, {sae}, 171

// CHECK: vfixupimmss xmm15, xmm18, xmm28, 123
// CHECK:  encoding: [0x62,0x13,0x6d,0x00,0x55,0xfc,0x7b]
          vfixupimmss xmm15, xmm18, xmm28, 123

// CHECK: vfixupimmss xmm15, xmm18, xmm28, {sae}, 123
// CHECK:  encoding: [0x62,0x13,0x6d,0x10,0x55,0xfc,0x7b]
          vfixupimmss xmm15, xmm18, xmm28, {sae}, 123

// CHECK: vfixupimmss xmm15, xmm18, dword ptr [rcx], 123
// CHECK:  encoding: [0x62,0x73,0x6d,0x00,0x55,0x39,0x7b]
          vfixupimmss xmm15, xmm18, dword ptr [rcx], 123

// CHECK: vfixupimmss xmm15, xmm18, dword ptr [rax + 8*r14 + 291], 123
// CHECK:  encoding: [0x62,0x33,0x6d,0x00,0x55,0xbc,0xf0,0x23,0x01,0x00,0x00,0x7b]
          vfixupimmss xmm15, xmm18, dword ptr [rax + 8*r14 + 291], 123

// CHECK: vfixupimmss xmm15, xmm18, dword ptr [rdx + 508], 123
// CHECK:  encoding: [0x62,0x73,0x6d,0x00,0x55,0x7a,0x7f,0x7b]
          vfixupimmss xmm15, xmm18, dword ptr [rdx + 508], 123

// CHECK: vfixupimmss xmm15, xmm18, dword ptr [rdx + 512], 123
// CHECK:  encoding: [0x62,0x73,0x6d,0x00,0x55,0xba,0x00,0x02,0x00,0x00,0x7b]
          vfixupimmss xmm15, xmm18, dword ptr [rdx + 512], 123

// CHECK: vfixupimmss xmm15, xmm18, dword ptr [rdx - 512], 123
// CHECK:  encoding: [0x62,0x73,0x6d,0x00,0x55,0x7a,0x80,0x7b]
          vfixupimmss xmm15, xmm18, dword ptr [rdx - 512], 123

// CHECK: vfixupimmss xmm15, xmm18, dword ptr [rdx - 516], 123
// CHECK:  encoding: [0x62,0x73,0x6d,0x00,0x55,0xba,0xfc,0xfd,0xff,0xff,0x7b]
          vfixupimmss xmm15, xmm18, dword ptr [rdx - 516], 123

// CHECK: vfixupimmsd xmm13, xmm26, xmm5, 171
// CHECK:  encoding: [0x62,0x73,0xad,0x00,0x55,0xed,0xab]
          vfixupimmsd xmm13, xmm26, xmm5, 171

// CHECK: vfixupimmsd xmm13 {k6}, xmm26, xmm5, 171
// CHECK:  encoding: [0x62,0x73,0xad,0x06,0x55,0xed,0xab]
          vfixupimmsd xmm13 {k6}, xmm26, xmm5, 171

// CHECK: vfixupimmsd xmm13 {k6} {z}, xmm26, xmm5, 171
// CHECK:  encoding: [0x62,0x73,0xad,0x86,0x55,0xed,0xab]
          vfixupimmsd xmm13 {k6} {z}, xmm26, xmm5, 171

// CHECK: vfixupimmsd xmm13, xmm26, xmm5, {sae}, 171
// CHECK:  encoding: [0x62,0x73,0xad,0x10,0x55,0xed,0xab]
          vfixupimmsd xmm13, xmm26, xmm5, {sae}, 171

// CHECK: vfixupimmsd xmm13, xmm26, xmm5, 123
// CHECK:  encoding: [0x62,0x73,0xad,0x00,0x55,0xed,0x7b]
          vfixupimmsd xmm13, xmm26, xmm5, 123

// CHECK: vfixupimmsd xmm13, xmm26, xmm5, {sae}, 123
// CHECK:  encoding: [0x62,0x73,0xad,0x10,0x55,0xed,0x7b]
          vfixupimmsd xmm13, xmm26, xmm5, {sae}, 123

// CHECK: vfixupimmsd xmm13, xmm26, qword ptr [rcx], 123
// CHECK:  encoding: [0x62,0x73,0xad,0x00,0x55,0x29,0x7b]
          vfixupimmsd xmm13, xmm26, qword ptr [rcx], 123

// CHECK: vfixupimmsd xmm13, xmm26, qword ptr [rax + 8*r14 + 291], 123
// CHECK:  encoding: [0x62,0x33,0xad,0x00,0x55,0xac,0xf0,0x23,0x01,0x00,0x00,0x7b]
          vfixupimmsd xmm13, xmm26, qword ptr [rax + 8*r14 + 291], 123

// CHECK: vfixupimmsd xmm13, xmm26, qword ptr [rdx + 1016], 123
// CHECK:  encoding: [0x62,0x73,0xad,0x00,0x55,0x6a,0x7f,0x7b]
          vfixupimmsd xmm13, xmm26, qword ptr [rdx + 1016], 123

// CHECK: vfixupimmsd xmm13, xmm26, qword ptr [rdx + 1024], 123
// CHECK:  encoding: [0x62,0x73,0xad,0x00,0x55,0xaa,0x00,0x04,0x00,0x00,0x7b]
          vfixupimmsd xmm13, xmm26, qword ptr [rdx + 1024], 123

// CHECK: vfixupimmsd xmm13, xmm26, qword ptr [rdx - 1024], 123
// CHECK:  encoding: [0x62,0x73,0xad,0x00,0x55,0x6a,0x80,0x7b]
          vfixupimmsd xmm13, xmm26, qword ptr [rdx - 1024], 123

// CHECK: vfixupimmsd xmm13, xmm26, qword ptr [rdx - 1032], 123
// CHECK:  encoding: [0x62,0x73,0xad,0x00,0x55,0xaa,0xf8,0xfb,0xff,0xff,0x7b]
          vfixupimmsd xmm13, xmm26, qword ptr [rdx - 1032], 123

// CHECK: vpslld zmm29, zmm24, 171
// CHECK:  encoding: [0x62,0x91,0x15,0x40,0x72,0xf0,0xab]
          vpslld zmm29, zmm24, 171

// CHECK: vpslld zmm29 {k6}, zmm24, 171
// CHECK:  encoding: [0x62,0x91,0x15,0x46,0x72,0xf0,0xab]
          vpslld zmm29 {k6}, zmm24, 171

// CHECK: vpslld zmm29 {k6} {z}, zmm24, 171
// CHECK:  encoding: [0x62,0x91,0x15,0xc6,0x72,0xf0,0xab]
          vpslld zmm29 {k6} {z}, zmm24, 171

// CHECK: vpslld zmm29, zmm24, 123
// CHECK:  encoding: [0x62,0x91,0x15,0x40,0x72,0xf0,0x7b]
          vpslld zmm29, zmm24, 123

// CHECK: vpslld zmm29, zmmword ptr [rcx], 123
// CHECK:  encoding: [0x62,0xf1,0x15,0x40,0x72,0x31,0x7b]
          vpslld zmm29, zmmword ptr [rcx], 123

// CHECK: vpslld zmm29, zmmword ptr [rax + 8*r14 + 291], 123
// CHECK:  encoding: [0x62,0xb1,0x15,0x40,0x72,0xb4,0xf0,0x23,0x01,0x00,0x00,0x7b]
          vpslld zmm29, zmmword ptr [rax + 8*r14 + 291], 123

// CHECK: vpslld zmm29, dword ptr [rcx]{1to16}, 123
// CHECK:  encoding: [0x62,0xf1,0x15,0x50,0x72,0x31,0x7b]
          vpslld zmm29, dword ptr [rcx]{1to16}, 123

// CHECK: vpslld zmm29, zmmword ptr [rdx + 8128], 123
// CHECK:  encoding: [0x62,0xf1,0x15,0x40,0x72,0x72,0x7f,0x7b]
          vpslld zmm29, zmmword ptr [rdx + 8128], 123

// CHECK: vpslld zmm29, zmmword ptr [rdx + 8192], 123
// CHECK:  encoding: [0x62,0xf1,0x15,0x40,0x72,0xb2,0x00,0x20,0x00,0x00,0x7b]
          vpslld zmm29, zmmword ptr [rdx + 8192], 123

// CHECK: vpslld zmm29, zmmword ptr [rdx - 8192], 123
// CHECK:  encoding: [0x62,0xf1,0x15,0x40,0x72,0x72,0x80,0x7b]
          vpslld zmm29, zmmword ptr [rdx - 8192], 123

// CHECK: vpslld zmm29, zmmword ptr [rdx - 8256], 123
// CHECK:  encoding: [0x62,0xf1,0x15,0x40,0x72,0xb2,0xc0,0xdf,0xff,0xff,0x7b]
          vpslld zmm29, zmmword ptr [rdx - 8256], 123

// CHECK: vpslld zmm29, dword ptr [rdx + 508]{1to16}, 123
// CHECK:  encoding: [0x62,0xf1,0x15,0x50,0x72,0x72,0x7f,0x7b]
          vpslld zmm29, dword ptr [rdx + 508]{1to16}, 123

// CHECK: vpslld zmm29, dword ptr [rdx + 512]{1to16}, 123
// CHECK:  encoding: [0x62,0xf1,0x15,0x50,0x72,0xb2,0x00,0x02,0x00,0x00,0x7b]
          vpslld zmm29, dword ptr [rdx + 512]{1to16}, 123

// CHECK: vpslld zmm29, dword ptr [rdx - 512]{1to16}, 123
// CHECK:  encoding: [0x62,0xf1,0x15,0x50,0x72,0x72,0x80,0x7b]
          vpslld zmm29, dword ptr [rdx - 512]{1to16}, 123

// CHECK: vpslld zmm29, dword ptr [rdx - 516]{1to16}, 123
// CHECK:  encoding: [0x62,0xf1,0x15,0x50,0x72,0xb2,0xfc,0xfd,0xff,0xff,0x7b]
          vpslld zmm29, dword ptr [rdx - 516]{1to16}, 123

// CHECK: vpsllq zmm6, zmm11, 171
// CHECK:  encoding: [0x62,0xd1,0xcd,0x48,0x73,0xf3,0xab]
          vpsllq zmm6, zmm11, 171

// CHECK: vpsllq zmm6 {k2}, zmm11, 171
// CHECK:  encoding: [0x62,0xd1,0xcd,0x4a,0x73,0xf3,0xab]
          vpsllq zmm6 {k2}, zmm11, 171

// CHECK: vpsllq zmm6 {k2} {z}, zmm11, 171
// CHECK:  encoding: [0x62,0xd1,0xcd,0xca,0x73,0xf3,0xab]
          vpsllq zmm6 {k2} {z}, zmm11, 171

// CHECK: vpsllq zmm6, zmm11, 123
// CHECK:  encoding: [0x62,0xd1,0xcd,0x48,0x73,0xf3,0x7b]
          vpsllq zmm6, zmm11, 123

// CHECK: vpsllq zmm6, zmmword ptr [rcx], 123
// CHECK:  encoding: [0x62,0xf1,0xcd,0x48,0x73,0x31,0x7b]
          vpsllq zmm6, zmmword ptr [rcx], 123

// CHECK: vpsllq zmm6, zmmword ptr [rax + 8*r14 + 291], 123
// CHECK:  encoding: [0x62,0xb1,0xcd,0x48,0x73,0xb4,0xf0,0x23,0x01,0x00,0x00,0x7b]
          vpsllq zmm6, zmmword ptr [rax + 8*r14 + 291], 123

// CHECK: vpsllq zmm6, qword ptr [rcx]{1to8}, 123
// CHECK:  encoding: [0x62,0xf1,0xcd,0x58,0x73,0x31,0x7b]
          vpsllq zmm6, qword ptr [rcx]{1to8}, 123

// CHECK: vpsllq zmm6, zmmword ptr [rdx + 8128], 123
// CHECK:  encoding: [0x62,0xf1,0xcd,0x48,0x73,0x72,0x7f,0x7b]
          vpsllq zmm6, zmmword ptr [rdx + 8128], 123

// CHECK: vpsllq zmm6, zmmword ptr [rdx + 8192], 123
// CHECK:  encoding: [0x62,0xf1,0xcd,0x48,0x73,0xb2,0x00,0x20,0x00,0x00,0x7b]
          vpsllq zmm6, zmmword ptr [rdx + 8192], 123

// CHECK: vpsllq zmm6, zmmword ptr [rdx - 8192], 123
// CHECK:  encoding: [0x62,0xf1,0xcd,0x48,0x73,0x72,0x80,0x7b]
          vpsllq zmm6, zmmword ptr [rdx - 8192], 123

// CHECK: vpsllq zmm6, zmmword ptr [rdx - 8256], 123
// CHECK:  encoding: [0x62,0xf1,0xcd,0x48,0x73,0xb2,0xc0,0xdf,0xff,0xff,0x7b]
          vpsllq zmm6, zmmword ptr [rdx - 8256], 123

// CHECK: vpsllq zmm6, qword ptr [rdx + 1016]{1to8}, 123
// CHECK:  encoding: [0x62,0xf1,0xcd,0x58,0x73,0x72,0x7f,0x7b]
          vpsllq zmm6, qword ptr [rdx + 1016]{1to8}, 123

// CHECK: vpsllq zmm6, qword ptr [rdx + 1024]{1to8}, 123
// CHECK:  encoding: [0x62,0xf1,0xcd,0x58,0x73,0xb2,0x00,0x04,0x00,0x00,0x7b]
          vpsllq zmm6, qword ptr [rdx + 1024]{1to8}, 123

// CHECK: vpsllq zmm6, qword ptr [rdx - 1024]{1to8}, 123
// CHECK:  encoding: [0x62,0xf1,0xcd,0x58,0x73,0x72,0x80,0x7b]
          vpsllq zmm6, qword ptr [rdx - 1024]{1to8}, 123

// CHECK: vpsllq zmm6, qword ptr [rdx - 1032]{1to8}, 123
// CHECK:  encoding: [0x62,0xf1,0xcd,0x58,0x73,0xb2,0xf8,0xfb,0xff,0xff,0x7b]
          vpsllq zmm6, qword ptr [rdx - 1032]{1to8}, 123

// CHECK: vpsrad zmm27, zmm5, 171
// CHECK:  encoding: [0x62,0xf1,0x25,0x40,0x72,0xe5,0xab]
          vpsrad zmm27, zmm5, 171

// CHECK: vpsrad zmm27 {k5}, zmm5, 171
// CHECK:  encoding: [0x62,0xf1,0x25,0x45,0x72,0xe5,0xab]
          vpsrad zmm27 {k5}, zmm5, 171

// CHECK: vpsrad zmm27 {k5} {z}, zmm5, 171
// CHECK:  encoding: [0x62,0xf1,0x25,0xc5,0x72,0xe5,0xab]
          vpsrad zmm27 {k5} {z}, zmm5, 171

// CHECK: vpsrad zmm27, zmm5, 123
// CHECK:  encoding: [0x62,0xf1,0x25,0x40,0x72,0xe5,0x7b]
          vpsrad zmm27, zmm5, 123

// CHECK: vpsrad zmm27, zmmword ptr [rcx], 123
// CHECK:  encoding: [0x62,0xf1,0x25,0x40,0x72,0x21,0x7b]
          vpsrad zmm27, zmmword ptr [rcx], 123

// CHECK: vpsrad zmm27, zmmword ptr [rax + 8*r14 + 291], 123
// CHECK:  encoding: [0x62,0xb1,0x25,0x40,0x72,0xa4,0xf0,0x23,0x01,0x00,0x00,0x7b]
          vpsrad zmm27, zmmword ptr [rax + 8*r14 + 291], 123

// CHECK: vpsrad zmm27, dword ptr [rcx]{1to16}, 123
// CHECK:  encoding: [0x62,0xf1,0x25,0x50,0x72,0x21,0x7b]
          vpsrad zmm27, dword ptr [rcx]{1to16}, 123

// CHECK: vpsrad zmm27, zmmword ptr [rdx + 8128], 123
// CHECK:  encoding: [0x62,0xf1,0x25,0x40,0x72,0x62,0x7f,0x7b]
          vpsrad zmm27, zmmword ptr [rdx + 8128], 123

// CHECK: vpsrad zmm27, zmmword ptr [rdx + 8192], 123
// CHECK:  encoding: [0x62,0xf1,0x25,0x40,0x72,0xa2,0x00,0x20,0x00,0x00,0x7b]
          vpsrad zmm27, zmmword ptr [rdx + 8192], 123

// CHECK: vpsrad zmm27, zmmword ptr [rdx - 8192], 123
// CHECK:  encoding: [0x62,0xf1,0x25,0x40,0x72,0x62,0x80,0x7b]
          vpsrad zmm27, zmmword ptr [rdx - 8192], 123

// CHECK: vpsrad zmm27, zmmword ptr [rdx - 8256], 123
// CHECK:  encoding: [0x62,0xf1,0x25,0x40,0x72,0xa2,0xc0,0xdf,0xff,0xff,0x7b]
          vpsrad zmm27, zmmword ptr [rdx - 8256], 123

// CHECK: vpsrad zmm27, dword ptr [rdx + 508]{1to16}, 123
// CHECK:  encoding: [0x62,0xf1,0x25,0x50,0x72,0x62,0x7f,0x7b]
          vpsrad zmm27, dword ptr [rdx + 508]{1to16}, 123

// CHECK: vpsrad zmm27, dword ptr [rdx + 512]{1to16}, 123
// CHECK:  encoding: [0x62,0xf1,0x25,0x50,0x72,0xa2,0x00,0x02,0x00,0x00,0x7b]
          vpsrad zmm27, dword ptr [rdx + 512]{1to16}, 123

// CHECK: vpsrad zmm27, dword ptr [rdx - 512]{1to16}, 123
// CHECK:  encoding: [0x62,0xf1,0x25,0x50,0x72,0x62,0x80,0x7b]
          vpsrad zmm27, dword ptr [rdx - 512]{1to16}, 123

// CHECK: vpsrad zmm27, dword ptr [rdx - 516]{1to16}, 123
// CHECK:  encoding: [0x62,0xf1,0x25,0x50,0x72,0xa2,0xfc,0xfd,0xff,0xff,0x7b]
          vpsrad zmm27, dword ptr [rdx - 516]{1to16}, 123

// CHECK: vpsraq zmm29, zmm5, 171
// CHECK:  encoding: [0x62,0xf1,0x95,0x40,0x72,0xe5,0xab]
          vpsraq zmm29, zmm5, 171

// CHECK: vpsraq zmm29 {k4}, zmm5, 171
// CHECK:  encoding: [0x62,0xf1,0x95,0x44,0x72,0xe5,0xab]
          vpsraq zmm29 {k4}, zmm5, 171

// CHECK: vpsraq zmm29 {k4} {z}, zmm5, 171
// CHECK:  encoding: [0x62,0xf1,0x95,0xc4,0x72,0xe5,0xab]
          vpsraq zmm29 {k4} {z}, zmm5, 171

// CHECK: vpsraq zmm29, zmm5, 123
// CHECK:  encoding: [0x62,0xf1,0x95,0x40,0x72,0xe5,0x7b]
          vpsraq zmm29, zmm5, 123

// CHECK: vpsraq zmm29, zmmword ptr [rcx], 123
// CHECK:  encoding: [0x62,0xf1,0x95,0x40,0x72,0x21,0x7b]
          vpsraq zmm29, zmmword ptr [rcx], 123

// CHECK: vpsraq zmm29, zmmword ptr [rax + 8*r14 + 291], 123
// CHECK:  encoding: [0x62,0xb1,0x95,0x40,0x72,0xa4,0xf0,0x23,0x01,0x00,0x00,0x7b]
          vpsraq zmm29, zmmword ptr [rax + 8*r14 + 291], 123

// CHECK: vpsraq zmm29, qword ptr [rcx]{1to8}, 123
// CHECK:  encoding: [0x62,0xf1,0x95,0x50,0x72,0x21,0x7b]
          vpsraq zmm29, qword ptr [rcx]{1to8}, 123

// CHECK: vpsraq zmm29, zmmword ptr [rdx + 8128], 123
// CHECK:  encoding: [0x62,0xf1,0x95,0x40,0x72,0x62,0x7f,0x7b]
          vpsraq zmm29, zmmword ptr [rdx + 8128], 123

// CHECK: vpsraq zmm29, zmmword ptr [rdx + 8192], 123
// CHECK:  encoding: [0x62,0xf1,0x95,0x40,0x72,0xa2,0x00,0x20,0x00,0x00,0x7b]
          vpsraq zmm29, zmmword ptr [rdx + 8192], 123

// CHECK: vpsraq zmm29, zmmword ptr [rdx - 8192], 123
// CHECK:  encoding: [0x62,0xf1,0x95,0x40,0x72,0x62,0x80,0x7b]
          vpsraq zmm29, zmmword ptr [rdx - 8192], 123

// CHECK: vpsraq zmm29, zmmword ptr [rdx - 8256], 123
// CHECK:  encoding: [0x62,0xf1,0x95,0x40,0x72,0xa2,0xc0,0xdf,0xff,0xff,0x7b]
          vpsraq zmm29, zmmword ptr [rdx - 8256], 123

// CHECK: vpsraq zmm29, qword ptr [rdx + 1016]{1to8}, 123
// CHECK:  encoding: [0x62,0xf1,0x95,0x50,0x72,0x62,0x7f,0x7b]
          vpsraq zmm29, qword ptr [rdx + 1016]{1to8}, 123

// CHECK: vpsraq zmm29, qword ptr [rdx + 1024]{1to8}, 123
// CHECK:  encoding: [0x62,0xf1,0x95,0x50,0x72,0xa2,0x00,0x04,0x00,0x00,0x7b]
          vpsraq zmm29, qword ptr [rdx + 1024]{1to8}, 123

// CHECK: vpsraq zmm29, qword ptr [rdx - 1024]{1to8}, 123
// CHECK:  encoding: [0x62,0xf1,0x95,0x50,0x72,0x62,0x80,0x7b]
          vpsraq zmm29, qword ptr [rdx - 1024]{1to8}, 123

// CHECK: vpsraq zmm29, qword ptr [rdx - 1032]{1to8}, 123
// CHECK:  encoding: [0x62,0xf1,0x95,0x50,0x72,0xa2,0xf8,0xfb,0xff,0xff,0x7b]
          vpsraq zmm29, qword ptr [rdx - 1032]{1to8}, 123

// CHECK: vprolvd zmm6, zmm29, zmm16
// CHECK:  encoding: [0x62,0xb2,0x15,0x40,0x15,0xf0]
          vprolvd zmm6, zmm29, zmm16

// CHECK: vprolvd zmm6 {k2}, zmm29, zmm16
// CHECK:  encoding: [0x62,0xb2,0x15,0x42,0x15,0xf0]
          vprolvd zmm6 {k2}, zmm29, zmm16

// CHECK: vprolvd zmm6 {k2} {z}, zmm29, zmm16
// CHECK:  encoding: [0x62,0xb2,0x15,0xc2,0x15,0xf0]
          vprolvd zmm6 {k2} {z}, zmm29, zmm16

// CHECK: vprolvd zmm6, zmm29, zmmword ptr [rcx]
// CHECK:  encoding: [0x62,0xf2,0x15,0x40,0x15,0x31]
          vprolvd zmm6, zmm29, zmmword ptr [rcx]

// CHECK: vprolvd zmm6, zmm29, zmmword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0xb2,0x15,0x40,0x15,0xb4,0xf0,0x23,0x01,0x00,0x00]
          vprolvd zmm6, zmm29, zmmword ptr [rax + 8*r14 + 291]

// CHECK: vprolvd zmm6, zmm29, dword ptr [rcx]{1to16}
// CHECK:  encoding: [0x62,0xf2,0x15,0x50,0x15,0x31]
          vprolvd zmm6, zmm29, dword ptr [rcx]{1to16}

// CHECK: vprolvd zmm6, zmm29, zmmword ptr [rdx + 8128]
// CHECK:  encoding: [0x62,0xf2,0x15,0x40,0x15,0x72,0x7f]
          vprolvd zmm6, zmm29, zmmword ptr [rdx + 8128]

// CHECK: vprolvd zmm6, zmm29, zmmword ptr [rdx + 8192]
// CHECK:  encoding: [0x62,0xf2,0x15,0x40,0x15,0xb2,0x00,0x20,0x00,0x00]
          vprolvd zmm6, zmm29, zmmword ptr [rdx + 8192]

// CHECK: vprolvd zmm6, zmm29, zmmword ptr [rdx - 8192]
// CHECK:  encoding: [0x62,0xf2,0x15,0x40,0x15,0x72,0x80]
          vprolvd zmm6, zmm29, zmmword ptr [rdx - 8192]

// CHECK: vprolvd zmm6, zmm29, zmmword ptr [rdx - 8256]
// CHECK:  encoding: [0x62,0xf2,0x15,0x40,0x15,0xb2,0xc0,0xdf,0xff,0xff]
          vprolvd zmm6, zmm29, zmmword ptr [rdx - 8256]

// CHECK: vprolvd zmm6, zmm29, dword ptr [rdx + 508]{1to16}
// CHECK:  encoding: [0x62,0xf2,0x15,0x50,0x15,0x72,0x7f]
          vprolvd zmm6, zmm29, dword ptr [rdx + 508]{1to16}

// CHECK: vprolvd zmm6, zmm29, dword ptr [rdx + 512]{1to16}
// CHECK:  encoding: [0x62,0xf2,0x15,0x50,0x15,0xb2,0x00,0x02,0x00,0x00]
          vprolvd zmm6, zmm29, dword ptr [rdx + 512]{1to16}

// CHECK: vprolvd zmm6, zmm29, dword ptr [rdx - 512]{1to16}
// CHECK:  encoding: [0x62,0xf2,0x15,0x50,0x15,0x72,0x80]
          vprolvd zmm6, zmm29, dword ptr [rdx - 512]{1to16}

// CHECK: vprolvd zmm6, zmm29, dword ptr [rdx - 516]{1to16}
// CHECK:  encoding: [0x62,0xf2,0x15,0x50,0x15,0xb2,0xfc,0xfd,0xff,0xff]
          vprolvd zmm6, zmm29, dword ptr [rdx - 516]{1to16}

// CHECK: vprold zmm10, zmm5, 171
// CHECK:  encoding: [0x62,0xf1,0x2d,0x48,0x72,0xcd,0xab]
          vprold zmm10, zmm5, 171

// CHECK: vprold zmm10 {k7}, zmm5, 171
// CHECK:  encoding: [0x62,0xf1,0x2d,0x4f,0x72,0xcd,0xab]
          vprold zmm10 {k7}, zmm5, 171

// CHECK: vprold zmm10 {k7} {z}, zmm5, 171
// CHECK:  encoding: [0x62,0xf1,0x2d,0xcf,0x72,0xcd,0xab]
          vprold zmm10 {k7} {z}, zmm5, 171

// CHECK: vprold zmm10, zmm5, 123
// CHECK:  encoding: [0x62,0xf1,0x2d,0x48,0x72,0xcd,0x7b]
          vprold zmm10, zmm5, 123

// CHECK: vprold zmm10, zmmword ptr [rcx], 123
// CHECK:  encoding: [0x62,0xf1,0x2d,0x48,0x72,0x09,0x7b]
          vprold zmm10, zmmword ptr [rcx], 123

// CHECK: vprold zmm10, zmmword ptr [rax + 8*r14 + 291], 123
// CHECK:  encoding: [0x62,0xb1,0x2d,0x48,0x72,0x8c,0xf0,0x23,0x01,0x00,0x00,0x7b]
          vprold zmm10, zmmword ptr [rax + 8*r14 + 291], 123

// CHECK: vprold zmm10, dword ptr [rcx]{1to16}, 123
// CHECK:  encoding: [0x62,0xf1,0x2d,0x58,0x72,0x09,0x7b]
          vprold zmm10, dword ptr [rcx]{1to16}, 123

// CHECK: vprold zmm10, zmmword ptr [rdx + 8128], 123
// CHECK:  encoding: [0x62,0xf1,0x2d,0x48,0x72,0x4a,0x7f,0x7b]
          vprold zmm10, zmmword ptr [rdx + 8128], 123

// CHECK: vprold zmm10, zmmword ptr [rdx + 8192], 123
// CHECK:  encoding: [0x62,0xf1,0x2d,0x48,0x72,0x8a,0x00,0x20,0x00,0x00,0x7b]
          vprold zmm10, zmmword ptr [rdx + 8192], 123

// CHECK: vprold zmm10, zmmword ptr [rdx - 8192], 123
// CHECK:  encoding: [0x62,0xf1,0x2d,0x48,0x72,0x4a,0x80,0x7b]
          vprold zmm10, zmmword ptr [rdx - 8192], 123

// CHECK: vprold zmm10, zmmword ptr [rdx - 8256], 123
// CHECK:  encoding: [0x62,0xf1,0x2d,0x48,0x72,0x8a,0xc0,0xdf,0xff,0xff,0x7b]
          vprold zmm10, zmmword ptr [rdx - 8256], 123

// CHECK: vprold zmm10, dword ptr [rdx + 508]{1to16}, 123
// CHECK:  encoding: [0x62,0xf1,0x2d,0x58,0x72,0x4a,0x7f,0x7b]
          vprold zmm10, dword ptr [rdx + 508]{1to16}, 123

// CHECK: vprold zmm10, dword ptr [rdx + 512]{1to16}, 123
// CHECK:  encoding: [0x62,0xf1,0x2d,0x58,0x72,0x8a,0x00,0x02,0x00,0x00,0x7b]
          vprold zmm10, dword ptr [rdx + 512]{1to16}, 123

// CHECK: vprold zmm10, dword ptr [rdx - 512]{1to16}, 123
// CHECK:  encoding: [0x62,0xf1,0x2d,0x58,0x72,0x4a,0x80,0x7b]
          vprold zmm10, dword ptr [rdx - 512]{1to16}, 123

// CHECK: vprold zmm10, dword ptr [rdx - 516]{1to16}, 123
// CHECK:  encoding: [0x62,0xf1,0x2d,0x58,0x72,0x8a,0xfc,0xfd,0xff,0xff,0x7b]
          vprold zmm10, dword ptr [rdx - 516]{1to16}, 123

// CHECK: vprolvq zmm27, zmm4, zmm6
// CHECK:  encoding: [0x62,0x62,0xdd,0x48,0x15,0xde]
          vprolvq zmm27, zmm4, zmm6

// CHECK: vprolvq zmm27 {k5}, zmm4, zmm6
// CHECK:  encoding: [0x62,0x62,0xdd,0x4d,0x15,0xde]
          vprolvq zmm27 {k5}, zmm4, zmm6

// CHECK: vprolvq zmm27 {k5} {z}, zmm4, zmm6
// CHECK:  encoding: [0x62,0x62,0xdd,0xcd,0x15,0xde]
          vprolvq zmm27 {k5} {z}, zmm4, zmm6

// CHECK: vprolvq zmm27, zmm4, zmmword ptr [rcx]
// CHECK:  encoding: [0x62,0x62,0xdd,0x48,0x15,0x19]
          vprolvq zmm27, zmm4, zmmword ptr [rcx]

// CHECK: vprolvq zmm27, zmm4, zmmword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0x22,0xdd,0x48,0x15,0x9c,0xf0,0x23,0x01,0x00,0x00]
          vprolvq zmm27, zmm4, zmmword ptr [rax + 8*r14 + 291]

// CHECK: vprolvq zmm27, zmm4, qword ptr [rcx]{1to8}
// CHECK:  encoding: [0x62,0x62,0xdd,0x58,0x15,0x19]
          vprolvq zmm27, zmm4, qword ptr [rcx]{1to8}

// CHECK: vprolvq zmm27, zmm4, zmmword ptr [rdx + 8128]
// CHECK:  encoding: [0x62,0x62,0xdd,0x48,0x15,0x5a,0x7f]
          vprolvq zmm27, zmm4, zmmword ptr [rdx + 8128]

// CHECK: vprolvq zmm27, zmm4, zmmword ptr [rdx + 8192]
// CHECK:  encoding: [0x62,0x62,0xdd,0x48,0x15,0x9a,0x00,0x20,0x00,0x00]
          vprolvq zmm27, zmm4, zmmword ptr [rdx + 8192]

// CHECK: vprolvq zmm27, zmm4, zmmword ptr [rdx - 8192]
// CHECK:  encoding: [0x62,0x62,0xdd,0x48,0x15,0x5a,0x80]
          vprolvq zmm27, zmm4, zmmword ptr [rdx - 8192]

// CHECK: vprolvq zmm27, zmm4, zmmword ptr [rdx - 8256]
// CHECK:  encoding: [0x62,0x62,0xdd,0x48,0x15,0x9a,0xc0,0xdf,0xff,0xff]
          vprolvq zmm27, zmm4, zmmword ptr [rdx - 8256]

// CHECK: vprolvq zmm27, zmm4, qword ptr [rdx + 1016]{1to8}
// CHECK:  encoding: [0x62,0x62,0xdd,0x58,0x15,0x5a,0x7f]
          vprolvq zmm27, zmm4, qword ptr [rdx + 1016]{1to8}

// CHECK: vprolvq zmm27, zmm4, qword ptr [rdx + 1024]{1to8}
// CHECK:  encoding: [0x62,0x62,0xdd,0x58,0x15,0x9a,0x00,0x04,0x00,0x00]
          vprolvq zmm27, zmm4, qword ptr [rdx + 1024]{1to8}

// CHECK: vprolvq zmm27, zmm4, qword ptr [rdx - 1024]{1to8}
// CHECK:  encoding: [0x62,0x62,0xdd,0x58,0x15,0x5a,0x80]
          vprolvq zmm27, zmm4, qword ptr [rdx - 1024]{1to8}

// CHECK: vprolvq zmm27, zmm4, qword ptr [rdx - 1032]{1to8}
// CHECK:  encoding: [0x62,0x62,0xdd,0x58,0x15,0x9a,0xf8,0xfb,0xff,0xff]
          vprolvq zmm27, zmm4, qword ptr [rdx - 1032]{1to8}

// CHECK: vprolq zmm19, zmm18, 171
// CHECK:  encoding: [0x62,0xb1,0xe5,0x40,0x72,0xca,0xab]
          vprolq zmm19, zmm18, 171

// CHECK: vprolq zmm19 {k3}, zmm18, 171
// CHECK:  encoding: [0x62,0xb1,0xe5,0x43,0x72,0xca,0xab]
          vprolq zmm19 {k3}, zmm18, 171

// CHECK: vprolq zmm19 {k3} {z}, zmm18, 171
// CHECK:  encoding: [0x62,0xb1,0xe5,0xc3,0x72,0xca,0xab]
          vprolq zmm19 {k3} {z}, zmm18, 171

// CHECK: vprolq zmm19, zmm18, 123
// CHECK:  encoding: [0x62,0xb1,0xe5,0x40,0x72,0xca,0x7b]
          vprolq zmm19, zmm18, 123

// CHECK: vprolq zmm19, zmmword ptr [rcx], 123
// CHECK:  encoding: [0x62,0xf1,0xe5,0x40,0x72,0x09,0x7b]
          vprolq zmm19, zmmword ptr [rcx], 123

// CHECK: vprolq zmm19, zmmword ptr [rax + 8*r14 + 291], 123
// CHECK:  encoding: [0x62,0xb1,0xe5,0x40,0x72,0x8c,0xf0,0x23,0x01,0x00,0x00,0x7b]
          vprolq zmm19, zmmword ptr [rax + 8*r14 + 291], 123

// CHECK: vprolq zmm19, qword ptr [rcx]{1to8}, 123
// CHECK:  encoding: [0x62,0xf1,0xe5,0x50,0x72,0x09,0x7b]
          vprolq zmm19, qword ptr [rcx]{1to8}, 123

// CHECK: vprolq zmm19, zmmword ptr [rdx + 8128], 123
// CHECK:  encoding: [0x62,0xf1,0xe5,0x40,0x72,0x4a,0x7f,0x7b]
          vprolq zmm19, zmmword ptr [rdx + 8128], 123

// CHECK: vprolq zmm19, zmmword ptr [rdx + 8192], 123
// CHECK:  encoding: [0x62,0xf1,0xe5,0x40,0x72,0x8a,0x00,0x20,0x00,0x00,0x7b]
          vprolq zmm19, zmmword ptr [rdx + 8192], 123

// CHECK: vprolq zmm19, zmmword ptr [rdx - 8192], 123
// CHECK:  encoding: [0x62,0xf1,0xe5,0x40,0x72,0x4a,0x80,0x7b]
          vprolq zmm19, zmmword ptr [rdx - 8192], 123

// CHECK: vprolq zmm19, zmmword ptr [rdx - 8256], 123
// CHECK:  encoding: [0x62,0xf1,0xe5,0x40,0x72,0x8a,0xc0,0xdf,0xff,0xff,0x7b]
          vprolq zmm19, zmmword ptr [rdx - 8256], 123

// CHECK: vprolq zmm19, qword ptr [rdx + 1016]{1to8}, 123
// CHECK:  encoding: [0x62,0xf1,0xe5,0x50,0x72,0x4a,0x7f,0x7b]
          vprolq zmm19, qword ptr [rdx + 1016]{1to8}, 123

// CHECK: vprolq zmm19, qword ptr [rdx + 1024]{1to8}, 123
// CHECK:  encoding: [0x62,0xf1,0xe5,0x50,0x72,0x8a,0x00,0x04,0x00,0x00,0x7b]
          vprolq zmm19, qword ptr [rdx + 1024]{1to8}, 123

// CHECK: vprolq zmm19, qword ptr [rdx - 1024]{1to8}, 123
// CHECK:  encoding: [0x62,0xf1,0xe5,0x50,0x72,0x4a,0x80,0x7b]
          vprolq zmm19, qword ptr [rdx - 1024]{1to8}, 123

// CHECK: vprolq zmm19, qword ptr [rdx - 1032]{1to8}, 123
// CHECK:  encoding: [0x62,0xf1,0xe5,0x50,0x72,0x8a,0xf8,0xfb,0xff,0xff,0x7b]
          vprolq zmm19, qword ptr [rdx - 1032]{1to8}, 123

// CHECK: vprorvd zmm11, zmm20, zmm28
// CHECK:  encoding: [0x62,0x12,0x5d,0x40,0x14,0xdc]
          vprorvd zmm11, zmm20, zmm28

// CHECK: vprorvd zmm11 {k2}, zmm20, zmm28
// CHECK:  encoding: [0x62,0x12,0x5d,0x42,0x14,0xdc]
          vprorvd zmm11 {k2}, zmm20, zmm28

// CHECK: vprorvd zmm11 {k2} {z}, zmm20, zmm28
// CHECK:  encoding: [0x62,0x12,0x5d,0xc2,0x14,0xdc]
          vprorvd zmm11 {k2} {z}, zmm20, zmm28

// CHECK: vprorvd zmm11, zmm20, zmmword ptr [rcx]
// CHECK:  encoding: [0x62,0x72,0x5d,0x40,0x14,0x19]
          vprorvd zmm11, zmm20, zmmword ptr [rcx]

// CHECK: vprorvd zmm11, zmm20, zmmword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0x32,0x5d,0x40,0x14,0x9c,0xf0,0x23,0x01,0x00,0x00]
          vprorvd zmm11, zmm20, zmmword ptr [rax + 8*r14 + 291]

// CHECK: vprorvd zmm11, zmm20, dword ptr [rcx]{1to16}
// CHECK:  encoding: [0x62,0x72,0x5d,0x50,0x14,0x19]
          vprorvd zmm11, zmm20, dword ptr [rcx]{1to16}

// CHECK: vprorvd zmm11, zmm20, zmmword ptr [rdx + 8128]
// CHECK:  encoding: [0x62,0x72,0x5d,0x40,0x14,0x5a,0x7f]
          vprorvd zmm11, zmm20, zmmword ptr [rdx + 8128]

// CHECK: vprorvd zmm11, zmm20, zmmword ptr [rdx + 8192]
// CHECK:  encoding: [0x62,0x72,0x5d,0x40,0x14,0x9a,0x00,0x20,0x00,0x00]
          vprorvd zmm11, zmm20, zmmword ptr [rdx + 8192]

// CHECK: vprorvd zmm11, zmm20, zmmword ptr [rdx - 8192]
// CHECK:  encoding: [0x62,0x72,0x5d,0x40,0x14,0x5a,0x80]
          vprorvd zmm11, zmm20, zmmword ptr [rdx - 8192]

// CHECK: vprorvd zmm11, zmm20, zmmword ptr [rdx - 8256]
// CHECK:  encoding: [0x62,0x72,0x5d,0x40,0x14,0x9a,0xc0,0xdf,0xff,0xff]
          vprorvd zmm11, zmm20, zmmword ptr [rdx - 8256]

// CHECK: vprorvd zmm11, zmm20, dword ptr [rdx + 508]{1to16}
// CHECK:  encoding: [0x62,0x72,0x5d,0x50,0x14,0x5a,0x7f]
          vprorvd zmm11, zmm20, dword ptr [rdx + 508]{1to16}

// CHECK: vprorvd zmm11, zmm20, dword ptr [rdx + 512]{1to16}
// CHECK:  encoding: [0x62,0x72,0x5d,0x50,0x14,0x9a,0x00,0x02,0x00,0x00]
          vprorvd zmm11, zmm20, dword ptr [rdx + 512]{1to16}

// CHECK: vprorvd zmm11, zmm20, dword ptr [rdx - 512]{1to16}
// CHECK:  encoding: [0x62,0x72,0x5d,0x50,0x14,0x5a,0x80]
          vprorvd zmm11, zmm20, dword ptr [rdx - 512]{1to16}

// CHECK: vprorvd zmm11, zmm20, dword ptr [rdx - 516]{1to16}
// CHECK:  encoding: [0x62,0x72,0x5d,0x50,0x14,0x9a,0xfc,0xfd,0xff,0xff]
          vprorvd zmm11, zmm20, dword ptr [rdx - 516]{1to16}

// CHECK: vprord zmm9, zmm10, 171
// CHECK:  encoding: [0x62,0xd1,0x35,0x48,0x72,0xc2,0xab]
          vprord zmm9, zmm10, 171

// CHECK: vprord zmm9 {k7}, zmm10, 171
// CHECK:  encoding: [0x62,0xd1,0x35,0x4f,0x72,0xc2,0xab]
          vprord zmm9 {k7}, zmm10, 171

// CHECK: vprord zmm9 {k7} {z}, zmm10, 171
// CHECK:  encoding: [0x62,0xd1,0x35,0xcf,0x72,0xc2,0xab]
          vprord zmm9 {k7} {z}, zmm10, 171

// CHECK: vprord zmm9, zmm10, 123
// CHECK:  encoding: [0x62,0xd1,0x35,0x48,0x72,0xc2,0x7b]
          vprord zmm9, zmm10, 123

// CHECK: vprord zmm9, zmmword ptr [rcx], 123
// CHECK:  encoding: [0x62,0xf1,0x35,0x48,0x72,0x01,0x7b]
          vprord zmm9, zmmword ptr [rcx], 123

// CHECK: vprord zmm9, zmmword ptr [rax + 8*r14 + 291], 123
// CHECK:  encoding: [0x62,0xb1,0x35,0x48,0x72,0x84,0xf0,0x23,0x01,0x00,0x00,0x7b]
          vprord zmm9, zmmword ptr [rax + 8*r14 + 291], 123

// CHECK: vprord zmm9, dword ptr [rcx]{1to16}, 123
// CHECK:  encoding: [0x62,0xf1,0x35,0x58,0x72,0x01,0x7b]
          vprord zmm9, dword ptr [rcx]{1to16}, 123

// CHECK: vprord zmm9, zmmword ptr [rdx + 8128], 123
// CHECK:  encoding: [0x62,0xf1,0x35,0x48,0x72,0x42,0x7f,0x7b]
          vprord zmm9, zmmword ptr [rdx + 8128], 123

// CHECK: vprord zmm9, zmmword ptr [rdx + 8192], 123
// CHECK:  encoding: [0x62,0xf1,0x35,0x48,0x72,0x82,0x00,0x20,0x00,0x00,0x7b]
          vprord zmm9, zmmword ptr [rdx + 8192], 123

// CHECK: vprord zmm9, zmmword ptr [rdx - 8192], 123
// CHECK:  encoding: [0x62,0xf1,0x35,0x48,0x72,0x42,0x80,0x7b]
          vprord zmm9, zmmword ptr [rdx - 8192], 123

// CHECK: vprord zmm9, zmmword ptr [rdx - 8256], 123
// CHECK:  encoding: [0x62,0xf1,0x35,0x48,0x72,0x82,0xc0,0xdf,0xff,0xff,0x7b]
          vprord zmm9, zmmword ptr [rdx - 8256], 123

// CHECK: vprord zmm9, dword ptr [rdx + 508]{1to16}, 123
// CHECK:  encoding: [0x62,0xf1,0x35,0x58,0x72,0x42,0x7f,0x7b]
          vprord zmm9, dword ptr [rdx + 508]{1to16}, 123

// CHECK: vprord zmm9, dword ptr [rdx + 512]{1to16}, 123
// CHECK:  encoding: [0x62,0xf1,0x35,0x58,0x72,0x82,0x00,0x02,0x00,0x00,0x7b]
          vprord zmm9, dword ptr [rdx + 512]{1to16}, 123

// CHECK: vprord zmm9, dword ptr [rdx - 512]{1to16}, 123
// CHECK:  encoding: [0x62,0xf1,0x35,0x58,0x72,0x42,0x80,0x7b]
          vprord zmm9, dword ptr [rdx - 512]{1to16}, 123

// CHECK: vprord zmm9, dword ptr [rdx - 516]{1to16}, 123
// CHECK:  encoding: [0x62,0xf1,0x35,0x58,0x72,0x82,0xfc,0xfd,0xff,0xff,0x7b]
          vprord zmm9, dword ptr [rdx - 516]{1to16}, 123

// CHECK: vprorvq zmm14, zmm24, zmm1
// CHECK:  encoding: [0x62,0x72,0xbd,0x40,0x14,0xf1]
          vprorvq zmm14, zmm24, zmm1

// CHECK: vprorvq zmm14 {k7}, zmm24, zmm1
// CHECK:  encoding: [0x62,0x72,0xbd,0x47,0x14,0xf1]
          vprorvq zmm14 {k7}, zmm24, zmm1

// CHECK: vprorvq zmm14 {k7} {z}, zmm24, zmm1
// CHECK:  encoding: [0x62,0x72,0xbd,0xc7,0x14,0xf1]
          vprorvq zmm14 {k7} {z}, zmm24, zmm1

// CHECK: vprorvq zmm14, zmm24, zmmword ptr [rcx]
// CHECK:  encoding: [0x62,0x72,0xbd,0x40,0x14,0x31]
          vprorvq zmm14, zmm24, zmmword ptr [rcx]

// CHECK: vprorvq zmm14, zmm24, zmmword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0x32,0xbd,0x40,0x14,0xb4,0xf0,0x23,0x01,0x00,0x00]
          vprorvq zmm14, zmm24, zmmword ptr [rax + 8*r14 + 291]

// CHECK: vprorvq zmm14, zmm24, qword ptr [rcx]{1to8}
// CHECK:  encoding: [0x62,0x72,0xbd,0x50,0x14,0x31]
          vprorvq zmm14, zmm24, qword ptr [rcx]{1to8}

// CHECK: vprorvq zmm14, zmm24, zmmword ptr [rdx + 8128]
// CHECK:  encoding: [0x62,0x72,0xbd,0x40,0x14,0x72,0x7f]
          vprorvq zmm14, zmm24, zmmword ptr [rdx + 8128]

// CHECK: vprorvq zmm14, zmm24, zmmword ptr [rdx + 8192]
// CHECK:  encoding: [0x62,0x72,0xbd,0x40,0x14,0xb2,0x00,0x20,0x00,0x00]
          vprorvq zmm14, zmm24, zmmword ptr [rdx + 8192]

// CHECK: vprorvq zmm14, zmm24, zmmword ptr [rdx - 8192]
// CHECK:  encoding: [0x62,0x72,0xbd,0x40,0x14,0x72,0x80]
          vprorvq zmm14, zmm24, zmmword ptr [rdx - 8192]

// CHECK: vprorvq zmm14, zmm24, zmmword ptr [rdx - 8256]
// CHECK:  encoding: [0x62,0x72,0xbd,0x40,0x14,0xb2,0xc0,0xdf,0xff,0xff]
          vprorvq zmm14, zmm24, zmmword ptr [rdx - 8256]

// CHECK: vprorvq zmm14, zmm24, qword ptr [rdx + 1016]{1to8}
// CHECK:  encoding: [0x62,0x72,0xbd,0x50,0x14,0x72,0x7f]
          vprorvq zmm14, zmm24, qword ptr [rdx + 1016]{1to8}

// CHECK: vprorvq zmm14, zmm24, qword ptr [rdx + 1024]{1to8}
// CHECK:  encoding: [0x62,0x72,0xbd,0x50,0x14,0xb2,0x00,0x04,0x00,0x00]
          vprorvq zmm14, zmm24, qword ptr [rdx + 1024]{1to8}

// CHECK: vprorvq zmm14, zmm24, qword ptr [rdx - 1024]{1to8}
// CHECK:  encoding: [0x62,0x72,0xbd,0x50,0x14,0x72,0x80]
          vprorvq zmm14, zmm24, qword ptr [rdx - 1024]{1to8}

// CHECK: vprorvq zmm14, zmm24, qword ptr [rdx - 1032]{1to8}
// CHECK:  encoding: [0x62,0x72,0xbd,0x50,0x14,0xb2,0xf8,0xfb,0xff,0xff]
          vprorvq zmm14, zmm24, qword ptr [rdx - 1032]{1to8}

// CHECK: vprorq zmm21, zmm25, 171
// CHECK:  encoding: [0x62,0x91,0xd5,0x40,0x72,0xc1,0xab]
          vprorq zmm21, zmm25, 171

// CHECK: vprorq zmm21 {k6}, zmm25, 171
// CHECK:  encoding: [0x62,0x91,0xd5,0x46,0x72,0xc1,0xab]
          vprorq zmm21 {k6}, zmm25, 171

// CHECK: vprorq zmm21 {k6} {z}, zmm25, 171
// CHECK:  encoding: [0x62,0x91,0xd5,0xc6,0x72,0xc1,0xab]
          vprorq zmm21 {k6} {z}, zmm25, 171

// CHECK: vprorq zmm21, zmm25, 123
// CHECK:  encoding: [0x62,0x91,0xd5,0x40,0x72,0xc1,0x7b]
          vprorq zmm21, zmm25, 123

// CHECK: vprorq zmm21, zmmword ptr [rcx], 123
// CHECK:  encoding: [0x62,0xf1,0xd5,0x40,0x72,0x01,0x7b]
          vprorq zmm21, zmmword ptr [rcx], 123

// CHECK: vprorq zmm21, zmmword ptr [rax + 8*r14 + 291], 123
// CHECK:  encoding: [0x62,0xb1,0xd5,0x40,0x72,0x84,0xf0,0x23,0x01,0x00,0x00,0x7b]
          vprorq zmm21, zmmword ptr [rax + 8*r14 + 291], 123

// CHECK: vprorq zmm21, qword ptr [rcx]{1to8}, 123
// CHECK:  encoding: [0x62,0xf1,0xd5,0x50,0x72,0x01,0x7b]
          vprorq zmm21, qword ptr [rcx]{1to8}, 123

// CHECK: vprorq zmm21, zmmword ptr [rdx + 8128], 123
// CHECK:  encoding: [0x62,0xf1,0xd5,0x40,0x72,0x42,0x7f,0x7b]
          vprorq zmm21, zmmword ptr [rdx + 8128], 123

// CHECK: vprorq zmm21, zmmword ptr [rdx + 8192], 123
// CHECK:  encoding: [0x62,0xf1,0xd5,0x40,0x72,0x82,0x00,0x20,0x00,0x00,0x7b]
          vprorq zmm21, zmmword ptr [rdx + 8192], 123

// CHECK: vprorq zmm21, zmmword ptr [rdx - 8192], 123
// CHECK:  encoding: [0x62,0xf1,0xd5,0x40,0x72,0x42,0x80,0x7b]
          vprorq zmm21, zmmword ptr [rdx - 8192], 123

// CHECK: vprorq zmm21, zmmword ptr [rdx - 8256], 123
// CHECK:  encoding: [0x62,0xf1,0xd5,0x40,0x72,0x82,0xc0,0xdf,0xff,0xff,0x7b]
          vprorq zmm21, zmmword ptr [rdx - 8256], 123

// CHECK: vprorq zmm21, qword ptr [rdx + 1016]{1to8}, 123
// CHECK:  encoding: [0x62,0xf1,0xd5,0x50,0x72,0x42,0x7f,0x7b]
          vprorq zmm21, qword ptr [rdx + 1016]{1to8}, 123

// CHECK: vprorq zmm21, qword ptr [rdx + 1024]{1to8}, 123
// CHECK:  encoding: [0x62,0xf1,0xd5,0x50,0x72,0x82,0x00,0x04,0x00,0x00,0x7b]
          vprorq zmm21, qword ptr [rdx + 1024]{1to8}, 123

// CHECK: vprorq zmm21, qword ptr [rdx - 1024]{1to8}, 123
// CHECK:  encoding: [0x62,0xf1,0xd5,0x50,0x72,0x42,0x80,0x7b]
          vprorq zmm21, qword ptr [rdx - 1024]{1to8}, 123

// CHECK: vprorq zmm21, qword ptr [rdx - 1032]{1to8}, 123
// CHECK:  encoding: [0x62,0xf1,0xd5,0x50,0x72,0x82,0xf8,0xfb,0xff,0xff,0x7b]
          vprorq zmm21, qword ptr [rdx - 1032]{1to8}, 123

// CHECK: vrndscalepd zmm22, zmm7, 171
// CHECK:  encoding: [0x62,0xe3,0xfd,0x48,0x09,0xf7,0xab]
          vrndscalepd zmm22, zmm7, 171

// CHECK: vrndscalepd zmm22 {k1}, zmm7, 171
// CHECK:  encoding: [0x62,0xe3,0xfd,0x49,0x09,0xf7,0xab]
          vrndscalepd zmm22 {k1}, zmm7, 171

// CHECK: vrndscalepd zmm22 {k1} {z}, zmm7, 171
// CHECK:  encoding: [0x62,0xe3,0xfd,0xc9,0x09,0xf7,0xab]
          vrndscalepd zmm22 {k1} {z}, zmm7, 171

// CHECK: vrndscalepd zmm22, zmm7, {sae}, 171
// CHECK:  encoding: [0x62,0xe3,0xfd,0x18,0x09,0xf7,0xab]
          vrndscalepd zmm22, zmm7, {sae}, 171

// CHECK: vrndscalepd zmm22, zmm7, 123
// CHECK:  encoding: [0x62,0xe3,0xfd,0x48,0x09,0xf7,0x7b]
          vrndscalepd zmm22, zmm7, 123

// CHECK: vrndscalepd zmm22, zmm7, {sae}, 123
// CHECK:  encoding: [0x62,0xe3,0xfd,0x18,0x09,0xf7,0x7b]
          vrndscalepd zmm22, zmm7, {sae}, 123

// CHECK: vrndscalepd zmm22, zmmword ptr [rcx], 123
// CHECK:  encoding: [0x62,0xe3,0xfd,0x48,0x09,0x31,0x7b]
          vrndscalepd zmm22, zmmword ptr [rcx], 123

// CHECK: vrndscalepd zmm22, zmmword ptr [rax + 8*r14 + 291], 123
// CHECK:  encoding: [0x62,0xa3,0xfd,0x48,0x09,0xb4,0xf0,0x23,0x01,0x00,0x00,0x7b]
          vrndscalepd zmm22, zmmword ptr [rax + 8*r14 + 291], 123

// CHECK: vrndscalepd zmm22, qword ptr [rcx]{1to8}, 123
// CHECK:  encoding: [0x62,0xe3,0xfd,0x58,0x09,0x31,0x7b]
          vrndscalepd zmm22, qword ptr [rcx]{1to8}, 123

// CHECK: vrndscalepd zmm22, zmmword ptr [rdx + 8128], 123
// CHECK:  encoding: [0x62,0xe3,0xfd,0x48,0x09,0x72,0x7f,0x7b]
          vrndscalepd zmm22, zmmword ptr [rdx + 8128], 123

// CHECK: vrndscalepd zmm22, zmmword ptr [rdx + 8192], 123
// CHECK:  encoding: [0x62,0xe3,0xfd,0x48,0x09,0xb2,0x00,0x20,0x00,0x00,0x7b]
          vrndscalepd zmm22, zmmword ptr [rdx + 8192], 123

// CHECK: vrndscalepd zmm22, zmmword ptr [rdx - 8192], 123
// CHECK:  encoding: [0x62,0xe3,0xfd,0x48,0x09,0x72,0x80,0x7b]
          vrndscalepd zmm22, zmmword ptr [rdx - 8192], 123

// CHECK: vrndscalepd zmm22, zmmword ptr [rdx - 8256], 123
// CHECK:  encoding: [0x62,0xe3,0xfd,0x48,0x09,0xb2,0xc0,0xdf,0xff,0xff,0x7b]
          vrndscalepd zmm22, zmmword ptr [rdx - 8256], 123

// CHECK: vrndscalepd zmm22, qword ptr [rdx + 1016]{1to8}, 123
// CHECK:  encoding: [0x62,0xe3,0xfd,0x58,0x09,0x72,0x7f,0x7b]
          vrndscalepd zmm22, qword ptr [rdx + 1016]{1to8}, 123

// CHECK: vrndscalepd zmm22, qword ptr [rdx + 1024]{1to8}, 123
// CHECK:  encoding: [0x62,0xe3,0xfd,0x58,0x09,0xb2,0x00,0x04,0x00,0x00,0x7b]
          vrndscalepd zmm22, qword ptr [rdx + 1024]{1to8}, 123

// CHECK: vrndscalepd zmm22, qword ptr [rdx - 1024]{1to8}, 123
// CHECK:  encoding: [0x62,0xe3,0xfd,0x58,0x09,0x72,0x80,0x7b]
          vrndscalepd zmm22, qword ptr [rdx - 1024]{1to8}, 123

// CHECK: vrndscalepd zmm22, qword ptr [rdx - 1032]{1to8}, 123
// CHECK:  encoding: [0x62,0xe3,0xfd,0x58,0x09,0xb2,0xf8,0xfb,0xff,0xff,0x7b]
          vrndscalepd zmm22, qword ptr [rdx - 1032]{1to8}, 123

// CHECK: vrndscaleps zmm13, zmm7, 171
// CHECK:  encoding: [0x62,0x73,0x7d,0x48,0x08,0xef,0xab]
          vrndscaleps zmm13, zmm7, 171

// CHECK: vrndscaleps zmm13 {k1}, zmm7, 171
// CHECK:  encoding: [0x62,0x73,0x7d,0x49,0x08,0xef,0xab]
          vrndscaleps zmm13 {k1}, zmm7, 171

// CHECK: vrndscaleps zmm13 {k1} {z}, zmm7, 171
// CHECK:  encoding: [0x62,0x73,0x7d,0xc9,0x08,0xef,0xab]
          vrndscaleps zmm13 {k1} {z}, zmm7, 171

// CHECK: vrndscaleps zmm13, zmm7, {sae}, 171
// CHECK:  encoding: [0x62,0x73,0x7d,0x18,0x08,0xef,0xab]
          vrndscaleps zmm13, zmm7, {sae}, 171

// CHECK: vrndscaleps zmm13, zmm7, 123
// CHECK:  encoding: [0x62,0x73,0x7d,0x48,0x08,0xef,0x7b]
          vrndscaleps zmm13, zmm7, 123

// CHECK: vrndscaleps zmm13, zmm7, {sae}, 123
// CHECK:  encoding: [0x62,0x73,0x7d,0x18,0x08,0xef,0x7b]
          vrndscaleps zmm13, zmm7, {sae}, 123

// CHECK: vrndscaleps zmm13, zmmword ptr [rcx], 123
// CHECK:  encoding: [0x62,0x73,0x7d,0x48,0x08,0x29,0x7b]
          vrndscaleps zmm13, zmmword ptr [rcx], 123

// CHECK: vrndscaleps zmm13, zmmword ptr [rax + 8*r14 + 291], 123
// CHECK:  encoding: [0x62,0x33,0x7d,0x48,0x08,0xac,0xf0,0x23,0x01,0x00,0x00,0x7b]
          vrndscaleps zmm13, zmmword ptr [rax + 8*r14 + 291], 123

// CHECK: vrndscaleps zmm13, dword ptr [rcx]{1to16}, 123
// CHECK:  encoding: [0x62,0x73,0x7d,0x58,0x08,0x29,0x7b]
          vrndscaleps zmm13, dword ptr [rcx]{1to16}, 123

// CHECK: vrndscaleps zmm13, zmmword ptr [rdx + 8128], 123
// CHECK:  encoding: [0x62,0x73,0x7d,0x48,0x08,0x6a,0x7f,0x7b]
          vrndscaleps zmm13, zmmword ptr [rdx + 8128], 123

// CHECK: vrndscaleps zmm13, zmmword ptr [rdx + 8192], 123
// CHECK:  encoding: [0x62,0x73,0x7d,0x48,0x08,0xaa,0x00,0x20,0x00,0x00,0x7b]
          vrndscaleps zmm13, zmmword ptr [rdx + 8192], 123

// CHECK: vrndscaleps zmm13, zmmword ptr [rdx - 8192], 123
// CHECK:  encoding: [0x62,0x73,0x7d,0x48,0x08,0x6a,0x80,0x7b]
          vrndscaleps zmm13, zmmword ptr [rdx - 8192], 123

// CHECK: vrndscaleps zmm13, zmmword ptr [rdx - 8256], 123
// CHECK:  encoding: [0x62,0x73,0x7d,0x48,0x08,0xaa,0xc0,0xdf,0xff,0xff,0x7b]
          vrndscaleps zmm13, zmmword ptr [rdx - 8256], 123

// CHECK: vrndscaleps zmm13, dword ptr [rdx + 508]{1to16}, 123
// CHECK:  encoding: [0x62,0x73,0x7d,0x58,0x08,0x6a,0x7f,0x7b]
          vrndscaleps zmm13, dword ptr [rdx + 508]{1to16}, 123

// CHECK: vrndscaleps zmm13, dword ptr [rdx + 512]{1to16}, 123
// CHECK:  encoding: [0x62,0x73,0x7d,0x58,0x08,0xaa,0x00,0x02,0x00,0x00,0x7b]
          vrndscaleps zmm13, dword ptr [rdx + 512]{1to16}, 123

// CHECK: vrndscaleps zmm13, dword ptr [rdx - 512]{1to16}, 123
// CHECK:  encoding: [0x62,0x73,0x7d,0x58,0x08,0x6a,0x80,0x7b]
          vrndscaleps zmm13, dword ptr [rdx - 512]{1to16}, 123

// CHECK: vrndscaleps zmm13, dword ptr [rdx - 516]{1to16}, 123
// CHECK:  encoding: [0x62,0x73,0x7d,0x58,0x08,0xaa,0xfc,0xfd,0xff,0xff,0x7b]
          vrndscaleps zmm13, dword ptr [rdx - 516]{1to16}, 123

// CHECK: vrndscalesd xmm25, xmm12, xmm15, 171
// CHECK:  encoding: [0x62,0x43,0x9d,0x08,0x0b,0xcf,0xab]
          vrndscalesd xmm25, xmm12, xmm15, 171

// CHECK: vrndscalesd xmm25 {k6}, xmm12, xmm15, 171
// CHECK:  encoding: [0x62,0x43,0x9d,0x0e,0x0b,0xcf,0xab]
          vrndscalesd xmm25 {k6}, xmm12, xmm15, 171

// CHECK: vrndscalesd xmm25 {k6} {z}, xmm12, xmm15, 171
// CHECK:  encoding: [0x62,0x43,0x9d,0x8e,0x0b,0xcf,0xab]
          vrndscalesd xmm25 {k6} {z}, xmm12, xmm15, 171

// CHECK: vrndscalesd xmm25, xmm12, xmm15, {sae}, 171
// CHECK:  encoding: [0x62,0x43,0x9d,0x18,0x0b,0xcf,0xab]
          vrndscalesd xmm25, xmm12, xmm15, {sae}, 171

// CHECK: vrndscalesd xmm25, xmm12, xmm15, 123
// CHECK:  encoding: [0x62,0x43,0x9d,0x08,0x0b,0xcf,0x7b]
          vrndscalesd xmm25, xmm12, xmm15, 123

// CHECK: vrndscalesd xmm25, xmm12, xmm15, {sae}, 123
// CHECK:  encoding: [0x62,0x43,0x9d,0x18,0x0b,0xcf,0x7b]
          vrndscalesd xmm25, xmm12, xmm15, {sae}, 123

// CHECK: vrndscalesd xmm25, xmm12, qword ptr [rcx], 123
// CHECK:  encoding: [0x62,0x63,0x9d,0x08,0x0b,0x09,0x7b]
          vrndscalesd xmm25, xmm12, qword ptr [rcx], 123

// CHECK: vrndscalesd xmm25, xmm12, qword ptr [rax + 8*r14 + 291], 123
// CHECK:  encoding: [0x62,0x23,0x9d,0x08,0x0b,0x8c,0xf0,0x23,0x01,0x00,0x00,0x7b]
          vrndscalesd xmm25, xmm12, qword ptr [rax + 8*r14 + 291], 123

// CHECK: vrndscalesd xmm25, xmm12, qword ptr [rdx + 1016], 123
// CHECK:  encoding: [0x62,0x63,0x9d,0x08,0x0b,0x4a,0x7f,0x7b]
          vrndscalesd xmm25, xmm12, qword ptr [rdx + 1016], 123

// CHECK: vrndscalesd xmm25, xmm12, qword ptr [rdx + 1024], 123
// CHECK:  encoding: [0x62,0x63,0x9d,0x08,0x0b,0x8a,0x00,0x04,0x00,0x00,0x7b]
          vrndscalesd xmm25, xmm12, qword ptr [rdx + 1024], 123

// CHECK: vrndscalesd xmm25, xmm12, qword ptr [rdx - 1024], 123
// CHECK:  encoding: [0x62,0x63,0x9d,0x08,0x0b,0x4a,0x80,0x7b]
          vrndscalesd xmm25, xmm12, qword ptr [rdx - 1024], 123

// CHECK: vrndscalesd xmm25, xmm12, qword ptr [rdx - 1032], 123
// CHECK:  encoding: [0x62,0x63,0x9d,0x08,0x0b,0x8a,0xf8,0xfb,0xff,0xff,0x7b]
          vrndscalesd xmm25, xmm12, qword ptr [rdx - 1032], 123

// CHECK: vrndscaless xmm11, xmm11, xmm17, 171
// CHECK:  encoding: [0x62,0x33,0x25,0x08,0x0a,0xd9,0xab]
          vrndscaless xmm11, xmm11, xmm17, 171

// CHECK: vrndscaless xmm11 {k3}, xmm11, xmm17, 171
// CHECK:  encoding: [0x62,0x33,0x25,0x0b,0x0a,0xd9,0xab]
          vrndscaless xmm11 {k3}, xmm11, xmm17, 171

// CHECK: vrndscaless xmm11 {k3} {z}, xmm11, xmm17, 171
// CHECK:  encoding: [0x62,0x33,0x25,0x8b,0x0a,0xd9,0xab]
          vrndscaless xmm11 {k3} {z}, xmm11, xmm17, 171

// CHECK: vrndscaless xmm11, xmm11, xmm17, {sae}, 171
// CHECK:  encoding: [0x62,0x33,0x25,0x18,0x0a,0xd9,0xab]
          vrndscaless xmm11, xmm11, xmm17, {sae}, 171

// CHECK: vrndscaless xmm11, xmm11, xmm17, 123
// CHECK:  encoding: [0x62,0x33,0x25,0x08,0x0a,0xd9,0x7b]
          vrndscaless xmm11, xmm11, xmm17, 123

// CHECK: vrndscaless xmm11, xmm11, xmm17, {sae}, 123
// CHECK:  encoding: [0x62,0x33,0x25,0x18,0x0a,0xd9,0x7b]
          vrndscaless xmm11, xmm11, xmm17, {sae}, 123

// CHECK: vrndscaless xmm11, xmm11, dword ptr [rcx], 123
// CHECK:  encoding: [0x62,0x73,0x25,0x08,0x0a,0x19,0x7b]
          vrndscaless xmm11, xmm11, dword ptr [rcx], 123

// CHECK: vrndscaless xmm11, xmm11, dword ptr [rax + 8*r14 + 291], 123
// CHECK:  encoding: [0x62,0x33,0x25,0x08,0x0a,0x9c,0xf0,0x23,0x01,0x00,0x00,0x7b]
          vrndscaless xmm11, xmm11, dword ptr [rax + 8*r14 + 291], 123

// CHECK: vrndscaless xmm11, xmm11, dword ptr [rdx + 508], 123
// CHECK:  encoding: [0x62,0x73,0x25,0x08,0x0a,0x5a,0x7f,0x7b]
          vrndscaless xmm11, xmm11, dword ptr [rdx + 508], 123

// CHECK: vrndscaless xmm11, xmm11, dword ptr [rdx + 512], 123
// CHECK:  encoding: [0x62,0x73,0x25,0x08,0x0a,0x9a,0x00,0x02,0x00,0x00,0x7b]
          vrndscaless xmm11, xmm11, dword ptr [rdx + 512], 123

// CHECK: vrndscaless xmm11, xmm11, dword ptr [rdx - 512], 123
// CHECK:  encoding: [0x62,0x73,0x25,0x08,0x0a,0x5a,0x80,0x7b]
          vrndscaless xmm11, xmm11, dword ptr [rdx - 512], 123

// CHECK: vrndscaless xmm11, xmm11, dword ptr [rdx - 516], 123
// CHECK:  encoding: [0x62,0x73,0x25,0x08,0x0a,0x9a,0xfc,0xfd,0xff,0xff,0x7b]
          vrndscaless xmm11, xmm11, dword ptr [rdx - 516], 123

// CHECK: vpcompressq zmmword ptr [rcx], zmm11
// CHECK:  encoding: [0x62,0x72,0xfd,0x48,0x8b,0x19]
          vpcompressq zmmword ptr [rcx], zmm11

// CHECK: vpcompressq zmmword ptr [rcx] {k7}, zmm11
// CHECK:  encoding: [0x62,0x72,0xfd,0x4f,0x8b,0x19]
          vpcompressq zmmword ptr [rcx] {k7}, zmm11

// CHECK: vpcompressq zmmword ptr [rax + 8*r14 + 291], zmm11
// CHECK:  encoding: [0x62,0x32,0xfd,0x48,0x8b,0x9c,0xf0,0x23,0x01,0x00,0x00]
          vpcompressq zmmword ptr [rax + 8*r14 + 291], zmm11

// CHECK: vpcompressq zmmword ptr [rdx + 1016], zmm11
// CHECK:  encoding: [0x62,0x72,0xfd,0x48,0x8b,0x5a,0x7f]
          vpcompressq zmmword ptr [rdx + 1016], zmm11

// CHECK: vpcompressq zmmword ptr [rdx + 1024], zmm11
// CHECK:  encoding: [0x62,0x72,0xfd,0x48,0x8b,0x9a,0x00,0x04,0x00,0x00]
          vpcompressq zmmword ptr [rdx + 1024], zmm11

// CHECK: vpcompressq zmmword ptr [rdx - 1024], zmm11
// CHECK:  encoding: [0x62,0x72,0xfd,0x48,0x8b,0x5a,0x80]
          vpcompressq zmmword ptr [rdx - 1024], zmm11

// CHECK: vpcompressq zmmword ptr [rdx - 1032], zmm11
// CHECK:  encoding: [0x62,0x72,0xfd,0x48,0x8b,0x9a,0xf8,0xfb,0xff,0xff]
          vpcompressq zmmword ptr [rdx - 1032], zmm11

// CHECK: vpcompressq zmm17, zmm19
// CHECK:  encoding: [0x62,0xa2,0xfd,0x48,0x8b,0xd9]
          vpcompressq zmm17, zmm19

// CHECK: vpcompressq zmm17 {k2}, zmm19
// CHECK:  encoding: [0x62,0xa2,0xfd,0x4a,0x8b,0xd9]
          vpcompressq zmm17 {k2}, zmm19

// CHECK: vpcompressq zmm17 {k2} {z}, zmm19
// CHECK:  encoding: [0x62,0xa2,0xfd,0xca,0x8b,0xd9]
          vpcompressq zmm17 {k2} {z}, zmm19

// CHECK: kandw  k2, k5, k6
// CHECK:  encoding: [0xc5,0xd4,0x41,0xd6]
          kandw  k2, k5, k6

// CHECK: kandnw k4, k6, k7
// CHECK:  encoding: [0xc5,0xcc,0x42,0xe7]
          kandnw k4, k6, k7

// CHECK: korw   k4, k6, k7
// CHECK:  encoding: [0xc5,0xcc,0x45,0xe7]
          korw   k4, k6, k7

// CHECK: kxnorw k3, k5, k5
// CHECK:  encoding: [0xc5,0xd4,0x46,0xdd]
          kxnorw k3, k5, k5

// CHECK: kxorw  k2, k6, k7
// CHECK:  encoding: [0xc5,0xcc,0x47,0xd7]
          kxorw  k2, k6, k7

// CHECK: knotw  k3, k6
// CHECK:  encoding: [0xc5,0xf8,0x44,0xde]
          knotw  k3, k6

// CHECK: kortestw k2, k6
// CHECK:  encoding: [0xc5,0xf8,0x98,0xd6]
          kortestw k2, k6

// CHECK: kshiftrw k4, k4, 171
// CHECK:  encoding: [0xc4,0xe3,0xf9,0x30,0xe4,0xab]
          kshiftrw k4, k4, 171

// CHECK: kshiftrw k4, k4, 123
// CHECK:  encoding: [0xc4,0xe3,0xf9,0x30,0xe4,0x7b]
          kshiftrw k4, k4, 123

// CHECK: kshiftlw k2, k5, 171
// CHECK:  encoding: [0xc4,0xe3,0xf9,0x32,0xd5,0xab]
          kshiftlw k2, k5, 171

// CHECK: kshiftlw k2, k5, 123
// CHECK:  encoding: [0xc4,0xe3,0xf9,0x32,0xd5,0x7b]
          kshiftlw k2, k5, 123

// CHECK: kmovw  k4, k5
// CHECK:  encoding: [0xc5,0xf8,0x90,0xe5]
          kmovw  k4, k5

// CHECK: kmovw  k4, word ptr [rcx]
// CHECK:  encoding: [0xc5,0xf8,0x90,0x21]
          kmovw  k4, word ptr [rcx]

// CHECK: kmovw  k4, word ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0xc4,0xa1,0x78,0x90,0xa4,0xf0,0x23,0x01,0x00,0x00]
          kmovw  k4, word ptr [rax + 8*r14 + 291]

// CHECK: kmovw  word ptr [rcx], k4
// CHECK:  encoding: [0xc5,0xf8,0x91,0x21]
          kmovw  word ptr [rcx], k4

// CHECK: kmovw  word ptr [rax + 8*r14 + 291], k4
// CHECK:  encoding: [0xc4,0xa1,0x78,0x91,0xa4,0xf0,0x23,0x01,0x00,0x00]
          kmovw  word ptr [rax + 8*r14 + 291], k4

// CHECK: kmovw  k3, eax
// CHECK:  encoding: [0xc5,0xf8,0x92,0xd8]
          kmovw  k3, eax

// CHECK: kmovw  k3, ebp
// CHECK:  encoding: [0xc5,0xf8,0x92,0xdd]
          kmovw  k3, ebp

// CHECK: kmovw  k3, r13d
// CHECK:  encoding: [0xc4,0xc1,0x78,0x92,0xdd]
          kmovw  k3, r13d

// CHECK: kmovw  eax, k2
// CHECK:  encoding: [0xc5,0xf8,0x93,0xc2]
          kmovw  eax, k2

// CHECK: kmovw  ebp, k2
// CHECK:  encoding: [0xc5,0xf8,0x93,0xea]
          kmovw  ebp, k2

// CHECK: kmovw  r13d, k2
// CHECK:  encoding: [0xc5,0x78,0x93,0xea]
          kmovw  r13d, k2

// CHECK: kunpckbw k5, k5, k6
// CHECK:  encoding: [0xc5,0xd5,0x4b,0xee]
          kunpckbw k5, k5, k6

// CHECK: vcvtps2ph ymmword ptr [rcx], zmm19, 171
// CHECK:  encoding: [0x62,0xe3,0x7d,0x48,0x1d,0x19,0xab]
          vcvtps2ph ymmword ptr [rcx], zmm19, 171

// CHECK: vcvtps2ph ymmword ptr [rcx] {k6}, zmm19, 171
// CHECK:  encoding: [0x62,0xe3,0x7d,0x4e,0x1d,0x19,0xab]
          vcvtps2ph ymmword ptr [rcx] {k6}, zmm19, 171

// CHECK: vcvtps2ph ymmword ptr [rcx], zmm19, 123
// CHECK:  encoding: [0x62,0xe3,0x7d,0x48,0x1d,0x19,0x7b]
          vcvtps2ph ymmword ptr [rcx], zmm19, 123

// CHECK: vcvtps2ph ymmword ptr [rax + 8*r14 + 291], zmm19, 123
// CHECK:  encoding: [0x62,0xa3,0x7d,0x48,0x1d,0x9c,0xf0,0x23,0x01,0x00,0x00,0x7b]
          vcvtps2ph ymmword ptr [rax + 8*r14 + 291], zmm19, 123

// CHECK: vcvtps2ph ymmword ptr [rdx + 4064], zmm19, 123
// CHECK:  encoding: [0x62,0xe3,0x7d,0x48,0x1d,0x5a,0x7f,0x7b]
          vcvtps2ph ymmword ptr [rdx + 4064], zmm19, 123

// CHECK: vcvtps2ph ymmword ptr [rdx + 4096], zmm19, 123
// CHECK:  encoding: [0x62,0xe3,0x7d,0x48,0x1d,0x9a,0x00,0x10,0x00,0x00,0x7b]
          vcvtps2ph ymmword ptr [rdx + 4096], zmm19, 123

// CHECK: vcvtps2ph ymmword ptr [rdx - 4096], zmm19, 123
// CHECK:  encoding: [0x62,0xe3,0x7d,0x48,0x1d,0x5a,0x80,0x7b]
          vcvtps2ph ymmword ptr [rdx - 4096], zmm19, 123

// CHECK: vcvtps2ph ymmword ptr [rdx - 4128], zmm19, 123
// CHECK:  encoding: [0x62,0xe3,0x7d,0x48,0x1d,0x9a,0xe0,0xef,0xff,0xff,0x7b]
          vcvtps2ph ymmword ptr [rdx - 4128], zmm19, 123

// CHECK: vextractf32x4 xmmword ptr [rcx], zmm20, 171
// CHECK:  encoding: [0x62,0xe3,0x7d,0x48,0x19,0x21,0xab]
          vextractf32x4 xmmword ptr [rcx], zmm20, 171

// CHECK: vextractf32x4 xmmword ptr [rcx] {k7}, zmm20, 171
// CHECK:  encoding: [0x62,0xe3,0x7d,0x4f,0x19,0x21,0xab]
          vextractf32x4 xmmword ptr [rcx] {k7}, zmm20, 171

// CHECK: vextractf32x4 xmmword ptr [rcx], zmm20, 123
// CHECK:  encoding: [0x62,0xe3,0x7d,0x48,0x19,0x21,0x7b]
          vextractf32x4 xmmword ptr [rcx], zmm20, 123

// CHECK: vextractf32x4 xmmword ptr [rax + 8*r14 + 291], zmm20, 123
// CHECK:  encoding: [0x62,0xa3,0x7d,0x48,0x19,0xa4,0xf0,0x23,0x01,0x00,0x00,0x7b]
          vextractf32x4 xmmword ptr [rax + 8*r14 + 291], zmm20, 123

// CHECK: vextractf32x4 xmmword ptr [rdx + 2032], zmm20, 123
// CHECK:  encoding: [0x62,0xe3,0x7d,0x48,0x19,0x62,0x7f,0x7b]
          vextractf32x4 xmmword ptr [rdx + 2032], zmm20, 123

// CHECK: vextractf32x4 xmmword ptr [rdx + 2048], zmm20, 123
// CHECK:  encoding: [0x62,0xe3,0x7d,0x48,0x19,0xa2,0x00,0x08,0x00,0x00,0x7b]
          vextractf32x4 xmmword ptr [rdx + 2048], zmm20, 123

// CHECK: vextractf32x4 xmmword ptr [rdx - 2048], zmm20, 123
// CHECK:  encoding: [0x62,0xe3,0x7d,0x48,0x19,0x62,0x80,0x7b]
          vextractf32x4 xmmword ptr [rdx - 2048], zmm20, 123

// CHECK: vextractf32x4 xmmword ptr [rdx - 2064], zmm20, 123
// CHECK:  encoding: [0x62,0xe3,0x7d,0x48,0x19,0xa2,0xf0,0xf7,0xff,0xff,0x7b]
          vextractf32x4 xmmword ptr [rdx - 2064], zmm20, 123

// CHECK: vextractf64x4 ymmword ptr [rcx], zmm5, 171
// CHECK:  encoding: [0x62,0xf3,0xfd,0x48,0x1b,0x29,0xab]
          vextractf64x4 ymmword ptr [rcx], zmm5, 171

// CHECK: vextractf64x4 ymmword ptr [rcx] {k4}, zmm5, 171
// CHECK:  encoding: [0x62,0xf3,0xfd,0x4c,0x1b,0x29,0xab]
          vextractf64x4 ymmword ptr [rcx] {k4}, zmm5, 171

// CHECK: vextractf64x4 ymmword ptr [rcx], zmm5, 123
// CHECK:  encoding: [0x62,0xf3,0xfd,0x48,0x1b,0x29,0x7b]
          vextractf64x4 ymmword ptr [rcx], zmm5, 123

// CHECK: vextractf64x4 ymmword ptr [rax + 8*r14 + 291], zmm5, 123
// CHECK:  encoding: [0x62,0xb3,0xfd,0x48,0x1b,0xac,0xf0,0x23,0x01,0x00,0x00,0x7b]
          vextractf64x4 ymmword ptr [rax + 8*r14 + 291], zmm5, 123

// CHECK: vextractf64x4 ymmword ptr [rdx + 4064], zmm5, 123
// CHECK:  encoding: [0x62,0xf3,0xfd,0x48,0x1b,0x6a,0x7f,0x7b]
          vextractf64x4 ymmword ptr [rdx + 4064], zmm5, 123

// CHECK: vextractf64x4 ymmword ptr [rdx + 4096], zmm5, 123
// CHECK:  encoding: [0x62,0xf3,0xfd,0x48,0x1b,0xaa,0x00,0x10,0x00,0x00,0x7b]
          vextractf64x4 ymmword ptr [rdx + 4096], zmm5, 123

// CHECK: vextractf64x4 ymmword ptr [rdx - 4096], zmm5, 123
// CHECK:  encoding: [0x62,0xf3,0xfd,0x48,0x1b,0x6a,0x80,0x7b]
          vextractf64x4 ymmword ptr [rdx - 4096], zmm5, 123

// CHECK: vextractf64x4 ymmword ptr [rdx - 4128], zmm5, 123
// CHECK:  encoding: [0x62,0xf3,0xfd,0x48,0x1b,0xaa,0xe0,0xef,0xff,0xff,0x7b]
          vextractf64x4 ymmword ptr [rdx - 4128], zmm5, 123

// CHECK: vextracti32x4 xmmword ptr [rcx], zmm29, 171
// CHECK:  encoding: [0x62,0x63,0x7d,0x48,0x39,0x29,0xab]
          vextracti32x4 xmmword ptr [rcx], zmm29, 171

// CHECK: vextracti32x4 xmmword ptr [rcx] {k2}, zmm29, 171
// CHECK:  encoding: [0x62,0x63,0x7d,0x4a,0x39,0x29,0xab]
          vextracti32x4 xmmword ptr [rcx] {k2}, zmm29, 171

// CHECK: vextracti32x4 xmmword ptr [rcx], zmm29, 123
// CHECK:  encoding: [0x62,0x63,0x7d,0x48,0x39,0x29,0x7b]
          vextracti32x4 xmmword ptr [rcx], zmm29, 123

// CHECK: vextracti32x4 xmmword ptr [rax + 8*r14 + 291], zmm29, 123
// CHECK:  encoding: [0x62,0x23,0x7d,0x48,0x39,0xac,0xf0,0x23,0x01,0x00,0x00,0x7b]
          vextracti32x4 xmmword ptr [rax + 8*r14 + 291], zmm29, 123

// CHECK: vextracti32x4 xmmword ptr [rdx + 2032], zmm29, 123
// CHECK:  encoding: [0x62,0x63,0x7d,0x48,0x39,0x6a,0x7f,0x7b]
          vextracti32x4 xmmword ptr [rdx + 2032], zmm29, 123

// CHECK: vextracti32x4 xmmword ptr [rdx + 2048], zmm29, 123
// CHECK:  encoding: [0x62,0x63,0x7d,0x48,0x39,0xaa,0x00,0x08,0x00,0x00,0x7b]
          vextracti32x4 xmmword ptr [rdx + 2048], zmm29, 123

// CHECK: vextracti32x4 xmmword ptr [rdx - 2048], zmm29, 123
// CHECK:  encoding: [0x62,0x63,0x7d,0x48,0x39,0x6a,0x80,0x7b]
          vextracti32x4 xmmword ptr [rdx - 2048], zmm29, 123

// CHECK: vextracti32x4 xmmword ptr [rdx - 2064], zmm29, 123
// CHECK:  encoding: [0x62,0x63,0x7d,0x48,0x39,0xaa,0xf0,0xf7,0xff,0xff,0x7b]
          vextracti32x4 xmmword ptr [rdx - 2064], zmm29, 123

// CHECK: vextracti64x4 ymmword ptr [rcx], zmm30, 171
// CHECK:  encoding: [0x62,0x63,0xfd,0x48,0x3b,0x31,0xab]
          vextracti64x4 ymmword ptr [rcx], zmm30, 171

// CHECK: vextracti64x4 ymmword ptr [rcx] {k4}, zmm30, 171
// CHECK:  encoding: [0x62,0x63,0xfd,0x4c,0x3b,0x31,0xab]
          vextracti64x4 ymmword ptr [rcx] {k4}, zmm30, 171

// CHECK: vextracti64x4 ymmword ptr [rcx], zmm30, 123
// CHECK:  encoding: [0x62,0x63,0xfd,0x48,0x3b,0x31,0x7b]
          vextracti64x4 ymmword ptr [rcx], zmm30, 123

// CHECK: vextracti64x4 ymmword ptr [rax + 8*r14 + 291], zmm30, 123
// CHECK:  encoding: [0x62,0x23,0xfd,0x48,0x3b,0xb4,0xf0,0x23,0x01,0x00,0x00,0x7b]
          vextracti64x4 ymmword ptr [rax + 8*r14 + 291], zmm30, 123

// CHECK: vextracti64x4 ymmword ptr [rdx + 4064], zmm30, 123
// CHECK:  encoding: [0x62,0x63,0xfd,0x48,0x3b,0x72,0x7f,0x7b]
          vextracti64x4 ymmword ptr [rdx + 4064], zmm30, 123

// CHECK: vextracti64x4 ymmword ptr [rdx + 4096], zmm30, 123
// CHECK:  encoding: [0x62,0x63,0xfd,0x48,0x3b,0xb2,0x00,0x10,0x00,0x00,0x7b]
          vextracti64x4 ymmword ptr [rdx + 4096], zmm30, 123

// CHECK: vextracti64x4 ymmword ptr [rdx - 4096], zmm30, 123
// CHECK:  encoding: [0x62,0x63,0xfd,0x48,0x3b,0x72,0x80,0x7b]
          vextracti64x4 ymmword ptr [rdx - 4096], zmm30, 123

// CHECK: vextracti64x4 ymmword ptr [rdx - 4128], zmm30, 123
// CHECK:  encoding: [0x62,0x63,0xfd,0x48,0x3b,0xb2,0xe0,0xef,0xff,0xff,0x7b]
          vextracti64x4 ymmword ptr [rdx - 4128], zmm30, 123

// CHECK: vmovapd zmmword ptr [rcx], zmm18
// CHECK:  encoding: [0x62,0xe1,0xfd,0x48,0x29,0x11]
          vmovapd zmmword ptr [rcx], zmm18

// CHECK: vmovapd zmmword ptr [rcx] {k6}, zmm18
// CHECK:  encoding: [0x62,0xe1,0xfd,0x4e,0x29,0x11]
          vmovapd zmmword ptr [rcx] {k6}, zmm18

// CHECK: vmovapd zmmword ptr [rax + 8*r14 + 291], zmm18
// CHECK:  encoding: [0x62,0xa1,0xfd,0x48,0x29,0x94,0xf0,0x23,0x01,0x00,0x00]
          vmovapd zmmword ptr [rax + 8*r14 + 291], zmm18

// CHECK: vmovapd zmmword ptr [rdx + 8128], zmm18
// CHECK:  encoding: [0x62,0xe1,0xfd,0x48,0x29,0x52,0x7f]
          vmovapd zmmword ptr [rdx + 8128], zmm18

// CHECK: vmovapd zmmword ptr [rdx + 8192], zmm18
// CHECK:  encoding: [0x62,0xe1,0xfd,0x48,0x29,0x92,0x00,0x20,0x00,0x00]
          vmovapd zmmword ptr [rdx + 8192], zmm18

// CHECK: vmovapd zmmword ptr [rdx - 8192], zmm18
// CHECK:  encoding: [0x62,0xe1,0xfd,0x48,0x29,0x52,0x80]
          vmovapd zmmword ptr [rdx - 8192], zmm18

// CHECK: vmovapd zmmword ptr [rdx - 8256], zmm18
// CHECK:  encoding: [0x62,0xe1,0xfd,0x48,0x29,0x92,0xc0,0xdf,0xff,0xff]
          vmovapd zmmword ptr [rdx - 8256], zmm18

// CHECK: vmovaps zmmword ptr [rcx], zmm9
// CHECK:  encoding: [0x62,0x71,0x7c,0x48,0x29,0x09]
          vmovaps zmmword ptr [rcx], zmm9

// CHECK: vmovaps zmmword ptr [rcx] {k3}, zmm9
// CHECK:  encoding: [0x62,0x71,0x7c,0x4b,0x29,0x09]
          vmovaps zmmword ptr [rcx] {k3}, zmm9

// CHECK: vmovaps zmmword ptr [rax + 8*r14 + 291], zmm9
// CHECK:  encoding: [0x62,0x31,0x7c,0x48,0x29,0x8c,0xf0,0x23,0x01,0x00,0x00]
          vmovaps zmmword ptr [rax + 8*r14 + 291], zmm9

// CHECK: vmovaps zmmword ptr [rdx + 8128], zmm9
// CHECK:  encoding: [0x62,0x71,0x7c,0x48,0x29,0x4a,0x7f]
          vmovaps zmmword ptr [rdx + 8128], zmm9

// CHECK: vmovaps zmmword ptr [rdx + 8192], zmm9
// CHECK:  encoding: [0x62,0x71,0x7c,0x48,0x29,0x8a,0x00,0x20,0x00,0x00]
          vmovaps zmmword ptr [rdx + 8192], zmm9

// CHECK: vmovaps zmmword ptr [rdx - 8192], zmm9
// CHECK:  encoding: [0x62,0x71,0x7c,0x48,0x29,0x4a,0x80]
          vmovaps zmmword ptr [rdx - 8192], zmm9

// CHECK: vmovaps zmmword ptr [rdx - 8256], zmm9
// CHECK:  encoding: [0x62,0x71,0x7c,0x48,0x29,0x8a,0xc0,0xdf,0xff,0xff]
          vmovaps zmmword ptr [rdx - 8256], zmm9

// CHECK: vmovdqa32 zmmword ptr [rcx], zmm18
// CHECK:  encoding: [0x62,0xe1,0x7d,0x48,0x7f,0x11]
          vmovdqa32 zmmword ptr [rcx], zmm18

// CHECK: vmovdqa32 zmmword ptr [rcx] {k4}, zmm18
// CHECK:  encoding: [0x62,0xe1,0x7d,0x4c,0x7f,0x11]
          vmovdqa32 zmmword ptr [rcx] {k4}, zmm18

// CHECK: vmovdqa32 zmmword ptr [rax + 8*r14 + 291], zmm18
// CHECK:  encoding: [0x62,0xa1,0x7d,0x48,0x7f,0x94,0xf0,0x23,0x01,0x00,0x00]
          vmovdqa32 zmmword ptr [rax + 8*r14 + 291], zmm18

// CHECK: vmovdqa32 zmmword ptr [rdx + 8128], zmm18
// CHECK:  encoding: [0x62,0xe1,0x7d,0x48,0x7f,0x52,0x7f]
          vmovdqa32 zmmword ptr [rdx + 8128], zmm18

// CHECK: vmovdqa32 zmmword ptr [rdx + 8192], zmm18
// CHECK:  encoding: [0x62,0xe1,0x7d,0x48,0x7f,0x92,0x00,0x20,0x00,0x00]
          vmovdqa32 zmmword ptr [rdx + 8192], zmm18

// CHECK: vmovdqa32 zmmword ptr [rdx - 8192], zmm18
// CHECK:  encoding: [0x62,0xe1,0x7d,0x48,0x7f,0x52,0x80]
          vmovdqa32 zmmword ptr [rdx - 8192], zmm18

// CHECK: vmovdqa32 zmmword ptr [rdx - 8256], zmm18
// CHECK:  encoding: [0x62,0xe1,0x7d,0x48,0x7f,0x92,0xc0,0xdf,0xff,0xff]
          vmovdqa32 zmmword ptr [rdx - 8256], zmm18

// CHECK: vmovdqa64 zmmword ptr [rcx], zmm19
// CHECK:  encoding: [0x62,0xe1,0xfd,0x48,0x7f,0x19]
          vmovdqa64 zmmword ptr [rcx], zmm19

// CHECK: vmovdqa64 zmmword ptr [rcx] {k5}, zmm19
// CHECK:  encoding: [0x62,0xe1,0xfd,0x4d,0x7f,0x19]
          vmovdqa64 zmmword ptr [rcx] {k5}, zmm19

// CHECK: vmovdqa64 zmmword ptr [rax + 8*r14 + 291], zmm19
// CHECK:  encoding: [0x62,0xa1,0xfd,0x48,0x7f,0x9c,0xf0,0x23,0x01,0x00,0x00]
          vmovdqa64 zmmword ptr [rax + 8*r14 + 291], zmm19

// CHECK: vmovdqa64 zmmword ptr [rdx + 8128], zmm19
// CHECK:  encoding: [0x62,0xe1,0xfd,0x48,0x7f,0x5a,0x7f]
          vmovdqa64 zmmword ptr [rdx + 8128], zmm19

// CHECK: vmovdqa64 zmmword ptr [rdx + 8192], zmm19
// CHECK:  encoding: [0x62,0xe1,0xfd,0x48,0x7f,0x9a,0x00,0x20,0x00,0x00]
          vmovdqa64 zmmword ptr [rdx + 8192], zmm19

// CHECK: vmovdqa64 zmmword ptr [rdx - 8192], zmm19
// CHECK:  encoding: [0x62,0xe1,0xfd,0x48,0x7f,0x5a,0x80]
          vmovdqa64 zmmword ptr [rdx - 8192], zmm19

// CHECK: vmovdqa64 zmmword ptr [rdx - 8256], zmm19
// CHECK:  encoding: [0x62,0xe1,0xfd,0x48,0x7f,0x9a,0xc0,0xdf,0xff,0xff]
          vmovdqa64 zmmword ptr [rdx - 8256], zmm19

// CHECK: vmovdqu32 zmmword ptr [rcx], zmm22
// CHECK:  encoding: [0x62,0xe1,0x7e,0x48,0x7f,0x31]
          vmovdqu32 zmmword ptr [rcx], zmm22

// CHECK: vmovdqu32 zmmword ptr [rcx] {k1}, zmm22
// CHECK:  encoding: [0x62,0xe1,0x7e,0x49,0x7f,0x31]
          vmovdqu32 zmmword ptr [rcx] {k1}, zmm22

// CHECK: vmovdqu32 zmmword ptr [rax + 8*r14 + 291], zmm22
// CHECK:  encoding: [0x62,0xa1,0x7e,0x48,0x7f,0xb4,0xf0,0x23,0x01,0x00,0x00]
          vmovdqu32 zmmword ptr [rax + 8*r14 + 291], zmm22

// CHECK: vmovdqu32 zmmword ptr [rdx + 8128], zmm22
// CHECK:  encoding: [0x62,0xe1,0x7e,0x48,0x7f,0x72,0x7f]
          vmovdqu32 zmmword ptr [rdx + 8128], zmm22

// CHECK: vmovdqu32 zmmword ptr [rdx + 8192], zmm22
// CHECK:  encoding: [0x62,0xe1,0x7e,0x48,0x7f,0xb2,0x00,0x20,0x00,0x00]
          vmovdqu32 zmmword ptr [rdx + 8192], zmm22

// CHECK: vmovdqu32 zmmword ptr [rdx - 8192], zmm22
// CHECK:  encoding: [0x62,0xe1,0x7e,0x48,0x7f,0x72,0x80]
          vmovdqu32 zmmword ptr [rdx - 8192], zmm22

// CHECK: vmovdqu32 zmmword ptr [rdx - 8256], zmm22
// CHECK:  encoding: [0x62,0xe1,0x7e,0x48,0x7f,0xb2,0xc0,0xdf,0xff,0xff]
          vmovdqu32 zmmword ptr [rdx - 8256], zmm22

// CHECK: vmovdqu64 zmmword ptr [rcx], zmm24
// CHECK:  encoding: [0x62,0x61,0xfe,0x48,0x7f,0x01]
          vmovdqu64 zmmword ptr [rcx], zmm24

// CHECK: vmovdqu64 zmmword ptr [rcx] {k5}, zmm24
// CHECK:  encoding: [0x62,0x61,0xfe,0x4d,0x7f,0x01]
          vmovdqu64 zmmword ptr [rcx] {k5}, zmm24

// CHECK: vmovdqu64 zmmword ptr [rax + 8*r14 + 291], zmm24
// CHECK:  encoding: [0x62,0x21,0xfe,0x48,0x7f,0x84,0xf0,0x23,0x01,0x00,0x00]
          vmovdqu64 zmmword ptr [rax + 8*r14 + 291], zmm24

// CHECK: vmovdqu64 zmmword ptr [rdx + 8128], zmm24
// CHECK:  encoding: [0x62,0x61,0xfe,0x48,0x7f,0x42,0x7f]
          vmovdqu64 zmmword ptr [rdx + 8128], zmm24

// CHECK: vmovdqu64 zmmword ptr [rdx + 8192], zmm24
// CHECK:  encoding: [0x62,0x61,0xfe,0x48,0x7f,0x82,0x00,0x20,0x00,0x00]
          vmovdqu64 zmmword ptr [rdx + 8192], zmm24

// CHECK: vmovdqu64 zmmword ptr [rdx - 8192], zmm24
// CHECK:  encoding: [0x62,0x61,0xfe,0x48,0x7f,0x42,0x80]
          vmovdqu64 zmmword ptr [rdx - 8192], zmm24

// CHECK: vmovdqu64 zmmword ptr [rdx - 8256], zmm24
// CHECK:  encoding: [0x62,0x61,0xfe,0x48,0x7f,0x82,0xc0,0xdf,0xff,0xff]
          vmovdqu64 zmmword ptr [rdx - 8256], zmm24

// CHECK: vmovupd zmmword ptr [rcx], zmm10
// CHECK:  encoding: [0x62,0x71,0xfd,0x48,0x11,0x11]
          vmovupd zmmword ptr [rcx], zmm10

// CHECK: vmovupd zmmword ptr [rcx] {k7}, zmm10
// CHECK:  encoding: [0x62,0x71,0xfd,0x4f,0x11,0x11]
          vmovupd zmmword ptr [rcx] {k7}, zmm10

// CHECK: vmovupd zmmword ptr [rax + 8*r14 + 291], zmm10
// CHECK:  encoding: [0x62,0x31,0xfd,0x48,0x11,0x94,0xf0,0x23,0x01,0x00,0x00]
          vmovupd zmmword ptr [rax + 8*r14 + 291], zmm10

// CHECK: vmovupd zmmword ptr [rdx + 8128], zmm10
// CHECK:  encoding: [0x62,0x71,0xfd,0x48,0x11,0x52,0x7f]
          vmovupd zmmword ptr [rdx + 8128], zmm10

// CHECK: vmovupd zmmword ptr [rdx + 8192], zmm10
// CHECK:  encoding: [0x62,0x71,0xfd,0x48,0x11,0x92,0x00,0x20,0x00,0x00]
          vmovupd zmmword ptr [rdx + 8192], zmm10

// CHECK: vmovupd zmmword ptr [rdx - 8192], zmm10
// CHECK:  encoding: [0x62,0x71,0xfd,0x48,0x11,0x52,0x80]
          vmovupd zmmword ptr [rdx - 8192], zmm10

// CHECK: vmovupd zmmword ptr [rdx - 8256], zmm10
// CHECK:  encoding: [0x62,0x71,0xfd,0x48,0x11,0x92,0xc0,0xdf,0xff,0xff]
          vmovupd zmmword ptr [rdx - 8256], zmm10

// CHECK: vmovups zmmword ptr [rcx], zmm24
// CHECK:  encoding: [0x62,0x61,0x7c,0x48,0x11,0x01]
          vmovups zmmword ptr [rcx], zmm24

// CHECK: vmovups zmmword ptr [rcx] {k7}, zmm24
// CHECK:  encoding: [0x62,0x61,0x7c,0x4f,0x11,0x01]
          vmovups zmmword ptr [rcx] {k7}, zmm24

// CHECK: vmovups zmmword ptr [rax + 8*r14 + 291], zmm24
// CHECK:  encoding: [0x62,0x21,0x7c,0x48,0x11,0x84,0xf0,0x23,0x01,0x00,0x00]
          vmovups zmmword ptr [rax + 8*r14 + 291], zmm24

// CHECK: vmovups zmmword ptr [rdx + 8128], zmm24
// CHECK:  encoding: [0x62,0x61,0x7c,0x48,0x11,0x42,0x7f]
          vmovups zmmword ptr [rdx + 8128], zmm24

// CHECK: vmovups zmmword ptr [rdx + 8192], zmm24
// CHECK:  encoding: [0x62,0x61,0x7c,0x48,0x11,0x82,0x00,0x20,0x00,0x00]
          vmovups zmmword ptr [rdx + 8192], zmm24

// CHECK: vmovups zmmword ptr [rdx - 8192], zmm24
// CHECK:  encoding: [0x62,0x61,0x7c,0x48,0x11,0x42,0x80]
          vmovups zmmword ptr [rdx - 8192], zmm24

// CHECK: vmovups zmmword ptr [rdx - 8256], zmm24
// CHECK:  encoding: [0x62,0x61,0x7c,0x48,0x11,0x82,0xc0,0xdf,0xff,0xff]
          vmovups zmmword ptr [rdx - 8256], zmm24

// CHECK: vpmovqb qword ptr [rcx], zmm3
// CHECK:  encoding: [0x62,0xf2,0x7e,0x48,0x32,0x19]
          vpmovqb qword ptr [rcx], zmm3

// CHECK: vpmovqb qword ptr [rcx] {k7}, zmm3
// CHECK:  encoding: [0x62,0xf2,0x7e,0x4f,0x32,0x19]
          vpmovqb qword ptr [rcx] {k7}, zmm3

// CHECK: vpmovqb qword ptr [rax + 8*r14 + 291], zmm3
// CHECK:  encoding: [0x62,0xb2,0x7e,0x48,0x32,0x9c,0xf0,0x23,0x01,0x00,0x00]
          vpmovqb qword ptr [rax + 8*r14 + 291], zmm3

// CHECK: vpmovqb qword ptr [rdx + 1016], zmm3
// CHECK:  encoding: [0x62,0xf2,0x7e,0x48,0x32,0x5a,0x7f]
          vpmovqb qword ptr [rdx + 1016], zmm3

// CHECK: vpmovqb qword ptr [rdx + 1024], zmm3
// CHECK:  encoding: [0x62,0xf2,0x7e,0x48,0x32,0x9a,0x00,0x04,0x00,0x00]
          vpmovqb qword ptr [rdx + 1024], zmm3

// CHECK: vpmovqb qword ptr [rdx - 1024], zmm3
// CHECK:  encoding: [0x62,0xf2,0x7e,0x48,0x32,0x5a,0x80]
          vpmovqb qword ptr [rdx - 1024], zmm3

// CHECK: vpmovqb qword ptr [rdx - 1032], zmm3
// CHECK:  encoding: [0x62,0xf2,0x7e,0x48,0x32,0x9a,0xf8,0xfb,0xff,0xff]
          vpmovqb qword ptr [rdx - 1032], zmm3

// CHECK: vpmovsqb qword ptr [rcx], zmm16
// CHECK:  encoding: [0x62,0xe2,0x7e,0x48,0x22,0x01]
          vpmovsqb qword ptr [rcx], zmm16

// CHECK: vpmovsqb qword ptr [rcx] {k2}, zmm16
// CHECK:  encoding: [0x62,0xe2,0x7e,0x4a,0x22,0x01]
          vpmovsqb qword ptr [rcx] {k2}, zmm16

// CHECK: vpmovsqb qword ptr [rax + 8*r14 + 291], zmm16
// CHECK:  encoding: [0x62,0xa2,0x7e,0x48,0x22,0x84,0xf0,0x23,0x01,0x00,0x00]
          vpmovsqb qword ptr [rax + 8*r14 + 291], zmm16

// CHECK: vpmovsqb qword ptr [rdx + 1016], zmm16
// CHECK:  encoding: [0x62,0xe2,0x7e,0x48,0x22,0x42,0x7f]
          vpmovsqb qword ptr [rdx + 1016], zmm16

// CHECK: vpmovsqb qword ptr [rdx + 1024], zmm16
// CHECK:  encoding: [0x62,0xe2,0x7e,0x48,0x22,0x82,0x00,0x04,0x00,0x00]
          vpmovsqb qword ptr [rdx + 1024], zmm16

// CHECK: vpmovsqb qword ptr [rdx - 1024], zmm16
// CHECK:  encoding: [0x62,0xe2,0x7e,0x48,0x22,0x42,0x80]
          vpmovsqb qword ptr [rdx - 1024], zmm16

// CHECK: vpmovsqb qword ptr [rdx - 1032], zmm16
// CHECK:  encoding: [0x62,0xe2,0x7e,0x48,0x22,0x82,0xf8,0xfb,0xff,0xff]
          vpmovsqb qword ptr [rdx - 1032], zmm16

// CHECK: vpmovusqb qword ptr [rcx], zmm28
// CHECK:  encoding: [0x62,0x62,0x7e,0x48,0x12,0x21]
          vpmovusqb qword ptr [rcx], zmm28

// CHECK: vpmovusqb qword ptr [rcx] {k1}, zmm28
// CHECK:  encoding: [0x62,0x62,0x7e,0x49,0x12,0x21]
          vpmovusqb qword ptr [rcx] {k1}, zmm28

// CHECK: vpmovusqb qword ptr [rax + 8*r14 + 291], zmm28
// CHECK:  encoding: [0x62,0x22,0x7e,0x48,0x12,0xa4,0xf0,0x23,0x01,0x00,0x00]
          vpmovusqb qword ptr [rax + 8*r14 + 291], zmm28

// CHECK: vpmovusqb qword ptr [rdx + 1016], zmm28
// CHECK:  encoding: [0x62,0x62,0x7e,0x48,0x12,0x62,0x7f]
          vpmovusqb qword ptr [rdx + 1016], zmm28

// CHECK: vpmovusqb qword ptr [rdx + 1024], zmm28
// CHECK:  encoding: [0x62,0x62,0x7e,0x48,0x12,0xa2,0x00,0x04,0x00,0x00]
          vpmovusqb qword ptr [rdx + 1024], zmm28

// CHECK: vpmovusqb qword ptr [rdx - 1024], zmm28
// CHECK:  encoding: [0x62,0x62,0x7e,0x48,0x12,0x62,0x80]
          vpmovusqb qword ptr [rdx - 1024], zmm28

// CHECK: vpmovusqb qword ptr [rdx - 1032], zmm28
// CHECK:  encoding: [0x62,0x62,0x7e,0x48,0x12,0xa2,0xf8,0xfb,0xff,0xff]
          vpmovusqb qword ptr [rdx - 1032], zmm28

// CHECK: vpmovqw xmmword ptr [rcx], zmm7
// CHECK:  encoding: [0x62,0xf2,0x7e,0x48,0x34,0x39]
          vpmovqw xmmword ptr [rcx], zmm7

// CHECK: vpmovqw xmmword ptr [rcx] {k6}, zmm7
// CHECK:  encoding: [0x62,0xf2,0x7e,0x4e,0x34,0x39]
          vpmovqw xmmword ptr [rcx] {k6}, zmm7

// CHECK: vpmovqw xmmword ptr [rax + 8*r14 + 291], zmm7
// CHECK:  encoding: [0x62,0xb2,0x7e,0x48,0x34,0xbc,0xf0,0x23,0x01,0x00,0x00]
          vpmovqw xmmword ptr [rax + 8*r14 + 291], zmm7

// CHECK: vpmovqw xmmword ptr [rdx + 2032], zmm7
// CHECK:  encoding: [0x62,0xf2,0x7e,0x48,0x34,0x7a,0x7f]
          vpmovqw xmmword ptr [rdx + 2032], zmm7

// CHECK: vpmovqw xmmword ptr [rdx + 2048], zmm7
// CHECK:  encoding: [0x62,0xf2,0x7e,0x48,0x34,0xba,0x00,0x08,0x00,0x00]
          vpmovqw xmmword ptr [rdx + 2048], zmm7

// CHECK: vpmovqw xmmword ptr [rdx - 2048], zmm7
// CHECK:  encoding: [0x62,0xf2,0x7e,0x48,0x34,0x7a,0x80]
          vpmovqw xmmword ptr [rdx - 2048], zmm7

// CHECK: vpmovqw xmmword ptr [rdx - 2064], zmm7
// CHECK:  encoding: [0x62,0xf2,0x7e,0x48,0x34,0xba,0xf0,0xf7,0xff,0xff]
          vpmovqw xmmword ptr [rdx - 2064], zmm7

// CHECK: vpmovsqw xmmword ptr [rcx], zmm1
// CHECK:  encoding: [0x62,0xf2,0x7e,0x48,0x24,0x09]
          vpmovsqw xmmword ptr [rcx], zmm1

// CHECK: vpmovsqw xmmword ptr [rcx] {k5}, zmm1
// CHECK:  encoding: [0x62,0xf2,0x7e,0x4d,0x24,0x09]
          vpmovsqw xmmword ptr [rcx] {k5}, zmm1

// CHECK: vpmovsqw xmmword ptr [rax + 8*r14 + 291], zmm1
// CHECK:  encoding: [0x62,0xb2,0x7e,0x48,0x24,0x8c,0xf0,0x23,0x01,0x00,0x00]
          vpmovsqw xmmword ptr [rax + 8*r14 + 291], zmm1

// CHECK: vpmovsqw xmmword ptr [rdx + 2032], zmm1
// CHECK:  encoding: [0x62,0xf2,0x7e,0x48,0x24,0x4a,0x7f]
          vpmovsqw xmmword ptr [rdx + 2032], zmm1

// CHECK: vpmovsqw xmmword ptr [rdx + 2048], zmm1
// CHECK:  encoding: [0x62,0xf2,0x7e,0x48,0x24,0x8a,0x00,0x08,0x00,0x00]
          vpmovsqw xmmword ptr [rdx + 2048], zmm1

// CHECK: vpmovsqw xmmword ptr [rdx - 2048], zmm1
// CHECK:  encoding: [0x62,0xf2,0x7e,0x48,0x24,0x4a,0x80]
          vpmovsqw xmmword ptr [rdx - 2048], zmm1

// CHECK: vpmovsqw xmmword ptr [rdx - 2064], zmm1
// CHECK:  encoding: [0x62,0xf2,0x7e,0x48,0x24,0x8a,0xf0,0xf7,0xff,0xff]
          vpmovsqw xmmword ptr [rdx - 2064], zmm1

// CHECK: vpmovusqw xmmword ptr [rcx], zmm25
// CHECK:  encoding: [0x62,0x62,0x7e,0x48,0x14,0x09]
          vpmovusqw xmmword ptr [rcx], zmm25

// CHECK: vpmovusqw xmmword ptr [rcx] {k3}, zmm25
// CHECK:  encoding: [0x62,0x62,0x7e,0x4b,0x14,0x09]
          vpmovusqw xmmword ptr [rcx] {k3}, zmm25

// CHECK: vpmovusqw xmmword ptr [rax + 8*r14 + 291], zmm25
// CHECK:  encoding: [0x62,0x22,0x7e,0x48,0x14,0x8c,0xf0,0x23,0x01,0x00,0x00]
          vpmovusqw xmmword ptr [rax + 8*r14 + 291], zmm25

// CHECK: vpmovusqw xmmword ptr [rdx + 2032], zmm25
// CHECK:  encoding: [0x62,0x62,0x7e,0x48,0x14,0x4a,0x7f]
          vpmovusqw xmmword ptr [rdx + 2032], zmm25

// CHECK: vpmovusqw xmmword ptr [rdx + 2048], zmm25
// CHECK:  encoding: [0x62,0x62,0x7e,0x48,0x14,0x8a,0x00,0x08,0x00,0x00]
          vpmovusqw xmmword ptr [rdx + 2048], zmm25

// CHECK: vpmovusqw xmmword ptr [rdx - 2048], zmm25
// CHECK:  encoding: [0x62,0x62,0x7e,0x48,0x14,0x4a,0x80]
          vpmovusqw xmmword ptr [rdx - 2048], zmm25

// CHECK: vpmovusqw xmmword ptr [rdx - 2064], zmm25
// CHECK:  encoding: [0x62,0x62,0x7e,0x48,0x14,0x8a,0xf0,0xf7,0xff,0xff]
          vpmovusqw xmmword ptr [rdx - 2064], zmm25

// CHECK: vpmovqd ymmword ptr [rcx], zmm28
// CHECK:  encoding: [0x62,0x62,0x7e,0x48,0x35,0x21]
          vpmovqd ymmword ptr [rcx], zmm28

// CHECK: vpmovqd ymmword ptr [rcx] {k5}, zmm28
// CHECK:  encoding: [0x62,0x62,0x7e,0x4d,0x35,0x21]
          vpmovqd ymmword ptr [rcx] {k5}, zmm28

// CHECK: vpmovqd ymmword ptr [rax + 8*r14 + 291], zmm28
// CHECK:  encoding: [0x62,0x22,0x7e,0x48,0x35,0xa4,0xf0,0x23,0x01,0x00,0x00]
          vpmovqd ymmword ptr [rax + 8*r14 + 291], zmm28

// CHECK: vpmovqd ymmword ptr [rdx + 4064], zmm28
// CHECK:  encoding: [0x62,0x62,0x7e,0x48,0x35,0x62,0x7f]
          vpmovqd ymmword ptr [rdx + 4064], zmm28

// CHECK: vpmovqd ymmword ptr [rdx + 4096], zmm28
// CHECK:  encoding: [0x62,0x62,0x7e,0x48,0x35,0xa2,0x00,0x10,0x00,0x00]
          vpmovqd ymmword ptr [rdx + 4096], zmm28

// CHECK: vpmovqd ymmword ptr [rdx - 4096], zmm28
// CHECK:  encoding: [0x62,0x62,0x7e,0x48,0x35,0x62,0x80]
          vpmovqd ymmword ptr [rdx - 4096], zmm28

// CHECK: vpmovqd ymmword ptr [rdx - 4128], zmm28
// CHECK:  encoding: [0x62,0x62,0x7e,0x48,0x35,0xa2,0xe0,0xef,0xff,0xff]
          vpmovqd ymmword ptr [rdx - 4128], zmm28

// CHECK: vpmovsqd ymmword ptr [rcx], zmm9
// CHECK:  encoding: [0x62,0x72,0x7e,0x48,0x25,0x09]
          vpmovsqd ymmword ptr [rcx], zmm9

// CHECK: vpmovsqd ymmword ptr [rcx] {k7}, zmm9
// CHECK:  encoding: [0x62,0x72,0x7e,0x4f,0x25,0x09]
          vpmovsqd ymmword ptr [rcx] {k7}, zmm9

// CHECK: vpmovsqd ymmword ptr [rax + 8*r14 + 291], zmm9
// CHECK:  encoding: [0x62,0x32,0x7e,0x48,0x25,0x8c,0xf0,0x23,0x01,0x00,0x00]
          vpmovsqd ymmword ptr [rax + 8*r14 + 291], zmm9

// CHECK: vpmovsqd ymmword ptr [rdx + 4064], zmm9
// CHECK:  encoding: [0x62,0x72,0x7e,0x48,0x25,0x4a,0x7f]
          vpmovsqd ymmword ptr [rdx + 4064], zmm9

// CHECK: vpmovsqd ymmword ptr [rdx + 4096], zmm9
// CHECK:  encoding: [0x62,0x72,0x7e,0x48,0x25,0x8a,0x00,0x10,0x00,0x00]
          vpmovsqd ymmword ptr [rdx + 4096], zmm9

// CHECK: vpmovsqd ymmword ptr [rdx - 4096], zmm9
// CHECK:  encoding: [0x62,0x72,0x7e,0x48,0x25,0x4a,0x80]
          vpmovsqd ymmword ptr [rdx - 4096], zmm9

// CHECK: vpmovsqd ymmword ptr [rdx - 4128], zmm9
// CHECK:  encoding: [0x62,0x72,0x7e,0x48,0x25,0x8a,0xe0,0xef,0xff,0xff]
          vpmovsqd ymmword ptr [rdx - 4128], zmm9

// CHECK: vpmovusqd ymmword ptr [rcx], zmm22
// CHECK:  encoding: [0x62,0xe2,0x7e,0x48,0x15,0x31]
          vpmovusqd ymmword ptr [rcx], zmm22

// CHECK: vpmovusqd ymmword ptr [rcx] {k1}, zmm22
// CHECK:  encoding: [0x62,0xe2,0x7e,0x49,0x15,0x31]
          vpmovusqd ymmword ptr [rcx] {k1}, zmm22

// CHECK: vpmovusqd ymmword ptr [rax + 8*r14 + 291], zmm22
// CHECK:  encoding: [0x62,0xa2,0x7e,0x48,0x15,0xb4,0xf0,0x23,0x01,0x00,0x00]
          vpmovusqd ymmword ptr [rax + 8*r14 + 291], zmm22

// CHECK: vpmovusqd ymmword ptr [rdx + 4064], zmm22
// CHECK:  encoding: [0x62,0xe2,0x7e,0x48,0x15,0x72,0x7f]
          vpmovusqd ymmword ptr [rdx + 4064], zmm22

// CHECK: vpmovusqd ymmword ptr [rdx + 4096], zmm22
// CHECK:  encoding: [0x62,0xe2,0x7e,0x48,0x15,0xb2,0x00,0x10,0x00,0x00]
          vpmovusqd ymmword ptr [rdx + 4096], zmm22

// CHECK: vpmovusqd ymmword ptr [rdx - 4096], zmm22
// CHECK:  encoding: [0x62,0xe2,0x7e,0x48,0x15,0x72,0x80]
          vpmovusqd ymmword ptr [rdx - 4096], zmm22

// CHECK: vpmovusqd ymmword ptr [rdx - 4128], zmm22
// CHECK:  encoding: [0x62,0xe2,0x7e,0x48,0x15,0xb2,0xe0,0xef,0xff,0xff]
          vpmovusqd ymmword ptr [rdx - 4128], zmm22

// CHECK: vpmovdb xmmword ptr [rcx], zmm12
// CHECK:  encoding: [0x62,0x72,0x7e,0x48,0x31,0x21]
          vpmovdb xmmword ptr [rcx], zmm12

// CHECK: vpmovdb xmmword ptr [rcx] {k3}, zmm12
// CHECK:  encoding: [0x62,0x72,0x7e,0x4b,0x31,0x21]
          vpmovdb xmmword ptr [rcx] {k3}, zmm12

// CHECK: vpmovdb xmmword ptr [rax + 8*r14 + 291], zmm12
// CHECK:  encoding: [0x62,0x32,0x7e,0x48,0x31,0xa4,0xf0,0x23,0x01,0x00,0x00]
          vpmovdb xmmword ptr [rax + 8*r14 + 291], zmm12

// CHECK: vpmovdb xmmword ptr [rdx + 2032], zmm12
// CHECK:  encoding: [0x62,0x72,0x7e,0x48,0x31,0x62,0x7f]
          vpmovdb xmmword ptr [rdx + 2032], zmm12

// CHECK: vpmovdb xmmword ptr [rdx + 2048], zmm12
// CHECK:  encoding: [0x62,0x72,0x7e,0x48,0x31,0xa2,0x00,0x08,0x00,0x00]
          vpmovdb xmmword ptr [rdx + 2048], zmm12

// CHECK: vpmovdb xmmword ptr [rdx - 2048], zmm12
// CHECK:  encoding: [0x62,0x72,0x7e,0x48,0x31,0x62,0x80]
          vpmovdb xmmword ptr [rdx - 2048], zmm12

// CHECK: vpmovdb xmmword ptr [rdx - 2064], zmm12
// CHECK:  encoding: [0x62,0x72,0x7e,0x48,0x31,0xa2,0xf0,0xf7,0xff,0xff]
          vpmovdb xmmword ptr [rdx - 2064], zmm12

// CHECK: vpmovsdb xmmword ptr [rcx], zmm6
// CHECK:  encoding: [0x62,0xf2,0x7e,0x48,0x21,0x31]
          vpmovsdb xmmword ptr [rcx], zmm6

// CHECK: vpmovsdb xmmword ptr [rcx] {k1}, zmm6
// CHECK:  encoding: [0x62,0xf2,0x7e,0x49,0x21,0x31]
          vpmovsdb xmmword ptr [rcx] {k1}, zmm6

// CHECK: vpmovsdb xmmword ptr [rax + 8*r14 + 291], zmm6
// CHECK:  encoding: [0x62,0xb2,0x7e,0x48,0x21,0xb4,0xf0,0x23,0x01,0x00,0x00]
          vpmovsdb xmmword ptr [rax + 8*r14 + 291], zmm6

// CHECK: vpmovsdb xmmword ptr [rdx + 2032], zmm6
// CHECK:  encoding: [0x62,0xf2,0x7e,0x48,0x21,0x72,0x7f]
          vpmovsdb xmmword ptr [rdx + 2032], zmm6

// CHECK: vpmovsdb xmmword ptr [rdx + 2048], zmm6
// CHECK:  encoding: [0x62,0xf2,0x7e,0x48,0x21,0xb2,0x00,0x08,0x00,0x00]
          vpmovsdb xmmword ptr [rdx + 2048], zmm6

// CHECK: vpmovsdb xmmword ptr [rdx - 2048], zmm6
// CHECK:  encoding: [0x62,0xf2,0x7e,0x48,0x21,0x72,0x80]
          vpmovsdb xmmword ptr [rdx - 2048], zmm6

// CHECK: vpmovsdb xmmword ptr [rdx - 2064], zmm6
// CHECK:  encoding: [0x62,0xf2,0x7e,0x48,0x21,0xb2,0xf0,0xf7,0xff,0xff]
          vpmovsdb xmmword ptr [rdx - 2064], zmm6

// CHECK: vpmovusdb xmmword ptr [rcx], zmm23
// CHECK:  encoding: [0x62,0xe2,0x7e,0x48,0x11,0x39]
          vpmovusdb xmmword ptr [rcx], zmm23

// CHECK: vpmovusdb xmmword ptr [rcx] {k3}, zmm23
// CHECK:  encoding: [0x62,0xe2,0x7e,0x4b,0x11,0x39]
          vpmovusdb xmmword ptr [rcx] {k3}, zmm23

// CHECK: vpmovusdb xmmword ptr [rax + 8*r14 + 291], zmm23
// CHECK:  encoding: [0x62,0xa2,0x7e,0x48,0x11,0xbc,0xf0,0x23,0x01,0x00,0x00]
          vpmovusdb xmmword ptr [rax + 8*r14 + 291], zmm23

// CHECK: vpmovusdb xmmword ptr [rdx + 2032], zmm23
// CHECK:  encoding: [0x62,0xe2,0x7e,0x48,0x11,0x7a,0x7f]
          vpmovusdb xmmword ptr [rdx + 2032], zmm23

// CHECK: vpmovusdb xmmword ptr [rdx + 2048], zmm23
// CHECK:  encoding: [0x62,0xe2,0x7e,0x48,0x11,0xba,0x00,0x08,0x00,0x00]
          vpmovusdb xmmword ptr [rdx + 2048], zmm23

// CHECK: vpmovusdb xmmword ptr [rdx - 2048], zmm23
// CHECK:  encoding: [0x62,0xe2,0x7e,0x48,0x11,0x7a,0x80]
          vpmovusdb xmmword ptr [rdx - 2048], zmm23

// CHECK: vpmovusdb xmmword ptr [rdx - 2064], zmm23
// CHECK:  encoding: [0x62,0xe2,0x7e,0x48,0x11,0xba,0xf0,0xf7,0xff,0xff]
          vpmovusdb xmmword ptr [rdx - 2064], zmm23

// CHECK: vpmovdw ymmword ptr [rcx], zmm7
// CHECK:  encoding: [0x62,0xf2,0x7e,0x48,0x33,0x39]
          vpmovdw ymmword ptr [rcx], zmm7

// CHECK: vpmovdw ymmword ptr [rcx] {k7}, zmm7
// CHECK:  encoding: [0x62,0xf2,0x7e,0x4f,0x33,0x39]
          vpmovdw ymmword ptr [rcx] {k7}, zmm7

// CHECK: vpmovdw ymmword ptr [rax + 8*r14 + 291], zmm7
// CHECK:  encoding: [0x62,0xb2,0x7e,0x48,0x33,0xbc,0xf0,0x23,0x01,0x00,0x00]
          vpmovdw ymmword ptr [rax + 8*r14 + 291], zmm7

// CHECK: vpmovdw ymmword ptr [rdx + 4064], zmm7
// CHECK:  encoding: [0x62,0xf2,0x7e,0x48,0x33,0x7a,0x7f]
          vpmovdw ymmword ptr [rdx + 4064], zmm7

// CHECK: vpmovdw ymmword ptr [rdx + 4096], zmm7
// CHECK:  encoding: [0x62,0xf2,0x7e,0x48,0x33,0xba,0x00,0x10,0x00,0x00]
          vpmovdw ymmword ptr [rdx + 4096], zmm7

// CHECK: vpmovdw ymmword ptr [rdx - 4096], zmm7
// CHECK:  encoding: [0x62,0xf2,0x7e,0x48,0x33,0x7a,0x80]
          vpmovdw ymmword ptr [rdx - 4096], zmm7

// CHECK: vpmovdw ymmword ptr [rdx - 4128], zmm7
// CHECK:  encoding: [0x62,0xf2,0x7e,0x48,0x33,0xba,0xe0,0xef,0xff,0xff]
          vpmovdw ymmword ptr [rdx - 4128], zmm7

// CHECK: vpmovsdw ymmword ptr [rcx], zmm14
// CHECK:  encoding: [0x62,0x72,0x7e,0x48,0x23,0x31]
          vpmovsdw ymmword ptr [rcx], zmm14

// CHECK: vpmovsdw ymmword ptr [rcx] {k6}, zmm14
// CHECK:  encoding: [0x62,0x72,0x7e,0x4e,0x23,0x31]
          vpmovsdw ymmword ptr [rcx] {k6}, zmm14

// CHECK: vpmovsdw ymmword ptr [rax + 8*r14 + 291], zmm14
// CHECK:  encoding: [0x62,0x32,0x7e,0x48,0x23,0xb4,0xf0,0x23,0x01,0x00,0x00]
          vpmovsdw ymmword ptr [rax + 8*r14 + 291], zmm14

// CHECK: vpmovsdw ymmword ptr [rdx + 4064], zmm14
// CHECK:  encoding: [0x62,0x72,0x7e,0x48,0x23,0x72,0x7f]
          vpmovsdw ymmword ptr [rdx + 4064], zmm14

// CHECK: vpmovsdw ymmword ptr [rdx + 4096], zmm14
// CHECK:  encoding: [0x62,0x72,0x7e,0x48,0x23,0xb2,0x00,0x10,0x00,0x00]
          vpmovsdw ymmword ptr [rdx + 4096], zmm14

// CHECK: vpmovsdw ymmword ptr [rdx - 4096], zmm14
// CHECK:  encoding: [0x62,0x72,0x7e,0x48,0x23,0x72,0x80]
          vpmovsdw ymmword ptr [rdx - 4096], zmm14

// CHECK: vpmovsdw ymmword ptr [rdx - 4128], zmm14
// CHECK:  encoding: [0x62,0x72,0x7e,0x48,0x23,0xb2,0xe0,0xef,0xff,0xff]
          vpmovsdw ymmword ptr [rdx - 4128], zmm14

// CHECK: vpmovusdw ymmword ptr [rcx], zmm5
// CHECK:  encoding: [0x62,0xf2,0x7e,0x48,0x13,0x29]
          vpmovusdw ymmword ptr [rcx], zmm5

// CHECK: vpmovusdw ymmword ptr [rcx] {k3}, zmm5
// CHECK:  encoding: [0x62,0xf2,0x7e,0x4b,0x13,0x29]
          vpmovusdw ymmword ptr [rcx] {k3}, zmm5

// CHECK: vpmovusdw ymmword ptr [rax + 8*r14 + 291], zmm5
// CHECK:  encoding: [0x62,0xb2,0x7e,0x48,0x13,0xac,0xf0,0x23,0x01,0x00,0x00]
          vpmovusdw ymmword ptr [rax + 8*r14 + 291], zmm5

// CHECK: vpmovusdw ymmword ptr [rdx + 4064], zmm5
// CHECK:  encoding: [0x62,0xf2,0x7e,0x48,0x13,0x6a,0x7f]
          vpmovusdw ymmword ptr [rdx + 4064], zmm5

// CHECK: vpmovusdw ymmword ptr [rdx + 4096], zmm5
// CHECK:  encoding: [0x62,0xf2,0x7e,0x48,0x13,0xaa,0x00,0x10,0x00,0x00]
          vpmovusdw ymmword ptr [rdx + 4096], zmm5

// CHECK: vpmovusdw ymmword ptr [rdx - 4096], zmm5
// CHECK:  encoding: [0x62,0xf2,0x7e,0x48,0x13,0x6a,0x80]
          vpmovusdw ymmword ptr [rdx - 4096], zmm5

// CHECK: vpmovusdw ymmword ptr [rdx - 4128], zmm5
// CHECK:  encoding: [0x62,0xf2,0x7e,0x48,0x13,0xaa,0xe0,0xef,0xff,0xff]
          vpmovusdw ymmword ptr [rdx - 4128], zmm5

// CHECK: vcvttpd2udq ymm16, zmm20
// CHECK:  encoding: [0x62,0xa1,0xfc,0x48,0x78,0xc4]
          vcvttpd2udq ymm16, zmm20

// CHECK: vcvttpd2udq ymm16 {k7}, zmm20
// CHECK:  encoding: [0x62,0xa1,0xfc,0x4f,0x78,0xc4]
          vcvttpd2udq ymm16 {k7}, zmm20

// CHECK: vcvttpd2udq ymm16 {k7} {z}, zmm20
// CHECK:  encoding: [0x62,0xa1,0xfc,0xcf,0x78,0xc4]
          vcvttpd2udq ymm16 {k7} {z}, zmm20

// CHECK: vcvttpd2udq ymm16, zmm20, {sae}
// CHECK:  encoding: [0x62,0xa1,0xfc,0x18,0x78,0xc4]
          vcvttpd2udq ymm16, zmm20, {sae}

// CHECK: vcvttpd2udq ymm16, zmmword ptr [rcx]
// CHECK:  encoding: [0x62,0xe1,0xfc,0x48,0x78,0x01]
          vcvttpd2udq ymm16, zmmword ptr [rcx]

// CHECK: vcvttpd2udq ymm16, zmmword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0xa1,0xfc,0x48,0x78,0x84,0xf0,0x23,0x01,0x00,0x00]
          vcvttpd2udq ymm16, zmmword ptr [rax + 8*r14 + 291]

// CHECK: vcvttpd2udq ymm16, qword ptr [rcx]{1to8}
// CHECK:  encoding: [0x62,0xe1,0xfc,0x58,0x78,0x01]
          vcvttpd2udq ymm16, qword ptr [rcx]{1to8}

// CHECK: vcvttpd2udq ymm16, zmmword ptr [rdx + 8128]
// CHECK:  encoding: [0x62,0xe1,0xfc,0x48,0x78,0x42,0x7f]
          vcvttpd2udq ymm16, zmmword ptr [rdx + 8128]

// CHECK: vcvttpd2udq ymm16, zmmword ptr [rdx + 8192]
// CHECK:  encoding: [0x62,0xe1,0xfc,0x48,0x78,0x82,0x00,0x20,0x00,0x00]
          vcvttpd2udq ymm16, zmmword ptr [rdx + 8192]

// CHECK: vcvttpd2udq ymm16, zmmword ptr [rdx - 8192]
// CHECK:  encoding: [0x62,0xe1,0xfc,0x48,0x78,0x42,0x80]
          vcvttpd2udq ymm16, zmmword ptr [rdx - 8192]

// CHECK: vcvttpd2udq ymm16, zmmword ptr [rdx - 8256]
// CHECK:  encoding: [0x62,0xe1,0xfc,0x48,0x78,0x82,0xc0,0xdf,0xff,0xff]
          vcvttpd2udq ymm16, zmmword ptr [rdx - 8256]

// CHECK: vcvttpd2udq ymm16, qword ptr [rdx + 1016]{1to8}
// CHECK:  encoding: [0x62,0xe1,0xfc,0x58,0x78,0x42,0x7f]
          vcvttpd2udq ymm16, qword ptr [rdx + 1016]{1to8}

// CHECK: vcvttpd2udq ymm16, qword ptr [rdx + 1024]{1to8}
// CHECK:  encoding: [0x62,0xe1,0xfc,0x58,0x78,0x82,0x00,0x04,0x00,0x00]
          vcvttpd2udq ymm16, qword ptr [rdx + 1024]{1to8}

// CHECK: vcvttpd2udq ymm16, qword ptr [rdx - 1024]{1to8}
// CHECK:  encoding: [0x62,0xe1,0xfc,0x58,0x78,0x42,0x80]
          vcvttpd2udq ymm16, qword ptr [rdx - 1024]{1to8}

// CHECK: vcvttpd2udq ymm16, qword ptr [rdx - 1032]{1to8}
// CHECK:  encoding: [0x62,0xe1,0xfc,0x58,0x78,0x82,0xf8,0xfb,0xff,0xff]
          vcvttpd2udq ymm16, qword ptr [rdx - 1032]{1to8}

// CHECK: vcvttps2udq zmm14, zmm28
// CHECK:  encoding: [0x62,0x11,0x7c,0x48,0x78,0xf4]
          vcvttps2udq zmm14, zmm28

// CHECK: vcvttps2udq zmm14 {k1}, zmm28
// CHECK:  encoding: [0x62,0x11,0x7c,0x49,0x78,0xf4]
          vcvttps2udq zmm14 {k1}, zmm28

// CHECK: vcvttps2udq zmm14 {k1} {z}, zmm28
// CHECK:  encoding: [0x62,0x11,0x7c,0xc9,0x78,0xf4]
          vcvttps2udq zmm14 {k1} {z}, zmm28

// CHECK: vcvttps2udq zmm14, zmm28, {sae}
// CHECK:  encoding: [0x62,0x11,0x7c,0x18,0x78,0xf4]
          vcvttps2udq zmm14, zmm28, {sae}

// CHECK: vcvttps2udq zmm14, zmmword ptr [rcx]
// CHECK:  encoding: [0x62,0x71,0x7c,0x48,0x78,0x31]
          vcvttps2udq zmm14, zmmword ptr [rcx]

// CHECK: vcvttps2udq zmm14, zmmword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0x31,0x7c,0x48,0x78,0xb4,0xf0,0x23,0x01,0x00,0x00]
          vcvttps2udq zmm14, zmmword ptr [rax + 8*r14 + 291]

// CHECK: vcvttps2udq zmm14, dword ptr [rcx]{1to16}
// CHECK:  encoding: [0x62,0x71,0x7c,0x58,0x78,0x31]
          vcvttps2udq zmm14, dword ptr [rcx]{1to16}

// CHECK: vcvttps2udq zmm14, zmmword ptr [rdx + 8128]
// CHECK:  encoding: [0x62,0x71,0x7c,0x48,0x78,0x72,0x7f]
          vcvttps2udq zmm14, zmmword ptr [rdx + 8128]

// CHECK: vcvttps2udq zmm14, zmmword ptr [rdx + 8192]
// CHECK:  encoding: [0x62,0x71,0x7c,0x48,0x78,0xb2,0x00,0x20,0x00,0x00]
          vcvttps2udq zmm14, zmmword ptr [rdx + 8192]

// CHECK: vcvttps2udq zmm14, zmmword ptr [rdx - 8192]
// CHECK:  encoding: [0x62,0x71,0x7c,0x48,0x78,0x72,0x80]
          vcvttps2udq zmm14, zmmword ptr [rdx - 8192]

// CHECK: vcvttps2udq zmm14, zmmword ptr [rdx - 8256]
// CHECK:  encoding: [0x62,0x71,0x7c,0x48,0x78,0xb2,0xc0,0xdf,0xff,0xff]
          vcvttps2udq zmm14, zmmword ptr [rdx - 8256]

// CHECK: vcvttps2udq zmm14, dword ptr [rdx + 508]{1to16}
// CHECK:  encoding: [0x62,0x71,0x7c,0x58,0x78,0x72,0x7f]
          vcvttps2udq zmm14, dword ptr [rdx + 508]{1to16}

// CHECK: vcvttps2udq zmm14, dword ptr [rdx + 512]{1to16}
// CHECK:  encoding: [0x62,0x71,0x7c,0x58,0x78,0xb2,0x00,0x02,0x00,0x00]
          vcvttps2udq zmm14, dword ptr [rdx + 512]{1to16}

// CHECK: vcvttps2udq zmm14, dword ptr [rdx - 512]{1to16}
// CHECK:  encoding: [0x62,0x71,0x7c,0x58,0x78,0x72,0x80]
          vcvttps2udq zmm14, dword ptr [rdx - 512]{1to16}

// CHECK: vcvttps2udq zmm14, dword ptr [rdx - 516]{1to16}
// CHECK:  encoding: [0x62,0x71,0x7c,0x58,0x78,0xb2,0xfc,0xfd,0xff,0xff]
          vcvttps2udq zmm14, dword ptr [rdx - 516]{1to16}

// CHECK: vcvttsd2usi eax, xmm21
// CHECK:  encoding: [0x62,0xb1,0x7f,0x08,0x78,0xc5]
          vcvttsd2usi eax, xmm21

// CHECK: vcvttsd2usi eax, xmm21, {sae}
// CHECK:  encoding: [0x62,0xb1,0x7f,0x18,0x78,0xc5]
          vcvttsd2usi eax, xmm21, {sae}

// CHECK: vcvttsd2usi eax, qword ptr [rcx]
// CHECK:  encoding: [0x62,0xf1,0x7f,0x08,0x78,0x01]
          vcvttsd2usi eax, qword ptr [rcx]

// CHECK: vcvttsd2usi eax, qword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0xb1,0x7f,0x08,0x78,0x84,0xf0,0x23,0x01,0x00,0x00]
          vcvttsd2usi eax, qword ptr [rax + 8*r14 + 291]

// CHECK: vcvttsd2usi eax, qword ptr [rdx + 1016]
// CHECK:  encoding: [0x62,0xf1,0x7f,0x08,0x78,0x42,0x7f]
          vcvttsd2usi eax, qword ptr [rdx + 1016]

// CHECK: vcvttsd2usi eax, qword ptr [rdx + 1024]
// CHECK:  encoding: [0x62,0xf1,0x7f,0x08,0x78,0x82,0x00,0x04,0x00,0x00]
          vcvttsd2usi eax, qword ptr [rdx + 1024]

// CHECK: vcvttsd2usi eax, qword ptr [rdx - 1024]
// CHECK:  encoding: [0x62,0xf1,0x7f,0x08,0x78,0x42,0x80]
          vcvttsd2usi eax, qword ptr [rdx - 1024]

// CHECK: vcvttsd2usi eax, qword ptr [rdx - 1032]
// CHECK:  encoding: [0x62,0xf1,0x7f,0x08,0x78,0x82,0xf8,0xfb,0xff,0xff]
          vcvttsd2usi eax, qword ptr [rdx - 1032]

// CHECK: vcvttsd2usi ebp, xmm21
// CHECK:  encoding: [0x62,0xb1,0x7f,0x08,0x78,0xed]
          vcvttsd2usi ebp, xmm21

// CHECK: vcvttsd2usi ebp, xmm21, {sae}
// CHECK:  encoding: [0x62,0xb1,0x7f,0x18,0x78,0xed]
          vcvttsd2usi ebp, xmm21, {sae}

// CHECK: vcvttsd2usi ebp, qword ptr [rcx]
// CHECK:  encoding: [0x62,0xf1,0x7f,0x08,0x78,0x29]
          vcvttsd2usi ebp, qword ptr [rcx]

// CHECK: vcvttsd2usi ebp, qword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0xb1,0x7f,0x08,0x78,0xac,0xf0,0x23,0x01,0x00,0x00]
          vcvttsd2usi ebp, qword ptr [rax + 8*r14 + 291]

// CHECK: vcvttsd2usi ebp, qword ptr [rdx + 1016]
// CHECK:  encoding: [0x62,0xf1,0x7f,0x08,0x78,0x6a,0x7f]
          vcvttsd2usi ebp, qword ptr [rdx + 1016]

// CHECK: vcvttsd2usi ebp, qword ptr [rdx + 1024]
// CHECK:  encoding: [0x62,0xf1,0x7f,0x08,0x78,0xaa,0x00,0x04,0x00,0x00]
          vcvttsd2usi ebp, qword ptr [rdx + 1024]

// CHECK: vcvttsd2usi ebp, qword ptr [rdx - 1024]
// CHECK:  encoding: [0x62,0xf1,0x7f,0x08,0x78,0x6a,0x80]
          vcvttsd2usi ebp, qword ptr [rdx - 1024]

// CHECK: vcvttsd2usi ebp, qword ptr [rdx - 1032]
// CHECK:  encoding: [0x62,0xf1,0x7f,0x08,0x78,0xaa,0xf8,0xfb,0xff,0xff]
          vcvttsd2usi ebp, qword ptr [rdx - 1032]

// CHECK: vcvttsd2usi r13d, xmm21
// CHECK:  encoding: [0x62,0x31,0x7f,0x08,0x78,0xed]
          vcvttsd2usi r13d, xmm21

// CHECK: vcvttsd2usi r13d, xmm21, {sae}
// CHECK:  encoding: [0x62,0x31,0x7f,0x18,0x78,0xed]
          vcvttsd2usi r13d, xmm21, {sae}

// CHECK: vcvttsd2usi r13d, qword ptr [rcx]
// CHECK:  encoding: [0x62,0x71,0x7f,0x08,0x78,0x29]
          vcvttsd2usi r13d, qword ptr [rcx]

// CHECK: vcvttsd2usi r13d, qword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0x31,0x7f,0x08,0x78,0xac,0xf0,0x23,0x01,0x00,0x00]
          vcvttsd2usi r13d, qword ptr [rax + 8*r14 + 291]

// CHECK: vcvttsd2usi r13d, qword ptr [rdx + 1016]
// CHECK:  encoding: [0x62,0x71,0x7f,0x08,0x78,0x6a,0x7f]
          vcvttsd2usi r13d, qword ptr [rdx + 1016]

// CHECK: vcvttsd2usi r13d, qword ptr [rdx + 1024]
// CHECK:  encoding: [0x62,0x71,0x7f,0x08,0x78,0xaa,0x00,0x04,0x00,0x00]
          vcvttsd2usi r13d, qword ptr [rdx + 1024]

// CHECK: vcvttsd2usi r13d, qword ptr [rdx - 1024]
// CHECK:  encoding: [0x62,0x71,0x7f,0x08,0x78,0x6a,0x80]
          vcvttsd2usi r13d, qword ptr [rdx - 1024]

// CHECK: vcvttsd2usi r13d, qword ptr [rdx - 1032]
// CHECK:  encoding: [0x62,0x71,0x7f,0x08,0x78,0xaa,0xf8,0xfb,0xff,0xff]
          vcvttsd2usi r13d, qword ptr [rdx - 1032]

// CHECK: vcvttsd2usi rax, xmm7
// CHECK:  encoding: [0x62,0xf1,0xff,0x08,0x78,0xc7]
          vcvttsd2usi rax, xmm7

// CHECK: vcvttsd2usi rax, xmm7, {sae}
// CHECK:  encoding: [0x62,0xf1,0xff,0x18,0x78,0xc7]
          vcvttsd2usi rax, xmm7, {sae}

// CHECK: vcvttsd2usi rax, qword ptr [rcx]
// CHECK:  encoding: [0x62,0xf1,0xff,0x08,0x78,0x01]
          vcvttsd2usi rax, qword ptr [rcx]

// CHECK: vcvttsd2usi rax, qword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0xb1,0xff,0x08,0x78,0x84,0xf0,0x23,0x01,0x00,0x00]
          vcvttsd2usi rax, qword ptr [rax + 8*r14 + 291]

// CHECK: vcvttsd2usi rax, qword ptr [rdx + 1016]
// CHECK:  encoding: [0x62,0xf1,0xff,0x08,0x78,0x42,0x7f]
          vcvttsd2usi rax, qword ptr [rdx + 1016]

// CHECK: vcvttsd2usi rax, qword ptr [rdx + 1024]
// CHECK:  encoding: [0x62,0xf1,0xff,0x08,0x78,0x82,0x00,0x04,0x00,0x00]
          vcvttsd2usi rax, qword ptr [rdx + 1024]

// CHECK: vcvttsd2usi rax, qword ptr [rdx - 1024]
// CHECK:  encoding: [0x62,0xf1,0xff,0x08,0x78,0x42,0x80]
          vcvttsd2usi rax, qword ptr [rdx - 1024]

// CHECK: vcvttsd2usi rax, qword ptr [rdx - 1032]
// CHECK:  encoding: [0x62,0xf1,0xff,0x08,0x78,0x82,0xf8,0xfb,0xff,0xff]
          vcvttsd2usi rax, qword ptr [rdx - 1032]

// CHECK: vcvttsd2usi r8, xmm7
// CHECK:  encoding: [0x62,0x71,0xff,0x08,0x78,0xc7]
          vcvttsd2usi r8, xmm7

// CHECK: vcvttsd2usi r8, xmm7, {sae}
// CHECK:  encoding: [0x62,0x71,0xff,0x18,0x78,0xc7]
          vcvttsd2usi r8, xmm7, {sae}

// CHECK: vcvttsd2usi r8, qword ptr [rcx]
// CHECK:  encoding: [0x62,0x71,0xff,0x08,0x78,0x01]
          vcvttsd2usi r8, qword ptr [rcx]

// CHECK: vcvttsd2usi r8, qword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0x31,0xff,0x08,0x78,0x84,0xf0,0x23,0x01,0x00,0x00]
          vcvttsd2usi r8, qword ptr [rax + 8*r14 + 291]

// CHECK: vcvttsd2usi r8, qword ptr [rdx + 1016]
// CHECK:  encoding: [0x62,0x71,0xff,0x08,0x78,0x42,0x7f]
          vcvttsd2usi r8, qword ptr [rdx + 1016]

// CHECK: vcvttsd2usi r8, qword ptr [rdx + 1024]
// CHECK:  encoding: [0x62,0x71,0xff,0x08,0x78,0x82,0x00,0x04,0x00,0x00]
          vcvttsd2usi r8, qword ptr [rdx + 1024]

// CHECK: vcvttsd2usi r8, qword ptr [rdx - 1024]
// CHECK:  encoding: [0x62,0x71,0xff,0x08,0x78,0x42,0x80]
          vcvttsd2usi r8, qword ptr [rdx - 1024]

// CHECK: vcvttsd2usi r8, qword ptr [rdx - 1032]
// CHECK:  encoding: [0x62,0x71,0xff,0x08,0x78,0x82,0xf8,0xfb,0xff,0xff]
          vcvttsd2usi r8, qword ptr [rdx - 1032]

// CHECK: vcvttss2usi eax, xmm18
// CHECK:  encoding: [0x62,0xb1,0x7e,0x08,0x78,0xc2]
          vcvttss2usi eax, xmm18

// CHECK: vcvttss2usi eax, xmm18, {sae}
// CHECK:  encoding: [0x62,0xb1,0x7e,0x18,0x78,0xc2]
          vcvttss2usi eax, xmm18, {sae}

// CHECK: vcvttss2usi eax, dword ptr [rcx]
// CHECK:  encoding: [0x62,0xf1,0x7e,0x08,0x78,0x01]
          vcvttss2usi eax, dword ptr [rcx]

// CHECK: vcvttss2usi eax, dword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0xb1,0x7e,0x08,0x78,0x84,0xf0,0x23,0x01,0x00,0x00]
          vcvttss2usi eax, dword ptr [rax + 8*r14 + 291]

// CHECK: vcvttss2usi eax, dword ptr [rdx + 508]
// CHECK:  encoding: [0x62,0xf1,0x7e,0x08,0x78,0x42,0x7f]
          vcvttss2usi eax, dword ptr [rdx + 508]

// CHECK: vcvttss2usi eax, dword ptr [rdx + 512]
// CHECK:  encoding: [0x62,0xf1,0x7e,0x08,0x78,0x82,0x00,0x02,0x00,0x00]
          vcvttss2usi eax, dword ptr [rdx + 512]

// CHECK: vcvttss2usi eax, dword ptr [rdx - 512]
// CHECK:  encoding: [0x62,0xf1,0x7e,0x08,0x78,0x42,0x80]
          vcvttss2usi eax, dword ptr [rdx - 512]

// CHECK: vcvttss2usi eax, dword ptr [rdx - 516]
// CHECK:  encoding: [0x62,0xf1,0x7e,0x08,0x78,0x82,0xfc,0xfd,0xff,0xff]
          vcvttss2usi eax, dword ptr [rdx - 516]

// CHECK: vcvttss2usi ebp, xmm18
// CHECK:  encoding: [0x62,0xb1,0x7e,0x08,0x78,0xea]
          vcvttss2usi ebp, xmm18

// CHECK: vcvttss2usi ebp, xmm18, {sae}
// CHECK:  encoding: [0x62,0xb1,0x7e,0x18,0x78,0xea]
          vcvttss2usi ebp, xmm18, {sae}

// CHECK: vcvttss2usi ebp, dword ptr [rcx]
// CHECK:  encoding: [0x62,0xf1,0x7e,0x08,0x78,0x29]
          vcvttss2usi ebp, dword ptr [rcx]

// CHECK: vcvttss2usi ebp, dword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0xb1,0x7e,0x08,0x78,0xac,0xf0,0x23,0x01,0x00,0x00]
          vcvttss2usi ebp, dword ptr [rax + 8*r14 + 291]

// CHECK: vcvttss2usi ebp, dword ptr [rdx + 508]
// CHECK:  encoding: [0x62,0xf1,0x7e,0x08,0x78,0x6a,0x7f]
          vcvttss2usi ebp, dword ptr [rdx + 508]

// CHECK: vcvttss2usi ebp, dword ptr [rdx + 512]
// CHECK:  encoding: [0x62,0xf1,0x7e,0x08,0x78,0xaa,0x00,0x02,0x00,0x00]
          vcvttss2usi ebp, dword ptr [rdx + 512]

// CHECK: vcvttss2usi ebp, dword ptr [rdx - 512]
// CHECK:  encoding: [0x62,0xf1,0x7e,0x08,0x78,0x6a,0x80]
          vcvttss2usi ebp, dword ptr [rdx - 512]

// CHECK: vcvttss2usi ebp, dword ptr [rdx - 516]
// CHECK:  encoding: [0x62,0xf1,0x7e,0x08,0x78,0xaa,0xfc,0xfd,0xff,0xff]
          vcvttss2usi ebp, dword ptr [rdx - 516]

// CHECK: vcvttss2usi r13d, xmm18
// CHECK:  encoding: [0x62,0x31,0x7e,0x08,0x78,0xea]
          vcvttss2usi r13d, xmm18

// CHECK: vcvttss2usi r13d, xmm18, {sae}
// CHECK:  encoding: [0x62,0x31,0x7e,0x18,0x78,0xea]
          vcvttss2usi r13d, xmm18, {sae}

// CHECK: vcvttss2usi r13d, dword ptr [rcx]
// CHECK:  encoding: [0x62,0x71,0x7e,0x08,0x78,0x29]
          vcvttss2usi r13d, dword ptr [rcx]

// CHECK: vcvttss2usi r13d, dword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0x31,0x7e,0x08,0x78,0xac,0xf0,0x23,0x01,0x00,0x00]
          vcvttss2usi r13d, dword ptr [rax + 8*r14 + 291]

// CHECK: vcvttss2usi r13d, dword ptr [rdx + 508]
// CHECK:  encoding: [0x62,0x71,0x7e,0x08,0x78,0x6a,0x7f]
          vcvttss2usi r13d, dword ptr [rdx + 508]

// CHECK: vcvttss2usi r13d, dword ptr [rdx + 512]
// CHECK:  encoding: [0x62,0x71,0x7e,0x08,0x78,0xaa,0x00,0x02,0x00,0x00]
          vcvttss2usi r13d, dword ptr [rdx + 512]

// CHECK: vcvttss2usi r13d, dword ptr [rdx - 512]
// CHECK:  encoding: [0x62,0x71,0x7e,0x08,0x78,0x6a,0x80]
          vcvttss2usi r13d, dword ptr [rdx - 512]

// CHECK: vcvttss2usi r13d, dword ptr [rdx - 516]
// CHECK:  encoding: [0x62,0x71,0x7e,0x08,0x78,0xaa,0xfc,0xfd,0xff,0xff]
          vcvttss2usi r13d, dword ptr [rdx - 516]

// CHECK: vcvttss2usi rax, xmm27
// CHECK:  encoding: [0x62,0x91,0xfe,0x08,0x78,0xc3]
          vcvttss2usi rax, xmm27

// CHECK: vcvttss2usi rax, xmm27, {sae}
// CHECK:  encoding: [0x62,0x91,0xfe,0x18,0x78,0xc3]
          vcvttss2usi rax, xmm27, {sae}

// CHECK: vcvttss2usi rax, dword ptr [rcx]
// CHECK:  encoding: [0x62,0xf1,0xfe,0x08,0x78,0x01]
          vcvttss2usi rax, dword ptr [rcx]

// CHECK: vcvttss2usi rax, dword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0xb1,0xfe,0x08,0x78,0x84,0xf0,0x23,0x01,0x00,0x00]
          vcvttss2usi rax, dword ptr [rax + 8*r14 + 291]

// CHECK: vcvttss2usi rax, dword ptr [rdx + 508]
// CHECK:  encoding: [0x62,0xf1,0xfe,0x08,0x78,0x42,0x7f]
          vcvttss2usi rax, dword ptr [rdx + 508]

// CHECK: vcvttss2usi rax, dword ptr [rdx + 512]
// CHECK:  encoding: [0x62,0xf1,0xfe,0x08,0x78,0x82,0x00,0x02,0x00,0x00]
          vcvttss2usi rax, dword ptr [rdx + 512]

// CHECK: vcvttss2usi rax, dword ptr [rdx - 512]
// CHECK:  encoding: [0x62,0xf1,0xfe,0x08,0x78,0x42,0x80]
          vcvttss2usi rax, dword ptr [rdx - 512]

// CHECK: vcvttss2usi rax, dword ptr [rdx - 516]
// CHECK:  encoding: [0x62,0xf1,0xfe,0x08,0x78,0x82,0xfc,0xfd,0xff,0xff]
          vcvttss2usi rax, dword ptr [rdx - 516]

// CHECK: vcvttss2usi r8, xmm27
// CHECK:  encoding: [0x62,0x11,0xfe,0x08,0x78,0xc3]
          vcvttss2usi r8, xmm27

// CHECK: vcvttss2usi r8, xmm27, {sae}
// CHECK:  encoding: [0x62,0x11,0xfe,0x18,0x78,0xc3]
          vcvttss2usi r8, xmm27, {sae}

// CHECK: vcvttss2usi r8, dword ptr [rcx]
// CHECK:  encoding: [0x62,0x71,0xfe,0x08,0x78,0x01]
          vcvttss2usi r8, dword ptr [rcx]

// CHECK: vcvttss2usi r8, dword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0x31,0xfe,0x08,0x78,0x84,0xf0,0x23,0x01,0x00,0x00]
          vcvttss2usi r8, dword ptr [rax + 8*r14 + 291]

// CHECK: vcvttss2usi r8, dword ptr [rdx + 508]
// CHECK:  encoding: [0x62,0x71,0xfe,0x08,0x78,0x42,0x7f]
          vcvttss2usi r8, dword ptr [rdx + 508]

// CHECK: vcvttss2usi r8, dword ptr [rdx + 512]
// CHECK:  encoding: [0x62,0x71,0xfe,0x08,0x78,0x82,0x00,0x02,0x00,0x00]
          vcvttss2usi r8, dword ptr [rdx + 512]

// CHECK: vcvttss2usi r8, dword ptr [rdx - 512]
// CHECK:  encoding: [0x62,0x71,0xfe,0x08,0x78,0x42,0x80]
          vcvttss2usi r8, dword ptr [rdx - 512]

// CHECK: vcvttss2usi r8, dword ptr [rdx - 516]
// CHECK:  encoding: [0x62,0x71,0xfe,0x08,0x78,0x82,0xfc,0xfd,0xff,0xff]
          vcvttss2usi r8, dword ptr [rdx - 516]

// CHECK: vpermi2d zmm10, zmm28, zmm4
// CHECK:  encoding: [0x62,0x72,0x1d,0x40,0x76,0xd4]
          vpermi2d zmm10, zmm28, zmm4

// CHECK: vpermi2d zmm10 {k5}, zmm28, zmm4
// CHECK:  encoding: [0x62,0x72,0x1d,0x45,0x76,0xd4]
          vpermi2d zmm10 {k5}, zmm28, zmm4

// CHECK: vpermi2d zmm10 {k5} {z}, zmm28, zmm4
// CHECK:  encoding: [0x62,0x72,0x1d,0xc5,0x76,0xd4]
          vpermi2d zmm10 {k5} {z}, zmm28, zmm4

// CHECK: vpermi2d zmm10, zmm28, zmmword ptr [rcx]
// CHECK:  encoding: [0x62,0x72,0x1d,0x40,0x76,0x11]
          vpermi2d zmm10, zmm28, zmmword ptr [rcx]

// CHECK: vpermi2d zmm10, zmm28, zmmword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0x32,0x1d,0x40,0x76,0x94,0xf0,0x23,0x01,0x00,0x00]
          vpermi2d zmm10, zmm28, zmmword ptr [rax + 8*r14 + 291]

// CHECK: vpermi2d zmm10, zmm28, dword ptr [rcx]{1to16}
// CHECK:  encoding: [0x62,0x72,0x1d,0x50,0x76,0x11]
          vpermi2d zmm10, zmm28, dword ptr [rcx]{1to16}

// CHECK: vpermi2d zmm10, zmm28, zmmword ptr [rdx + 8128]
// CHECK:  encoding: [0x62,0x72,0x1d,0x40,0x76,0x52,0x7f]
          vpermi2d zmm10, zmm28, zmmword ptr [rdx + 8128]

// CHECK: vpermi2d zmm10, zmm28, zmmword ptr [rdx + 8192]
// CHECK:  encoding: [0x62,0x72,0x1d,0x40,0x76,0x92,0x00,0x20,0x00,0x00]
          vpermi2d zmm10, zmm28, zmmword ptr [rdx + 8192]

// CHECK: vpermi2d zmm10, zmm28, zmmword ptr [rdx - 8192]
// CHECK:  encoding: [0x62,0x72,0x1d,0x40,0x76,0x52,0x80]
          vpermi2d zmm10, zmm28, zmmword ptr [rdx - 8192]

// CHECK: vpermi2d zmm10, zmm28, zmmword ptr [rdx - 8256]
// CHECK:  encoding: [0x62,0x72,0x1d,0x40,0x76,0x92,0xc0,0xdf,0xff,0xff]
          vpermi2d zmm10, zmm28, zmmword ptr [rdx - 8256]

// CHECK: vpermi2d zmm10, zmm28, dword ptr [rdx + 508]{1to16}
// CHECK:  encoding: [0x62,0x72,0x1d,0x50,0x76,0x52,0x7f]
          vpermi2d zmm10, zmm28, dword ptr [rdx + 508]{1to16}

// CHECK: vpermi2d zmm10, zmm28, dword ptr [rdx + 512]{1to16}
// CHECK:  encoding: [0x62,0x72,0x1d,0x50,0x76,0x92,0x00,0x02,0x00,0x00]
          vpermi2d zmm10, zmm28, dword ptr [rdx + 512]{1to16}

// CHECK: vpermi2d zmm10, zmm28, dword ptr [rdx - 512]{1to16}
// CHECK:  encoding: [0x62,0x72,0x1d,0x50,0x76,0x52,0x80]
          vpermi2d zmm10, zmm28, dword ptr [rdx - 512]{1to16}

// CHECK: vpermi2d zmm10, zmm28, dword ptr [rdx - 516]{1to16}
// CHECK:  encoding: [0x62,0x72,0x1d,0x50,0x76,0x92,0xfc,0xfd,0xff,0xff]
          vpermi2d zmm10, zmm28, dword ptr [rdx - 516]{1to16}

// CHECK: vpermi2q zmm18, zmm28, zmm28
// CHECK:  encoding: [0x62,0x82,0x9d,0x40,0x76,0xd4]
          vpermi2q zmm18, zmm28, zmm28

// CHECK: vpermi2q zmm18 {k2}, zmm28, zmm28
// CHECK:  encoding: [0x62,0x82,0x9d,0x42,0x76,0xd4]
          vpermi2q zmm18 {k2}, zmm28, zmm28

// CHECK: vpermi2q zmm18 {k2} {z}, zmm28, zmm28
// CHECK:  encoding: [0x62,0x82,0x9d,0xc2,0x76,0xd4]
          vpermi2q zmm18 {k2} {z}, zmm28, zmm28

// CHECK: vpermi2q zmm18, zmm28, zmmword ptr [rcx]
// CHECK:  encoding: [0x62,0xe2,0x9d,0x40,0x76,0x11]
          vpermi2q zmm18, zmm28, zmmword ptr [rcx]

// CHECK: vpermi2q zmm18, zmm28, zmmword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0xa2,0x9d,0x40,0x76,0x94,0xf0,0x23,0x01,0x00,0x00]
          vpermi2q zmm18, zmm28, zmmword ptr [rax + 8*r14 + 291]

// CHECK: vpermi2q zmm18, zmm28, qword ptr [rcx]{1to8}
// CHECK:  encoding: [0x62,0xe2,0x9d,0x50,0x76,0x11]
          vpermi2q zmm18, zmm28, qword ptr [rcx]{1to8}

// CHECK: vpermi2q zmm18, zmm28, zmmword ptr [rdx + 8128]
// CHECK:  encoding: [0x62,0xe2,0x9d,0x40,0x76,0x52,0x7f]
          vpermi2q zmm18, zmm28, zmmword ptr [rdx + 8128]

// CHECK: vpermi2q zmm18, zmm28, zmmword ptr [rdx + 8192]
// CHECK:  encoding: [0x62,0xe2,0x9d,0x40,0x76,0x92,0x00,0x20,0x00,0x00]
          vpermi2q zmm18, zmm28, zmmword ptr [rdx + 8192]

// CHECK: vpermi2q zmm18, zmm28, zmmword ptr [rdx - 8192]
// CHECK:  encoding: [0x62,0xe2,0x9d,0x40,0x76,0x52,0x80]
          vpermi2q zmm18, zmm28, zmmword ptr [rdx - 8192]

// CHECK: vpermi2q zmm18, zmm28, zmmword ptr [rdx - 8256]
// CHECK:  encoding: [0x62,0xe2,0x9d,0x40,0x76,0x92,0xc0,0xdf,0xff,0xff]
          vpermi2q zmm18, zmm28, zmmword ptr [rdx - 8256]

// CHECK: vpermi2q zmm18, zmm28, qword ptr [rdx + 1016]{1to8}
// CHECK:  encoding: [0x62,0xe2,0x9d,0x50,0x76,0x52,0x7f]
          vpermi2q zmm18, zmm28, qword ptr [rdx + 1016]{1to8}

// CHECK: vpermi2q zmm18, zmm28, qword ptr [rdx + 1024]{1to8}
// CHECK:  encoding: [0x62,0xe2,0x9d,0x50,0x76,0x92,0x00,0x04,0x00,0x00]
          vpermi2q zmm18, zmm28, qword ptr [rdx + 1024]{1to8}

// CHECK: vpermi2q zmm18, zmm28, qword ptr [rdx - 1024]{1to8}
// CHECK:  encoding: [0x62,0xe2,0x9d,0x50,0x76,0x52,0x80]
          vpermi2q zmm18, zmm28, qword ptr [rdx - 1024]{1to8}

// CHECK: vpermi2q zmm18, zmm28, qword ptr [rdx - 1032]{1to8}
// CHECK:  encoding: [0x62,0xe2,0x9d,0x50,0x76,0x92,0xf8,0xfb,0xff,0xff]
          vpermi2q zmm18, zmm28, qword ptr [rdx - 1032]{1to8}

// CHECK: vpermi2ps zmm24, zmm23, zmm8
// CHECK:  encoding: [0x62,0x42,0x45,0x40,0x77,0xc0]
          vpermi2ps zmm24, zmm23, zmm8

// CHECK: vpermi2ps zmm24 {k2}, zmm23, zmm8
// CHECK:  encoding: [0x62,0x42,0x45,0x42,0x77,0xc0]
          vpermi2ps zmm24 {k2}, zmm23, zmm8

// CHECK: vpermi2ps zmm24 {k2} {z}, zmm23, zmm8
// CHECK:  encoding: [0x62,0x42,0x45,0xc2,0x77,0xc0]
          vpermi2ps zmm24 {k2} {z}, zmm23, zmm8

// CHECK: vpermi2ps zmm24, zmm23, zmmword ptr [rcx]
// CHECK:  encoding: [0x62,0x62,0x45,0x40,0x77,0x01]
          vpermi2ps zmm24, zmm23, zmmword ptr [rcx]

// CHECK: vpermi2ps zmm24, zmm23, zmmword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0x22,0x45,0x40,0x77,0x84,0xf0,0x23,0x01,0x00,0x00]
          vpermi2ps zmm24, zmm23, zmmword ptr [rax + 8*r14 + 291]

// CHECK: vpermi2ps zmm24, zmm23, dword ptr [rcx]{1to16}
// CHECK:  encoding: [0x62,0x62,0x45,0x50,0x77,0x01]
          vpermi2ps zmm24, zmm23, dword ptr [rcx]{1to16}

// CHECK: vpermi2ps zmm24, zmm23, zmmword ptr [rdx + 8128]
// CHECK:  encoding: [0x62,0x62,0x45,0x40,0x77,0x42,0x7f]
          vpermi2ps zmm24, zmm23, zmmword ptr [rdx + 8128]

// CHECK: vpermi2ps zmm24, zmm23, zmmword ptr [rdx + 8192]
// CHECK:  encoding: [0x62,0x62,0x45,0x40,0x77,0x82,0x00,0x20,0x00,0x00]
          vpermi2ps zmm24, zmm23, zmmword ptr [rdx + 8192]

// CHECK: vpermi2ps zmm24, zmm23, zmmword ptr [rdx - 8192]
// CHECK:  encoding: [0x62,0x62,0x45,0x40,0x77,0x42,0x80]
          vpermi2ps zmm24, zmm23, zmmword ptr [rdx - 8192]

// CHECK: vpermi2ps zmm24, zmm23, zmmword ptr [rdx - 8256]
// CHECK:  encoding: [0x62,0x62,0x45,0x40,0x77,0x82,0xc0,0xdf,0xff,0xff]
          vpermi2ps zmm24, zmm23, zmmword ptr [rdx - 8256]

// CHECK: vpermi2ps zmm24, zmm23, dword ptr [rdx + 508]{1to16}
// CHECK:  encoding: [0x62,0x62,0x45,0x50,0x77,0x42,0x7f]
          vpermi2ps zmm24, zmm23, dword ptr [rdx + 508]{1to16}

// CHECK: vpermi2ps zmm24, zmm23, dword ptr [rdx + 512]{1to16}
// CHECK:  encoding: [0x62,0x62,0x45,0x50,0x77,0x82,0x00,0x02,0x00,0x00]
          vpermi2ps zmm24, zmm23, dword ptr [rdx + 512]{1to16}

// CHECK: vpermi2ps zmm24, zmm23, dword ptr [rdx - 512]{1to16}
// CHECK:  encoding: [0x62,0x62,0x45,0x50,0x77,0x42,0x80]
          vpermi2ps zmm24, zmm23, dword ptr [rdx - 512]{1to16}

// CHECK: vpermi2ps zmm24, zmm23, dword ptr [rdx - 516]{1to16}
// CHECK:  encoding: [0x62,0x62,0x45,0x50,0x77,0x82,0xfc,0xfd,0xff,0xff]
          vpermi2ps zmm24, zmm23, dword ptr [rdx - 516]{1to16}

// CHECK: vpermi2pd zmm20, zmm5, zmm20
// CHECK:  encoding: [0x62,0xa2,0xd5,0x48,0x77,0xe4]
          vpermi2pd zmm20, zmm5, zmm20

// CHECK: vpermi2pd zmm20 {k3}, zmm5, zmm20
// CHECK:  encoding: [0x62,0xa2,0xd5,0x4b,0x77,0xe4]
          vpermi2pd zmm20 {k3}, zmm5, zmm20

// CHECK: vpermi2pd zmm20 {k3} {z}, zmm5, zmm20
// CHECK:  encoding: [0x62,0xa2,0xd5,0xcb,0x77,0xe4]
          vpermi2pd zmm20 {k3} {z}, zmm5, zmm20

// CHECK: vpermi2pd zmm20, zmm5, zmmword ptr [rcx]
// CHECK:  encoding: [0x62,0xe2,0xd5,0x48,0x77,0x21]
          vpermi2pd zmm20, zmm5, zmmword ptr [rcx]

// CHECK: vpermi2pd zmm20, zmm5, zmmword ptr [rax + 8*r14 + 291]
// CHECK:  encoding: [0x62,0xa2,0xd5,0x48,0x77,0xa4,0xf0,0x23,0x01,0x00,0x00]
          vpermi2pd zmm20, zmm5, zmmword ptr [rax + 8*r14 + 291]

// CHECK: vpermi2pd zmm20, zmm5, qword ptr [rcx]{1to8}
// CHECK:  encoding: [0x62,0xe2,0xd5,0x58,0x77,0x21]
          vpermi2pd zmm20, zmm5, qword ptr [rcx]{1to8}

// CHECK: vpermi2pd zmm20, zmm5, zmmword ptr [rdx + 8128]
// CHECK:  encoding: [0x62,0xe2,0xd5,0x48,0x77,0x62,0x7f]
          vpermi2pd zmm20, zmm5, zmmword ptr [rdx + 8128]

// CHECK: vpermi2pd zmm20, zmm5, zmmword ptr [rdx + 8192]
// CHECK:  encoding: [0x62,0xe2,0xd5,0x48,0x77,0xa2,0x00,0x20,0x00,0x00]
          vpermi2pd zmm20, zmm5, zmmword ptr [rdx + 8192]

// CHECK: vpermi2pd zmm20, zmm5, zmmword ptr [rdx - 8192]
// CHECK:  encoding: [0x62,0xe2,0xd5,0x48,0x77,0x62,0x80]
          vpermi2pd zmm20, zmm5, zmmword ptr [rdx - 8192]

// CHECK: vpermi2pd zmm20, zmm5, zmmword ptr [rdx - 8256]
// CHECK:  encoding: [0x62,0xe2,0xd5,0x48,0x77,0xa2,0xc0,0xdf,0xff,0xff]
          vpermi2pd zmm20, zmm5, zmmword ptr [rdx - 8256]

// CHECK: vpermi2pd zmm20, zmm5, qword ptr [rdx + 1016]{1to8}
// CHECK:  encoding: [0x62,0xe2,0xd5,0x58,0x77,0x62,0x7f]
          vpermi2pd zmm20, zmm5, qword ptr [rdx + 1016]{1to8}

// CHECK: vpermi2pd zmm20, zmm5, qword ptr [rdx + 1024]{1to8}
// CHECK:  encoding: [0x62,0xe2,0xd5,0x58,0x77,0xa2,0x00,0x04,0x00,0x00]
          vpermi2pd zmm20, zmm5, qword ptr [rdx + 1024]{1to8}

// CHECK: vpermi2pd zmm20, zmm5, qword ptr [rdx - 1024]{1to8}
// CHECK:  encoding: [0x62,0xe2,0xd5,0x58,0x77,0x62,0x80]
          vpermi2pd zmm20, zmm5, qword ptr [rdx - 1024]{1to8}

// CHECK: vpermi2pd zmm20, zmm5, qword ptr [rdx - 1032]{1to8}
// CHECK:  encoding: [0x62,0xe2,0xd5,0x58,0x77,0xa2,0xf8,0xfb,0xff,0xff]
          vpermi2pd zmm20, zmm5, qword ptr [rdx - 1032]{1to8}

// CHECK: vaddpd zmm17, zmm11, zmm2
// CHECK:  encoding: [0x62,0xe1,0xa5,0x48,0x58,0xca]
          vaddpd zmm17, zmm11, zmm2

// CHECK: vaddpd zmm17 {k1}, zmm11, zmm2
// CHECK:  encoding: [0x62,0xe1,0xa5,0x49,0x58,0xca]
          vaddpd zmm17 {k1}, zmm11, zmm2

// CHECK: vaddpd zmm17 {k1} {z}, zmm11, zmm2
// CHECK:  encoding: [0x62,0xe1,0xa5,0xc9,0x58,0xca]
          vaddpd zmm17 {k1} {z}, zmm11, zmm2

// CHECK: vaddpd zmm17, zmm11, zmm2, {rn-sae}
// CHECK:  encoding: [0x62,0xe1,0xa5,0x18,0x58,0xca]
          vaddpd zmm17, zmm11, zmm2, {rn-sae}

// CHECK: vaddpd zmm17, zmm11, zmm2, {ru-sae}
// CHECK:  encoding: [0x62,0xe1,0xa5,0x58,0x58,0xca]
          vaddpd zmm17, zmm11, zmm2, {ru-sae}

// CHECK: vaddpd zmm17, zmm11, zmm2, {rd-sae}
// CHECK:  encoding: [0x62,0xe1,0xa5,0x38,0x58,0xca]
          vaddpd zmm17, zmm11, zmm2, {rd-sae}

// CHECK: vaddpd zmm17, zmm11, zmm2, {rz-sae}
// CHECK:  encoding: [0x62,0xe1,0xa5,0x78,0x58,0xca]
          vaddpd zmm17, zmm11, zmm2, {rz-sae}

// CHECK: vaddpd zmm17, zmm11, zmmword ptr [rcx]
// CHECK:  encoding: [0x62,0xe1,0xa5,0x48,0x58,0x09]
          vaddpd zmm17, zmm11, zmmword ptr [rcx]

// CHECK: vaddpd zmm17, zmm11, zmmword ptr [rax + 8*r14 + 4660]
// CHECK:  encoding: [0x62,0xa1,0xa5,0x48,0x58,0x8c,0xf0,0x34,0x12,0x00,0x00]
          vaddpd zmm17, zmm11, zmmword ptr [rax + 8*r14 + 4660]

// CHECK: vaddpd zmm17, zmm11, qword ptr [rcx]{1to8}
// CHECK:  encoding: [0x62,0xe1,0xa5,0x58,0x58,0x09]
          vaddpd zmm17, zmm11, qword ptr [rcx]{1to8}

// CHECK: vaddpd zmm17, zmm11, zmmword ptr [rdx + 8128]
// CHECK:  encoding: [0x62,0xe1,0xa5,0x48,0x58,0x4a,0x7f]
          vaddpd zmm17, zmm11, zmmword ptr [rdx + 8128]

// CHECK: vaddpd zmm17, zmm11, zmmword ptr [rdx + 8192]
// CHECK:  encoding: [0x62,0xe1,0xa5,0x48,0x58,0x8a,0x00,0x20,0x00,0x00]
          vaddpd zmm17, zmm11, zmmword ptr [rdx + 8192]

// CHECK: vaddpd zmm17, zmm11, zmmword ptr [rdx - 8192]
// CHECK:  encoding: [0x62,0xe1,0xa5,0x48,0x58,0x4a,0x80]
          vaddpd zmm17, zmm11, zmmword ptr [rdx - 8192]

// CHECK: vaddpd zmm17, zmm11, zmmword ptr [rdx - 8256]
// CHECK:  encoding: [0x62,0xe1,0xa5,0x48,0x58,0x8a,0xc0,0xdf,0xff,0xff]
          vaddpd zmm17, zmm11, zmmword ptr [rdx - 8256]

// CHECK: vaddpd zmm17, zmm11, qword ptr [rdx + 1016]{1to8}
// CHECK:  encoding: [0x62,0xe1,0xa5,0x58,0x58,0x4a,0x7f]
          vaddpd zmm17, zmm11, qword ptr [rdx + 1016]{1to8}

// CHECK: vaddpd zmm17, zmm11, qword ptr [rdx + 1024]{1to8}
// CHECK:  encoding: [0x62,0xe1,0xa5,0x58,0x58,0x8a,0x00,0x04,0x00,0x00]
          vaddpd zmm17, zmm11, qword ptr [rdx + 1024]{1to8}

// CHECK: vaddpd zmm17, zmm11, qword ptr [rdx - 1024]{1to8}
// CHECK:  encoding: [0x62,0xe1,0xa5,0x58,0x58,0x4a,0x80]
          vaddpd zmm17, zmm11, qword ptr [rdx - 1024]{1to8}

// CHECK: vaddpd zmm17, zmm11, qword ptr [rdx - 1032]{1to8}
// CHECK:  encoding: [0x62,0xe1,0xa5,0x58,0x58,0x8a,0xf8,0xfb,0xff,0xff]
          vaddpd zmm17, zmm11, qword ptr [rdx - 1032]{1to8}

// CHECK: vaddps zmm3, zmm6, zmm5
// CHECK:  encoding: [0x62,0xf1,0x4c,0x48,0x58,0xdd]
          vaddps zmm3, zmm6, zmm5

// CHECK: vaddps zmm3 {k1}, zmm6, zmm5
// CHECK:  encoding: [0x62,0xf1,0x4c,0x49,0x58,0xdd]
          vaddps zmm3 {k1}, zmm6, zmm5

// CHECK: vaddps zmm3 {k1} {z}, zmm6, zmm5
// CHECK:  encoding: [0x62,0xf1,0x4c,0xc9,0x58,0xdd]
          vaddps zmm3 {k1} {z}, zmm6, zmm5

// CHECK: vaddps zmm3, zmm6, zmm5, {rn-sae}
// CHECK:  encoding: [0x62,0xf1,0x4c,0x18,0x58,0xdd]
          vaddps zmm3, zmm6, zmm5, {rn-sae}

// CHECK: vaddps zmm3, zmm6, zmm5, {ru-sae}
// CHECK:  encoding: [0x62,0xf1,0x4c,0x58,0x58,0xdd]
          vaddps zmm3, zmm6, zmm5, {ru-sae}

// CHECK: vaddps zmm3, zmm6, zmm5, {rd-sae}
// CHECK:  encoding: [0x62,0xf1,0x4c,0x38,0x58,0xdd]
          vaddps zmm3, zmm6, zmm5, {rd-sae}

// CHECK: vaddps zmm3, zmm6, zmm5, {rz-sae}
// CHECK:  encoding: [0x62,0xf1,0x4c,0x78,0x58,0xdd]
          vaddps zmm3, zmm6, zmm5, {rz-sae}

// CHECK: vaddps zmm3, zmm6, zmmword ptr [rcx]
// CHECK:  encoding: [0x62,0xf1,0x4c,0x48,0x58,0x19]
          vaddps zmm3, zmm6, zmmword ptr [rcx]

// CHECK: vaddps zmm3, zmm6, zmmword ptr [rax + 8*r14 + 4660]
// CHECK:  encoding: [0x62,0xb1,0x4c,0x48,0x58,0x9c,0xf0,0x34,0x12,0x00,0x00]
          vaddps zmm3, zmm6, zmmword ptr [rax + 8*r14 + 4660]

// CHECK: vaddps zmm3, zmm6, dword ptr [rcx]{1to16}
// CHECK:  encoding: [0x62,0xf1,0x4c,0x58,0x58,0x19]
          vaddps zmm3, zmm6, dword ptr [rcx]{1to16}

// CHECK: vaddps zmm3, zmm6, zmmword ptr [rdx + 8128]
// CHECK:  encoding: [0x62,0xf1,0x4c,0x48,0x58,0x5a,0x7f]
          vaddps zmm3, zmm6, zmmword ptr [rdx + 8128]

// CHECK: vaddps zmm3, zmm6, zmmword ptr [rdx + 8192]
// CHECK:  encoding: [0x62,0xf1,0x4c,0x48,0x58,0x9a,0x00,0x20,0x00,0x00]
          vaddps zmm3, zmm6, zmmword ptr [rdx + 8192]

// CHECK: vaddps zmm3, zmm6, zmmword ptr [rdx - 8192]
// CHECK:  encoding: [0x62,0xf1,0x4c,0x48,0x58,0x5a,0x80]
          vaddps zmm3, zmm6, zmmword ptr [rdx - 8192]

// CHECK: vaddps zmm3, zmm6, zmmword ptr [rdx - 8256]
// CHECK:  encoding: [0x62,0xf1,0x4c,0x48,0x58,0x9a,0xc0,0xdf,0xff,0xff]
          vaddps zmm3, zmm6, zmmword ptr [rdx - 8256]

// CHECK: vaddps zmm3, zmm6, dword ptr [rdx + 508]{1to16}
// CHECK:  encoding: [0x62,0xf1,0x4c,0x58,0x58,0x5a,0x7f]
          vaddps zmm3, zmm6, dword ptr [rdx + 508]{1to16}

// CHECK: vaddps zmm3, zmm6, dword ptr [rdx + 512]{1to16}
// CHECK:  encoding: [0x62,0xf1,0x4c,0x58,0x58,0x9a,0x00,0x02,0x00,0x00]
          vaddps zmm3, zmm6, dword ptr [rdx + 512]{1to16}

// CHECK: vaddps zmm3, zmm6, dword ptr [rdx - 512]{1to16}
// CHECK:  encoding: [0x62,0xf1,0x4c,0x58,0x58,0x5a,0x80]
          vaddps zmm3, zmm6, dword ptr [rdx - 512]{1to16}

// CHECK: vaddps zmm3, zmm6, dword ptr [rdx - 516]{1to16}
// CHECK:  encoding: [0x62,0xf1,0x4c,0x58,0x58,0x9a,0xfc,0xfd,0xff,0xff]
          vaddps zmm3, zmm6, dword ptr [rdx - 516]{1to16}

// CHECK: vaddsd xmm1, xmm18, xmm27
// CHECK:  encoding: [0x62,0x91,0xef,0x00,0x58,0xcb]
          vaddsd xmm1, xmm18, xmm27

// CHECK: vaddsd xmm1 {k3}, xmm18, xmm27
// CHECK:  encoding: [0x62,0x91,0xef,0x03,0x58,0xcb]
          vaddsd xmm1 {k3}, xmm18, xmm27

// CHECK: vaddsd xmm1 {k3} {z}, xmm18, xmm27
// CHECK:  encoding: [0x62,0x91,0xef,0x83,0x58,0xcb]
          vaddsd xmm1 {k3} {z}, xmm18, xmm27

// CHECK: vaddsd xmm1, xmm18, xmm27, {rn-sae}
// CHECK:  encoding: [0x62,0x91,0xef,0x10,0x58,0xcb]
          vaddsd xmm1, xmm18, xmm27, {rn-sae}

// CHECK: vaddsd xmm1, xmm18, xmm27, {ru-sae}
// CHECK:  encoding: [0x62,0x91,0xef,0x50,0x58,0xcb]
          vaddsd xmm1, xmm18, xmm27, {ru-sae}

// CHECK: vaddsd xmm1, xmm18, xmm27, {rd-sae}
// CHECK:  encoding: [0x62,0x91,0xef,0x30,0x58,0xcb]
          vaddsd xmm1, xmm18, xmm27, {rd-sae}

// CHECK: vaddsd xmm1, xmm18, xmm27, {rz-sae}
// CHECK:  encoding: [0x62,0x91,0xef,0x70,0x58,0xcb]
          vaddsd xmm1, xmm18, xmm27, {rz-sae}

// CHECK: vaddsd xmm1, xmm18, qword ptr [rcx]
// CHECK:  encoding: [0x62,0xf1,0xef,0x00,0x58,0x09]
          vaddsd xmm1, xmm18, qword ptr [rcx]

// CHECK: vaddsd xmm1, xmm18, qword ptr [rax + 8*r14 + 4660]
// CHECK:  encoding: [0x62,0xb1,0xef,0x00,0x58,0x8c,0xf0,0x34,0x12,0x00,0x00]
          vaddsd xmm1, xmm18, qword ptr [rax + 8*r14 + 4660]

// CHECK: vaddsd xmm1, xmm18, qword ptr [rdx + 1016]
// CHECK:  encoding: [0x62,0xf1,0xef,0x00,0x58,0x4a,0x7f]
          vaddsd xmm1, xmm18, qword ptr [rdx + 1016]

// CHECK: vaddsd xmm1, xmm18, qword ptr [rdx + 1024]
// CHECK:  encoding: [0x62,0xf1,0xef,0x00,0x58,0x8a,0x00,0x04,0x00,0x00]
          vaddsd xmm1, xmm18, qword ptr [rdx + 1024]

// CHECK: vaddsd xmm1, xmm18, qword ptr [rdx - 1024]
// CHECK:  encoding: [0x62,0xf1,0xef,0x00,0x58,0x4a,0x80]
          vaddsd xmm1, xmm18, qword ptr [rdx - 1024]

// CHECK: vaddsd xmm1, xmm18, qword ptr [rdx - 1032]
// CHECK:  encoding: [0x62,0xf1,0xef,0x00,0x58,0x8a,0xf8,0xfb,0xff,0xff]
          vaddsd xmm1, xmm18, qword ptr [rdx - 1032]

// CHECK: vaddss xmm17, xmm14, xmm15
// CHECK:  encoding: [0x62,0xc1,0x0e,0x08,0x58,0xcf]
          vaddss xmm17, xmm14, xmm15

// CHECK: vaddss xmm17 {k4}, xmm14, xmm15
// CHECK:  encoding: [0x62,0xc1,0x0e,0x0c,0x58,0xcf]
          vaddss xmm17 {k4}, xmm14, xmm15

// CHECK: vaddss xmm17 {k4} {z}, xmm14, xmm15
// CHECK:  encoding: [0x62,0xc1,0x0e,0x8c,0x58,0xcf]
          vaddss xmm17 {k4} {z}, xmm14, xmm15

// CHECK: vaddss xmm17, xmm14, xmm15, {rn-sae}
// CHECK:  encoding: [0x62,0xc1,0x0e,0x18,0x58,0xcf]
          vaddss xmm17, xmm14, xmm15, {rn-sae}

// CHECK: vaddss xmm17, xmm14, xmm15, {ru-sae}
// CHECK:  encoding: [0x62,0xc1,0x0e,0x58,0x58,0xcf]
          vaddss xmm17, xmm14, xmm15, {ru-sae}

// CHECK: vaddss xmm17, xmm14, xmm15, {rd-sae}
// CHECK:  encoding: [0x62,0xc1,0x0e,0x38,0x58,0xcf]
          vaddss xmm17, xmm14, xmm15, {rd-sae}

// CHECK: vaddss xmm17, xmm14, xmm15, {rz-sae}
// CHECK:  encoding: [0x62,0xc1,0x0e,0x78,0x58,0xcf]
          vaddss xmm17, xmm14, xmm15, {rz-sae}

// CHECK: vaddss xmm17, xmm14, dword ptr [rcx]
// CHECK:  encoding: [0x62,0xe1,0x0e,0x08,0x58,0x09]
          vaddss xmm17, xmm14, dword ptr [rcx]

// CHECK: vaddss xmm17, xmm14, dword ptr [rax + 8*r14 + 4660]
// CHECK:  encoding: [0x62,0xa1,0x0e,0x08,0x58,0x8c,0xf0,0x34,0x12,0x00,0x00]
          vaddss xmm17, xmm14, dword ptr [rax + 8*r14 + 4660]

// CHECK: vaddss xmm17, xmm14, dword ptr [rdx + 508]
// CHECK:  encoding: [0x62,0xe1,0x0e,0x08,0x58,0x4a,0x7f]
          vaddss xmm17, xmm14, dword ptr [rdx + 508]

// CHECK: vaddss xmm17, xmm14, dword ptr [rdx + 512]
// CHECK:  encoding: [0x62,0xe1,0x0e,0x08,0x58,0x8a,0x00,0x02,0x00,0x00]
          vaddss xmm17, xmm14, dword ptr [rdx + 512]

// CHECK: vaddss xmm17, xmm14, dword ptr [rdx - 512]
// CHECK:  encoding: [0x62,0xe1,0x0e,0x08,0x58,0x4a,0x80]
          vaddss xmm17, xmm14, dword ptr [rdx - 512]

// CHECK: vaddss xmm17, xmm14, dword ptr [rdx - 516]
// CHECK:  encoding: [0x62,0xe1,0x0e,0x08,0x58,0x8a,0xfc,0xfd,0xff,0xff]
          vaddss xmm17, xmm14, dword ptr [rdx - 516]

// CHECK: valignd zmm15, zmm7, zmm5, 171
// CHECK:  encoding: [0x62,0x73,0x45,0x48,0x03,0xfd,0xab]
          valignd zmm15, zmm7, zmm5, 171

// CHECK: valignd zmm15 {k2}, zmm7, zmm5, 171
// CHECK:  encoding: [0x62,0x73,0x45,0x4a,0x03,0xfd,0xab]
          valignd zmm15 {k2}, zmm7, zmm5, 171

// CHECK: valignd zmm15 {k2} {z}, zmm7, zmm5, 171
// CHECK:  encoding: [0x62,0x73,0x45,0xca,0x03,0xfd,0xab]
          valignd zmm15 {k2} {z}, zmm7, zmm5, 171

// CHECK: valignd zmm15, zmm7, zmm5, 123
// CHECK:  encoding: [0x62,0x73,0x45,0x48,0x03,0xfd,0x7b]
          valignd zmm15, zmm7, zmm5, 123

// CHECK: valignd zmm15, zmm7, zmmword ptr [rcx], 123
// CHECK:  encoding: [0x62,0x73,0x45,0x48,0x03,0x39,0x7b]
          valignd zmm15, zmm7, zmmword ptr [rcx], 123

// CHECK: valignd zmm15, zmm7, zmmword ptr [rax + 8*r14 + 4660], 123
// CHECK:  encoding: [0x62,0x33,0x45,0x48,0x03,0xbc,0xf0,0x34,0x12,0x00,0x00,0x7b]
          valignd zmm15, zmm7, zmmword ptr [rax + 8*r14 + 4660], 123

// CHECK: valignd zmm15, zmm7, dword ptr [rcx]{1to16}, 123
// CHECK:  encoding: [0x62,0x73,0x45,0x58,0x03,0x39,0x7b]
          valignd zmm15, zmm7, dword ptr [rcx]{1to16}, 123

// CHECK: valignd zmm15, zmm7, zmmword ptr [rdx + 8128], 123
// CHECK:  encoding: [0x62,0x73,0x45,0x48,0x03,0x7a,0x7f,0x7b]
          valignd zmm15, zmm7, zmmword ptr [rdx + 8128], 123

// CHECK: valignd zmm15, zmm7, zmmword ptr [rdx + 8192], 123
// CHECK:  encoding: [0x62,0x73,0x45,0x48,0x03,0xba,0x00,0x20,0x00,0x00,0x7b]
          valignd zmm15, zmm7, zmmword ptr [rdx + 8192], 123

// CHECK: valignd zmm15, zmm7, zmmword ptr [rdx - 8192], 123
// CHECK:  encoding: [0x62,0x73,0x45,0x48,0x03,0x7a,0x80,0x7b]
          valignd zmm15, zmm7, zmmword ptr [rdx - 8192], 123

// CHECK: valignd zmm15, zmm7, zmmword ptr [rdx - 8256], 123
// CHECK:  encoding: [0x62,0x73,0x45,0x48,0x03,0xba,0xc0,0xdf,0xff,0xff,0x7b]
          valignd zmm15, zmm7, zmmword ptr [rdx - 8256], 123

// CHECK: valignd zmm15, zmm7, dword ptr [rdx + 508]{1to16}, 123
// CHECK:  encoding: [0x62,0x73,0x45,0x58,0x03,0x7a,0x7f,0x7b]
          valignd zmm15, zmm7, dword ptr [rdx + 508]{1to16}, 123

// CHECK: valignd zmm15, zmm7, dword ptr [rdx + 512]{1to16}, 123
// CHECK:  encoding: [0x62,0x73,0x45,0x58,0x03,0xba,0x00,0x02,0x00,0x00,0x7b]
          valignd zmm15, zmm7, dword ptr [rdx + 512]{1to16}, 123

// CHECK: valignd zmm15, zmm7, dword ptr [rdx - 512]{1to16}, 123
// CHECK:  encoding: [0x62,0x73,0x45,0x58,0x03,0x7a,0x80,0x7b]
          valignd zmm15, zmm7, dword ptr [rdx - 512]{1to16}, 123

// CHECK: valignd zmm15, zmm7, dword ptr [rdx - 516]{1to16}, 123
// CHECK:  encoding: [0x62,0x73,0x45,0x58,0x03,0xba,0xfc,0xfd,0xff,0xff,0x7b]
          valignd zmm15, zmm7, dword ptr [rdx - 516]{1to16}, 123

// CHECK: vblendmpd zmm23, zmm2, zmm8
// CHECK:  encoding: [0x62,0xc2,0xed,0x48,0x65,0xf8]
          vblendmpd zmm23, zmm2, zmm8

// CHECK: vblendmpd zmm23 {k7}, zmm2, zmm8
// CHECK:  encoding: [0x62,0xc2,0xed,0x4f,0x65,0xf8]
          vblendmpd zmm23 {k7}, zmm2, zmm8

// CHECK: vblendmpd zmm23 {k7} {z}, zmm2, zmm8
// CHECK:  encoding: [0x62,0xc2,0xed,0xcf,0x65,0xf8]
          vblendmpd zmm23 {k7} {z}, zmm2, zmm8

// CHECK: vblendmpd zmm23, zmm2, zmmword ptr [rcx]
// CHECK:  encoding: [0x62,0xe2,0xed,0x48,0x65,0x39]
          vblendmpd zmm23, zmm2, zmmword ptr [rcx]

// CHECK: vblendmpd zmm23, zmm2, zmmword ptr [rax + 8*r14 + 4660]
// CHECK:  encoding: [0x62,0xa2,0xed,0x48,0x65,0xbc,0xf0,0x34,0x12,0x00,0x00]
          vblendmpd zmm23, zmm2, zmmword ptr [rax + 8*r14 + 4660]

// CHECK: vblendmpd zmm23, zmm2, qword ptr [rcx]{1to8}
// CHECK:  encoding: [0x62,0xe2,0xed,0x58,0x65,0x39]
          vblendmpd zmm23, zmm2, qword ptr [rcx]{1to8}

// CHECK: vblendmpd zmm23, zmm2, zmmword ptr [rdx + 8128]
// CHECK:  encoding: [0x62,0xe2,0xed,0x48,0x65,0x7a,0x7f]
          vblendmpd zmm23, zmm2, zmmword ptr [rdx + 8128]

// CHECK: vblendmpd zmm23, zmm2, zmmword ptr [rdx + 8192]
// CHECK:  encoding: [0x62,0xe2,0xed,0x48,0x65,0xba,0x00,0x20,0x00,0x00]
          vblendmpd zmm23, zmm2, zmmword ptr [rdx + 8192]

// CHECK: vblendmpd zmm23, zmm2, zmmword ptr [rdx - 8192]
// CHECK:  encoding: [0x62,0xe2,0xed,0x48,0x65,0x7a,0x80]
          vblendmpd zmm23, zmm2, zmmword ptr [rdx - 8192]

// CHECK: vblendmpd zmm23, zmm2, zmmword ptr [rdx - 8256]
// CHECK:  encoding: [0x62,0xe2,0xed,0x48,0x65,0xba,0xc0,0xdf,0xff,0xff]
          vblendmpd zmm23, zmm2, zmmword ptr [rdx - 8256]

// CHECK: vblendmpd zmm23, zmm2, qword ptr [rdx + 1016]{1to8}
// CHECK:  encoding: [0x62,0xe2,0xed,0x58,0x65,0x7a,0x7f]
          vblendmpd zmm23, zmm2, qword ptr [rdx + 1016]{1to8}

// CHECK: vblendmpd zmm23, zmm2, qword ptr [rdx + 1024]{1to8}
// CHECK:  encoding: [0x62,0xe2,0xed,0x58,0x65,0xba,0x00,0x04,0x00,0x00]
          vblendmpd zmm23, zmm2, qword ptr [rdx + 1024]{1to8}

// CHECK: vblendmpd zmm23, zmm2, qword ptr [rdx - 1024]{1to8}
// CHECK:  encoding: [0x62,0xe2,0xed,0x58,0x65,0x7a,0x80]
          vblendmpd zmm23, zmm2, qword ptr [rdx - 1024]{1to8}

// CHECK: vblendmpd zmm23, zmm2, qword ptr [rdx - 1032]{1to8}
// CHECK:  encoding: [0x62,0xe2,0xed,0x58,0x65,0xba,0xf8,0xfb,0xff,0xff]
          vblendmpd zmm23, zmm2, qword ptr [rdx - 1032]{1to8}

// CHECK: vblendmps zmm23, zmm9, zmm7
// CHECK:  encoding: [0x62,0xe2,0x35,0x48,0x65,0xff]
          vblendmps zmm23, zmm9, zmm7

// CHECK: vblendmps zmm23 {k7}, zmm9, zmm7
// CHECK:  encoding: [0x62,0xe2,0x35,0x4f,0x65,0xff]
          vblendmps zmm23 {k7}, zmm9, zmm7

// CHECK: vblendmps zmm23 {k7} {z}, zmm9, zmm7
// CHECK:  encoding: [0x62,0xe2,0x35,0xcf,0x65,0xff]
          vblendmps zmm23 {k7} {z}, zmm9, zmm7

// CHECK: vblendmps zmm23, zmm9, zmmword ptr [rcx]
// CHECK:  encoding: [0x62,0xe2,0x35,0x48,0x65,0x39]
          vblendmps zmm23, zmm9, zmmword ptr [rcx]

// CHECK: vblendmps zmm23, zmm9, zmmword ptr [rax + 8*r14 + 4660]
// CHECK:  encoding: [0x62,0xa2,0x35,0x48,0x65,0xbc,0xf0,0x34,0x12,0x00,0x00]
          vblendmps zmm23, zmm9, zmmword ptr [rax + 8*r14 + 4660]

// CHECK: vblendmps zmm23, zmm9, dword ptr [rcx]{1to16}
// CHECK:  encoding: [0x62,0xe2,0x35,0x58,0x65,0x39]
          vblendmps zmm23, zmm9, dword ptr [rcx]{1to16}

// CHECK: vblendmps zmm23, zmm9, zmmword ptr [rdx + 8128]
// CHECK:  encoding: [0x62,0xe2,0x35,0x48,0x65,0x7a,0x7f]
          vblendmps zmm23, zmm9, zmmword ptr [rdx + 8128]

// CHECK: vblendmps zmm23, zmm9, zmmword ptr [rdx + 8192]
// CHECK:  encoding: [0x62,0xe2,0x35,0x48,0x65,0xba,0x00,0x20,0x00,0x00]
          vblendmps zmm23, zmm9, zmmword ptr [rdx + 8192]

// CHECK: vblendmps zmm23, zmm9, zmmword ptr [rdx - 8192]
// CHECK:  encoding: [0x62,0xe2,0x35,0x48,0x65,0x7a,0x80]
          vblendmps zmm23, zmm9, zmmword ptr [rdx - 8192]

// CHECK: vblendmps zmm23, zmm9, zmmword ptr [rdx - 8256]
// CHECK:  encoding: [0x62,0xe2,0x35,0x48,0x65,0xba,0xc0,0xdf,0xff,0xff]
          vblendmps zmm23, zmm9, zmmword ptr [rdx - 8256]

// CHECK: vblendmps zmm23, zmm9, dword ptr [rdx + 508]{1to16}
// CHECK:  encoding: [0x62,0xe2,0x35,0x58,0x65,0x7a,0x7f]
          vblendmps zmm23, zmm9, dword ptr [rdx + 508]{1to16}

// CHECK: vblendmps zmm23, zmm9, dword ptr [rdx + 512]{1to16}
// CHECK:  encoding: [0x62,0xe2,0x35,0x58,0x65,0xba,0x00,0x02,0x00,0x00]
          vblendmps zmm23, zmm9, dword ptr [rdx + 512]{1to16}

// CHECK: vblendmps zmm23, zmm9, dword ptr [rdx - 512]{1to16}
// CHECK:  encoding: [0x62,0xe2,0x35,0x58,0x65,0x7a,0x80]
          vblendmps zmm23, zmm9, dword ptr [rdx - 512]{1to16}

// CHECK: vblendmps zmm23, zmm9, dword ptr [rdx - 516]{1to16}
// CHECK:  encoding: [0x62,0xe2,0x35,0x58,0x65,0xba,0xfc,0xfd,0xff,0xff]
          vblendmps zmm23, zmm9, dword ptr [rdx - 516]{1to16}

// CHECK: vbroadcastf32x4 zmm15, xmmword ptr [rcx]
// CHECK:  encoding: [0x62,0x72,0x7d,0x48,0x1a,0x39]
          vbroadcastf32x4 zmm15, xmmword ptr [rcx]

// CHECK: vbroadcastf32x4 zmm15 {k3}, xmmword ptr [rcx]
// CHECK:  encoding: [0x62,0x72,0x7d,0x4b,0x1a,0x39]
          vbroadcastf32x4 zmm15 {k3}, xmmword ptr [rcx]

// CHECK: vbroadcastf32x4 zmm15 {k3} {z}, xmmword ptr [rcx]
// CHECK:  encoding: [0x62,0x72,0x7d,0xcb,0x1a,0x39]
          vbroadcastf32x4 zmm15 {k3} {z}, xmmword ptr [rcx]

// CHECK: vbroadcastf32x4 zmm15, xmmword ptr [rax + 8*r14 + 4660]
// CHECK:  encoding: [0x62,0x32,0x7d,0x48,0x1a,0xbc,0xf0,0x34,0x12,0x00,0x00]
          vbroadcastf32x4 zmm15, xmmword ptr [rax + 8*r14 + 4660]

// CHECK: vbroadcastf32x4 zmm15, xmmword ptr [rdx + 2032]
// CHECK:  encoding: [0x62,0x72,0x7d,0x48,0x1a,0x7a,0x7f]
          vbroadcastf32x4 zmm15, xmmword ptr [rdx + 2032]

// CHECK: vbroadcastf32x4 zmm15, xmmword ptr [rdx + 2048]
// CHECK:  encoding: [0x62,0x72,0x7d,0x48,0x1a,0xba,0x00,0x08,0x00,0x00]
          vbroadcastf32x4 zmm15, xmmword ptr [rdx + 2048]

// CHECK: vbroadcastf32x4 zmm15, xmmword ptr [rdx - 2048]
// CHECK:  encoding: [0x62,0x72,0x7d,0x48,0x1a,0x7a,0x80]
          vbroadcastf32x4 zmm15, xmmword ptr [rdx - 2048]

// CHECK: vbroadcastf32x4 zmm15, xmmword ptr [rdx - 2064]
// CHECK:  encoding: [0x62,0x72,0x7d,0x48,0x1a,0xba,0xf0,0xf7,0xff,0xff]
          vbroadcastf32x4 zmm15, xmmword ptr [rdx - 2064]

// CHECK: vbroadcastf64x4 zmm26, ymmword ptr [rcx]
// CHECK:  encoding: [0x62,0x62,0xfd,0x48,0x1b,0x11]
          vbroadcastf64x4 zmm26, ymmword ptr [rcx]

// CHECK: vbroadcastf64x4 zmm26 {k1}, ymmword ptr [rcx]
// CHECK:  encoding: [0x62,0x62,0xfd,0x49,0x1b,0x11]
          vbroadcastf64x4 zmm26 {k1}, ymmword ptr [rcx]

// CHECK: vbroadcastf64x4 zmm26 {k1} {z}, ymmword ptr [rcx]
// CHECK:  encoding: [0x62,0x62,0xfd,0xc9,0x1b,0x11]
          vbroadcastf64x4 zmm26 {k1} {z}, ymmword ptr [rcx]

// CHECK: vbroadcastf64x4 zmm26, ymmword ptr [rax + 8*r14 + 4660]
// CHECK:  encoding: [0x62,0x22,0xfd,0x48,0x1b,0x94,0xf0,0x34,0x12,0x00,0x00]
          vbroadcastf64x4 zmm26, ymmword ptr [rax + 8*r14 + 4660]

// CHECK: vbroadcastf64x4 zmm26, ymmword ptr [rdx + 4064]
// CHECK:  encoding: [0x62,0x62,0xfd,0x48,0x1b,0x52,0x7f]
          vbroadcastf64x4 zmm26, ymmword ptr [rdx + 4064]

// CHECK: vbroadcastf64x4 zmm26, ymmword ptr [rdx + 4096]
// CHECK:  encoding: [0x62,0x62,0xfd,0x48,0x1b,0x92,0x00,0x10,0x00,0x00]
          vbroadcastf64x4 zmm26, ymmword ptr [rdx + 4096]

// CHECK: vbroadcastf64x4 zmm26, ymmword ptr [rdx - 4096]
// CHECK:  encoding: [0x62,0x62,0xfd,0x48,0x1b,0x52,0x80]
          vbroadcastf64x4 zmm26, ymmword ptr [rdx - 4096]

// CHECK: vbroadcastf64x4 zmm26, ymmword ptr [rdx - 4128]
// CHECK:  encoding: [0x62,0x62,0xfd,0x48,0x1b,0x92,0xe0,0xef,0xff,0xff]
          vbroadcastf64x4 zmm26, ymmword ptr [rdx - 4128]

// CHECK: vbroadcasti32x4 zmm2, xmmword ptr [rcx]
// CHECK:  encoding: [0x62,0xf2,0x7d,0x48,0x5a,0x11]
          vbroadcasti32x4 zmm2, xmmword ptr [rcx]

// CHECK: vbroadcasti32x4 zmm2 {k5}, xmmword ptr [rcx]
// CHECK:  encoding: [0x62,0xf2,0x7d,0x4d,0x5a,0x11]
          vbroadcasti32x4 zmm2 {k5}, xmmword ptr [rcx]

// CHECK: vbroadcasti32x4 zmm2 {k5} {z}, xmmword ptr [rcx]
// CHECK:  encoding: [0x62,0xf2,0x7d,0xcd,0x5a,0x11]
          vbroadcasti32x4 zmm2 {k5} {z}, xmmword ptr [rcx]

// CHECK: vbroadcasti32x4 zmm2, xmmword ptr [rax + 8*r14 + 4660]
// CHECK:  encoding: [0x62,0xb2,0x7d,0x48,0x5a,0x94,0xf0,0x34,0x12,0x00,0x00]
          vbroadcasti32x4 zmm2, xmmword ptr [rax + 8*r14 + 4660]

// CHECK: vbroadcasti32x4 zmm2, xmmword ptr [rdx + 2032]
// CHECK:  encoding: [0x62,0xf2,0x7d,0x48,0x5a,0x52,0x7f]
          vbroadcasti32x4 zmm2, xmmword ptr [rdx + 2032]

// CHECK: vbroadcasti32x4 zmm2, xmmword ptr [rdx + 2048]
// CHECK:  encoding: [0x62,0xf2,0x7d,0x48,0x5a,0x92,0x00,0x08,0x00,0x00]
          vbroadcasti32x4 zmm2, xmmword ptr [rdx + 2048]

// CHECK: vbroadcasti32x4 zmm2, xmmword ptr [rdx - 2048]
// CHECK:  encoding: [0x62,0xf2,0x7d,0x48,0x5a,0x52,0x80]
          vbroadcasti32x4 zmm2, xmmword ptr [rdx - 2048]

// CHECK: vbroadcasti32x4 zmm2, xmmword ptr [rdx - 2064]
// CHECK:  encoding: [0x62,0xf2,0x7d,0x48,0x5a,0x92,0xf0,0xf7,0xff,0xff]
          vbroadcasti32x4 zmm2, xmmword ptr [rdx - 2064]

// CHECK: vbroadcasti64x4 zmm17, ymmword ptr [rcx]
// CHECK:  encoding: [0x62,0xe2,0xfd,0x48,0x5b,0x09]
          vbroadcasti64x4 zmm17, ymmword ptr [rcx]

// CHECK: vbroadcasti64x4 zmm17 {k2}, ymmword ptr [rcx]
// CHECK:  encoding: [0x62,0xe2,0xfd,0x4a,0x5b,0x09]
          vbroadcasti64x4 zmm17 {k2}, ymmword ptr [rcx]

// CHECK: vbroadcasti64x4 zmm17 {k2} {z}, ymmword ptr [rcx]
// CHECK:  encoding: [0x62,0xe2,0xfd,0xca,0x5b,0x09]
          vbroadcasti64x4 zmm17 {k2} {z}, ymmword ptr [rcx]

// CHECK: vbroadcasti64x4 zmm17, ymmword ptr [rax + 8*r14 + 4660]
// CHECK:  encoding: [0x62,0xa2,0xfd,0x48,0x5b,0x8c,0xf0,0x34,0x12,0x00,0x00]
          vbroadcasti64x4 zmm17, ymmword ptr [rax + 8*r14 + 4660]

// CHECK: vbroadcasti64x4 zmm17, ymmword ptr [rdx + 4064]
// CHECK:  encoding: [0x62,0xe2,0xfd,0x48,0x5b,0x4a,0x7f]
          vbroadcasti64x4 zmm17, ymmword ptr [rdx + 4064]

// CHECK: vbroadcasti64x4 zmm17, ymmword ptr [rdx + 4096]
// CHECK:  encoding: [0x62,0xe2,0xfd,0x48,0x5b,0x8a,0x00,0x10,0x00,0x00]
          vbroadcasti64x4 zmm17, ymmword ptr [rdx + 4096]

// CHECK: vbroadcasti64x4 zmm17, ymmword ptr [rdx - 4096]
// CHECK:  encoding: [0x62,0xe2,0xfd,0x48,0x5b,0x4a,0x80]
          vbroadcasti64x4 zmm17, ymmword ptr [rdx - 4096]

// CHECK: vbroadcasti64x4 zmm17, ymmword ptr [rdx - 4128]
// CHECK:  encoding: [0x62,0xe2,0xfd,0x48,0x5b,0x8a,0xe0,0xef,0xff,0xff]
          vbroadcasti64x4 zmm17, ymmword ptr [rdx - 4128]

// CHECK: vbroadcastsd zmm27, qword ptr [rcx]
// CHECK:  encoding: [0x62,0x62,0xfd,0x48,0x19,0x19]
          vbroadcastsd zmm27, qword ptr [rcx]

// CHECK: vbroadcastsd zmm27 {k7}, qword ptr [rcx]
// CHECK:  encoding: [0x62,0x62,0xfd,0x4f,0x19,0x19]
          vbroadcastsd zmm27 {k7}, qword ptr [rcx]

// CHECK: vbroadcastsd zmm27 {k7} {z}, qword ptr [rcx]
// CHECK:  encoding: [0x62,0x62,0xfd,0xcf,0x19,0x19]
          vbroadcastsd zmm27 {k7} {z}, qword ptr [rcx]

// CHECK: vbroadcastsd zmm27, qword ptr [rax + 8*r14 + 4660]
// CHECK:  encoding: [0x62,0x22,0xfd,0x48,0x19,0x9c,0xf0,0x34,0x12,0x00,0x00]
          vbroadcastsd zmm27, qword ptr [rax + 8*r14 + 4660]

// CHECK: vbroadcastsd zmm27, qword ptr [rdx + 1016]
// CHECK:  encoding: [0x62,0x62,0xfd,0x48,0x19,0x5a,0x7f]
          vbroadcastsd zmm27, qword ptr [rdx + 1016]

// CHECK: vbroadcastsd zmm27, qword ptr [rdx + 1024]
// CHECK:  encoding: [0x62,0x62,0xfd,0x48,0x19,0x9a,0x00,0x04,0x00,0x00]
          vbroadcastsd zmm27, qword ptr [rdx + 1024]

// CHECK: vbroadcastsd zmm27, qword ptr [rdx - 1024]
// CHECK:  encoding: [0x62,0x62,0xfd,0x48,0x19,0x5a,0x80]
          vbroadcastsd zmm27, qword ptr [rdx - 1024]

// CHECK: vbroadcastsd zmm27, qword ptr [rdx - 1032]
// CHECK:  encoding: [0x62,0x62,0xfd,0x48,0x19,0x9a,0xf8,0xfb,0xff,0xff]
          vbroadcastsd zmm27, qword ptr [rdx - 1032]

// CHECK: vbroadcastsd zmm19, xmm25
// CHECK:  encoding: [0x62,0x82,0xfd,0x48,0x19,0xd9]
          vbroadcastsd zmm19, xmm25

// CHECK: vbroadcastsd zmm19 {k3}, xmm25
// CHECK:  encoding: [0x62,0x82,0xfd,0x4b,0x19,0xd9]
          vbroadcastsd zmm19 {k3}, xmm25

// CHECK: vbroadcastsd zmm19 {k3} {z}, xmm25
// CHECK:  encoding: [0x62,0x82,0xfd,0xcb,0x19,0xd9]
          vbroadcastsd zmm19 {k3} {z}, xmm25

// CHECK: vbroadcastss zmm2, dword ptr [rcx]
// CHECK:  encoding: [0x62,0xf2,0x7d,0x48,0x18,0x11]
          vbroadcastss zmm2, dword ptr [rcx]

// CHECK: vbroadcastss zmm2 {k1}, dword ptr [rcx]
// CHECK:  encoding: [0x62,0xf2,0x7d,0x49,0x18,0x11]
          vbroadcastss zmm2 {k1}, dword ptr [rcx]

// CHECK: vbroadcastss zmm2 {k1} {z}, dword ptr [rcx]
// CHECK:  encoding: [0x62,0xf2,0x7d,0xc9,0x18,0x11]
          vbroadcastss zmm2 {k1} {z}, dword ptr [rcx]

// CHECK: vbroadcastss zmm2, dword ptr [rax + 8*r14 + 4660]
// CHECK:  encoding: [0x62,0xb2,0x7d,0x48,0x18,0x94,0xf0,0x34,0x12,0x00,0x00]
          vbroadcastss zmm2, dword ptr [rax + 8*r14 + 4660]

// CHECK: vbroadcastss zmm2, dword ptr [rdx + 508]
// CHECK:  encoding: [0x62,0xf2,0x7d,0x48,0x18,0x52,0x7f]
          vbroadcastss zmm2, dword ptr [rdx + 508]

// CHECK: vbroadcastss zmm2, dword ptr [rdx + 512]
// CHECK:  encoding: [0x62,0xf2,0x7d,0x48,0x18,0x92,0x00,0x02,0x00,0x00]
          vbroadcastss zmm2, dword ptr [rdx + 512]

// CHECK: vbroadcastss zmm2, dword ptr [rdx - 512]
// CHECK:  encoding: [0x62,0xf2,0x7d,0x48,0x18,0x52,0x80]
          vbroadcastss zmm2, dword ptr [rdx - 512]

// CHECK: vbroadcastss zmm2, dword ptr [rdx - 516]
// CHECK:  encoding: [0x62,0xf2,0x7d,0x48,0x18,0x92,0xfc,0xfd,0xff,0xff]
          vbroadcastss zmm2, dword ptr [rdx - 516]

// CHECK: vbroadcastss zmm23, xmm15
// CHECK:  encoding: [0x62,0xc2,0x7d,0x48,0x18,0xff]
          vbroadcastss zmm23, xmm15

// CHECK: vbroadcastss zmm23 {k4}, xmm15
// CHECK:  encoding: [0x62,0xc2,0x7d,0x4c,0x18,0xff]
          vbroadcastss zmm23 {k4}, xmm15

// CHECK: vbroadcastss zmm23 {k4} {z}, xmm15
// CHECK:  encoding: [0x62,0xc2,0x7d,0xcc,0x18,0xff]
          vbroadcastss zmm23 {k4} {z}, xmm15

// CHECK: vcmppd k5, zmm15, zmm16, 171
// CHECK:  encoding: [0x62,0xb1,0x85,0x48,0xc2,0xe8,0xab]
          vcmppd k5, zmm15, zmm16, 171

// CHECK: vcmppd k5 {k5}, zmm15, zmm16, 171
// CHECK:  encoding: [0x62,0xb1,0x85,0x4d,0xc2,0xe8,0xab]
          vcmppd k5 {k5}, zmm15, zmm16, 171

// CHECK: vcmppd k5, zmm15, zmm16, {sae}, 171
// CHECK:  encoding: [0x62,0xb1,0x85,0x18,0xc2,0xe8,0xab]
          vcmppd k5, zmm15, zmm16, {sae}, 171

// CHECK: vcmppd k5, zmm15, zmm16, 123
// CHECK:  encoding: [0x62,0xb1,0x85,0x48,0xc2,0xe8,0x7b]
          vcmppd k5, zmm15, zmm16, 123

// CHECK: vcmppd k5, zmm15, zmm16, {sae}, 123
// CHECK:  encoding: [0x62,0xb1,0x85,0x18,0xc2,0xe8,0x7b]
          vcmppd k5, zmm15, zmm16, {sae}, 123

// CHECK: vcmppd k5, zmm15, zmmword ptr [rcx], 123
// CHECK:  encoding: [0x62,0xf1,0x85,0x48,0xc2,0x29,0x7b]
          vcmppd k5, zmm15, zmmword ptr [rcx], 123

// CHECK: vcmppd k5, zmm15, zmmword ptr [rax + 8*r14 + 4660], 123
// CHECK:  encoding: [0x62,0xb1,0x85,0x48,0xc2,0xac,0xf0,0x34,0x12,0x00,0x00,0x7b]
          vcmppd k5, zmm15, zmmword ptr [rax + 8*r14 + 4660], 123

// CHECK: vcmppd k5, zmm15, qword ptr [rcx]{1to8}, 123
// CHECK:  encoding: [0x62,0xf1,0x85,0x58,0xc2,0x29,0x7b]
          vcmppd k5, zmm15, qword ptr [rcx]{1to8}, 123

// CHECK: vcmppd k5, zmm15, zmmword ptr [rdx + 8128], 123
// CHECK:  encoding: [0x62,0xf1,0x85,0x48,0xc2,0x6a,0x7f,0x7b]
          vcmppd k5, zmm15, zmmword ptr [rdx + 8128], 123

// CHECK: vcmppd k5, zmm15, zmmword ptr [rdx + 8192], 123
// CHECK:  encoding: [0x62,0xf1,0x85,0x48,0xc2,0xaa,0x00,0x20,0x00,0x00,0x7b]
          vcmppd k5, zmm15, zmmword ptr [rdx + 8192], 123

// CHECK: vcmppd k5, zmm15, zmmword ptr [rdx - 8192], 123
// CHECK:  encoding: [0x62,0xf1,0x85,0x48,0xc2,0x6a,0x80,0x7b]
          vcmppd k5, zmm15, zmmword ptr [rdx - 8192], 123

// CHECK: vcmppd k5, zmm15, zmmword ptr [rdx - 8256], 123
// CHECK:  encoding: [0x62,0xf1,0x85,0x48,0xc2,0xaa,0xc0,0xdf,0xff,0xff,0x7b]
          vcmppd k5, zmm15, zmmword ptr [rdx - 8256], 123

// CHECK: vcmppd k5, zmm15, qword ptr [rdx + 1016]{1to8}, 123
// CHECK:  encoding: [0x62,0xf1,0x85,0x58,0xc2,0x6a,0x7f,0x7b]
          vcmppd k5, zmm15, qword ptr [rdx + 1016]{1to8}, 123

// CHECK: vcmppd k5, zmm15, qword ptr [rdx + 1024]{1to8}, 123
// CHECK:  encoding: [0x62,0xf1,0x85,0x58,0xc2,0xaa,0x00,0x04,0x00,0x00,0x7b]
          vcmppd k5, zmm15, qword ptr [rdx + 1024]{1to8}, 123

// CHECK: vcmppd k5, zmm15, qword ptr [rdx - 1024]{1to8}, 123
// CHECK:  encoding: [0x62,0xf1,0x85,0x58,0xc2,0x6a,0x80,0x7b]
          vcmppd k5, zmm15, qword ptr [rdx - 1024]{1to8}, 123

// CHECK: vcmppd k5, zmm15, qword ptr [rdx - 1032]{1to8}, 123
// CHECK:  encoding: [0x62,0xf1,0x85,0x58,0xc2,0xaa,0xf8,0xfb,0xff,0xff,0x7b]
          vcmppd k5, zmm15, qword ptr [rdx - 1032]{1to8}, 123

// CHECK: vcmpps k2, zmm3, zmm29, 171
// CHECK:  encoding: [0x62,0x91,0x64,0x48,0xc2,0xd5,0xab]
          vcmpps k2, zmm3, zmm29, 171

// CHECK: vcmpps k2 {k5}, zmm3, zmm29, 171
// CHECK:  encoding: [0x62,0x91,0x64,0x4d,0xc2,0xd5,0xab]
          vcmpps k2 {k5}, zmm3, zmm29, 171

// CHECK: vcmpps k2, zmm3, zmm29, {sae}, 171
// CHECK:  encoding: [0x62,0x91,0x64,0x18,0xc2,0xd5,0xab]
          vcmpps k2, zmm3, zmm29, {sae}, 171

// CHECK: vcmpps k2, zmm3, zmm29, 123
// CHECK:  encoding: [0x62,0x91,0x64,0x48,0xc2,0xd5,0x7b]
          vcmpps k2, zmm3, zmm29, 123

// CHECK: vcmpps k2, zmm3, zmm29, {sae}, 123
// CHECK:  encoding: [0x62,0x91,0x64,0x18,0xc2,0xd5,0x7b]
          vcmpps k2, zmm3, zmm29, {sae}, 123

// CHECK: vcmpps k2, zmm3, zmmword ptr [rcx], 123
// CHECK:  encoding: [0x62,0xf1,0x64,0x48,0xc2,0x11,0x7b]
          vcmpps k2, zmm3, zmmword ptr [rcx], 123

// CHECK: vcmpps k2, zmm3, zmmword ptr [rax + 8*r14 + 4660], 123
// CHECK:  encoding: [0x62,0xb1,0x64,0x48,0xc2,0x94,0xf0,0x34,0x12,0x00,0x00,0x7b]
          vcmpps k2, zmm3, zmmword ptr [rax + 8*r14 + 4660], 123

// CHECK: vcmpps k2, zmm3, dword ptr [rcx]{1to16}, 123
// CHECK:  encoding: [0x62,0xf1,0x64,0x58,0xc2,0x11,0x7b]
          vcmpps k2, zmm3, dword ptr [rcx]{1to16}, 123

// CHECK: vcmpps k2, zmm3, zmmword ptr [rdx + 8128], 123
// CHECK:  encoding: [0x62,0xf1,0x64,0x48,0xc2,0x52,0x7f,0x7b]
          vcmpps k2, zmm3, zmmword ptr [rdx + 8128], 123

// CHECK: vcmpps k2, zmm3, zmmword ptr [rdx + 8192], 123
// CHECK:  encoding: [0x62,0xf1,0x64,0x48,0xc2,0x92,0x00,0x20,0x00,0x00,0x7b]
          vcmpps k2, zmm3, zmmword ptr [rdx + 8192], 123

// CHECK: vcmpps k2, zmm3, zmmword ptr [rdx - 8192], 123
// CHECK:  encoding: [0x62,0xf1,0x64,0x48,0xc2,0x52,0x80,0x7b]
          vcmpps k2, zmm3, zmmword ptr [rdx - 8192], 123

// CHECK: vcmpps k2, zmm3, zmmword ptr [rdx - 8256], 123
// CHECK:  encoding: [0x62,0xf1,0x64,0x48,0xc2,0x92,0xc0,0xdf,0xff,0xff,0x7b]
          vcmpps k2, zmm3, zmmword ptr [rdx - 8256], 123

// CHECK: vcmpps k2, zmm3, dword ptr [rdx + 508]{1to16}, 123
// CHECK:  encoding: [0x62,0xf1,0x64,0x58,0xc2,0x52,0x7f,0x7b]
          vcmpps k2, zmm3, dword ptr [rdx + 508]{1to16}, 123

// CHECK: vcmpps k2, zmm3, dword ptr [rdx + 512]{1to16}, 123
// CHECK:  encoding: [0x62,0xf1,0x64,0x58,0xc2,0x92,0x00,0x02,0x00,0x00,0x7b]
          vcmpps k2, zmm3, dword ptr [rdx + 512]{1to16}, 123

// CHECK: vcmpps k2, zmm3, dword ptr [rdx - 512]{1to16}, 123
// CHECK:  encoding: [0x62,0xf1,0x64,0x58,0xc2,0x52,0x80,0x7b]
          vcmpps k2, zmm3, dword ptr [rdx - 512]{1to16}, 123

// CHECK: vcmpps k2, zmm3, dword ptr [rdx - 516]{1to16}, 123
// CHECK:  encoding: [0x62,0xf1,0x64,0x58,0xc2,0x92,0xfc,0xfd,0xff,0xff,0x7b]
          vcmpps k2, zmm3, dword ptr [rdx - 516]{1to16}, 123

// CHECK: vcmpsd k4, xmm5, xmm6, 171
// CHECK:  encoding: [0x62,0xf1,0xd7,0x08,0xc2,0xe6,0xab]
          vcmpsd k4, xmm5, xmm6, 171

// CHECK: vcmpsd k4 {k5}, xmm5, xmm6, 171
// CHECK:  encoding: [0x62,0xf1,0xd7,0x0d,0xc2,0xe6,0xab]
          vcmpsd k4 {k5}, xmm5, xmm6, 171

// CHECK: vcmpsd k4, xmm5, xmm6, {sae}, 171
// CHECK:  encoding: [0x62,0xf1,0xd7,0x18,0xc2,0xe6,0xab]
          vcmpsd k4, xmm5, xmm6, {sae}, 171

// CHECK: vcmpsd k4, xmm5, xmm6, 123
// CHECK:  encoding: [0x62,0xf1,0xd7,0x08,0xc2,0xe6,0x7b]
          vcmpsd k4, xmm5, xmm6, 123

// CHECK: vcmpsd k4, xmm5, xmm6, {sae}, 123
// CHECK:  encoding: [0x62,0xf1,0xd7,0x18,0xc2,0xe6,0x7b]
          vcmpsd k4, xmm5, xmm6, {sae}, 123

// CHECK: vcmpsd k4, xmm5, qword ptr [rcx], 123
// CHECK:  encoding: [0x62,0xf1,0xd7,0x08,0xc2,0x21,0x7b]
          vcmpsd k4, xmm5, qword ptr [rcx], 123

// CHECK: vcmpsd k4, xmm5, qword ptr [rax + 8*r14 + 4660], 123
// CHECK:  encoding: [0x62,0xb1,0xd7,0x08,0xc2,0xa4,0xf0,0x34,0x12,0x00,0x00,0x7b]
          vcmpsd k4, xmm5, qword ptr [rax + 8*r14 + 4660], 123

// CHECK: vcmpsd k4, xmm5, qword ptr [rdx + 1016], 123
// CHECK:  encoding: [0x62,0xf1,0xd7,0x08,0xc2,0x62,0x7f,0x7b]
          vcmpsd k4, xmm5, qword ptr [rdx + 1016], 123

// CHECK: vcmpsd k4, xmm5, qword ptr [rdx + 1024], 123
// CHECK:  encoding: [0x62,0xf1,0xd7,0x08,0xc2,0xa2,0x00,0x04,0x00,0x00,0x7b]
          vcmpsd k4, xmm5, qword ptr [rdx + 1024], 123

// CHECK: vcmpsd k4, xmm5, qword ptr [rdx - 1024], 123
// CHECK:  encoding: [0x62,0xf1,0xd7,0x08,0xc2,0x62,0x80,0x7b]
          vcmpsd k4, xmm5, qword ptr [rdx - 1024], 123

// CHECK: vcmpsd k4, xmm5, qword ptr [rdx - 1032], 123
// CHECK:  encoding: [0x62,0xf1,0xd7,0x08,0xc2,0xa2,0xf8,0xfb,0xff,0xff,0x7b]
          vcmpsd k4, xmm5, qword ptr [rdx - 1032], 123

// CHECK: vcmpss k2, xmm19, xmm24, 171
// CHECK:  encoding: [0x62,0x91,0x66,0x00,0xc2,0xd0,0xab]
          vcmpss k2, xmm19, xmm24, 171

// CHECK: vcmpss k2 {k1}, xmm19, xmm24, 171
// CHECK:  encoding: [0x62,0x91,0x66,0x01,0xc2,0xd0,0xab]
          vcmpss k2 {k1}, xmm19, xmm24, 171

// CHECK: vcmpss k2, xmm19, xmm24, {sae}, 171
// CHECK:  encoding: [0x62,0x91,0x66,0x10,0xc2,0xd0,0xab]
          vcmpss k2, xmm19, xmm24, {sae}, 171

// CHECK: vcmpss k2, xmm19, xmm24, 123
// CHECK:  encoding: [0x62,0x91,0x66,0x00,0xc2,0xd0,0x7b]
          vcmpss k2, xmm19, xmm24, 123

// CHECK: vcmpss k2, xmm19, xmm24, {sae}, 123
// CHECK:  encoding: [0x62,0x91,0x66,0x10,0xc2,0xd0,0x7b]
          vcmpss k2, xmm19, xmm24, {sae}, 123

// CHECK: vcmpss k2, xmm19, dword ptr [rcx], 123
// CHECK:  encoding: [0x62,0xf1,0x66,0x00,0xc2,0x11,0x7b]
          vcmpss k2, xmm19, dword ptr [rcx], 123

// CHECK: vcmpss k2, xmm19, dword ptr [rax + 8*r14 + 4660], 123
// CHECK:  encoding: [0x62,0xb1,0x66,0x00,0xc2,0x94,0xf0,0x34,0x12,0x00,0x00,0x7b]
          vcmpss k2, xmm19, dword ptr [rax + 8*r14 + 4660], 123

// CHECK: vcmpss k2, xmm19, dword ptr [rdx + 508], 123
// CHECK:  encoding: [0x62,0xf1,0x66,0x00,0xc2,0x52,0x7f,0x7b]
          vcmpss k2, xmm19, dword ptr [rdx + 508], 123

// CHECK: vcmpss k2, xmm19, dword ptr [rdx + 512], 123
// CHECK:  encoding: [0x62,0xf1,0x66,0x00,0xc2,0x92,0x00,0x02,0x00,0x00,0x7b]
          vcmpss k2, xmm19, dword ptr [rdx + 512], 123

// CHECK: vcmpss k2, xmm19, dword ptr [rdx - 512], 123
// CHECK:  encoding: [0x62,0xf1,0x66,0x00,0xc2,0x52,0x80,0x7b]
          vcmpss k2, xmm19, dword ptr [rdx - 512], 123

// CHECK: vcmpss k2, xmm19, dword ptr [rdx - 516], 123
// CHECK:  encoding: [0x62,0xf1,0x66,0x00,0xc2,0x92,0xfc,0xfd,0xff,0xff,0x7b]
          vcmpss k2, xmm19, dword ptr [rdx - 516], 123

// CHECK: vcomisd xmm13, xmm11
// CHECK:  encoding: [0xc4,0x41,0x79,0x2f,0xeb]
          vcomisd xmm13, xmm11

// CHECK: vcomisd xmm13, xmm11, {sae}
// CHECK:  encoding: [0x62,0x51,0xfd,0x18,0x2f,0xeb]
          vcomisd xmm13, xmm11, {sae}

// CHECK: vcomisd xmm13, qword ptr [rcx]
// CHECK:  encoding: [0xc5,0x79,0x2f,0x29]
          vcomisd xmm13, qword ptr [rcx]

// CHECK: vcomisd xmm13, qword ptr [rax + 8*r14 + 4660]
// CHECK:  encoding: [0xc4,0x21,0x79,0x2f,0xac,0xf0,0x34,0x12,0x00,0x00]
          vcomisd xmm13, qword ptr [rax + 8*r14 + 4660]

// CHECK: vcomisd xmm13, qword ptr [rdx + 1016]
// CHECK:  encoding: [0xc5,0x79,0x2f,0xaa,0xf8,0x03,0x00,0x00]
          vcomisd xmm13, qword ptr [rdx + 1016]

// CHECK: vcomisd xmm13, qword ptr [rdx + 1024]
// CHECK:  encoding: [0xc5,0x79,0x2f,0xaa,0x00,0x04,0x00,0x00]
          vcomisd xmm13, qword ptr [rdx + 1024]

// CHECK: vcomisd xmm13, qword ptr [rdx - 1024]
// CHECK:  encoding: [0xc5,0x79,0x2f,0xaa,0x00,0xfc,0xff,0xff]
          vcomisd xmm13, qword ptr [rdx - 1024]

// CHECK: vcomisd xmm13, qword ptr [rdx - 1032]
// CHECK:  encoding: [0xc5,0x79,0x2f,0xaa,0xf8,0xfb,0xff,0xff]
          vcomisd xmm13, qword ptr [rdx - 1032]

// CHECK: vcomiss xmm8, xmm15
// CHECK:  encoding: [0xc4,0x41,0x78,0x2f,0xc7]
          vcomiss xmm8, xmm15

// CHECK: vcomiss xmm8, xmm15, {sae}
// CHECK:  encoding: [0x62,0x51,0x7c,0x18,0x2f,0xc7]
          vcomiss xmm8, xmm15, {sae}

// CHECK: vcomiss xmm8, dword ptr [rcx]
// CHECK:  encoding: [0xc5,0x78,0x2f,0x01]
          vcomiss xmm8, dword ptr [rcx]

// CHECK: vcomiss xmm8, dword ptr [rax + 8*r14 + 4660]
// CHECK:  encoding: [0xc4,0x21,0x78,0x2f,0x84,0xf0,0x34,0x12,0x00,0x00]
          vcomiss xmm8, dword ptr [rax + 8*r14 + 4660]

// CHECK: vcomiss xmm8, dword ptr [rdx + 508]
// CHECK:  encoding: [0xc5,0x78,0x2f,0x82,0xfc,0x01,0x00,0x00]
          vcomiss xmm8, dword ptr [rdx + 508]

// CHECK: vcomiss xmm8, dword ptr [rdx + 512]
// CHECK:  encoding: [0xc5,0x78,0x2f,0x82,0x00,0x02,0x00,0x00]
          vcomiss xmm8, dword ptr [rdx + 512]

// CHECK: vcomiss xmm8, dword ptr [rdx - 512]
// CHECK:  encoding: [0xc5,0x78,0x2f,0x82,0x00,0xfe,0xff,0xff]
          vcomiss xmm8, dword ptr [rdx - 512]

// CHECK: vcomiss xmm8, dword ptr [rdx - 516]
// CHECK:  encoding: [0xc5,0x78,0x2f,0x82,0xfc,0xfd,0xff,0xff]
          vcomiss xmm8, dword ptr [rdx - 516]

// CHECK: vcompresspd zmmword ptr [rcx], zmm30
// CHECK:  encoding: [0x62,0x62,0xfd,0x48,0x8a,0x31]
          vcompresspd zmmword ptr [rcx], zmm30

// CHECK: vcompresspd zmmword ptr [rcx] {k7}, zmm30
// CHECK:  encoding: [0x62,0x62,0xfd,0x4f,0x8a,0x31]
          vcompresspd zmmword ptr [rcx] {k7}, zmm30

// CHECK: vcompresspd zmmword ptr [rax + 8*r14 + 4660], zmm30
// CHECK:  encoding: [0x62,0x22,0xfd,0x48,0x8a,0xb4,0xf0,0x34,0x12,0x00,0x00]
          vcompresspd zmmword ptr [rax + 8*r14 + 4660], zmm30

// CHECK: vcompresspd zmmword ptr [rdx + 1016], zmm30
// CHECK:  encoding: [0x62,0x62,0xfd,0x48,0x8a,0x72,0x7f]
          vcompresspd zmmword ptr [rdx + 1016], zmm30

// CHECK: vcompresspd zmmword ptr [rdx + 1024], zmm30
// CHECK:  encoding: [0x62,0x62,0xfd,0x48,0x8a,0xb2,0x00,0x04,0x00,0x00]
          vcompresspd zmmword ptr [rdx + 1024], zmm30

// CHECK: vcompresspd zmmword ptr [rdx - 1024], zmm30
// CHECK:  encoding: [0x62,0x62,0xfd,0x48,0x8a,0x72,0x80]
          vcompresspd zmmword ptr [rdx - 1024], zmm30

// CHECK: vcompresspd zmmword ptr [rdx - 1032], zmm30
// CHECK:  encoding: [0x62,0x62,0xfd,0x48,0x8a,0xb2,0xf8,0xfb,0xff,0xff]
          vcompresspd zmmword ptr [rdx - 1032], zmm30

// CHECK: vcompresspd zmm1, zmm25
// CHECK:  encoding: [0x62,0x62,0xfd,0x48,0x8a,0xc9]
          vcompresspd zmm1, zmm25

// CHECK: vcompresspd zmm1 {k4}, zmm25
// CHECK:  encoding: [0x62,0x62,0xfd,0x4c,0x8a,0xc9]
          vcompresspd zmm1 {k4}, zmm25

// CHECK: vcompresspd zmm1 {k4} {z}, zmm25
// CHECK:  encoding: [0x62,0x62,0xfd,0xcc,0x8a,0xc9]
          vcompresspd zmm1 {k4} {z}, zmm25

// CHECK: vcompressps zmmword ptr [rcx], zmm10
// CHECK:  encoding: [0x62,0x72,0x7d,0x48,0x8a,0x11]
          vcompressps zmmword ptr [rcx], zmm10

// CHECK: vcompressps zmmword ptr [rcx] {k4}, zmm10
// CHECK:  encoding: [0x62,0x72,0x7d,0x4c,0x8a,0x11]
          vcompressps zmmword ptr [rcx] {k4}, zmm10

// CHECK: vcompressps zmmword ptr [rax + 8*r14 + 4660], zmm10
// CHECK:  encoding: [0x62,0x32,0x7d,0x48,0x8a,0x94,0xf0,0x34,0x12,0x00,0x00]
          vcompressps zmmword ptr [rax + 8*r14 + 4660], zmm10

// CHECK: vcompressps zmmword ptr [rdx + 508], zmm10
// CHECK:  encoding: [0x62,0x72,0x7d,0x48,0x8a,0x52,0x7f]
          vcompressps zmmword ptr [rdx + 508], zmm10

// CHECK: vcompressps zmmword ptr [rdx + 512], zmm10
// CHECK:  encoding: [0x62,0x72,0x7d,0x48,0x8a,0x92,0x00,0x02,0x00,0x00]
          vcompressps zmmword ptr [rdx + 512], zmm10

// CHECK: vcompressps zmmword ptr [rdx - 512], zmm10
// CHECK:  encoding: [0x62,0x72,0x7d,0x48,0x8a,0x52,0x80]
          vcompressps zmmword ptr [rdx - 512], zmm10

// CHECK: vcompressps zmmword ptr [rdx - 516], zmm10
// CHECK:  encoding: [0x62,0x72,0x7d,0x48,0x8a,0x92,0xfc,0xfd,0xff,0xff]
          vcompressps zmmword ptr [rdx - 516], zmm10

// CHECK: vcompressps zmm19, zmm7
// CHECK:  encoding: [0x62,0xb2,0x7d,0x48,0x8a,0xfb]
          vcompressps zmm19, zmm7

// CHECK: vcompressps zmm19 {k3}, zmm7
// CHECK:  encoding: [0x62,0xb2,0x7d,0x4b,0x8a,0xfb]
          vcompressps zmm19 {k3}, zmm7

// CHECK: vcompressps zmm19 {k3} {z}, zmm7
// CHECK:  encoding: [0x62,0xb2,0x7d,0xcb,0x8a,0xfb]
          vcompressps zmm19 {k3} {z}, zmm7

// CHECK: vcvtdq2pd zmm28, ymm20
// CHECK:  encoding: [0x62,0x21,0x7e,0x48,0xe6,0xe4]
          vcvtdq2pd zmm28, ymm20

// CHECK: vcvtdq2pd zmm28 {k2}, ymm20
// CHECK:  encoding: [0x62,0x21,0x7e,0x4a,0xe6,0xe4]
          vcvtdq2pd zmm28 {k2}, ymm20

// CHECK: vcvtdq2pd zmm28 {k2} {z}, ymm20
// CHECK:  encoding: [0x62,0x21,0x7e,0xca,0xe6,0xe4]
          vcvtdq2pd zmm28 {k2} {z}, ymm20

// CHECK: vcvtdq2pd zmm28, ymmword ptr [rcx]
// CHECK:  encoding: [0x62,0x61,0x7e,0x48,0xe6,0x21]
          vcvtdq2pd zmm28, ymmword ptr [rcx]

// CHECK: vcvtdq2pd zmm28, ymmword ptr [rax + 8*r14 + 4660]
// CHECK:  encoding: [0x62,0x21,0x7e,0x48,0xe6,0xa4,0xf0,0x34,0x12,0x00,0x00]
          vcvtdq2pd zmm28, ymmword ptr [rax + 8*r14 + 4660]

// CHECK: vcvtdq2pd zmm28, dword ptr [rcx]{1to8}
// CHECK:  encoding: [0x62,0x61,0x7e,0x58,0xe6,0x21]
          vcvtdq2pd zmm28, dword ptr [rcx]{1to8}

// CHECK: vcvtdq2pd zmm28, ymmword ptr [rdx + 4064]
// CHECK:  encoding: [0x62,0x61,0x7e,0x48,0xe6,0x62,0x7f]
          vcvtdq2pd zmm28, ymmword ptr [rdx + 4064]

// CHECK: vcvtdq2pd zmm28, ymmword ptr [rdx + 4096]
// CHECK:  encoding: [0x62,0x61,0x7e,0x48,0xe6,0xa2,0x00,0x10,0x00,0x00]
          vcvtdq2pd zmm28, ymmword ptr [rdx + 4096]

// CHECK: vcvtdq2pd zmm28, ymmword ptr [rdx - 4096]
// CHECK:  encoding: [0x62,0x61,0x7e,0x48,0xe6,0x62,0x80]
          vcvtdq2pd zmm28, ymmword ptr [rdx - 4096]

// CHECK: vcvtdq2pd zmm28, ymmword ptr [rdx - 4128]
// CHECK:  encoding: [0x62,0x61,0x7e,0x48,0xe6,0xa2,0xe0,0xef,0xff,0xff]
          vcvtdq2pd zmm28, ymmword ptr [rdx - 4128]

// CHECK: vcvtdq2pd zmm28, dword ptr [rdx + 508]{1to8}
// CHECK:  encoding: [0x62,0x61,0x7e,0x58,0xe6,0x62,0x7f]
          vcvtdq2pd zmm28, dword ptr [rdx + 508]{1to8}

// CHECK: vcvtdq2pd zmm28, dword ptr [rdx + 512]{1to8}
// CHECK:  encoding: [0x62,0x61,0x7e,0x58,0xe6,0xa2,0x00,0x02,0x00,0x00]
          vcvtdq2pd zmm28, dword ptr [rdx + 512]{1to8}

// CHECK: vcvtdq2pd zmm28, dword ptr [rdx - 512]{1to8}
// CHECK:  encoding: [0x62,0x61,0x7e,0x58,0xe6,0x62,0x80]
          vcvtdq2pd zmm28, dword ptr [rdx - 512]{1to8}

// CHECK: vcvtdq2pd zmm28, dword ptr [rdx - 516]{1to8}
// CHECK:  encoding: [0x62,0x61,0x7e,0x58,0xe6,0xa2,0xfc,0xfd,0xff,0xff]
          vcvtdq2pd zmm28, dword ptr [rdx - 516]{1to8}

// CHECK: vcvtdq2ps zmm19, zmm4
// CHECK:  encoding: [0x62,0xe1,0x7c,0x48,0x5b,0xdc]
          vcvtdq2ps zmm19, zmm4

// CHECK: vcvtdq2ps zmm19 {k5}, zmm4
// CHECK:  encoding: [0x62,0xe1,0x7c,0x4d,0x5b,0xdc]
          vcvtdq2ps zmm19 {k5}, zmm4

// CHECK: vcvtdq2ps zmm19 {k5} {z}, zmm4
// CHECK:  encoding: [0x62,0xe1,0x7c,0xcd,0x5b,0xdc]
          vcvtdq2ps zmm19 {k5} {z}, zmm4

// CHECK: vcvtdq2ps zmm19, zmm4, {rn-sae}
// CHECK:  encoding: [0x62,0xe1,0x7c,0x18,0x5b,0xdc]
          vcvtdq2ps zmm19, zmm4, {rn-sae}

// CHECK: vcvtdq2ps zmm19, zmm4, {ru-sae}
// CHECK:  encoding: [0x62,0xe1,0x7c,0x58,0x5b,0xdc]
          vcvtdq2ps zmm19, zmm4, {ru-sae}

// CHECK: vcvtdq2ps zmm19, zmm4, {rd-sae}
// CHECK:  encoding: [0x62,0xe1,0x7c,0x38,0x5b,0xdc]
          vcvtdq2ps zmm19, zmm4, {rd-sae}

// CHECK: vcvtdq2ps zmm19, zmm4, {rz-sae}
// CHECK:  encoding: [0x62,0xe1,0x7c,0x78,0x5b,0xdc]
          vcvtdq2ps zmm19, zmm4, {rz-sae}

// CHECK: vcvtdq2ps zmm19, zmmword ptr [rcx]
// CHECK:  encoding: [0x62,0xe1,0x7c,0x48,0x5b,0x19]
          vcvtdq2ps zmm19, zmmword ptr [rcx]

// CHECK: vcvtdq2ps zmm19, zmmword ptr [rax + 8*r14 + 4660]
// CHECK:  encoding: [0x62,0xa1,0x7c,0x48,0x5b,0x9c,0xf0,0x34,0x12,0x00,0x00]
          vcvtdq2ps zmm19, zmmword ptr [rax + 8*r14 + 4660]

// CHECK: vcvtdq2ps zmm19, dword ptr [rcx]{1to16}
// CHECK:  encoding: [0x62,0xe1,0x7c,0x58,0x5b,0x19]
          vcvtdq2ps zmm19, dword ptr [rcx]{1to16}

// CHECK: vcvtdq2ps zmm19, zmmword ptr [rdx + 8128]
// CHECK:  encoding: [0x62,0xe1,0x7c,0x48,0x5b,0x5a,0x7f]
          vcvtdq2ps zmm19, zmmword ptr [rdx + 8128]

// CHECK: vcvtdq2ps zmm19, zmmword ptr [rdx + 8192]
// CHECK:  encoding: [0x62,0xe1,0x7c,0x48,0x5b,0x9a,0x00,0x20,0x00,0x00]
          vcvtdq2ps zmm19, zmmword ptr [rdx + 8192]

// CHECK: vcvtdq2ps zmm19, zmmword ptr [rdx - 8192]
// CHECK:  encoding: [0x62,0xe1,0x7c,0x48,0x5b,0x5a,0x80]
          vcvtdq2ps zmm19, zmmword ptr [rdx - 8192]

// CHECK: vcvtdq2ps zmm19, zmmword ptr [rdx - 8256]
// CHECK:  encoding: [0x62,0xe1,0x7c,0x48,0x5b,0x9a,0xc0,0xdf,0xff,0xff]
          vcvtdq2ps zmm19, zmmword ptr [rdx - 8256]

// CHECK: vcvtdq2ps zmm19, dword ptr [rdx + 508]{1to16}
// CHECK:  encoding: [0x62,0xe1,0x7c,0x58,0x5b,0x5a,0x7f]
          vcvtdq2ps zmm19, dword ptr [rdx + 508]{1to16}

// CHECK: vcvtdq2ps zmm19, dword ptr [rdx + 512]{1to16}
// CHECK:  encoding: [0x62,0xe1,0x7c,0x58,0x5b,0x9a,0x00,0x02,0x00,0x00]
          vcvtdq2ps zmm19, dword ptr [rdx + 512]{1to16}

// CHECK: vcvtdq2ps zmm19, dword ptr [rdx - 512]{1to16}
// CHECK:  encoding: [0x62,0xe1,0x7c,0x58,0x5b,0x5a,0x80]
          vcvtdq2ps zmm19, dword ptr [rdx - 512]{1to16}

// CHECK: vcvtdq2ps zmm19, dword ptr [rdx - 516]{1to16}
// CHECK:  encoding: [0x62,0xe1,0x7c,0x58,0x5b,0x9a,0xfc,0xfd,0xff,0xff]
          vcvtdq2ps zmm19, dword ptr [rdx - 516]{1to16}

// CHECK: vcvtpd2dq ymm6, zmm2
// CHECK:  encoding: [0x62,0xf1,0xff,0x48,0xe6,0xf2]
          vcvtpd2dq ymm6, zmm2

// CHECK: vcvtpd2dq ymm6 {k6}, zmm2
// CHECK:  encoding: [0x62,0xf1,0xff,0x4e,0xe6,0xf2]
          vcvtpd2dq ymm6 {k6}, zmm2

// CHECK: vcvtpd2dq ymm6 {k6} {z}, zmm2
// CHECK:  encoding: [0x62,0xf1,0xff,0xce,0xe6,0xf2]
          vcvtpd2dq ymm6 {k6} {z}, zmm2

// CHECK: vcvtpd2dq ymm6, zmm2, {rn-sae}
// CHECK:  encoding: [0x62,0xf1,0xff,0x18,0xe6,0xf2]
          vcvtpd2dq ymm6, zmm2, {rn-sae}

// CHECK: vcvtpd2dq ymm6, zmm2, {ru-sae}
// CHECK:  encoding: [0x62,0xf1,0xff,0x58,0xe6,0xf2]
          vcvtpd2dq ymm6, zmm2, {ru-sae}

// CHECK: vcvtpd2dq ymm6, zmm2, {rd-sae}
// CHECK:  encoding: [0x62,0xf1,0xff,0x38,0xe6,0xf2]
          vcvtpd2dq ymm6, zmm2, {rd-sae}

// CHECK: vcvtpd2dq ymm6, zmm2, {rz-sae}
// CHECK:  encoding: [0x62,0xf1,0xff,0x78,0xe6,0xf2]
          vcvtpd2dq ymm6, zmm2, {rz-sae}

// CHECK: vcvtpd2dq ymm6, zmmword ptr [rcx]
// CHECK:  encoding: [0x62,0xf1,0xff,0x48,0xe6,0x31]
          vcvtpd2dq ymm6, zmmword ptr [rcx]

// CHECK: vcvtpd2dq ymm6, zmmword ptr [rax + 8*r14 + 4660]
// CHECK:  encoding: [0x62,0xb1,0xff,0x48,0xe6,0xb4,0xf0,0x34,0x12,0x00,0x00]
          vcvtpd2dq ymm6, zmmword ptr [rax + 8*r14 + 4660]

// CHECK: vcvtpd2dq ymm6, qword ptr [rcx]{1to8}
// CHECK:  encoding: [0x62,0xf1,0xff,0x58,0xe6,0x31]
          vcvtpd2dq ymm6, qword ptr [rcx]{1to8}

// CHECK: vcvtpd2dq ymm6, zmmword ptr [rdx + 8128]
// CHECK:  encoding: [0x62,0xf1,0xff,0x48,0xe6,0x72,0x7f]
          vcvtpd2dq ymm6, zmmword ptr [rdx + 8128]

// CHECK: vcvtpd2dq ymm6, zmmword ptr [rdx + 8192]
// CHECK:  encoding: [0x62,0xf1,0xff,0x48,0xe6,0xb2,0x00,0x20,0x00,0x00]
          vcvtpd2dq ymm6, zmmword ptr [rdx + 8192]

// CHECK: vcvtpd2dq ymm6, zmmword ptr [rdx - 8192]
// CHECK:  encoding: [0x62,0xf1,0xff,0x48,0xe6,0x72,0x80]
          vcvtpd2dq ymm6, zmmword ptr [rdx - 8192]

// CHECK: vcvtpd2dq ymm6, zmmword ptr [rdx - 8256]
// CHECK:  encoding: [0x62,0xf1,0xff,0x48,0xe6,0xb2,0xc0,0xdf,0xff,0xff]
          vcvtpd2dq ymm6, zmmword ptr [rdx - 8256]

// CHECK: vcvtpd2dq ymm6, qword ptr [rdx + 1016]{1to8}
// CHECK:  encoding: [0x62,0xf1,0xff,0x58,0xe6,0x72,0x7f]
          vcvtpd2dq ymm6, qword ptr [rdx + 1016]{1to8}

// CHECK: vcvtpd2dq ymm6, qword ptr [rdx + 1024]{1to8}
// CHECK:  encoding: [0x62,0xf1,0xff,0x58,0xe6,0xb2,0x00,0x04,0x00,0x00]
          vcvtpd2dq ymm6, qword ptr [rdx + 1024]{1to8}

// CHECK: vcvtpd2dq ymm6, qword ptr [rdx - 1024]{1to8}
// CHECK:  encoding: [0x62,0xf1,0xff,0x58,0xe6,0x72,0x80]
          vcvtpd2dq ymm6, qword ptr [rdx - 1024]{1to8}

// CHECK: vcvtpd2dq ymm6, qword ptr [rdx - 1032]{1to8}
// CHECK:  encoding: [0x62,0xf1,0xff,0x58,0xe6,0xb2,0xf8,0xfb,0xff,0xff]
          vcvtpd2dq ymm6, qword ptr [rdx - 1032]{1to8}

// CHECK: vcvtpd2ps ymm16, zmm10
// CHECK:  encoding: [0x62,0xc1,0xfd,0x48,0x5a,0xc2]
          vcvtpd2ps ymm16, zmm10

// CHECK: vcvtpd2ps ymm16 {k2}, zmm10
// CHECK:  encoding: [0x62,0xc1,0xfd,0x4a,0x5a,0xc2]
          vcvtpd2ps ymm16 {k2}, zmm10

// CHECK: vcvtpd2ps ymm16 {k2} {z}, zmm10
// CHECK:  encoding: [0x62,0xc1,0xfd,0xca,0x5a,0xc2]
          vcvtpd2ps ymm16 {k2} {z}, zmm10

// CHECK: vcvtpd2ps ymm16, zmm10, {rn-sae}
// CHECK:  encoding: [0x62,0xc1,0xfd,0x18,0x5a,0xc2]
          vcvtpd2ps ymm16, zmm10, {rn-sae}

// CHECK: vcvtpd2ps ymm16, zmm10, {ru-sae}
// CHECK:  encoding: [0x62,0xc1,0xfd,0x58,0x5a,0xc2]
          vcvtpd2ps ymm16, zmm10, {ru-sae}

// CHECK: vcvtpd2ps ymm16, zmm10, {rd-sae}
// CHECK:  encoding: [0x62,0xc1,0xfd,0x38,0x5a,0xc2]
          vcvtpd2ps ymm16, zmm10, {rd-sae}

// CHECK: vcvtpd2ps ymm16, zmm10, {rz-sae}
// CHECK:  encoding: [0x62,0xc1,0xfd,0x78,0x5a,0xc2]
          vcvtpd2ps ymm16, zmm10, {rz-sae}

// CHECK: vcvtpd2ps ymm16, zmmword ptr [rcx]
// CHECK:  encoding: [0x62,0xe1,0xfd,0x48,0x5a,0x01]
          vcvtpd2ps ymm16, zmmword ptr [rcx]

// CHECK: vcvtpd2ps ymm16, zmmword ptr [rax + 8*r14 + 4660]
// CHECK:  encoding: [0x62,0xa1,0xfd,0x48,0x5a,0x84,0xf0,0x34,0x12,0x00,0x00]
          vcvtpd2ps ymm16, zmmword ptr [rax + 8*r14 + 4660]

// CHECK: vcvtpd2ps ymm16, qword ptr [rcx]{1to8}
// CHECK:  encoding: [0x62,0xe1,0xfd,0x58,0x5a,0x01]
          vcvtpd2ps ymm16, qword ptr [rcx]{1to8}

// CHECK: vcvtpd2ps ymm16, zmmword ptr [rdx + 8128]
// CHECK:  encoding: [0x62,0xe1,0xfd,0x48,0x5a,0x42,0x7f]
          vcvtpd2ps ymm16, zmmword ptr [rdx + 8128]

// CHECK: vcvtpd2ps ymm16, zmmword ptr [rdx + 8192]
// CHECK:  encoding: [0x62,0xe1,0xfd,0x48,0x5a,0x82,0x00,0x20,0x00,0x00]
          vcvtpd2ps ymm16, zmmword ptr [rdx + 8192]

// CHECK: vcvtpd2ps ymm16, zmmword ptr [rdx - 8192]
// CHECK:  encoding: [0x62,0xe1,0xfd,0x48,0x5a,0x42,0x80]
          vcvtpd2ps ymm16, zmmword ptr [rdx - 8192]

// CHECK: vcvtpd2ps ymm16, zmmword ptr [rdx - 8256]
// CHECK:  encoding: [0x62,0xe1,0xfd,0x48,0x5a,0x82,0xc0,0xdf,0xff,0xff]
          vcvtpd2ps ymm16, zmmword ptr [rdx - 8256]

// CHECK: vcvtpd2ps ymm16, qword ptr [rdx + 1016]{1to8}
// CHECK:  encoding: [0x62,0xe1,0xfd,0x58,0x5a,0x42,0x7f]
          vcvtpd2ps ymm16, qword ptr [rdx + 1016]{1to8}

// CHECK: vcvtpd2ps ymm16, qword ptr [rdx + 1024]{1to8}
// CHECK:  encoding: [0x62,0xe1,0xfd,0x58,0x5a,0x82,0x00,0x04,0x00,0x00]
          vcvtpd2ps ymm16, qword ptr [rdx + 1024]{1to8}

// CHECK: vcvtpd2ps ymm16, qword ptr [rdx - 1024]{1to8}
// CHECK:  encoding: [0x62,0xe1,0xfd,0x58,0x5a,0x42,0x80]
          vcvtpd2ps ymm16, qword ptr [rdx - 1024]{1to8}

// CHECK: vcvtpd2ps ymm16, qword ptr [rdx - 1032]{1to8}
// CHECK:  encoding: [0x62,0xe1,0xfd,0x58,0x5a,0x82,0xf8,0xfb,0xff,0xff]
          vcvtpd2ps ymm16, qword ptr [rdx - 1032]{1to8}

// CHECK: vcvtpd2udq ymm25, zmm25
// CHECK:  encoding: [0x62,0x01,0xfc,0x48,0x79,0xc9]
          vcvtpd2udq ymm25, zmm25

// CHECK: vcvtpd2udq ymm25 {k1}, zmm25
// CHECK:  encoding: [0x62,0x01,0xfc,0x49,0x79,0xc9]
          vcvtpd2udq ymm25 {k1}, zmm25

// CHECK: vcvtpd2udq ymm25 {k1} {z}, zmm25
// CHECK:  encoding: [0x62,0x01,0xfc,0xc9,0x79,0xc9]
          vcvtpd2udq ymm25 {k1} {z}, zmm25

// CHECK: vcvtpd2udq ymm25, zmm25, {rn-sae}
// CHECK:  encoding: [0x62,0x01,0xfc,0x18,0x79,0xc9]
          vcvtpd2udq ymm25, zmm25, {rn-sae}

// CHECK: vcvtpd2udq ymm25, zmm25, {ru-sae}
// CHECK:  encoding: [0x62,0x01,0xfc,0x58,0x79,0xc9]
          vcvtpd2udq ymm25, zmm25, {ru-sae}

// CHECK: vcvtpd2udq ymm25, zmm25, {rd-sae}
// CHECK:  encoding: [0x62,0x01,0xfc,0x38,0x79,0xc9]
          vcvtpd2udq ymm25, zmm25, {rd-sae}

// CHECK: vcvtpd2udq ymm25, zmm25, {rz-sae}
// CHECK:  encoding: [0x62,0x01,0xfc,0x78,0x79,0xc9]
          vcvtpd2udq ymm25, zmm25, {rz-sae}

// CHECK: vcvtpd2udq ymm25, zmmword ptr [rcx]
// CHECK:  encoding: [0x62,0x61,0xfc,0x48,0x79,0x09]
          vcvtpd2udq ymm25, zmmword ptr [rcx]

// CHECK: vcvtpd2udq ymm25, zmmword ptr [rax + 8*r14 + 4660]
// CHECK:  encoding: [0x62,0x21,0xfc,0x48,0x79,0x8c,0xf0,0x34,0x12,0x00,0x00]
          vcvtpd2udq ymm25, zmmword ptr [rax + 8*r14 + 4660]

// CHECK: vcvtpd2udq ymm25, qword ptr [rcx]{1to8}
// CHECK:  encoding: [0x62,0x61,0xfc,0x58,0x79,0x09]
          vcvtpd2udq ymm25, qword ptr [rcx]{1to8}

// CHECK: vcvtpd2udq ymm25, zmmword ptr [rdx + 8128]
// CHECK:  encoding: [0x62,0x61,0xfc,0x48,0x79,0x4a,0x7f]
          vcvtpd2udq ymm25, zmmword ptr [rdx + 8128]

// CHECK: vcvtpd2udq ymm25, zmmword ptr [rdx + 8192]
// CHECK:  encoding: [0x62,0x61,0xfc,0x48,0x79,0x8a,0x00,0x20,0x00,0x00]
          vcvtpd2udq ymm25, zmmword ptr [rdx + 8192]

// CHECK: vcvtpd2udq ymm25, zmmword ptr [rdx - 8192]
// CHECK:  encoding: [0x62,0x61,0xfc,0x48,0x79,0x4a,0x80]
          vcvtpd2udq ymm25, zmmword ptr [rdx - 8192]

// CHECK: vcvtpd2udq ymm25, zmmword ptr [rdx - 8256]
// CHECK:  encoding: [0x62,0x61,0xfc,0x48,0x79,0x8a,0xc0,0xdf,0xff,0xff]
          vcvtpd2udq ymm25, zmmword ptr [rdx - 8256]

// CHECK: vcvtpd2udq ymm25, qword ptr [rdx + 1016]{1to8}
// CHECK:  encoding: [0x62,0x61,0xfc,0x58,0x79,0x4a,0x7f]
          vcvtpd2udq ymm25, qword ptr [rdx + 1016]{1to8}

// CHECK: vcvtpd2udq ymm25, qword ptr [rdx + 1024]{1to8}
// CHECK:  encoding: [0x62,0x61,0xfc,0x58,0x79,0x8a,0x00,0x04,0x00,0x00]
          vcvtpd2udq ymm25, qword ptr [rdx + 1024]{1to8}

// CHECK: vcvtpd2udq ymm25, qword ptr [rdx - 1024]{1to8}
// CHECK:  encoding: [0x62,0x61,0xfc,0x58,0x79,0x4a,0x80]
          vcvtpd2udq ymm25, qword ptr [rdx - 1024]{1to8}

// CHECK: vcvtpd2udq ymm25, qword ptr [rdx - 1032]{1to8}
// CHECK:  encoding: [0x62,0x61,0xfc,0x58,0x79,0x8a,0xf8,0xfb,0xff,0xff]
          vcvtpd2udq ymm25, qword ptr [rdx - 1032]{1to8}

// CHECK: vcvtph2ps zmm9, ymm21
// CHECK:  encoding: [0x62,0x32,0x7d,0x48,0x13,0xcd]
          vcvtph2ps zmm9, ymm21

// CHECK: vcvtph2ps zmm9 {k3}, ymm21
// CHECK:  encoding: [0x62,0x32,0x7d,0x4b,0x13,0xcd]
          vcvtph2ps zmm9 {k3}, ymm21

// CHECK: vcvtph2ps zmm9 {k3} {z}, ymm21
// CHECK:  encoding: [0x62,0x32,0x7d,0xcb,0x13,0xcd]
          vcvtph2ps zmm9 {k3} {z}, ymm21

// CHECK: vcvtph2ps zmm9, ymm21, {sae}
// CHECK:  encoding: [0x62,0x32,0x7d,0x18,0x13,0xcd]
          vcvtph2ps zmm9, ymm21, {sae}

// CHECK: vcvtph2ps zmm9, ymmword ptr [rcx]
// CHECK:  encoding: [0x62,0x72,0x7d,0x48,0x13,0x09]
          vcvtph2ps zmm9, ymmword ptr [rcx]

// CHECK: vcvtph2ps zmm9, ymmword ptr [rax + 8*r14 + 4660]
// CHECK:  encoding: [0x62,0x32,0x7d,0x48,0x13,0x8c,0xf0,0x34,0x12,0x00,0x00]
          vcvtph2ps zmm9, ymmword ptr [rax + 8*r14 + 4660]

// CHECK: vcvtph2ps zmm9, ymmword ptr [rdx + 4064]
// CHECK:  encoding: [0x62,0x72,0x7d,0x48,0x13,0x4a,0x7f]
          vcvtph2ps zmm9, ymmword ptr [rdx + 4064]

// CHECK: vcvtph2ps zmm9, ymmword ptr [rdx + 4096]
// CHECK:  encoding: [0x62,0x72,0x7d,0x48,0x13,0x8a,0x00,0x10,0x00,0x00]
          vcvtph2ps zmm9, ymmword ptr [rdx + 4096]

// CHECK: vcvtph2ps zmm9, ymmword ptr [rdx - 4096]
// CHECK:  encoding: [0x62,0x72,0x7d,0x48,0x13,0x4a,0x80]
          vcvtph2ps zmm9, ymmword ptr [rdx - 4096]

// CHECK: vcvtph2ps zmm9, ymmword ptr [rdx - 4128]
// CHECK:  encoding: [0x62,0x72,0x7d,0x48,0x13,0x8a,0xe0,0xef,0xff,0xff]
          vcvtph2ps zmm9, ymmword ptr [rdx - 4128]

// CHECK: vcvtps2dq zmm16, zmm6
// CHECK:  encoding: [0x62,0xe1,0x7d,0x48,0x5b,0xc6]
          vcvtps2dq zmm16, zmm6

// CHECK: vcvtps2dq zmm16 {k2}, zmm6
// CHECK:  encoding: [0x62,0xe1,0x7d,0x4a,0x5b,0xc6]
          vcvtps2dq zmm16 {k2}, zmm6

// CHECK: vcvtps2dq zmm16 {k2} {z}, zmm6
// CHECK:  encoding: [0x62,0xe1,0x7d,0xca,0x5b,0xc6]
          vcvtps2dq zmm16 {k2} {z}, zmm6

// CHECK: vcvtps2dq zmm16, zmm6, {rn-sae}
// CHECK:  encoding: [0x62,0xe1,0x7d,0x18,0x5b,0xc6]
          vcvtps2dq zmm16, zmm6, {rn-sae}

// CHECK: vcvtps2dq zmm16, zmm6, {ru-sae}
// CHECK:  encoding: [0x62,0xe1,0x7d,0x58,0x5b,0xc6]
          vcvtps2dq zmm16, zmm6, {ru-sae}

// CHECK: vcvtps2dq zmm16, zmm6, {rd-sae}
// CHECK:  encoding: [0x62,0xe1,0x7d,0x38,0x5b,0xc6]
          vcvtps2dq zmm16, zmm6, {rd-sae}

// CHECK: vcvtps2dq zmm16, zmm6, {rz-sae}
// CHECK:  encoding: [0x62,0xe1,0x7d,0x78,0x5b,0xc6]
          vcvtps2dq zmm16, zmm6, {rz-sae}

// CHECK: vcvtps2dq zmm16, zmmword ptr [rcx]
// CHECK:  encoding: [0x62,0xe1,0x7d,0x48,0x5b,0x01]
          vcvtps2dq zmm16, zmmword ptr [rcx]

// CHECK: vcvtps2dq zmm16, zmmword ptr [rax + 8*r14 + 4660]
// CHECK:  encoding: [0x62,0xa1,0x7d,0x48,0x5b,0x84,0xf0,0x34,0x12,0x00,0x00]
          vcvtps2dq zmm16, zmmword ptr [rax + 8*r14 + 4660]

// CHECK: vcvtps2dq zmm16, dword ptr [rcx]{1to16}
// CHECK:  encoding: [0x62,0xe1,0x7d,0x58,0x5b,0x01]
          vcvtps2dq zmm16, dword ptr [rcx]{1to16}

// CHECK: vcvtps2dq zmm16, zmmword ptr [rdx + 8128]
// CHECK:  encoding: [0x62,0xe1,0x7d,0x48,0x5b,0x42,0x7f]
          vcvtps2dq zmm16, zmmword ptr [rdx + 8128]

// CHECK: vcvtps2dq zmm16, zmmword ptr [rdx + 8192]
// CHECK:  encoding: [0x62,0xe1,0x7d,0x48,0x5b,0x82,0x00,0x20,0x00,0x00]
          vcvtps2dq zmm16, zmmword ptr [rdx + 8192]

// CHECK: vcvtps2dq zmm16, zmmword ptr [rdx - 8192]
// CHECK:  encoding: [0x62,0xe1,0x7d,0x48,0x5b,0x42,0x80]
          vcvtps2dq zmm16, zmmword ptr [rdx - 8192]

// CHECK: vcvtps2dq zmm16, zmmword ptr [rdx - 8256]
// CHECK:  encoding: [0x62,0xe1,0x7d,0x48,0x5b,0x82,0xc0,0xdf,0xff,0xff]
          vcvtps2dq zmm16, zmmword ptr [rdx - 8256]

// CHECK: vcvtps2dq zmm16, dword ptr [rdx + 508]{1to16}
// CHECK:  encoding: [0x62,0xe1,0x7d,0x58,0x5b,0x42,0x7f]
          vcvtps2dq zmm16, dword ptr [rdx + 508]{1to16}

// CHECK: vcvtps2dq zmm16, dword ptr [rdx + 512]{1to16}
// CHECK:  encoding: [0x62,0xe1,0x7d,0x58,0x5b,0x82,0x00,0x02,0x00,0x00]
          vcvtps2dq zmm16, dword ptr [rdx + 512]{1to16}

// CHECK: vcvtps2dq zmm16, dword ptr [rdx - 512]{1to16}
// CHECK:  encoding: [0x62,0xe1,0x7d,0x58,0x5b,0x42,0x80]
          vcvtps2dq zmm16, dword ptr [rdx - 512]{1to16}

// CHECK: vcvtps2dq zmm16, dword ptr [rdx - 516]{1to16}
// CHECK:  encoding: [0x62,0xe1,0x7d,0x58,0x5b,0x82,0xfc,0xfd,0xff,0xff]
          vcvtps2dq zmm16, dword ptr [rdx - 516]{1to16}

// CHECK: vcvtps2pd zmm11, ymm24
// CHECK:  encoding: [0x62,0x11,0x7c,0x48,0x5a,0xd8]
          vcvtps2pd zmm11, ymm24

// CHECK: vcvtps2pd zmm11 {k3}, ymm24
// CHECK:  encoding: [0x62,0x11,0x7c,0x4b,0x5a,0xd8]
          vcvtps2pd zmm11 {k3}, ymm24

// CHECK: vcvtps2pd zmm11 {k3} {z}, ymm24
// CHECK:  encoding: [0x62,0x11,0x7c,0xcb,0x5a,0xd8]
          vcvtps2pd zmm11 {k3} {z}, ymm24

// CHECK: vcvtps2pd zmm11, ymm24, {sae}
// CHECK:  encoding: [0x62,0x11,0x7c,0x18,0x5a,0xd8]
          vcvtps2pd zmm11, ymm24, {sae}

// CHECK: vcvtps2pd zmm11, ymmword ptr [rcx]
// CHECK:  encoding: [0x62,0x71,0x7c,0x48,0x5a,0x19]
          vcvtps2pd zmm11, ymmword ptr [rcx]

// CHECK: vcvtps2pd zmm11, ymmword ptr [rax + 8*r14 + 4660]
// CHECK:  encoding: [0x62,0x31,0x7c,0x48,0x5a,0x9c,0xf0,0x34,0x12,0x00,0x00]
          vcvtps2pd zmm11, ymmword ptr [rax + 8*r14 + 4660]

// CHECK: vcvtps2pd zmm11, dword ptr [rcx]{1to8}
// CHECK:  encoding: [0x62,0x71,0x7c,0x58,0x5a,0x19]
          vcvtps2pd zmm11, dword ptr [rcx]{1to8}

// CHECK: vcvtps2pd zmm11, ymmword ptr [rdx + 4064]
// CHECK:  encoding: [0x62,0x71,0x7c,0x48,0x5a,0x5a,0x7f]
          vcvtps2pd zmm11, ymmword ptr [rdx + 4064]

// CHECK: vcvtps2pd zmm11, ymmword ptr [rdx + 4096]
// CHECK:  encoding: [0x62,0x71,0x7c,0x48,0x5a,0x9a,0x00,0x10,0x00,0x00]
          vcvtps2pd zmm11, ymmword ptr [rdx + 4096]

// CHECK: vcvtps2pd zmm11, ymmword ptr [rdx - 4096]
// CHECK:  encoding: [0x62,0x71,0x7c,0x48,0x5a,0x5a,0x80]
          vcvtps2pd zmm11, ymmword ptr [rdx - 4096]

// CHECK: vcvtps2pd zmm11, ymmword ptr [rdx - 4128]
// CHECK:  encoding: [0x62,0x71,0x7c,0x48,0x5a,0x9a,0xe0,0xef,0xff,0xff]
          vcvtps2pd zmm11, ymmword ptr [rdx - 4128]

// CHECK: vcvtps2pd zmm11, dword ptr [rdx + 508]{1to8}
// CHECK:  encoding: [0x62,0x71,0x7c,0x58,0x5a,0x5a,0x7f]
          vcvtps2pd zmm11, dword ptr [rdx + 508]{1to8}

// CHECK: vcvtps2pd zmm11, dword ptr [rdx + 512]{1to8}
// CHECK:  encoding: [0x62,0x71,0x7c,0x58,0x5a,0x9a,0x00,0x02,0x00,0x00]
          vcvtps2pd zmm11, dword ptr [rdx + 512]{1to8}

// CHECK: vcvtps2pd zmm11, dword ptr [rdx - 512]{1to8}
// CHECK:  encoding: [0x62,0x71,0x7c,0x58,0x5a,0x5a,0x80]
          vcvtps2pd zmm11, dword ptr [rdx - 512]{1to8}

// CHECK: vcvtps2pd zmm11, dword ptr [rdx - 516]{1to8}
// CHECK:  encoding: [0x62,0x71,0x7c,0x58,0x5a,0x9a,0xfc,0xfd,0xff,0xff]
          vcvtps2pd zmm11, dword ptr [rdx - 516]{1to8}

// CHECK: vcvtps2ph ymm9, zmm22, 171
// CHECK:  encoding: [0x62,0xc3,0x7d,0x48,0x1d,0xf1,0xab]
          vcvtps2ph ymm9, zmm22, 171

// CHECK: vcvtps2ph ymm9 {k7}, zmm22, 171
// CHECK:  encoding: [0x62,0xc3,0x7d,0x4f,0x1d,0xf1,0xab]
          vcvtps2ph ymm9 {k7}, zmm22, 171

// CHECK: vcvtps2ph ymm9 {k7} {z}, zmm22, 171
// CHECK:  encoding: [0x62,0xc3,0x7d,0xcf,0x1d,0xf1,0xab]
          vcvtps2ph ymm9 {k7} {z}, zmm22, 171

// CHECK: vcvtps2ph ymm9, zmm22, {sae}, 171
// CHECK:  encoding: [0x62,0xc3,0x7d,0x18,0x1d,0xf1,0xab]
          vcvtps2ph ymm9, zmm22, {sae}, 171

// CHECK: vcvtps2ph ymm9, zmm22, 123
// CHECK:  encoding: [0x62,0xc3,0x7d,0x48,0x1d,0xf1,0x7b]
          vcvtps2ph ymm9, zmm22, 123

// CHECK: vcvtps2ph ymm9, zmm22, {sae}, 123
// CHECK:  encoding: [0x62,0xc3,0x7d,0x18,0x1d,0xf1,0x7b]
          vcvtps2ph ymm9, zmm22, {sae}, 123

// CHECK: vcvtps2udq zmm5, zmm4
// CHECK:  encoding: [0x62,0xf1,0x7c,0x48,0x79,0xec]
          vcvtps2udq zmm5, zmm4

// CHECK: vcvtps2udq zmm5 {k5}, zmm4
// CHECK:  encoding: [0x62,0xf1,0x7c,0x4d,0x79,0xec]
          vcvtps2udq zmm5 {k5}, zmm4

// CHECK: vcvtps2udq zmm5 {k5} {z}, zmm4
// CHECK:  encoding: [0x62,0xf1,0x7c,0xcd,0x79,0xec]
          vcvtps2udq zmm5 {k5} {z}, zmm4

// CHECK: vcvtps2udq zmm5, zmm4, {rn-sae}
// CHECK:  encoding: [0x62,0xf1,0x7c,0x18,0x79,0xec]
          vcvtps2udq zmm5, zmm4, {rn-sae}

// CHECK: vcvtps2udq zmm5, zmm4, {ru-sae}
// CHECK:  encoding: [0x62,0xf1,0x7c,0x58,0x79,0xec]
          vcvtps2udq zmm5, zmm4, {ru-sae}

// CHECK: vcvtps2udq zmm5, zmm4, {rd-sae}
// CHECK:  encoding: [0x62,0xf1,0x7c,0x38,0x79,0xec]
          vcvtps2udq zmm5, zmm4, {rd-sae}

// CHECK: vcvtps2udq zmm5, zmm4, {rz-sae}
// CHECK:  encoding: [0x62,0xf1,0x7c,0x78,0x79,0xec]
          vcvtps2udq zmm5, zmm4, {rz-sae}

// CHECK: vcvtps2udq zmm5, zmmword ptr [rcx]
// CHECK:  encoding: [0x62,0xf1,0x7c,0x48,0x79,0x29]
          vcvtps2udq zmm5, zmmword ptr [rcx]

// CHECK: vcvtps2udq zmm5, zmmword ptr [rax + 8*r14 + 4660]
// CHECK:  encoding: [0x62,0xb1,0x7c,0x48,0x79,0xac,0xf0,0x34,0x12,0x00,0x00]
          vcvtps2udq zmm5, zmmword ptr [rax + 8*r14 + 4660]

// CHECK: vcvtps2udq zmm5, dword ptr [rcx]{1to16}
// CHECK:  encoding: [0x62,0xf1,0x7c,0x58,0x79,0x29]
          vcvtps2udq zmm5, dword ptr [rcx]{1to16}

// CHECK: vcvtps2udq zmm5, zmmword ptr [rdx + 8128]
// CHECK:  encoding: [0x62,0xf1,0x7c,0x48,0x79,0x6a,0x7f]
          vcvtps2udq zmm5, zmmword ptr [rdx + 8128]

// CHECK: vcvtps2udq zmm5, zmmword ptr [rdx + 8192]
// CHECK:  encoding: [0x62,0xf1,0x7c,0x48,0x79,0xaa,0x00,0x20,0x00,0x00]
          vcvtps2udq zmm5, zmmword ptr [rdx + 8192]

// CHECK: vcvtps2udq zmm5, zmmword ptr [rdx - 8192]
// CHECK:  encoding: [0x62,0xf1,0x7c,0x48,0x79,0x6a,0x80]
          vcvtps2udq zmm5, zmmword ptr [rdx - 8192]

// CHECK: vcvtps2udq zmm5, zmmword ptr [rdx - 8256]
// CHECK:  encoding: [0x62,0xf1,0x7c,0x48,0x79,0xaa,0xc0,0xdf,0xff,0xff]
          vcvtps2udq zmm5, zmmword ptr [rdx - 8256]

// CHECK: vcvtps2udq zmm5, dword ptr [rdx + 508]{1to16}
// CHECK:  encoding: [0x62,0xf1,0x7c,0x58,0x79,0x6a,0x7f]
          vcvtps2udq zmm5, dword ptr [rdx + 508]{1to16}

// CHECK: vcvtps2udq zmm5, dword ptr [rdx + 512]{1to16}
// CHECK:  encoding: [0x62,0xf1,0x7c,0x58,0x79,0xaa,0x00,0x02,0x00,0x00]
          vcvtps2udq zmm5, dword ptr [rdx + 512]{1to16}

// CHECK: vcvtps2udq zmm5, dword ptr [rdx - 512]{1to16}
// CHECK:  encoding: [0x62,0xf1,0x7c,0x58,0x79,0x6a,0x80]
          vcvtps2udq zmm5, dword ptr [rdx - 512]{1to16}

// CHECK: vcvtps2udq zmm5, dword ptr [rdx - 516]{1to16}
// CHECK:  encoding: [0x62,0xf1,0x7c,0x58,0x79,0xaa,0xfc,0xfd,0xff,0xff]
          vcvtps2udq zmm5, dword ptr [rdx - 516]{1to16}

// CHECK: vcvtsd2si eax, xmm4, {rn-sae}
// CHECK:  encoding: [0x62,0xf1,0x7f,0x18,0x2d,0xc4]
          vcvtsd2si eax, xmm4, {rn-sae}

// CHECK: vcvtsd2si eax, xmm4, {ru-sae}
// CHECK:  encoding: [0x62,0xf1,0x7f,0x58,0x2d,0xc4]
          vcvtsd2si eax, xmm4, {ru-sae}

// CHECK: vcvtsd2si eax, xmm4, {rd-sae}
// CHECK:  encoding: [0x62,0xf1,0x7f,0x38,0x2d,0xc4]
          vcvtsd2si eax, xmm4, {rd-sae}

// CHECK: vcvtsd2si eax, xmm4, {rz-sae}
// CHECK:  encoding: [0x62,0xf1,0x7f,0x78,0x2d,0xc4]
          vcvtsd2si eax, xmm4, {rz-sae}

// CHECK: vcvtsd2si ebp, xmm4, {rn-sae}
// CHECK:  encoding: [0x62,0xf1,0x7f,0x18,0x2d,0xec]
          vcvtsd2si ebp, xmm4, {rn-sae}

// CHECK: vcvtsd2si ebp, xmm4, {ru-sae}
// CHECK:  encoding: [0x62,0xf1,0x7f,0x58,0x2d,0xec]
          vcvtsd2si ebp, xmm4, {ru-sae}

// CHECK: vcvtsd2si ebp, xmm4, {rd-sae}
// CHECK:  encoding: [0x62,0xf1,0x7f,0x38,0x2d,0xec]
          vcvtsd2si ebp, xmm4, {rd-sae}

// CHECK: vcvtsd2si ebp, xmm4, {rz-sae}
// CHECK:  encoding: [0x62,0xf1,0x7f,0x78,0x2d,0xec]
          vcvtsd2si ebp, xmm4, {rz-sae}

// CHECK: vcvtsd2si r13d, xmm4, {rn-sae}
// CHECK:  encoding: [0x62,0x71,0x7f,0x18,0x2d,0xec]
          vcvtsd2si r13d, xmm4, {rn-sae}

// CHECK: vcvtsd2si r13d, xmm4, {ru-sae}
// CHECK:  encoding: [0x62,0x71,0x7f,0x58,0x2d,0xec]
          vcvtsd2si r13d, xmm4, {ru-sae}

// CHECK: vcvtsd2si r13d, xmm4, {rd-sae}
// CHECK:  encoding: [0x62,0x71,0x7f,0x38,0x2d,0xec]
          vcvtsd2si r13d, xmm4, {rd-sae}

// CHECK: vcvtsd2si r13d, xmm4, {rz-sae}
// CHECK:  encoding: [0x62,0x71,0x7f,0x78,0x2d,0xec]
          vcvtsd2si r13d, xmm4, {rz-sae}

// CHECK: vcvtsd2si rax, xmm27, {rn-sae}
// CHECK:  encoding: [0x62,0x91,0xff,0x18,0x2d,0xc3]
          vcvtsd2si rax, xmm27, {rn-sae}

// CHECK: vcvtsd2si rax, xmm27, {ru-sae}
// CHECK:  encoding: [0x62,0x91,0xff,0x58,0x2d,0xc3]
          vcvtsd2si rax, xmm27, {ru-sae}

// CHECK: vcvtsd2si rax, xmm27, {rd-sae}
// CHECK:  encoding: [0x62,0x91,0xff,0x38,0x2d,0xc3]
          vcvtsd2si rax, xmm27, {rd-sae}

// CHECK: vcvtsd2si rax, xmm27, {rz-sae}
// CHECK:  encoding: [0x62,0x91,0xff,0x78,0x2d,0xc3]
          vcvtsd2si rax, xmm27, {rz-sae}

// CHECK: vcvtsd2si r8, xmm27, {rn-sae}
// CHECK:  encoding: [0x62,0x11,0xff,0x18,0x2d,0xc3]
          vcvtsd2si r8, xmm27, {rn-sae}

// CHECK: vcvtsd2si r8, xmm27, {ru-sae}
// CHECK:  encoding: [0x62,0x11,0xff,0x58,0x2d,0xc3]
          vcvtsd2si r8, xmm27, {ru-sae}

// CHECK: vcvtsd2si r8, xmm27, {rd-sae}
// CHECK:  encoding: [0x62,0x11,0xff,0x38,0x2d,0xc3]
          vcvtsd2si r8, xmm27, {rd-sae}

// CHECK: vcvtsd2si r8, xmm27, {rz-sae}
// CHECK:  encoding: [0x62,0x11,0xff,0x78,0x2d,0xc3]
          vcvtsd2si r8, xmm27, {rz-sae}

// CHECK: vcvtsi2sd xmm4, xmm9, eax
// CHECK:  encoding: [0xc5,0xb3,0x2a,0xe0]
          vcvtsi2sd xmm4, xmm9, eax

// CHECK: vcvtsi2sd xmm4, xmm9, ebp
// CHECK:  encoding: [0xc5,0xb3,0x2a,0xe5]
          vcvtsi2sd xmm4, xmm9, ebp

// CHECK: vcvtsi2sd xmm4, xmm9, r13d
// CHECK:  encoding: [0xc4,0xc1,0x33,0x2a,0xe5]
          vcvtsi2sd xmm4, xmm9, r13d

// CHECK: vcvtsi2sd xmm4, xmm9, dword ptr [rcx]
// CHECK:  encoding: [0xc5,0xb3,0x2a,0x21]
          vcvtsi2sd xmm4, xmm9, dword ptr [rcx]

// CHECK: vcvtsi2sd xmm4, xmm9, dword ptr [rax + 8*r14 + 4660]
// CHECK:  encoding: [0xc4,0xa1,0x33,0x2a,0xa4,0xf0,0x34,0x12,0x00,0x00]
          vcvtsi2sd xmm4, xmm9, dword ptr [rax + 8*r14 + 4660]

// CHECK: vcvtsi2sd xmm4, xmm9, dword ptr [rdx + 508]
// CHECK:  encoding: [0xc5,0xb3,0x2a,0xa2,0xfc,0x01,0x00,0x00]
          vcvtsi2sd xmm4, xmm9, dword ptr [rdx + 508]

// CHECK: vcvtsi2sd xmm4, xmm9, dword ptr [rdx + 512]
// CHECK:  encoding: [0xc5,0xb3,0x2a,0xa2,0x00,0x02,0x00,0x00]
          vcvtsi2sd xmm4, xmm9, dword ptr [rdx + 512]

// CHECK: vcvtsi2sd xmm4, xmm9, dword ptr [rdx - 512]
// CHECK:  encoding: [0xc5,0xb3,0x2a,0xa2,0x00,0xfe,0xff,0xff]
          vcvtsi2sd xmm4, xmm9, dword ptr [rdx - 512]

// CHECK: vcvtsi2sd xmm4, xmm9, dword ptr [rdx - 516]
// CHECK:  encoding: [0xc5,0xb3,0x2a,0xa2,0xfc,0xfd,0xff,0xff]
          vcvtsi2sd xmm4, xmm9, dword ptr [rdx - 516]

// CHECK: vcvtsi2sd xmm24, xmm17, rax
// CHECK:  encoding: [0x62,0x61,0xf7,0x00,0x2a,0xc0]
          vcvtsi2sd xmm24, xmm17, rax

// CHECK: vcvtsi2sd xmm24, xmm17, {rn-sae}, rax
// CHECK:  encoding: [0x62,0x61,0xf7,0x10,0x2a,0xc0]
          vcvtsi2sd xmm24, xmm17, {rn-sae}, rax

// CHECK: vcvtsi2sd xmm24, xmm17, {ru-sae}, rax
// CHECK:  encoding: [0x62,0x61,0xf7,0x50,0x2a,0xc0]
          vcvtsi2sd xmm24, xmm17, {ru-sae}, rax

// CHECK: vcvtsi2sd xmm24, xmm17, {rd-sae}, rax
// CHECK:  encoding: [0x62,0x61,0xf7,0x30,0x2a,0xc0]
          vcvtsi2sd xmm24, xmm17, {rd-sae}, rax

// CHECK: vcvtsi2sd xmm24, xmm17, {rz-sae}, rax
// CHECK:  encoding: [0x62,0x61,0xf7,0x70,0x2a,0xc0]
          vcvtsi2sd xmm24, xmm17, {rz-sae}, rax

// CHECK: vcvtsi2sd xmm24, xmm17, r8
// CHECK:  encoding: [0x62,0x41,0xf7,0x00,0x2a,0xc0]
          vcvtsi2sd xmm24, xmm17, r8

// CHECK: vcvtsi2sd xmm24, xmm17, {rn-sae}, r8
// CHECK:  encoding: [0x62,0x41,0xf7,0x10,0x2a,0xc0]
          vcvtsi2sd xmm24, xmm17, {rn-sae}, r8

// CHECK: vcvtsi2sd xmm24, xmm17, {ru-sae}, r8
// CHECK:  encoding: [0x62,0x41,0xf7,0x50,0x2a,0xc0]
          vcvtsi2sd xmm24, xmm17, {ru-sae}, r8

// CHECK: vcvtsi2sd xmm24, xmm17, {rd-sae}, r8
// CHECK:  encoding: [0x62,0x41,0xf7,0x30,0x2a,0xc0]
          vcvtsi2sd xmm24, xmm17, {rd-sae}, r8

// CHECK: vcvtsi2sd xmm24, xmm17, {rz-sae}, r8
// CHECK:  encoding: [0x62,0x41,0xf7,0x70,0x2a,0xc0]
          vcvtsi2sd xmm24, xmm17, {rz-sae}, r8

// CHECK: vcvtsi2sd xmm24, xmm17, qword ptr [rcx]
// CHECK:  encoding: [0x62,0x61,0xf7,0x00,0x2a,0x01]
          vcvtsi2sd xmm24, xmm17, qword ptr [rcx]

// CHECK: vcvtsi2sd xmm24, xmm17, qword ptr [rax + 8*r14 + 4660]
// CHECK:  encoding: [0x62,0x21,0xf7,0x00,0x2a,0x84,0xf0,0x34,0x12,0x00,0x00]
          vcvtsi2sd xmm24, xmm17, qword ptr [rax + 8*r14 + 4660]

// CHECK: vcvtsi2sd xmm24, xmm17, qword ptr [rdx + 1016]
// CHECK:  encoding: [0x62,0x61,0xf7,0x00,0x2a,0x42,0x7f]
          vcvtsi2sd xmm24, xmm17, qword ptr [rdx + 1016]

// CHECK: vcvtsi2sd xmm24, xmm17, qword ptr [rdx + 1024]
// CHECK:  encoding: [0x62,0x61,0xf7,0x00,0x2a,0x82,0x00,0x04,0x00,0x00]
          vcvtsi2sd xmm24, xmm17, qword ptr [rdx + 1024]

// CHECK: vcvtsi2sd xmm24, xmm17, qword ptr [rdx - 1024]
// CHECK:  encoding: [0x62,0x61,0xf7,0x00,0x2a,0x42,0x80]
          vcvtsi2sd xmm24, xmm17, qword ptr [rdx - 1024]

// CHECK: vcvtsi2sd xmm24, xmm17, qword ptr [rdx - 1032]
// CHECK:  encoding: [0x62,0x61,0xf7,0x00,0x2a,0x82,0xf8,0xfb,0xff,0xff]
          vcvtsi2sd xmm24, xmm17, qword ptr [rdx - 1032]

// CHECK: vcvtsi2ss xmm25, xmm28, eax
// CHECK:  encoding: [0x62,0x61,0x1e,0x00,0x2a,0xc8]
          vcvtsi2ss xmm25, xmm28, eax

// CHECK: vcvtsi2ss xmm25, xmm28, {rn-sae}, eax
// CHECK:  encoding: [0x62,0x61,0x1e,0x10,0x2a,0xc8]
          vcvtsi2ss xmm25, xmm28, {rn-sae}, eax

// CHECK: vcvtsi2ss xmm25, xmm28, {ru-sae}, eax
// CHECK:  encoding: [0x62,0x61,0x1e,0x50,0x2a,0xc8]
          vcvtsi2ss xmm25, xmm28, {ru-sae}, eax

// CHECK: vcvtsi2ss xmm25, xmm28, {rd-sae}, eax
// CHECK:  encoding: [0x62,0x61,0x1e,0x30,0x2a,0xc8]
          vcvtsi2ss xmm25, xmm28, {rd-sae}, eax

// CHECK: vcvtsi2ss xmm25, xmm28, {rz-sae}, eax
// CHECK:  encoding: [0x62,0x61,0x1e,0x70,0x2a,0xc8]
          vcvtsi2ss xmm25, xmm28, {rz-sae}, eax

// CHECK: vcvtsi2ss xmm25, xmm28, ebp
// CHECK:  encoding: [0x62,0x61,0x1e,0x00,0x2a,0xcd]
          vcvtsi2ss xmm25, xmm28, ebp

// CHECK: vcvtsi2ss xmm25, xmm28, {rn-sae}, ebp
// CHECK:  encoding: [0x62,0x61,0x1e,0x10,0x2a,0xcd]
          vcvtsi2ss xmm25, xmm28, {rn-sae}, ebp

// CHECK: vcvtsi2ss xmm25, xmm28, {ru-sae}, ebp
// CHECK:  encoding: [0x62,0x61,0x1e,0x50,0x2a,0xcd]
          vcvtsi2ss xmm25, xmm28, {ru-sae}, ebp

// CHECK: vcvtsi2ss xmm25, xmm28, {rd-sae}, ebp
// CHECK:  encoding: [0x62,0x61,0x1e,0x30,0x2a,0xcd]
          vcvtsi2ss xmm25, xmm28, {rd-sae}, ebp

// CHECK: vcvtsi2ss xmm25, xmm28, {rz-sae}, ebp
// CHECK:  encoding: [0x62,0x61,0x1e,0x70,0x2a,0xcd]
          vcvtsi2ss xmm25, xmm28, {rz-sae}, ebp

// CHECK: vcvtsi2ss xmm25, xmm28, r13d
// CHECK:  encoding: [0x62,0x41,0x1e,0x00,0x2a,0xcd]
          vcvtsi2ss xmm25, xmm28, r13d

// CHECK: vcvtsi2ss xmm25, xmm28, {rn-sae}, r13d
// CHECK:  encoding: [0x62,0x41,0x1e,0x10,0x2a,0xcd]
          vcvtsi2ss xmm25, xmm28, {rn-sae}, r13d

// CHECK: vcvtsi2ss xmm25, xmm28, {ru-sae}, r13d
// CHECK:  encoding: [0x62,0x41,0x1e,0x50,0x2a,0xcd]
          vcvtsi2ss xmm25, xmm28, {ru-sae}, r13d

// CHECK: vcvtsi2ss xmm25, xmm28, {rd-sae}, r13d
// CHECK:  encoding: [0x62,0x41,0x1e,0x30,0x2a,0xcd]
          vcvtsi2ss xmm25, xmm28, {rd-sae}, r13d

// CHECK: vcvtsi2ss xmm25, xmm28, {rz-sae}, r13d
// CHECK:  encoding: [0x62,0x41,0x1e,0x70,0x2a,0xcd]
          vcvtsi2ss xmm25, xmm28, {rz-sae}, r13d

// CHECK: vcvtsi2ss xmm25, xmm28, dword ptr [rcx]
// CHECK:  encoding: [0x62,0x61,0x1e,0x00,0x2a,0x09]
          vcvtsi2ss xmm25, xmm28, dword ptr [rcx]

// CHECK: vcvtsi2ss xmm25, xmm28, dword ptr [rax + 8*r14 + 4660]
// CHECK:  encoding: [0x62,0x21,0x1e,0x00,0x2a,0x8c,0xf0,0x34,0x12,0x00,0x00]
          vcvtsi2ss xmm25, xmm28, dword ptr [rax + 8*r14 + 4660]

// CHECK: vcvtsi2ss xmm25, xmm28, dword ptr [rdx + 508]
// CHECK:  encoding: [0x62,0x61,0x1e,0x00,0x2a,0x4a,0x7f]
          vcvtsi2ss xmm25, xmm28, dword ptr [rdx + 508]

// CHECK: vcvtsi2ss xmm25, xmm28, dword ptr [rdx + 512]
// CHECK:  encoding: [0x62,0x61,0x1e,0x00,0x2a,0x8a,0x00,0x02,0x00,0x00]
          vcvtsi2ss xmm25, xmm28, dword ptr [rdx + 512]

// CHECK: vcvtsi2ss xmm25, xmm28, dword ptr [rdx - 512]
// CHECK:  encoding: [0x62,0x61,0x1e,0x00,0x2a,0x4a,0x80]
          vcvtsi2ss xmm25, xmm28, dword ptr [rdx - 512]

// CHECK: vcvtsi2ss xmm25, xmm28, dword ptr [rdx - 516]
// CHECK:  encoding: [0x62,0x61,0x1e,0x00,0x2a,0x8a,0xfc,0xfd,0xff,0xff]
          vcvtsi2ss xmm25, xmm28, dword ptr [rdx - 516]

// CHECK: vcvtsi2ss xmm4, xmm8, rax
// CHECK:  encoding: [0xc4,0xe1,0xba,0x2a,0xe0]
          vcvtsi2ss xmm4, xmm8, rax

// CHECK: vcvtsi2ss xmm4, xmm8, {rn-sae}, rax
// CHECK:  encoding: [0x62,0xf1,0xbe,0x18,0x2a,0xe0]
          vcvtsi2ss xmm4, xmm8, {rn-sae}, rax

// CHECK: vcvtsi2ss xmm4, xmm8, {ru-sae}, rax
// CHECK:  encoding: [0x62,0xf1,0xbe,0x58,0x2a,0xe0]
          vcvtsi2ss xmm4, xmm8, {ru-sae}, rax

// CHECK: vcvtsi2ss xmm4, xmm8, {rd-sae}, rax
// CHECK:  encoding: [0x62,0xf1,0xbe,0x38,0x2a,0xe0]
          vcvtsi2ss xmm4, xmm8, {rd-sae}, rax

// CHECK: vcvtsi2ss xmm4, xmm8, {rz-sae}, rax
// CHECK:  encoding: [0x62,0xf1,0xbe,0x78,0x2a,0xe0]
          vcvtsi2ss xmm4, xmm8, {rz-sae}, rax

// CHECK: vcvtsi2ss xmm4, xmm8, r8
// CHECK:  encoding: [0xc4,0xc1,0xba,0x2a,0xe0]
          vcvtsi2ss xmm4, xmm8, r8

// CHECK: vcvtsi2ss xmm4, xmm8, {rn-sae}, r8
// CHECK:  encoding: [0x62,0xd1,0xbe,0x18,0x2a,0xe0]
          vcvtsi2ss xmm4, xmm8, {rn-sae}, r8

// CHECK: vcvtsi2ss xmm4, xmm8, {ru-sae}, r8
// CHECK:  encoding: [0x62,0xd1,0xbe,0x58,0x2a,0xe0]
          vcvtsi2ss xmm4, xmm8, {ru-sae}, r8

// CHECK: vcvtsi2ss xmm4, xmm8, {rd-sae}, r8
// CHECK:  encoding: [0x62,0xd1,0xbe,0x38,0x2a,0xe0]
          vcvtsi2ss xmm4, xmm8, {rd-sae}, r8

// CHECK: vcvtsi2ss xmm4, xmm8, {rz-sae}, r8
// CHECK:  encoding: [0x62,0xd1,0xbe,0x78,0x2a,0xe0]
          vcvtsi2ss xmm4, xmm8, {rz-sae}, r8

// CHECK: vcvtsi2ss xmm4, xmm8, qword ptr [rcx]
// CHECK:  encoding: [0xc4,0xe1,0xba,0x2a,0x21]
          vcvtsi2ss xmm4, xmm8, qword ptr [rcx]

// CHECK: vcvtsi2ss xmm4, xmm8, qword ptr [rax + 8*r14 + 4660]
// CHECK:  encoding: [0xc4,0xa1,0xba,0x2a,0xa4,0xf0,0x34,0x12,0x00,0x00]
          vcvtsi2ss xmm4, xmm8, qword ptr [rax + 8*r14 + 4660]

// CHECK: vcvtsi2ss xmm4, xmm8, qword ptr [rdx + 1016]
// CHECK:  encoding: [0xc4,0xe1,0xba,0x2a,0xa2,0xf8,0x03,0x00,0x00]
          vcvtsi2ss xmm4, xmm8, qword ptr [rdx + 1016]

// CHECK: vcvtsi2ss xmm4, xmm8, qword ptr [rdx + 1024]
// CHECK:  encoding: [0xc4,0xe1,0xba,0x2a,0xa2,0x00,0x04,0x00,0x00]
          vcvtsi2ss xmm4, xmm8, qword ptr [rdx + 1024]

// CHECK: vcvtsi2ss xmm4, xmm8, qword ptr [rdx - 1024]
// CHECK:  encoding: [0xc4,0xe1,0xba,0x2a,0xa2,0x00,0xfc,0xff,0xff]
          vcvtsi2ss xmm4, xmm8, qword ptr [rdx - 1024]

// CHECK: vcvtsi2ss xmm4, xmm8, qword ptr [rdx - 1032]
// CHECK:  encoding: [0xc4,0xe1,0xba,0x2a,0xa2,0xf8,0xfb,0xff,0xff]
          vcvtsi2ss xmm4, xmm8, qword ptr [rdx - 1032]

// CHECK: vcvtss2si eax, xmm8, {rn-sae}
// CHECK:  encoding: [0x62,0xd1,0x7e,0x18,0x2d,0xc0]
          vcvtss2si eax, xmm8, {rn-sae}

// CHECK: vcvtss2si eax, xmm8, {ru-sae}
// CHECK:  encoding: [0x62,0xd1,0x7e,0x58,0x2d,0xc0]
          vcvtss2si eax, xmm8, {ru-sae}

// CHECK: vcvtss2si eax, xmm8, {rd-sae}
// CHECK:  encoding: [0x62,0xd1,0x7e,0x38,0x2d,0xc0]
          vcvtss2si eax, xmm8, {rd-sae}

// CHECK: vcvtss2si eax, xmm8, {rz-sae}
// CHECK:  encoding: [0x62,0xd1,0x7e,0x78,0x2d,0xc0]
          vcvtss2si eax, xmm8, {rz-sae}

// CHECK: vcvtss2si ebp, xmm8, {rn-sae}
// CHECK:  encoding: [0x62,0xd1,0x7e,0x18,0x2d,0xe8]
          vcvtss2si ebp, xmm8, {rn-sae}

// CHECK: vcvtss2si ebp, xmm8, {ru-sae}
// CHECK:  encoding: [0x62,0xd1,0x7e,0x58,0x2d,0xe8]
          vcvtss2si ebp, xmm8, {ru-sae}

// CHECK: vcvtss2si ebp, xmm8, {rd-sae}
// CHECK:  encoding: [0x62,0xd1,0x7e,0x38,0x2d,0xe8]
          vcvtss2si ebp, xmm8, {rd-sae}

// CHECK: vcvtss2si ebp, xmm8, {rz-sae}
// CHECK:  encoding: [0x62,0xd1,0x7e,0x78,0x2d,0xe8]
          vcvtss2si ebp, xmm8, {rz-sae}

// CHECK: vcvtss2si r13d, xmm8, {rn-sae}
// CHECK:  encoding: [0x62,0x51,0x7e,0x18,0x2d,0xe8]
          vcvtss2si r13d, xmm8, {rn-sae}

// CHECK: vcvtss2si r13d, xmm8, {ru-sae}
// CHECK:  encoding: [0x62,0x51,0x7e,0x58,0x2d,0xe8]
          vcvtss2si r13d, xmm8, {ru-sae}

// CHECK: vcvtss2si r13d, xmm8, {rd-sae}
// CHECK:  encoding: [0x62,0x51,0x7e,0x38,0x2d,0xe8]
          vcvtss2si r13d, xmm8, {rd-sae}

// CHECK: vcvtss2si r13d, xmm8, {rz-sae}
// CHECK:  encoding: [0x62,0x51,0x7e,0x78,0x2d,0xe8]
          vcvtss2si r13d, xmm8, {rz-sae}

// CHECK: vcvtss2si rax, xmm6, {rn-sae}
// CHECK:  encoding: [0x62,0xf1,0xfe,0x18,0x2d,0xc6]
          vcvtss2si rax, xmm6, {rn-sae}

// CHECK: vcvtss2si rax, xmm6, {ru-sae}
// CHECK:  encoding: [0x62,0xf1,0xfe,0x58,0x2d,0xc6]
          vcvtss2si rax, xmm6, {ru-sae}

// CHECK: vcvtss2si rax, xmm6, {rd-sae}
// CHECK:  encoding: [0x62,0xf1,0xfe,0x38,0x2d,0xc6]
          vcvtss2si rax, xmm6, {rd-sae}

// CHECK: vcvtss2si rax, xmm6, {rz-sae}
// CHECK:  encoding: [0x62,0xf1,0xfe,0x78,0x2d,0xc6]
          vcvtss2si rax, xmm6, {rz-sae}

// CHECK: vcvtss2si r8, xmm6, {rn-sae}
// CHECK:  encoding: [0x62,0x71,0xfe,0x18,0x2d,0xc6]
          vcvtss2si r8, xmm6, {rn-sae}

// CHECK: vcvtss2si r8, xmm6, {ru-sae}
// CHECK:  encoding: [0x62,0x71,0xfe,0x58,0x2d,0xc6]
          vcvtss2si r8, xmm6, {ru-sae}

// CHECK: vcvtss2si r8, xmm6, {rd-sae}
// CHECK:  encoding: [0x62,0x71,0xfe,0x38,0x2d,0xc6]
          vcvtss2si r8, xmm6, {rd-sae}

// CHECK: vcvtss2si r8, xmm6, {rz-sae}
// CHECK:  encoding: [0x62,0x71,0xfe,0x78,0x2d,0xc6]
          vcvtss2si r8, xmm6, {rz-sae}

// CHECK: vcvttpd2dq ymm4, zmm1
// CHECK:  encoding: [0x62,0xf1,0xfd,0x48,0xe6,0xe1]
          vcvttpd2dq ymm4, zmm1

// CHECK: vcvttpd2dq ymm4 {k6}, zmm1
// CHECK:  encoding: [0x62,0xf1,0xfd,0x4e,0xe6,0xe1]
          vcvttpd2dq ymm4 {k6}, zmm1

// CHECK: vcvttpd2dq ymm4 {k6} {z}, zmm1
// CHECK:  encoding: [0x62,0xf1,0xfd,0xce,0xe6,0xe1]
          vcvttpd2dq ymm4 {k6} {z}, zmm1

// CHECK: vcvttpd2dq ymm4, zmm1, {sae}
// CHECK:  encoding: [0x62,0xf1,0xfd,0x18,0xe6,0xe1]
          vcvttpd2dq ymm4, zmm1, {sae}

// CHECK: vcvttpd2dq ymm4, zmmword ptr [rcx]
// CHECK:  encoding: [0x62,0xf1,0xfd,0x48,0xe6,0x21]
          vcvttpd2dq ymm4, zmmword ptr [rcx]

// CHECK: vcvttpd2dq ymm4, zmmword ptr [rax + 8*r14 + 4660]
// CHECK:  encoding: [0x62,0xb1,0xfd,0x48,0xe6,0xa4,0xf0,0x34,0x12,0x00,0x00]
          vcvttpd2dq ymm4, zmmword ptr [rax + 8*r14 + 4660]

// CHECK: vcvttpd2dq ymm4, qword ptr [rcx]{1to8}
// CHECK:  encoding: [0x62,0xf1,0xfd,0x58,0xe6,0x21]
          vcvttpd2dq ymm4, qword ptr [rcx]{1to8}

// CHECK: vcvttpd2dq ymm4, zmmword ptr [rdx + 8128]
// CHECK:  encoding: [0x62,0xf1,0xfd,0x48,0xe6,0x62,0x7f]
          vcvttpd2dq ymm4, zmmword ptr [rdx + 8128]

// CHECK: vcvttpd2dq ymm4, zmmword ptr [rdx + 8192]
// CHECK:  encoding: [0x62,0xf1,0xfd,0x48,0xe6,0xa2,0x00,0x20,0x00,0x00]
          vcvttpd2dq ymm4, zmmword ptr [rdx + 8192]

// CHECK: vcvttpd2dq ymm4, zmmword ptr [rdx - 8192]
// CHECK:  encoding: [0x62,0xf1,0xfd,0x48,0xe6,0x62,0x80]
          vcvttpd2dq ymm4, zmmword ptr [rdx - 8192]

// CHECK: vcvttpd2dq ymm4, zmmword ptr [rdx - 8256]
// CHECK:  encoding: [0x62,0xf1,0xfd,0x48,0xe6,0xa2,0xc0,0xdf,0xff,0xff]
          vcvttpd2dq ymm4, zmmword ptr [rdx - 8256]

// CHECK: vcvttpd2dq ymm4, qword ptr [rdx + 1016]{1to8}
// CHECK:  encoding: [0x62,0xf1,0xfd,0x58,0xe6,0x62,0x7f]
          vcvttpd2dq ymm4, qword ptr [rdx + 1016]{1to8}

// CHECK: vcvttpd2dq ymm4, qword ptr [rdx + 1024]{1to8}
// CHECK:  encoding: [0x62,0xf1,0xfd,0x58,0xe6,0xa2,0x00,0x04,0x00,0x00]
          vcvttpd2dq ymm4, qword ptr [rdx + 1024]{1to8}

// CHECK: vcvttpd2dq ymm4, qword ptr [rdx - 1024]{1to8}
// CHECK:  encoding: [0x62,0xf1,0xfd,0x58,0xe6,0x62,0x80]
          vcvttpd2dq ymm4, qword ptr [rdx - 1024]{1to8}

// CHECK: vcvttpd2dq ymm4, qword ptr [rdx - 1032]{1to8}
// CHECK:  encoding: [0x62,0xf1,0xfd,0x58,0xe6,0xa2,0xf8,0xfb,0xff,0xff]
          vcvttpd2dq ymm4, qword ptr [rdx - 1032]{1to8}

// CHECK: vcvttps2dq zmm23, zmm28
// CHECK:  encoding: [0x62,0x81,0x7e,0x48,0x5b,0xfc]
          vcvttps2dq zmm23, zmm28

// CHECK: vcvttps2dq zmm23 {k3}, zmm28
// CHECK:  encoding: [0x62,0x81,0x7e,0x4b,0x5b,0xfc]
          vcvttps2dq zmm23 {k3}, zmm28

// CHECK: vcvttps2dq zmm23 {k3} {z}, zmm28
// CHECK:  encoding: [0x62,0x81,0x7e,0xcb,0x5b,0xfc]
          vcvttps2dq zmm23 {k3} {z}, zmm28

// CHECK: vcvttps2dq zmm23, zmm28, {sae}
// CHECK:  encoding: [0x62,0x81,0x7e,0x18,0x5b,0xfc]
          vcvttps2dq zmm23, zmm28, {sae}

// CHECK: vcvttps2dq zmm23, zmmword ptr [rcx]
// CHECK:  encoding: [0x62,0xe1,0x7e,0x48,0x5b,0x39]
          vcvttps2dq zmm23, zmmword ptr [rcx]

// CHECK: vcvttps2dq zmm23, zmmword ptr [rax + 8*r14 + 4660]
// CHECK:  encoding: [0x62,0xa1,0x7e,0x48,0x5b,0xbc,0xf0,0x34,0x12,0x00,0x00]
          vcvttps2dq zmm23, zmmword ptr [rax + 8*r14 + 4660]

// CHECK: vcvttps2dq zmm23, dword ptr [rcx]{1to16}
// CHECK:  encoding: [0x62,0xe1,0x7e,0x58,0x5b,0x39]
          vcvttps2dq zmm23, dword ptr [rcx]{1to16}

// CHECK: vcvttps2dq zmm23, zmmword ptr [rdx + 8128]
// CHECK:  encoding: [0x62,0xe1,0x7e,0x48,0x5b,0x7a,0x7f]
          vcvttps2dq zmm23, zmmword ptr [rdx + 8128]

// CHECK: vcvttps2dq zmm23, zmmword ptr [rdx + 8192]
// CHECK:  encoding: [0x62,0xe1,0x7e,0x48,0x5b,0xba,0x00,0x20,0x00,0x00]
          vcvttps2dq zmm23, zmmword ptr [rdx + 8192]

// CHECK: vcvttps2dq zmm23, zmmword ptr [rdx - 8192]
// CHECK:  encoding: [0x62,0xe1,0x7e,0x48,0x5b,0x7a,0x80]
          vcvttps2dq zmm23, zmmword ptr [rdx - 8192]

// CHECK: vcvttps2dq zmm23, zmmword ptr [rdx - 8256]
// CHECK:  encoding: [0x62,0xe1,0x7e,0x48,0x5b,0xba,0xc0,0xdf,0xff,0xff]
          vcvttps2dq zmm23, zmmword ptr [rdx - 8256]

// CHECK: vcvttps2dq zmm23, dword ptr [rdx + 508]{1to16}
// CHECK:  encoding: [0x62,0xe1,0x7e,0x58,0x5b,0x7a,0x7f]
          vcvttps2dq zmm23, dword ptr [rdx + 508]{1to16}

// CHECK: vcvttps2dq zmm23, dword ptr [rdx + 512]{1to16}
// CHECK:  encoding: [0x62,0xe1,0x7e,0x58,0x5b,0xba,0x00,0x02,0x00,0x00]
          vcvttps2dq zmm23, dword ptr [rdx + 512]{1to16}

// CHECK: vcvttps2dq zmm23, dword ptr [rdx - 512]{1to16}
// CHECK:  encoding: [0x62,0xe1,0x7e,0x58,0x5b,0x7a,0x80]
          vcvttps2dq zmm23, dword ptr [rdx - 512]{1to16}

// CHECK: vcvttps2dq zmm23, dword ptr [rdx - 516]{1to16}
// CHECK:  encoding: [0x62,0xe1,0x7e,0x58,0x5b,0xba,0xfc,0xfd,0xff,0xff]
          vcvttps2dq zmm23, dword ptr [rdx - 516]{1to16}

// CHECK: vcvttsd2si eax, xmm5, {sae}
// CHECK:  encoding: [0x62,0xf1,0x7f,0x18,0x2c,0xc5]
          vcvttsd2si eax, xmm5, {sae}

// CHECK: vcvttsd2si ebp, xmm5, {sae}
// CHECK:  encoding: [0x62,0xf1,0x7f,0x18,0x2c,0xed]
          vcvttsd2si ebp, xmm5, {sae}

// CHECK: vcvttsd2si r13d, xmm5, {sae}
// CHECK:  encoding: [0x62,0x71,0x7f,0x18,0x2c,0xed]
          vcvttsd2si r13d, xmm5, {sae}

// CHECK: vcvttsd2si rax, xmm7, {sae}
// CHECK:  encoding: [0x62,0xf1,0xff,0x18,0x2c,0xc7]
          vcvttsd2si rax, xmm7, {sae}

// CHECK: vcvttsd2si r8, xmm7, {sae}
// CHECK:  encoding: [0x62,0x71,0xff,0x18,0x2c,0xc7]
          vcvttsd2si r8, xmm7, {sae}

// CHECK: vcvttss2si eax, xmm4, {sae}
// CHECK:  encoding: [0x62,0xf1,0x7e,0x18,0x2c,0xc4]
          vcvttss2si eax, xmm4, {sae}

// CHECK: vcvttss2si ebp, xmm4, {sae}
// CHECK:  encoding: [0x62,0xf1,0x7e,0x18,0x2c,0xec]
          vcvttss2si ebp, xmm4, {sae}

// CHECK: vcvttss2si r13d, xmm4, {sae}
// CHECK:  encoding: [0x62,0x71,0x7e,0x18,0x2c,0xec]
          vcvttss2si r13d, xmm4, {sae}

// CHECK: vcvttss2si rax, xmm27, {sae}
// CHECK:  encoding: [0x62,0x91,0xfe,0x18,0x2c,0xc3]
          vcvttss2si rax, xmm27, {sae}

// CHECK: vcvttss2si r8, xmm27, {sae}
// CHECK:  encoding: [0x62,0x11,0xfe,0x18,0x2c,0xc3]
          vcvttss2si r8, xmm27, {sae}

// CHECK: vcvtudq2pd zmm18, ymm28
// CHECK:  encoding: [0x62,0x81,0x7e,0x48,0x7a,0xd4]
          vcvtudq2pd zmm18, ymm28

// CHECK: vcvtudq2pd zmm18 {k1}, ymm28
// CHECK:  encoding: [0x62,0x81,0x7e,0x49,0x7a,0xd4]
          vcvtudq2pd zmm18 {k1}, ymm28

// CHECK: vcvtudq2pd zmm18 {k1} {z}, ymm28
// CHECK:  encoding: [0x62,0x81,0x7e,0xc9,0x7a,0xd4]
          vcvtudq2pd zmm18 {k1} {z}, ymm28

// CHECK: vcvtudq2pd zmm18, ymmword ptr [rcx]
// CHECK:  encoding: [0x62,0xe1,0x7e,0x48,0x7a,0x11]
          vcvtudq2pd zmm18, ymmword ptr [rcx]

// CHECK: vcvtudq2pd zmm18, ymmword ptr [rax + 8*r14 + 4660]
// CHECK:  encoding: [0x62,0xa1,0x7e,0x48,0x7a,0x94,0xf0,0x34,0x12,0x00,0x00]
          vcvtudq2pd zmm18, ymmword ptr [rax + 8*r14 + 4660]

// CHECK: vcvtudq2pd zmm18, dword ptr [rcx]{1to8}
// CHECK:  encoding: [0x62,0xe1,0x7e,0x58,0x7a,0x11]
          vcvtudq2pd zmm18, dword ptr [rcx]{1to8}

// CHECK: vcvtudq2pd zmm18, ymmword ptr [rdx + 4064]
// CHECK:  encoding: [0x62,0xe1,0x7e,0x48,0x7a,0x52,0x7f]
          vcvtudq2pd zmm18, ymmword ptr [rdx + 4064]

// CHECK: vcvtudq2pd zmm18, ymmword ptr [rdx + 4096]
// CHECK:  encoding: [0x62,0xe1,0x7e,0x48,0x7a,0x92,0x00,0x10,0x00,0x00]
          vcvtudq2pd zmm18, ymmword ptr [rdx + 4096]

// CHECK: vcvtudq2pd zmm18, ymmword ptr [rdx - 4096]
// CHECK:  encoding: [0x62,0xe1,0x7e,0x48,0x7a,0x52,0x80]
          vcvtudq2pd zmm18, ymmword ptr [rdx - 4096]

// CHECK: vcvtudq2pd zmm18, ymmword ptr [rdx - 4128]
// CHECK:  encoding: [0x62,0xe1,0x7e,0x48,0x7a,0x92,0xe0,0xef,0xff,0xff]
          vcvtudq2pd zmm18, ymmword ptr [rdx - 4128]

// CHECK: vcvtudq2pd zmm18, dword ptr [rdx + 508]{1to8}
// CHECK:  encoding: [0x62,0xe1,0x7e,0x58,0x7a,0x52,0x7f]
          vcvtudq2pd zmm18, dword ptr [rdx + 508]{1to8}

// CHECK: vcvtudq2pd zmm18, dword ptr [rdx + 512]{1to8}
// CHECK:  encoding: [0x62,0xe1,0x7e,0x58,0x7a,0x92,0x00,0x02,0x00,0x00]
          vcvtudq2pd zmm18, dword ptr [rdx + 512]{1to8}

// CHECK: vcvtudq2pd zmm18, dword ptr [rdx - 512]{1to8}
// CHECK:  encoding: [0x62,0xe1,0x7e,0x58,0x7a,0x52,0x80]
          vcvtudq2pd zmm18, dword ptr [rdx - 512]{1to8}

// CHECK: vcvtudq2pd zmm18, dword ptr [rdx - 516]{1to8}
// CHECK:  encoding: [0x62,0xe1,0x7e,0x58,0x7a,0x92,0xfc,0xfd,0xff,0xff]
          vcvtudq2pd zmm18, dword ptr [rdx - 516]{1to8}

// CHECK: vcvtudq2ps zmm7, zmm24
// CHECK:  encoding: [0x62,0x91,0x7f,0x48,0x7a,0xf8]
          vcvtudq2ps zmm7, zmm24

// CHECK: vcvtudq2ps zmm7 {k7}, zmm24
// CHECK:  encoding: [0x62,0x91,0x7f,0x4f,0x7a,0xf8]
          vcvtudq2ps zmm7 {k7}, zmm24

// CHECK: vcvtudq2ps zmm7 {k7} {z}, zmm24
// CHECK:  encoding: [0x62,0x91,0x7f,0xcf,0x7a,0xf8]
          vcvtudq2ps zmm7 {k7} {z}, zmm24

// CHECK: vcvtudq2ps zmm7, zmm24, {rn-sae}
// CHECK:  encoding: [0x62,0x91,0x7f,0x18,0x7a,0xf8]
          vcvtudq2ps zmm7, zmm24, {rn-sae}

// CHECK: vcvtudq2ps zmm7, zmm24, {ru-sae}
// CHECK:  encoding: [0x62,0x91,0x7f,0x58,0x7a,0xf8]
          vcvtudq2ps zmm7, zmm24, {ru-sae}

// CHECK: vcvtudq2ps zmm7, zmm24, {rd-sae}
// CHECK:  encoding: [0x62,0x91,0x7f,0x38,0x7a,0xf8]
          vcvtudq2ps zmm7, zmm24, {rd-sae}

// CHECK: vcvtudq2ps zmm7, zmm24, {rz-sae}
// CHECK:  encoding: [0x62,0x91,0x7f,0x78,0x7a,0xf8]
          vcvtudq2ps zmm7, zmm24, {rz-sae}

// CHECK: vcvtudq2ps zmm7, zmmword ptr [rcx]
// CHECK:  encoding: [0x62,0xf1,0x7f,0x48,0x7a,0x39]
          vcvtudq2ps zmm7, zmmword ptr [rcx]

// CHECK: vcvtudq2ps zmm7, zmmword ptr [rax + 8*r14 + 4660]
// CHECK:  encoding: [0x62,0xb1,0x7f,0x48,0x7a,0xbc,0xf0,0x34,0x12,0x00,0x00]
          vcvtudq2ps zmm7, zmmword ptr [rax + 8*r14 + 4660]

// CHECK: vcvtudq2ps zmm7, dword ptr [rcx]{1to16}
// CHECK:  encoding: [0x62,0xf1,0x7f,0x58,0x7a,0x39]
          vcvtudq2ps zmm7, dword ptr [rcx]{1to16}

// CHECK: vcvtudq2ps zmm7, zmmword ptr [rdx + 8128]
// CHECK:  encoding: [0x62,0xf1,0x7f,0x48,0x7a,0x7a,0x7f]
          vcvtudq2ps zmm7, zmmword ptr [rdx + 8128]

// CHECK: vcvtudq2ps zmm7, zmmword ptr [rdx + 8192]
// CHECK:  encoding: [0x62,0xf1,0x7f,0x48,0x7a,0xba,0x00,0x20,0x00,0x00]
          vcvtudq2ps zmm7, zmmword ptr [rdx + 8192]

// CHECK: vcvtudq2ps zmm7, zmmword ptr [rdx - 8192]
// CHECK:  encoding: [0x62,0xf1,0x7f,0x48,0x7a,0x7a,0x80]
          vcvtudq2ps zmm7, zmmword ptr [rdx - 8192]

// CHECK: vcvtudq2ps zmm7, zmmword ptr [rdx - 8256]
// CHECK:  encoding: [0x62,0xf1,0x7f,0x48,0x7a,0xba,0xc0,0xdf,0xff,0xff]
          vcvtudq2ps zmm7, zmmword ptr [rdx - 8256]

// CHECK: vcvtudq2ps zmm7, dword ptr [rdx + 508]{1to16}
// CHECK:  encoding: [0x62,0xf1,0x7f,0x58,0x7a,0x7a,0x7f]
          vcvtudq2ps zmm7, dword ptr [rdx + 508]{1to16}

// CHECK: vcvtudq2ps zmm7, dword ptr [rdx + 512]{1to16}
// CHECK:  encoding: [0x62,0xf1,0x7f,0x58,0x7a,0xba,0x00,0x02,0x00,0x00]
          vcvtudq2ps zmm7, dword ptr [rdx + 512]{1to16}

// CHECK: vcvtudq2ps zmm7, dword ptr [rdx - 512]{1to16}
// CHECK:  encoding: [0x62,0xf1,0x7f,0x58,0x7a,0x7a,0x80]
          vcvtudq2ps zmm7, dword ptr [rdx - 512]{1to16}

// CHECK: vcvtudq2ps zmm7, dword ptr [rdx - 516]{1to16}
// CHECK:  encoding: [0x62,0xf1,0x7f,0x58,0x7a,0xba,0xfc,0xfd,0xff,0xff]
          vcvtudq2ps zmm7, dword ptr [rdx - 516]{1to16}

// CHECK: vdivpd zmm18, zmm4, zmm19
// CHECK:  encoding: [0x62,0xa1,0xdd,0x48,0x5e,0xd3]
          vdivpd zmm18, zmm4, zmm19

// CHECK: vdivpd zmm18 {k5}, zmm4, zmm19
// CHECK:  encoding: [0x62,0xa1,0xdd,0x4d,0x5e,0xd3]
          vdivpd zmm18 {k5}, zmm4, zmm19

// CHECK: vdivpd zmm18 {k5} {z}, zmm4, zmm19
// CHECK:  encoding: [0x62,0xa1,0xdd,0xcd,0x5e,0xd3]
          vdivpd zmm18 {k5} {z}, zmm4, zmm19

// CHECK: vdivpd zmm18, zmm4, zmm19, {rn-sae}
// CHECK:  encoding: [0x62,0xa1,0xdd,0x18,0x5e,0xd3]
          vdivpd zmm18, zmm4, zmm19, {rn-sae}

// CHECK: vdivpd zmm18, zmm4, zmm19, {ru-sae}
// CHECK:  encoding: [0x62,0xa1,0xdd,0x58,0x5e,0xd3]
          vdivpd zmm18, zmm4, zmm19, {ru-sae}

// CHECK: vdivpd zmm18, zmm4, zmm19, {rd-sae}
// CHECK:  encoding: [0x62,0xa1,0xdd,0x38,0x5e,0xd3]
          vdivpd zmm18, zmm4, zmm19, {rd-sae}

// CHECK: vdivpd zmm18, zmm4, zmm19, {rz-sae}
// CHECK:  encoding: [0x62,0xa1,0xdd,0x78,0x5e,0xd3]
          vdivpd zmm18, zmm4, zmm19, {rz-sae}

// CHECK: vdivpd zmm18, zmm4, zmmword ptr [rcx]
// CHECK:  encoding: [0x62,0xe1,0xdd,0x48,0x5e,0x11]
          vdivpd zmm18, zmm4, zmmword ptr [rcx]

// CHECK: vdivpd zmm18, zmm4, zmmword ptr [rax + 8*r14 + 4660]
// CHECK:  encoding: [0x62,0xa1,0xdd,0x48,0x5e,0x94,0xf0,0x34,0x12,0x00,0x00]
          vdivpd zmm18, zmm4, zmmword ptr [rax + 8*r14 + 4660]

// CHECK: vdivpd zmm18, zmm4, qword ptr [rcx]{1to8}
// CHECK:  encoding: [0x62,0xe1,0xdd,0x58,0x5e,0x11]
          vdivpd zmm18, zmm4, qword ptr [rcx]{1to8}

// CHECK: vdivpd zmm18, zmm4, zmmword ptr [rdx + 8128]
// CHECK:  encoding: [0x62,0xe1,0xdd,0x48,0x5e,0x52,0x7f]
          vdivpd zmm18, zmm4, zmmword ptr [rdx + 8128]

// CHECK: vdivpd zmm18, zmm4, zmmword ptr [rdx + 8192]
// CHECK:  encoding: [0x62,0xe1,0xdd,0x48,0x5e,0x92,0x00,0x20,0x00,0x00]
          vdivpd zmm18, zmm4, zmmword ptr [rdx + 8192]

// CHECK: vdivpd zmm18, zmm4, zmmword ptr [rdx - 8192]
// CHECK:  encoding: [0x62,0xe1,0xdd,0x48,0x5e,0x52,0x80]
          vdivpd zmm18, zmm4, zmmword ptr [rdx - 8192]

// CHECK: vdivpd zmm18, zmm4, zmmword ptr [rdx - 8256]
// CHECK:  encoding: [0x62,0xe1,0xdd,0x48,0x5e,0x92,0xc0,0xdf,0xff,0xff]
          vdivpd zmm18, zmm4, zmmword ptr [rdx - 8256]

// CHECK: vdivpd zmm18, zmm4, qword ptr [rdx + 1016]{1to8}
// CHECK:  encoding: [0x62,0xe1,0xdd,0x58,0x5e,0x52,0x7f]
          vdivpd zmm18, zmm4, qword ptr [rdx + 1016]{1to8}

// CHECK: vdivpd zmm18, zmm4, qword ptr [rdx + 1024]{1to8}
// CHECK:  encoding: [0x62,0xe1,0xdd,0x58,0x5e,0x92,0x00,0x04,0x00,0x00]
          vdivpd zmm18, zmm4, qword ptr [rdx + 1024]{1to8}

// CHECK: vdivpd zmm18, zmm4, qword ptr [rdx - 1024]{1to8}
// CHECK:  encoding: [0x62,0xe1,0xdd,0x58,0x5e,0x52,0x80]
          vdivpd zmm18, zmm4, qword ptr [rdx - 1024]{1to8}

// CHECK: vdivpd zmm18, zmm4, qword ptr [rdx - 1032]{1to8}
// CHECK:  encoding: [0x62,0xe1,0xdd,0x58,0x5e,0x92,0xf8,0xfb,0xff,0xff]
          vdivpd zmm18, zmm4, qword ptr [rdx - 1032]{1to8}

// CHECK: vdivps zmm6, zmm29, zmm4
// CHECK:  encoding: [0x62,0xf1,0x14,0x40,0x5e,0xf4]
          vdivps zmm6, zmm29, zmm4

// CHECK: vdivps zmm6 {k6}, zmm29, zmm4
// CHECK:  encoding: [0x62,0xf1,0x14,0x46,0x5e,0xf4]
          vdivps zmm6 {k6}, zmm29, zmm4

// CHECK: vdivps zmm6 {k6} {z}, zmm29, zmm4
// CHECK:  encoding: [0x62,0xf1,0x14,0xc6,0x5e,0xf4]
          vdivps zmm6 {k6} {z}, zmm29, zmm4

// CHECK: vdivps zmm6, zmm29, zmm4, {rn-sae}
// CHECK:  encoding: [0x62,0xf1,0x14,0x10,0x5e,0xf4]
          vdivps zmm6, zmm29, zmm4, {rn-sae}

// CHECK: vdivps zmm6, zmm29, zmm4, {ru-sae}
// CHECK:  encoding: [0x62,0xf1,0x14,0x50,0x5e,0xf4]
          vdivps zmm6, zmm29, zmm4, {ru-sae}

// CHECK: vdivps zmm6, zmm29, zmm4, {rd-sae}
// CHECK:  encoding: [0x62,0xf1,0x14,0x30,0x5e,0xf4]
          vdivps zmm6, zmm29, zmm4, {rd-sae}

// CHECK: vdivps zmm6, zmm29, zmm4, {rz-sae}
// CHECK:  encoding: [0x62,0xf1,0x14,0x70,0x5e,0xf4]
          vdivps zmm6, zmm29, zmm4, {rz-sae}

// CHECK: vdivps zmm6, zmm29, zmmword ptr [rcx]
// CHECK:  encoding: [0x62,0xf1,0x14,0x40,0x5e,0x31]
          vdivps zmm6, zmm29, zmmword ptr [rcx]

// CHECK: vdivps zmm6, zmm29, zmmword ptr [rax + 8*r14 + 4660]
// CHECK:  encoding: [0x62,0xb1,0x14,0x40,0x5e,0xb4,0xf0,0x34,0x12,0x00,0x00]
          vdivps zmm6, zmm29, zmmword ptr [rax + 8*r14 + 4660]

// CHECK: vdivps zmm6, zmm29, dword ptr [rcx]{1to16}
// CHECK:  encoding: [0x62,0xf1,0x14,0x50,0x5e,0x31]
          vdivps zmm6, zmm29, dword ptr [rcx]{1to16}

// CHECK: vdivps zmm6, zmm29, zmmword ptr [rdx + 8128]
// CHECK:  encoding: [0x62,0xf1,0x14,0x40,0x5e,0x72,0x7f]
          vdivps zmm6, zmm29, zmmword ptr [rdx + 8128]

// CHECK: vdivps zmm6, zmm29, zmmword ptr [rdx + 8192]
// CHECK:  encoding: [0x62,0xf1,0x14,0x40,0x5e,0xb2,0x00,0x20,0x00,0x00]
          vdivps zmm6, zmm29, zmmword ptr [rdx + 8192]

// CHECK: vdivps zmm6, zmm29, zmmword ptr [rdx - 8192]
// CHECK:  encoding: [0x62,0xf1,0x14,0x40,0x5e,0x72,0x80]
          vdivps zmm6, zmm29, zmmword ptr [rdx - 8192]

// CHECK: vdivps zmm6, zmm29, zmmword ptr [rdx - 8256]
// CHECK:  encoding: [0x62,0xf1,0x14,0x40,0x5e,0xb2,0xc0,0xdf,0xff,0xff]
          vdivps zmm6, zmm29, zmmword ptr [rdx - 8256]

// CHECK: vdivps zmm6, zmm29, dword ptr [rdx + 508]{1to16}
// CHECK:  encoding: [0x62,0xf1,0x14,0x50,0x5e,0x72,0x7f]
          vdivps zmm6, zmm29, dword ptr [rdx + 508]{1to16}

// CHECK: vdivps zmm6, zmm29, dword ptr [rdx + 512]{1to16}
// CHECK:  encoding: [0x62,0xf1,0x14,0x50,0x5e,0xb2,0x00,0x02,0x00,0x00]
          vdivps zmm6, zmm29, dword ptr [rdx + 512]{1to16}

// CHECK: vdivps zmm6, zmm29, dword ptr [rdx - 512]{1to16}
// CHECK:  encoding: [0x62,0xf1,0x14,0x50,0x5e,0x72,0x80]
          vdivps zmm6, zmm29, dword ptr [rdx - 512]{1to16}

// CHECK: vdivps zmm6, zmm29, dword ptr [rdx - 516]{1to16}
// CHECK:  encoding: [0x62,0xf1,0x14,0x50,0x5e,0xb2,0xfc,0xfd,0xff,0xff]
          vdivps zmm6, zmm29, dword ptr [rdx - 516]{1to16}

// CHECK: vdivsd xmm15, xmm4, xmm22
// CHECK:  encoding: [0x62,0x31,0xdf,0x08,0x5e,0xfe]
          vdivsd xmm15, xmm4, xmm22

// CHECK: vdivsd xmm15 {k3}, xmm4, xmm22
// CHECK:  encoding: [0x62,0x31,0xdf,0x0b,0x5e,0xfe]
          vdivsd xmm15 {k3}, xmm4, xmm22

// CHECK: vdivsd xmm15 {k3} {z}, xmm4, xmm22
// CHECK:  encoding: [0x62,0x31,0xdf,0x8b,0x5e,0xfe]
          vdivsd xmm15 {k3} {z}, xmm4, xmm22

// CHECK: vdivsd xmm15, xmm4, xmm22, {rn-sae}
// CHECK:  encoding: [0x62,0x31,0xdf,0x18,0x5e,0xfe]
          vdivsd xmm15, xmm4, xmm22, {rn-sae}

// CHECK: vdivsd xmm15, xmm4, xmm22, {ru-sae}
// CHECK:  encoding: [0x62,0x31,0xdf,0x58,0x5e,0xfe]
          vdivsd xmm15, xmm4, xmm22, {ru-sae}

// CHECK: vdivsd xmm15, xmm4, xmm22, {rd-sae}
// CHECK:  encoding: [0x62,0x31,0xdf,0x38,0x5e,0xfe]
          vdivsd xmm15, xmm4, xmm22, {rd-sae}

// CHECK: vdivsd xmm15, xmm4, xmm22, {rz-sae}
// CHECK:  encoding: [0x62,0x31,0xdf,0x78,0x5e,0xfe]
          vdivsd xmm15, xmm4, xmm22, {rz-sae}

// CHECK: vdivsd xmm15, xmm4, qword ptr [rcx]
// CHECK:  encoding: [0xc5,0x5b,0x5e,0x39]
          vdivsd xmm15, xmm4, qword ptr [rcx]

// CHECK: vdivsd xmm15, xmm4, qword ptr [rax + 8*r14 + 4660]
// CHECK:  encoding: [0xc4,0x21,0x5b,0x5e,0xbc,0xf0,0x34,0x12,0x00,0x00]
          vdivsd xmm15, xmm4, qword ptr [rax + 8*r14 + 4660]

// CHECK: vdivsd xmm15, xmm4, qword ptr [rdx + 1016]
// CHECK:  encoding: [0xc5,0x5b,0x5e,0xba,0xf8,0x03,0x00,0x00]
          vdivsd xmm15, xmm4, qword ptr [rdx + 1016]

// CHECK: vdivsd xmm15, xmm4, qword ptr [rdx + 1024]
// CHECK:  encoding: [0xc5,0x5b,0x5e,0xba,0x00,0x04,0x00,0x00]
          vdivsd xmm15, xmm4, qword ptr [rdx + 1024]

// CHECK: vdivsd xmm15, xmm4, qword ptr [rdx - 1024]
// CHECK:  encoding: [0xc5,0x5b,0x5e,0xba,0x00,0xfc,0xff,0xff]
          vdivsd xmm15, xmm4, qword ptr [rdx - 1024]

// CHECK: vdivsd xmm15, xmm4, qword ptr [rdx - 1032]
// CHECK:  encoding: [0xc5,0x5b,0x5e,0xba,0xf8,0xfb,0xff,0xff]
          vdivsd xmm15, xmm4, qword ptr [rdx - 1032]

// CHECK: vdivss xmm27, xmm2, xmm20
// CHECK:  encoding: [0x62,0x21,0x6e,0x08,0x5e,0xdc]
          vdivss xmm27, xmm2, xmm20

// CHECK: vdivss xmm27 {k5}, xmm2, xmm20
// CHECK:  encoding: [0x62,0x21,0x6e,0x0d,0x5e,0xdc]
          vdivss xmm27 {k5}, xmm2, xmm20

// CHECK: vdivss xmm27 {k5} {z}, xmm2, xmm20
// CHECK:  encoding: [0x62,0x21,0x6e,0x8d,0x5e,0xdc]
          vdivss xmm27 {k5} {z}, xmm2, xmm20

// CHECK: vdivss xmm27, xmm2, xmm20, {rn-sae}
// CHECK:  encoding: [0x62,0x21,0x6e,0x18,0x5e,0xdc]
          vdivss xmm27, xmm2, xmm20, {rn-sae}

// CHECK: vdivss xmm27, xmm2, xmm20, {ru-sae}
// CHECK:  encoding: [0x62,0x21,0x6e,0x58,0x5e,0xdc]
          vdivss xmm27, xmm2, xmm20, {ru-sae}

// CHECK: vdivss xmm27, xmm2, xmm20, {rd-sae}
// CHECK:  encoding: [0x62,0x21,0x6e,0x38,0x5e,0xdc]
          vdivss xmm27, xmm2, xmm20, {rd-sae}

// CHECK: vdivss xmm27, xmm2, xmm20, {rz-sae}
// CHECK:  encoding: [0x62,0x21,0x6e,0x78,0x5e,0xdc]
          vdivss xmm27, xmm2, xmm20, {rz-sae}

// CHECK: vdivss xmm27, xmm2, dword ptr [rcx]
// CHECK:  encoding: [0x62,0x61,0x6e,0x08,0x5e,0x19]
          vdivss xmm27, xmm2, dword ptr [rcx]

// CHECK: vdivss xmm27, xmm2, dword ptr [rax + 8*r14 + 4660]
// CHECK:  encoding: [0x62,0x21,0x6e,0x08,0x5e,0x9c,0xf0,0x34,0x12,0x00,0x00]
          vdivss xmm27, xmm2, dword ptr [rax + 8*r14 + 4660]

// CHECK: vdivss xmm27, xmm2, dword ptr [rdx + 508]
// CHECK:  encoding: [0x62,0x61,0x6e,0x08,0x5e,0x5a,0x7f]
          vdivss xmm27, xmm2, dword ptr [rdx + 508]

// CHECK: vdivss xmm27, xmm2, dword ptr [rdx + 512]
// CHECK:  encoding: [0x62,0x61,0x6e,0x08,0x5e,0x9a,0x00,0x02,0x00,0x00]
          vdivss xmm27, xmm2, dword ptr [rdx + 512]

// CHECK: vdivss xmm27, xmm2, dword ptr [rdx - 512]
// CHECK:  encoding: [0x62,0x61,0x6e,0x08,0x5e,0x5a,0x80]
          vdivss xmm27, xmm2, dword ptr [rdx - 512]

// CHECK: vdivss xmm27, xmm2, dword ptr [rdx - 516]
// CHECK:  encoding: [0x62,0x61,0x6e,0x08,0x5e,0x9a,0xfc,0xfd,0xff,0xff]
          vdivss xmm27, xmm2, dword ptr [rdx - 516]

// CHECK: vexpandpd zmm4, zmmword ptr [rcx]
// CHECK:  encoding: [0x62,0xf2,0xfd,0x48,0x88,0x21]
          vexpandpd zmm4, zmmword ptr [rcx]

// CHECK: vexpandpd zmm4 {k7}, zmmword ptr [rcx]
// CHECK:  encoding: [0x62,0xf2,0xfd,0x4f,0x88,0x21]
          vexpandpd zmm4 {k7}, zmmword ptr [rcx]

// CHECK: vexpandpd zmm4 {k7} {z}, zmmword ptr [rcx]
// CHECK:  encoding: [0x62,0xf2,0xfd,0xcf,0x88,0x21]
          vexpandpd zmm4 {k7} {z}, zmmword ptr [rcx]

// CHECK: vexpandpd zmm4, zmmword ptr [rax + 8*r14 + 4660]
// CHECK:  encoding: [0x62,0xb2,0xfd,0x48,0x88,0xa4,0xf0,0x34,0x12,0x00,0x00]
          vexpandpd zmm4, zmmword ptr [rax + 8*r14 + 4660]

// CHECK: vexpandpd zmm4, zmmword ptr [rdx + 1016]
// CHECK:  encoding: [0x62,0xf2,0xfd,0x48,0x88,0x62,0x7f]
          vexpandpd zmm4, zmmword ptr [rdx + 1016]

// CHECK: vexpandpd zmm4, zmmword ptr [rdx + 1024]
// CHECK:  encoding: [0x62,0xf2,0xfd,0x48,0x88,0xa2,0x00,0x04,0x00,0x00]
          vexpandpd zmm4, zmmword ptr [rdx + 1024]

// CHECK: vexpandpd zmm4, zmmword ptr [rdx - 1024]
// CHECK:  encoding: [0x62,0xf2,0xfd,0x48,0x88,0x62,0x80]
          vexpandpd zmm4, zmmword ptr [rdx - 1024]

// CHECK: vexpandpd zmm4, zmmword ptr [rdx - 1032]
// CHECK:  encoding: [0x62,0xf2,0xfd,0x48,0x88,0xa2,0xf8,0xfb,0xff,0xff]
          vexpandpd zmm4, zmmword ptr [rdx - 1032]

// CHECK: vexpandpd zmm18, zmm9
// CHECK:  encoding: [0x62,0xc2,0xfd,0x48,0x88,0xd1]
          vexpandpd zmm18, zmm9

// CHECK: vexpandpd zmm18 {k2}, zmm9
// CHECK:  encoding: [0x62,0xc2,0xfd,0x4a,0x88,0xd1]
          vexpandpd zmm18 {k2}, zmm9

// CHECK: vexpandpd zmm18 {k2} {z}, zmm9
// CHECK:  encoding: [0x62,0xc2,0xfd,0xca,0x88,0xd1]
          vexpandpd zmm18 {k2} {z}, zmm9

// CHECK: vexpandps zmm28, zmmword ptr [rcx]
// CHECK:  encoding: [0x62,0x62,0x7d,0x48,0x88,0x21]
          vexpandps zmm28, zmmword ptr [rcx]

// CHECK: vexpandps zmm28 {k7}, zmmword ptr [rcx]
// CHECK:  encoding: [0x62,0x62,0x7d,0x4f,0x88,0x21]
          vexpandps zmm28 {k7}, zmmword ptr [rcx]

// CHECK: vexpandps zmm28 {k7} {z}, zmmword ptr [rcx]
// CHECK:  encoding: [0x62,0x62,0x7d,0xcf,0x88,0x21]
          vexpandps zmm28 {k7} {z}, zmmword ptr [rcx]

// CHECK: vexpandps zmm28, zmmword ptr [rax + 8*r14 + 4660]
// CHECK:  encoding: [0x62,0x22,0x7d,0x48,0x88,0xa4,0xf0,0x34,0x12,0x00,0x00]
          vexpandps zmm28, zmmword ptr [rax + 8*r14 + 4660]

// CHECK: vexpandps zmm28, zmmword ptr [rdx + 508]
// CHECK:  encoding: [0x62,0x62,0x7d,0x48,0x88,0x62,0x7f]
          vexpandps zmm28, zmmword ptr [rdx + 508]

// CHECK: vexpandps zmm28, zmmword ptr [rdx + 512]
// CHECK:  encoding: [0x62,0x62,0x7d,0x48,0x88,0xa2,0x00,0x02,0x00,0x00]
          vexpandps zmm28, zmmword ptr [rdx + 512]

// CHECK: vexpandps zmm28, zmmword ptr [rdx - 512]
// CHECK:  encoding: [0x62,0x62,0x7d,0x48,0x88,0x62,0x80]
          vexpandps zmm28, zmmword ptr [rdx - 512]

// CHECK: vexpandps zmm28, zmmword ptr [rdx - 516]
// CHECK:  encoding: [0x62,0x62,0x7d,0x48,0x88,0xa2,0xfc,0xfd,0xff,0xff]
          vexpandps zmm28, zmmword ptr [rdx - 516]

// CHECK: vexpandps zmm17, zmm18
// CHECK:  encoding: [0x62,0xa2,0x7d,0x48,0x88,0xca]
          vexpandps zmm17, zmm18

// CHECK: vexpandps zmm17 {k1}, zmm18
// CHECK:  encoding: [0x62,0xa2,0x7d,0x49,0x88,0xca]
          vexpandps zmm17 {k1}, zmm18

// CHECK: vexpandps zmm17 {k1} {z}, zmm18
// CHECK:  encoding: [0x62,0xa2,0x7d,0xc9,0x88,0xca]
          vexpandps zmm17 {k1} {z}, zmm18

// CHECK: vextractf32x4 xmm21, zmm10, 171
// CHECK:  encoding: [0x62,0x33,0x7d,0x48,0x19,0xd5,0xab]
          vextractf32x4 xmm21, zmm10, 171

// CHECK: vextractf32x4 xmm21 {k2}, zmm10, 171
// CHECK:  encoding: [0x62,0x33,0x7d,0x4a,0x19,0xd5,0xab]
          vextractf32x4 xmm21 {k2}, zmm10, 171

// CHECK: vextractf32x4 xmm21 {k2} {z}, zmm10, 171
// CHECK:  encoding: [0x62,0x33,0x7d,0xca,0x19,0xd5,0xab]
          vextractf32x4 xmm21 {k2} {z}, zmm10, 171

// CHECK: vextractf32x4 xmm21, zmm10, 123
// CHECK:  encoding: [0x62,0x33,0x7d,0x48,0x19,0xd5,0x7b]
          vextractf32x4 xmm21, zmm10, 123

// CHECK: vextractf64x4 ymm14, zmm5, 171
// CHECK:  encoding: [0x62,0xd3,0xfd,0x48,0x1b,0xee,0xab]
          vextractf64x4 ymm14, zmm5, 171

// CHECK: vextractf64x4 ymm14 {k3}, zmm5, 171
// CHECK:  encoding: [0x62,0xd3,0xfd,0x4b,0x1b,0xee,0xab]
          vextractf64x4 ymm14 {k3}, zmm5, 171

// CHECK: vextractf64x4 ymm14 {k3} {z}, zmm5, 171
// CHECK:  encoding: [0x62,0xd3,0xfd,0xcb,0x1b,0xee,0xab]
          vextractf64x4 ymm14 {k3} {z}, zmm5, 171

// CHECK: vextractf64x4 ymm14, zmm5, 123
// CHECK:  encoding: [0x62,0xd3,0xfd,0x48,0x1b,0xee,0x7b]
          vextractf64x4 ymm14, zmm5, 123

// CHECK: vextracti32x4 xmm29, zmm12, 171
// CHECK:  encoding: [0x62,0x13,0x7d,0x48,0x39,0xe5,0xab]
          vextracti32x4 xmm29, zmm12, 171

// CHECK: vextracti32x4 xmm29 {k5}, zmm12, 171
// CHECK:  encoding: [0x62,0x13,0x7d,0x4d,0x39,0xe5,0xab]
          vextracti32x4 xmm29 {k5}, zmm12, 171

// CHECK: vextracti32x4 xmm29 {k5} {z}, zmm12, 171
// CHECK:  encoding: [0x62,0x13,0x7d,0xcd,0x39,0xe5,0xab]
          vextracti32x4 xmm29 {k5} {z}, zmm12, 171

// CHECK: vextracti32x4 xmm29, zmm12, 123
// CHECK:  encoding: [0x62,0x13,0x7d,0x48,0x39,0xe5,0x7b]
          vextracti32x4 xmm29, zmm12, 123

// CHECK: vextracti64x4 ymm5, zmm22, 171
// CHECK:  encoding: [0x62,0xe3,0xfd,0x48,0x3b,0xf5,0xab]
          vextracti64x4 ymm5, zmm22, 171

// CHECK: vextracti64x4 ymm5 {k6}, zmm22, 171
// CHECK:  encoding: [0x62,0xe3,0xfd,0x4e,0x3b,0xf5,0xab]
          vextracti64x4 ymm5 {k6}, zmm22, 171

// CHECK: vextracti64x4 ymm5 {k6} {z}, zmm22, 171
// CHECK:  encoding: [0x62,0xe3,0xfd,0xce,0x3b,0xf5,0xab]
          vextracti64x4 ymm5 {k6} {z}, zmm22, 171

// CHECK: vextracti64x4 ymm5, zmm22, 123
// CHECK:  encoding: [0x62,0xe3,0xfd,0x48,0x3b,0xf5,0x7b]
          vextracti64x4 ymm5, zmm22, 123

// CHECK: vfmadd132pd zmm23, zmm15, zmm11
// CHECK:  encoding: [0x62,0xc2,0x85,0x48,0x98,0xfb]
          vfmadd132pd zmm23, zmm15, zmm11

// CHECK: vfmadd132pd zmm23 {k7}, zmm15, zmm11
// CHECK:  encoding: [0x62,0xc2,0x85,0x4f,0x98,0xfb]
          vfmadd132pd zmm23 {k7}, zmm15, zmm11

// CHECK: vfmadd132pd zmm23 {k7} {z}, zmm15, zmm11
// CHECK:  encoding: [0x62,0xc2,0x85,0xcf,0x98,0xfb]
          vfmadd132pd zmm23 {k7} {z}, zmm15, zmm11

// CHECK: vfmadd132pd zmm23, zmm15, zmm11, {rn-sae}
// CHECK:  encoding: [0x62,0xc2,0x85,0x18,0x98,0xfb]
          vfmadd132pd zmm23, zmm15, zmm11, {rn-sae}

// CHECK: vfmadd132pd zmm23, zmm15, zmm11, {ru-sae}
// CHECK:  encoding: [0x62,0xc2,0x85,0x58,0x98,0xfb]
          vfmadd132pd zmm23, zmm15, zmm11, {ru-sae}

// CHECK: vfmadd132pd zmm23, zmm15, zmm11, {rd-sae}
// CHECK:  encoding: [0x62,0xc2,0x85,0x38,0x98,0xfb]
          vfmadd132pd zmm23, zmm15, zmm11, {rd-sae}

// CHECK: vfmadd132pd zmm23, zmm15, zmm11, {rz-sae}
// CHECK:  encoding: [0x62,0xc2,0x85,0x78,0x98,0xfb]
          vfmadd132pd zmm23, zmm15, zmm11, {rz-sae}

// CHECK: vfmadd132pd zmm23, zmm15, zmmword ptr [rcx]
// CHECK:  encoding: [0x62,0xe2,0x85,0x48,0x98,0x39]
          vfmadd132pd zmm23, zmm15, zmmword ptr [rcx]

// CHECK: vfmadd132pd zmm23, zmm15, zmmword ptr [rax + 8*r14 + 4660]
// CHECK:  encoding: [0x62,0xa2,0x85,0x48,0x98,0xbc,0xf0,0x34,0x12,0x00,0x00]
          vfmadd132pd zmm23, zmm15, zmmword ptr [rax + 8*r14 + 4660]

// CHECK: vfmadd132pd zmm23, zmm15, qword ptr [rcx]{1to8}
// CHECK:  encoding: [0x62,0xe2,0x85,0x58,0x98,0x39]
          vfmadd132pd zmm23, zmm15, qword ptr [rcx]{1to8}

// CHECK: vfmadd132pd zmm23, zmm15, zmmword ptr [rdx + 8128]
// CHECK:  encoding: [0x62,0xe2,0x85,0x48,0x98,0x7a,0x7f]
          vfmadd132pd zmm23, zmm15, zmmword ptr [rdx + 8128]

// CHECK: vfmadd132pd zmm23, zmm15, zmmword ptr [rdx + 8192]
// CHECK:  encoding: [0x62,0xe2,0x85,0x48,0x98,0xba,0x00,0x20,0x00,0x00]
          vfmadd132pd zmm23, zmm15, zmmword ptr [rdx + 8192]

// CHECK: vfmadd132pd zmm23, zmm15, zmmword ptr [rdx - 8192]
// CHECK:  encoding: [0x62,0xe2,0x85,0x48,0x98,0x7a,0x80]
          vfmadd132pd zmm23, zmm15, zmmword ptr [rdx - 8192]

// CHECK: vfmadd132pd zmm23, zmm15, zmmword ptr [rdx - 8256]
// CHECK:  encoding: [0x62,0xe2,0x85,0x48,0x98,0xba,0xc0,0xdf,0xff,0xff]
          vfmadd132pd zmm23, zmm15, zmmword ptr [rdx - 8256]

// CHECK: vfmadd132pd zmm23, zmm15, qword ptr [rdx + 1016]{1to8}
// CHECK:  encoding: [0x62,0xe2,0x85,0x58,0x98,0x7a,0x7f]
          vfmadd132pd zmm23, zmm15, qword ptr [rdx + 1016]{1to8}

// CHECK: vfmadd132pd zmm23, zmm15, qword ptr [rdx + 1024]{1to8}
// CHECK:  encoding: [0x62,0xe2,0x85,0x58,0x98,0xba,0x00,0x04,0x00,0x00]
          vfmadd132pd zmm23, zmm15, qword ptr [rdx + 1024]{1to8}

// CHECK: vfmadd132pd zmm23, zmm15, qword ptr [rdx - 1024]{1to8}
// CHECK:  encoding: [0x62,0xe2,0x85,0x58,0x98,0x7a,0x80]
          vfmadd132pd zmm23, zmm15, qword ptr [rdx - 1024]{1to8}

// CHECK: vfmadd132pd zmm23, zmm15, qword ptr [rdx - 1032]{1to8}
// CHECK:  encoding: [0x62,0xe2,0x85,0x58,0x98,0xba,0xf8,0xfb,0xff,0xff]
          vfmadd132pd zmm23, zmm15, qword ptr [rdx - 1032]{1to8}

// CHECK: vfmadd132ps zmm19, zmm25, zmm17
// CHECK:  encoding: [0x62,0xa2,0x35,0x40,0x98,0xd9]
          vfmadd132ps zmm19, zmm25, zmm17

// CHECK: vfmadd132ps zmm19 {k6}, zmm25, zmm17
// CHECK:  encoding: [0x62,0xa2,0x35,0x46,0x98,0xd9]
          vfmadd132ps zmm19 {k6}, zmm25, zmm17

// CHECK: vfmadd132ps zmm19 {k6} {z}, zmm25, zmm17
// CHECK:  encoding: [0x62,0xa2,0x35,0xc6,0x98,0xd9]
          vfmadd132ps zmm19 {k6} {z}, zmm25, zmm17

// CHECK: vfmadd132ps zmm19, zmm25, zmm17, {rn-sae}
// CHECK:  encoding: [0x62,0xa2,0x35,0x10,0x98,0xd9]
          vfmadd132ps zmm19, zmm25, zmm17, {rn-sae}

// CHECK: vfmadd132ps zmm19, zmm25, zmm17, {ru-sae}
// CHECK:  encoding: [0x62,0xa2,0x35,0x50,0x98,0xd9]
          vfmadd132ps zmm19, zmm25, zmm17, {ru-sae}

// CHECK: vfmadd132ps zmm19, zmm25, zmm17, {rd-sae}
// CHECK:  encoding: [0x62,0xa2,0x35,0x30,0x98,0xd9]
          vfmadd132ps zmm19, zmm25, zmm17, {rd-sae}

// CHECK: vfmadd132ps zmm19, zmm25, zmm17, {rz-sae}
// CHECK:  encoding: [0x62,0xa2,0x35,0x70,0x98,0xd9]
          vfmadd132ps zmm19, zmm25, zmm17, {rz-sae}

// CHECK: vfmadd132ps zmm19, zmm25, zmmword ptr [rcx]
// CHECK:  encoding: [0x62,0xe2,0x35,0x40,0x98,0x19]
          vfmadd132ps zmm19, zmm25, zmmword ptr [rcx]

// CHECK: vfmadd132ps zmm19, zmm25, zmmword ptr [rax + 8*r14 + 4660]
// CHECK:  encoding: [0x62,0xa2,0x35,0x40,0x98,0x9c,0xf0,0x34,0x12,0x00,0x00]
          vfmadd132ps zmm19, zmm25, zmmword ptr [rax + 8*r14 + 4660]

// CHECK: vfmadd132ps zmm19, zmm25, dword ptr [rcx]{1to16}
// CHECK:  encoding: [0x62,0xe2,0x35,0x50,0x98,0x19]
          vfmadd132ps zmm19, zmm25, dword ptr [rcx]{1to16}

// CHECK: vfmadd132ps zmm19, zmm25, zmmword ptr [rdx + 8128]
// CHECK:  encoding: [0x62,0xe2,0x35,0x40,0x98,0x5a,0x7f]
          vfmadd132ps zmm19, zmm25, zmmword ptr [rdx + 8128]

// CHECK: vfmadd132ps zmm19, zmm25, zmmword ptr [rdx + 8192]
// CHECK:  encoding: [0x62,0xe2,0x35,0x40,0x98,0x9a,0x00,0x20,0x00,0x00]
          vfmadd132ps zmm19, zmm25, zmmword ptr [rdx + 8192]

// CHECK: vfmadd132ps zmm19, zmm25, zmmword ptr [rdx - 8192]
// CHECK:  encoding: [0x62,0xe2,0x35,0x40,0x98,0x5a,0x80]
          vfmadd132ps zmm19, zmm25, zmmword ptr [rdx - 8192]

// CHECK: vfmadd132ps zmm19, zmm25, zmmword ptr [rdx - 8256]
// CHECK:  encoding: [0x62,0xe2,0x35,0x40,0x98,0x9a,0xc0,0xdf,0xff,0xff]
          vfmadd132ps zmm19, zmm25, zmmword ptr [rdx - 8256]

// CHECK: vfmadd132ps zmm19, zmm25, dword ptr [rdx + 508]{1to16}
// CHECK:  encoding: [0x62,0xe2,0x35,0x50,0x98,0x5a,0x7f]
          vfmadd132ps zmm19, zmm25, dword ptr [rdx + 508]{1to16}

// CHECK: vfmadd132ps zmm19, zmm25, dword ptr [rdx + 512]{1to16}
// CHECK:  encoding: [0x62,0xe2,0x35,0x50,0x98,0x9a,0x00,0x02,0x00,0x00]
          vfmadd132ps zmm19, zmm25, dword ptr [rdx + 512]{1to16}

// CHECK: vfmadd132ps zmm19, zmm25, dword ptr [rdx - 512]{1to16}
// CHECK:  encoding: [0x62,0xe2,0x35,0x50,0x98,0x5a,0x80]
          vfmadd132ps zmm19, zmm25, dword ptr [rdx - 512]{1to16}

// CHECK: vfmadd132ps zmm19, zmm25, dword ptr [rdx - 516]{1to16}
// CHECK:  encoding: [0x62,0xe2,0x35,0x50,0x98,0x9a,0xfc,0xfd,0xff,0xff]
          vfmadd132ps zmm19, zmm25, dword ptr [rdx - 516]{1to16}

// CHECK: vfmadd132sd xmm18, xmm22, xmm11
// CHECK:  encoding: [0x62,0xc2,0xcd,0x00,0x99,0xd3]
          vfmadd132sd xmm18, xmm22, xmm11

// CHECK: vfmadd132sd xmm18 {k6}, xmm22, xmm11
// CHECK:  encoding: [0x62,0xc2,0xcd,0x06,0x99,0xd3]
          vfmadd132sd xmm18 {k6}, xmm22, xmm11

// CHECK: vfmadd132sd xmm18 {k6} {z}, xmm22, xmm11
// CHECK:  encoding: [0x62,0xc2,0xcd,0x86,0x99,0xd3]
          vfmadd132sd xmm18 {k6} {z}, xmm22, xmm11

// CHECK: vfmadd132sd xmm18, xmm22, xmm11, {rn-sae}
// CHECK:  encoding: [0x62,0xc2,0xcd,0x10,0x99,0xd3]
          vfmadd132sd xmm18, xmm22, xmm11, {rn-sae}

// CHECK: vfmadd132sd xmm18, xmm22, xmm11, {ru-sae}
// CHECK:  encoding: [0x62,0xc2,0xcd,0x50,0x99,0xd3]
          vfmadd132sd xmm18, xmm22, xmm11, {ru-sae}

// CHECK: vfmadd132sd xmm18, xmm22, xmm11, {rd-sae}
// CHECK:  encoding: [0x62,0xc2,0xcd,0x30,0x99,0xd3]
          vfmadd132sd xmm18, xmm22, xmm11, {rd-sae}

// CHECK: vfmadd132sd xmm18, xmm22, xmm11, {rz-sae}
// CHECK:  encoding: [0x62,0xc2,0xcd,0x70,0x99,0xd3]
          vfmadd132sd xmm18, xmm22, xmm11, {rz-sae}

// CHECK: vfmadd132sd xmm18, xmm22, qword ptr [rcx]
// CHECK:  encoding: [0x62,0xe2,0xcd,0x00,0x99,0x11]
          vfmadd132sd xmm18, xmm22, qword ptr [rcx]

// CHECK: vfmadd132sd xmm18, xmm22, qword ptr [rax + 8*r14 + 4660]
// CHECK:  encoding: [0x62,0xa2,0xcd,0x00,0x99,0x94,0xf0,0x34,0x12,0x00,0x00]
          vfmadd132sd xmm18, xmm22, qword ptr [rax + 8*r14 + 4660]

// CHECK: vfmadd132sd xmm18, xmm22, qword ptr [rdx + 1016]
// CHECK:  encoding: [0x62,0xe2,0xcd,0x00,0x99,0x52,0x7f]
          vfmadd132sd xmm18, xmm22, qword ptr [rdx + 1016]

// CHECK: vfmadd132sd xmm18, xmm22, qword ptr [rdx + 1024]
// CHECK:  encoding: [0x62,0xe2,0xcd,0x00,0x99,0x92,0x00,0x04,0x00,0x00]
          vfmadd132sd xmm18, xmm22, qword ptr [rdx + 1024]

// CHECK: vfmadd132sd xmm18, xmm22, qword ptr [rdx - 1024]
// CHECK:  encoding: [0x62,0xe2,0xcd,0x00,0x99,0x52,0x80]
          vfmadd132sd xmm18, xmm22, qword ptr [rdx - 1024]

// CHECK: vfmadd132sd xmm18, xmm22, qword ptr [rdx - 1032]
// CHECK:  encoding: [0x62,0xe2,0xcd,0x00,0x99,0x92,0xf8,0xfb,0xff,0xff]
          vfmadd132sd xmm18, xmm22, qword ptr [rdx - 1032]

// CHECK: vfmadd132ss xmm26, xmm20, xmm7
// CHECK:  encoding: [0x62,0x62,0x5d,0x00,0x99,0xd7]
          vfmadd132ss xmm26, xmm20, xmm7

// CHECK: vfmadd132ss xmm26 {k7}, xmm20, xmm7
// CHECK:  encoding: [0x62,0x62,0x5d,0x07,0x99,0xd7]
          vfmadd132ss xmm26 {k7}, xmm20, xmm7

// CHECK: vfmadd132ss xmm26 {k7} {z}, xmm20, xmm7
// CHECK:  encoding: [0x62,0x62,0x5d,0x87,0x99,0xd7]
          vfmadd132ss xmm26 {k7} {z}, xmm20, xmm7

// CHECK: vfmadd132ss xmm26, xmm20, xmm7, {rn-sae}
// CHECK:  encoding: [0x62,0x62,0x5d,0x10,0x99,0xd7]
          vfmadd132ss xmm26, xmm20, xmm7, {rn-sae}

// CHECK: vfmadd132ss xmm26, xmm20, xmm7, {ru-sae}
// CHECK:  encoding: [0x62,0x62,0x5d,0x50,0x99,0xd7]
          vfmadd132ss xmm26, xmm20, xmm7, {ru-sae}

// CHECK: vfmadd132ss xmm26, xmm20, xmm7, {rd-sae}
// CHECK:  encoding: [0x62,0x62,0x5d,0x30,0x99,0xd7]
          vfmadd132ss xmm26, xmm20, xmm7, {rd-sae}

// CHECK: vfmadd132ss xmm26, xmm20, xmm7, {rz-sae}
// CHECK:  encoding: [0x62,0x62,0x5d,0x70,0x99,0xd7]
          vfmadd132ss xmm26, xmm20, xmm7, {rz-sae}

// CHECK: vfmadd132ss xmm26, xmm20, dword ptr [rcx]
// CHECK:  encoding: [0x62,0x62,0x5d,0x00,0x99,0x11]
          vfmadd132ss xmm26, xmm20, dword ptr [rcx]

// CHECK: vfmadd132ss xmm26, xmm20, dword ptr [rax + 8*r14 + 4660]
// CHECK:  encoding: [0x62,0x22,0x5d,0x00,0x99,0x94,0xf0,0x34,0x12,0x00,0x00]
          vfmadd132ss xmm26, xmm20, dword ptr [rax + 8*r14 + 4660]

// CHECK: vfmadd132ss xmm26, xmm20, dword ptr [rdx + 508]
// CHECK:  encoding: [0x62,0x62,0x5d,0x00,0x99,0x52,0x7f]
          vfmadd132ss xmm26, xmm20, dword ptr [rdx + 508]

// CHECK: vfmadd132ss xmm26, xmm20, dword ptr [rdx + 512]
// CHECK:  encoding: [0x62,0x62,0x5d,0x00,0x99,0x92,0x00,0x02,0x00,0x00]
          vfmadd132ss xmm26, xmm20, dword ptr [rdx + 512]

// CHECK: vfmadd132ss xmm26, xmm20, dword ptr [rdx - 512]
// CHECK:  encoding: [0x62,0x62,0x5d,0x00,0x99,0x52,0x80]
          vfmadd132ss xmm26, xmm20, dword ptr [rdx - 512]

// CHECK: vfmadd132ss xmm26, xmm20, dword ptr [rdx - 516]
// CHECK:  encoding: [0x62,0x62,0x5d,0x00,0x99,0x92,0xfc,0xfd,0xff,0xff]
          vfmadd132ss xmm26, xmm20, dword ptr [rdx - 516]

// CHECK: vfmadd213pd zmm6, zmm17, zmm1
// CHECK:  encoding: [0x62,0xf2,0xf5,0x40,0xa8,0xf1]
          vfmadd213pd zmm6, zmm17, zmm1

// CHECK: vfmadd213pd zmm6 {k6}, zmm17, zmm1
// CHECK:  encoding: [0x62,0xf2,0xf5,0x46,0xa8,0xf1]
          vfmadd213pd zmm6 {k6}, zmm17, zmm1

// CHECK: vfmadd213pd zmm6 {k6} {z}, zmm17, zmm1
// CHECK:  encoding: [0x62,0xf2,0xf5,0xc6,0xa8,0xf1]
          vfmadd213pd zmm6 {k6} {z}, zmm17, zmm1

// CHECK: vfmadd213pd zmm6, zmm17, zmm1, {rn-sae}
// CHECK:  encoding: [0x62,0xf2,0xf5,0x10,0xa8,0xf1]
          vfmadd213pd zmm6, zmm17, zmm1, {rn-sae}

// CHECK: vfmadd213pd zmm6, zmm17, zmm1, {ru-sae}
// CHECK:  encoding: [0x62,0xf2,0xf5,0x50,0xa8,0xf1]
          vfmadd213pd zmm6, zmm17, zmm1, {ru-sae}

// CHECK: vfmadd213pd zmm6, zmm17, zmm1, {rd-sae}
// CHECK:  encoding: [0x62,0xf2,0xf5,0x30,0xa8,0xf1]
          vfmadd213pd zmm6, zmm17, zmm1, {rd-sae}

// CHECK: vfmadd213pd zmm6, zmm17, zmm1, {rz-sae}
// CHECK:  encoding: [0x62,0xf2,0xf5,0x70,0xa8,0xf1]
          vfmadd213pd zmm6, zmm17, zmm1, {rz-sae}

// CHECK: vfmadd213pd zmm6, zmm17, zmmword ptr [rcx]
// CHECK:  encoding: [0x62,0xf2,0xf5,0x40,0xa8,0x31]
          vfmadd213pd zmm6, zmm17, zmmword ptr [rcx]

// CHECK: vfmadd213pd zmm6, zmm17, zmmword ptr [rax + 8*r14 + 4660]
// CHECK:  encoding: [0x62,0xb2,0xf5,0x40,0xa8,0xb4,0xf0,0x34,0x12,0x00,0x00]
          vfmadd213pd zmm6, zmm17, zmmword ptr [rax + 8*r14 + 4660]

// CHECK: vfmadd213pd zmm6, zmm17, qword ptr [rcx]{1to8}
// CHECK:  encoding: [0x62,0xf2,0xf5,0x50,0xa8,0x31]
          vfmadd213pd zmm6, zmm17, qword ptr [rcx]{1to8}

// CHECK: vfmadd213pd zmm6, zmm17, zmmword ptr [rdx + 8128]
// CHECK:  encoding: [0x62,0xf2,0xf5,0x40,0xa8,0x72,0x7f]
          vfmadd213pd zmm6, zmm17, zmmword ptr [rdx + 8128]

// CHECK: vfmadd213pd zmm6, zmm17, zmmword ptr [rdx + 8192]
// CHECK:  encoding: [0x62,0xf2,0xf5,0x40,0xa8,0xb2,0x00,0x20,0x00,0x00]
          vfmadd213pd zmm6, zmm17, zmmword ptr [rdx + 8192]

// CHECK: vfmadd213pd zmm6, zmm17, zmmword ptr [rdx - 8192]
// CHECK:  encoding: [0x62,0xf2,0xf5,0x40,0xa8,0x72,0x80]
          vfmadd213pd zmm6, zmm17, zmmword ptr [rdx - 8192]

// CHECK: vfmadd213pd zmm6, zmm17, zmmword ptr [rdx - 8256]
// CHECK:  encoding: [0x62,0xf2,0xf5,0x40,0xa8,0xb2,0xc0,0xdf,0xff,0xff]
          vfmadd213pd zmm6, zmm17, zmmword ptr [rdx - 8256]

// CHECK: vfmadd213pd zmm6, zmm17, qword ptr [rdx + 1016]{1to8}
// CHECK:  encoding: [0x62,0xf2,0xf5,0x50,0xa8,0x72,0x7f]
          vfmadd213pd zmm6, zmm17, qword ptr [rdx + 1016]{1to8}

// CHECK: vfmadd213pd zmm6, zmm17, qword ptr [rdx + 1024]{1to8}
// CHECK:  encoding: [0x62,0xf2,0xf5,0x50,0xa8,0xb2,0x00,0x04,0x00,0x00]
          vfmadd213pd zmm6, zmm17, qword ptr [rdx + 1024]{1to8}

// CHECK: vfmadd213pd zmm6, zmm17, qword ptr [rdx - 1024]{1to8}
// CHECK:  encoding: [0x62,0xf2,0xf5,0x50,0xa8,0x72,0x80]
          vfmadd213pd zmm6, zmm17, qword ptr [rdx - 1024]{1to8}

// CHECK: vfmadd213pd zmm6, zmm17, qword ptr [rdx - 1032]{1to8}
// CHECK:  encoding: [0x62,0xf2,0xf5,0x50,0xa8,0xb2,0xf8,0xfb,0xff,0xff]
          vfmadd213pd zmm6, zmm17, qword ptr [rdx - 1032]{1to8}

// CHECK: vfmadd213ps zmm5, zmm24, zmm24
// CHECK:  encoding: [0x62,0x92,0x3d,0x40,0xa8,0xe8]
          vfmadd213ps zmm5, zmm24, zmm24

// CHECK: vfmadd213ps zmm5 {k6}, zmm24, zmm24
// CHECK:  encoding: [0x62,0x92,0x3d,0x46,0xa8,0xe8]
          vfmadd213ps zmm5 {k6}, zmm24, zmm24

// CHECK: vfmadd213ps zmm5 {k6} {z}, zmm24, zmm24
// CHECK:  encoding: [0x62,0x92,0x3d,0xc6,0xa8,0xe8]
          vfmadd213ps zmm5 {k6} {z}, zmm24, zmm24

// CHECK: vfmadd213ps zmm5, zmm24, zmm24, {rn-sae}
// CHECK:  encoding: [0x62,0x92,0x3d,0x10,0xa8,0xe8]
          vfmadd213ps zmm5, zmm24, zmm24, {rn-sae}

// CHECK: vfmadd213ps zmm5, zmm24, zmm24, {ru-sae}
// CHECK:  encoding: [0x62,0x92,0x3d,0x50,0xa8,0xe8]
          vfmadd213ps zmm5, zmm24, zmm24, {ru-sae}

// CHECK: vfmadd213ps zmm5, zmm24, zmm24, {rd-sae}
// CHECK:  encoding: [0x62,0x92,0x3d,0x30,0xa8,0xe8]
          vfmadd213ps zmm5, zmm24, zmm24, {rd-sae}

// CHECK: vfmadd213ps zmm5, zmm24, zmm24, {rz-sae}
// CHECK:  encoding: [0x62,0x92,0x3d,0x70,0xa8,0xe8]
          vfmadd213ps zmm5, zmm24, zmm24, {rz-sae}

// CHECK: vfmadd213ps zmm5, zmm24, zmmword ptr [rcx]
// CHECK:  encoding: [0x62,0xf2,0x3d,0x40,0xa8,0x29]
          vfmadd213ps zmm5, zmm24, zmmword ptr [rcx]

// CHECK: vfmadd213ps zmm5, zmm24, zmmword ptr [rax + 8*r14 + 4660]
// CHECK:  encoding: [0x62,0xb2,0x3d,0x40,0xa8,0xac,0xf0,0x34,0x12,0x00,0x00]
          vfmadd213ps zmm5, zmm24, zmmword ptr [rax + 8*r14 + 4660]

// CHECK: vfmadd213ps zmm5, zmm24, dword ptr [rcx]{1to16}
// CHECK:  encoding: [0x62,0xf2,0x3d,0x50,0xa8,0x29]
          vfmadd213ps zmm5, zmm24, dword ptr [rcx]{1to16}

// CHECK: vfmadd213ps zmm5, zmm24, zmmword ptr [rdx + 8128]
// CHECK:  encoding: [0x62,0xf2,0x3d,0x40,0xa8,0x6a,0x7f]
          vfmadd213ps zmm5, zmm24, zmmword ptr [rdx + 8128]

// CHECK: vfmadd213ps zmm5, zmm24, zmmword ptr [rdx + 8192]
// CHECK:  encoding: [0x62,0xf2,0x3d,0x40,0xa8,0xaa,0x00,0x20,0x00,0x00]
          vfmadd213ps zmm5, zmm24, zmmword ptr [rdx + 8192]

// CHECK: vfmadd213ps zmm5, zmm24, zmmword ptr [rdx - 8192]
// CHECK:  encoding: [0x62,0xf2,0x3d,0x40,0xa8,0x6a,0x80]
          vfmadd213ps zmm5, zmm24, zmmword ptr [rdx - 8192]

// CHECK: vfmadd213ps zmm5, zmm24, zmmword ptr [rdx - 8256]
// CHECK:  encoding: [0x62,0xf2,0x3d,0x40,0xa8,0xaa,0xc0,0xdf,0xff,0xff]
          vfmadd213ps zmm5, zmm24, zmmword ptr [rdx - 8256]

// CHECK: vfmadd213ps zmm5, zmm24, dword ptr [rdx + 508]{1to16}
// CHECK:  encoding: [0x62,0xf2,0x3d,0x50,0xa8,0x6a,0x7f]
          vfmadd213ps zmm5, zmm24, dword ptr [rdx + 508]{1to16}

// CHECK: vfmadd213ps zmm5, zmm24, dword ptr [rdx + 512]{1to16}
// CHECK:  encoding: [0x62,0xf2,0x3d,0x50,0xa8,0xaa,0x00,0x02,0x00,0x00]
          vfmadd213ps zmm5, zmm24, dword ptr [rdx + 512]{1to16}

// CHECK: vfmadd213ps zmm5, zmm24, dword ptr [rdx - 512]{1to16}
// CHECK:  encoding: [0x62,0xf2,0x3d,0x50,0xa8,0x6a,0x80]
          vfmadd213ps zmm5, zmm24, dword ptr [rdx - 512]{1to16}

// CHECK: vfmadd213ps zmm5, zmm24, dword ptr [rdx - 516]{1to16}
// CHECK:  encoding: [0x62,0xf2,0x3d,0x50,0xa8,0xaa,0xfc,0xfd,0xff,0xff]
          vfmadd213ps zmm5, zmm24, dword ptr [rdx - 516]{1to16}

// CHECK: vfmadd213sd xmm30, xmm14, xmm28
// CHECK:  encoding: [0x62,0x02,0x8d,0x08,0xa9,0xf4]
          vfmadd213sd xmm30, xmm14, xmm28

// CHECK: vfmadd213sd xmm30 {k5}, xmm14, xmm28
// CHECK:  encoding: [0x62,0x02,0x8d,0x0d,0xa9,0xf4]
          vfmadd213sd xmm30 {k5}, xmm14, xmm28

// CHECK: vfmadd213sd xmm30 {k5} {z}, xmm14, xmm28
// CHECK:  encoding: [0x62,0x02,0x8d,0x8d,0xa9,0xf4]
          vfmadd213sd xmm30 {k5} {z}, xmm14, xmm28

// CHECK: vfmadd213sd xmm30, xmm14, xmm28, {rn-sae}
// CHECK:  encoding: [0x62,0x02,0x8d,0x18,0xa9,0xf4]
          vfmadd213sd xmm30, xmm14, xmm28, {rn-sae}

// CHECK: vfmadd213sd xmm30, xmm14, xmm28, {ru-sae}
// CHECK:  encoding: [0x62,0x02,0x8d,0x58,0xa9,0xf4]
          vfmadd213sd xmm30, xmm14, xmm28, {ru-sae}

// CHECK: vfmadd213sd xmm30, xmm14, xmm28, {rd-sae}
// CHECK:  encoding: [0x62,0x02,0x8d,0x38,0xa9,0xf4]
          vfmadd213sd xmm30, xmm14, xmm28, {rd-sae}

// CHECK: vfmadd213sd xmm30, xmm14, xmm28, {rz-sae}
// CHECK:  encoding: [0x62,0x02,0x8d,0x78,0xa9,0xf4]
          vfmadd213sd xmm30, xmm14, xmm28, {rz-sae}

// CHECK: vfmadd213sd xmm30, xmm14, qword ptr [rcx]
// CHECK:  encoding: [0x62,0x62,0x8d,0x08,0xa9,0x31]
          vfmadd213sd xmm30, xmm14, qword ptr [rcx]

// CHECK: vfmadd213sd xmm30, xmm14, qword ptr [rax + 8*r14 + 4660]
// CHECK:  encoding: [0x62,0x22,0x8d,0x08,0xa9,0xb4,0xf0,0x34,0x12,0x00,0x00]
          vfmadd213sd xmm30, xmm14, qword ptr [rax + 8*r14 + 4660]

// CHECK: vfmadd213sd xmm30, xmm14, qword ptr [rdx + 1016]
// CHECK:  encoding: [0x62,0x62,0x8d,0x08,0xa9,0x72,0x7f]
          vfmadd213sd xmm30, xmm14, qword ptr [rdx + 1016]

// CHECK: vfmadd213sd xmm30, xmm14, qword ptr [rdx + 1024]
// CHECK:  encoding: [0x62,0x62,0x8d,0x08,0xa9,0xb2,0x00,0x04,0x00,0x00]
          vfmadd213sd xmm30, xmm14, qword ptr [rdx + 1024]

// CHECK: vfmadd213sd xmm30, xmm14, qword ptr [rdx - 1024]
// CHECK:  encoding: [0x62,0x62,0x8d,0x08,0xa9,0x72,0x80]
          vfmadd213sd xmm30, xmm14, qword ptr [rdx - 1024]

// CHECK: vfmadd213sd xmm30, xmm14, qword ptr [rdx - 1032]
// CHECK:  encoding: [0x62,0x62,0x8d,0x08,0xa9,0xb2,0xf8,0xfb,0xff,0xff]
          vfmadd213sd xmm30, xmm14, qword ptr [rdx - 1032]

// CHECK: vfmadd213ss xmm18, xmm25, xmm25
// CHECK:  encoding: [0x62,0x82,0x35,0x00,0xa9,0xd1]
          vfmadd213ss xmm18, xmm25, xmm25

// CHECK: vfmadd213ss xmm18 {k1}, xmm25, xmm25
// CHECK:  encoding: [0x62,0x82,0x35,0x01,0xa9,0xd1]
          vfmadd213ss xmm18 {k1}, xmm25, xmm25

// CHECK: vfmadd213ss xmm18 {k1} {z}, xmm25, xmm25
// CHECK:  encoding: [0x62,0x82,0x35,0x81,0xa9,0xd1]
          vfmadd213ss xmm18 {k1} {z}, xmm25, xmm25

// CHECK: vfmadd213ss xmm18, xmm25, xmm25, {rn-sae}
// CHECK:  encoding: [0x62,0x82,0x35,0x10,0xa9,0xd1]
          vfmadd213ss xmm18, xmm25, xmm25, {rn-sae}

// CHECK: vfmadd213ss xmm18, xmm25, xmm25, {ru-sae}
// CHECK:  encoding: [0x62,0x82,0x35,0x50,0xa9,0xd1]
          vfmadd213ss xmm18, xmm25, xmm25, {ru-sae}

// CHECK: vfmadd213ss xmm18, xmm25, xmm25, {rd-sae}
// CHECK:  encoding: [0x62,0x82,0x35,0x30,0xa9,0xd1]
          vfmadd213ss xmm18, xmm25, xmm25, {rd-sae}

// CHECK: vfmadd213ss xmm18, xmm25, xmm25, {rz-sae}
// CHECK:  encoding: [0x62,0x82,0x35,0x70,0xa9,0xd1]
          vfmadd213ss xmm18, xmm25, xmm25, {rz-sae}

// CHECK: vfmadd213ss xmm18, xmm25, dword ptr [rcx]
// CHECK:  encoding: [0x62,0xe2,0x35,0x00,0xa9,0x11]
          vfmadd213ss xmm18, xmm25, dword ptr [rcx]

// CHECK: vfmadd213ss xmm18, xmm25, dword ptr [rax + 8*r14 + 4660]
// CHECK:  encoding: [0x62,0xa2,0x35,0x00,0xa9,0x94,0xf0,0x34,0x12,0x00,0x00]
          vfmadd213ss xmm18, xmm25, dword ptr [rax + 8*r14 + 4660]

// CHECK: vfmadd213ss xmm18, xmm25, dword ptr [rdx + 508]
// CHECK:  encoding: [0x62,0xe2,0x35,0x00,0xa9,0x52,0x7f]
          vfmadd213ss xmm18, xmm25, dword ptr [rdx + 508]

// CHECK: vfmadd213ss xmm18, xmm25, dword ptr [rdx + 512]
// CHECK:  encoding: [0x62,0xe2,0x35,0x00,0xa9,0x92,0x00,0x02,0x00,0x00]
          vfmadd213ss xmm18, xmm25, dword ptr [rdx + 512]

// CHECK: vfmadd213ss xmm18, xmm25, dword ptr [rdx - 512]
// CHECK:  encoding: [0x62,0xe2,0x35,0x00,0xa9,0x52,0x80]
          vfmadd213ss xmm18, xmm25, dword ptr [rdx - 512]

// CHECK: vfmadd213ss xmm18, xmm25, dword ptr [rdx - 516]
// CHECK:  encoding: [0x62,0xe2,0x35,0x00,0xa9,0x92,0xfc,0xfd,0xff,0xff]
          vfmadd213ss xmm18, xmm25, dword ptr [rdx - 516]

// CHECK: vfmadd231pd zmm5, zmm13, zmm19
// CHECK:  encoding: [0x62,0xb2,0x95,0x48,0xb8,0xeb]
          vfmadd231pd zmm5, zmm13, zmm19

// CHECK: vfmadd231pd zmm5 {k1}, zmm13, zmm19
// CHECK:  encoding: [0x62,0xb2,0x95,0x49,0xb8,0xeb]
          vfmadd231pd zmm5 {k1}, zmm13, zmm19

// CHECK: vfmadd231pd zmm5 {k1} {z}, zmm13, zmm19
// CHECK:  encoding: [0x62,0xb2,0x95,0xc9,0xb8,0xeb]
          vfmadd231pd zmm5 {k1} {z}, zmm13, zmm19

// CHECK: vfmadd231pd zmm5, zmm13, zmm19, {rn-sae}
// CHECK:  encoding: [0x62,0xb2,0x95,0x18,0xb8,0xeb]
          vfmadd231pd zmm5, zmm13, zmm19, {rn-sae}

// CHECK: vfmadd231pd zmm5, zmm13, zmm19, {ru-sae}
// CHECK:  encoding: [0x62,0xb2,0x95,0x58,0xb8,0xeb]
          vfmadd231pd zmm5, zmm13, zmm19, {ru-sae}

// CHECK: vfmadd231pd zmm5, zmm13, zmm19, {rd-sae}
// CHECK:  encoding: [0x62,0xb2,0x95,0x38,0xb8,0xeb]
          vfmadd231pd zmm5, zmm13, zmm19, {rd-sae}

// CHECK: vfmadd231pd zmm5, zmm13, zmm19, {rz-sae}
// CHECK:  encoding: [0x62,0xb2,0x95,0x78,0xb8,0xeb]
          vfmadd231pd zmm5, zmm13, zmm19, {rz-sae}

// CHECK: vfmadd231pd zmm5, zmm13, zmmword ptr [rcx]
// CHECK:  encoding: [0x62,0xf2,0x95,0x48,0xb8,0x29]
          vfmadd231pd zmm5, zmm13, zmmword ptr [rcx]

// CHECK: vfmadd231pd zmm5, zmm13, zmmword ptr [rax + 8*r14 + 4660]
// CHECK:  encoding: [0x62,0xb2,0x95,0x48,0xb8,0xac,0xf0,0x34,0x12,0x00,0x00]
          vfmadd231pd zmm5, zmm13, zmmword ptr [rax + 8*r14 + 4660]

// CHECK: vfmadd231pd zmm5, zmm13, qword ptr [rcx]{1to8}
// CHECK:  encoding: [0x62,0xf2,0x95,0x58,0xb8,0x29]
          vfmadd231pd zmm5, zmm13, qword ptr [rcx]{1to8}

// CHECK: vfmadd231pd zmm5, zmm13, zmmword ptr [rdx + 8128]
// CHECK:  encoding: [0x62,0xf2,0x95,0x48,0xb8,0x6a,0x7f]
          vfmadd231pd zmm5, zmm13, zmmword ptr [rdx + 8128]

// CHECK: vfmadd231pd zmm5, zmm13, zmmword ptr [rdx + 8192]
// CHECK:  encoding: [0x62,0xf2,0x95,0x48,0xb8,0xaa,0x00,0x20,0x00,0x00]
          vfmadd231pd zmm5, zmm13, zmmword ptr [rdx + 8192]

// CHECK: vfmadd231pd zmm5, zmm13, zmmword ptr [rdx - 8192]
// CHECK:  encoding: [0x62,0xf2,0x95,0x48,0xb8,0x6a,0x80]
          vfmadd231pd zmm5, zmm13, zmmword ptr [rdx - 8192]

// CHECK: vfmadd231pd zmm5, zmm13, zmmword ptr [rdx - 8256]
// CHECK:  encoding: [0x62,0xf2,0x95,0x48,0xb8,0xaa,0xc0,0xdf,0xff,0xff]
          vfmadd231pd zmm5, zmm13, zmmword ptr [rdx - 8256]

// CHECK: vfmadd231pd zmm5, zmm13, qword ptr [rdx + 1016]{1to8}
// CHECK:  encoding: [0x62,0xf2,0x95,0x58,0xb8,0x6a,0x7f]
          vfmadd231pd zmm5, zmm13, qword ptr [rdx + 1016]{1to8}

// CHECK: vfmadd231pd zmm5, zmm13, qword ptr [rdx + 1024]{1to8}
// CHECK:  encoding: [0x62,0xf2,0x95,0x58,0xb8,0xaa,0x00,0x04,0x00,0x00]
          vfmadd231pd zmm5, zmm13, qword ptr [rdx + 1024]{1to8}

// CHECK: vfmadd231pd zmm5, zmm13, qword ptr [rdx - 1024]{1to8}
// CHECK:  encoding: [0x62,0xf2,0x95,0x58,0xb8,0x6a,0x80]
          vfmadd231pd zmm5, zmm13, qword ptr [rdx - 1024]{1to8}

// CHECK: vfmadd231pd zmm5, zmm13, qword ptr [rdx - 1032]{1to8}
// CHECK:  encoding: [0x62,0xf2,0x95,0x58,0xb8,0xaa,0xf8,0xfb,0xff,0xff]
          vfmadd231pd zmm5, zmm13, qword ptr [rdx - 1032]{1to8}

// CHECK: vfmadd231ps zmm2, zmm1, zmm18
// CHECK:  encoding: [0x62,0xb2,0x75,0x48,0xb8,0xd2]
          vfmadd231ps zmm2, zmm1, zmm18

// CHECK: vfmadd231ps zmm2 {k2}, zmm1, zmm18
// CHECK:  encoding: [0x62,0xb2,0x75,0x4a,0xb8,0xd2]
          vfmadd231ps zmm2 {k2}, zmm1, zmm18

// CHECK: vfmadd231ps zmm2 {k2} {z}, zmm1, zmm18
// CHECK:  encoding: [0x62,0xb2,0x75,0xca,0xb8,0xd2]
          vfmadd231ps zmm2 {k2} {z}, zmm1, zmm18

// CHECK: vfmadd231ps zmm2, zmm1, zmm18, {rn-sae}
// CHECK:  encoding: [0x62,0xb2,0x75,0x18,0xb8,0xd2]
          vfmadd231ps zmm2, zmm1, zmm18, {rn-sae}

// CHECK: vfmadd231ps zmm2, zmm1, zmm18, {ru-sae}
// CHECK:  encoding: [0x62,0xb2,0x75,0x58,0xb8,0xd2]
          vfmadd231ps zmm2, zmm1, zmm18, {ru-sae}

// CHECK: vfmadd231ps zmm2, zmm1, zmm18, {rd-sae}
// CHECK:  encoding: [0x62,0xb2,0x75,0x38,0xb8,0xd2]
          vfmadd231ps zmm2, zmm1, zmm18, {rd-sae}

// CHECK: vfmadd231ps zmm2, zmm1, zmm18, {rz-sae}
// CHECK:  encoding: [0x62,0xb2,0x75,0x78,0xb8,0xd2]
          vfmadd231ps zmm2, zmm1, zmm18, {rz-sae}

// CHECK: vfmadd231ps zmm2, zmm1, zmmword ptr [rcx]
// CHECK:  encoding: [0x62,0xf2,0x75,0x48,0xb8,0x11]
          vfmadd231ps zmm2, zmm1, zmmword ptr [rcx]

// CHECK: vfmadd231ps zmm2, zmm1, zmmword ptr [rax + 8*r14 + 4660]
// CHECK:  encoding: [0x62,0xb2,0x75,0x48,0xb8,0x94,0xf0,0x34,0x12,0x00,0x00]
          vfmadd231ps zmm2, zmm1, zmmword ptr [rax + 8*r14 + 4660]

// CHECK: vfmadd231ps zmm2, zmm1, dword ptr [rcx]{1to16}
// CHECK:  encoding: [0x62,0xf2,0x75,0x58,0xb8,0x11]
          vfmadd231ps zmm2, zmm1, dword ptr [rcx]{1to16}

// CHECK: vfmadd231ps zmm2, zmm1, zmmword ptr [rdx + 8128]
// CHECK:  encoding: [0x62,0xf2,0x75,0x48,0xb8,0x52,0x7f]
          vfmadd231ps zmm2, zmm1, zmmword ptr [rdx + 8128]

// CHECK: vfmadd231ps zmm2, zmm1, zmmword ptr [rdx + 8192]
// CHECK:  encoding: [0x62,0xf2,0x75,0x48,0xb8,0x92,0x00,0x20,0x00,0x00]
          vfmadd231ps zmm2, zmm1, zmmword ptr [rdx + 8192]

// CHECK: vfmadd231ps zmm2, zmm1, zmmword ptr [rdx - 8192]
// CHECK:  encoding: [0x62,0xf2,0x75,0x48,0xb8,0x52,0x80]
          vfmadd231ps zmm2, zmm1, zmmword ptr [rdx - 8192]

// CHECK: vfmadd231ps zmm2, zmm1, zmmword ptr [rdx - 8256]
// CHECK:  encoding: [0x62,0xf2,0x75,0x48,0xb8,0x92,0xc0,0xdf,0xff,0xff]
          vfmadd231ps zmm2, zmm1, zmmword ptr [rdx - 8256]

// CHECK: vfmadd231ps zmm2, zmm1, dword ptr [rdx + 508]{1to16}
// CHECK:  encoding: [0x62,0xf2,0x75,0x58,0xb8,0x52,0x7f]
          vfmadd231ps zmm2, zmm1, dword ptr [rdx + 508]{1to16}

// CHECK: vfmadd231ps zmm2, zmm1, dword ptr [rdx + 512]{1to16}
// CHECK:  encoding: [0x62,0xf2,0x75,0x58,0xb8,0x92,0x00,0x02,0x00,0x00]
          vfmadd231ps zmm2, zmm1, dword ptr [rdx + 512]{1to16}

// CHECK: vfmadd231ps zmm2, zmm1, dword ptr [rdx - 512]{1to16}
// CHECK:  encoding: [0x62,0xf2,0x75,0x58,0xb8,0x52,0x80]
          vfmadd231ps zmm2, zmm1, dword ptr [rdx - 512]{1to16}

// CHECK: vfmadd231ps zmm2, zmm1, dword ptr [rdx - 516]{1to16}
// CHECK:  encoding: [0x62,0xf2,0x75,0x58,0xb8,0x92,0xfc,0xfd,0xff,0xff]
          vfmadd231ps zmm2, zmm1, dword ptr [rdx - 516]{1to16}

// CHECK: vfmadd231sd xmm6, xmm14, xmm14
// CHECK:  encoding: [0xc4,0xc2,0x89,0xb9,0xf6]
          vfmadd231sd xmm6, xmm14, xmm14

// CHECK: vfmadd231sd xmm6 {k2}, xmm14, xmm14
// CHECK:  encoding: [0x62,0xd2,0x8d,0x0a,0xb9,0xf6]
          vfmadd231sd xmm6 {k2}, xmm14, xmm14

// CHECK: vfmadd231sd xmm6 {k2} {z}, xmm14, xmm14
// CHECK:  encoding: [0x62,0xd2,0x8d,0x8a,0xb9,0xf6]
          vfmadd231sd xmm6 {k2} {z}, xmm14, xmm14

// CHECK: vfmadd231sd xmm6, xmm14, xmm14, {rn-sae}
// CHECK:  encoding: [0x62,0xd2,0x8d,0x18,0xb9,0xf6]
          vfmadd231sd xmm6, xmm14, xmm14, {rn-sae}

// CHECK: vfmadd231sd xmm6, xmm14, xmm14, {ru-sae}
// CHECK:  encoding: [0x62,0xd2,0x8d,0x58,0xb9,0xf6]
          vfmadd231sd xmm6, xmm14, xmm14, {ru-sae}

// CHECK: vfmadd231sd xmm6, xmm14, xmm14, {rd-sae}
// CHECK:  encoding: [0x62,0xd2,0x8d,0x38,0xb9,0xf6]
          vfmadd231sd xmm6, xmm14, xmm14, {rd-sae}

// CHECK: vfmadd231sd xmm6, xmm14, xmm14, {rz-sae}
// CHECK:  encoding: [0x62,0xd2,0x8d,0x78,0xb9,0xf6]
          vfmadd231sd xmm6, xmm14, xmm14, {rz-sae}

// CHECK: vfmadd231sd xmm6, xmm14, qword ptr [rcx]
// CHECK:  encoding: [0xc4,0xe2,0x89,0xb9,0x31]
          vfmadd231sd xmm6, xmm14, qword ptr [rcx]

// CHECK: vfmadd231sd xmm6, xmm14, qword ptr [rax + 8*r14 + 4660]
// CHECK:  encoding: [0xc4,0xa2,0x89,0xb9,0xb4,0xf0,0x34,0x12,0x00,0x00]
          vfmadd231sd xmm6, xmm14, qword ptr [rax + 8*r14 + 4660]

// CHECK: vfmadd231sd xmm6, xmm14, qword ptr [rdx + 1016]
// CHECK:  encoding: [0xc4,0xe2,0x89,0xb9,0xb2,0xf8,0x03,0x00,0x00]
          vfmadd231sd xmm6, xmm14, qword ptr [rdx + 1016]

// CHECK: vfmadd231sd xmm6, xmm14, qword ptr [rdx + 1024]
// CHECK:  encoding: [0xc4,0xe2,0x89,0xb9,0xb2,0x00,0x04,0x00,0x00]
          vfmadd231sd xmm6, xmm14, qword ptr [rdx + 1024]

// CHECK: vfmadd231sd xmm6, xmm14, qword ptr [rdx - 1024]
// CHECK:  encoding: [0xc4,0xe2,0x89,0xb9,0xb2,0x00,0xfc,0xff,0xff]
          vfmadd231sd xmm6, xmm14, qword ptr [rdx - 1024]

// CHECK: vfmadd231sd xmm6, xmm14, qword ptr [rdx - 1032]
// CHECK:  encoding: [0xc4,0xe2,0x89,0xb9,0xb2,0xf8,0xfb,0xff,0xff]
          vfmadd231sd xmm6, xmm14, qword ptr [rdx - 1032]

// CHECK: vfmadd231ss xmm26, xmm14, xmm19
// CHECK:  encoding: [0x62,0x22,0x0d,0x08,0xb9,0xd3]
          vfmadd231ss xmm26, xmm14, xmm19

// CHECK: vfmadd231ss xmm26 {k4}, xmm14, xmm19
// CHECK:  encoding: [0x62,0x22,0x0d,0x0c,0xb9,0xd3]
          vfmadd231ss xmm26 {k4}, xmm14, xmm19

// CHECK: vfmadd231ss xmm26 {k4} {z}, xmm14, xmm19
// CHECK:  encoding: [0x62,0x22,0x0d,0x8c,0xb9,0xd3]
          vfmadd231ss xmm26 {k4} {z}, xmm14, xmm19

// CHECK: vfmadd231ss xmm26, xmm14, xmm19, {rn-sae}
// CHECK:  encoding: [0x62,0x22,0x0d,0x18,0xb9,0xd3]
          vfmadd231ss xmm26, xmm14, xmm19, {rn-sae}

// CHECK: vfmadd231ss xmm26, xmm14, xmm19, {ru-sae}
// CHECK:  encoding: [0x62,0x22,0x0d,0x58,0xb9,0xd3]
          vfmadd231ss xmm26, xmm14, xmm19, {ru-sae}

// CHECK: vfmadd231ss xmm26, xmm14, xmm19, {rd-sae}
// CHECK:  encoding: [0x62,0x22,0x0d,0x38,0xb9,0xd3]
          vfmadd231ss xmm26, xmm14, xmm19, {rd-sae}

// CHECK: vfmadd231ss xmm26, xmm14, xmm19, {rz-sae}
// CHECK:  encoding: [0x62,0x22,0x0d,0x78,0xb9,0xd3]
          vfmadd231ss xmm26, xmm14, xmm19, {rz-sae}

// CHECK: vfmadd231ss xmm26, xmm14, dword ptr [rcx]
// CHECK:  encoding: [0x62,0x62,0x0d,0x08,0xb9,0x11]
          vfmadd231ss xmm26, xmm14, dword ptr [rcx]

// CHECK: vfmadd231ss xmm26, xmm14, dword ptr [rax + 8*r14 + 4660]
// CHECK:  encoding: [0x62,0x22,0x0d,0x08,0xb9,0x94,0xf0,0x34,0x12,0x00,0x00]
          vfmadd231ss xmm26, xmm14, dword ptr [rax + 8*r14 + 4660]

// CHECK: vfmadd231ss xmm26, xmm14, dword ptr [rdx + 508]
// CHECK:  encoding: [0x62,0x62,0x0d,0x08,0xb9,0x52,0x7f]
          vfmadd231ss xmm26, xmm14, dword ptr [rdx + 508]

// CHECK: vfmadd231ss xmm26, xmm14, dword ptr [rdx + 512]
// CHECK:  encoding: [0x62,0x62,0x0d,0x08,0xb9,0x92,0x00,0x02,0x00,0x00]
          vfmadd231ss xmm26, xmm14, dword ptr [rdx + 512]

// CHECK: vfmadd231ss xmm26, xmm14, dword ptr [rdx - 512]
// CHECK:  encoding: [0x62,0x62,0x0d,0x08,0xb9,0x52,0x80]
          vfmadd231ss xmm26, xmm14, dword ptr [rdx - 512]

// CHECK: vfmadd231ss xmm26, xmm14, dword ptr [rdx - 516]
// CHECK:  encoding: [0x62,0x62,0x0d,0x08,0xb9,0x92,0xfc,0xfd,0xff,0xff]
          vfmadd231ss xmm26, xmm14, dword ptr [rdx - 516]

// CHECK: vfmaddsub132pd zmm20, zmm6, zmm2
// CHECK:  encoding: [0x62,0xe2,0xcd,0x48,0x96,0xe2]
          vfmaddsub132pd zmm20, zmm6, zmm2

// CHECK: vfmaddsub132pd zmm20 {k6}, zmm6, zmm2
// CHECK:  encoding: [0x62,0xe2,0xcd,0x4e,0x96,0xe2]
          vfmaddsub132pd zmm20 {k6}, zmm6, zmm2

// CHECK: vfmaddsub132pd zmm20 {k6} {z}, zmm6, zmm2
// CHECK:  encoding: [0x62,0xe2,0xcd,0xce,0x96,0xe2]
          vfmaddsub132pd zmm20 {k6} {z}, zmm6, zmm2

// CHECK: vfmaddsub132pd zmm20, zmm6, zmm2, {rn-sae}
// CHECK:  encoding: [0x62,0xe2,0xcd,0x18,0x96,0xe2]
          vfmaddsub132pd zmm20, zmm6, zmm2, {rn-sae}

// CHECK: vfmaddsub132pd zmm20, zmm6, zmm2, {ru-sae}
// CHECK:  encoding: [0x62,0xe2,0xcd,0x58,0x96,0xe2]
          vfmaddsub132pd zmm20, zmm6, zmm2, {ru-sae}

// CHECK: vfmaddsub132pd zmm20, zmm6, zmm2, {rd-sae}
// CHECK:  encoding: [0x62,0xe2,0xcd,0x38,0x96,0xe2]
          vfmaddsub132pd zmm20, zmm6, zmm2, {rd-sae}

// CHECK: vfmaddsub132pd zmm20, zmm6, zmm2, {rz-sae}
// CHECK:  encoding: [0x62,0xe2,0xcd,0x78,0x96,0xe2]
          vfmaddsub132pd zmm20, zmm6, zmm2, {rz-sae}

// CHECK: vfmaddsub132pd zmm20, zmm6, zmmword ptr [rcx]
// CHECK:  encoding: [0x62,0xe2,0xcd,0x48,0x96,0x21]
          vfmaddsub132pd zmm20, zmm6, zmmword ptr [rcx]

// CHECK: vfmaddsub132pd zmm20, zmm6, zmmword ptr [rax + 8*r14 + 4660]
// CHECK:  encoding: [0x62,0xa2,0xcd,0x48,0x96,0xa4,0xf0,0x34,0x12,0x00,0x00]
          vfmaddsub132pd zmm20, zmm6, zmmword ptr [rax + 8*r14 + 4660]

// CHECK: vfmaddsub132pd zmm20, zmm6, qword ptr [rcx]{1to8}
// CHECK:  encoding: [0x62,0xe2,0xcd,0x58,0x96,0x21]
          vfmaddsub132pd zmm20, zmm6, qword ptr [rcx]{1to8}

// CHECK: vfmaddsub132pd zmm20, zmm6, zmmword ptr [rdx + 8128]
// CHECK:  encoding: [0x62,0xe2,0xcd,0x48,0x96,0x62,0x7f]
          vfmaddsub132pd zmm20, zmm6, zmmword ptr [rdx + 8128]

// CHECK: vfmaddsub132pd zmm20, zmm6, zmmword ptr [rdx + 8192]
// CHECK:  encoding: [0x62,0xe2,0xcd,0x48,0x96,0xa2,0x00,0x20,0x00,0x00]
          vfmaddsub132pd zmm20, zmm6, zmmword ptr [rdx + 8192]

// CHECK: vfmaddsub132pd zmm20, zmm6, zmmword ptr [rdx - 8192]
// CHECK:  encoding: [0x62,0xe2,0xcd,0x48,0x96,0x62,0x80]
          vfmaddsub132pd zmm20, zmm6, zmmword ptr [rdx - 8192]

// CHECK: vfmaddsub132pd zmm20, zmm6, zmmword ptr [rdx - 8256]
// CHECK:  encoding: [0x62,0xe2,0xcd,0x48,0x96,0xa2,0xc0,0xdf,0xff,0xff]
          vfmaddsub132pd zmm20, zmm6, zmmword ptr [rdx - 8256]

// CHECK: vfmaddsub132pd zmm20, zmm6, qword ptr [rdx + 1016]{1to8}
// CHECK:  encoding: [0x62,0xe2,0xcd,0x58,0x96,0x62,0x7f]
          vfmaddsub132pd zmm20, zmm6, qword ptr [rdx + 1016]{1to8}

// CHECK: vfmaddsub132pd zmm20, zmm6, qword ptr [rdx + 1024]{1to8}
// CHECK:  encoding: [0x62,0xe2,0xcd,0x58,0x96,0xa2,0x00,0x04,0x00,0x00]
          vfmaddsub132pd zmm20, zmm6, qword ptr [rdx + 1024]{1to8}

// CHECK: vfmaddsub132pd zmm20, zmm6, qword ptr [rdx - 1024]{1to8}
// CHECK:  encoding: [0x62,0xe2,0xcd,0x58,0x96,0x62,0x80]
          vfmaddsub132pd zmm20, zmm6, qword ptr [rdx - 1024]{1to8}

// CHECK: vfmaddsub132pd zmm20, zmm6, qword ptr [rdx - 1032]{1to8}
// CHECK:  encoding: [0x62,0xe2,0xcd,0x58,0x96,0xa2,0xf8,0xfb,0xff,0xff]
          vfmaddsub132pd zmm20, zmm6, qword ptr [rdx - 1032]{1to8}

// CHECK: vfmaddsub132ps zmm29, zmm7, zmm12
// CHECK:  encoding: [0x62,0x42,0x45,0x48,0x96,0xec]
          vfmaddsub132ps zmm29, zmm7, zmm12

// CHECK: vfmaddsub132ps zmm29 {k7}, zmm7, zmm12
// CHECK:  encoding: [0x62,0x42,0x45,0x4f,0x96,0xec]
          vfmaddsub132ps zmm29 {k7}, zmm7, zmm12

// CHECK: vfmaddsub132ps zmm29 {k7} {z}, zmm7, zmm12
// CHECK:  encoding: [0x62,0x42,0x45,0xcf,0x96,0xec]
          vfmaddsub132ps zmm29 {k7} {z}, zmm7, zmm12

// CHECK: vfmaddsub132ps zmm29, zmm7, zmm12, {rn-sae}
// CHECK:  encoding: [0x62,0x42,0x45,0x18,0x96,0xec]
          vfmaddsub132ps zmm29, zmm7, zmm12, {rn-sae}

// CHECK: vfmaddsub132ps zmm29, zmm7, zmm12, {ru-sae}
// CHECK:  encoding: [0x62,0x42,0x45,0x58,0x96,0xec]
          vfmaddsub132ps zmm29, zmm7, zmm12, {ru-sae}

// CHECK: vfmaddsub132ps zmm29, zmm7, zmm12, {rd-sae}
// CHECK:  encoding: [0x62,0x42,0x45,0x38,0x96,0xec]
          vfmaddsub132ps zmm29, zmm7, zmm12, {rd-sae}

// CHECK: vfmaddsub132ps zmm29, zmm7, zmm12, {rz-sae}
// CHECK:  encoding: [0x62,0x42,0x45,0x78,0x96,0xec]
          vfmaddsub132ps zmm29, zmm7, zmm12, {rz-sae}

// CHECK: vfmaddsub132ps zmm29, zmm7, zmmword ptr [rcx]
// CHECK:  encoding: [0x62,0x62,0x45,0x48,0x96,0x29]
          vfmaddsub132ps zmm29, zmm7, zmmword ptr [rcx]

// CHECK: vfmaddsub132ps zmm29, zmm7, zmmword ptr [rax + 8*r14 + 4660]
// CHECK:  encoding: [0x62,0x22,0x45,0x48,0x96,0xac,0xf0,0x34,0x12,0x00,0x00]
          vfmaddsub132ps zmm29, zmm7, zmmword ptr [rax + 8*r14 + 4660]

// CHECK: vfmaddsub132ps zmm29, zmm7, dword ptr [rcx]{1to16}
// CHECK:  encoding: [0x62,0x62,0x45,0x58,0x96,0x29]
          vfmaddsub132ps zmm29, zmm7, dword ptr [rcx]{1to16}

// CHECK: vfmaddsub132ps zmm29, zmm7, zmmword ptr [rdx + 8128]
// CHECK:  encoding: [0x62,0x62,0x45,0x48,0x96,0x6a,0x7f]
          vfmaddsub132ps zmm29, zmm7, zmmword ptr [rdx + 8128]

// CHECK: vfmaddsub132ps zmm29, zmm7, zmmword ptr [rdx + 8192]
// CHECK:  encoding: [0x62,0x62,0x45,0x48,0x96,0xaa,0x00,0x20,0x00,0x00]
          vfmaddsub132ps zmm29, zmm7, zmmword ptr [rdx + 8192]

// CHECK: vfmaddsub132ps zmm29, zmm7, zmmword ptr [rdx - 8192]
// CHECK:  encoding: [0x62,0x62,0x45,0x48,0x96,0x6a,0x80]
          vfmaddsub132ps zmm29, zmm7, zmmword ptr [rdx - 8192]

// CHECK: vfmaddsub132ps zmm29, zmm7, zmmword ptr [rdx - 8256]
// CHECK:  encoding: [0x62,0x62,0x45,0x48,0x96,0xaa,0xc0,0xdf,0xff,0xff]
          vfmaddsub132ps zmm29, zmm7, zmmword ptr [rdx - 8256]

// CHECK: vfmaddsub132ps zmm29, zmm7, dword ptr [rdx + 508]{1to16}
// CHECK:  encoding: [0x62,0x62,0x45,0x58,0x96,0x6a,0x7f]
          vfmaddsub132ps zmm29, zmm7, dword ptr [rdx + 508]{1to16}

// CHECK: vfmaddsub132ps zmm29, zmm7, dword ptr [rdx + 512]{1to16}
// CHECK:  encoding: [0x62,0x62,0x45,0x58,0x96,0xaa,0x00,0x02,0x00,0x00]
          vfmaddsub132ps zmm29, zmm7, dword ptr [rdx + 512]{1to16}

// CHECK: vfmaddsub132ps zmm29, zmm7, dword ptr [rdx - 512]{1to16}
// CHECK:  encoding: [0x62,0x62,0x45,0x58,0x96,0x6a,0x80]
          vfmaddsub132ps zmm29, zmm7, dword ptr [rdx - 512]{1to16}

// CHECK: vfmaddsub132ps zmm29, zmm7, dword ptr [rdx - 516]{1to16}
// CHECK:  encoding: [0x62,0x62,0x45,0x58,0x96,0xaa,0xfc,0xfd,0xff,0xff]
          vfmaddsub132ps zmm29, zmm7, dword ptr [rdx - 516]{1to16}

// CHECK: vfmaddsub213pd zmm27, zmm20, zmm15
// CHECK:  encoding: [0x62,0x42,0xdd,0x40,0xa6,0xdf]
          vfmaddsub213pd zmm27, zmm20, zmm15

// CHECK: vfmaddsub213pd zmm27 {k3}, zmm20, zmm15
// CHECK:  encoding: [0x62,0x42,0xdd,0x43,0xa6,0xdf]
          vfmaddsub213pd zmm27 {k3}, zmm20, zmm15

// CHECK: vfmaddsub213pd zmm27 {k3} {z}, zmm20, zmm15
// CHECK:  encoding: [0x62,0x42,0xdd,0xc3,0xa6,0xdf]
          vfmaddsub213pd zmm27 {k3} {z}, zmm20, zmm15

// CHECK: vfmaddsub213pd zmm27, zmm20, zmm15, {rn-sae}
// CHECK:  encoding: [0x62,0x42,0xdd,0x10,0xa6,0xdf]
          vfmaddsub213pd zmm27, zmm20, zmm15, {rn-sae}

// CHECK: vfmaddsub213pd zmm27, zmm20, zmm15, {ru-sae}
// CHECK:  encoding: [0x62,0x42,0xdd,0x50,0xa6,0xdf]
          vfmaddsub213pd zmm27, zmm20, zmm15, {ru-sae}

// CHECK: vfmaddsub213pd zmm27, zmm20, zmm15, {rd-sae}
// CHECK:  encoding: [0x62,0x42,0xdd,0x30,0xa6,0xdf]
          vfmaddsub213pd zmm27, zmm20, zmm15, {rd-sae}

// CHECK: vfmaddsub213pd zmm27, zmm20, zmm15, {rz-sae}
// CHECK:  encoding: [0x62,0x42,0xdd,0x70,0xa6,0xdf]
          vfmaddsub213pd zmm27, zmm20, zmm15, {rz-sae}

// CHECK: vfmaddsub213pd zmm27, zmm20, zmmword ptr [rcx]
// CHECK:  encoding: [0x62,0x62,0xdd,0x40,0xa6,0x19]
          vfmaddsub213pd zmm27, zmm20, zmmword ptr [rcx]

// CHECK: vfmaddsub213pd zmm27, zmm20, zmmword ptr [rax + 8*r14 + 4660]
// CHECK:  encoding: [0x62,0x22,0xdd,0x40,0xa6,0x9c,0xf0,0x34,0x12,0x00,0x00]
          vfmaddsub213pd zmm27, zmm20, zmmword ptr [rax + 8*r14 + 4660]

// CHECK: vfmaddsub213pd zmm27, zmm20, qword ptr [rcx]{1to8}
// CHECK:  encoding: [0x62,0x62,0xdd,0x50,0xa6,0x19]
          vfmaddsub213pd zmm27, zmm20, qword ptr [rcx]{1to8}

// CHECK: vfmaddsub213pd zmm27, zmm20, zmmword ptr [rdx + 8128]
// CHECK:  encoding: [0x62,0x62,0xdd,0x40,0xa6,0x5a,0x7f]
          vfmaddsub213pd zmm27, zmm20, zmmword ptr [rdx + 8128]

// CHECK: vfmaddsub213pd zmm27, zmm20, zmmword ptr [rdx + 8192]
// CHECK:  encoding: [0x62,0x62,0xdd,0x40,0xa6,0x9a,0x00,0x20,0x00,0x00]
          vfmaddsub213pd zmm27, zmm20, zmmword ptr [rdx + 8192]

// CHECK: vfmaddsub213pd zmm27, zmm20, zmmword ptr [rdx - 8192]
// CHECK:  encoding: [0x62,0x62,0xdd,0x40,0xa6,0x5a,0x80]
          vfmaddsub213pd zmm27, zmm20, zmmword ptr [rdx - 8192]

// CHECK: vfmaddsub213pd zmm27, zmm20, zmmword ptr [rdx - 8256]
// CHECK:  encoding: [0x62,0x62,0xdd,0x40,0xa6,0x9a,0xc0,0xdf,0xff,0xff]
          vfmaddsub213pd zmm27, zmm20, zmmword ptr [rdx - 8256]

// CHECK: vfmaddsub213pd zmm27, zmm20, qword ptr [rdx + 1016]{1to8}
// CHECK:  encoding: [0x62,0x62,0xdd,0x50,0xa6,0x5a,0x7f]
          vfmaddsub213pd zmm27, zmm20, qword ptr [rdx + 1016]{1to8}

// CHECK: vfmaddsub213pd zmm27, zmm20, qword ptr [rdx + 1024]{1to8}
// CHECK:  encoding: [0x62,0x62,0xdd,0x50,0xa6,0x9a,0x00,0x04,0x00,0x00]
          vfmaddsub213pd zmm27, zmm20, qword ptr [rdx + 1024]{1to8}

// CHECK: vfmaddsub213pd zmm27, zmm20, qword ptr [rdx - 1024]{1to8}
// CHECK:  encoding: [0x62,0x62,0xdd,0x50,0xa6,0x5a,0x80]
          vfmaddsub213pd zmm27, zmm20, qword ptr [rdx - 1024]{1to8}

// CHECK: vfmaddsub213pd zmm27, zmm20, qword ptr [rdx - 1032]{1to8}
// CHECK:  encoding: [0x62,0x62,0xdd,0x50,0xa6,0x9a,0xf8,0xfb,0xff,0xff]
          vfmaddsub213pd zmm27, zmm20, qword ptr [rdx - 1032]{1to8}

// CHECK: vfmaddsub213ps zmm22, zmm13, zmm10
// CHECK:  encoding: [0x62,0xc2,0x15,0x48,0xa6,0xf2]
          vfmaddsub213ps zmm22, zmm13, zmm10

// CHECK: vfmaddsub213ps zmm22 {k5}, zmm13, zmm10
// CHECK:  encoding: [0x62,0xc2,0x15,0x4d,0xa6,0xf2]
          vfmaddsub213ps zmm22 {k5}, zmm13, zmm10

// CHECK: vfmaddsub213ps zmm22 {k5} {z}, zmm13, zmm10
// CHECK:  encoding: [0x62,0xc2,0x15,0xcd,0xa6,0xf2]
          vfmaddsub213ps zmm22 {k5} {z}, zmm13, zmm10

// CHECK: vfmaddsub213ps zmm22, zmm13, zmm10, {rn-sae}
// CHECK:  encoding: [0x62,0xc2,0x15,0x18,0xa6,0xf2]
          vfmaddsub213ps zmm22, zmm13, zmm10, {rn-sae}

// CHECK: vfmaddsub213ps zmm22, zmm13, zmm10, {ru-sae}
// CHECK:  encoding: [0x62,0xc2,0x15,0x58,0xa6,0xf2]
          vfmaddsub213ps zmm22, zmm13, zmm10, {ru-sae}

// CHECK: vfmaddsub213ps zmm22, zmm13, zmm10, {rd-sae}
// CHECK:  encoding: [0x62,0xc2,0x15,0x38,0xa6,0xf2]
          vfmaddsub213ps zmm22, zmm13, zmm10, {rd-sae}

// CHECK: vfmaddsub213ps zmm22, zmm13, zmm10, {rz-sae}
// CHECK:  encoding: [0x62,0xc2,0x15,0x78,0xa6,0xf2]
          vfmaddsub213ps zmm22, zmm13, zmm10, {rz-sae}

// CHECK: vfmaddsub213ps zmm22, zmm13, zmmword ptr [rcx]
// CHECK:  encoding: [0x62,0xe2,0x15,0x48,0xa6,0x31]
          vfmaddsub213ps zmm22, zmm13, zmmword ptr [rcx]

// CHECK: vfmaddsub213ps zmm22, zmm13, zmmword ptr [rax + 8*r14 + 4660]
// CHECK:  encoding: [0x62,0xa2,0x15,0x48,0xa6,0xb4,0xf0,0x34,0x12,0x00,0x00]
          vfmaddsub213ps zmm22, zmm13, zmmword ptr [rax + 8*r14 + 4660]

// CHECK: vfmaddsub213ps zmm22, zmm13, dword ptr [rcx]{1to16}
// CHECK:  encoding: [0x62,0xe2,0x15,0x58,0xa6,0x31]
          vfmaddsub213ps zmm22, zmm13, dword ptr [rcx]{1to16}

// CHECK: vfmaddsub213ps zmm22, zmm13, zmmword ptr [rdx + 8128]
// CHECK:  encoding: [0x62,0xe2,0x15,0x48,0xa6,0x72,0x7f]
          vfmaddsub213ps zmm22, zmm13, zmmword ptr [rdx + 8128]

// CHECK: vfmaddsub213ps zmm22, zmm13, zmmword ptr [rdx + 8192]
// CHECK:  encoding: [0x62,0xe2,0x15,0x48,0xa6,0xb2,0x00,0x20,0x00,0x00]
          vfmaddsub213ps zmm22, zmm13, zmmword ptr [rdx + 8192]

// CHECK: vfmaddsub213ps zmm22, zmm13, zmmword ptr [rdx - 8192]
// CHECK:  encoding: [0x62,0xe2,0x15,0x48,0xa6,0x72,0x80]
          vfmaddsub213ps zmm22, zmm13, zmmword ptr [rdx - 8192]

// CHECK: vfmaddsub213ps zmm22, zmm13, zmmword ptr [rdx - 8256]
// CHECK:  encoding: [0x62,0xe2,0x15,0x48,0xa6,0xb2,0xc0,0xdf,0xff,0xff]
          vfmaddsub213ps zmm22, zmm13, zmmword ptr [rdx - 8256]

// CHECK: vfmaddsub213ps zmm22, zmm13, dword ptr [rdx + 508]{1to16}
// CHECK:  encoding: [0x62,0xe2,0x15,0x58,0xa6,0x72,0x7f]
          vfmaddsub213ps zmm22, zmm13, dword ptr [rdx + 508]{1to16}

// CHECK: vfmaddsub213ps zmm22, zmm13, dword ptr [rdx + 512]{1to16}
// CHECK:  encoding: [0x62,0xe2,0x15,0x58,0xa6,0xb2,0x00,0x02,0x00,0x00]
          vfmaddsub213ps zmm22, zmm13, dword ptr [rdx + 512]{1to16}

// CHECK: vfmaddsub213ps zmm22, zmm13, dword ptr [rdx - 512]{1to16}
// CHECK:  encoding: [0x62,0xe2,0x15,0x58,0xa6,0x72,0x80]
          vfmaddsub213ps zmm22, zmm13, dword ptr [rdx - 512]{1to16}

// CHECK: vfmaddsub213ps zmm22, zmm13, dword ptr [rdx - 516]{1to16}
// CHECK:  encoding: [0x62,0xe2,0x15,0x58,0xa6,0xb2,0xfc,0xfd,0xff,0xff]
          vfmaddsub213ps zmm22, zmm13, dword ptr [rdx - 516]{1to16}

// CHECK: vfmaddsub231pd zmm4, zmm25, zmm28
// CHECK:  encoding: [0x62,0x92,0xb5,0x40,0xb6,0xe4]
          vfmaddsub231pd zmm4, zmm25, zmm28

// CHECK: vfmaddsub231pd zmm4 {k6}, zmm25, zmm28
// CHECK:  encoding: [0x62,0x92,0xb5,0x46,0xb6,0xe4]
          vfmaddsub231pd zmm4 {k6}, zmm25, zmm28

// CHECK: vfmaddsub231pd zmm4 {k6} {z}, zmm25, zmm28
// CHECK:  encoding: [0x62,0x92,0xb5,0xc6,0xb6,0xe4]
          vfmaddsub231pd zmm4 {k6} {z}, zmm25, zmm28

// CHECK: vfmaddsub231pd zmm4, zmm25, zmm28, {rn-sae}
// CHECK:  encoding: [0x62,0x92,0xb5,0x10,0xb6,0xe4]
          vfmaddsub231pd zmm4, zmm25, zmm28, {rn-sae}

// CHECK: vfmaddsub231pd zmm4, zmm25, zmm28, {ru-sae}
// CHECK:  encoding: [0x62,0x92,0xb5,0x50,0xb6,0xe4]
          vfmaddsub231pd zmm4, zmm25, zmm28, {ru-sae}

// CHECK: vfmaddsub231pd zmm4, zmm25, zmm28, {rd-sae}
// CHECK:  encoding: [0x62,0x92,0xb5,0x30,0xb6,0xe4]
          vfmaddsub231pd zmm4, zmm25, zmm28, {rd-sae}

// CHECK: vfmaddsub231pd zmm4, zmm25, zmm28, {rz-sae}
// CHECK:  encoding: [0x62,0x92,0xb5,0x70,0xb6,0xe4]
          vfmaddsub231pd zmm4, zmm25, zmm28, {rz-sae}

// CHECK: vfmaddsub231pd zmm4, zmm25, zmmword ptr [rcx]
// CHECK:  encoding: [0x62,0xf2,0xb5,0x40,0xb6,0x21]
          vfmaddsub231pd zmm4, zmm25, zmmword ptr [rcx]

// CHECK: vfmaddsub231pd zmm4, zmm25, zmmword ptr [rax + 8*r14 + 4660]
// CHECK:  encoding: [0x62,0xb2,0xb5,0x40,0xb6,0xa4,0xf0,0x34,0x12,0x00,0x00]
          vfmaddsub231pd zmm4, zmm25, zmmword ptr [rax + 8*r14 + 4660]

// CHECK: vfmaddsub231pd zmm4, zmm25, qword ptr [rcx]{1to8}
// CHECK:  encoding: [0x62,0xf2,0xb5,0x50,0xb6,0x21]
          vfmaddsub231pd zmm4, zmm25, qword ptr [rcx]{1to8}

// CHECK: vfmaddsub231pd zmm4, zmm25, zmmword ptr [rdx + 8128]
// CHECK:  encoding: [0x62,0xf2,0xb5,0x40,0xb6,0x62,0x7f]
          vfmaddsub231pd zmm4, zmm25, zmmword ptr [rdx + 8128]

// CHECK: vfmaddsub231pd zmm4, zmm25, zmmword ptr [rdx + 8192]
// CHECK:  encoding: [0x62,0xf2,0xb5,0x40,0xb6,0xa2,0x00,0x20,0x00,0x00]
          vfmaddsub231pd zmm4, zmm25, zmmword ptr [rdx + 8192]

// CHECK: vfmaddsub231pd zmm4, zmm25, zmmword ptr [rdx - 8192]
// CHECK:  encoding: [0x62,0xf2,0xb5,0x40,0xb6,0x62,0x80]
          vfmaddsub231pd zmm4, zmm25, zmmword ptr [rdx - 8192]

// CHECK: vfmaddsub231pd zmm4, zmm25, zmmword ptr [rdx - 8256]
// CHECK:  encoding: [0x62,0xf2,0xb5,0x40,0xb6,0xa2,0xc0,0xdf,0xff,0xff]
          vfmaddsub231pd zmm4, zmm25, zmmword ptr [rdx - 8256]

// CHECK: vfmaddsub231pd zmm4, zmm25, qword ptr [rdx + 1016]{1to8}
// CHECK:  encoding: [0x62,0xf2,0xb5,0x50,0xb6,0x62,0x7f]
          vfmaddsub231pd zmm4, zmm25, qword ptr [rdx + 1016]{1to8}

// CHECK: vfmaddsub231pd zmm4, zmm25, qword ptr [rdx + 1024]{1to8}
// CHECK:  encoding: [0x62,0xf2,0xb5,0x50,0xb6,0xa2,0x00,0x04,0x00,0x00]
          vfmaddsub231pd zmm4, zmm25, qword ptr [rdx + 1024]{1to8}

// CHECK: vfmaddsub231pd zmm4, zmm25, qword ptr [rdx - 1024]{1to8}
// CHECK:  encoding: [0x62,0xf2,0xb5,0x50,0xb6,0x62,0x80]
          vfmaddsub231pd zmm4, zmm25, qword ptr [rdx - 1024]{1to8}

// CHECK: vfmaddsub231pd zmm4, zmm25, qword ptr [rdx - 1032]{1to8}
// CHECK:  encoding: [0x62,0xf2,0xb5,0x50,0xb6,0xa2,0xf8,0xfb,0xff,0xff]
          vfmaddsub231pd zmm4, zmm25, qword ptr [rdx - 1032]{1to8}

// CHECK: vfmaddsub231ps zmm7, zmm22, zmm10
// CHECK:  encoding: [0x62,0xd2,0x4d,0x40,0xb6,0xfa]
          vfmaddsub231ps zmm7, zmm22, zmm10

// CHECK: vfmaddsub231ps zmm7 {k6}, zmm22, zmm10
// CHECK:  encoding: [0x62,0xd2,0x4d,0x46,0xb6,0xfa]
          vfmaddsub231ps zmm7 {k6}, zmm22, zmm10

// CHECK: vfmaddsub231ps zmm7 {k6} {z}, zmm22, zmm10
// CHECK:  encoding: [0x62,0xd2,0x4d,0xc6,0xb6,0xfa]
          vfmaddsub231ps zmm7 {k6} {z}, zmm22, zmm10

// CHECK: vfmaddsub231ps zmm7, zmm22, zmm10, {rn-sae}
// CHECK:  encoding: [0x62,0xd2,0x4d,0x10,0xb6,0xfa]
          vfmaddsub231ps zmm7, zmm22, zmm10, {rn-sae}

// CHECK: vfmaddsub231ps zmm7, zmm22, zmm10, {ru-sae}
// CHECK:  encoding: [0x62,0xd2,0x4d,0x50,0xb6,0xfa]
          vfmaddsub231ps zmm7, zmm22, zmm10, {ru-sae}

// CHECK: vfmaddsub231ps zmm7, zmm22, zmm10, {rd-sae}
// CHECK:  encoding: [0x62,0xd2,0x4d,0x30,0xb6,0xfa]
          vfmaddsub231ps zmm7, zmm22, zmm10, {rd-sae}

// CHECK: vfmaddsub231ps zmm7, zmm22, zmm10, {rz-sae}
// CHECK:  encoding: [0x62,0xd2,0x4d,0x70,0xb6,0xfa]
          vfmaddsub231ps zmm7, zmm22, zmm10, {rz-sae}

// CHECK: vfmaddsub231ps zmm7, zmm22, zmmword ptr [rcx]
// CHECK:  encoding: [0x62,0xf2,0x4d,0x40,0xb6,0x39]
          vfmaddsub231ps zmm7, zmm22, zmmword ptr [rcx]

// CHECK: vfmaddsub231ps zmm7, zmm22, zmmword ptr [rax + 8*r14 + 4660]
// CHECK:  encoding: [0x62,0xb2,0x4d,0x40,0xb6,0xbc,0xf0,0x34,0x12,0x00,0x00]
          vfmaddsub231ps zmm7, zmm22, zmmword ptr [rax + 8*r14 + 4660]

// CHECK: vfmaddsub231ps zmm7, zmm22, dword ptr [rcx]{1to16}
// CHECK:  encoding: [0x62,0xf2,0x4d,0x50,0xb6,0x39]
          vfmaddsub231ps zmm7, zmm22, dword ptr [rcx]{1to16}

// CHECK: vfmaddsub231ps zmm7, zmm22, zmmword ptr [rdx + 8128]
// CHECK:  encoding: [0x62,0xf2,0x4d,0x40,0xb6,0x7a,0x7f]
          vfmaddsub231ps zmm7, zmm22, zmmword ptr [rdx + 8128]

// CHECK: vfmaddsub231ps zmm7, zmm22, zmmword ptr [rdx + 8192]
// CHECK:  encoding: [0x62,0xf2,0x4d,0x40,0xb6,0xba,0x00,0x20,0x00,0x00]
          vfmaddsub231ps zmm7, zmm22, zmmword ptr [rdx + 8192]

// CHECK: vfmaddsub231ps zmm7, zmm22, zmmword ptr [rdx - 8192]
// CHECK:  encoding: [0x62,0xf2,0x4d,0x40,0xb6,0x7a,0x80]
          vfmaddsub231ps zmm7, zmm22, zmmword ptr [rdx - 8192]

// CHECK: vfmaddsub231ps zmm7, zmm22, zmmword ptr [rdx - 8256]
// CHECK:  encoding: [0x62,0xf2,0x4d,0x40,0xb6,0xba,0xc0,0xdf,0xff,0xff]
          vfmaddsub231ps zmm7, zmm22, zmmword ptr [rdx - 8256]

// CHECK: vfmaddsub231ps zmm7, zmm22, dword ptr [rdx + 508]{1to16}
// CHECK:  encoding: [0x62,0xf2,0x4d,0x50,0xb6,0x7a,0x7f]
          vfmaddsub231ps zmm7, zmm22, dword ptr [rdx + 508]{1to16}

// CHECK: vfmaddsub231ps zmm7, zmm22, dword ptr [rdx + 512]{1to16}
// CHECK:  encoding: [0x62,0xf2,0x4d,0x50,0xb6,0xba,0x00,0x02,0x00,0x00]
          vfmaddsub231ps zmm7, zmm22, dword ptr [rdx + 512]{1to16}

// CHECK: vfmaddsub231ps zmm7, zmm22, dword ptr [rdx - 512]{1to16}
// CHECK:  encoding: [0x62,0xf2,0x4d,0x50,0xb6,0x7a,0x80]
          vfmaddsub231ps zmm7, zmm22, dword ptr [rdx - 512]{1to16}

// CHECK: vfmaddsub231ps zmm7, zmm22, dword ptr [rdx - 516]{1to16}
// CHECK:  encoding: [0x62,0xf2,0x4d,0x50,0xb6,0xba,0xfc,0xfd,0xff,0xff]
          vfmaddsub231ps zmm7, zmm22, dword ptr [rdx - 516]{1to16}

// CHECK: vfmsub132pd zmm25, zmm29, zmm19
// CHECK:  encoding: [0x62,0x22,0x95,0x40,0x9a,0xcb]
          vfmsub132pd zmm25, zmm29, zmm19

// CHECK: vfmsub132pd zmm25 {k4}, zmm29, zmm19
// CHECK:  encoding: [0x62,0x22,0x95,0x44,0x9a,0xcb]
          vfmsub132pd zmm25 {k4}, zmm29, zmm19

// CHECK: vfmsub132pd zmm25 {k4} {z}, zmm29, zmm19
// CHECK:  encoding: [0x62,0x22,0x95,0xc4,0x9a,0xcb]
          vfmsub132pd zmm25 {k4} {z}, zmm29, zmm19

// CHECK: vfmsub132pd zmm25, zmm29, zmm19, {rn-sae}
// CHECK:  encoding: [0x62,0x22,0x95,0x10,0x9a,0xcb]
          vfmsub132pd zmm25, zmm29, zmm19, {rn-sae}

// CHECK: vfmsub132pd zmm25, zmm29, zmm19, {ru-sae}
// CHECK:  encoding: [0x62,0x22,0x95,0x50,0x9a,0xcb]
          vfmsub132pd zmm25, zmm29, zmm19, {ru-sae}

// CHECK: vfmsub132pd zmm25, zmm29, zmm19, {rd-sae}
// CHECK:  encoding: [0x62,0x22,0x95,0x30,0x9a,0xcb]
          vfmsub132pd zmm25, zmm29, zmm19, {rd-sae}

// CHECK: vfmsub132pd zmm25, zmm29, zmm19, {rz-sae}
// CHECK:  encoding: [0x62,0x22,0x95,0x70,0x9a,0xcb]
          vfmsub132pd zmm25, zmm29, zmm19, {rz-sae}

// CHECK: vfmsub132pd zmm25, zmm29, zmmword ptr [rcx]
// CHECK:  encoding: [0x62,0x62,0x95,0x40,0x9a,0x09]
          vfmsub132pd zmm25, zmm29, zmmword ptr [rcx]

// CHECK: vfmsub132pd zmm25, zmm29, zmmword ptr [rax + 8*r14 + 4660]
// CHECK:  encoding: [0x62,0x22,0x95,0x40,0x9a,0x8c,0xf0,0x34,0x12,0x00,0x00]
          vfmsub132pd zmm25, zmm29, zmmword ptr [rax + 8*r14 + 4660]

// CHECK: vfmsub132pd zmm25, zmm29, qword ptr [rcx]{1to8}
// CHECK:  encoding: [0x62,0x62,0x95,0x50,0x9a,0x09]
          vfmsub132pd zmm25, zmm29, qword ptr [rcx]{1to8}

// CHECK: vfmsub132pd zmm25, zmm29, zmmword ptr [rdx + 8128]
// CHECK:  encoding: [0x62,0x62,0x95,0x40,0x9a,0x4a,0x7f]
          vfmsub132pd zmm25, zmm29, zmmword ptr [rdx + 8128]

// CHECK: vfmsub132pd zmm25, zmm29, zmmword ptr [rdx + 8192]
// CHECK:  encoding: [0x62,0x62,0x95,0x40,0x9a,0x8a,0x00,0x20,0x00,0x00]
          vfmsub132pd zmm25, zmm29, zmmword ptr [rdx + 8192]

// CHECK: vfmsub132pd zmm25, zmm29, zmmword ptr [rdx - 8192]
// CHECK:  encoding: [0x62,0x62,0x95,0x40,0x9a,0x4a,0x80]
          vfmsub132pd zmm25, zmm29, zmmword ptr [rdx - 8192]

// CHECK: vfmsub132pd zmm25, zmm29, zmmword ptr [rdx - 8256]
// CHECK:  encoding: [0x62,0x62,0x95,0x40,0x9a,0x8a,0xc0,0xdf,0xff,0xff]
          vfmsub132pd zmm25, zmm29, zmmword ptr [rdx - 8256]

// CHECK: vfmsub132pd zmm25, zmm29, qword ptr [rdx + 1016]{1to8}
// CHECK:  encoding: [0x62,0x62,0x95,0x50,0x9a,0x4a,0x7f]
          vfmsub132pd zmm25, zmm29, qword ptr [rdx + 1016]{1to8}

// CHECK: vfmsub132pd zmm25, zmm29, qword ptr [rdx + 1024]{1to8}
// CHECK:  encoding: [0x62,0x62,0x95,0x50,0x9a,0x8a,0x00,0x04,0x00,0x00]
          vfmsub132pd zmm25, zmm29, qword ptr [rdx + 1024]{1to8}

// CHECK: vfmsub132pd zmm25, zmm29, qword ptr [rdx - 1024]{1to8}
// CHECK:  encoding: [0x62,0x62,0x95,0x50,0x9a,0x4a,0x80]
          vfmsub132pd zmm25, zmm29, qword ptr [rdx - 1024]{1to8}

// CHECK: vfmsub132pd zmm25, zmm29, qword ptr [rdx - 1032]{1to8}
// CHECK:  encoding: [0x62,0x62,0x95,0x50,0x9a,0x8a,0xf8,0xfb,0xff,0xff]
          vfmsub132pd zmm25, zmm29, qword ptr [rdx - 1032]{1to8}

// CHECK: vfmsub132ps zmm27, zmm6, zmm18
// CHECK:  encoding: [0x62,0x22,0x4d,0x48,0x9a,0xda]
          vfmsub132ps zmm27, zmm6, zmm18

// CHECK: vfmsub132ps zmm27 {k4}, zmm6, zmm18
// CHECK:  encoding: [0x62,0x22,0x4d,0x4c,0x9a,0xda]
          vfmsub132ps zmm27 {k4}, zmm6, zmm18

// CHECK: vfmsub132ps zmm27 {k4} {z}, zmm6, zmm18
// CHECK:  encoding: [0x62,0x22,0x4d,0xcc,0x9a,0xda]
          vfmsub132ps zmm27 {k4} {z}, zmm6, zmm18

// CHECK: vfmsub132ps zmm27, zmm6, zmm18, {rn-sae}
// CHECK:  encoding: [0x62,0x22,0x4d,0x18,0x9a,0xda]
          vfmsub132ps zmm27, zmm6, zmm18, {rn-sae}

// CHECK: vfmsub132ps zmm27, zmm6, zmm18, {ru-sae}
// CHECK:  encoding: [0x62,0x22,0x4d,0x58,0x9a,0xda]
          vfmsub132ps zmm27, zmm6, zmm18, {ru-sae}

// CHECK: vfmsub132ps zmm27, zmm6, zmm18, {rd-sae}
// CHECK:  encoding: [0x62,0x22,0x4d,0x38,0x9a,0xda]
          vfmsub132ps zmm27, zmm6, zmm18, {rd-sae}

// CHECK: vfmsub132ps zmm27, zmm6, zmm18, {rz-sae}
// CHECK:  encoding: [0x62,0x22,0x4d,0x78,0x9a,0xda]
          vfmsub132ps zmm27, zmm6, zmm18, {rz-sae}

// CHECK: vfmsub132ps zmm27, zmm6, zmmword ptr [rcx]
// CHECK:  encoding: [0x62,0x62,0x4d,0x48,0x9a,0x19]
          vfmsub132ps zmm27, zmm6, zmmword ptr [rcx]

// CHECK: vfmsub132ps zmm27, zmm6, zmmword ptr [rax + 8*r14 + 4660]
// CHECK:  encoding: [0x62,0x22,0x4d,0x48,0x9a,0x9c,0xf0,0x34,0x12,0x00,0x00]
          vfmsub132ps zmm27, zmm6, zmmword ptr [rax + 8*r14 + 4660]

// CHECK: vfmsub132ps zmm27, zmm6, dword ptr [rcx]{1to16}
// CHECK:  encoding: [0x62,0x62,0x4d,0x58,0x9a,0x19]
          vfmsub132ps zmm27, zmm6, dword ptr [rcx]{1to16}

// CHECK: vfmsub132ps zmm27, zmm6, zmmword ptr [rdx + 8128]
// CHECK:  encoding: [0x62,0x62,0x4d,0x48,0x9a,0x5a,0x7f]
          vfmsub132ps zmm27, zmm6, zmmword ptr [rdx + 8128]

// CHECK: vfmsub132ps zmm27, zmm6, zmmword ptr [rdx + 8192]
// CHECK:  encoding: [0x62,0x62,0x4d,0x48,0x9a,0x9a,0x00,0x20,0x00,0x00]
          vfmsub132ps zmm27, zmm6, zmmword ptr [rdx + 8192]

// CHECK: vfmsub132ps zmm27, zmm6, zmmword ptr [rdx - 8192]
// CHECK:  encoding: [0x62,0x62,0x4d,0x48,0x9a,0x5a,0x80]
          vfmsub132ps zmm27, zmm6, zmmword ptr [rdx - 8192]

// CHECK: vfmsub132ps zmm27, zmm6, zmmword ptr [rdx - 8256]
// CHECK:  encoding: [0x62,0x62,0x4d,0x48,0x9a,0x9a,0xc0,0xdf,0xff,0xff]
          vfmsub132ps zmm27, zmm6, zmmword ptr [rdx - 8256]

// CHECK: vfmsub132ps zmm27, zmm6, dword ptr [rdx + 508]{1to16}
// CHECK:  encoding: [0x62,0x62,0x4d,0x58,0x9a,0x5a,0x7f]
          vfmsub132ps zmm27, zmm6, dword ptr [rdx + 508]{1to16}

// CHECK: vfmsub132ps zmm27, zmm6, dword ptr [rdx + 512]{1to16}
// CHECK:  encoding: [0x62,0x62,0x4d,0x58,0x9a,0x9a,0x00,0x02,0x00,0x00]
          vfmsub132ps zmm27, zmm6, dword ptr [rdx + 512]{1to16}

// CHECK: vfmsub132ps zmm27, zmm6, dword ptr [rdx - 512]{1to16}
// CHECK:  encoding: [0x62,0x62,0x4d,0x58,0x9a,0x5a,0x80]
          vfmsub132ps zmm27, zmm6, dword ptr [rdx - 512]{1to16}

// CHECK: vfmsub132ps zmm27, zmm6, dword ptr [rdx - 516]{1to16}
// CHECK:  encoding: [0x62,0x62,0x4d,0x58,0x9a,0x9a,0xfc,0xfd,0xff,0xff]
          vfmsub132ps zmm27, zmm6, dword ptr [rdx - 516]{1to16}

// CHECK: vfmsub132sd xmm23, xmm20, xmm28
// CHECK:  encoding: [0x62,0x82,0xdd,0x00,0x9b,0xfc]
          vfmsub132sd xmm23, xmm20, xmm28

// CHECK: vfmsub132sd xmm23 {k1}, xmm20, xmm28
// CHECK:  encoding: [0x62,0x82,0xdd,0x01,0x9b,0xfc]
          vfmsub132sd xmm23 {k1}, xmm20, xmm28

// CHECK: vfmsub132sd xmm23 {k1} {z}, xmm20, xmm28
// CHECK:  encoding: [0x62,0x82,0xdd,0x81,0x9b,0xfc]
          vfmsub132sd xmm23 {k1} {z}, xmm20, xmm28

// CHECK: vfmsub132sd xmm23, xmm20, xmm28, {rn-sae}
// CHECK:  encoding: [0x62,0x82,0xdd,0x10,0x9b,0xfc]
          vfmsub132sd xmm23, xmm20, xmm28, {rn-sae}

// CHECK: vfmsub132sd xmm23, xmm20, xmm28, {ru-sae}
// CHECK:  encoding: [0x62,0x82,0xdd,0x50,0x9b,0xfc]
          vfmsub132sd xmm23, xmm20, xmm28, {ru-sae}

// CHECK: vfmsub132sd xmm23, xmm20, xmm28, {rd-sae}
// CHECK:  encoding: [0x62,0x82,0xdd,0x30,0x9b,0xfc]
          vfmsub132sd xmm23, xmm20, xmm28, {rd-sae}

// CHECK: vfmsub132sd xmm23, xmm20, xmm28, {rz-sae}
// CHECK:  encoding: [0x62,0x82,0xdd,0x70,0x9b,0xfc]
          vfmsub132sd xmm23, xmm20, xmm28, {rz-sae}

// CHECK: vfmsub132sd xmm23, xmm20, qword ptr [rcx]
// CHECK:  encoding: [0x62,0xe2,0xdd,0x00,0x9b,0x39]
          vfmsub132sd xmm23, xmm20, qword ptr [rcx]

// CHECK: vfmsub132sd xmm23, xmm20, qword ptr [rax + 8*r14 + 4660]
// CHECK:  encoding: [0x62,0xa2,0xdd,0x00,0x9b,0xbc,0xf0,0x34,0x12,0x00,0x00]
          vfmsub132sd xmm23, xmm20, qword ptr [rax + 8*r14 + 4660]

// CHECK: vfmsub132sd xmm23, xmm20, qword ptr [rdx + 1016]
// CHECK:  encoding: [0x62,0xe2,0xdd,0x00,0x9b,0x7a,0x7f]
          vfmsub132sd xmm23, xmm20, qword ptr [rdx + 1016]

// CHECK: vfmsub132sd xmm23, xmm20, qword ptr [rdx + 1024]
// CHECK:  encoding: [0x62,0xe2,0xdd,0x00,0x9b,0xba,0x00,0x04,0x00,0x00]
          vfmsub132sd xmm23, xmm20, qword ptr [rdx + 1024]

// CHECK: vfmsub132sd xmm23, xmm20, qword ptr [rdx - 1024]
// CHECK:  encoding: [0x62,0xe2,0xdd,0x00,0x9b,0x7a,0x80]
          vfmsub132sd xmm23, xmm20, qword ptr [rdx - 1024]

// CHECK: vfmsub132sd xmm23, xmm20, qword ptr [rdx - 1032]
// CHECK:  encoding: [0x62,0xe2,0xdd,0x00,0x9b,0xba,0xf8,0xfb,0xff,0xff]
          vfmsub132sd xmm23, xmm20, qword ptr [rdx - 1032]

// CHECK: vfmsub132ss xmm26, xmm9, xmm25
// CHECK:  encoding: [0x62,0x02,0x35,0x08,0x9b,0xd1]
          vfmsub132ss xmm26, xmm9, xmm25

// CHECK: vfmsub132ss xmm26 {k7}, xmm9, xmm25
// CHECK:  encoding: [0x62,0x02,0x35,0x0f,0x9b,0xd1]
          vfmsub132ss xmm26 {k7}, xmm9, xmm25

// CHECK: vfmsub132ss xmm26 {k7} {z}, xmm9, xmm25
// CHECK:  encoding: [0x62,0x02,0x35,0x8f,0x9b,0xd1]
          vfmsub132ss xmm26 {k7} {z}, xmm9, xmm25

// CHECK: vfmsub132ss xmm26, xmm9, xmm25, {rn-sae}
// CHECK:  encoding: [0x62,0x02,0x35,0x18,0x9b,0xd1]
          vfmsub132ss xmm26, xmm9, xmm25, {rn-sae}

// CHECK: vfmsub132ss xmm26, xmm9, xmm25, {ru-sae}
// CHECK:  encoding: [0x62,0x02,0x35,0x58,0x9b,0xd1]
          vfmsub132ss xmm26, xmm9, xmm25, {ru-sae}

// CHECK: vfmsub132ss xmm26, xmm9, xmm25, {rd-sae}
// CHECK:  encoding: [0x62,0x02,0x35,0x38,0x9b,0xd1]
          vfmsub132ss xmm26, xmm9, xmm25, {rd-sae}

// CHECK: vfmsub132ss xmm26, xmm9, xmm25, {rz-sae}
// CHECK:  encoding: [0x62,0x02,0x35,0x78,0x9b,0xd1]
          vfmsub132ss xmm26, xmm9, xmm25, {rz-sae}

// CHECK: vfmsub132ss xmm26, xmm9, dword ptr [rcx]
// CHECK:  encoding: [0x62,0x62,0x35,0x08,0x9b,0x11]
          vfmsub132ss xmm26, xmm9, dword ptr [rcx]

// CHECK: vfmsub132ss xmm26, xmm9, dword ptr [rax + 8*r14 + 4660]
// CHECK:  encoding: [0x62,0x22,0x35,0x08,0x9b,0x94,0xf0,0x34,0x12,0x00,0x00]
          vfmsub132ss xmm26, xmm9, dword ptr [rax + 8*r14 + 4660]

// CHECK: vfmsub132ss xmm26, xmm9, dword ptr [rdx + 508]
// CHECK:  encoding: [0x62,0x62,0x35,0x08,0x9b,0x52,0x7f]
          vfmsub132ss xmm26, xmm9, dword ptr [rdx + 508]

// CHECK: vfmsub132ss xmm26, xmm9, dword ptr [rdx + 512]
// CHECK:  encoding: [0x62,0x62,0x35,0x08,0x9b,0x92,0x00,0x02,0x00,0x00]
          vfmsub132ss xmm26, xmm9, dword ptr [rdx + 512]

// CHECK: vfmsub132ss xmm26, xmm9, dword ptr [rdx - 512]
// CHECK:  encoding: [0x62,0x62,0x35,0x08,0x9b,0x52,0x80]
          vfmsub132ss xmm26, xmm9, dword ptr [rdx - 512]

// CHECK: vfmsub132ss xmm26, xmm9, dword ptr [rdx - 516]
// CHECK:  encoding: [0x62,0x62,0x35,0x08,0x9b,0x92,0xfc,0xfd,0xff,0xff]
          vfmsub132ss xmm26, xmm9, dword ptr [rdx - 516]

// CHECK: vfmsub213pd zmm7, zmm18, zmm19
// CHECK:  encoding: [0x62,0xb2,0xed,0x40,0xaa,0xfb]
          vfmsub213pd zmm7, zmm18, zmm19

// CHECK: vfmsub213pd zmm7 {k4}, zmm18, zmm19
// CHECK:  encoding: [0x62,0xb2,0xed,0x44,0xaa,0xfb]
          vfmsub213pd zmm7 {k4}, zmm18, zmm19

// CHECK: vfmsub213pd zmm7 {k4} {z}, zmm18, zmm19
// CHECK:  encoding: [0x62,0xb2,0xed,0xc4,0xaa,0xfb]
          vfmsub213pd zmm7 {k4} {z}, zmm18, zmm19

// CHECK: vfmsub213pd zmm7, zmm18, zmm19, {rn-sae}
// CHECK:  encoding: [0x62,0xb2,0xed,0x10,0xaa,0xfb]
          vfmsub213pd zmm7, zmm18, zmm19, {rn-sae}

// CHECK: vfmsub213pd zmm7, zmm18, zmm19, {ru-sae}
// CHECK:  encoding: [0x62,0xb2,0xed,0x50,0xaa,0xfb]
          vfmsub213pd zmm7, zmm18, zmm19, {ru-sae}

// CHECK: vfmsub213pd zmm7, zmm18, zmm19, {rd-sae}
// CHECK:  encoding: [0x62,0xb2,0xed,0x30,0xaa,0xfb]
          vfmsub213pd zmm7, zmm18, zmm19, {rd-sae}

// CHECK: vfmsub213pd zmm7, zmm18, zmm19, {rz-sae}
// CHECK:  encoding: [0x62,0xb2,0xed,0x70,0xaa,0xfb]
          vfmsub213pd zmm7, zmm18, zmm19, {rz-sae}

// CHECK: vfmsub213pd zmm7, zmm18, zmmword ptr [rcx]
// CHECK:  encoding: [0x62,0xf2,0xed,0x40,0xaa,0x39]
          vfmsub213pd zmm7, zmm18, zmmword ptr [rcx]

// CHECK: vfmsub213pd zmm7, zmm18, zmmword ptr [rax + 8*r14 + 4660]
// CHECK:  encoding: [0x62,0xb2,0xed,0x40,0xaa,0xbc,0xf0,0x34,0x12,0x00,0x00]
          vfmsub213pd zmm7, zmm18, zmmword ptr [rax + 8*r14 + 4660]

// CHECK: vfmsub213pd zmm7, zmm18, qword ptr [rcx]{1to8}
// CHECK:  encoding: [0x62,0xf2,0xed,0x50,0xaa,0x39]
          vfmsub213pd zmm7, zmm18, qword ptr [rcx]{1to8}

// CHECK: vfmsub213pd zmm7, zmm18, zmmword ptr [rdx + 8128]
// CHECK:  encoding: [0x62,0xf2,0xed,0x40,0xaa,0x7a,0x7f]
          vfmsub213pd zmm7, zmm18, zmmword ptr [rdx + 8128]

// CHECK: vfmsub213pd zmm7, zmm18, zmmword ptr [rdx + 8192]
// CHECK:  encoding: [0x62,0xf2,0xed,0x40,0xaa,0xba,0x00,0x20,0x00,0x00]
          vfmsub213pd zmm7, zmm18, zmmword ptr [rdx + 8192]

// CHECK: vfmsub213pd zmm7, zmm18, zmmword ptr [rdx - 8192]
// CHECK:  encoding: [0x62,0xf2,0xed,0x40,0xaa,0x7a,0x80]
          vfmsub213pd zmm7, zmm18, zmmword ptr [rdx - 8192]

// CHECK: vfmsub213pd zmm7, zmm18, zmmword ptr [rdx - 8256]
// CHECK:  encoding: [0x62,0xf2,0xed,0x40,0xaa,0xba,0xc0,0xdf,0xff,0xff]
          vfmsub213pd zmm7, zmm18, zmmword ptr [rdx - 8256]

// CHECK: vfmsub213pd zmm7, zmm18, qword ptr [rdx + 1016]{1to8}
// CHECK:  encoding: [0x62,0xf2,0xed,0x50,0xaa,0x7a,0x7f]
          vfmsub213pd zmm7, zmm18, qword ptr [rdx + 1016]{1to8}

// CHECK: vfmsub213pd zmm7, zmm18, qword ptr [rdx + 1024]{1to8}
// CHECK:  encoding: [0x62,0xf2,0xed,0x50,0xaa,0xba,0x00,0x04,0x00,0x00]
          vfmsub213pd zmm7, zmm18, qword ptr [rdx + 1024]{1to8}

// CHECK: vfmsub213pd zmm7, zmm18, qword ptr [rdx - 1024]{1to8}
// CHECK:  encoding: [0x62,0xf2,0xed,0x50,0xaa,0x7a,0x80]
          vfmsub213pd zmm7, zmm18, qword ptr [rdx - 1024]{1to8}

// CHECK: vfmsub213pd zmm7, zmm18, qword ptr [rdx - 1032]{1to8}
// CHECK:  encoding: [0x62,0xf2,0xed,0x50,0xaa,0xba,0xf8,0xfb,0xff,0xff]
          vfmsub213pd zmm7, zmm18, qword ptr [rdx - 1032]{1to8}

// CHECK: vfmsub213ps zmm9, zmm16, zmm6
// CHECK:  encoding: [0x62,0x72,0x7d,0x40,0xaa,0xce]
          vfmsub213ps zmm9, zmm16, zmm6

// CHECK: vfmsub213ps zmm9 {k6}, zmm16, zmm6
// CHECK:  encoding: [0x62,0x72,0x7d,0x46,0xaa,0xce]
          vfmsub213ps zmm9 {k6}, zmm16, zmm6

// CHECK: vfmsub213ps zmm9 {k6} {z}, zmm16, zmm6
// CHECK:  encoding: [0x62,0x72,0x7d,0xc6,0xaa,0xce]
          vfmsub213ps zmm9 {k6} {z}, zmm16, zmm6

// CHECK: vfmsub213ps zmm9, zmm16, zmm6, {rn-sae}
// CHECK:  encoding: [0x62,0x72,0x7d,0x10,0xaa,0xce]
          vfmsub213ps zmm9, zmm16, zmm6, {rn-sae}

// CHECK: vfmsub213ps zmm9, zmm16, zmm6, {ru-sae}
// CHECK:  encoding: [0x62,0x72,0x7d,0x50,0xaa,0xce]
          vfmsub213ps zmm9, zmm16, zmm6, {ru-sae}

// CHECK: vfmsub213ps zmm9, zmm16, zmm6, {rd-sae}
// CHECK:  encoding: [0x62,0x72,0x7d,0x30,0xaa,0xce]
          vfmsub213ps zmm9, zmm16, zmm6, {rd-sae}

// CHECK: vfmsub213ps zmm9, zmm16, zmm6, {rz-sae}
// CHECK:  encoding: [0x62,0x72,0x7d,0x70,0xaa,0xce]
          vfmsub213ps zmm9, zmm16, zmm6, {rz-sae}

// CHECK: vfmsub213ps zmm9, zmm16, zmmword ptr [rcx]
// CHECK:  encoding: [0x62,0x72,0x7d,0x40,0xaa,0x09]
          vfmsub213ps zmm9, zmm16, zmmword ptr [rcx]

// CHECK: vfmsub213ps zmm9, zmm16, zmmword ptr [rax + 8*r14 + 4660]
// CHECK:  encoding: [0x62,0x32,0x7d,0x40,0xaa,0x8c,0xf0,0x34,0x12,0x00,0x00]
          vfmsub213ps zmm9, zmm16, zmmword ptr [rax + 8*r14 + 4660]

// CHECK: vfmsub213ps zmm9, zmm16, dword ptr [rcx]{1to16}
// CHECK:  encoding: [0x62,0x72,0x7d,0x50,0xaa,0x09]
          vfmsub213ps zmm9, zmm16, dword ptr [rcx]{1to16}

// CHECK: vfmsub213ps zmm9, zmm16, zmmword ptr [rdx + 8128]
// CHECK:  encoding: [0x62,0x72,0x7d,0x40,0xaa,0x4a,0x7f]
          vfmsub213ps zmm9, zmm16, zmmword ptr [rdx + 8128]

// CHECK: vfmsub213ps zmm9, zmm16, zmmword ptr [rdx + 8192]
// CHECK:  encoding: [0x62,0x72,0x7d,0x40,0xaa,0x8a,0x00,0x20,0x00,0x00]
          vfmsub213ps zmm9, zmm16, zmmword ptr [rdx + 8192]

// CHECK: vfmsub213ps zmm9, zmm16, zmmword ptr [rdx - 8192]
// CHECK:  encoding: [0x62,0x72,0x7d,0x40,0xaa,0x4a,0x80]
          vfmsub213ps zmm9, zmm16, zmmword ptr [rdx - 8192]

// CHECK: vfmsub213ps zmm9, zmm16, zmmword ptr [rdx - 8256]
// CHECK:  encoding: [0x62,0x72,0x7d,0x40,0xaa,0x8a,0xc0,0xdf,0xff,0xff]
          vfmsub213ps zmm9, zmm16, zmmword ptr [rdx - 8256]

// CHECK: vfmsub213ps zmm9, zmm16, dword ptr [rdx + 508]{1to16}
// CHECK:  encoding: [0x62,0x72,0x7d,0x50,0xaa,0x4a,0x7f]
          vfmsub213ps zmm9, zmm16, dword ptr [rdx + 508]{1to16}

// CHECK: vfmsub213ps zmm9, zmm16, dword ptr [rdx + 512]{1to16}
// CHECK:  encoding: [0x62,0x72,0x7d,0x50,0xaa,0x8a,0x00,0x02,0x00,0x00]
          vfmsub213ps zmm9, zmm16, dword ptr [rdx + 512]{1to16}

// CHECK: vfmsub213ps zmm9, zmm16, dword ptr [rdx - 512]{1to16}
// CHECK:  encoding: [0x62,0x72,0x7d,0x50,0xaa,0x4a,0x80]
          vfmsub213ps zmm9, zmm16, dword ptr [rdx - 512]{1to16}

// CHECK: vfmsub213ps zmm9, zmm16, dword ptr [rdx - 516]{1to16}
// CHECK:  encoding: [0x62,0x72,0x7d,0x50,0xaa,0x8a,0xfc,0xfd,0xff,0xff]
          vfmsub213ps zmm9, zmm16, dword ptr [rdx - 516]{1to16}

// CHECK: vfmsub213sd xmm12, xmm18, xmm20
// CHECK:  encoding: [0x62,0x32,0xed,0x00,0xab,0xe4]
          vfmsub213sd xmm12, xmm18, xmm20

// CHECK: vfmsub213sd xmm12 {k4}, xmm18, xmm20
// CHECK:  encoding: [0x62,0x32,0xed,0x04,0xab,0xe4]
          vfmsub213sd xmm12 {k4}, xmm18, xmm20

// CHECK: vfmsub213sd xmm12 {k4} {z}, xmm18, xmm20
// CHECK:  encoding: [0x62,0x32,0xed,0x84,0xab,0xe4]
          vfmsub213sd xmm12 {k4} {z}, xmm18, xmm20

// CHECK: vfmsub213sd xmm12, xmm18, xmm20, {rn-sae}
// CHECK:  encoding: [0x62,0x32,0xed,0x10,0xab,0xe4]
          vfmsub213sd xmm12, xmm18, xmm20, {rn-sae}

// CHECK: vfmsub213sd xmm12, xmm18, xmm20, {ru-sae}
// CHECK:  encoding: [0x62,0x32,0xed,0x50,0xab,0xe4]
          vfmsub213sd xmm12, xmm18, xmm20, {ru-sae}

// CHECK: vfmsub213sd xmm12, xmm18, xmm20, {rd-sae}
// CHECK:  encoding: [0x62,0x32,0xed,0x30,0xab,0xe4]
          vfmsub213sd xmm12, xmm18, xmm20, {rd-sae}

// CHECK: vfmsub213sd xmm12, xmm18, xmm20, {rz-sae}
// CHECK:  encoding: [0x62,0x32,0xed,0x70,0xab,0xe4]
          vfmsub213sd xmm12, xmm18, xmm20, {rz-sae}

// CHECK: vfmsub213sd xmm12, xmm18, qword ptr [rcx]
// CHECK:  encoding: [0x62,0x72,0xed,0x00,0xab,0x21]
          vfmsub213sd xmm12, xmm18, qword ptr [rcx]

// CHECK: vfmsub213sd xmm12, xmm18, qword ptr [rax + 8*r14 + 4660]
// CHECK:  encoding: [0x62,0x32,0xed,0x00,0xab,0xa4,0xf0,0x34,0x12,0x00,0x00]
          vfmsub213sd xmm12, xmm18, qword ptr [rax + 8*r14 + 4660]

// CHECK: vfmsub213sd xmm12, xmm18, qword ptr [rdx + 1016]
// CHECK:  encoding: [0x62,0x72,0xed,0x00,0xab,0x62,0x7f]
          vfmsub213sd xmm12, xmm18, qword ptr [rdx + 1016]

// CHECK: vfmsub213sd xmm12, xmm18, qword ptr [rdx + 1024]
// CHECK:  encoding: [0x62,0x72,0xed,0x00,0xab,0xa2,0x00,0x04,0x00,0x00]
          vfmsub213sd xmm12, xmm18, qword ptr [rdx + 1024]

// CHECK: vfmsub213sd xmm12, xmm18, qword ptr [rdx - 1024]
// CHECK:  encoding: [0x62,0x72,0xed,0x00,0xab,0x62,0x80]
          vfmsub213sd xmm12, xmm18, qword ptr [rdx - 1024]

// CHECK: vfmsub213sd xmm12, xmm18, qword ptr [rdx - 1032]
// CHECK:  encoding: [0x62,0x72,0xed,0x00,0xab,0xa2,0xf8,0xfb,0xff,0xff]
          vfmsub213sd xmm12, xmm18, qword ptr [rdx - 1032]

// CHECK: vfmsub213ss xmm2, xmm1, xmm9
// CHECK:  encoding: [0xc4,0xc2,0x71,0xab,0xd1]
          vfmsub213ss xmm2, xmm1, xmm9

// CHECK: vfmsub213ss xmm2 {k7}, xmm1, xmm9
// CHECK:  encoding: [0x62,0xd2,0x75,0x0f,0xab,0xd1]
          vfmsub213ss xmm2 {k7}, xmm1, xmm9

// CHECK: vfmsub213ss xmm2 {k7} {z}, xmm1, xmm9
// CHECK:  encoding: [0x62,0xd2,0x75,0x8f,0xab,0xd1]
          vfmsub213ss xmm2 {k7} {z}, xmm1, xmm9

// CHECK: vfmsub213ss xmm2, xmm1, xmm9, {rn-sae}
// CHECK:  encoding: [0x62,0xd2,0x75,0x18,0xab,0xd1]
          vfmsub213ss xmm2, xmm1, xmm9, {rn-sae}

// CHECK: vfmsub213ss xmm2, xmm1, xmm9, {ru-sae}
// CHECK:  encoding: [0x62,0xd2,0x75,0x58,0xab,0xd1]
          vfmsub213ss xmm2, xmm1, xmm9, {ru-sae}

// CHECK: vfmsub213ss xmm2, xmm1, xmm9, {rd-sae}
// CHECK:  encoding: [0x62,0xd2,0x75,0x38,0xab,0xd1]
          vfmsub213ss xmm2, xmm1, xmm9, {rd-sae}

// CHECK: vfmsub213ss xmm2, xmm1, xmm9, {rz-sae}
// CHECK:  encoding: [0x62,0xd2,0x75,0x78,0xab,0xd1]
          vfmsub213ss xmm2, xmm1, xmm9, {rz-sae}

// CHECK: vfmsub213ss xmm2, xmm1, dword ptr [rcx]
// CHECK:  encoding: [0xc4,0xe2,0x71,0xab,0x11]
          vfmsub213ss xmm2, xmm1, dword ptr [rcx]

// CHECK: vfmsub213ss xmm2, xmm1, dword ptr [rax + 8*r14 + 4660]
// CHECK:  encoding: [0xc4,0xa2,0x71,0xab,0x94,0xf0,0x34,0x12,0x00,0x00]
          vfmsub213ss xmm2, xmm1, dword ptr [rax + 8*r14 + 4660]

// CHECK: vfmsub213ss xmm2, xmm1, dword ptr [rdx + 508]
// CHECK:  encoding: [0xc4,0xe2,0x71,0xab,0x92,0xfc,0x01,0x00,0x00]
          vfmsub213ss xmm2, xmm1, dword ptr [rdx + 508]

// CHECK: vfmsub213ss xmm2, xmm1, dword ptr [rdx + 512]
// CHECK:  encoding: [0xc4,0xe2,0x71,0xab,0x92,0x00,0x02,0x00,0x00]
          vfmsub213ss xmm2, xmm1, dword ptr [rdx + 512]

// CHECK: vfmsub213ss xmm2, xmm1, dword ptr [rdx - 512]
// CHECK:  encoding: [0xc4,0xe2,0x71,0xab,0x92,0x00,0xfe,0xff,0xff]
          vfmsub213ss xmm2, xmm1, dword ptr [rdx - 512]

// CHECK: vfmsub213ss xmm2, xmm1, dword ptr [rdx - 516]
// CHECK:  encoding: [0xc4,0xe2,0x71,0xab,0x92,0xfc,0xfd,0xff,0xff]
          vfmsub213ss xmm2, xmm1, dword ptr [rdx - 516]

// CHECK: vfmsub231pd zmm17, zmm2, zmm14
// CHECK:  encoding: [0x62,0xc2,0xed,0x48,0xba,0xce]
          vfmsub231pd zmm17, zmm2, zmm14

// CHECK: vfmsub231pd zmm17 {k2}, zmm2, zmm14
// CHECK:  encoding: [0x62,0xc2,0xed,0x4a,0xba,0xce]
          vfmsub231pd zmm17 {k2}, zmm2, zmm14

// CHECK: vfmsub231pd zmm17 {k2} {z}, zmm2, zmm14
// CHECK:  encoding: [0x62,0xc2,0xed,0xca,0xba,0xce]
          vfmsub231pd zmm17 {k2} {z}, zmm2, zmm14

// CHECK: vfmsub231pd zmm17, zmm2, zmm14, {rn-sae}
// CHECK:  encoding: [0x62,0xc2,0xed,0x18,0xba,0xce]
          vfmsub231pd zmm17, zmm2, zmm14, {rn-sae}

// CHECK: vfmsub231pd zmm17, zmm2, zmm14, {ru-sae}
// CHECK:  encoding: [0x62,0xc2,0xed,0x58,0xba,0xce]
          vfmsub231pd zmm17, zmm2, zmm14, {ru-sae}

// CHECK: vfmsub231pd zmm17, zmm2, zmm14, {rd-sae}
// CHECK:  encoding: [0x62,0xc2,0xed,0x38,0xba,0xce]
          vfmsub231pd zmm17, zmm2, zmm14, {rd-sae}

// CHECK: vfmsub231pd zmm17, zmm2, zmm14, {rz-sae}
// CHECK:  encoding: [0x62,0xc2,0xed,0x78,0xba,0xce]
          vfmsub231pd zmm17, zmm2, zmm14, {rz-sae}

// CHECK: vfmsub231pd zmm17, zmm2, zmmword ptr [rcx]
// CHECK:  encoding: [0x62,0xe2,0xed,0x48,0xba,0x09]
          vfmsub231pd zmm17, zmm2, zmmword ptr [rcx]

// CHECK: vfmsub231pd zmm17, zmm2, zmmword ptr [rax + 8*r14 + 4660]
// CHECK:  encoding: [0x62,0xa2,0xed,0x48,0xba,0x8c,0xf0,0x34,0x12,0x00,0x00]
          vfmsub231pd zmm17, zmm2, zmmword ptr [rax + 8*r14 + 4660]

// CHECK: vfmsub231pd zmm17, zmm2, qword ptr [rcx]{1to8}
// CHECK:  encoding: [0x62,0xe2,0xed,0x58,0xba,0x09]
          vfmsub231pd zmm17, zmm2, qword ptr [rcx]{1to8}

// CHECK: vfmsub231pd zmm17, zmm2, zmmword ptr [rdx + 8128]
// CHECK:  encoding: [0x62,0xe2,0xed,0x48,0xba,0x4a,0x7f]
          vfmsub231pd zmm17, zmm2, zmmword ptr [rdx + 8128]

// CHECK: vfmsub231pd zmm17, zmm2, zmmword ptr [rdx + 8192]
// CHECK:  encoding: [0x62,0xe2,0xed,0x48,0xba,0x8a,0x00,0x20,0x00,0x00]
          vfmsub231pd zmm17, zmm2, zmmword ptr [rdx + 8192]

// CHECK: vfmsub231pd zmm17, zmm2, zmmword ptr [rdx - 8192]
// CHECK:  encoding: [0x62,0xe2,0xed,0x48,0xba,0x4a,0x80]
          vfmsub231pd zmm17, zmm2, zmmword ptr [rdx - 8192]

// CHECK: vfmsub231pd zmm17, zmm2, zmmword ptr [rdx - 8256]
// CHECK:  encoding: [0x62,0xe2,0xed,0x48,0xba,0x8a,0xc0,0xdf,0xff,0xff]
          vfmsub231pd zmm17, zmm2, zmmword ptr [rdx - 8256]

// CHECK: vfmsub231pd zmm17, zmm2, qword ptr [rdx + 1016]{1to8}
// CHECK:  encoding: [0x62,0xe2,0xed,0x58,0xba,0x4a,0x7f]
          vfmsub231pd zmm17, zmm2, qword ptr [rdx + 1016]{1to8}

// CHECK: vfmsub231pd zmm17, zmm2, qword ptr [rdx + 1024]{1to8}
// CHECK:  encoding: [0x62,0xe2,0xed,0x58,0xba,0x8a,0x00,0x04,0x00,0x00]
          vfmsub231pd zmm17, zmm2, qword ptr [rdx + 1024]{1to8}

// CHECK: vfmsub231pd zmm17, zmm2, qword ptr [rdx - 1024]{1to8}
// CHECK:  encoding: [0x62,0xe2,0xed,0x58,0xba,0x4a,0x80]
          vfmsub231pd zmm17, zmm2, qword ptr [rdx - 1024]{1to8}

// CHECK: vfmsub231pd zmm17, zmm2, qword ptr [rdx - 1032]{1to8}
// CHECK:  encoding: [0x62,0xe2,0xed,0x58,0xba,0x8a,0xf8,0xfb,0xff,0xff]
          vfmsub231pd zmm17, zmm2, qword ptr [rdx - 1032]{1to8}

// CHECK: vfmsub231ps zmm5, zmm4, zmm20
// CHECK:  encoding: [0x62,0xb2,0x5d,0x48,0xba,0xec]
          vfmsub231ps zmm5, zmm4, zmm20

// CHECK: vfmsub231ps zmm5 {k1}, zmm4, zmm20
// CHECK:  encoding: [0x62,0xb2,0x5d,0x49,0xba,0xec]
          vfmsub231ps zmm5 {k1}, zmm4, zmm20

// CHECK: vfmsub231ps zmm5 {k1} {z}, zmm4, zmm20
// CHECK:  encoding: [0x62,0xb2,0x5d,0xc9,0xba,0xec]
          vfmsub231ps zmm5 {k1} {z}, zmm4, zmm20

// CHECK: vfmsub231ps zmm5, zmm4, zmm20, {rn-sae}
// CHECK:  encoding: [0x62,0xb2,0x5d,0x18,0xba,0xec]
          vfmsub231ps zmm5, zmm4, zmm20, {rn-sae}

// CHECK: vfmsub231ps zmm5, zmm4, zmm20, {ru-sae}
// CHECK:  encoding: [0x62,0xb2,0x5d,0x58,0xba,0xec]
          vfmsub231ps zmm5, zmm4, zmm20, {ru-sae}

// CHECK: vfmsub231ps zmm5, zmm4, zmm20, {rd-sae}
// CHECK:  encoding: [0x62,0xb2,0x5d,0x38,0xba,0xec]
          vfmsub231ps zmm5, zmm4, zmm20, {rd-sae}

// CHECK: vfmsub231ps zmm5, zmm4, zmm20, {rz-sae}
// CHECK:  encoding: [0x62,0xb2,0x5d,0x78,0xba,0xec]
          vfmsub231ps zmm5, zmm4, zmm20, {rz-sae}

// CHECK: vfmsub231ps zmm5, zmm4, zmmword ptr [rcx]
// CHECK:  encoding: [0x62,0xf2,0x5d,0x48,0xba,0x29]
          vfmsub231ps zmm5, zmm4, zmmword ptr [rcx]

// CHECK: vfmsub231ps zmm5, zmm4, zmmword ptr [rax + 8*r14 + 4660]
// CHECK:  encoding: [0x62,0xb2,0x5d,0x48,0xba,0xac,0xf0,0x34,0x12,0x00,0x00]
          vfmsub231ps zmm5, zmm4, zmmword ptr [rax + 8*r14 + 4660]

// CHECK: vfmsub231ps zmm5, zmm4, dword ptr [rcx]{1to16}
// CHECK:  encoding: [0x62,0xf2,0x5d,0x58,0xba,0x29]
          vfmsub231ps zmm5, zmm4, dword ptr [rcx]{1to16}

// CHECK: vfmsub231ps zmm5, zmm4, zmmword ptr [rdx + 8128]
// CHECK:  encoding: [0x62,0xf2,0x5d,0x48,0xba,0x6a,0x7f]
          vfmsub231ps zmm5, zmm4, zmmword ptr [rdx + 8128]

// CHECK: vfmsub231ps zmm5, zmm4, zmmword ptr [rdx + 8192]
// CHECK:  encoding: [0x62,0xf2,0x5d,0x48,0xba,0xaa,0x00,0x20,0x00,0x00]
          vfmsub231ps zmm5, zmm4, zmmword ptr [rdx + 8192]

// CHECK: vfmsub231ps zmm5, zmm4, zmmword ptr [rdx - 8192]
// CHECK:  encoding: [0x62,0xf2,0x5d,0x48,0xba,0x6a,0x80]
          vfmsub231ps zmm5, zmm4, zmmword ptr [rdx - 8192]

// CHECK: vfmsub231ps zmm5, zmm4, zmmword ptr [rdx - 8256]
// CHECK:  encoding: [0x62,0xf2,0x5d,0x48,0xba,0xaa,0xc0,0xdf,0xff,0xff]
          vfmsub231ps zmm5, zmm4, zmmword ptr [rdx - 8256]

// CHECK: vfmsub231ps zmm5, zmm4, dword ptr [rdx + 508]{1to16}
// CHECK:  encoding: [0x62,0xf2,0x5d,0x58,0xba,0x6a,0x7f]
          vfmsub231ps zmm5, zmm4, dword ptr [rdx + 508]{1to16}

// CHECK: vfmsub231ps zmm5, zmm4, dword ptr [rdx + 512]{1to16}
// CHECK:  encoding: [0x62,0xf2,0x5d,0x58,0xba,0xaa,0x00,0x02,0x00,0x00]
          vfmsub231ps zmm5, zmm4, dword ptr [rdx + 512]{1to16}

// CHECK: vfmsub231ps zmm5, zmm4, dword ptr [rdx - 512]{1to16}
// CHECK:  encoding: [0x62,0xf2,0x5d,0x58,0xba,0x6a,0x80]
          vfmsub231ps zmm5, zmm4, dword ptr [rdx - 512]{1to16}

// CHECK: vfmsub231ps zmm5, zmm4, dword ptr [rdx - 516]{1to16}
// CHECK:  encoding: [0x62,0xf2,0x5d,0x58,0xba,0xaa,0xfc,0xfd,0xff,0xff]
          vfmsub231ps zmm5, zmm4, dword ptr [rdx - 516]{1to16}

// CHECK: vfmsub231sd xmm7, xmm2, xmm6
// CHECK:  encoding: [0xc4,0xe2,0xe9,0xbb,0xfe]
          vfmsub231sd xmm7, xmm2, xmm6

// CHECK: vfmsub231sd xmm7 {k4}, xmm2, xmm6
// CHECK:  encoding: [0x62,0xf2,0xed,0x0c,0xbb,0xfe]
          vfmsub231sd xmm7 {k4}, xmm2, xmm6

// CHECK: vfmsub231sd xmm7 {k4} {z}, xmm2, xmm6
// CHECK:  encoding: [0x62,0xf2,0xed,0x8c,0xbb,0xfe]
          vfmsub231sd xmm7 {k4} {z}, xmm2, xmm6

// CHECK: vfmsub231sd xmm7, xmm2, xmm6, {rn-sae}
// CHECK:  encoding: [0x62,0xf2,0xed,0x18,0xbb,0xfe]
          vfmsub231sd xmm7, xmm2, xmm6, {rn-sae}

// CHECK: vfmsub231sd xmm7, xmm2, xmm6, {ru-sae}
// CHECK:  encoding: [0x62,0xf2,0xed,0x58,0xbb,0xfe]
          vfmsub231sd xmm7, xmm2, xmm6, {ru-sae}

// CHECK: vfmsub231sd xmm7, xmm2, xmm6, {rd-sae}
// CHECK:  encoding: [0x62,0xf2,0xed,0x38,0xbb,0xfe]
          vfmsub231sd xmm7, xmm2, xmm6, {rd-sae}

// CHECK: vfmsub231sd xmm7, xmm2, xmm6, {rz-sae}
// CHECK:  encoding: [0x62,0xf2,0xed,0x78,0xbb,0xfe]
          vfmsub231sd xmm7, xmm2, xmm6, {rz-sae}

// CHECK: vfmsub231sd xmm7, xmm2, qword ptr [rcx]
// CHECK:  encoding: [0xc4,0xe2,0xe9,0xbb,0x39]
          vfmsub231sd xmm7, xmm2, qword ptr [rcx]

// CHECK: vfmsub231sd xmm7, xmm2, qword ptr [rax + 8*r14 + 4660]
// CHECK:  encoding: [0xc4,0xa2,0xe9,0xbb,0xbc,0xf0,0x34,0x12,0x00,0x00]
          vfmsub231sd xmm7, xmm2, qword ptr [rax + 8*r14 + 4660]

// CHECK: vfmsub231sd xmm7, xmm2, qword ptr [rdx + 1016]
// CHECK:  encoding: [0xc4,0xe2,0xe9,0xbb,0xba,0xf8,0x03,0x00,0x00]
          vfmsub231sd xmm7, xmm2, qword ptr [rdx + 1016]

// CHECK: vfmsub231sd xmm7, xmm2, qword ptr [rdx + 1024]
// CHECK:  encoding: [0xc4,0xe2,0xe9,0xbb,0xba,0x00,0x04,0x00,0x00]
          vfmsub231sd xmm7, xmm2, qword ptr [rdx + 1024]

// CHECK: vfmsub231sd xmm7, xmm2, qword ptr [rdx - 1024]
// CHECK:  encoding: [0xc4,0xe2,0xe9,0xbb,0xba,0x00,0xfc,0xff,0xff]
          vfmsub231sd xmm7, xmm2, qword ptr [rdx - 1024]

// CHECK: vfmsub231sd xmm7, xmm2, qword ptr [rdx - 1032]
// CHECK:  encoding: [0xc4,0xe2,0xe9,0xbb,0xba,0xf8,0xfb,0xff,0xff]
          vfmsub231sd xmm7, xmm2, qword ptr [rdx - 1032]

// CHECK: vfmsub231ss xmm18, xmm18, xmm18
// CHECK:  encoding: [0x62,0xa2,0x6d,0x00,0xbb,0xd2]
          vfmsub231ss xmm18, xmm18, xmm18

// CHECK: vfmsub231ss xmm18 {k7}, xmm18, xmm18
// CHECK:  encoding: [0x62,0xa2,0x6d,0x07,0xbb,0xd2]
          vfmsub231ss xmm18 {k7}, xmm18, xmm18

// CHECK: vfmsub231ss xmm18 {k7} {z}, xmm18, xmm18
// CHECK:  encoding: [0x62,0xa2,0x6d,0x87,0xbb,0xd2]
          vfmsub231ss xmm18 {k7} {z}, xmm18, xmm18

// CHECK: vfmsub231ss xmm18, xmm18, xmm18, {rn-sae}
// CHECK:  encoding: [0x62,0xa2,0x6d,0x10,0xbb,0xd2]
          vfmsub231ss xmm18, xmm18, xmm18, {rn-sae}

// CHECK: vfmsub231ss xmm18, xmm18, xmm18, {ru-sae}
// CHECK:  encoding: [0x62,0xa2,0x6d,0x50,0xbb,0xd2]
          vfmsub231ss xmm18, xmm18, xmm18, {ru-sae}

// CHECK: vfmsub231ss xmm18, xmm18, xmm18, {rd-sae}
// CHECK:  encoding: [0x62,0xa2,0x6d,0x30,0xbb,0xd2]
          vfmsub231ss xmm18, xmm18, xmm18, {rd-sae}

// CHECK: vfmsub231ss xmm18, xmm18, xmm18, {rz-sae}
// CHECK:  encoding: [0x62,0xa2,0x6d,0x70,0xbb,0xd2]
          vfmsub231ss xmm18, xmm18, xmm18, {rz-sae}

// CHECK: vfmsub231ss xmm18, xmm18, dword ptr [rcx]
// CHECK:  encoding: [0x62,0xe2,0x6d,0x00,0xbb,0x11]
          vfmsub231ss xmm18, xmm18, dword ptr [rcx]

// CHECK: vfmsub231ss xmm18, xmm18, dword ptr [rax + 8*r14 + 4660]
// CHECK:  encoding: [0x62,0xa2,0x6d,0x00,0xbb,0x94,0xf0,0x34,0x12,0x00,0x00]
          vfmsub231ss xmm18, xmm18, dword ptr [rax + 8*r14 + 4660]

// CHECK: vfmsub231ss xmm18, xmm18, dword ptr [rdx + 508]
// CHECK:  encoding: [0x62,0xe2,0x6d,0x00,0xbb,0x52,0x7f]
          vfmsub231ss xmm18, xmm18, dword ptr [rdx + 508]

// CHECK: vfmsub231ss xmm18, xmm18, dword ptr [rdx + 512]
// CHECK:  encoding: [0x62,0xe2,0x6d,0x00,0xbb,0x92,0x00,0x02,0x00,0x00]
          vfmsub231ss xmm18, xmm18, dword ptr [rdx + 512]

// CHECK: vfmsub231ss xmm18, xmm18, dword ptr [rdx - 512]
// CHECK:  encoding: [0x62,0xe2,0x6d,0x00,0xbb,0x52,0x80]
          vfmsub231ss xmm18, xmm18, dword ptr [rdx - 512]

// CHECK: vfmsub231ss xmm18, xmm18, dword ptr [rdx - 516]
// CHECK:  encoding: [0x62,0xe2,0x6d,0x00,0xbb,0x92,0xfc,0xfd,0xff,0xff]
          vfmsub231ss xmm18, xmm18, dword ptr [rdx - 516]

// CHECK: vfmsubadd132pd zmm21, zmm4, zmm7
// CHECK:  encoding: [0x62,0xe2,0xdd,0x48,0x97,0xef]
          vfmsubadd132pd zmm21, zmm4, zmm7

// CHECK: vfmsubadd132pd zmm21 {k5}, zmm4, zmm7
// CHECK:  encoding: [0x62,0xe2,0xdd,0x4d,0x97,0xef]
          vfmsubadd132pd zmm21 {k5}, zmm4, zmm7

// CHECK: vfmsubadd132pd zmm21 {k5} {z}, zmm4, zmm7
// CHECK:  encoding: [0x62,0xe2,0xdd,0xcd,0x97,0xef]
          vfmsubadd132pd zmm21 {k5} {z}, zmm4, zmm7

// CHECK: vfmsubadd132pd zmm21, zmm4, zmm7, {rn-sae}
// CHECK:  encoding: [0x62,0xe2,0xdd,0x18,0x97,0xef]
          vfmsubadd132pd zmm21, zmm4, zmm7, {rn-sae}

// CHECK: vfmsubadd132pd zmm21, zmm4, zmm7, {ru-sae}
// CHECK:  encoding: [0x62,0xe2,0xdd,0x58,0x97,0xef]
          vfmsubadd132pd zmm21, zmm4, zmm7, {ru-sae}

// CHECK: vfmsubadd132pd zmm21, zmm4, zmm7, {rd-sae}
// CHECK:  encoding: [0x62,0xe2,0xdd,0x38,0x97,0xef]
          vfmsubadd132pd zmm21, zmm4, zmm7, {rd-sae}

// CHECK: vfmsubadd132pd zmm21, zmm4, zmm7, {rz-sae}
// CHECK:  encoding: [0x62,0xe2,0xdd,0x78,0x97,0xef]
          vfmsubadd132pd zmm21, zmm4, zmm7, {rz-sae}

// CHECK: vfmsubadd132pd zmm21, zmm4, zmmword ptr [rcx]
// CHECK:  encoding: [0x62,0xe2,0xdd,0x48,0x97,0x29]
          vfmsubadd132pd zmm21, zmm4, zmmword ptr [rcx]

// CHECK: vfmsubadd132pd zmm21, zmm4, zmmword ptr [rax + 8*r14 + 4660]
// CHECK:  encoding: [0x62,0xa2,0xdd,0x48,0x97,0xac,0xf0,0x34,0x12,0x00,0x00]
          vfmsubadd132pd zmm21, zmm4, zmmword ptr [rax + 8*r14 + 4660]

// CHECK: vfmsubadd132pd zmm21, zmm4, qword ptr [rcx]{1to8}
// CHECK:  encoding: [0x62,0xe2,0xdd,0x58,0x97,0x29]
          vfmsubadd132pd zmm21, zmm4, qword ptr [rcx]{1to8}

// CHECK: vfmsubadd132pd zmm21, zmm4, zmmword ptr [rdx + 8128]
// CHECK:  encoding: [0x62,0xe2,0xdd,0x48,0x97,0x6a,0x7f]
          vfmsubadd132pd zmm21, zmm4, zmmword ptr [rdx + 8128]

// CHECK: vfmsubadd132pd zmm21, zmm4, zmmword ptr [rdx + 8192]
// CHECK:  encoding: [0x62,0xe2,0xdd,0x48,0x97,0xaa,0x00,0x20,0x00,0x00]
          vfmsubadd132pd zmm21, zmm4, zmmword ptr [rdx + 8192]

// CHECK: vfmsubadd132pd zmm21, zmm4, zmmword ptr [rdx - 8192]
// CHECK:  encoding: [0x62,0xe2,0xdd,0x48,0x97,0x6a,0x80]
          vfmsubadd132pd zmm21, zmm4, zmmword ptr [rdx - 8192]

// CHECK: vfmsubadd132pd zmm21, zmm4, zmmword ptr [rdx - 8256]
// CHECK:  encoding: [0x62,0xe2,0xdd,0x48,0x97,0xaa,0xc0,0xdf,0xff,0xff]
          vfmsubadd132pd zmm21, zmm4, zmmword ptr [rdx - 8256]

// CHECK: vfmsubadd132pd zmm21, zmm4, qword ptr [rdx + 1016]{1to8}
// CHECK:  encoding: [0x62,0xe2,0xdd,0x58,0x97,0x6a,0x7f]
          vfmsubadd132pd zmm21, zmm4, qword ptr [rdx + 1016]{1to8}

// CHECK: vfmsubadd132pd zmm21, zmm4, qword ptr [rdx + 1024]{1to8}
// CHECK:  encoding: [0x62,0xe2,0xdd,0x58,0x97,0xaa,0x00,0x04,0x00,0x00]
          vfmsubadd132pd zmm21, zmm4, qword ptr [rdx + 1024]{1to8}

// CHECK: vfmsubadd132pd zmm21, zmm4, qword ptr [rdx - 1024]{1to8}
// CHECK:  encoding: [0x62,0xe2,0xdd,0x58,0x97,0x6a,0x80]
          vfmsubadd132pd zmm21, zmm4, qword ptr [rdx - 1024]{1to8}

// CHECK: vfmsubadd132pd zmm21, zmm4, qword ptr [rdx - 1032]{1to8}
// CHECK:  encoding: [0x62,0xe2,0xdd,0x58,0x97,0xaa,0xf8,0xfb,0xff,0xff]
          vfmsubadd132pd zmm21, zmm4, qword ptr [rdx - 1032]{1to8}

// CHECK: vfmsubadd132ps zmm6, zmm24, zmm16
// CHECK:  encoding: [0x62,0xb2,0x3d,0x40,0x97,0xf0]
          vfmsubadd132ps zmm6, zmm24, zmm16

// CHECK: vfmsubadd132ps zmm6 {k7}, zmm24, zmm16
// CHECK:  encoding: [0x62,0xb2,0x3d,0x47,0x97,0xf0]
          vfmsubadd132ps zmm6 {k7}, zmm24, zmm16

// CHECK: vfmsubadd132ps zmm6 {k7} {z}, zmm24, zmm16
// CHECK:  encoding: [0x62,0xb2,0x3d,0xc7,0x97,0xf0]
          vfmsubadd132ps zmm6 {k7} {z}, zmm24, zmm16

// CHECK: vfmsubadd132ps zmm6, zmm24, zmm16, {rn-sae}
// CHECK:  encoding: [0x62,0xb2,0x3d,0x10,0x97,0xf0]
          vfmsubadd132ps zmm6, zmm24, zmm16, {rn-sae}

// CHECK: vfmsubadd132ps zmm6, zmm24, zmm16, {ru-sae}
// CHECK:  encoding: [0x62,0xb2,0x3d,0x50,0x97,0xf0]
          vfmsubadd132ps zmm6, zmm24, zmm16, {ru-sae}

// CHECK: vfmsubadd132ps zmm6, zmm24, zmm16, {rd-sae}
// CHECK:  encoding: [0x62,0xb2,0x3d,0x30,0x97,0xf0]
          vfmsubadd132ps zmm6, zmm24, zmm16, {rd-sae}

// CHECK: vfmsubadd132ps zmm6, zmm24, zmm16, {rz-sae}
// CHECK:  encoding: [0x62,0xb2,0x3d,0x70,0x97,0xf0]
          vfmsubadd132ps zmm6, zmm24, zmm16, {rz-sae}

// CHECK: vfmsubadd132ps zmm6, zmm24, zmmword ptr [rcx]
// CHECK:  encoding: [0x62,0xf2,0x3d,0x40,0x97,0x31]
          vfmsubadd132ps zmm6, zmm24, zmmword ptr [rcx]

// CHECK: vfmsubadd132ps zmm6, zmm24, zmmword ptr [rax + 8*r14 + 4660]
// CHECK:  encoding: [0x62,0xb2,0x3d,0x40,0x97,0xb4,0xf0,0x34,0x12,0x00,0x00]
          vfmsubadd132ps zmm6, zmm24, zmmword ptr [rax + 8*r14 + 4660]

// CHECK: vfmsubadd132ps zmm6, zmm24, dword ptr [rcx]{1to16}
// CHECK:  encoding: [0x62,0xf2,0x3d,0x50,0x97,0x31]
          vfmsubadd132ps zmm6, zmm24, dword ptr [rcx]{1to16}

// CHECK: vfmsubadd132ps zmm6, zmm24, zmmword ptr [rdx + 8128]
// CHECK:  encoding: [0x62,0xf2,0x3d,0x40,0x97,0x72,0x7f]
          vfmsubadd132ps zmm6, zmm24, zmmword ptr [rdx + 8128]

// CHECK: vfmsubadd132ps zmm6, zmm24, zmmword ptr [rdx + 8192]
// CHECK:  encoding: [0x62,0xf2,0x3d,0x40,0x97,0xb2,0x00,0x20,0x00,0x00]
          vfmsubadd132ps zmm6, zmm24, zmmword ptr [rdx + 8192]

// CHECK: vfmsubadd132ps zmm6, zmm24, zmmword ptr [rdx - 8192]
// CHECK:  encoding: [0x62,0xf2,0x3d,0x40,0x97,0x72,0x80]
          vfmsubadd132ps zmm6, zmm24, zmmword ptr [rdx - 8192]

// CHECK: vfmsubadd132ps zmm6, zmm24, zmmword ptr [rdx - 8256]
// CHECK:  encoding: [0x62,0xf2,0x3d,0x40,0x97,0xb2,0xc0,0xdf,0xff,0xff]
          vfmsubadd132ps zmm6, zmm24, zmmword ptr [rdx - 8256]

// CHECK: vfmsubadd132ps zmm6, zmm24, dword ptr [rdx + 508]{1to16}
// CHECK:  encoding: [0x62,0xf2,0x3d,0x50,0x97,0x72,0x7f]
          vfmsubadd132ps zmm6, zmm24, dword ptr [rdx + 508]{1to16}

// CHECK: vfmsubadd132ps zmm6, zmm24, dword ptr [rdx + 512]{1to16}
// CHECK:  encoding: [0x62,0xf2,0x3d,0x50,0x97,0xb2,0x00,0x02,0x00,0x00]
          vfmsubadd132ps zmm6, zmm24, dword ptr [rdx + 512]{1to16}

// CHECK: vfmsubadd132ps zmm6, zmm24, dword ptr [rdx - 512]{1to16}
// CHECK:  encoding: [0x62,0xf2,0x3d,0x50,0x97,0x72,0x80]
          vfmsubadd132ps zmm6, zmm24, dword ptr [rdx - 512]{1to16}

// CHECK: vfmsubadd132ps zmm6, zmm24, dword ptr [rdx - 516]{1to16}
// CHECK:  encoding: [0x62,0xf2,0x3d,0x50,0x97,0xb2,0xfc,0xfd,0xff,0xff]
          vfmsubadd132ps zmm6, zmm24, dword ptr [rdx - 516]{1to16}

// CHECK: vfmsubadd213pd zmm11, zmm22, zmm11
// CHECK:  encoding: [0x62,0x52,0xcd,0x40,0xa7,0xdb]
          vfmsubadd213pd zmm11, zmm22, zmm11

// CHECK: vfmsubadd213pd zmm11 {k4}, zmm22, zmm11
// CHECK:  encoding: [0x62,0x52,0xcd,0x44,0xa7,0xdb]
          vfmsubadd213pd zmm11 {k4}, zmm22, zmm11

// CHECK: vfmsubadd213pd zmm11 {k4} {z}, zmm22, zmm11
// CHECK:  encoding: [0x62,0x52,0xcd,0xc4,0xa7,0xdb]
          vfmsubadd213pd zmm11 {k4} {z}, zmm22, zmm11

// CHECK: vfmsubadd213pd zmm11, zmm22, zmm11, {rn-sae}
// CHECK:  encoding: [0x62,0x52,0xcd,0x10,0xa7,0xdb]
          vfmsubadd213pd zmm11, zmm22, zmm11, {rn-sae}

// CHECK: vfmsubadd213pd zmm11, zmm22, zmm11, {ru-sae}
// CHECK:  encoding: [0x62,0x52,0xcd,0x50,0xa7,0xdb]
          vfmsubadd213pd zmm11, zmm22, zmm11, {ru-sae}

// CHECK: vfmsubadd213pd zmm11, zmm22, zmm11, {rd-sae}
// CHECK:  encoding: [0x62,0x52,0xcd,0x30,0xa7,0xdb]
          vfmsubadd213pd zmm11, zmm22, zmm11, {rd-sae}

// CHECK: vfmsubadd213pd zmm11, zmm22, zmm11, {rz-sae}
// CHECK:  encoding: [0x62,0x52,0xcd,0x70,0xa7,0xdb]
          vfmsubadd213pd zmm11, zmm22, zmm11, {rz-sae}

// CHECK: vfmsubadd213pd zmm11, zmm22, zmmword ptr [rcx]
// CHECK:  encoding: [0x62,0x72,0xcd,0x40,0xa7,0x19]
          vfmsubadd213pd zmm11, zmm22, zmmword ptr [rcx]

// CHECK: vfmsubadd213pd zmm11, zmm22, zmmword ptr [rax + 8*r14 + 4660]
// CHECK:  encoding: [0x62,0x32,0xcd,0x40,0xa7,0x9c,0xf0,0x34,0x12,0x00,0x00]
          vfmsubadd213pd zmm11, zmm22, zmmword ptr [rax + 8*r14 + 4660]

// CHECK: vfmsubadd213pd zmm11, zmm22, qword ptr [rcx]{1to8}
// CHECK:  encoding: [0x62,0x72,0xcd,0x50,0xa7,0x19]
          vfmsubadd213pd zmm11, zmm22, qword ptr [rcx]{1to8}

// CHECK: vfmsubadd213pd zmm11, zmm22, zmmword ptr [rdx + 8128]
// CHECK:  encoding: [0x62,0x72,0xcd,0x40,0xa7,0x5a,0x7f]
          vfmsubadd213pd zmm11, zmm22, zmmword ptr [rdx + 8128]

// CHECK: vfmsubadd213pd zmm11, zmm22, zmmword ptr [rdx + 8192]
// CHECK:  encoding: [0x62,0x72,0xcd,0x40,0xa7,0x9a,0x00,0x20,0x00,0x00]
          vfmsubadd213pd zmm11, zmm22, zmmword ptr [rdx + 8192]

// CHECK: vfmsubadd213pd zmm11, zmm22, zmmword ptr [rdx - 8192]
// CHECK:  encoding: [0x62,0x72,0xcd,0x40,0xa7,0x5a,0x80]
          vfmsubadd213pd zmm11, zmm22, zmmword ptr [rdx - 8192]

// CHECK: vfmsubadd213pd zmm11, zmm22, zmmword ptr [rdx - 8256]
// CHECK:  encoding: [0x62,0x72,0xcd,0x40,0xa7,0x9a,0xc0,0xdf,0xff,0xff]
          vfmsubadd213pd zmm11, zmm22, zmmword ptr [rdx - 8256]

// CHECK: vfmsubadd213pd zmm11, zmm22, qword ptr [rdx + 1016]{1to8}
// CHECK:  encoding: [0x62,0x72,0xcd,0x50,0xa7,0x5a,0x7f]
          vfmsubadd213pd zmm11, zmm22, qword ptr [rdx + 1016]{1to8}

// CHECK: vfmsubadd213pd zmm11, zmm22, qword ptr [rdx + 1024]{1to8}
// CHECK:  encoding: [0x62,0x72,0xcd,0x50,0xa7,0x9a,0x00,0x04,0x00,0x00]
          vfmsubadd213pd zmm11, zmm22, qword ptr [rdx + 