# Notes for updating `external/libffi` from source

Note: AOSP has (or had) a platform/external/libffi used by Dalvik/MIPS.
To avoid confusion, we call our version of the library libffi-cheets.

## Files added for use in cheets:

- `./Android.mk`
- `./MODULE_LICENSE_BSD_LIKE`
- `./NOTICE (copy of ./LICENSE)`
- `./README.cheets.md`
- `./linux-arm/ffi.h`
- `./linux-arm/fficonfig.h`
- `./linux-arm/ffitarget.h`
- `./linux-x86/ffi.h`
- `./linux-x86/fficonfig.h`
- `./linux-x86/ffitarget.h`

The `ffi.h`, `fficonfig.h`, and `ffitarget.h` files allow us to easily configure
each build target.

Note that Android.mk embeds the version of Wayland being built (ends up in src/wayland-version.h)

## Files generated by the build process

These files are generated by the Android.mk makefile into the source directory,
and should not be checked in.

### From `include/ffi.h.in`

- `include/ffi.h`