# Copyright (C) 2007 The Android Open Source Project
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

# If you don't need to do a full clean build but would like to touch
# a file or delete some intermediate files, add a clean step to the end
# of the list.  These steps will only be run once, if they haven't been
# run before.
#
# E.g.:
#     $(call add-clean-step, touch -c external/sqlite/sqlite3.h)
#     $(call add-clean-step, rm -rf $(PRODUCT_OUT)/obj/STATIC_LIBRARIES/libz_intermediates)
#
# Always use "touch -c" and "rm -f" or "rm -rf" to gracefully deal with
# files that are missing or have been moved.
#
# Use $(PRODUCT_OUT) to get to the "out/target/product/blah/" directory.
# Use $(OUT_DIR) to refer to the "out" directory.
#
# If you need to re-do something that's already mentioned, just copy
# the command and add it to the bottom of the list.  E.g., if a change
# that you made last week required touching a file and a change you
# made today requires touching the same file, just copy the old
# touch step and add it to the end of the list.
#
# ************************************************
# NEWER CLEAN STEPS MUST BE AT THE END OF THE LIST
# ************************************************

# Note: this is not really required, but remember only the added lines
# will be executed (see $OUT/clean_steps.mk value for the current line)

$(call add-clean-step, rm -f $(PRODUCT_OUT)/utilities/busybox)
$(call add-clean-step, rm -f $(PRODUCT_OUT)/symbols/system/xbin/busybox)

$(call add-clean-step, rm -rf $(PRODUCT_OUT)/obj/EXECUTABLES/busybox_intermediates)
$(call add-clean-step, rm -rf $(PRODUCT_OUT)/obj/STATIC_LIBRARIES/libbusybox_intermediates)
$(call add-clean-step, rm -rf $(PRODUCT_OUT)/obj/UTILITY_EXECUTABLES/static_busybox_intermediates)

$(call add-clean-step, rm -rf $(PRODUCT_OUT)/obj/busybox)

# remains from old build system */
$(call add-clean-step, rm -f external/busybox/include/bbconfigopts.h)
$(call add-clean-step, rm -f external/busybox/include/autoconf.h)
$(call add-clean-step, rm -f external/busybox/include/applet_tables.h)
$(call add-clean-step, rm -f external/busybox/include/applets.h)
$(call add-clean-step, rm -f external/busybox/.config)

# force prepare
$(call add-clean-step, touch external/busybox/busybox-minimal.config)
$(call add-clean-step, touch external/busybox/busybox-full.config)

# ************************************************
# NEWER CLEAN STEPS MUST BE AT THE END OF THE LIST
# ************************************************

