/*
 * Copyright (C) 2008 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.harmony.crypto.tests.javax.crypto.func;

import junit.framework.Test;
import junit.framework.TestSuite;

/**
 * This is autogenerated source file. Includes tests for package org.apache.harmony.crypto.tests.javax.crypto;
 */

public class AllTests {

    public static void main(String[] args) {
        junit.textui.TestRunner.run(AllTests.suite());
    }

    public static Test suite() {
        TestSuite suite = new TestSuite("All tests for package org.apache.harmony.crypto.tests.javax.crypto.func;");
        // $JUnit-BEGIN$

        suite.addTestSuite(CipherAesTest.class);
        suite.addTestSuite(CipherAesWrapTest.class);
        suite.addTestSuite(CipherDESedeTest.class);
        suite.addTestSuite(CipherDESedeWrapTest.class);
        suite.addTestSuite(CipherDesTest.class);
        suite.addTestSuite(CipherPBETest.class);
        suite.addTestSuite(CipherRSATest.class);
        suite.addTestSuite(KeyAgreementFunctionalTest.class);
        suite.addTestSuite(KeyGeneratorFunctionalTest.class);
        suite.addTestSuite(MacFunctionalTest.class);
        suite.addTestSuite(SecretKeyFactoryFunctionalTest.class);

        // $JUnit-END$
        return suite;
    }
}
