/* 
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 * 
 *     http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.harmony.security.tests.java.security;

import dalvik.annotation.TestTargetClass;
import dalvik.annotation.TestTargets;
import dalvik.annotation.TestLevel;
import dalvik.annotation.TestTargetNew;

import java.security.ProviderException;

@TestTargetClass(ProviderException.class)
public class ProviderException2Test extends junit.framework.TestCase {

    /**
     * @tests java.security.ProviderException#ProviderException()
     */
    @TestTargetNew(
        level = TestLevel.COMPLETE,
        notes = "",
        method = "ProviderException",
        args = {}
    )
    public void test_Constructor() {
        // Test for method java.security.ProviderException()
        ProviderException e = new ProviderException();
        assertEquals("Failed toString test for constructed instance",
                "java.security.ProviderException", e.toString());
    }

    /**
     * @tests java.security.ProviderException#ProviderException(java.lang.String)
     */
    @TestTargetNew(
        level = TestLevel.PARTIAL,
        notes = "Verification with null/empty parameter is absent",
        method = "ProviderException",
        args = {java.lang.String.class}
    )
    public void test_ConstructorLjava_lang_String() {
        // Test for method java.security.ProviderException(java.lang.String)
        ProviderException e = new ProviderException("test message");
        assertEquals("Failed toString test for constructed instance", 
                        "java.security.ProviderException: test message", e
                .toString());
    }
}